# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .health_evaluation_py3 import HealthEvaluation


class ApplicationTypeApplicationsHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for applications of a particular application
    type. The application type applications evaluation can be returned when
    cluster health evaluation returns unhealthy aggregated health state, either
    Error or Warning. It contains health evaluations for each unhealthy
    application of the included application type that impacted current
    aggregated health state.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_type_name: The application type name as defined in the
     application manifest.
    :type application_type_name: str
    :param max_percent_unhealthy_applications: Maximum allowed percentage of
     unhealthy applications for the application type, specified as an entry in
     ApplicationTypeHealthPolicyMap.
    :type max_percent_unhealthy_applications: int
    :param total_count: Total number of applications of the application type
     found in the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     ApplicationHealthEvaluation of this application type that impacted the
     aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'max_percent_unhealthy_applications': {'key': 'MaxPercentUnhealthyApplications', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, *, aggregated_health_state=None, description: str=None, application_type_name: str=None, max_percent_unhealthy_applications: int=None, total_count: int=None, unhealthy_evaluations=None, **kwargs) -> None:
        super(ApplicationTypeApplicationsHealthEvaluation, self).__init__(aggregated_health_state=aggregated_health_state, description=description, **kwargs)
        self.application_type_name = application_type_name
        self.max_percent_unhealthy_applications = max_percent_unhealthy_applications
        self.total_count = total_count
        self.unhealthy_evaluations = unhealthy_evaluations
        self.kind = 'ApplicationTypeApplications'
