# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationGatewayFirewallDisabledRuleGroup(Model):
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the rule group that will be
     disabled.
    :type rule_group_name: str
    :param rules: The list of rules that will be disabled. If null, all rules
     of the rule group will be disabled.
    :type rules: list[int]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[int]'},
    }

    def __init__(self, *, rule_group_name: str, rules=None, **kwargs) -> None:
        super(ApplicationGatewayFirewallDisabledRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules
