# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClusterDefinition(Model):
    """The cluster definition.

    :param blueprint: The link to the blueprint.
    :type blueprint: str
    :param kind: The type of cluster.
    :type kind: str
    :param component_version: The versions of different services in the
     cluster.
    :type component_version: dict[str, str]
    :param configurations: The cluster configurations.
    :type configurations: object
    """

    _attribute_map = {
        'blueprint': {'key': 'blueprint', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'component_version': {'key': 'componentVersion', 'type': '{str}'},
        'configurations': {'key': 'configurations', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ClusterDefinition, self).__init__(**kwargs)
        self.blueprint = kwargs.get('blueprint', None)
        self.kind = kwargs.get('kind', None)
        self.component_version = kwargs.get('component_version', None)
        self.configurations = kwargs.get('configurations', None)
