# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class USqlTableFragment(Model):
    """A Data Lake Analytics catalog U-SQL table fragment item.

    :param parent_id: the parent object Id of the table fragment. The parent
     could be a table or table partition.
    :type parent_id: str
    :param fragment_id: the version of the catalog item.
    :type fragment_id: str
    :param index_id: the ordinal of the index which contains the table
     fragment.
    :type index_id: int
    :param size: the data size of the table fragment in bytes.
    :type size: long
    :param row_count: the number of rows in the table fragment.
    :type row_count: long
    :param create_date: the creation time of the table fragment.
    :type create_date: datetime
    """

    _attribute_map = {
        'parent_id': {'key': 'parentId', 'type': 'str'},
        'fragment_id': {'key': 'fragmentId', 'type': 'str'},
        'index_id': {'key': 'indexId', 'type': 'int'},
        'size': {'key': 'size', 'type': 'long'},
        'row_count': {'key': 'rowCount', 'type': 'long'},
        'create_date': {'key': 'createDate', 'type': 'iso-8601'},
    }

    def __init__(self, *, parent_id: str=None, fragment_id: str=None, index_id: int=None, size: int=None, row_count: int=None, create_date=None, **kwargs) -> None:
        super(USqlTableFragment, self).__init__(**kwargs)
        self.parent_id = parent_id
        self.fragment_id = fragment_id
        self.index_id = index_id
        self.size = size
        self.row_count = row_count
        self.create_date = create_date
