# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class Budget(ProxyResource):
    """A budget resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param e_tag: eTag of the resource. To handle concurrent update scenarion,
     this field will be used to determine whether the user is updating the
     latest version or not.
    :type e_tag: str
    :param category: The category of the budget, whether the budget tracks
     cost or usage. Possible values include: 'Cost', 'Usage'
    :type category: str or ~azure.mgmt.consumption.models.CategoryType
    :param amount: The total amount of cost to track with the budget
    :type amount: decimal.Decimal
    :param time_grain: The time covered by a budget. Tracking of the amount
     will be reset based on the time grain. Possible values include: 'Monthly',
     'Quarterly', 'Annually'
    :type time_grain: str or ~azure.mgmt.consumption.models.TimeGrainType
    :param time_period: Has start and end date of the budget. The start date
     must be first of the month and should be less than the end date. Budget
     start date must be on or after June 1, 2017. Future start date should not
     be more than three months. Past start date should  be selected within the
     timegrain preiod. There are no restrictions on the end date.
    :type time_period: ~azure.mgmt.consumption.models.BudgetTimePeriod
    :param filters: May be used to filter budgets by resource group, resource,
     or meter.
    :type filters: ~azure.mgmt.consumption.models.Filters
    :ivar current_spend: The current amount of cost which is being tracked for
     a budget.
    :vartype current_spend: ~azure.mgmt.consumption.models.CurrentSpend
    :param notifications: Dictionary of notifications associated with the
     budget. Budget can have up to five notifications.
    :type notifications: dict[str,
     ~azure.mgmt.consumption.models.Notification]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category': {'required': True},
        'amount': {'required': True},
        'time_grain': {'required': True},
        'time_period': {'required': True},
        'current_spend': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'amount': {'key': 'properties.amount', 'type': 'decimal'},
        'time_grain': {'key': 'properties.timeGrain', 'type': 'str'},
        'time_period': {'key': 'properties.timePeriod', 'type': 'BudgetTimePeriod'},
        'filters': {'key': 'properties.filters', 'type': 'Filters'},
        'current_spend': {'key': 'properties.currentSpend', 'type': 'CurrentSpend'},
        'notifications': {'key': 'properties.notifications', 'type': '{Notification}'},
    }

    def __init__(self, category, amount, time_grain, time_period, e_tag=None, filters=None, notifications=None):
        super(Budget, self).__init__(e_tag=e_tag)
        self.category = category
        self.amount = amount
        self.time_grain = time_grain
        self.time_period = time_period
        self.filters = filters
        self.current_spend = None
        self.notifications = notifications
