# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LuisApp(Model):
    """Exported Model - An exported LUIS Application.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param name: The name of the application.
    :type name: str
    :param version_id: The version ID of the application that was exported.
    :type version_id: str
    :param desc: The description of the application.
    :type desc: str
    :param culture: The culture of the application. E.g.: en-us.
    :type culture: str
    :param intents: List of intents.
    :type intents:
     list[~azure.cognitiveservices.language.luis.authoring.models.HierarchicalModel]
    :param entities: List of entities.
    :type entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.HierarchicalModel]
    :param closed_lists: List of closed lists.
    :type closed_lists:
     list[~azure.cognitiveservices.language.luis.authoring.models.ClosedList]
    :param composites: List of composite entities.
    :type composites:
     list[~azure.cognitiveservices.language.luis.authoring.models.HierarchicalModel]
    :param pattern_any_entities: List of Pattern.Any entities.
    :type pattern_any_entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.PatternAny]
    :param regex_entities: List of regular expression entities.
    :type regex_entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.RegexEntity]
    :param prebuilt_entities: List of prebuilt entities.
    :type prebuilt_entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.PrebuiltEntity]
    :param regex_features: List of pattern features.
    :type regex_features:
     list[~azure.cognitiveservices.language.luis.authoring.models.JSONRegexFeature]
    :param model_features: List of model features.
    :type model_features:
     list[~azure.cognitiveservices.language.luis.authoring.models.JSONModelFeature]
    :param patterns: List of patterns.
    :type patterns:
     list[~azure.cognitiveservices.language.luis.authoring.models.PatternRule]
    :param utterances: List of sample utterances.
    :type utterances:
     list[~azure.cognitiveservices.language.luis.authoring.models.JSONUtterance]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'version_id': {'key': 'versionId', 'type': 'str'},
        'desc': {'key': 'desc', 'type': 'str'},
        'culture': {'key': 'culture', 'type': 'str'},
        'intents': {'key': 'intents', 'type': '[HierarchicalModel]'},
        'entities': {'key': 'entities', 'type': '[HierarchicalModel]'},
        'closed_lists': {'key': 'closedLists', 'type': '[ClosedList]'},
        'composites': {'key': 'composites', 'type': '[HierarchicalModel]'},
        'pattern_any_entities': {'key': 'patternAnyEntities', 'type': '[PatternAny]'},
        'regex_entities': {'key': 'regex_entities', 'type': '[RegexEntity]'},
        'prebuilt_entities': {'key': 'prebuiltEntities', 'type': '[PrebuiltEntity]'},
        'regex_features': {'key': 'regex_features', 'type': '[JSONRegexFeature]'},
        'model_features': {'key': 'model_features', 'type': '[JSONModelFeature]'},
        'patterns': {'key': 'patterns', 'type': '[PatternRule]'},
        'utterances': {'key': 'utterances', 'type': '[JSONUtterance]'},
    }

    def __init__(self, *, additional_properties=None, name: str=None, version_id: str=None, desc: str=None, culture: str=None, intents=None, entities=None, closed_lists=None, composites=None, pattern_any_entities=None, regex_entities=None, prebuilt_entities=None, regex_features=None, model_features=None, patterns=None, utterances=None, **kwargs) -> None:
        super(LuisApp, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.version_id = version_id
        self.desc = desc
        self.culture = culture
        self.intents = intents
        self.entities = entities
        self.closed_lists = closed_lists
        self.composites = composites
        self.pattern_any_entities = pattern_any_entities
        self.regex_entities = regex_entities
        self.prebuilt_entities = prebuilt_entities
        self.regex_features = regex_features
        self.model_features = model_features
        self.patterns = patterns
        self.utterances = utterances
