/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
 
package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;

public class FieldsOfPrimitiveboolean { 
  public int identifier;
  private boolean boolean0;
  private boolean boolean1;
  private boolean boolean2;
  private boolean boolean3;
  private boolean boolean4;
  private boolean boolean5;
  private boolean boolean6;
  private boolean boolean7;
  private static boolean boolean8;
  private transient boolean boolean9;
  private transient boolean boolean10;
  private transient boolean boolean11;
  private transient boolean boolean12;
  private transient boolean boolean13;
  private transient boolean boolean14;
  private final boolean boolean15 = false;
  private volatile boolean boolean16;
  private volatile boolean boolean17;
  private volatile boolean boolean18;
  private volatile boolean boolean19;
  private volatile boolean boolean20;
  private volatile boolean boolean21;
  private volatile boolean boolean22;
  private volatile boolean boolean23;
  private static transient boolean boolean24;
  private static final boolean boolean25 = false;
  private static volatile boolean boolean26;
  private transient final boolean boolean27 = false;
  private transient volatile boolean boolean28;
  private transient volatile boolean boolean29;
  private transient volatile boolean boolean30;
  private transient volatile boolean boolean31;
  private transient volatile boolean boolean32;
  private transient volatile boolean boolean33;
  private static transient final boolean boolean34 = false;
  private static transient volatile boolean boolean35;
  public boolean boolean36;
  public boolean boolean37;
  public boolean boolean38;
  public boolean boolean39;
  public boolean boolean40;
  public boolean boolean41;
  public boolean boolean42;
  public boolean boolean43;
  public static boolean boolean44;
  public transient boolean boolean45;
  public transient boolean boolean46;
  public transient boolean boolean47;
  public transient boolean boolean48;
  public transient boolean boolean49;
  public transient boolean boolean50;
  public final boolean boolean51 = false;
  public volatile boolean boolean52;
  public volatile boolean boolean53;
  public volatile boolean boolean54;
  public volatile boolean boolean55;
  public volatile boolean boolean56;
  public volatile boolean boolean57;
  public volatile boolean boolean58;
  public volatile boolean boolean59;
  public static transient boolean boolean60;
  public static final boolean boolean61 = false;
  public static volatile boolean boolean62;
  public transient final boolean boolean63 = false;
  public transient volatile boolean boolean64;
  public transient volatile boolean boolean65;
  public transient volatile boolean boolean66;
  public transient volatile boolean boolean67;
  public transient volatile boolean boolean68;
  public transient volatile boolean boolean69;
  public static transient final boolean boolean70 = false;
  public static transient volatile boolean boolean71;
  protected boolean boolean72;
  protected boolean boolean73;
  protected boolean boolean74;
  protected boolean boolean75;
  protected boolean boolean76;
  protected boolean boolean77;
  protected boolean boolean78;
  protected boolean boolean79;
  protected static boolean boolean80;
  protected transient boolean boolean81;
  protected transient boolean boolean82;
  protected transient boolean boolean83;
  protected transient boolean boolean84;
  protected transient boolean boolean85;
  protected transient boolean boolean86;
  protected final boolean boolean87 = false;
  protected volatile boolean boolean88;
  protected volatile boolean boolean89;
  protected volatile boolean boolean90;
  protected volatile boolean boolean91;
  protected volatile boolean boolean92;
  protected volatile boolean boolean93;
  protected volatile boolean boolean94;
  protected volatile boolean boolean95;
  protected static transient boolean boolean96;
  protected static final boolean boolean97 = false;
  protected static volatile boolean boolean98;
  protected transient final boolean boolean99 = false;
  protected transient volatile boolean boolean100;
  protected transient volatile boolean boolean101;
  protected transient volatile boolean boolean102;
  protected transient volatile boolean boolean103;
  protected transient volatile boolean boolean104;
  protected transient volatile boolean boolean105;
  protected static transient final boolean boolean106 = false;
  protected static transient volatile boolean boolean107;
  boolean boolean108;
  boolean boolean109;
  boolean boolean110;
  boolean boolean111;
  boolean boolean112;
  boolean boolean113;
  boolean boolean114;
  boolean boolean115;
  static boolean boolean116;
  transient boolean boolean117;
  transient boolean boolean118;
  transient boolean boolean119;
  transient boolean boolean120;
  transient boolean boolean121;
  transient boolean boolean122;
  final boolean boolean123 = false;
  volatile boolean boolean124;
  volatile boolean boolean125;
  volatile boolean boolean126;
  volatile boolean boolean127;
  volatile boolean boolean128;
  volatile boolean boolean129;
  volatile boolean boolean130;
  volatile boolean boolean131;
  static transient boolean boolean132;
  static final boolean boolean133 = false;
  static volatile boolean boolean134;
  transient final boolean boolean135 = false;
  transient volatile boolean boolean136;
  transient volatile boolean boolean137;
  transient volatile boolean boolean138;
  transient volatile boolean boolean139;
  transient volatile boolean boolean140;
  transient volatile boolean boolean141;
  static transient final boolean boolean142 = false;
  static transient volatile boolean boolean143;

public static final boolean [] isPersistent = { 
true,true,true,false,true,true,true,false,false,false,
false,true,true,true,false,false,true,true,true,false,
true,true,true,false,false,false,false,false,false,false,
true,true,true,false,false,false,true,true,true,false,
true,true,true,false,false,false,false,true,true,true,
false,false,true,true,true,false,true,true,true,false,
false,false,false,false,false,false,true,true,true,false,
false,false,true,true,true,false,true,true,true,false,
false,false,false,true,true,true,false,false,true,true,
true,false,true,true,true,false,false,false,false,false,
false,false,true,true,true,false,false,false,true,true,
true,false,true,true,true,false,false,false,false,true,
true,true,false,false,true,true,true,false,true,true,
true,false,false,false,false,false,false,false,true,true,
true,false,false,false
 };

public static final boolean [] isStatic = { 
false,false,false,false,false,false,false,false,true,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,true,true,true,false,false,false,
false,false,false,false,true,true,false,false,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
true,true,true,false,false,false,false,false,false,false,
true,true,false,false,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,true,true,true,false,
false,false,false,false,false,false,true,true,false,false,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,true,true,true,false,false,false,false,false,
false,false,true,true
 };

public static final boolean [] isFinal = { 
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,true,false,false,false,false,
false,false,false,false,false,true,false,true,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,true,false,false,false,false,false,false,false,false,
false,true,false,true,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,false,true,false,false,
false,false,false,false,false,false,false,true,false,true,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,true,false,false,false,false,false,false,
false,false,false,true,false,true,false,false,false,false,
false,false,true,false
 };

  public static final String [] fieldSpecs = { 
  "private boolean boolean0",
  "embedded= true   private boolean boolean1",
  "embedded= false   private boolean boolean2",
  "persistence-modifier= none    private boolean boolean3",
  "persistence-modifier= persistent    private boolean boolean4",
  "persistence-modifier= persistent  embedded= true   private boolean boolean5",
  "persistence-modifier= persistent  embedded= false   private boolean boolean6",
  "persistence-modifier= transactional    private boolean boolean7",
  "private static boolean boolean8",
  "private transient boolean boolean9",
  "persistence-modifier= none    private transient boolean boolean10",
  "persistence-modifier= persistent    private transient boolean boolean11",
  "persistence-modifier= persistent  embedded= true   private transient boolean boolean12",
  "persistence-modifier= persistent  embedded= false   private transient boolean boolean13",
  "persistence-modifier= transactional    private transient boolean boolean14",
  "private final boolean boolean15",
  "private volatile boolean boolean16",
  "embedded= true   private volatile boolean boolean17",
  "embedded= false   private volatile boolean boolean18",
  "persistence-modifier= none    private volatile boolean boolean19",
  "persistence-modifier= persistent    private volatile boolean boolean20",
  "persistence-modifier= persistent  embedded= true   private volatile boolean boolean21",
  "persistence-modifier= persistent  embedded= false   private volatile boolean boolean22",
  "persistence-modifier= transactional    private volatile boolean boolean23",
  "private static transient boolean boolean24",
  "private static final boolean boolean25",
  "private static volatile boolean boolean26",
  "private transient final boolean boolean27",
  "private transient volatile boolean boolean28",
  "persistence-modifier= none    private transient volatile boolean boolean29",
  "persistence-modifier= persistent    private transient volatile boolean boolean30",
  "persistence-modifier= persistent  embedded= true   private transient volatile boolean boolean31",
  "persistence-modifier= persistent  embedded= false   private transient volatile boolean boolean32",
  "persistence-modifier= transactional    private transient volatile boolean boolean33",
  "private static transient final boolean boolean34",
  "private static transient volatile boolean boolean35",
  "public boolean boolean36",
  "embedded= true   public boolean boolean37",
  "embedded= false   public boolean boolean38",
  "persistence-modifier= none    public boolean boolean39",
  "persistence-modifier= persistent    public boolean boolean40",
  "persistence-modifier= persistent  embedded= true   public boolean boolean41",
  "persistence-modifier= persistent  embedded= false   public boolean boolean42",
  "persistence-modifier= transactional    public boolean boolean43",
  "public static boolean boolean44",
  "public transient boolean boolean45",
  "persistence-modifier= none    public transient boolean boolean46",
  "persistence-modifier= persistent    public transient boolean boolean47",
  "persistence-modifier= persistent  embedded= true   public transient boolean boolean48",
  "persistence-modifier= persistent  embedded= false   public transient boolean boolean49",
  "persistence-modifier= transactional    public transient boolean boolean50",
  "public final boolean boolean51",
  "public volatile boolean boolean52",
  "embedded= true   public volatile boolean boolean53",
  "embedded= false   public volatile boolean boolean54",
  "persistence-modifier= none    public volatile boolean boolean55",
  "persistence-modifier= persistent    public volatile boolean boolean56",
  "persistence-modifier= persistent  embedded= true   public volatile boolean boolean57",
  "persistence-modifier= persistent  embedded= false   public volatile boolean boolean58",
  "persistence-modifier= transactional    public volatile boolean boolean59",
  "public static transient boolean boolean60",
  "public static final boolean boolean61",
  "public static volatile boolean boolean62",
  "public transient final boolean boolean63",
  "public transient volatile boolean boolean64",
  "persistence-modifier= none    public transient volatile boolean boolean65",
  "persistence-modifier= persistent    public transient volatile boolean boolean66",
  "persistence-modifier= persistent  embedded= true   public transient volatile boolean boolean67",
  "persistence-modifier= persistent  embedded= false   public transient volatile boolean boolean68",
  "persistence-modifier= transactional    public transient volatile boolean boolean69",
  "public static transient final boolean boolean70",
  "public static transient volatile boolean boolean71",
  "protected boolean boolean72",
  "embedded= true   protected boolean boolean73",
  "embedded= false   protected boolean boolean74",
  "persistence-modifier= none    protected boolean boolean75",
  "persistence-modifier= persistent    protected boolean boolean76",
  "persistence-modifier= persistent  embedded= true   protected boolean boolean77",
  "persistence-modifier= persistent  embedded= false   protected boolean boolean78",
  "persistence-modifier= transactional    protected boolean boolean79",
  "protected static boolean boolean80",
  "protected transient boolean boolean81",
  "persistence-modifier= none    protected transient boolean boolean82",
  "persistence-modifier= persistent    protected transient boolean boolean83",
  "persistence-modifier= persistent  embedded= true   protected transient boolean boolean84",
  "persistence-modifier= persistent  embedded= false   protected transient boolean boolean85",
  "persistence-modifier= transactional    protected transient boolean boolean86",
  "protected final boolean boolean87",
  "protected volatile boolean boolean88",
  "embedded= true   protected volatile boolean boolean89",
  "embedded= false   protected volatile boolean boolean90",
  "persistence-modifier= none    protected volatile boolean boolean91",
  "persistence-modifier= persistent    protected volatile boolean boolean92",
  "persistence-modifier= persistent  embedded= true   protected volatile boolean boolean93",
  "persistence-modifier= persistent  embedded= false   protected volatile boolean boolean94",
  "persistence-modifier= transactional    protected volatile boolean boolean95",
  "protected static transient boolean boolean96",
  "protected static final boolean boolean97",
  "protected static volatile boolean boolean98",
  "protected transient final boolean boolean99",
  "protected transient volatile boolean boolean100",
  "persistence-modifier= none    protected transient volatile boolean boolean101",
  "persistence-modifier= persistent    protected transient volatile boolean boolean102",
  "persistence-modifier= persistent  embedded= true   protected transient volatile boolean boolean103",
  "persistence-modifier= persistent  embedded= false   protected transient volatile boolean boolean104",
  "persistence-modifier= transactional    protected transient volatile boolean boolean105",
  "protected static transient final boolean boolean106",
  "protected static transient volatile boolean boolean107",
  "boolean boolean108",
  "embedded= true   boolean boolean109",
  "embedded= false   boolean boolean110",
  "persistence-modifier= none    boolean boolean111",
  "persistence-modifier= persistent    boolean boolean112",
  "persistence-modifier= persistent  embedded= true   boolean boolean113",
  "persistence-modifier= persistent  embedded= false   boolean boolean114",
  "persistence-modifier= transactional    boolean boolean115",
  "static boolean boolean116",
  "transient boolean boolean117",
  "persistence-modifier= none    transient boolean boolean118",
  "persistence-modifier= persistent    transient boolean boolean119",
  "persistence-modifier= persistent  embedded= true   transient boolean boolean120",
  "persistence-modifier= persistent  embedded= false   transient boolean boolean121",
  "persistence-modifier= transactional    transient boolean boolean122",
  "final boolean boolean123",
  "volatile boolean boolean124",
  "embedded= true   volatile boolean boolean125",
  "embedded= false   volatile boolean boolean126",
  "persistence-modifier= none    volatile boolean boolean127",
  "persistence-modifier= persistent    volatile boolean boolean128",
  "persistence-modifier= persistent  embedded= true   volatile boolean boolean129",
  "persistence-modifier= persistent  embedded= false   volatile boolean boolean130",
  "persistence-modifier= transactional    volatile boolean boolean131",
  "static transient boolean boolean132",
  "static final boolean boolean133",
  "static volatile boolean boolean134",
  "transient final boolean boolean135",
  "transient volatile boolean boolean136",
  "persistence-modifier= none    transient volatile boolean boolean137",
  "persistence-modifier= persistent    transient volatile boolean boolean138",
  "persistence-modifier= persistent  embedded= true   transient volatile boolean boolean139",
  "persistence-modifier= persistent  embedded= false   transient volatile boolean boolean140",
  "persistence-modifier= transactional    transient volatile boolean boolean141",
  "static transient final boolean boolean142",
  "static transient volatile boolean boolean143"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public boolean get(int index)
  {
    switch (index)
    {
      case(0):
        return boolean0;
      case(1):
        return boolean1;
      case(2):
        return boolean2;
      case(3):
        return boolean3;
      case(4):
        return boolean4;
      case(5):
        return boolean5;
      case(6):
        return boolean6;
      case(7):
        return boolean7;
      case(8):
        return boolean8;
      case(9):
        return boolean9;
      case(10):
        return boolean10;
      case(11):
        return boolean11;
      case(12):
        return boolean12;
      case(13):
        return boolean13;
      case(14):
        return boolean14;
      case(15):
        return boolean15;
      case(16):
        return boolean16;
      case(17):
        return boolean17;
      case(18):
        return boolean18;
      case(19):
        return boolean19;
      case(20):
        return boolean20;
      case(21):
        return boolean21;
      case(22):
        return boolean22;
      case(23):
        return boolean23;
      case(24):
        return boolean24;
      case(25):
        return boolean25;
      case(26):
        return boolean26;
      case(27):
        return boolean27;
      case(28):
        return boolean28;
      case(29):
        return boolean29;
      case(30):
        return boolean30;
      case(31):
        return boolean31;
      case(32):
        return boolean32;
      case(33):
        return boolean33;
      case(34):
        return boolean34;
      case(35):
        return boolean35;
      case(36):
        return boolean36;
      case(37):
        return boolean37;
      case(38):
        return boolean38;
      case(39):
        return boolean39;
      case(40):
        return boolean40;
      case(41):
        return boolean41;
      case(42):
        return boolean42;
      case(43):
        return boolean43;
      case(44):
        return boolean44;
      case(45):
        return boolean45;
      case(46):
        return boolean46;
      case(47):
        return boolean47;
      case(48):
        return boolean48;
      case(49):
        return boolean49;
      case(50):
        return boolean50;
      case(51):
        return boolean51;
      case(52):
        return boolean52;
      case(53):
        return boolean53;
      case(54):
        return boolean54;
      case(55):
        return boolean55;
      case(56):
        return boolean56;
      case(57):
        return boolean57;
      case(58):
        return boolean58;
      case(59):
        return boolean59;
      case(60):
        return boolean60;
      case(61):
        return boolean61;
      case(62):
        return boolean62;
      case(63):
        return boolean63;
      case(64):
        return boolean64;
      case(65):
        return boolean65;
      case(66):
        return boolean66;
      case(67):
        return boolean67;
      case(68):
        return boolean68;
      case(69):
        return boolean69;
      case(70):
        return boolean70;
      case(71):
        return boolean71;
      case(72):
        return boolean72;
      case(73):
        return boolean73;
      case(74):
        return boolean74;
      case(75):
        return boolean75;
      case(76):
        return boolean76;
      case(77):
        return boolean77;
      case(78):
        return boolean78;
      case(79):
        return boolean79;
      case(80):
        return boolean80;
      case(81):
        return boolean81;
      case(82):
        return boolean82;
      case(83):
        return boolean83;
      case(84):
        return boolean84;
      case(85):
        return boolean85;
      case(86):
        return boolean86;
      case(87):
        return boolean87;
      case(88):
        return boolean88;
      case(89):
        return boolean89;
      case(90):
        return boolean90;
      case(91):
        return boolean91;
      case(92):
        return boolean92;
      case(93):
        return boolean93;
      case(94):
        return boolean94;
      case(95):
        return boolean95;
      case(96):
        return boolean96;
      case(97):
        return boolean97;
      case(98):
        return boolean98;
      case(99):
        return boolean99;
      case(100):
        return boolean100;
      case(101):
        return boolean101;
      case(102):
        return boolean102;
      case(103):
        return boolean103;
      case(104):
        return boolean104;
      case(105):
        return boolean105;
      case(106):
        return boolean106;
      case(107):
        return boolean107;
      case(108):
        return boolean108;
      case(109):
        return boolean109;
      case(110):
        return boolean110;
      case(111):
        return boolean111;
      case(112):
        return boolean112;
      case(113):
        return boolean113;
      case(114):
        return boolean114;
      case(115):
        return boolean115;
      case(116):
        return boolean116;
      case(117):
        return boolean117;
      case(118):
        return boolean118;
      case(119):
        return boolean119;
      case(120):
        return boolean120;
      case(121):
        return boolean121;
      case(122):
        return boolean122;
      case(123):
        return boolean123;
      case(124):
        return boolean124;
      case(125):
        return boolean125;
      case(126):
        return boolean126;
      case(127):
        return boolean127;
      case(128):
        return boolean128;
      case(129):
        return boolean129;
      case(130):
        return boolean130;
      case(131):
        return boolean131;
      case(132):
        return boolean132;
      case(133):
        return boolean133;
      case(134):
        return boolean134;
      case(135):
        return boolean135;
      case(136):
        return boolean136;
      case(137):
        return boolean137;
      case(138):
        return boolean138;
      case(139):
        return boolean139;
      case(140):
        return boolean140;
      case(141):
        return boolean141;
      case(142):
        return boolean142;
      case(143):
        return boolean143;
      default:
        throw new IndexOutOfBoundsException();
    }
  }
  public boolean set(int index,boolean value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        boolean0= value;
         break;
      case(1):
        boolean1= value;
         break;
      case(2):
        boolean2= value;
         break;
      case(3):
        boolean3= value;
         break;
      case(4):
        boolean4= value;
         break;
      case(5):
        boolean5= value;
         break;
      case(6):
        boolean6= value;
         break;
      case(7):
        boolean7= value;
         break;
      case(8):
        boolean8= value;
         break;
      case(9):
        boolean9= value;
         break;
      case(10):
        boolean10= value;
         break;
      case(11):
        boolean11= value;
         break;
      case(12):
        boolean12= value;
         break;
      case(13):
        boolean13= value;
         break;
      case(14):
        boolean14= value;
         break;
      case(16):
        boolean16= value;
         break;
      case(17):
        boolean17= value;
         break;
      case(18):
        boolean18= value;
         break;
      case(19):
        boolean19= value;
         break;
      case(20):
        boolean20= value;
         break;
      case(21):
        boolean21= value;
         break;
      case(22):
        boolean22= value;
         break;
      case(23):
        boolean23= value;
         break;
      case(24):
        boolean24= value;
         break;
      case(26):
        boolean26= value;
         break;
      case(28):
        boolean28= value;
         break;
      case(29):
        boolean29= value;
         break;
      case(30):
        boolean30= value;
         break;
      case(31):
        boolean31= value;
         break;
      case(32):
        boolean32= value;
         break;
      case(33):
        boolean33= value;
         break;
      case(35):
        boolean35= value;
         break;
      case(36):
        boolean36= value;
         break;
      case(37):
        boolean37= value;
         break;
      case(38):
        boolean38= value;
         break;
      case(39):
        boolean39= value;
         break;
      case(40):
        boolean40= value;
         break;
      case(41):
        boolean41= value;
         break;
      case(42):
        boolean42= value;
         break;
      case(43):
        boolean43= value;
         break;
      case(44):
        boolean44= value;
         break;
      case(45):
        boolean45= value;
         break;
      case(46):
        boolean46= value;
         break;
      case(47):
        boolean47= value;
         break;
      case(48):
        boolean48= value;
         break;
      case(49):
        boolean49= value;
         break;
      case(50):
        boolean50= value;
         break;
      case(52):
        boolean52= value;
         break;
      case(53):
        boolean53= value;
         break;
      case(54):
        boolean54= value;
         break;
      case(55):
        boolean55= value;
         break;
      case(56):
        boolean56= value;
         break;
      case(57):
        boolean57= value;
         break;
      case(58):
        boolean58= value;
         break;
      case(59):
        boolean59= value;
         break;
      case(60):
        boolean60= value;
         break;
      case(62):
        boolean62= value;
         break;
      case(64):
        boolean64= value;
         break;
      case(65):
        boolean65= value;
         break;
      case(66):
        boolean66= value;
         break;
      case(67):
        boolean67= value;
         break;
      case(68):
        boolean68= value;
         break;
      case(69):
        boolean69= value;
         break;
      case(71):
        boolean71= value;
         break;
      case(72):
        boolean72= value;
         break;
      case(73):
        boolean73= value;
         break;
      case(74):
        boolean74= value;
         break;
      case(75):
        boolean75= value;
         break;
      case(76):
        boolean76= value;
         break;
      case(77):
        boolean77= value;
         break;
      case(78):
        boolean78= value;
         break;
      case(79):
        boolean79= value;
         break;
      case(80):
        boolean80= value;
         break;
      case(81):
        boolean81= value;
         break;
      case(82):
        boolean82= value;
         break;
      case(83):
        boolean83= value;
         break;
      case(84):
        boolean84= value;
         break;
      case(85):
        boolean85= value;
         break;
      case(86):
        boolean86= value;
         break;
      case(88):
        boolean88= value;
         break;
      case(89):
        boolean89= value;
         break;
      case(90):
        boolean90= value;
         break;
      case(91):
        boolean91= value;
         break;
      case(92):
        boolean92= value;
         break;
      case(93):
        boolean93= value;
         break;
      case(94):
        boolean94= value;
         break;
      case(95):
        boolean95= value;
         break;
      case(96):
        boolean96= value;
         break;
      case(98):
        boolean98= value;
         break;
      case(100):
        boolean100= value;
         break;
      case(101):
        boolean101= value;
         break;
      case(102):
        boolean102= value;
         break;
      case(103):
        boolean103= value;
         break;
      case(104):
        boolean104= value;
         break;
      case(105):
        boolean105= value;
         break;
      case(107):
        boolean107= value;
         break;
      case(108):
        boolean108= value;
         break;
      case(109):
        boolean109= value;
         break;
      case(110):
        boolean110= value;
         break;
      case(111):
        boolean111= value;
         break;
      case(112):
        boolean112= value;
         break;
      case(113):
        boolean113= value;
         break;
      case(114):
        boolean114= value;
         break;
      case(115):
        boolean115= value;
         break;
      case(116):
        boolean116= value;
         break;
      case(117):
        boolean117= value;
         break;
      case(118):
        boolean118= value;
         break;
      case(119):
        boolean119= value;
         break;
      case(120):
        boolean120= value;
         break;
      case(121):
        boolean121= value;
         break;
      case(122):
        boolean122= value;
         break;
      case(124):
        boolean124= value;
         break;
      case(125):
        boolean125= value;
         break;
      case(126):
        boolean126= value;
         break;
      case(127):
        boolean127= value;
         break;
      case(128):
        boolean128= value;
         break;
      case(129):
        boolean129= value;
         break;
      case(130):
        boolean130= value;
         break;
      case(131):
        boolean131= value;
         break;
      case(132):
        boolean132= value;
         break;
      case(134):
        boolean134= value;
         break;
      case(136):
        boolean136= value;
         break;
      case(137):
        boolean137= value;
         break;
      case(138):
        boolean138= value;
         break;
      case(139):
        boolean139= value;
         break;
      case(140):
        boolean140= value;
         break;
      case(141):
        boolean141= value;
         break;
      case(143):
        boolean143= value;
         break;
      default:
        throw new IndexOutOfBoundsException();
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }

    }   
}
