/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.CaliperOptions;
import com.google.caliper.util.CommandLineParser;
import com.google.caliper.util.InvalidCommandException;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;

public final class ParsedOptions
implements CaliperOptions {
    @CommandLineParser.Option(value={"-n", "--dry-run", "--debug"})
    private boolean dryRun;
    @CommandLineParser.Option(value={"-d", "--delimiter"})
    private String delimiter = ",";
    private ImmutableSet<String> benchmarkNames = ImmutableSet.of();
    @CommandLineParser.Option(value={"-v", "--verbose"})
    private boolean verbose = false;
    private boolean detailedLogging = false;
    private int trials = 1;
    private ImmutableSet<String> vmNames = ImmutableSet.of();
    private String outputFileOrDir;
    private boolean calculateAggregateScore;
    @CommandLineParser.Option(value={"-i", "--instrument"})
    private String instrumentName = "micro";
    private Multimap<String, String> mutableUserParameters = ArrayListMultimap.create();
    private Multimap<String, String> mutableVmArguments = ArrayListMultimap.create();
    private String caliperRcFilename = System.getProperty("user.home") + "/.caliperrc";
    private String benchmarkClassName;
    private static final ImmutableList<String> USAGE = ImmutableList.of((Object)"Usage:", (Object)" caliper [options...] <benchmark_class_name>", (Object)" java <benchmark_class_name> [options...]", (Object)"", (Object)"Options:", (Object)" -h, --help        print this message", (Object)" -n, --dry-run     instead of measuring, execute a single rep for each scenario", (Object)"                   in-process", (Object)" -b, --benchmark   comma-separated list of benchmark methods to run; 'foo' is", (Object)"                   an alias for 'timeFoo' (default: all found in class)", (Object)" -m, --vm          comma-separated list of VMs to test on; possible values are", (Object)"                   configured in Caliper's configuration file (default:", (Object[])new String[]{"                   whichever VM caliper itself is running in, only)", " -i, --instrument  measuring instrument to use; possible values are configured", "                   in Caliper's configuration file (default: 'micro')", " -t, --trials      number of independent measurements to take per benchmark", "                   scenario; a positive integer (default: 1)", " -o, --output      name of file or directory in which to store the results data", "                   file; if a directory a unique filename is chosen; if a file", "                   it is overwritten (default: ./caliper-results/)", " -l, --logging     generate extremely detailed event logs (GC, compilation", "                   events, etc.) and include them in the output data file", " -v, --verbose     instead of normal console output, display a raw feed of very", "                   detailed information", " -s, --score       also calculate and display an aggregate score for this run", "                   (higher is better, but this value is meaningless otherwise)", " -d, --delimiter   separator used in -b, -m, -D and -J options (default: ',')", " -c, --config      location of Caliper's configuration file (default:", "                   $HOME/.caliperrc)", "", " -Dparam=val1,val2,...", "     Specifies the values to inject into the 'param' field of the benchmark", "     class; if multiple values or parameters are specified in this way, caliper", "     will try all possible combinations.", "", " -JdisplayName='vm arg list choice 1,vm arg list choice 2,...'", "     Specifies alternate sets of VM arguments to pass. As with any variable,", "     caliper will test all possible combinations. Example:", "     -Jmemory='-Xms32m -Xmx32m,-Xms512m -Xmx512m'", "", "See http://code.google.com/p/caliper/wiki/CommandLineOptions for more details.", ""});

    public static ParsedOptions from(String[] args) throws InvalidCommandException {
        ParsedOptions options = new ParsedOptions();
        CommandLineParser<ParsedOptions> parser = CommandLineParser.forClass(ParsedOptions.class);
        try {
            parser.parseAndInject(args, options);
        }
        catch (InvalidCommandException e) {
            e.setUsage((List<String>)USAGE);
            throw e;
        }
        return options;
    }

    private ParsedOptions() {
    }

    @Override
    public boolean dryRun() {
        return this.dryRun;
    }

    private void dryRunIncompatible(String optionName) throws InvalidCommandException {
        if (this.dryRun) {
            throw new InvalidCommandException("Option not available in dry-run mode: " + optionName, new Object[0]);
        }
    }

    private ImmutableSet<String> split(String string) {
        return ImmutableSet.copyOf((Iterable)Splitter.on((String)this.delimiter).split((CharSequence)string));
    }

    @CommandLineParser.Option(value={"-b", "--benchmark"})
    private void setBenchmarkNames(String benchmarksString) {
        this.benchmarkNames = this.split(benchmarksString);
    }

    @Override
    public ImmutableSet<String> benchmarkMethodNames() {
        return this.benchmarkNames;
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }

    @CommandLineParser.Option(value={"-l", "--logging", "--captureVmLog"})
    private void setDetailedLogging(boolean b) throws InvalidCommandException {
        if (b) {
            this.dryRunIncompatible("verbose");
        }
        this.detailedLogging = b;
    }

    @Override
    public boolean detailedLogging() {
        return this.detailedLogging;
    }

    @CommandLineParser.Option(value={"-t", "--trials"})
    private void setTrials(int trials) throws InvalidCommandException {
        this.dryRunIncompatible("trials");
        if (trials < 1) {
            throw new InvalidCommandException("trials must be at least 1: " + trials, new Object[0]);
        }
        this.trials = trials;
    }

    @Override
    public int trialsPerScenario() {
        return this.trials;
    }

    @CommandLineParser.Option(value={"-m", "--vm"})
    private void setVms(String vmsString) throws InvalidCommandException {
        this.dryRunIncompatible("vm");
        this.vmNames = this.split(vmsString);
    }

    @Override
    public ImmutableSet<String> vmNames() {
        return this.vmNames;
    }

    @CommandLineParser.Option(value={"-o", "--output", "--saveResults"})
    private void setOutputFileOrDir(String s) throws InvalidCommandException {
        this.dryRunIncompatible("output");
        this.outputFileOrDir = s;
    }

    @Override
    public String outputFileOrDir() {
        return this.outputFileOrDir;
    }

    @CommandLineParser.Option(value={"-s", "--score", "--printScore"})
    private void setCalculateAggregateScore(boolean b) throws InvalidCommandException {
        if (b) {
            this.dryRunIncompatible("score");
        }
        this.calculateAggregateScore = b;
    }

    @Override
    public boolean calculateAggregateScore() {
        return this.calculateAggregateScore;
    }

    @Override
    public String instrumentName() {
        return this.instrumentName;
    }

    @CommandLineParser.Option(value={"-D"})
    private void addParameterSpec(String nameAndValues) throws InvalidCommandException {
        this.addToMultimap(nameAndValues, this.mutableUserParameters);
    }

    @Override
    public ImmutableSetMultimap<String, String> userParameters() {
        return new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).putAll(this.mutableUserParameters).build();
    }

    @CommandLineParser.Option(value={"-J"})
    private void addVmArgumentsSpec(String nameAndValues) throws InvalidCommandException {
        this.dryRunIncompatible("-J");
        this.addToMultimap(nameAndValues, this.mutableVmArguments);
    }

    @Override
    public ImmutableSetMultimap<String, String> vmArguments() {
        return new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).putAll(this.mutableVmArguments).build();
    }

    @CommandLineParser.Option(value={"-c", "--config"})
    private void setCaliperRcFilename(String filename) {
        this.caliperRcFilename = filename;
    }

    @Override
    public String caliperRcFilename() {
        return this.caliperRcFilename;
    }

    @CommandLineParser.Leftovers
    private void setLeftovers(ImmutableList<String> leftovers) throws InvalidCommandException {
        if (leftovers.isEmpty()) {
            throw new InvalidCommandException("No benchmark class specified", new Object[0]);
        }
        if (leftovers.size() > 1) {
            throw new InvalidCommandException("Extra stuff, expected only class name: " + leftovers, new Object[0]);
        }
        this.benchmarkClassName = (String)leftovers.get(0);
    }

    @Override
    public String benchmarkClassName() {
        return this.benchmarkClassName;
    }

    private void addToMultimap(String nameAndValues, Multimap<String, String> multimap) throws InvalidCommandException {
        int eq = nameAndValues.indexOf(61);
        if (eq == -1) {
            throw new InvalidCommandException("no '=' found in: " + nameAndValues, new Object[0]);
        }
        String name = nameAndValues.substring(0, eq);
        String values = nameAndValues.substring(eq + 1);
        if (multimap.containsKey((Object)name)) {
            throw new InvalidCommandException("multiple parameter sets for: " + name, new Object[0]);
        }
        multimap.putAll((Object)name, this.split(values));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("benchmarkClassName", (Object)this.benchmarkClassName()).add("benchmarkMethodNames", this.benchmarkMethodNames()).add("benchmarkParameters", this.userParameters()).add("calculateAggregateScore", this.calculateAggregateScore()).add("dryRun", this.dryRun()).add("instrumentName", (Object)this.instrumentName()).add("vms", this.vmNames()).add("vmArguments", this.vmArguments()).add("outputFileOrDir", (Object)this.outputFileOrDir()).add("trials", this.trialsPerScenario()).add("detailedLogging", this.detailedLogging()).add("verbose", this.verbose()).add("delimiter", (Object)this.delimiter).add("caliperRcFilename", (Object)this.caliperRcFilename).toString();
    }
}

