/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SAXParserFactory {
    private static final String defaultPropName = "javax.xml.parsers.SAXParserFactory";
    private boolean validating = false;
    private boolean namespaceAware = false;
    private static final Object[] NO_OBJS = new Object[0];
    private static Method getCCL;
    private static String foundFactory;
    private static boolean debug;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$javax$xml$parsers$SAXParserFactory;

    protected SAXParserFactory() {
    }

    public static SAXParserFactory newInstance() {
        String string = SAXParserFactory.findFactory(defaultPropName, "org.apache.crimson.jaxp.SAXParserFactoryImpl");
        if (string == null) {
            throw new FactoryConfigurationError("No default implementation found");
        }
        SAXParserFactory sAXParserFactory = null;
        try {
            Class clazz = SAXParserFactory.getClassForName(string);
            sAXParserFactory = (SAXParserFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FactoryConfigurationError(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new FactoryConfigurationError(instantiationException);
        }
        return sAXParserFactory;
    }

    private static Class getClassForName(String string) throws ClassNotFoundException {
        if (getCCL != null) {
            try {
                ClassLoader classLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), NO_OBJS);
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                getCCL = null;
            }
        }
        return Class.forName(string);
    }

    public abstract SAXParser newSAXParser() throws ParserConfigurationException, SAXException;

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public abstract void setFeature(String var1, boolean var2) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

    public abstract boolean getFeature(String var1) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

    private static String findFactory(String string, String string2) {
        block17: {
            Object object;
            Object object2;
            Object object3;
            String string3;
            block16: {
                try {
                    foundFactory = System.getProperty(string);
                    if (foundFactory != null) {
                        if (debug) {
                            System.err.println("JAXP: found system property" + foundFactory);
                        }
                        return foundFactory;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    string3 = System.getProperty("java.home");
                    object3 = string3 + File.separator + "lib" + File.separator + "jaxp.properties";
                    object2 = new File((String)object3);
                    if (((File)object2).exists()) {
                        object = new Properties();
                        ((Properties)object).load(new FileInputStream((File)object2));
                        foundFactory = ((Properties)object).getProperty(string);
                        if (debug) {
                            System.err.println("JAXP: found java.home property " + foundFactory);
                        }
                        if (foundFactory != null) {
                            return foundFactory;
                        }
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block16;
                    exception.printStackTrace();
                }
            }
            string3 = "META-INF/services/" + string;
            try {
                object3 = (class$javax$xml$parsers$SAXParserFactory == null ? (class$javax$xml$parsers$SAXParserFactory = SAXParserFactory.class$(defaultPropName)) : class$javax$xml$parsers$SAXParserFactory).getClassLoader();
                object2 = null;
                object2 = object3 == null ? ClassLoader.getSystemResourceAsStream(string3) : ((ClassLoader)object3).getResourceAsStream(string3);
                if (object2 != null) {
                    if (debug) {
                        System.err.println("JAXP: found  " + string3);
                    }
                    object = new BufferedReader(new InputStreamReader((InputStream)object2));
                    foundFactory = ((BufferedReader)object).readLine();
                    ((BufferedReader)object).close();
                    if (debug) {
                        System.err.println("JAXP: loaded from services: " + foundFactory);
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        return foundFactory;
                    }
                }
            }
            catch (Exception exception) {
                if (!debug) break block17;
                exception.printStackTrace();
            }
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            getCCL = (class$java$lang$Thread == null ? (class$java$lang$Thread = SAXParserFactory.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
        }
        catch (Exception exception) {
            getCCL = null;
        }
        foundFactory = null;
        debug = false;
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

