/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     coree.h
 * Abstract:        Include file for "core-extension" word set
 */

#ifdef DECLARE_WORDS
#	ifdef PROTOTYPES
#		undef PROTOTYPES
#	endif
#	undef __COREE_H__
#else
#	ifndef PROTOTYPES
#		define PROTOTYPES
#	endif
#endif

#ifndef __COREE_H__
#define __COREE_H__

#include "yforth.h"
#include "macro.h"

/**************************************************************************/
/* VARIABLES **************************************************************/
/**************************************************************************/

variable(Char *, pad,                   "pad")
variable(Cell, source_id,               "source-id")

/**************************************************************************/
/* PROTOTYPES *************************************************************/
/**************************************************************************/

code(dot_paren,                     ".(",                   IMMEDIATE)
code(dot_r,							".r",					0)
code(zero_not_equals,               "0<>",                  0)
code(zero_greater,                  "0>",                   0)
code(two_to_r,                      "2>r",                  COMP_ONLY)
code(two_r_from,                    "2r>",                  COMP_ONLY)
code(two_r_fetch,                   "2r@",                  COMP_ONLY)
code(colon_no_name,                 ":noname",              0)
code(not_equals,                    "<>",                   0)
code(question_do,                   "?do",                  COMP_ONLY | IMMEDIATE)
code(again,                         "again",                COMP_ONLY | IMMEDIATE)
code(c_quote,                       "c\"",                  COMP_ONLY | IMMEDIATE)
code(compile_comma,                 "compile,",             COMP_ONLY)
code(erase,                         "erase",                0)
code(false,                         "false",                0)
code(hex,                           "hex",                  0)
code(marker,                        "marker",               0)
code(nip,                           "nip",                  0)
code(parse,                         "parse",                0)
code(pick,                          "pick",                 0)
code(refill,                        "refill",               0)
code(restore_input,                 "restore-input",        0)
code(roll,                          "roll",                 0)
code(save_input,                    "save-input",           0)
code(true,                          "true",                 0)
code(tuck,                          "tuck",                 0)
code(u_dot_r,						"u.r",					0)
code(u_greater_than,                "u>",                   0)
code(unused,                        "unused",               0)
code(within,                        "within",               0)
code(backslash,                     "\\",                   IMMEDIATE)
code(backslash,                     "#!",                   IMMEDIATE)
code(bracket_compile,               "[compile]",            COMP_ONLY)
code(value,							"value",				0)
code(to,							"to",					IMMEDIATE)

code(paren_question_do_paren,       "(?do)",                0)
code(paren_write_value_paren,		"(wValue)",				0)
code(paren_marker_paren,			"(marker)",				0)

#ifdef PROTOTYPES

/**************************************************************************/
/* AUXILIARY FUNCTIONS PROTOTYPES *****************************************/
/**************************************************************************/

void exec_marker(struct voc_marker *vm);

#endif

#endif

