/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.BulkAccess;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Util;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;

public class Helper {
    protected final DomainRoot mDomainRoot;
    protected final QueryMgr mQueryMgr;
    protected final BulkAccess mBulkAccess;

    public Helper(AMX proxy) {
        this.mDomainRoot = proxy.getDomainRoot();
        this.mQueryMgr = this.mDomainRoot.getQueryMgr();
        this.mBulkAccess = this.mDomainRoot.getBulkAccess();
    }

    public DomainRoot getDomainRoot() {
        return this.mDomainRoot;
    }

    protected <T extends AMX> Set<T> propsQuery(String props) {
        Set results = this.mQueryMgr.queryPropsSet(props);
        return results;
    }

    protected <T extends AMX> Set<T> propsQuery(String props1, String props2) {
        String props = Util.concatenateProps(props1, props2);
        return this.propsQuery(props);
    }

    public Set<ObjectName> filterByAttributeValue(Set<ObjectName> objectNameSet, String attributeName, Object valueToMatch) {
        ObjectName[] objectNames = new ObjectName[objectNameSet.size()];
        objectNameSet.toArray(objectNames);
        Object[] values = this.mBulkAccess.bulkGetAttribute(objectNames, attributeName);
        HashSet<ObjectName> filtered = new HashSet<ObjectName>();
        for (int i = 0; i < values.length; ++i) {
            Object idxValue = values[i];
            boolean matches = false;
            if (valueToMatch == null && idxValue == null) {
                matches = true;
            } else if (valueToMatch instanceof Class && ((Class)valueToMatch).isAssignableFrom(idxValue.getClass())) {
                matches = true;
            } else if (valueToMatch != null && valueToMatch.equals(idxValue)) {
                matches = true;
            }
            if (!matches) continue;
            filtered.add(objectNames[i]);
        }
        return filtered;
    }
}

