import OCP.Graphic3d
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TCollection
import io
import OCP.Quantity
import OCP.OSD
import OCP.gp
import Graphic3d_Camera
import OCP.TColStd
import OCP.Bnd
import OCP.NCollection
import OCP.Aspect
import OCP.BVH
import OCP.TopLoc
import OCP.Image
import OCP.Standard
import OCP.Font
import OCP.SelectMgr
__all__  = [
"Graphic3d_AlphaMode",
"Graphic3d_Array1OfAttribute",
"Graphic3d_ArrayOfPrimitives",
"Graphic3d_ArrayOfPolygons",
"Graphic3d_ArrayOfPolylines",
"Graphic3d_ArrayOfPoints",
"Graphic3d_ArrayOfQuadrangleStrips",
"Graphic3d_ArrayOfQuadrangles",
"Graphic3d_ArrayOfSegments",
"Graphic3d_ArrayOfTriangleFans",
"Graphic3d_ArrayOfTriangleStrips",
"Graphic3d_ArrayOfTriangles",
"Graphic3d_Aspects",
"Graphic3d_AspectLine3d",
"Graphic3d_AspectMarker3d",
"Graphic3d_AspectText3d",
"Graphic3d_AspectFillArea3d",
"Graphic3d_Buffer",
"Graphic3d_Attribute",
"Graphic3d_BSDF",
"Graphic3d_BoundBuffer",
"Graphic3d_AttribBuffer",
"Graphic3d_BufferRange",
"Graphic3d_BufferType",
"Graphic3d_CLight",
"Graphic3d_CStructure",
"Graphic3d_DataStructureManager",
"Graphic3d_Camera",
"Graphic3d_CameraLerp",
"Graphic3d_CameraTile",
"Graphic3d_CappingFlags",
"Graphic3d_ClipPlane",
"Graphic3d_ClipState",
"Graphic3d_TextureRoot",
"Graphic3d_CubeMapOrder",
"Graphic3d_TextureMap",
"Graphic3d_CubeMap",
"Graphic3d_CubeMapSide",
"Graphic3d_CullingTool",
"Graphic3d_CView",
"Graphic3d_DiagnosticInfo",
"Graphic3d_DisplayPriority",
"Graphic3d_FrameStats",
"Graphic3d_FrameStatsCounter",
"Graphic3d_FrameStatsData",
"Graphic3d_FrameStatsDataTmp",
"Graphic3d_FrameStatsTimer",
"Graphic3d_Fresnel",
"Graphic3d_FresnelModel",
"Graphic3d_GlslExtension",
"Graphic3d_GraduatedTrihedron",
"Graphic3d_GraphicDriver",
"Graphic3d_GraphicDriverFactory",
"Graphic3d_GraphicDriverFactoryList",
"Graphic3d_Group",
"Graphic3d_GroupAspect",
"Graphic3d_GroupDefinitionError",
"Graphic3d_HatchStyle",
"Graphic3d_HorizontalTextAlignment",
"Graphic3d_IndexBuffer",
"Graphic3d_Layer",
"Graphic3d_LevelOfTextureAnisotropy",
"Graphic3d_LightSet",
"Graphic3d_MarkerImage",
"Graphic3d_Mat4",
"Graphic3d_Mat4d",
"Graphic3d_MaterialAspect",
"Graphic3d_MaterialDefinitionError",
"Graphic3d_Texture2D",
"Graphic3d_TextureSet",
"Graphic3d_MutableIndexBuffer",
"Graphic3d_NameOfMaterial",
"Graphic3d_NameOfTexture1D",
"Graphic3d_NameOfTexture2D",
"Graphic3d_NameOfTextureEnv",
"Graphic3d_NameOfTexturePlane",
"Graphic3d_PBRMaterial",
"Graphic3d_PolygonOffset",
"Graphic3d_PresentationAttributes",
"Graphic3d_PriorityDefinitionError",
"Graphic3d_RenderTransparentMethod",
"Graphic3d_RenderingMode",
"Graphic3d_RenderingParams",
"Graphic3d_SequenceOfGroup",
"Graphic3d_SequenceOfHClipPlane",
"Graphic3d_SequenceOfStructure",
"Graphic3d_ShaderAttribute",
"Graphic3d_ShaderAttributeList",
"Graphic3d_ShaderFlags",
"Graphic3d_ShaderManager",
"Graphic3d_ShaderObject",
"Graphic3d_ShaderObjectList",
"Graphic3d_ShaderProgram",
"Graphic3d_ShaderVariable",
"Graphic3d_ShaderVariableList",
"Graphic3d_StereoMode",
"Graphic3d_Structure",
"Graphic3d_StructureDefinitionError",
"Graphic3d_StructureManager",
"Graphic3d_Text",
"Graphic3d_TextPath",
"Graphic3d_Texture1D",
"Graphic3d_Texture1Dmanual",
"Graphic3d_Texture1Dsegment",
"Graphic3d_MediaTexture",
"Graphic3d_Texture2Dplane",
"Graphic3d_Texture3D",
"Graphic3d_TextureEnv",
"Graphic3d_CubeMapPacked",
"Graphic3d_TextureParams",
"Graphic3d_CubeMapSeparate",
"Graphic3d_MediaTextureSet",
"Graphic3d_TextureSetBits",
"Graphic3d_TextureUnit",
"Graphic3d_ToneMappingMethod",
"Graphic3d_TransModeFlags",
"Graphic3d_TransformPers",
"Graphic3d_TransformPersScaledAbove",
"Graphic3d_TypeOfAnswer",
"Graphic3d_TypeOfAttribute",
"Graphic3d_TypeOfBackfacingModel",
"Graphic3d_TypeOfBackground",
"Graphic3d_TypeOfConnection",
"Graphic3d_TypeOfData",
"Graphic3d_TypeOfLightSource",
"Graphic3d_TypeOfLimit",
"Graphic3d_TypeOfMaterial",
"Graphic3d_TypeOfPrimitiveArray",
"Graphic3d_TypeOfReflection",
"Graphic3d_TypeOfShaderObject",
"Graphic3d_TypeOfShadingModel",
"Graphic3d_TypeOfStructure",
"Graphic3d_TypeOfTexture",
"Graphic3d_TypeOfTextureFilter",
"Graphic3d_TypeOfTextureMode",
"Graphic3d_TypeOfVisualization",
"Graphic3d_ValueInterface",
"Graphic3d_UniformInt",
"Graphic3d_UniformValueTypeID_Graphic3d_Vec2",
"Graphic3d_UniformValueTypeID_Graphic3d_Vec2i",
"Graphic3d_UniformValueTypeID_Graphic3d_Vec3",
"Graphic3d_UniformValueTypeID_Graphic3d_Vec3i",
"Graphic3d_UniformValueTypeID_Graphic3d_Vec4",
"Graphic3d_UniformValueTypeID_Graphic3d_Vec4i",
"Graphic3d_UniformValueTypeID_Standard_Integer",
"Graphic3d_UniformValueTypeID_Standard_ShortReal",
"Graphic3d_UniformVec2",
"Graphic3d_UniformVec2i",
"Graphic3d_UniformVec3",
"Graphic3d_UniformVec3i",
"Graphic3d_UniformVec4",
"Graphic3d_UniformVec4i",
"Graphic3d_ValidatedCubeMapOrder",
"Graphic3d_UniformFloat",
"Graphic3d_Vec2b",
"Graphic3d_Vec2d",
"Graphic3d_Vec2i",
"Graphic3d_Vec2ub",
"Graphic3d_Vec3b",
"Graphic3d_Vec3i",
"Graphic3d_Vec3ub",
"Graphic3d_Vec4",
"Graphic3d_Vec4b",
"Graphic3d_Vec4d",
"Graphic3d_Vec4i",
"Graphic3d_Vec4ub",
"Graphic3d_Vertex",
"Graphic3d_VerticalTextAlignment",
"Graphic3d_ViewAffinity",
"Graphic3d_WorldViewProjState",
"Graphic3d_ZLayerSettings",
"Graphic3d_ASPECT_FILL_AREA",
"Graphic3d_ASPECT_LINE",
"Graphic3d_ASPECT_MARKER",
"Graphic3d_ASPECT_TEXT",
"Graphic3d_AlphaMode_Blend",
"Graphic3d_AlphaMode_BlendAuto",
"Graphic3d_AlphaMode_Mask",
"Graphic3d_AlphaMode_MaskBlend",
"Graphic3d_AlphaMode_Opaque",
"Graphic3d_ArrayFlags_AttribsDeinterleaved",
"Graphic3d_ArrayFlags_AttribsMutable",
"Graphic3d_ArrayFlags_BoundColor",
"Graphic3d_ArrayFlags_IndexesMutable",
"Graphic3d_ArrayFlags_None",
"Graphic3d_ArrayFlags_VertexColor",
"Graphic3d_ArrayFlags_VertexNormal",
"Graphic3d_ArrayFlags_VertexTexel",
"Graphic3d_BT_Depth",
"Graphic3d_BT_RGB",
"Graphic3d_BT_RGBA",
"Graphic3d_BT_RGB_RayTraceHdrLeft",
"Graphic3d_BT_Red",
"Graphic3d_BT_ShadowMap",
"Graphic3d_CMS_NEG_X",
"Graphic3d_CMS_NEG_Y",
"Graphic3d_CMS_NEG_Z",
"Graphic3d_CMS_POS_X",
"Graphic3d_CMS_POS_Y",
"Graphic3d_CMS_POS_Z",
"Graphic3d_CappingFlags_None",
"Graphic3d_CappingFlags_ObjectAspect",
"Graphic3d_CappingFlags_ObjectMaterial",
"Graphic3d_CappingFlags_ObjectShader",
"Graphic3d_CappingFlags_ObjectTexture",
"Graphic3d_ClipState_In",
"Graphic3d_ClipState_On",
"Graphic3d_ClipState_Out",
"Graphic3d_DiagnosticInfo_Basic",
"Graphic3d_DiagnosticInfo_Complete",
"Graphic3d_DiagnosticInfo_Device",
"Graphic3d_DiagnosticInfo_Extensions",
"Graphic3d_DiagnosticInfo_FrameBuffer",
"Graphic3d_DiagnosticInfo_Limits",
"Graphic3d_DiagnosticInfo_Memory",
"Graphic3d_DiagnosticInfo_NativePlatform",
"Graphic3d_DiagnosticInfo_Short",
"Graphic3d_DisplayPriority_Above",
"Graphic3d_DisplayPriority_Above1",
"Graphic3d_DisplayPriority_Above2",
"Graphic3d_DisplayPriority_AlmostBottom",
"Graphic3d_DisplayPriority_Below",
"Graphic3d_DisplayPriority_Below1",
"Graphic3d_DisplayPriority_Below2",
"Graphic3d_DisplayPriority_Bottom",
"Graphic3d_DisplayPriority_Highlight",
"Graphic3d_DisplayPriority_INVALID",
"Graphic3d_DisplayPriority_NB",
"Graphic3d_DisplayPriority_Normal",
"Graphic3d_DisplayPriority_Topmost",
"Graphic3d_FM_CONDUCTOR",
"Graphic3d_FM_CONSTANT",
"Graphic3d_FM_DIELECTRIC",
"Graphic3d_FM_SCHLICK",
"Graphic3d_FrameStatsCounter_EstimatedBytesFbos",
"Graphic3d_FrameStatsCounter_EstimatedBytesGeom",
"Graphic3d_FrameStatsCounter_EstimatedBytesTextures",
"Graphic3d_FrameStatsCounter_IMMEDIATE_LOWER",
"Graphic3d_FrameStatsCounter_IMMEDIATE_UPPER",
"Graphic3d_FrameStatsCounter_NB",
"Graphic3d_FrameStatsCounter_NbElemsFillImmediate",
"Graphic3d_FrameStatsCounter_NbElemsFillNotCulled",
"Graphic3d_FrameStatsCounter_NbElemsImmediate",
"Graphic3d_FrameStatsCounter_NbElemsLineImmediate",
"Graphic3d_FrameStatsCounter_NbElemsLineNotCulled",
"Graphic3d_FrameStatsCounter_NbElemsNotCulled",
"Graphic3d_FrameStatsCounter_NbElemsPointImmediate",
"Graphic3d_FrameStatsCounter_NbElemsPointNotCulled",
"Graphic3d_FrameStatsCounter_NbElemsTextImmediate",
"Graphic3d_FrameStatsCounter_NbElemsTextNotCulled",
"Graphic3d_FrameStatsCounter_NbGroupsImmediate",
"Graphic3d_FrameStatsCounter_NbGroupsNotCulled",
"Graphic3d_FrameStatsCounter_NbLayers",
"Graphic3d_FrameStatsCounter_NbLayersImmediate",
"Graphic3d_FrameStatsCounter_NbLayersNotCulled",
"Graphic3d_FrameStatsCounter_NbLinesImmediate",
"Graphic3d_FrameStatsCounter_NbLinesNotCulled",
"Graphic3d_FrameStatsCounter_NbPointsImmediate",
"Graphic3d_FrameStatsCounter_NbPointsNotCulled",
"Graphic3d_FrameStatsCounter_NbStructs",
"Graphic3d_FrameStatsCounter_NbStructsImmediate",
"Graphic3d_FrameStatsCounter_NbStructsNotCulled",
"Graphic3d_FrameStatsCounter_NbTrianglesImmediate",
"Graphic3d_FrameStatsCounter_NbTrianglesNotCulled",
"Graphic3d_FrameStatsCounter_RENDERED_LOWER",
"Graphic3d_FrameStatsCounter_RENDERED_UPPER",
"Graphic3d_FrameStatsCounter_SCENE_LOWER",
"Graphic3d_FrameStatsCounter_SCENE_UPPER",
"Graphic3d_FrameStatsTimer_CpuCulling",
"Graphic3d_FrameStatsTimer_CpuDynamics",
"Graphic3d_FrameStatsTimer_CpuFrame",
"Graphic3d_FrameStatsTimer_CpuPicking",
"Graphic3d_FrameStatsTimer_ElapsedFrame",
"Graphic3d_FrameStatsTimer_NB",
"Graphic3d_GlslExtension_GL_EXT_frag_depth",
"Graphic3d_GlslExtension_GL_EXT_gpu_shader4",
"Graphic3d_GlslExtension_GL_EXT_shader_texture_lod",
"Graphic3d_GlslExtension_GL_OES_standard_derivatives",
"Graphic3d_GlslExtension_NB",
"Graphic3d_HTA_CENTER",
"Graphic3d_HTA_LEFT",
"Graphic3d_HTA_RIGHT",
"Graphic3d_LOTA_FAST",
"Graphic3d_LOTA_MIDDLE",
"Graphic3d_LOTA_OFF",
"Graphic3d_LOTA_QUALITY",
"Graphic3d_MATERIAL_ASPECT",
"Graphic3d_MATERIAL_PHYSIC",
"Graphic3d_NOM_ALUMINIUM",
"Graphic3d_NOM_BRASS",
"Graphic3d_NOM_BRONZE",
"Graphic3d_NOM_CHARCOAL",
"Graphic3d_NOM_CHROME",
"Graphic3d_NOM_COPPER",
"Graphic3d_NOM_DEFAULT",
"Graphic3d_NOM_DIAMOND",
"Graphic3d_NOM_GLASS",
"Graphic3d_NOM_GOLD",
"Graphic3d_NOM_JADE",
"Graphic3d_NOM_METALIZED",
"Graphic3d_NOM_NEON_GNC",
"Graphic3d_NOM_NEON_PHC",
"Graphic3d_NOM_OBSIDIAN",
"Graphic3d_NOM_PEWTER",
"Graphic3d_NOM_PLASTER",
"Graphic3d_NOM_PLASTIC",
"Graphic3d_NOM_SATIN",
"Graphic3d_NOM_SHINY_PLASTIC",
"Graphic3d_NOM_SILVER",
"Graphic3d_NOM_STEEL",
"Graphic3d_NOM_STONE",
"Graphic3d_NOM_TRANSPARENT",
"Graphic3d_NOM_UserDefined",
"Graphic3d_NOM_WATER",
"Graphic3d_NOTP_UNKNOWN",
"Graphic3d_NOTP_XY",
"Graphic3d_NOTP_YZ",
"Graphic3d_NOTP_ZX",
"Graphic3d_NOT_1D_ELEVATION",
"Graphic3d_NOT_1D_UNKNOWN",
"Graphic3d_NOT_2D_ALIENSKIN",
"Graphic3d_NOT_2D_ALUMINUM",
"Graphic3d_NOT_2D_BLUEWHITE_PAPER",
"Graphic3d_NOT_2D_BLUE_ROCK",
"Graphic3d_NOT_2D_BRUSHED",
"Graphic3d_NOT_2D_BUBBLES",
"Graphic3d_NOT_2D_BUMP",
"Graphic3d_NOT_2D_CAST",
"Graphic3d_NOT_2D_CHESS",
"Graphic3d_NOT_2D_CHIPBD",
"Graphic3d_NOT_2D_CLOUDS",
"Graphic3d_NOT_2D_FLESH",
"Graphic3d_NOT_2D_FLOOR",
"Graphic3d_NOT_2D_GALVNISD",
"Graphic3d_NOT_2D_GRASS",
"Graphic3d_NOT_2D_KNURL",
"Graphic3d_NOT_2D_MAPLE",
"Graphic3d_NOT_2D_MARBLE",
"Graphic3d_NOT_2D_MATRA",
"Graphic3d_NOT_2D_MOTTLED",
"Graphic3d_NOT_2D_RAIN",
"Graphic3d_NOT_2D_ROCK",
"Graphic3d_NOT_2D_UNKNOWN",
"Graphic3d_NOT_ENV_CLOUDS",
"Graphic3d_NOT_ENV_CV",
"Graphic3d_NOT_ENV_LINES",
"Graphic3d_NOT_ENV_MEDIT",
"Graphic3d_NOT_ENV_PEARL",
"Graphic3d_NOT_ENV_ROAD",
"Graphic3d_NOT_ENV_SKY1",
"Graphic3d_NOT_ENV_SKY2",
"Graphic3d_NOT_ENV_UNKNOWN",
"Graphic3d_NameOfMaterial_Aluminum",
"Graphic3d_NameOfMaterial_Brass",
"Graphic3d_NameOfMaterial_Bronze",
"Graphic3d_NameOfMaterial_Charcoal",
"Graphic3d_NameOfMaterial_Chrome",
"Graphic3d_NameOfMaterial_Copper",
"Graphic3d_NameOfMaterial_DEFAULT",
"Graphic3d_NameOfMaterial_Diamond",
"Graphic3d_NameOfMaterial_Glass",
"Graphic3d_NameOfMaterial_Gold",
"Graphic3d_NameOfMaterial_Ionized",
"Graphic3d_NameOfMaterial_Jade",
"Graphic3d_NameOfMaterial_Metalized",
"Graphic3d_NameOfMaterial_Neon",
"Graphic3d_NameOfMaterial_Obsidian",
"Graphic3d_NameOfMaterial_Pewter",
"Graphic3d_NameOfMaterial_Plastered",
"Graphic3d_NameOfMaterial_Plastified",
"Graphic3d_NameOfMaterial_Satin",
"Graphic3d_NameOfMaterial_ShinyPlastified",
"Graphic3d_NameOfMaterial_Silver",
"Graphic3d_NameOfMaterial_Steel",
"Graphic3d_NameOfMaterial_Stone",
"Graphic3d_NameOfMaterial_Transparent",
"Graphic3d_NameOfMaterial_UserDefined",
"Graphic3d_NameOfMaterial_Water",
"Graphic3d_RM_RASTERIZATION",
"Graphic3d_RM_RAYTRACING",
"Graphic3d_RTM_BLEND_OIT",
"Graphic3d_RTM_BLEND_UNORDERED",
"Graphic3d_RTM_DEPTH_PEELING_OIT",
"Graphic3d_ShaderFlags_AlphaTest",
"Graphic3d_ShaderFlags_ClipChains",
"Graphic3d_ShaderFlags_ClipPlanes1",
"Graphic3d_ShaderFlags_ClipPlanes2",
"Graphic3d_ShaderFlags_ClipPlanesN",
"Graphic3d_ShaderFlags_HasTextures",
"Graphic3d_ShaderFlags_IsPoint",
"Graphic3d_ShaderFlags_MeshEdges",
"Graphic3d_ShaderFlags_NB",
"Graphic3d_ShaderFlags_NeedsGeomShader",
"Graphic3d_ShaderFlags_OitDepthPeeling",
"Graphic3d_ShaderFlags_PointSimple",
"Graphic3d_ShaderFlags_PointSprite",
"Graphic3d_ShaderFlags_PointSpriteA",
"Graphic3d_ShaderFlags_StippleLine",
"Graphic3d_ShaderFlags_TextureEnv",
"Graphic3d_ShaderFlags_TextureNormal",
"Graphic3d_ShaderFlags_TextureRGB",
"Graphic3d_ShaderFlags_VertColor",
"Graphic3d_ShaderFlags_WriteOit",
"Graphic3d_StereoMode_Anaglyph",
"Graphic3d_StereoMode_ChessBoard",
"Graphic3d_StereoMode_ColumnInterlaced",
"Graphic3d_StereoMode_NB",
"Graphic3d_StereoMode_OpenVR",
"Graphic3d_StereoMode_OverUnder",
"Graphic3d_StereoMode_QuadBuffer",
"Graphic3d_StereoMode_RowInterlaced",
"Graphic3d_StereoMode_SideBySide",
"Graphic3d_StereoMode_SoftPageFlip",
"Graphic3d_TMF_2d",
"Graphic3d_TMF_AxialScalePers",
"Graphic3d_TMF_AxialZoomPers",
"Graphic3d_TMF_CameraPers",
"Graphic3d_TMF_None",
"Graphic3d_TMF_OrthoPers",
"Graphic3d_TMF_RotatePers",
"Graphic3d_TMF_TriedronPers",
"Graphic3d_TMF_ZoomPers",
"Graphic3d_TMF_ZoomRotatePers",
"Graphic3d_TOA_COLOR",
"Graphic3d_TOA_COMPUTE",
"Graphic3d_TOA_CUSTOM",
"Graphic3d_TOA_NO",
"Graphic3d_TOA_NORM",
"Graphic3d_TOA_POS",
"Graphic3d_TOA_UV",
"Graphic3d_TOA_YES",
"Graphic3d_TOBM_AUTOMATIC",
"Graphic3d_TOBM_DISABLE",
"Graphic3d_TOBM_FORCE",
"Graphic3d_TOB_CUBEMAP",
"Graphic3d_TOB_GRADIENT",
"Graphic3d_TOB_NONE",
"Graphic3d_TOB_TEXTURE",
"Graphic3d_TOC_ANCESTOR",
"Graphic3d_TOC_DESCENDANT",
"Graphic3d_TOD_FLOAT",
"Graphic3d_TOD_UINT",
"Graphic3d_TOD_USHORT",
"Graphic3d_TOD_VEC2",
"Graphic3d_TOD_VEC3",
"Graphic3d_TOD_VEC4",
"Graphic3d_TOD_VEC4UB",
"Graphic3d_TOLS_AMBIENT",
"Graphic3d_TOLS_DIRECTIONAL",
"Graphic3d_TOLS_POSITIONAL",
"Graphic3d_TOLS_SPOT",
"Graphic3d_TOPA_LINES_ADJACENCY",
"Graphic3d_TOPA_LINE_STRIP_ADJACENCY",
"Graphic3d_TOPA_POINTS",
"Graphic3d_TOPA_POLYGONS",
"Graphic3d_TOPA_POLYLINES",
"Graphic3d_TOPA_QUADRANGLES",
"Graphic3d_TOPA_QUADRANGLESTRIPS",
"Graphic3d_TOPA_SEGMENTS",
"Graphic3d_TOPA_TRIANGLEFANS",
"Graphic3d_TOPA_TRIANGLES",
"Graphic3d_TOPA_TRIANGLESTRIPS",
"Graphic3d_TOPA_TRIANGLES_ADJACENCY",
"Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY",
"Graphic3d_TOPA_UNDEFINED",
"Graphic3d_TOR_AMBIENT",
"Graphic3d_TOR_DIFFUSE",
"Graphic3d_TOR_EMISSION",
"Graphic3d_TOR_SPECULAR",
"Graphic3d_TOSM_DEFAULT",
"Graphic3d_TOSM_FACET",
"Graphic3d_TOSM_FRAGMENT",
"Graphic3d_TOSM_NONE",
"Graphic3d_TOSM_PBR",
"Graphic3d_TOSM_PBR_FACET",
"Graphic3d_TOSM_UNLIT",
"Graphic3d_TOSM_VERTEX",
"Graphic3d_TOS_ALL",
"Graphic3d_TOS_COMPUTE",
"Graphic3d_TOS_COMPUTED",
"Graphic3d_TOS_FRAGMENT",
"Graphic3d_TOS_GEOMETRY",
"Graphic3d_TOS_SHADING",
"Graphic3d_TOS_TESS_CONTROL",
"Graphic3d_TOS_TESS_EVALUATION",
"Graphic3d_TOS_VERTEX",
"Graphic3d_TOS_WIREFRAME",
"Graphic3d_TOTF_BILINEAR",
"Graphic3d_TOTF_NEAREST",
"Graphic3d_TOTF_TRILINEAR",
"Graphic3d_TOTM_EYE",
"Graphic3d_TOTM_MANUAL",
"Graphic3d_TOTM_OBJECT",
"Graphic3d_TOTM_SPHERE",
"Graphic3d_TOTM_SPRITE",
"Graphic3d_TOT_1D",
"Graphic3d_TOT_2D",
"Graphic3d_TOT_2D_MIPMAP",
"Graphic3d_TOT_CUBEMAP",
"Graphic3d_TOV_SHADING",
"Graphic3d_TOV_WIREFRAME",
"Graphic3d_TP_DOWN",
"Graphic3d_TP_LEFT",
"Graphic3d_TP_RIGHT",
"Graphic3d_TP_UP",
"Graphic3d_TextureSetBits_BaseColor",
"Graphic3d_TextureSetBits_Emissive",
"Graphic3d_TextureSetBits_MetallicRoughness",
"Graphic3d_TextureSetBits_NONE",
"Graphic3d_TextureSetBits_Normal",
"Graphic3d_TextureSetBits_Occlusion",
"Graphic3d_TextureUnit_0",
"Graphic3d_TextureUnit_1",
"Graphic3d_TextureUnit_10",
"Graphic3d_TextureUnit_11",
"Graphic3d_TextureUnit_12",
"Graphic3d_TextureUnit_13",
"Graphic3d_TextureUnit_14",
"Graphic3d_TextureUnit_15",
"Graphic3d_TextureUnit_2",
"Graphic3d_TextureUnit_3",
"Graphic3d_TextureUnit_4",
"Graphic3d_TextureUnit_5",
"Graphic3d_TextureUnit_6",
"Graphic3d_TextureUnit_7",
"Graphic3d_TextureUnit_8",
"Graphic3d_TextureUnit_9",
"Graphic3d_TextureUnit_BaseColor",
"Graphic3d_TextureUnit_DepthPeelingDepth",
"Graphic3d_TextureUnit_DepthPeelingFrontColor",
"Graphic3d_TextureUnit_Emissive",
"Graphic3d_TextureUnit_EnvMap",
"Graphic3d_TextureUnit_MetallicRoughness",
"Graphic3d_TextureUnit_NB",
"Graphic3d_TextureUnit_Normal",
"Graphic3d_TextureUnit_Occlusion",
"Graphic3d_TextureUnit_PbrEnvironmentLUT",
"Graphic3d_TextureUnit_PbrIblDiffuseSH",
"Graphic3d_TextureUnit_PbrIblSpecular",
"Graphic3d_TextureUnit_PointSprite",
"Graphic3d_TextureUnit_ShadowMap",
"Graphic3d_ToneMappingMethod_Disabled",
"Graphic3d_ToneMappingMethod_Filmic",
"Graphic3d_TypeOfBackfacingModel_Auto",
"Graphic3d_TypeOfBackfacingModel_BackCulled",
"Graphic3d_TypeOfBackfacingModel_DoubleSided",
"Graphic3d_TypeOfBackfacingModel_FrontCulled",
"Graphic3d_TypeOfBackground_NB",
"Graphic3d_TypeOfLightSource_Ambient",
"Graphic3d_TypeOfLightSource_Directional",
"Graphic3d_TypeOfLightSource_NB",
"Graphic3d_TypeOfLightSource_Positional",
"Graphic3d_TypeOfLightSource_Spot",
"Graphic3d_TypeOfLimit_HasBlendedOit",
"Graphic3d_TypeOfLimit_HasBlendedOitMsaa",
"Graphic3d_TypeOfLimit_HasFlatShading",
"Graphic3d_TypeOfLimit_HasMeshEdges",
"Graphic3d_TypeOfLimit_HasPBR",
"Graphic3d_TypeOfLimit_HasRayTracing",
"Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling",
"Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic",
"Graphic3d_TypeOfLimit_HasRayTracingTextures",
"Graphic3d_TypeOfLimit_HasSRGB",
"Graphic3d_TypeOfLimit_IsWorkaroundFBO",
"Graphic3d_TypeOfLimit_MaxCombinedTextureUnits",
"Graphic3d_TypeOfLimit_MaxMsaa",
"Graphic3d_TypeOfLimit_MaxNbClipPlanes",
"Graphic3d_TypeOfLimit_MaxNbLights",
"Graphic3d_TypeOfLimit_MaxNbViews",
"Graphic3d_TypeOfLimit_MaxTextureSize",
"Graphic3d_TypeOfLimit_MaxViewDumpSizeX",
"Graphic3d_TypeOfLimit_MaxViewDumpSizeY",
"Graphic3d_TypeOfLimit_NB",
"Graphic3d_TypeOfReflection_NB",
"Graphic3d_TypeOfShadingModel_DEFAULT",
"Graphic3d_TypeOfShadingModel_Gouraud",
"Graphic3d_TypeOfShadingModel_NB",
"Graphic3d_TypeOfShadingModel_Pbr",
"Graphic3d_TypeOfShadingModel_PbrFacet",
"Graphic3d_TypeOfShadingModel_Phong",
"Graphic3d_TypeOfShadingModel_PhongFacet",
"Graphic3d_TypeOfShadingModel_Unlit",
"Graphic3d_TypeOfTexture_1D",
"Graphic3d_TypeOfTexture_2D",
"Graphic3d_TypeOfTexture_3D",
"Graphic3d_TypeOfTexture_CUBEMAP",
"Graphic3d_VTA_BOTTOM",
"Graphic3d_VTA_CENTER",
"Graphic3d_VTA_TOP",
"Graphic3d_VTA_TOPFIRSTLINE",
"Graphic3d_ZLayerId_BotOSD",
"Graphic3d_ZLayerId_Default",
"Graphic3d_ZLayerId_Top",
"Graphic3d_ZLayerId_TopOSD",
"Graphic3d_ZLayerId_Topmost",
"Graphic3d_ZLayerId_UNKNOWN",
"V3d_AMBIENT",
"V3d_COLOR",
"V3d_DIRECTIONAL",
"V3d_FLAT",
"V3d_GOURAUD",
"V3d_PHONG",
"V3d_POSITIONAL",
"V3d_SPOT",
"V3d_TOBM_ALWAYS_DISPLAYED",
"V3d_TOBM_AUTOMATIC",
"V3d_TOBM_NEVER_DISPLAYED"
]
class Graphic3d_AlphaMode():
    """
    Defines how alpha value of base color / texture should be treated.

    Members:

      Graphic3d_AlphaMode_Opaque

      Graphic3d_AlphaMode_Mask

      Graphic3d_AlphaMode_Blend

      Graphic3d_AlphaMode_MaskBlend

      Graphic3d_AlphaMode_BlendAuto
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_AlphaMode_Blend: OCP.Graphic3d.Graphic3d_AlphaMode # value = <Graphic3d_AlphaMode.Graphic3d_AlphaMode_Blend: 2>
    Graphic3d_AlphaMode_BlendAuto: OCP.Graphic3d.Graphic3d_AlphaMode # value = <Graphic3d_AlphaMode.Graphic3d_AlphaMode_BlendAuto: -1>
    Graphic3d_AlphaMode_Mask: OCP.Graphic3d.Graphic3d_AlphaMode # value = <Graphic3d_AlphaMode.Graphic3d_AlphaMode_Mask: 1>
    Graphic3d_AlphaMode_MaskBlend: OCP.Graphic3d.Graphic3d_AlphaMode # value = <Graphic3d_AlphaMode.Graphic3d_AlphaMode_MaskBlend: 3>
    Graphic3d_AlphaMode_Opaque: OCP.Graphic3d.Graphic3d_AlphaMode # value = <Graphic3d_AlphaMode.Graphic3d_AlphaMode_Opaque: 0>
    __entries: dict # value = {'Graphic3d_AlphaMode_Opaque': (<Graphic3d_AlphaMode.Graphic3d_AlphaMode_Opaque: 0>, None), 'Graphic3d_AlphaMode_Mask': (<Graphic3d_AlphaMode.Graphic3d_AlphaMode_Mask: 1>, None), 'Graphic3d_AlphaMode_Blend': (<Graphic3d_AlphaMode.Graphic3d_AlphaMode_Blend: 2>, None), 'Graphic3d_AlphaMode_MaskBlend': (<Graphic3d_AlphaMode.Graphic3d_AlphaMode_MaskBlend: 3>, None), 'Graphic3d_AlphaMode_BlendAuto': (<Graphic3d_AlphaMode.Graphic3d_AlphaMode_BlendAuto: -1>, None)}
    __members__: dict # value = {'Graphic3d_AlphaMode_Opaque': <Graphic3d_AlphaMode.Graphic3d_AlphaMode_Opaque: 0>, 'Graphic3d_AlphaMode_Mask': <Graphic3d_AlphaMode.Graphic3d_AlphaMode_Mask: 1>, 'Graphic3d_AlphaMode_Blend': <Graphic3d_AlphaMode.Graphic3d_AlphaMode_Blend: 2>, 'Graphic3d_AlphaMode_MaskBlend': <Graphic3d_AlphaMode.Graphic3d_AlphaMode_MaskBlend: 3>, 'Graphic3d_AlphaMode_BlendAuto': <Graphic3d_AlphaMode.Graphic3d_AlphaMode_BlendAuto: -1>}
    pass
class Graphic3d_Array1OfAttribute():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : Graphic3d_Array1OfAttribute) -> Graphic3d_Array1OfAttribute: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeFirst(self) -> Graphic3d_Attribute: 
        """
        Returns first element
        """
    def ChangeLast(self) -> Graphic3d_Attribute: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> Graphic3d_Attribute: 
        """
        Variable value access
        """
    def First(self) -> Graphic3d_Attribute: 
        """
        Returns first element
        """
    def Init(self,theValue : Graphic3d_Attribute) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Last(self) -> Graphic3d_Attribute: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : Graphic3d_Array1OfAttribute) -> Graphic3d_Array1OfAttribute: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : Graphic3d_Attribute) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> Graphic3d_Attribute: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> Graphic3d_Attribute: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_Array1OfAttribute) -> None: ...
    def __iter__(self) -> Iterator[Graphic3d_Attribute]: ...
    def __len__(self) -> int: ...
    pass
class Graphic3d_ArrayOfPrimitives(OCP.Standard.Standard_Transient):
    """
    This class furnish services to defined and fill an array of primitives which can be passed directly to graphics rendering API.This class furnish services to defined and fill an array of primitives which can be passed directly to graphics rendering API.This class furnish services to defined and fill an array of primitives which can be passed directly to graphics rendering API.
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfPolygons(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains polygons array definition. WARNING! Polygon primitives might be unsupported by graphics library. Triangulation should be used instead of quads for better compatibility.Contains polygons array definition. WARNING! Polygon primitives might be unsupported by graphics library. Triangulation should be used instead of quads for better compatibility.
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxBounds : int=0,theMaxEdges : int=0,theHasVNormals : bool=False,theHasVColors : bool=False,theHasBColors : bool=False,theHasVTexels : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfPolylines(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains polylines array definition.Contains polylines array definition.
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxBounds : int=0,theMaxEdges : int=0,theHasVColors : bool=False,theHasBColors : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfPoints(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains points array definition.Contains points array definition.
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theHasVColors : bool=False,theHasVNormals : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfQuadrangleStrips(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains quadrangles strip array definition. WARNING! Quadrangle primitives might be unsupported by graphics library. Triangulation should be used instead of quads for better compatibility.Contains quadrangles strip array definition. WARNING! Quadrangle primitives might be unsupported by graphics library. Triangulation should be used instead of quads for better compatibility.
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxStrips : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxStrips : int=0,theHasVNormals : bool=False,theHasVColors : bool=False,theHasSColors : bool=False,theHasVTexels : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfQuadrangles(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains quadrangles array definition. WARNING! Quadrangle primitives might be unsupported by graphics library. Triangulation should be used instead of quads for better compatibility.Contains quadrangles array definition. WARNING! Quadrangle primitives might be unsupported by graphics library. Triangulation should be used instead of quads for better compatibility.
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxEdges : int=0,theHasVNormals : bool=False,theHasVColors : bool=False,theHasVTexels : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfSegments(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains segments array definition.Contains segments array definition.
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxEdges : int=0,theHasVColors : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfTriangleFans(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains triangles fan array definitionContains triangles fan array definition
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxFans : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxFans : int=0,theHasVNormals : bool=False,theHasVColors : bool=False,theHasBColors : bool=False,theHasVTexels : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfTriangleStrips(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains triangles strip array definition.Contains triangles strip array definition.
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxStrips : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxStrips : int=0,theHasVNormals : bool=False,theHasVColors : bool=False,theHasBColors : bool=False,theHasVTexels : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ArrayOfTriangles(Graphic3d_ArrayOfPrimitives, OCP.Standard.Standard_Transient):
    """
    Contains triangles array definitionContains triangles array definition
    """
    @overload
    def AddBound(self,theEdgeNumber : int) -> int: 
        """
        Adds a bound of length theEdgeNumber in the bound array

        Adds a bound of length theEdgeNumber and bound color theBColor in the bound array. Warning: theBColor is ignored when the hasBColors constructor parameter is FALSE

        Adds a bound of length theEdgeNumber and bound color coordinates in the bound array. Warning: <theR,theG,theB> are ignored when the hasBColors constructor parameter is FALSE
        """
    @overload
    def AddBound(self,theEdgeNumber : int,theBColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddBound(self,theEdgeNumber : int,theR : float,theG : float,theB : float) -> int: ...
    def AddEdge(self,theVertexIndex : int) -> int: 
        """
        Adds an edge in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array.

        Convenience method, adds three vertex indices (a triangle) in the range [1,VertexNumber()] in the array.

        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array.
        """
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: ...
    @overload
    def AddEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: ...
    def AddPolylineEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add line strip (polyline) into indexed segments array. N-1 segments are added from N input nodes (or N with closed flag). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    def AddQuadEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds four vertex indices (a quad) in the range [1,VertexNumber()] in the array of quads. Raises exception if array is not of type Graphic3d_TOPA_QUADRANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int,theVertexIndex4 : int) -> int: 
        """
        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds quad indices in the range [1,VertexNumber()] into array or triangles as two triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddQuadTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddSegmentEdges(self,theVertexIndex1 : int,theVertexIndex2 : int) -> int: 
        """
        Convenience method, adds two vertex indices (a segment) in the range [1,VertexNumber()] in the array of segments (Graphic3d_TOPA_SEGMENTS). Raises exception if array is not of type Graphic3d_TOPA_SEGMENTS.
        """
    @overload
    def AddTriangleEdges(self,theVertexIndex1 : int,theVertexIndex2 : int,theVertexIndex3 : int) -> int: 
        """
        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.

        Convenience method, adds three vertex indices (4th component is ignored) of triangle in the range [1,VertexNumber()] in the array of triangles. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec3i) -> int: ...
    @overload
    def AddTriangleEdges(self,theIndexes : Graphic3d_Vec4i) -> int: ...
    def AddTriangleFanEdges(self,theVertexLower : int,theVertexUpper : int,theToClose : bool) -> None: 
        """
        Add triangle fan into indexed triangulation array. N-2 triangles are added from N input nodes (or N-1 with closed flag). Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    def AddTriangleStripEdges(self,theVertexLower : int,theVertexUpper : int) -> None: 
        """
        Add triangle strip into indexed triangulation array. N-2 triangles are added from N input nodes. Raises exception if array is not of type Graphic3d_TOPA_TRIANGLES.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt) -> int: 
        """
        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice in the array.

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex color in the vertex array. Warning: theColor is ignored when the hasVColors constructor parameter is FALSE

        Adds a vertice and vertex normal in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice and vertex normal in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice,vertex normal and color in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theColor is ignored when the hasVColors constructor parameter is FALSE.

        Adds a vertice and vertex texture in the vertex array. theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice and vertex texture coordinates in the vertex array. Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: theNormal is ignored when the hasVNormals constructor parameter is FALSE and theTexel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.

        Adds a vertice,vertex normal and texture in the vertex array. Warning: Normal is ignored when the hasVNormals constructor parameter is FALSE and Texel is ignored when the hasVTexels constructor parameter is FALSE.
        """
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Vec3f) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theColor : Graphic3d_Vec4ub) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor : OCP.Quantity.Quantity_Color) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theColor32 : int) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theTX : float,theTY : float) -> int: ...
    @overload
    def AddVertex(self,theVertex : OCP.gp.gp_Pnt,theNormal : OCP.gp.gp_Dir,theTexel : OCP.gp.gp_Pnt2d) -> int: ...
    @overload
    def AddVertex(self,theX : float,theY : float,theZ : float,theNX : float,theNY : float,theNZ : float,theTX : float,theTY : float) -> int: ...
    def Attributes(self) -> Graphic3d_Buffer: 
        """
        Returns vertex attributes buffer (colors, normals, texture coordinates).
        """
    def Bound(self,theRank : int) -> int: 
        """
        Returns the edge number at rank theRank.
        """
    @overload
    def BoundColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the bound color at rank theRank from the bound table if defined.

        Returns the bound color values at rank theRank from the bound table if defined.
        """
    @overload
    def BoundColor(self,theRank : int) -> tuple[float, float, float]: ...
    def BoundNumber(self) -> int: 
        """
        Returns the number of defined bounds
        """
    def BoundNumberAllocated(self) -> int: 
        """
        Returns the number of allocated bounds
        """
    def Bounds(self) -> Graphic3d_BoundBuffer: 
        """
        primitives / assigning colors) Returns optional bounds buffer.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: 
        """
        Create an array of specified type.

        Create an array of specified type.
        """
    @staticmethod
    @overload
    def CreateArray_s(theType : Graphic3d_TypeOfPrimitiveArray,theMaxVertexs : int,theMaxBounds : int,theMaxEdges : int,theArrayFlags : int) -> Graphic3d_ArrayOfPrimitives: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theRank : int) -> int: 
        """
        Returns the vertex index at rank theRank in the range [1,EdgeNumber()]
        """
    def EdgeNumber(self) -> int: 
        """
        Returns the number of defined edges
        """
    def EdgeNumberAllocated(self) -> int: 
        """
        Returns the number of allocated edges
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBoundColors(self) -> bool: 
        """
        Returns TRUE when bound colors array is defined.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns TRUE when vertex colors array is defined.
        """
    def HasVertexNormals(self) -> bool: 
        """
        Returns TRUE when vertex normals array is defined.
        """
    def HasVertexTexels(self) -> bool: 
        """
        Returns TRUE when vertex texels array is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Indices(self) -> Graphic3d_IndexBuffer: 
        """
        Returns optional index buffer.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsValid(self) -> bool: 
        """
        Returns TRUE only when the contains of this array is available.
        """
    def ItemNumber(self) -> int: 
        """
        Returns the number of total items according to the array type.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the bound color of rank theIndex in the array.

        Change the bound color of rank theIndex in the array.
        """
    @overload
    def SetBoundColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.

        Change the vertex color in the array.
        """
    @overload
    def SetVertexColor(self,theIndex : int,theR : float,theG : float,theB : float) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def SetVertexColor(self,theIndex : int,theColor32 : int) -> None: ...
    @overload
    def SetVertexNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: 
        """
        Change the vertex normal in the array.

        Change the vertex normal in the array.
        """
    @overload
    def SetVertexNormal(self,theIndex : int,theNX : float,theNY : float,theNZ : float) -> None: ...
    @overload
    def SetVertexTexel(self,theIndex : int,theTexel : OCP.gp.gp_Pnt2d) -> None: 
        """
        Change the vertex texel in the array.

        Change the vertex texel in the array.
        """
    @overload
    def SetVertexTexel(self,theIndex : int,theTX : float,theTY : float) -> None: ...
    @overload
    def SetVertice(self,theIndex : int,theVertex : OCP.gp.gp_Pnt) -> None: 
        """
        Change the vertice of rank theIndex in the array.

        Change the vertice in the array.
        """
    @overload
    def SetVertice(self,theIndex : int,theX : float,theY : float,theZ : float) -> None: ...
    def StringType(self) -> str: 
        """
        Returns the string type of this primitive
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfPrimitiveArray: 
        """
        Returns the type of this primitive
        """
    @overload
    def VertexColor(self,theRank : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the vertex color at rank theRank from the vertex table if defined.

        Returns the vertex color from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.

        Returns the vertex color values from the vertex table if defined.
        """
    @overload
    def VertexColor(self,theIndex : int,theColor : Graphic3d_Vec4ub) -> None: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def VertexColor(self,theRank : int) -> tuple[int]: ...
    @overload
    def VertexNormal(self,theRank : int) -> OCP.gp.gp_Dir: 
        """
        Returns the vertex normal from the vertex table if defined.

        Returns the vertex normal coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexNormal(self,theRank : int) -> tuple[float, float, float]: ...
    def VertexNumber(self) -> int: 
        """
        Returns the number of defined vertex
        """
    def VertexNumberAllocated(self) -> int: 
        """
        Returns the number of allocated vertex
        """
    @overload
    def VertexTexel(self,theRank : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns the vertex texture at rank theRank from the vertex table if defined.

        Returns the vertex texture coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def VertexTexel(self,theRank : int) -> tuple[float, float]: ...
    @overload
    def Vertice(self,theRank : int) -> OCP.gp.gp_Pnt: 
        """
        Returns the vertice from the vertex table if defined.

        Returns the vertice coordinates at rank theRank from the vertex table if defined.
        """
    @overload
    def Vertice(self,theRank : int) -> tuple[float, float, float]: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxEdges : int,theArrayFlags : int) -> None: ...
    @overload
    def __init__(self,theMaxVertexs : int,theMaxEdges : int=0,theHasVNormals : bool=False,theHasVColors : bool=False,theHasVTexels : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Aspects(OCP.Standard.Standard_Transient):
    """
    This class defines graphic attributes.This class defines graphic attributes.
    """
    def AllowBackFace(self) -> None: ...
    def AlphaCutoff(self) -> float: 
        """
        Returns alpha cutoff threshold, for discarding fragments within Graphic3d_AlphaMode_Mask mode (0.5 by default). If the alpha value is greater than or equal to this value then it is rendered as fully opaque, otherwise, it is rendered as fully transparent.
        """
    def AlphaMode(self) -> Graphic3d_AlphaMode: 
        """
        Returns the way how alpha value should be treated (Graphic3d_AlphaMode_BlendAuto by default, for backward compatibility).
        """
    def BackFace(self) -> bool: ...
    def BackInteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return back interior color.
        """
    def BackInteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return back interior color.
        """
    def BackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeBackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeFrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return the color.
        """
    def ColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color
        """
    def ColorSubTitle(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return text background/shadow color; equals to EdgeColor() property.
        """
    def ColorSubTitleRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Returns text background/shadow color; equals to EdgeColor() property.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultLinePatternForType_s(theType : OCP.Aspect.Aspect_TypeOfLine) -> int: 
        """
        Return stipple line pattern for line type.
        """
    @staticmethod
    def DefaultLineTypeForPattern_s(thePattern : int) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type for stipple line pattern.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Distinguish(self) -> bool: 
        """
        Returns true if material properties should be distinguished for back and front faces (false by default).
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EdgeColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return color of edges.
        """
    def EdgeColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color of edges.
        """
    def EdgeLineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return edges line type (same as LineType()).
        """
    def EdgeWidth(self) -> float: 
        """
        Return width for edges in pixels (same as LineWidth()).
        """
    def FaceCulling(self) -> Graphic3d_TypeOfBackfacingModel: 
        """
        Return face culling mode; Graphic3d_FaceCulling_BackClosed by default. A back-facing polygon is defined as a polygon whose vertices are in a clockwise order with respect to screen coordinates.
        """
    def FrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HatchStyle(self) -> Graphic3d_HatchStyle: 
        """
        Returns the hatch type used when InteriorStyle is IS_HATCH
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return interior color.
        """
    def InteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return interior color.
        """
    def InteriorStyle(self) -> OCP.Aspect.Aspect_InteriorStyle: 
        """
        Return interior rendering style; Aspect_IS_SOLID by default.
        """
    def IsEqual(self,theOther : Graphic3d_Aspects) -> bool: 
        """
        Check for equality with another aspects.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMarkerSprite(self) -> bool: 
        """
        Returns TRUE if marker should be drawn using marker sprite (either user-provided or generated).
        """
    def IsTextZoomable(self) -> bool: 
        """
        Returns TRUE when the Text Zoomable is on.
        """
    def LinePattern(self) -> int: 
        """
        Return custom stipple line pattern; 0xFFFF by default.
        """
    def LineStippleFactor(self) -> int: 
        """
        Return a multiplier for each bit in the line stipple pattern within [1, 256] range; 1 by default.
        """
    def LineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type; Aspect_TOL_SOLID by default.
        """
    def LineWidth(self) -> float: 
        """
        Return width for edges in pixels; 1.0 by default.
        """
    def MarkerImage(self) -> Graphic3d_MarkerImage: 
        """
        Returns marker's image texture. Could be null handle if marker aspect has been initialized as default type of marker.
        """
    def MarkerScale(self) -> float: 
        """
        Return marker scale factor; 1.0 by default.
        """
    def MarkerType(self) -> OCP.Aspect.Aspect_TypeOfMarker: 
        """
        Return marker type; Aspect_TOM_POINT by default.
        """
    def PolygonOffset(self) -> Graphic3d_PolygonOffset: 
        """
        Returns current polygon offsets settings.
        """
    def PolygonOffsets(self,theFactor : float,theUnits : float) -> tuple[int]: 
        """
        Returns current polygon offsets settings.
        """
    def SetAlphaMode(self,theMode : Graphic3d_AlphaMode,theAlphaCutoff : float=0.5) -> None: 
        """
        Defines the way how alpha value should be treated.
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the back face

        Modifies the color of the interior of the back face
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetBackMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of internal faces
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies text background/shadow color; equals to EdgeColor() property.

        Modifies text background/shadow color; equals to EdgeColor() property.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetDistinguish(self,toDistinguish : bool) -> None: 
        """
        Set material distinction between front and back faces.
        """
    def SetDistinguishOff(self) -> None: 
        """
        Forbids material distinction between front and back faces.
        """
    def SetDistinguishOn(self) -> None: 
        """
        Allows material distinction between front and back faces.
        """
    def SetDrawEdges(self,theToDraw : bool) -> None: 
        """
        Set if mesh edges should be drawn or not.
        """
    def SetDrawSilhouette(self,theToDraw : bool) -> None: 
        """
        Enables/disables drawing silhouette (outline).
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the edge of the face

        Modifies the color of the edge of the face
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetEdgeLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the edge line type (same as SetLineType())
        """
    def SetEdgeOff(self) -> None: 
        """
        The edges of FillAreas are not drawn.
        """
    def SetEdgeOn(self) -> None: 
        """
        The edges of FillAreas are drawn.
        """
    def SetEdgeWidth(self,theWidth : float) -> None: 
        """
        Modifies the edge thickness (same as SetLineWidth())
        """
    def SetFaceCulling(self,theCulling : Graphic3d_TypeOfBackfacingModel) -> None: 
        """
        Set face culling mode.
        """
    def SetFrontMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of external faces
        """
    @overload
    def SetHatchStyle(self,theStyle : Graphic3d_HatchStyle) -> None: 
        """
        Modifies the hatch type used when InteriorStyle is IS_HATCH

        Modifies the hatch type used when InteriorStyle is IS_HATCH
        """
    @overload
    def SetHatchStyle(self,theStyle : OCP.Aspect.Aspect_HatchStyle) -> None: ...
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the face

        Modifies the color of the interior of the face
        """
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetInteriorStyle(self,theStyle : OCP.Aspect.Aspect_InteriorStyle) -> None: 
        """
        Modifies the interior type used for rendering
        """
    def SetLinePattern(self,thePattern : int) -> None: 
        """
        Modifies the stipple line pattern, and changes line type to Aspect_TOL_USERDEFINED for non-standard pattern.
        """
    def SetLineStippleFactor(self,theFactor : int) -> None: 
        """
        Set a multiplier for each bit in the line stipple pattern.
        """
    def SetLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the line type
        """
    def SetLineWidth(self,theWidth : float) -> None: 
        """
        Modifies the line thickness Warning: Raises Standard_OutOfRange if the width is a negative value.
        """
    def SetMarkerImage(self,theImage : Graphic3d_MarkerImage) -> None: 
        """
        Set marker's image texture.
        """
    def SetMarkerScale(self,theScale : float) -> None: 
        """
        Modifies the scale factor. Marker type Aspect_TOM_POINT is not affected by the marker size scale factor. It is always the smallest displayable dot. Warning: Raises Standard_OutOfRange if the scale is a negative value.
        """
    def SetMarkerType(self,theType : OCP.Aspect.Aspect_TypeOfMarker) -> None: 
        """
        Modifies the type of marker.
        """
    def SetPolygonOffset(self,theOffset : Graphic3d_PolygonOffset) -> None: 
        """
        Sets polygon offsets settings.
        """
    def SetPolygonOffsets(self,theMode : int,theFactor : float=1.0,theUnits : float=0.0) -> None: 
        """
        Sets up OpenGL polygon offsets mechanism. <aMode> parameter can contain various combinations of Aspect_PolygonOffsetMode enumeration elements (Aspect_POM_None means that polygon offsets are not changed). If <aMode> is different from Aspect_POM_Off and Aspect_POM_None, then <aFactor> and <aUnits> arguments are used by graphic renderer to calculate a depth offset value:
        """
    def SetShaderProgram(self,theProgram : Graphic3d_ShaderProgram) -> None: 
        """
        Sets up OpenGL/GLSL shader program.
        """
    def SetShadingModel(self,theShadingModel : Graphic3d_TypeOfShadingModel) -> None: 
        """
        Sets shading model
        """
    def SetSkipFirstEdge(self,theToSkipFirstEdge : bool) -> None: 
        """
        Set skip first triangle edge flag for drawing wireframe presentation of quads array split into triangles.
        """
    def SetSuppressBackFaces(self,theToSuppress : bool) -> None: ...
    def SetTextAngle(self,theAngle : float) -> None: 
        """
        Turns usage of text rotated
        """
    def SetTextDisplayType(self,theType : OCP.Aspect.Aspect_TypeOfDisplayText) -> None: 
        """
        Sets display type.
        """
    def SetTextFont(self,theFont : OCP.TCollection.TCollection_HAsciiString) -> None: 
        """
        Modifies the font.
        """
    def SetTextFontAspect(self,theFontAspect : OCP.Font.Font_FontAspect) -> None: 
        """
        Turns usage of Aspect text
        """
    def SetTextStyle(self,theStyle : OCP.Aspect.Aspect_TypeOfStyleText) -> None: 
        """
        Modifies the style of the text.
        """
    def SetTextZoomable(self,theFlag : bool) -> None: 
        """
        Turns usage of text zoomable on/off
        """
    def SetTextureMap(self,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Assign texture to be mapped. See also SetTextureMapOn() to actually activate texture mapping.
        """
    def SetTextureMapOff(self) -> None: 
        """
        Disable texture mapping.
        """
    @overload
    def SetTextureMapOn(self,theToMap : bool) -> None: 
        """
        Enable or disable texture mapping (has no effect if texture is not set).

        Enable texture mapping (has no effect if texture is not set).
        """
    @overload
    def SetTextureMapOn(self) -> None: ...
    def SetTextureSet(self,theTextures : Graphic3d_TextureSet) -> None: 
        """
        Setup texture array to be mapped.
        """
    def ShaderProgram(self) -> Graphic3d_ShaderProgram: 
        """
        Return shader program.
        """
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel: 
        """
        Returns shading model; Graphic3d_TypeOfShadingModel_DEFAULT by default. Graphic3d_TOSM_DEFAULT means that Shading Model set as default for entire Viewer will be used.
        """
    def SuppressBackFace(self) -> None: ...
    def TextAngle(self) -> float: 
        """
        Returns Angle of degree
        """
    def TextDisplayType(self) -> OCP.Aspect.Aspect_TypeOfDisplayText: 
        """
        Returns display type; Aspect_TODT_NORMAL by default.
        """
    def TextFont(self) -> OCP.TCollection.TCollection_HAsciiString: 
        """
        Returns the font; NULL string by default.
        """
    def TextFontAspect(self) -> OCP.Font.Font_FontAspect: 
        """
        Returns text FontAspect
        """
    def TextStyle(self) -> OCP.Aspect.Aspect_TypeOfStyleText: 
        """
        Returns the text style; Aspect_TOST_NORMAL by default.
        """
    def TextureMap(self) -> Graphic3d_TextureMap: 
        """
        Return texture to be mapped.
        """
    def TextureMapState(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def TextureSet(self) -> Graphic3d_TextureSet: 
        """
        Return texture array to be mapped.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToDrawEdges(self) -> bool: 
        """
        Returns true if mesh edges should be drawn (false by default).
        """
    def ToDrawSilhouette(self) -> bool: 
        """
        Returns TRUE if silhouette (outline) should be drawn (with edge color and width); FALSE by default.
        """
    def ToMapTexture(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def ToSkipFirstEdge(self) -> bool: 
        """
        Returns TRUE if drawing element edges should discard first edge in triangle; FALSE by default. Graphics hardware works mostly with triangles, so that wireframe presentation will draw triangle edges by default. This flag allows rendering wireframe presentation of quad-only array split into triangles. For this, quads should be split in specific order, so that the quad diagonal (to be NOT rendered) goes first: 1------2 / / Triangle #1: 2-0-1; Triangle #2: 0-2-3 0------3
        """
    def ToSuppressBackFaces(self) -> bool: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_AspectLine3d(Graphic3d_Aspects, OCP.Standard.Standard_Transient):
    """
    Creates and updates a group of attributes for 3d line primitives. This group contains the color, the type of line, and its thickness.Creates and updates a group of attributes for 3d line primitives. This group contains the color, the type of line, and its thickness.
    """
    def AllowBackFace(self) -> None: ...
    def AlphaCutoff(self) -> float: 
        """
        Returns alpha cutoff threshold, for discarding fragments within Graphic3d_AlphaMode_Mask mode (0.5 by default). If the alpha value is greater than or equal to this value then it is rendered as fully opaque, otherwise, it is rendered as fully transparent.
        """
    def AlphaMode(self) -> Graphic3d_AlphaMode: 
        """
        Returns the way how alpha value should be treated (Graphic3d_AlphaMode_BlendAuto by default, for backward compatibility).
        """
    def BackFace(self) -> bool: ...
    def BackInteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return back interior color.
        """
    def BackInteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return back interior color.
        """
    def BackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeBackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeFrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return the color.
        """
    def ColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color
        """
    def ColorSubTitle(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return text background/shadow color; equals to EdgeColor() property.
        """
    def ColorSubTitleRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Returns text background/shadow color; equals to EdgeColor() property.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultLinePatternForType_s(theType : OCP.Aspect.Aspect_TypeOfLine) -> int: 
        """
        Return stipple line pattern for line type.
        """
    @staticmethod
    def DefaultLineTypeForPattern_s(thePattern : int) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type for stipple line pattern.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Distinguish(self) -> bool: 
        """
        Returns true if material properties should be distinguished for back and front faces (false by default).
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EdgeColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return color of edges.
        """
    def EdgeColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color of edges.
        """
    def EdgeLineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return edges line type (same as LineType()).
        """
    def EdgeWidth(self) -> float: 
        """
        Return width for edges in pixels (same as LineWidth()).
        """
    def FaceCulling(self) -> Graphic3d_TypeOfBackfacingModel: 
        """
        Return face culling mode; Graphic3d_FaceCulling_BackClosed by default. A back-facing polygon is defined as a polygon whose vertices are in a clockwise order with respect to screen coordinates.
        """
    def FrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HatchStyle(self) -> Graphic3d_HatchStyle: 
        """
        Returns the hatch type used when InteriorStyle is IS_HATCH
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return interior color.
        """
    def InteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return interior color.
        """
    def InteriorStyle(self) -> OCP.Aspect.Aspect_InteriorStyle: 
        """
        Return interior rendering style; Aspect_IS_SOLID by default.
        """
    def IsEqual(self,theOther : Graphic3d_Aspects) -> bool: 
        """
        Check for equality with another aspects.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMarkerSprite(self) -> bool: 
        """
        Returns TRUE if marker should be drawn using marker sprite (either user-provided or generated).
        """
    def IsTextZoomable(self) -> bool: 
        """
        Returns TRUE when the Text Zoomable is on.
        """
    def LinePattern(self) -> int: 
        """
        Return custom stipple line pattern; 0xFFFF by default.
        """
    def LineStippleFactor(self) -> int: 
        """
        Return a multiplier for each bit in the line stipple pattern within [1, 256] range; 1 by default.
        """
    def LineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type; Aspect_TOL_SOLID by default.
        """
    def LineWidth(self) -> float: 
        """
        Return width for edges in pixels; 1.0 by default.
        """
    def MarkerImage(self) -> Graphic3d_MarkerImage: 
        """
        Returns marker's image texture. Could be null handle if marker aspect has been initialized as default type of marker.
        """
    def MarkerScale(self) -> float: 
        """
        Return marker scale factor; 1.0 by default.
        """
    def MarkerType(self) -> OCP.Aspect.Aspect_TypeOfMarker: 
        """
        Return marker type; Aspect_TOM_POINT by default.
        """
    def PolygonOffset(self) -> Graphic3d_PolygonOffset: 
        """
        Returns current polygon offsets settings.
        """
    def PolygonOffsets(self,theFactor : float,theUnits : float) -> tuple[int]: 
        """
        Returns current polygon offsets settings.
        """
    def SetAlphaMode(self,theMode : Graphic3d_AlphaMode,theAlphaCutoff : float=0.5) -> None: 
        """
        Defines the way how alpha value should be treated.
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the back face

        Modifies the color of the interior of the back face
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetBackMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of internal faces
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies text background/shadow color; equals to EdgeColor() property.

        Modifies text background/shadow color; equals to EdgeColor() property.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetDistinguish(self,toDistinguish : bool) -> None: 
        """
        Set material distinction between front and back faces.
        """
    def SetDistinguishOff(self) -> None: 
        """
        Forbids material distinction between front and back faces.
        """
    def SetDistinguishOn(self) -> None: 
        """
        Allows material distinction between front and back faces.
        """
    def SetDrawEdges(self,theToDraw : bool) -> None: 
        """
        Set if mesh edges should be drawn or not.
        """
    def SetDrawSilhouette(self,theToDraw : bool) -> None: 
        """
        Enables/disables drawing silhouette (outline).
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the edge of the face

        Modifies the color of the edge of the face
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetEdgeLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the edge line type (same as SetLineType())
        """
    def SetEdgeOff(self) -> None: 
        """
        The edges of FillAreas are not drawn.
        """
    def SetEdgeOn(self) -> None: 
        """
        The edges of FillAreas are drawn.
        """
    def SetEdgeWidth(self,theWidth : float) -> None: 
        """
        Modifies the edge thickness (same as SetLineWidth())
        """
    def SetFaceCulling(self,theCulling : Graphic3d_TypeOfBackfacingModel) -> None: 
        """
        Set face culling mode.
        """
    def SetFrontMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of external faces
        """
    @overload
    def SetHatchStyle(self,theStyle : Graphic3d_HatchStyle) -> None: 
        """
        Modifies the hatch type used when InteriorStyle is IS_HATCH

        Modifies the hatch type used when InteriorStyle is IS_HATCH
        """
    @overload
    def SetHatchStyle(self,theStyle : OCP.Aspect.Aspect_HatchStyle) -> None: ...
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the face

        Modifies the color of the interior of the face
        """
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetInteriorStyle(self,theStyle : OCP.Aspect.Aspect_InteriorStyle) -> None: 
        """
        Modifies the interior type used for rendering
        """
    def SetLinePattern(self,thePattern : int) -> None: 
        """
        Modifies the stipple line pattern, and changes line type to Aspect_TOL_USERDEFINED for non-standard pattern.
        """
    def SetLineStippleFactor(self,theFactor : int) -> None: 
        """
        Set a multiplier for each bit in the line stipple pattern.
        """
    def SetLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the line type
        """
    def SetLineWidth(self,theWidth : float) -> None: 
        """
        Modifies the line thickness Warning: Raises Standard_OutOfRange if the width is a negative value.
        """
    def SetMarkerImage(self,theImage : Graphic3d_MarkerImage) -> None: 
        """
        Set marker's image texture.
        """
    def SetMarkerScale(self,theScale : float) -> None: 
        """
        Modifies the scale factor. Marker type Aspect_TOM_POINT is not affected by the marker size scale factor. It is always the smallest displayable dot. Warning: Raises Standard_OutOfRange if the scale is a negative value.
        """
    def SetMarkerType(self,theType : OCP.Aspect.Aspect_TypeOfMarker) -> None: 
        """
        Modifies the type of marker.
        """
    def SetPolygonOffset(self,theOffset : Graphic3d_PolygonOffset) -> None: 
        """
        Sets polygon offsets settings.
        """
    def SetPolygonOffsets(self,theMode : int,theFactor : float=1.0,theUnits : float=0.0) -> None: 
        """
        Sets up OpenGL polygon offsets mechanism. <aMode> parameter can contain various combinations of Aspect_PolygonOffsetMode enumeration elements (Aspect_POM_None means that polygon offsets are not changed). If <aMode> is different from Aspect_POM_Off and Aspect_POM_None, then <aFactor> and <aUnits> arguments are used by graphic renderer to calculate a depth offset value:
        """
    def SetShaderProgram(self,theProgram : Graphic3d_ShaderProgram) -> None: 
        """
        Sets up OpenGL/GLSL shader program.
        """
    def SetShadingModel(self,theShadingModel : Graphic3d_TypeOfShadingModel) -> None: 
        """
        Sets shading model
        """
    def SetSkipFirstEdge(self,theToSkipFirstEdge : bool) -> None: 
        """
        Set skip first triangle edge flag for drawing wireframe presentation of quads array split into triangles.
        """
    def SetSuppressBackFaces(self,theToSuppress : bool) -> None: ...
    def SetTextAngle(self,theAngle : float) -> None: 
        """
        Turns usage of text rotated
        """
    def SetTextDisplayType(self,theType : OCP.Aspect.Aspect_TypeOfDisplayText) -> None: 
        """
        Sets display type.
        """
    def SetTextFont(self,theFont : OCP.TCollection.TCollection_HAsciiString) -> None: 
        """
        Modifies the font.
        """
    def SetTextFontAspect(self,theFontAspect : OCP.Font.Font_FontAspect) -> None: 
        """
        Turns usage of Aspect text
        """
    def SetTextStyle(self,theStyle : OCP.Aspect.Aspect_TypeOfStyleText) -> None: 
        """
        Modifies the style of the text.
        """
    def SetTextZoomable(self,theFlag : bool) -> None: 
        """
        Turns usage of text zoomable on/off
        """
    def SetTextureMap(self,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Assign texture to be mapped. See also SetTextureMapOn() to actually activate texture mapping.
        """
    def SetTextureMapOff(self) -> None: 
        """
        Disable texture mapping.
        """
    @overload
    def SetTextureMapOn(self,theToMap : bool) -> None: 
        """
        Enable or disable texture mapping (has no effect if texture is not set).

        Enable texture mapping (has no effect if texture is not set).
        """
    @overload
    def SetTextureMapOn(self) -> None: ...
    def SetTextureSet(self,theTextures : Graphic3d_TextureSet) -> None: 
        """
        Setup texture array to be mapped.
        """
    def SetType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the type of line.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Modifies the line thickness. Warning: Raises Standard_OutOfRange if the width is a negative value.

        Modifies the line thickness. Warning: Raises Standard_OutOfRange if the width is a negative value.
        """
    def ShaderProgram(self) -> Graphic3d_ShaderProgram: 
        """
        Return shader program.
        """
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel: 
        """
        Returns shading model; Graphic3d_TypeOfShadingModel_DEFAULT by default. Graphic3d_TOSM_DEFAULT means that Shading Model set as default for entire Viewer will be used.
        """
    def SuppressBackFace(self) -> None: ...
    def TextAngle(self) -> float: 
        """
        Returns Angle of degree
        """
    def TextDisplayType(self) -> OCP.Aspect.Aspect_TypeOfDisplayText: 
        """
        Returns display type; Aspect_TODT_NORMAL by default.
        """
    def TextFont(self) -> OCP.TCollection.TCollection_HAsciiString: 
        """
        Returns the font; NULL string by default.
        """
    def TextFontAspect(self) -> OCP.Font.Font_FontAspect: 
        """
        Returns text FontAspect
        """
    def TextStyle(self) -> OCP.Aspect.Aspect_TypeOfStyleText: 
        """
        Returns the text style; Aspect_TOST_NORMAL by default.
        """
    def TextureMap(self) -> Graphic3d_TextureMap: 
        """
        Return texture to be mapped.
        """
    def TextureMapState(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def TextureSet(self) -> Graphic3d_TextureSet: 
        """
        Return texture array to be mapped.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToDrawEdges(self) -> bool: 
        """
        Returns true if mesh edges should be drawn (false by default).
        """
    def ToDrawSilhouette(self) -> bool: 
        """
        Returns TRUE if silhouette (outline) should be drawn (with edge color and width); FALSE by default.
        """
    def ToMapTexture(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def ToSkipFirstEdge(self) -> bool: 
        """
        Returns TRUE if drawing element edges should discard first edge in triangle; FALSE by default. Graphics hardware works mostly with triangles, so that wireframe presentation will draw triangle edges by default. This flag allows rendering wireframe presentation of quad-only array split into triangles. For this, quads should be split in specific order, so that the quad diagonal (to be NOT rendered) goes first: 1------2 / / Triangle #1: 2-0-1; Triangle #2: 0-2-3 0------3
        """
    def ToSuppressBackFaces(self) -> bool: ...
    def Type(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type.
        """
    def Width(self) -> float: 
        """
        Return line width.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theColor : OCP.Quantity.Quantity_Color,theType : OCP.Aspect.Aspect_TypeOfLine,theWidth : float) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_AspectMarker3d(Graphic3d_Aspects, OCP.Standard.Standard_Transient):
    """
    Creates and updates an attribute group for marker type primitives. This group contains the type of marker, its color, and its scale factor.Creates and updates an attribute group for marker type primitives. This group contains the type of marker, its color, and its scale factor.
    """
    def AllowBackFace(self) -> None: ...
    def AlphaCutoff(self) -> float: 
        """
        Returns alpha cutoff threshold, for discarding fragments within Graphic3d_AlphaMode_Mask mode (0.5 by default). If the alpha value is greater than or equal to this value then it is rendered as fully opaque, otherwise, it is rendered as fully transparent.
        """
    def AlphaMode(self) -> Graphic3d_AlphaMode: 
        """
        Returns the way how alpha value should be treated (Graphic3d_AlphaMode_BlendAuto by default, for backward compatibility).
        """
    def BackFace(self) -> bool: ...
    def BackInteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return back interior color.
        """
    def BackInteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return back interior color.
        """
    def BackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeBackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeFrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return the color.
        """
    def ColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color
        """
    def ColorSubTitle(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return text background/shadow color; equals to EdgeColor() property.
        """
    def ColorSubTitleRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Returns text background/shadow color; equals to EdgeColor() property.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultLinePatternForType_s(theType : OCP.Aspect.Aspect_TypeOfLine) -> int: 
        """
        Return stipple line pattern for line type.
        """
    @staticmethod
    def DefaultLineTypeForPattern_s(thePattern : int) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type for stipple line pattern.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Distinguish(self) -> bool: 
        """
        Returns true if material properties should be distinguished for back and front faces (false by default).
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EdgeColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return color of edges.
        """
    def EdgeColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color of edges.
        """
    def EdgeLineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return edges line type (same as LineType()).
        """
    def EdgeWidth(self) -> float: 
        """
        Return width for edges in pixels (same as LineWidth()).
        """
    def FaceCulling(self) -> Graphic3d_TypeOfBackfacingModel: 
        """
        Return face culling mode; Graphic3d_FaceCulling_BackClosed by default. A back-facing polygon is defined as a polygon whose vertices are in a clockwise order with respect to screen coordinates.
        """
    def FrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def GetMarkerImage(self) -> Graphic3d_MarkerImage: 
        """
        Returns marker's image texture. Could be null handle if marker aspect has been initialized as default type of marker.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetTextureSize(self) -> tuple[int, int]: 
        """
        Returns marker's texture size.
        """
    def HatchStyle(self) -> Graphic3d_HatchStyle: 
        """
        Returns the hatch type used when InteriorStyle is IS_HATCH
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return interior color.
        """
    def InteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return interior color.
        """
    def InteriorStyle(self) -> OCP.Aspect.Aspect_InteriorStyle: 
        """
        Return interior rendering style; Aspect_IS_SOLID by default.
        """
    def IsEqual(self,theOther : Graphic3d_Aspects) -> bool: 
        """
        Check for equality with another aspects.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMarkerSprite(self) -> bool: 
        """
        Returns TRUE if marker should be drawn using marker sprite (either user-provided or generated).
        """
    def IsTextZoomable(self) -> bool: 
        """
        Returns TRUE when the Text Zoomable is on.
        """
    def LinePattern(self) -> int: 
        """
        Return custom stipple line pattern; 0xFFFF by default.
        """
    def LineStippleFactor(self) -> int: 
        """
        Return a multiplier for each bit in the line stipple pattern within [1, 256] range; 1 by default.
        """
    def LineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type; Aspect_TOL_SOLID by default.
        """
    def LineWidth(self) -> float: 
        """
        Return width for edges in pixels; 1.0 by default.
        """
    def MarkerImage(self) -> Graphic3d_MarkerImage: 
        """
        Returns marker's image texture. Could be null handle if marker aspect has been initialized as default type of marker.
        """
    def MarkerScale(self) -> float: 
        """
        Return marker scale factor; 1.0 by default.
        """
    def MarkerType(self) -> OCP.Aspect.Aspect_TypeOfMarker: 
        """
        Return marker type; Aspect_TOM_POINT by default.
        """
    def PolygonOffset(self) -> Graphic3d_PolygonOffset: 
        """
        Returns current polygon offsets settings.
        """
    def PolygonOffsets(self,theFactor : float,theUnits : float) -> tuple[int]: 
        """
        Returns current polygon offsets settings.
        """
    def Scale(self) -> float: 
        """
        Return scale factor.
        """
    def SetAlphaMode(self,theMode : Graphic3d_AlphaMode,theAlphaCutoff : float=0.5) -> None: 
        """
        Defines the way how alpha value should be treated.
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the back face

        Modifies the color of the interior of the back face
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetBackMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of internal faces
        """
    def SetBitMap(self,theWidth : int,theHeight : int,theTexture : OCP.TColStd.TColStd_HArray1OfByte) -> None: ...
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies text background/shadow color; equals to EdgeColor() property.

        Modifies text background/shadow color; equals to EdgeColor() property.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetDistinguish(self,toDistinguish : bool) -> None: 
        """
        Set material distinction between front and back faces.
        """
    def SetDistinguishOff(self) -> None: 
        """
        Forbids material distinction between front and back faces.
        """
    def SetDistinguishOn(self) -> None: 
        """
        Allows material distinction between front and back faces.
        """
    def SetDrawEdges(self,theToDraw : bool) -> None: 
        """
        Set if mesh edges should be drawn or not.
        """
    def SetDrawSilhouette(self,theToDraw : bool) -> None: 
        """
        Enables/disables drawing silhouette (outline).
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the edge of the face

        Modifies the color of the edge of the face
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetEdgeLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the edge line type (same as SetLineType())
        """
    def SetEdgeOff(self) -> None: 
        """
        The edges of FillAreas are not drawn.
        """
    def SetEdgeOn(self) -> None: 
        """
        The edges of FillAreas are drawn.
        """
    def SetEdgeWidth(self,theWidth : float) -> None: 
        """
        Modifies the edge thickness (same as SetLineWidth())
        """
    def SetFaceCulling(self,theCulling : Graphic3d_TypeOfBackfacingModel) -> None: 
        """
        Set face culling mode.
        """
    def SetFrontMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of external faces
        """
    @overload
    def SetHatchStyle(self,theStyle : Graphic3d_HatchStyle) -> None: 
        """
        Modifies the hatch type used when InteriorStyle is IS_HATCH

        Modifies the hatch type used when InteriorStyle is IS_HATCH
        """
    @overload
    def SetHatchStyle(self,theStyle : OCP.Aspect.Aspect_HatchStyle) -> None: ...
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the face

        Modifies the color of the interior of the face
        """
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetInteriorStyle(self,theStyle : OCP.Aspect.Aspect_InteriorStyle) -> None: 
        """
        Modifies the interior type used for rendering
        """
    def SetLinePattern(self,thePattern : int) -> None: 
        """
        Modifies the stipple line pattern, and changes line type to Aspect_TOL_USERDEFINED for non-standard pattern.
        """
    def SetLineStippleFactor(self,theFactor : int) -> None: 
        """
        Set a multiplier for each bit in the line stipple pattern.
        """
    def SetLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the line type
        """
    def SetLineWidth(self,theWidth : float) -> None: 
        """
        Modifies the line thickness Warning: Raises Standard_OutOfRange if the width is a negative value.
        """
    def SetMarkerImage(self,theImage : Graphic3d_MarkerImage) -> None: 
        """
        Set marker's image texture.
        """
    def SetMarkerScale(self,theScale : float) -> None: 
        """
        Modifies the scale factor. Marker type Aspect_TOM_POINT is not affected by the marker size scale factor. It is always the smallest displayable dot. Warning: Raises Standard_OutOfRange if the scale is a negative value.
        """
    def SetMarkerType(self,theType : OCP.Aspect.Aspect_TypeOfMarker) -> None: 
        """
        Modifies the type of marker.
        """
    def SetPolygonOffset(self,theOffset : Graphic3d_PolygonOffset) -> None: 
        """
        Sets polygon offsets settings.
        """
    def SetPolygonOffsets(self,theMode : int,theFactor : float=1.0,theUnits : float=0.0) -> None: 
        """
        Sets up OpenGL polygon offsets mechanism. <aMode> parameter can contain various combinations of Aspect_PolygonOffsetMode enumeration elements (Aspect_POM_None means that polygon offsets are not changed). If <aMode> is different from Aspect_POM_Off and Aspect_POM_None, then <aFactor> and <aUnits> arguments are used by graphic renderer to calculate a depth offset value:
        """
    def SetScale(self,theScale : float) -> None: 
        """
        Modifies the scale factor. Marker type Aspect_TOM_POINT is not affected by the marker size scale factor. It is always the smallest displayable dot. Warning: Raises Standard_OutOfRange if the scale is a negative value.

        Assign scale factor.
        """
    def SetShaderProgram(self,theProgram : Graphic3d_ShaderProgram) -> None: 
        """
        Sets up OpenGL/GLSL shader program.
        """
    def SetShadingModel(self,theShadingModel : Graphic3d_TypeOfShadingModel) -> None: 
        """
        Sets shading model
        """
    def SetSkipFirstEdge(self,theToSkipFirstEdge : bool) -> None: 
        """
        Set skip first triangle edge flag for drawing wireframe presentation of quads array split into triangles.
        """
    def SetSuppressBackFaces(self,theToSuppress : bool) -> None: ...
    def SetTextAngle(self,theAngle : float) -> None: 
        """
        Turns usage of text rotated
        """
    def SetTextDisplayType(self,theType : OCP.Aspect.Aspect_TypeOfDisplayText) -> None: 
        """
        Sets display type.
        """
    def SetTextFont(self,theFont : OCP.TCollection.TCollection_HAsciiString) -> None: 
        """
        Modifies the font.
        """
    def SetTextFontAspect(self,theFontAspect : OCP.Font.Font_FontAspect) -> None: 
        """
        Turns usage of Aspect text
        """
    def SetTextStyle(self,theStyle : OCP.Aspect.Aspect_TypeOfStyleText) -> None: 
        """
        Modifies the style of the text.
        """
    def SetTextZoomable(self,theFlag : bool) -> None: 
        """
        Turns usage of text zoomable on/off
        """
    def SetTextureMap(self,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Assign texture to be mapped. See also SetTextureMapOn() to actually activate texture mapping.
        """
    def SetTextureMapOff(self) -> None: 
        """
        Disable texture mapping.
        """
    @overload
    def SetTextureMapOn(self,theToMap : bool) -> None: 
        """
        Enable or disable texture mapping (has no effect if texture is not set).

        Enable texture mapping (has no effect if texture is not set).
        """
    @overload
    def SetTextureMapOn(self) -> None: ...
    def SetTextureSet(self,theTextures : Graphic3d_TextureSet) -> None: 
        """
        Setup texture array to be mapped.
        """
    def SetType(self,theType : OCP.Aspect.Aspect_TypeOfMarker) -> None: 
        """
        Modifies the type of marker.
        """
    def ShaderProgram(self) -> Graphic3d_ShaderProgram: 
        """
        Return shader program.
        """
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel: 
        """
        Returns shading model; Graphic3d_TypeOfShadingModel_DEFAULT by default. Graphic3d_TOSM_DEFAULT means that Shading Model set as default for entire Viewer will be used.
        """
    def SuppressBackFace(self) -> None: ...
    def TextAngle(self) -> float: 
        """
        Returns Angle of degree
        """
    def TextDisplayType(self) -> OCP.Aspect.Aspect_TypeOfDisplayText: 
        """
        Returns display type; Aspect_TODT_NORMAL by default.
        """
    def TextFont(self) -> OCP.TCollection.TCollection_HAsciiString: 
        """
        Returns the font; NULL string by default.
        """
    def TextFontAspect(self) -> OCP.Font.Font_FontAspect: 
        """
        Returns text FontAspect
        """
    def TextStyle(self) -> OCP.Aspect.Aspect_TypeOfStyleText: 
        """
        Returns the text style; Aspect_TOST_NORMAL by default.
        """
    def TextureMap(self) -> Graphic3d_TextureMap: 
        """
        Return texture to be mapped.
        """
    def TextureMapState(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def TextureSet(self) -> Graphic3d_TextureSet: 
        """
        Return texture array to be mapped.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToDrawEdges(self) -> bool: 
        """
        Returns true if mesh edges should be drawn (false by default).
        """
    def ToDrawSilhouette(self) -> bool: 
        """
        Returns TRUE if silhouette (outline) should be drawn (with edge color and width); FALSE by default.
        """
    def ToMapTexture(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def ToSkipFirstEdge(self) -> bool: 
        """
        Returns TRUE if drawing element edges should discard first edge in triangle; FALSE by default. Graphics hardware works mostly with triangles, so that wireframe presentation will draw triangle edges by default. This flag allows rendering wireframe presentation of quad-only array split into triangles. For this, quads should be split in specific order, so that the quad diagonal (to be NOT rendered) goes first: 1------2 / / Triangle #1: 2-0-1; Triangle #2: 0-2-3 0------3
        """
    def ToSuppressBackFaces(self) -> bool: ...
    def Type(self) -> OCP.Aspect.Aspect_TypeOfMarker: 
        """
        Return marker type.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theType : OCP.Aspect.Aspect_TypeOfMarker,theColor : OCP.Quantity.Quantity_Color,theScale : float) -> None: ...
    @overload
    def __init__(self,theColor : OCP.Quantity.Quantity_Color,theWidth : int,theHeight : int,theTextureBitmap : OCP.TColStd.TColStd_HArray1OfByte) -> None: ...
    @overload
    def __init__(self,theTextureImage : OCP.Image.Image_PixMap) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_AspectText3d(Graphic3d_Aspects, OCP.Standard.Standard_Transient):
    """
    Creates and updates a group of attributes for text primitives.Creates and updates a group of attributes for text primitives.
    """
    def AllowBackFace(self) -> None: ...
    def AlphaCutoff(self) -> float: 
        """
        Returns alpha cutoff threshold, for discarding fragments within Graphic3d_AlphaMode_Mask mode (0.5 by default). If the alpha value is greater than or equal to this value then it is rendered as fully opaque, otherwise, it is rendered as fully transparent.
        """
    def AlphaMode(self) -> Graphic3d_AlphaMode: 
        """
        Returns the way how alpha value should be treated (Graphic3d_AlphaMode_BlendAuto by default, for backward compatibility).
        """
    def BackFace(self) -> bool: ...
    def BackInteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return back interior color.
        """
    def BackInteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return back interior color.
        """
    def BackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeBackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeFrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return the text color.
        """
    def ColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return the text color.
        """
    def ColorSubTitle(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return text background/shadow color; equals to EdgeColor() property.
        """
    def ColorSubTitleRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Returns text background/shadow color; equals to EdgeColor() property.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultLinePatternForType_s(theType : OCP.Aspect.Aspect_TypeOfLine) -> int: 
        """
        Return stipple line pattern for line type.
        """
    @staticmethod
    def DefaultLineTypeForPattern_s(thePattern : int) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type for stipple line pattern.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayType(self) -> OCP.Aspect.Aspect_TypeOfDisplayText: 
        """
        Return display type.
        """
    def Distinguish(self) -> bool: 
        """
        Returns true if material properties should be distinguished for back and front faces (false by default).
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EdgeColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return color of edges.
        """
    def EdgeColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color of edges.
        """
    def EdgeLineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return edges line type (same as LineType()).
        """
    def EdgeWidth(self) -> float: 
        """
        Return width for edges in pixels (same as LineWidth()).
        """
    def FaceCulling(self) -> Graphic3d_TypeOfBackfacingModel: 
        """
        Return face culling mode; Graphic3d_FaceCulling_BackClosed by default. A back-facing polygon is defined as a polygon whose vertices are in a clockwise order with respect to screen coordinates.
        """
    def Font(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Return the font.
        """
    def FrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetTextAngle(self) -> float: 
        """
        Returns Angle of degree
        """
    def GetTextFontAspect(self) -> OCP.Font.Font_FontAspect: 
        """
        Returns text FontAspect
        """
    def GetTextZoomable(self) -> bool: 
        """
        Returns TRUE when the Text Zoomable is on.
        """
    def HatchStyle(self) -> Graphic3d_HatchStyle: 
        """
        Returns the hatch type used when InteriorStyle is IS_HATCH
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return interior color.
        """
    def InteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return interior color.
        """
    def InteriorStyle(self) -> OCP.Aspect.Aspect_InteriorStyle: 
        """
        Return interior rendering style; Aspect_IS_SOLID by default.
        """
    def IsEqual(self,theOther : Graphic3d_Aspects) -> bool: 
        """
        Check for equality with another aspects.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMarkerSprite(self) -> bool: 
        """
        Returns TRUE if marker should be drawn using marker sprite (either user-provided or generated).
        """
    def IsTextZoomable(self) -> bool: 
        """
        Returns TRUE when the Text Zoomable is on.
        """
    def LinePattern(self) -> int: 
        """
        Return custom stipple line pattern; 0xFFFF by default.
        """
    def LineStippleFactor(self) -> int: 
        """
        Return a multiplier for each bit in the line stipple pattern within [1, 256] range; 1 by default.
        """
    def LineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type; Aspect_TOL_SOLID by default.
        """
    def LineWidth(self) -> float: 
        """
        Return width for edges in pixels; 1.0 by default.
        """
    def MarkerImage(self) -> Graphic3d_MarkerImage: 
        """
        Returns marker's image texture. Could be null handle if marker aspect has been initialized as default type of marker.
        """
    def MarkerScale(self) -> float: 
        """
        Return marker scale factor; 1.0 by default.
        """
    def MarkerType(self) -> OCP.Aspect.Aspect_TypeOfMarker: 
        """
        Return marker type; Aspect_TOM_POINT by default.
        """
    def PolygonOffset(self) -> Graphic3d_PolygonOffset: 
        """
        Returns current polygon offsets settings.
        """
    def PolygonOffsets(self,theFactor : float,theUnits : float) -> tuple[int]: 
        """
        Returns current polygon offsets settings.
        """
    def SetAlphaMode(self,theMode : Graphic3d_AlphaMode,theAlphaCutoff : float=0.5) -> None: 
        """
        Defines the way how alpha value should be treated.
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the back face

        Modifies the color of the interior of the back face
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetBackMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of internal faces
        """
    @overload
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color.

        Modifies the color.
        """
    @overload
    def SetColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies text background/shadow color; equals to EdgeColor() property.

        Modifies text background/shadow color; equals to EdgeColor() property.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetDisplayType(self,theDisplayType : OCP.Aspect.Aspect_TypeOfDisplayText) -> None: 
        """
        Define the display type of the text.
        """
    def SetDistinguish(self,toDistinguish : bool) -> None: 
        """
        Set material distinction between front and back faces.
        """
    def SetDistinguishOff(self) -> None: 
        """
        Forbids material distinction between front and back faces.
        """
    def SetDistinguishOn(self) -> None: 
        """
        Allows material distinction between front and back faces.
        """
    def SetDrawEdges(self,theToDraw : bool) -> None: 
        """
        Set if mesh edges should be drawn or not.
        """
    def SetDrawSilhouette(self,theToDraw : bool) -> None: 
        """
        Enables/disables drawing silhouette (outline).
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the edge of the face

        Modifies the color of the edge of the face
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetEdgeLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the edge line type (same as SetLineType())
        """
    def SetEdgeOff(self) -> None: 
        """
        The edges of FillAreas are not drawn.
        """
    def SetEdgeOn(self) -> None: 
        """
        The edges of FillAreas are drawn.
        """
    def SetEdgeWidth(self,theWidth : float) -> None: 
        """
        Modifies the edge thickness (same as SetLineWidth())
        """
    def SetFaceCulling(self,theCulling : Graphic3d_TypeOfBackfacingModel) -> None: 
        """
        Set face culling mode.
        """
    @overload
    def SetFont(self,theFont : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Modifies the font.

        Modifies the font.
        """
    @overload
    def SetFont(self,theFont : str) -> None: ...
    def SetFrontMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of external faces
        """
    @overload
    def SetHatchStyle(self,theStyle : Graphic3d_HatchStyle) -> None: 
        """
        Modifies the hatch type used when InteriorStyle is IS_HATCH

        Modifies the hatch type used when InteriorStyle is IS_HATCH
        """
    @overload
    def SetHatchStyle(self,theStyle : OCP.Aspect.Aspect_HatchStyle) -> None: ...
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the face

        Modifies the color of the interior of the face
        """
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetInteriorStyle(self,theStyle : OCP.Aspect.Aspect_InteriorStyle) -> None: 
        """
        Modifies the interior type used for rendering
        """
    def SetLinePattern(self,thePattern : int) -> None: 
        """
        Modifies the stipple line pattern, and changes line type to Aspect_TOL_USERDEFINED for non-standard pattern.
        """
    def SetLineStippleFactor(self,theFactor : int) -> None: 
        """
        Set a multiplier for each bit in the line stipple pattern.
        """
    def SetLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the line type
        """
    def SetLineWidth(self,theWidth : float) -> None: 
        """
        Modifies the line thickness Warning: Raises Standard_OutOfRange if the width is a negative value.
        """
    def SetMarkerImage(self,theImage : Graphic3d_MarkerImage) -> None: 
        """
        Set marker's image texture.
        """
    def SetMarkerScale(self,theScale : float) -> None: 
        """
        Modifies the scale factor. Marker type Aspect_TOM_POINT is not affected by the marker size scale factor. It is always the smallest displayable dot. Warning: Raises Standard_OutOfRange if the scale is a negative value.
        """
    def SetMarkerType(self,theType : OCP.Aspect.Aspect_TypeOfMarker) -> None: 
        """
        Modifies the type of marker.
        """
    def SetPolygonOffset(self,theOffset : Graphic3d_PolygonOffset) -> None: 
        """
        Sets polygon offsets settings.
        """
    def SetPolygonOffsets(self,theMode : int,theFactor : float=1.0,theUnits : float=0.0) -> None: 
        """
        Sets up OpenGL polygon offsets mechanism. <aMode> parameter can contain various combinations of Aspect_PolygonOffsetMode enumeration elements (Aspect_POM_None means that polygon offsets are not changed). If <aMode> is different from Aspect_POM_Off and Aspect_POM_None, then <aFactor> and <aUnits> arguments are used by graphic renderer to calculate a depth offset value:
        """
    def SetShaderProgram(self,theProgram : Graphic3d_ShaderProgram) -> None: 
        """
        Sets up OpenGL/GLSL shader program.
        """
    def SetShadingModel(self,theShadingModel : Graphic3d_TypeOfShadingModel) -> None: 
        """
        Sets shading model
        """
    def SetSkipFirstEdge(self,theToSkipFirstEdge : bool) -> None: 
        """
        Set skip first triangle edge flag for drawing wireframe presentation of quads array split into triangles.
        """
    def SetStyle(self,theStyle : OCP.Aspect.Aspect_TypeOfStyleText) -> None: 
        """
        Modifies the style of the text.
        """
    def SetSuppressBackFaces(self,theToSuppress : bool) -> None: ...
    def SetTextAngle(self,theAngle : float) -> None: 
        """
        Turns usage of text rotated
        """
    def SetTextDisplayType(self,theType : OCP.Aspect.Aspect_TypeOfDisplayText) -> None: 
        """
        Sets display type.
        """
    def SetTextFont(self,theFont : OCP.TCollection.TCollection_HAsciiString) -> None: 
        """
        Modifies the font.
        """
    def SetTextFontAspect(self,theFontAspect : OCP.Font.Font_FontAspect) -> None: 
        """
        Turns usage of Aspect text
        """
    def SetTextStyle(self,theStyle : OCP.Aspect.Aspect_TypeOfStyleText) -> None: 
        """
        Modifies the style of the text.
        """
    def SetTextZoomable(self,theFlag : bool) -> None: 
        """
        Turns usage of text zoomable on/off
        """
    def SetTextureMap(self,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Assign texture to be mapped. See also SetTextureMapOn() to actually activate texture mapping.
        """
    def SetTextureMapOff(self) -> None: 
        """
        Disable texture mapping.
        """
    @overload
    def SetTextureMapOn(self,theToMap : bool) -> None: 
        """
        Enable or disable texture mapping (has no effect if texture is not set).

        Enable texture mapping (has no effect if texture is not set).
        """
    @overload
    def SetTextureMapOn(self) -> None: ...
    def SetTextureSet(self,theTextures : Graphic3d_TextureSet) -> None: 
        """
        Setup texture array to be mapped.
        """
    def ShaderProgram(self) -> Graphic3d_ShaderProgram: 
        """
        Return shader program.
        """
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel: 
        """
        Returns shading model; Graphic3d_TypeOfShadingModel_DEFAULT by default. Graphic3d_TOSM_DEFAULT means that Shading Model set as default for entire Viewer will be used.
        """
    def Style(self) -> OCP.Aspect.Aspect_TypeOfStyleText: 
        """
        Return the text style.
        """
    def SuppressBackFace(self) -> None: ...
    def TextAngle(self) -> float: 
        """
        Returns Angle of degree
        """
    def TextDisplayType(self) -> OCP.Aspect.Aspect_TypeOfDisplayText: 
        """
        Returns display type; Aspect_TODT_NORMAL by default.
        """
    def TextFont(self) -> OCP.TCollection.TCollection_HAsciiString: 
        """
        Returns the font; NULL string by default.
        """
    def TextFontAspect(self) -> OCP.Font.Font_FontAspect: 
        """
        Returns text FontAspect
        """
    def TextStyle(self) -> OCP.Aspect.Aspect_TypeOfStyleText: 
        """
        Returns the text style; Aspect_TOST_NORMAL by default.
        """
    def TextureMap(self) -> Graphic3d_TextureMap: 
        """
        Return texture to be mapped.
        """
    def TextureMapState(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def TextureSet(self) -> Graphic3d_TextureSet: 
        """
        Return texture array to be mapped.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToDrawEdges(self) -> bool: 
        """
        Returns true if mesh edges should be drawn (false by default).
        """
    def ToDrawSilhouette(self) -> bool: 
        """
        Returns TRUE if silhouette (outline) should be drawn (with edge color and width); FALSE by default.
        """
    def ToMapTexture(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def ToSkipFirstEdge(self) -> bool: 
        """
        Returns TRUE if drawing element edges should discard first edge in triangle; FALSE by default. Graphics hardware works mostly with triangles, so that wireframe presentation will draw triangle edges by default. This flag allows rendering wireframe presentation of quad-only array split into triangles. For this, quads should be split in specific order, so that the quad diagonal (to be NOT rendered) goes first: 1------2 / / Triangle #1: 2-0-1; Triangle #2: 0-2-3 0------3
        """
    def ToSuppressBackFaces(self) -> bool: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theColor : OCP.Quantity.Quantity_Color,theFont : str,theExpansionFactor : float,theSpace : float,theStyle : OCP.Aspect.Aspect_TypeOfStyleText=Aspect_TypeOfStyleText.Aspect_TOST_NORMAL,theDisplayType : OCP.Aspect.Aspect_TypeOfDisplayText=Aspect_TypeOfDisplayText.Aspect_TODT_NORMAL) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_AspectFillArea3d(Graphic3d_Aspects, OCP.Standard.Standard_Transient):
    """
    This class defines graphic attributes for opaque 3d primitives (polygons, triangles, quadrilaterals).This class defines graphic attributes for opaque 3d primitives (polygons, triangles, quadrilaterals).
    """
    def AllowBackFace(self) -> None: ...
    def AlphaCutoff(self) -> float: 
        """
        Returns alpha cutoff threshold, for discarding fragments within Graphic3d_AlphaMode_Mask mode (0.5 by default). If the alpha value is greater than or equal to this value then it is rendered as fully opaque, otherwise, it is rendered as fully transparent.
        """
    def AlphaMode(self) -> Graphic3d_AlphaMode: 
        """
        Returns the way how alpha value should be treated (Graphic3d_AlphaMode_BlendAuto by default, for backward compatibility).
        """
    def BackFace(self) -> bool: ...
    def BackInteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return back interior color.
        """
    def BackInteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return back interior color.
        """
    def BackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeBackMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of internal faces
        """
    def ChangeFrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return the color.
        """
    def ColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color
        """
    def ColorSubTitle(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return text background/shadow color; equals to EdgeColor() property.
        """
    def ColorSubTitleRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Returns text background/shadow color; equals to EdgeColor() property.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultLinePatternForType_s(theType : OCP.Aspect.Aspect_TypeOfLine) -> int: 
        """
        Return stipple line pattern for line type.
        """
    @staticmethod
    def DefaultLineTypeForPattern_s(thePattern : int) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type for stipple line pattern.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Distinguish(self) -> bool: 
        """
        Returns true if material properties should be distinguished for back and front faces (false by default).
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self) -> bool: ...
    def EdgeColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return color of edges.
        """
    def EdgeColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return color of edges.
        """
    def EdgeLineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return edges line type (same as LineType()).
        """
    def EdgeWidth(self) -> float: 
        """
        Return width for edges in pixels (same as LineWidth()).
        """
    def FaceCulling(self) -> Graphic3d_TypeOfBackfacingModel: 
        """
        Return face culling mode; Graphic3d_FaceCulling_BackClosed by default. A back-facing polygon is defined as a polygon whose vertices are in a clockwise order with respect to screen coordinates.
        """
    def FrontMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns the surface material of external faces
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HatchStyle(self) -> Graphic3d_HatchStyle: 
        """
        Returns the hatch type used when InteriorStyle is IS_HATCH
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteriorColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return interior color.
        """
    def InteriorColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return interior color.
        """
    def InteriorStyle(self) -> OCP.Aspect.Aspect_InteriorStyle: 
        """
        Return interior rendering style; Aspect_IS_SOLID by default.
        """
    def IsEqual(self,theOther : Graphic3d_Aspects) -> bool: 
        """
        Check for equality with another aspects.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMarkerSprite(self) -> bool: 
        """
        Returns TRUE if marker should be drawn using marker sprite (either user-provided or generated).
        """
    def IsTextZoomable(self) -> bool: 
        """
        Returns TRUE when the Text Zoomable is on.
        """
    def LinePattern(self) -> int: 
        """
        Return custom stipple line pattern; 0xFFFF by default.
        """
    def LineStippleFactor(self) -> int: 
        """
        Return a multiplier for each bit in the line stipple pattern within [1, 256] range; 1 by default.
        """
    def LineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Return line type; Aspect_TOL_SOLID by default.
        """
    def LineWidth(self) -> float: 
        """
        Return width for edges in pixels; 1.0 by default.
        """
    def MarkerImage(self) -> Graphic3d_MarkerImage: 
        """
        Returns marker's image texture. Could be null handle if marker aspect has been initialized as default type of marker.
        """
    def MarkerScale(self) -> float: 
        """
        Return marker scale factor; 1.0 by default.
        """
    def MarkerType(self) -> OCP.Aspect.Aspect_TypeOfMarker: 
        """
        Return marker type; Aspect_TOM_POINT by default.
        """
    def PolygonOffset(self) -> Graphic3d_PolygonOffset: 
        """
        Returns current polygon offsets settings.
        """
    def PolygonOffsets(self,theFactor : float,theUnits : float) -> tuple[int]: 
        """
        Returns current polygon offsets settings.
        """
    def SetAlphaMode(self,theMode : Graphic3d_AlphaMode,theAlphaCutoff : float=0.5) -> None: 
        """
        Defines the way how alpha value should be treated.
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the back face

        Modifies the color of the interior of the back face
        """
    @overload
    def SetBackInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetBackMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of internal faces
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies text background/shadow color; equals to EdgeColor() property.

        Modifies text background/shadow color; equals to EdgeColor() property.
        """
    @overload
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetDistinguish(self,toDistinguish : bool) -> None: 
        """
        Set material distinction between front and back faces.
        """
    def SetDistinguishOff(self) -> None: 
        """
        Forbids material distinction between front and back faces.
        """
    def SetDistinguishOn(self) -> None: 
        """
        Allows material distinction between front and back faces.
        """
    def SetDrawEdges(self,theToDraw : bool) -> None: 
        """
        Set if mesh edges should be drawn or not.
        """
    def SetDrawSilhouette(self,theToDraw : bool) -> None: 
        """
        Enables/disables drawing silhouette (outline).
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the edge of the face

        Modifies the color of the edge of the face
        """
    @overload
    def SetEdgeColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetEdgeLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the edge line type (same as SetLineType())
        """
    def SetEdgeOff(self) -> None: 
        """
        The edges of FillAreas are not drawn.
        """
    def SetEdgeOn(self) -> None: 
        """
        The edges of FillAreas are drawn.
        """
    def SetEdgeWidth(self,theWidth : float) -> None: 
        """
        Modifies the edge thickness (same as SetLineWidth())
        """
    def SetFaceCulling(self,theCulling : Graphic3d_TypeOfBackfacingModel) -> None: 
        """
        Set face culling mode.
        """
    def SetFrontMaterial(self,theMaterial : Graphic3d_MaterialAspect) -> None: 
        """
        Modifies the surface material of external faces
        """
    @overload
    def SetHatchStyle(self,theStyle : Graphic3d_HatchStyle) -> None: 
        """
        Modifies the hatch type used when InteriorStyle is IS_HATCH

        Modifies the hatch type used when InteriorStyle is IS_HATCH
        """
    @overload
    def SetHatchStyle(self,theStyle : OCP.Aspect.Aspect_HatchStyle) -> None: ...
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the color of the interior of the face

        Modifies the color of the interior of the face
        """
    @overload
    def SetInteriorColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: ...
    def SetInteriorStyle(self,theStyle : OCP.Aspect.Aspect_InteriorStyle) -> None: 
        """
        Modifies the interior type used for rendering
        """
    def SetLinePattern(self,thePattern : int) -> None: 
        """
        Modifies the stipple line pattern, and changes line type to Aspect_TOL_USERDEFINED for non-standard pattern.
        """
    def SetLineStippleFactor(self,theFactor : int) -> None: 
        """
        Set a multiplier for each bit in the line stipple pattern.
        """
    def SetLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Modifies the line type
        """
    def SetLineWidth(self,theWidth : float) -> None: 
        """
        Modifies the line thickness Warning: Raises Standard_OutOfRange if the width is a negative value.
        """
    def SetMarkerImage(self,theImage : Graphic3d_MarkerImage) -> None: 
        """
        Set marker's image texture.
        """
    def SetMarkerScale(self,theScale : float) -> None: 
        """
        Modifies the scale factor. Marker type Aspect_TOM_POINT is not affected by the marker size scale factor. It is always the smallest displayable dot. Warning: Raises Standard_OutOfRange if the scale is a negative value.
        """
    def SetMarkerType(self,theType : OCP.Aspect.Aspect_TypeOfMarker) -> None: 
        """
        Modifies the type of marker.
        """
    def SetPolygonOffset(self,theOffset : Graphic3d_PolygonOffset) -> None: 
        """
        Sets polygon offsets settings.
        """
    def SetPolygonOffsets(self,theMode : int,theFactor : float=1.0,theUnits : float=0.0) -> None: 
        """
        Sets up OpenGL polygon offsets mechanism. <aMode> parameter can contain various combinations of Aspect_PolygonOffsetMode enumeration elements (Aspect_POM_None means that polygon offsets are not changed). If <aMode> is different from Aspect_POM_Off and Aspect_POM_None, then <aFactor> and <aUnits> arguments are used by graphic renderer to calculate a depth offset value:
        """
    def SetShaderProgram(self,theProgram : Graphic3d_ShaderProgram) -> None: 
        """
        Sets up OpenGL/GLSL shader program.
        """
    def SetShadingModel(self,theShadingModel : Graphic3d_TypeOfShadingModel) -> None: 
        """
        Sets shading model
        """
    def SetSkipFirstEdge(self,theToSkipFirstEdge : bool) -> None: 
        """
        Set skip first triangle edge flag for drawing wireframe presentation of quads array split into triangles.
        """
    def SetSuppressBackFaces(self,theToSuppress : bool) -> None: ...
    def SetTextAngle(self,theAngle : float) -> None: 
        """
        Turns usage of text rotated
        """
    def SetTextDisplayType(self,theType : OCP.Aspect.Aspect_TypeOfDisplayText) -> None: 
        """
        Sets display type.
        """
    def SetTextFont(self,theFont : OCP.TCollection.TCollection_HAsciiString) -> None: 
        """
        Modifies the font.
        """
    def SetTextFontAspect(self,theFontAspect : OCP.Font.Font_FontAspect) -> None: 
        """
        Turns usage of Aspect text
        """
    def SetTextStyle(self,theStyle : OCP.Aspect.Aspect_TypeOfStyleText) -> None: 
        """
        Modifies the style of the text.
        """
    def SetTextZoomable(self,theFlag : bool) -> None: 
        """
        Turns usage of text zoomable on/off
        """
    def SetTextureMap(self,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Assign texture to be mapped. See also SetTextureMapOn() to actually activate texture mapping.
        """
    def SetTextureMapOff(self) -> None: 
        """
        Disable texture mapping.
        """
    @overload
    def SetTextureMapOn(self,theToMap : bool) -> None: 
        """
        Enable or disable texture mapping (has no effect if texture is not set).

        Enable texture mapping (has no effect if texture is not set).
        """
    @overload
    def SetTextureMapOn(self) -> None: ...
    def SetTextureSet(self,theTextures : Graphic3d_TextureSet) -> None: 
        """
        Setup texture array to be mapped.
        """
    def ShaderProgram(self) -> Graphic3d_ShaderProgram: 
        """
        Return shader program.
        """
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel: 
        """
        Returns shading model; Graphic3d_TypeOfShadingModel_DEFAULT by default. Graphic3d_TOSM_DEFAULT means that Shading Model set as default for entire Viewer will be used.
        """
    def SuppressBackFace(self) -> None: ...
    def TextAngle(self) -> float: 
        """
        Returns Angle of degree
        """
    def TextDisplayType(self) -> OCP.Aspect.Aspect_TypeOfDisplayText: 
        """
        Returns display type; Aspect_TODT_NORMAL by default.
        """
    def TextFont(self) -> OCP.TCollection.TCollection_HAsciiString: 
        """
        Returns the font; NULL string by default.
        """
    def TextFontAspect(self) -> OCP.Font.Font_FontAspect: 
        """
        Returns text FontAspect
        """
    def TextStyle(self) -> OCP.Aspect.Aspect_TypeOfStyleText: 
        """
        Returns the text style; Aspect_TOST_NORMAL by default.
        """
    def TextureMap(self) -> Graphic3d_TextureMap: 
        """
        Return texture to be mapped.
        """
    def TextureMapState(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def TextureSet(self) -> Graphic3d_TextureSet: 
        """
        Return texture array to be mapped.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToDrawEdges(self) -> bool: 
        """
        Returns true if mesh edges should be drawn (false by default).
        """
    def ToDrawSilhouette(self) -> bool: 
        """
        Returns TRUE if silhouette (outline) should be drawn (with edge color and width); FALSE by default.
        """
    def ToMapTexture(self) -> bool: 
        """
        Return true if texture mapping is enabled (false by default).
        """
    def ToSkipFirstEdge(self) -> bool: 
        """
        Returns TRUE if drawing element edges should discard first edge in triangle; FALSE by default. Graphics hardware works mostly with triangles, so that wireframe presentation will draw triangle edges by default. This flag allows rendering wireframe presentation of quad-only array split into triangles. For this, quads should be split in specific order, so that the quad diagonal (to be NOT rendered) goes first: 1------2 / / Triangle #1: 2-0-1; Triangle #2: 0-2-3 0------3
        """
    def ToSuppressBackFaces(self) -> bool: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theInterior : OCP.Aspect.Aspect_InteriorStyle,theInteriorColor : OCP.Quantity.Quantity_Color,theEdgeColor : OCP.Quantity.Quantity_Color,theEdgeLineType : OCP.Aspect.Aspect_TypeOfLine,theEdgeWidth : float,theFrontMaterial : Graphic3d_MaterialAspect,theBackMaterial : Graphic3d_MaterialAspect) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Buffer(OCP.NCollection.NCollection_Buffer, OCP.Standard.Standard_Transient):
    """
    Buffer of vertex attributes.Buffer of vertex attributes.
    """
    def Allocate(self,theSize : int) -> bool: 
        """
        Allocate the buffer.
        """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns buffer allocator
        """
    def Attribute(self,theAttribIndex : int) -> Graphic3d_Attribute: 
        """
        Returns attribute definition
        """
    def AttributeData(self,theAttrib : Graphic3d_TypeOfAttribute,theAttribIndex : int,theAttribStride : int) -> int: 
        """
        Return the attribute data with stride size specific to this attribute.
        """
    def AttributeOffset(self,theAttribIndex : int) -> int: 
        """
        Returns data offset to specified attribute
        """
    def AttributesArray(self) -> Graphic3d_Attribute: 
        """
        Returns array of attributes definitions
        """
    def ChangeAttribute(self,theAttribIndex : int) -> Graphic3d_Attribute: 
        """
        Returns attribute definition
        """
    def ChangeAttributeData(self,theAttrib : Graphic3d_TypeOfAttribute,theAttribIndex : int,theAttribStride : int) -> int: 
        """
        Return the attribute data with stride size specific to this attribute.
        """
    def ChangeData(self,theAttribIndex : int) -> int: 
        """
        Returns data for specified attribute
        """
    def Data(self,theAttribIndex : int) -> int: 
        """
        Returns data for specified attribute
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultAllocator_s() -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Return default vertex data allocator.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FindAttribute(self,theAttrib : Graphic3d_TypeOfAttribute) -> int: 
        """
        Find attribute index.
        """
    def Free(self) -> None: 
        """
        De-allocate buffer.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,theNbElems : int,theAttribs : Graphic3d_Attribute,theNbAttribs : int) -> bool: 
        """
        Allocates new empty array

        Allocates new empty array
        """
    @overload
    def Init(self,theNbElems : int,theAttribs : Graphic3d_Array1OfAttribute) -> bool: ...
    def Invalidate(self) -> None: 
        """
        Invalidate entire buffer.
        """
    def InvalidatedRange(self) -> Graphic3d_BufferRange: 
        """
        Return invalidated range; EMPTY by default. Requires sub-classing for creating a mutable buffer (advanced usage).
        """
    def IsEmpty(self) -> bool: 
        """
        Returns true if buffer is not allocated
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    def IsInterleaved(self) -> bool: 
        """
        Flag indicating that attributes in the buffer are interleaved; TRUE by default. Requires sub-classing for creating a non-interleaved buffer (advanced usage).
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Return TRUE if data can be invalidated; FALSE by default. Requires sub-classing for creating a mutable buffer (advanced usage).
        """
    def NbMaxElements(self) -> int: 
        """
        Return number of initially allocated elements which can fit into this buffer, while NbElements can be overwritten to smaller value.
        """
    def SetAllocator(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Assign new buffer allocator with de-allocation of buffer.
        """
    def Size(self) -> int: 
        """
        Return buffer length in bytes.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Validate(self) -> None: 
        """
        Reset invalidated range. Requires sub-classing for creating a mutable buffer (advanced usage).
        """
    def __init__(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    def changeValue(self,theElem : int) -> int: 
        """
        Access specified element.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    def release(self) -> None: 
        """
        Release buffer.
        """
    def value(self,theElem : int) -> int: 
        """
        Access specified element.
        """
    @property
    def NbAttributes(self) -> int:
        """
        :type: int
        """
    @NbAttributes.setter
    def NbAttributes(self, arg0: int) -> None:
        pass
    @property
    def NbElements(self) -> int:
        """
        :type: int
        """
    @NbElements.setter
    def NbElements(self, arg0: int) -> None:
        pass
    @property
    def Stride(self) -> int:
        """
        :type: int
        """
    @Stride.setter
    def Stride(self, arg0: int) -> None:
        pass
    pass
class Graphic3d_Attribute():
    """
    Vertex attribute definition.
    """
    def Stride(self) -> int: ...
    @staticmethod
    def Stride_s(theType : Graphic3d_TypeOfData) -> int: 
        """
        Returns size of attribute of specified data type
        """
    def __init__(self) -> None: ...
    @property
    def DataType(self) -> Graphic3d_TypeOfData:
        """
        :type: Graphic3d_TypeOfData
        """
    @DataType.setter
    def DataType(self, arg0: Graphic3d_TypeOfData) -> None:
        pass
    @property
    def Id(self) -> Graphic3d_TypeOfAttribute:
        """
        :type: Graphic3d_TypeOfAttribute
        """
    @Id.setter
    def Id(self, arg0: Graphic3d_TypeOfAttribute) -> None:
        pass
    pass
class Graphic3d_BSDF():
    """
    Describes material's BSDF (Bidirectional Scattering Distribution Function) used for physically-based rendering (in path tracing engine). BSDF is represented as weighted mixture of basic BRDFs/BTDFs (Bidirectional Reflectance (Transmittance) Distribution Functions).
    """
    @staticmethod
    def CreateDiffuse_s(theWeight : OCP.gp.gp_Vec3f) -> Graphic3d_BSDF: 
        """
        Creates BSDF describing diffuse (Lambertian) surface.
        """
    @staticmethod
    def CreateGlass_s(theWeight : OCP.gp.gp_Vec3f,theAbsorptionColor : OCP.gp.gp_Vec3f,theAbsorptionCoeff : float,theRefractionIndex : float) -> Graphic3d_BSDF: 
        """
        Creates BSDF describing glass-like object. Glass-like BSDF mixes refraction and reflection effects at grazing angles using physically-based Fresnel dielectric model.
        """
    @staticmethod
    def CreateMetallicRoughness_s(thePbr : Graphic3d_PBRMaterial) -> Graphic3d_BSDF: 
        """
        Creates BSDF from PBR metallic-roughness material.
        """
    @staticmethod
    def CreateMetallic_s(theWeight : OCP.gp.gp_Vec3f,theFresnel : Graphic3d_Fresnel,theRoughness : float) -> Graphic3d_BSDF: 
        """
        Creates BSDF describing polished metallic-like surface.
        """
    @staticmethod
    def CreateTransparent_s(theWeight : OCP.gp.gp_Vec3f,theAbsorptionColor : OCP.gp.gp_Vec3f,theAbsorptionCoeff : float) -> Graphic3d_BSDF: 
        """
        Creates BSDF describing transparent object. Transparent BSDF models simple transparency without refraction (the ray passes straight through the surface).
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def Normalize(self) -> None: 
        """
        Normalizes BSDF components.
        """
    def __init__(self) -> None: ...
    @property
    def Absorption(self) -> Graphic3d_Vec4:
        """
        :type: Graphic3d_Vec4
        """
    @Absorption.setter
    def Absorption(self, arg0: Graphic3d_Vec4) -> None:
        pass
    @property
    def FresnelBase(self) -> Graphic3d_Fresnel:
        """
        :type: Graphic3d_Fresnel
        """
    @FresnelBase.setter
    def FresnelBase(self, arg0: Graphic3d_Fresnel) -> None:
        pass
    @property
    def FresnelCoat(self) -> Graphic3d_Fresnel:
        """
        :type: Graphic3d_Fresnel
        """
    @FresnelCoat.setter
    def FresnelCoat(self, arg0: Graphic3d_Fresnel) -> None:
        pass
    @property
    def Kc(self) -> Graphic3d_Vec4:
        """
        :type: Graphic3d_Vec4
        """
    @Kc.setter
    def Kc(self, arg0: Graphic3d_Vec4) -> None:
        pass
    @property
    def Kd(self) -> OCP.gp.gp_Vec3f:
        """
        :type: OCP.gp.gp_Vec3f
        """
    @Kd.setter
    def Kd(self, arg0: OCP.gp.gp_Vec3f) -> None:
        pass
    @property
    def Ks(self) -> Graphic3d_Vec4:
        """
        :type: Graphic3d_Vec4
        """
    @Ks.setter
    def Ks(self, arg0: Graphic3d_Vec4) -> None:
        pass
    @property
    def Kt(self) -> OCP.gp.gp_Vec3f:
        """
        :type: OCP.gp.gp_Vec3f
        """
    @Kt.setter
    def Kt(self, arg0: OCP.gp.gp_Vec3f) -> None:
        pass
    @property
    def Le(self) -> OCP.gp.gp_Vec3f:
        """
        :type: OCP.gp.gp_Vec3f
        """
    @Le.setter
    def Le(self, arg0: OCP.gp.gp_Vec3f) -> None:
        pass
    pass
class Graphic3d_BoundBuffer(OCP.NCollection.NCollection_Buffer, OCP.Standard.Standard_Transient):
    """
    Bounds buffer.Bounds buffer.
    """
    def Allocate(self,theSize : int) -> bool: 
        """
        Allocate the buffer.
        """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns buffer allocator
        """
    def ChangeData(self) -> int: 
        """
        Returns buffer data
        """
    def Data(self) -> int: 
        """
        Returns buffer data
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Free(self) -> None: 
        """
        De-allocate buffer.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theNbBounds : int,theHasColors : bool) -> bool: 
        """
        Allocates new empty array
        """
    def IsEmpty(self) -> bool: 
        """
        Returns true if buffer is not allocated
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def SetAllocator(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Assign new buffer allocator with de-allocation of buffer.
        """
    def Size(self) -> int: 
        """
        Return buffer length in bytes.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    @property
    def NbBounds(self) -> int:
        """
        :type: int
        """
    @NbBounds.setter
    def NbBounds(self, arg0: int) -> None:
        pass
    @property
    def NbMaxBounds(self) -> int:
        """
        :type: int
        """
    @NbMaxBounds.setter
    def NbMaxBounds(self, arg0: int) -> None:
        pass
    pass
class Graphic3d_AttribBuffer(Graphic3d_Buffer, OCP.NCollection.NCollection_Buffer, OCP.Standard.Standard_Transient):
    """
    Buffer of vertex attributes. This class is intended for advanced usage allowing invalidation of entire buffer content or its sub-part.
    """
    def Allocate(self,theSize : int) -> bool: 
        """
        Allocate the buffer.
        """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns buffer allocator
        """
    def Attribute(self,theAttribIndex : int) -> Graphic3d_Attribute: 
        """
        Returns attribute definition
        """
    def AttributeData(self,theAttrib : Graphic3d_TypeOfAttribute,theAttribIndex : int,theAttribStride : int) -> int: 
        """
        Return the attribute data with stride size specific to this attribute.
        """
    def AttributeOffset(self,theAttribIndex : int) -> int: 
        """
        Returns data offset to specified attribute
        """
    def AttributesArray(self) -> Graphic3d_Attribute: 
        """
        Returns array of attributes definitions
        """
    def ChangeAttribute(self,theAttribIndex : int) -> Graphic3d_Attribute: 
        """
        Returns attribute definition
        """
    def ChangeAttributeData(self,theAttrib : Graphic3d_TypeOfAttribute,theAttribIndex : int,theAttribStride : int) -> int: 
        """
        Return the attribute data with stride size specific to this attribute.
        """
    def ChangeData(self,theAttribIndex : int) -> int: 
        """
        Returns data for specified attribute
        """
    def Data(self,theAttribIndex : int) -> int: 
        """
        Returns data for specified attribute
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultAllocator_s() -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Return default vertex data allocator.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FindAttribute(self,theAttrib : Graphic3d_TypeOfAttribute) -> int: 
        """
        Find attribute index.
        """
    def Free(self) -> None: 
        """
        De-allocate buffer.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,theNbElems : int,theAttribs : Graphic3d_Attribute,theNbAttribs : int) -> bool: 
        """
        Allocates new empty array

        Allocates new empty array
        """
    @overload
    def Init(self,theNbElems : int,theAttribs : Graphic3d_Array1OfAttribute) -> bool: ...
    @overload
    def Invalidate(self) -> None: 
        """
        Invalidate the entire buffer data.

        Invalidate the entire attribute data.

        Invalidate attribute data within specified sub-range (starting from 0).

        Invalidate all attribute data within specified vertex sub-range (starting from 0).
        """
    @overload
    def Invalidate(self,theAttributeIndex : int) -> None: ...
    @overload
    def Invalidate(self,theAttributeIndex : int,theVertexLower : int,theVertexUpper : int) -> None: ...
    @overload
    def Invalidate(self,theVertexLower : int,theVertexUpper : int) -> None: ...
    def InvalidatedRange(self) -> Graphic3d_BufferRange: 
        """
        Return invalidated range.
        """
    def IsEmpty(self) -> bool: 
        """
        Returns true if buffer is not allocated
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    def IsInterleaved(self) -> bool: 
        """
        Return TRUE for interleaved array; TRUE by default.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Return TRUE if data can be invalidated; FALSE by default.
        """
    def NbMaxElements(self) -> int: 
        """
        Return number of initially allocated elements which can fit into this buffer, while NbElements can be overwritten to smaller value.
        """
    def SetAllocator(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Assign new buffer allocator with de-allocation of buffer.
        """
    def SetInterleaved(self,theIsInterleaved : bool) -> None: 
        """
        Setup interleaved/non-interleaved array. WARNING! Filling non-interleaved buffer should be implemented on user side without Graphic3d_Buffer auxiliary methods designed for interleaved data.
        """
    def SetMutable(self,theMutable : bool) -> None: 
        """
        Set if data can be invalidated.
        """
    def Size(self) -> int: 
        """
        Return buffer length in bytes.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Validate(self) -> None: 
        """
        Reset invalidated range.
        """
    def __init__(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    def changeValue(self,theElem : int) -> int: 
        """
        Access specified element.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    def invalidate(self,theRange : Graphic3d_BufferRange) -> None: 
        """
        Invalidate specified sub-range of data (as byte offsets).
        """
    def release(self) -> None: 
        """
        Release buffer.
        """
    def value(self,theElem : int) -> int: 
        """
        Access specified element.
        """
    @property
    def NbAttributes(self) -> int:
        """
        :type: int
        """
    @NbAttributes.setter
    def NbAttributes(self, arg0: int) -> None:
        pass
    @property
    def NbElements(self) -> int:
        """
        :type: int
        """
    @NbElements.setter
    def NbElements(self, arg0: int) -> None:
        pass
    @property
    def Stride(self) -> int:
        """
        :type: int
        """
    @Stride.setter
    def Stride(self, arg0: int) -> None:
        pass
    pass
class Graphic3d_BufferRange():
    """
    Range of values defined as Start + Length pair.
    """
    def Clear(self) -> None: 
        """
        Clear the range.
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if range is empty.
        """
    def Unite(self,theRange : Graphic3d_BufferRange) -> None: 
        """
        Add another range to this one.
        """
    def Upper(self) -> int: 
        """
        Return the Upper element within the range
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theStart : int,theLength : int) -> None: ...
    @property
    def Length(self) -> int:
        """
        :type: int
        """
    @Length.setter
    def Length(self, arg0: int) -> None:
        pass
    @property
    def Start(self) -> int:
        """
        :type: int
        """
    @Start.setter
    def Start(self, arg0: int) -> None:
        pass
    pass
class Graphic3d_BufferType():
    """
    Define buffers available for dump

    Members:

      Graphic3d_BT_RGB

      Graphic3d_BT_RGBA

      Graphic3d_BT_Depth

      Graphic3d_BT_RGB_RayTraceHdrLeft

      Graphic3d_BT_Red

      Graphic3d_BT_ShadowMap
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_BT_Depth: OCP.Graphic3d.Graphic3d_BufferType # value = <Graphic3d_BufferType.Graphic3d_BT_Depth: 2>
    Graphic3d_BT_RGB: OCP.Graphic3d.Graphic3d_BufferType # value = <Graphic3d_BufferType.Graphic3d_BT_RGB: 0>
    Graphic3d_BT_RGBA: OCP.Graphic3d.Graphic3d_BufferType # value = <Graphic3d_BufferType.Graphic3d_BT_RGBA: 1>
    Graphic3d_BT_RGB_RayTraceHdrLeft: OCP.Graphic3d.Graphic3d_BufferType # value = <Graphic3d_BufferType.Graphic3d_BT_RGB_RayTraceHdrLeft: 3>
    Graphic3d_BT_Red: OCP.Graphic3d.Graphic3d_BufferType # value = <Graphic3d_BufferType.Graphic3d_BT_Red: 4>
    Graphic3d_BT_ShadowMap: OCP.Graphic3d.Graphic3d_BufferType # value = <Graphic3d_BufferType.Graphic3d_BT_ShadowMap: 5>
    __entries: dict # value = {'Graphic3d_BT_RGB': (<Graphic3d_BufferType.Graphic3d_BT_RGB: 0>, None), 'Graphic3d_BT_RGBA': (<Graphic3d_BufferType.Graphic3d_BT_RGBA: 1>, None), 'Graphic3d_BT_Depth': (<Graphic3d_BufferType.Graphic3d_BT_Depth: 2>, None), 'Graphic3d_BT_RGB_RayTraceHdrLeft': (<Graphic3d_BufferType.Graphic3d_BT_RGB_RayTraceHdrLeft: 3>, None), 'Graphic3d_BT_Red': (<Graphic3d_BufferType.Graphic3d_BT_Red: 4>, None), 'Graphic3d_BT_ShadowMap': (<Graphic3d_BufferType.Graphic3d_BT_ShadowMap: 5>, None)}
    __members__: dict # value = {'Graphic3d_BT_RGB': <Graphic3d_BufferType.Graphic3d_BT_RGB: 0>, 'Graphic3d_BT_RGBA': <Graphic3d_BufferType.Graphic3d_BT_RGBA: 1>, 'Graphic3d_BT_Depth': <Graphic3d_BufferType.Graphic3d_BT_Depth: 2>, 'Graphic3d_BT_RGB_RayTraceHdrLeft': <Graphic3d_BufferType.Graphic3d_BT_RGB_RayTraceHdrLeft: 3>, 'Graphic3d_BT_Red': <Graphic3d_BufferType.Graphic3d_BT_Red: 4>, 'Graphic3d_BT_ShadowMap': <Graphic3d_BufferType.Graphic3d_BT_ShadowMap: 5>}
    pass
class Graphic3d_CLight(OCP.Standard.Standard_Transient):
    """
    Generic light source definition. This class defines arbitrary light source - see Graphic3d_TypeOfLightSource enumeration. Some parameters are applicable only to particular light type; calling methods unrelated to current type will throw an exception.Generic light source definition. This class defines arbitrary light source - see Graphic3d_TypeOfLightSource enumeration. Some parameters are applicable only to particular light type; calling methods unrelated to current type will throw an exception.
    """
    def Angle(self) -> float: 
        """
        Returns an angle in radians of the cone created by the spot; 30 degrees by default.
        """
    def Attenuation(self) -> tuple[float, float]: 
        """
        Returns the attenuation factors.
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the color of the light source; WHITE by default.
        """
    def Concentration(self) -> float: 
        """
        Returns intensity distribution of the spot light, within [0.0, 1.0] range; 1.0 by default. This coefficient should be converted into spotlight exponent within [0.0, 128.0] range: The concentration factor determines the dispersion of the light on the surface, the default value (1.0) corresponds to a minimum of dispersion.
        """
    def ConstAttenuation(self) -> float: 
        """
        Returns constant attenuation factor of positional/spot light source; 1.0f by default. Distance attenuation factors of reducing positional/spot light intensity depending on the distance from its position:
        """
    def CopyFrom(self,theLight : Graphic3d_CLight) -> None: 
        """
        Copy parameters from another light source excluding source type.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    @overload
    def Direction(self) -> OCP.gp.gp_Dir: 
        """
        Returns direction of directional/spot light.

        Returns the theVx, theVy, theVz direction of the light source.
        """
    @overload
    def Direction(self) -> tuple[float, float, float]: ...
    def DisplayPosition(self) -> OCP.gp.gp_Pnt: 
        """
        Returns location of positional/spot/directional light, which is the same as returned by Position().
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns light resource identifier string
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasRange(self) -> bool: 
        """
        Returns TRUE if maximum distance of point light source is defined.
        """
    def Headlight(self) -> bool: 
        """
        Alias for IsHeadlight().
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Intensity(self) -> float: 
        """
        Returns the intensity of light source; 1.0 by default.
        """
    def IsEnabled(self) -> bool: 
        """
        Check that the light source is turned on; TRUE by default. This flag affects all occurrences of light sources, where it was registered and activated; so that it is possible defining an active light in View which is actually in disabled state.
        """
    def IsHeadlight(self) -> bool: 
        """
        Returns true if the light is a headlight; FALSE by default. Headlight flag means that light position/direction are defined not in a World coordinate system, but relative to the camera orientation.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def LinearAttenuation(self) -> float: 
        """
        Returns linear attenuation factor of positional/spot light source; 0.0 by default. Distance attenuation factors of reducing positional/spot light intensity depending on the distance from its position:
        """
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns light source name; empty string by default.
        """
    def PackedColor(self) -> Graphic3d_Vec4: 
        """
        Returns the color of the light source with dummy Alpha component, which should be ignored.
        """
    def PackedDirection(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns direction of directional/spot light.
        """
    def PackedDirectionRange(self) -> Graphic3d_Vec4: 
        """
        Returns direction of directional/spot light and range for positional/spot light in alpha channel.
        """
    def PackedParams(self) -> Graphic3d_Vec4: 
        """
        Packed light parameters.
        """
    @overload
    def Position(self) -> tuple[float, float, float]: 
        """
        Returns location of positional/spot light.

        Returns location of positional/spot light; (0, 0, 0) by default.
        """
    @overload
    def Position(self) -> OCP.gp.gp_Pnt: ...
    def Range(self) -> float: 
        """
        Returns maximum distance on which point light source affects to objects and is considered during illumination calculations. 0.0 means disabling range considering at all without any distance limits. Has sense only for point light sources (positional and spot).
        """
    def Revision(self) -> int: 
        """
        Returns modification counter
        """
    def SetAngle(self,theAngle : float) -> None: 
        """
        Angle in radians of the cone created by the spot, should be within range (0.0, M_PI).
        """
    def SetAttenuation(self,theConstAttenuation : float,theLinearAttenuation : float) -> None: 
        """
        Defines the coefficients of attenuation; values should be >= 0.0 and their summ should not be equal to 0.
        """
    def SetCastShadows(self,theToCast : bool) -> None: 
        """
        Enable/disable shadow casting.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Defines the color of a light source by giving the basic color.
        """
    def SetConcentration(self,theConcentration : float) -> None: 
        """
        Defines the coefficient of concentration; value should be within range [0.0, 1.0].
        """
    @overload
    def SetDirection(self,theDir : OCP.gp.gp_Dir) -> None: 
        """
        Sets direction of directional/spot light.

        Sets direction of directional/spot light.
        """
    @overload
    def SetDirection(self,theVx : float,theVy : float,theVz : float) -> None: ...
    def SetDisplayPosition(self,thePosition : OCP.gp.gp_Pnt) -> None: 
        """
        Setup location of positional/spot/directional light, which is the same as SetPosition() but allows directional light source (technically having no position, but this point can be used for displaying light source presentation).
        """
    def SetEnabled(self,theIsOn : bool) -> None: 
        """
        Change enabled state of the light state. This call does not remove or deactivate light source in Views/Viewers; instead it turns it OFF so that it just have no effect.
        """
    def SetHeadlight(self,theValue : bool) -> None: 
        """
        Setup headlight flag.
        """
    def SetIntensity(self,theValue : float) -> None: 
        """
        Modifies the intensity of light source, which should be > 0.0.
        """
    def SetName(self,theName : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets light source name.
        """
    @overload
    def SetPosition(self,thePosition : OCP.gp.gp_Pnt) -> None: 
        """
        Setup location of positional/spot light.

        Setup location of positional/spot light.
        """
    @overload
    def SetPosition(self,theX : float,theY : float,theZ : float) -> None: ...
    def SetRange(self,theValue : float) -> None: 
        """
        Modifies maximum distance on which point light source affects to objects and is considered during illumination calculations. Positional and spot lights are only point light sources. 0.0 means disabling range considering at all without any distance limits.
        """
    def SetSmoothAngle(self,theValue : float) -> None: 
        """
        Modifies the smoothing angle (in radians) of directional light source; should be within range [0.0, M_PI/2].
        """
    def SetSmoothRadius(self,theValue : float) -> None: 
        """
        Modifies the smoothing radius of positional/spot light; should be >= 0.0.
        """
    def Smoothness(self) -> float: 
        """
        Returns the smoothness of light source (either smoothing angle for directional light or smoothing radius in case of positional light); 0.0 by default.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToCastShadows(self) -> bool: 
        """
        Return TRUE if shadow casting is enabled; FALSE by default. Has no effect in Ray-Tracing rendering mode.
        """
    def Type(self) -> Graphic3d_TypeOfLightSource: 
        """
        Returns the Type of the Light, cannot be changed after object construction.
        """
    def __init__(self,theType : Graphic3d_TypeOfLightSource) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_CStructure(OCP.Standard.Standard_Transient):
    """
    Low-level graphic structure interfaceLow-level graphic structure interface
    """
    def BndBoxClipCheck(self) -> bool: 
        """
        Returns whether check of object's bounding box clipping is enabled before drawing of object; TRUE by default.
        """
    def BoundingBox(self) -> Any: 
        """
        Returns bounding box of this presentation
        """
    def ChangeBoundingBox(self) -> Any: 
        """
        Returns bounding box of this presentation without transformation matrix applied
        """
    def Clear(self) -> None: 
        """
        Clear graphic data
        """
    def ClipPlanes(self) -> Graphic3d_SequenceOfHClipPlane: 
        """
        Returns associated clip planes
        """
    def Connect(self,theStructure : Graphic3d_CStructure) -> None: 
        """
        Connect other structure to this one
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Disconnect(self,theStructure : Graphic3d_CStructure) -> None: 
        """
        Disconnect other structure to this one
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GraphicDriver(self) -> Graphic3d_GraphicDriver: 
        """
        Returns graphic driver created this structure
        """
    def GraphicHighlight(self,theStyle : Graphic3d_PresentationAttributes) -> None: 
        """
        Highlights structure with the given style
        """
    def GraphicUnhighlight(self) -> None: 
        """
        Unhighlights the structure and invalidates pointer to structure's highlight style
        """
    def Groups(self) -> Graphic3d_SequenceOfGroup: 
        """
        Returns graphic groups
        """
    def HasGroupTransformPersistence(self) -> bool: 
        """
        Return TRUE if some groups might have transform persistence; FALSE by default.
        """
    def HighlightStyle(self) -> Graphic3d_PresentationAttributes: 
        """
        Returns valid handle to highlight style of the structure in case if highlight flag is set to true
        """
    def Identification(self) -> int: 
        """
        Return structure id (generated by Graphic3d_GraphicDriver::NewIdentification() during structure construction).
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsAlwaysRendered(self) -> bool: 
        """
        Checks if the structure should be included into BVH tree or not.
        """
    def IsCulled(self) -> bool: 
        """
        Returns FALSE if the structure hits the current view volume, otherwise returns TRUE.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @overload
    def IsVisible(self) -> bool: 
        """
        Return structure visibility flag

        Return structure visibility considering both View Affinity and global visibility state.
        """
    @overload
    def IsVisible(self,theViewId : int) -> bool: ...
    def MarkAsNotCulled(self) -> None: 
        """
        Marks structure as overlapping the current view volume one. The method is called during traverse of BVH tree.
        """
    def NewGroup(self,theStruct : Graphic3d_Structure) -> Graphic3d_Group: 
        """
        Create new group within this structure
        """
    def OnVisibilityChanged(self) -> None: 
        """
        Update structure visibility state
        """
    def PreviousPriority(self) -> Graphic3d_DisplayPriority: 
        """
        Return previous structure display priority.
        """
    def Priority(self) -> Graphic3d_DisplayPriority: 
        """
        Return structure display priority.
        """
    def RemoveGroup(self,theGroup : Graphic3d_Group) -> None: 
        """
        Remove group from this structure
        """
    def SetBndBoxClipCheck(self,theBndBoxClipCheck : bool) -> None: 
        """
        Enable/disable check of object's bounding box clipping before drawing of object.
        """
    def SetClipPlanes(self,thePlanes : Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Pass clip planes to the associated graphic driver structure
        """
    def SetCulled(self,theIsCulled : bool) -> None: 
        """
        Marks structure as culled/not culled - note that IsAlwaysRendered() is ignored here!
        """
    def SetGroupTransformPersistence(self,theValue : bool) -> None: 
        """
        Set if some groups might have transform persistence.
        """
    def SetPreviousPriority(self,thePriority : Graphic3d_DisplayPriority) -> None: 
        """
        Set previous structure display priority.
        """
    def SetPriority(self,thePriority : Graphic3d_DisplayPriority) -> None: 
        """
        Set structure display priority.
        """
    def SetTransformPersistence(self,theTrsfPers : Graphic3d_TransformPers) -> None: 
        """
        Set transformation persistence.
        """
    def SetTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: 
        """
        Assign transformation.
        """
    def SetZLayer(self,theLayerIndex : int) -> None: 
        """
        Set z layer ID to display the structure in specified layer
        """
    def ShadowLink(self,theManager : Graphic3d_StructureManager) -> Graphic3d_CStructure: 
        """
        Create shadow link to this structure
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def TransformPersistence(self) -> Graphic3d_TransformPers: 
        """
        Return transformation persistence.
        """
    def Transformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return transformation.
        """
    def ZLayer(self) -> int: 
        """
        Get z layer ID
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    def updateLayerTransformation(self) -> None: 
        """
        Update render transformation matrix.
        """
    pass
class Graphic3d_DataStructureManager(OCP.Standard.Standard_Transient):
    """
    This class allows the definition of a manager to which the graphic objects are associated. It allows them to be globally manipulated. It defines the global attributes.This class allows the definition of a manager to which the graphic objects are associated. It allows them to be globally manipulated. It defines the global attributes.This class allows the definition of a manager to which the graphic objects are associated. It allows them to be globally manipulated. It defines the global attributes.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Camera(OCP.Standard.Standard_Transient):
    """
    Camera class provides object-oriented approach to setting up projection and orientation properties of 3D view.Camera class provides object-oriented approach to setting up projection and orientation properties of 3D view.
    """
    class FocusType_e():
        """
        Enumerates approaches to define stereographic focus. - FocusType_Absolute : focus is specified as absolute value. - FocusType_Relative : focus is specified relative to (as coefficient of) camera focal length.

        Members:

          FocusType_Absolute

          FocusType_Relative
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        FocusType_Absolute: OCP.Graphic3d.FocusType_e # value = <FocusType_e.FocusType_Absolute: 0>
        FocusType_Relative: OCP.Graphic3d.FocusType_e # value = <FocusType_e.FocusType_Relative: 1>
        __entries: dict # value = {'FocusType_Absolute': (<FocusType_e.FocusType_Absolute: 0>, None), 'FocusType_Relative': (<FocusType_e.FocusType_Relative: 1>, None)}
        __members__: dict # value = {'FocusType_Absolute': <FocusType_e.FocusType_Absolute: 0>, 'FocusType_Relative': <FocusType_e.FocusType_Relative: 1>}
        pass
    class IODType_e():
        """
        Enumerates approaches to define Intraocular distance. - IODType_Absolute : Intraocular distance is defined as absolute value. - IODType_Relative : Intraocular distance is defined relative to (as coefficient of) camera focal length.

        Members:

          IODType_Absolute

          IODType_Relative
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        IODType_Absolute: OCP.Graphic3d.IODType_e # value = <IODType_e.IODType_Absolute: 0>
        IODType_Relative: OCP.Graphic3d.IODType_e # value = <IODType_e.IODType_Relative: 1>
        __entries: dict # value = {'IODType_Absolute': (<IODType_e.IODType_Absolute: 0>, None), 'IODType_Relative': (<IODType_e.IODType_Relative: 1>, None)}
        __members__: dict # value = {'IODType_Absolute': <IODType_e.IODType_Absolute: 0>, 'IODType_Relative': <IODType_e.IODType_Relative: 1>}
        pass
    class Projection_e():
        """
        Enumerates supported monographic projections. - Projection_Orthographic : orthographic projection. - Projection_Perspective : perspective projection. - Projection_Stereo : stereographic projection. - Projection_MonoLeftEye : mono projection for stereo left eye. - Projection_MonoRightEye : mono projection for stereo right eye.

        Members:

          Projection_Orthographic

          Projection_Perspective

          Projection_Stereo

          Projection_MonoLeftEye

          Projection_MonoRightEye
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        Projection_MonoLeftEye: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_MonoLeftEye: 3>
        Projection_MonoRightEye: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_MonoRightEye: 4>
        Projection_Orthographic: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_Orthographic: 0>
        Projection_Perspective: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_Perspective: 1>
        Projection_Stereo: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_Stereo: 2>
        __entries: dict # value = {'Projection_Orthographic': (<Projection_e.Projection_Orthographic: 0>, None), 'Projection_Perspective': (<Projection_e.Projection_Perspective: 1>, None), 'Projection_Stereo': (<Projection_e.Projection_Stereo: 2>, None), 'Projection_MonoLeftEye': (<Projection_e.Projection_MonoLeftEye: 3>, None), 'Projection_MonoRightEye': (<Projection_e.Projection_MonoRightEye: 4>, None)}
        __members__: dict # value = {'Projection_Orthographic': <Projection_e.Projection_Orthographic: 0>, 'Projection_Perspective': <Projection_e.Projection_Perspective: 1>, 'Projection_Stereo': <Projection_e.Projection_Stereo: 2>, 'Projection_MonoLeftEye': <Projection_e.Projection_MonoLeftEye: 3>, 'Projection_MonoRightEye': <Projection_e.Projection_MonoRightEye: 4>}
        pass
    def Aspect(self) -> float: 
        """
        Get camera display ratio.
        """
    def AxialScale(self) -> OCP.gp.gp_XYZ: 
        """
        Get camera axial scale.
        """
    def Center(self) -> OCP.gp.gp_Pnt: 
        """
        Get Center of the camera, e.g. the point where camera looks at. This point is computed as Eye() translated along Direction() at Distance().
        """
    def ConvertProj2View(self,thePnt : OCP.gp.gp_Pnt) -> OCP.gp.gp_Pnt: 
        """
        Convert point from projection coordinate space to view coordinate space.
        """
    def ConvertView2Proj(self,thePnt : OCP.gp.gp_Pnt) -> OCP.gp.gp_Pnt: 
        """
        Convert point from view coordinate space to projection coordinate space.
        """
    def ConvertView2World(self,thePnt : OCP.gp.gp_Pnt) -> OCP.gp.gp_Pnt: 
        """
        Convert point from view coordinate space to world coordinates.
        """
    def ConvertWorld2View(self,thePnt : OCP.gp.gp_Pnt) -> OCP.gp.gp_Pnt: 
        """
        Convert point from world coordinate space to view coordinate space.
        """
    def Copy(self,theOther : Graphic3d_Camera) -> None: 
        """
        Copy properties of another camera.
        """
    def CopyMappingData(self,theOtherCamera : Graphic3d_Camera) -> None: 
        """
        Initialize mapping related parameters from other camera handle.
        """
    def CopyOrientationData(self,theOtherCamera : Graphic3d_Camera) -> None: 
        """
        Initialize orientation related parameters from other camera handle.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Direction(self) -> OCP.gp.gp_Dir: 
        """
        Get camera look direction.
        """
    def Distance(self) -> float: 
        """
        Get distance of Eye from camera Center.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Eye(self) -> OCP.gp.gp_Pnt: 
        """
        Get camera Eye position.
        """
    def FOV2d(self) -> float: 
        """
        Get Field Of View (FOV) restriction for 2D on-screen elements; 180 degrees by default. When 2D FOV is smaller than FOVy or FOVx, 2D elements defined within offset from view corner will be extended to fit into specified 2D FOV. This can be useful to make 2D elements sharply visible, like in case of HMD normally having extra large FOVy.
        """
    def FOVx(self) -> float: 
        """
        Get Field Of View (FOV) in x axis.
        """
    def FOVy(self) -> float: 
        """
        Get Field Of View (FOV) in y axis.
        """
    def FitMinMax(self,theBox : OCP.Bnd.Bnd_Box,theResolution : float,theToEnlargeIfLine : bool) -> bool: 
        """
        Adjust camera to fit in specified AABB.
        """
    def Frustum(self,theLeft : OCP.gp.gp_Pln,theRight : OCP.gp.gp_Pln,theBottom : OCP.gp.gp_Pln,theTop : OCP.gp.gp_Pln,theNear : OCP.gp.gp_Pln,theFar : OCP.gp.gp_Pln) -> None: 
        """
        Calculate WCS frustum planes for the camera projection volume. Frustum is a convex volume determined by six planes directing inwards. The frustum planes are usually used as inputs for camera algorithms. Thus, if any changes to projection matrix calculation are necessary, the frustum planes calculation should be also touched.
        """
    def FrustumPoints(self,thePoints : Any,theModelWorld : Graphic3d_Mat4d=Graphic3d_Mat4d) -> None: 
        """
        Fill array of current view frustum corners. The size of this array is equal to FrustumVerticesNB. The order of vertices is as defined in FrustumVert_* enumeration.
        """
    def GetIODType(self) -> Graphic3d_Camera.IODType_e: 
        """
        Get Intraocular distance definition type.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IOD(self) -> float: 
        """
        Get Intraocular distance value.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @staticmethod
    def Interpolate_s(theStart : Graphic3d_Camera,theEnd : Graphic3d_Camera,theT : float,theCamera : Graphic3d_Camera) -> None: 
        """
        Linear interpolation tool for camera orientation and position. This tool interpolates camera parameters scale, eye, center, rotation (up and direction vectors) independently.
        """
    def InvalidateOrientation(self) -> None: 
        """
        Invalidate orientation matrix. The matrix will be updated on request.
        """
    def InvalidateProjection(self) -> None: 
        """
        Invalidate state of projection matrix. The matrix will be updated on request.
        """
    def IsCustomMonoProjection(self) -> bool: 
        """
        Return TRUE if custom projection matrix is set.
        """
    def IsCustomStereoFrustum(self) -> bool: 
        """
        Return TRUE if custom stereo frustums are set.
        """
    def IsCustomStereoProjection(self) -> bool: 
        """
        Return TRUE if custom stereo projection matrices are set.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsOrthographic(self) -> bool: 
        """
        Check that the camera projection is orthographic.
        """
    def IsStereo(self) -> bool: 
        """
        Check whether the camera projection is stereo. Please note that stereo rendering is now implemented with support of Quad buffering.
        """
    def IsZeroToOneDepth(self) -> bool: 
        """
        Return TRUE if camera should calculate projection matrix for [0, 1] depth range or for [-1, 1] range. FALSE by default.
        """
    def MoveEyeTo(self,theEye : OCP.gp.gp_Pnt) -> None: 
        """
        Sets camera Eye position. Unlike SetEye(), this method only changes Eye point and preserves camera direction.
        """
    def NDC2dOffsetX(self) -> float: 
        """
        Return offset to the view corner in NDC space within dimension X for 2d on-screen elements, which is normally 0.5. Can be clamped when FOVx exceeds FOV2d.
        """
    def NDC2dOffsetY(self) -> float: 
        """
        Return offset to the view corner in NDC space within dimension X for 2d on-screen elements, which is normally 0.5. Can be clamped when FOVy exceeds FOV2d.
        """
    def OrientationMatrix(self) -> Graphic3d_Mat4d: 
        """
        Get orientation matrix.
        """
    def OrientationMatrixF(self) -> Graphic3d_Mat4: 
        """
        Get orientation matrix of Standard_ShortReal precision.
        """
    def OrthogonalizeUp(self) -> None: 
        """
        Orthogonalize up direction vector.
        """
    def OrthogonalizedUp(self) -> OCP.gp.gp_Dir: 
        """
        Return a copy of orthogonalized up direction vector.
        """
    def Project(self,thePnt : OCP.gp.gp_Pnt) -> OCP.gp.gp_Pnt: 
        """
        Project point from world coordinate space to normalized device coordinates (mapping).
        """
    def ProjectionMatrix(self) -> Graphic3d_Mat4d: 
        """
        Get monographic or middle point projection matrix used for monographic rendering and for point projection / unprojection.
        """
    def ProjectionMatrixF(self) -> Graphic3d_Mat4: 
        """
        Get monographic or middle point projection matrix of Standard_ShortReal precision used for monographic rendering and for point projection / unprojection.
        """
    def ProjectionState(self) -> int: 
        """
        Returns modification state of camera projection matrix
        """
    def ProjectionStereoLeft(self) -> Graphic3d_Mat4d: 
        """
        Returns stereographic matrix computed for left eye. Please note that this method is used for rendering for Projection_Stereo.
        """
    def ProjectionStereoLeftF(self) -> Graphic3d_Mat4: 
        """
        Returns stereographic matrix of Standard_ShortReal precision computed for left eye. Please note that this method is used for rendering for Projection_Stereo.
        """
    def ProjectionStereoRight(self) -> Graphic3d_Mat4d: 
        """
        Returns stereographic matrix computed for right eye. Please note that this method is used for rendering for Projection_Stereo.
        """
    def ProjectionStereoRightF(self) -> Graphic3d_Mat4: 
        """
        Returns stereographic matrix of Standard_ShortReal precision computed for right eye. Please note that this method is used for rendering for Projection_Stereo.
        """
    def ProjectionType(self) -> Graphic3d_Camera.Projection_e: 
        """
        Returns camera projection type.
        """
    def ResetCustomProjection(self) -> None: 
        """
        Unset all custom frustums and projection matrices.
        """
    def Scale(self) -> float: 
        """
        Get camera scale.
        """
    def SetAspect(self,theAspect : float) -> None: 
        """
        Changes width / height display ratio.
        """
    def SetAxialScale(self,theAxialScale : OCP.gp.gp_XYZ) -> None: 
        """
        Set camera axial scale.
        """
    def SetCenter(self,theCenter : OCP.gp.gp_Pnt) -> None: 
        """
        Sets Center of the camera, e.g. the point where camera looks at. This methods changes camera direction, so that the new direction is computed from current Eye position to specified Center position.
        """
    def SetCustomMonoProjection(self,theProj : Graphic3d_Mat4d) -> None: 
        """
        Set custom projection matrix.
        """
    def SetCustomStereoFrustums(self,theFrustumL : Any,theFrustumR : Any) -> None: 
        """
        Set custom stereo frustums. These can be retrieved from APIs like OpenVR.
        """
    def SetCustomStereoProjection(self,theProjL : Graphic3d_Mat4d,theHeadToEyeL : Graphic3d_Mat4d,theProjR : Graphic3d_Mat4d,theHeadToEyeR : Graphic3d_Mat4d) -> None: 
        """
        Set custom stereo projection matrices.
        """
    def SetDirection(self,theDir : OCP.gp.gp_Dir) -> None: 
        """
        Sets camera look direction and computes the new Eye position relative to current Center. WARNING! This method does NOT verify that the current Up() vector is orthogonal to the new Direction.
        """
    def SetDirectionFromEye(self,theDir : OCP.gp.gp_Dir) -> None: 
        """
        Sets camera look direction preserving the current Eye() position. WARNING! This method does NOT verify that the current Up() vector is orthogonal to the new Direction.
        """
    def SetDistance(self,theDistance : float) -> None: 
        """
        Set distance of Eye from camera Center.
        """
    def SetEye(self,theEye : OCP.gp.gp_Pnt) -> None: 
        """
        Sets camera Eye position. WARNING! For backward compatibility reasons, this method also changes view direction, so that the new direction is computed from new Eye position to old Center position.
        """
    def SetEyeAndCenter(self,theEye : OCP.gp.gp_Pnt,theCenter : OCP.gp.gp_Pnt) -> None: 
        """
        Sets camera Eye and Center positions.
        """
    def SetFOV2d(self,theFOV : float) -> None: 
        """
        Set Field Of View (FOV) restriction for 2D on-screen elements.
        """
    def SetFOVy(self,theFOVy : float) -> None: 
        """
        Set Field Of View (FOV) in y axis for perspective projection. Field of View in x axis is automatically scaled from view aspect ratio.
        """
    def SetIOD(self,theType : Graphic3d_Camera.IODType_e,theIOD : float) -> None: 
        """
        Sets Intraocular distance.
        """
    def SetIdentityOrientation(self) -> None: 
        """
        Sets camera parameters to make current orientation matrix identity one.
        """
    def SetProjectionType(self,theProjection : Graphic3d_Camera.Projection_e) -> None: 
        """
        Change camera projection type. When switching to perspective projection from orthographic one, the ZNear and ZFar are reset to default values (0.001, 3000.0) if less than 0.0.
        """
    def SetScale(self,theScale : float) -> None: 
        """
        Sets camera scale. For orthographic projection the scale factor corresponds to parallel scale of view mapping (i.e. size of viewport). For perspective camera scale is converted to distance. The scale specifies equal size of the view projection in both dimensions assuming that the aspect is 1.0. The projection height and width are specified with the scale and correspondingly multiplied by the aspect.
        """
    def SetTile(self,theTile : Graphic3d_CameraTile) -> None: 
        """
        Sets the Tile defining the drawing sub-area within View. Note that tile defining a region outside the view boundaries is also valid - use method Graphic3d_CameraTile::Cropped() to assign a cropped copy.
        """
    def SetUp(self,theUp : OCP.gp.gp_Dir) -> None: 
        """
        Sets camera Up direction vector, orthogonal to camera direction. WARNING! This method does NOT verify that the new Up vector is orthogonal to the current Direction().
        """
    def SetZFocus(self,theType : Graphic3d_Camera.FocusType_e,theZFocus : float) -> None: 
        """
        Sets stereographic focus distance.
        """
    def SetZRange(self,theZNear : float,theZFar : float) -> None: 
        """
        Change the Near and Far Z-clipping plane positions. For orthographic projection, theZNear, theZFar can be negative or positive. For perspective projection, only positive values are allowed. Program error exception is raised if non-positive values are specified for perspective projection or theZNear >= theZFar.
        """
    def SetZeroToOneDepth(self,theIsZeroToOne : bool) -> None: 
        """
        Set using [0, 1] depth range or [-1, 1] range.
        """
    def SideRight(self) -> OCP.gp.gp_Dir: 
        """
        Right side direction.
        """
    def StereoProjection(self,theProjL : Graphic3d_Mat4d,theHeadToEyeL : Graphic3d_Mat4d,theProjR : Graphic3d_Mat4d,theHeadToEyeR : Graphic3d_Mat4d) -> None: 
        """
        Get stereo projection matrices.
        """
    def StereoProjectionF(self,theProjL : Graphic3d_Mat4,theHeadToEyeL : Graphic3d_Mat4,theProjR : Graphic3d_Mat4,theHeadToEyeR : Graphic3d_Mat4) -> None: 
        """
        Get stereo projection matrices.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Tile(self) -> Graphic3d_CameraTile: 
        """
        Get current tile.
        """
    def Transform(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Transform orientation components of the camera: Eye, Up and Center points.
        """
    def UnProject(self,thePnt : OCP.gp.gp_Pnt) -> OCP.gp.gp_Pnt: 
        """
        Unproject point from normalized device coordinates to world coordinate space.
        """
    def Up(self) -> OCP.gp.gp_Dir: 
        """
        Get camera Up direction vector.
        """
    @overload
    def ViewDimensions(self) -> OCP.gp.gp_XYZ: 
        """
        Calculate view plane size at center (target) point and distance between ZFar and ZNear planes.

        Calculate view plane size at center point with specified Z offset and distance between ZFar and ZNear planes.
        """
    @overload
    def ViewDimensions(self,theZValue : float) -> OCP.gp.gp_XYZ: ...
    def WorldViewProjState(self) -> Graphic3d_WorldViewProjState: 
        """
        Returns projection modification state of the camera.
        """
    def WorldViewState(self) -> int: 
        """
        Returns modification state of camera world view transformation matrix.
        """
    def ZFar(self) -> float: 
        """
        Get the Far Z-clipping plane position.
        """
    @overload
    def ZFitAll(self,theScaleFactor : float,theMinMax : OCP.Bnd.Bnd_Box,theGraphicBB : OCP.Bnd.Bnd_Box,theZNear : float,theZFar : float) -> bool: 
        """
        Estimate Z-min and Z-max planes of projection volume to match the displayed objects. The methods ensures that view volume will be close by depth range to the displayed objects. Fitting assumes that for orthogonal projection the view volume contains the displayed objects completely. For zoomed perspective view, the view volume is adjusted such that it contains the objects or their parts, located in front of the camera.

        Change Z-min and Z-max planes of projection volume to match the displayed objects.
        """
    @overload
    def ZFitAll(self,theScaleFactor : float,theMinMax : OCP.Bnd.Bnd_Box,theGraphicBB : OCP.Bnd.Bnd_Box) -> None: ...
    def ZFocus(self) -> float: 
        """
        Get stereographic focus value.
        """
    def ZFocusType(self) -> Graphic3d_Camera.FocusType_e: 
        """
        Get stereographic focus definition type.
        """
    def ZNear(self) -> float: 
        """
        Get the Near Z-clipping plane position.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_Camera) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    FocusType_Absolute: OCP.Graphic3d.FocusType_e # value = <FocusType_e.FocusType_Absolute: 0>
    FocusType_Relative: OCP.Graphic3d.FocusType_e # value = <FocusType_e.FocusType_Relative: 1>
    FrustumVert_LeftBottomFar = 1
    FrustumVert_LeftBottomNear = 0
    FrustumVert_LeftTopFar = 3
    FrustumVert_LeftTopNear = 2
    FrustumVert_RightBottomFar = 5
    FrustumVert_RightBottomNear = 4
    FrustumVert_RightTopFar = 7
    FrustumVert_RightTopNear = 6
    FrustumVerticesNB = 8
    IODType_Absolute: OCP.Graphic3d.IODType_e # value = <IODType_e.IODType_Absolute: 0>
    IODType_Relative: OCP.Graphic3d.IODType_e # value = <IODType_e.IODType_Relative: 1>
    Projection_MonoLeftEye: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_MonoLeftEye: 3>
    Projection_MonoRightEye: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_MonoRightEye: 4>
    Projection_Orthographic: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_Orthographic: 0>
    Projection_Perspective: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_Perspective: 1>
    Projection_Stereo: OCP.Graphic3d.Projection_e # value = <Projection_e.Projection_Stereo: 2>
    pass
class Graphic3d_CameraLerp():
    """
    Simple linear interpolation tool (also known as mix() in GLSL). The main purpose of this template class is making interpolation routines more readable.
    """
    def Init(self,theStart : Graphic3d_Camera,theEnd : Graphic3d_Camera) -> None: 
        """
        Initialize values.
        """
    def Interpolate(self,theT : float,theResult : Graphic3d_Camera) -> None: 
        """
        Compute interpolated value between two values.
        """
    @staticmethod
    def Interpolate_s(theStart : Graphic3d_Camera,theEnd : Graphic3d_Camera,theT : float) -> Graphic3d_Camera: 
        """
        Compute interpolated value between two values.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theStart : Graphic3d_Camera,theEnd : Graphic3d_Camera) -> None: ...
    pass
class Graphic3d_CameraTile():
    """
    Class defines the area (Tile) inside a view.
    """
    def Cropped(self) -> Graphic3d_CameraTile: 
        """
        Return the copy cropped by total size
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def IsValid(self) -> bool: 
        """
        Return true if Tile has been defined.
        """
    def OffsetLowerLeft(self) -> Graphic3d_Vec2i: 
        """
        Return offset position from lower-left corner.
        """
    def __init__(self) -> None: ...
    @property
    def Offset(self) -> Graphic3d_Vec2i:
        """
        :type: Graphic3d_Vec2i
        """
    @Offset.setter
    def Offset(self, arg0: Graphic3d_Vec2i) -> None:
        pass
    @property
    def TileSize(self) -> Graphic3d_Vec2i:
        """
        :type: Graphic3d_Vec2i
        """
    @TileSize.setter
    def TileSize(self, arg0: Graphic3d_Vec2i) -> None:
        pass
    @property
    def TotalSize(self) -> Graphic3d_Vec2i:
        """
        :type: Graphic3d_Vec2i
        """
    @TotalSize.setter
    def TotalSize(self, arg0: Graphic3d_Vec2i) -> None:
        pass
    pass
class Graphic3d_CappingFlags():
    """
    Enumeration of capping flags.

    Members:

      Graphic3d_CappingFlags_None

      Graphic3d_CappingFlags_ObjectMaterial

      Graphic3d_CappingFlags_ObjectTexture

      Graphic3d_CappingFlags_ObjectShader

      Graphic3d_CappingFlags_ObjectAspect
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_CappingFlags_None: OCP.Graphic3d.Graphic3d_CappingFlags # value = <Graphic3d_CappingFlags.Graphic3d_CappingFlags_None: 0>
    Graphic3d_CappingFlags_ObjectAspect: OCP.Graphic3d.Graphic3d_CappingFlags # value = <Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectAspect: 11>
    Graphic3d_CappingFlags_ObjectMaterial: OCP.Graphic3d.Graphic3d_CappingFlags # value = <Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectMaterial: 1>
    Graphic3d_CappingFlags_ObjectShader: OCP.Graphic3d.Graphic3d_CappingFlags # value = <Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectShader: 8>
    Graphic3d_CappingFlags_ObjectTexture: OCP.Graphic3d.Graphic3d_CappingFlags # value = <Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectTexture: 2>
    __entries: dict # value = {'Graphic3d_CappingFlags_None': (<Graphic3d_CappingFlags.Graphic3d_CappingFlags_None: 0>, None), 'Graphic3d_CappingFlags_ObjectMaterial': (<Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectMaterial: 1>, None), 'Graphic3d_CappingFlags_ObjectTexture': (<Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectTexture: 2>, None), 'Graphic3d_CappingFlags_ObjectShader': (<Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectShader: 8>, None), 'Graphic3d_CappingFlags_ObjectAspect': (<Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectAspect: 11>, None)}
    __members__: dict # value = {'Graphic3d_CappingFlags_None': <Graphic3d_CappingFlags.Graphic3d_CappingFlags_None: 0>, 'Graphic3d_CappingFlags_ObjectMaterial': <Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectMaterial: 1>, 'Graphic3d_CappingFlags_ObjectTexture': <Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectTexture: 2>, 'Graphic3d_CappingFlags_ObjectShader': <Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectShader: 8>, 'Graphic3d_CappingFlags_ObjectAspect': <Graphic3d_CappingFlags.Graphic3d_CappingFlags_ObjectAspect: 11>}
    pass
class Graphic3d_ClipPlane(OCP.Standard.Standard_Transient):
    """
    Container for properties describing either a Clipping halfspace (single Clipping Plane), or a chain of Clipping Planes defining logical AND (conjunction) operation. The plane equation is specified in "world" coordinate system.Container for properties describing either a Clipping halfspace (single Clipping Plane), or a chain of Clipping Planes defining logical AND (conjunction) operation. The plane equation is specified in "world" coordinate system.
    """
    def CappingAspect(self) -> Graphic3d_AspectFillArea3d: 
        """
        Return capping aspect.
        """
    def CappingColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Return color for rendering capping surface.
        """
    def CappingCustomHatch(self) -> Graphic3d_HatchStyle: 
        """
        Returns hatching style.
        """
    def CappingHatch(self) -> OCP.Aspect.Aspect_HatchStyle: 
        """
        Returns hatching style.
        """
    def CappingMaterial(self) -> Graphic3d_MaterialAspect: 
        """
        Returns capping material.
        """
    def CappingTexture(self) -> Graphic3d_TextureMap: 
        """
        Returns capping texture map.
        """
    def ChainNextPlane(self) -> Graphic3d_ClipPlane: 
        """
        Return the next plane in a Chain of Planes defining logical AND operation, or NULL if there is no chain or it is a last element in chain.
        """
    def ChainPreviousPlane(self) -> Graphic3d_ClipPlane: 
        """
        Return the previous plane in a Chain of Planes defining logical AND operation, or NULL if there is no Chain or it is a first element in Chain. When clipping is defined by a Chain of Planes, it cuts a space only in case if check fails for all Planes in Chain.
        """
    def Clone(self) -> Graphic3d_ClipPlane: 
        """
        Clone plane. Virtual method to simplify copying procedure if plane class is redefined at application level to add specific fields to it e.g. id, name, etc.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetEquation(self) -> Graphic3d_Vec4d: 
        """
        Get 4-component equation vector for clipping plane.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID is used for managing associated resources in graphical driver. The clip plane can be assigned within a range of IO which can be displayed in separate OpenGl contexts. For each of the context an associated OpenGl resource for graphical aspects should be created and kept. The resources are stored in graphical driver for each of individual groups of shared context under the clip plane identifier.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsBoxFullInHalfspace(self,theBox : Any) -> bool: 
        """
        Check if the given bounding box is fully inside (or touches from inside) the half-space (e.g. NOT discarded by clipping plane).
        """
    def IsBoxFullOutHalfspace(self,theBox : Any) -> bool: 
        """
        Check if the given bounding box is fully outside of the half-space (e.g. should be discarded by clipping plane).
        """
    def IsCapping(self) -> bool: 
        """
        Check state of capping surface rendering.
        """
    def IsChain(self) -> bool: 
        """
        Return TRUE if this item defines a conjunction (logical AND) between a set of Planes. Graphic3d_ClipPlane item defines either a Clipping halfspace (single Clipping Plane) or a Clipping volume defined by a logical AND (conjunction) operation between a set of Planes defined as a Chain (so that the volume cuts a space only in case if check fails for ALL Planes in the Chain).
        """
    def IsHatchOn(self) -> bool: 
        """
        Returns True if hatching mask is turned on.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsOn(self) -> bool: 
        """
        Check that the clipping plane is turned on.
        """
    def IsPointOutHalfspace(self,thePoint : Graphic3d_Vec4d) -> bool: 
        """
        Check if the given point is outside of the half-space (e.g. should be discarded by clipping plane).
        """
    def MCountAspect(self) -> int: 
        """
        Returns modification counter for aspect.
        """
    def MCountEquation(self) -> int: 
        """
        Returns modification counter for equation.
        """
    def NbChainNextPlanes(self) -> int: 
        """
        Return the number of chains in forward direction (including this item, so it is always >= 1). For a head of Chain - returns the length of entire Chain.
        """
    def ProbeBox(self,theBox : Any) -> Graphic3d_ClipState: 
        """
        Check if the given bounding box is fully outside / fully inside.
        """
    def ProbeBoxHalfspace(self,theBox : Any) -> Graphic3d_ClipState: 
        """
        Check if the given bounding box is fully outside / fully inside the half-space.
        """
    def ProbeBoxMaxPointHalfspace(self,theBox : Any) -> Graphic3d_ClipState: 
        """
        Check if the given bounding box is fully outside of the half-space (e.g. should be discarded by clipping plane).
        """
    def ProbeBoxTouch(self,theBox : Any) -> bool: 
        """
        Check if the given bounding box is In and touch the clipping planes
        """
    def ProbePoint(self,thePoint : Graphic3d_Vec4d) -> Graphic3d_ClipState: 
        """
        Check if the given point is outside / inside / on section.
        """
    def ProbePointHalfspace(self,thePoint : Graphic3d_Vec4d) -> Graphic3d_ClipState: 
        """
        Check if the given point is outside of the half-space (e.g. should be discarded by clipping plane).
        """
    def ReversedEquation(self) -> Graphic3d_Vec4d: 
        """
        Get 4-component equation vector for clipping plane.
        """
    def SetCapping(self,theIsOn : bool) -> None: 
        """
        Change state of capping surface rendering.
        """
    def SetCappingAspect(self,theAspect : Graphic3d_AspectFillArea3d) -> None: 
        """
        Assign capping aspect.
        """
    def SetCappingColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Set color for rendering capping surface.
        """
    def SetCappingCustomHatch(self,theStyle : Graphic3d_HatchStyle) -> None: 
        """
        Set custom hatch style (stipple) and turn hatching on.
        """
    def SetCappingHatch(self,theStyle : OCP.Aspect.Aspect_HatchStyle) -> None: 
        """
        Set hatch style (stipple) and turn hatching on.
        """
    def SetCappingHatchOff(self) -> None: 
        """
        Turn off hatching.
        """
    def SetCappingHatchOn(self) -> None: 
        """
        Turn on hatching.
        """
    def SetCappingMaterial(self,theMat : Graphic3d_MaterialAspect) -> None: 
        """
        Set material for rendering capping surface.
        """
    def SetCappingTexture(self,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Set texture to be applied on capping surface.
        """
    def SetChainNextPlane(self,thePlane : Graphic3d_ClipPlane) -> None: 
        """
        Set the next plane in a Chain of Planes. This operation also updates relationship between chains (Previous/Next items), so that the previously set Next plane is cut off.
        """
    @overload
    def SetEquation(self,thePlane : OCP.gp.gp_Pln) -> None: 
        """
        Set plane equation by its geometrical definition. The equation is specified in "world" coordinate system.

        Set 4-component equation vector for clipping plane. The equation is specified in "world" coordinate system.
        """
    @overload
    def SetEquation(self,theEquation : Graphic3d_Vec4d) -> None: ...
    def SetOn(self,theIsOn : bool) -> None: 
        """
        Change state of the clipping plane.
        """
    def SetUseObjectMaterial(self,theToUse : bool) -> None: 
        """
        Set flag for controlling the source of capping plane material.
        """
    def SetUseObjectShader(self,theToUse : bool) -> None: 
        """
        Set flag for controlling the source of capping plane shader program.
        """
    def SetUseObjectTexture(self,theToUse : bool) -> None: 
        """
        Set flag for controlling the source of capping plane texture.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToPlane(self) -> OCP.gp.gp_Pln: 
        """
        Get geometrical definition.
        """
    def ToUseObjectMaterial(self) -> bool: 
        """
        Flag indicating whether material for capping plane should be taken from object. Default value: FALSE (use dedicated capping plane material).
        """
    def ToUseObjectProperties(self) -> bool: 
        """
        Return true if some fill area aspect properties should be taken from object.
        """
    def ToUseObjectShader(self) -> bool: 
        """
        Flag indicating whether shader program for capping plane should be taken from object. Default value: FALSE.
        """
    def ToUseObjectTexture(self) -> bool: 
        """
        Flag indicating whether texture for capping plane should be taken from object. Default value: FALSE.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_ClipPlane) -> None: ...
    @overload
    def __init__(self,theEquation : Graphic3d_Vec4d) -> None: ...
    @overload
    def __init__(self,thePlane : OCP.gp.gp_Pln) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ClipState():
    """
    Clipping state.

    Members:

      Graphic3d_ClipState_Out

      Graphic3d_ClipState_In

      Graphic3d_ClipState_On
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_ClipState_In: OCP.Graphic3d.Graphic3d_ClipState # value = <Graphic3d_ClipState.Graphic3d_ClipState_In: 1>
    Graphic3d_ClipState_On: OCP.Graphic3d.Graphic3d_ClipState # value = <Graphic3d_ClipState.Graphic3d_ClipState_On: 2>
    Graphic3d_ClipState_Out: OCP.Graphic3d.Graphic3d_ClipState # value = <Graphic3d_ClipState.Graphic3d_ClipState_Out: 0>
    __entries: dict # value = {'Graphic3d_ClipState_Out': (<Graphic3d_ClipState.Graphic3d_ClipState_Out: 0>, None), 'Graphic3d_ClipState_In': (<Graphic3d_ClipState.Graphic3d_ClipState_In: 1>, None), 'Graphic3d_ClipState_On': (<Graphic3d_ClipState.Graphic3d_ClipState_On: 2>, None)}
    __members__: dict # value = {'Graphic3d_ClipState_Out': <Graphic3d_ClipState.Graphic3d_ClipState_Out: 0>, 'Graphic3d_ClipState_In': <Graphic3d_ClipState.Graphic3d_ClipState_In: 1>, 'Graphic3d_ClipState_On': <Graphic3d_ClipState.Graphic3d_ClipState_On: 2>}
    pass
class Graphic3d_TextureRoot(OCP.Standard.Standard_Transient):
    """
    This is the texture root class enable the dialog with the GraphicDriver allows the loading of texture.This is the texture root class enable the dialog with the GraphicDriver allows the loading of texture.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_CubeMapOrder():
    """
    Graphic3d_CubeMapOrder maps sides of cubemap on tiles in packed cubemap image to support different tiles order in such images. Also it can be considered as permutation of numbers from 0 to 5. It stores permutation in one integer as convolution.
    """
    def Clear(self) -> Graphic3d_CubeMapOrder: 
        """
        Makes order empty.
        """
    @staticmethod
    def Default_s() -> Graphic3d_ValidatedCubeMapOrder: 
        """
        Returns default order in protector container class. It is guaranteed to be valid.
        """
    def Get(self,theCubeMapSide : Graphic3d_CubeMapSide) -> int: 
        """
        Returns value of passed cubemap side.
        """
    def HasOverflows(self) -> bool: 
        """
        Checks whether attempts to assign index greater than 5 to any side happed.
        """
    def HasRepetitions(self) -> bool: 
        """
        Checks whether order has repetitions.
        """
    def IsEmpty(self) -> bool: 
        """
        Checks whether order is empty.
        """
    def IsValid(self) -> bool: 
        """
        Checks whether order is valid. Order is valid when it doesn't have repetitions and there were not attempts to assign indexes greater than 5.
        """
    def Permute(self,anOrder : Graphic3d_ValidatedCubeMapOrder) -> Graphic3d_CubeMapOrder: 
        """
        Applies another cubemap order as permutation for the current one.
        """
    def Permuted(self,anOrder : Graphic3d_ValidatedCubeMapOrder) -> Graphic3d_CubeMapOrder: 
        """
        Returns permuted by other cubemap order copy of current one.
        """
    @overload
    def Set(self,theOrder : Graphic3d_CubeMapOrder) -> Graphic3d_CubeMapOrder: 
        """
        Alias of 'operator='.

        Sets number of tile in packed cubemap image according passed cubemap side.
        """
    @overload
    def Set(self,theCubeMapSide : Graphic3d_CubeMapSide,theValue : int) -> Graphic3d_CubeMapOrder: ...
    def SetDefault(self) -> Graphic3d_CubeMapOrder: 
        """
        Sets default order (just from 0 to 5)
        """
    def Swap(self,theFirstSide : Graphic3d_CubeMapSide,theSecondSide : Graphic3d_CubeMapSide) -> Graphic3d_CubeMapOrder: 
        """
        Swaps values of two cubemap sides.
        """
    def Swapped(self,theFirstSide : Graphic3d_CubeMapSide,theSecondSide : Graphic3d_CubeMapSide) -> Graphic3d_CubeMapOrder: 
        """
        Returns copy of current order with swapped values of two cubemap sides.
        """
    def Validated(self) -> Graphic3d_ValidatedCubeMapOrder: 
        """
        Checks whether order is valid and returns object containing it. If order is invalid then exception will be thrown. This method is only way to create Graphic3d_ValidatedCubeMapOrder except copy constructor.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,thePosXLocation : int,theNegXLocation : int,thePosYLocation : int,theNegYLocation : int,thePosZLocation : int,theNegZLocation : int) -> None: ...
    @overload
    def __init__(self,theOrder : Graphic3d_ValidatedCubeMapOrder) -> None: ...
    pass
class Graphic3d_TextureMap(Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    This is an abstract class for managing texture applicable on polygons.This is an abstract class for managing texture applicable on polygons.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_CubeMap(Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    Base class for cubemaps. It is iterator over cubemap sides.Base class for cubemaps. It is iterator over cubemap sides.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def CompressedValue(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        Returns current cubemap side as compressed PixMap. Returns null handle if current side is invalid or if image is not in supported compressed format.
        """
    def CurrentSide(self) -> Graphic3d_CubeMapSide: 
        """
        Returns current cubemap side (iterator state).
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps of cubemap will be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def More(self) -> bool: 
        """
        Returns whether the iterator has reached the end (true if it hasn't).
        """
    def Next(self) -> None: 
        """
        Moves iterator to the next cubemap side. Uses OpenGL cubemap sides order +X -> -X -> +Y -> -Y -> +Z -> -Z.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Reset(self) -> Graphic3d_CubeMap: 
        """
        Sets iterator state to +X cubemap side.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps of cubemap or not.
        """
    def SetZInversion(self,theZIsInverted : bool) -> None: 
        """
        Sets Z axis inversion (vertical flipping).
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    def Value(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        Returns PixMap containing current side of cubemap. Returns null handle if current side is invalid.
        """
    def ZIsInverted(self) -> bool: 
        """
        Returns whether Z axis is inverted.
        """
    @overload
    def __init__(self,theFileName : OCP.TCollection.TCollection_AsciiString,theToGenerateMipmaps : bool=False) -> None: ...
    @overload
    def __init__(self,thePixmap : OCP.Image.Image_PixMap=None,theToGenerateMipmaps : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_CubeMapSide():
    """
    Sides of cubemap in order of OpenGL rules

    Members:

      Graphic3d_CMS_POS_X

      Graphic3d_CMS_NEG_X

      Graphic3d_CMS_POS_Y

      Graphic3d_CMS_NEG_Y

      Graphic3d_CMS_POS_Z

      Graphic3d_CMS_NEG_Z
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_CMS_NEG_X: OCP.Graphic3d.Graphic3d_CubeMapSide # value = <Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_X: 1>
    Graphic3d_CMS_NEG_Y: OCP.Graphic3d.Graphic3d_CubeMapSide # value = <Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_Y: 3>
    Graphic3d_CMS_NEG_Z: OCP.Graphic3d.Graphic3d_CubeMapSide # value = <Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_Z: 5>
    Graphic3d_CMS_POS_X: OCP.Graphic3d.Graphic3d_CubeMapSide # value = <Graphic3d_CubeMapSide.Graphic3d_CMS_POS_X: 0>
    Graphic3d_CMS_POS_Y: OCP.Graphic3d.Graphic3d_CubeMapSide # value = <Graphic3d_CubeMapSide.Graphic3d_CMS_POS_Y: 2>
    Graphic3d_CMS_POS_Z: OCP.Graphic3d.Graphic3d_CubeMapSide # value = <Graphic3d_CubeMapSide.Graphic3d_CMS_POS_Z: 4>
    __entries: dict # value = {'Graphic3d_CMS_POS_X': (<Graphic3d_CubeMapSide.Graphic3d_CMS_POS_X: 0>, None), 'Graphic3d_CMS_NEG_X': (<Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_X: 1>, None), 'Graphic3d_CMS_POS_Y': (<Graphic3d_CubeMapSide.Graphic3d_CMS_POS_Y: 2>, None), 'Graphic3d_CMS_NEG_Y': (<Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_Y: 3>, None), 'Graphic3d_CMS_POS_Z': (<Graphic3d_CubeMapSide.Graphic3d_CMS_POS_Z: 4>, None), 'Graphic3d_CMS_NEG_Z': (<Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_Z: 5>, None)}
    __members__: dict # value = {'Graphic3d_CMS_POS_X': <Graphic3d_CubeMapSide.Graphic3d_CMS_POS_X: 0>, 'Graphic3d_CMS_NEG_X': <Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_X: 1>, 'Graphic3d_CMS_POS_Y': <Graphic3d_CubeMapSide.Graphic3d_CMS_POS_Y: 2>, 'Graphic3d_CMS_NEG_Y': <Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_Y: 3>, 'Graphic3d_CMS_POS_Z': <Graphic3d_CubeMapSide.Graphic3d_CMS_POS_Z: 4>, 'Graphic3d_CMS_NEG_Z': <Graphic3d_CubeMapSide.Graphic3d_CMS_NEG_Z: 5>}
    pass
class Graphic3d_CullingTool():
    """
    Graphic3d_CullingTool class provides a possibility to store parameters of view volume, such as its vertices and equations, and contains methods detecting if given AABB overlaps view volume.
    """
    def CacheClipPtsProjections(self) -> None: 
        """
        Caches view volume's vertices projections along its normals and AABBs dimensions. Must be called at the beginning of each BVH tree traverse loop.
        """
    def Camera(self) -> Graphic3d_Camera: 
        """
        Return the camera definition.
        """
    def CameraDirection(self) -> OCP.SelectMgr.SelectMgr_Vec3: 
        """
        Returns camera direction.
        """
    def CameraEye(self) -> OCP.SelectMgr.SelectMgr_Vec3: 
        """
        Returns camera eye position.
        """
    def IsCulled(self,theCtx : Any,theMinPnt : OCP.SelectMgr.SelectMgr_Vec3,theMaxPnt : OCP.SelectMgr.SelectMgr_Vec3,theIsInside : bool=None) -> bool: 
        """
        Checks whether given AABB should be entirely culled or not.
        """
    def IsOutFrustum(self,theMinPnt : OCP.SelectMgr.SelectMgr_Vec3,theMaxPnt : OCP.SelectMgr.SelectMgr_Vec3,theIsInside : bool=None) -> bool: 
        """
        Detects if AABB overlaps view volume using separating axis theorem (SAT).
        """
    def IsTooDistant(self,theCtx : Any,theMinPnt : OCP.SelectMgr.SelectMgr_Vec3,theMaxPnt : OCP.SelectMgr.SelectMgr_Vec3,theIsInside : bool=None) -> bool: 
        """
        Returns TRUE if given AABB should be discarded by distance culling criterion.
        """
    def IsTooSmall(self,theCtx : Any,theMinPnt : OCP.SelectMgr.SelectMgr_Vec3,theMaxPnt : OCP.SelectMgr.SelectMgr_Vec3) -> bool: 
        """
        Returns TRUE if given AABB should be discarded by size culling criterion.
        """
    def ProjectionMatrix(self) -> Graphic3d_Mat4d: 
        """
        Returns current projection matrix.
        """
    def SetCullingDistance(self,theCtx : Any,theDistance : float) -> None: 
        """
        Setup distance culling.
        """
    def SetCullingSize(self,theCtx : Any,theSize : float) -> None: 
        """
        Setup size culling.
        """
    def SetViewVolume(self,theCamera : Graphic3d_Camera,theModelWorld : Graphic3d_Mat4d=Graphic3d_Mat4d) -> None: 
        """
        Retrieves view volume's planes equations and its vertices from projection and world-view matrices.
        """
    def SetViewportSize(self,theViewportWidth : int,theViewportHeight : int,theResolutionRatio : float) -> None: ...
    def SignedPlanePointDistance(self,theNormal : Graphic3d_Vec4d,thePnt : Graphic3d_Vec4d) -> float: 
        """
        Calculates signed distance from plane to point.
        """
    def ViewportHeight(self) -> int: ...
    def ViewportWidth(self) -> int: ...
    def WorldViewMatrix(self) -> Graphic3d_Mat4d: 
        """
        Returns current world view transformation matrix.
        """
    def WorldViewProjState(self) -> Graphic3d_WorldViewProjState: 
        """
        Returns state of current world view projection transformation matrices.
        """
    def __init__(self) -> None: ...
    pass
class Graphic3d_CView(Graphic3d_DataStructureManager, OCP.Standard.Standard_Transient):
    """
    Base class of a graphical view that carries out rendering process for a concrete implementation of graphical driver. Provides virtual interfaces for redrawing its contents, management of displayed structures and render settings. The source code of the class itself implements functionality related to management of computed (HLR or "view-dependent") structures.Base class of a graphical view that carries out rendering process for a concrete implementation of graphical driver. Provides virtual interfaces for redrawing its contents, management of displayed structures and render settings. The source code of the class itself implements functionality related to management of computed (HLR or "view-dependent") structures.Base class of a graphical view that carries out rendering process for a concrete implementation of graphical driver. Provides virtual interfaces for redrawing its contents, management of displayed structures and render settings. The source code of the class itself implements functionality related to management of computed (HLR or "view-dependent") structures.
    """
    def Activate(self) -> None: 
        """
        Activates the view. Maps presentations defined within structure manager onto this view.
        """
    def AddSubview(self,theView : Graphic3d_CView) -> None: 
        """
        Add subview to the list.
        """
    def BackfacingModel(self) -> Graphic3d_TypeOfBackfacingModel: 
        """
        Return backfacing model used for the view; Graphic3d_TypeOfBackfacingModel_Auto by default, which means that backface culling is defined by each presentation.
        """
    def Background(self) -> OCP.Aspect.Aspect_Background: 
        """
        Returns background fill color.
        """
    def BackgroundCubeMap(self) -> Graphic3d_CubeMap: 
        """
        Returns cubemap being set last time on background.
        """
    def BackgroundImage(self) -> Graphic3d_TextureMap: 
        """
        Returns background image texture map.
        """
    def BackgroundImageStyle(self) -> OCP.Aspect.Aspect_FillMethod: 
        """
        Returns background image fill style.
        """
    def BackgroundSkydome(self) -> OCP.Aspect.Aspect_SkydomeBackground: 
        """
        Returns skydome aspect;
        """
    def BackgroundType(self) -> Graphic3d_TypeOfBackground: 
        """
        Returns background type.
        """
    def BaseXRCamera(self) -> Graphic3d_Camera: 
        """
        Returns anchor camera definition (without tracked head orientation).
        """
    def BufferDump(self,theImage : OCP.Image.Image_PixMap,theBufferType : Graphic3d_BufferType) -> bool: 
        """
        Dump active rendering buffer into specified memory buffer.
        """
    def Camera(self) -> Graphic3d_Camera: 
        """
        Returns camera object of the view.
        """
    def ChangeRenderingParams(self) -> Graphic3d_RenderingParams: 
        """
        Returns reference to current rendering parameters and effect settings.
        """
    def ClipPlanes(self) -> Graphic3d_SequenceOfHClipPlane: 
        """
        Returns list of clip planes set for the view.
        """
    def Compute(self) -> None: 
        """
        Computes the new presentation of the structures displayed in this view with the type Graphic3d_TOS_COMPUTED.
        """
    def ComputeXRBaseCameraFromPosed(self,theCamPosed : Graphic3d_Camera,thePoseTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Update based camera from posed camera by applying reversed transformation.
        """
    def ComputeXRPosedCameraFromBase(self,theCam : Graphic3d_Camera,theXRTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Compute camera position based on XR pose.
        """
    def ComputedMode(self) -> bool: 
        """
        Returns the computed HLR mode state
        """
    def ConsiderZoomPersistenceObjects(self) -> float: 
        """
        Returns zoom-scale factor.
        """
    def CopySettings(self,theOther : Graphic3d_CView) -> None: 
        """
        Copy visualization settings from another view. Method is used for cloning views in viewer when its required to create view with same view properties.
        """
    def Deactivate(self) -> None: 
        """
        Deactivates the view. Unmaps presentations defined within structure manager. The view in deactivated state will ignore actions on structures such as Display().
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DiagnosticInformation(self,theDict : OCP.TColStd.TColStd_IndexedDataMapOfStringString,theFlags : Graphic3d_DiagnosticInfo) -> None: 
        """
        Fill in the dictionary with diagnostic info. Should be called within rendering thread.
        """
    def DisplayedStructures(self,theStructures : Any) -> None: 
        """
        Returns the set of structures displayed in this view.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FBO(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns pointer to an assigned framebuffer object.
        """
    def FBOChangeViewport(self,theFbo : OCP.Standard.Standard_Transient,theWidth : int,theHeight : int) -> None: 
        """
        Change offscreen FBO viewport.
        """
    def FBOCreate(self,theWidth : int,theHeight : int) -> OCP.Standard.Standard_Transient: 
        """
        Generate offscreen FBO in the graphic library. If not supported on hardware returns NULL.
        """
    def FBOGetDimensions(self,theFbo : OCP.Standard.Standard_Transient) -> tuple[int, int, int, int]: 
        """
        Read offscreen FBO configuration.
        """
    def FBORelease(self,theFbo : OCP.Standard.Standard_Transient) -> Any: 
        """
        Remove offscreen FBO from the graphic library
        """
    def GetGraduatedTrihedron(self) -> Graphic3d_GraduatedTrihedron: 
        """
        Returns data of a graduated trihedron
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GradientBackground(self) -> OCP.Aspect.Aspect_GradientBackground: 
        """
        Returns gradient background fill colors.
        """
    def GraduatedTrihedronDisplay(self,theTrihedronData : Graphic3d_GraduatedTrihedron) -> None: 
        """
        Displays Graduated Trihedron.
        """
    def GraduatedTrihedronErase(self) -> None: 
        """
        Erases Graduated Trihedron.
        """
    def GraduatedTrihedronMinMaxValues(self,theMin : OCP.gp.gp_Vec3f,theMax : OCP.gp.gp_Vec3f) -> None: 
        """
        Sets minimum and maximum points of scene bounding box for Graduated Trihedron stored in graphic view object.
        """
    def IBLCubeMap(self) -> Graphic3d_CubeMap: 
        """
        Returns cubemap being set last time on background.
        """
    def Identification(self) -> int: 
        """
        Returns the identification number of the view.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InitXR(self) -> bool: 
        """
        Initialize XR session.
        """
    def InsertLayerAfter(self,theNewLayerId : int,theSettings : Graphic3d_ZLayerSettings,theLayerBefore : int) -> None: 
        """
        Add a layer to the view.
        """
    def InsertLayerBefore(self,theNewLayerId : int,theSettings : Graphic3d_ZLayerSettings,theLayerAfter : int) -> None: 
        """
        Add a layer to the view.
        """
    def Invalidate(self) -> None: 
        """
        Invalidates content of the view but does not redraw it.
        """
    def InvalidateBVHData(self,theLayerId : int) -> None: 
        """
        Marks BVH tree and the set of BVH primitives of correspondent priority list with id theLayerId as outdated.
        """
    def InvalidateZLayerBoundingBox(self,theLayerId : int) -> None: 
        """
        Returns the bounding box of all structures displayed in the Z layer.
        """
    def IsActive(self) -> bool: 
        """
        Returns the activity flag of the view.
        """
    def IsActiveXR(self) -> bool: 
        """
        Return TRUE if there is active XR session.
        """
    def IsComputed(self,theStructId : int,theComputedStruct : Graphic3d_Structure) -> bool: 
        """
        Returns Standard_True in case if the structure with the given <theStructId> is in list of structures to be computed and stores computed struct to <theComputedStruct>.
        """
    def IsDefined(self) -> bool: 
        """
        Returns True if the window associated to the view is defined.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    def IsInvalidated(self) -> bool: 
        """
        Return true if view content cache has been invalidated.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsRemoved(self) -> bool: 
        """
        Returns true if the view was removed.
        """
    def IsSubViewRelativeSize(self) -> bool: 
        """
        Return TRUE if subview size is set as proportions relative to parent view.
        """
    def IsSubview(self) -> bool: 
        """
        Return TRUE if this is a subview of another view.
        """
    def IsSubviewComposer(self) -> bool: 
        """
        Return TRUE if this is view performs rendering of subviews and nothing else; FALSE by default. By default, view with subviews will render main scene and blit subviews on top of it. Rendering of main scene might become redundant in case if subviews cover entire window of parent view. This flag allows to disable rendering of the main scene in such scenarios without creation of a dedicated V3d_Viewer instance just for composing subviews.
        """
    def Layer(self,theLayerId : int) -> Graphic3d_Layer: 
        """
        Returns layer with given ID or NULL if undefined.
        """
    def Layers(self) -> Any: 
        """
        Returns the list of layers.
        """
    def Lights(self) -> Graphic3d_LightSet: 
        """
        Returns list of lights of the view.
        """
    @overload
    def MinMaxValues(self,theToIncludeAuxiliary : bool=False) -> OCP.Bnd.Bnd_Box: 
        """
        Returns the bounding box of all structures displayed in the view. If theToIncludeAuxiliary is TRUE, then the boundary box also includes minimum and maximum limits of graphical elements forming parts of infinite and other auxiliary structures.

        Returns the coordinates of the boundary box of all structures in the set <theSet>. If <theToIgnoreInfiniteFlag> is TRUE, then the boundary box also includes minimum and maximum limits of graphical elements forming parts of infinite structures.
        """
    @overload
    def MinMaxValues(self,theSet : Any,theToIncludeAuxiliary : bool=False) -> OCP.Bnd.Bnd_Box: ...
    def NumberOfDisplayedStructures(self) -> int: 
        """
        Returns number of displayed structures in the view.
        """
    def ParentView(self) -> Graphic3d_CView: 
        """
        Return parent View or NULL if this is not a subview.
        """
    def PoseXRToWorld(self,thePoseXR : OCP.gp.gp_Trsf) -> OCP.gp.gp_Trsf: 
        """
        Convert XR pose to world space.
        """
    def PosedXRCamera(self) -> Graphic3d_Camera: 
        """
        Returns transient XR camera position with tracked head orientation applied.
        """
    def ProcessXRInput(self) -> None: 
        """
        Process input.
        """
    def ReCompute(self,theStructure : Graphic3d_Structure) -> None: 
        """
        Computes the new presentation of the structure displayed in this view with the type Graphic3d_TOS_COMPUTED.
        """
    def Redraw(self) -> None: 
        """
        Redraw content of the view.
        """
    def RedrawImmediate(self) -> None: 
        """
        Redraw immediate content of the view.
        """
    def ReleaseXR(self) -> None: 
        """
        Release XR session.
        """
    def Remove(self) -> None: 
        """
        Erases the view and removes from graphic driver. No more graphic operations are allowed in this view after the call.
        """
    def RemoveSubview(self,theView : Graphic3d_CView) -> bool: 
        """
        Remove subview from the list.
        """
    def RemoveZLayer(self,theLayerId : int) -> None: 
        """
        Remove Z layer from the specified view. All structures displayed at the moment in layer will be displayed in default layer ( the bottom-level z layer ). To unset layer ID from associated structures use method UnsetZLayer (...).
        """
    def RenderingParams(self) -> Graphic3d_RenderingParams: 
        """
        Returns current rendering parameters and effect settings.
        """
    def Resized(self) -> None: 
        """
        Handle changing size of the rendering window.
        """
    def SetBackfacingModel(self,theModel : Graphic3d_TypeOfBackfacingModel) -> None: 
        """
        Sets backfacing model for the view.
        """
    def SetBackground(self,theBackground : OCP.Aspect.Aspect_Background) -> None: 
        """
        Sets background fill color.
        """
    def SetBackgroundImage(self,theTextureMap : Graphic3d_TextureMap,theToUpdatePBREnv : bool=True) -> None: 
        """
        Sets image texture or environment cubemap as background.
        """
    def SetBackgroundImageStyle(self,theFillStyle : OCP.Aspect.Aspect_FillMethod) -> None: 
        """
        Sets background image fill style.
        """
    def SetBackgroundSkydome(self,theAspect : OCP.Aspect.Aspect_SkydomeBackground,theToUpdatePBREnv : bool=True) -> None: 
        """
        Sets skydome aspect
        """
    def SetBackgroundType(self,theType : Graphic3d_TypeOfBackground) -> None: 
        """
        Sets background type.
        """
    def SetBaseXRCamera(self,theCamera : Graphic3d_Camera) -> None: 
        """
        Sets anchor camera definition.
        """
    def SetCamera(self,theCamera : Graphic3d_Camera) -> None: 
        """
        Sets camera used by the view.
        """
    def SetClipPlanes(self,thePlanes : Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Sets list of clip planes for the view.
        """
    def SetComputedMode(self,theMode : bool) -> None: 
        """
        Switches computed HLR mode in the view
        """
    def SetFBO(self,theFbo : OCP.Standard.Standard_Transient) -> None: 
        """
        Sets framebuffer object for offscreen rendering.
        """
    def SetGradientBackground(self,theBackground : OCP.Aspect.Aspect_GradientBackground) -> None: 
        """
        Sets gradient background fill colors.
        """
    def SetImageBasedLighting(self,theToEnableIBL : bool) -> None: 
        """
        Enables or disables IBL (Image Based Lighting) from background cubemap. Has no effect if PBR is not used.
        """
    def SetImmediateModeDrawToFront(self,theDrawToFrontBuffer : bool) -> bool: 
        """
        Returns previous mode.
        """
    def SetLights(self,theLights : Graphic3d_LightSet) -> None: 
        """
        Sets list of lights for the view.
        """
    def SetPosedXRCamera(self,theCamera : Graphic3d_Camera) -> None: 
        """
        Sets transient XR camera position with tracked head orientation applied.
        """
    def SetShadingModel(self,theModel : Graphic3d_TypeOfShadingModel) -> None: 
        """
        Sets default Shading Model of the view. Will throw an exception on attempt to set Graphic3d_TypeOfShadingModel_DEFAULT.
        """
    def SetSubviewComposer(self,theIsComposer : bool) -> None: 
        """
        Set if this view should perform composing of subviews and nothing else.
        """
    def SetSubviewCorner(self,thePos : OCP.Aspect.Aspect_TypeOfTriedronPosition) -> None: 
        """
        Set subview position within parent view.
        """
    def SetSubviewMargins(self,theMargins : Graphic3d_Vec2i) -> None: 
        """
        Set subview margins in pixels.
        """
    def SetSubviewOffset(self,theOffset : Graphic3d_Vec2d) -> None: 
        """
        Set corner offset within parent view.
        """
    def SetSubviewSize(self,theSize : Graphic3d_Vec2d) -> None: 
        """
        Set subview size relative to parent view.
        """
    def SetTextureEnv(self,theTextureEnv : Graphic3d_TextureEnv) -> None: 
        """
        Sets environment texture for the view.
        """
    def SetToFlipOutput(self,arg0 : bool) -> None: 
        """
        Sets state of flip OY necessity in projection matrix
        """
    def SetUnitFactor(self,theFactor : float) -> None: 
        """
        Set unit scale factor.
        """
    def SetVisualizationType(self,theType : Graphic3d_TypeOfVisualization) -> None: 
        """
        Sets visualization type of the view.
        """
    def SetWindow(self,theParentVIew : Graphic3d_CView,theWindow : OCP.Aspect.Aspect_Window,theContext : capsule) -> None: 
        """
        Creates and maps rendering window to the view.
        """
    def SetXRSession(self,theSession : OCP.Aspect.Aspect_XRSession) -> None: 
        """
        Set XR session.
        """
    def SetZLayerRedrawMode(self,theMode : bool) -> None: 
        """
        Sets ZLayerId redraw mode.
        """
    def SetZLayerSettings(self,theLayerId : int,theSettings : Graphic3d_ZLayerSettings) -> None: 
        """
        Sets the settings for a single Z layer of specified view.
        """
    def SetZLayerTarget(self,theTarget : int) -> None: 
        """
        Sets ZLayerId target.
        """
    def SetupXRPosedCamera(self) -> None: 
        """
        Compute PosedXRCamera() based on current XR head pose and make it active.
        """
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel: 
        """
        Returns default Shading Model of the view; Graphic3d_TypeOfShadingModel_Phong by default.
        """
    def ShadowMapDump(self,theImage : OCP.Image.Image_PixMap,theLightName : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Dumps the graphical contents of a shadowmap framebuffer into an image.
        """
    @overload
    def StatisticInformation(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns string with statistic performance info.

        Fills in the dictionary with statistic performance info.
        """
    @overload
    def StatisticInformation(self,theDict : OCP.TColStd.TColStd_IndexedDataMapOfStringString) -> None: ...
    def StructureManager(self) -> Graphic3d_StructureManager: 
        """
        Returns the structure manager handle which manage structures associated with this view.
        """
    def SubviewCorner(self) -> OCP.Aspect.Aspect_TypeOfTriedronPosition: 
        """
        Return subview position within parent view; Aspect_TOTP_LEFT_UPPER by default.
        """
    def SubviewMargins(self) -> Graphic3d_Vec2i: 
        """
        Return subview margins in pixels; (0,0) by default
        """
    def SubviewOffset(self) -> Graphic3d_Vec2d: 
        """
        Return corner offset within parent view; (0.0,0.0) by default. Values >= 2 define offset in pixels; Values <= 1.0 define offset as fraction of parent view dimensions.
        """
    def SubviewResized(self,theWindow : OCP.Aspect.Aspect_NeutralWindow) -> None: 
        """
        Update subview position and dimensions.
        """
    def SubviewSize(self) -> Graphic3d_Vec2d: 
        """
        Return subview dimensions; (1.0, 1.0) by default. Values >= 2 define size in pixels; Values <= 1.0 define size as fraction of parent view.
        """
    def SubviewTopLeft(self) -> Graphic3d_Vec2i: 
        """
        Return subview top-left position relative to parent view in pixels.
        """
    def Subviews(self) -> Any: 
        """
        Return subview list.
        """
    def SynchronizeXRBaseToPosedCamera(self) -> None: 
        """
        Recomputes PosedXRCamera() based on BaseXRCamera() and head orientation.
        """
    def SynchronizeXRPosedToBaseCamera(self) -> None: 
        """
        Checks if PosedXRCamera() has been modified since SetupXRPosedCamera() and copies these modifications to BaseXRCamera().
        """
    def TextureEnv(self) -> Graphic3d_TextureEnv: 
        """
        Returns environment texture set for the view.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToFlipOutput(self) -> bool: 
        """
        Returns necessity to flip OY in projection matrix
        """
    def TurnViewXRCamera(self,theTrsfTurn : OCP.gp.gp_Trsf) -> None: 
        """
        Turn XR camera direction using current (head) eye position as anchor.
        """
    def UnitFactor(self) -> float: 
        """
        Return unit scale factor defined as scale factor for m (meters); 1.0 by default. Normally, view definition is unitless, however some operations like VR input requires proper units mapping.
        """
    def UnsetXRPosedCamera(self) -> None: 
        """
        Set current camera back to BaseXRCamera() and copy temporary modifications of PosedXRCamera(). Calls SynchronizeXRPosedToBaseCamera() beforehand.
        """
    def Update(self,theLayerId : int=-1) -> None: 
        """
        Invalidates bounding box of specified ZLayerId.
        """
    def ViewAxisInWorld(self,thePoseXR : OCP.gp.gp_Trsf) -> OCP.gp.gp_Ax1: 
        """
        Returns view direction in the world space based on XR pose.
        """
    def VisualizationType(self) -> Graphic3d_TypeOfVisualization: 
        """
        Returns visualization type of the view.
        """
    def Window(self) -> OCP.Aspect.Aspect_Window: 
        """
        Returns the window associated to the view.
        """
    def XRSession(self) -> OCP.Aspect.Aspect_XRSession: 
        """
        Return XR session.
        """
    def ZLayerMax(self) -> int: 
        """
        Returns the maximum Z layer ID. First layer ID is Graphic3d_ZLayerId_Default, last ID is ZLayerMax().
        """
    def ZLayerRedrawMode(self) -> bool: 
        """
        Returns ZLayerId redraw mode
        """
    def ZLayerTarget(self) -> int: 
        """
        Returns ZLayerId target
        """
    def __init__(self,theMgr : Graphic3d_StructureManager) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_DiagnosticInfo():
    """
    Diagnostic info categories bit flags.

    Members:

      Graphic3d_DiagnosticInfo_Device

      Graphic3d_DiagnosticInfo_FrameBuffer

      Graphic3d_DiagnosticInfo_Limits

      Graphic3d_DiagnosticInfo_Memory

      Graphic3d_DiagnosticInfo_NativePlatform

      Graphic3d_DiagnosticInfo_Extensions

      Graphic3d_DiagnosticInfo_Short

      Graphic3d_DiagnosticInfo_Basic

      Graphic3d_DiagnosticInfo_Complete
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_DiagnosticInfo_Basic: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Basic: 31>
    Graphic3d_DiagnosticInfo_Complete: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Complete: 63>
    Graphic3d_DiagnosticInfo_Device: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Device: 1>
    Graphic3d_DiagnosticInfo_Extensions: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Extensions: 32>
    Graphic3d_DiagnosticInfo_FrameBuffer: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_FrameBuffer: 2>
    Graphic3d_DiagnosticInfo_Limits: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Limits: 4>
    Graphic3d_DiagnosticInfo_Memory: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Memory: 8>
    Graphic3d_DiagnosticInfo_NativePlatform: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_NativePlatform: 16>
    Graphic3d_DiagnosticInfo_Short: OCP.Graphic3d.Graphic3d_DiagnosticInfo # value = <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Short: 7>
    __entries: dict # value = {'Graphic3d_DiagnosticInfo_Device': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Device: 1>, None), 'Graphic3d_DiagnosticInfo_FrameBuffer': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_FrameBuffer: 2>, None), 'Graphic3d_DiagnosticInfo_Limits': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Limits: 4>, None), 'Graphic3d_DiagnosticInfo_Memory': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Memory: 8>, None), 'Graphic3d_DiagnosticInfo_NativePlatform': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_NativePlatform: 16>, None), 'Graphic3d_DiagnosticInfo_Extensions': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Extensions: 32>, None), 'Graphic3d_DiagnosticInfo_Short': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Short: 7>, None), 'Graphic3d_DiagnosticInfo_Basic': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Basic: 31>, None), 'Graphic3d_DiagnosticInfo_Complete': (<Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Complete: 63>, None)}
    __members__: dict # value = {'Graphic3d_DiagnosticInfo_Device': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Device: 1>, 'Graphic3d_DiagnosticInfo_FrameBuffer': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_FrameBuffer: 2>, 'Graphic3d_DiagnosticInfo_Limits': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Limits: 4>, 'Graphic3d_DiagnosticInfo_Memory': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Memory: 8>, 'Graphic3d_DiagnosticInfo_NativePlatform': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_NativePlatform: 16>, 'Graphic3d_DiagnosticInfo_Extensions': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Extensions: 32>, 'Graphic3d_DiagnosticInfo_Short': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Short: 7>, 'Graphic3d_DiagnosticInfo_Basic': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Basic: 31>, 'Graphic3d_DiagnosticInfo_Complete': <Graphic3d_DiagnosticInfo.Graphic3d_DiagnosticInfo_Complete: 63>}
    pass
class Graphic3d_DisplayPriority():
    """
    Structure priority - range (do not change this range!). Values are between 0 and 10, with 5 used by default. A structure of priority 10 is displayed the last and appears over the others (considering depth test).

    Members:

      Graphic3d_DisplayPriority_INVALID

      Graphic3d_DisplayPriority_Bottom

      Graphic3d_DisplayPriority_AlmostBottom

      Graphic3d_DisplayPriority_Below2

      Graphic3d_DisplayPriority_Below1

      Graphic3d_DisplayPriority_Below

      Graphic3d_DisplayPriority_Normal

      Graphic3d_DisplayPriority_Above

      Graphic3d_DisplayPriority_Above1

      Graphic3d_DisplayPriority_Above2

      Graphic3d_DisplayPriority_Highlight

      Graphic3d_DisplayPriority_Topmost
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_DisplayPriority_Above: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above: 6>
    Graphic3d_DisplayPriority_Above1: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above1: 7>
    Graphic3d_DisplayPriority_Above2: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above2: 8>
    Graphic3d_DisplayPriority_AlmostBottom: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_AlmostBottom: 1>
    Graphic3d_DisplayPriority_Below: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below: 4>
    Graphic3d_DisplayPriority_Below1: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below1: 3>
    Graphic3d_DisplayPriority_Below2: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below2: 2>
    Graphic3d_DisplayPriority_Bottom: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Bottom: 0>
    Graphic3d_DisplayPriority_Highlight: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Highlight: 9>
    Graphic3d_DisplayPriority_INVALID: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_INVALID: -1>
    Graphic3d_DisplayPriority_Normal: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Normal: 5>
    Graphic3d_DisplayPriority_Topmost: OCP.Graphic3d.Graphic3d_DisplayPriority # value = <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Topmost: 10>
    __entries: dict # value = {'Graphic3d_DisplayPriority_INVALID': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_INVALID: -1>, None), 'Graphic3d_DisplayPriority_Bottom': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Bottom: 0>, None), 'Graphic3d_DisplayPriority_AlmostBottom': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_AlmostBottom: 1>, None), 'Graphic3d_DisplayPriority_Below2': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below2: 2>, None), 'Graphic3d_DisplayPriority_Below1': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below1: 3>, None), 'Graphic3d_DisplayPriority_Below': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below: 4>, None), 'Graphic3d_DisplayPriority_Normal': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Normal: 5>, None), 'Graphic3d_DisplayPriority_Above': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above: 6>, None), 'Graphic3d_DisplayPriority_Above1': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above1: 7>, None), 'Graphic3d_DisplayPriority_Above2': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above2: 8>, None), 'Graphic3d_DisplayPriority_Highlight': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Highlight: 9>, None), 'Graphic3d_DisplayPriority_Topmost': (<Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Topmost: 10>, None)}
    __members__: dict # value = {'Graphic3d_DisplayPriority_INVALID': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_INVALID: -1>, 'Graphic3d_DisplayPriority_Bottom': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Bottom: 0>, 'Graphic3d_DisplayPriority_AlmostBottom': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_AlmostBottom: 1>, 'Graphic3d_DisplayPriority_Below2': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below2: 2>, 'Graphic3d_DisplayPriority_Below1': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below1: 3>, 'Graphic3d_DisplayPriority_Below': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Below: 4>, 'Graphic3d_DisplayPriority_Normal': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Normal: 5>, 'Graphic3d_DisplayPriority_Above': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above: 6>, 'Graphic3d_DisplayPriority_Above1': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above1: 7>, 'Graphic3d_DisplayPriority_Above2': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Above2: 8>, 'Graphic3d_DisplayPriority_Highlight': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Highlight: 9>, 'Graphic3d_DisplayPriority_Topmost': <Graphic3d_DisplayPriority.Graphic3d_DisplayPriority_Topmost: 10>}
    pass
class Graphic3d_FrameStats(OCP.Standard.Standard_Transient):
    """
    Class storing the frame statistics.
    """
    def ActiveDataFrame(self) -> Graphic3d_FrameStatsDataTmp: 
        """
        Returns currently filling data frame for modification, should be called between ::FrameStart() and ::FrameEnd() calls.
        """
    def ChangeCounter(self,theCounter : Graphic3d_FrameStatsCounter) -> int: 
        """
        Returns value of specified counter for modification, should be called between ::FrameStart() and ::FrameEnd() calls.
        """
    def ChangeDataFrames(self) -> Any: 
        """
        Returns data frames.
        """
    def ChangeTimer(self,theTimer : Graphic3d_FrameStatsTimer) -> float: 
        """
        Returns value of specified timer for modification, should be called between ::FrameStart() and ::FrameEnd() calls.
        """
    def CounterValue(self,theCounter : Graphic3d_FrameStatsCounter) -> int: 
        """
        Returns value of specified counter, cached between stats updates. Should NOT be called between ::FrameStart() and ::FrameEnd() calls.
        """
    def DataFrames(self) -> Any: 
        """
        Returns data frames.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    @overload
    def FormatStats(self,theFlags : Any) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns formatted string.

        Fill in the dictionary with formatted statistic info.
        """
    @overload
    def FormatStats(self,theDict : OCP.TColStd.TColStd_IndexedDataMapOfStringString,theFlags : Any) -> None: ...
    def FrameDuration(self) -> float: 
        """
        Returns duration of the last frame in seconds.
        """
    def FrameEnd(self,theView : Graphic3d_CView,theIsImmediateOnly : bool) -> None: 
        """
        Frame redraw finished.
        """
    def FrameRate(self) -> float: 
        """
        Returns FPS (frames per seconds, elapsed time). This number indicates an actual frame rate averaged for several frames within UpdateInterval() duration, basing on a real elapsed time between updates.
        """
    def FrameRateCpu(self) -> float: 
        """
        Returns CPU FPS (frames per seconds, CPU time). This number indicates a PREDICTED frame rate, basing on CPU elapsed time between updates and NOT real elapsed time (which might include periods of CPU inactivity). Number is expected to be greater then actual frame rate returned by FrameRate(). Values significantly greater actual frame rate indicate that rendering is limited by GPU performance (CPU is stalled in-between), while values around actual frame rate indicate rendering being limited by CPU performance (GPU is stalled in-between).
        """
    def FrameStart(self,theView : Graphic3d_CView,theIsImmediateOnly : bool) -> None: 
        """
        Frame redraw started.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasCulledLayers(self) -> bool: 
        """
        Returns TRUE if some Layers have been culled.
        """
    def HasCulledStructs(self) -> bool: 
        """
        Returns TRUE if some structures have been culled.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsLongLineFormat(self) -> bool: 
        """
        Prefer longer lines over more greater of lines.
        """
    def LastDataFrame(self) -> Graphic3d_FrameStatsData: 
        """
        Returns last data frame, cached between stats updates. Should NOT be called between ::FrameStart() and ::FrameEnd() calls.
        """
    def LastDataFrameIndex(self) -> int: 
        """
        Returns last data frame index.
        """
    def SetLongLineFormat(self,theValue : bool) -> None: 
        """
        Set if format should prefer longer lines over greater number of lines.
        """
    def SetUpdateInterval(self,theInterval : float) -> None: 
        """
        Sets interval in seconds for updating values.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def TimerValue(self,theTimer : Graphic3d_FrameStatsTimer) -> float: 
        """
        Returns value of specified timer for modification, should be called between ::FrameStart() and ::FrameEnd() calls. Should NOT be called between ::FrameStart() and ::FrameEnd() calls.
        """
    def UpdateInterval(self) -> float: 
        """
        Returns interval in seconds for updating meters across several frames; 1 second by default.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_FrameStatsCounter():
    """
    Stats counter.

    Members:

      Graphic3d_FrameStatsCounter_NbLayers

      Graphic3d_FrameStatsCounter_NbStructs

      Graphic3d_FrameStatsCounter_EstimatedBytesGeom

      Graphic3d_FrameStatsCounter_EstimatedBytesFbos

      Graphic3d_FrameStatsCounter_EstimatedBytesTextures

      Graphic3d_FrameStatsCounter_NbLayersNotCulled

      Graphic3d_FrameStatsCounter_NbStructsNotCulled

      Graphic3d_FrameStatsCounter_NbGroupsNotCulled

      Graphic3d_FrameStatsCounter_NbElemsNotCulled

      Graphic3d_FrameStatsCounter_NbElemsFillNotCulled

      Graphic3d_FrameStatsCounter_NbElemsLineNotCulled

      Graphic3d_FrameStatsCounter_NbElemsPointNotCulled

      Graphic3d_FrameStatsCounter_NbElemsTextNotCulled

      Graphic3d_FrameStatsCounter_NbTrianglesNotCulled

      Graphic3d_FrameStatsCounter_NbLinesNotCulled

      Graphic3d_FrameStatsCounter_NbPointsNotCulled

      Graphic3d_FrameStatsCounter_NbLayersImmediate

      Graphic3d_FrameStatsCounter_NbStructsImmediate

      Graphic3d_FrameStatsCounter_NbGroupsImmediate

      Graphic3d_FrameStatsCounter_NbElemsImmediate

      Graphic3d_FrameStatsCounter_NbElemsFillImmediate

      Graphic3d_FrameStatsCounter_NbElemsLineImmediate

      Graphic3d_FrameStatsCounter_NbElemsPointImmediate

      Graphic3d_FrameStatsCounter_NbElemsTextImmediate

      Graphic3d_FrameStatsCounter_NbTrianglesImmediate

      Graphic3d_FrameStatsCounter_NbLinesImmediate

      Graphic3d_FrameStatsCounter_NbPointsImmediate
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_FrameStatsCounter_EstimatedBytesFbos: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesFbos: 3>
    Graphic3d_FrameStatsCounter_EstimatedBytesGeom: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesGeom: 2>
    Graphic3d_FrameStatsCounter_EstimatedBytesTextures: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesTextures: 4>
    Graphic3d_FrameStatsCounter_NbElemsFillImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsFillImmediate: 20>
    Graphic3d_FrameStatsCounter_NbElemsFillNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsFillNotCulled: 9>
    Graphic3d_FrameStatsCounter_NbElemsImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsImmediate: 19>
    Graphic3d_FrameStatsCounter_NbElemsLineImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsLineImmediate: 21>
    Graphic3d_FrameStatsCounter_NbElemsLineNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsLineNotCulled: 10>
    Graphic3d_FrameStatsCounter_NbElemsNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsNotCulled: 8>
    Graphic3d_FrameStatsCounter_NbElemsPointImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsPointImmediate: 22>
    Graphic3d_FrameStatsCounter_NbElemsPointNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsPointNotCulled: 11>
    Graphic3d_FrameStatsCounter_NbElemsTextImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsTextImmediate: 23>
    Graphic3d_FrameStatsCounter_NbElemsTextNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsTextNotCulled: 12>
    Graphic3d_FrameStatsCounter_NbGroupsImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbGroupsImmediate: 18>
    Graphic3d_FrameStatsCounter_NbGroupsNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbGroupsNotCulled: 7>
    Graphic3d_FrameStatsCounter_NbLayers: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayers: 0>
    Graphic3d_FrameStatsCounter_NbLayersImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayersImmediate: 16>
    Graphic3d_FrameStatsCounter_NbLayersNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayersNotCulled: 5>
    Graphic3d_FrameStatsCounter_NbLinesImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLinesImmediate: 25>
    Graphic3d_FrameStatsCounter_NbLinesNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLinesNotCulled: 14>
    Graphic3d_FrameStatsCounter_NbPointsImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbPointsImmediate: 26>
    Graphic3d_FrameStatsCounter_NbPointsNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbPointsNotCulled: 15>
    Graphic3d_FrameStatsCounter_NbStructs: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructs: 1>
    Graphic3d_FrameStatsCounter_NbStructsImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructsImmediate: 17>
    Graphic3d_FrameStatsCounter_NbStructsNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructsNotCulled: 6>
    Graphic3d_FrameStatsCounter_NbTrianglesImmediate: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbTrianglesImmediate: 24>
    Graphic3d_FrameStatsCounter_NbTrianglesNotCulled: OCP.Graphic3d.Graphic3d_FrameStatsCounter # value = <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbTrianglesNotCulled: 13>
    __entries: dict # value = {'Graphic3d_FrameStatsCounter_NbLayers': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayers: 0>, None), 'Graphic3d_FrameStatsCounter_NbStructs': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructs: 1>, None), 'Graphic3d_FrameStatsCounter_EstimatedBytesGeom': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesGeom: 2>, None), 'Graphic3d_FrameStatsCounter_EstimatedBytesFbos': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesFbos: 3>, None), 'Graphic3d_FrameStatsCounter_EstimatedBytesTextures': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesTextures: 4>, None), 'Graphic3d_FrameStatsCounter_NbLayersNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayersNotCulled: 5>, None), 'Graphic3d_FrameStatsCounter_NbStructsNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructsNotCulled: 6>, None), 'Graphic3d_FrameStatsCounter_NbGroupsNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbGroupsNotCulled: 7>, None), 'Graphic3d_FrameStatsCounter_NbElemsNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsNotCulled: 8>, None), 'Graphic3d_FrameStatsCounter_NbElemsFillNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsFillNotCulled: 9>, None), 'Graphic3d_FrameStatsCounter_NbElemsLineNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsLineNotCulled: 10>, None), 'Graphic3d_FrameStatsCounter_NbElemsPointNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsPointNotCulled: 11>, None), 'Graphic3d_FrameStatsCounter_NbElemsTextNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsTextNotCulled: 12>, None), 'Graphic3d_FrameStatsCounter_NbTrianglesNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbTrianglesNotCulled: 13>, None), 'Graphic3d_FrameStatsCounter_NbLinesNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLinesNotCulled: 14>, None), 'Graphic3d_FrameStatsCounter_NbPointsNotCulled': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbPointsNotCulled: 15>, None), 'Graphic3d_FrameStatsCounter_NbLayersImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayersImmediate: 16>, None), 'Graphic3d_FrameStatsCounter_NbStructsImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructsImmediate: 17>, None), 'Graphic3d_FrameStatsCounter_NbGroupsImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbGroupsImmediate: 18>, None), 'Graphic3d_FrameStatsCounter_NbElemsImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsImmediate: 19>, None), 'Graphic3d_FrameStatsCounter_NbElemsFillImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsFillImmediate: 20>, None), 'Graphic3d_FrameStatsCounter_NbElemsLineImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsLineImmediate: 21>, None), 'Graphic3d_FrameStatsCounter_NbElemsPointImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsPointImmediate: 22>, None), 'Graphic3d_FrameStatsCounter_NbElemsTextImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsTextImmediate: 23>, None), 'Graphic3d_FrameStatsCounter_NbTrianglesImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbTrianglesImmediate: 24>, None), 'Graphic3d_FrameStatsCounter_NbLinesImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLinesImmediate: 25>, None), 'Graphic3d_FrameStatsCounter_NbPointsImmediate': (<Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbPointsImmediate: 26>, None)}
    __members__: dict # value = {'Graphic3d_FrameStatsCounter_NbLayers': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayers: 0>, 'Graphic3d_FrameStatsCounter_NbStructs': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructs: 1>, 'Graphic3d_FrameStatsCounter_EstimatedBytesGeom': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesGeom: 2>, 'Graphic3d_FrameStatsCounter_EstimatedBytesFbos': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesFbos: 3>, 'Graphic3d_FrameStatsCounter_EstimatedBytesTextures': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_EstimatedBytesTextures: 4>, 'Graphic3d_FrameStatsCounter_NbLayersNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayersNotCulled: 5>, 'Graphic3d_FrameStatsCounter_NbStructsNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructsNotCulled: 6>, 'Graphic3d_FrameStatsCounter_NbGroupsNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbGroupsNotCulled: 7>, 'Graphic3d_FrameStatsCounter_NbElemsNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsNotCulled: 8>, 'Graphic3d_FrameStatsCounter_NbElemsFillNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsFillNotCulled: 9>, 'Graphic3d_FrameStatsCounter_NbElemsLineNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsLineNotCulled: 10>, 'Graphic3d_FrameStatsCounter_NbElemsPointNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsPointNotCulled: 11>, 'Graphic3d_FrameStatsCounter_NbElemsTextNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsTextNotCulled: 12>, 'Graphic3d_FrameStatsCounter_NbTrianglesNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbTrianglesNotCulled: 13>, 'Graphic3d_FrameStatsCounter_NbLinesNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLinesNotCulled: 14>, 'Graphic3d_FrameStatsCounter_NbPointsNotCulled': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbPointsNotCulled: 15>, 'Graphic3d_FrameStatsCounter_NbLayersImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLayersImmediate: 16>, 'Graphic3d_FrameStatsCounter_NbStructsImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbStructsImmediate: 17>, 'Graphic3d_FrameStatsCounter_NbGroupsImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbGroupsImmediate: 18>, 'Graphic3d_FrameStatsCounter_NbElemsImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsImmediate: 19>, 'Graphic3d_FrameStatsCounter_NbElemsFillImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsFillImmediate: 20>, 'Graphic3d_FrameStatsCounter_NbElemsLineImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsLineImmediate: 21>, 'Graphic3d_FrameStatsCounter_NbElemsPointImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsPointImmediate: 22>, 'Graphic3d_FrameStatsCounter_NbElemsTextImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbElemsTextImmediate: 23>, 'Graphic3d_FrameStatsCounter_NbTrianglesImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbTrianglesImmediate: 24>, 'Graphic3d_FrameStatsCounter_NbLinesImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbLinesImmediate: 25>, 'Graphic3d_FrameStatsCounter_NbPointsImmediate': <Graphic3d_FrameStatsCounter.Graphic3d_FrameStatsCounter_NbPointsImmediate: 26>}
    pass
class Graphic3d_FrameStatsData():
    """
    Data frame definition.
    """
    def CounterValue(self,theIndex : Graphic3d_FrameStatsCounter) -> int: 
        """
        Get counter value.
        """
    def FillMax(self,theOther : Graphic3d_FrameStatsData) -> None: 
        """
        Fill with maximum values.
        """
    def FrameRate(self) -> float: 
        """
        Returns FPS (frames per seconds, elapsed time). This number indicates an actual frame rate averaged for several frames within UpdateInterval() duration, basing on a real elapsed time between updates.
        """
    def FrameRateCpu(self) -> float: 
        """
        Returns CPU FPS (frames per seconds, CPU time). This number indicates a PREDICTED frame rate, basing on CPU elapsed time between updates and NOT real elapsed time (which might include periods of CPU inactivity). Number is expected to be greater then actual frame rate returned by FrameRate(). Values significantly greater actual frame rate indicate that rendering is limited by GPU performance (CPU is stalled in-between), while values around actual frame rate indicate rendering being limited by CPU performance (GPU is stalled in-between).
        """
    def ImmediateFrameRate(self) -> float: 
        """
        Returns FPS for immediate redraws.
        """
    def ImmediateFrameRateCpu(self) -> float: 
        """
        Returns CPU FPS for immediate redraws.
        """
    def Reset(self) -> None: 
        """
        Reset data.
        """
    def TimerValue(self,theIndex : Graphic3d_FrameStatsTimer) -> float: 
        """
        Get timer value.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_FrameStatsData) -> None: ...
    pass
class Graphic3d_FrameStatsDataTmp(Graphic3d_FrameStatsData):
    """
    Temporary data frame definition.
    """
    def ChangeCounterValue(self,theIndex : Graphic3d_FrameStatsCounter) -> int: 
        """
        Get counter value.
        """
    def ChangeTimer(self,theTimer : Graphic3d_FrameStatsTimer) -> OCP.OSD.OSD_Timer: 
        """
        Return a timer object for time measurements.
        """
    def ChangeTimerValue(self,theIndex : Graphic3d_FrameStatsTimer) -> float: 
        """
        Modify timer value.
        """
    def CounterValue(self,theIndex : Graphic3d_FrameStatsCounter) -> int: 
        """
        Get counter value.
        """
    def FillMax(self,theOther : Graphic3d_FrameStatsData) -> None: 
        """
        Fill with maximum values.
        """
    def FlushTimers(self,theNbFrames : int,theIsFinal : bool) -> None: 
        """
        Compute average data considering the amount of rendered frames.
        """
    def FrameRate(self) -> float: 
        """
        Returns FPS (frames per seconds, elapsed time). This number indicates an actual frame rate averaged for several frames within UpdateInterval() duration, basing on a real elapsed time between updates.
        """
    def FrameRateCpu(self) -> float: 
        """
        Returns CPU FPS (frames per seconds, CPU time). This number indicates a PREDICTED frame rate, basing on CPU elapsed time between updates and NOT real elapsed time (which might include periods of CPU inactivity). Number is expected to be greater then actual frame rate returned by FrameRate(). Values significantly greater actual frame rate indicate that rendering is limited by GPU performance (CPU is stalled in-between), while values around actual frame rate indicate rendering being limited by CPU performance (GPU is stalled in-between).
        """
    def ImmediateFrameRate(self) -> float: 
        """
        Returns FPS for immediate redraws.
        """
    def ImmediateFrameRateCpu(self) -> float: 
        """
        Returns CPU FPS for immediate redraws.
        """
    def Reset(self) -> None: 
        """
        Reset data.
        """
    def TimerValue(self,theIndex : Graphic3d_FrameStatsTimer) -> float: 
        """
        Get timer value.
        """
    def __init__(self) -> None: ...
    @property
    def ChangeFrameRate(self) -> float:
        """
        Returns FPS (frames per seconds, elapsed time).

        :type: float
        """
    @ChangeFrameRate.setter
    def ChangeFrameRate(self, arg1: float) -> None:
        """
        Returns FPS (frames per seconds, elapsed time).
        """
    @property
    def ChangeFrameRateCpu(self) -> float:
        """
        Returns CPU FPS (frames per seconds, CPU time).

        :type: float
        """
    @ChangeFrameRateCpu.setter
    def ChangeFrameRateCpu(self, arg1: float) -> None:
        """
        Returns CPU FPS (frames per seconds, CPU time).
        """
    @property
    def ChangeImmediateFrameRate(self) -> float:
        """
        Returns FPS for immediate redraws.

        :type: float
        """
    @ChangeImmediateFrameRate.setter
    def ChangeImmediateFrameRate(self, arg1: float) -> None:
        """
        Returns FPS for immediate redraws.
        """
    @property
    def ChangeImmediateFrameRateCpu(self) -> float:
        """
        Returns CPU FPS for immediate redraws.

        :type: float
        """
    @ChangeImmediateFrameRateCpu.setter
    def ChangeImmediateFrameRateCpu(self, arg1: float) -> None:
        """
        Returns CPU FPS for immediate redraws.
        """
    pass
class Graphic3d_FrameStatsTimer():
    """
    Timers for collecting frame performance statistics.

    Members:

      Graphic3d_FrameStatsTimer_ElapsedFrame

      Graphic3d_FrameStatsTimer_CpuFrame

      Graphic3d_FrameStatsTimer_CpuCulling

      Graphic3d_FrameStatsTimer_CpuPicking

      Graphic3d_FrameStatsTimer_CpuDynamics
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_FrameStatsTimer_CpuCulling: OCP.Graphic3d.Graphic3d_FrameStatsTimer # value = <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuCulling: 2>
    Graphic3d_FrameStatsTimer_CpuDynamics: OCP.Graphic3d.Graphic3d_FrameStatsTimer # value = <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuDynamics: 4>
    Graphic3d_FrameStatsTimer_CpuFrame: OCP.Graphic3d.Graphic3d_FrameStatsTimer # value = <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuFrame: 1>
    Graphic3d_FrameStatsTimer_CpuPicking: OCP.Graphic3d.Graphic3d_FrameStatsTimer # value = <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuPicking: 3>
    Graphic3d_FrameStatsTimer_ElapsedFrame: OCP.Graphic3d.Graphic3d_FrameStatsTimer # value = <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_ElapsedFrame: 0>
    __entries: dict # value = {'Graphic3d_FrameStatsTimer_ElapsedFrame': (<Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_ElapsedFrame: 0>, None), 'Graphic3d_FrameStatsTimer_CpuFrame': (<Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuFrame: 1>, None), 'Graphic3d_FrameStatsTimer_CpuCulling': (<Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuCulling: 2>, None), 'Graphic3d_FrameStatsTimer_CpuPicking': (<Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuPicking: 3>, None), 'Graphic3d_FrameStatsTimer_CpuDynamics': (<Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuDynamics: 4>, None)}
    __members__: dict # value = {'Graphic3d_FrameStatsTimer_ElapsedFrame': <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_ElapsedFrame: 0>, 'Graphic3d_FrameStatsTimer_CpuFrame': <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuFrame: 1>, 'Graphic3d_FrameStatsTimer_CpuCulling': <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuCulling: 2>, 'Graphic3d_FrameStatsTimer_CpuPicking': <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuPicking: 3>, 'Graphic3d_FrameStatsTimer_CpuDynamics': <Graphic3d_FrameStatsTimer.Graphic3d_FrameStatsTimer_CpuDynamics: 4>}
    pass
class Graphic3d_Fresnel():
    """
    Describes Fresnel reflectance parameters.
    """
    @staticmethod
    @overload
    def CreateConductor_s(theRefractionIndex : float,theAbsorptionIndex : float) -> Graphic3d_Fresnel: 
        """
        Creates Fresnel factor for physical-based conductor model.

        Creates Fresnel factor for physical-based conductor model (spectral version).
        """
    @staticmethod
    @overload
    def CreateConductor_s(theRefractionIndex : OCP.gp.gp_Vec3f,theAbsorptionIndex : OCP.gp.gp_Vec3f) -> Graphic3d_Fresnel: ...
    @staticmethod
    def CreateConstant_s(theReflection : float) -> Graphic3d_Fresnel: 
        """
        Creates Fresnel factor for constant reflection.
        """
    @staticmethod
    def CreateDielectric_s(theRefractionIndex : float) -> Graphic3d_Fresnel: 
        """
        Creates Fresnel factor for physical-based dielectric model.
        """
    @staticmethod
    def CreateSchlick_s(theSpecularColor : OCP.gp.gp_Vec3f) -> Graphic3d_Fresnel: 
        """
        Creates Schlick's approximation of Fresnel factor.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def FresnelType(self) -> Graphic3d_FresnelModel: 
        """
        Returns type of Fresnel.
        """
    def Serialize(self) -> Graphic3d_Vec4: 
        """
        Returns serialized representation of Fresnel factor.
        """
    def __init__(self) -> None: ...
    pass
class Graphic3d_FresnelModel():
    """
    Type of the Fresnel model.

    Members:

      Graphic3d_FM_SCHLICK

      Graphic3d_FM_CONSTANT

      Graphic3d_FM_CONDUCTOR

      Graphic3d_FM_DIELECTRIC
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_FM_CONDUCTOR: OCP.Graphic3d.Graphic3d_FresnelModel # value = <Graphic3d_FresnelModel.Graphic3d_FM_CONDUCTOR: 2>
    Graphic3d_FM_CONSTANT: OCP.Graphic3d.Graphic3d_FresnelModel # value = <Graphic3d_FresnelModel.Graphic3d_FM_CONSTANT: 1>
    Graphic3d_FM_DIELECTRIC: OCP.Graphic3d.Graphic3d_FresnelModel # value = <Graphic3d_FresnelModel.Graphic3d_FM_DIELECTRIC: 3>
    Graphic3d_FM_SCHLICK: OCP.Graphic3d.Graphic3d_FresnelModel # value = <Graphic3d_FresnelModel.Graphic3d_FM_SCHLICK: 0>
    __entries: dict # value = {'Graphic3d_FM_SCHLICK': (<Graphic3d_FresnelModel.Graphic3d_FM_SCHLICK: 0>, None), 'Graphic3d_FM_CONSTANT': (<Graphic3d_FresnelModel.Graphic3d_FM_CONSTANT: 1>, None), 'Graphic3d_FM_CONDUCTOR': (<Graphic3d_FresnelModel.Graphic3d_FM_CONDUCTOR: 2>, None), 'Graphic3d_FM_DIELECTRIC': (<Graphic3d_FresnelModel.Graphic3d_FM_DIELECTRIC: 3>, None)}
    __members__: dict # value = {'Graphic3d_FM_SCHLICK': <Graphic3d_FresnelModel.Graphic3d_FM_SCHLICK: 0>, 'Graphic3d_FM_CONSTANT': <Graphic3d_FresnelModel.Graphic3d_FM_CONSTANT: 1>, 'Graphic3d_FM_CONDUCTOR': <Graphic3d_FresnelModel.Graphic3d_FM_CONDUCTOR: 2>, 'Graphic3d_FM_DIELECTRIC': <Graphic3d_FresnelModel.Graphic3d_FM_DIELECTRIC: 3>}
    pass
class Graphic3d_GlslExtension():
    """
    GLSL syntax extensions.

    Members:

      Graphic3d_GlslExtension_GL_OES_standard_derivatives

      Graphic3d_GlslExtension_GL_EXT_shader_texture_lod

      Graphic3d_GlslExtension_GL_EXT_frag_depth

      Graphic3d_GlslExtension_GL_EXT_gpu_shader4
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_GlslExtension_GL_EXT_frag_depth: OCP.Graphic3d.Graphic3d_GlslExtension # value = <Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_frag_depth: 2>
    Graphic3d_GlslExtension_GL_EXT_gpu_shader4: OCP.Graphic3d.Graphic3d_GlslExtension # value = <Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_gpu_shader4: 3>
    Graphic3d_GlslExtension_GL_EXT_shader_texture_lod: OCP.Graphic3d.Graphic3d_GlslExtension # value = <Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_shader_texture_lod: 1>
    Graphic3d_GlslExtension_GL_OES_standard_derivatives: OCP.Graphic3d.Graphic3d_GlslExtension # value = <Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_OES_standard_derivatives: 0>
    __entries: dict # value = {'Graphic3d_GlslExtension_GL_OES_standard_derivatives': (<Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_OES_standard_derivatives: 0>, None), 'Graphic3d_GlslExtension_GL_EXT_shader_texture_lod': (<Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_shader_texture_lod: 1>, None), 'Graphic3d_GlslExtension_GL_EXT_frag_depth': (<Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_frag_depth: 2>, None), 'Graphic3d_GlslExtension_GL_EXT_gpu_shader4': (<Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_gpu_shader4: 3>, None)}
    __members__: dict # value = {'Graphic3d_GlslExtension_GL_OES_standard_derivatives': <Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_OES_standard_derivatives: 0>, 'Graphic3d_GlslExtension_GL_EXT_shader_texture_lod': <Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_shader_texture_lod: 1>, 'Graphic3d_GlslExtension_GL_EXT_frag_depth': <Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_frag_depth: 2>, 'Graphic3d_GlslExtension_GL_EXT_gpu_shader4': <Graphic3d_GlslExtension.Graphic3d_GlslExtension_GL_EXT_gpu_shader4: 3>}
    pass
class Graphic3d_GraduatedTrihedron():
    """
    Defines the class of a graduated trihedron. It contains main style parameters for implementation of graduated trihedron
    """
    def ArrowsLength(self) -> float: ...
    def AxisAspectAt(self,theIndex : int) -> Any: ...
    def ChangeAxisAspect(self,theIndex : int) -> Any: ...
    def ChangeXAxisAspect(self) -> Any: ...
    def ChangeYAxisAspect(self) -> Any: ...
    def ChangeZAxisAspect(self) -> Any: ...
    def CubicAxesCallback(self,theView : Graphic3d_CView) -> bool: ...
    def GridColor(self) -> OCP.Quantity.Quantity_Color: ...
    def NamesFont(self) -> OCP.TCollection.TCollection_AsciiString: ...
    def NamesFontAspect(self) -> OCP.Font.Font_FontAspect: ...
    def NamesSize(self) -> int: ...
    def SetArrowsLength(self,theValue : float) -> None: ...
    def SetCubicAxesCallback(self,theCallback : Any) -> None: 
        """
        SetCubicAxesCallback(self: OCP.Graphic3d.Graphic3d_GraduatedTrihedron, theCallback: void (Graphic3d_CView*)) -> None
        """
    def SetDrawAxes(self,theToDraw : bool) -> None: ...
    def SetDrawGrid(self,theToDraw : bool) -> None: ...
    def SetGridColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: ...
    def SetNamesFont(self,theFont : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def SetNamesFontAspect(self,theAspect : OCP.Font.Font_FontAspect) -> None: ...
    def SetNamesSize(self,theValue : int) -> None: ...
    def SetValuesFont(self,theFont : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def SetValuesFontAspect(self,theAspect : OCP.Font.Font_FontAspect) -> None: ...
    def SetValuesSize(self,theValue : int) -> None: ...
    def ToDrawAxes(self) -> bool: ...
    def ToDrawGrid(self) -> bool: ...
    def ValuesFont(self) -> OCP.TCollection.TCollection_AsciiString: ...
    def ValuesFontAspect(self) -> OCP.Font.Font_FontAspect: ...
    def ValuesSize(self) -> int: ...
    def XAxisAspect(self) -> Any: ...
    def YAxisAspect(self) -> Any: ...
    def ZAxisAspect(self) -> Any: ...
    def __init__(self,theNamesFont : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString,theNamesStyle : OCP.Font.Font_FontAspect=Font_FontAspect.Font_FontAspect_Bold,theNamesSize : int=12,theValuesFont : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString,theValuesStyle : OCP.Font.Font_FontAspect=Font_FontAspect.Font_FontAspect_Regular,theValuesSize : int=12,theArrowsLength : float=30.0,theGridColor : OCP.Quantity.Quantity_Color=OCP.Quantity.Quantity_Color,theToDrawGrid : bool=True,theToDrawAxes : bool=True) -> None: ...
    pass
class Graphic3d_GraphicDriver(OCP.Standard.Standard_Transient):
    """
    This class allows the definition of a graphic driver for 3d interface (currently only OpenGl driver is used).This class allows the definition of a graphic driver for 3d interface (currently only OpenGl driver is used).
    """
    def CreateStructure(self,theManager : Graphic3d_StructureManager) -> Graphic3d_CStructure: 
        """
        Creates new empty graphic structure
        """
    def CreateView(self,theMgr : Graphic3d_StructureManager) -> Graphic3d_CView: 
        """
        Creates new view for this graphic driver.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultTextHeight(self) -> float: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableVBO(self,status : bool) -> None: 
        """
        enables/disables usage of OpenGL vertex buffer arrays while drawing primitive arrays
        """
    def GetDisplayConnection(self) -> OCP.Aspect.Aspect_DisplayConnection: 
        """
        returns Handle to display connection
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InquireLightLimit(self) -> int: 
        """
        Request maximum number of active light sources supported by driver and hardware.
        """
    def InquireLimit(self,theType : Graphic3d_TypeOfLimit) -> int: 
        """
        Request limit of graphic resource of specific type.
        """
    def InquirePlaneLimit(self) -> int: 
        """
        Request maximum number of active clipping planes supported by driver and hardware.
        """
    def InquireViewLimit(self) -> int: 
        """
        Request maximum number of views supported by driver.
        """
    def InsertLayerAfter(self,theNewLayerId : int,theSettings : Graphic3d_ZLayerSettings,theLayerBefore : int) -> None: 
        """
        Adds a layer to all views.
        """
    def InsertLayerBefore(self,theNewLayerId : int,theSettings : Graphic3d_ZLayerSettings,theLayerAfter : int) -> None: 
        """
        Adds a layer to all views. To add a structure to desired layer on display it is necessary to set the layer ID for the structure.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsVerticalSync(self) -> bool: 
        """
        Returns TRUE if vertical synchronization with display refresh rate (VSync) should be used; TRUE by default.
        """
    def MemoryInfo(self,theFreeBytes : int,theInfo : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Returns information about GPU memory usage.
        """
    def NewIdentification(self) -> int: 
        """
        Returns a new identification number for a new structure.
        """
    def RemoveIdentification(self,theId : int) -> None: 
        """
        Frees the identifier of a structure.
        """
    def RemoveStructure(self,theCStructure : Graphic3d_CStructure) -> Any: 
        """
        Removes structure from graphic driver and releases its resources.
        """
    def RemoveView(self,theView : Graphic3d_CView) -> None: 
        """
        Removes view from graphic driver and releases its resources.
        """
    def RemoveZLayer(self,theLayerId : int) -> None: 
        """
        Removes Z layer. All structures displayed at the moment in layer will be displayed in default layer (the bottom-level z layer). By default, there are always default bottom-level layer that can't be removed. The passed theLayerId should be not less than 0 (reserved for default layers that can not be removed).
        """
    def SetVerticalSync(self,theToEnable : bool) -> None: 
        """
        Set if vertical synchronization with display refresh rate (VSync) should be used.
        """
    def SetZLayerSettings(self,theLayerId : int,theSettings : Graphic3d_ZLayerSettings) -> None: 
        """
        Sets the settings for a single Z layer.
        """
    def TextSize(self,theView : Graphic3d_CView,theText : str,theHeight : float,theWidth : float,theAscent : float,theDescent : float) -> None: 
        """
        Computes text width.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ViewExists(self,theWindow : OCP.Aspect.Aspect_Window,theView : Graphic3d_CView) -> bool: 
        """
        Returns view associated with the window if it is exists and is activated. Returns Standard_True if the view associated to the window exists.
        """
    def ZLayerSettings(self,theLayerId : int) -> Graphic3d_ZLayerSettings: 
        """
        Returns the settings of a single Z layer.
        """
    def ZLayers(self,theLayerSeq : OCP.TColStd.TColStd_SequenceOfInteger) -> None: 
        """
        Returns list of Z layers defined for the graphical driver.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_GraphicDriverFactory(OCP.Standard.Standard_Transient):
    """
    This class for creation of Graphic3d_GraphicDriver.This class for creation of Graphic3d_GraphicDriver.
    """
    def CreateDriver(self,theDisp : OCP.Aspect.Aspect_DisplayConnection) -> Graphic3d_GraphicDriver: 
        """
        Creates new empty graphic driver.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultDriverFactory_s() -> Graphic3d_GraphicDriverFactory: 
        """
        Return default driver factory or NULL if no one was registered.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    @staticmethod
    def DriverFactories_s() -> Graphic3d_GraphicDriverFactoryList: 
        """
        Return the global map of registered driver factories.
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Return driver factory name.
        """
    @staticmethod
    def RegisterFactory_s(theFactory : Graphic3d_GraphicDriverFactory,theIsPreferred : bool=False) -> None: 
        """
        Registers factory.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @staticmethod
    def UnregisterFactory_s(theName : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Unregisters factory.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_GraphicDriverFactoryList(OCP.NCollection.NCollection_BaseList):
    """
    Purpose: Simple list to link items together keeping the first and the last one. Inherits BaseList, adding the data item to each node.
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : Graphic3d_GraphicDriverFactory) -> Graphic3d_GraphicDriverFactory: 
        """
        Append one item at the end

        Append one item at the end and output iterator pointing at the appended item

        Append another list at the end. After this operation, theOther list will be cleared.
        """
    @overload
    def Append(self,theItem : Graphic3d_GraphicDriverFactory,theIter : Any) -> None: ...
    @overload
    def Append(self,theOther : Graphic3d_GraphicDriverFactoryList) -> None: ...
    def Assign(self,theOther : Graphic3d_GraphicDriverFactoryList) -> Graphic3d_GraphicDriverFactoryList: 
        """
        Replace this list by the items of another list (theOther parameter). This method does not change the internal allocator.
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear this list
        """
    def Extent(self) -> int: ...
    def First(self) -> Graphic3d_GraphicDriverFactory: 
        """
        First item

        First item (non-const)
        """
    @overload
    def InsertAfter(self,theItem : Graphic3d_GraphicDriverFactory,theIter : Any) -> Graphic3d_GraphicDriverFactory: 
        """
        InsertAfter

        InsertAfter
        """
    @overload
    def InsertAfter(self,theOther : Graphic3d_GraphicDriverFactoryList,theIter : Any) -> None: ...
    @overload
    def InsertBefore(self,theItem : Graphic3d_GraphicDriverFactory,theIter : Any) -> Graphic3d_GraphicDriverFactory: 
        """
        InsertBefore

        InsertBefore
        """
    @overload
    def InsertBefore(self,theOther : Graphic3d_GraphicDriverFactoryList,theIter : Any) -> None: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> Graphic3d_GraphicDriverFactory: 
        """
        Last item

        Last item (non-const)
        """
    @overload
    def Prepend(self,theItem : Graphic3d_GraphicDriverFactory) -> Graphic3d_GraphicDriverFactory: 
        """
        Prepend one item at the beginning

        Prepend another list at the beginning
        """
    @overload
    def Prepend(self,theOther : Graphic3d_GraphicDriverFactoryList) -> None: ...
    def Remove(self,theIter : Any) -> None: 
        """
        Remove item pointed by iterator theIter; theIter is then set to the next item
        """
    def RemoveFirst(self) -> None: 
        """
        RemoveFirst item
        """
    def Reverse(self) -> None: 
        """
        Reverse the list
        """
    def Size(self) -> int: 
        """
        Size - Number of items
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_GraphicDriverFactoryList) -> None: ...
    def __iter__(self) -> Iterator[Graphic3d_GraphicDriverFactory]: ...
    def __len__(self) -> int: ...
    pass
class Graphic3d_Group(OCP.Standard.Standard_Transient):
    """
    This class allows the definition of groups of primitives inside of graphic objects (presentations). A group contains the primitives and attributes for which the range is limited to this group. The primitives of a group can be globally suppressed.This class allows the definition of groups of primitives inside of graphic objects (presentations). A group contains the primitives and attributes for which the range is limited to this group. The primitives of a group can be globally suppressed.
    """
    @overload
    def AddPrimitiveArray(self,theType : Graphic3d_TypeOfPrimitiveArray,theIndices : Graphic3d_IndexBuffer,theAttribs : Graphic3d_Buffer,theBounds : Graphic3d_BoundBuffer,theToEvalMinMax : bool=True) -> None: 
        """
        Adds an array of primitives for display

        Adds an array of primitives for display
        """
    @overload
    def AddPrimitiveArray(self,thePrim : Graphic3d_ArrayOfPrimitives,theToEvalMinMax : bool=True) -> None: ...
    def AddText(self,theTextParams : Graphic3d_Text,theToEvalMinMax : bool=True) -> None: 
        """
        Adds a text for display
        """
    def Aspects(self) -> Graphic3d_Aspects: 
        """
        Return fill area aspect.
        """
    def BoundingBox(self) -> Any: 
        """
        Returns boundary box of the group <me> without transformation applied,
        """
    def ChangeBoundingBox(self) -> Any: 
        """
        Returns non-const boundary box of the group <me> without transformation applied,
        """
    def Clear(self,theUpdateStructureMgr : bool=True) -> None: 
        """
        Suppress all primitives and attributes of <me>. To clear group without update in Graphic3d_StructureManager pass Standard_False as <theUpdateStructureMgr>. This used on context and viewer destruction, when the pointer to structure manager in Graphic3d_Structure could be already released (pointers are used here to avoid handle cross-reference);
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsClosed(self) -> bool: 
        """
        Return true if primitive arrays within this graphic group form closed volume (do no contain open shells).
        """
    def IsDeleted(self) -> bool: 
        """
        Returns Standard_True if the group <me> is deleted. <me> is deleted after the call Remove (me) or the associated structure is deleted.
        """
    def IsEmpty(self) -> bool: 
        """
        Returns Standard_True if the group <me> is empty.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Marker(self,thePoint : Graphic3d_Vertex,theToEvalMinMax : bool=True) -> None: ...
    def MinMaxValues(self) -> tuple[float, float, float, float, float, float]: 
        """
        Returns the coordinates of the boundary box of the group.
        """
    def Remove(self) -> None: 
        """
        Suppress the group <me> in the structure. Warning: No more graphic operations in <me> after this call. Modifies the current modelling transform persistence (pan, zoom or rotate) Get the current modelling transform persistence (pan, zoom or rotate)
        """
    def ReplaceAspects(self,theMap : Any) -> None: 
        """
        Replace aspects specified in the replacement map.
        """
    def SetClosed(self,theIsClosed : bool) -> None: 
        """
        Changes property shown that primitive arrays within this group form closed volume (do no contain open shells).
        """
    def SetFlippingOptions(self,theIsEnabled : bool,theRefPlane : OCP.gp.gp_Ax2) -> None: 
        """
        sets the flipping to theIsEnabled state.
        """
    def SetGroupPrimitivesAspect(self,theAspect : Graphic3d_Aspects) -> None: 
        """
        Modifies the context for all the face primitives of the group.
        """
    def SetMinMaxValues(self,theXMin : float,theYMin : float,theZMin : float,theXMax : float,theYMax : float,theZMax : float) -> None: 
        """
        Sets the coordinates of the boundary box of the group.
        """
    def SetPrimitivesAspect(self,theAspect : Graphic3d_Aspects) -> None: 
        """
        Modifies the current context of the group to give another aspect for all the primitives created after this call in the group.
        """
    def SetStencilTestOptions(self,theIsEnabled : bool) -> None: 
        """
        sets the stencil test to theIsEnabled state;
        """
    def SetTransformPersistence(self,theTrsfPers : Graphic3d_TransformPers) -> None: 
        """
        Set transformation persistence.
        """
    def SetTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Assign transformation.
        """
    def Structure(self) -> Graphic3d_Structure: 
        """
        Returns the structure containing the group <me>.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Update presentation aspects after their modification.
        """
    @overload
    def Text(self,AText : str,APoint : Graphic3d_Vertex,AHeight : float,AAngle : float,ATp : Graphic3d_TextPath,AHta : Graphic3d_HorizontalTextAlignment,AVta : Graphic3d_VerticalTextAlignment,EvalMinMax : bool=True) -> None: 
        """
        Creates the string <AText> at position <APoint>. The 3D point of attachment is projected. The text is written in the plane of projection. The attributes are given with respect to the plane of projection. AHeight : Height of text. (Relative to the Normalized Projection Coordinates (NPC) Space). AAngle : Orientation of the text (with respect to the horizontal).

        Creates the string <AText> at position <APoint>. The 3D point of attachment is projected. The text is written in the plane of projection. The attributes are given with respect to the plane of projection. AHeight : Height of text. (Relative to the Normalized Projection Coordinates (NPC) Space). The other attributes have the following default values: AAngle : PI / 2. ATp : TP_RIGHT AHta : HTA_LEFT AVta : VTA_BOTTOM

        Creates the string <AText> at position <APoint>. The 3D point of attachment is projected. The text is written in the plane of projection. The attributes are given with respect to the plane of projection. AHeight : Height of text. (Relative to the Normalized Projection Coordinates (NPC) Space). AAngle : Orientation of the text (with respect to the horizontal).

        Creates the string <AText> at position <APoint>. The 3D point of attachment is projected. The text is written in the plane of projection. The attributes are given with respect to the plane of projection. AHeight : Height of text. (Relative to the Normalized Projection Coordinates (NPC) Space). The other attributes have the following default values: AAngle : PI / 2. ATp : TP_RIGHT AHta : HTA_LEFT AVta : VTA_BOTTOM

        Creates the string <theText> at orientation <theOrientation> in 3D space.

        Creates the string <theText> at orientation <theOrientation> in 3D space.
        """
    @overload
    def Text(self,AText : str,APoint : Graphic3d_Vertex,AHeight : float,EvalMinMax : bool=True) -> None: ...
    @overload
    def Text(self,AText : OCP.TCollection.TCollection_ExtendedString,APoint : Graphic3d_Vertex,AHeight : float,AAngle : float,ATp : Graphic3d_TextPath,AHta : Graphic3d_HorizontalTextAlignment,AVta : Graphic3d_VerticalTextAlignment,EvalMinMax : bool=True) -> None: ...
    @overload
    def Text(self,AText : OCP.TCollection.TCollection_ExtendedString,APoint : Graphic3d_Vertex,AHeight : float,EvalMinMax : bool=True) -> None: ...
    @overload
    def Text(self,theTextUtf : str,theOrientation : OCP.gp.gp_Ax2,theHeight : float,theAngle : float,theTp : Graphic3d_TextPath,theHTA : Graphic3d_HorizontalTextAlignment,theVTA : Graphic3d_VerticalTextAlignment,theToEvalMinMax : bool=True,theHasOwnAnchor : bool=True) -> None: ...
    @overload
    def Text(self,theText : OCP.TCollection.TCollection_ExtendedString,theOrientation : OCP.gp.gp_Ax2,theHeight : float,theAngle : float,theTp : Graphic3d_TextPath,theHTA : Graphic3d_HorizontalTextAlignment,theVTA : Graphic3d_VerticalTextAlignment,theToEvalMinMax : bool=True,theHasOwnAnchor : bool=True) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def TransformPersistence(self) -> Graphic3d_TransformPers: 
        """
        Return transformation persistence.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return transformation.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_GroupAspect():
    """
    Identifies primitives aspects defined per group. - ASPECT_LINE: aspect for line primitives; - ASPECT_TEXT: aspect for text primitives; - ASPECT_MARKER: aspect for marker primitives; - ASPECT_FILL_AREA: aspect for face primitives.

    Members:

      Graphic3d_ASPECT_LINE

      Graphic3d_ASPECT_TEXT

      Graphic3d_ASPECT_MARKER

      Graphic3d_ASPECT_FILL_AREA
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_ASPECT_FILL_AREA: OCP.Graphic3d.Graphic3d_GroupAspect # value = <Graphic3d_GroupAspect.Graphic3d_ASPECT_FILL_AREA: 3>
    Graphic3d_ASPECT_LINE: OCP.Graphic3d.Graphic3d_GroupAspect # value = <Graphic3d_GroupAspect.Graphic3d_ASPECT_LINE: 0>
    Graphic3d_ASPECT_MARKER: OCP.Graphic3d.Graphic3d_GroupAspect # value = <Graphic3d_GroupAspect.Graphic3d_ASPECT_MARKER: 2>
    Graphic3d_ASPECT_TEXT: OCP.Graphic3d.Graphic3d_GroupAspect # value = <Graphic3d_GroupAspect.Graphic3d_ASPECT_TEXT: 1>
    __entries: dict # value = {'Graphic3d_ASPECT_LINE': (<Graphic3d_GroupAspect.Graphic3d_ASPECT_LINE: 0>, None), 'Graphic3d_ASPECT_TEXT': (<Graphic3d_GroupAspect.Graphic3d_ASPECT_TEXT: 1>, None), 'Graphic3d_ASPECT_MARKER': (<Graphic3d_GroupAspect.Graphic3d_ASPECT_MARKER: 2>, None), 'Graphic3d_ASPECT_FILL_AREA': (<Graphic3d_GroupAspect.Graphic3d_ASPECT_FILL_AREA: 3>, None)}
    __members__: dict # value = {'Graphic3d_ASPECT_LINE': <Graphic3d_GroupAspect.Graphic3d_ASPECT_LINE: 0>, 'Graphic3d_ASPECT_TEXT': <Graphic3d_GroupAspect.Graphic3d_ASPECT_TEXT: 1>, 'Graphic3d_ASPECT_MARKER': <Graphic3d_GroupAspect.Graphic3d_ASPECT_MARKER: 2>, 'Graphic3d_ASPECT_FILL_AREA': <Graphic3d_GroupAspect.Graphic3d_ASPECT_FILL_AREA: 3>}
    pass
class Graphic3d_GroupDefinitionError(Exception, BaseException):
    class type():
        pass
    __cause__: getset_descriptor # value = <attribute '__cause__' of 'BaseException' objects>
    __context__: getset_descriptor # value = <attribute '__context__' of 'BaseException' objects>
    __dict__: mappingproxy # value = mappingproxy({'__module__': 'OCP.Graphic3d', '__weakref__': <attribute '__weakref__' of 'Graphic3d_GroupDefinitionError' objects>, '__doc__': None})
    __suppress_context__: member_descriptor # value = <member '__suppress_context__' of 'BaseException' objects>
    __traceback__: getset_descriptor # value = <attribute '__traceback__' of 'BaseException' objects>
    __weakref__: getset_descriptor # value = <attribute '__weakref__' of 'Graphic3d_GroupDefinitionError' objects>
    args: getset_descriptor # value = <attribute 'args' of 'BaseException' objects>
    pass
class Graphic3d_HatchStyle(OCP.Standard.Standard_Transient):
    """
    A class that provides an API to use standard OCCT hatch styles defined in Aspect_HatchStyle enum or to create custom styles from a user-defined bitmapA class that provides an API to use standard OCCT hatch styles defined in Aspect_HatchStyle enum or to create custom styles from a user-defined bitmap
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HatchType(self) -> int: 
        """
        In case if predefined OCCT style is used, returns index in Aspect_HatchStyle enumeration. If the style is custom, returns unique index of the style
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Pattern(self) -> int: 
        """
        Returns the pattern of custom hatch style
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def __init__(self,thePattern : OCP.Image.Image_PixMap) -> None: ...
    @overload
    def __init__(self,theType : OCP.Aspect.Aspect_HatchStyle) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_HorizontalTextAlignment():
    """
    Defines the horizontal position of the text relative to its anchor.

    Members:

      Graphic3d_HTA_LEFT

      Graphic3d_HTA_CENTER

      Graphic3d_HTA_RIGHT
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_HTA_CENTER: OCP.Graphic3d.Graphic3d_HorizontalTextAlignment # value = <Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_CENTER: 1>
    Graphic3d_HTA_LEFT: OCP.Graphic3d.Graphic3d_HorizontalTextAlignment # value = <Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_LEFT: 0>
    Graphic3d_HTA_RIGHT: OCP.Graphic3d.Graphic3d_HorizontalTextAlignment # value = <Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_RIGHT: 2>
    __entries: dict # value = {'Graphic3d_HTA_LEFT': (<Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_LEFT: 0>, None), 'Graphic3d_HTA_CENTER': (<Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_CENTER: 1>, None), 'Graphic3d_HTA_RIGHT': (<Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_RIGHT: 2>, None)}
    __members__: dict # value = {'Graphic3d_HTA_LEFT': <Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_LEFT: 0>, 'Graphic3d_HTA_CENTER': <Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_CENTER: 1>, 'Graphic3d_HTA_RIGHT': <Graphic3d_HorizontalTextAlignment.Graphic3d_HTA_RIGHT: 2>}
    pass
class Graphic3d_IndexBuffer(Graphic3d_Buffer, OCP.NCollection.NCollection_Buffer, OCP.Standard.Standard_Transient):
    """
    Index buffer.Index buffer.
    """
    def Allocate(self,theSize : int) -> bool: 
        """
        Allocate the buffer.
        """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns buffer allocator
        """
    def Attribute(self,theAttribIndex : int) -> Graphic3d_Attribute: 
        """
        Returns attribute definition
        """
    def AttributeData(self,theAttrib : Graphic3d_TypeOfAttribute,theAttribIndex : int,theAttribStride : int) -> int: 
        """
        Return the attribute data with stride size specific to this attribute.
        """
    def AttributeOffset(self,theAttribIndex : int) -> int: 
        """
        Returns data offset to specified attribute
        """
    def AttributesArray(self) -> Graphic3d_Attribute: 
        """
        Returns array of attributes definitions
        """
    def ChangeAttribute(self,theAttribIndex : int) -> Graphic3d_Attribute: 
        """
        Returns attribute definition
        """
    def ChangeAttributeData(self,theAttrib : Graphic3d_TypeOfAttribute,theAttribIndex : int,theAttribStride : int) -> int: 
        """
        Return the attribute data with stride size specific to this attribute.
        """
    def ChangeData(self,theAttribIndex : int) -> int: 
        """
        Returns data for specified attribute
        """
    def Data(self,theAttribIndex : int) -> int: 
        """
        Returns data for specified attribute
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultAllocator_s() -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Return default vertex data allocator.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FindAttribute(self,theAttrib : Graphic3d_TypeOfAttribute) -> int: 
        """
        Find attribute index.
        """
    def Free(self) -> None: 
        """
        De-allocate buffer.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Index(self,theIndex : int) -> int: 
        """
        Access index at specified position
        """
    @overload
    def Init(self,theNbElems : int,theAttribs : Graphic3d_Attribute,theNbAttribs : int) -> bool: 
        """
        Allocates new empty array

        Allocates new empty array
        """
    @overload
    def Init(self,theNbElems : int,theAttribs : Graphic3d_Array1OfAttribute) -> bool: ...
    def InitInt32(self,theNbElems : int) -> bool: 
        """
        Allocates new empty index array
        """
    def Invalidate(self) -> None: 
        """
        Invalidate entire buffer.
        """
    def InvalidatedRange(self) -> Graphic3d_BufferRange: 
        """
        Return invalidated range; EMPTY by default. Requires sub-classing for creating a mutable buffer (advanced usage).
        """
    def IsEmpty(self) -> bool: 
        """
        Returns true if buffer is not allocated
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    def IsInterleaved(self) -> bool: 
        """
        Flag indicating that attributes in the buffer are interleaved; TRUE by default. Requires sub-classing for creating a non-interleaved buffer (advanced usage).
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Return TRUE if data can be invalidated; FALSE by default. Requires sub-classing for creating a mutable buffer (advanced usage).
        """
    def NbMaxElements(self) -> int: 
        """
        Return number of initially allocated elements which can fit into this buffer, while NbElements can be overwritten to smaller value.
        """
    def SetAllocator(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Assign new buffer allocator with de-allocation of buffer.
        """
    def SetIndex(self,theIndex : int,theValue : int) -> None: 
        """
        Change index at specified position
        """
    def Size(self) -> int: 
        """
        Return buffer length in bytes.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Validate(self) -> None: 
        """
        Reset invalidated range. Requires sub-classing for creating a mutable buffer (advanced usage).
        """
    def __init__(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    def changeValue(self,theElem : int) -> int: 
        """
        Access specified element.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    def release(self) -> None: 
        """
        Release buffer.
        """
    def value(self,theElem : int) -> int: 
        """
        Access specified element.
        """
    @property
    def NbAttributes(self) -> int:
        """
        :type: int
        """
    @NbAttributes.setter
    def NbAttributes(self, arg0: int) -> None:
        pass
    @property
    def NbElements(self) -> int:
        """
        :type: int
        """
    @NbElements.setter
    def NbElements(self, arg0: int) -> None:
        pass
    @property
    def Stride(self) -> int:
        """
        :type: int
        """
    @Stride.setter
    def Stride(self, arg0: int) -> None:
        pass
    pass
class Graphic3d_Layer(OCP.Standard.Standard_Transient):
    """
    Presentations list sorted within priorities.
    """
    def Add(self,theStruct : Graphic3d_CStructure,thePriority : Graphic3d_DisplayPriority,isForChangePriority : bool=False) -> None: ...
    def Append(self,theOther : Graphic3d_Layer) -> bool: 
        """
        Append layer of acceptable type (with similar number of priorities or less). Returns Standard_False if the list can not be accepted.
        """
    def ArrayOfStructures(self) -> Any: 
        """
        Returns array of structures.
        """
    def BoundingBox(self,theViewId : int,theCamera : Graphic3d_Camera,theWindowWidth : int,theWindowHeight : int,theToIncludeAuxiliary : bool) -> OCP.Bnd.Bnd_Box: 
        """
        Returns layer bounding box.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FrustumCullingBVHBuilder(self) -> OCP.BVH.BVH_Builder3d: 
        """
        Returns BVH tree builder for frustum culling.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InvalidateBVHData(self) -> None: 
        """
        Marks BVH tree for given priority list as dirty and marks primitive set for rebuild.
        """
    def InvalidateBoundingBox(self) -> None: 
        """
        Marks cached bounding box as obsolete.
        """
    def IsCulled(self) -> bool: 
        """
        Returns TRUE if layer is empty or has been discarded entirely by culling test.
        """
    def IsImmediate(self) -> bool: 
        """
        Return true if layer was marked with immediate flag.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def LayerId(self) -> int: 
        """
        Return layer id.
        """
    def LayerSettings(self) -> Graphic3d_ZLayerSettings: 
        """
        Returns settings of the layer object.
        """
    def NbOfTransformPersistenceObjects(self) -> int: 
        """
        Returns number of transform persistence objects.
        """
    def NbPriorities(self) -> int: 
        """
        Returns the number of available priority levels
        """
    def NbStructures(self) -> int: 
        """
        Returns the number of structures
        """
    def NbStructuresNotCulled(self) -> int: 
        """
        Number of NOT culled structures in the layer.
        """
    def NonCullableStructures(self) -> Any: 
        """
        Returns indexed map of always rendered structures.
        """
    def Remove(self,theStruct : Graphic3d_CStructure,thePriority : Graphic3d_DisplayPriority,isForChangePriority : bool=False) -> bool: 
        """
        Remove structure and returns its priority, if the structure is not found, method returns negative value
        """
    def SetFrustumCullingBVHBuilder(self,theBuilder : OCP.BVH.BVH_Builder3d) -> None: 
        """
        Assigns BVH tree builder for frustum culling.
        """
    def SetLayerSettings(self,theSettings : Graphic3d_ZLayerSettings) -> None: 
        """
        Sets settings of the layer object.
        """
    def Structures(self,thePriority : Graphic3d_DisplayPriority) -> Any: 
        """
        Returns structures for specified priority.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateCulling(self,theViewId : int,theSelector : Graphic3d_CullingTool,theFrustumCullingState : Any) -> None: 
        """
        Update culling state - should be called before rendering. Traverses through BVH tree to determine which structures are in view volume.
        """
    def __init__(self,theId : int,theBuilder : OCP.BVH.BVH_Builder3d) -> None: ...
    def considerZoomPersistenceObjects(self,theViewId : int,theCamera : Graphic3d_Camera,theWindowWidth : int,theWindowHeight : int) -> float: 
        """
        Returns zoom-scale factor.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_LevelOfTextureAnisotropy():
    """
    Level of anisotropy filter. Notice that actual quality depends on hardware capabilities!

    Members:

      Graphic3d_LOTA_OFF

      Graphic3d_LOTA_FAST

      Graphic3d_LOTA_MIDDLE

      Graphic3d_LOTA_QUALITY
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_LOTA_FAST: OCP.Graphic3d.Graphic3d_LevelOfTextureAnisotropy # value = <Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_FAST: 1>
    Graphic3d_LOTA_MIDDLE: OCP.Graphic3d.Graphic3d_LevelOfTextureAnisotropy # value = <Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_MIDDLE: 2>
    Graphic3d_LOTA_OFF: OCP.Graphic3d.Graphic3d_LevelOfTextureAnisotropy # value = <Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_OFF: 0>
    Graphic3d_LOTA_QUALITY: OCP.Graphic3d.Graphic3d_LevelOfTextureAnisotropy # value = <Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_QUALITY: 3>
    __entries: dict # value = {'Graphic3d_LOTA_OFF': (<Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_OFF: 0>, None), 'Graphic3d_LOTA_FAST': (<Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_FAST: 1>, None), 'Graphic3d_LOTA_MIDDLE': (<Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_MIDDLE: 2>, None), 'Graphic3d_LOTA_QUALITY': (<Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_QUALITY: 3>, None)}
    __members__: dict # value = {'Graphic3d_LOTA_OFF': <Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_OFF: 0>, 'Graphic3d_LOTA_FAST': <Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_FAST: 1>, 'Graphic3d_LOTA_MIDDLE': <Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_MIDDLE: 2>, 'Graphic3d_LOTA_QUALITY': <Graphic3d_LevelOfTextureAnisotropy.Graphic3d_LOTA_QUALITY: 3>}
    pass
class Graphic3d_LightSet(OCP.Standard.Standard_Transient):
    """
    Class defining the set of light sources.Class defining the set of light sources.
    """
    class IterationFilter_e():
        """
        Iteration filter flags.

        Members:

          IterationFilter_None

          IterationFilter_ExcludeAmbient

          IterationFilter_ExcludeDisabled

          IterationFilter_ExcludeNoShadow

          IterationFilter_ExcludeDisabledAndAmbient

          IterationFilter_ActiveShadowCasters
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        IterationFilter_ActiveShadowCasters: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ActiveShadowCasters: 14>
        IterationFilter_ExcludeAmbient: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ExcludeAmbient: 2>
        IterationFilter_ExcludeDisabled: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ExcludeDisabled: 4>
        IterationFilter_ExcludeDisabledAndAmbient: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ExcludeDisabledAndAmbient: 6>
        IterationFilter_ExcludeNoShadow: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ExcludeNoShadow: 8>
        IterationFilter_None: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_None: 0>
        __entries: dict # value = {'IterationFilter_None': (<IterationFilter_e.IterationFilter_None: 0>, None), 'IterationFilter_ExcludeAmbient': (<IterationFilter_e.IterationFilter_ExcludeAmbient: 2>, None), 'IterationFilter_ExcludeDisabled': (<IterationFilter_e.IterationFilter_ExcludeDisabled: 4>, None), 'IterationFilter_ExcludeNoShadow': (<IterationFilter_e.IterationFilter_ExcludeNoShadow: 8>, None), 'IterationFilter_ExcludeDisabledAndAmbient': (<IterationFilter_e.IterationFilter_ExcludeDisabledAndAmbient: 6>, None), 'IterationFilter_ActiveShadowCasters': (<IterationFilter_e.IterationFilter_ActiveShadowCasters: 14>, None)}
        __members__: dict # value = {'IterationFilter_None': <IterationFilter_e.IterationFilter_None: 0>, 'IterationFilter_ExcludeAmbient': <IterationFilter_e.IterationFilter_ExcludeAmbient: 2>, 'IterationFilter_ExcludeDisabled': <IterationFilter_e.IterationFilter_ExcludeDisabled: 4>, 'IterationFilter_ExcludeNoShadow': <IterationFilter_e.IterationFilter_ExcludeNoShadow: 8>, 'IterationFilter_ExcludeDisabledAndAmbient': <IterationFilter_e.IterationFilter_ExcludeDisabledAndAmbient: 6>, 'IterationFilter_ActiveShadowCasters': <IterationFilter_e.IterationFilter_ActiveShadowCasters: 14>}
        pass
    def Add(self,theLight : Graphic3d_CLight) -> bool: 
        """
        Append new light source.
        """
    def AmbientColor(self) -> Graphic3d_Vec4: 
        """
        Returns cumulative ambient color, which is computed as sum of all enabled ambient light sources. Values are NOT clamped (can be greater than 1.0f) and alpha component is fixed to 1.0f.
        """
    def Contains(self,theLight : Graphic3d_CLight) -> bool: 
        """
        Return TRUE if light source is defined in this set.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Extent(self) -> int: 
        """
        Return number of light sources.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if lights list is empty.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def KeyEnabledLong(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns a string defining a list of enabled light sources as concatenation of letters 'd' (Directional), 'p' (Point), 's' (Spot) depending on the type of light source in the list. Example: "dppp".
        """
    def KeyEnabledShort(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns a string defining a list of enabled light sources as concatenation of letters 'd' (Directional), 'p' (Point), 's' (Spot) depending on the type of light source in the list, specified only once. Example: "dp".
        """
    def Lower(self) -> int: 
        """
        Return lower light index.
        """
    def NbCastShadows(self) -> int: 
        """
        Returns total amount of enabled lights castings shadows.
        """
    def NbEnabled(self) -> int: 
        """
        Returns total amount of enabled lights EXCLUDING ambient.
        """
    def NbEnabledLightsOfType(self,theType : Graphic3d_TypeOfLightSource) -> int: 
        """
        Returns total amount of enabled lights of specified type.
        """
    def NbLightsOfType(self,theType : Graphic3d_TypeOfLightSource) -> int: 
        """
        Returns total amount of lights of specified type.
        """
    def Remove(self,theLight : Graphic3d_CLight) -> bool: 
        """
        Remove light source.
        """
    def Revision(self) -> int: 
        """
        Return light sources revision.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateRevision(self) -> int: 
        """
        Update light sources revision.
        """
    def Upper(self) -> int: 
        """
        Return upper light index.
        """
    def Value(self,theIndex : int) -> Graphic3d_CLight: 
        """
        Return the light source for specified index within range [Lower(), Upper()].
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    IterationFilter_ActiveShadowCasters: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ActiveShadowCasters: 14>
    IterationFilter_ExcludeAmbient: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ExcludeAmbient: 2>
    IterationFilter_ExcludeDisabled: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ExcludeDisabled: 4>
    IterationFilter_ExcludeDisabledAndAmbient: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ExcludeDisabledAndAmbient: 6>
    IterationFilter_ExcludeNoShadow: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_ExcludeNoShadow: 8>
    IterationFilter_None: OCP.Graphic3d.IterationFilter_e # value = <IterationFilter_e.IterationFilter_None: 0>
    pass
class Graphic3d_MarkerImage(OCP.Standard.Standard_Transient):
    """
    This class is used to store bitmaps and images for markers rendering. It can convert bitmap texture stored in TColStd_HArray1OfByte to Image_PixMap and vice versa.This class is used to store bitmaps and images for markers rendering. It can convert bitmap texture stored in TColStd_HArray1OfByte to Image_PixMap and vice versa.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetBitMapArray(self,theAlphaValue : float=0.5,theIsTopDown : bool=False) -> OCP.TColStd.TColStd_HArray1OfByte: 
        """
        Return marker image as array of bytes. If an instance of the class has been initialized with image, it will be converted to bitmap based on the parameter theAlphaValue.
        """
    def GetImage(self) -> OCP.Image.Image_PixMap: 
        """
        Return marker image. If an instance of the class has been initialized with a bitmap, it will be converted to image.
        """
    def GetImageAlpha(self) -> OCP.Image.Image_PixMap: 
        """
        Return image alpha as grayscale image. Note that if an instance of the class has been initialized with a bitmap or with grayscale image this method will return exactly the same image as GetImage()
        """
    def GetImageAlphaId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Return an unique ID. This ID will be used to manage resource in graphic driver.
        """
    def GetImageId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Return an unique ID. This ID will be used to manage resource in graphic driver.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetTextureSize(self) -> tuple[int, int]: 
        """
        Return texture size
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColoredImage(self) -> bool: 
        """
        Return TRUE if marker image has colors (e.g. RGBA and not grayscale).
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @staticmethod
    def StandardMarker_s(theMarkerType : OCP.Aspect.Aspect_TypeOfMarker,theScale : float,theColor : Graphic3d_Vec4) -> Graphic3d_MarkerImage: 
        """
        Returns a marker image for the marker of the specified type, scale and color.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def __init__(self,theImage : OCP.Image.Image_PixMap,theImageAlpha : OCP.Image.Image_PixMap=None) -> None: ...
    @overload
    def __init__(self,theBitMap : OCP.TColStd.TColStd_HArray1OfByte,theWidth : int,theHeight : int) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Mat4():
    """
    Generic matrix of 4 x 4 elements. To be used in conjunction with NCollection_Vec4 entities. Originally introduced for 3D space projection and orientation operations. Warning, empty constructor returns an identity matrix.
    """
    def Add(self,theMat : Graphic3d_Mat4) -> None: 
        """
        Per-component addition of another matrix.
        """
    def Added(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Per-component addition of another matrix.
        """
    def Adjoint(self) -> Graphic3d_Mat4: 
        """
        Return adjoint (adjugate matrix, e.g. conjugate transpose).
        """
    def ChangeData(self) -> float: ...
    def ChangeValue(self,theRow : int,theCol : int) -> float: 
        """
        Access element at the specified row and column.
        """
    @staticmethod
    def Cols_s() -> int: 
        """
        Get number of columns.
        """
    def DeterminantMat3(self) -> float: 
        """
        Return determinant of the 3x3 sub-matrix.
        """
    def Divide(self,theFactor : float) -> None: 
        """
        Compute per-component division.
        """
    def Divided(self,theScalar : float) -> Graphic3d_Mat4: 
        """
        Divides all the coefficients of the matrix by scalar.
        """
    def DumpJson(self,theOStream : io.BytesIO,arg1 : int) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetColumn(self,theCol : int) -> Graphic3d_Vec4: 
        """
        Get vector of elements for the specified column.
        """
    def GetData(self) -> float: 
        """
        Raw access to the data (for OpenGL exchange); the data is returned in column-major order.
        """
    def GetDiagonal(self) -> Graphic3d_Vec4: 
        """
        Get vector of diagonal elements.
        """
    def GetMat3(self) -> Any: 
        """
        Return 3x3 sub-matrix.
        """
    def GetRow(self,theRow : int) -> Graphic3d_Vec4: 
        """
        Get vector of elements for the specified row.
        """
    def GetValue(self,theRow : int,theCol : int) -> float: 
        """
        Get element at the specified row and column.
        """
    @staticmethod
    def Identity_s() -> Graphic3d_Mat4: 
        """
        Return identity matrix.
        """
    def InitIdentity(self) -> None: 
        """
        Initialize the identity matrix.
        """
    def InitZero(self) -> None: 
        """
        Initialize the zero matrix.
        """
    @overload
    def Inverted(self,theOutMx : Graphic3d_Mat4,theDet : float) -> bool: 
        """
        Compute inverted matrix.

        Compute inverted matrix.

        Return inverted matrix.
        """
    @overload
    def Inverted(self,theOutMx : Graphic3d_Mat4) -> bool: ...
    @overload
    def Inverted(self) -> Graphic3d_Mat4: ...
    def IsEqual(self,theOther : Graphic3d_Mat4) -> bool: 
        """
        Check this matrix for equality with another matrix (without tolerance!).
        """
    def IsIdentity(self) -> bool: 
        """
        Checks the matrix for identity (without tolerance).
        """
    def IsZero(self) -> bool: 
        """
        Checks the matrix for zero (without tolerance).
        """
    @staticmethod
    def Map_s(theData : float) -> Graphic3d_Mat4: 
        """
        Maps plain C array to matrix type.

        Maps plain C array to matrix type.
        """
    @overload
    def Multiplied(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Compute matrix multiplication product.

        Compute per-element multiplication.
        """
    @overload
    def Multiplied(self,theFactor : float) -> Graphic3d_Mat4: ...
    @overload
    def Multiply(self,theMat : Graphic3d_Mat4) -> None: 
        """
        Compute matrix multiplication.

        Compute per-component multiplication.
        """
    @overload
    def Multiply(self,theFactor : float) -> None: ...
    @staticmethod
    def Multiply_s(theMatA : Graphic3d_Mat4,theMatB : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Compute matrix multiplication product: A * B.
        """
    def Negated(self) -> Graphic3d_Mat4: 
        """
        Returns matrix with all components negated.
        """
    @staticmethod
    def Rows_s() -> int: 
        """
        Get number of rows.
        """
    @overload
    def SetColumn(self,theCol : int,theVec : OCP.gp.gp_Vec3f) -> None: 
        """
        Change first 3 column values by the passed vector.

        Set column values by the passed 4 element vector.
        """
    @overload
    def SetColumn(self,theCol : int,theVec : Graphic3d_Vec4) -> None: ...
    @overload
    def SetDiagonal(self,theVec : OCP.gp.gp_Vec3f) -> None: 
        """
        Change first 3 elements of the diagonal matrix.

        Set diagonal elements of the matrix by the passed vector.
        """
    @overload
    def SetDiagonal(self,theVec : Graphic3d_Vec4) -> None: ...
    @overload
    def SetRow(self,theRow : int,theVec : OCP.gp.gp_Vec3f) -> None: 
        """
        Change first 3 row values by the passed vector.

        Set row values by the passed 4 element vector.
        """
    @overload
    def SetRow(self,theRow : int,theVec : Graphic3d_Vec4) -> None: ...
    def SetValue(self,theRow : int,theCol : int,theValue : float) -> None: 
        """
        Set value for the element specified by row and columns.
        """
    def Subtract(self,theMat : Graphic3d_Mat4) -> None: 
        """
        Per-component subtraction of another matrix.
        """
    def Subtracted(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Per-component subtraction of another matrix.
        """
    def Translate(self,theVec : OCP.gp.gp_Vec3f) -> None: 
        """
        Translate the matrix on the passed vector.
        """
    def Transpose(self) -> None: 
        """
        Transpose the matrix.
        """
    def Transposed(self) -> Graphic3d_Mat4: 
        """
        Transpose the matrix.
        """
    @staticmethod
    def Zero_s() -> Graphic3d_Mat4: 
        """
        Return zero matrix.
        """
    def __add__(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Per-component addition of another matrix.
        """
    def __call__(self,theRow : int,theCol : int) -> float: 
        """
        Return value.

        Return value.
        """
    def __iadd__(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Per-component addition of another matrix.
        """
    @overload
    def __imul__(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Multiply by the another matrix.

        Compute per-element multiplication.
        """
    @overload
    def __imul__(self,theFactor : float) -> Graphic3d_Mat4: ...
    def __init__(self) -> None: ...
    def __isub__(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Per-component subtraction of another matrix.
        """
    def __itruediv__(self,theScalar : float) -> Graphic3d_Mat4: 
        """
        Per-component division.
        """
    @overload
    def __mul__(self,theVec : Graphic3d_Vec4) -> Graphic3d_Vec4: 
        """
        Multiply by the vector (M * V).

        Compute matrix multiplication product.

        Compute per-element multiplication.
        """
    @overload
    def __mul__(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: ...
    @overload
    def __mul__(self,theFactor : float) -> Graphic3d_Mat4: ...
    @overload
    def __rmul__(self,theVec : Graphic3d_Vec4) -> Graphic3d_Vec4: 
        """
        Multiply by the vector (M * V).

        Compute matrix multiplication product.

        Compute per-element multiplication.
        """
    @overload
    def __rmul__(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: ...
    @overload
    def __rmul__(self,theFactor : float) -> Graphic3d_Mat4: ...
    @overload
    def __sub__(self,theMat : Graphic3d_Mat4) -> Graphic3d_Mat4: 
        """
        Per-component subtraction of another matrix.

        Returns matrix with all components negated.
        """
    @overload
    def __sub__(self) -> Graphic3d_Mat4: ...
    def __truediv__(self,theScalar : float) -> Graphic3d_Mat4: 
        """
        Divides all the coefficients of the matrix by scalar.
        """
    pass
class Graphic3d_Mat4d():
    """
    Generic matrix of 4 x 4 elements. To be used in conjunction with NCollection_Vec4 entities. Originally introduced for 3D space projection and orientation operations. Warning, empty constructor returns an identity matrix.
    """
    def Add(self,theMat : Graphic3d_Mat4d) -> None: 
        """
        Per-component addition of another matrix.
        """
    def Added(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Per-component addition of another matrix.
        """
    def Adjoint(self) -> Graphic3d_Mat4d: 
        """
        Return adjoint (adjugate matrix, e.g. conjugate transpose).
        """
    def ChangeData(self) -> float: ...
    def ChangeValue(self,theRow : int,theCol : int) -> float: 
        """
        Access element at the specified row and column.
        """
    @staticmethod
    def Cols_s() -> int: 
        """
        Get number of columns.
        """
    def DeterminantMat3(self) -> float: 
        """
        Return determinant of the 3x3 sub-matrix.
        """
    def Divide(self,theFactor : float) -> None: 
        """
        Compute per-component division.
        """
    def Divided(self,theScalar : float) -> Graphic3d_Mat4d: 
        """
        Divides all the coefficients of the matrix by scalar.
        """
    def DumpJson(self,theOStream : io.BytesIO,arg1 : int) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetColumn(self,theCol : int) -> Graphic3d_Vec4d: 
        """
        Get vector of elements for the specified column.
        """
    def GetData(self) -> float: 
        """
        Raw access to the data (for OpenGL exchange); the data is returned in column-major order.
        """
    def GetDiagonal(self) -> Graphic3d_Vec4d: 
        """
        Get vector of diagonal elements.
        """
    def GetMat3(self) -> Any: 
        """
        Return 3x3 sub-matrix.
        """
    def GetRow(self,theRow : int) -> Graphic3d_Vec4d: 
        """
        Get vector of elements for the specified row.
        """
    def GetValue(self,theRow : int,theCol : int) -> float: 
        """
        Get element at the specified row and column.
        """
    @staticmethod
    def Identity_s() -> Graphic3d_Mat4d: 
        """
        Return identity matrix.
        """
    def InitIdentity(self) -> None: 
        """
        Initialize the identity matrix.
        """
    def InitZero(self) -> None: 
        """
        Initialize the zero matrix.
        """
    @overload
    def Inverted(self,theOutMx : Graphic3d_Mat4d,theDet : float) -> bool: 
        """
        Compute inverted matrix.

        Compute inverted matrix.

        Return inverted matrix.
        """
    @overload
    def Inverted(self,theOutMx : Graphic3d_Mat4d) -> bool: ...
    @overload
    def Inverted(self) -> Graphic3d_Mat4d: ...
    def IsEqual(self,theOther : Graphic3d_Mat4d) -> bool: 
        """
        Check this matrix for equality with another matrix (without tolerance!).
        """
    def IsIdentity(self) -> bool: 
        """
        Checks the matrix for identity (without tolerance).
        """
    def IsZero(self) -> bool: 
        """
        Checks the matrix for zero (without tolerance).
        """
    @staticmethod
    def Map_s(theData : float) -> Graphic3d_Mat4d: 
        """
        Maps plain C array to matrix type.

        Maps plain C array to matrix type.
        """
    @overload
    def Multiplied(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Compute matrix multiplication product.

        Compute per-element multiplication.
        """
    @overload
    def Multiplied(self,theFactor : float) -> Graphic3d_Mat4d: ...
    @overload
    def Multiply(self,theMat : Graphic3d_Mat4d) -> None: 
        """
        Compute matrix multiplication.

        Compute per-component multiplication.
        """
    @overload
    def Multiply(self,theFactor : float) -> None: ...
    @staticmethod
    def Multiply_s(theMatA : Graphic3d_Mat4d,theMatB : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Compute matrix multiplication product: A * B.
        """
    def Negated(self) -> Graphic3d_Mat4d: 
        """
        Returns matrix with all components negated.
        """
    @staticmethod
    def Rows_s() -> int: 
        """
        Get number of rows.
        """
    @overload
    def SetColumn(self,theCol : int,theVec : OCP.SelectMgr.SelectMgr_Vec3) -> None: 
        """
        Change first 3 column values by the passed vector.

        Set column values by the passed 4 element vector.
        """
    @overload
    def SetColumn(self,theCol : int,theVec : Graphic3d_Vec4d) -> None: ...
    @overload
    def SetDiagonal(self,theVec : OCP.SelectMgr.SelectMgr_Vec3) -> None: 
        """
        Change first 3 elements of the diagonal matrix.

        Set diagonal elements of the matrix by the passed vector.
        """
    @overload
    def SetDiagonal(self,theVec : Graphic3d_Vec4d) -> None: ...
    @overload
    def SetRow(self,theRow : int,theVec : OCP.SelectMgr.SelectMgr_Vec3) -> None: 
        """
        Change first 3 row values by the passed vector.

        Set row values by the passed 4 element vector.
        """
    @overload
    def SetRow(self,theRow : int,theVec : Graphic3d_Vec4d) -> None: ...
    def SetValue(self,theRow : int,theCol : int,theValue : float) -> None: 
        """
        Set value for the element specified by row and columns.
        """
    def Subtract(self,theMat : Graphic3d_Mat4d) -> None: 
        """
        Per-component subtraction of another matrix.
        """
    def Subtracted(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Per-component subtraction of another matrix.
        """
    def Translate(self,theVec : OCP.SelectMgr.SelectMgr_Vec3) -> None: 
        """
        Translate the matrix on the passed vector.
        """
    def Transpose(self) -> None: 
        """
        Transpose the matrix.
        """
    def Transposed(self) -> Graphic3d_Mat4d: 
        """
        Transpose the matrix.
        """
    @staticmethod
    def Zero_s() -> Graphic3d_Mat4d: 
        """
        Return zero matrix.
        """
    def __add__(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Per-component addition of another matrix.
        """
    def __call__(self,theRow : int,theCol : int) -> float: 
        """
        Return value.

        Return value.
        """
    def __iadd__(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Per-component addition of another matrix.
        """
    @overload
    def __imul__(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Multiply by the another matrix.

        Compute per-element multiplication.
        """
    @overload
    def __imul__(self,theFactor : float) -> Graphic3d_Mat4d: ...
    def __init__(self) -> None: ...
    def __isub__(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Per-component subtraction of another matrix.
        """
    def __itruediv__(self,theScalar : float) -> Graphic3d_Mat4d: 
        """
        Per-component division.
        """
    @overload
    def __mul__(self,theVec : Graphic3d_Vec4d) -> Graphic3d_Vec4d: 
        """
        Multiply by the vector (M * V).

        Compute matrix multiplication product.

        Compute per-element multiplication.
        """
    @overload
    def __mul__(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: ...
    @overload
    def __mul__(self,theFactor : float) -> Graphic3d_Mat4d: ...
    @overload
    def __rmul__(self,theVec : Graphic3d_Vec4d) -> Graphic3d_Vec4d: 
        """
        Multiply by the vector (M * V).

        Compute matrix multiplication product.

        Compute per-element multiplication.
        """
    @overload
    def __rmul__(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: ...
    @overload
    def __rmul__(self,theFactor : float) -> Graphic3d_Mat4d: ...
    @overload
    def __sub__(self,theMat : Graphic3d_Mat4d) -> Graphic3d_Mat4d: 
        """
        Per-component subtraction of another matrix.

        Returns matrix with all components negated.
        """
    @overload
    def __sub__(self) -> Graphic3d_Mat4d: ...
    def __truediv__(self,theScalar : float) -> Graphic3d_Mat4d: 
        """
        Divides all the coefficients of the matrix by scalar.
        """
    pass
class Graphic3d_MaterialAspect():
    """
    This class allows the definition of the type of a surface. Aspect attributes of a 3d face. Keywords: Material, FillArea, Shininess, Ambient, Color, Diffuse, Specular, Transparency, Emissive, ReflectionMode, BackFace, FrontFace, Reflection, Absorption
    """
    def Alpha(self) -> float: 
        """
        Returns the alpha coefficient of the surface (1.0 - Transparency); 1.0 means opaque.
        """
    def AmbientColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the ambient color of the surface.
        """
    def BSDF(self) -> Graphic3d_BSDF: 
        """
        Returns BSDF (bidirectional scattering distribution function).
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the diffuse color of the surface. WARNING! This method does NOT return color for Graphic3d_MATERIAL_ASPECT material (color is defined by Graphic3d_Aspects::InteriorColor()).
        """
    def DiffuseColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the diffuse color of the surface.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def EmissiveColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the emissive color of the surface.
        """
    def IncreaseShine(self,theDelta : float) -> None: 
        """
        Increases or decreases the luminosity.
        """
    def IsDifferent(self,theOther : Graphic3d_MaterialAspect) -> bool: 
        """
        Returns TRUE if this material differs from specified one.
        """
    def IsEqual(self,theOther : Graphic3d_MaterialAspect) -> bool: 
        """
        Returns TRUE if this material is identical to specified one.
        """
    @staticmethod
    @overload
    def MaterialFromName_s(theName : str,theMat : Graphic3d_NameOfMaterial) -> bool: 
        """
        Finds the material for specified name.

        Returns the material for specified name or Graphic3d_NameOfMaterial_DEFAULT if name is unknown.
        """
    @staticmethod
    @overload
    def MaterialFromName_s(theName : str) -> Graphic3d_NameOfMaterial: ...
    def MaterialName(self) -> str: 
        """
        Returns the given name of this material. This might be:
        """
    @staticmethod
    def MaterialName_s(theRank : int) -> str: 
        """
        Returns the name of the predefined material of specified rank within range [1, NumberOfMaterials()].
        """
    @overload
    def MaterialType(self) -> Graphic3d_TypeOfMaterial: 
        """
        Returns material type.

        Returns TRUE if type of this material is equal to specified type.
        """
    @overload
    def MaterialType(self,theType : Graphic3d_TypeOfMaterial) -> bool: ...
    @staticmethod
    def MaterialType_s(theRank : int) -> Graphic3d_TypeOfMaterial: 
        """
        Returns the type of the predefined material of specified rank within range [1, NumberOfMaterials()].
        """
    def Name(self) -> Graphic3d_NameOfMaterial: 
        """
        Returns the material name (within predefined enumeration).
        """
    @staticmethod
    def NumberOfMaterials_s() -> int: 
        """
        Returns the number of predefined textures.
        """
    def PBRMaterial(self) -> Graphic3d_PBRMaterial: 
        """
        Returns physically based representation of material
        """
    def ReflectionMode(self,theType : Graphic3d_TypeOfReflection) -> bool: 
        """
        Returns TRUE if the reflection mode is active, FALSE otherwise.
        """
    def RefractionIndex(self) -> float: 
        """
        Returns the refraction index of the material
        """
    def RequestedName(self) -> Graphic3d_NameOfMaterial: 
        """
        Returns the material name within predefined enumeration which has been requested (before modifications).
        """
    def Reset(self) -> None: 
        """
        Resets the material with the original values according to the material name but leave the current color values untouched for the material of type ASPECT.
        """
    def SetAlpha(self,theValue : float) -> None: 
        """
        Modifies the alpha coefficient of the surface, where 1.0 is opaque and 0.0 is fully transparent.
        """
    def SetAmbientColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the ambient color of the surface.
        """
    def SetBSDF(self,theBSDF : Graphic3d_BSDF) -> None: 
        """
        Modifies the BSDF (bidirectional scattering distribution function).
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the ambient and diffuse color of the surface. WARNING! Has no effect for Graphic3d_MATERIAL_ASPECT material (color should be set to Graphic3d_Aspects::SetInteriorColor()).
        """
    def SetDiffuseColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the diffuse color of the surface.
        """
    def SetEmissiveColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the emissive color of the surface.
        """
    def SetMaterialName(self,theName : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        The current material become a "UserDefined" material. Set the name of the "UserDefined" material.
        """
    def SetMaterialType(self,theType : Graphic3d_TypeOfMaterial) -> None: 
        """
        Set material type.
        """
    def SetPBRMaterial(self,thePBRMaterial : Graphic3d_PBRMaterial) -> None: 
        """
        Modifies the physically based representation of material
        """
    def SetReflectionModeOff(self,theType : Graphic3d_TypeOfReflection) -> None: 
        """
        Deactivates the reflective properties of the surface with specified reflection type.
        """
    def SetRefractionIndex(self,theValue : float) -> None: 
        """
        Modifies the refraction index of the material. Warning: Raises MaterialDefinitionError if given value is a lesser than 1.0.
        """
    def SetShininess(self,theValue : float) -> None: 
        """
        Modifies the luminosity of the surface. Warning: Raises MaterialDefinitionError if given value is a negative value or greater than 1.0.
        """
    def SetSpecularColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the specular color of the surface.
        """
    def SetTransparency(self,theValue : float) -> None: 
        """
        Modifies the transparency coefficient of the surface, where 0 is opaque and 1 is fully transparent. Transparency is applicable to materials that have at least one of reflection modes (ambient, diffuse, specular or emissive) enabled. See also SetReflectionModeOn() and SetReflectionModeOff() methods.
        """
    def Shininess(self) -> float: 
        """
        Returns the luminosity of the surface.
        """
    def SpecularColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the specular color of the surface.
        """
    def StringName(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the given name of this material. This might be: - given name set by method ::SetMaterialName() - standard name for a material within enumeration - "UserDefined" for non-standard material without name specified externally.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency coefficient of the surface (1.0 - Alpha); 0.0 means opaque.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theName : Graphic3d_NameOfMaterial) -> None: ...
    pass
class Graphic3d_MaterialDefinitionError(Exception, BaseException):
    class type():
        pass
    __cause__: getset_descriptor # value = <attribute '__cause__' of 'BaseException' objects>
    __context__: getset_descriptor # value = <attribute '__context__' of 'BaseException' objects>
    __dict__: mappingproxy # value = mappingproxy({'__module__': 'OCP.Graphic3d', '__weakref__': <attribute '__weakref__' of 'Graphic3d_MaterialDefinitionError' objects>, '__doc__': None})
    __suppress_context__: member_descriptor # value = <member '__suppress_context__' of 'BaseException' objects>
    __traceback__: getset_descriptor # value = <attribute '__traceback__' of 'BaseException' objects>
    __weakref__: getset_descriptor # value = <attribute '__weakref__' of 'Graphic3d_MaterialDefinitionError' objects>
    args: getset_descriptor # value = <attribute 'args' of 'BaseException' objects>
    pass
class Graphic3d_Texture2D(Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    This abstract class for managing 2D texturesThis abstract class for managing 2D textures
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Name(self) -> Graphic3d_NameOfTexture2D: 
        """
        Returns the name of the predefined textures or NOT_2D_UNKNOWN when the name is given as a filename.
        """
    @staticmethod
    def NumberOfTextures_s() -> int: 
        """
        Returns the number of predefined textures.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetImage(self,thePixMap : OCP.Image.Image_PixMap) -> None: 
        """
        Assign new image to the texture. Note that this method does not invalidate already uploaded resources - consider calling ::UpdateRevision() if needed.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    @staticmethod
    def TextureName_s(theRank : int) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the name of the predefined texture of rank <aRank>
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @overload
    def __init__(self,theFileName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @overload
    def __init__(self,theNOT : Graphic3d_NameOfTexture2D) -> None: ...
    @overload
    def __init__(self,thePixMap : OCP.Image.Image_PixMap) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_TextureSet(OCP.Standard.Standard_Transient):
    """
    Class holding array of textures to be mapped as a set. Textures should be defined in ascending order of texture units within the set.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> Graphic3d_TextureMap: 
        """
        Return the first texture.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if texture array is empty.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Lower(self) -> int: 
        """
        Return the lower index in texture set.
        """
    def SetFirst(self,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Return the first texture.
        """
    def SetValue(self,theIndex : int,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Return the texture at specified position within [0, Size()) range.
        """
    def Size(self) -> int: 
        """
        Return number of textures.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Upper(self) -> int: 
        """
        Return the upper index in texture set.
        """
    def Value(self,theIndex : int) -> Graphic3d_TextureMap: 
        """
        Return the texture at specified position within [0, Size()) range.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theNbTextures : int) -> None: ...
    @overload
    def __init__(self,theTexture : Graphic3d_TextureMap) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_MutableIndexBuffer(Graphic3d_IndexBuffer, Graphic3d_Buffer, OCP.NCollection.NCollection_Buffer, OCP.Standard.Standard_Transient):
    """
    Mutable index buffer.
    """
    def Allocate(self,theSize : int) -> bool: 
        """
        Allocate the buffer.
        """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns buffer allocator
        """
    def Attribute(self,theAttribIndex : int) -> Graphic3d_Attribute: 
        """
        Returns attribute definition
        """
    def AttributeData(self,theAttrib : Graphic3d_TypeOfAttribute,theAttribIndex : int,theAttribStride : int) -> int: 
        """
        Return the attribute data with stride size specific to this attribute.
        """
    def AttributeOffset(self,theAttribIndex : int) -> int: 
        """
        Returns data offset to specified attribute
        """
    def AttributesArray(self) -> Graphic3d_Attribute: 
        """
        Returns array of attributes definitions
        """
    def ChangeAttribute(self,theAttribIndex : int) -> Graphic3d_Attribute: 
        """
        Returns attribute definition
        """
    def ChangeAttributeData(self,theAttrib : Graphic3d_TypeOfAttribute,theAttribIndex : int,theAttribStride : int) -> int: 
        """
        Return the attribute data with stride size specific to this attribute.
        """
    def ChangeData(self,theAttribIndex : int) -> int: 
        """
        Returns data for specified attribute
        """
    def Data(self,theAttribIndex : int) -> int: 
        """
        Returns data for specified attribute
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @staticmethod
    def DefaultAllocator_s() -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Return default vertex data allocator.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FindAttribute(self,theAttrib : Graphic3d_TypeOfAttribute) -> int: 
        """
        Find attribute index.
        """
    def Free(self) -> None: 
        """
        De-allocate buffer.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Index(self,theIndex : int) -> int: 
        """
        Access index at specified position
        """
    @overload
    def Init(self,theNbElems : int,theAttribs : Graphic3d_Attribute,theNbAttribs : int) -> bool: 
        """
        Allocates new empty array

        Allocates new empty array
        """
    @overload
    def Init(self,theNbElems : int,theAttribs : Graphic3d_Array1OfAttribute) -> bool: ...
    def InitInt32(self,theNbElems : int) -> bool: 
        """
        Allocates new empty index array
        """
    @overload
    def Invalidate(self) -> None: 
        """
        Invalidate the entire buffer data.

        Invalidate the given indexes (starting from 0)
        """
    @overload
    def Invalidate(self,theIndexLower : int,theIndexUpper : int) -> None: ...
    def InvalidatedRange(self) -> Graphic3d_BufferRange: 
        """
        Return invalidated range.
        """
    def IsEmpty(self) -> bool: 
        """
        Returns true if buffer is not allocated
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    def IsInterleaved(self) -> bool: 
        """
        Flag indicating that attributes in the buffer are interleaved; TRUE by default. Requires sub-classing for creating a non-interleaved buffer (advanced usage).
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Return TRUE if data can be invalidated.
        """
    def NbMaxElements(self) -> int: 
        """
        Return number of initially allocated elements which can fit into this buffer, while NbElements can be overwritten to smaller value.
        """
    def SetAllocator(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Assign new buffer allocator with de-allocation of buffer.
        """
    def SetIndex(self,theIndex : int,theValue : int) -> None: 
        """
        Change index at specified position
        """
    def Size(self) -> int: 
        """
        Return buffer length in bytes.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Validate(self) -> None: 
        """
        Reset invalidated range.
        """
    def __init__(self,theAlloc : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    def changeValue(self,theElem : int) -> int: 
        """
        Access specified element.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    def invalidate(self,theRange : Graphic3d_BufferRange) -> None: 
        """
        Invalidate specified sub-range of data (as byte offsets).
        """
    def release(self) -> None: 
        """
        Release buffer.
        """
    def value(self,theElem : int) -> int: 
        """
        Access specified element.
        """
    @property
    def NbAttributes(self) -> int:
        """
        :type: int
        """
    @NbAttributes.setter
    def NbAttributes(self, arg0: int) -> None:
        pass
    @property
    def NbElements(self) -> int:
        """
        :type: int
        """
    @NbElements.setter
    def NbElements(self, arg0: int) -> None:
        pass
    @property
    def Stride(self) -> int:
        """
        :type: int
        """
    @Stride.setter
    def Stride(self, arg0: int) -> None:
        pass
    pass
class Graphic3d_NameOfMaterial():
    """
    List of named materials (predefined presets). Each preset defines either physical (having natural color) or generic (mutable color) material (

    Members:

      Graphic3d_NameOfMaterial_Brass

      Graphic3d_NameOfMaterial_Bronze

      Graphic3d_NameOfMaterial_Copper

      Graphic3d_NameOfMaterial_Gold

      Graphic3d_NameOfMaterial_Pewter

      Graphic3d_NameOfMaterial_Plastered

      Graphic3d_NameOfMaterial_Plastified

      Graphic3d_NameOfMaterial_Silver

      Graphic3d_NameOfMaterial_Steel

      Graphic3d_NameOfMaterial_Stone

      Graphic3d_NameOfMaterial_ShinyPlastified

      Graphic3d_NameOfMaterial_Satin

      Graphic3d_NameOfMaterial_Metalized

      Graphic3d_NameOfMaterial_Ionized

      Graphic3d_NameOfMaterial_Chrome

      Graphic3d_NameOfMaterial_Aluminum

      Graphic3d_NameOfMaterial_Obsidian

      Graphic3d_NameOfMaterial_Neon

      Graphic3d_NameOfMaterial_Jade

      Graphic3d_NameOfMaterial_Charcoal

      Graphic3d_NameOfMaterial_Water

      Graphic3d_NameOfMaterial_Glass

      Graphic3d_NameOfMaterial_Diamond

      Graphic3d_NameOfMaterial_Transparent

      Graphic3d_NameOfMaterial_DEFAULT

      Graphic3d_NameOfMaterial_UserDefined

      Graphic3d_NOM_BRASS

      Graphic3d_NOM_BRONZE

      Graphic3d_NOM_COPPER

      Graphic3d_NOM_GOLD

      Graphic3d_NOM_PEWTER

      Graphic3d_NOM_PLASTER

      Graphic3d_NOM_PLASTIC

      Graphic3d_NOM_SILVER

      Graphic3d_NOM_STEEL

      Graphic3d_NOM_STONE

      Graphic3d_NOM_SHINY_PLASTIC

      Graphic3d_NOM_SATIN

      Graphic3d_NOM_METALIZED

      Graphic3d_NOM_NEON_GNC

      Graphic3d_NOM_CHROME

      Graphic3d_NOM_ALUMINIUM

      Graphic3d_NOM_OBSIDIAN

      Graphic3d_NOM_NEON_PHC

      Graphic3d_NOM_JADE

      Graphic3d_NOM_CHARCOAL

      Graphic3d_NOM_WATER

      Graphic3d_NOM_GLASS

      Graphic3d_NOM_DIAMOND

      Graphic3d_NOM_TRANSPARENT

      Graphic3d_NOM_DEFAULT

      Graphic3d_NOM_UserDefined
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_NOM_ALUMINIUM: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Aluminum: 15>
    Graphic3d_NOM_BRASS: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Brass: 0>
    Graphic3d_NOM_BRONZE: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Bronze: 1>
    Graphic3d_NOM_CHARCOAL: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Charcoal: 19>
    Graphic3d_NOM_CHROME: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Chrome: 14>
    Graphic3d_NOM_COPPER: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Copper: 2>
    Graphic3d_NOM_DEFAULT: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_DEFAULT: 24>
    Graphic3d_NOM_DIAMOND: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Diamond: 22>
    Graphic3d_NOM_GLASS: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Glass: 21>
    Graphic3d_NOM_GOLD: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Gold: 3>
    Graphic3d_NOM_JADE: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Jade: 18>
    Graphic3d_NOM_METALIZED: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Metalized: 12>
    Graphic3d_NOM_NEON_GNC: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Ionized: 13>
    Graphic3d_NOM_NEON_PHC: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Neon: 17>
    Graphic3d_NOM_OBSIDIAN: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Obsidian: 16>
    Graphic3d_NOM_PEWTER: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Pewter: 4>
    Graphic3d_NOM_PLASTER: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastered: 5>
    Graphic3d_NOM_PLASTIC: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastified: 6>
    Graphic3d_NOM_SATIN: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Satin: 11>
    Graphic3d_NOM_SHINY_PLASTIC: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_ShinyPlastified: 10>
    Graphic3d_NOM_SILVER: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Silver: 7>
    Graphic3d_NOM_STEEL: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Steel: 8>
    Graphic3d_NOM_STONE: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Stone: 9>
    Graphic3d_NOM_TRANSPARENT: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Transparent: 23>
    Graphic3d_NOM_UserDefined: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_UserDefined: 25>
    Graphic3d_NOM_WATER: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Water: 20>
    Graphic3d_NameOfMaterial_Aluminum: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Aluminum: 15>
    Graphic3d_NameOfMaterial_Brass: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Brass: 0>
    Graphic3d_NameOfMaterial_Bronze: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Bronze: 1>
    Graphic3d_NameOfMaterial_Charcoal: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Charcoal: 19>
    Graphic3d_NameOfMaterial_Chrome: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Chrome: 14>
    Graphic3d_NameOfMaterial_Copper: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Copper: 2>
    Graphic3d_NameOfMaterial_DEFAULT: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_DEFAULT: 24>
    Graphic3d_NameOfMaterial_Diamond: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Diamond: 22>
    Graphic3d_NameOfMaterial_Glass: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Glass: 21>
    Graphic3d_NameOfMaterial_Gold: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Gold: 3>
    Graphic3d_NameOfMaterial_Ionized: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Ionized: 13>
    Graphic3d_NameOfMaterial_Jade: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Jade: 18>
    Graphic3d_NameOfMaterial_Metalized: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Metalized: 12>
    Graphic3d_NameOfMaterial_Neon: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Neon: 17>
    Graphic3d_NameOfMaterial_Obsidian: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Obsidian: 16>
    Graphic3d_NameOfMaterial_Pewter: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Pewter: 4>
    Graphic3d_NameOfMaterial_Plastered: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastered: 5>
    Graphic3d_NameOfMaterial_Plastified: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastified: 6>
    Graphic3d_NameOfMaterial_Satin: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Satin: 11>
    Graphic3d_NameOfMaterial_ShinyPlastified: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_ShinyPlastified: 10>
    Graphic3d_NameOfMaterial_Silver: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Silver: 7>
    Graphic3d_NameOfMaterial_Steel: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Steel: 8>
    Graphic3d_NameOfMaterial_Stone: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Stone: 9>
    Graphic3d_NameOfMaterial_Transparent: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Transparent: 23>
    Graphic3d_NameOfMaterial_UserDefined: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_UserDefined: 25>
    Graphic3d_NameOfMaterial_Water: OCP.Graphic3d.Graphic3d_NameOfMaterial # value = <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Water: 20>
    __entries: dict # value = {'Graphic3d_NameOfMaterial_Brass': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Brass: 0>, None), 'Graphic3d_NameOfMaterial_Bronze': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Bronze: 1>, None), 'Graphic3d_NameOfMaterial_Copper': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Copper: 2>, None), 'Graphic3d_NameOfMaterial_Gold': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Gold: 3>, None), 'Graphic3d_NameOfMaterial_Pewter': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Pewter: 4>, None), 'Graphic3d_NameOfMaterial_Plastered': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastered: 5>, None), 'Graphic3d_NameOfMaterial_Plastified': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastified: 6>, None), 'Graphic3d_NameOfMaterial_Silver': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Silver: 7>, None), 'Graphic3d_NameOfMaterial_Steel': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Steel: 8>, None), 'Graphic3d_NameOfMaterial_Stone': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Stone: 9>, None), 'Graphic3d_NameOfMaterial_ShinyPlastified': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_ShinyPlastified: 10>, None), 'Graphic3d_NameOfMaterial_Satin': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Satin: 11>, None), 'Graphic3d_NameOfMaterial_Metalized': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Metalized: 12>, None), 'Graphic3d_NameOfMaterial_Ionized': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Ionized: 13>, None), 'Graphic3d_NameOfMaterial_Chrome': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Chrome: 14>, None), 'Graphic3d_NameOfMaterial_Aluminum': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Aluminum: 15>, None), 'Graphic3d_NameOfMaterial_Obsidian': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Obsidian: 16>, None), 'Graphic3d_NameOfMaterial_Neon': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Neon: 17>, None), 'Graphic3d_NameOfMaterial_Jade': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Jade: 18>, None), 'Graphic3d_NameOfMaterial_Charcoal': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Charcoal: 19>, None), 'Graphic3d_NameOfMaterial_Water': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Water: 20>, None), 'Graphic3d_NameOfMaterial_Glass': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Glass: 21>, None), 'Graphic3d_NameOfMaterial_Diamond': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Diamond: 22>, None), 'Graphic3d_NameOfMaterial_Transparent': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Transparent: 23>, None), 'Graphic3d_NameOfMaterial_DEFAULT': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_DEFAULT: 24>, None), 'Graphic3d_NameOfMaterial_UserDefined': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_UserDefined: 25>, None), 'Graphic3d_NOM_BRASS': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Brass: 0>, None), 'Graphic3d_NOM_BRONZE': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Bronze: 1>, None), 'Graphic3d_NOM_COPPER': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Copper: 2>, None), 'Graphic3d_NOM_GOLD': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Gold: 3>, None), 'Graphic3d_NOM_PEWTER': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Pewter: 4>, None), 'Graphic3d_NOM_PLASTER': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastered: 5>, None), 'Graphic3d_NOM_PLASTIC': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastified: 6>, None), 'Graphic3d_NOM_SILVER': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Silver: 7>, None), 'Graphic3d_NOM_STEEL': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Steel: 8>, None), 'Graphic3d_NOM_STONE': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Stone: 9>, None), 'Graphic3d_NOM_SHINY_PLASTIC': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_ShinyPlastified: 10>, None), 'Graphic3d_NOM_SATIN': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Satin: 11>, None), 'Graphic3d_NOM_METALIZED': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Metalized: 12>, None), 'Graphic3d_NOM_NEON_GNC': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Ionized: 13>, None), 'Graphic3d_NOM_CHROME': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Chrome: 14>, None), 'Graphic3d_NOM_ALUMINIUM': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Aluminum: 15>, None), 'Graphic3d_NOM_OBSIDIAN': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Obsidian: 16>, None), 'Graphic3d_NOM_NEON_PHC': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Neon: 17>, None), 'Graphic3d_NOM_JADE': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Jade: 18>, None), 'Graphic3d_NOM_CHARCOAL': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Charcoal: 19>, None), 'Graphic3d_NOM_WATER': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Water: 20>, None), 'Graphic3d_NOM_GLASS': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Glass: 21>, None), 'Graphic3d_NOM_DIAMOND': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Diamond: 22>, None), 'Graphic3d_NOM_TRANSPARENT': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Transparent: 23>, None), 'Graphic3d_NOM_DEFAULT': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_DEFAULT: 24>, None), 'Graphic3d_NOM_UserDefined': (<Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_UserDefined: 25>, None)}
    __members__: dict # value = {'Graphic3d_NameOfMaterial_Brass': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Brass: 0>, 'Graphic3d_NameOfMaterial_Bronze': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Bronze: 1>, 'Graphic3d_NameOfMaterial_Copper': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Copper: 2>, 'Graphic3d_NameOfMaterial_Gold': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Gold: 3>, 'Graphic3d_NameOfMaterial_Pewter': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Pewter: 4>, 'Graphic3d_NameOfMaterial_Plastered': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastered: 5>, 'Graphic3d_NameOfMaterial_Plastified': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastified: 6>, 'Graphic3d_NameOfMaterial_Silver': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Silver: 7>, 'Graphic3d_NameOfMaterial_Steel': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Steel: 8>, 'Graphic3d_NameOfMaterial_Stone': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Stone: 9>, 'Graphic3d_NameOfMaterial_ShinyPlastified': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_ShinyPlastified: 10>, 'Graphic3d_NameOfMaterial_Satin': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Satin: 11>, 'Graphic3d_NameOfMaterial_Metalized': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Metalized: 12>, 'Graphic3d_NameOfMaterial_Ionized': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Ionized: 13>, 'Graphic3d_NameOfMaterial_Chrome': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Chrome: 14>, 'Graphic3d_NameOfMaterial_Aluminum': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Aluminum: 15>, 'Graphic3d_NameOfMaterial_Obsidian': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Obsidian: 16>, 'Graphic3d_NameOfMaterial_Neon': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Neon: 17>, 'Graphic3d_NameOfMaterial_Jade': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Jade: 18>, 'Graphic3d_NameOfMaterial_Charcoal': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Charcoal: 19>, 'Graphic3d_NameOfMaterial_Water': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Water: 20>, 'Graphic3d_NameOfMaterial_Glass': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Glass: 21>, 'Graphic3d_NameOfMaterial_Diamond': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Diamond: 22>, 'Graphic3d_NameOfMaterial_Transparent': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Transparent: 23>, 'Graphic3d_NameOfMaterial_DEFAULT': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_DEFAULT: 24>, 'Graphic3d_NameOfMaterial_UserDefined': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_UserDefined: 25>, 'Graphic3d_NOM_BRASS': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Brass: 0>, 'Graphic3d_NOM_BRONZE': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Bronze: 1>, 'Graphic3d_NOM_COPPER': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Copper: 2>, 'Graphic3d_NOM_GOLD': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Gold: 3>, 'Graphic3d_NOM_PEWTER': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Pewter: 4>, 'Graphic3d_NOM_PLASTER': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastered: 5>, 'Graphic3d_NOM_PLASTIC': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Plastified: 6>, 'Graphic3d_NOM_SILVER': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Silver: 7>, 'Graphic3d_NOM_STEEL': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Steel: 8>, 'Graphic3d_NOM_STONE': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Stone: 9>, 'Graphic3d_NOM_SHINY_PLASTIC': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_ShinyPlastified: 10>, 'Graphic3d_NOM_SATIN': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Satin: 11>, 'Graphic3d_NOM_METALIZED': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Metalized: 12>, 'Graphic3d_NOM_NEON_GNC': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Ionized: 13>, 'Graphic3d_NOM_CHROME': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Chrome: 14>, 'Graphic3d_NOM_ALUMINIUM': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Aluminum: 15>, 'Graphic3d_NOM_OBSIDIAN': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Obsidian: 16>, 'Graphic3d_NOM_NEON_PHC': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Neon: 17>, 'Graphic3d_NOM_JADE': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Jade: 18>, 'Graphic3d_NOM_CHARCOAL': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Charcoal: 19>, 'Graphic3d_NOM_WATER': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Water: 20>, 'Graphic3d_NOM_GLASS': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Glass: 21>, 'Graphic3d_NOM_DIAMOND': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Diamond: 22>, 'Graphic3d_NOM_TRANSPARENT': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_Transparent: 23>, 'Graphic3d_NOM_DEFAULT': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_DEFAULT: 24>, 'Graphic3d_NOM_UserDefined': <Graphic3d_NameOfMaterial.Graphic3d_NameOfMaterial_UserDefined: 25>}
    pass
class Graphic3d_NameOfTexture1D():
    """
    Types of standard textures.

    Members:

      Graphic3d_NOT_1D_ELEVATION

      Graphic3d_NOT_1D_UNKNOWN
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_NOT_1D_ELEVATION: OCP.Graphic3d.Graphic3d_NameOfTexture1D # value = <Graphic3d_NameOfTexture1D.Graphic3d_NOT_1D_ELEVATION: 0>
    Graphic3d_NOT_1D_UNKNOWN: OCP.Graphic3d.Graphic3d_NameOfTexture1D # value = <Graphic3d_NameOfTexture1D.Graphic3d_NOT_1D_UNKNOWN: 1>
    __entries: dict # value = {'Graphic3d_NOT_1D_ELEVATION': (<Graphic3d_NameOfTexture1D.Graphic3d_NOT_1D_ELEVATION: 0>, None), 'Graphic3d_NOT_1D_UNKNOWN': (<Graphic3d_NameOfTexture1D.Graphic3d_NOT_1D_UNKNOWN: 1>, None)}
    __members__: dict # value = {'Graphic3d_NOT_1D_ELEVATION': <Graphic3d_NameOfTexture1D.Graphic3d_NOT_1D_ELEVATION: 0>, 'Graphic3d_NOT_1D_UNKNOWN': <Graphic3d_NameOfTexture1D.Graphic3d_NOT_1D_UNKNOWN: 1>}
    pass
class Graphic3d_NameOfTexture2D():
    """
    Types of standard textures.

    Members:

      Graphic3d_NOT_2D_MATRA

      Graphic3d_NOT_2D_ALIENSKIN

      Graphic3d_NOT_2D_BLUE_ROCK

      Graphic3d_NOT_2D_BLUEWHITE_PAPER

      Graphic3d_NOT_2D_BRUSHED

      Graphic3d_NOT_2D_BUBBLES

      Graphic3d_NOT_2D_BUMP

      Graphic3d_NOT_2D_CAST

      Graphic3d_NOT_2D_CHIPBD

      Graphic3d_NOT_2D_CLOUDS

      Graphic3d_NOT_2D_FLESH

      Graphic3d_NOT_2D_FLOOR

      Graphic3d_NOT_2D_GALVNISD

      Graphic3d_NOT_2D_GRASS

      Graphic3d_NOT_2D_ALUMINUM

      Graphic3d_NOT_2D_ROCK

      Graphic3d_NOT_2D_KNURL

      Graphic3d_NOT_2D_MAPLE

      Graphic3d_NOT_2D_MARBLE

      Graphic3d_NOT_2D_MOTTLED

      Graphic3d_NOT_2D_RAIN

      Graphic3d_NOT_2D_CHESS

      Graphic3d_NOT_2D_UNKNOWN
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_NOT_2D_ALIENSKIN: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ALIENSKIN: 1>
    Graphic3d_NOT_2D_ALUMINUM: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ALUMINUM: 14>
    Graphic3d_NOT_2D_BLUEWHITE_PAPER: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BLUEWHITE_PAPER: 3>
    Graphic3d_NOT_2D_BLUE_ROCK: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BLUE_ROCK: 2>
    Graphic3d_NOT_2D_BRUSHED: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BRUSHED: 4>
    Graphic3d_NOT_2D_BUBBLES: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BUBBLES: 5>
    Graphic3d_NOT_2D_BUMP: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BUMP: 6>
    Graphic3d_NOT_2D_CAST: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CAST: 7>
    Graphic3d_NOT_2D_CHESS: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CHESS: 21>
    Graphic3d_NOT_2D_CHIPBD: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CHIPBD: 8>
    Graphic3d_NOT_2D_CLOUDS: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CLOUDS: 9>
    Graphic3d_NOT_2D_FLESH: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_FLESH: 10>
    Graphic3d_NOT_2D_FLOOR: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_FLOOR: 11>
    Graphic3d_NOT_2D_GALVNISD: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_GALVNISD: 12>
    Graphic3d_NOT_2D_GRASS: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_GRASS: 13>
    Graphic3d_NOT_2D_KNURL: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_KNURL: 16>
    Graphic3d_NOT_2D_MAPLE: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MAPLE: 17>
    Graphic3d_NOT_2D_MARBLE: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MARBLE: 18>
    Graphic3d_NOT_2D_MATRA: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MATRA: 0>
    Graphic3d_NOT_2D_MOTTLED: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MOTTLED: 19>
    Graphic3d_NOT_2D_RAIN: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_RAIN: 20>
    Graphic3d_NOT_2D_ROCK: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ROCK: 15>
    Graphic3d_NOT_2D_UNKNOWN: OCP.Graphic3d.Graphic3d_NameOfTexture2D # value = <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_UNKNOWN: 22>
    __entries: dict # value = {'Graphic3d_NOT_2D_MATRA': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MATRA: 0>, None), 'Graphic3d_NOT_2D_ALIENSKIN': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ALIENSKIN: 1>, None), 'Graphic3d_NOT_2D_BLUE_ROCK': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BLUE_ROCK: 2>, None), 'Graphic3d_NOT_2D_BLUEWHITE_PAPER': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BLUEWHITE_PAPER: 3>, None), 'Graphic3d_NOT_2D_BRUSHED': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BRUSHED: 4>, None), 'Graphic3d_NOT_2D_BUBBLES': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BUBBLES: 5>, None), 'Graphic3d_NOT_2D_BUMP': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BUMP: 6>, None), 'Graphic3d_NOT_2D_CAST': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CAST: 7>, None), 'Graphic3d_NOT_2D_CHIPBD': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CHIPBD: 8>, None), 'Graphic3d_NOT_2D_CLOUDS': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CLOUDS: 9>, None), 'Graphic3d_NOT_2D_FLESH': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_FLESH: 10>, None), 'Graphic3d_NOT_2D_FLOOR': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_FLOOR: 11>, None), 'Graphic3d_NOT_2D_GALVNISD': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_GALVNISD: 12>, None), 'Graphic3d_NOT_2D_GRASS': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_GRASS: 13>, None), 'Graphic3d_NOT_2D_ALUMINUM': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ALUMINUM: 14>, None), 'Graphic3d_NOT_2D_ROCK': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ROCK: 15>, None), 'Graphic3d_NOT_2D_KNURL': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_KNURL: 16>, None), 'Graphic3d_NOT_2D_MAPLE': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MAPLE: 17>, None), 'Graphic3d_NOT_2D_MARBLE': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MARBLE: 18>, None), 'Graphic3d_NOT_2D_MOTTLED': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MOTTLED: 19>, None), 'Graphic3d_NOT_2D_RAIN': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_RAIN: 20>, None), 'Graphic3d_NOT_2D_CHESS': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CHESS: 21>, None), 'Graphic3d_NOT_2D_UNKNOWN': (<Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_UNKNOWN: 22>, None)}
    __members__: dict # value = {'Graphic3d_NOT_2D_MATRA': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MATRA: 0>, 'Graphic3d_NOT_2D_ALIENSKIN': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ALIENSKIN: 1>, 'Graphic3d_NOT_2D_BLUE_ROCK': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BLUE_ROCK: 2>, 'Graphic3d_NOT_2D_BLUEWHITE_PAPER': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BLUEWHITE_PAPER: 3>, 'Graphic3d_NOT_2D_BRUSHED': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BRUSHED: 4>, 'Graphic3d_NOT_2D_BUBBLES': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BUBBLES: 5>, 'Graphic3d_NOT_2D_BUMP': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_BUMP: 6>, 'Graphic3d_NOT_2D_CAST': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CAST: 7>, 'Graphic3d_NOT_2D_CHIPBD': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CHIPBD: 8>, 'Graphic3d_NOT_2D_CLOUDS': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CLOUDS: 9>, 'Graphic3d_NOT_2D_FLESH': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_FLESH: 10>, 'Graphic3d_NOT_2D_FLOOR': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_FLOOR: 11>, 'Graphic3d_NOT_2D_GALVNISD': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_GALVNISD: 12>, 'Graphic3d_NOT_2D_GRASS': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_GRASS: 13>, 'Graphic3d_NOT_2D_ALUMINUM': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ALUMINUM: 14>, 'Graphic3d_NOT_2D_ROCK': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_ROCK: 15>, 'Graphic3d_NOT_2D_KNURL': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_KNURL: 16>, 'Graphic3d_NOT_2D_MAPLE': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MAPLE: 17>, 'Graphic3d_NOT_2D_MARBLE': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MARBLE: 18>, 'Graphic3d_NOT_2D_MOTTLED': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_MOTTLED: 19>, 'Graphic3d_NOT_2D_RAIN': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_RAIN: 20>, 'Graphic3d_NOT_2D_CHESS': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_CHESS: 21>, 'Graphic3d_NOT_2D_UNKNOWN': <Graphic3d_NameOfTexture2D.Graphic3d_NOT_2D_UNKNOWN: 22>}
    pass
class Graphic3d_NameOfTextureEnv():
    """
    Types of standard textures.

    Members:

      Graphic3d_NOT_ENV_CLOUDS

      Graphic3d_NOT_ENV_CV

      Graphic3d_NOT_ENV_MEDIT

      Graphic3d_NOT_ENV_PEARL

      Graphic3d_NOT_ENV_SKY1

      Graphic3d_NOT_ENV_SKY2

      Graphic3d_NOT_ENV_LINES

      Graphic3d_NOT_ENV_ROAD

      Graphic3d_NOT_ENV_UNKNOWN
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_NOT_ENV_CLOUDS: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_CLOUDS: 0>
    Graphic3d_NOT_ENV_CV: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_CV: 1>
    Graphic3d_NOT_ENV_LINES: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_LINES: 6>
    Graphic3d_NOT_ENV_MEDIT: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_MEDIT: 2>
    Graphic3d_NOT_ENV_PEARL: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_PEARL: 3>
    Graphic3d_NOT_ENV_ROAD: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_ROAD: 7>
    Graphic3d_NOT_ENV_SKY1: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_SKY1: 4>
    Graphic3d_NOT_ENV_SKY2: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_SKY2: 5>
    Graphic3d_NOT_ENV_UNKNOWN: OCP.Graphic3d.Graphic3d_NameOfTextureEnv # value = <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_UNKNOWN: 8>
    __entries: dict # value = {'Graphic3d_NOT_ENV_CLOUDS': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_CLOUDS: 0>, None), 'Graphic3d_NOT_ENV_CV': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_CV: 1>, None), 'Graphic3d_NOT_ENV_MEDIT': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_MEDIT: 2>, None), 'Graphic3d_NOT_ENV_PEARL': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_PEARL: 3>, None), 'Graphic3d_NOT_ENV_SKY1': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_SKY1: 4>, None), 'Graphic3d_NOT_ENV_SKY2': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_SKY2: 5>, None), 'Graphic3d_NOT_ENV_LINES': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_LINES: 6>, None), 'Graphic3d_NOT_ENV_ROAD': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_ROAD: 7>, None), 'Graphic3d_NOT_ENV_UNKNOWN': (<Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_UNKNOWN: 8>, None)}
    __members__: dict # value = {'Graphic3d_NOT_ENV_CLOUDS': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_CLOUDS: 0>, 'Graphic3d_NOT_ENV_CV': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_CV: 1>, 'Graphic3d_NOT_ENV_MEDIT': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_MEDIT: 2>, 'Graphic3d_NOT_ENV_PEARL': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_PEARL: 3>, 'Graphic3d_NOT_ENV_SKY1': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_SKY1: 4>, 'Graphic3d_NOT_ENV_SKY2': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_SKY2: 5>, 'Graphic3d_NOT_ENV_LINES': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_LINES: 6>, 'Graphic3d_NOT_ENV_ROAD': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_ROAD: 7>, 'Graphic3d_NOT_ENV_UNKNOWN': <Graphic3d_NameOfTextureEnv.Graphic3d_NOT_ENV_UNKNOWN: 8>}
    pass
class Graphic3d_NameOfTexturePlane():
    """
    Type of the texture projection plane for both S and T texture coordinate.

    Members:

      Graphic3d_NOTP_XY

      Graphic3d_NOTP_YZ

      Graphic3d_NOTP_ZX

      Graphic3d_NOTP_UNKNOWN
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_NOTP_UNKNOWN: OCP.Graphic3d.Graphic3d_NameOfTexturePlane # value = <Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_UNKNOWN: 3>
    Graphic3d_NOTP_XY: OCP.Graphic3d.Graphic3d_NameOfTexturePlane # value = <Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_XY: 0>
    Graphic3d_NOTP_YZ: OCP.Graphic3d.Graphic3d_NameOfTexturePlane # value = <Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_YZ: 1>
    Graphic3d_NOTP_ZX: OCP.Graphic3d.Graphic3d_NameOfTexturePlane # value = <Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_ZX: 2>
    __entries: dict # value = {'Graphic3d_NOTP_XY': (<Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_XY: 0>, None), 'Graphic3d_NOTP_YZ': (<Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_YZ: 1>, None), 'Graphic3d_NOTP_ZX': (<Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_ZX: 2>, None), 'Graphic3d_NOTP_UNKNOWN': (<Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_UNKNOWN: 3>, None)}
    __members__: dict # value = {'Graphic3d_NOTP_XY': <Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_XY: 0>, 'Graphic3d_NOTP_YZ': <Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_YZ: 1>, 'Graphic3d_NOTP_ZX': <Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_ZX: 2>, 'Graphic3d_NOTP_UNKNOWN': <Graphic3d_NameOfTexturePlane.Graphic3d_NOTP_UNKNOWN: 3>}
    pass
class Graphic3d_PBRMaterial():
    """
    Class implementing Metallic-Roughness physically based material definition
    """
    def Alpha(self) -> float: 
        """
        Returns alpha component in range [0, 1].
        """
    def Color(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Returns albedo color with alpha component of material.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def Emission(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns light intensity emitted by material. Values are greater or equal 0.
        """
    @staticmethod
    def GenerateEnvLUT_s(theLUT : OCP.Image.Image_PixMap,theNbIntegralSamples : int=1024) -> None: 
        """
        Generates 2D look up table of scale and bias for fresnell zero coefficient. It is needed for calculation reflectance part of environment lighting.
        """
    def IOR(self) -> float: 
        """
        Returns index of refraction in [1, 3] range.
        """
    def Metallic(self) -> float: 
        """
        Returns material's metallic coefficient in [0, 1] range. 1 for metals and 0 for dielectrics. It is preferable to be exactly 0 or 1. Average values are needed for textures mixing in shader.
        """
    @staticmethod
    def MetallicFromSpecular_s(theSpecular : OCP.Quantity.Quantity_Color) -> float: 
        """
        Compute material metallicity from common material (specular color).
        """
    @staticmethod
    def MinRoughness_s() -> float: 
        """
        Roughness cannot be 0 in real calculations, so it returns minimal achievable level of roughness in practice
        """
    def NormalizedRoughness(self) -> float: 
        """
        Returns roughness mapping parameter in [0, 1] range. Roughness is defined in [0, 1] for handful material settings and is mapped to [MinRoughness, 1] for calculations.
        """
    def Roughness(self) -> float: 
        """
        Returns real value of roughness in [MinRoughness, 1] range for calculations.
        """
    @staticmethod
    def RoughnessFromSpecular_s(theSpecular : OCP.Quantity.Quantity_Color,theShiness : float) -> float: 
        """
        Compute material roughness from common material (specular color + shininess).
        """
    @staticmethod
    def Roughness_s(theNormalizedRoughness : float) -> float: 
        """
        Maps roughness from [0, 1] to [MinRoughness, 1] for calculations.
        """
    def SetAlpha(self,theAlpha : float) -> None: 
        """
        Modifies alpha component.
        """
    def SetBSDF(self,theBSDF : Graphic3d_BSDF) -> None: 
        """
        Generates material in Metallic-Roughness system from Graphic3d_BSDF.
        """
    @overload
    def SetColor(self,theColor : OCP.Quantity.Quantity_ColorRGBA) -> None: 
        """
        Modifies albedo color with alpha component.

        Modifies only albedo color.
        """
    @overload
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: ...
    def SetEmission(self,theEmission : OCP.gp.gp_Vec3f) -> None: 
        """
        Modifies light intensity emitted by material.
        """
    def SetIOR(self,theIOR : float) -> None: 
        """
        Modifies index of refraction in [1, 3] range. In practice affects only on non-metal materials reflection possibilities.
        """
    def SetMetallic(self,theMetallic : float) -> None: 
        """
        Modifies metallic coefficient of material in [0, 1] range.
        """
    def SetRoughness(self,theRoughness : float) -> None: 
        """
        Modifies roughness coefficient of material in [0, 1] range.
        """
    @staticmethod
    def SpecIBLMapSamplesFactor_s(theProbability : float,theRoughness : float) -> float: 
        """
        Shows how much times less samples can be used in certain roughness value specular IBL map generation in compare with samples number for map with roughness of 1. Specular IBL maps with less roughness values have higher resolution but require less samples for the same quality of baking. So that reducing samples number is good strategy to improve performance of baking. The samples number for specular IBL map with roughness of 1 (the maximum possible samples number) is expected to be defined as baking parameter. Samples number for other roughness values can be calculated by multiplication origin samples number by this factor.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theBSDF : Graphic3d_BSDF) -> None: ...
    pass
class Graphic3d_PolygonOffset():
    """
    Polygon offset parameters.
    """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def __init__(self) -> None: ...
    @property
    def Factor(self) -> float:
        """
        :type: float
        """
    @Factor.setter
    def Factor(self, arg0: float) -> None:
        pass
    @property
    def Mode(self) -> OCP.Aspect.Aspect_PolygonOffsetMode:
        """
        :type: OCP.Aspect.Aspect_PolygonOffsetMode
        """
    @Mode.setter
    def Mode(self, arg0: OCP.Aspect.Aspect_PolygonOffsetMode) -> None:
        pass
    @property
    def Units(self) -> float:
        """
        :type: float
        """
    @Units.setter
    def Units(self, arg0: float) -> None:
        pass
    pass
class Graphic3d_PresentationAttributes(OCP.Standard.Standard_Transient):
    """
    Class defines presentation properties.Class defines presentation properties.
    """
    def BasicFillAreaAspect(self) -> Graphic3d_AspectFillArea3d: 
        """
        Return basic presentation fill area aspect, NULL by default. When set, might be used instead of Color() property.
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns basic presentation color, Quantity_NOC_WHITE by default.
        """
    def ColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Returns basic presentation color (including alpha channel).
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns display mode, 0 by default. -1 means undefined (main display mode of presentation to be used).
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Method(self) -> OCP.Aspect.Aspect_TypeOfHighlightMethod: 
        """
        Returns highlight method, Aspect_TOHM_COLOR by default.
        """
    def SetBasicFillAreaAspect(self,theAspect : Graphic3d_AspectFillArea3d) -> None: 
        """
        Sets basic presentation fill area aspect.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets basic presentation color (RGB components, does not modifies transparency).
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets display mode.
        """
    def SetMethod(self,theMethod : OCP.Aspect.Aspect_TypeOfHighlightMethod) -> None: 
        """
        Changes highlight method to the given one.
        """
    def SetTransparency(self,theTranspCoef : float) -> None: 
        """
        Sets basic presentation transparency (0 - opaque, 1 - fully transparent).
        """
    def SetZLayer(self,theLayer : int) -> None: 
        """
        Sets presentation Zlayer.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Transparency(self) -> float: 
        """
        Returns basic presentation transparency (0 - opaque, 1 - fully transparent), 0 by default (opaque).
        """
    def ZLayer(self) -> int: 
        """
        Returns presentation Zlayer, Graphic3d_ZLayerId_Default by default. Graphic3d_ZLayerId_UNKNOWN means undefined (a layer of main presentation to be used).
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_PriorityDefinitionError(Exception, BaseException):
    class type():
        pass
    __cause__: getset_descriptor # value = <attribute '__cause__' of 'BaseException' objects>
    __context__: getset_descriptor # value = <attribute '__context__' of 'BaseException' objects>
    __dict__: mappingproxy # value = mappingproxy({'__module__': 'OCP.Graphic3d', '__weakref__': <attribute '__weakref__' of 'Graphic3d_PriorityDefinitionError' objects>, '__doc__': None})
    __suppress_context__: member_descriptor # value = <member '__suppress_context__' of 'BaseException' objects>
    __traceback__: getset_descriptor # value = <attribute '__traceback__' of 'BaseException' objects>
    __weakref__: getset_descriptor # value = <attribute '__weakref__' of 'Graphic3d_PriorityDefinitionError' objects>
    args: getset_descriptor # value = <attribute 'args' of 'BaseException' objects>
    pass
class Graphic3d_RenderTransparentMethod():
    """
    Enumerates transparency rendering methods supported by rasterization mode.

    Members:

      Graphic3d_RTM_BLEND_UNORDERED

      Graphic3d_RTM_BLEND_OIT

      Graphic3d_RTM_DEPTH_PEELING_OIT
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_RTM_BLEND_OIT: OCP.Graphic3d.Graphic3d_RenderTransparentMethod # value = <Graphic3d_RenderTransparentMethod.Graphic3d_RTM_BLEND_OIT: 1>
    Graphic3d_RTM_BLEND_UNORDERED: OCP.Graphic3d.Graphic3d_RenderTransparentMethod # value = <Graphic3d_RenderTransparentMethod.Graphic3d_RTM_BLEND_UNORDERED: 0>
    Graphic3d_RTM_DEPTH_PEELING_OIT: OCP.Graphic3d.Graphic3d_RenderTransparentMethod # value = <Graphic3d_RenderTransparentMethod.Graphic3d_RTM_DEPTH_PEELING_OIT: 2>
    __entries: dict # value = {'Graphic3d_RTM_BLEND_UNORDERED': (<Graphic3d_RenderTransparentMethod.Graphic3d_RTM_BLEND_UNORDERED: 0>, None), 'Graphic3d_RTM_BLEND_OIT': (<Graphic3d_RenderTransparentMethod.Graphic3d_RTM_BLEND_OIT: 1>, None), 'Graphic3d_RTM_DEPTH_PEELING_OIT': (<Graphic3d_RenderTransparentMethod.Graphic3d_RTM_DEPTH_PEELING_OIT: 2>, None)}
    __members__: dict # value = {'Graphic3d_RTM_BLEND_UNORDERED': <Graphic3d_RenderTransparentMethod.Graphic3d_RTM_BLEND_UNORDERED: 0>, 'Graphic3d_RTM_BLEND_OIT': <Graphic3d_RenderTransparentMethod.Graphic3d_RTM_BLEND_OIT: 1>, 'Graphic3d_RTM_DEPTH_PEELING_OIT': <Graphic3d_RenderTransparentMethod.Graphic3d_RTM_DEPTH_PEELING_OIT: 2>}
    pass
class Graphic3d_RenderingMode():
    """
    Describes rendering modes. - RM_RASTERIZATION: enables OpenGL rasterization mode; - RM_RAYTRACING: enables GPU ray-tracing mode.

    Members:

      Graphic3d_RM_RASTERIZATION

      Graphic3d_RM_RAYTRACING
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_RM_RASTERIZATION: OCP.Graphic3d.Graphic3d_RenderingMode # value = <Graphic3d_RenderingMode.Graphic3d_RM_RASTERIZATION: 0>
    Graphic3d_RM_RAYTRACING: OCP.Graphic3d.Graphic3d_RenderingMode # value = <Graphic3d_RenderingMode.Graphic3d_RM_RAYTRACING: 1>
    __entries: dict # value = {'Graphic3d_RM_RASTERIZATION': (<Graphic3d_RenderingMode.Graphic3d_RM_RASTERIZATION: 0>, None), 'Graphic3d_RM_RAYTRACING': (<Graphic3d_RenderingMode.Graphic3d_RM_RAYTRACING: 1>, None)}
    __members__: dict # value = {'Graphic3d_RM_RASTERIZATION': <Graphic3d_RenderingMode.Graphic3d_RM_RASTERIZATION: 0>, 'Graphic3d_RM_RAYTRACING': <Graphic3d_RenderingMode.Graphic3d_RM_RAYTRACING: 1>}
    pass
class Graphic3d_RenderingParams():
    """
    Helper class to store rendering parameters.
    """
    class Anaglyph_e():
        """
        Anaglyph filter presets.

        Members:

          Anaglyph_RedCyan_Simple

          Anaglyph_RedCyan_Optimized

          Anaglyph_YellowBlue_Simple

          Anaglyph_YellowBlue_Optimized

          Anaglyph_GreenMagenta_Simple

          Anaglyph_UserDefined
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        Anaglyph_GreenMagenta_Simple: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_GreenMagenta_Simple: 4>
        Anaglyph_RedCyan_Optimized: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_RedCyan_Optimized: 1>
        Anaglyph_RedCyan_Simple: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_RedCyan_Simple: 0>
        Anaglyph_UserDefined: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_UserDefined: 5>
        Anaglyph_YellowBlue_Optimized: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_YellowBlue_Optimized: 3>
        Anaglyph_YellowBlue_Simple: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_YellowBlue_Simple: 2>
        __entries: dict # value = {'Anaglyph_RedCyan_Simple': (<Anaglyph_e.Anaglyph_RedCyan_Simple: 0>, None), 'Anaglyph_RedCyan_Optimized': (<Anaglyph_e.Anaglyph_RedCyan_Optimized: 1>, None), 'Anaglyph_YellowBlue_Simple': (<Anaglyph_e.Anaglyph_YellowBlue_Simple: 2>, None), 'Anaglyph_YellowBlue_Optimized': (<Anaglyph_e.Anaglyph_YellowBlue_Optimized: 3>, None), 'Anaglyph_GreenMagenta_Simple': (<Anaglyph_e.Anaglyph_GreenMagenta_Simple: 4>, None), 'Anaglyph_UserDefined': (<Anaglyph_e.Anaglyph_UserDefined: 5>, None)}
        __members__: dict # value = {'Anaglyph_RedCyan_Simple': <Anaglyph_e.Anaglyph_RedCyan_Simple: 0>, 'Anaglyph_RedCyan_Optimized': <Anaglyph_e.Anaglyph_RedCyan_Optimized: 1>, 'Anaglyph_YellowBlue_Simple': <Anaglyph_e.Anaglyph_YellowBlue_Simple: 2>, 'Anaglyph_YellowBlue_Optimized': <Anaglyph_e.Anaglyph_YellowBlue_Optimized: 3>, 'Anaglyph_GreenMagenta_Simple': <Anaglyph_e.Anaglyph_GreenMagenta_Simple: 4>, 'Anaglyph_UserDefined': <Anaglyph_e.Anaglyph_UserDefined: 5>}
        pass
    class FrustumCulling_e():
        """
        State of frustum culling optimization.

        Members:

          FrustumCulling_Off

          FrustumCulling_On

          FrustumCulling_NoUpdate
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        FrustumCulling_NoUpdate: OCP.Graphic3d.FrustumCulling_e # value = <FrustumCulling_e.FrustumCulling_NoUpdate: 2>
        FrustumCulling_Off: OCP.Graphic3d.FrustumCulling_e # value = <FrustumCulling_e.FrustumCulling_Off: 0>
        FrustumCulling_On: OCP.Graphic3d.FrustumCulling_e # value = <FrustumCulling_e.FrustumCulling_On: 1>
        __entries: dict # value = {'FrustumCulling_Off': (<FrustumCulling_e.FrustumCulling_Off: 0>, None), 'FrustumCulling_On': (<FrustumCulling_e.FrustumCulling_On: 1>, None), 'FrustumCulling_NoUpdate': (<FrustumCulling_e.FrustumCulling_NoUpdate: 2>, None)}
        __members__: dict # value = {'FrustumCulling_Off': <FrustumCulling_e.FrustumCulling_Off: 0>, 'FrustumCulling_On': <FrustumCulling_e.FrustumCulling_On: 1>, 'FrustumCulling_NoUpdate': <FrustumCulling_e.FrustumCulling_NoUpdate: 2>}
        pass
    class PerfCounters_e():
        """
        Statistics display flags. If not specified otherwise, the counter value is computed for a single rendered frame.

        Members:

          PerfCounters_NONE

          PerfCounters_FrameRate

          PerfCounters_CPU

          PerfCounters_Layers

          PerfCounters_Structures

          PerfCounters_Groups

          PerfCounters_GroupArrays

          PerfCounters_Triangles

          PerfCounters_Points

          PerfCounters_Lines

          PerfCounters_EstimMem

          PerfCounters_FrameTime

          PerfCounters_FrameTimeMax

          PerfCounters_SkipImmediate

          PerfCounters_Basic

          PerfCounters_Extended

          PerfCounters_All
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        PerfCounters_All: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_All: 4095>
        PerfCounters_Basic: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Basic: 15>
        PerfCounters_CPU: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_CPU: 2>
        PerfCounters_EstimMem: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_EstimMem: 512>
        PerfCounters_Extended: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Extended: 1023>
        PerfCounters_FrameRate: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_FrameRate: 1>
        PerfCounters_FrameTime: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_FrameTime: 1024>
        PerfCounters_FrameTimeMax: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_FrameTimeMax: 2048>
        PerfCounters_GroupArrays: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_GroupArrays: 32>
        PerfCounters_Groups: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Groups: 16>
        PerfCounters_Layers: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Layers: 4>
        PerfCounters_Lines: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Lines: 256>
        PerfCounters_NONE: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_NONE: 0>
        PerfCounters_Points: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Points: 128>
        PerfCounters_SkipImmediate: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_SkipImmediate: 4096>
        PerfCounters_Structures: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Structures: 8>
        PerfCounters_Triangles: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Triangles: 64>
        __entries: dict # value = {'PerfCounters_NONE': (<PerfCounters_e.PerfCounters_NONE: 0>, None), 'PerfCounters_FrameRate': (<PerfCounters_e.PerfCounters_FrameRate: 1>, None), 'PerfCounters_CPU': (<PerfCounters_e.PerfCounters_CPU: 2>, None), 'PerfCounters_Layers': (<PerfCounters_e.PerfCounters_Layers: 4>, None), 'PerfCounters_Structures': (<PerfCounters_e.PerfCounters_Structures: 8>, None), 'PerfCounters_Groups': (<PerfCounters_e.PerfCounters_Groups: 16>, None), 'PerfCounters_GroupArrays': (<PerfCounters_e.PerfCounters_GroupArrays: 32>, None), 'PerfCounters_Triangles': (<PerfCounters_e.PerfCounters_Triangles: 64>, None), 'PerfCounters_Points': (<PerfCounters_e.PerfCounters_Points: 128>, None), 'PerfCounters_Lines': (<PerfCounters_e.PerfCounters_Lines: 256>, None), 'PerfCounters_EstimMem': (<PerfCounters_e.PerfCounters_EstimMem: 512>, None), 'PerfCounters_FrameTime': (<PerfCounters_e.PerfCounters_FrameTime: 1024>, None), 'PerfCounters_FrameTimeMax': (<PerfCounters_e.PerfCounters_FrameTimeMax: 2048>, None), 'PerfCounters_SkipImmediate': (<PerfCounters_e.PerfCounters_SkipImmediate: 4096>, None), 'PerfCounters_Basic': (<PerfCounters_e.PerfCounters_Basic: 15>, None), 'PerfCounters_Extended': (<PerfCounters_e.PerfCounters_Extended: 1023>, None), 'PerfCounters_All': (<PerfCounters_e.PerfCounters_All: 4095>, None)}
        __members__: dict # value = {'PerfCounters_NONE': <PerfCounters_e.PerfCounters_NONE: 0>, 'PerfCounters_FrameRate': <PerfCounters_e.PerfCounters_FrameRate: 1>, 'PerfCounters_CPU': <PerfCounters_e.PerfCounters_CPU: 2>, 'PerfCounters_Layers': <PerfCounters_e.PerfCounters_Layers: 4>, 'PerfCounters_Structures': <PerfCounters_e.PerfCounters_Structures: 8>, 'PerfCounters_Groups': <PerfCounters_e.PerfCounters_Groups: 16>, 'PerfCounters_GroupArrays': <PerfCounters_e.PerfCounters_GroupArrays: 32>, 'PerfCounters_Triangles': <PerfCounters_e.PerfCounters_Triangles: 64>, 'PerfCounters_Points': <PerfCounters_e.PerfCounters_Points: 128>, 'PerfCounters_Lines': <PerfCounters_e.PerfCounters_Lines: 256>, 'PerfCounters_EstimMem': <PerfCounters_e.PerfCounters_EstimMem: 512>, 'PerfCounters_FrameTime': <PerfCounters_e.PerfCounters_FrameTime: 1024>, 'PerfCounters_FrameTimeMax': <PerfCounters_e.PerfCounters_FrameTimeMax: 2048>, 'PerfCounters_SkipImmediate': <PerfCounters_e.PerfCounters_SkipImmediate: 4096>, 'PerfCounters_Basic': <PerfCounters_e.PerfCounters_Basic: 15>, 'PerfCounters_Extended': <PerfCounters_e.PerfCounters_Extended: 1023>, 'PerfCounters_All': <PerfCounters_e.PerfCounters_All: 4095>}
        pass
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def ResolutionRatio(self) -> float: 
        """
        Returns resolution ratio.
        """
    def __init__(self) -> None: ...
    @property
    def AdaptiveScreenSampling(self) -> bool:
        """
        :type: bool
        """
    @AdaptiveScreenSampling.setter
    def AdaptiveScreenSampling(self, arg0: bool) -> None:
        pass
    @property
    def AdaptiveScreenSamplingAtomic(self) -> bool:
        """
        :type: bool
        """
    @AdaptiveScreenSamplingAtomic.setter
    def AdaptiveScreenSamplingAtomic(self, arg0: bool) -> None:
        pass
    @property
    def AnaglyphLeft(self) -> Graphic3d_Mat4:
        """
        :type: Graphic3d_Mat4
        """
    @AnaglyphLeft.setter
    def AnaglyphLeft(self, arg0: Graphic3d_Mat4) -> None:
        pass
    @property
    def AnaglyphRight(self) -> Graphic3d_Mat4:
        """
        :type: Graphic3d_Mat4
        """
    @AnaglyphRight.setter
    def AnaglyphRight(self, arg0: Graphic3d_Mat4) -> None:
        pass
    @property
    def CameraApertureRadius(self) -> float:
        """
        :type: float
        """
    @CameraApertureRadius.setter
    def CameraApertureRadius(self, arg0: float) -> None:
        pass
    @property
    def CameraFocalPlaneDist(self) -> float:
        """
        :type: float
        """
    @CameraFocalPlaneDist.setter
    def CameraFocalPlaneDist(self, arg0: float) -> None:
        pass
    @property
    def ChartSize(self) -> Graphic3d_Vec2i:
        """
        :type: Graphic3d_Vec2i
        """
    @ChartSize.setter
    def ChartSize(self, arg0: Graphic3d_Vec2i) -> None:
        pass
    @property
    def CoherentPathTracingMode(self) -> bool:
        """
        :type: bool
        """
    @CoherentPathTracingMode.setter
    def CoherentPathTracingMode(self, arg0: bool) -> None:
        pass
    @property
    def Exposure(self) -> float:
        """
        :type: float
        """
    @Exposure.setter
    def Exposure(self, arg0: float) -> None:
        pass
    @property
    def FontHinting(self) -> OCP.Font.Font_Hinting:
        """
        :type: OCP.Font.Font_Hinting
        """
    @FontHinting.setter
    def FontHinting(self, arg0: OCP.Font.Font_Hinting) -> None:
        pass
    @property
    def HmdFov2d(self) -> float:
        """
        :type: float
        """
    @HmdFov2d.setter
    def HmdFov2d(self, arg0: float) -> None:
        pass
    @property
    def IsAntialiasingEnabled(self) -> bool:
        """
        :type: bool
        """
    @IsAntialiasingEnabled.setter
    def IsAntialiasingEnabled(self, arg0: bool) -> None:
        pass
    @property
    def IsGlobalIlluminationEnabled(self) -> bool:
        """
        :type: bool
        """
    @IsGlobalIlluminationEnabled.setter
    def IsGlobalIlluminationEnabled(self, arg0: bool) -> None:
        pass
    @property
    def IsReflectionEnabled(self) -> bool:
        """
        :type: bool
        """
    @IsReflectionEnabled.setter
    def IsReflectionEnabled(self, arg0: bool) -> None:
        pass
    @property
    def IsShadowEnabled(self) -> bool:
        """
        :type: bool
        """
    @IsShadowEnabled.setter
    def IsShadowEnabled(self, arg0: bool) -> None:
        pass
    @property
    def IsTransparentShadowEnabled(self) -> bool:
        """
        :type: bool
        """
    @IsTransparentShadowEnabled.setter
    def IsTransparentShadowEnabled(self, arg0: bool) -> None:
        pass
    @property
    def LineFeather(self) -> float:
        """
        :type: float
        """
    @LineFeather.setter
    def LineFeather(self, arg0: float) -> None:
        pass
    @property
    def Method(self) -> Graphic3d_RenderingMode:
        """
        :type: Graphic3d_RenderingMode
        """
    @Method.setter
    def Method(self, arg0: Graphic3d_RenderingMode) -> None:
        pass
    @property
    def NbMsaaSamples(self) -> int:
        """
        :type: int
        """
    @NbMsaaSamples.setter
    def NbMsaaSamples(self, arg0: int) -> None:
        pass
    @property
    def NbOitDepthPeelingLayers(self) -> int:
        """
        :type: int
        """
    @NbOitDepthPeelingLayers.setter
    def NbOitDepthPeelingLayers(self, arg0: int) -> None:
        pass
    @property
    def NbRayTracingTiles(self) -> int:
        """
        :type: int
        """
    @NbRayTracingTiles.setter
    def NbRayTracingTiles(self, arg0: int) -> None:
        pass
    @property
    def OitDepthFactor(self) -> float:
        """
        :type: float
        """
    @OitDepthFactor.setter
    def OitDepthFactor(self, arg0: float) -> None:
        pass
    @property
    def PbrEnvBakingDiffNbSamples(self) -> int:
        """
        :type: int
        """
    @PbrEnvBakingDiffNbSamples.setter
    def PbrEnvBakingDiffNbSamples(self, arg0: int) -> None:
        pass
    @property
    def PbrEnvBakingProbability(self) -> float:
        """
        :type: float
        """
    @PbrEnvBakingProbability.setter
    def PbrEnvBakingProbability(self, arg0: float) -> None:
        pass
    @property
    def PbrEnvBakingSpecNbSamples(self) -> int:
        """
        :type: int
        """
    @PbrEnvBakingSpecNbSamples.setter
    def PbrEnvBakingSpecNbSamples(self, arg0: int) -> None:
        pass
    @property
    def PbrEnvPow2Size(self) -> int:
        """
        :type: int
        """
    @PbrEnvPow2Size.setter
    def PbrEnvPow2Size(self, arg0: int) -> None:
        pass
    @property
    def PbrEnvSpecMapNbLevels(self) -> int:
        """
        :type: int
        """
    @PbrEnvSpecMapNbLevels.setter
    def PbrEnvSpecMapNbLevels(self, arg0: int) -> None:
        pass
    @property
    def RadianceClampingValue(self) -> float:
        """
        :type: float
        """
    @RadianceClampingValue.setter
    def RadianceClampingValue(self, arg0: float) -> None:
        pass
    @property
    def RayTracingTileSize(self) -> int:
        """
        :type: int
        """
    @RayTracingTileSize.setter
    def RayTracingTileSize(self, arg0: int) -> None:
        pass
    @property
    def RaytracingDepth(self) -> int:
        """
        :type: int
        """
    @RaytracingDepth.setter
    def RaytracingDepth(self, arg0: int) -> None:
        pass
    @property
    def RebuildRayTracingShaders(self) -> bool:
        """
        :type: bool
        """
    @RebuildRayTracingShaders.setter
    def RebuildRayTracingShaders(self, arg0: bool) -> None:
        pass
    @property
    def RenderResolutionScale(self) -> float:
        """
        :type: float
        """
    @RenderResolutionScale.setter
    def RenderResolutionScale(self, arg0: float) -> None:
        pass
    @property
    def SamplesPerPixel(self) -> int:
        """
        :type: int
        """
    @SamplesPerPixel.setter
    def SamplesPerPixel(self, arg0: int) -> None:
        pass
    @property
    def ShadingModel(self) -> Graphic3d_TypeOfShadingModel:
        """
        :type: Graphic3d_TypeOfShadingModel
        """
    @ShadingModel.setter
    def ShadingModel(self, arg0: Graphic3d_TypeOfShadingModel) -> None:
        pass
    @property
    def ShadowMapBias(self) -> float:
        """
        :type: float
        """
    @ShadowMapBias.setter
    def ShadowMapBias(self, arg0: float) -> None:
        pass
    @property
    def ShadowMapResolution(self) -> int:
        """
        :type: int
        """
    @ShadowMapResolution.setter
    def ShadowMapResolution(self, arg0: int) -> None:
        pass
    @property
    def ShowSamplingTiles(self) -> bool:
        """
        :type: bool
        """
    @ShowSamplingTiles.setter
    def ShowSamplingTiles(self, arg0: bool) -> None:
        pass
    @property
    def StatsMaxChartTime(self) -> float:
        """
        :type: float
        """
    @StatsMaxChartTime.setter
    def StatsMaxChartTime(self, arg0: float) -> None:
        pass
    @property
    def StatsNbFrames(self) -> int:
        """
        :type: int
        """
    @StatsNbFrames.setter
    def StatsNbFrames(self, arg0: int) -> None:
        pass
    @property
    def StatsTextHeight(self) -> int:
        """
        :type: int
        """
    @StatsTextHeight.setter
    def StatsTextHeight(self, arg0: int) -> None:
        pass
    @property
    def StatsUpdateInterval(self) -> float:
        """
        :type: float
        """
    @StatsUpdateInterval.setter
    def StatsUpdateInterval(self, arg0: float) -> None:
        pass
    @property
    def StereoMode(self) -> Graphic3d_StereoMode:
        """
        :type: Graphic3d_StereoMode
        """
    @StereoMode.setter
    def StereoMode(self, arg0: Graphic3d_StereoMode) -> None:
        pass
    @property
    def ToEnableAlphaToCoverage(self) -> bool:
        """
        :type: bool
        """
    @ToEnableAlphaToCoverage.setter
    def ToEnableAlphaToCoverage(self, arg0: bool) -> None:
        pass
    @property
    def ToEnableDepthPrepass(self) -> bool:
        """
        :type: bool
        """
    @ToEnableDepthPrepass.setter
    def ToEnableDepthPrepass(self, arg0: bool) -> None:
        pass
    @property
    def ToIgnoreNormalMapInRayTracing(self) -> bool:
        """
        :type: bool
        """
    @ToIgnoreNormalMapInRayTracing.setter
    def ToIgnoreNormalMapInRayTracing(self, arg0: bool) -> None:
        pass
    @property
    def ToMirrorComposer(self) -> bool:
        """
        :type: bool
        """
    @ToMirrorComposer.setter
    def ToMirrorComposer(self, arg0: bool) -> None:
        pass
    @property
    def ToReverseStereo(self) -> bool:
        """
        :type: bool
        """
    @ToReverseStereo.setter
    def ToReverseStereo(self, arg0: bool) -> None:
        pass
    @property
    def ToShowStats(self) -> bool:
        """
        :type: bool
        """
    @ToShowStats.setter
    def ToShowStats(self, arg0: bool) -> None:
        pass
    @property
    def ToSmoothInterlacing(self) -> bool:
        """
        :type: bool
        """
    @ToSmoothInterlacing.setter
    def ToSmoothInterlacing(self, arg0: bool) -> None:
        pass
    @property
    def ToneMappingMethod(self) -> Graphic3d_ToneMappingMethod:
        """
        :type: Graphic3d_ToneMappingMethod
        """
    @ToneMappingMethod.setter
    def ToneMappingMethod(self, arg0: Graphic3d_ToneMappingMethod) -> None:
        pass
    @property
    def TransparencyMethod(self) -> Graphic3d_RenderTransparentMethod:
        """
        :type: Graphic3d_RenderTransparentMethod
        """
    @TransparencyMethod.setter
    def TransparencyMethod(self, arg0: Graphic3d_RenderTransparentMethod) -> None:
        pass
    @property
    def TwoSidedBsdfModels(self) -> bool:
        """
        :type: bool
        """
    @TwoSidedBsdfModels.setter
    def TwoSidedBsdfModels(self, arg0: bool) -> None:
        pass
    @property
    def UseEnvironmentMapBackground(self) -> bool:
        """
        :type: bool
        """
    @UseEnvironmentMapBackground.setter
    def UseEnvironmentMapBackground(self, arg0: bool) -> None:
        pass
    @property
    def WhitePoint(self) -> float:
        """
        :type: float
        """
    @WhitePoint.setter
    def WhitePoint(self, arg0: float) -> None:
        pass
    Anaglyph_GreenMagenta_Simple: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_GreenMagenta_Simple: 4>
    Anaglyph_RedCyan_Optimized: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_RedCyan_Optimized: 1>
    Anaglyph_RedCyan_Simple: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_RedCyan_Simple: 0>
    Anaglyph_UserDefined: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_UserDefined: 5>
    Anaglyph_YellowBlue_Optimized: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_YellowBlue_Optimized: 3>
    Anaglyph_YellowBlue_Simple: OCP.Graphic3d.Anaglyph_e # value = <Anaglyph_e.Anaglyph_YellowBlue_Simple: 2>
    FrustumCulling_NoUpdate: OCP.Graphic3d.FrustumCulling_e # value = <FrustumCulling_e.FrustumCulling_NoUpdate: 2>
    FrustumCulling_Off: OCP.Graphic3d.FrustumCulling_e # value = <FrustumCulling_e.FrustumCulling_Off: 0>
    FrustumCulling_On: OCP.Graphic3d.FrustumCulling_e # value = <FrustumCulling_e.FrustumCulling_On: 1>
    PerfCounters_All: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_All: 4095>
    PerfCounters_Basic: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Basic: 15>
    PerfCounters_CPU: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_CPU: 2>
    PerfCounters_EstimMem: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_EstimMem: 512>
    PerfCounters_Extended: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Extended: 1023>
    PerfCounters_FrameRate: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_FrameRate: 1>
    PerfCounters_FrameTime: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_FrameTime: 1024>
    PerfCounters_FrameTimeMax: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_FrameTimeMax: 2048>
    PerfCounters_GroupArrays: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_GroupArrays: 32>
    PerfCounters_Groups: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Groups: 16>
    PerfCounters_Layers: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Layers: 4>
    PerfCounters_Lines: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Lines: 256>
    PerfCounters_NONE: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_NONE: 0>
    PerfCounters_Points: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Points: 128>
    PerfCounters_SkipImmediate: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_SkipImmediate: 4096>
    PerfCounters_Structures: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Structures: 8>
    PerfCounters_Triangles: OCP.Graphic3d.PerfCounters_e # value = <PerfCounters_e.PerfCounters_Triangles: 64>
    pass
class Graphic3d_SequenceOfGroup(OCP.NCollection.NCollection_BaseSequence):
    """
    Purpose: Definition of a sequence of elements indexed by an Integer in range of 1..n
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : Graphic3d_Group) -> None: 
        """
        Append one item

        Append another sequence (making it empty)
        """
    @overload
    def Append(self,theSeq : Graphic3d_SequenceOfGroup) -> None: ...
    def Assign(self,theOther : Graphic3d_SequenceOfGroup) -> Graphic3d_SequenceOfGroup: 
        """
        Replace this sequence by the items of theOther. This method does not change the internal allocator.
        """
    def ChangeFirst(self) -> Graphic3d_Group: 
        """
        First item access
        """
    def ChangeLast(self) -> Graphic3d_Group: 
        """
        Last item access
        """
    def ChangeValue(self,theIndex : int) -> Graphic3d_Group: 
        """
        Variable item access by theIndex
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear the items out, take a new allocator if non null
        """
    def Exchange(self,I : int,J : int) -> None: 
        """
        Exchange two members
        """
    def First(self) -> Graphic3d_Group: 
        """
        First item access
        """
    @overload
    def InsertAfter(self,theIndex : int,theSeq : Graphic3d_SequenceOfGroup) -> None: 
        """
        InsertAfter theIndex another sequence (making it empty)

        InsertAfter theIndex theItem
        """
    @overload
    def InsertAfter(self,theIndex : int,theItem : Graphic3d_Group) -> None: ...
    @overload
    def InsertBefore(self,theIndex : int,theItem : Graphic3d_Group) -> None: 
        """
        InsertBefore theIndex theItem

        InsertBefore theIndex another sequence (making it empty)
        """
    @overload
    def InsertBefore(self,theIndex : int,theSeq : Graphic3d_SequenceOfGroup) -> None: ...
    def IsEmpty(self) -> bool: 
        """
        Empty query
        """
    def Last(self) -> Graphic3d_Group: 
        """
        Last item access
        """
    def Length(self) -> int: 
        """
        Number of items
        """
    def Lower(self) -> int: 
        """
        Method for consistency with other collections.
        """
    @overload
    def Prepend(self,theItem : Graphic3d_Group) -> None: 
        """
        Prepend one item

        Prepend another sequence (making it empty)
        """
    @overload
    def Prepend(self,theSeq : Graphic3d_SequenceOfGroup) -> None: ...
    @overload
    def Remove(self,theIndex : int) -> None: 
        """
        Remove one item

        Remove range of items
        """
    @overload
    def Remove(self,theFromIndex : int,theToIndex : int) -> None: ...
    def Reverse(self) -> None: 
        """
        Reverse sequence
        """
    def SetValue(self,theIndex : int,theItem : Graphic3d_Group) -> None: 
        """
        Set item value by theIndex
        """
    def Size(self) -> int: 
        """
        Number of items
        """
    def Split(self,theIndex : int,theSeq : Graphic3d_SequenceOfGroup) -> None: 
        """
        Split in two sequences
        """
    def Upper(self) -> int: 
        """
        Method for consistency with other collections.
        """
    def Value(self,theIndex : int) -> Graphic3d_Group: 
        """
        Constant item access by theIndex
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> Graphic3d_Group: 
        """
        Constant operator()

        Variable operator()
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_SequenceOfGroup) -> None: ...
    def __iter__(self) -> Iterator[Graphic3d_Group]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def delNode_s(theNode : NCollection_SeqNode,theAl : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Static deleter to be passed to BaseSequence
        """
    pass
class Graphic3d_SequenceOfHClipPlane(OCP.Standard.Standard_Transient):
    """
    Class defines a Clipping Volume as a logical OR (disjunction) operation between Graphic3d_ClipPlane in sequence. Each Graphic3d_ClipPlane represents either a single Plane clipping a halfspace (direction is specified by normal), or a sub-chain of planes defining a logical AND (conjunction) operation. Therefore, this collection allows defining a Clipping Volume through the limited set of Boolean operations between clipping Planes.Class defines a Clipping Volume as a logical OR (disjunction) operation between Graphic3d_ClipPlane in sequence. Each Graphic3d_ClipPlane represents either a single Plane clipping a halfspace (direction is specified by normal), or a sub-chain of planes defining a logical AND (conjunction) operation. Therefore, this collection allows defining a Clipping Volume through the limited set of Boolean operations between clipping Planes.
    """
    def Append(self,theItem : Graphic3d_ClipPlane) -> bool: 
        """
        Append a plane.
        """
    def Clear(self) -> None: 
        """
        Clear the items out.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> Graphic3d_ClipPlane: 
        """
        Return the first item in sequence.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if sequence is empty.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @overload
    def Remove(self,theItem : Graphic3d_ClipPlane) -> bool: 
        """
        Remove a plane.

        Remove a plane.
        """
    @overload
    def Remove(self,theItem : Any) -> None: ...
    def SetOverrideGlobal(self,theToOverride : bool) -> None: 
        """
        Setup flag defining if local properties should override global properties.
        """
    def Size(self) -> int: 
        """
        Return the number of items in sequence.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToOverrideGlobal(self) -> bool: 
        """
        Return true if local properties should override global properties.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_SequenceOfStructure(OCP.NCollection.NCollection_BaseSequence):
    """
    Purpose: Definition of a sequence of elements indexed by an Integer in range of 1..n
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : Graphic3d_Structure) -> None: 
        """
        Append one item

        Append another sequence (making it empty)
        """
    @overload
    def Append(self,theSeq : Graphic3d_SequenceOfStructure) -> None: ...
    def Assign(self,theOther : Graphic3d_SequenceOfStructure) -> Graphic3d_SequenceOfStructure: 
        """
        Replace this sequence by the items of theOther. This method does not change the internal allocator.
        """
    def ChangeFirst(self) -> Graphic3d_Structure: 
        """
        First item access
        """
    def ChangeLast(self) -> Graphic3d_Structure: 
        """
        Last item access
        """
    def ChangeValue(self,theIndex : int) -> Graphic3d_Structure: 
        """
        Variable item access by theIndex
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear the items out, take a new allocator if non null
        """
    def Exchange(self,I : int,J : int) -> None: 
        """
        Exchange two members
        """
    def First(self) -> Graphic3d_Structure: 
        """
        First item access
        """
    @overload
    def InsertAfter(self,theIndex : int,theSeq : Graphic3d_SequenceOfStructure) -> None: 
        """
        InsertAfter theIndex another sequence (making it empty)

        InsertAfter theIndex theItem
        """
    @overload
    def InsertAfter(self,theIndex : int,theItem : Graphic3d_Structure) -> None: ...
    @overload
    def InsertBefore(self,theIndex : int,theItem : Graphic3d_Structure) -> None: 
        """
        InsertBefore theIndex theItem

        InsertBefore theIndex another sequence (making it empty)
        """
    @overload
    def InsertBefore(self,theIndex : int,theSeq : Graphic3d_SequenceOfStructure) -> None: ...
    def IsEmpty(self) -> bool: 
        """
        Empty query
        """
    def Last(self) -> Graphic3d_Structure: 
        """
        Last item access
        """
    def Length(self) -> int: 
        """
        Number of items
        """
    def Lower(self) -> int: 
        """
        Method for consistency with other collections.
        """
    @overload
    def Prepend(self,theItem : Graphic3d_Structure) -> None: 
        """
        Prepend one item

        Prepend another sequence (making it empty)
        """
    @overload
    def Prepend(self,theSeq : Graphic3d_SequenceOfStructure) -> None: ...
    @overload
    def Remove(self,theIndex : int) -> None: 
        """
        Remove one item

        Remove range of items
        """
    @overload
    def Remove(self,theFromIndex : int,theToIndex : int) -> None: ...
    def Reverse(self) -> None: 
        """
        Reverse sequence
        """
    def SetValue(self,theIndex : int,theItem : Graphic3d_Structure) -> None: 
        """
        Set item value by theIndex
        """
    def Size(self) -> int: 
        """
        Number of items
        """
    def Split(self,theIndex : int,theSeq : Graphic3d_SequenceOfStructure) -> None: 
        """
        Split in two sequences
        """
    def Upper(self) -> int: 
        """
        Method for consistency with other collections.
        """
    def Value(self,theIndex : int) -> Graphic3d_Structure: 
        """
        Constant item access by theIndex
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> Graphic3d_Structure: 
        """
        Constant operator()

        Variable operator()
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_SequenceOfStructure) -> None: ...
    def __iter__(self) -> Iterator[Graphic3d_Structure]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def delNode_s(theNode : NCollection_SeqNode,theAl : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Static deleter to be passed to BaseSequence
        """
    pass
class Graphic3d_ShaderAttribute(OCP.Standard.Standard_Transient):
    """
    Describes custom vertex shader attribute.Describes custom vertex shader attribute.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Location(self) -> int: 
        """
        Returns attribute location to be bound on GLSL program linkage stage.
        """
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns name of shader variable.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self,theName : OCP.TCollection.TCollection_AsciiString,theLocation : int) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ShaderAttributeList(OCP.NCollection.NCollection_BaseSequence):
    """
    Purpose: Definition of a sequence of elements indexed by an Integer in range of 1..n
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : Graphic3d_ShaderAttribute) -> None: 
        """
        Append one item

        Append another sequence (making it empty)
        """
    @overload
    def Append(self,theSeq : Graphic3d_ShaderAttributeList) -> None: ...
    def Assign(self,theOther : Graphic3d_ShaderAttributeList) -> Graphic3d_ShaderAttributeList: 
        """
        Replace this sequence by the items of theOther. This method does not change the internal allocator.
        """
    def ChangeFirst(self) -> Graphic3d_ShaderAttribute: 
        """
        First item access
        """
    def ChangeLast(self) -> Graphic3d_ShaderAttribute: 
        """
        Last item access
        """
    def ChangeValue(self,theIndex : int) -> Graphic3d_ShaderAttribute: 
        """
        Variable item access by theIndex
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear the items out, take a new allocator if non null
        """
    def Exchange(self,I : int,J : int) -> None: 
        """
        Exchange two members
        """
    def First(self) -> Graphic3d_ShaderAttribute: 
        """
        First item access
        """
    @overload
    def InsertAfter(self,theIndex : int,theSeq : Graphic3d_ShaderAttributeList) -> None: 
        """
        InsertAfter theIndex another sequence (making it empty)

        InsertAfter theIndex theItem
        """
    @overload
    def InsertAfter(self,theIndex : int,theItem : Graphic3d_ShaderAttribute) -> None: ...
    @overload
    def InsertBefore(self,theIndex : int,theItem : Graphic3d_ShaderAttribute) -> None: 
        """
        InsertBefore theIndex theItem

        InsertBefore theIndex another sequence (making it empty)
        """
    @overload
    def InsertBefore(self,theIndex : int,theSeq : Graphic3d_ShaderAttributeList) -> None: ...
    def IsEmpty(self) -> bool: 
        """
        Empty query
        """
    def Last(self) -> Graphic3d_ShaderAttribute: 
        """
        Last item access
        """
    def Length(self) -> int: 
        """
        Number of items
        """
    def Lower(self) -> int: 
        """
        Method for consistency with other collections.
        """
    @overload
    def Prepend(self,theItem : Graphic3d_ShaderAttribute) -> None: 
        """
        Prepend one item

        Prepend another sequence (making it empty)
        """
    @overload
    def Prepend(self,theSeq : Graphic3d_ShaderAttributeList) -> None: ...
    @overload
    def Remove(self,theIndex : int) -> None: 
        """
        Remove one item

        Remove range of items
        """
    @overload
    def Remove(self,theFromIndex : int,theToIndex : int) -> None: ...
    def Reverse(self) -> None: 
        """
        Reverse sequence
        """
    def SetValue(self,theIndex : int,theItem : Graphic3d_ShaderAttribute) -> None: 
        """
        Set item value by theIndex
        """
    def Size(self) -> int: 
        """
        Number of items
        """
    def Split(self,theIndex : int,theSeq : Graphic3d_ShaderAttributeList) -> None: 
        """
        Split in two sequences
        """
    def Upper(self) -> int: 
        """
        Method for consistency with other collections.
        """
    def Value(self,theIndex : int) -> Graphic3d_ShaderAttribute: 
        """
        Constant item access by theIndex
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> Graphic3d_ShaderAttribute: 
        """
        Constant operator()

        Variable operator()
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_ShaderAttributeList) -> None: ...
    def __iter__(self) -> Iterator[Graphic3d_ShaderAttribute]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def delNode_s(theNode : NCollection_SeqNode,theAl : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Static deleter to be passed to BaseSequence
        """
    pass
class Graphic3d_ShaderFlags():
    """
    Standard GLSL program combination bits.

    Members:

      Graphic3d_ShaderFlags_VertColor

      Graphic3d_ShaderFlags_TextureRGB

      Graphic3d_ShaderFlags_TextureEnv

      Graphic3d_ShaderFlags_TextureNormal

      Graphic3d_ShaderFlags_PointSimple

      Graphic3d_ShaderFlags_PointSprite

      Graphic3d_ShaderFlags_PointSpriteA

      Graphic3d_ShaderFlags_StippleLine

      Graphic3d_ShaderFlags_ClipPlanes1

      Graphic3d_ShaderFlags_ClipPlanes2

      Graphic3d_ShaderFlags_ClipPlanesN

      Graphic3d_ShaderFlags_ClipChains

      Graphic3d_ShaderFlags_MeshEdges

      Graphic3d_ShaderFlags_AlphaTest

      Graphic3d_ShaderFlags_WriteOit

      Graphic3d_ShaderFlags_OitDepthPeeling

      Graphic3d_ShaderFlags_NB

      Graphic3d_ShaderFlags_IsPoint

      Graphic3d_ShaderFlags_HasTextures

      Graphic3d_ShaderFlags_NeedsGeomShader
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_ShaderFlags_AlphaTest: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_AlphaTest: 1024>
    Graphic3d_ShaderFlags_ClipChains: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipChains: 256>
    Graphic3d_ShaderFlags_ClipPlanes1: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanes1: 64>
    Graphic3d_ShaderFlags_ClipPlanes2: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanes2: 128>
    Graphic3d_ShaderFlags_ClipPlanesN: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanesN: 192>
    Graphic3d_ShaderFlags_HasTextures: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureNormal: 6>
    Graphic3d_ShaderFlags_IsPoint: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSpriteA: 24>
    Graphic3d_ShaderFlags_MeshEdges: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_MeshEdges: 512>
    Graphic3d_ShaderFlags_NB: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_NB: 8192>
    Graphic3d_ShaderFlags_NeedsGeomShader: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_MeshEdges: 512>
    Graphic3d_ShaderFlags_OitDepthPeeling: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_OitDepthPeeling: 4096>
    Graphic3d_ShaderFlags_PointSimple: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSimple: 8>
    Graphic3d_ShaderFlags_PointSprite: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSprite: 16>
    Graphic3d_ShaderFlags_PointSpriteA: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSpriteA: 24>
    Graphic3d_ShaderFlags_StippleLine: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_StippleLine: 32>
    Graphic3d_ShaderFlags_TextureEnv: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureEnv: 4>
    Graphic3d_ShaderFlags_TextureNormal: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureNormal: 6>
    Graphic3d_ShaderFlags_TextureRGB: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureRGB: 2>
    Graphic3d_ShaderFlags_VertColor: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_VertColor: 1>
    Graphic3d_ShaderFlags_WriteOit: OCP.Graphic3d.Graphic3d_ShaderFlags # value = <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_WriteOit: 2048>
    __entries: dict # value = {'Graphic3d_ShaderFlags_VertColor': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_VertColor: 1>, None), 'Graphic3d_ShaderFlags_TextureRGB': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureRGB: 2>, None), 'Graphic3d_ShaderFlags_TextureEnv': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureEnv: 4>, None), 'Graphic3d_ShaderFlags_TextureNormal': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureNormal: 6>, None), 'Graphic3d_ShaderFlags_PointSimple': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSimple: 8>, None), 'Graphic3d_ShaderFlags_PointSprite': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSprite: 16>, None), 'Graphic3d_ShaderFlags_PointSpriteA': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSpriteA: 24>, None), 'Graphic3d_ShaderFlags_StippleLine': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_StippleLine: 32>, None), 'Graphic3d_ShaderFlags_ClipPlanes1': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanes1: 64>, None), 'Graphic3d_ShaderFlags_ClipPlanes2': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanes2: 128>, None), 'Graphic3d_ShaderFlags_ClipPlanesN': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanesN: 192>, None), 'Graphic3d_ShaderFlags_ClipChains': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipChains: 256>, None), 'Graphic3d_ShaderFlags_MeshEdges': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_MeshEdges: 512>, None), 'Graphic3d_ShaderFlags_AlphaTest': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_AlphaTest: 1024>, None), 'Graphic3d_ShaderFlags_WriteOit': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_WriteOit: 2048>, None), 'Graphic3d_ShaderFlags_OitDepthPeeling': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_OitDepthPeeling: 4096>, None), 'Graphic3d_ShaderFlags_NB': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_NB: 8192>, None), 'Graphic3d_ShaderFlags_IsPoint': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSpriteA: 24>, None), 'Graphic3d_ShaderFlags_HasTextures': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureNormal: 6>, None), 'Graphic3d_ShaderFlags_NeedsGeomShader': (<Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_MeshEdges: 512>, None)}
    __members__: dict # value = {'Graphic3d_ShaderFlags_VertColor': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_VertColor: 1>, 'Graphic3d_ShaderFlags_TextureRGB': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureRGB: 2>, 'Graphic3d_ShaderFlags_TextureEnv': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureEnv: 4>, 'Graphic3d_ShaderFlags_TextureNormal': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureNormal: 6>, 'Graphic3d_ShaderFlags_PointSimple': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSimple: 8>, 'Graphic3d_ShaderFlags_PointSprite': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSprite: 16>, 'Graphic3d_ShaderFlags_PointSpriteA': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSpriteA: 24>, 'Graphic3d_ShaderFlags_StippleLine': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_StippleLine: 32>, 'Graphic3d_ShaderFlags_ClipPlanes1': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanes1: 64>, 'Graphic3d_ShaderFlags_ClipPlanes2': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanes2: 128>, 'Graphic3d_ShaderFlags_ClipPlanesN': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipPlanesN: 192>, 'Graphic3d_ShaderFlags_ClipChains': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_ClipChains: 256>, 'Graphic3d_ShaderFlags_MeshEdges': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_MeshEdges: 512>, 'Graphic3d_ShaderFlags_AlphaTest': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_AlphaTest: 1024>, 'Graphic3d_ShaderFlags_WriteOit': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_WriteOit: 2048>, 'Graphic3d_ShaderFlags_OitDepthPeeling': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_OitDepthPeeling: 4096>, 'Graphic3d_ShaderFlags_NB': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_NB: 8192>, 'Graphic3d_ShaderFlags_IsPoint': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_PointSpriteA: 24>, 'Graphic3d_ShaderFlags_HasTextures': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_TextureNormal: 6>, 'Graphic3d_ShaderFlags_NeedsGeomShader': <Graphic3d_ShaderFlags.Graphic3d_ShaderFlags_MeshEdges: 512>}
    pass
class Graphic3d_ShaderManager(OCP.Standard.Standard_Transient):
    """
    This class is responsible for generation of shader programs.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableGlslExtension(self,theExt : Graphic3d_GlslExtension,theToEnable : bool=True) -> None: 
        """
        Set if specified extension is available or not.
        """
    def GapiVersionMajor(self) -> int: 
        """
        Return GAPI version major number.
        """
    def GapiVersionMinor(self) -> int: 
        """
        Return GAPI version minor number.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasFlatShading(self) -> bool: 
        """
        Return flag indicating flat shading usage; TRUE by default.
        """
    def HasGlslExtension(self,theExt : Graphic3d_GlslExtension) -> bool: 
        """
        Return TRUE if specified extension is available.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsGapiGreaterEqual(self,theVerMajor : int,theVerMinor : int) -> bool: 
        """
        Returns true if detected GL version is greater or equal to requested one.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def SetEmulateDepthClamp(self,theToEmulate : bool) -> None: 
        """
        Set if depth clamping should be emulated by GLSL program.
        """
    def SetFlatShading(self,theToUse : bool,theToReverseSign : bool) -> None: 
        """
        Set flag indicating flat shading usage.
        """
    def SetGapiVersion(self,theVerMajor : int,theVerMinor : int) -> None: 
        """
        Return GAPI version major number.
        """
    def SetUseRedAlpha(self,theUseRedAlpha : bool) -> None: 
        """
        Set if RED channel should be used instead of ALPHA for single-channel textures.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToEmulateDepthClamp(self) -> bool: 
        """
        Return TRUE if depth clamping should be emulated by GLSL program; TRUE by default.
        """
    def ToReverseDFdxSign(self) -> bool: 
        """
        Return flag indicating flat shading should reverse normal flag; FALSE by default.
        """
    def UseRedAlpha(self) -> bool: 
        """
        Return TRUE if RED channel should be used instead of ALPHA for single-channel textures (e.g. GAPI supports only GL_RED textures and not GL_ALPHA).
        """
    def __init__(self,theGapi : OCP.Aspect.Aspect_GraphicsLibrary) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ShaderObject(OCP.Standard.Standard_Transient):
    """
    This class is responsible for managing shader objects.This class is responsible for managing shader objects.
    """
    @staticmethod
    def CreateFromFile_s(theType : Graphic3d_TypeOfShaderObject,thePath : OCP.TCollection.TCollection_AsciiString) -> Graphic3d_ShaderObject: 
        """
        Creates new shader object from specified file.
        """
    @staticmethod
    @overload
    def CreateFromSource_s(theType : Graphic3d_TypeOfShaderObject,theSource : OCP.TCollection.TCollection_AsciiString) -> Graphic3d_ShaderObject: 
        """
        Creates new shader object from specified source.

        This is a preprocessor for Graphic3d_ShaderObject::CreateFromSource() function. Creates a new shader object from specified source according to list of uniforms and in/out variables.
        """
    @staticmethod
    @overload
    def CreateFromSource_s(theSource : OCP.TCollection.TCollection_AsciiString,theType : Graphic3d_TypeOfShaderObject,theUniforms : Any,theStageInOuts : Any,theInName : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString,theOutName : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString,theNbGeomInputVerts : int=0) -> Graphic3d_ShaderObject: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns unique ID used to manage resource in graphic driver.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsDone(self) -> bool: 
        """
        Checks if the shader object is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path to the shader source.
        """
    def Source(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the source code of the shader object.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfShaderObject: 
        """
        Returns type of the shader object.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ShaderObjectList(OCP.NCollection.NCollection_BaseSequence):
    """
    Purpose: Definition of a sequence of elements indexed by an Integer in range of 1..n
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : Graphic3d_ShaderObject) -> None: 
        """
        Append one item

        Append another sequence (making it empty)
        """
    @overload
    def Append(self,theSeq : Graphic3d_ShaderObjectList) -> None: ...
    def Assign(self,theOther : Graphic3d_ShaderObjectList) -> Graphic3d_ShaderObjectList: 
        """
        Replace this sequence by the items of theOther. This method does not change the internal allocator.
        """
    def ChangeFirst(self) -> Graphic3d_ShaderObject: 
        """
        First item access
        """
    def ChangeLast(self) -> Graphic3d_ShaderObject: 
        """
        Last item access
        """
    def ChangeValue(self,theIndex : int) -> Graphic3d_ShaderObject: 
        """
        Variable item access by theIndex
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear the items out, take a new allocator if non null
        """
    def Exchange(self,I : int,J : int) -> None: 
        """
        Exchange two members
        """
    def First(self) -> Graphic3d_ShaderObject: 
        """
        First item access
        """
    @overload
    def InsertAfter(self,theIndex : int,theSeq : Graphic3d_ShaderObjectList) -> None: 
        """
        InsertAfter theIndex another sequence (making it empty)

        InsertAfter theIndex theItem
        """
    @overload
    def InsertAfter(self,theIndex : int,theItem : Graphic3d_ShaderObject) -> None: ...
    @overload
    def InsertBefore(self,theIndex : int,theItem : Graphic3d_ShaderObject) -> None: 
        """
        InsertBefore theIndex theItem

        InsertBefore theIndex another sequence (making it empty)
        """
    @overload
    def InsertBefore(self,theIndex : int,theSeq : Graphic3d_ShaderObjectList) -> None: ...
    def IsEmpty(self) -> bool: 
        """
        Empty query
        """
    def Last(self) -> Graphic3d_ShaderObject: 
        """
        Last item access
        """
    def Length(self) -> int: 
        """
        Number of items
        """
    def Lower(self) -> int: 
        """
        Method for consistency with other collections.
        """
    @overload
    def Prepend(self,theItem : Graphic3d_ShaderObject) -> None: 
        """
        Prepend one item

        Prepend another sequence (making it empty)
        """
    @overload
    def Prepend(self,theSeq : Graphic3d_ShaderObjectList) -> None: ...
    @overload
    def Remove(self,theIndex : int) -> None: 
        """
        Remove one item

        Remove range of items
        """
    @overload
    def Remove(self,theFromIndex : int,theToIndex : int) -> None: ...
    def Reverse(self) -> None: 
        """
        Reverse sequence
        """
    def SetValue(self,theIndex : int,theItem : Graphic3d_ShaderObject) -> None: 
        """
        Set item value by theIndex
        """
    def Size(self) -> int: 
        """
        Number of items
        """
    def Split(self,theIndex : int,theSeq : Graphic3d_ShaderObjectList) -> None: 
        """
        Split in two sequences
        """
    def Upper(self) -> int: 
        """
        Method for consistency with other collections.
        """
    def Value(self,theIndex : int) -> Graphic3d_ShaderObject: 
        """
        Constant item access by theIndex
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> Graphic3d_ShaderObject: 
        """
        Constant operator()

        Variable operator()
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_ShaderObjectList) -> None: ...
    def __iter__(self) -> Iterator[Graphic3d_ShaderObject]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def delNode_s(theNode : NCollection_SeqNode,theAl : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Static deleter to be passed to BaseSequence
        """
    pass
class Graphic3d_ShaderProgram(OCP.Standard.Standard_Transient):
    """
    This class is responsible for managing shader programs.This class is responsible for managing shader programs.
    """
    def AppendToHeader(self,theHeaderLine : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Append line to GLSL header.
        """
    def AttachShader(self,theShader : Graphic3d_ShaderObject) -> bool: 
        """
        Attaches shader object to the program object.
        """
    def ClearVariables(self) -> None: 
        """
        Removes all custom uniform variables from the program.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DetachShader(self,theShader : Graphic3d_ShaderObject) -> bool: 
        """
        Detaches shader object from the program object.
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns unique ID used to manage resource in graphic driver.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasAlphaTest(self) -> bool: 
        """
        Return true if Fragment Shader should perform alpha test; FALSE by default.
        """
    def HasDefaultSampler(self) -> bool: 
        """
        Return TRUE if standard program header should define default texture sampler occSampler0; TRUE by default for compatibility.
        """
    def Header(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns GLSL header (version code and extensions).
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsDone(self) -> bool: 
        """
        Checks if the program object is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsPBR(self) -> bool: 
        """
        Return TRUE if standard program header should define functions and variables used in PBR pipeline. FALSE by default.
        """
    def NbClipPlanesMax(self) -> int: 
        """
        Return the length of array of clipping planes (THE_MAX_CLIP_PLANES), to be used for initialization occClipPlaneEquations. Default value is THE_MAX_CLIP_PLANES_DEFAULT.
        """
    def NbFragmentOutputs(self) -> int: 
        """
        Returns the number (1+) of Fragment Shader outputs to be written to (more than 1 can be in case of multiple draw buffers); 1 by default.
        """
    def NbLightsMax(self) -> int: 
        """
        Return the length of array of light sources (THE_MAX_LIGHTS), to be used for initialization occLightSources. Default value is THE_MAX_LIGHTS_DEFAULT.
        """
    def NbShadowMaps(self) -> int: 
        """
        Return the length of array of shadow maps (THE_NB_SHADOWMAPS); 0 by default.
        """
    def OitOutput(self) -> Graphic3d_RenderTransparentMethod: 
        """
        Return if Fragment Shader color should output to OIT buffers; OFF by default.
        """
    def PushVariableFloat(self,theName : OCP.TCollection.TCollection_AsciiString,theValue : float) -> bool: 
        """
        Pushes float uniform.
        """
    def PushVariableInt(self,theName : OCP.TCollection.TCollection_AsciiString,theValue : int) -> bool: 
        """
        Pushes int uniform.
        """
    def PushVariableVec2(self,theName : OCP.TCollection.TCollection_AsciiString,theValue : OCP.gp.gp_Vec2f) -> bool: 
        """
        Pushes vec2 uniform.
        """
    def PushVariableVec2i(self,theName : OCP.TCollection.TCollection_AsciiString,theValue : Graphic3d_Vec2i) -> bool: 
        """
        Pushes vec2i uniform.
        """
    def PushVariableVec3(self,theName : OCP.TCollection.TCollection_AsciiString,theValue : OCP.gp.gp_Vec3f) -> bool: 
        """
        Pushes vec3 uniform.
        """
    def PushVariableVec3i(self,theName : OCP.TCollection.TCollection_AsciiString,theValue : Graphic3d_Vec3i) -> bool: 
        """
        Pushes vec3i uniform.
        """
    def PushVariableVec4(self,theName : OCP.TCollection.TCollection_AsciiString,theValue : Graphic3d_Vec4) -> bool: 
        """
        Pushes vec4 uniform.
        """
    def PushVariableVec4i(self,theName : OCP.TCollection.TCollection_AsciiString,theValue : Graphic3d_Vec4i) -> bool: 
        """
        Pushes vec4i uniform.
        """
    def SetAlphaTest(self,theAlphaTest : bool) -> None: 
        """
        Set if Fragment Shader should perform alpha test. Note that this flag is designed for usage with - custom shader program may discard fragment regardless this flag.
        """
    def SetDefaultSampler(self,theHasDefSampler : bool) -> None: 
        """
        Set if standard program header should define default texture sampler occSampler0.
        """
    def SetHeader(self,theHeader : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Setup GLSL header containing language version code and used extensions. Will be prepended to the very beginning of the source code. Example:
        """
    def SetId(self,theId : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets unique ID used to manage resource in graphic driver. WARNING! Graphic3d_ShaderProgram constructor generates a unique id for proper resource management; however if application overrides it, it is responsibility of application to avoid name collisions.
        """
    def SetNbClipPlanesMax(self,theNbPlanes : int) -> None: 
        """
        Specify the length of array of clipping planes (THE_MAX_CLIP_PLANES).
        """
    def SetNbFragmentOutputs(self,theNbOutputs : int) -> None: 
        """
        Sets the number of Fragment Shader outputs to be written to. Should be done before GLSL program initialization.
        """
    def SetNbLightsMax(self,theNbLights : int) -> None: 
        """
        Specify the length of array of light sources (THE_MAX_LIGHTS).
        """
    def SetNbShadowMaps(self,theNbMaps : int) -> None: 
        """
        Specify the length of array of shadow maps (THE_NB_SHADOWMAPS).
        """
    def SetOitOutput(self,theOutput : Graphic3d_RenderTransparentMethod) -> None: 
        """
        Set if Fragment Shader color should output to OIT buffers. Note that weighted OIT also requires at least 2 Fragment Outputs (color + coverage), and Depth Peeling requires at least 3 Fragment Outputs (depth + front color + back color),
        """
    def SetPBR(self,theIsPBR : bool) -> None: 
        """
        Sets whether standard program header should define functions and variables used in PBR pipeline.
        """
    def SetTextureSetBits(self,theBits : int) -> None: 
        """
        Set texture units declared within the program.
        """
    def SetVertexAttributes(self,theAttributes : Graphic3d_ShaderAttributeList) -> None: 
        """
        Assign the list of custom vertex attributes. Should be done before GLSL program initialization.
        """
    def ShaderObjects(self) -> Graphic3d_ShaderObjectList: 
        """
        Returns list of attached shader objects.
        """
    @staticmethod
    def ShadersFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to GLSL programs determined from CSF_ShadersDirectory or CASROOT environment variables.
        """
    def TextureSetBits(self) -> int: 
        """
        Return texture units declared within the program,
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Variables(self) -> Graphic3d_ShaderVariableList: 
        """
        The list of currently pushed but not applied custom uniform variables. This list is automatically cleared after applying to GLSL program.
        """
    def VertexAttributes(self) -> Graphic3d_ShaderAttributeList: 
        """
        Return the list of custom vertex attributes.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ShaderVariable(OCP.Standard.Standard_Transient):
    """
    Describes custom uniform shader variable.Describes custom uniform shader variable.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsDone(self) -> bool: 
        """
        Checks if the shader variable is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns name of shader variable.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Value(self) -> Graphic3d_ValueInterface: 
        """
        Returns interface of shader variable value.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_ShaderVariableList(OCP.NCollection.NCollection_BaseSequence):
    """
    Purpose: Definition of a sequence of elements indexed by an Integer in range of 1..n
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : Graphic3d_ShaderVariable) -> None: 
        """
        Append one item

        Append another sequence (making it empty)
        """
    @overload
    def Append(self,theSeq : Graphic3d_ShaderVariableList) -> None: ...
    def Assign(self,theOther : Graphic3d_ShaderVariableList) -> Graphic3d_ShaderVariableList: 
        """
        Replace this sequence by the items of theOther. This method does not change the internal allocator.
        """
    def ChangeFirst(self) -> Graphic3d_ShaderVariable: 
        """
        First item access
        """
    def ChangeLast(self) -> Graphic3d_ShaderVariable: 
        """
        Last item access
        """
    def ChangeValue(self,theIndex : int) -> Graphic3d_ShaderVariable: 
        """
        Variable item access by theIndex
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear the items out, take a new allocator if non null
        """
    def Exchange(self,I : int,J : int) -> None: 
        """
        Exchange two members
        """
    def First(self) -> Graphic3d_ShaderVariable: 
        """
        First item access
        """
    @overload
    def InsertAfter(self,theIndex : int,theSeq : Graphic3d_ShaderVariableList) -> None: 
        """
        InsertAfter theIndex another sequence (making it empty)

        InsertAfter theIndex theItem
        """
    @overload
    def InsertAfter(self,theIndex : int,theItem : Graphic3d_ShaderVariable) -> None: ...
    @overload
    def InsertBefore(self,theIndex : int,theItem : Graphic3d_ShaderVariable) -> None: 
        """
        InsertBefore theIndex theItem

        InsertBefore theIndex another sequence (making it empty)
        """
    @overload
    def InsertBefore(self,theIndex : int,theSeq : Graphic3d_ShaderVariableList) -> None: ...
    def IsEmpty(self) -> bool: 
        """
        Empty query
        """
    def Last(self) -> Graphic3d_ShaderVariable: 
        """
        Last item access
        """
    def Length(self) -> int: 
        """
        Number of items
        """
    def Lower(self) -> int: 
        """
        Method for consistency with other collections.
        """
    @overload
    def Prepend(self,theItem : Graphic3d_ShaderVariable) -> None: 
        """
        Prepend one item

        Prepend another sequence (making it empty)
        """
    @overload
    def Prepend(self,theSeq : Graphic3d_ShaderVariableList) -> None: ...
    @overload
    def Remove(self,theIndex : int) -> None: 
        """
        Remove one item

        Remove range of items
        """
    @overload
    def Remove(self,theFromIndex : int,theToIndex : int) -> None: ...
    def Reverse(self) -> None: 
        """
        Reverse sequence
        """
    def SetValue(self,theIndex : int,theItem : Graphic3d_ShaderVariable) -> None: 
        """
        Set item value by theIndex
        """
    def Size(self) -> int: 
        """
        Number of items
        """
    def Split(self,theIndex : int,theSeq : Graphic3d_ShaderVariableList) -> None: 
        """
        Split in two sequences
        """
    def Upper(self) -> int: 
        """
        Method for consistency with other collections.
        """
    def Value(self,theIndex : int) -> Graphic3d_ShaderVariable: 
        """
        Constant item access by theIndex
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> Graphic3d_ShaderVariable: 
        """
        Constant operator()

        Variable operator()
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self,theOther : Graphic3d_ShaderVariableList) -> None: ...
    def __iter__(self) -> Iterator[Graphic3d_ShaderVariable]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def delNode_s(theNode : NCollection_SeqNode,theAl : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Static deleter to be passed to BaseSequence
        """
    pass
class Graphic3d_StereoMode():
    """
    This enumeration defines the list of stereoscopic output modes.

    Members:

      Graphic3d_StereoMode_QuadBuffer

      Graphic3d_StereoMode_Anaglyph

      Graphic3d_StereoMode_RowInterlaced

      Graphic3d_StereoMode_ColumnInterlaced

      Graphic3d_StereoMode_ChessBoard

      Graphic3d_StereoMode_SideBySide

      Graphic3d_StereoMode_OverUnder

      Graphic3d_StereoMode_SoftPageFlip

      Graphic3d_StereoMode_OpenVR
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_StereoMode_Anaglyph: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_Anaglyph: 1>
    Graphic3d_StereoMode_ChessBoard: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_ChessBoard: 4>
    Graphic3d_StereoMode_ColumnInterlaced: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_ColumnInterlaced: 3>
    Graphic3d_StereoMode_OpenVR: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_OpenVR: 8>
    Graphic3d_StereoMode_OverUnder: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_OverUnder: 6>
    Graphic3d_StereoMode_QuadBuffer: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_QuadBuffer: 0>
    Graphic3d_StereoMode_RowInterlaced: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_RowInterlaced: 2>
    Graphic3d_StereoMode_SideBySide: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_SideBySide: 5>
    Graphic3d_StereoMode_SoftPageFlip: OCP.Graphic3d.Graphic3d_StereoMode # value = <Graphic3d_StereoMode.Graphic3d_StereoMode_SoftPageFlip: 7>
    __entries: dict # value = {'Graphic3d_StereoMode_QuadBuffer': (<Graphic3d_StereoMode.Graphic3d_StereoMode_QuadBuffer: 0>, None), 'Graphic3d_StereoMode_Anaglyph': (<Graphic3d_StereoMode.Graphic3d_StereoMode_Anaglyph: 1>, None), 'Graphic3d_StereoMode_RowInterlaced': (<Graphic3d_StereoMode.Graphic3d_StereoMode_RowInterlaced: 2>, None), 'Graphic3d_StereoMode_ColumnInterlaced': (<Graphic3d_StereoMode.Graphic3d_StereoMode_ColumnInterlaced: 3>, None), 'Graphic3d_StereoMode_ChessBoard': (<Graphic3d_StereoMode.Graphic3d_StereoMode_ChessBoard: 4>, None), 'Graphic3d_StereoMode_SideBySide': (<Graphic3d_StereoMode.Graphic3d_StereoMode_SideBySide: 5>, None), 'Graphic3d_StereoMode_OverUnder': (<Graphic3d_StereoMode.Graphic3d_StereoMode_OverUnder: 6>, None), 'Graphic3d_StereoMode_SoftPageFlip': (<Graphic3d_StereoMode.Graphic3d_StereoMode_SoftPageFlip: 7>, None), 'Graphic3d_StereoMode_OpenVR': (<Graphic3d_StereoMode.Graphic3d_StereoMode_OpenVR: 8>, None)}
    __members__: dict # value = {'Graphic3d_StereoMode_QuadBuffer': <Graphic3d_StereoMode.Graphic3d_StereoMode_QuadBuffer: 0>, 'Graphic3d_StereoMode_Anaglyph': <Graphic3d_StereoMode.Graphic3d_StereoMode_Anaglyph: 1>, 'Graphic3d_StereoMode_RowInterlaced': <Graphic3d_StereoMode.Graphic3d_StereoMode_RowInterlaced: 2>, 'Graphic3d_StereoMode_ColumnInterlaced': <Graphic3d_StereoMode.Graphic3d_StereoMode_ColumnInterlaced: 3>, 'Graphic3d_StereoMode_ChessBoard': <Graphic3d_StereoMode.Graphic3d_StereoMode_ChessBoard: 4>, 'Graphic3d_StereoMode_SideBySide': <Graphic3d_StereoMode.Graphic3d_StereoMode_SideBySide: 5>, 'Graphic3d_StereoMode_OverUnder': <Graphic3d_StereoMode.Graphic3d_StereoMode_OverUnder: 6>, 'Graphic3d_StereoMode_SoftPageFlip': <Graphic3d_StereoMode.Graphic3d_StereoMode_SoftPageFlip: 7>, 'Graphic3d_StereoMode_OpenVR': <Graphic3d_StereoMode.Graphic3d_StereoMode_OpenVR: 8>}
    pass
class Graphic3d_Structure(OCP.Standard.Standard_Transient):
    """
    This class allows the definition a graphic object. This graphic structure can be displayed, erased, or highlighted. This graphic structure can be connected with another graphic structure.This class allows the definition a graphic object. This graphic structure can be displayed, erased, or highlighted. This graphic structure can be connected with another graphic structure.
    """
    @staticmethod
    def AcceptConnection_s(theStructure1 : Graphic3d_Structure,theStructure2 : Graphic3d_Structure,theType : Graphic3d_TypeOfConnection) -> bool: 
        """
        Returns Standard_True if the connection is possible between <AStructure1> and <AStructure2> without a creation of a cycle.
        """
    def Ancestors(self,SG : Any) -> None: 
        """
        Returns the group of structures to which <me> is connected.
        """
    def CStructure(self) -> Graphic3d_CStructure: 
        """
        Returns the low-level structure
        """
    def CalculateBoundBox(self) -> None: 
        """
        Computes axis-aligned bounding box of a structure.
        """
    def Clear(self,WithDestruction : bool=True) -> None: 
        """
        if WithDestruction == Standard_True then suppress all the groups of primitives in the structure. and it is mandatory to create a new group in <me>. if WithDestruction == Standard_False then clears all the groups of primitives in the structure. and all the groups are conserved and empty. They will be erased at the next screen update. The structure itself is conserved. The transformation and the attributes of <me> are conserved. The childs of <me> are conserved.
        """
    def ClipPlanes(self) -> Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes slicing the structure on rendering.
        """
    def Compute(self) -> None: ...
    def ComputeVisual(self) -> Graphic3d_TypeOfStructure: ...
    @overload
    def Connect(self,theStructure : Graphic3d_Structure,theType : Graphic3d_TypeOfConnection,theWithCheck : bool=False) -> None: 
        """
        If Atype is TOC_DESCENDANT then add <AStructure> as a child structure of <me>. If Atype is TOC_ANCESTOR then add <AStructure> as a parent structure of <me>. The connection propagates Display, Highlight, Erase, Remove, and stacks the transformations. No connection if the graph of the structures contains a cycle and <WithCheck> is Standard_True;
        """
    @overload
    def Connect(self,thePrs : Graphic3d_Structure) -> None: ...
    def CurrentGroup(self) -> Graphic3d_Group: 
        """
        Returns the last created group or creates new one if list is empty.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Descendants(self,SG : Any) -> None: 
        """
        Returns the group of structures connected to <me>.
        """
    def Disconnect(self,theStructure : Graphic3d_Structure) -> None: 
        """
        Suppress the connection between <AStructure> and <me>.
        """
    def DisconnectAll(self,AType : Graphic3d_TypeOfConnection) -> None: 
        """
        If Atype is TOC_DESCENDANT then suppress all the connections with the child structures of <me>. If Atype is TOC_ANCESTOR then suppress all the connections with the parent structures of <me>.
        """
    def Display(self) -> None: 
        """
        Displays the structure <me> in all the views of the visualiser.
        """
    def DisplayPriority(self) -> Graphic3d_DisplayPriority: 
        """
        Returns the current display priority for this structure.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Erase(self) -> None: 
        """
        Erases this structure in all the views of the visualiser.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetZLayer(self) -> int: 
        """
        Get Z layer ID of displayed structure. The method returns -1 if the structure has no ID (deleted from graphic driver).
        """
    def GraphicClear(self,WithDestruction : bool) -> None: 
        """
        Clears the structure <me>.
        """
    def GraphicConnect(self,theDaughter : Graphic3d_Structure) -> None: ...
    def GraphicDisconnect(self,theDaughter : Graphic3d_Structure) -> None: ...
    def GraphicTransform(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: 
        """
        Internal method which sets new transformation without calling graphic manager callbacks.
        """
    def Groups(self) -> Graphic3d_SequenceOfGroup: 
        """
        Returns the groups sequence included in this structure.
        """
    def HLRValidation(self) -> bool: 
        """
        Hidden parts stored in this structure are valid if: 1) the owner is defined. 2) they are not invalid.
        """
    def Highlight(self,theStyle : Graphic3d_PresentationAttributes,theToUpdateMgr : bool=True) -> None: 
        """
        Highlights the structure in all the views with the given style
        """
    def HighlightStyle(self) -> Graphic3d_PresentationAttributes: 
        """
        Returns the highlight attributes.
        """
    def Identification(self) -> int: 
        """
        Returns the identification number of this structure.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsDeleted(self) -> bool: 
        """
        Returns TRUE if this structure is deleted (after Remove() call).
        """
    def IsDisplayed(self) -> bool: 
        """
        Returns the display indicator for this structure.
        """
    def IsEmpty(self) -> bool: 
        """
        Returns Standard_True if the structure <me> is empty. Warning: A structure is empty if : it do not have group or all the groups are empties and it do not have descendant or all the descendants are empties.
        """
    def IsHighlighted(self) -> bool: 
        """
        Returns the highlight indicator for this structure.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns Standard_True if the structure <me> is infinite.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if structure has mutable nature (content or location are be changed regularly). Mutable structure will be managed in different way than static ones.
        """
    def IsTransformed(self) -> bool: 
        """
        Returns TRUE if the structure is transformed.
        """
    def IsVisible(self) -> bool: 
        """
        Returns the visibility indicator for this structure.
        """
    def MinMaxValues(self,theToIgnoreInfiniteFlag : bool=False) -> OCP.Bnd.Bnd_Box: 
        """
        Returns the coordinates of the boundary box of the structure <me>. If <theToIgnoreInfiniteFlag> is TRUE, the method returns actual graphical boundaries of the Graphic3d_Group components. Otherwise, the method returns boundaries taking into account infinite state of the structure. This approach generally used for application specific fit operation (e.g. fitting the model into screen, not taking into account infinite helper elements). Warning: If the structure <me> is empty then the empty box is returned, If the structure <me> is infinite then the whole box is returned.
        """
    @staticmethod
    def Network_s(theStructure : Graphic3d_Structure,theType : Graphic3d_TypeOfConnection,theSet : Any) -> None: 
        """
        Returns <ASet> the group of structures : - directly or indirectly connected to <AStructure> if the TypeOfConnection == TOC_DESCENDANT - to which <AStructure> is directly or indirectly connected if the TypeOfConnection == TOC_ANCESTOR
        """
    def NewGroup(self) -> Graphic3d_Group: 
        """
        Append new group to this structure.
        """
    def NumberOfGroups(self) -> int: 
        """
        Returns the current number of groups in this structure.
        """
    def Owner(self) -> capsule: ...
    @staticmethod
    def PrintNetwork_s(AStructure : Graphic3d_Structure,AType : Graphic3d_TypeOfConnection) -> None: 
        """
        Prints information about the network associated with the structure <AStructure>.
        """
    @overload
    def ReCompute(self) -> None: 
        """
        Forces a new construction of the structure <me> if <me> is displayed and TOS_COMPUTED.

        Forces a new construction of the structure <me> if <me> is displayed in <aProjetor> and TOS_COMPUTED.
        """
    @overload
    def ReCompute(self,aProjector : Graphic3d_DataStructureManager) -> None: ...
    def RecomputeTransformation(self,theProjector : Graphic3d_Camera) -> None: 
        """
        Calculates structure transformation for specific camera position
        """
    @overload
    def Remove(self) -> None: 
        """
        Suppress the structure <me>. It will be erased at the next screen update. Warning: No more graphic operations in <me> after this call. Category: Methods to modify the class definition

        Suppress the structure in the list of descendants or in the list of ancestors.
        """
    @overload
    def Remove(self,thePrs : Graphic3d_Structure) -> None: ...
    @overload
    def Remove(self,thePtr : Graphic3d_Structure,theType : Graphic3d_TypeOfConnection) -> None: ...
    def RemoveAll(self) -> None: ...
    def ResetDisplayPriority(self) -> None: 
        """
        Reset the current priority of the structure to the previous priority. Warning: If structure is displayed then the SetDisplayPriority() method erases it and displays with the previous priority.
        """
    def SetClipPlanes(self,thePlanes : Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Changes a sequence of clip planes slicing the structure on rendering.
        """
    def SetComputeVisual(self,theVisual : Graphic3d_TypeOfStructure) -> None: ...
    @overload
    def SetDisplayPriority(self,thePriority : Graphic3d_DisplayPriority) -> None: 
        """
        Modifies the order of displaying the structure. Values are between 0 and 10. Structures are drawn according to their display priorities in ascending order. A structure of priority 10 is displayed the last and appears over the others. The default value is 5. Warning: If structure is displayed then the SetDisplayPriority method erases it and displays with the new priority. Raises Graphic3d_PriorityDefinitionError if Priority is greater than 10 or a negative value.
        """
    @overload
    def SetDisplayPriority(self,thePriority : int) -> None: ...
    def SetHLRValidation(self,theFlag : bool) -> None: ...
    def SetInfiniteState(self,theToSet : bool) -> None: 
        """
        Sets infinite flag. When TRUE, the MinMaxValues method returns: theXMin = theYMin = theZMin = RealFirst(). theXMax = theYMax = theZMax = RealLast(). By default, structure is created not infinite but empty.
        """
    def SetIsForHighlight(self,isForHighlight : bool) -> None: 
        """
        Marks the structure <me> representing wired structure needed for highlight only so it won't be added to BVH tree.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the structure location has mutable nature (content or location will be changed regularly).
        """
    def SetOwner(self,theOwner : capsule) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : Graphic3d_TransformPers) -> None: 
        """
        Modifies the current transform persistence (pan, zoom or rotate)
        """
    def SetTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: 
        """
        Modifies the current local transformation
        """
    def SetVisible(self,AValue : bool) -> None: 
        """
        Modifies the visibility indicator to Standard_True or Standard_False for the structure <me>. The default value at the definition of <me> is Standard_True.
        """
    def SetVisual(self,AVisual : Graphic3d_TypeOfStructure) -> None: 
        """
        Modifies the visualisation mode for the structure <me>.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID for the structure. The Z layer mechanism allows to display structures presented in higher layers in overlay of structures in lower layers by switching off z buffer depth test between layers
        """
    def SetZoomLimit(self,LimitInf : float,LimitSup : float) -> None: 
        """
        Modifies the minimum and maximum zoom coefficients for the structure <me>. The default value at the definition of <me> is unlimited. Category: Methods to modify the class definition Warning: Raises StructureDefinitionError if <LimitInf> is greater than <LimitSup> or if <LimitInf> or <LimitSup> is a negative value.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def TransformPersistence(self) -> Graphic3d_TransformPers: 
        """
        Returns transform persistence of the presentable object.
        """
    def Transformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return local transformation.
        """
    @staticmethod
    def Transforms_s(theTrsf : OCP.gp.gp_Trsf,theX : float,theY : float,theZ : float) -> tuple[float, float, float]: 
        """
        Transforms theX, theY, theZ with the transformation theTrsf.
        """
    def UnHighlight(self) -> None: 
        """
        Suppresses the highlight for the structure <me> in all the views of the visualiser.
        """
    def Visual(self) -> Graphic3d_TypeOfStructure: 
        """
        Returns the visualisation mode for the structure <me>.
        """
    def __init__(self,theManager : Graphic3d_StructureManager,theLinkPrs : Graphic3d_Structure=None) -> None: ...
    def computeHLR(self,theProjector : Graphic3d_Camera,theStructure : Graphic3d_Structure) -> Any: 
        """
        Returns the new Structure defined for the new visualization
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_StructureDefinitionError(Exception, BaseException):
    class type():
        pass
    __cause__: getset_descriptor # value = <attribute '__cause__' of 'BaseException' objects>
    __context__: getset_descriptor # value = <attribute '__context__' of 'BaseException' objects>
    __dict__: mappingproxy # value = mappingproxy({'__module__': 'OCP.Graphic3d', '__weakref__': <attribute '__weakref__' of 'Graphic3d_StructureDefinitionError' objects>, '__doc__': None})
    __suppress_context__: member_descriptor # value = <member '__suppress_context__' of 'BaseException' objects>
    __traceback__: getset_descriptor # value = <attribute '__traceback__' of 'BaseException' objects>
    __weakref__: getset_descriptor # value = <attribute '__weakref__' of 'Graphic3d_StructureDefinitionError' objects>
    args: getset_descriptor # value = <attribute 'args' of 'BaseException' objects>
    pass
class Graphic3d_StructureManager(OCP.Standard.Standard_Transient):
    """
    This class allows the definition of a manager to which the graphic objects are associated. It allows them to be globally manipulated. It defines the global attributes. Keywords: Structure, Structure Manager, Update Mode, Destroy, Highlight, VisibleThis class allows the definition of a manager to which the graphic objects are associated. It allows them to be globally manipulated. It defines the global attributes. Keywords: Structure, Structure Manager, Update Mode, Destroy, Highlight, Visible
    """
    def ChangeDisplayPriority(self,theStructure : Graphic3d_Structure,theOldPriority : Graphic3d_DisplayPriority,theNewPriority : Graphic3d_DisplayPriority) -> None: 
        """
        Changes the display priority of the structure <AStructure>.
        """
    def ChangeZLayer(self,theStructure : Graphic3d_Structure,theLayerId : int) -> None: 
        """
        Change Z layer for structure. The Z layer mechanism allows to display structures in higher layers in overlay of structures in lower layers.
        """
    def Clear(self,theStructure : Graphic3d_Structure,theWithDestruction : bool) -> None: 
        """
        Clears the structure.
        """
    def Connect(self,theMother : Graphic3d_Structure,theDaughter : Graphic3d_Structure) -> None: 
        """
        Connects the structures.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefinedViews(self) -> Any: 
        """
        Returns the group of views defined in the structure manager.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Disconnect(self,theMother : Graphic3d_Structure,theDaughter : Graphic3d_Structure) -> None: 
        """
        Disconnects the structures.
        """
    def Display(self,theStructure : Graphic3d_Structure) -> None: 
        """
        Display the structure.
        """
    def DisplayedStructures(self,SG : Any) -> None: 
        """
        Returns the set of structures displayed in visualiser <me>.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    @overload
    def Erase(self) -> None: 
        """
        Erases all the structures.

        Erases the structure.
        """
    @overload
    def Erase(self,theStructure : Graphic3d_Structure) -> None: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GraphicDriver(self) -> Graphic3d_GraphicDriver: 
        """
        Returns the graphic driver of <me>.
        """
    def Highlight(self,theStructure : Graphic3d_Structure) -> None: 
        """
        Highlights the structure.
        """
    def HighlightedStructures(self,SG : Any) -> None: 
        """
        Returns the set of highlighted structures in a visualiser <me>.
        """
    @overload
    def Identification(self,theView : Graphic3d_CView) -> int: 
        """
        Attaches the view to this structure manager and sets its identification number within the manager.

        Returns the structure with the identification number <AId>.
        """
    @overload
    def Identification(self,AId : int) -> Graphic3d_Structure: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsDeviceLost(self) -> bool: 
        """
        Returns TRUE if Device Lost flag has been set and presentation data should be reuploaded onto graphics driver.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MaxNumOfViews(self) -> int: 
        """
        Returns the theoretical maximum number of definable views in the manager. Warning: It's not possible to accept an infinite number of definable views because each view must have an identification and we have different managers.
        """
    def ObjectAffinity(self,theObject : OCP.Standard.Standard_Transient) -> Graphic3d_ViewAffinity: ...
    @overload
    def ReCompute(self,theStructure : Graphic3d_Structure) -> None: 
        """
        Forces a new construction of the structure. if <theStructure> is displayed and TOS_COMPUTED.

        Forces a new construction of the structure. if <theStructure> is displayed in <theProjector> and TOS_COMPUTED.
        """
    @overload
    def ReCompute(self,theStructure : Graphic3d_Structure,theProjector : Graphic3d_DataStructureManager) -> None: ...
    @overload
    def RecomputeStructures(self) -> None: 
        """
        Recomputes all structures in the manager. Resets Device Lost flag.

        Recomputes all structures from theStructures.
        """
    @overload
    def RecomputeStructures(self,theStructures : Any) -> None: ...
    def RegisterObject(self,theObject : OCP.Standard.Standard_Transient,theAffinity : Graphic3d_ViewAffinity) -> None: ...
    def Remove(self) -> None: 
        """
        Deletes and erases the 3D structure manager.
        """
    def SetDeviceLost(self) -> None: 
        """
        Sets Device Lost flag.
        """
    def SetTransform(self,theStructure : Graphic3d_Structure,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: 
        """
        Transforms the structure.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def UnHighlight(self,AStructure : Graphic3d_Structure) -> None: 
        """
        Suppress the highlighting on the structure <AStructure>.

        Suppresses the highlighting on all the structures in <me>.
        """
    @overload
    def UnHighlight(self) -> None: ...
    def UnIdentification(self,theView : Graphic3d_CView) -> None: 
        """
        Detach the view from this structure manager and release its identification.
        """
    def UnregisterObject(self,theObject : OCP.Standard.Standard_Transient) -> None: ...
    def Update(self,theLayerId : int=-1) -> None: 
        """
        Invalidates bounding box of specified ZLayerId.
        """
    def __init__(self,theDriver : Graphic3d_GraphicDriver) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Text(OCP.Standard.Standard_Transient):
    """
    This class allows the definition of a text object for display. The text might be defined in one of ways, using: - text value and position, - text value, orientation and the state whether the text uses position as point of attach. - text formatter. Formatter contains text, height and alignment parameter.This class allows the definition of a text object for display. The text might be defined in one of ways, using: - text value and position, - text value, orientation and the state whether the text uses position as point of attach. - text formatter. Formatter contains text, height and alignment parameter.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasOwnAnchorPoint(self) -> bool: 
        """
        Returns true if the text has an anchor point
        """
    def HasPlane(self) -> bool: 
        """
        Returns true if the text is filled by a point
        """
    def Height(self) -> float: 
        """
        Sets height of text. (Relative to the Normalized Projection Coordinates (NPC) Space).
        """
    def HorizontalAlignment(self) -> Graphic3d_HorizontalTextAlignment: 
        """
        Returns horizontal alignment of text.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Orientation(self) -> OCP.gp.gp_Ax2: 
        """
        Returns text orientation in 3D space.
        """
    def Position(self) -> OCP.gp.gp_Pnt: 
        """
        The 3D point of attachment is projected. If the orientation is defined, the text is written in the plane of projection.
        """
    def ResetOrientation(self) -> None: 
        """
        Reset text orientation in 3D space.
        """
    def SetHeight(self,theHeight : float) -> None: 
        """
        Returns height of text
        """
    def SetHorizontalAlignment(self,theJustification : Graphic3d_HorizontalTextAlignment) -> None: 
        """
        Sets horizontal alignment of text.
        """
    def SetOrientation(self,theOrientation : OCP.gp.gp_Ax2) -> None: 
        """
        Sets text orientation in 3D space.
        """
    def SetOwnAnchorPoint(self,theHasOwnAnchor : bool) -> None: 
        """
        Returns true if the text has an anchor point
        """
    def SetPosition(self,thePoint : OCP.gp.gp_Pnt) -> None: 
        """
        Sets text point.
        """
    @overload
    def SetText(self,theText : OCP.NCollection.NCollection_Utf8String) -> None: 
        """
        Sets text value.

        Sets text value.

        Sets text value.
        """
    @overload
    def SetText(self,theText : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @overload
    def SetText(self,theText : str) -> None: ...
    def SetTextFormatter(self,theFormatter : OCP.Font.Font_TextFormatter) -> None: 
        """
        Setup text default formatter for text within this context.
        """
    def SetVerticalAlignment(self,theJustification : Graphic3d_VerticalTextAlignment) -> None: 
        """
        Sets vertical alignment of text.
        """
    def Text(self) -> OCP.NCollection.NCollection_Utf8String: 
        """
        Returns text value.
        """
    def TextFormatter(self) -> OCP.Font.Font_TextFormatter: 
        """
        Returns text formatter; NULL by default, which means standard text formatter will be used.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def VerticalAlignment(self) -> Graphic3d_VerticalTextAlignment: 
        """
        Returns vertical alignment of text.
        """
    def __init__(self,theHeight : float) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_TextPath():
    """
    Direction in which text is displayed.

    Members:

      Graphic3d_TP_UP

      Graphic3d_TP_DOWN

      Graphic3d_TP_LEFT

      Graphic3d_TP_RIGHT
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TP_DOWN: OCP.Graphic3d.Graphic3d_TextPath # value = <Graphic3d_TextPath.Graphic3d_TP_DOWN: 1>
    Graphic3d_TP_LEFT: OCP.Graphic3d.Graphic3d_TextPath # value = <Graphic3d_TextPath.Graphic3d_TP_LEFT: 2>
    Graphic3d_TP_RIGHT: OCP.Graphic3d.Graphic3d_TextPath # value = <Graphic3d_TextPath.Graphic3d_TP_RIGHT: 3>
    Graphic3d_TP_UP: OCP.Graphic3d.Graphic3d_TextPath # value = <Graphic3d_TextPath.Graphic3d_TP_UP: 0>
    __entries: dict # value = {'Graphic3d_TP_UP': (<Graphic3d_TextPath.Graphic3d_TP_UP: 0>, None), 'Graphic3d_TP_DOWN': (<Graphic3d_TextPath.Graphic3d_TP_DOWN: 1>, None), 'Graphic3d_TP_LEFT': (<Graphic3d_TextPath.Graphic3d_TP_LEFT: 2>, None), 'Graphic3d_TP_RIGHT': (<Graphic3d_TextPath.Graphic3d_TP_RIGHT: 3>, None)}
    __members__: dict # value = {'Graphic3d_TP_UP': <Graphic3d_TextPath.Graphic3d_TP_UP: 0>, 'Graphic3d_TP_DOWN': <Graphic3d_TextPath.Graphic3d_TP_DOWN: 1>, 'Graphic3d_TP_LEFT': <Graphic3d_TextPath.Graphic3d_TP_LEFT: 2>, 'Graphic3d_TP_RIGHT': <Graphic3d_TextPath.Graphic3d_TP_RIGHT: 3>}
    pass
class Graphic3d_Texture1D(Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    This is an abstract class for managing 1D textures.This is an abstract class for managing 1D textures.This is an abstract class for managing 1D textures.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Name(self) -> Graphic3d_NameOfTexture1D: 
        """
        Returns the name of the predefined textures or NOT_1D_UNKNOWN when the name is given as a filename.
        """
    @staticmethod
    def NumberOfTextures_s() -> int: 
        """
        Returns the number of predefined textures.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    @staticmethod
    def TextureName_s(aRank : int) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the name of the predefined texture of rank <aRank>
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Texture1Dmanual(Graphic3d_Texture1D, Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    This class provides the implementation of a manual 1D texture. you MUST provide texture coordinates on your facets if you want to see your texture.This class provides the implementation of a manual 1D texture. you MUST provide texture coordinates on your facets if you want to see your texture.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Name(self) -> Graphic3d_NameOfTexture1D: 
        """
        Returns the name of the predefined textures or NOT_1D_UNKNOWN when the name is given as a filename.
        """
    @staticmethod
    def NumberOfTextures_s() -> int: 
        """
        Returns the number of predefined textures.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    @staticmethod
    def TextureName_s(aRank : int) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the name of the predefined texture of rank <aRank>
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @overload
    def __init__(self,theFileName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @overload
    def __init__(self,theNOT : Graphic3d_NameOfTexture1D) -> None: ...
    @overload
    def __init__(self,thePixMap : OCP.Image.Image_PixMap) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Texture1Dsegment(Graphic3d_Texture1D, Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    This class provides the implementation of a 1D texture applicable along a segment. You might use the SetSegment() method to set the way the texture is "stretched" on facets.This class provides the implementation of a 1D texture applicable along a segment. You might use the SetSegment() method to set the way the texture is "stretched" on facets.This class provides the implementation of a 1D texture applicable along a segment. You might use the SetSegment() method to set the way the texture is "stretched" on facets.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Name(self) -> Graphic3d_NameOfTexture1D: 
        """
        Returns the name of the predefined textures or NOT_1D_UNKNOWN when the name is given as a filename.
        """
    @staticmethod
    def NumberOfTextures_s() -> int: 
        """
        Returns the number of predefined textures.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def Segment(self,theX1 : float,theY1 : float,theZ1 : float,theX2 : float,theY2 : float,theZ2 : float) -> None: 
        """
        Returns the values of the current segment X1, Y1, Z1 , X2, Y2, Z2.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    def SetSegment(self,theX1 : float,theY1 : float,theZ1 : float,theX2 : float,theY2 : float,theZ2 : float) -> None: 
        """
        Sets the texture application bounds. Defines the way the texture is stretched across facets. Default values are <0.0, 0.0, 0.0> , <0.0, 0.0, 1.0>
        """
    @staticmethod
    def TextureName_s(aRank : int) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the name of the predefined texture of rank <aRank>
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @overload
    def __init__(self,theFileName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @overload
    def __init__(self,theNOT : Graphic3d_NameOfTexture1D) -> None: ...
    @overload
    def __init__(self,thePixMap : OCP.Image.Image_PixMap) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_MediaTexture(Graphic3d_Texture2D, Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    Texture adapter for Media_Frame.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def Frame(self) -> Media_Frame: 
        """
        Return the frame.
        """
    def GenerateNewId(self) -> None: 
        """
        Regenerate a new texture id
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        Image reader.
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Name(self) -> Graphic3d_NameOfTexture2D: 
        """
        Returns the name of the predefined textures or NOT_2D_UNKNOWN when the name is given as a filename.
        """
    @staticmethod
    def NumberOfTextures_s() -> int: 
        """
        Returns the number of predefined textures.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetFrame(self,theFrame : Media_Frame) -> None: 
        """
        Set the frame.
        """
    def SetImage(self,thePixMap : OCP.Image.Image_PixMap) -> None: 
        """
        Assign new image to the texture. Note that this method does not invalidate already uploaded resources - consider calling ::UpdateRevision() if needed.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    @staticmethod
    def TextureName_s(theRank : int) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the name of the predefined texture of rank <aRank>
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    def __init__(self,theMutex : Any,thePlane : int=-1) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Texture2Dplane(Graphic3d_Texture2D, Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    This class allows the management of a 2D texture defined from a plane equation Use the SetXXX() methods for positioning the texture as you want.This class allows the management of a 2D texture defined from a plane equation Use the SetXXX() methods for positioning the texture as you want.This class allows the management of a 2D texture defined from a plane equation Use the SetXXX() methods for positioning the texture as you want.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Name(self) -> Graphic3d_NameOfTexture2D: 
        """
        Returns the name of the predefined textures or NOT_2D_UNKNOWN when the name is given as a filename.
        """
    @staticmethod
    def NumberOfTextures_s() -> int: 
        """
        Returns the number of predefined textures.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Plane(self) -> Graphic3d_NameOfTexturePlane: 
        """
        Returns the current texture plane name or NOTP_UNKNOWN when the plane is user defined.
        """
    def PlaneS(self,A : float,B : float,C : float,D : float) -> None: 
        """
        Returns the current texture plane S equation
        """
    def PlaneT(self,A : float,B : float,C : float,D : float) -> None: 
        """
        Returns the current texture plane T equation
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def Rotation(self,theVal : float) -> None: 
        """
        Returns the current texture rotation angle
        """
    def ScaleS(self,theVal : float) -> None: 
        """
        Returns the current texture S scale value
        """
    def ScaleT(self,theVal : float) -> None: 
        """
        Returns the current texture T scale value
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetImage(self,thePixMap : OCP.Image.Image_PixMap) -> None: 
        """
        Assign new image to the texture. Note that this method does not invalidate already uploaded resources - consider calling ::UpdateRevision() if needed.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    def SetPlane(self,thePlane : Graphic3d_NameOfTexturePlane) -> None: 
        """
        Defines the texture projection plane for both S and T texture coordinate default is NOTP_XY meaning: <1.0, 0.0, 0.0, 0.0> for S and <0.0, 1.0, 0.0, 0.0> for T
        """
    def SetPlaneS(self,A : float,B : float,C : float,D : float) -> None: 
        """
        Defines the texture projection plane for texture coordinate S default is <1.0, 0.0, 0.0, 0.0>
        """
    def SetPlaneT(self,A : float,B : float,C : float,D : float) -> None: 
        """
        Defines the texture projection plane for texture coordinate T default is <0.0, 1.0, 0.0, 0.0>
        """
    def SetRotation(self,theVal : float) -> None: 
        """
        Sets the rotation angle of the whole texture. the same result might be achieved by recomputing the S and T plane equation but it's not the easiest way... the angle is expressed in degrees default is 0.0
        """
    def SetScaleS(self,theVal : float) -> None: 
        """
        Defines the texture scale for the S texture coordinate much easier than recomputing the S plane equation but the result is the same default to 1.0
        """
    def SetScaleT(self,theVal : float) -> None: 
        """
        Defines the texture scale for the T texture coordinate much easier than recompution the T plane equation but the result is the same default to 1.0
        """
    def SetTranslateS(self,theVal : float) -> None: 
        """
        Defines the texture translation for the S texture coordinate you can obtain the same effect by modifying the S plane equation but its not easier. default to 0.0
        """
    def SetTranslateT(self,theVal : float) -> None: 
        """
        Defines the texture translation for the T texture coordinate you can obtain the same effect by modifying the T plane equation but its not easier. default to 0.0
        """
    @staticmethod
    def TextureName_s(theRank : int) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the name of the predefined texture of rank <aRank>
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def TranslateS(self,theVal : float) -> None: 
        """
        Returns the current texture S translation value
        """
    def TranslateT(self,theVal : float) -> None: 
        """
        Returns the current texture T translation value
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @overload
    def __init__(self,theFileName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @overload
    def __init__(self,theNOT : Graphic3d_NameOfTexture2D) -> None: ...
    @overload
    def __init__(self,thePixMap : OCP.Image.Image_PixMap) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_Texture3D(Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    This abstract class for managing 3D textures.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        Load and return image.
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetImage(self,thePixMap : OCP.Image.Image_PixMap) -> None: 
        """
        Assign new image to the texture. Note that this method does not invalidate already uploaded resources - consider calling ::UpdateRevision() if needed.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @overload
    def __init__(self,theFileName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @overload
    def __init__(self,thePixMap : OCP.Image.Image_PixMap) -> None: ...
    @overload
    def __init__(self,theFiles : OCP.TColStd.TColStd_Array1OfAsciiString) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_TextureEnv(Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    This class provides environment texture.This class provides environment texture.This class provides environment texture.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps should be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def Name(self) -> Graphic3d_NameOfTextureEnv: 
        """
        Returns the name of the predefined textures or NOT_ENV_UNKNOWN when the name is given as a filename.
        """
    @staticmethod
    def NumberOfTextures_s() -> int: 
        """
        Returns the number of predefined textures.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps or not.
        """
    @staticmethod
    def TextureName_s(theRank : int) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the name of the predefined texture of rank <aRank>
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    @overload
    def __init__(self,theFileName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @overload
    def __init__(self,theName : Graphic3d_NameOfTextureEnv) -> None: ...
    @overload
    def __init__(self,thePixMap : OCP.Image.Image_PixMap) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_CubeMapPacked(Graphic3d_CubeMap, Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    Class is intended to process cubemap packed into single image plane.Class is intended to process cubemap packed into single image plane.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def CompressedValue(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        Returns current cubemap side as compressed PixMap.
        """
    def CurrentSide(self) -> Graphic3d_CubeMapSide: 
        """
        Returns current cubemap side (iterator state).
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. Default constructors allow defining the texture source as path to texture image or directly as pixmap. If the source is defined as path, then the image will be dynamically loaded when this method is called (and no copy will be preserved in this class instance). Inheritors may dynamically generate the image. Notice, image data should be in Bottom-Up order (see Image_PixMap::IsTopDown())!
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps of cubemap will be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def More(self) -> bool: 
        """
        Returns whether the iterator has reached the end (true if it hasn't).
        """
    def Next(self) -> None: 
        """
        Moves iterator to the next cubemap side. Uses OpenGL cubemap sides order +X -> -X -> +Y -> -Y -> +Z -> -Z.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Reset(self) -> Graphic3d_CubeMap: 
        """
        Sets iterator state to +X cubemap side.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps of cubemap or not.
        """
    def SetZInversion(self,theZIsInverted : bool) -> None: 
        """
        Sets Z axis inversion (vertical flipping).
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    def Value(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        Returns current cubemap side as PixMap. Resulting PixMap is memory wrapper over original image. Returns null handle if current side or whole cubemap is invalid. Origin image has to contain six quad tiles having one sizes without any gaps to be valid.
        """
    def ZIsInverted(self) -> bool: 
        """
        Returns whether Z axis is inverted.
        """
    @overload
    def __init__(self,theFileName : OCP.TCollection.TCollection_AsciiString,theOrder : Graphic3d_ValidatedCubeMapOrder=Graphic3d_ValidatedCubeMapOrder) -> None: ...
    @overload
    def __init__(self,theImage : OCP.Image.Image_PixMap,theOrder : Graphic3d_ValidatedCubeMapOrder=Graphic3d_ValidatedCubeMapOrder) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_TextureParams(OCP.Standard.Standard_Transient):
    """
    This class describes texture parameters.This class describes texture parameters.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisontropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def BaseLevel(self) -> int: 
        """
        Returns base texture mipmap level; 0 by default.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Filter(self) -> Graphic3d_TypeOfTextureFilter: 
        """
        Returns texture interpolation filter. Default value is Graphic3d_TOTF_NEAREST.
        """
    def GenMode(self) -> Graphic3d_TypeOfTextureMode: 
        """
        Returns texture coordinates generation mode. Default value is Graphic3d_TOTM_MANUAL.
        """
    def GenPlaneS(self) -> Graphic3d_Vec4: 
        """
        Returns texture coordinates generation plane S.
        """
    def GenPlaneT(self) -> Graphic3d_Vec4: 
        """
        Returns texture coordinates generation plane T.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate. Default value is FALSE.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enabled. Default value is FALSE.
        """
    def MaxLevel(self) -> int: 
        """
        Return maximum texture mipmap array level; 1000 by default. Real rendering limit will take into account mipmap generation flags and presence of mipmaps in loaded image.
        """
    def Rotation(self) -> float: 
        """
        Return rotation angle in degrees; 0 by default. Complete transformation matrix: Rotation -> Translation -> Scale.
        """
    def SamplerRevision(self) -> int: 
        """
        Return modification counter of parameters related to sampler state.
        """
    def Scale(self) -> OCP.gp.gp_Vec2f: 
        """
        Return scale factor; (1.0; 1.0) by default, which means no scaling. Complete transformation matrix: Rotation -> Translation -> Scale.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetFilter(self,theFilter : Graphic3d_TypeOfTextureFilter) -> None: ...
    def SetGenMode(self,theMode : Graphic3d_TypeOfTextureMode,thePlaneS : Graphic3d_Vec4,thePlaneT : Graphic3d_Vec4) -> None: 
        """
        Setup texture coordinates generation mode.
        """
    def SetLevelsRange(self,theFirstLevel : int,theSecondLevel : int=0) -> None: 
        """
        Setups texture mipmap array levels range. The lowest value will be the base level. The remaining one will be the maximum level.
        """
    def SetModulate(self,theToModulate : bool) -> None: ...
    def SetRepeat(self,theToRepeat : bool) -> None: ...
    def SetRotation(self,theAngleDegrees : float) -> None: ...
    def SetScale(self,theScale : OCP.gp.gp_Vec2f) -> None: ...
    def SetTextureUnit(self,theUnit : Graphic3d_TextureUnit) -> None: 
        """
        Setup default texture unit.
        """
    def SetTranslation(self,theVec : OCP.gp.gp_Vec2f) -> None: ...
    def TextureUnit(self) -> Graphic3d_TextureUnit: 
        """
        Default texture unit to be used, default is Graphic3d_TextureUnit_BaseColor.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Translation(self) -> OCP.gp.gp_Vec2f: 
        """
        Return translation vector; (0.0; 0.0), which means no translation. Complete transformation matrix: Rotation -> Translation -> Scale.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_CubeMapSeparate(Graphic3d_CubeMap, Graphic3d_TextureMap, Graphic3d_TextureRoot, OCP.Standard.Standard_Transient):
    """
    Class to manage cubemap located in six different images.Class to manage cubemap located in six different images.
    """
    def AnisoFilter(self) -> Graphic3d_LevelOfTextureAnisotropy: 
        """
        Returns level of anisotropy texture filter. Default value is Graphic3d_LOTA_OFF.
        """
    def CompressedValue(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        Returns current cubemap side as compressed PixMap.
        """
    def CurrentSide(self) -> Graphic3d_CubeMapSide: 
        """
        Returns current cubemap side (iterator state).
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableModulate(self) -> None: 
        """
        disable texture modulate mode. the image is directly decal on the surface.
        """
    def DisableRepeat(self) -> None: 
        """
        use this methods if you want to disable texture repetition on your objects.
        """
    def DisableSmooth(self) -> None: 
        """
        disable texture smoothing
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EnableModulate(self) -> None: 
        """
        enable texture modulate mode. the image is modulate with the shading of the surface.
        """
    def EnableRepeat(self) -> None: 
        """
        use this methods if you want to enable texture repetition on your objects.
        """
    def EnableSmooth(self) -> None: 
        """
        enable texture smoothing
        """
    def GetCompressedImage(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_CompressedPixMap: 
        """
        This method will be called by graphic driver each time when texture resource should be created. It is called in front of GetImage() for uploading compressed image formats natively supported by GPU.
        """
    def GetId(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        This ID will be used to manage resource in graphic driver.
        """
    def GetImage(self,arg0 : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        Returns NULL.
        """
    def GetParams(self) -> Graphic3d_TextureParams: 
        """
        Returns low-level texture parameters
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasMipmaps(self) -> bool: 
        """
        Returns whether mipmaps of cubemap will be generated or not.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsColorMap(self) -> bool: 
        """
        Return flag indicating color nature of values within the texture; TRUE by default.
        """
    def IsDone(self) -> bool: 
        """
        Checks if a texture class is valid or not. Returns true if the construction of the class is correct.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsModulate(self) -> bool: 
        """
        Returns TRUE if the texture is modulate.
        """
    def IsRepeat(self) -> bool: 
        """
        Returns TRUE if the texture repeat is enable.
        """
    def IsSmoothed(self) -> bool: 
        """
        Returns TRUE if the texture is smoothed.
        """
    def IsTopDown(self) -> bool: 
        """
        Returns whether row's memory layout is top-down.
        """
    def More(self) -> bool: 
        """
        Returns whether the iterator has reached the end (true if it hasn't).
        """
    def Next(self) -> None: 
        """
        Moves iterator to the next cubemap side. Uses OpenGL cubemap sides order +X -> -X -> +Y -> -Y -> +Z -> -Z.
        """
    def Path(self) -> OCP.OSD.OSD_Path: 
        """
        Returns the full path of the defined texture. It could be empty path if GetImage() is overridden to load image not from file.
        """
    def Reset(self) -> Graphic3d_CubeMap: 
        """
        Sets iterator state to +X cubemap side.
        """
    def Revision(self) -> int: 
        """
        Return image revision.
        """
    def SetAnisoFilter(self,theLevel : Graphic3d_LevelOfTextureAnisotropy) -> None: ...
    def SetColorMap(self,theIsColor : bool) -> None: 
        """
        Set flag indicating color nature of values within the texture.
        """
    def SetMipmapsGeneration(self,theToGenerateMipmaps : bool) -> None: 
        """
        Sets whether to generate mipmaps of cubemap or not.
        """
    def SetZInversion(self,theZIsInverted : bool) -> None: 
        """
        Sets Z axis inversion (vertical flipping).
        """
    @staticmethod
    def TexturesFolder_s() -> OCP.TCollection.TCollection_AsciiString: 
        """
        The path to textures determined from CSF_MDTVTexturesDirectory or CASROOT environment variables.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> Graphic3d_TypeOfTexture: 
        """
        Returns the texture type.
        """
    def UpdateRevision(self) -> None: 
        """
        Update image revision. Can be used for signaling changes in the texture source (e.g. file update, pixmap update) without re-creating texture source itself (since unique id should be never modified).
        """
    def Value(self,theSupported : OCP.Image.Image_SupportedFormats) -> OCP.Image.Image_PixMap: 
        """
        Returns current side of cubemap as PixMap. Returns null handle if current side or whole cubemap is invalid. All origin images have to have the same sizes, format and quad shapes to form valid cubemap.
        """
    def ZIsInverted(self) -> bool: 
        """
        Returns whether Z axis is inverted.
        """
    @overload
    def __init__(self,thePaths : OCP.TColStd.TColStd_Array1OfAsciiString) -> None: ...
    @overload
    def __init__(self,theImages : Any) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_MediaTextureSet(Graphic3d_TextureSet, OCP.Standard.Standard_Transient):
    """
    Texture adapter for Media_Frame.
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Duration(self) -> float: 
        """
        Return duration in seconds.
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> Graphic3d_TextureMap: 
        """
        Return the first texture.
        """
    def FrameSize(self) -> Graphic3d_Vec2i: 
        """
        Return front frame dimensions.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Input(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Return input media.
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if texture array is empty.
        """
    def IsFullRangeYUV(self) -> bool: 
        """
        Return TRUE if YUV range is full.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsPlanarYUV(self) -> bool: 
        """
        Return TRUE if texture set defined 3 YUV planes.
        """
    def Lower(self) -> int: 
        """
        Return the lower index in texture set.
        """
    def Notify(self) -> None: 
        """
        Call callback.
        """
    def OpenInput(self,thePath : OCP.TCollection.TCollection_AsciiString,theToWait : bool) -> None: 
        """
        Open specified file. Passing an empty path would close current input.
        """
    def PlayerContext(self) -> Media_PlayerContext: 
        """
        Return player context; it can be NULL until first OpenInput().
        """
    def Progress(self) -> float: 
        """
        Return playback progress in seconds.
        """
    def SetCallback(self,theCallbackFunction : Any,theCallbackUserPtr : capsule) -> None: 
        """
        SetCallback(self: OCP.Graphic3d.Graphic3d_MediaTextureSet, theCallbackFunction: void (void*), theCallbackUserPtr: capsule) -> None

        Setup callback to be called on queue progress (e.g. when new frame should be displayed).
        """
    def SetFirst(self,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Return the first texture.
        """
    def SetValue(self,theIndex : int,theTexture : Graphic3d_TextureMap) -> None: 
        """
        Return the texture at specified position within [0, Size()) range.
        """
    def ShaderProgram(self) -> Graphic3d_ShaderProgram: 
        """
        Return shader program for displaying texture set.
        """
    def Size(self) -> int: 
        """
        Return number of textures.
        """
    def SwapFrames(self) -> bool: 
        """
        Swap front/back frames.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Upper(self) -> int: 
        """
        Return the upper index in texture set.
        """
    def Value(self,theIndex : int) -> Graphic3d_TextureMap: 
        """
        Return the texture at specified position within [0, Size()) range.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class Graphic3d_TextureSetBits():
    """
    Standard texture units combination bits.

    Members:

      Graphic3d_TextureSetBits_NONE

      Graphic3d_TextureSetBits_BaseColor

      Graphic3d_TextureSetBits_Emissive

      Graphic3d_TextureSetBits_Occlusion

      Graphic3d_TextureSetBits_Normal

      Graphic3d_TextureSetBits_MetallicRoughness
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TextureSetBits_BaseColor: OCP.Graphic3d.Graphic3d_TextureSetBits # value = <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_BaseColor: 1>
    Graphic3d_TextureSetBits_Emissive: OCP.Graphic3d.Graphic3d_TextureSetBits # value = <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Emissive: 2>
    Graphic3d_TextureSetBits_MetallicRoughness: OCP.Graphic3d.Graphic3d_TextureSetBits # value = <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_MetallicRoughness: 16>
    Graphic3d_TextureSetBits_NONE: OCP.Graphic3d.Graphic3d_TextureSetBits # value = <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_NONE: 0>
    Graphic3d_TextureSetBits_Normal: OCP.Graphic3d.Graphic3d_TextureSetBits # value = <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Normal: 8>
    Graphic3d_TextureSetBits_Occlusion: OCP.Graphic3d.Graphic3d_TextureSetBits # value = <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Occlusion: 4>
    __entries: dict # value = {'Graphic3d_TextureSetBits_NONE': (<Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_NONE: 0>, None), 'Graphic3d_TextureSetBits_BaseColor': (<Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_BaseColor: 1>, None), 'Graphic3d_TextureSetBits_Emissive': (<Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Emissive: 2>, None), 'Graphic3d_TextureSetBits_Occlusion': (<Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Occlusion: 4>, None), 'Graphic3d_TextureSetBits_Normal': (<Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Normal: 8>, None), 'Graphic3d_TextureSetBits_MetallicRoughness': (<Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_MetallicRoughness: 16>, None)}
    __members__: dict # value = {'Graphic3d_TextureSetBits_NONE': <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_NONE: 0>, 'Graphic3d_TextureSetBits_BaseColor': <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_BaseColor: 1>, 'Graphic3d_TextureSetBits_Emissive': <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Emissive: 2>, 'Graphic3d_TextureSetBits_Occlusion': <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Occlusion: 4>, 'Graphic3d_TextureSetBits_Normal': <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_Normal: 8>, 'Graphic3d_TextureSetBits_MetallicRoughness': <Graphic3d_TextureSetBits.Graphic3d_TextureSetBits_MetallicRoughness: 16>}
    pass
class Graphic3d_TextureUnit():
    """
    Texture unit.

    Members:

      Graphic3d_TextureUnit_0

      Graphic3d_TextureUnit_1

      Graphic3d_TextureUnit_2

      Graphic3d_TextureUnit_3

      Graphic3d_TextureUnit_4

      Graphic3d_TextureUnit_5

      Graphic3d_TextureUnit_6

      Graphic3d_TextureUnit_7

      Graphic3d_TextureUnit_8

      Graphic3d_TextureUnit_9

      Graphic3d_TextureUnit_10

      Graphic3d_TextureUnit_11

      Graphic3d_TextureUnit_12

      Graphic3d_TextureUnit_13

      Graphic3d_TextureUnit_14

      Graphic3d_TextureUnit_15

      Graphic3d_TextureUnit_BaseColor

      Graphic3d_TextureUnit_Emissive

      Graphic3d_TextureUnit_Occlusion

      Graphic3d_TextureUnit_Normal

      Graphic3d_TextureUnit_MetallicRoughness

      Graphic3d_TextureUnit_EnvMap

      Graphic3d_TextureUnit_PointSprite

      Graphic3d_TextureUnit_DepthPeelingDepth

      Graphic3d_TextureUnit_DepthPeelingFrontColor

      Graphic3d_TextureUnit_ShadowMap

      Graphic3d_TextureUnit_PbrEnvironmentLUT

      Graphic3d_TextureUnit_PbrIblDiffuseSH

      Graphic3d_TextureUnit_PbrIblSpecular
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TextureUnit_0: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>
    Graphic3d_TextureUnit_1: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>
    Graphic3d_TextureUnit_10: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_10: 10>
    Graphic3d_TextureUnit_11: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_11: 11>
    Graphic3d_TextureUnit_12: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_12: 12>
    Graphic3d_TextureUnit_13: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_13: 13>
    Graphic3d_TextureUnit_14: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_14: 14>
    Graphic3d_TextureUnit_15: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_15: 15>
    Graphic3d_TextureUnit_2: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_2: 2>
    Graphic3d_TextureUnit_3: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_3: 3>
    Graphic3d_TextureUnit_4: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_4: 4>
    Graphic3d_TextureUnit_5: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_5: 5>
    Graphic3d_TextureUnit_6: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_6: 6>
    Graphic3d_TextureUnit_7: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_7: 7>
    Graphic3d_TextureUnit_8: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_8: 8>
    Graphic3d_TextureUnit_9: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_9: 9>
    Graphic3d_TextureUnit_BaseColor: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>
    Graphic3d_TextureUnit_DepthPeelingDepth: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_DepthPeelingDepth: -6>
    Graphic3d_TextureUnit_DepthPeelingFrontColor: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_DepthPeelingFrontColor: -5>
    Graphic3d_TextureUnit_Emissive: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>
    Graphic3d_TextureUnit_EnvMap: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>
    Graphic3d_TextureUnit_MetallicRoughness: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_4: 4>
    Graphic3d_TextureUnit_Normal: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_3: 3>
    Graphic3d_TextureUnit_Occlusion: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_2: 2>
    Graphic3d_TextureUnit_PbrEnvironmentLUT: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrEnvironmentLUT: -3>
    Graphic3d_TextureUnit_PbrIblDiffuseSH: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrIblDiffuseSH: -2>
    Graphic3d_TextureUnit_PbrIblSpecular: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrIblSpecular: -1>
    Graphic3d_TextureUnit_PointSprite: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>
    Graphic3d_TextureUnit_ShadowMap: OCP.Graphic3d.Graphic3d_TextureUnit # value = <Graphic3d_TextureUnit.Graphic3d_TextureUnit_ShadowMap: -4>
    __entries: dict # value = {'Graphic3d_TextureUnit_0': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>, None), 'Graphic3d_TextureUnit_1': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>, None), 'Graphic3d_TextureUnit_2': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_2: 2>, None), 'Graphic3d_TextureUnit_3': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_3: 3>, None), 'Graphic3d_TextureUnit_4': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_4: 4>, None), 'Graphic3d_TextureUnit_5': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_5: 5>, None), 'Graphic3d_TextureUnit_6': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_6: 6>, None), 'Graphic3d_TextureUnit_7': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_7: 7>, None), 'Graphic3d_TextureUnit_8': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_8: 8>, None), 'Graphic3d_TextureUnit_9': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_9: 9>, None), 'Graphic3d_TextureUnit_10': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_10: 10>, None), 'Graphic3d_TextureUnit_11': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_11: 11>, None), 'Graphic3d_TextureUnit_12': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_12: 12>, None), 'Graphic3d_TextureUnit_13': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_13: 13>, None), 'Graphic3d_TextureUnit_14': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_14: 14>, None), 'Graphic3d_TextureUnit_15': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_15: 15>, None), 'Graphic3d_TextureUnit_BaseColor': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>, None), 'Graphic3d_TextureUnit_Emissive': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>, None), 'Graphic3d_TextureUnit_Occlusion': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_2: 2>, None), 'Graphic3d_TextureUnit_Normal': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_3: 3>, None), 'Graphic3d_TextureUnit_MetallicRoughness': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_4: 4>, None), 'Graphic3d_TextureUnit_EnvMap': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>, None), 'Graphic3d_TextureUnit_PointSprite': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>, None), 'Graphic3d_TextureUnit_DepthPeelingDepth': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_DepthPeelingDepth: -6>, None), 'Graphic3d_TextureUnit_DepthPeelingFrontColor': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_DepthPeelingFrontColor: -5>, None), 'Graphic3d_TextureUnit_ShadowMap': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_ShadowMap: -4>, None), 'Graphic3d_TextureUnit_PbrEnvironmentLUT': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrEnvironmentLUT: -3>, None), 'Graphic3d_TextureUnit_PbrIblDiffuseSH': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrIblDiffuseSH: -2>, None), 'Graphic3d_TextureUnit_PbrIblSpecular': (<Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrIblSpecular: -1>, None)}
    __members__: dict # value = {'Graphic3d_TextureUnit_0': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>, 'Graphic3d_TextureUnit_1': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>, 'Graphic3d_TextureUnit_2': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_2: 2>, 'Graphic3d_TextureUnit_3': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_3: 3>, 'Graphic3d_TextureUnit_4': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_4: 4>, 'Graphic3d_TextureUnit_5': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_5: 5>, 'Graphic3d_TextureUnit_6': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_6: 6>, 'Graphic3d_TextureUnit_7': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_7: 7>, 'Graphic3d_TextureUnit_8': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_8: 8>, 'Graphic3d_TextureUnit_9': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_9: 9>, 'Graphic3d_TextureUnit_10': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_10: 10>, 'Graphic3d_TextureUnit_11': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_11: 11>, 'Graphic3d_TextureUnit_12': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_12: 12>, 'Graphic3d_TextureUnit_13': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_13: 13>, 'Graphic3d_TextureUnit_14': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_14: 14>, 'Graphic3d_TextureUnit_15': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_15: 15>, 'Graphic3d_TextureUnit_BaseColor': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>, 'Graphic3d_TextureUnit_Emissive': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>, 'Graphic3d_TextureUnit_Occlusion': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_2: 2>, 'Graphic3d_TextureUnit_Normal': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_3: 3>, 'Graphic3d_TextureUnit_MetallicRoughness': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_4: 4>, 'Graphic3d_TextureUnit_EnvMap': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_0: 0>, 'Graphic3d_TextureUnit_PointSprite': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_1: 1>, 'Graphic3d_TextureUnit_DepthPeelingDepth': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_DepthPeelingDepth: -6>, 'Graphic3d_TextureUnit_DepthPeelingFrontColor': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_DepthPeelingFrontColor: -5>, 'Graphic3d_TextureUnit_ShadowMap': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_ShadowMap: -4>, 'Graphic3d_TextureUnit_PbrEnvironmentLUT': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrEnvironmentLUT: -3>, 'Graphic3d_TextureUnit_PbrIblDiffuseSH': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrIblDiffuseSH: -2>, 'Graphic3d_TextureUnit_PbrIblSpecular': <Graphic3d_TextureUnit.Graphic3d_TextureUnit_PbrIblSpecular: -1>}
    pass
class Graphic3d_ToneMappingMethod():
    """
    Enumerates tone mapping methods.

    Members:

      Graphic3d_ToneMappingMethod_Disabled

      Graphic3d_ToneMappingMethod_Filmic
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_ToneMappingMethod_Disabled: OCP.Graphic3d.Graphic3d_ToneMappingMethod # value = <Graphic3d_ToneMappingMethod.Graphic3d_ToneMappingMethod_Disabled: 0>
    Graphic3d_ToneMappingMethod_Filmic: OCP.Graphic3d.Graphic3d_ToneMappingMethod # value = <Graphic3d_ToneMappingMethod.Graphic3d_ToneMappingMethod_Filmic: 1>
    __entries: dict # value = {'Graphic3d_ToneMappingMethod_Disabled': (<Graphic3d_ToneMappingMethod.Graphic3d_ToneMappingMethod_Disabled: 0>, None), 'Graphic3d_ToneMappingMethod_Filmic': (<Graphic3d_ToneMappingMethod.Graphic3d_ToneMappingMethod_Filmic: 1>, None)}
    __members__: dict # value = {'Graphic3d_ToneMappingMethod_Disabled': <Graphic3d_ToneMappingMethod.Graphic3d_ToneMappingMethod_Disabled: 0>, 'Graphic3d_ToneMappingMethod_Filmic': <Graphic3d_ToneMappingMethod.Graphic3d_ToneMappingMethod_Filmic: 1>}
    pass
class Graphic3d_TransModeFlags():
    """
    Transform Persistence Mode defining whether to lock in object position, rotation and / or zooming relative to camera position.

    Members:

      Graphic3d_TMF_None

      Graphic3d_TMF_ZoomPers

      Graphic3d_TMF_RotatePers

      Graphic3d_TMF_TriedronPers

      Graphic3d_TMF_2d

      Graphic3d_TMF_CameraPers

      Graphic3d_TMF_OrthoPers

      Graphic3d_TMF_AxialScalePers

      Graphic3d_TMF_ZoomRotatePers

      Graphic3d_TMF_AxialZoomPers
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TMF_2d: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_2d: 64>
    Graphic3d_TMF_AxialScalePers: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_AxialScalePers: 512>
    Graphic3d_TMF_AxialZoomPers: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_AxialZoomPers: 514>
    Graphic3d_TMF_CameraPers: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_CameraPers: 128>
    Graphic3d_TMF_None: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_None: 0>
    Graphic3d_TMF_OrthoPers: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_OrthoPers: 256>
    Graphic3d_TMF_RotatePers: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_RotatePers: 8>
    Graphic3d_TMF_TriedronPers: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_TriedronPers: 32>
    Graphic3d_TMF_ZoomPers: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_ZoomPers: 2>
    Graphic3d_TMF_ZoomRotatePers: OCP.Graphic3d.Graphic3d_TransModeFlags # value = <Graphic3d_TransModeFlags.Graphic3d_TMF_ZoomRotatePers: 10>
    __entries: dict # value = {'Graphic3d_TMF_None': (<Graphic3d_TransModeFlags.Graphic3d_TMF_None: 0>, None), 'Graphic3d_TMF_ZoomPers': (<Graphic3d_TransModeFlags.Graphic3d_TMF_ZoomPers: 2>, None), 'Graphic3d_TMF_RotatePers': (<Graphic3d_TransModeFlags.Graphic3d_TMF_RotatePers: 8>, None), 'Graphic3d_TMF_TriedronPers': (<Graphic3d_TransModeFlags.Graphic3d_TMF_TriedronPers: 32>, None), 'Graphic3d_TMF_2d': (<Graphic3d_TransModeFlags.Graphic3d_TMF_2d: 64>, None), 'Graphic3d_TMF_CameraPers': (<Graphic3d_TransModeFlags.Graphic3d_TMF_CameraPers: 128>, None), 'Graphic3d_TMF_OrthoPers': (<Graphic3d_TransModeFlags.Graphic3d_TMF_OrthoPers: 256>, None), 'Graphic3d_TMF_AxialScalePers': (<Graphic3d_TransModeFlags.Graphic3d_TMF_AxialScalePers: 512>, None), 'Graphic3d_TMF_ZoomRotatePers': (<Graphic3d_TransModeFlags.Graphic3d_TMF_ZoomRotatePers: 10>, None), 'Graphic3d_TMF_AxialZoomPers': (<Graphic3d_TransModeFlags.Graphic3d_TMF_AxialZoomPers: 514>, None)}
    __members__: dict # value = {'Graphic3d_TMF_None': <Graphic3d_TransModeFlags.Graphic3d_TMF_None: 0>, 'Graphic3d_TMF_ZoomPers': <Graphic3d_TransModeFlags.Graphic3d_TMF_ZoomPers: 2>, 'Graphic3d_TMF_RotatePers': <Graphic3d_TransModeFlags.Graphic3d_TMF_RotatePers: 8>, 'Graphic3d_TMF_TriedronPers': <Graphic3d_TransModeFlags.Graphic3d_TMF_TriedronPers: 32>, 'Graphic3d_TMF_2d': <Graphic3d_TransModeFlags.Graphic3d_TMF_2d: 64>, 'Graphic3d_TMF_CameraPers': <Graphic3d_TransModeFlags.Graphic3d_TMF_CameraPers: 128>, 'Graphic3d_TMF_OrthoPers': <Graphic3d_TransModeFlags.Graphic3d_TMF_OrthoPers: 256>, 'Graphic3d_TMF_AxialScalePers': <Graphic3d_TransModeFlags.Graphic3d_TMF_AxialScalePers: 512>, 'Graphic3d_TMF_ZoomRotatePers': <Graphic3d_TransModeFlags.Graphic3d_TMF_ZoomRotatePers: 10>, 'Graphic3d_TMF_AxialZoomPers': <Graphic3d_TransModeFlags.Graphic3d_TMF_AxialZoomPers: 514>}
    pass
class Graphic3d_TransformPers(OCP.Standard.Standard_Transient):
    """
    Transformation Persistence definition.Transformation Persistence definition.
    """
    def AnchorPoint(self) -> OCP.gp.gp_Pnt: 
        """
        Return the anchor point for zoom/rotate transformation persistence.
        """
    def ComputeApply(self,theCamera : Graphic3d_Camera,theViewportWidth : int,theViewportHeight : int,theAnchor : OCP.gp.gp_Pnt=None) -> Graphic3d_Mat4d: 
        """
        Perform computations for applying transformation persistence on specified matrices.
        """
    def Corner2d(self) -> OCP.Aspect.Aspect_TypeOfTriedronPosition: 
        """
        Return the corner for 2d/trihedron transformation persistence.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Flags(self) -> Graphic3d_TransModeFlags: 
        """
        Transformation persistence mode flags.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsAxial(self) -> bool: 
        """
        Return true for Graphic3d_TMF_AxialScalePers modes.
        """
    @staticmethod
    def IsAxial_s(theMode : Graphic3d_TransModeFlags) -> bool: 
        """
        Return true if specified mode is axial transformation persistence.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsOrthoPers(self) -> bool: 
        """
        Return true for Graphic3d_TMF_OrthoPers mode.
        """
    @staticmethod
    def IsOrthoPers_s(theMode : Graphic3d_TransModeFlags) -> bool: 
        """
        Return true if specified mode is orthographic projection transformation persistence.
        """
    def IsTrihedronOr2d(self) -> bool: 
        """
        Return true for Graphic3d_TMF_TriedronPers and Graphic3d_TMF_2d modes.
        """
    @staticmethod
    def IsTrihedronOr2d_s(theMode : Graphic3d_TransModeFlags) -> bool: 
        """
        Return true if specified mode is 2d/trihedron transformation persistence.
        """
    def IsZoomOrRotate(self) -> bool: 
        """
        Return true for Graphic3d_TMF_ZoomPers, Graphic3d_TMF_ZoomRotatePers or Graphic3d_TMF_RotatePers modes.
        """
    @staticmethod
    def IsZoomOrRotate_s(theMode : Graphic3d_TransModeFlags) -> bool: 
        """
        Return true if specified mode is zoom/rotate transformation persistence.
        """
    def Mode(self) -> Graphic3d_TransModeFlags: 
        """
        Transformation persistence mode flags.
        """
    def Offset2d(self) -> Graphic3d_Vec2i: 
        """
        Return the offset from the corner for 2d/trihedron transformation persistence.
        """
    def SetAnchorPoint(self,thePnt : OCP.gp.gp_Pnt) -> None: 
        """
        Set the anchor point for zoom/rotate transformation persistence.
        """
    def SetCorner2d(self,thePos : OCP.Aspect.Aspect_TypeOfTriedronPosition) -> None: 
        """
        Set the corner for 2d/trihedron transformation persistence.
        """
    def SetOffset2d(self,theOffset : Graphic3d_Vec2i) -> None: 
        """
        Set the offset from the corner for 2d/trihedron transformation persistence.
        """
    @overload
    def SetPersistence(self,theMode : Graphic3d_TransModeFlags,thePnt : OCP.gp.gp_Pnt) -> None: 
        """
        Set Zoom/Rotate transformation persistence with an anchor 3D point. Throws an exception if persistence mode is not Graphic3d_TMF_ZoomPers, Graphic3d_TMF_ZoomRotatePers or Graphic3d_TMF_RotatePers.

        Set 2d/trihedron transformation persistence with a corner and 2D offset. Throws an exception if persistence mode is not Graphic3d_TMF_TriedronPers or Graphic3d_TMF_2d.
        """
    @overload
    def SetPersistence(self,theMode : Graphic3d_TransModeFlags,theCorner : OCP.Aspect.Aspect_TypeOfTriedronPosition,theOffset : Graphic3d_Vec2i) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def __init__(self,theMode : Graphic3d_TransModeFlags) -> None: ...
    @overload
    def __init__(self,theMode : Graphic3d_TransModeFlags,thePnt : OCP.gp.gp_Pnt) -> None: ...
    @overload
    def __init__(self,theMode : Graphic3d_TransModeFlags,theCorner : OCP.Aspect.Aspect_TypeOfTriedronPosition,theOffset : Graphic3d_Vec2i=Graphic3d_Vec2i) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    def persistentRotationMatrix(self,theCamera : Graphic3d_Camera,theViewportWidth : int,theViewportHeight : int) -> Any: 
        """
        Create orientation matrix based on camera and view dimensions. Default implementation locks rotation by nullifying rotation component. Camera and view dimensions are not used, by default.
        """
    def persistentScale(self,theCamera : Graphic3d_Camera,theViewportWidth : int,theViewportHeight : int) -> float: 
        """
        Find scale value based on the camera position and view dimensions
        """
    pass
class Graphic3d_TransformPersScaledAbove(Graphic3d_TransformPers, OCP.Standard.Standard_Transient):
    """
    Transformation Zoom persistence with the above boundary of scale. This persistence works only when the camera scale value is below the scale value of this persistence. Otherwise, no persistence is applied.Transformation Zoom persistence with the above boundary of scale. This persistence works only when the camera scale value is below the scale value of this persistence. Otherwise, no persistence is applied.
    """
    def AnchorPoint(self) -> OCP.gp.gp_Pnt: 
        """
        Return the anchor point for zoom/rotate transformation persistence.
        """
    def ComputeApply(self,theCamera : Graphic3d_Camera,theViewportWidth : int,theViewportHeight : int,theAnchor : OCP.gp.gp_Pnt=None) -> Graphic3d_Mat4d: 
        """
        Perform computations for applying transformation persistence on specified matrices.
        """
    def Corner2d(self) -> OCP.Aspect.Aspect_TypeOfTriedronPosition: 
        """
        Return the corner for 2d/trihedron transformation persistence.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Flags(self) -> Graphic3d_TransModeFlags: 
        """
        Transformation persistence mode flags.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsAxial(self) -> bool: 
        """
        Return true for Graphic3d_TMF_AxialScalePers modes.
        """
    @staticmethod
    def IsAxial_s(theMode : Graphic3d_TransModeFlags) -> bool: 
        """
        Return true if specified mode is axial transformation persistence.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsOrthoPers(self) -> bool: 
        """
        Return true for Graphic3d_TMF_OrthoPers mode.
        """
    @staticmethod
    def IsOrthoPers_s(theMode : Graphic3d_TransModeFlags) -> bool: 
        """
        Return true if specified mode is orthographic projection transformation persistence.
        """
    def IsTrihedronOr2d(self) -> bool: 
        """
        Return true for Graphic3d_TMF_TriedronPers and Graphic3d_TMF_2d modes.
        """
    @staticmethod
    def IsTrihedronOr2d_s(theMode : Graphic3d_TransModeFlags) -> bool: 
        """
        Return true if specified mode is 2d/trihedron transformation persistence.
        """
    def IsZoomOrRotate(self) -> bool: 
        """
        Return true for Graphic3d_TMF_ZoomPers, Graphic3d_TMF_ZoomRotatePers or Graphic3d_TMF_RotatePers modes.
        """
    @staticmethod
    def IsZoomOrRotate_s(theMode : Graphic3d_TransModeFlags) -> bool: 
        """
        Return true if specified mode is zoom/rotate transformation persistence.
        """
    def Mode(self) -> Graphic3d_TransModeFlags: 
        """
        Transformation persistence mode flags.
        """
    def Offset2d(self) -> Graphic3d_Vec2i: 
        """
        Return the offset from the corner for 2d/trihedron transformation persistence.
        """
    def SetAnchorPoint(self,thePnt : OCP.gp.gp_Pnt) -> None: 
        """
        Set the anchor point for zoom/rotate transformation persistence.
        """
    def SetCorner2d(self,thePos : OCP.Aspect.Aspect_TypeOfTriedronPosition) -> None: 
        """
        Set the corner for 2d/trihedron transformation persistence.
        """
    def SetOffset2d(self,theOffset : Graphic3d_Vec2i) -> None: 
        """
        Set the offset from the corner for 2d/trihedron transformation persistence.
        """
    @overload
    def SetPersistence(self,theMode : Graphic3d_TransModeFlags,thePnt : OCP.gp.gp_Pnt) -> None: 
        """
        Set Zoom/Rotate transformation persistence with an anchor 3D point. Throws an exception if persistence mode is not Graphic3d_TMF_ZoomPers, Graphic3d_TMF_ZoomRotatePers or Graphic3d_TMF_RotatePers.

        Set 2d/trihedron transformation persistence with a corner and 2D offset. Throws an exception if persistence mode is not Graphic3d_TMF_TriedronPers or Graphic3d_TMF_2d.
        """
    @overload
    def SetPersistence(self,theMode : Graphic3d_TransModeFlags,theCorner : OCP.Aspect.Aspect_TypeOfTriedronPosition,theOffset : Graphic3d_Vec2i) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self,theScale : float,thePnt : OCP.gp.gp_Pnt) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    def persistentRotationMatrix(self,theCamera : Graphic3d_Camera,theViewportWidth : int,theViewportHeight : int) -> Any: 
        """
        Create orientation matrix based on camera and view dimensions. Default implementation locks rotation by nullifying rotation component. Camera and view dimensions are not used, by default.
        """
    def persistentScale(self,theCamera : Graphic3d_Camera,theViewportWidth : int,theViewportHeight : int) -> float: 
        """
        Find scale value based on the camera position and view dimensions If the camera scale value less than the persistence scale, zoom persistence is not applied.
        """
    pass
class Graphic3d_TypeOfAnswer():
    """
    The answer of the method AcceptDisplay AcceptDisplay means is it possible to display the specified structure in the specified view ? TOA_YES yes TOA_NO no TOA_COMPUTE yes but we have to compute the representation

    Members:

      Graphic3d_TOA_YES

      Graphic3d_TOA_NO

      Graphic3d_TOA_COMPUTE
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOA_COMPUTE: OCP.Graphic3d.Graphic3d_TypeOfAnswer # value = <Graphic3d_TypeOfAnswer.Graphic3d_TOA_COMPUTE: 2>
    Graphic3d_TOA_NO: OCP.Graphic3d.Graphic3d_TypeOfAnswer # value = <Graphic3d_TypeOfAnswer.Graphic3d_TOA_NO: 1>
    Graphic3d_TOA_YES: OCP.Graphic3d.Graphic3d_TypeOfAnswer # value = <Graphic3d_TypeOfAnswer.Graphic3d_TOA_YES: 0>
    __entries: dict # value = {'Graphic3d_TOA_YES': (<Graphic3d_TypeOfAnswer.Graphic3d_TOA_YES: 0>, None), 'Graphic3d_TOA_NO': (<Graphic3d_TypeOfAnswer.Graphic3d_TOA_NO: 1>, None), 'Graphic3d_TOA_COMPUTE': (<Graphic3d_TypeOfAnswer.Graphic3d_TOA_COMPUTE: 2>, None)}
    __members__: dict # value = {'Graphic3d_TOA_YES': <Graphic3d_TypeOfAnswer.Graphic3d_TOA_YES: 0>, 'Graphic3d_TOA_NO': <Graphic3d_TypeOfAnswer.Graphic3d_TOA_NO: 1>, 'Graphic3d_TOA_COMPUTE': <Graphic3d_TypeOfAnswer.Graphic3d_TOA_COMPUTE: 2>}
    pass
class Graphic3d_TypeOfAttribute():
    """
    Type of attribute in Vertex Buffer

    Members:

      Graphic3d_TOA_POS

      Graphic3d_TOA_NORM

      Graphic3d_TOA_UV

      Graphic3d_TOA_COLOR

      Graphic3d_TOA_CUSTOM
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOA_COLOR: OCP.Graphic3d.Graphic3d_TypeOfAttribute # value = <Graphic3d_TypeOfAttribute.Graphic3d_TOA_COLOR: 3>
    Graphic3d_TOA_CUSTOM: OCP.Graphic3d.Graphic3d_TypeOfAttribute # value = <Graphic3d_TypeOfAttribute.Graphic3d_TOA_CUSTOM: 4>
    Graphic3d_TOA_NORM: OCP.Graphic3d.Graphic3d_TypeOfAttribute # value = <Graphic3d_TypeOfAttribute.Graphic3d_TOA_NORM: 1>
    Graphic3d_TOA_POS: OCP.Graphic3d.Graphic3d_TypeOfAttribute # value = <Graphic3d_TypeOfAttribute.Graphic3d_TOA_POS: 0>
    Graphic3d_TOA_UV: OCP.Graphic3d.Graphic3d_TypeOfAttribute # value = <Graphic3d_TypeOfAttribute.Graphic3d_TOA_UV: 2>
    __entries: dict # value = {'Graphic3d_TOA_POS': (<Graphic3d_TypeOfAttribute.Graphic3d_TOA_POS: 0>, None), 'Graphic3d_TOA_NORM': (<Graphic3d_TypeOfAttribute.Graphic3d_TOA_NORM: 1>, None), 'Graphic3d_TOA_UV': (<Graphic3d_TypeOfAttribute.Graphic3d_TOA_UV: 2>, None), 'Graphic3d_TOA_COLOR': (<Graphic3d_TypeOfAttribute.Graphic3d_TOA_COLOR: 3>, None), 'Graphic3d_TOA_CUSTOM': (<Graphic3d_TypeOfAttribute.Graphic3d_TOA_CUSTOM: 4>, None)}
    __members__: dict # value = {'Graphic3d_TOA_POS': <Graphic3d_TypeOfAttribute.Graphic3d_TOA_POS: 0>, 'Graphic3d_TOA_NORM': <Graphic3d_TypeOfAttribute.Graphic3d_TOA_NORM: 1>, 'Graphic3d_TOA_UV': <Graphic3d_TypeOfAttribute.Graphic3d_TOA_UV: 2>, 'Graphic3d_TOA_COLOR': <Graphic3d_TypeOfAttribute.Graphic3d_TOA_COLOR: 3>, 'Graphic3d_TOA_CUSTOM': <Graphic3d_TypeOfAttribute.Graphic3d_TOA_CUSTOM: 4>}
    pass
class Graphic3d_TypeOfBackfacingModel():
    """
    Modes of display of back faces in the view.

    Members:

      Graphic3d_TypeOfBackfacingModel_Auto

      Graphic3d_TypeOfBackfacingModel_DoubleSided

      Graphic3d_TypeOfBackfacingModel_BackCulled

      Graphic3d_TypeOfBackfacingModel_FrontCulled

      Graphic3d_TOBM_AUTOMATIC

      Graphic3d_TOBM_FORCE

      Graphic3d_TOBM_DISABLE

      V3d_TOBM_AUTOMATIC

      V3d_TOBM_ALWAYS_DISPLAYED

      V3d_TOBM_NEVER_DISPLAYED
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOBM_AUTOMATIC: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>
    Graphic3d_TOBM_DISABLE: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>
    Graphic3d_TOBM_FORCE: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>
    Graphic3d_TypeOfBackfacingModel_Auto: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>
    Graphic3d_TypeOfBackfacingModel_BackCulled: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>
    Graphic3d_TypeOfBackfacingModel_DoubleSided: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>
    Graphic3d_TypeOfBackfacingModel_FrontCulled: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_FrontCulled: 3>
    V3d_TOBM_ALWAYS_DISPLAYED: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>
    V3d_TOBM_AUTOMATIC: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>
    V3d_TOBM_NEVER_DISPLAYED: OCP.Graphic3d.Graphic3d_TypeOfBackfacingModel # value = <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>
    __entries: dict # value = {'Graphic3d_TypeOfBackfacingModel_Auto': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>, None), 'Graphic3d_TypeOfBackfacingModel_DoubleSided': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>, None), 'Graphic3d_TypeOfBackfacingModel_BackCulled': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>, None), 'Graphic3d_TypeOfBackfacingModel_FrontCulled': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_FrontCulled: 3>, None), 'Graphic3d_TOBM_AUTOMATIC': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>, None), 'Graphic3d_TOBM_FORCE': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>, None), 'Graphic3d_TOBM_DISABLE': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>, None), 'V3d_TOBM_AUTOMATIC': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>, None), 'V3d_TOBM_ALWAYS_DISPLAYED': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>, None), 'V3d_TOBM_NEVER_DISPLAYED': (<Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>, None)}
    __members__: dict # value = {'Graphic3d_TypeOfBackfacingModel_Auto': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>, 'Graphic3d_TypeOfBackfacingModel_DoubleSided': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>, 'Graphic3d_TypeOfBackfacingModel_BackCulled': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>, 'Graphic3d_TypeOfBackfacingModel_FrontCulled': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_FrontCulled: 3>, 'Graphic3d_TOBM_AUTOMATIC': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>, 'Graphic3d_TOBM_FORCE': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>, 'Graphic3d_TOBM_DISABLE': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>, 'V3d_TOBM_AUTOMATIC': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_Auto: 0>, 'V3d_TOBM_ALWAYS_DISPLAYED': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_DoubleSided: 1>, 'V3d_TOBM_NEVER_DISPLAYED': <Graphic3d_TypeOfBackfacingModel.Graphic3d_TypeOfBackfacingModel_BackCulled: 2>}
    pass
class Graphic3d_TypeOfBackground():
    """
    Describes type of view background.

    Members:

      Graphic3d_TOB_NONE

      Graphic3d_TOB_GRADIENT

      Graphic3d_TOB_TEXTURE

      Graphic3d_TOB_CUBEMAP
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOB_CUBEMAP: OCP.Graphic3d.Graphic3d_TypeOfBackground # value = <Graphic3d_TypeOfBackground.Graphic3d_TOB_CUBEMAP: 2>
    Graphic3d_TOB_GRADIENT: OCP.Graphic3d.Graphic3d_TypeOfBackground # value = <Graphic3d_TypeOfBackground.Graphic3d_TOB_GRADIENT: 0>
    Graphic3d_TOB_NONE: OCP.Graphic3d.Graphic3d_TypeOfBackground # value = <Graphic3d_TypeOfBackground.Graphic3d_TOB_NONE: -1>
    Graphic3d_TOB_TEXTURE: OCP.Graphic3d.Graphic3d_TypeOfBackground # value = <Graphic3d_TypeOfBackground.Graphic3d_TOB_TEXTURE: 1>
    __entries: dict # value = {'Graphic3d_TOB_NONE': (<Graphic3d_TypeOfBackground.Graphic3d_TOB_NONE: -1>, None), 'Graphic3d_TOB_GRADIENT': (<Graphic3d_TypeOfBackground.Graphic3d_TOB_GRADIENT: 0>, None), 'Graphic3d_TOB_TEXTURE': (<Graphic3d_TypeOfBackground.Graphic3d_TOB_TEXTURE: 1>, None), 'Graphic3d_TOB_CUBEMAP': (<Graphic3d_TypeOfBackground.Graphic3d_TOB_CUBEMAP: 2>, None)}
    __members__: dict # value = {'Graphic3d_TOB_NONE': <Graphic3d_TypeOfBackground.Graphic3d_TOB_NONE: -1>, 'Graphic3d_TOB_GRADIENT': <Graphic3d_TypeOfBackground.Graphic3d_TOB_GRADIENT: 0>, 'Graphic3d_TOB_TEXTURE': <Graphic3d_TypeOfBackground.Graphic3d_TOB_TEXTURE: 1>, 'Graphic3d_TOB_CUBEMAP': <Graphic3d_TypeOfBackground.Graphic3d_TOB_CUBEMAP: 2>}
    pass
class Graphic3d_TypeOfConnection():
    """
    To manage the connections between the structures.

    Members:

      Graphic3d_TOC_ANCESTOR

      Graphic3d_TOC_DESCENDANT
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOC_ANCESTOR: OCP.Graphic3d.Graphic3d_TypeOfConnection # value = <Graphic3d_TypeOfConnection.Graphic3d_TOC_ANCESTOR: 0>
    Graphic3d_TOC_DESCENDANT: OCP.Graphic3d.Graphic3d_TypeOfConnection # value = <Graphic3d_TypeOfConnection.Graphic3d_TOC_DESCENDANT: 1>
    __entries: dict # value = {'Graphic3d_TOC_ANCESTOR': (<Graphic3d_TypeOfConnection.Graphic3d_TOC_ANCESTOR: 0>, None), 'Graphic3d_TOC_DESCENDANT': (<Graphic3d_TypeOfConnection.Graphic3d_TOC_DESCENDANT: 1>, None)}
    __members__: dict # value = {'Graphic3d_TOC_ANCESTOR': <Graphic3d_TypeOfConnection.Graphic3d_TOC_ANCESTOR: 0>, 'Graphic3d_TOC_DESCENDANT': <Graphic3d_TypeOfConnection.Graphic3d_TOC_DESCENDANT: 1>}
    pass
class Graphic3d_TypeOfData():
    """
    Type of the element in Vertex or Index Buffer

    Members:

      Graphic3d_TOD_USHORT

      Graphic3d_TOD_UINT

      Graphic3d_TOD_VEC2

      Graphic3d_TOD_VEC3

      Graphic3d_TOD_VEC4

      Graphic3d_TOD_VEC4UB

      Graphic3d_TOD_FLOAT
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOD_FLOAT: OCP.Graphic3d.Graphic3d_TypeOfData # value = <Graphic3d_TypeOfData.Graphic3d_TOD_FLOAT: 6>
    Graphic3d_TOD_UINT: OCP.Graphic3d.Graphic3d_TypeOfData # value = <Graphic3d_TypeOfData.Graphic3d_TOD_UINT: 1>
    Graphic3d_TOD_USHORT: OCP.Graphic3d.Graphic3d_TypeOfData # value = <Graphic3d_TypeOfData.Graphic3d_TOD_USHORT: 0>
    Graphic3d_TOD_VEC2: OCP.Graphic3d.Graphic3d_TypeOfData # value = <Graphic3d_TypeOfData.Graphic3d_TOD_VEC2: 2>
    Graphic3d_TOD_VEC3: OCP.Graphic3d.Graphic3d_TypeOfData # value = <Graphic3d_TypeOfData.Graphic3d_TOD_VEC3: 3>
    Graphic3d_TOD_VEC4: OCP.Graphic3d.Graphic3d_TypeOfData # value = <Graphic3d_TypeOfData.Graphic3d_TOD_VEC4: 4>
    Graphic3d_TOD_VEC4UB: OCP.Graphic3d.Graphic3d_TypeOfData # value = <Graphic3d_TypeOfData.Graphic3d_TOD_VEC4UB: 5>
    __entries: dict # value = {'Graphic3d_TOD_USHORT': (<Graphic3d_TypeOfData.Graphic3d_TOD_USHORT: 0>, None), 'Graphic3d_TOD_UINT': (<Graphic3d_TypeOfData.Graphic3d_TOD_UINT: 1>, None), 'Graphic3d_TOD_VEC2': (<Graphic3d_TypeOfData.Graphic3d_TOD_VEC2: 2>, None), 'Graphic3d_TOD_VEC3': (<Graphic3d_TypeOfData.Graphic3d_TOD_VEC3: 3>, None), 'Graphic3d_TOD_VEC4': (<Graphic3d_TypeOfData.Graphic3d_TOD_VEC4: 4>, None), 'Graphic3d_TOD_VEC4UB': (<Graphic3d_TypeOfData.Graphic3d_TOD_VEC4UB: 5>, None), 'Graphic3d_TOD_FLOAT': (<Graphic3d_TypeOfData.Graphic3d_TOD_FLOAT: 6>, None)}
    __members__: dict # value = {'Graphic3d_TOD_USHORT': <Graphic3d_TypeOfData.Graphic3d_TOD_USHORT: 0>, 'Graphic3d_TOD_UINT': <Graphic3d_TypeOfData.Graphic3d_TOD_UINT: 1>, 'Graphic3d_TOD_VEC2': <Graphic3d_TypeOfData.Graphic3d_TOD_VEC2: 2>, 'Graphic3d_TOD_VEC3': <Graphic3d_TypeOfData.Graphic3d_TOD_VEC3: 3>, 'Graphic3d_TOD_VEC4': <Graphic3d_TypeOfData.Graphic3d_TOD_VEC4: 4>, 'Graphic3d_TOD_VEC4UB': <Graphic3d_TypeOfData.Graphic3d_TOD_VEC4UB: 5>, 'Graphic3d_TOD_FLOAT': <Graphic3d_TypeOfData.Graphic3d_TOD_FLOAT: 6>}
    pass
class Graphic3d_TypeOfLightSource():
    """
    Definition of all the type of light source.

    Members:

      Graphic3d_TypeOfLightSource_Ambient

      Graphic3d_TypeOfLightSource_Directional

      Graphic3d_TypeOfLightSource_Positional

      Graphic3d_TypeOfLightSource_Spot

      Graphic3d_TOLS_AMBIENT

      Graphic3d_TOLS_DIRECTIONAL

      Graphic3d_TOLS_POSITIONAL

      Graphic3d_TOLS_SPOT

      V3d_AMBIENT

      V3d_DIRECTIONAL

      V3d_POSITIONAL

      V3d_SPOT
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOLS_AMBIENT: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>
    Graphic3d_TOLS_DIRECTIONAL: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>
    Graphic3d_TOLS_POSITIONAL: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>
    Graphic3d_TOLS_SPOT: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>
    Graphic3d_TypeOfLightSource_Ambient: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>
    Graphic3d_TypeOfLightSource_Directional: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>
    Graphic3d_TypeOfLightSource_Positional: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>
    Graphic3d_TypeOfLightSource_Spot: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>
    V3d_AMBIENT: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>
    V3d_DIRECTIONAL: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>
    V3d_POSITIONAL: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>
    V3d_SPOT: OCP.Graphic3d.Graphic3d_TypeOfLightSource # value = <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>
    __entries: dict # value = {'Graphic3d_TypeOfLightSource_Ambient': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>, None), 'Graphic3d_TypeOfLightSource_Directional': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>, None), 'Graphic3d_TypeOfLightSource_Positional': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>, None), 'Graphic3d_TypeOfLightSource_Spot': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>, None), 'Graphic3d_TOLS_AMBIENT': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>, None), 'Graphic3d_TOLS_DIRECTIONAL': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>, None), 'Graphic3d_TOLS_POSITIONAL': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>, None), 'Graphic3d_TOLS_SPOT': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>, None), 'V3d_AMBIENT': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>, None), 'V3d_DIRECTIONAL': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>, None), 'V3d_POSITIONAL': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>, None), 'V3d_SPOT': (<Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>, None)}
    __members__: dict # value = {'Graphic3d_TypeOfLightSource_Ambient': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>, 'Graphic3d_TypeOfLightSource_Directional': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>, 'Graphic3d_TypeOfLightSource_Positional': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>, 'Graphic3d_TypeOfLightSource_Spot': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>, 'Graphic3d_TOLS_AMBIENT': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>, 'Graphic3d_TOLS_DIRECTIONAL': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>, 'Graphic3d_TOLS_POSITIONAL': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>, 'Graphic3d_TOLS_SPOT': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>, 'V3d_AMBIENT': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Ambient: 0>, 'V3d_DIRECTIONAL': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Directional: 1>, 'V3d_POSITIONAL': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Positional: 2>, 'V3d_SPOT': <Graphic3d_TypeOfLightSource.Graphic3d_TypeOfLightSource_Spot: 3>}
    pass
class Graphic3d_TypeOfLimit():
    """
    Type of graphic resource limit.

    Members:

      Graphic3d_TypeOfLimit_MaxNbLights

      Graphic3d_TypeOfLimit_MaxNbClipPlanes

      Graphic3d_TypeOfLimit_MaxNbViews

      Graphic3d_TypeOfLimit_MaxTextureSize

      Graphic3d_TypeOfLimit_MaxViewDumpSizeX

      Graphic3d_TypeOfLimit_MaxViewDumpSizeY

      Graphic3d_TypeOfLimit_MaxCombinedTextureUnits

      Graphic3d_TypeOfLimit_MaxMsaa

      Graphic3d_TypeOfLimit_HasPBR

      Graphic3d_TypeOfLimit_HasRayTracing

      Graphic3d_TypeOfLimit_HasRayTracingTextures

      Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling

      Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic

      Graphic3d_TypeOfLimit_HasSRGB

      Graphic3d_TypeOfLimit_HasBlendedOit

      Graphic3d_TypeOfLimit_HasBlendedOitMsaa

      Graphic3d_TypeOfLimit_HasFlatShading

      Graphic3d_TypeOfLimit_HasMeshEdges

      Graphic3d_TypeOfLimit_IsWorkaroundFBO

      Graphic3d_TypeOfLimit_NB
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TypeOfLimit_HasBlendedOit: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasBlendedOit: 14>
    Graphic3d_TypeOfLimit_HasBlendedOitMsaa: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasBlendedOitMsaa: 15>
    Graphic3d_TypeOfLimit_HasFlatShading: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasFlatShading: 16>
    Graphic3d_TypeOfLimit_HasMeshEdges: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasMeshEdges: 17>
    Graphic3d_TypeOfLimit_HasPBR: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasPBR: 8>
    Graphic3d_TypeOfLimit_HasRayTracing: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracing: 9>
    Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling: 11>
    Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic: 12>
    Graphic3d_TypeOfLimit_HasRayTracingTextures: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingTextures: 10>
    Graphic3d_TypeOfLimit_HasSRGB: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasSRGB: 13>
    Graphic3d_TypeOfLimit_IsWorkaroundFBO: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_IsWorkaroundFBO: 18>
    Graphic3d_TypeOfLimit_MaxCombinedTextureUnits: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxCombinedTextureUnits: 6>
    Graphic3d_TypeOfLimit_MaxMsaa: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxMsaa: 7>
    Graphic3d_TypeOfLimit_MaxNbClipPlanes: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbClipPlanes: 1>
    Graphic3d_TypeOfLimit_MaxNbLights: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbLights: 0>
    Graphic3d_TypeOfLimit_MaxNbViews: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbViews: 2>
    Graphic3d_TypeOfLimit_MaxTextureSize: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxTextureSize: 3>
    Graphic3d_TypeOfLimit_MaxViewDumpSizeX: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxViewDumpSizeX: 4>
    Graphic3d_TypeOfLimit_MaxViewDumpSizeY: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxViewDumpSizeY: 5>
    Graphic3d_TypeOfLimit_NB: OCP.Graphic3d.Graphic3d_TypeOfLimit # value = <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_NB: 19>
    __entries: dict # value = {'Graphic3d_TypeOfLimit_MaxNbLights': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbLights: 0>, None), 'Graphic3d_TypeOfLimit_MaxNbClipPlanes': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbClipPlanes: 1>, None), 'Graphic3d_TypeOfLimit_MaxNbViews': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbViews: 2>, None), 'Graphic3d_TypeOfLimit_MaxTextureSize': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxTextureSize: 3>, None), 'Graphic3d_TypeOfLimit_MaxViewDumpSizeX': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxViewDumpSizeX: 4>, None), 'Graphic3d_TypeOfLimit_MaxViewDumpSizeY': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxViewDumpSizeY: 5>, None), 'Graphic3d_TypeOfLimit_MaxCombinedTextureUnits': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxCombinedTextureUnits: 6>, None), 'Graphic3d_TypeOfLimit_MaxMsaa': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxMsaa: 7>, None), 'Graphic3d_TypeOfLimit_HasPBR': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasPBR: 8>, None), 'Graphic3d_TypeOfLimit_HasRayTracing': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracing: 9>, None), 'Graphic3d_TypeOfLimit_HasRayTracingTextures': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingTextures: 10>, None), 'Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling: 11>, None), 'Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic: 12>, None), 'Graphic3d_TypeOfLimit_HasSRGB': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasSRGB: 13>, None), 'Graphic3d_TypeOfLimit_HasBlendedOit': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasBlendedOit: 14>, None), 'Graphic3d_TypeOfLimit_HasBlendedOitMsaa': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasBlendedOitMsaa: 15>, None), 'Graphic3d_TypeOfLimit_HasFlatShading': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasFlatShading: 16>, None), 'Graphic3d_TypeOfLimit_HasMeshEdges': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasMeshEdges: 17>, None), 'Graphic3d_TypeOfLimit_IsWorkaroundFBO': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_IsWorkaroundFBO: 18>, None), 'Graphic3d_TypeOfLimit_NB': (<Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_NB: 19>, None)}
    __members__: dict # value = {'Graphic3d_TypeOfLimit_MaxNbLights': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbLights: 0>, 'Graphic3d_TypeOfLimit_MaxNbClipPlanes': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbClipPlanes: 1>, 'Graphic3d_TypeOfLimit_MaxNbViews': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxNbViews: 2>, 'Graphic3d_TypeOfLimit_MaxTextureSize': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxTextureSize: 3>, 'Graphic3d_TypeOfLimit_MaxViewDumpSizeX': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxViewDumpSizeX: 4>, 'Graphic3d_TypeOfLimit_MaxViewDumpSizeY': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxViewDumpSizeY: 5>, 'Graphic3d_TypeOfLimit_MaxCombinedTextureUnits': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxCombinedTextureUnits: 6>, 'Graphic3d_TypeOfLimit_MaxMsaa': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_MaxMsaa: 7>, 'Graphic3d_TypeOfLimit_HasPBR': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasPBR: 8>, 'Graphic3d_TypeOfLimit_HasRayTracing': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracing: 9>, 'Graphic3d_TypeOfLimit_HasRayTracingTextures': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingTextures: 10>, 'Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSampling: 11>, 'Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasRayTracingAdaptiveSamplingAtomic: 12>, 'Graphic3d_TypeOfLimit_HasSRGB': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasSRGB: 13>, 'Graphic3d_TypeOfLimit_HasBlendedOit': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasBlendedOit: 14>, 'Graphic3d_TypeOfLimit_HasBlendedOitMsaa': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasBlendedOitMsaa: 15>, 'Graphic3d_TypeOfLimit_HasFlatShading': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasFlatShading: 16>, 'Graphic3d_TypeOfLimit_HasMeshEdges': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_HasMeshEdges: 17>, 'Graphic3d_TypeOfLimit_IsWorkaroundFBO': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_IsWorkaroundFBO: 18>, 'Graphic3d_TypeOfLimit_NB': <Graphic3d_TypeOfLimit.Graphic3d_TypeOfLimit_NB: 19>}
    pass
class Graphic3d_TypeOfMaterial():
    """
    Types of materials specifies if a material can change color.

    Members:

      Graphic3d_MATERIAL_ASPECT

      Graphic3d_MATERIAL_PHYSIC
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_MATERIAL_ASPECT: OCP.Graphic3d.Graphic3d_TypeOfMaterial # value = <Graphic3d_TypeOfMaterial.Graphic3d_MATERIAL_ASPECT: 0>
    Graphic3d_MATERIAL_PHYSIC: OCP.Graphic3d.Graphic3d_TypeOfMaterial # value = <Graphic3d_TypeOfMaterial.Graphic3d_MATERIAL_PHYSIC: 1>
    __entries: dict # value = {'Graphic3d_MATERIAL_ASPECT': (<Graphic3d_TypeOfMaterial.Graphic3d_MATERIAL_ASPECT: 0>, None), 'Graphic3d_MATERIAL_PHYSIC': (<Graphic3d_TypeOfMaterial.Graphic3d_MATERIAL_PHYSIC: 1>, None)}
    __members__: dict # value = {'Graphic3d_MATERIAL_ASPECT': <Graphic3d_TypeOfMaterial.Graphic3d_MATERIAL_ASPECT: 0>, 'Graphic3d_MATERIAL_PHYSIC': <Graphic3d_TypeOfMaterial.Graphic3d_MATERIAL_PHYSIC: 1>}
    pass
class Graphic3d_TypeOfPrimitiveArray():
    """
    The type of primitive array in a group in a structure.

    Members:

      Graphic3d_TOPA_UNDEFINED

      Graphic3d_TOPA_POINTS

      Graphic3d_TOPA_SEGMENTS

      Graphic3d_TOPA_POLYLINES

      Graphic3d_TOPA_TRIANGLES

      Graphic3d_TOPA_TRIANGLESTRIPS

      Graphic3d_TOPA_TRIANGLEFANS

      Graphic3d_TOPA_LINES_ADJACENCY

      Graphic3d_TOPA_LINE_STRIP_ADJACENCY

      Graphic3d_TOPA_TRIANGLES_ADJACENCY

      Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY

      Graphic3d_TOPA_QUADRANGLES

      Graphic3d_TOPA_QUADRANGLESTRIPS

      Graphic3d_TOPA_POLYGONS
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOPA_LINES_ADJACENCY: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_LINES_ADJACENCY: 7>
    Graphic3d_TOPA_LINE_STRIP_ADJACENCY: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_LINE_STRIP_ADJACENCY: 8>
    Graphic3d_TOPA_POINTS: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POINTS: 1>
    Graphic3d_TOPA_POLYGONS: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POLYGONS: 13>
    Graphic3d_TOPA_POLYLINES: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POLYLINES: 3>
    Graphic3d_TOPA_QUADRANGLES: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_QUADRANGLES: 11>
    Graphic3d_TOPA_QUADRANGLESTRIPS: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_QUADRANGLESTRIPS: 12>
    Graphic3d_TOPA_SEGMENTS: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_SEGMENTS: 2>
    Graphic3d_TOPA_TRIANGLEFANS: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLEFANS: 6>
    Graphic3d_TOPA_TRIANGLES: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLES: 4>
    Graphic3d_TOPA_TRIANGLESTRIPS: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLESTRIPS: 5>
    Graphic3d_TOPA_TRIANGLES_ADJACENCY: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLES_ADJACENCY: 9>
    Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY: 10>
    Graphic3d_TOPA_UNDEFINED: OCP.Graphic3d.Graphic3d_TypeOfPrimitiveArray # value = <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_UNDEFINED: 0>
    __entries: dict # value = {'Graphic3d_TOPA_UNDEFINED': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_UNDEFINED: 0>, None), 'Graphic3d_TOPA_POINTS': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POINTS: 1>, None), 'Graphic3d_TOPA_SEGMENTS': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_SEGMENTS: 2>, None), 'Graphic3d_TOPA_POLYLINES': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POLYLINES: 3>, None), 'Graphic3d_TOPA_TRIANGLES': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLES: 4>, None), 'Graphic3d_TOPA_TRIANGLESTRIPS': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLESTRIPS: 5>, None), 'Graphic3d_TOPA_TRIANGLEFANS': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLEFANS: 6>, None), 'Graphic3d_TOPA_LINES_ADJACENCY': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_LINES_ADJACENCY: 7>, None), 'Graphic3d_TOPA_LINE_STRIP_ADJACENCY': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_LINE_STRIP_ADJACENCY: 8>, None), 'Graphic3d_TOPA_TRIANGLES_ADJACENCY': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLES_ADJACENCY: 9>, None), 'Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY: 10>, None), 'Graphic3d_TOPA_QUADRANGLES': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_QUADRANGLES: 11>, None), 'Graphic3d_TOPA_QUADRANGLESTRIPS': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_QUADRANGLESTRIPS: 12>, None), 'Graphic3d_TOPA_POLYGONS': (<Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POLYGONS: 13>, None)}
    __members__: dict # value = {'Graphic3d_TOPA_UNDEFINED': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_UNDEFINED: 0>, 'Graphic3d_TOPA_POINTS': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POINTS: 1>, 'Graphic3d_TOPA_SEGMENTS': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_SEGMENTS: 2>, 'Graphic3d_TOPA_POLYLINES': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POLYLINES: 3>, 'Graphic3d_TOPA_TRIANGLES': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLES: 4>, 'Graphic3d_TOPA_TRIANGLESTRIPS': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLESTRIPS: 5>, 'Graphic3d_TOPA_TRIANGLEFANS': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLEFANS: 6>, 'Graphic3d_TOPA_LINES_ADJACENCY': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_LINES_ADJACENCY: 7>, 'Graphic3d_TOPA_LINE_STRIP_ADJACENCY': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_LINE_STRIP_ADJACENCY: 8>, 'Graphic3d_TOPA_TRIANGLES_ADJACENCY': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLES_ADJACENCY: 9>, 'Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_TRIANGLE_STRIP_ADJACENCY: 10>, 'Graphic3d_TOPA_QUADRANGLES': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_QUADRANGLES: 11>, 'Graphic3d_TOPA_QUADRANGLESTRIPS': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_QUADRANGLESTRIPS: 12>, 'Graphic3d_TOPA_POLYGONS': <Graphic3d_TypeOfPrimitiveArray.Graphic3d_TOPA_POLYGONS: 13>}
    pass
class Graphic3d_TypeOfReflection():
    """
    Nature of the reflection of a material.

    Members:

      Graphic3d_TOR_AMBIENT

      Graphic3d_TOR_DIFFUSE

      Graphic3d_TOR_SPECULAR

      Graphic3d_TOR_EMISSION
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOR_AMBIENT: OCP.Graphic3d.Graphic3d_TypeOfReflection # value = <Graphic3d_TypeOfReflection.Graphic3d_TOR_AMBIENT: 0>
    Graphic3d_TOR_DIFFUSE: OCP.Graphic3d.Graphic3d_TypeOfReflection # value = <Graphic3d_TypeOfReflection.Graphic3d_TOR_DIFFUSE: 1>
    Graphic3d_TOR_EMISSION: OCP.Graphic3d.Graphic3d_TypeOfReflection # value = <Graphic3d_TypeOfReflection.Graphic3d_TOR_EMISSION: 3>
    Graphic3d_TOR_SPECULAR: OCP.Graphic3d.Graphic3d_TypeOfReflection # value = <Graphic3d_TypeOfReflection.Graphic3d_TOR_SPECULAR: 2>
    __entries: dict # value = {'Graphic3d_TOR_AMBIENT': (<Graphic3d_TypeOfReflection.Graphic3d_TOR_AMBIENT: 0>, None), 'Graphic3d_TOR_DIFFUSE': (<Graphic3d_TypeOfReflection.Graphic3d_TOR_DIFFUSE: 1>, None), 'Graphic3d_TOR_SPECULAR': (<Graphic3d_TypeOfReflection.Graphic3d_TOR_SPECULAR: 2>, None), 'Graphic3d_TOR_EMISSION': (<Graphic3d_TypeOfReflection.Graphic3d_TOR_EMISSION: 3>, None)}
    __members__: dict # value = {'Graphic3d_TOR_AMBIENT': <Graphic3d_TypeOfReflection.Graphic3d_TOR_AMBIENT: 0>, 'Graphic3d_TOR_DIFFUSE': <Graphic3d_TypeOfReflection.Graphic3d_TOR_DIFFUSE: 1>, 'Graphic3d_TOR_SPECULAR': <Graphic3d_TypeOfReflection.Graphic3d_TOR_SPECULAR: 2>, 'Graphic3d_TOR_EMISSION': <Graphic3d_TypeOfReflection.Graphic3d_TOR_EMISSION: 3>}
    pass
class Graphic3d_TypeOfShaderObject():
    """
    Type of the shader object.

    Members:

      Graphic3d_TOS_VERTEX

      Graphic3d_TOS_TESS_CONTROL

      Graphic3d_TOS_TESS_EVALUATION

      Graphic3d_TOS_GEOMETRY

      Graphic3d_TOS_FRAGMENT

      Graphic3d_TOS_COMPUTE
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOS_COMPUTE: OCP.Graphic3d.Graphic3d_TypeOfShaderObject # value = <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_COMPUTE: 32>
    Graphic3d_TOS_FRAGMENT: OCP.Graphic3d.Graphic3d_TypeOfShaderObject # value = <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_FRAGMENT: 16>
    Graphic3d_TOS_GEOMETRY: OCP.Graphic3d.Graphic3d_TypeOfShaderObject # value = <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_GEOMETRY: 8>
    Graphic3d_TOS_TESS_CONTROL: OCP.Graphic3d.Graphic3d_TypeOfShaderObject # value = <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_TESS_CONTROL: 2>
    Graphic3d_TOS_TESS_EVALUATION: OCP.Graphic3d.Graphic3d_TypeOfShaderObject # value = <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_TESS_EVALUATION: 4>
    Graphic3d_TOS_VERTEX: OCP.Graphic3d.Graphic3d_TypeOfShaderObject # value = <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_VERTEX: 1>
    __entries: dict # value = {'Graphic3d_TOS_VERTEX': (<Graphic3d_TypeOfShaderObject.Graphic3d_TOS_VERTEX: 1>, None), 'Graphic3d_TOS_TESS_CONTROL': (<Graphic3d_TypeOfShaderObject.Graphic3d_TOS_TESS_CONTROL: 2>, None), 'Graphic3d_TOS_TESS_EVALUATION': (<Graphic3d_TypeOfShaderObject.Graphic3d_TOS_TESS_EVALUATION: 4>, None), 'Graphic3d_TOS_GEOMETRY': (<Graphic3d_TypeOfShaderObject.Graphic3d_TOS_GEOMETRY: 8>, None), 'Graphic3d_TOS_FRAGMENT': (<Graphic3d_TypeOfShaderObject.Graphic3d_TOS_FRAGMENT: 16>, None), 'Graphic3d_TOS_COMPUTE': (<Graphic3d_TypeOfShaderObject.Graphic3d_TOS_COMPUTE: 32>, None)}
    __members__: dict # value = {'Graphic3d_TOS_VERTEX': <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_VERTEX: 1>, 'Graphic3d_TOS_TESS_CONTROL': <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_TESS_CONTROL: 2>, 'Graphic3d_TOS_TESS_EVALUATION': <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_TESS_EVALUATION: 4>, 'Graphic3d_TOS_GEOMETRY': <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_GEOMETRY: 8>, 'Graphic3d_TOS_FRAGMENT': <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_FRAGMENT: 16>, 'Graphic3d_TOS_COMPUTE': <Graphic3d_TypeOfShaderObject.Graphic3d_TOS_COMPUTE: 32>}
    pass
class Graphic3d_TypeOfShadingModel():
    """
    Definition of the color shading model.

    Members:

      Graphic3d_TypeOfShadingModel_DEFAULT

      Graphic3d_TypeOfShadingModel_Unlit

      Graphic3d_TypeOfShadingModel_PhongFacet

      Graphic3d_TypeOfShadingModel_Gouraud

      Graphic3d_TypeOfShadingModel_Phong

      Graphic3d_TypeOfShadingModel_Pbr

      Graphic3d_TypeOfShadingModel_PbrFacet

      Graphic3d_TOSM_DEFAULT

      Graphic3d_TOSM_UNLIT

      Graphic3d_TOSM_FACET

      Graphic3d_TOSM_VERTEX

      Graphic3d_TOSM_FRAGMENT

      Graphic3d_TOSM_PBR

      Graphic3d_TOSM_PBR_FACET

      Graphic3d_TOSM_NONE

      V3d_COLOR

      V3d_FLAT

      V3d_GOURAUD

      V3d_PHONG
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOSM_DEFAULT: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_DEFAULT: -1>
    Graphic3d_TOSM_FACET: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>
    Graphic3d_TOSM_FRAGMENT: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>
    Graphic3d_TOSM_NONE: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>
    Graphic3d_TOSM_PBR: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Pbr: 4>
    Graphic3d_TOSM_PBR_FACET: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PbrFacet: 5>
    Graphic3d_TOSM_UNLIT: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>
    Graphic3d_TOSM_VERTEX: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>
    Graphic3d_TypeOfShadingModel_DEFAULT: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_DEFAULT: -1>
    Graphic3d_TypeOfShadingModel_Gouraud: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>
    Graphic3d_TypeOfShadingModel_Pbr: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Pbr: 4>
    Graphic3d_TypeOfShadingModel_PbrFacet: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PbrFacet: 5>
    Graphic3d_TypeOfShadingModel_Phong: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>
    Graphic3d_TypeOfShadingModel_PhongFacet: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>
    Graphic3d_TypeOfShadingModel_Unlit: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>
    V3d_COLOR: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>
    V3d_FLAT: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>
    V3d_GOURAUD: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>
    V3d_PHONG: OCP.Graphic3d.Graphic3d_TypeOfShadingModel # value = <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>
    __entries: dict # value = {'Graphic3d_TypeOfShadingModel_DEFAULT': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_DEFAULT: -1>, None), 'Graphic3d_TypeOfShadingModel_Unlit': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>, None), 'Graphic3d_TypeOfShadingModel_PhongFacet': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>, None), 'Graphic3d_TypeOfShadingModel_Gouraud': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>, None), 'Graphic3d_TypeOfShadingModel_Phong': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>, None), 'Graphic3d_TypeOfShadingModel_Pbr': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Pbr: 4>, None), 'Graphic3d_TypeOfShadingModel_PbrFacet': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PbrFacet: 5>, None), 'Graphic3d_TOSM_DEFAULT': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_DEFAULT: -1>, None), 'Graphic3d_TOSM_UNLIT': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>, None), 'Graphic3d_TOSM_FACET': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>, None), 'Graphic3d_TOSM_VERTEX': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>, None), 'Graphic3d_TOSM_FRAGMENT': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>, None), 'Graphic3d_TOSM_PBR': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Pbr: 4>, None), 'Graphic3d_TOSM_PBR_FACET': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PbrFacet: 5>, None), 'Graphic3d_TOSM_NONE': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>, None), 'V3d_COLOR': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>, None), 'V3d_FLAT': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>, None), 'V3d_GOURAUD': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>, None), 'V3d_PHONG': (<Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>, None)}
    __members__: dict # value = {'Graphic3d_TypeOfShadingModel_DEFAULT': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_DEFAULT: -1>, 'Graphic3d_TypeOfShadingModel_Unlit': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>, 'Graphic3d_TypeOfShadingModel_PhongFacet': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>, 'Graphic3d_TypeOfShadingModel_Gouraud': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>, 'Graphic3d_TypeOfShadingModel_Phong': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>, 'Graphic3d_TypeOfShadingModel_Pbr': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Pbr: 4>, 'Graphic3d_TypeOfShadingModel_PbrFacet': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PbrFacet: 5>, 'Graphic3d_TOSM_DEFAULT': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_DEFAULT: -1>, 'Graphic3d_TOSM_UNLIT': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>, 'Graphic3d_TOSM_FACET': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>, 'Graphic3d_TOSM_VERTEX': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>, 'Graphic3d_TOSM_FRAGMENT': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>, 'Graphic3d_TOSM_PBR': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Pbr: 4>, 'Graphic3d_TOSM_PBR_FACET': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PbrFacet: 5>, 'Graphic3d_TOSM_NONE': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>, 'V3d_COLOR': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Unlit: 0>, 'V3d_FLAT': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_PhongFacet: 1>, 'V3d_GOURAUD': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Gouraud: 2>, 'V3d_PHONG': <Graphic3d_TypeOfShadingModel.Graphic3d_TypeOfShadingModel_Phong: 3>}
    pass
class Graphic3d_TypeOfStructure():
    """
    Structural attribute indicating if it can be displayed in wireframe, shadow mode, or both.

    Members:

      Graphic3d_TOS_WIREFRAME

      Graphic3d_TOS_SHADING

      Graphic3d_TOS_COMPUTED

      Graphic3d_TOS_ALL
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOS_ALL: OCP.Graphic3d.Graphic3d_TypeOfStructure # value = <Graphic3d_TypeOfStructure.Graphic3d_TOS_ALL: 3>
    Graphic3d_TOS_COMPUTED: OCP.Graphic3d.Graphic3d_TypeOfStructure # value = <Graphic3d_TypeOfStructure.Graphic3d_TOS_COMPUTED: 2>
    Graphic3d_TOS_SHADING: OCP.Graphic3d.Graphic3d_TypeOfStructure # value = <Graphic3d_TypeOfStructure.Graphic3d_TOS_SHADING: 1>
    Graphic3d_TOS_WIREFRAME: OCP.Graphic3d.Graphic3d_TypeOfStructure # value = <Graphic3d_TypeOfStructure.Graphic3d_TOS_WIREFRAME: 0>
    __entries: dict # value = {'Graphic3d_TOS_WIREFRAME': (<Graphic3d_TypeOfStructure.Graphic3d_TOS_WIREFRAME: 0>, None), 'Graphic3d_TOS_SHADING': (<Graphic3d_TypeOfStructure.Graphic3d_TOS_SHADING: 1>, None), 'Graphic3d_TOS_COMPUTED': (<Graphic3d_TypeOfStructure.Graphic3d_TOS_COMPUTED: 2>, None), 'Graphic3d_TOS_ALL': (<Graphic3d_TypeOfStructure.Graphic3d_TOS_ALL: 3>, None)}
    __members__: dict # value = {'Graphic3d_TOS_WIREFRAME': <Graphic3d_TypeOfStructure.Graphic3d_TOS_WIREFRAME: 0>, 'Graphic3d_TOS_SHADING': <Graphic3d_TypeOfStructure.Graphic3d_TOS_SHADING: 1>, 'Graphic3d_TOS_COMPUTED': <Graphic3d_TypeOfStructure.Graphic3d_TOS_COMPUTED: 2>, 'Graphic3d_TOS_ALL': <Graphic3d_TypeOfStructure.Graphic3d_TOS_ALL: 3>}
    pass
class Graphic3d_TypeOfTexture():
    """
    Type of the texture file format.

    Members:

      Graphic3d_TypeOfTexture_1D

      Graphic3d_TypeOfTexture_2D

      Graphic3d_TypeOfTexture_3D

      Graphic3d_TypeOfTexture_CUBEMAP

      Graphic3d_TOT_2D_MIPMAP

      Graphic3d_TOT_1D

      Graphic3d_TOT_2D

      Graphic3d_TOT_CUBEMAP
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOT_1D: OCP.Graphic3d.Graphic3d_TypeOfTexture # value = <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_1D: 0>
    Graphic3d_TOT_2D: OCP.Graphic3d.Graphic3d_TypeOfTexture # value = <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_2D: 1>
    Graphic3d_TOT_2D_MIPMAP: OCP.Graphic3d.Graphic3d_TypeOfTexture # value = <Graphic3d_TypeOfTexture.Graphic3d_TOT_2D_MIPMAP: 4>
    Graphic3d_TOT_CUBEMAP: OCP.Graphic3d.Graphic3d_TypeOfTexture # value = <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_CUBEMAP: 3>
    Graphic3d_TypeOfTexture_1D: OCP.Graphic3d.Graphic3d_TypeOfTexture # value = <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_1D: 0>
    Graphic3d_TypeOfTexture_2D: OCP.Graphic3d.Graphic3d_TypeOfTexture # value = <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_2D: 1>
    Graphic3d_TypeOfTexture_3D: OCP.Graphic3d.Graphic3d_TypeOfTexture # value = <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_3D: 2>
    Graphic3d_TypeOfTexture_CUBEMAP: OCP.Graphic3d.Graphic3d_TypeOfTexture # value = <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_CUBEMAP: 3>
    __entries: dict # value = {'Graphic3d_TypeOfTexture_1D': (<Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_1D: 0>, None), 'Graphic3d_TypeOfTexture_2D': (<Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_2D: 1>, None), 'Graphic3d_TypeOfTexture_3D': (<Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_3D: 2>, None), 'Graphic3d_TypeOfTexture_CUBEMAP': (<Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_CUBEMAP: 3>, None), 'Graphic3d_TOT_2D_MIPMAP': (<Graphic3d_TypeOfTexture.Graphic3d_TOT_2D_MIPMAP: 4>, None), 'Graphic3d_TOT_1D': (<Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_1D: 0>, None), 'Graphic3d_TOT_2D': (<Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_2D: 1>, None), 'Graphic3d_TOT_CUBEMAP': (<Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_CUBEMAP: 3>, None)}
    __members__: dict # value = {'Graphic3d_TypeOfTexture_1D': <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_1D: 0>, 'Graphic3d_TypeOfTexture_2D': <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_2D: 1>, 'Graphic3d_TypeOfTexture_3D': <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_3D: 2>, 'Graphic3d_TypeOfTexture_CUBEMAP': <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_CUBEMAP: 3>, 'Graphic3d_TOT_2D_MIPMAP': <Graphic3d_TypeOfTexture.Graphic3d_TOT_2D_MIPMAP: 4>, 'Graphic3d_TOT_1D': <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_1D: 0>, 'Graphic3d_TOT_2D': <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_2D: 1>, 'Graphic3d_TOT_CUBEMAP': <Graphic3d_TypeOfTexture.Graphic3d_TypeOfTexture_CUBEMAP: 3>}
    pass
class Graphic3d_TypeOfTextureFilter():
    """
    Type of the texture filter. Notice that for textures without mipmaps linear interpolation will be used instead of TOTF_BILINEAR and TOTF_TRILINEAR.

    Members:

      Graphic3d_TOTF_NEAREST

      Graphic3d_TOTF_BILINEAR

      Graphic3d_TOTF_TRILINEAR
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOTF_BILINEAR: OCP.Graphic3d.Graphic3d_TypeOfTextureFilter # value = <Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_BILINEAR: 1>
    Graphic3d_TOTF_NEAREST: OCP.Graphic3d.Graphic3d_TypeOfTextureFilter # value = <Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_NEAREST: 0>
    Graphic3d_TOTF_TRILINEAR: OCP.Graphic3d.Graphic3d_TypeOfTextureFilter # value = <Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_TRILINEAR: 2>
    __entries: dict # value = {'Graphic3d_TOTF_NEAREST': (<Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_NEAREST: 0>, None), 'Graphic3d_TOTF_BILINEAR': (<Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_BILINEAR: 1>, None), 'Graphic3d_TOTF_TRILINEAR': (<Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_TRILINEAR: 2>, None)}
    __members__: dict # value = {'Graphic3d_TOTF_NEAREST': <Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_NEAREST: 0>, 'Graphic3d_TOTF_BILINEAR': <Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_BILINEAR: 1>, 'Graphic3d_TOTF_TRILINEAR': <Graphic3d_TypeOfTextureFilter.Graphic3d_TOTF_TRILINEAR: 2>}
    pass
class Graphic3d_TypeOfTextureMode():
    """
    Type of the texture projection.

    Members:

      Graphic3d_TOTM_OBJECT

      Graphic3d_TOTM_SPHERE

      Graphic3d_TOTM_EYE

      Graphic3d_TOTM_MANUAL

      Graphic3d_TOTM_SPRITE
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOTM_EYE: OCP.Graphic3d.Graphic3d_TypeOfTextureMode # value = <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_EYE: 2>
    Graphic3d_TOTM_MANUAL: OCP.Graphic3d.Graphic3d_TypeOfTextureMode # value = <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_MANUAL: 3>
    Graphic3d_TOTM_OBJECT: OCP.Graphic3d.Graphic3d_TypeOfTextureMode # value = <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_OBJECT: 0>
    Graphic3d_TOTM_SPHERE: OCP.Graphic3d.Graphic3d_TypeOfTextureMode # value = <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_SPHERE: 1>
    Graphic3d_TOTM_SPRITE: OCP.Graphic3d.Graphic3d_TypeOfTextureMode # value = <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_SPRITE: 4>
    __entries: dict # value = {'Graphic3d_TOTM_OBJECT': (<Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_OBJECT: 0>, None), 'Graphic3d_TOTM_SPHERE': (<Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_SPHERE: 1>, None), 'Graphic3d_TOTM_EYE': (<Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_EYE: 2>, None), 'Graphic3d_TOTM_MANUAL': (<Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_MANUAL: 3>, None), 'Graphic3d_TOTM_SPRITE': (<Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_SPRITE: 4>, None)}
    __members__: dict # value = {'Graphic3d_TOTM_OBJECT': <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_OBJECT: 0>, 'Graphic3d_TOTM_SPHERE': <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_SPHERE: 1>, 'Graphic3d_TOTM_EYE': <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_EYE: 2>, 'Graphic3d_TOTM_MANUAL': <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_MANUAL: 3>, 'Graphic3d_TOTM_SPRITE': <Graphic3d_TypeOfTextureMode.Graphic3d_TOTM_SPRITE: 4>}
    pass
class Graphic3d_TypeOfVisualization():
    """
    Modes of visualisation of objects in a view

    Members:

      Graphic3d_TOV_WIREFRAME

      Graphic3d_TOV_SHADING
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Graphic3d_TOV_SHADING: OCP.Graphic3d.Graphic3d_TypeOfVisualization # value = <Graphic3d_TypeOfVisualization.Graphic3d_TOV_SHADING: 1>
    Graphic3d_TOV_WIREFRAME: OCP.Graphic3d.Graphic3d_TypeOfVisualization # value = <Graphic3d_TypeOfVisualization.Graphic3d_TOV_WIREFRAME: 0>
    __entries: dict # value = {'Graphic3d_TOV_WIREFRAME': (<Graphic3d_TypeOfVisualization.Graphic3d_TOV_WIREFRAME: 0>, None), 'Graphic3d_TOV_SHADING': (<Graphic3d_TypeOfVisualization.Graphic3d_TOV_SHADING: 1>, None)}
    __members__: dict # value = {'Graphic3d_TOV_WIREFRAME': <Graphic3d_TypeOfVisualization.Graphic3d_TOV_WIREFRAME: 0>, 'Graphic3d_TOV_SHADING': <Graphic3d_TypeOfVisualization.Graphic3d_TOV_SHADING: 1>}
    pass
class Graphic3d_ValueInterface():
    """
    Interface for generic variable value.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    pass
class Graphic3d_UniformInt(Graphic3d_ValueInterface):
    """
    Describes specific value of custom uniform variable.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    def __init__(self,theValue : int) -> None: ...
    pass
class Graphic3d_UniformValueTypeID_Graphic3d_Vec2():
    def __init__(self) -> None: ...
    pass
class Graphic3d_UniformValueTypeID_Graphic3d_Vec2i():
    def __init__(self) -> None: ...
    pass
class Graphic3d_UniformValueTypeID_Graphic3d_Vec3():
    def __init__(self) -> None: ...
    pass
class Graphic3d_UniformValueTypeID_Graphic3d_Vec3i():
    def __init__(self) -> None: ...
    pass
class Graphic3d_UniformValueTypeID_Graphic3d_Vec4():
    def __init__(self) -> None: ...
    pass
class Graphic3d_UniformValueTypeID_Graphic3d_Vec4i():
    def __init__(self) -> None: ...
    pass
class Graphic3d_UniformValueTypeID_Standard_Integer():
    def __init__(self) -> None: ...
    pass
class Graphic3d_UniformValueTypeID_Standard_ShortReal():
    def __init__(self) -> None: ...
    pass
class Graphic3d_UniformVec2(Graphic3d_ValueInterface):
    """
    Describes specific value of custom uniform variable.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    def __init__(self,theValue : OCP.gp.gp_Vec2f) -> None: ...
    pass
class Graphic3d_UniformVec2i(Graphic3d_ValueInterface):
    """
    Describes specific value of custom uniform variable.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    def __init__(self,theValue : Graphic3d_Vec2i) -> None: ...
    pass
class Graphic3d_UniformVec3(Graphic3d_ValueInterface):
    """
    Describes specific value of custom uniform variable.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    def __init__(self,theValue : OCP.gp.gp_Vec3f) -> None: ...
    pass
class Graphic3d_UniformVec3i(Graphic3d_ValueInterface):
    """
    Describes specific value of custom uniform variable.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    def __init__(self,theValue : Graphic3d_Vec3i) -> None: ...
    pass
class Graphic3d_UniformVec4(Graphic3d_ValueInterface):
    """
    Describes specific value of custom uniform variable.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    def __init__(self,theValue : Graphic3d_Vec4) -> None: ...
    pass
class Graphic3d_UniformVec4i(Graphic3d_ValueInterface):
    """
    Describes specific value of custom uniform variable.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    def __init__(self,theValue : Graphic3d_Vec4i) -> None: ...
    pass
class Graphic3d_ValidatedCubeMapOrder():
    """
    Graphic3d_ValidatedCubeMapOrder contains completely valid order object. The only way to create this class except copy constructor is 'Validated' method of Graphic3d_CubeMapOrder. This class can initialize Graphic3d_CubeMapOrder. It is supposed to be used in case of necessity of completely valid order (in function argument as example). It helps to automate order's valid checks.Graphic3d_ValidatedCubeMapOrder contains completely valid order object. The only way to create this class except copy constructor is 'Validated' method of Graphic3d_CubeMapOrder. This class can initialize Graphic3d_CubeMapOrder. It is supposed to be used in case of necessity of completely valid order (in function argument as example). It helps to automate order's valid checks.
    """
    def __init__(self,theOther : Graphic3d_ValidatedCubeMapOrder) -> None: ...
    pass
class Graphic3d_UniformFloat(Graphic3d_ValueInterface):
    """
    Describes specific value of custom uniform variable.
    """
    def TypeID(self) -> int: 
        """
        Returns unique identifier of value type.
        """
    def __init__(self,theValue : float) -> None: ...
    pass
class Graphic3d_Vec2b():
    """
    Defines the 2D-vector template. The main target for this class - to handle raw low-level arrays (from/to graphic driver etc.).
    """
    def ChangeData(self) -> str: ...
    @staticmethod
    def DX_s() -> Graphic3d_Vec2b: 
        """
        Construct DX unit vector.
        """
    @staticmethod
    def DY_s() -> Graphic3d_Vec2b: 
        """
        Construct DY unit vector.
        """
    def Dot(self,theOther : Graphic3d_Vec2b) -> str: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> str: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    def IsEqual(self,theOther : Graphic3d_Vec2b) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Modulus(self) -> str: 
        """
        Computes the vector modulus (magnitude, length).
        """
    def Multiplied(self,theFactor : str) -> Graphic3d_Vec2b: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Multiply(self,theFactor : str) -> None: 
        """
        Compute per-component multiplication by scale factor.
        """
    def SetValues(self,theX : str,theY : str) -> None: 
        """
        Assign new values to the vector.
        """
    def SquareModulus(self) -> str: 
        """
        Computes the square of vector modulus (magnitude, length). This method may be used for performance tricks.
        """
    def __iadd__(self,theAdd : Graphic3d_Vec2b) -> Graphic3d_Vec2b: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec2b) -> Graphic3d_Vec2b: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication by scale factor.
        """
    @overload
    def __imul__(self,theFactor : str) -> Graphic3d_Vec2b: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theXY : str) -> None: ...
    @overload
    def __init__(self,theX : str,theY : str) -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec2b) -> Graphic3d_Vec2b: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : str) -> Graphic3d_Vec2b: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec2b) -> Graphic3d_Vec2b: ...
    def __mul__(self,theFactor : str) -> Graphic3d_Vec2b: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __rmul__(self,theFactor : str) -> Graphic3d_Vec2b: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __sub__(self) -> Graphic3d_Vec2b: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : str) -> Graphic3d_Vec2b: 
        """
        Compute per-component division by scale factor.
        """
    def cwiseAbs(self) -> Graphic3d_Vec2b: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec2b) -> Graphic3d_Vec2b: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec2b) -> Graphic3d_Vec2b: 
        """
        Compute component-wise minimum of two vectors.
        """
    def maxComp(self) -> str: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> str: 
        """
        Compute minimum component of the vector.
        """
    def x(self) -> str: 
        """
        Alias to 1st component as X coordinate in XY.

        Alias to 1st component as X coordinate in XY.
        """
    def xy(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def y(self) -> str: 
        """
        Alias to 2nd component as Y coordinate in XY.

        Alias to 2nd component as Y coordinate in XY.
        """
    def yx(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    pass
class Graphic3d_Vec2d():
    """
    Defines the 2D-vector template. The main target for this class - to handle raw low-level arrays (from/to graphic driver etc.).
    """
    def ChangeData(self) -> float: ...
    @staticmethod
    def DX_s() -> Graphic3d_Vec2d: 
        """
        Construct DX unit vector.
        """
    @staticmethod
    def DY_s() -> Graphic3d_Vec2d: 
        """
        Construct DY unit vector.
        """
    def Dot(self,theOther : Graphic3d_Vec2d) -> float: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> float: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    def IsEqual(self,theOther : Graphic3d_Vec2d) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Modulus(self) -> float: 
        """
        Computes the vector modulus (magnitude, length).
        """
    def Multiplied(self,theFactor : float) -> Graphic3d_Vec2d: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Multiply(self,theFactor : float) -> None: 
        """
        Compute per-component multiplication by scale factor.
        """
    def SetValues(self,theX : float,theY : float) -> None: 
        """
        Assign new values to the vector.
        """
    def SquareModulus(self) -> float: 
        """
        Computes the square of vector modulus (magnitude, length). This method may be used for performance tricks.
        """
    def __iadd__(self,theAdd : Graphic3d_Vec2d) -> Graphic3d_Vec2d: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec2d) -> Graphic3d_Vec2d: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication by scale factor.
        """
    @overload
    def __imul__(self,theFactor : float) -> Graphic3d_Vec2d: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theXY : float) -> None: ...
    @overload
    def __init__(self,theX : float,theY : float) -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec2d) -> Graphic3d_Vec2d: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : float) -> Graphic3d_Vec2d: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec2d) -> Graphic3d_Vec2d: ...
    def __mul__(self,theFactor : float) -> Graphic3d_Vec2d: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __rmul__(self,theFactor : float) -> Graphic3d_Vec2d: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __sub__(self) -> Graphic3d_Vec2d: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : float) -> Graphic3d_Vec2d: 
        """
        Compute per-component division by scale factor.
        """
    def cwiseAbs(self) -> Graphic3d_Vec2d: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec2d) -> Graphic3d_Vec2d: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec2d) -> Graphic3d_Vec2d: 
        """
        Compute component-wise minimum of two vectors.
        """
    def maxComp(self) -> float: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> float: 
        """
        Compute minimum component of the vector.
        """
    def x(self) -> float: 
        """
        Alias to 1st component as X coordinate in XY.

        Alias to 1st component as X coordinate in XY.
        """
    def xy(self) -> Graphic3d_Vec2d: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def y(self) -> float: 
        """
        Alias to 2nd component as Y coordinate in XY.

        Alias to 2nd component as Y coordinate in XY.
        """
    def yx(self) -> Graphic3d_Vec2d: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    pass
class Graphic3d_Vec2i():
    """
    Defines the 2D-vector template. The main target for this class - to handle raw low-level arrays (from/to graphic driver etc.).
    """
    def ChangeData(self) -> int: ...
    @staticmethod
    def DX_s() -> Graphic3d_Vec2i: 
        """
        Construct DX unit vector.
        """
    @staticmethod
    def DY_s() -> Graphic3d_Vec2i: 
        """
        Construct DY unit vector.
        """
    def Dot(self,theOther : Graphic3d_Vec2i) -> int: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> int: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    def IsEqual(self,theOther : Graphic3d_Vec2i) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Modulus(self) -> int: 
        """
        Computes the vector modulus (magnitude, length).
        """
    def Multiplied(self,theFactor : int) -> Graphic3d_Vec2i: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Multiply(self,theFactor : int) -> None: 
        """
        Compute per-component multiplication by scale factor.
        """
    def SetValues(self,theX : int,theY : int) -> None: 
        """
        Assign new values to the vector.
        """
    def SquareModulus(self) -> int: 
        """
        Computes the square of vector modulus (magnitude, length). This method may be used for performance tricks.
        """
    def __iadd__(self,theAdd : Graphic3d_Vec2i) -> Graphic3d_Vec2i: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec2i) -> Graphic3d_Vec2i: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication by scale factor.
        """
    @overload
    def __imul__(self,theFactor : int) -> Graphic3d_Vec2i: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theXY : int) -> None: ...
    @overload
    def __init__(self,theX : int,theY : int) -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec2i) -> Graphic3d_Vec2i: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : int) -> Graphic3d_Vec2i: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec2i) -> Graphic3d_Vec2i: ...
    def __mul__(self,theFactor : int) -> Graphic3d_Vec2i: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __rmul__(self,theFactor : int) -> Graphic3d_Vec2i: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __sub__(self) -> Graphic3d_Vec2i: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : int) -> Graphic3d_Vec2i: 
        """
        Compute per-component division by scale factor.
        """
    def cwiseAbs(self) -> Graphic3d_Vec2i: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec2i) -> Graphic3d_Vec2i: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec2i) -> Graphic3d_Vec2i: 
        """
        Compute component-wise minimum of two vectors.
        """
    def maxComp(self) -> int: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> int: 
        """
        Compute minimum component of the vector.
        """
    def x(self) -> int: 
        """
        Alias to 1st component as X coordinate in XY.

        Alias to 1st component as X coordinate in XY.
        """
    def xy(self) -> Graphic3d_Vec2i: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def y(self) -> int: 
        """
        Alias to 2nd component as Y coordinate in XY.

        Alias to 2nd component as Y coordinate in XY.
        """
    def yx(self) -> Graphic3d_Vec2i: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    pass
class Graphic3d_Vec2ub():
    """
    Defines the 2D-vector template. The main target for this class - to handle raw low-level arrays (from/to graphic driver etc.).
    """
    def ChangeData(self) -> int: ...
    @staticmethod
    def DX_s() -> Graphic3d_Vec2ub: 
        """
        Construct DX unit vector.
        """
    @staticmethod
    def DY_s() -> Graphic3d_Vec2ub: 
        """
        Construct DY unit vector.
        """
    def Dot(self,theOther : Graphic3d_Vec2ub) -> int: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> int: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    def IsEqual(self,theOther : Graphic3d_Vec2ub) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Modulus(self) -> int: 
        """
        Computes the vector modulus (magnitude, length).
        """
    def Multiplied(self,theFactor : int) -> Graphic3d_Vec2ub: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Multiply(self,theFactor : int) -> None: 
        """
        Compute per-component multiplication by scale factor.
        """
    def SetValues(self,theX : int,theY : int) -> None: 
        """
        Assign new values to the vector.
        """
    def SquareModulus(self) -> int: 
        """
        Computes the square of vector modulus (magnitude, length). This method may be used for performance tricks.
        """
    def __iadd__(self,theAdd : Graphic3d_Vec2ub) -> Graphic3d_Vec2ub: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec2ub) -> Graphic3d_Vec2ub: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication by scale factor.
        """
    @overload
    def __imul__(self,theFactor : int) -> Graphic3d_Vec2ub: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theXY : int) -> None: ...
    @overload
    def __init__(self,theX : int,theY : int) -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec2ub) -> Graphic3d_Vec2ub: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : int) -> Graphic3d_Vec2ub: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec2ub) -> Graphic3d_Vec2ub: ...
    def __mul__(self,theFactor : int) -> Graphic3d_Vec2ub: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __rmul__(self,theFactor : int) -> Graphic3d_Vec2ub: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __sub__(self) -> Graphic3d_Vec2ub: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : int) -> Graphic3d_Vec2ub: 
        """
        Compute per-component division by scale factor.
        """
    def cwiseAbs(self) -> Graphic3d_Vec2ub: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec2ub) -> Graphic3d_Vec2ub: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec2ub) -> Graphic3d_Vec2ub: 
        """
        Compute component-wise minimum of two vectors.
        """
    def maxComp(self) -> int: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> int: 
        """
        Compute minimum component of the vector.
        """
    def x(self) -> int: 
        """
        Alias to 1st component as X coordinate in XY.

        Alias to 1st component as X coordinate in XY.
        """
    def xy(self) -> Graphic3d_Vec2ub: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def y(self) -> int: 
        """
        Alias to 2nd component as Y coordinate in XY.

        Alias to 2nd component as Y coordinate in XY.
        """
    def yx(self) -> Graphic3d_Vec2ub: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    pass
class Graphic3d_Vec3b():
    """
    Generic 3-components vector. To be used as RGB color pixel or XYZ 3D-point. The main target for this class - to handle raw low-level arrays (from/to graphic driver etc.).
    """
    def ChangeData(self) -> str: ...
    @staticmethod
    def Cross_s(theVec1 : Graphic3d_Vec3b,theVec2 : Graphic3d_Vec3b) -> Graphic3d_Vec3b: 
        """
        Computes the cross product.
        """
    @staticmethod
    def DX_s() -> Graphic3d_Vec3b: 
        """
        Construct DX unit vector.
        """
    @staticmethod
    def DY_s() -> Graphic3d_Vec3b: 
        """
        Construct DY unit vector.
        """
    @staticmethod
    def DZ_s() -> Graphic3d_Vec3b: 
        """
        Construct DZ unit vector.
        """
    def Dot(self,theOther : Graphic3d_Vec3b) -> str: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> str: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    @staticmethod
    def GetLERP_s(theFrom : Graphic3d_Vec3b,theTo : Graphic3d_Vec3b,theT : str) -> Graphic3d_Vec3b: 
        """
        Compute linear interpolation between to vectors.
        """
    def IsEqual(self,theOther : Graphic3d_Vec3b) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Modulus(self) -> str: 
        """
        Computes the vector modulus (magnitude, length).
        """
    def Multiplied(self,theFactor : str) -> Graphic3d_Vec3b: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Multiply(self,theFactor : str) -> None: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Normalize(self) -> None: 
        """
        Normalize the vector.
        """
    def Normalized(self) -> Graphic3d_Vec3b: 
        """
        Normalize the vector.
        """
    @overload
    def SetValues(self,theX : str,theY : str,theZ : str) -> None: 
        """
        Assign new values to the vector.

        Assign new values to the vector.
        """
    @overload
    def SetValues(self,theVec2 : Graphic3d_Vec2b,theZ : str) -> None: ...
    def SquareModulus(self) -> str: 
        """
        Computes the square of vector modulus (magnitude, length). This method may be used for performance tricks.
        """
    def __iadd__(self,theAdd : Graphic3d_Vec3b) -> Graphic3d_Vec3b: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec3b) -> Graphic3d_Vec3b: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication by scale factor.
        """
    @overload
    def __imul__(self,theFactor : str) -> Graphic3d_Vec3b: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theValue : str) -> None: ...
    @overload
    def __init__(self,theX : str,theY : str,theZ : str) -> None: ...
    @overload
    def __init__(self,theVec2 : Graphic3d_Vec2b,theZ : str='\x00') -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec3b) -> Graphic3d_Vec3b: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : str) -> Graphic3d_Vec3b: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec3b) -> Graphic3d_Vec3b: ...
    def __mul__(self,theFactor : str) -> Graphic3d_Vec3b: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __rmul__(self,theFactor : str) -> Graphic3d_Vec3b: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __sub__(self) -> Graphic3d_Vec3b: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : str) -> Graphic3d_Vec3b: 
        """
        Compute per-component division by scale factor.
        """
    def b(self) -> str: 
        """
        Alias to 3rd component as BLUE channel in RGB.

        Alias to 3rd component as BLUE channel in RGB.
        """
    def cwiseAbs(self) -> Graphic3d_Vec3b: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec3b) -> Graphic3d_Vec3b: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec3b) -> Graphic3d_Vec3b: 
        """
        Compute component-wise minimum of two vectors.
        """
    def g(self) -> str: 
        """
        Alias to 2nd component as GREEN channel in RGB.

        Alias to 2nd component as GREEN channel in RGB.
        """
    def maxComp(self) -> str: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> str: 
        """
        Compute minimum component of the vector.
        """
    def r(self) -> str: 
        """
        Alias to 1st component as RED channel in RGB.

        Alias to 1st component as RED channel in RGB.
        """
    def x(self) -> str: 
        """
        Alias to 1st component as X coordinate in XYZ.

        Alias to 1st component as X coordinate in XYZ.
        """
    def xy(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def xyz(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def xz(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def xzy(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def y(self) -> str: 
        """
        Alias to 2nd component as Y coordinate in XYZ.

        Alias to 2nd component as Y coordinate in XYZ.
        """
    def yx(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def yxz(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def yz(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def yzx(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def z(self) -> str: 
        """
        Alias to 3rd component as Z coordinate in XYZ.

        Alias to 3rd component as Z coordinate in XYZ.
        """
    def zx(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def zxy(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def zy(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def zyx(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    pass
class Graphic3d_Vec3i():
    """
    Generic 3-components vector. To be used as RGB color pixel or XYZ 3D-point. The main target for this class - to handle raw low-level arrays (from/to graphic driver etc.).
    """
    def ChangeData(self) -> int: ...
    @staticmethod
    def Cross_s(theVec1 : Graphic3d_Vec3i,theVec2 : Graphic3d_Vec3i) -> Graphic3d_Vec3i: 
        """
        Computes the cross product.
        """
    @staticmethod
    def DX_s() -> Graphic3d_Vec3i: 
        """
        Construct DX unit vector.
        """
    @staticmethod
    def DY_s() -> Graphic3d_Vec3i: 
        """
        Construct DY unit vector.
        """
    @staticmethod
    def DZ_s() -> Graphic3d_Vec3i: 
        """
        Construct DZ unit vector.
        """
    def Dot(self,theOther : Graphic3d_Vec3i) -> int: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> int: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    @staticmethod
    def GetLERP_s(theFrom : Graphic3d_Vec3i,theTo : Graphic3d_Vec3i,theT : int) -> Graphic3d_Vec3i: 
        """
        Compute linear interpolation between to vectors.
        """
    def IsEqual(self,theOther : Graphic3d_Vec3i) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Modulus(self) -> int: 
        """
        Computes the vector modulus (magnitude, length).
        """
    def Multiplied(self,theFactor : int) -> Graphic3d_Vec3i: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Multiply(self,theFactor : int) -> None: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Normalize(self) -> None: 
        """
        Normalize the vector.
        """
    def Normalized(self) -> Graphic3d_Vec3i: 
        """
        Normalize the vector.
        """
    @overload
    def SetValues(self,theX : int,theY : int,theZ : int) -> None: 
        """
        Assign new values to the vector.

        Assign new values to the vector.
        """
    @overload
    def SetValues(self,theVec2 : Graphic3d_Vec2i,theZ : int) -> None: ...
    def SquareModulus(self) -> int: 
        """
        Computes the square of vector modulus (magnitude, length). This method may be used for performance tricks.
        """
    def __iadd__(self,theAdd : Graphic3d_Vec3i) -> Graphic3d_Vec3i: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec3i) -> Graphic3d_Vec3i: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication by scale factor.
        """
    @overload
    def __imul__(self,theFactor : int) -> Graphic3d_Vec3i: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theValue : int) -> None: ...
    @overload
    def __init__(self,theX : int,theY : int,theZ : int) -> None: ...
    @overload
    def __init__(self,theVec2 : Graphic3d_Vec2i,theZ : int=0) -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec3i) -> Graphic3d_Vec3i: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : int) -> Graphic3d_Vec3i: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec3i) -> Graphic3d_Vec3i: ...
    def __mul__(self,theFactor : int) -> Graphic3d_Vec3i: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __rmul__(self,theFactor : int) -> Graphic3d_Vec3i: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __sub__(self) -> Graphic3d_Vec3i: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : int) -> Graphic3d_Vec3i: 
        """
        Compute per-component division by scale factor.
        """
    def b(self) -> int: 
        """
        Alias to 3rd component as BLUE channel in RGB.

        Alias to 3rd component as BLUE channel in RGB.
        """
    def cwiseAbs(self) -> Graphic3d_Vec3i: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec3i) -> Graphic3d_Vec3i: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec3i) -> Graphic3d_Vec3i: 
        """
        Compute component-wise minimum of two vectors.
        """
    def g(self) -> int: 
        """
        Alias to 2nd component as GREEN channel in RGB.

        Alias to 2nd component as GREEN channel in RGB.
        """
    def maxComp(self) -> int: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> int: 
        """
        Compute minimum component of the vector.
        """
    def r(self) -> int: 
        """
        Alias to 1st component as RED channel in RGB.

        Alias to 1st component as RED channel in RGB.
        """
    def x(self) -> int: 
        """
        Alias to 1st component as X coordinate in XYZ.

        Alias to 1st component as X coordinate in XYZ.
        """
    def xy(self) -> Graphic3d_Vec2i: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def xyz(self) -> Graphic3d_Vec3i: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def xz(self) -> Graphic3d_Vec2i: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def xzy(self) -> Graphic3d_Vec3i: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def y(self) -> int: 
        """
        Alias to 2nd component as Y coordinate in XYZ.

        Alias to 2nd component as Y coordinate in XYZ.
        """
    def yx(self) -> Graphic3d_Vec2i: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def yxz(self) -> Graphic3d_Vec3i: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def yz(self) -> Graphic3d_Vec2i: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def yzx(self) -> Graphic3d_Vec3i: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def z(self) -> int: 
        """
        Alias to 3rd component as Z coordinate in XYZ.

        Alias to 3rd component as Z coordinate in XYZ.
        """
    def zx(self) -> Graphic3d_Vec2i: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def zxy(self) -> Graphic3d_Vec3i: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def zy(self) -> Graphic3d_Vec2i: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def zyx(self) -> Graphic3d_Vec3i: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    pass
class Graphic3d_Vec3ub():
    """
    Generic 3-components vector. To be used as RGB color pixel or XYZ 3D-point. The main target for this class - to handle raw low-level arrays (from/to graphic driver etc.).
    """
    def ChangeData(self) -> int: ...
    @staticmethod
    def Cross_s(theVec1 : Graphic3d_Vec3ub,theVec2 : Graphic3d_Vec3ub) -> Graphic3d_Vec3ub: 
        """
        Computes the cross product.
        """
    @staticmethod
    def DX_s() -> Graphic3d_Vec3ub: 
        """
        Construct DX unit vector.
        """
    @staticmethod
    def DY_s() -> Graphic3d_Vec3ub: 
        """
        Construct DY unit vector.
        """
    @staticmethod
    def DZ_s() -> Graphic3d_Vec3ub: 
        """
        Construct DZ unit vector.
        """
    def Dot(self,theOther : Graphic3d_Vec3ub) -> int: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> int: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    @staticmethod
    def GetLERP_s(theFrom : Graphic3d_Vec3ub,theTo : Graphic3d_Vec3ub,theT : int) -> Graphic3d_Vec3ub: 
        """
        Compute linear interpolation between to vectors.
        """
    def IsEqual(self,theOther : Graphic3d_Vec3ub) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Modulus(self) -> int: 
        """
        Computes the vector modulus (magnitude, length).
        """
    def Multiplied(self,theFactor : int) -> Graphic3d_Vec3ub: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Multiply(self,theFactor : int) -> None: 
        """
        Compute per-component multiplication by scale factor.
        """
    def Normalize(self) -> None: 
        """
        Normalize the vector.
        """
    def Normalized(self) -> Graphic3d_Vec3ub: 
        """
        Normalize the vector.
        """
    @overload
    def SetValues(self,theX : int,theY : int,theZ : int) -> None: 
        """
        Assign new values to the vector.

        Assign new values to the vector.
        """
    @overload
    def SetValues(self,theVec2 : Graphic3d_Vec2ub,theZ : int) -> None: ...
    def SquareModulus(self) -> int: 
        """
        Computes the square of vector modulus (magnitude, length). This method may be used for performance tricks.
        """
    def __iadd__(self,theAdd : Graphic3d_Vec3ub) -> Graphic3d_Vec3ub: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec3ub) -> Graphic3d_Vec3ub: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication by scale factor.
        """
    @overload
    def __imul__(self,theFactor : int) -> Graphic3d_Vec3ub: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theValue : int) -> None: ...
    @overload
    def __init__(self,theX : int,theY : int,theZ : int) -> None: ...
    @overload
    def __init__(self,theVec2 : Graphic3d_Vec2ub,theZ : int=0) -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec3ub) -> Graphic3d_Vec3ub: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : int) -> Graphic3d_Vec3ub: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec3ub) -> Graphic3d_Vec3ub: ...
    def __mul__(self,theFactor : int) -> Graphic3d_Vec3ub: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __rmul__(self,theFactor : int) -> Graphic3d_Vec3ub: 
        """
        Compute per-component multiplication by scale factor.
        """
    def __sub__(self) -> Graphic3d_Vec3ub: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : int) -> Graphic3d_Vec3ub: 
        """
        Compute per-component division by scale factor.
        """
    def b(self) -> int: 
        """
        Alias to 3rd component as BLUE channel in RGB.

        Alias to 3rd component as BLUE channel in RGB.
        """
    def cwiseAbs(self) -> Graphic3d_Vec3ub: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec3ub) -> Graphic3d_Vec3ub: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec3ub) -> Graphic3d_Vec3ub: 
        """
        Compute component-wise minimum of two vectors.
        """
    def g(self) -> int: 
        """
        Alias to 2nd component as GREEN channel in RGB.

        Alias to 2nd component as GREEN channel in RGB.
        """
    def maxComp(self) -> int: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> int: 
        """
        Compute minimum component of the vector.
        """
    def r(self) -> int: 
        """
        Alias to 1st component as RED channel in RGB.

        Alias to 1st component as RED channel in RGB.
        """
    def x(self) -> int: 
        """
        Alias to 1st component as X coordinate in XYZ.

        Alias to 1st component as X coordinate in XYZ.
        """
    def xy(self) -> Graphic3d_Vec2ub: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def xyz(self) -> Graphic3d_Vec3ub: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def xz(self) -> Graphic3d_Vec2ub: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def xzy(self) -> Graphic3d_Vec3ub: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def y(self) -> int: 
        """
        Alias to 2nd component as Y coordinate in XYZ.

        Alias to 2nd component as Y coordinate in XYZ.
        """
    def yx(self) -> Graphic3d_Vec2ub: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def yxz(self) -> Graphic3d_Vec3ub: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def yz(self) -> Graphic3d_Vec2ub: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def yzx(self) -> Graphic3d_Vec3ub: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def z(self) -> int: 
        """
        Alias to 3rd component as Z coordinate in XYZ.

        Alias to 3rd component as Z coordinate in XYZ.
        """
    def zx(self) -> Graphic3d_Vec2ub: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def zxy(self) -> Graphic3d_Vec3ub: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    def zy(self) -> Graphic3d_Vec2ub: 
        """
        Returns 2 components by their names in specified order (in GLSL-style)
        """
    def zyx(self) -> Graphic3d_Vec3ub: 
        """
        Returns 3 components by their names in specified order (in GLSL-style)
        """
    pass
class Graphic3d_Vec4():
    """
    Generic 4-components vector. To be used as RGBA color vector or XYZW 3D-point with special W-component for operations with projection / model view matrices. Use this class for 3D-points carefully because declared W-component may results in incorrect results if used without matrices.
    """
    def ChangeData(self) -> float: ...
    def Dot(self,theOther : Graphic3d_Vec4) -> float: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> float: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    def IsEqual(self,theOther : Graphic3d_Vec4) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Multiplied(self,theFactor : float) -> Graphic3d_Vec4: 
        """
        Compute per-component multiplication.
        """
    def Multiply(self,theFactor : float) -> None: 
        """
        Compute per-component multiplication.
        """
    @overload
    def SetValues(self,theX : float,theY : float,theZ : float,theW : float) -> None: 
        """
        Assign new values to the vector.

        Assign new values as 3-component vector and a 4-th value.
        """
    @overload
    def SetValues(self,theVec3 : OCP.gp.gp_Vec3f,theW : float) -> None: ...
    def __iadd__(self,theAdd : Graphic3d_Vec4) -> Graphic3d_Vec4: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec4) -> Graphic3d_Vec4: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication.
        """
    @overload
    def __imul__(self,theFactor : float) -> Graphic3d_Vec4: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theValue : float) -> None: ...
    @overload
    def __init__(self,theX : float,theY : float,theZ : float,theW : float) -> None: ...
    @overload
    def __init__(self,theVec2 : OCP.gp.gp_Vec2f) -> None: ...
    @overload
    def __init__(self,theVec3 : OCP.gp.gp_Vec3f,theW : float=0.0) -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec4) -> Graphic3d_Vec4: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : float) -> Graphic3d_Vec4: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec4) -> Graphic3d_Vec4: ...
    def __mul__(self,theFactor : float) -> Graphic3d_Vec4: 
        """
        Compute per-component multiplication.
        """
    def __rmul__(self,theFactor : float) -> Graphic3d_Vec4: 
        """
        Compute per-component multiplication.
        """
    def __sub__(self) -> Graphic3d_Vec4: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : float) -> Graphic3d_Vec4: 
        """
        Compute per-component division by scale factor.
        """
    def a(self) -> float: 
        """
        Alias to 4th component as ALPHA channel in RGBA.

        Alias to 4th component as ALPHA channel in RGBA.
        """
    def b(self) -> float: 
        """
        Alias to 3rd component as BLUE channel in RGBA.

        Alias to 3rd component as BLUE channel in RGBA.
        """
    def bgr(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns RGB components as vector
        """
    def brg(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns RGB components as vector
        """
    def cwiseAbs(self) -> Graphic3d_Vec4: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec4) -> Graphic3d_Vec4: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec4) -> Graphic3d_Vec4: 
        """
        Compute component-wise minimum of two vectors.
        """
    def g(self) -> float: 
        """
        Alias to 2nd component as GREEN channel in RGBA.

        Alias to 2nd component as GREEN channel in RGBA.
        """
    def gbr(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns RGB components as vector
        """
    def grb(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns RGB components as vector
        """
    def maxComp(self) -> float: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> float: 
        """
        Compute minimum component of the vector.
        """
    def r(self) -> float: 
        """
        Alias to 1st component as RED channel in RGBA.

        Alias to 1st component as RED channel in RGBA.
        """
    def rbg(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns RGB components as vector
        """
    def rgb(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns RGB components as vector
        """
    def w(self) -> float: 
        """
        Alias to 4th component as W coordinate in XYZW.

        Alias to 4th component as W coordinate in XYZW.
        """
    def wx(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def wxy(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wxz(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wy(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def wyx(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wyz(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wz(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def wzx(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wzy(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def x(self) -> float: 
        """
        Alias to 1st component as X coordinate in XYZW.

        Alias to 1st component as X coordinate in XYZW.
        """
    def xw(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def xwy(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xwz(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xy(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def xyw(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xyz(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xz(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def xzw(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xzy(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def y(self) -> float: 
        """
        Alias to 2nd component as Y coordinate in XYZW.

        Alias to 2nd component as Y coordinate in XYZW.
        """
    def yw(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def ywx(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def ywz(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def yx(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def yxw(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def yxz(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def yz(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def yzw(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def yzx(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def z(self) -> float: 
        """
        Alias to 3rd component as Z coordinate in XYZW.

        Alias to 3rd component as Z coordinate in XYZW.
        """
    def zw(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def zwx(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def zwy(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def zx(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def zxw(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def zxy(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def zy(self) -> OCP.gp.gp_Vec2f: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def zyw(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def zyx(self) -> OCP.gp.gp_Vec3f: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    pass
class Graphic3d_Vec4b():
    """
    Generic 4-components vector. To be used as RGBA color vector or XYZW 3D-point with special W-component for operations with projection / model view matrices. Use this class for 3D-points carefully because declared W-component may results in incorrect results if used without matrices.
    """
    def ChangeData(self) -> str: ...
    def Dot(self,theOther : Graphic3d_Vec4b) -> str: 
        """
        Computes the dot product.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def GetData(self) -> str: 
        """
        Raw access to the data (for OpenGL exchange).
        """
    def IsEqual(self,theOther : Graphic3d_Vec4b) -> bool: 
        """
        Check this vector with another vector for equality (without tolerance!).
        """
    @staticmethod
    def Length_s() -> int: 
        """
        Returns the number of components.
        """
    def Multiplied(self,theFactor : str) -> Graphic3d_Vec4b: 
        """
        Compute per-component multiplication.
        """
    def Multiply(self,theFactor : str) -> None: 
        """
        Compute per-component multiplication.
        """
    @overload
    def SetValues(self,theX : str,theY : str,theZ : str,theW : str) -> None: 
        """
        Assign new values to the vector.

        Assign new values as 3-component vector and a 4-th value.
        """
    @overload
    def SetValues(self,theVec3 : Graphic3d_Vec3b,theW : str) -> None: ...
    def __iadd__(self,theAdd : Graphic3d_Vec4b) -> Graphic3d_Vec4b: 
        """
        Compute per-component summary.
        """
    @overload
    def __imul__(self,theRight : Graphic3d_Vec4b) -> Graphic3d_Vec4b: 
        """
        Compute per-component multiplication.

        Compute per-component multiplication.
        """
    @overload
    def __imul__(self,theFactor : str) -> Graphic3d_Vec4b: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theValue : str) -> None: ...
    @overload
    def __init__(self,theX : str,theY : str,theZ : str,theW : str) -> None: ...
    @overload
    def __init__(self,theVec2 : Graphic3d_Vec2b) -> None: ...
    @overload
    def __init__(self,theVec3 : Graphic3d_Vec3b,theW : str='\x00') -> None: ...
    def __isub__(self,theDec : Graphic3d_Vec4b) -> Graphic3d_Vec4b: 
        """
        Compute per-component subtraction.
        """
    @overload
    def __itruediv__(self,theInvFactor : str) -> Graphic3d_Vec4b: 
        """
        Compute per-component division by scale factor.

        Compute per-component division.
        """
    @overload
    def __itruediv__(self,theRight : Graphic3d_Vec4b) -> Graphic3d_Vec4b: ...
    def __mul__(self,theFactor : str) -> Graphic3d_Vec4b: 
        """
        Compute per-component multiplication.
        """
    def __rmul__(self,theFactor : str) -> Graphic3d_Vec4b: 
        """
        Compute per-component multiplication.
        """
    def __sub__(self) -> Graphic3d_Vec4b: 
        """
        Unary -.
        """
    def __truediv__(self,theInvFactor : str) -> Graphic3d_Vec4b: 
        """
        Compute per-component division by scale factor.
        """
    def a(self) -> str: 
        """
        Alias to 4th component as ALPHA channel in RGBA.

        Alias to 4th component as ALPHA channel in RGBA.
        """
    def b(self) -> str: 
        """
        Alias to 3rd component as BLUE channel in RGBA.

        Alias to 3rd component as BLUE channel in RGBA.
        """
    def bgr(self) -> Graphic3d_Vec3b: 
        """
        Returns RGB components as vector
        """
    def brg(self) -> Graphic3d_Vec3b: 
        """
        Returns RGB components as vector
        """
    def cwiseAbs(self) -> Graphic3d_Vec4b: 
        """
        Compute component-wise modulus of the vector.
        """
    def cwiseMax(self,theVec : Graphic3d_Vec4b) -> Graphic3d_Vec4b: 
        """
        Compute component-wise maximum of two vectors.
        """
    def cwiseMin(self,theVec : Graphic3d_Vec4b) -> Graphic3d_Vec4b: 
        """
        Compute component-wise minimum of two vectors.
        """
    def g(self) -> str: 
        """
        Alias to 2nd component as GREEN channel in RGBA.

        Alias to 2nd component as GREEN channel in RGBA.
        """
    def gbr(self) -> Graphic3d_Vec3b: 
        """
        Returns RGB components as vector
        """
    def grb(self) -> Graphic3d_Vec3b: 
        """
        Returns RGB components as vector
        """
    def maxComp(self) -> str: 
        """
        Compute maximum component of the vector.
        """
    def minComp(self) -> str: 
        """
        Compute minimum component of the vector.
        """
    def r(self) -> str: 
        """
        Alias to 1st component as RED channel in RGBA.

        Alias to 1st component as RED channel in RGBA.
        """
    def rbg(self) -> Graphic3d_Vec3b: 
        """
        Returns RGB components as vector
        """
    def rgb(self) -> Graphic3d_Vec3b: 
        """
        Returns RGB components as vector
        """
    def w(self) -> str: 
        """
        Alias to 4th component as W coordinate in XYZW.

        Alias to 4th component as W coordinate in XYZW.
        """
    def wx(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def wxy(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wxz(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wy(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def wyx(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wyz(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wz(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def wzx(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def wzy(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def x(self) -> str: 
        """
        Alias to 1st component as X coordinate in XYZW.

        Alias to 1st component as X coordinate in XYZW.
        """
    def xw(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def xwy(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xwz(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xy(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def xyw(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xyz(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xz(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def xzw(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def xzy(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def y(self) -> str: 
        """
        Alias to 2nd component as Y coordinate in XYZW.

        Alias to 2nd component as Y coordinate in XYZW.
        """
    def yw(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def ywx(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def ywz(self) -> Graphic3d_Vec3b: 
        """
        Returns 3 of XYZW components in specified order as vector in GLSL-style
        """
    def yx(self) -> Graphic3d_Vec2b: 
        """
        Returns 2 of XYZW components in specified order as vector in GLSL-style
        """
    def