
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Poly_Triangulation.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <Poly_Polygon3D.hxx>
#include <Poly_Polygon2D.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_Polygon3D.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_Polygon2D.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Triangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_Polygon2D.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Triangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <TopoDS_Face.hxx>
#include <TopLoc_Location.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>

// module includes
#include <BRep_Builder.hxx>
#include <BRep_Curve3D.hxx>
#include <BRep_CurveOn2Surfaces.hxx>
#include <BRep_CurveOnClosedSurface.hxx>
#include <BRep_CurveOnSurface.hxx>
#include <BRep_CurveRepresentation.hxx>
#include <BRep_GCurve.hxx>
#include <BRep_ListIteratorOfListOfCurveRepresentation.hxx>
#include <BRep_ListIteratorOfListOfPointRepresentation.hxx>
#include <BRep_ListOfCurveRepresentation.hxx>
#include <BRep_ListOfPointRepresentation.hxx>
#include <BRep_PointOnCurve.hxx>
#include <BRep_PointOnCurveOnSurface.hxx>
#include <BRep_PointOnSurface.hxx>
#include <BRep_PointRepresentation.hxx>
#include <BRep_PointsOnSurface.hxx>
#include <BRep_Polygon3D.hxx>
#include <BRep_PolygonOnClosedSurface.hxx>
#include <BRep_PolygonOnClosedTriangulation.hxx>
#include <BRep_PolygonOnSurface.hxx>
#include <BRep_PolygonOnTriangulation.hxx>
#include <BRep_TEdge.hxx>
#include <BRep_TFace.hxx>
#include <BRep_Tool.hxx>
#include <BRep_TVertex.hxx>

// template related includes

// ./opencascade/BRep_ListOfCurveRepresentation.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/BRep_ListOfCurveRepresentation.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/BRep_ListOfPointRepresentation.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/BRep_ListOfPointRepresentation.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BRep(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BRep"));
py::object klass;

//Python trampoline classes
    class Py_BRep_CurveRepresentation : public BRep_CurveRepresentation{
    public:
        using BRep_CurveRepresentation::BRep_CurveRepresentation;


        // public pure virtual
        handle<BRep_CurveRepresentation> Copy() const  override { using return_type = handle<BRep_CurveRepresentation>;
    PYBIND11_OVERLOAD_PURE(return_type,BRep_CurveRepresentation,Copy,) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_BRep_GCurve : public BRep_GCurve{
    public:
        using BRep_GCurve::BRep_GCurve;


        // public pure virtual
        void D0( const Standard_Real U,gp_Pnt & P) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,BRep_GCurve,D0,U,P) };

        handle<BRep_CurveRepresentation> Copy() const  override { using return_type = handle<BRep_CurveRepresentation>;
    PYBIND11_OVERLOAD_PURE(return_type,BRep_CurveRepresentation,Copy,) };

        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class BRep_Builder from ./opencascade/BRep_Builder.hxx
    klass = m.attr("BRep_Builder");

    // default constructor
    register_default_constructor<BRep_Builder , shared_ptr<BRep_Builder>>(m,"BRep_Builder");

    // nested enums

    static_cast<py::class_<BRep_Builder , shared_ptr<BRep_Builder>  , TopoDS_Builder >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("MakeFace",
             (void (BRep_Builder::*)( TopoDS_Face &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Face &  ) const>(&BRep_Builder::MakeFace),
             R"#(Makes an undefined Face.)#"  , py::arg("F")
          )
        .def("MakeFace",
             (void (BRep_Builder::*)( TopoDS_Face & ,   const handle<Geom_Surface> & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Face & ,   const handle<Geom_Surface> & ,   const Standard_Real  ) const>(&BRep_Builder::MakeFace),
             R"#(Makes a Face with a surface.)#"  , py::arg("F"),  py::arg("S"),  py::arg("Tol")
          )
        .def("MakeFace",
             (void (BRep_Builder::*)( TopoDS_Face & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Face & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const>(&BRep_Builder::MakeFace),
             R"#(Makes a Face with a surface and a location.)#"  , py::arg("F"),  py::arg("S"),  py::arg("L"),  py::arg("Tol")
          )
        .def("MakeFace",
             (void (BRep_Builder::*)( TopoDS_Face & ,   const handle<Poly_Triangulation> &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Face & ,   const handle<Poly_Triangulation> &  ) const>(&BRep_Builder::MakeFace),
             R"#(Makes a theFace with a single triangulation. The triangulation is in the same reference system than the TFace.)#"  , py::arg("theFace"),  py::arg("theTriangulation")
          )
        .def("MakeFace",
             (void (BRep_Builder::*)( TopoDS_Face & ,   const Poly_ListOfTriangulation & ,   const handle<Poly_Triangulation> &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Face & ,   const Poly_ListOfTriangulation & ,   const handle<Poly_Triangulation> &  ) const>(&BRep_Builder::MakeFace),
             R"#(Makes a Face with a list of triangulations and active one. Use NULL active triangulation to set the first triangulation in list as active. The triangulations is in the same reference system than the TFace.)#"  , py::arg("theFace"),  py::arg("theTriangulations"),  py::arg("theActiveTriangulation")=static_cast< const handle<Poly_Triangulation> &>(Handle ( Poly_Triangulation ) ( ))
          )
        .def("UpdateFace",
             (void (BRep_Builder::*)(  const TopoDS_Face & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Face & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateFace),
             R"#(Updates the face F using the tolerance value Tol, surface S and location Location.)#"  , py::arg("F"),  py::arg("S"),  py::arg("L"),  py::arg("Tol")
          )
        .def("UpdateFace",
             (void (BRep_Builder::*)(  const TopoDS_Face & ,   const handle<Poly_Triangulation> & ,   const Standard_Boolean  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Face & ,   const handle<Poly_Triangulation> & ,   const Standard_Boolean  ) const>(&BRep_Builder::UpdateFace),
             R"#(Changes a face triangulation. A NULL theTriangulation removes face triangulations. If theToReset is TRUE face triangulations will be reset to new list with only one input triangulation that will be active. Else if theTriangulation is contained in internal triangulations list it will be made active, else the active triangulation will be replaced to theTriangulation one.)#"  , py::arg("theFace"),  py::arg("theTriangulation"),  py::arg("theToReset")=static_cast< const Standard_Boolean>(true)
          )
        .def("UpdateFace",
             (void (BRep_Builder::*)(  const TopoDS_Face & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Face & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateFace),
             R"#(Updates the face Tolerance.)#"  , py::arg("F"),  py::arg("Tol")
          )
        .def("NaturalRestriction",
             (void (BRep_Builder::*)(  const TopoDS_Face & ,   const Standard_Boolean  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Face & ,   const Standard_Boolean  ) const>(&BRep_Builder::NaturalRestriction),
             R"#(Sets the NaturalRestriction flag of the face.)#"  , py::arg("F"),  py::arg("N")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge &  ) const>(&BRep_Builder::MakeEdge),
             R"#(Makes an undefined Edge (no geometry).)#"  , py::arg("E")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const Standard_Real  ) const>(&BRep_Builder::MakeEdge),
             R"#(Makes an Edge with a curve.)#"  , py::arg("E"),  py::arg("C"),  py::arg("Tol")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const TopLoc_Location & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const TopLoc_Location & ,   const Standard_Real  ) const>(&BRep_Builder::MakeEdge),
             R"#(Makes an Edge with a curve and a location.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_Polygon3D> &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_Polygon3D> &  ) const>(&BRep_Builder::MakeEdge),
             R"#(Makes an Edge with a polygon 3d.)#"  , py::arg("E"),  py::arg("P")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const>(&BRep_Builder::MakeEdge),
             R"#(makes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("N"),  py::arg("T")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const>(&BRep_Builder::MakeEdge),
             R"#(makes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("N"),  py::arg("T"),  py::arg("L")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets a 3D curve for the edge. If <C> is a null handle, remove any existing 3d curve.)#"  , py::arg("E"),  py::arg("C"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const TopLoc_Location & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const TopLoc_Location & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets a 3D curve for the edge. If <C> is a null handle, remove any existing 3d curve.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const TopoDS_Face & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const TopoDS_Face & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets a pcurve for the edge on the face. If <C> is a null handle, remove any existing pcurve.)#"  , py::arg("E"),  py::arg("C"),  py::arg("F"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom2d_Curve> & ,   const TopoDS_Face & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom2d_Curve> & ,   const TopoDS_Face & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets pcurves for the edge on the closed face. If <C1> or <C2> is a null handle, remove any existing pcurve.)#"  , py::arg("E"),  py::arg("C1"),  py::arg("C2"),  py::arg("F"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets a pcurve for the edge on the face. If <C> is a null handle, remove any existing pcurve.)#"  , py::arg("E"),  py::arg("C"),  py::arg("S"),  py::arg("L"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets a pcurve for the edge on the face. If <C> is a null handle, remove any existing pcurve. Sets UV bounds for curve repsentation)#"  , py::arg("E"),  py::arg("C"),  py::arg("S"),  py::arg("L"),  py::arg("Tol"),  py::arg("Pf"),  py::arg("Pl")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets pcurves for the edge on the closed surface. <C1> or <C2> is a null handle, remove any existing pcurve.)#"  , py::arg("E"),  py::arg("C1"),  py::arg("C2"),  py::arg("S"),  py::arg("L"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets pcurves for the edge on the closed surface. <C1> or <C2> is a null handle, remove any existing pcurve. Sets UV bounds for curve repsentation)#"  , py::arg("E"),  py::arg("C1"),  py::arg("C2"),  py::arg("S"),  py::arg("L"),  py::arg("Tol"),  py::arg("Pf"),  py::arg("Pl")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon3D> &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon3D> &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge 3D polygon. A null Polygon removes the 3d Polygon.)#"  , py::arg("E"),  py::arg("P")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon3D> & ,   const TopLoc_Location &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon3D> & ,   const TopLoc_Location &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge 3D polygon. A null Polygon removes the 3d Polygon.)#"  , py::arg("E"),  py::arg("P"),  py::arg("L")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("N"),  py::arg("T")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("N"),  py::arg("T"),  py::arg("L")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("N1"),  py::arg("N2"),  py::arg("T")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("N1"),  py::arg("N2"),  py::arg("T"),  py::arg("L")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon2D> & ,   const TopoDS_Face &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon2D> & ,   const TopoDS_Face &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes Edge polygon on a face.)#"  , py::arg("E"),  py::arg("P"),  py::arg("S")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon2D> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon2D> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes Edge polygon on a face.)#"  , py::arg("E"),  py::arg("P"),  py::arg("S"),  py::arg("T")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon2D> & ,   const handle<Poly_Polygon2D> & ,   const TopoDS_Face &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon2D> & ,   const handle<Poly_Polygon2D> & ,   const TopoDS_Face &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes Edge polygons on a face.)#"  , py::arg("E"),  py::arg("P1"),  py::arg("P2"),  py::arg("S")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon2D> & ,   const handle<Poly_Polygon2D> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon2D> & ,   const handle<Poly_Polygon2D> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes Edge polygons on a face.)#"  , py::arg("E"),  py::arg("P1"),  py::arg("P2"),  py::arg("S"),  py::arg("L")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Updates the edge tolerance.)#"  , py::arg("E"),  py::arg("Tol")
          )
        .def("Continuity",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const TopoDS_Face & ,   const GeomAbs_Shape  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const TopoDS_Face & ,   const GeomAbs_Shape  ) const>(&BRep_Builder::Continuity),
             R"#(Sets the geometric continuity on the edge.)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2"),  py::arg("C")
          )
        .def("Continuity",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location & ,   const GeomAbs_Shape  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location & ,   const GeomAbs_Shape  ) const>(&BRep_Builder::Continuity),
             R"#(Sets the geometric continuity on the edge.)#"  , py::arg("E"),  py::arg("S1"),  py::arg("S2"),  py::arg("L1"),  py::arg("L2"),  py::arg("C")
          )
        .def("SameParameter",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Boolean  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Boolean  ) const>(&BRep_Builder::SameParameter),
             R"#(Sets the same parameter flag for the edge <E>.)#"  , py::arg("E"),  py::arg("S")
          )
        .def("SameRange",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Boolean  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Boolean  ) const>(&BRep_Builder::SameRange),
             R"#(Sets the same range flag for the edge <E>.)#"  , py::arg("E"),  py::arg("S")
          )
        .def("Degenerated",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Boolean  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Boolean  ) const>(&BRep_Builder::Degenerated),
             R"#(Sets the degenerated flag for the edge <E>.)#"  , py::arg("E"),  py::arg("D")
          )
        .def("Range",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Boolean  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Boolean  ) const>(&BRep_Builder::Range),
             R"#(Sets the range of the 3d curve if Only3d=TRUE, otherwise sets the range to all the representations)#"  , py::arg("E"),  py::arg("First"),  py::arg("Last"),  py::arg("Only3d")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("Range",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real ,   const Standard_Real  ) const>(&BRep_Builder::Range),
             R"#(Sets the range of the edge on the pcurve on the surface.)#"  , py::arg("E"),  py::arg("S"),  py::arg("L"),  py::arg("First"),  py::arg("Last")
          )
        .def("Range",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const Standard_Real ,   const Standard_Real  ) const>(&BRep_Builder::Range),
             R"#(Sets the range of the edge on the pcurve on the face.)#"  , py::arg("E"),  py::arg("F"),  py::arg("First"),  py::arg("Last")
          )
        .def("Transfert",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Edge &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Edge &  ) const>(&BRep_Builder::Transfert),
             R"#(Add to <Eout> the geometric representations of <Ein>.)#"  , py::arg("Ein"),  py::arg("Eout")
          )
        .def("MakeVertex",
             (void (BRep_Builder::*)( TopoDS_Vertex &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Vertex &  ) const>(&BRep_Builder::MakeVertex),
             R"#(Makes an udefined vertex without geometry.)#"  , py::arg("V")
          )
        .def("MakeVertex",
             (void (BRep_Builder::*)( TopoDS_Vertex & ,   const gp_Pnt & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Vertex & ,   const gp_Pnt & ,   const Standard_Real  ) const>(&BRep_Builder::MakeVertex),
             R"#(Makes a vertex from a 3D point.)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("UpdateVertex",
             (void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const gp_Pnt & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const gp_Pnt & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateVertex),
             R"#(Sets a 3D point on the vertex.)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("UpdateVertex",
             (void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateVertex),
             R"#(Sets the parameter for the vertex on the edge curves.)#"  , py::arg("V"),  py::arg("P"),  py::arg("E"),  py::arg("Tol")
          )
        .def("UpdateVertex",
             (void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge & ,   const TopoDS_Face & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge & ,   const TopoDS_Face & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateVertex),
             R"#(Sets the parameter for the vertex on the edge pcurve on the face.)#"  , py::arg("V"),  py::arg("P"),  py::arg("E"),  py::arg("F"),  py::arg("Tol")
          )
        .def("UpdateVertex",
             (void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateVertex),
             R"#(Sets the parameter for the vertex on the edge pcurve on the surface.)#"  , py::arg("V"),  py::arg("P"),  py::arg("E"),  py::arg("S"),  py::arg("L"),  py::arg("Tol")
          )
        .def("UpdateVertex",
             (void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const Standard_Real ,   const TopoDS_Face & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const Standard_Real ,   const TopoDS_Face & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateVertex),
             R"#(Sets the parameters for the vertex on the face.)#"  , py::arg("Ve"),  py::arg("U"),  py::arg("V"),  py::arg("F"),  py::arg("Tol")
          )
        .def("UpdateVertex",
             (void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateVertex),
             R"#(Updates the vertex tolerance.)#"  , py::arg("V"),  py::arg("Tol")
          )
        .def("Transfert",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Edge & ,   const TopoDS_Vertex & ,   const TopoDS_Vertex &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Edge & ,   const TopoDS_Vertex & ,   const TopoDS_Vertex &  ) const>(&BRep_Builder::Transfert),
             R"#(Transfert the parameters of Vin on Ein as the parameter of Vout on Eout.)#"  , py::arg("Ein"),  py::arg("Eout"),  py::arg("Vin"),  py::arg("Vout")
          )
        .def("MakeFace",
             (void (BRep_Builder::*)( TopoDS_Face &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Face &  ) const>(&BRep_Builder::MakeFace),
             R"#(Makes an undefined Face.)#"  , py::arg("F")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const Standard_Real  ) const>(&BRep_Builder::MakeEdge),
             R"#(Makes an Edge with a curve.)#"  , py::arg("E"),  py::arg("C"),  py::arg("Tol")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_Polygon3D> &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_Polygon3D> &  ) const>(&BRep_Builder::MakeEdge),
             R"#(Makes an Edge with a polygon 3d.)#"  , py::arg("E"),  py::arg("P")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const>(&BRep_Builder::MakeEdge),
             R"#(makes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("P"),  py::arg("T")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const>(&BRep_Builder::MakeEdge),
             R"#(makes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("P"),  py::arg("T"),  py::arg("L")
          )
        .def("MakeEdge",
             (void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const TopLoc_Location & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const TopLoc_Location & ,   const Standard_Real  ) const>(&BRep_Builder::MakeEdge),
             R"#(Makes an Edge with a curve and a location.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom_Curve> & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets a 3D curve for the edge. If <C> is a null handle, remove any existing 3d curve.)#"  , py::arg("E"),  py::arg("C"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const TopoDS_Face & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const TopoDS_Face & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets a pcurve for the edge on the face. If <C> is a null handle, remove any existing pcurve.)#"  , py::arg("E"),  py::arg("C"),  py::arg("F"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom2d_Curve> & ,   const TopoDS_Face & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Geom2d_Curve> & ,   const handle<Geom2d_Curve> & ,   const TopoDS_Face & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Sets pcurves for the edge on the closed face. If <C1> or <C2> is a null handle, remove any existing pcurve.)#"  , py::arg("E"),  py::arg("C1"),  py::arg("C2"),  py::arg("F"),  py::arg("Tol")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon3D> &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_Polygon3D> &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge 3D polygon. A null Polygon removes the 3d Polygon.)#"  , py::arg("E"),  py::arg("P")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("P"),  py::arg("T")
          )
        .def("UpdateEdge",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_PolygonOnTriangulation> & ,   const handle<Poly_Triangulation> &  ) const>(&BRep_Builder::UpdateEdge),
             R"#(Changes an Edge polygon on Triangulation.)#"  , py::arg("E"),  py::arg("P1"),  py::arg("P2"),  py::arg("T")
          )
        .def("Range",
             (void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const Standard_Real ,   const Standard_Real  ) const>(&BRep_Builder::Range),
             R"#(Sets the range of the edge on the pcurve on the face.)#"  , py::arg("E"),  py::arg("F"),  py::arg("First"),  py::arg("Last")
          )
        .def("MakeVertex",
             (void (BRep_Builder::*)( TopoDS_Vertex &  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Vertex &  ) const>(&BRep_Builder::MakeVertex),
             R"#(Makes an udefined vertex without geometry.)#"  , py::arg("V")
          )
        .def("MakeVertex",
             (void (BRep_Builder::*)( TopoDS_Vertex & ,   const gp_Pnt & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)( TopoDS_Vertex & ,   const gp_Pnt & ,   const Standard_Real  ) const>(&BRep_Builder::MakeVertex),
             R"#(Makes a vertex from a 3D point.)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("UpdateVertex",
             (void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge & ,   const TopoDS_Face & ,   const Standard_Real  ) const) static_cast<void (BRep_Builder::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge & ,   const TopoDS_Face & ,   const Standard_Real  ) const>(&BRep_Builder::UpdateVertex),
             R"#(Sets the parameter for the vertex on the edge pcurve on the face.)#"  , py::arg("V"),  py::arg("Par"),  py::arg("E"),  py::arg("F"),  py::arg("Tol")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BRep_CurveRepresentation from ./opencascade/BRep_CurveRepresentation.hxx
    klass = m.attr("BRep_CurveRepresentation");


    // nested enums

    static_cast<py::class_<BRep_CurveRepresentation ,opencascade::handle<BRep_CurveRepresentation> ,Py_BRep_CurveRepresentation , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsCurve3D",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsCurve3D),
             R"#(A 3D curve representation.)#" 
          )
        .def("IsCurveOnSurface",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsCurveOnSurface),
             R"#(A curve in the parametric space of a surface.)#" 
          )
        .def("IsRegularity",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsRegularity),
             R"#(A continuity between two surfaces.)#" 
          )
        .def("IsCurveOnClosedSurface",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsCurveOnClosedSurface),
             R"#(A curve with two parametric curves on the same surface.)#" 
          )
        .def("IsCurveOnSurface",
             (Standard_Boolean (BRep_CurveRepresentation::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_CurveRepresentation::IsCurveOnSurface),
             R"#(Is it a curve in the parametric space of <S> with location <L>.)#"  , py::arg("S"),  py::arg("L")
          )
        .def("IsRegularity",
             (Standard_Boolean (BRep_CurveRepresentation::*)(  const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)(  const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) const>(&BRep_CurveRepresentation::IsRegularity),
             R"#(Is it a regularity between <S1> and <S2> with location <L1> and <L2>.)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("L1"),  py::arg("L2")
          )
        .def("IsPolygon3D",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsPolygon3D),
             R"#(A 3D polygon representation.)#" 
          )
        .def("IsPolygonOnTriangulation",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsPolygonOnTriangulation),
             R"#(A representation by an array of nodes on a triangulation.)#" 
          )
        .def("IsPolygonOnTriangulation",
             (Standard_Boolean (BRep_CurveRepresentation::*)(  const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)(  const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const>(&BRep_CurveRepresentation::IsPolygonOnTriangulation),
             R"#(Is it a polygon in the definition of <T> with location <L>.)#"  , py::arg("T"),  py::arg("L")
          )
        .def("IsPolygonOnClosedTriangulation",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsPolygonOnClosedTriangulation),
             R"#(A representation by two arrays of nodes on a triangulation.)#" 
          )
        .def("IsPolygonOnSurface",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsPolygonOnSurface),
             R"#(A polygon in the parametric space of a surface.)#" 
          )
        .def("IsPolygonOnSurface",
             (Standard_Boolean (BRep_CurveRepresentation::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_CurveRepresentation::IsPolygonOnSurface),
             R"#(Is it a polygon in the parametric space of <S> with location <L>.)#"  , py::arg("S"),  py::arg("L")
          )
        .def("IsPolygonOnClosedSurface",
             (Standard_Boolean (BRep_CurveRepresentation::*)() const) static_cast<Standard_Boolean (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::IsPolygonOnClosedSurface),
             R"#(Two 2D polygon representations in the parametric space of a surface.)#" 
          )
        .def("Location",
             (void (BRep_CurveRepresentation::*)(  const TopLoc_Location &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const TopLoc_Location &  ) >(&BRep_CurveRepresentation::Location),
             R"#()#"  , py::arg("L")
          )
        .def("Curve3D",
             (void (BRep_CurveRepresentation::*)(  const handle<Geom_Curve> &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const handle<Geom_Curve> &  ) >(&BRep_CurveRepresentation::Curve3D),
             R"#()#"  , py::arg("C")
          )
        .def("PCurve",
             (void (BRep_CurveRepresentation::*)(  const handle<Geom2d_Curve> &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const handle<Geom2d_Curve> &  ) >(&BRep_CurveRepresentation::PCurve),
             R"#()#"  , py::arg("C")
          )
        .def("PCurve2",
             (void (BRep_CurveRepresentation::*)(  const handle<Geom2d_Curve> &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const handle<Geom2d_Curve> &  ) >(&BRep_CurveRepresentation::PCurve2),
             R"#()#"  , py::arg("C")
          )
        .def("Polygon3D",
             (void (BRep_CurveRepresentation::*)(  const handle<Poly_Polygon3D> &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const handle<Poly_Polygon3D> &  ) >(&BRep_CurveRepresentation::Polygon3D),
             R"#()#"  , py::arg("P")
          )
        .def("Polygon",
             (void (BRep_CurveRepresentation::*)(  const handle<Poly_Polygon2D> &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const handle<Poly_Polygon2D> &  ) >(&BRep_CurveRepresentation::Polygon),
             R"#()#"  , py::arg("P")
          )
        .def("Polygon2",
             (void (BRep_CurveRepresentation::*)(  const handle<Poly_Polygon2D> &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const handle<Poly_Polygon2D> &  ) >(&BRep_CurveRepresentation::Polygon2),
             R"#()#"  , py::arg("P")
          )
        .def("PolygonOnTriangulation",
             (void (BRep_CurveRepresentation::*)(  const handle<Poly_PolygonOnTriangulation> &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const handle<Poly_PolygonOnTriangulation> &  ) >(&BRep_CurveRepresentation::PolygonOnTriangulation),
             R"#()#"  , py::arg("P")
          )
        .def("PolygonOnTriangulation2",
             (void (BRep_CurveRepresentation::*)(  const handle<Poly_PolygonOnTriangulation> &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const handle<Poly_PolygonOnTriangulation> &  ) >(&BRep_CurveRepresentation::PolygonOnTriangulation2),
             R"#()#"  , py::arg("P2")
          )
        .def("Continuity",
             (void (BRep_CurveRepresentation::*)(  const GeomAbs_Shape  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const GeomAbs_Shape  ) >(&BRep_CurveRepresentation::Continuity),
             R"#()#"  , py::arg("C")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_CurveRepresentation::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("DumpJson",
             (void (BRep_CurveRepresentation::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_CurveRepresentation::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_CurveRepresentation::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("Location",
             (void (BRep_CurveRepresentation::*)(  const TopLoc_Location &  ) ) static_cast<void (BRep_CurveRepresentation::*)(  const TopLoc_Location &  ) >(&BRep_CurveRepresentation::Location),
             R"#()#"  , py::arg("L")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_CurveRepresentation::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_CurveRepresentation::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Location",
             ( const TopLoc_Location & (BRep_CurveRepresentation::*)() const) static_cast< const TopLoc_Location & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Location),
             R"#()#"
             
         )
       .def("Curve3D",
             ( const handle<Geom_Curve> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Geom_Curve> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Curve3D),
             R"#()#"
             
         )
       .def("Surface",
             ( const handle<Geom_Surface> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Geom_Surface> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Surface),
             R"#()#"
             
         )
       .def("PCurve",
             ( const handle<Geom2d_Curve> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Geom2d_Curve> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::PCurve),
             R"#()#"
             
         )
       .def("PCurve2",
             ( const handle<Geom2d_Curve> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Geom2d_Curve> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::PCurve2),
             R"#()#"
             
         )
       .def("Polygon3D",
             ( const handle<Poly_Polygon3D> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Poly_Polygon3D> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Polygon3D),
             R"#()#"
             
         )
       .def("Polygon",
             ( const handle<Poly_Polygon2D> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Poly_Polygon2D> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Polygon),
             R"#()#"
             
         )
       .def("Polygon2",
             ( const handle<Poly_Polygon2D> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Poly_Polygon2D> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Polygon2),
             R"#()#"
             
         )
       .def("Triangulation",
             ( const handle<Poly_Triangulation> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Poly_Triangulation> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Triangulation),
             R"#()#"
             
         )
       .def("PolygonOnTriangulation",
             ( const handle<Poly_PolygonOnTriangulation> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Poly_PolygonOnTriangulation> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::PolygonOnTriangulation),
             R"#()#"
             
         )
       .def("PolygonOnTriangulation2",
             ( const handle<Poly_PolygonOnTriangulation> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Poly_PolygonOnTriangulation> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::PolygonOnTriangulation2),
             R"#()#"
             
         )
       .def("Surface2",
             ( const handle<Geom_Surface> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Geom_Surface> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Surface2),
             R"#()#"
             
         )
       .def("Location2",
             ( const TopLoc_Location & (BRep_CurveRepresentation::*)() const) static_cast< const TopLoc_Location & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Location2),
             R"#()#"
             
         )
       .def("Continuity",
             ( const GeomAbs_Shape & (BRep_CurveRepresentation::*)() const) static_cast< const GeomAbs_Shape & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Continuity),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_CurveRepresentation::*)() const) static_cast< const handle<Standard_Type> & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::DynamicType),
             R"#()#"
             
         )
       .def("Location",
             ( const TopLoc_Location & (BRep_CurveRepresentation::*)() const) static_cast< const TopLoc_Location & (BRep_CurveRepresentation::*)() const>(&BRep_CurveRepresentation::Location),
             R"#()#"
             
         )
;

    // Class BRep_PointRepresentation from ./opencascade/BRep_PointRepresentation.hxx
    klass = m.attr("BRep_PointRepresentation");


    // nested enums

    static_cast<py::class_<BRep_PointRepresentation ,opencascade::handle<BRep_PointRepresentation>  , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsPointOnCurve",
             (Standard_Boolean (BRep_PointRepresentation::*)() const) static_cast<Standard_Boolean (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::IsPointOnCurve),
             R"#(A point on a 3d curve.)#" 
          )
        .def("IsPointOnCurveOnSurface",
             (Standard_Boolean (BRep_PointRepresentation::*)() const) static_cast<Standard_Boolean (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::IsPointOnCurveOnSurface),
             R"#(A point on a 2d curve on a surface.)#" 
          )
        .def("IsPointOnSurface",
             (Standard_Boolean (BRep_PointRepresentation::*)() const) static_cast<Standard_Boolean (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::IsPointOnSurface),
             R"#(A point on a surface.)#" 
          )
        .def("IsPointOnCurve",
             (Standard_Boolean (BRep_PointRepresentation::*)(  const handle<Geom_Curve> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_PointRepresentation::*)(  const handle<Geom_Curve> & ,   const TopLoc_Location &  ) const>(&BRep_PointRepresentation::IsPointOnCurve),
             R"#(A point on the curve <C>.)#"  , py::arg("C"),  py::arg("L")
          )
        .def("IsPointOnCurveOnSurface",
             (Standard_Boolean (BRep_PointRepresentation::*)(  const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_PointRepresentation::*)(  const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_PointRepresentation::IsPointOnCurveOnSurface),
             R"#(A point on the 2d curve <PC> on the surface <S>.)#"  , py::arg("PC"),  py::arg("S"),  py::arg("L")
          )
        .def("IsPointOnSurface",
             (Standard_Boolean (BRep_PointRepresentation::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_PointRepresentation::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_PointRepresentation::IsPointOnSurface),
             R"#(A point on the surface <S>.)#"  , py::arg("S"),  py::arg("L")
          )
        .def("Location",
             (void (BRep_PointRepresentation::*)(  const TopLoc_Location &  ) ) static_cast<void (BRep_PointRepresentation::*)(  const TopLoc_Location &  ) >(&BRep_PointRepresentation::Location),
             R"#()#"  , py::arg("L")
          )
        .def("Parameter",
             (Standard_Real (BRep_PointRepresentation::*)() const) static_cast<Standard_Real (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::Parameter),
             R"#()#" 
          )
        .def("Parameter",
             (void (BRep_PointRepresentation::*)(  const Standard_Real  ) ) static_cast<void (BRep_PointRepresentation::*)(  const Standard_Real  ) >(&BRep_PointRepresentation::Parameter),
             R"#()#"  , py::arg("P")
          )
        .def("Parameter2",
             (Standard_Real (BRep_PointRepresentation::*)() const) static_cast<Standard_Real (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::Parameter2),
             R"#()#" 
          )
        .def("Parameter2",
             (void (BRep_PointRepresentation::*)(  const Standard_Real  ) ) static_cast<void (BRep_PointRepresentation::*)(  const Standard_Real  ) >(&BRep_PointRepresentation::Parameter2),
             R"#()#"  , py::arg("P")
          )
        .def("Curve",
             (void (BRep_PointRepresentation::*)(  const handle<Geom_Curve> &  ) ) static_cast<void (BRep_PointRepresentation::*)(  const handle<Geom_Curve> &  ) >(&BRep_PointRepresentation::Curve),
             R"#()#"  , py::arg("C")
          )
        .def("PCurve",
             (void (BRep_PointRepresentation::*)(  const handle<Geom2d_Curve> &  ) ) static_cast<void (BRep_PointRepresentation::*)(  const handle<Geom2d_Curve> &  ) >(&BRep_PointRepresentation::PCurve),
             R"#()#"  , py::arg("C")
          )
        .def("Surface",
             (void (BRep_PointRepresentation::*)(  const handle<Geom_Surface> &  ) ) static_cast<void (BRep_PointRepresentation::*)(  const handle<Geom_Surface> &  ) >(&BRep_PointRepresentation::Surface),
             R"#()#"  , py::arg("S")
          )
        .def("DumpJson",
             (void (BRep_PointRepresentation::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_PointRepresentation::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_PointRepresentation::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("Location",
             (void (BRep_PointRepresentation::*)(  const TopLoc_Location &  ) ) static_cast<void (BRep_PointRepresentation::*)(  const TopLoc_Location &  ) >(&BRep_PointRepresentation::Location),
             R"#()#"  , py::arg("L")
          )
        .def("Parameter",
             (Standard_Real (BRep_PointRepresentation::*)() const) static_cast<Standard_Real (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::Parameter),
             R"#()#" 
          )
        .def("Parameter",
             (void (BRep_PointRepresentation::*)(  const Standard_Real  ) ) static_cast<void (BRep_PointRepresentation::*)(  const Standard_Real  ) >(&BRep_PointRepresentation::Parameter),
             R"#()#"  , py::arg("P")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PointRepresentation::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PointRepresentation::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Location",
             ( const TopLoc_Location & (BRep_PointRepresentation::*)() const) static_cast< const TopLoc_Location & (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::Location),
             R"#()#"
             
         )
       .def("Curve",
             ( const handle<Geom_Curve> & (BRep_PointRepresentation::*)() const) static_cast< const handle<Geom_Curve> & (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::Curve),
             R"#()#"
             
         )
       .def("PCurve",
             ( const handle<Geom2d_Curve> & (BRep_PointRepresentation::*)() const) static_cast< const handle<Geom2d_Curve> & (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::PCurve),
             R"#()#"
             
         )
       .def("Surface",
             ( const handle<Geom_Surface> & (BRep_PointRepresentation::*)() const) static_cast< const handle<Geom_Surface> & (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::Surface),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PointRepresentation::*)() const) static_cast< const handle<Standard_Type> & (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::DynamicType),
             R"#()#"
             
         )
       .def("Location",
             ( const TopLoc_Location & (BRep_PointRepresentation::*)() const) static_cast< const TopLoc_Location & (BRep_PointRepresentation::*)() const>(&BRep_PointRepresentation::Location),
             R"#()#"
             
         )
;

    // Class BRep_TEdge from ./opencascade/BRep_TEdge.hxx
    klass = m.attr("BRep_TEdge");


    // nested enums

    static_cast<py::class_<BRep_TEdge ,opencascade::handle<BRep_TEdge>  , TopoDS_TEdge >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Tolerance",
             (Standard_Real (BRep_TEdge::*)() const) static_cast<Standard_Real (BRep_TEdge::*)() const>(&BRep_TEdge::Tolerance),
             R"#()#" 
          )
        .def("Tolerance",
             (void (BRep_TEdge::*)(  const Standard_Real  ) ) static_cast<void (BRep_TEdge::*)(  const Standard_Real  ) >(&BRep_TEdge::Tolerance),
             R"#()#"  , py::arg("T")
          )
        .def("UpdateTolerance",
             (void (BRep_TEdge::*)(  const Standard_Real  ) ) static_cast<void (BRep_TEdge::*)(  const Standard_Real  ) >(&BRep_TEdge::UpdateTolerance),
             R"#(Sets the tolerance to the max of <T> and the current tolerance.)#"  , py::arg("T")
          )
        .def("SameParameter",
             (Standard_Boolean (BRep_TEdge::*)() const) static_cast<Standard_Boolean (BRep_TEdge::*)() const>(&BRep_TEdge::SameParameter),
             R"#()#" 
          )
        .def("SameParameter",
             (void (BRep_TEdge::*)(  const Standard_Boolean  ) ) static_cast<void (BRep_TEdge::*)(  const Standard_Boolean  ) >(&BRep_TEdge::SameParameter),
             R"#()#"  , py::arg("S")
          )
        .def("SameRange",
             (Standard_Boolean (BRep_TEdge::*)() const) static_cast<Standard_Boolean (BRep_TEdge::*)() const>(&BRep_TEdge::SameRange),
             R"#()#" 
          )
        .def("SameRange",
             (void (BRep_TEdge::*)(  const Standard_Boolean  ) ) static_cast<void (BRep_TEdge::*)(  const Standard_Boolean  ) >(&BRep_TEdge::SameRange),
             R"#()#"  , py::arg("S")
          )
        .def("Degenerated",
             (Standard_Boolean (BRep_TEdge::*)() const) static_cast<Standard_Boolean (BRep_TEdge::*)() const>(&BRep_TEdge::Degenerated),
             R"#()#" 
          )
        .def("Degenerated",
             (void (BRep_TEdge::*)(  const Standard_Boolean  ) ) static_cast<void (BRep_TEdge::*)(  const Standard_Boolean  ) >(&BRep_TEdge::Degenerated),
             R"#()#"  , py::arg("S")
          )
        .def("EmptyCopy",
             (handle<TopoDS_TShape> (BRep_TEdge::*)() const) static_cast<handle<TopoDS_TShape> (BRep_TEdge::*)() const>(&BRep_TEdge::EmptyCopy),
             R"#(Returns a copy of the TShape with no sub-shapes.)#" 
          )
        .def("DumpJson",
             (void (BRep_TEdge::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_TEdge::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_TEdge::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("Tolerance",
             (Standard_Real (BRep_TEdge::*)() const) static_cast<Standard_Real (BRep_TEdge::*)() const>(&BRep_TEdge::Tolerance),
             R"#()#" 
          )
        .def("Tolerance",
             (void (BRep_TEdge::*)(  const Standard_Real  ) ) static_cast<void (BRep_TEdge::*)(  const Standard_Real  ) >(&BRep_TEdge::Tolerance),
             R"#()#"  , py::arg("T")
          )
        .def("UpdateTolerance",
             (void (BRep_TEdge::*)(  const Standard_Real  ) ) static_cast<void (BRep_TEdge::*)(  const Standard_Real  ) >(&BRep_TEdge::UpdateTolerance),
             R"#(Sets the tolerance to the max of <T> and the current tolerance.)#"  , py::arg("T")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_TEdge::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_TEdge::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Curves",
             ( const BRep_ListOfCurveRepresentation & (BRep_TEdge::*)() const) static_cast< const BRep_ListOfCurveRepresentation & (BRep_TEdge::*)() const>(&BRep_TEdge::Curves),
             R"#()#"
             
         )
       .def("ChangeCurves",
             (BRep_ListOfCurveRepresentation & (BRep_TEdge::*)() ) static_cast<BRep_ListOfCurveRepresentation & (BRep_TEdge::*)() >(&BRep_TEdge::ChangeCurves),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_TEdge::*)() const) static_cast< const handle<Standard_Type> & (BRep_TEdge::*)() const>(&BRep_TEdge::DynamicType),
             R"#()#"
             
         )
       .def("Curves",
             ( const BRep_ListOfCurveRepresentation & (BRep_TEdge::*)() const) static_cast< const BRep_ListOfCurveRepresentation & (BRep_TEdge::*)() const>(&BRep_TEdge::Curves),
             R"#()#"
             
         )
       .def("ChangeCurves",
             (BRep_ListOfCurveRepresentation & (BRep_TEdge::*)() ) static_cast<BRep_ListOfCurveRepresentation & (BRep_TEdge::*)() >(&BRep_TEdge::ChangeCurves),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class BRep_TFace from ./opencascade/BRep_TFace.hxx
    klass = m.attr("BRep_TFace");


    // nested enums

    static_cast<py::class_<BRep_TFace ,opencascade::handle<BRep_TFace>  , TopoDS_TFace >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Surface",
             (void (BRep_TFace::*)(  const handle<Geom_Surface> &  ) ) static_cast<void (BRep_TFace::*)(  const handle<Geom_Surface> &  ) >(&BRep_TFace::Surface),
             R"#(Sets surface for this face.)#"  , py::arg("theSurface")
          )
        .def("Location",
             (void (BRep_TFace::*)(  const TopLoc_Location &  ) ) static_cast<void (BRep_TFace::*)(  const TopLoc_Location &  ) >(&BRep_TFace::Location),
             R"#(Sets the location for this face.)#"  , py::arg("theLocation")
          )
        .def("Tolerance",
             (Standard_Real (BRep_TFace::*)() const) static_cast<Standard_Real (BRep_TFace::*)() const>(&BRep_TFace::Tolerance),
             R"#(Returns the face tolerance.)#" 
          )
        .def("Tolerance",
             (void (BRep_TFace::*)(  const Standard_Real  ) ) static_cast<void (BRep_TFace::*)(  const Standard_Real  ) >(&BRep_TFace::Tolerance),
             R"#(Sets the tolerance for this face.)#"  , py::arg("theTolerance")
          )
        .def("NaturalRestriction",
             (Standard_Boolean (BRep_TFace::*)() const) static_cast<Standard_Boolean (BRep_TFace::*)() const>(&BRep_TFace::NaturalRestriction),
             R"#(Returns TRUE if the boundary of this face is known to be the parametric space (Umin, UMax, VMin, VMax).)#" 
          )
        .def("NaturalRestriction",
             (void (BRep_TFace::*)(  const Standard_Boolean  ) ) static_cast<void (BRep_TFace::*)(  const Standard_Boolean  ) >(&BRep_TFace::NaturalRestriction),
             R"#(Sets the flag that is TRUE if the boundary of this face is known to be the parametric space.)#"  , py::arg("theRestriction")
          )
        .def("Triangulation",
             ( const handle<Poly_Triangulation> & (BRep_TFace::*)(  const Poly_MeshPurpose  ) const) static_cast< const handle<Poly_Triangulation> & (BRep_TFace::*)(  const Poly_MeshPurpose  ) const>(&BRep_TFace::Triangulation),
             R"#(Returns the triangulation of this face according to the mesh purpose.)#"  , py::arg("thePurpose")=static_cast< const Poly_MeshPurpose>(Poly_MeshPurpose_NONE)
          )
        .def("Triangulation",
             (void (BRep_TFace::*)(  const handle<Poly_Triangulation> & ,   const Standard_Boolean  ) ) static_cast<void (BRep_TFace::*)(  const handle<Poly_Triangulation> & ,   const Standard_Boolean  ) >(&BRep_TFace::Triangulation),
             R"#(Sets input triangulation for this face.)#"  , py::arg("theTriangulation"),  py::arg("theToReset")=static_cast< const Standard_Boolean>(true)
          )
        .def("EmptyCopy",
             (handle<TopoDS_TShape> (BRep_TFace::*)() const) static_cast<handle<TopoDS_TShape> (BRep_TFace::*)() const>(&BRep_TFace::EmptyCopy),
             R"#(Returns a copy of the TShape with no sub-shapes. The new Face has no triangulation.)#" 
          )
        .def("DumpJson",
             (void (BRep_TFace::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_TFace::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_TFace::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("Triangulations",
             (void (BRep_TFace::*)(  const Poly_ListOfTriangulation & ,   const handle<Poly_Triangulation> &  ) ) static_cast<void (BRep_TFace::*)(  const Poly_ListOfTriangulation & ,   const handle<Poly_Triangulation> &  ) >(&BRep_TFace::Triangulations),
             R"#(Sets input list of triangulations and currently active triangulation for this face. If list is empty internal list of triangulations will be cleared and active triangulation will be nullified. Else this list will be saved and the input active triangulation be saved as active. Use NULL active triangulation to set the first triangulation in list as active. Note: the method throws exception if there is any NULL triangulation in input list or if this list doesn't contain input active triangulation.)#"  , py::arg("theTriangulations"),  py::arg("theActiveTriangulation")
          )
        .def("NbTriangulations",
             (Standard_Integer (BRep_TFace::*)() const) static_cast<Standard_Integer (BRep_TFace::*)() const>(&BRep_TFace::NbTriangulations),
             R"#(Returns number of available face triangulations.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_TFace::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_TFace::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Surface",
             ( const handle<Geom_Surface> & (BRep_TFace::*)() const) static_cast< const handle<Geom_Surface> & (BRep_TFace::*)() const>(&BRep_TFace::Surface),
             R"#(Returns face surface.)#"
             
         )
       .def("Location",
             ( const TopLoc_Location & (BRep_TFace::*)() const) static_cast< const TopLoc_Location & (BRep_TFace::*)() const>(&BRep_TFace::Location),
             R"#(Returns the face location.)#"
             
         )
       .def("Triangulations",
             ( const Poly_ListOfTriangulation & (BRep_TFace::*)() const) static_cast< const Poly_ListOfTriangulation & (BRep_TFace::*)() const>(&BRep_TFace::Triangulations),
             R"#(Returns the list of available face triangulations.)#"
             
         )
       .def("ActiveTriangulation",
             ( const handle<Poly_Triangulation> & (BRep_TFace::*)() const) static_cast< const handle<Poly_Triangulation> & (BRep_TFace::*)() const>(&BRep_TFace::ActiveTriangulation),
             R"#(Returns current active triangulation.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_TFace::*)() const) static_cast< const handle<Standard_Type> & (BRep_TFace::*)() const>(&BRep_TFace::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_TVertex from ./opencascade/BRep_TVertex.hxx
    klass = m.attr("BRep_TVertex");


    // nested enums

    static_cast<py::class_<BRep_TVertex ,opencascade::handle<BRep_TVertex>  , TopoDS_TVertex >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Tolerance",
             (Standard_Real (BRep_TVertex::*)() const) static_cast<Standard_Real (BRep_TVertex::*)() const>(&BRep_TVertex::Tolerance),
             R"#()#" 
          )
        .def("Tolerance",
             (void (BRep_TVertex::*)(  const Standard_Real  ) ) static_cast<void (BRep_TVertex::*)(  const Standard_Real  ) >(&BRep_TVertex::Tolerance),
             R"#()#"  , py::arg("T")
          )
        .def("UpdateTolerance",
             (void (BRep_TVertex::*)(  const Standard_Real  ) ) static_cast<void (BRep_TVertex::*)(  const Standard_Real  ) >(&BRep_TVertex::UpdateTolerance),
             R"#(Sets the tolerance to the max of <T> and the current tolerance.)#"  , py::arg("T")
          )
        .def("Pnt",
             (void (BRep_TVertex::*)(  const gp_Pnt &  ) ) static_cast<void (BRep_TVertex::*)(  const gp_Pnt &  ) >(&BRep_TVertex::Pnt),
             R"#()#"  , py::arg("P")
          )
        .def("EmptyCopy",
             (handle<TopoDS_TShape> (BRep_TVertex::*)() const) static_cast<handle<TopoDS_TShape> (BRep_TVertex::*)() const>(&BRep_TVertex::EmptyCopy),
             R"#(Returns a copy of the TShape with no sub-shapes.)#" 
          )
        .def("DumpJson",
             (void (BRep_TVertex::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_TVertex::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_TVertex::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("Tolerance",
             (Standard_Real (BRep_TVertex::*)() const) static_cast<Standard_Real (BRep_TVertex::*)() const>(&BRep_TVertex::Tolerance),
             R"#()#" 
          )
        .def("Tolerance",
             (void (BRep_TVertex::*)(  const Standard_Real  ) ) static_cast<void (BRep_TVertex::*)(  const Standard_Real  ) >(&BRep_TVertex::Tolerance),
             R"#()#"  , py::arg("T")
          )
        .def("UpdateTolerance",
             (void (BRep_TVertex::*)(  const Standard_Real  ) ) static_cast<void (BRep_TVertex::*)(  const Standard_Real  ) >(&BRep_TVertex::UpdateTolerance),
             R"#(Sets the tolerance to the max of <T> and the current tolerance.)#"  , py::arg("T")
          )
        .def("Pnt",
             (void (BRep_TVertex::*)(  const gp_Pnt &  ) ) static_cast<void (BRep_TVertex::*)(  const gp_Pnt &  ) >(&BRep_TVertex::Pnt),
             R"#()#"  , py::arg("P")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_TVertex::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_TVertex::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Pnt",
             ( const gp_Pnt & (BRep_TVertex::*)() const) static_cast< const gp_Pnt & (BRep_TVertex::*)() const>(&BRep_TVertex::Pnt),
             R"#()#"
             
         )
       .def("Points",
             ( const BRep_ListOfPointRepresentation & (BRep_TVertex::*)() const) static_cast< const BRep_ListOfPointRepresentation & (BRep_TVertex::*)() const>(&BRep_TVertex::Points),
             R"#()#"
             
         )
       .def("ChangePoints",
             (BRep_ListOfPointRepresentation & (BRep_TVertex::*)() ) static_cast<BRep_ListOfPointRepresentation & (BRep_TVertex::*)() >(&BRep_TVertex::ChangePoints),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_TVertex::*)() const) static_cast< const handle<Standard_Type> & (BRep_TVertex::*)() const>(&BRep_TVertex::DynamicType),
             R"#()#"
             
         )
       .def("Pnt",
             ( const gp_Pnt & (BRep_TVertex::*)() const) static_cast< const gp_Pnt & (BRep_TVertex::*)() const>(&BRep_TVertex::Pnt),
             R"#()#"
             
         )
       .def("Points",
             ( const BRep_ListOfPointRepresentation & (BRep_TVertex::*)() const) static_cast< const BRep_ListOfPointRepresentation & (BRep_TVertex::*)() const>(&BRep_TVertex::Points),
             R"#()#"
             
         )
       .def("ChangePoints",
             (BRep_ListOfPointRepresentation & (BRep_TVertex::*)() ) static_cast<BRep_ListOfPointRepresentation & (BRep_TVertex::*)() >(&BRep_TVertex::ChangePoints),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class BRep_Tool from ./opencascade/BRep_Tool.hxx
    klass = m.attr("BRep_Tool");

    // default constructor
    register_default_constructor<BRep_Tool , shared_ptr<BRep_Tool>>(m,"BRep_Tool");

    // nested enums

    static_cast<py::class_<BRep_Tool , shared_ptr<BRep_Tool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsClosed_s",
                    (Standard_Boolean (*)(  const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Shape &  ) >(&BRep_Tool::IsClosed),
                    R"#(If S is Shell, returns True if it has no free boundaries (edges). If S is Wire, returns True if it has no free ends (vertices). (Internal and External sub-shepes are ignored in these checks) If S is Edge, returns True if its vertices are the same. For other shape types returns S.Closed().)#"  , py::arg("S")
          )
        .def_static("Surface_s",
                    ( const handle<Geom_Surface> & (*)(  const TopoDS_Face & ,  TopLoc_Location &  ) ) static_cast< const handle<Geom_Surface> & (*)(  const TopoDS_Face & ,  TopLoc_Location &  ) >(&BRep_Tool::Surface),
                    R"#(Returns the geometric surface of the face. Returns in <L> the location for the surface.)#"  , py::arg("F"),  py::arg("L")
          )
        .def_static("Surface_s",
                    (handle<Geom_Surface> (*)(  const TopoDS_Face &  ) ) static_cast<handle<Geom_Surface> (*)(  const TopoDS_Face &  ) >(&BRep_Tool::Surface),
                    R"#(Returns the geometric surface of the face. It can be a copy if there is a Location.)#"  , py::arg("F")
          )
        .def_static("Triangulation_s",
                    ( const handle<Poly_Triangulation> & (*)(  const TopoDS_Face & ,  TopLoc_Location & ,   const Poly_MeshPurpose  ) ) static_cast< const handle<Poly_Triangulation> & (*)(  const TopoDS_Face & ,  TopLoc_Location & ,   const Poly_MeshPurpose  ) >(&BRep_Tool::Triangulation),
                    R"#(Returns the triangulation of the face according to the mesh purpose.)#"  , py::arg("theFace"),  py::arg("theLocation"),  py::arg("theMeshPurpose")=static_cast< const Poly_MeshPurpose>(Poly_MeshPurpose_NONE)
          )
        .def_static("Triangulations_s",
                    ( const Poly_ListOfTriangulation & (*)(  const TopoDS_Face & ,  TopLoc_Location &  ) ) static_cast< const Poly_ListOfTriangulation & (*)(  const TopoDS_Face & ,  TopLoc_Location &  ) >(&BRep_Tool::Triangulations),
                    R"#(Returns all triangulations of the face.)#"  , py::arg("theFace"),  py::arg("theLocation")
          )
        .def_static("Tolerance_s",
                    (Standard_Real (*)(  const TopoDS_Face &  ) ) static_cast<Standard_Real (*)(  const TopoDS_Face &  ) >(&BRep_Tool::Tolerance),
                    R"#(Returns the tolerance of the face.)#"  , py::arg("F")
          )
        .def_static("NaturalRestriction_s",
                    (Standard_Boolean (*)(  const TopoDS_Face &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Face &  ) >(&BRep_Tool::NaturalRestriction),
                    R"#(Returns the NaturalRestriction flag of the face.)#"  , py::arg("F")
          )
        .def_static("IsGeometric_s",
                    (Standard_Boolean (*)(  const TopoDS_Face &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Face &  ) >(&BRep_Tool::IsGeometric),
                    R"#(Returns True if <F> has a surface, false otherwise.)#"  , py::arg("F")
          )
        .def_static("IsGeometric_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge &  ) >(&BRep_Tool::IsGeometric),
                    R"#(Returns True if <E> is a 3d curve or a curve on surface.)#"  , py::arg("E")
          )
        .def_static("Curve_s",
                    ( const handle<Geom_Curve> & (*)(  const TopoDS_Edge & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast< const handle<Geom_Curve> & (*)(  const TopoDS_Edge & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Real &  ) >(&BRep_Tool::Curve),
                    R"#(Returns the 3D curve of the edge. May be a Null handle. Returns in <L> the location for the curve. In <First> and <Last> the parameter range.)#"  , py::arg("E"),  py::arg("L"),  py::arg("First"),  py::arg("Last")
          )
        .def_static("Curve_s",
                    (handle<Geom_Curve> (*)(  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<handle<Geom_Curve> (*)(  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) >(&BRep_Tool::Curve),
                    R"#(Returns the 3D curve of the edge. May be a Null handle. In <First> and <Last> the parameter range. It can be a copy if there is a Location.)#"  , py::arg("E"),  py::arg("First"),  py::arg("Last")
          )
        .def_static("Polygon3D_s",
                    ( const handle<Poly_Polygon3D> & (*)(  const TopoDS_Edge & ,  TopLoc_Location &  ) ) static_cast< const handle<Poly_Polygon3D> & (*)(  const TopoDS_Edge & ,  TopLoc_Location &  ) >(&BRep_Tool::Polygon3D),
                    R"#(Returns the 3D polygon of the edge. May be a Null handle. Returns in <L> the location for the polygon.)#"  , py::arg("E"),  py::arg("L")
          )
        .def_static("CurveOnSurface_s",
                    (handle<Geom2d_Curve> (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,  Standard_Real & ,  Standard_Real & ,  Standard_Boolean *  ) ) static_cast<handle<Geom2d_Curve> (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,  Standard_Real & ,  Standard_Real & ,  Standard_Boolean *  ) >(&BRep_Tool::CurveOnSurface),
                    R"#(Returns the curve associated to the edge in the parametric space of the face. Returns a NULL handle if this curve does not exist. Returns in <First> and <Last> the parameter range. If the surface is a plane the curve can be not stored but created a new each time. The flag pointed by <theIsStored> serves to indicate storage status. It is valued if the pointer is non-null.)#"  , py::arg("E"),  py::arg("F"),  py::arg("First"),  py::arg("Last"),  py::arg("theIsStored")=static_cast<Standard_Boolean *>(NULL)
          )
        .def_static("CurveOnSurface_s",
                    (handle<Geom2d_Curve> (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,  Standard_Real & ,  Standard_Real & ,  Standard_Boolean *  ) ) static_cast<handle<Geom2d_Curve> (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,  Standard_Real & ,  Standard_Real & ,  Standard_Boolean *  ) >(&BRep_Tool::CurveOnSurface),
                    R"#(Returns the curve associated to the edge in the parametric space of the surface. Returns a NULL handle if this curve does not exist. Returns in <First> and <Last> the parameter range. If the surface is a plane the curve can be not stored but created a new each time. The flag pointed by <theIsStored> serves to indicate storage status. It is valued if the pointer is non-null.)#"  , py::arg("E"),  py::arg("S"),  py::arg("L"),  py::arg("First"),  py::arg("Last"),  py::arg("theIsStored")=static_cast<Standard_Boolean *>(NULL)
          )
        .def_static("CurveOnPlane_s",
                    (handle<Geom2d_Curve> (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<handle<Geom2d_Curve> (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,  Standard_Real & ,  Standard_Real &  ) >(&BRep_Tool::CurveOnPlane),
                    R"#(For the planar surface builds the 2d curve for the edge by projection of the edge on plane. Returns a NULL handle if the surface is not planar or the projection failed.)#"  , py::arg("E"),  py::arg("S"),  py::arg("L"),  py::arg("First"),  py::arg("Last")
          )
        .def_static("PolygonOnSurface_s",
                    (handle<Poly_Polygon2D> (*)(  const TopoDS_Edge & ,   const TopoDS_Face &  ) ) static_cast<handle<Poly_Polygon2D> (*)(  const TopoDS_Edge & ,   const TopoDS_Face &  ) >(&BRep_Tool::PolygonOnSurface),
                    R"#(Returns the polygon associated to the edge in the parametric space of the face. Returns a NULL handle if this polygon does not exist.)#"  , py::arg("E"),  py::arg("F")
          )
        .def_static("PolygonOnSurface_s",
                    (handle<Poly_Polygon2D> (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) ) static_cast<handle<Poly_Polygon2D> (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) >(&BRep_Tool::PolygonOnSurface),
                    R"#(Returns the polygon associated to the edge in the parametric space of the surface. Returns a NULL handle if this polygon does not exist.)#"  , py::arg("E"),  py::arg("S"),  py::arg("L")
          )
        .def_static("PolygonOnTriangulation_s",
                    ( const handle<Poly_PolygonOnTriangulation> & (*)(  const TopoDS_Edge & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) ) static_cast< const handle<Poly_PolygonOnTriangulation> & (*)(  const TopoDS_Edge & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) >(&BRep_Tool::PolygonOnTriangulation),
                    R"#(Returns the polygon associated to the edge in the parametric space of the face. Returns a NULL handle if this polygon does not exist.)#"  , py::arg("E"),  py::arg("T"),  py::arg("L")
          )
        .def_static("IsClosed_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge & ,   const TopoDS_Face &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge & ,   const TopoDS_Face &  ) >(&BRep_Tool::IsClosed),
                    R"#(Returns True if <E> has two PCurves in the parametric space of <F>. i.e. <F> is on a closed surface and <E> is on the closing curve.)#"  , py::arg("E"),  py::arg("F")
          )
        .def_static("IsClosed_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) >(&BRep_Tool::IsClosed),
                    R"#(Returns True if <E> has two PCurves in the parametric space of <S>. i.e. <S> is a closed surface and <E> is on the closing curve.)#"  , py::arg("E"),  py::arg("S"),  py::arg("L")
          )
        .def_static("IsClosed_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge & ,   const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) >(&BRep_Tool::IsClosed),
                    R"#(Returns True if <E> has two arrays of indices in the triangulation <T>.)#"  , py::arg("E"),  py::arg("T"),  py::arg("L")
          )
        .def_static("Tolerance_s",
                    (Standard_Real (*)(  const TopoDS_Edge &  ) ) static_cast<Standard_Real (*)(  const TopoDS_Edge &  ) >(&BRep_Tool::Tolerance),
                    R"#(Returns the tolerance for <E>.)#"  , py::arg("E")
          )
        .def_static("SameParameter_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge &  ) >(&BRep_Tool::SameParameter),
                    R"#(Returns the SameParameter flag for the edge.)#"  , py::arg("E")
          )
        .def_static("SameRange_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge &  ) >(&BRep_Tool::SameRange),
                    R"#(Returns the SameRange flag for the edge.)#"  , py::arg("E")
          )
        .def_static("Degenerated_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge &  ) >(&BRep_Tool::Degenerated),
                    R"#(Returns True if the edge is degenerated.)#"  , py::arg("E")
          )
        .def_static("UVPoints_s",
                    (void (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,  gp_Pnt2d & ,  gp_Pnt2d &  ) ) static_cast<void (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,  gp_Pnt2d & ,  gp_Pnt2d &  ) >(&BRep_Tool::UVPoints),
                    R"#(Gets the UV locations of the extremities of the edge.)#"  , py::arg("E"),  py::arg("S"),  py::arg("L"),  py::arg("PFirst"),  py::arg("PLast")
          )
        .def_static("UVPoints_s",
                    (void (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,  gp_Pnt2d & ,  gp_Pnt2d &  ) ) static_cast<void (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,  gp_Pnt2d & ,  gp_Pnt2d &  ) >(&BRep_Tool::UVPoints),
                    R"#(Gets the UV locations of the extremities of the edge.)#"  , py::arg("E"),  py::arg("F"),  py::arg("PFirst"),  py::arg("PLast")
          )
        .def_static("SetUVPoints_s",
                    (void (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&BRep_Tool::SetUVPoints),
                    R"#(Sets the UV locations of the extremities of the edge.)#"  , py::arg("E"),  py::arg("S"),  py::arg("L"),  py::arg("PFirst"),  py::arg("PLast")
          )
        .def_static("SetUVPoints_s",
                    (void (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&BRep_Tool::SetUVPoints),
                    R"#(Sets the UV locations of the extremities of the edge.)#"  , py::arg("E"),  py::arg("F"),  py::arg("PFirst"),  py::arg("PLast")
          )
        .def_static("HasContinuity_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const TopoDS_Face &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const TopoDS_Face &  ) >(&BRep_Tool::HasContinuity),
                    R"#(Returns True if the edge is on the surfaces of the two faces.)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2")
          )
        .def_static("Continuity_s",
                    (GeomAbs_Shape (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const TopoDS_Face &  ) ) static_cast<GeomAbs_Shape (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const TopoDS_Face &  ) >(&BRep_Tool::Continuity),
                    R"#(Returns the continuity.)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2")
          )
        .def_static("HasContinuity_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) >(&BRep_Tool::HasContinuity),
                    R"#(Returns True if the edge is on the surfaces.)#"  , py::arg("E"),  py::arg("S1"),  py::arg("S2"),  py::arg("L1"),  py::arg("L2")
          )
        .def_static("Continuity_s",
                    (GeomAbs_Shape (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) ) static_cast<GeomAbs_Shape (*)(  const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) >(&BRep_Tool::Continuity),
                    R"#(Returns the continuity.)#"  , py::arg("E"),  py::arg("S1"),  py::arg("S2"),  py::arg("L1"),  py::arg("L2")
          )
        .def_static("HasContinuity_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge &  ) >(&BRep_Tool::HasContinuity),
                    R"#(Returns True if the edge has regularity on some two surfaces)#"  , py::arg("E")
          )
        .def_static("MaxContinuity_s",
                    (GeomAbs_Shape (*)(  const TopoDS_Edge &  ) ) static_cast<GeomAbs_Shape (*)(  const TopoDS_Edge &  ) >(&BRep_Tool::MaxContinuity),
                    R"#(Returns the max continuity of edge between some surfaces or GeomAbs_C0 if there no such surfaces.)#"  , py::arg("theEdge")
          )
        .def_static("Pnt_s",
                    (gp_Pnt (*)(  const TopoDS_Vertex &  ) ) static_cast<gp_Pnt (*)(  const TopoDS_Vertex &  ) >(&BRep_Tool::Pnt),
                    R"#(Returns the 3d point.)#"  , py::arg("V")
          )
        .def_static("Tolerance_s",
                    (Standard_Real (*)(  const TopoDS_Vertex &  ) ) static_cast<Standard_Real (*)(  const TopoDS_Vertex &  ) >(&BRep_Tool::Tolerance),
                    R"#(Returns the tolerance.)#"  , py::arg("V")
          )
        .def_static("Parameter_s",
                    (Standard_Boolean (*)(  const TopoDS_Vertex & ,   const TopoDS_Edge & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Vertex & ,   const TopoDS_Edge & ,  Standard_Real &  ) >(&BRep_Tool::Parameter),
                    R"#(Finds the parameter of <theV> on <theE>.)#"  , py::arg("theV"),  py::arg("theE"),  py::arg("theParam")
          )
        .def_static("Parameter_s",
                    (Standard_Real (*)(  const TopoDS_Vertex & ,   const TopoDS_Edge &  ) ) static_cast<Standard_Real (*)(  const TopoDS_Vertex & ,   const TopoDS_Edge &  ) >(&BRep_Tool::Parameter),
                    R"#(Returns the parameter of <V> on <E>. Throws Standard_NoSuchObject if no parameter on edge)#"  , py::arg("V"),  py::arg("E")
          )
        .def_static("Parameter_s",
                    (Standard_Real (*)(  const TopoDS_Vertex & ,   const TopoDS_Edge & ,   const TopoDS_Face &  ) ) static_cast<Standard_Real (*)(  const TopoDS_Vertex & ,   const TopoDS_Edge & ,   const TopoDS_Face &  ) >(&BRep_Tool::Parameter),
                    R"#(Returns the parameters of the vertex on the pcurve of the edge on the face.)#"  , py::arg("V"),  py::arg("E"),  py::arg("F")
          )
        .def_static("Parameter_s",
                    (Standard_Real (*)(  const TopoDS_Vertex & ,   const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) ) static_cast<Standard_Real (*)(  const TopoDS_Vertex & ,   const TopoDS_Edge & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) >(&BRep_Tool::Parameter),
                    R"#(Returns the parameters of the vertex on the pcurve of the edge on the surface.)#"  , py::arg("V"),  py::arg("E"),  py::arg("S"),  py::arg("L")
          )
        .def_static("Parameters_s",
                    (gp_Pnt2d (*)(  const TopoDS_Vertex & ,   const TopoDS_Face &  ) ) static_cast<gp_Pnt2d (*)(  const TopoDS_Vertex & ,   const TopoDS_Face &  ) >(&BRep_Tool::Parameters),
                    R"#(Returns the parameters of the vertex on the face.)#"  , py::arg("V"),  py::arg("F")
          )
        .def_static("MaxTolerance_s",
                    (Standard_Real (*)(  const TopoDS_Shape & ,   const TopAbs_ShapeEnum  ) ) static_cast<Standard_Real (*)(  const TopoDS_Shape & ,   const TopAbs_ShapeEnum  ) >(&BRep_Tool::MaxTolerance),
                    R"#()#"  , py::arg("theShape"),  py::arg("theSubShape")
          )
    // static methods using call by reference i.s.o. return
        .def_static("CurveOnSurface_s",
            []( const TopoDS_Edge & E,Geom2d_Curve& C,Geom_Surface& S,TopLoc_Location & L ){
                Standard_Real  First;
                Standard_Real  Last;
                handle<Geom2d_Curve>  C_ptr; C_ptr = &C;
                handle<Geom_Surface>  S_ptr; S_ptr = &S;

                BRep_Tool::CurveOnSurface(E,C_ptr,S_ptr,L,First,Last);
                if ( C_ptr.get() != &C ) copy_if_copy_constructible(C, *C_ptr);
                if ( S_ptr.get() != &S ) copy_if_copy_constructible(S, *S_ptr);

return std::make_tuple(First,Last); },
            R"#(Returns in <C>, <S>, <L> a 2d curve, a surface and a location for the edge <E>. <C> and <S> are null if the edge has no curve on surface. Returns in <First> and <Last> the parameter range.)#"  , py::arg("E"),  py::arg("C"),  py::arg("S"),  py::arg("L")
          )
        .def_static("CurveOnSurface_s",
            []( const TopoDS_Edge & E,Geom2d_Curve& C,Geom_Surface& S,TopLoc_Location & L, const Standard_Integer Index ){
                Standard_Real  First;
                Standard_Real  Last;
                handle<Geom2d_Curve>  C_ptr; C_ptr = &C;
                handle<Geom_Surface>  S_ptr; S_ptr = &S;

                BRep_Tool::CurveOnSurface(E,C_ptr,S_ptr,L,First,Last,Index);
                if ( C_ptr.get() != &C ) copy_if_copy_constructible(C, *C_ptr);
                if ( S_ptr.get() != &S ) copy_if_copy_constructible(S, *S_ptr);

return std::make_tuple(First,Last); },
            R"#(Returns in <C>, <S>, <L> the 2d curve, the surface and the location for the edge <E> of rank <Index>. <C> and <S> are null if the index is out of range. Returns in <First> and <Last> the parameter range.)#"  , py::arg("E"),  py::arg("C"),  py::arg("S"),  py::arg("L"),  py::arg("Index")
          )
        .def_static("PolygonOnSurface_s",
            []( const TopoDS_Edge & E,Poly_Polygon2D& C,Geom_Surface& S,TopLoc_Location & L ){
                handle<Poly_Polygon2D>  C_ptr; C_ptr = &C;
                handle<Geom_Surface>  S_ptr; S_ptr = &S;

                BRep_Tool::PolygonOnSurface(E,C_ptr,S_ptr,L);
                if ( C_ptr.get() != &C ) copy_if_copy_constructible(C, *C_ptr);
                if ( S_ptr.get() != &S ) copy_if_copy_constructible(S, *S_ptr);

 },
            R"#(Returns in <C>, <S>, <L> a 2d curve, a surface and a location for the edge <E>. <C> and <S> are null if the edge has no polygon on surface.)#"  , py::arg("E"),  py::arg("C"),  py::arg("S"),  py::arg("L")
          )
        .def_static("PolygonOnSurface_s",
            []( const TopoDS_Edge & E,Poly_Polygon2D& C,Geom_Surface& S,TopLoc_Location & L, const Standard_Integer Index ){
                handle<Poly_Polygon2D>  C_ptr; C_ptr = &C;
                handle<Geom_Surface>  S_ptr; S_ptr = &S;

                BRep_Tool::PolygonOnSurface(E,C_ptr,S_ptr,L,Index);
                if ( C_ptr.get() != &C ) copy_if_copy_constructible(C, *C_ptr);
                if ( S_ptr.get() != &S ) copy_if_copy_constructible(S, *S_ptr);

 },
            R"#(Returns in <C>, <S>, <L> the 2d curve, the surface and the location for the edge <E> of rank <Index>. <C> and <S> are null if the index is out of range.)#"  , py::arg("E"),  py::arg("C"),  py::arg("S"),  py::arg("L"),  py::arg("Index")
          )
        .def_static("PolygonOnTriangulation_s",
            []( const TopoDS_Edge & E,Poly_PolygonOnTriangulation& P,Poly_Triangulation& T,TopLoc_Location & L ){
                handle<Poly_PolygonOnTriangulation>  P_ptr; P_ptr = &P;
                handle<Poly_Triangulation>  T_ptr; T_ptr = &T;

                BRep_Tool::PolygonOnTriangulation(E,P_ptr,T_ptr,L);
                if ( P_ptr.get() != &P ) copy_if_copy_constructible(P, *P_ptr);
                if ( T_ptr.get() != &T ) copy_if_copy_constructible(T, *T_ptr);

 },
            R"#(Returns in <P>, <T>, <L> a polygon on triangulation, a triangulation and a location for the edge <E>. <P> and <T> are null if the edge has no polygon on triangulation.)#"  , py::arg("E"),  py::arg("P"),  py::arg("T"),  py::arg("L")
          )
        .def_static("PolygonOnTriangulation_s",
            []( const TopoDS_Edge & E,Poly_PolygonOnTriangulation& P,Poly_Triangulation& T,TopLoc_Location & L, const Standard_Integer Index ){
                handle<Poly_PolygonOnTriangulation>  P_ptr; P_ptr = &P;
                handle<Poly_Triangulation>  T_ptr; T_ptr = &T;

                BRep_Tool::PolygonOnTriangulation(E,P_ptr,T_ptr,L,Index);
                if ( P_ptr.get() != &P ) copy_if_copy_constructible(P, *P_ptr);
                if ( T_ptr.get() != &T ) copy_if_copy_constructible(T, *T_ptr);

 },
            R"#(Returns in <P>, <T>, <L> a polygon on triangulation, a triangulation and a location for the edge <E> for the range index. <C> and <S> are null if the edge has no polygon on triangulation.)#"  , py::arg("E"),  py::arg("P"),  py::arg("T"),  py::arg("L"),  py::arg("Index")
          )
        .def_static("Range_s",
            []( const TopoDS_Edge & E ){
                Standard_Real  First;
                Standard_Real  Last;

                BRep_Tool::Range(E,First,Last);
                
return std::make_tuple(First,Last); },
            R"#(Gets the range of the 3d curve.)#"  , py::arg("E")
          )
        .def_static("Range_s",
            []( const TopoDS_Edge & E, const handle<Geom_Surface> & S, const TopLoc_Location & L ){
                Standard_Real  First;
                Standard_Real  Last;

                BRep_Tool::Range(E,S,L,First,Last);
                
return std::make_tuple(First,Last); },
            R"#(Gets the range of the edge on the pcurve on the surface.)#"  , py::arg("E"),  py::arg("S"),  py::arg("L")
          )
        .def_static("Range_s",
            []( const TopoDS_Edge & E, const TopoDS_Face & F ){
                Standard_Real  First;
                Standard_Real  Last;

                BRep_Tool::Range(E,F,First,Last);
                
return std::make_tuple(First,Last); },
            R"#(Gets the range of the edge on the pcurve on the face.)#"  , py::arg("E"),  py::arg("F")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BRep_CurveOn2Surfaces from ./opencascade/BRep_CurveOn2Surfaces.hxx
    klass = m.attr("BRep_CurveOn2Surfaces");


    // nested enums

    static_cast<py::class_<BRep_CurveOn2Surfaces ,opencascade::handle<BRep_CurveOn2Surfaces>  , BRep_CurveRepresentation >>(klass)
    // constructors
        .def(py::init<  const handle<Geom_Surface> &, const handle<Geom_Surface> &, const TopLoc_Location &, const TopLoc_Location &, const GeomAbs_Shape >()  , py::arg("S1"),  py::arg("S2"),  py::arg("L1"),  py::arg("L2"),  py::arg("C") )
    // custom constructors
    // methods
        .def("IsRegularity",
             (Standard_Boolean (BRep_CurveOn2Surfaces::*)() const) static_cast<Standard_Boolean (BRep_CurveOn2Surfaces::*)() const>(&BRep_CurveOn2Surfaces::IsRegularity),
             R"#(Returns True.)#" 
          )
        .def("IsRegularity",
             (Standard_Boolean (BRep_CurveOn2Surfaces::*)(  const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_CurveOn2Surfaces::*)(  const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) const>(&BRep_CurveOn2Surfaces::IsRegularity),
             R"#(A curve on two surfaces (continuity).)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("L1"),  py::arg("L2")
          )
        .def("D0",
             (void (BRep_CurveOn2Surfaces::*)(  const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (BRep_CurveOn2Surfaces::*)(  const Standard_Real ,  gp_Pnt &  ) const>(&BRep_CurveOn2Surfaces::D0),
             R"#(Raises an error.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("Continuity",
             (void (BRep_CurveOn2Surfaces::*)(  const GeomAbs_Shape  ) ) static_cast<void (BRep_CurveOn2Surfaces::*)(  const GeomAbs_Shape  ) >(&BRep_CurveOn2Surfaces::Continuity),
             R"#()#"  , py::arg("C")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_CurveOn2Surfaces::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_CurveOn2Surfaces::*)() const>(&BRep_CurveOn2Surfaces::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("DumpJson",
             (void (BRep_CurveOn2Surfaces::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_CurveOn2Surfaces::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_CurveOn2Surfaces::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_CurveOn2Surfaces::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_CurveOn2Surfaces::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Surface",
             ( const handle<Geom_Surface> & (BRep_CurveOn2Surfaces::*)() const) static_cast< const handle<Geom_Surface> & (BRep_CurveOn2Surfaces::*)() const>(&BRep_CurveOn2Surfaces::Surface),
             R"#()#"
             
         )
       .def("Surface2",
             ( const handle<Geom_Surface> & (BRep_CurveOn2Surfaces::*)() const) static_cast< const handle<Geom_Surface> & (BRep_CurveOn2Surfaces::*)() const>(&BRep_CurveOn2Surfaces::Surface2),
             R"#()#"
             
         )
       .def("Location2",
             ( const TopLoc_Location & (BRep_CurveOn2Surfaces::*)() const) static_cast< const TopLoc_Location & (BRep_CurveOn2Surfaces::*)() const>(&BRep_CurveOn2Surfaces::Location2),
             R"#()#"
             
         )
       .def("Continuity",
             ( const GeomAbs_Shape & (BRep_CurveOn2Surfaces::*)() const) static_cast< const GeomAbs_Shape & (BRep_CurveOn2Surfaces::*)() const>(&BRep_CurveOn2Surfaces::Continuity),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_CurveOn2Surfaces::*)() const) static_cast< const handle<Standard_Type> & (BRep_CurveOn2Surfaces::*)() const>(&BRep_CurveOn2Surfaces::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_GCurve from ./opencascade/BRep_GCurve.hxx
    klass = m.attr("BRep_GCurve");


    // nested enums

    static_cast<py::class_<BRep_GCurve ,opencascade::handle<BRep_GCurve> ,Py_BRep_GCurve , BRep_CurveRepresentation >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("SetRange",
             (void (BRep_GCurve::*)(  const Standard_Real ,   const Standard_Real  ) ) static_cast<void (BRep_GCurve::*)(  const Standard_Real ,   const Standard_Real  ) >(&BRep_GCurve::SetRange),
             R"#()#"  , py::arg("First"),  py::arg("Last")
          )
        .def("First",
             (Standard_Real (BRep_GCurve::*)() const) static_cast<Standard_Real (BRep_GCurve::*)() const>(&BRep_GCurve::First),
             R"#()#" 
          )
        .def("Last",
             (Standard_Real (BRep_GCurve::*)() const) static_cast<Standard_Real (BRep_GCurve::*)() const>(&BRep_GCurve::Last),
             R"#()#" 
          )
        .def("First",
             (void (BRep_GCurve::*)(  const Standard_Real  ) ) static_cast<void (BRep_GCurve::*)(  const Standard_Real  ) >(&BRep_GCurve::First),
             R"#()#"  , py::arg("F")
          )
        .def("Last",
             (void (BRep_GCurve::*)(  const Standard_Real  ) ) static_cast<void (BRep_GCurve::*)(  const Standard_Real  ) >(&BRep_GCurve::Last),
             R"#()#"  , py::arg("L")
          )
        .def("D0",
             (void (BRep_GCurve::*)(  const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (BRep_GCurve::*)(  const Standard_Real ,  gp_Pnt &  ) const>(&BRep_GCurve::D0),
             R"#(Computes the point at parameter U.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("Update",
             (void (BRep_GCurve::*)() ) static_cast<void (BRep_GCurve::*)() >(&BRep_GCurve::Update),
             R"#(Recomputes any derived data after a modification. This is called when the range is modified.)#" 
          )
        .def("DumpJson",
             (void (BRep_GCurve::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_GCurve::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_GCurve::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("SetRange",
             (void (BRep_GCurve::*)(  const Standard_Real ,   const Standard_Real  ) ) static_cast<void (BRep_GCurve::*)(  const Standard_Real ,   const Standard_Real  ) >(&BRep_GCurve::SetRange),
             R"#()#"  , py::arg("First"),  py::arg("Last")
          )
        .def("First",
             (Standard_Real (BRep_GCurve::*)() const) static_cast<Standard_Real (BRep_GCurve::*)() const>(&BRep_GCurve::First),
             R"#()#" 
          )
        .def("Last",
             (Standard_Real (BRep_GCurve::*)() const) static_cast<Standard_Real (BRep_GCurve::*)() const>(&BRep_GCurve::Last),
             R"#()#" 
          )
        .def("First",
             (void (BRep_GCurve::*)(  const Standard_Real  ) ) static_cast<void (BRep_GCurve::*)(  const Standard_Real  ) >(&BRep_GCurve::First),
             R"#()#"  , py::arg("F")
          )
        .def("Last",
             (void (BRep_GCurve::*)(  const Standard_Real  ) ) static_cast<void (BRep_GCurve::*)(  const Standard_Real  ) >(&BRep_GCurve::Last),
             R"#()#"  , py::arg("L")
          )
    // methods using call by reference i.s.o. return
        .def("Range",
             []( BRep_GCurve &self   ){
                 Standard_Real  First;
                Standard_Real  Last;

                 self.Range(First,Last);
                 
                 return std::make_tuple(First,Last); },
             R"#()#" 
          )
        .def("Range",
             []( BRep_GCurve &self   ){
                 Standard_Real  First;
                Standard_Real  Last;

                 self.Range(First,Last);
                 
                 return std::make_tuple(First,Last); },
             R"#()#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_GCurve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_GCurve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_GCurve::*)() const) static_cast< const handle<Standard_Type> & (BRep_GCurve::*)() const>(&BRep_GCurve::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_PointOnCurve from ./opencascade/BRep_PointOnCurve.hxx
    klass = m.attr("BRep_PointOnCurve");


    // nested enums

    static_cast<py::class_<BRep_PointOnCurve ,opencascade::handle<BRep_PointOnCurve>  , BRep_PointRepresentation >>(klass)
    // constructors
        .def(py::init<  const Standard_Real, const handle<Geom_Curve> &, const TopLoc_Location & >()  , py::arg("P"),  py::arg("C"),  py::arg("L") )
    // custom constructors
    // methods
        .def("IsPointOnCurve",
             (Standard_Boolean (BRep_PointOnCurve::*)() const) static_cast<Standard_Boolean (BRep_PointOnCurve::*)() const>(&BRep_PointOnCurve::IsPointOnCurve),
             R"#(Returns True)#" 
          )
        .def("IsPointOnCurve",
             (Standard_Boolean (BRep_PointOnCurve::*)(  const handle<Geom_Curve> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_PointOnCurve::*)(  const handle<Geom_Curve> & ,   const TopLoc_Location &  ) const>(&BRep_PointOnCurve::IsPointOnCurve),
             R"#()#"  , py::arg("C"),  py::arg("L")
          )
        .def("Curve",
             (void (BRep_PointOnCurve::*)(  const handle<Geom_Curve> &  ) ) static_cast<void (BRep_PointOnCurve::*)(  const handle<Geom_Curve> &  ) >(&BRep_PointOnCurve::Curve),
             R"#()#"  , py::arg("C")
          )
        .def("DumpJson",
             (void (BRep_PointOnCurve::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_PointOnCurve::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_PointOnCurve::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PointOnCurve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PointOnCurve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Curve",
             ( const handle<Geom_Curve> & (BRep_PointOnCurve::*)() const) static_cast< const handle<Geom_Curve> & (BRep_PointOnCurve::*)() const>(&BRep_PointOnCurve::Curve),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PointOnCurve::*)() const) static_cast< const handle<Standard_Type> & (BRep_PointOnCurve::*)() const>(&BRep_PointOnCurve::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_PointsOnSurface from ./opencascade/BRep_PointsOnSurface.hxx
    klass = m.attr("BRep_PointsOnSurface");


    // nested enums

    static_cast<py::class_<BRep_PointsOnSurface ,opencascade::handle<BRep_PointsOnSurface>  , BRep_PointRepresentation >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Surface",
             (void (BRep_PointsOnSurface::*)(  const handle<Geom_Surface> &  ) ) static_cast<void (BRep_PointsOnSurface::*)(  const handle<Geom_Surface> &  ) >(&BRep_PointsOnSurface::Surface),
             R"#()#"  , py::arg("S")
          )
        .def("DumpJson",
             (void (BRep_PointsOnSurface::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_PointsOnSurface::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_PointsOnSurface::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PointsOnSurface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PointsOnSurface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Surface",
             ( const handle<Geom_Surface> & (BRep_PointsOnSurface::*)() const) static_cast< const handle<Geom_Surface> & (BRep_PointsOnSurface::*)() const>(&BRep_PointsOnSurface::Surface),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PointsOnSurface::*)() const) static_cast< const handle<Standard_Type> & (BRep_PointsOnSurface::*)() const>(&BRep_PointsOnSurface::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_Polygon3D from ./opencascade/BRep_Polygon3D.hxx
    klass = m.attr("BRep_Polygon3D");


    // nested enums

    static_cast<py::class_<BRep_Polygon3D ,opencascade::handle<BRep_Polygon3D>  , BRep_CurveRepresentation >>(klass)
    // constructors
        .def(py::init<  const handle<Poly_Polygon3D> &, const TopLoc_Location & >()  , py::arg("P"),  py::arg("L") )
    // custom constructors
    // methods
        .def("IsPolygon3D",
             (Standard_Boolean (BRep_Polygon3D::*)() const) static_cast<Standard_Boolean (BRep_Polygon3D::*)() const>(&BRep_Polygon3D::IsPolygon3D),
             R"#(Returns True.)#" 
          )
        .def("Polygon3D",
             (void (BRep_Polygon3D::*)(  const handle<Poly_Polygon3D> &  ) ) static_cast<void (BRep_Polygon3D::*)(  const handle<Poly_Polygon3D> &  ) >(&BRep_Polygon3D::Polygon3D),
             R"#()#"  , py::arg("P")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_Polygon3D::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_Polygon3D::*)() const>(&BRep_Polygon3D::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("DumpJson",
             (void (BRep_Polygon3D::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_Polygon3D::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_Polygon3D::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_Polygon3D::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_Polygon3D::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Polygon3D",
             ( const handle<Poly_Polygon3D> & (BRep_Polygon3D::*)() const) static_cast< const handle<Poly_Polygon3D> & (BRep_Polygon3D::*)() const>(&BRep_Polygon3D::Polygon3D),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_Polygon3D::*)() const) static_cast< const handle<Standard_Type> & (BRep_Polygon3D::*)() const>(&BRep_Polygon3D::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_PolygonOnSurface from ./opencascade/BRep_PolygonOnSurface.hxx
    klass = m.attr("BRep_PolygonOnSurface");


    // nested enums

    static_cast<py::class_<BRep_PolygonOnSurface ,opencascade::handle<BRep_PolygonOnSurface>  , BRep_CurveRepresentation >>(klass)
    // constructors
        .def(py::init<  const handle<Poly_Polygon2D> &, const handle<Geom_Surface> &, const TopLoc_Location & >()  , py::arg("P"),  py::arg("S"),  py::arg("L") )
    // custom constructors
    // methods
        .def("IsPolygonOnSurface",
             (Standard_Boolean (BRep_PolygonOnSurface::*)() const) static_cast<Standard_Boolean (BRep_PolygonOnSurface::*)() const>(&BRep_PolygonOnSurface::IsPolygonOnSurface),
             R"#(A 2D polygon representation in the parametric space of a surface.)#" 
          )
        .def("IsPolygonOnSurface",
             (Standard_Boolean (BRep_PolygonOnSurface::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_PolygonOnSurface::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_PolygonOnSurface::IsPolygonOnSurface),
             R"#(A 2D polygon representation in the parametric space of a surface.)#"  , py::arg("S"),  py::arg("L")
          )
        .def("Polygon",
             (void (BRep_PolygonOnSurface::*)(  const handle<Poly_Polygon2D> &  ) ) static_cast<void (BRep_PolygonOnSurface::*)(  const handle<Poly_Polygon2D> &  ) >(&BRep_PolygonOnSurface::Polygon),
             R"#()#"  , py::arg("P")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_PolygonOnSurface::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_PolygonOnSurface::*)() const>(&BRep_PolygonOnSurface::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("DumpJson",
             (void (BRep_PolygonOnSurface::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_PolygonOnSurface::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_PolygonOnSurface::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PolygonOnSurface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PolygonOnSurface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Surface",
             ( const handle<Geom_Surface> & (BRep_PolygonOnSurface::*)() const) static_cast< const handle<Geom_Surface> & (BRep_PolygonOnSurface::*)() const>(&BRep_PolygonOnSurface::Surface),
             R"#()#"
             
         )
       .def("Polygon",
             ( const handle<Poly_Polygon2D> & (BRep_PolygonOnSurface::*)() const) static_cast< const handle<Poly_Polygon2D> & (BRep_PolygonOnSurface::*)() const>(&BRep_PolygonOnSurface::Polygon),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PolygonOnSurface::*)() const) static_cast< const handle<Standard_Type> & (BRep_PolygonOnSurface::*)() const>(&BRep_PolygonOnSurface::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_PolygonOnTriangulation from ./opencascade/BRep_PolygonOnTriangulation.hxx
    klass = m.attr("BRep_PolygonOnTriangulation");


    // nested enums

    static_cast<py::class_<BRep_PolygonOnTriangulation ,opencascade::handle<BRep_PolygonOnTriangulation>  , BRep_CurveRepresentation >>(klass)
    // constructors
        .def(py::init<  const handle<Poly_PolygonOnTriangulation> &, const handle<Poly_Triangulation> &, const TopLoc_Location & >()  , py::arg("P"),  py::arg("T"),  py::arg("L") )
    // custom constructors
    // methods
        .def("IsPolygonOnTriangulation",
             (Standard_Boolean (BRep_PolygonOnTriangulation::*)() const) static_cast<Standard_Boolean (BRep_PolygonOnTriangulation::*)() const>(&BRep_PolygonOnTriangulation::IsPolygonOnTriangulation),
             R"#(returns True.)#" 
          )
        .def("IsPolygonOnTriangulation",
             (Standard_Boolean (BRep_PolygonOnTriangulation::*)(  const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_PolygonOnTriangulation::*)(  const handle<Poly_Triangulation> & ,   const TopLoc_Location &  ) const>(&BRep_PolygonOnTriangulation::IsPolygonOnTriangulation),
             R"#(Is it a polygon in the definition of <T> with location <L>.)#"  , py::arg("T"),  py::arg("L")
          )
        .def("PolygonOnTriangulation",
             (void (BRep_PolygonOnTriangulation::*)(  const handle<Poly_PolygonOnTriangulation> &  ) ) static_cast<void (BRep_PolygonOnTriangulation::*)(  const handle<Poly_PolygonOnTriangulation> &  ) >(&BRep_PolygonOnTriangulation::PolygonOnTriangulation),
             R"#(returns True.)#"  , py::arg("P")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_PolygonOnTriangulation::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_PolygonOnTriangulation::*)() const>(&BRep_PolygonOnTriangulation::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("DumpJson",
             (void (BRep_PolygonOnTriangulation::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_PolygonOnTriangulation::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_PolygonOnTriangulation::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PolygonOnTriangulation::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PolygonOnTriangulation::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Triangulation",
             ( const handle<Poly_Triangulation> & (BRep_PolygonOnTriangulation::*)() const) static_cast< const handle<Poly_Triangulation> & (BRep_PolygonOnTriangulation::*)() const>(&BRep_PolygonOnTriangulation::Triangulation),
             R"#()#"
             
         )
       .def("PolygonOnTriangulation",
             ( const handle<Poly_PolygonOnTriangulation> & (BRep_PolygonOnTriangulation::*)() const) static_cast< const handle<Poly_PolygonOnTriangulation> & (BRep_PolygonOnTriangulation::*)() const>(&BRep_PolygonOnTriangulation::PolygonOnTriangulation),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PolygonOnTriangulation::*)() const) static_cast< const handle<Standard_Type> & (BRep_PolygonOnTriangulation::*)() const>(&BRep_PolygonOnTriangulation::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_Curve3D from ./opencascade/BRep_Curve3D.hxx
    klass = m.attr("BRep_Curve3D");


    // nested enums

    static_cast<py::class_<BRep_Curve3D ,opencascade::handle<BRep_Curve3D>  , BRep_GCurve >>(klass)
    // constructors
        .def(py::init<  const handle<Geom_Curve> &, const TopLoc_Location & >()  , py::arg("C"),  py::arg("L") )
    // custom constructors
    // methods
        .def("D0",
             (void (BRep_Curve3D::*)(  const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (BRep_Curve3D::*)(  const Standard_Real ,  gp_Pnt &  ) const>(&BRep_Curve3D::D0),
             R"#(Computes the point at parameter U.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("IsCurve3D",
             (Standard_Boolean (BRep_Curve3D::*)() const) static_cast<Standard_Boolean (BRep_Curve3D::*)() const>(&BRep_Curve3D::IsCurve3D),
             R"#(Returns True.)#" 
          )
        .def("Curve3D",
             (void (BRep_Curve3D::*)(  const handle<Geom_Curve> &  ) ) static_cast<void (BRep_Curve3D::*)(  const handle<Geom_Curve> &  ) >(&BRep_Curve3D::Curve3D),
             R"#()#"  , py::arg("C")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_Curve3D::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_Curve3D::*)() const>(&BRep_Curve3D::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("DumpJson",
             (void (BRep_Curve3D::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_Curve3D::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_Curve3D::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_Curve3D::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_Curve3D::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Curve3D",
             ( const handle<Geom_Curve> & (BRep_Curve3D::*)() const) static_cast< const handle<Geom_Curve> & (BRep_Curve3D::*)() const>(&BRep_Curve3D::Curve3D),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_Curve3D::*)() const) static_cast< const handle<Standard_Type> & (BRep_Curve3D::*)() const>(&BRep_Curve3D::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_CurveOnSurface from ./opencascade/BRep_CurveOnSurface.hxx
    klass = m.attr("BRep_CurveOnSurface");


    // nested enums

    static_cast<py::class_<BRep_CurveOnSurface ,opencascade::handle<BRep_CurveOnSurface>  , BRep_GCurve >>(klass)
    // constructors
        .def(py::init<  const handle<Geom2d_Curve> &, const handle<Geom_Surface> &, const TopLoc_Location & >()  , py::arg("PC"),  py::arg("S"),  py::arg("L") )
    // custom constructors
    // methods
        .def("SetUVPoints",
             (void (BRep_CurveOnSurface::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (BRep_CurveOnSurface::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&BRep_CurveOnSurface::SetUVPoints),
             R"#()#"  , py::arg("P1"),  py::arg("P2")
          )
        .def("UVPoints",
             (void (BRep_CurveOnSurface::*)( gp_Pnt2d & ,  gp_Pnt2d &  ) const) static_cast<void (BRep_CurveOnSurface::*)( gp_Pnt2d & ,  gp_Pnt2d &  ) const>(&BRep_CurveOnSurface::UVPoints),
             R"#()#"  , py::arg("P1"),  py::arg("P2")
          )
        .def("D0",
             (void (BRep_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (BRep_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt &  ) const>(&BRep_CurveOnSurface::D0),
             R"#(Computes the point at parameter U.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("IsCurveOnSurface",
             (Standard_Boolean (BRep_CurveOnSurface::*)() const) static_cast<Standard_Boolean (BRep_CurveOnSurface::*)() const>(&BRep_CurveOnSurface::IsCurveOnSurface),
             R"#(Returns True.)#" 
          )
        .def("IsCurveOnSurface",
             (Standard_Boolean (BRep_CurveOnSurface::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_CurveOnSurface::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_CurveOnSurface::IsCurveOnSurface),
             R"#(A curve in the parametric space of a surface.)#"  , py::arg("S"),  py::arg("L")
          )
        .def("PCurve",
             (void (BRep_CurveOnSurface::*)(  const handle<Geom2d_Curve> &  ) ) static_cast<void (BRep_CurveOnSurface::*)(  const handle<Geom2d_Curve> &  ) >(&BRep_CurveOnSurface::PCurve),
             R"#()#"  , py::arg("C")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_CurveOnSurface::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_CurveOnSurface::*)() const>(&BRep_CurveOnSurface::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("Update",
             (void (BRep_CurveOnSurface::*)() ) static_cast<void (BRep_CurveOnSurface::*)() >(&BRep_CurveOnSurface::Update),
             R"#(Recomputes any derived data after a modification. This is called when the range is modified.)#" 
          )
        .def("DumpJson",
             (void (BRep_CurveOnSurface::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_CurveOnSurface::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_CurveOnSurface::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("SetUVPoints",
             (void (BRep_CurveOnSurface::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (BRep_CurveOnSurface::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&BRep_CurveOnSurface::SetUVPoints),
             R"#()#"  , py::arg("P1"),  py::arg("P2")
          )
        .def("UVPoints",
             (void (BRep_CurveOnSurface::*)( gp_Pnt2d & ,  gp_Pnt2d &  ) const) static_cast<void (BRep_CurveOnSurface::*)( gp_Pnt2d & ,  gp_Pnt2d &  ) const>(&BRep_CurveOnSurface::UVPoints),
             R"#()#"  , py::arg("P1"),  py::arg("P2")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_CurveOnSurface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_CurveOnSurface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Surface",
             ( const handle<Geom_Surface> & (BRep_CurveOnSurface::*)() const) static_cast< const handle<Geom_Surface> & (BRep_CurveOnSurface::*)() const>(&BRep_CurveOnSurface::Surface),
             R"#()#"
             
         )
       .def("PCurve",
             ( const handle<Geom2d_Curve> & (BRep_CurveOnSurface::*)() const) static_cast< const handle<Geom2d_Curve> & (BRep_CurveOnSurface::*)() const>(&BRep_CurveOnSurface::PCurve),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_CurveOnSurface::*)() const) static_cast< const handle<Standard_Type> & (BRep_CurveOnSurface::*)() const>(&BRep_CurveOnSurface::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_PointOnCurveOnSurface from ./opencascade/BRep_PointOnCurveOnSurface.hxx
    klass = m.attr("BRep_PointOnCurveOnSurface");


    // nested enums

    static_cast<py::class_<BRep_PointOnCurveOnSurface ,opencascade::handle<BRep_PointOnCurveOnSurface>  , BRep_PointsOnSurface >>(klass)
    // constructors
        .def(py::init<  const Standard_Real, const handle<Geom2d_Curve> &, const handle<Geom_Surface> &, const TopLoc_Location & >()  , py::arg("P"),  py::arg("C"),  py::arg("S"),  py::arg("L") )
    // custom constructors
    // methods
        .def("IsPointOnCurveOnSurface",
             (Standard_Boolean (BRep_PointOnCurveOnSurface::*)() const) static_cast<Standard_Boolean (BRep_PointOnCurveOnSurface::*)() const>(&BRep_PointOnCurveOnSurface::IsPointOnCurveOnSurface),
             R"#(Returns True)#" 
          )
        .def("IsPointOnCurveOnSurface",
             (Standard_Boolean (BRep_PointOnCurveOnSurface::*)(  const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_PointOnCurveOnSurface::*)(  const handle<Geom2d_Curve> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_PointOnCurveOnSurface::IsPointOnCurveOnSurface),
             R"#()#"  , py::arg("PC"),  py::arg("S"),  py::arg("L")
          )
        .def("PCurve",
             (void (BRep_PointOnCurveOnSurface::*)(  const handle<Geom2d_Curve> &  ) ) static_cast<void (BRep_PointOnCurveOnSurface::*)(  const handle<Geom2d_Curve> &  ) >(&BRep_PointOnCurveOnSurface::PCurve),
             R"#()#"  , py::arg("C")
          )
        .def("DumpJson",
             (void (BRep_PointOnCurveOnSurface::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_PointOnCurveOnSurface::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_PointOnCurveOnSurface::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PointOnCurveOnSurface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PointOnCurveOnSurface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("PCurve",
             ( const handle<Geom2d_Curve> & (BRep_PointOnCurveOnSurface::*)() const) static_cast< const handle<Geom2d_Curve> & (BRep_PointOnCurveOnSurface::*)() const>(&BRep_PointOnCurveOnSurface::PCurve),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PointOnCurveOnSurface::*)() const) static_cast< const handle<Standard_Type> & (BRep_PointOnCurveOnSurface::*)() const>(&BRep_PointOnCurveOnSurface::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_PointOnSurface from ./opencascade/BRep_PointOnSurface.hxx
    klass = m.attr("BRep_PointOnSurface");


    // nested enums

    static_cast<py::class_<BRep_PointOnSurface ,opencascade::handle<BRep_PointOnSurface>  , BRep_PointsOnSurface >>(klass)
    // constructors
        .def(py::init<  const Standard_Real, const Standard_Real, const handle<Geom_Surface> &, const TopLoc_Location & >()  , py::arg("P1"),  py::arg("P2"),  py::arg("S"),  py::arg("L") )
    // custom constructors
    // methods
        .def("IsPointOnSurface",
             (Standard_Boolean (BRep_PointOnSurface::*)() const) static_cast<Standard_Boolean (BRep_PointOnSurface::*)() const>(&BRep_PointOnSurface::IsPointOnSurface),
             R"#()#" 
          )
        .def("IsPointOnSurface",
             (Standard_Boolean (BRep_PointOnSurface::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_PointOnSurface::*)(  const handle<Geom_Surface> & ,   const TopLoc_Location &  ) const>(&BRep_PointOnSurface::IsPointOnSurface),
             R"#()#"  , py::arg("S"),  py::arg("L")
          )
        .def("Parameter2",
             (Standard_Real (BRep_PointOnSurface::*)() const) static_cast<Standard_Real (BRep_PointOnSurface::*)() const>(&BRep_PointOnSurface::Parameter2),
             R"#()#" 
          )
        .def("Parameter2",
             (void (BRep_PointOnSurface::*)(  const Standard_Real  ) ) static_cast<void (BRep_PointOnSurface::*)(  const Standard_Real  ) >(&BRep_PointOnSurface::Parameter2),
             R"#()#"  , py::arg("P")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PointOnSurface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PointOnSurface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PointOnSurface::*)() const) static_cast< const handle<Standard_Type> & (BRep_PointOnSurface::*)() const>(&BRep_PointOnSurface::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_PolygonOnClosedSurface from ./opencascade/BRep_PolygonOnClosedSurface.hxx
    klass = m.attr("BRep_PolygonOnClosedSurface");


    // nested enums

    static_cast<py::class_<BRep_PolygonOnClosedSurface ,opencascade::handle<BRep_PolygonOnClosedSurface>  , BRep_PolygonOnSurface >>(klass)
    // constructors
        .def(py::init<  const handle<Poly_Polygon2D> &, const handle<Poly_Polygon2D> &, const handle<Geom_Surface> &, const TopLoc_Location & >()  , py::arg("P1"),  py::arg("P2"),  py::arg("S"),  py::arg("L") )
    // custom constructors
    // methods
        .def("IsPolygonOnClosedSurface",
             (Standard_Boolean (BRep_PolygonOnClosedSurface::*)() const) static_cast<Standard_Boolean (BRep_PolygonOnClosedSurface::*)() const>(&BRep_PolygonOnClosedSurface::IsPolygonOnClosedSurface),
             R"#(returns True.)#" 
          )
        .def("Polygon2",
             (void (BRep_PolygonOnClosedSurface::*)(  const handle<Poly_Polygon2D> &  ) ) static_cast<void (BRep_PolygonOnClosedSurface::*)(  const handle<Poly_Polygon2D> &  ) >(&BRep_PolygonOnClosedSurface::Polygon2),
             R"#()#"  , py::arg("P")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_PolygonOnClosedSurface::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_PolygonOnClosedSurface::*)() const>(&BRep_PolygonOnClosedSurface::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("DumpJson",
             (void (BRep_PolygonOnClosedSurface::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_PolygonOnClosedSurface::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_PolygonOnClosedSurface::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PolygonOnClosedSurface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PolygonOnClosedSurface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Polygon2",
             ( const handle<Poly_Polygon2D> & (BRep_PolygonOnClosedSurface::*)() const) static_cast< const handle<Poly_Polygon2D> & (BRep_PolygonOnClosedSurface::*)() const>(&BRep_PolygonOnClosedSurface::Polygon2),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PolygonOnClosedSurface::*)() const) static_cast< const handle<Standard_Type> & (BRep_PolygonOnClosedSurface::*)() const>(&BRep_PolygonOnClosedSurface::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_PolygonOnClosedTriangulation from ./opencascade/BRep_PolygonOnClosedTriangulation.hxx
    klass = m.attr("BRep_PolygonOnClosedTriangulation");


    // nested enums

    static_cast<py::class_<BRep_PolygonOnClosedTriangulation ,opencascade::handle<BRep_PolygonOnClosedTriangulation>  , BRep_PolygonOnTriangulation >>(klass)
    // constructors
        .def(py::init<  const handle<Poly_PolygonOnTriangulation> &, const handle<Poly_PolygonOnTriangulation> &, const handle<Poly_Triangulation> &, const TopLoc_Location & >()  , py::arg("P1"),  py::arg("P2"),  py::arg("Tr"),  py::arg("L") )
    // custom constructors
    // methods
        .def("IsPolygonOnClosedTriangulation",
             (Standard_Boolean (BRep_PolygonOnClosedTriangulation::*)() const) static_cast<Standard_Boolean (BRep_PolygonOnClosedTriangulation::*)() const>(&BRep_PolygonOnClosedTriangulation::IsPolygonOnClosedTriangulation),
             R"#(Returns True.)#" 
          )
        .def("PolygonOnTriangulation2",
             (void (BRep_PolygonOnClosedTriangulation::*)(  const handle<Poly_PolygonOnTriangulation> &  ) ) static_cast<void (BRep_PolygonOnClosedTriangulation::*)(  const handle<Poly_PolygonOnTriangulation> &  ) >(&BRep_PolygonOnClosedTriangulation::PolygonOnTriangulation2),
             R"#()#"  , py::arg("P2")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_PolygonOnClosedTriangulation::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_PolygonOnClosedTriangulation::*)() const>(&BRep_PolygonOnClosedTriangulation::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("DumpJson",
             (void (BRep_PolygonOnClosedTriangulation::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_PolygonOnClosedTriangulation::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_PolygonOnClosedTriangulation::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_PolygonOnClosedTriangulation::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_PolygonOnClosedTriangulation::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("PolygonOnTriangulation2",
             ( const handle<Poly_PolygonOnTriangulation> & (BRep_PolygonOnClosedTriangulation::*)() const) static_cast< const handle<Poly_PolygonOnTriangulation> & (BRep_PolygonOnClosedTriangulation::*)() const>(&BRep_PolygonOnClosedTriangulation::PolygonOnTriangulation2),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_PolygonOnClosedTriangulation::*)() const) static_cast< const handle<Standard_Type> & (BRep_PolygonOnClosedTriangulation::*)() const>(&BRep_PolygonOnClosedTriangulation::DynamicType),
             R"#()#"
             
         )
;

    // Class BRep_CurveOnClosedSurface from ./opencascade/BRep_CurveOnClosedSurface.hxx
    klass = m.attr("BRep_CurveOnClosedSurface");


    // nested enums

    static_cast<py::class_<BRep_CurveOnClosedSurface ,opencascade::handle<BRep_CurveOnClosedSurface>  , BRep_CurveOnSurface >>(klass)
    // constructors
        .def(py::init<  const handle<Geom2d_Curve> &, const handle<Geom2d_Curve> &, const handle<Geom_Surface> &, const TopLoc_Location &, const GeomAbs_Shape >()  , py::arg("PC1"),  py::arg("PC2"),  py::arg("S"),  py::arg("L"),  py::arg("C") )
    // custom constructors
    // methods
        .def("SetUVPoints2",
             (void (BRep_CurveOnClosedSurface::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (BRep_CurveOnClosedSurface::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&BRep_CurveOnClosedSurface::SetUVPoints2),
             R"#()#"  , py::arg("P1"),  py::arg("P2")
          )
        .def("UVPoints2",
             (void (BRep_CurveOnClosedSurface::*)( gp_Pnt2d & ,  gp_Pnt2d &  ) const) static_cast<void (BRep_CurveOnClosedSurface::*)( gp_Pnt2d & ,  gp_Pnt2d &  ) const>(&BRep_CurveOnClosedSurface::UVPoints2),
             R"#()#"  , py::arg("P1"),  py::arg("P2")
          )
        .def("IsCurveOnClosedSurface",
             (Standard_Boolean (BRep_CurveOnClosedSurface::*)() const) static_cast<Standard_Boolean (BRep_CurveOnClosedSurface::*)() const>(&BRep_CurveOnClosedSurface::IsCurveOnClosedSurface),
             R"#(Returns True.)#" 
          )
        .def("IsRegularity",
             (Standard_Boolean (BRep_CurveOnClosedSurface::*)() const) static_cast<Standard_Boolean (BRep_CurveOnClosedSurface::*)() const>(&BRep_CurveOnClosedSurface::IsRegularity),
             R"#(Returns True)#" 
          )
        .def("IsRegularity",
             (Standard_Boolean (BRep_CurveOnClosedSurface::*)(  const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) const) static_cast<Standard_Boolean (BRep_CurveOnClosedSurface::*)(  const handle<Geom_Surface> & ,   const handle<Geom_Surface> & ,   const TopLoc_Location & ,   const TopLoc_Location &  ) const>(&BRep_CurveOnClosedSurface::IsRegularity),
             R"#(A curve on two surfaces (continuity).)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("L1"),  py::arg("L2")
          )
        .def("Continuity",
             (void (BRep_CurveOnClosedSurface::*)(  const GeomAbs_Shape  ) ) static_cast<void (BRep_CurveOnClosedSurface::*)(  const GeomAbs_Shape  ) >(&BRep_CurveOnClosedSurface::Continuity),
             R"#()#"  , py::arg("C")
          )
        .def("PCurve2",
             (void (BRep_CurveOnClosedSurface::*)(  const handle<Geom2d_Curve> &  ) ) static_cast<void (BRep_CurveOnClosedSurface::*)(  const handle<Geom2d_Curve> &  ) >(&BRep_CurveOnClosedSurface::PCurve2),
             R"#()#"  , py::arg("C")
          )
        .def("Copy",
             (handle<BRep_CurveRepresentation> (BRep_CurveOnClosedSurface::*)() const) static_cast<handle<BRep_CurveRepresentation> (BRep_CurveOnClosedSurface::*)() const>(&BRep_CurveOnClosedSurface::Copy),
             R"#(Return a copy of this representation.)#" 
          )
        .def("Update",
             (void (BRep_CurveOnClosedSurface::*)() ) static_cast<void (BRep_CurveOnClosedSurface::*)() >(&BRep_CurveOnClosedSurface::Update),
             R"#(Recomputes any derived data after a modification. This is called when the range is modified.)#" 
          )
        .def("DumpJson",
             (void (BRep_CurveOnClosedSurface::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (BRep_CurveOnClosedSurface::*)( Standard_OStream & ,  Standard_Integer  ) const>(&BRep_CurveOnClosedSurface::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("SetUVPoints2",
             (void (BRep_CurveOnClosedSurface::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (BRep_CurveOnClosedSurface::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&BRep_CurveOnClosedSurface::SetUVPoints2),
             R"#()#"  , py::arg("P1"),  py::arg("P2")
          )
        .def("UVPoints2",
             (void (BRep_CurveOnClosedSurface::*)( gp_Pnt2d & ,  gp_Pnt2d &  ) const) static_cast<void (BRep_CurveOnClosedSurface::*)( gp_Pnt2d & ,  gp_Pnt2d &  ) const>(&BRep_CurveOnClosedSurface::UVPoints2),
             R"#()#"  , py::arg("P1"),  py::arg("P2")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRep_CurveOnClosedSurface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRep_CurveOnClosedSurface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("PCurve2",
             ( const handle<Geom2d_Curve> & (BRep_CurveOnClosedSurface::*)() const) static_cast< const handle<Geom2d_Curve> & (BRep_CurveOnClosedSurface::*)() const>(&BRep_CurveOnClosedSurface::PCurve2),
             R"#()#"
             
         )
       .def("Surface2",
             ( const handle<Geom_Surface> & (BRep_CurveOnClosedSurface::*)() const) static_cast< const handle<Geom_Surface> & (BRep_CurveOnClosedSurface::*)() const>(&BRep_CurveOnClosedSurface::Surface2),
             R"#(Returns Surface())#"
             
         )
       .def("Location2",
             ( const TopLoc_Location & (BRep_CurveOnClosedSurface::*)() const) static_cast< const TopLoc_Location & (BRep_CurveOnClosedSurface::*)() const>(&BRep_CurveOnClosedSurface::Location2),
             R"#(Returns Location())#"
             
         )
       .def("Continuity",
             ( const GeomAbs_Shape & (BRep_CurveOnClosedSurface::*)() const) static_cast< const GeomAbs_Shape & (BRep_CurveOnClosedSurface::*)() const>(&BRep_CurveOnClosedSurface::Continuity),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRep_CurveOnClosedSurface::*)() const) static_cast< const handle<Standard_Type> & (BRep_CurveOnClosedSurface::*)() const>(&BRep_CurveOnClosedSurface::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/BRep_Builder.hxx
// ./opencascade/BRep_Curve3D.hxx
// ./opencascade/BRep_CurveOn2Surfaces.hxx
// ./opencascade/BRep_CurveOnClosedSurface.hxx
// ./opencascade/BRep_CurveOnSurface.hxx
// ./opencascade/BRep_CurveRepresentation.hxx
// ./opencascade/BRep_GCurve.hxx
// ./opencascade/BRep_ListIteratorOfListOfCurveRepresentation.hxx
// ./opencascade/BRep_ListIteratorOfListOfPointRepresentation.hxx
// ./opencascade/BRep_ListOfCurveRepresentation.hxx
// ./opencascade/BRep_ListOfPointRepresentation.hxx
// ./opencascade/BRep_PointOnCurve.hxx
// ./opencascade/BRep_PointOnCurveOnSurface.hxx
// ./opencascade/BRep_PointOnSurface.hxx
// ./opencascade/BRep_PointRepresentation.hxx
// ./opencascade/BRep_PointsOnSurface.hxx
// ./opencascade/BRep_Polygon3D.hxx
// ./opencascade/BRep_PolygonOnClosedSurface.hxx
// ./opencascade/BRep_PolygonOnClosedTriangulation.hxx
// ./opencascade/BRep_PolygonOnSurface.hxx
// ./opencascade/BRep_PolygonOnTriangulation.hxx
// ./opencascade/BRep_TEdge.hxx
// ./opencascade/BRep_TFace.hxx
// ./opencascade/BRep_TVertex.hxx
// ./opencascade/BRep_Tool.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_List<opencascade::handle<BRep_CurveRepresentation>>(m,"BRep_ListOfCurveRepresentation");
    register_template_NCollection_List<opencascade::handle<BRep_PointRepresentation>>(m,"BRep_ListOfPointRepresentation");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
