# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class NetworkLoadBalancerForwardingRuleHealthCheck(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'client_timeout': 'int',

        'connect_timeout': 'int',

        'retries': 'int',

        'target_timeout': 'int',
    }

    attribute_map = {

        'client_timeout': 'clientTimeout',

        'connect_timeout': 'connectTimeout',

        'retries': 'retries',

        'target_timeout': 'targetTimeout',
    }

    def __init__(self, client_timeout=None, connect_timeout=None, retries=None, target_timeout=None, local_vars_configuration=None):  # noqa: E501
        """NetworkLoadBalancerForwardingRuleHealthCheck - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._client_timeout = None
        self._connect_timeout = None
        self._retries = None
        self._target_timeout = None
        self.discriminator = None

        if client_timeout is not None:
            self.client_timeout = client_timeout
        if connect_timeout is not None:
            self.connect_timeout = connect_timeout
        if retries is not None:
            self.retries = retries
        if target_timeout is not None:
            self.target_timeout = target_timeout


    @property
    def client_timeout(self):
        """Gets the client_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501

        The maximum time in milliseconds to wait for the client to acknowledge or send data; default is 50,000 (50 seconds).  # noqa: E501

        :return: The client_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501
        :rtype: int
        """
        return self._client_timeout

    @client_timeout.setter
    def client_timeout(self, client_timeout):
        """Sets the client_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.

        The maximum time in milliseconds to wait for the client to acknowledge or send data; default is 50,000 (50 seconds).  # noqa: E501

        :param client_timeout: The client_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501
        :type client_timeout: int
        """

        self._client_timeout = client_timeout

    @property
    def connect_timeout(self):
        """Gets the connect_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501

        The maximum time in milliseconds to wait for a connection attempt to a target to succeed; default is 5000 (five seconds).  # noqa: E501

        :return: The connect_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501
        :rtype: int
        """
        return self._connect_timeout

    @connect_timeout.setter
    def connect_timeout(self, connect_timeout):
        """Sets the connect_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.

        The maximum time in milliseconds to wait for a connection attempt to a target to succeed; default is 5000 (five seconds).  # noqa: E501

        :param connect_timeout: The connect_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501
        :type connect_timeout: int
        """

        self._connect_timeout = connect_timeout

    @property
    def retries(self):
        """Gets the retries of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501

        The maximum number of attempts to reconnect to a target after a connection failure. Valid range is 0 to 65535 and default is three reconnection attempts.  # noqa: E501

        :return: The retries of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501
        :rtype: int
        """
        return self._retries

    @retries.setter
    def retries(self, retries):
        """Sets the retries of this NetworkLoadBalancerForwardingRuleHealthCheck.

        The maximum number of attempts to reconnect to a target after a connection failure. Valid range is 0 to 65535 and default is three reconnection attempts.  # noqa: E501

        :param retries: The retries of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501
        :type retries: int
        """

        self._retries = retries

    @property
    def target_timeout(self):
        """Gets the target_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501

        The maximum time in milliseconds that a target can remain inactive; default is 50,000 (50 seconds).  # noqa: E501

        :return: The target_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501
        :rtype: int
        """
        return self._target_timeout

    @target_timeout.setter
    def target_timeout(self, target_timeout):
        """Sets the target_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.

        The maximum time in milliseconds that a target can remain inactive; default is 50,000 (50 seconds).  # noqa: E501

        :param target_timeout: The target_timeout of this NetworkLoadBalancerForwardingRuleHealthCheck.  # noqa: E501
        :type target_timeout: int
        """

        self._target_timeout = target_timeout
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkLoadBalancerForwardingRuleHealthCheck):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NetworkLoadBalancerForwardingRuleHealthCheck):
            return True

        return self.to_dict() != other.to_dict()
