# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.templatespecs.v2022_02_01 import TemplateSpecsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestTemplateSpecsTemplateSpecVersionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(TemplateSpecsClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_template_spec_versions_create_or_update(self, resource_group):
        response = self.client.template_spec_versions.create_or_update(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            template_spec_version="str",
            template_spec_version_model={
                "location": "str",
                "description": "str",
                "id": "str",
                "linkedTemplates": [{"path": "str", "template": {}}],
                "mainTemplate": {},
                "metadata": {},
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "uiFormDefinition": {},
            },
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_template_spec_versions_update(self, resource_group):
        response = self.client.template_spec_versions.update(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            template_spec_version="str",
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_template_spec_versions_get(self, resource_group):
        response = self.client.template_spec_versions.get(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            template_spec_version="str",
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_template_spec_versions_delete(self, resource_group):
        response = self.client.template_spec_versions.delete(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            template_spec_version="str",
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_template_spec_versions_list(self, resource_group):
        response = self.client.template_spec_versions.list(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            api_version="2022-02-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_template_spec_versions_list_built_ins(self, resource_group):
        response = self.client.template_spec_versions.list_built_ins(
            template_spec_name="str",
            api_version="2022-02-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_template_spec_versions_get_built_in(self, resource_group):
        response = self.client.template_spec_versions.get_built_in(
            template_spec_name="str",
            template_spec_version="str",
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...
