# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class ApiKey(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ApiKey."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class AutoGeneratedDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scope for dns deterministic name hash calculation."""

    TENANT_REUSE = "TenantReuse"


class AvailablePromotion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AvailablePromotion."""

    NONE = "None"
    FREE_TRIAL = "FreeTrial"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DeterministicOutboundIP(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DeterministicOutboundIP."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ManagedPrivateEndpointConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The approval/rejection status of managed private endpoint connection."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class MarketplaceAutoRenew(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The AutoRenew setting of the Enterprise subscription."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ProvisioningState."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    NOT_SPECIFIED = "NotSpecified"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicate the state for enable or disable traffic over the public interface."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class StartTLSPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The StartTLSPolicy setting of the SMTP configuration
    https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy.
    """

    OPPORTUNISTIC_START_TLS = "OpportunisticStartTLS"
    MANDATORY_START_TLS = "MandatoryStartTLS"
    NO_START_TLS = "NoStartTLS"


class ZoneRedundancy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ZoneRedundancy."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"
