# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, TYPE_CHECKING

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AaaaRecord(_serialization.Model):
    """An AAAA record.

    :ivar ipv6_address: The IPv6 address of this AAAA record.
    :vartype ipv6_address: str
    """

    _attribute_map = {
        "ipv6_address": {"key": "ipv6Address", "type": "str"},
    }

    def __init__(self, *, ipv6_address: Optional[str] = None, **kwargs):
        """
        :keyword ipv6_address: The IPv6 address of this AAAA record.
        :paramtype ipv6_address: str
        """
        super().__init__(**kwargs)
        self.ipv6_address = ipv6_address


class ARecord(_serialization.Model):
    """An A record.

    :ivar ipv4_address: The IPv4 address of this A record.
    :vartype ipv4_address: str
    """

    _attribute_map = {
        "ipv4_address": {"key": "ipv4Address", "type": "str"},
    }

    def __init__(self, *, ipv4_address: Optional[str] = None, **kwargs):
        """
        :keyword ipv4_address: The IPv4 address of this A record.
        :paramtype ipv4_address: str
        """
        super().__init__(**kwargs)
        self.ipv4_address = ipv4_address


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.privatedns.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.privatedns.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CnameRecord(_serialization.Model):
    """A CNAME record.

    :ivar cname: The canonical name for this CNAME record.
    :vartype cname: str
    """

    _attribute_map = {
        "cname": {"key": "cname", "type": "str"},
    }

    def __init__(self, *, cname: Optional[str] = None, **kwargs):
        """
        :keyword cname: The canonical name for this CNAME record.
        :paramtype cname: str
        """
        super().__init__(**kwargs)
        self.cname = cname


class MxRecord(_serialization.Model):
    """An MX record.

    :ivar preference: The preference value for this MX record.
    :vartype preference: int
    :ivar exchange: The domain name of the mail host for this MX record.
    :vartype exchange: str
    """

    _attribute_map = {
        "preference": {"key": "preference", "type": "int"},
        "exchange": {"key": "exchange", "type": "str"},
    }

    def __init__(self, *, preference: Optional[int] = None, exchange: Optional[str] = None, **kwargs):
        """
        :keyword preference: The preference value for this MX record.
        :paramtype preference: int
        :keyword exchange: The domain name of the mail host for this MX record.
        :paramtype exchange: str
        """
        super().__init__(**kwargs)
        self.preference = preference
        self.exchange = exchange


class Resource(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Example -
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Example -
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The Azure Region where the resource lives.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, location: Optional[str] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The Azure Region where the resource lives.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class PrivateZone(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Private DNS zone.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Example -
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The Azure Region where the resource lives.
    :vartype location: str
    :ivar etag: The ETag of the zone.
    :vartype etag: str
    :ivar max_number_of_record_sets: The maximum number of record sets that can be created in this
     Private DNS zone. This is a read-only property and any attempt to set this value will be
     ignored.
    :vartype max_number_of_record_sets: int
    :ivar number_of_record_sets: The current number of record sets in this Private DNS zone. This
     is a read-only property and any attempt to set this value will be ignored.
    :vartype number_of_record_sets: int
    :ivar max_number_of_virtual_network_links: The maximum number of virtual networks that can be
     linked to this Private DNS zone. This is a read-only property and any attempt to set this value
     will be ignored.
    :vartype max_number_of_virtual_network_links: int
    :ivar number_of_virtual_network_links: The current number of virtual networks that are linked
     to this Private DNS zone. This is a read-only property and any attempt to set this value will
     be ignored.
    :vartype number_of_virtual_network_links: int
    :ivar max_number_of_virtual_network_links_with_registration: The maximum number of virtual
     networks that can be linked to this Private DNS zone with registration enabled. This is a
     read-only property and any attempt to set this value will be ignored.
    :vartype max_number_of_virtual_network_links_with_registration: int
    :ivar number_of_virtual_network_links_with_registration: The current number of virtual networks
     that are linked to this Private DNS zone with registration enabled. This is a read-only
     property and any attempt to set this value will be ignored.
    :vartype number_of_virtual_network_links_with_registration: int
    :ivar provisioning_state: The provisioning state of the resource. This is a read-only property
     and any attempt to set this value will be ignored. Known values are: "Creating", "Updating",
     "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.privatedns.models.ProvisioningState
    :ivar internal_id: Private zone internal Id.
    :vartype internal_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "max_number_of_record_sets": {"readonly": True},
        "number_of_record_sets": {"readonly": True},
        "max_number_of_virtual_network_links": {"readonly": True},
        "number_of_virtual_network_links": {"readonly": True},
        "max_number_of_virtual_network_links_with_registration": {"readonly": True},
        "number_of_virtual_network_links_with_registration": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "internal_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "max_number_of_record_sets": {"key": "properties.maxNumberOfRecordSets", "type": "int"},
        "number_of_record_sets": {"key": "properties.numberOfRecordSets", "type": "int"},
        "max_number_of_virtual_network_links": {"key": "properties.maxNumberOfVirtualNetworkLinks", "type": "int"},
        "number_of_virtual_network_links": {"key": "properties.numberOfVirtualNetworkLinks", "type": "int"},
        "max_number_of_virtual_network_links_with_registration": {
            "key": "properties.maxNumberOfVirtualNetworkLinksWithRegistration",
            "type": "int",
        },
        "number_of_virtual_network_links_with_registration": {
            "key": "properties.numberOfVirtualNetworkLinksWithRegistration",
            "type": "int",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "internal_id": {"key": "properties.internalId", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The Azure Region where the resource lives.
        :paramtype location: str
        :keyword etag: The ETag of the zone.
        :paramtype etag: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.max_number_of_record_sets = None
        self.number_of_record_sets = None
        self.max_number_of_virtual_network_links = None
        self.number_of_virtual_network_links = None
        self.max_number_of_virtual_network_links_with_registration = None
        self.number_of_virtual_network_links_with_registration = None
        self.provisioning_state = None
        self.internal_id = None


class PrivateZoneListResult(_serialization.Model):
    """The response to a Private DNS zone list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Information about the Private DNS zones.
    :vartype value: list[~azure.mgmt.privatedns.models.PrivateZone]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateZone]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateZone"]] = None, **kwargs):
        """
        :keyword value: Information about the Private DNS zones.
        :paramtype value: list[~azure.mgmt.privatedns.models.PrivateZone]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProxyResource(Resource):
    """The resource model definition for an ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Example -
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class PtrRecord(_serialization.Model):
    """A PTR record.

    :ivar ptrdname: The PTR target domain name for this PTR record.
    :vartype ptrdname: str
    """

    _attribute_map = {
        "ptrdname": {"key": "ptrdname", "type": "str"},
    }

    def __init__(self, *, ptrdname: Optional[str] = None, **kwargs):
        """
        :keyword ptrdname: The PTR target domain name for this PTR record.
        :paramtype ptrdname: str
        """
        super().__init__(**kwargs)
        self.ptrdname = ptrdname


class RecordSet(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS zone.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Example -
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
    :vartype type: str
    :ivar etag: The ETag of the record set.
    :vartype etag: str
    :ivar metadata: The metadata attached to the record set.
    :vartype metadata: dict[str, str]
    :ivar ttl: The TTL (time-to-live) of the records in the record set.
    :vartype ttl: int
    :ivar fqdn: Fully qualified domain name of the record set.
    :vartype fqdn: str
    :ivar is_auto_registered: Is the record set auto-registered in the Private DNS zone through a
     virtual network link?.
    :vartype is_auto_registered: bool
    :ivar a_records: The list of A records in the record set.
    :vartype a_records: list[~azure.mgmt.privatedns.models.ARecord]
    :ivar aaaa_records: The list of AAAA records in the record set.
    :vartype aaaa_records: list[~azure.mgmt.privatedns.models.AaaaRecord]
    :ivar cname_record: The CNAME record in the record set.
    :vartype cname_record: ~azure.mgmt.privatedns.models.CnameRecord
    :ivar mx_records: The list of MX records in the record set.
    :vartype mx_records: list[~azure.mgmt.privatedns.models.MxRecord]
    :ivar ptr_records: The list of PTR records in the record set.
    :vartype ptr_records: list[~azure.mgmt.privatedns.models.PtrRecord]
    :ivar soa_record: The SOA record in the record set.
    :vartype soa_record: ~azure.mgmt.privatedns.models.SoaRecord
    :ivar srv_records: The list of SRV records in the record set.
    :vartype srv_records: list[~azure.mgmt.privatedns.models.SrvRecord]
    :ivar txt_records: The list of TXT records in the record set.
    :vartype txt_records: list[~azure.mgmt.privatedns.models.TxtRecord]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "fqdn": {"readonly": True},
        "is_auto_registered": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "ttl": {"key": "properties.ttl", "type": "int"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "is_auto_registered": {"key": "properties.isAutoRegistered", "type": "bool"},
        "a_records": {"key": "properties.aRecords", "type": "[ARecord]"},
        "aaaa_records": {"key": "properties.aaaaRecords", "type": "[AaaaRecord]"},
        "cname_record": {"key": "properties.cnameRecord", "type": "CnameRecord"},
        "mx_records": {"key": "properties.mxRecords", "type": "[MxRecord]"},
        "ptr_records": {"key": "properties.ptrRecords", "type": "[PtrRecord]"},
        "soa_record": {"key": "properties.soaRecord", "type": "SoaRecord"},
        "srv_records": {"key": "properties.srvRecords", "type": "[SrvRecord]"},
        "txt_records": {"key": "properties.txtRecords", "type": "[TxtRecord]"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        ttl: Optional[int] = None,
        a_records: Optional[List["_models.ARecord"]] = None,
        aaaa_records: Optional[List["_models.AaaaRecord"]] = None,
        cname_record: Optional["_models.CnameRecord"] = None,
        mx_records: Optional[List["_models.MxRecord"]] = None,
        ptr_records: Optional[List["_models.PtrRecord"]] = None,
        soa_record: Optional["_models.SoaRecord"] = None,
        srv_records: Optional[List["_models.SrvRecord"]] = None,
        txt_records: Optional[List["_models.TxtRecord"]] = None,
        **kwargs
    ):
        """
        :keyword etag: The ETag of the record set.
        :paramtype etag: str
        :keyword metadata: The metadata attached to the record set.
        :paramtype metadata: dict[str, str]
        :keyword ttl: The TTL (time-to-live) of the records in the record set.
        :paramtype ttl: int
        :keyword a_records: The list of A records in the record set.
        :paramtype a_records: list[~azure.mgmt.privatedns.models.ARecord]
        :keyword aaaa_records: The list of AAAA records in the record set.
        :paramtype aaaa_records: list[~azure.mgmt.privatedns.models.AaaaRecord]
        :keyword cname_record: The CNAME record in the record set.
        :paramtype cname_record: ~azure.mgmt.privatedns.models.CnameRecord
        :keyword mx_records: The list of MX records in the record set.
        :paramtype mx_records: list[~azure.mgmt.privatedns.models.MxRecord]
        :keyword ptr_records: The list of PTR records in the record set.
        :paramtype ptr_records: list[~azure.mgmt.privatedns.models.PtrRecord]
        :keyword soa_record: The SOA record in the record set.
        :paramtype soa_record: ~azure.mgmt.privatedns.models.SoaRecord
        :keyword srv_records: The list of SRV records in the record set.
        :paramtype srv_records: list[~azure.mgmt.privatedns.models.SrvRecord]
        :keyword txt_records: The list of TXT records in the record set.
        :paramtype txt_records: list[~azure.mgmt.privatedns.models.TxtRecord]
        """
        super().__init__(**kwargs)
        self.etag = etag
        self.metadata = metadata
        self.ttl = ttl
        self.fqdn = None
        self.is_auto_registered = None
        self.a_records = a_records
        self.aaaa_records = aaaa_records
        self.cname_record = cname_record
        self.mx_records = mx_records
        self.ptr_records = ptr_records
        self.soa_record = soa_record
        self.srv_records = srv_records
        self.txt_records = txt_records


class RecordSetListResult(_serialization.Model):
    """The response to a record set list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Information about the record sets in the response.
    :vartype value: list[~azure.mgmt.privatedns.models.RecordSet]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RecordSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.RecordSet"]] = None, **kwargs):
        """
        :keyword value: Information about the record sets in the response.
        :paramtype value: list[~azure.mgmt.privatedns.models.RecordSet]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SoaRecord(_serialization.Model):
    """An SOA record.

    :ivar host: The domain name of the authoritative name server for this SOA record.
    :vartype host: str
    :ivar email: The email contact for this SOA record.
    :vartype email: str
    :ivar serial_number: The serial number for this SOA record.
    :vartype serial_number: int
    :ivar refresh_time: The refresh value for this SOA record.
    :vartype refresh_time: int
    :ivar retry_time: The retry time for this SOA record.
    :vartype retry_time: int
    :ivar expire_time: The expire time for this SOA record.
    :vartype expire_time: int
    :ivar minimum_ttl: The minimum value for this SOA record. By convention this is used to
     determine the negative caching duration.
    :vartype minimum_ttl: int
    """

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "int"},
        "refresh_time": {"key": "refreshTime", "type": "int"},
        "retry_time": {"key": "retryTime", "type": "int"},
        "expire_time": {"key": "expireTime", "type": "int"},
        "minimum_ttl": {"key": "minimumTtl", "type": "int"},
    }

    def __init__(
        self,
        *,
        host: Optional[str] = None,
        email: Optional[str] = None,
        serial_number: Optional[int] = None,
        refresh_time: Optional[int] = None,
        retry_time: Optional[int] = None,
        expire_time: Optional[int] = None,
        minimum_ttl: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword host: The domain name of the authoritative name server for this SOA record.
        :paramtype host: str
        :keyword email: The email contact for this SOA record.
        :paramtype email: str
        :keyword serial_number: The serial number for this SOA record.
        :paramtype serial_number: int
        :keyword refresh_time: The refresh value for this SOA record.
        :paramtype refresh_time: int
        :keyword retry_time: The retry time for this SOA record.
        :paramtype retry_time: int
        :keyword expire_time: The expire time for this SOA record.
        :paramtype expire_time: int
        :keyword minimum_ttl: The minimum value for this SOA record. By convention this is used to
         determine the negative caching duration.
        :paramtype minimum_ttl: int
        """
        super().__init__(**kwargs)
        self.host = host
        self.email = email
        self.serial_number = serial_number
        self.refresh_time = refresh_time
        self.retry_time = retry_time
        self.expire_time = expire_time
        self.minimum_ttl = minimum_ttl


class SrvRecord(_serialization.Model):
    """An SRV record.

    :ivar priority: The priority value for this SRV record.
    :vartype priority: int
    :ivar weight: The weight value for this SRV record.
    :vartype weight: int
    :ivar port: The port value for this SRV record.
    :vartype port: int
    :ivar target: The target domain name for this SRV record.
    :vartype target: str
    """

    _attribute_map = {
        "priority": {"key": "priority", "type": "int"},
        "weight": {"key": "weight", "type": "int"},
        "port": {"key": "port", "type": "int"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self,
        *,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        port: Optional[int] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword priority: The priority value for this SRV record.
        :paramtype priority: int
        :keyword weight: The weight value for this SRV record.
        :paramtype weight: int
        :keyword port: The port value for this SRV record.
        :paramtype port: int
        :keyword target: The target domain name for this SRV record.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.priority = priority
        self.weight = weight
        self.port = port
        self.target = target


class SubResource(_serialization.Model):
    """Reference to another subresource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class TxtRecord(_serialization.Model):
    """A TXT record.

    :ivar value: The text value of this TXT record.
    :vartype value: list[str]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(self, *, value: Optional[List[str]] = None, **kwargs):
        """
        :keyword value: The text value of this TXT record.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.value = value


class VirtualNetworkLink(TrackedResource):
    """Describes a link to virtual network for a Private DNS zone.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Example -
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The Azure Region where the resource lives.
    :vartype location: str
    :ivar etag: The ETag of the virtual network link.
    :vartype etag: str
    :ivar virtual_network: The reference of the virtual network.
    :vartype virtual_network: ~azure.mgmt.privatedns.models.SubResource
    :ivar registration_enabled: Is auto-registration of virtual machine records in the virtual
     network in the Private DNS zone enabled?.
    :vartype registration_enabled: bool
    :ivar virtual_network_link_state: The status of the virtual network link to the Private DNS
     zone. Possible values are 'InProgress' and 'Done'. This is a read-only property and any attempt
     to set this value will be ignored. Known values are: "InProgress" and "Completed".
    :vartype virtual_network_link_state: str or
     ~azure.mgmt.privatedns.models.VirtualNetworkLinkState
    :ivar provisioning_state: The provisioning state of the resource. This is a read-only property
     and any attempt to set this value will be ignored. Known values are: "Creating", "Updating",
     "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.privatedns.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_network_link_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "SubResource"},
        "registration_enabled": {"key": "properties.registrationEnabled", "type": "bool"},
        "virtual_network_link_state": {"key": "properties.virtualNetworkLinkState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        etag: Optional[str] = None,
        virtual_network: Optional["_models.SubResource"] = None,
        registration_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The Azure Region where the resource lives.
        :paramtype location: str
        :keyword etag: The ETag of the virtual network link.
        :paramtype etag: str
        :keyword virtual_network: The reference of the virtual network.
        :paramtype virtual_network: ~azure.mgmt.privatedns.models.SubResource
        :keyword registration_enabled: Is auto-registration of virtual machine records in the virtual
         network in the Private DNS zone enabled?.
        :paramtype registration_enabled: bool
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.virtual_network = virtual_network
        self.registration_enabled = registration_enabled
        self.virtual_network_link_state = None
        self.provisioning_state = None


class VirtualNetworkLinkListResult(_serialization.Model):
    """The response to a list virtual network link to Private DNS zone operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Information about the virtual network links to the Private DNS zones.
    :vartype value: list[~azure.mgmt.privatedns.models.VirtualNetworkLink]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualNetworkLink"]] = None, **kwargs):
        """
        :keyword value: Information about the virtual network links to the Private DNS zones.
        :paramtype value: list[~azure.mgmt.privatedns.models.VirtualNetworkLink]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None
