import { Arbitrary } from '../../../check/arbitrary/definition/Arbitrary';
import { SizeForArbitrary } from './MaxLengthFromMinLength';
/**
 * Constraints for {@link anything} and {@link object}
 * @public
 */
export interface ObjectConstraints {
    /**
     * Limit the depth of the object by increasing the probability to generate simple values (defined via values)
     * as we go deeper in the object.
     *
     * Example of values: 0.1 (small impact as depth increases), 0.5, 1 (huge impact as depth increases).
     *
     * @remarks Since 2.20.0
     */
    depthFactor?: number;
    /**
     * Maximal depth allowed
     * @remarks Since 0.0.7
     */
    maxDepth?: number;
    /**
     * Maximal number of keys
     * @remarks Since 1.13.0
     */
    maxKeys?: number;
    /**
     * Define how large the generated values should be (at max)
     * @remarks Since 2.22.0
     */
    size?: SizeForArbitrary;
    /**
     * Arbitrary for keys
     *
     * Default for `key` is: {@link string}
     * @remarks Since 0.0.7
     */
    key?: Arbitrary<string>;
    /**
     * Arbitrary for values
     *
     * Default for `values` are:
     * - {@link boolean},
     * - {@link integer},
     * - {@link double},
     * - {@link string}
     * - constants among:
     *  - `null`,
     *  - `undefined`,
     *  - `Number.NaN`,
     *  - `+0`,
     *  - `-0`,
     *  - `Number.EPSILON`,
     *  - `Number.MIN_VALUE`,
     *  - `Number.MAX_VALUE`,
     *  - `Number.MIN_SAFE_INTEGER`,
     *  - `Number.MAX_SAFE_INTEGER`,
     *  - `Number.POSITIVE_INFINITY`,
     *  - `Number.NEGATIVE_INFINITY`
     * @remarks Since 0.0.7
     */
    values?: Arbitrary<unknown>[];
    /**
     * Also generate boxed versions of values
     * @remarks Since 1.11.0
     */
    withBoxedValues?: boolean;
    /**
     * Also generate Set
     * @remarks Since 1.11.0
     */
    withSet?: boolean;
    /**
     * Also generate Map
     * @remarks Since 1.11.0
     */
    withMap?: boolean;
    /**
     * Also generate string representations of object instances
     * @remarks Since 1.17.0
     */
    withObjectString?: boolean;
    /**
     * Also generate object with null prototype
     * @remarks Since 1.23.0
     */
    withNullPrototype?: boolean;
    /**
     * Also generate BigInt
     * @remarks Since 1.26.0
     */
    withBigInt?: boolean;
    /**
     * Also generate Date
     * @remarks Since 2.5.0
     */
    withDate?: boolean;
    /**
     * Also generate typed arrays in: (Uint|Int)(8|16|32)Array and Float(32|64)Array
     * Remark: no typed arrays made of bigint
     * @remarks Since 2.9.0
     */
    withTypedArray?: boolean;
    /**
     * Also generate sparse arrays (arrays with holes)
     * @remarks Since 2.13.0
     */
    withSparseArray?: boolean;
}
