//// [nestedExcessPropertyChecking.ts]
type A1 = { x: { a?: string } };
type B1 = { x: { b?: string } };

type C1 = { x: { c: string } };

const ab1: A1 & B1 = {} as C1;  // Error

type A2 = { a?: string };
type B2 = { b?: string };

type C2 = { c: string };

const ab2: A2 & B2 = {} as C2;  // Error

enum E { A = "A" }

let x: { nope?: any } = E.A;  // Error
let y: { nope?: any } = "A";  // Error

// Repros from #51043

type OverridesInput = {
    someProp?: 'A' | 'B'
}

const foo1: Partial<{ something: any }> & { variables: {
    overrides?: OverridesInput;
} & Partial<{
    overrides?: OverridesInput;
}>} = { variables: { overrides: false } };  // Error


interface Unrelated { _?: any }

interface VariablesA { overrides?: OverridesInput; }
interface VariablesB { overrides?: OverridesInput; }

const foo2: Unrelated & { variables: VariablesA & VariablesB } = {
    variables: {
        overrides: false  // Error
    }
};


//// [nestedExcessPropertyChecking.js]
"use strict";
var ab1 = {}; // Error
var ab2 = {}; // Error
var E;
(function (E) {
    E["A"] = "A";
})(E || (E = {}));
var x = E.A; // Error
var y = "A"; // Error
var foo1 = { variables: { overrides: false } }; // Error
var foo2 = {
    variables: {
        overrides: false // Error
    }
};
