/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_k_csk.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  double t73, t77, t79, t81, t87, t89, t90, t91;
  double t93, t94, t96, t97, t98, t100, t102, t107;
  double tvrho0, t110, t111, t114, t117, t118, t121, t123;
  double t127, tvsigma0, t129, t135, t136, t139, t141, t145;
  double tvlapl0, tvtau0;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t73 = t21 / t22;
  t77 = t34 * rho[0];
  t79 = 0.1e1 / t23 / t77;
  t81 = t30 * t33 * t79;
  t87 = -0.25e2 / 0.162e3 * t30 * t40 * t36 + 0.4e2 / 0.243e3 * t81;
  t89 = t64 * t61;
  t90 = my_piecewise3(t55, 0, t87);
  t91 = my_piecewise3(t57, t90, 0);
  t93 = fabs(t58) / t58;
  t94 = 0.1e1 / t59;
  t96 = 0.1e1 / t63;
  t97 = t62 * t96;
  t98 = t93 * t94 * t97;
  t100 = my_piecewise5(t52, 0, t55, 0, -t89 * t91 * t98);
  t102 = -0.5e1 / 0.27e2 * t81 + t87 * t65 + t47 * t100;
  t107 = my_piecewise3(t3, 0, t8 * t73 * t67 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tvrho0 = 0.2e1 * rho[0] * t107 + 0.2e1 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t110 = t32 * t36;
  t111 = t30 * t110;
  t114 = t30 * t110 * t65;
  t117 = my_piecewise3(t55, 0, -0.5e1 / 0.81e2 * t111);
  t118 = my_piecewise3(t57, t117, 0);
  t121 = my_piecewise5(t52, 0, t55, 0, -t89 * t118 * t98);
  t123 = 0.5e1 / 0.72e2 * t111 - 0.5e1 / 0.81e2 * t114 + t47 * t121;
  t127 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t123);
  tvsigma0 = 0.2e1 * rho[0] * t127;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t129 = t32 * t42;
  t135 = my_piecewise3(t55, 0, 0.5e1 / 0.54e2 * t30 * t129);
  t136 = my_piecewise3(t57, t135, 0);
  t139 = my_piecewise5(t52, 0, t55, 0, -t89 * t136 * t98);
  t141 = 0.5e1 / 0.54e2 * t30 * t129 * t65 + t47 * t139;
  t145 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t141);
  tvlapl0 = 0.2e1 * rho[0] * t145;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  double t73, t77, t79, t81, t87, t89, t90, t91;
  double t93, t94, t96, t97, t98, t100, t102, t107;
  double tvrho0, t110, t111, t114, t117, t118, t121, t123;
  double t127, tvsigma0, t129, t135, t136, t139, t141, t145;
  double tvlapl0, tvtau0;

  double t150, t157, t159, t161, t167, t171, t173, t174;
  double t176, t177, t178, t179, t180, t181, t182, t183;
  double t184, t186, t188, t189, t190, t192, t193, t196;
  double t197, t199, t200, t201, t203, t205, t206, t207;
  double t210, t212, t217, tv2rho20, t223, t224, t227, t230;
  double t233, t234, t235, t236, t238, t239, t241, t244;
  double t245, t248, t250, t251, t252, t254, t256, t257;
  double t260, t262, t267, tv2rhosigma0, t278, t279, t281, t282;
  double t285, t286, t289, t291, t293, t297, t299, t304;
  double tv2rholapl0, tv2rhotau0, t308, t310, t313, t316, t317, t319;
  double t320, t321, t323, t327, t329, t333, tv2sigma20, t339;
  double t343, t345, t346, t347, t348, t349, t352, t353;
  double t356, t358, t362, tv2sigmalapl0, tv2sigmatau0, t367, t370, t373;
  double t374, t376, t380, t382, t386, tv2lapl20, tv2lapltau0, tv2tau20;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t73 = t21 / t22;
  t77 = t34 * rho[0];
  t79 = 0.1e1 / t23 / t77;
  t81 = t30 * t33 * t79;
  t87 = -0.25e2 / 0.162e3 * t30 * t40 * t36 + 0.4e2 / 0.243e3 * t81;
  t89 = t64 * t61;
  t90 = my_piecewise3(t55, 0, t87);
  t91 = my_piecewise3(t57, t90, 0);
  t93 = fabs(t58) / t58;
  t94 = 0.1e1 / t59;
  t96 = 0.1e1 / t63;
  t97 = t62 * t96;
  t98 = t93 * t94 * t97;
  t100 = my_piecewise5(t52, 0, t55, 0, -t89 * t91 * t98);
  t102 = -0.5e1 / 0.27e2 * t81 + t87 * t65 + t47 * t100;
  t107 = my_piecewise3(t3, 0, t8 * t73 * t67 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tvrho0 = 0.2e1 * rho[0] * t107 + 0.2e1 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t110 = t32 * t36;
  t111 = t30 * t110;
  t114 = t30 * t110 * t65;
  t117 = my_piecewise3(t55, 0, -0.5e1 / 0.81e2 * t111);
  t118 = my_piecewise3(t57, t117, 0);
  t121 = my_piecewise5(t52, 0, t55, 0, -t89 * t118 * t98);
  t123 = 0.5e1 / 0.72e2 * t111 - 0.5e1 / 0.81e2 * t114 + t47 * t121;
  t127 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t123);
  tvsigma0 = 0.2e1 * rho[0] * t127;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t129 = t32 * t42;
  t135 = my_piecewise3(t55, 0, 0.5e1 / 0.54e2 * t30 * t129);
  t136 = my_piecewise3(t57, t135, 0);
  t139 = my_piecewise5(t52, 0, t55, 0, -t89 * t136 * t98);
  t141 = 0.5e1 / 0.54e2 * t30 * t129 * t65 + t47 * t139;
  t145 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t141);
  tvlapl0 = 0.2e1 * rho[0] * t145;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t150 = t21 / t22 / rho[0];
  t157 = t34 * t34;
  t159 = 0.1e1 / t23 / t157;
  t161 = t30 * t33 * t159;
  t167 = 0.1e3 / 0.243e3 * t30 * t40 * t79 - 0.44e3 / 0.729e3 * t161;
  t171 = t60 * t60;
  t173 = t64 / t171;
  t174 = t91 * t91;
  t176 = t93 * t93;
  t177 = t59 * t59;
  t178 = 0.1e1 / t177;
  t179 = t176 * t178;
  t180 = t62 * t62;
  t181 = t63 * t63;
  t182 = 0.1e1 / t181;
  t183 = t180 * t182;
  t184 = t179 * t183;
  t186 = t174 * t176;
  t188 = t178 * t62;
  t189 = t96 * params->csk_a;
  t190 = t188 * t189;
  t192 = my_piecewise3(t55, 0, t167);
  t193 = my_piecewise3(t57, t192, 0);
  t196 = t89 * t174;
  t197 = 0.0;
  t199 = t197 * t94 * t97;
  t200 = t196 * t199;
  t201 = t179 * t97;
  t203 = t173 * t186;
  t205 = t178 * t180;
  t206 = t182 * params->csk_a;
  t207 = t205 * t206;
  t210 = my_piecewise5(t52, 0, t55, 0, t173 * t174 * t184 + t89 * t186 * t190 - t89 * t193 * t98 - t203 * t190 + t196 * t201 - t203 * t207 - t200);
  t212 = 0.55e2 / 0.81e2 * t161 + t167 * t65 + 0.2e1 * t87 * t100 + t47 * t210;
  t217 = my_piecewise3(t3, 0, -t8 * t150 * t67 / 0.3e2 + t8 * t73 * t102 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t212);
  tv2rho20 = 0.2e1 * rho[0] * t217 + 0.4e1 * t107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t223 = t32 * t79;
  t224 = t30 * t223;
  t227 = t30 * t223 * t65;
  t230 = t30 * t110 * t100;
  t233 = t91 * t176;
  t234 = t173 * t233;
  t235 = t182 * t118;
  t236 = t205 * t235;
  t238 = t118 * t176;
  t239 = t89 * t238;
  t241 = t188 * t189 * t91;
  t244 = my_piecewise3(t55, 0, 0.4e2 / 0.243e3 * t224);
  t245 = my_piecewise3(t57, t244, 0);
  t248 = t118 * t91;
  t250 = t89 * t248 * t199;
  t251 = t96 * t91;
  t252 = t188 * t251;
  t254 = t173 * t238;
  t256 = t206 * t91;
  t257 = t205 * t256;
  t260 = my_piecewise5(t52, 0, t55, 0, -t89 * t245 * t98 + t234 * t236 + t239 * t241 + t239 * t252 - t254 * t241 - t254 * t257 - t250);
  t262 = -0.5e1 / 0.27e2 * t224 + 0.4e2 / 0.243e3 * t227 - 0.5e1 / 0.81e2 * t230 + t87 * t121 + t47 * t260;
  t267 = my_piecewise3(t3, 0, t8 * t73 * t123 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t262);
  tv2rhosigma0 = 0.2e1 * rho[0] * t267 + 0.2e1 * t127;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t278 = t182 * t136;
  t279 = t205 * t278;
  t281 = t136 * t176;
  t282 = t89 * t281;
  t285 = my_piecewise3(t55, 0, -0.25e2 / 0.162e3 * t111);
  t286 = my_piecewise3(t57, t285, 0);
  t289 = t136 * t91;
  t291 = t89 * t289 * t199;
  t293 = t173 * t281;
  t297 = my_piecewise5(t52, 0, t55, 0, -t89 * t286 * t98 + t234 * t279 + t282 * t241 - t293 * t241 + t282 * t252 - t293 * t257 - t291);
  t299 = -0.25e2 / 0.162e3 * t114 + 0.5e1 / 0.54e2 * t30 * t129 * t100 + t87 * t139 + t47 * t297;
  t304 = my_piecewise3(t3, 0, t8 * t73 * t141 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t299);
  tv2rholapl0 = 0.2e1 * rho[0] * t304 + 0.2e1 * t145;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t308 = t30 * t110 * t121;
  t310 = t118 * t118;
  t313 = t310 * t176;
  t316 = my_piecewise3(t55, 0, 0);
  t317 = my_piecewise3(t57, t316, 0);
  t319 = t89 * t317 * t98;
  t320 = t89 * t310;
  t321 = t320 * t199;
  t323 = t173 * t313;
  t327 = my_piecewise5(t52, 0, t55, 0, t173 * t310 * t184 + t89 * t313 * t190 - t323 * t190 + t320 * t201 - t323 * t207 - t319 - t321);
  t329 = -0.1e2 / 0.81e2 * t308 + t47 * t327;
  t333 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t329);
  tv2sigma20 = 0.2e1 * rho[0] * t333;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t339 = t30 * t110 * t139;
  t343 = t188 * t189 * t118;
  t345 = t136 * t118;
  t346 = t89 * t345;
  t347 = t346 * t199;
  t348 = t96 * t118;
  t349 = t188 * t348;
  t352 = t206 * t118;
  t353 = t205 * t352;
  t356 = my_piecewise5(t52, 0, t55, 0, t254 * t279 + t282 * t343 + t282 * t349 - t293 * t343 - t293 * t353 - t319 - t347);
  t358 = 0.5e1 / 0.54e2 * t30 * t129 * t121 - 0.5e1 / 0.81e2 * t339 + t47 * t356;
  t362 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t358);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t362;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t367 = t136 * t136;
  t370 = t367 * t176;
  t373 = t89 * t367;
  t374 = t373 * t199;
  t376 = t173 * t370;
  t380 = my_piecewise5(t52, 0, t55, 0, t173 * t367 * t184 + t89 * t370 * t190 - t376 * t190 + t373 * t201 - t376 * t207 - t319 - t374);
  t382 = 0.5e1 / 0.27e2 * t30 * t129 * t139 + t47 * t380;
  t386 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t382);
  tv2lapl20 = 0.2e1 * rho[0] * t386;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  double t73, t77, t79, t81, t87, t89, t90, t91;
  double t93, t94, t96, t97, t98, t100, t102, t107;
  double tvrho0, t110, t111, t114, t117, t118, t121, t123;
  double t127, tvsigma0, t129, t135, t136, t139, t141, t145;
  double tvlapl0, tvtau0;

  double t150, t157, t159, t161, t167, t171, t173, t174;
  double t176, t177, t178, t179, t180, t181, t182, t183;
  double t184, t186, t188, t189, t190, t192, t193, t196;
  double t197, t199, t200, t201, t203, t205, t206, t207;
  double t210, t212, t217, tv2rho20, t223, t224, t227, t230;
  double t233, t234, t235, t236, t238, t239, t241, t244;
  double t245, t248, t250, t251, t252, t254, t256, t257;
  double t260, t262, t267, tv2rhosigma0, t278, t279, t281, t282;
  double t285, t286, t289, t291, t293, t297, t299, t304;
  double tv2rholapl0, tv2rhotau0, t308, t310, t313, t316, t317, t319;
  double t320, t321, t323, t327, t329, t333, tv2sigma20, t339;
  double t343, t345, t346, t347, t348, t349, t352, t353;
  double t356, t358, t362, tv2sigmalapl0, tv2sigmatau0, t367, t370, t373;
  double t374, t376, t380, t382, t386, tv2lapl20, tv2lapltau0, tv2tau20;

  double t391, t403, t405, t411, t417, t419, t421, t422;
  double t423, t427, t432, t434, t436, t437, t438, t440;
  double t441, t444, t445, t448, t449, t450, t452, t453;
  double t454, t457, t458, t464, t465, t467, t469, t470;
  double t471, t473, t474, t475, t476, t480, t481, t482;
  double t484, t489, t490, t491, t493, t496, t497, t498;
  double t501, t502, t503, t504, t509, t513, t514, t515;
  double t518, t519, t522, t524, t528, t529, t532, t534;
  double t536, t541, tv3rho30, t551, t552, t555, t558, t561;
  double t567, t568, t571, t572, t573, t574, t575, t577;
  double t580, t581, t583, t584, t586, t587, t590, t591;
  double t594, t597, t598, t599, t601, t602, t603, t612;
  double t615, t616, t618, t619, t622, t623, t624, t627;
  double t630, t636, t637, t638, t640, t641, t642, t644;
  double t645, t646, t648, t652, t653, t656, t657, t661;
  double t662, t667, t669, t673, t674, t675, t677, t679;
  double t681, t686, tv3rho2sigma0, t705, t706, t709, t710, t713;
  double t714, t717, t720, t721, t727, t735, t736, t737;
  double t740, t746, t747, t748, t749, t750, t752, t757;
  double t759, t760, t761, t764, t765, t766, t770, t776;
  double t777, t780, t782, t784, t788, t790, t792, t794;
  double t799, tv3rho2lapl0, tv3rho2tau0, t806, t809, t812, t813, t815;
  double t816, t819, t820, t823, t824, t825, t829, t832;
  double t833, t836, t837, t838, t839, t840, t842, t843;
  double t849, t850, t851, t852, t853, t854, t856, t857;
  double t860, t864, t865, t866, t867, t870, t871, t872;
  double t873, t875, t876, t877, t878, t880, t884, t889;
  double t890, t891, t892, t893, t896, t901, t902, t903;
  double t904, t906, t907, t908, t909, t911, t912, t913;
  double t914, t915, t917, t918, t919, t922, t924, t926;
  double t931, tv3rhosigma20, t942, t945, t948, t949, t951, t952;
  double t954, t955, t956, t957, t959, t960, t961, t967;
  double t968, t972, t973, t976, t977, t980, t981, t982;
  double t983, t984, t987, t988, t989, t990, t991, t994;
  double t995, t996, t998, t1001, t1003, t1005, t1008, t1011;
  double t1012, t1013, t1014, t1016, t1021, t1022, t1028, t1030;
  double t1031, t1033, t1036, t1038, t1040, t1045, tv3rhosigmalapl0, tv3rhosigmatau0;
  double t1056, t1057, t1060, t1061, t1064, t1065, t1066, t1068;
  double t1073, t1076, t1090, t1091, t1092, t1094, t1098, t1099;
  double t1102, t1103, t1105, t1113, t1114, t1116, t1117, t1118;
  double t1120, t1121, t1125, t1127, t1129, t1134, tv3rholapl20, tv3rholapltau0;
  double tv3rhotau20, t1138, t1140, t1149, t1150, t1151, t1152, t1153;
  double t1154, t1155, t1156, t1157, t1158, t1159, t1160, t1161;
  double t1163, t1164, t1165, t1166, t1167, t1168, t1171, t1174;
  double t1175, t1177, t1178, t1181, t1182, t1186, t1187, t1188;
  double t1189, t1191, t1192, t1195, t1204, t1206, t1208, t1212;
  double tv3sigma30, t1218, t1221, t1222, t1229, t1230, t1235, t1236;
  double t1237, t1238, t1239, t1240, t1241, t1242, t1243, t1244;
  double t1245, t1248, t1249, t1252, t1255, t1256, t1257, t1258;
  double t1261, t1262, t1263, t1264, t1265, t1266, t1267, t1268;
  double t1269, t1270, t1271, t1272, t1273, t1274, t1275, t1276;
  double t1277, t1278, t1279, t1281, t1283, t1286, t1287, t1290;
  double t1292, t1294, t1298, tv3sigma2lapl0, tv3sigma2tau0, t1304, t1306, t1307;
  double t1310, t1311, t1314, t1315, t1321, t1322, t1327, t1337;
  double t1338, t1339, t1340, t1341, t1342, t1343, t1345, t1346;
  double t1348, t1349, t1350, t1351, t1352, t1353, t1354, t1355;
  double t1356, t1363, t1365, t1367, t1371, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20;
  double t1376, t1385, t1386, t1387, t1388, t1389, t1390, t1391;
  double t1393, t1394, t1395, t1396, t1397, t1398, t1399, t1400;
  double t1401, t1402, t1403, t1406, t1413, t1416, t1417, t1418;
  double t1420, t1421, t1430, t1432, t1434, t1438, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, tv3tau30;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t73 = t21 / t22;
  t77 = t34 * rho[0];
  t79 = 0.1e1 / t23 / t77;
  t81 = t30 * t33 * t79;
  t87 = -0.25e2 / 0.162e3 * t30 * t40 * t36 + 0.4e2 / 0.243e3 * t81;
  t89 = t64 * t61;
  t90 = my_piecewise3(t55, 0, t87);
  t91 = my_piecewise3(t57, t90, 0);
  t93 = fabs(t58) / t58;
  t94 = 0.1e1 / t59;
  t96 = 0.1e1 / t63;
  t97 = t62 * t96;
  t98 = t93 * t94 * t97;
  t100 = my_piecewise5(t52, 0, t55, 0, -t89 * t91 * t98);
  t102 = -0.5e1 / 0.27e2 * t81 + t87 * t65 + t47 * t100;
  t107 = my_piecewise3(t3, 0, t8 * t73 * t67 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tvrho0 = 0.2e1 * rho[0] * t107 + 0.2e1 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t110 = t32 * t36;
  t111 = t30 * t110;
  t114 = t30 * t110 * t65;
  t117 = my_piecewise3(t55, 0, -0.5e1 / 0.81e2 * t111);
  t118 = my_piecewise3(t57, t117, 0);
  t121 = my_piecewise5(t52, 0, t55, 0, -t89 * t118 * t98);
  t123 = 0.5e1 / 0.72e2 * t111 - 0.5e1 / 0.81e2 * t114 + t47 * t121;
  t127 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t123);
  tvsigma0 = 0.2e1 * rho[0] * t127;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t129 = t32 * t42;
  t135 = my_piecewise3(t55, 0, 0.5e1 / 0.54e2 * t30 * t129);
  t136 = my_piecewise3(t57, t135, 0);
  t139 = my_piecewise5(t52, 0, t55, 0, -t89 * t136 * t98);
  t141 = 0.5e1 / 0.54e2 * t30 * t129 * t65 + t47 * t139;
  t145 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t141);
  tvlapl0 = 0.2e1 * rho[0] * t145;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t150 = t21 / t22 / rho[0];
  t157 = t34 * t34;
  t159 = 0.1e1 / t23 / t157;
  t161 = t30 * t33 * t159;
  t167 = 0.1e3 / 0.243e3 * t30 * t40 * t79 - 0.44e3 / 0.729e3 * t161;
  t171 = t60 * t60;
  t173 = t64 / t171;
  t174 = t91 * t91;
  t176 = t93 * t93;
  t177 = t59 * t59;
  t178 = 0.1e1 / t177;
  t179 = t176 * t178;
  t180 = t62 * t62;
  t181 = t63 * t63;
  t182 = 0.1e1 / t181;
  t183 = t180 * t182;
  t184 = t179 * t183;
  t186 = t174 * t176;
  t188 = t178 * t62;
  t189 = t96 * params->csk_a;
  t190 = t188 * t189;
  t192 = my_piecewise3(t55, 0, t167);
  t193 = my_piecewise3(t57, t192, 0);
  t196 = t89 * t174;
  t197 = 0.0;
  t199 = t197 * t94 * t97;
  t200 = t196 * t199;
  t201 = t179 * t97;
  t203 = t173 * t186;
  t205 = t178 * t180;
  t206 = t182 * params->csk_a;
  t207 = t205 * t206;
  t210 = my_piecewise5(t52, 0, t55, 0, t173 * t174 * t184 + t89 * t186 * t190 - t89 * t193 * t98 - t203 * t190 + t196 * t201 - t203 * t207 - t200);
  t212 = 0.55e2 / 0.81e2 * t161 + t167 * t65 + 0.2e1 * t87 * t100 + t47 * t210;
  t217 = my_piecewise3(t3, 0, -t8 * t150 * t67 / 0.3e2 + t8 * t73 * t102 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t212);
  tv2rho20 = 0.2e1 * rho[0] * t217 + 0.4e1 * t107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t223 = t32 * t79;
  t224 = t30 * t223;
  t227 = t30 * t223 * t65;
  t230 = t30 * t110 * t100;
  t233 = t91 * t176;
  t234 = t173 * t233;
  t235 = t182 * t118;
  t236 = t205 * t235;
  t238 = t118 * t176;
  t239 = t89 * t238;
  t241 = t188 * t189 * t91;
  t244 = my_piecewise3(t55, 0, 0.4e2 / 0.243e3 * t224);
  t245 = my_piecewise3(t57, t244, 0);
  t248 = t118 * t91;
  t250 = t89 * t248 * t199;
  t251 = t96 * t91;
  t252 = t188 * t251;
  t254 = t173 * t238;
  t256 = t206 * t91;
  t257 = t205 * t256;
  t260 = my_piecewise5(t52, 0, t55, 0, -t89 * t245 * t98 + t234 * t236 + t239 * t241 + t239 * t252 - t254 * t241 - t254 * t257 - t250);
  t262 = -0.5e1 / 0.27e2 * t224 + 0.4e2 / 0.243e3 * t227 - 0.5e1 / 0.81e2 * t230 + t87 * t121 + t47 * t260;
  t267 = my_piecewise3(t3, 0, t8 * t73 * t123 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t262);
  tv2rhosigma0 = 0.2e1 * rho[0] * t267 + 0.2e1 * t127;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t278 = t182 * t136;
  t279 = t205 * t278;
  t281 = t136 * t176;
  t282 = t89 * t281;
  t285 = my_piecewise3(t55, 0, -0.25e2 / 0.162e3 * t111);
  t286 = my_piecewise3(t57, t285, 0);
  t289 = t136 * t91;
  t291 = t89 * t289 * t199;
  t293 = t173 * t281;
  t297 = my_piecewise5(t52, 0, t55, 0, -t89 * t286 * t98 + t234 * t279 + t282 * t241 - t293 * t241 + t282 * t252 - t293 * t257 - t291);
  t299 = -0.25e2 / 0.162e3 * t114 + 0.5e1 / 0.54e2 * t30 * t129 * t100 + t87 * t139 + t47 * t297;
  t304 = my_piecewise3(t3, 0, t8 * t73 * t141 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t299);
  tv2rholapl0 = 0.2e1 * rho[0] * t304 + 0.2e1 * t145;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t308 = t30 * t110 * t121;
  t310 = t118 * t118;
  t313 = t310 * t176;
  t316 = my_piecewise3(t55, 0, 0);
  t317 = my_piecewise3(t57, t316, 0);
  t319 = t89 * t317 * t98;
  t320 = t89 * t310;
  t321 = t320 * t199;
  t323 = t173 * t313;
  t327 = my_piecewise5(t52, 0, t55, 0, t173 * t310 * t184 + t89 * t313 * t190 - t323 * t190 + t320 * t201 - t323 * t207 - t319 - t321);
  t329 = -0.1e2 / 0.81e2 * t308 + t47 * t327;
  t333 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t329);
  tv2sigma20 = 0.2e1 * rho[0] * t333;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t339 = t30 * t110 * t139;
  t343 = t188 * t189 * t118;
  t345 = t136 * t118;
  t346 = t89 * t345;
  t347 = t346 * t199;
  t348 = t96 * t118;
  t349 = t188 * t348;
  t352 = t206 * t118;
  t353 = t205 * t352;
  t356 = my_piecewise5(t52, 0, t55, 0, t254 * t279 + t282 * t343 + t282 * t349 - t293 * t343 - t293 * t353 - t319 - t347);
  t358 = 0.5e1 / 0.54e2 * t30 * t129 * t121 - 0.5e1 / 0.81e2 * t339 + t47 * t356;
  t362 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t358);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t362;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t367 = t136 * t136;
  t370 = t367 * t176;
  t373 = t89 * t367;
  t374 = t373 * t199;
  t376 = t173 * t370;
  t380 = my_piecewise5(t52, 0, t55, 0, t173 * t367 * t184 + t89 * t370 * t190 - t376 * t190 + t373 * t201 - t376 * t207 - t319 - t374);
  t382 = 0.5e1 / 0.27e2 * t30 * t129 * t139 + t47 * t380;
  t386 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t382);
  tv2lapl20 = 0.2e1 * rho[0] * t386;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t391 = t21 / t22 / t34;
  t403 = 0.1e1 / t23 / t157 / rho[0];
  t405 = t30 * t33 * t403;
  t411 = -0.11e4 / 0.729e3 * t30 * t40 * t159 + 0.616e4 / 0.2187e4 * t405;
  t417 = t174 * t91;
  t419 = t176 * t93;
  t421 = 0.1e1 / t177 / t59;
  t422 = t419 * t421;
  t423 = t422 * t183;
  t427 = t422 * t97;
  t432 = t64 / t171 / t60;
  t434 = t180 * t62;
  t436 = 0.1e1 / t181 / t63;
  t437 = t434 * t436;
  t438 = t422 * t437;
  t440 = my_piecewise3(t55, 0, t411);
  t441 = my_piecewise3(t57, t440, 0);
  t444 = t193 * t176;
  t445 = t173 * t444;
  t448 = t417 * t197;
  t449 = t173 * t448;
  t450 = t178 * params->csk_a;
  t452 = t93 * t62 * t96;
  t453 = t450 * t452;
  t454 = t449 * t453;
  t457 = t189 * t193;
  t458 = t188 * t457;
  t464 = t205 * t206 * t93;
  t465 = t449 * t464;
  t467 = t417 * t93;
  t469 = t189 * t197;
  t470 = t188 * t469;
  t471 = t89 * t467 * t470;
  t473 = t417 * t419;
  t474 = t173 * t473;
  t475 = t421 * params->csk_a;
  t476 = t475 * t97;
  t480 = t182 * t197;
  t481 = t205 * t480;
  t482 = t173 * t467 * t481;
  t484 = -0.3e1 * t173 * t417 * t423 + 0.3e1 * t89 * t233 * t458 - 0.2e1 * t89 * t417 * t427 - t432 * t417 * t438 - t89 * t441 * t98 - 0.3e1 * t445 * t241 - 0.3e1 * t445 * t257 + 0.3e1 * t474 * t476 - t200 - 0.3e1 * t454 - 0.3e1 * t465 + 0.3e1 * t471 + 0.3e1 * t482;
  t489 = t96 * t93;
  t490 = t188 * t489;
  t491 = t89 * t448 * t490;
  t493 = t89 * t473;
  t496 = t432 * t473;
  t497 = t421 * t180;
  t498 = t497 * t206;
  t501 = t421 * t62;
  t502 = params->csk_a * params->csk_a;
  t503 = t96 * t502;
  t504 = t501 * t503;
  t509 = t182 * t193;
  t513 = t421 * t434;
  t514 = t436 * params->csk_a;
  t515 = t513 * t514;
  t518 = t182 * t502;
  t519 = t497 * t518;
  t522 = t193 * t91;
  t524 = t89 * t522 * t199;
  t528 = t436 * t502;
  t529 = t513 * t528;
  t532 = 0.3e1 * t234 * t205 * t509 + 0.3e1 * t89 * t444 * t252 + 0.3e1 * t474 * t504 + 0.3e1 * t474 * t519 - 0.3e1 * t493 * t476 - t493 * t504 + 0.3e1 * t496 * t498 - t496 * t504 + 0.3e1 * t496 * t515 - 0.3e1 * t496 * t519 - 0.2e1 * t496 * t529 + 0.3e1 * t491 - 0.3e1 * t524;
  t534 = my_piecewise5(t52, 0, t55, 0, t484 + t532);
  t536 = -0.77e3 / 0.243e3 * t405 + t411 * t65 + 0.3e1 * t167 * t100 + 0.3e1 * t87 * t210 + t47 * t534;
  t541 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t391 * t67 - t8 * t150 * t102 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t73 * t212 + 0.3e1 / 0.2e2 * t8 * t24 * t536);
  tv3rho30 = 0.2e1 * rho[0] * t541 + 0.6e1 * t217;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t551 = t32 * t159;
  t552 = t30 * t551;
  t555 = t30 * t551 * t65;
  t558 = t30 * t223 * t100;
  t561 = t30 * t110 * t210;
  t567 = my_piecewise3(t55, 0, -0.44e3 / 0.729e3 * t552);
  t568 = my_piecewise3(t57, t567, 0);
  t571 = t174 * t93;
  t572 = t173 * t571;
  t573 = t235 * t197;
  t574 = t205 * t573;
  t575 = t572 * t574;
  t577 = t118 * t174;
  t580 = t197 * t178 * t452;
  t581 = t89 * t577 * t580;
  t583 = t118 * t419;
  t584 = t173 * t583;
  t586 = t174 * t62 * t96;
  t587 = t475 * t586;
  t590 = t245 * t176;
  t591 = t173 * t590;
  t594 = t89 * t583;
  t597 = t432 * t583;
  t598 = t421 * t502;
  t599 = t598 * t586;
  t601 = t174 * t419;
  t602 = t432 * t601;
  t603 = t497 * t352;
  t612 = t598 * t174 * t180 * t182;
  t615 = t206 * t193;
  t616 = t205 * t615;
  t618 = t528 * t174;
  t619 = t513 * t618;
  t622 = t436 * t118;
  t623 = t622 * params->csk_a;
  t624 = t513 * t623;
  t627 = t89 * t590;
  t630 = -t89 * t568 * t98 - 0.2e1 * t591 * t241 + 0.2e1 * t627 * t241 - t254 * t458 - t254 * t616 + 0.3e1 * t584 * t587 + 0.3e1 * t584 * t599 - 0.3e1 * t594 * t587 - t594 * t599 - t597 * t599 - 0.3e1 * t597 * t612 - 0.2e1 * t597 * t619 + 0.3e1 * t602 * t603 + 0.3e1 * t602 * t624 + 0.3e1 * t575 + 0.3e1 * t581;
  t636 = t118 * t93;
  t637 = t636 * t178;
  t638 = t89 * t637;
  t640 = params->csk_a * t174 * t197;
  t641 = t97 * t640;
  t642 = t638 * t641;
  t644 = t577 * t197;
  t645 = t173 * t644;
  t646 = t645 * t464;
  t648 = t645 * t453;
  t652 = t173 * t601;
  t653 = t497 * t235;
  t656 = t96 * t174;
  t657 = t501 * t656;
  t661 = t182 * t245;
  t662 = t205 * t661;
  t667 = t245 * t91;
  t669 = t89 * t667 * t199;
  t673 = t89 * t118 * t193 * t199;
  t674 = t96 * t193;
  t675 = t188 * t674;
  t677 = -t602 * t513 * t622 + 0.2e1 * t234 * t662 + t445 * t236 + t239 * t458 + t239 * t675 + 0.2e1 * t627 * t252 - 0.2e1 * t591 * t257 + 0.3e1 * t584 * t612 - 0.2e1 * t594 * t657 - 0.3e1 * t652 * t653 - t250 + 0.3e1 * t642 - 0.3e1 * t646 - 0.3e1 * t648 - 0.2e1 * t669 - t673;
  t679 = my_piecewise5(t52, 0, t55, 0, t630 + t677);
  t681 = 0.55e2 / 0.81e2 * t552 - 0.44e3 / 0.729e3 * t555 + 0.8e2 / 0.243e3 * t558 - 0.5e1 / 0.81e2 * t561 + t167 * t121 + 0.2e1 * t87 * t260 + t47 * t679;
  t686 = my_piecewise3(t3, 0, -t8 * t150 * t123 / 0.3e2 + t8 * t73 * t262 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t681);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t686 + 0.4e1 * t267;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t705 = my_piecewise3(t55, 0, 0.1e3 / 0.243e3 * t224);
  t706 = my_piecewise3(t57, t705, 0);
  t709 = t136 * t419;
  t710 = t173 * t709;
  t713 = t286 * t176;
  t714 = t173 * t713;
  t717 = t89 * t709;
  t720 = t278 * params->csk_a;
  t721 = t497 * t720;
  t727 = t432 * t709;
  t735 = t436 * t136;
  t736 = t735 * params->csk_a;
  t737 = t513 * t736;
  t740 = t89 * t713;
  t746 = -t89 * t706 * t98 - 0.2e1 * t714 * t241 + 0.2e1 * t740 * t241 + t282 * t458 - t293 * t458 - t293 * t616 + 0.3e1 * t710 * t587 - 0.3e1 * t717 * t587 + 0.3e1 * t710 * t599 - t717 * t599 - t727 * t599 + 0.3e1 * t602 * t721 + 0.3e1 * t602 * t737 + 0.3e1 * t710 * t612 - 0.3e1 * t727 * t612 - 0.2e1 * t727 * t619;
  t747 = t136 * t174;
  t748 = t747 * t197;
  t749 = t173 * t748;
  t750 = t749 * t464;
  t752 = t749 * t453;
  t757 = t89 * t747 * t580;
  t759 = t278 * t197;
  t760 = t205 * t759;
  t761 = t572 * t760;
  t764 = t136 * t93 * t178;
  t765 = t89 * t764;
  t766 = t765 * t641;
  t770 = t497 * t278;
  t776 = t182 * t286;
  t777 = t205 * t776;
  t780 = t513 * t735;
  t782 = t286 * t91;
  t784 = t89 * t782 * t199;
  t788 = t89 * t136 * t193 * t199;
  t790 = 0.2e1 * t234 * t777 + 0.2e1 * t740 * t252 - 0.2e1 * t714 * t257 + t445 * t279 + t282 * t675 - t602 * t780 - 0.3e1 * t652 * t770 - 0.2e1 * t717 * t657 - t291 - 0.3e1 * t750 - 0.3e1 * t752 + 0.3e1 * t757 + 0.3e1 * t761 + 0.3e1 * t766 - 0.2e1 * t784 - t788;
  t792 = my_piecewise5(t52, 0, t55, 0, t746 + t790);
  t794 = 0.1e3 / 0.243e3 * t227 - 0.25e2 / 0.81e2 * t230 + 0.5e1 / 0.54e2 * t30 * t129 * t210 + t167 * t139 + 0.2e1 * t87 * t297 + t47 * t792;
  t799 = my_piecewise3(t3, 0, -t8 * t150 * t141 / 0.3e2 + t8 * t73 * t299 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t794);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t799 + 0.4e1 * t304;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t806 = t30 * t223 * t121;
  t809 = t30 * t110 * t260;
  t812 = t310 * t419;
  t813 = t173 * t812;
  t815 = t91 * t62 * t96;
  t816 = t475 * t815;
  t819 = t206 * t245;
  t820 = t205 * t819;
  t823 = t432 * t812;
  t824 = t528 * t91;
  t825 = t513 * t824;
  t829 = t188 * t189 * t245;
  t832 = t518 * t91;
  t833 = t497 * t832;
  t836 = t317 * t176;
  t837 = t173 * t836;
  t838 = t837 * t257;
  t839 = t310 * t197;
  t840 = t89 * t839;
  t842 = t188 * t251 * t93;
  t843 = t840 * t842;
  t849 = t310 * t93;
  t850 = t173 * t849;
  t851 = t182 * t91;
  t852 = t851 * t197;
  t853 = t205 * t852;
  t854 = t850 * t853;
  t856 = t514 * t91;
  t857 = t513 * t856;
  t860 = t89 * t812;
  t864 = t173 * t839 * t178;
  t865 = params->csk_a * t91;
  t866 = t865 * t452;
  t867 = t864 * t866;
  t870 = t89 * t849 * t178;
  t871 = t865 * t197;
  t872 = t97 * t871;
  t873 = t870 * t872;
  t875 = 0.2e1 * t239 * t829 - 0.2e1 * t254 * t820 - 0.2e1 * t254 * t829 + 0.3e1 * t813 * t816 + 0.3e1 * t813 * t833 - 0.3e1 * t860 * t816 - 0.2e1 * t823 * t825 - 0.3e1 * t823 * t833 + 0.3e1 * t823 * t857 - t319 - t321 - t838 + 0.3e1 * t843 + 0.3e1 * t854 - 0.3e1 * t867 + 0.3e1 * t873;
  t876 = t865 * t93;
  t877 = t183 * t876;
  t878 = t864 * t877;
  t880 = t497 * t256;
  t884 = t501 * t503 * t91;
  t889 = t89 * t836;
  t890 = t889 * t241;
  t891 = t837 * t241;
  t892 = t889 * t252;
  t893 = t501 * t251;
  t896 = t497 * t851;
  t901 = t91 * t419;
  t902 = t432 * t901;
  t903 = t436 * t310;
  t904 = t513 * t903;
  t906 = t182 * t317;
  t907 = t205 * t906;
  t908 = t234 * t907;
  t909 = t317 * t91;
  t911 = t89 * t909 * t199;
  t912 = t118 * t197;
  t913 = t89 * t912;
  t914 = t94 * t62;
  t915 = t96 * t245;
  t917 = t913 * t914 * t915;
  t918 = 0.2e1 * t917;
  t919 = t188 * t915;
  t922 = 0.2e1 * t239 * t919 + 0.2e1 * t254 * t662 + 0.3e1 * t813 * t884 - 0.3e1 * t813 * t896 + 0.3e1 * t823 * t880 - t823 * t884 - t860 * t884 - 0.2e1 * t860 * t893 - t902 * t904 - 0.3e1 * t878 + t890 - t891 + t892 + t908 - t911 - t918;
  t924 = my_piecewise5(t52, 0, t55, 0, t875 + t922);
  t926 = 0.8e2 / 0.243e3 * t806 - 0.1e2 / 0.81e2 * t809 + t87 * t327 + t47 * t924;
  t931 = my_piecewise3(t3, 0, t8 * t73 * t329 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t926);
  tv3rhosigma20 = 0.2e1 * rho[0] * t931 + 0.2e1 * t333;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t942 = t30 * t223 * t139;
  t945 = t30 * t110 * t297;
  t948 = t345 * t197;
  t949 = t173 * t948;
  t951 = t450 * t91 * t452;
  t952 = t949 * t951;
  t954 = t97 * params->csk_a;
  t955 = t248 * t197;
  t956 = t954 * t955;
  t957 = t765 * t956;
  t959 = t205 * t182;
  t960 = t959 * t876;
  t961 = t949 * t960;
  t967 = t622 * t136;
  t968 = t513 * t967;
  t972 = t348 * t91;
  t973 = t501 * t972;
  t976 = t278 * t91;
  t977 = t497 * t976;
  t980 = t709 * t421;
  t981 = t89 * t980;
  t982 = params->csk_a * t118;
  t983 = t982 * t91;
  t984 = t97 * t983;
  t987 = t583 * t421;
  t988 = t432 * t987;
  t989 = t136 * params->csk_a;
  t990 = t989 * t91;
  t991 = t183 * t990;
  t994 = t502 * t118;
  t995 = t994 * t91;
  t996 = t97 * t995;
  t998 = t173 * t980;
  t1001 = t432 * t980;
  t1003 = -t1001 * t996 + t282 * t829 - t293 * t820 - t293 * t829 - t714 * t343 + t740 * t343 - t714 * t353 - 0.3e1 * t584 * t977 - 0.2e1 * t717 * t973 - t902 * t968 - 0.3e1 * t981 * t984 - t981 * t996 + 0.3e1 * t988 * t991 + 0.3e1 * t998 * t996 - t319 - t838 - 0.3e1 * t952 + 0.3e1 * t957 - 0.3e1 * t961;
  t1005 = t994 * t183 * t91;
  t1008 = t437 * t995;
  t1011 = t173 * t637;
  t1012 = t289 * t197;
  t1013 = t183 * t1012;
  t1014 = t1011 * t1013;
  t1016 = t437 * t990;
  t1021 = t89 * t948;
  t1022 = t1021 * t842;
  t1028 = t286 * t118;
  t1030 = t89 * t1028 * t199;
  t1031 = t136 * t245;
  t1033 = t89 * t1031 * t199;
  t1036 = -0.3e1 * t1001 * t1005 - 0.2e1 * t1001 * t1008 + 0.3e1 * t998 * t1005 + 0.3e1 * t988 * t1016 + t254 * t777 + t591 * t279 + t282 * t919 + t740 * t349 + 0.3e1 * t998 * t984 + 0.3e1 * t1014 + 0.3e1 * t1022 - t1030 - t1033 - t347 + t890 - t891 + t892 + t908 - t911;
  t1038 = my_piecewise5(t52, 0, t55, 0, t1003 + t1036);
  t1040 = -0.25e2 / 0.162e3 * t308 + 0.5e1 / 0.54e2 * t30 * t129 * t260 + 0.4e2 / 0.243e3 * t942 - 0.5e1 / 0.81e2 * t945 + t87 * t356 + t47 * t1038;
  t1045 = my_piecewise3(t3, 0, t8 * t73 * t358 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1040);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1045 + 0.2e1 * t362;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1056 = t189 * t286;
  t1057 = t188 * t1056;
  t1060 = t367 * t419;
  t1061 = t173 * t1060;
  t1064 = t367 * t197;
  t1065 = t89 * t1064;
  t1066 = t1065 * t842;
  t1068 = t89 * t1060;
  t1073 = t432 * t1060;
  t1076 = t206 * t286;
  t1090 = t367 * t93;
  t1091 = t173 * t1090;
  t1092 = t1091 * t853;
  t1094 = -0.2e1 * t293 * t205 * t1076 + 0.2e1 * t282 * t1057 - 0.2e1 * t293 * t1057 + 0.3e1 * t1061 * t816 + 0.3e1 * t1061 * t833 + 0.3e1 * t1061 * t884 - 0.3e1 * t1068 * t816 - t1068 * t884 - 0.2e1 * t1073 * t825 - 0.3e1 * t1073 * t833 + 0.3e1 * t1073 * t880 - t1073 * t884 + 0.3e1 * t1066 + 0.3e1 * t1092 - t319 - t374;
  t1098 = t173 * t1064 * t178;
  t1099 = t1098 * t866;
  t1102 = t89 * t1090 * t178;
  t1103 = t1102 * t872;
  t1105 = t1098 * t877;
  t1113 = t436 * t367;
  t1114 = t513 * t1113;
  t1116 = t136 * t197;
  t1117 = t89 * t1116;
  t1118 = t96 * t286;
  t1120 = t1117 * t914 * t1118;
  t1121 = 0.2e1 * t1120;
  t1125 = 0.2e1 * t282 * t188 * t1118 - 0.3e1 * t1061 * t896 - 0.2e1 * t1068 * t893 + 0.3e1 * t1073 * t857 - t902 * t1114 + 0.2e1 * t293 * t777 - 0.3e1 * t1099 + 0.3e1 * t1103 - 0.3e1 * t1105 - t1121 - t838 + t890 - t891 + t892 + t908 - t911;
  t1127 = my_piecewise5(t52, 0, t55, 0, t1094 + t1125);
  t1129 = -0.25e2 / 0.81e2 * t339 + 0.5e1 / 0.27e2 * t30 * t129 * t297 + t87 * t380 + t47 * t1127;
  t1134 = my_piecewise3(t3, 0, t8 * t73 * t382 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1129);
  tv3rholapl20 = 0.2e1 * rho[0] * t1134 + 0.2e1 * t386;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1138 = t30 * t110 * t327;
  t1140 = t310 * t118;
  t1149 = t189 * t317;
  t1150 = t188 * t1149;
  t1151 = t239 * t1150;
  t1152 = 0.3e1 * t1151;
  t1153 = t837 * t353;
  t1154 = 0.3e1 * t1153;
  t1155 = t837 * t343;
  t1156 = 0.3e1 * t1155;
  t1157 = t1140 * t197;
  t1158 = t173 * t1157;
  t1159 = t1158 * t453;
  t1160 = 0.3e1 * t1159;
  t1161 = t1140 * t93;
  t1163 = t89 * t1161 * t470;
  t1164 = 0.3e1 * t1163;
  t1165 = t1158 * t464;
  t1166 = 0.3e1 * t1165;
  t1167 = t1140 * t419;
  t1168 = t432 * t1167;
  t1171 = t173 * t1167;
  t1174 = -0.3e1 * t173 * t1140 * t423 - 0.2e1 * t89 * t1140 * t427 - t432 * t1140 * t438 - 0.2e1 * t1168 * t529 + 0.3e1 * t1171 * t519 + t1152 - t1154 - t1156 - t1160 + t1164 - t1166 - t319 - t321;
  t1175 = t317 * t118;
  t1177 = t89 * t1175 * t199;
  t1178 = 0.3e1 * t1177;
  t1181 = t254 * t907;
  t1182 = 0.3e1 * t1181;
  t1186 = t173 * t1161 * t481;
  t1187 = 0.3e1 * t1186;
  t1188 = t889 * t349;
  t1189 = 0.3e1 * t1188;
  t1191 = t89 * t1157 * t490;
  t1192 = 0.3e1 * t1191;
  t1195 = t89 * t1167;
  t1204 = 0.3e1 * t1168 * t498 - t1168 * t504 + 0.3e1 * t1168 * t515 - 0.3e1 * t1168 * t519 + 0.3e1 * t1171 * t476 + 0.3e1 * t1171 * t504 - 0.3e1 * t1195 * t476 - t1195 * t504 - t1178 + t1182 + t1187 + t1189 + t1192;
  t1206 = my_piecewise5(t52, 0, t55, 0, t1174 + t1204);
  t1208 = -0.5e1 / 0.27e2 * t1138 + t47 * t1206;
  t1212 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1208);
  tv3sigma30 = 0.2e1 * rho[0] * t1212;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1218 = t30 * t110 * t356;
  t1221 = t310 * t62 * t96;
  t1222 = t475 * t1221;
  t1229 = t503 * t310;
  t1230 = t501 * t1229;
  t1235 = t850 * t760;
  t1236 = 0.3e1 * t1235;
  t1237 = t136 * t310;
  t1238 = t89 * t1237;
  t1239 = t1238 * t580;
  t1240 = 0.3e1 * t1239;
  t1241 = 0.2e1 * t1151;
  t1242 = 0.2e1 * t1153;
  t1243 = 0.2e1 * t1155;
  t1244 = t528 * t310;
  t1245 = t513 * t1244;
  t1248 = t518 * t310;
  t1249 = t497 * t1248;
  t1252 = t293 * t1150;
  t1255 = 0.3e1 * t710 * t1222 - 0.3e1 * t717 * t1222 + 0.3e1 * t710 * t1230 - t717 * t1230 - t727 * t1230 - 0.2e1 * t727 * t1245 + 0.3e1 * t710 * t1249 - 0.3e1 * t727 * t1249 + 0.3e1 * t823 * t721 + t1236 + t1240 + t1241 - t1242 - t1243 - t1252 - t319;
  t1256 = t206 * t317;
  t1257 = t205 * t1256;
  t1258 = t293 * t1257;
  t1261 = t282 * t1150;
  t1262 = t1237 * t197;
  t1263 = t173 * t1262;
  t1264 = t1263 * t464;
  t1265 = 0.3e1 * t1264;
  t1266 = t1263 * t453;
  t1267 = 0.3e1 * t1266;
  t1268 = params->csk_a * t310;
  t1269 = t1268 * t197;
  t1270 = t97 * t1269;
  t1271 = t765 * t1270;
  t1272 = 0.3e1 * t1271;
  t1273 = 0.2e1 * t1177;
  t1274 = 0.2e1 * t1181;
  t1275 = 0.2e1 * t1188;
  t1276 = t96 * t317;
  t1277 = t188 * t1276;
  t1278 = t282 * t1277;
  t1279 = t837 * t279;
  t1281 = t136 * t317;
  t1283 = t89 * t1281 * t199;
  t1286 = t96 * t310;
  t1287 = t501 * t1286;
  t1290 = -0.2e1 * t717 * t1287 + 0.3e1 * t823 * t737 - 0.3e1 * t813 * t770 - t823 * t780 - t1258 + t1261 - t1265 - t1267 + t1272 - t1273 + t1274 + t1275 + t1278 + t1279 - t1283 - t347;
  t1292 = my_piecewise5(t52, 0, t55, 0, t1255 + t1290);
  t1294 = 0.5e1 / 0.54e2 * t30 * t129 * t327 - 0.1e2 / 0.81e2 * t1218 + t47 * t1292;
  t1298 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1294);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1298;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1304 = t30 * t110 * t380;
  t1306 = t183 * t118;
  t1307 = t598 * t1306;
  t1310 = t1091 * t574;
  t1311 = 0.3e1 * t1310;
  t1314 = t503 * t118;
  t1315 = t501 * t1314;
  t1321 = t118 * t62 * t96;
  t1322 = t475 * t1321;
  t1327 = t528 * t118;
  t1337 = t1065 * t188 * t348 * t93;
  t1338 = 0.3e1 * t1337;
  t1339 = -0.2e1 * t1073 * t513 * t1327 + 0.3e1 * t1061 * t1307 + 0.3e1 * t1061 * t1315 + 0.3e1 * t1061 * t1322 - t1068 * t1315 - 0.3e1 * t1068 * t1322 - 0.3e1 * t1073 * t1307 - t1073 * t1315 + 0.3e1 * t1073 * t603 + 0.3e1 * t1073 * t624 + t1151 - t1153 + t1311 + t1338 - t319 - t374;
  t1340 = 0.2e1 * t1252;
  t1341 = 0.2e1 * t1258;
  t1342 = 0.2e1 * t1261;
  t1343 = t982 * t93;
  t1345 = t1098 * t183 * t1343;
  t1346 = 0.3e1 * t1345;
  t1348 = t1098 * t982 * t452;
  t1349 = 0.3e1 * t1348;
  t1350 = t982 * t197;
  t1351 = t97 * t1350;
  t1352 = t1102 * t1351;
  t1353 = 0.3e1 * t1352;
  t1354 = 0.2e1 * t1278;
  t1355 = 0.2e1 * t1279;
  t1356 = 0.2e1 * t1283;
  t1363 = -0.2e1 * t1068 * t501 * t348 - 0.3e1 * t1061 * t653 - t597 * t1114 - t1155 - t1177 + t1181 + t1188 - t1340 - t1341 + t1342 - t1346 - t1349 + t1353 + t1354 + t1355 - t1356;
  t1365 = my_piecewise5(t52, 0, t55, 0, t1339 + t1363);
  t1367 = 0.5e1 / 0.27e2 * t30 * t129 * t356 - 0.5e1 / 0.81e2 * t1304 + t47 * t1365;
  t1371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1367);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1371;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1376 = t367 * t136;
  t1385 = t1376 * t197;
  t1386 = t173 * t1385;
  t1387 = t1386 * t464;
  t1388 = 0.3e1 * t1387;
  t1389 = t1386 * t453;
  t1390 = 0.3e1 * t1389;
  t1391 = t1376 * t93;
  t1393 = t89 * t1391 * t470;
  t1394 = 0.3e1 * t1393;
  t1395 = 0.3e1 * t1252;
  t1396 = 0.3e1 * t1258;
  t1397 = 0.3e1 * t1261;
  t1398 = 0.3e1 * t1278;
  t1399 = 0.3e1 * t1279;
  t1400 = -0.3e1 * t173 * t1376 * t423 - 0.2e1 * t89 * t1376 * t427 - t432 * t1376 * t438 - t1388 - t1390 + t1394 - t1395 - t1396 + t1397 + t1398 + t1399 - t319 - t374;
  t1401 = 0.3e1 * t1283;
  t1402 = t1376 * t419;
  t1403 = t89 * t1402;
  t1406 = t432 * t1402;
  t1413 = t173 * t1402;
  t1416 = t89 * t1385;
  t1417 = t1416 * t490;
  t1418 = 0.3e1 * t1417;
  t1420 = t173 * t1391 * t481;
  t1421 = 0.3e1 * t1420;
  t1430 = -0.3e1 * t1403 * t476 - t1403 * t504 + 0.3e1 * t1406 * t498 - t1406 * t504 + 0.3e1 * t1406 * t515 - 0.3e1 * t1406 * t519 - 0.2e1 * t1406 * t529 + 0.3e1 * t1413 * t476 + 0.3e1 * t1413 * t504 + 0.3e1 * t1413 * t519 - t1401 + t1418 + t1421;
  t1432 = my_piecewise5(t52, 0, t55, 0, t1400 + t1430);
  t1434 = 0.5e1 / 0.18e2 * t30 * t129 * t380 + t47 * t1432;
  t1438 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1434);
  tv3lapl30 = 0.2e1 * rho[0] * t1438;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  double t73, t77, t79, t81, t87, t89, t90, t91;
  double t93, t94, t96, t97, t98, t100, t102, t107;
  double tvrho0, t110, t111, t114, t117, t118, t121, t123;
  double t127, tvsigma0, t129, t135, t136, t139, t141, t145;
  double tvlapl0, tvtau0;

  double t150, t157, t159, t161, t167, t171, t173, t174;
  double t176, t177, t178, t179, t180, t181, t182, t183;
  double t184, t186, t188, t189, t190, t192, t193, t196;
  double t197, t199, t200, t201, t203, t205, t206, t207;
  double t210, t212, t217, tv2rho20, t223, t224, t227, t230;
  double t233, t234, t235, t236, t238, t239, t241, t244;
  double t245, t248, t250, t251, t252, t254, t256, t257;
  double t260, t262, t267, tv2rhosigma0, t278, t279, t281, t282;
  double t285, t286, t289, t291, t293, t297, t299, t304;
  double tv2rholapl0, tv2rhotau0, t308, t310, t313, t316, t317, t319;
  double t320, t321, t323, t327, t329, t333, tv2sigma20, t339;
  double t343, t345, t346, t347, t348, t349, t352, t353;
  double t356, t358, t362, tv2sigmalapl0, tv2sigmatau0, t367, t370, t373;
  double t374, t376, t380, t382, t386, tv2lapl20, tv2lapltau0, tv2tau20;

  double t391, t403, t405, t411, t417, t419, t421, t422;
  double t423, t427, t432, t434, t436, t437, t438, t440;
  double t441, t444, t445, t448, t449, t450, t452, t453;
  double t454, t457, t458, t464, t465, t467, t469, t470;
  double t471, t473, t474, t475, t476, t480, t481, t482;
  double t484, t489, t490, t491, t493, t496, t497, t498;
  double t501, t502, t503, t504, t509, t513, t514, t515;
  double t518, t519, t522, t524, t528, t529, t532, t534;
  double t536, t541, tv3rho30, t551, t552, t555, t558, t561;
  double t567, t568, t571, t572, t573, t574, t575, t577;
  double t580, t581, t583, t584, t586, t587, t590, t591;
  double t594, t597, t598, t599, t601, t602, t603, t612;
  double t615, t616, t618, t619, t622, t623, t624, t627;
  double t630, t636, t637, t638, t640, t641, t642, t644;
  double t645, t646, t648, t652, t653, t656, t657, t661;
  double t662, t667, t669, t673, t674, t675, t677, t679;
  double t681, t686, tv3rho2sigma0, t705, t706, t709, t710, t713;
  double t714, t717, t720, t721, t727, t735, t736, t737;
  double t740, t746, t747, t748, t749, t750, t752, t757;
  double t759, t760, t761, t764, t765, t766, t770, t776;
  double t777, t780, t782, t784, t788, t790, t792, t794;
  double t799, tv3rho2lapl0, tv3rho2tau0, t806, t809, t812, t813, t815;
  double t816, t819, t820, t823, t824, t825, t829, t832;
  double t833, t836, t837, t838, t839, t840, t842, t843;
  double t849, t850, t851, t852, t853, t854, t856, t857;
  double t860, t864, t865, t866, t867, t870, t871, t872;
  double t873, t875, t876, t877, t878, t880, t884, t889;
  double t890, t891, t892, t893, t896, t901, t902, t903;
  double t904, t906, t907, t908, t909, t911, t912, t913;
  double t914, t915, t917, t918, t919, t922, t924, t926;
  double t931, tv3rhosigma20, t942, t945, t948, t949, t951, t952;
  double t954, t955, t956, t957, t959, t960, t961, t967;
  double t968, t972, t973, t976, t977, t980, t981, t982;
  double t983, t984, t987, t988, t989, t990, t991, t994;
  double t995, t996, t998, t1001, t1003, t1005, t1008, t1011;
  double t1012, t1013, t1014, t1016, t1021, t1022, t1028, t1030;
  double t1031, t1033, t1036, t1038, t1040, t1045, tv3rhosigmalapl0, tv3rhosigmatau0;
  double t1056, t1057, t1060, t1061, t1064, t1065, t1066, t1068;
  double t1073, t1076, t1090, t1091, t1092, t1094, t1098, t1099;
  double t1102, t1103, t1105, t1113, t1114, t1116, t1117, t1118;
  double t1120, t1121, t1125, t1127, t1129, t1134, tv3rholapl20, tv3rholapltau0;
  double tv3rhotau20, t1138, t1140, t1149, t1150, t1151, t1152, t1153;
  double t1154, t1155, t1156, t1157, t1158, t1159, t1160, t1161;
  double t1163, t1164, t1165, t1166, t1167, t1168, t1171, t1174;
  double t1175, t1177, t1178, t1181, t1182, t1186, t1187, t1188;
  double t1189, t1191, t1192, t1195, t1204, t1206, t1208, t1212;
  double tv3sigma30, t1218, t1221, t1222, t1229, t1230, t1235, t1236;
  double t1237, t1238, t1239, t1240, t1241, t1242, t1243, t1244;
  double t1245, t1248, t1249, t1252, t1255, t1256, t1257, t1258;
  double t1261, t1262, t1263, t1264, t1265, t1266, t1267, t1268;
  double t1269, t1270, t1271, t1272, t1273, t1274, t1275, t1276;
  double t1277, t1278, t1279, t1281, t1283, t1286, t1287, t1290;
  double t1292, t1294, t1298, tv3sigma2lapl0, tv3sigma2tau0, t1304, t1306, t1307;
  double t1310, t1311, t1314, t1315, t1321, t1322, t1327, t1337;
  double t1338, t1339, t1340, t1341, t1342, t1343, t1345, t1346;
  double t1348, t1349, t1350, t1351, t1352, t1353, t1354, t1355;
  double t1356, t1363, t1365, t1367, t1371, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20;
  double t1376, t1385, t1386, t1387, t1388, t1389, t1390, t1391;
  double t1393, t1394, t1395, t1396, t1397, t1398, t1399, t1400;
  double t1401, t1402, t1403, t1406, t1413, t1416, t1417, t1418;
  double t1420, t1421, t1430, t1432, t1434, t1438, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, tv3tau30;

  double t1460, t1466, t1474, t1475, t1483, t1484, t1487, t1489;
  double t1490, t1492, t1493, t1494, t1495, t1496, t1497, t1498;
  double t1499, t1500, t1502, t1503, t1506, t1507, t1508, t1512;
  double t1515, t1516, t1519, t1526, t1527, t1528, t1530, t1533;
  double t1534, t1537, t1538, t1541, t1544, t1545, t1549, t1553;
  double t1556, t1558, t1561, t1566, t1570, t1571, t1574, t1582;
  double t1585, t1587, t1592, t1597, t1600, t1601, t1603, t1608;
  double t1614, t1619, t1622, t1626, t1631, t1633, t1636, t1639;
  double t1645, t1646, t1647, t1648, t1649, t1652, t1653, t1654;
  double t1657, t1658, t1659, t1660, t1663, t1668, t1669, t1675;
  double t1678, t1679, t1685, t1686, t1697, t1700, t1701, t1707;
  double t1708, t1712, t1715, t1720, t1725, t1728, t1729, t1732;
  double t1742, t1743, t1744, t1745, t1749, t1755, t1756, t1761;
  double t1774, t1778, t1785, tv4rho40, t1798, t1799, t1819, t1820;
  double t1827, t1828, t1831, t1833, t1838, t1839, t1840, t1841;
  double t1842, t1845, t1847, t1848, t1851, t1853, t1854, t1857;
  double t1862, t1863, t1865, t1866, t1869, t1870, t1871, t1874;
  double t1875, t1877, t1880, t1881, t1884, t1887, t1890, t1893;
  double t1896, t1901, t1905, t1908, t1909, t1912, t1913, t1916;
  double t1920, t1922, t1924, t1927, t1931, t1934, t1943, t1947;
  double t1954, t1958, t1963, t1964, t1971, t1975, t1980, t1982;
  double t1991, t1993, t1996, t2002, t2007, t2010, t2016, t2020;
  double t2026, t2029, t2031, t2035, t2044, t2047, t2050, t2053;
  double t2056, t2059, t2060, t2063, t2066, t2067, t2071, t2074;
  double t2079, t2081, t2082, t2088, t2092, t2093, t2097, t2100;
  double t2101, t2102, t2109, t2114, t2131, t2136, t2137, t2150;
  double t2159, t2162, t2166, t2170, t2180, t2184, t2191, tv4rho3sigma0;
  double t2216, t2217, t2220, t2227, t2228, t2229, t2234, t2237;
  double t2238, t2243, t2244, t2251, t2254, t2255, t2258, t2259;
  double t2264, t2275, t2289, t2294, t2297, t2298, t2302, t2305;
  double t2306, t2311, t2314, t2317, t2320, t2329, t2331, t2338;
  double t2339, t2342, t2348, t2351, t2356, t2357, t2363, t2368;
  double t2381, t2391, t2395, t2399, t2405, t2406, t2408, t2413;
  double t2415, t2419, t2436, t2441, t2446, t2464, t2465, t2470;
  double t2473, t2484, t2493, t2496, t2502, t2506, t2513, tv4rho3lapl0;
  double tv4rho3tau0, t2535, t2536, t2544, t2545, t2548, t2550, t2557;
  double t2558, t2559, t2560, t2563, t2564, t2567, t2568, t2570;
  double t2576, t2580, t2581, t2584, t2587, t2590, t2593, t2598;
  double t2599, t2602, t2606, t2610, t2618, t2619, t2625, t2633;
  double t2638, t2639, t2648, t2650, t2657, t2661, t2662, t2663;
  double t2664, t2667, t2668, t2669, t2673, t2676, t2677, t2682;
  double t2683, t2685, t2686, t2688, t2689, t2692, t2695, t2698;
  double t2702, t2705, t2707, t2713, t2715, t2717, t2718, t2719;
  double t2720, t2721, t2729, t2730, t2734, t2744, t2747, t2748;
  double t2751, t2753, t2755, t2757, t2760, t2766, t2772, t2776;
  double t2779, t2785, t2789, t2799, t2800, t2802, t2803, t2804;
  double t2806, t2808, t2813, t2836, t2846, t2848, t2849, t2853;
  double t2854, t2860, t2861, t2862, t2863, t2864, t2866, t2867;
  double t2874, t2877, t2880, t2882, t2888, t2889, t2890, t2893;
  double t2894, t2898, t2901, t2902, t2904, t2905, t2913, t2922;
  double t2926, t2933, tv4rho2sigma20, t2960, t2964, t2965, t2968, t2969;
  double t2976, t2977, t2981, t2983, t2995, t2999, t3019, t3021;
  double t3022, t3027, t3028, t3029, t3030, t3033, t3034, t3035;
  double t3036, t3040, t3041, t3042, t3043, t3044, t3046, t3049;
  double t3052, t3054, t3057, t3070, t3075, t3078, t3083, t3085;
  double t3093, t3097, t3108, t3115, t3118, t3123, t3141, t3142;
  double t3143, t3146, t3169, t3170, t3195, t3200, t3201, t3208;
  double t3209, t3214, t3215, t3221, t3246, t3247, t3248, t3256;
  double t3279, t3286, t3291, t3295, t3313, t3317, t3324, tv4rho2sigmalapl0;
  double tv4rho2sigmatau0, t3342, t3343, t3351, t3352, t3355, t3358, t3361;
  double t3362, t3365, t3368, t3375, t3382, t3385, t3386, t3401;
  double t3402, t3405, t3406, t3407, t3422, t3424, t3425, t3427;
  double t3430, t3433, t3439, t3440, t3443, t3450, t3466, t3478;
  double t3486, t3492, t3509, t3513, t3525, t3534, t3536, t3554;
  double t3555, t3556, t3563, t3575, t3584, t3593, t3596, t3602;
  double t3604, t3605, t3614, t3618, t3625, tv4rho2lapl20, tv4rho2lapltau0, tv4rho2tau20;
  double t3639, t3640, t3642, t3643, t3644, t3645, t3647, t3650;
  double t3651, t3657, t3658, t3659, t3661, t3664, t3666, t3667;
  double t3668, t3669, t3672, t3674, t3675, t3676, t3678, t3682;
  double t3684, t3685, t3688, t3689, t3690, t3693, t3694, t3698;
  double t3700, t3702, t3706, t3709, t3714, t3717, t3718, t3719;
  double t3720, t3722, t3727, t3729, t3730, t3731, t3734, t3736;
  double t3738, t3742, t3745, t3748, t3752, t3755, t3758, t3767;
  double t3772, t3773, t3776, t3777, t3781, t3787, t3789, t3792;
  double t3795, t3796, t3797, t3803, t3807, t3812, t3814, t3818;
  double t3823, t3826, t3828, t3831, t3834, t3852, t3856, t3872;
  double t3873, t3879, t3886, t3887, t3889, t3891, t3893, t3901;
  double t3908, t3911, t3912, t3923, t3927, t3929, t3931, t3932;
  double t3936, t3943, tv4rhosigma30, t3960, t3961, t3962, t3965, t3967;
  double t3968, t3969, t3976, t3978, t3980, t3981, t3993, t3995;
  double t3996, t3999, t4000, t4006, t4008, t4020, t4022, t4032;
  double t4034, t4037, t4040, t4043, t4044, t4045, t4050, t4059;
  double t4068, t4074, t4078, t4083, t4084, t4088, t4099, t4111;
  double t4116, t4119, t4143, t4153, t4156, t4160, t4163, t4167;
  double t4168, t4179, t4180, t4189, t4213, t4220, t4221, t4222;
  double t4224, t4225, t4229, t4233, t4250, t4251, t4253, t4264;
  double t4272, t4282, t4288, t4293, t4294, t4298, t4303, t4310;
  double tv4rhosigma2lapl0, tv4rhosigma2tau0, t4327, t4328, t4329, t4330, t4335, t4336;
  double t4343, t4346, t4347, t4349, t4356, t4357, t4378, t4380;
  double t4387, t4406, t4409, t4419, t4430, t4431, t4437, t4473;
  double t4505, t4549, t4550, t4558, t4561, t4589, t4594, t4605;
  double t4610, t4617, tv4rhosigmalapl20, tv4rhosigmalapltau0, tv4rhosigmatau20, t4628, t4629, t4630;
  double t4633, t4636, t4640, t4662, t4679, t4680, t4683, t4685;
  double t4688, t4694, t4712, t4715, t4716, t4718, t4729, t4730;
  double t4737, t4749, t4756, t4768, t4773, t4775, t4781, t4786;
  double t4793, t4794, t4804, t4813, t4821, t4826, t4833, t4840;
  double t4842, t4843, t4847, t4854, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30;
  double t4860, t4861, t4863, t4865, t4868, t4869, t4870, t4875;
  double t4886, t4887, t4889, t4891, t4892, t4894, t4896, t4898;
  double t4905, t4907, t4908, t4912, t4913, t4915, t4917, t4920;
  double t4922, t4927, t4929, t4932, t4933, t4935, t4938, t4939;
  double t4941, t4943, t4944, t4947, t4950, t4956, t4967, t4972;
  double t4973, t4978, t4982, t4983, t4985, t4992, t4997, t5002;
  double t5005, t5019, t5023, t5031, t5032, t5034, t5036, t5043;
  double t5065, t5069, t5075, tv4sigma40, t5083, t5084, t5085, t5086;
  double t5087, t5088, t5089, t5090, t5091, t5093, t5094, t5095;
  double t5096, t5097, t5098, t5099, t5100, t5107, t5111, t5117;
  double t5124, t5125, t5126, t5127, t5128, t5131, t5132, t5133;
  double t5134, t5136, t5137, t5139, t5140, t5149, t5156, t5160;
  double t5165, t5173, t5182, t5191, t5194, t5198, t5217, t5222;
  double t5223, t5237, t5238, t5239, t5240, t5247, t5257, t5258;
  double t5259, t5260, t5261, t5263, t5264, t5267, t5274, t5289;
  double t5293, t5299, tv4sigma3lapl0, tv4sigma3tau0, t5310, t5311, t5324, t5330;
  double t5335, t5342, t5345, t5349, t5360, t5366, t5372, t5375;
  double t5379, t5388, t5392, t5396, t5403, t5417, t5422, t5424;
  double t5425, t5427, t5428, t5430, t5433, t5435, t5437, t5439;
  double t5450, t5452, t5456, t5464, t5476, t5491, t5499, t5501;
  double t5503, t5508, t5521, t5525, t5531, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20;
  double t5544, t5550, t5557, t5562, t5568, t5571, t5574, t5582;
  double t5591, t5596, t5599, t5626, t5634, t5656, t5660, t5662;
  double t5680, t5684, t5690, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, tv4sigmatau30, t5695;
  double t5698, t5703, t5715, t5719, t5720, t5724, t5733, t5736;
  double t5763, t5777, t5778, t5781, t5792, t5799, t5801, t5802;
  double t5815, t5847, t5851, t5857, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30;
  double tv4tau40;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t73 = t21 / t22;
  t77 = t34 * rho[0];
  t79 = 0.1e1 / t23 / t77;
  t81 = t30 * t33 * t79;
  t87 = -0.25e2 / 0.162e3 * t30 * t40 * t36 + 0.4e2 / 0.243e3 * t81;
  t89 = t64 * t61;
  t90 = my_piecewise3(t55, 0, t87);
  t91 = my_piecewise3(t57, t90, 0);
  t93 = fabs(t58) / t58;
  t94 = 0.1e1 / t59;
  t96 = 0.1e1 / t63;
  t97 = t62 * t96;
  t98 = t93 * t94 * t97;
  t100 = my_piecewise5(t52, 0, t55, 0, -t89 * t91 * t98);
  t102 = -0.5e1 / 0.27e2 * t81 + t87 * t65 + t47 * t100;
  t107 = my_piecewise3(t3, 0, t8 * t73 * t67 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tvrho0 = 0.2e1 * rho[0] * t107 + 0.2e1 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t110 = t32 * t36;
  t111 = t30 * t110;
  t114 = t30 * t110 * t65;
  t117 = my_piecewise3(t55, 0, -0.5e1 / 0.81e2 * t111);
  t118 = my_piecewise3(t57, t117, 0);
  t121 = my_piecewise5(t52, 0, t55, 0, -t89 * t118 * t98);
  t123 = 0.5e1 / 0.72e2 * t111 - 0.5e1 / 0.81e2 * t114 + t47 * t121;
  t127 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t123);
  tvsigma0 = 0.2e1 * rho[0] * t127;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t129 = t32 * t42;
  t135 = my_piecewise3(t55, 0, 0.5e1 / 0.54e2 * t30 * t129);
  t136 = my_piecewise3(t57, t135, 0);
  t139 = my_piecewise5(t52, 0, t55, 0, -t89 * t136 * t98);
  t141 = 0.5e1 / 0.54e2 * t30 * t129 * t65 + t47 * t139;
  t145 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t141);
  tvlapl0 = 0.2e1 * rho[0] * t145;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t150 = t21 / t22 / rho[0];
  t157 = t34 * t34;
  t159 = 0.1e1 / t23 / t157;
  t161 = t30 * t33 * t159;
  t167 = 0.1e3 / 0.243e3 * t30 * t40 * t79 - 0.44e3 / 0.729e3 * t161;
  t171 = t60 * t60;
  t173 = t64 / t171;
  t174 = t91 * t91;
  t176 = t93 * t93;
  t177 = t59 * t59;
  t178 = 0.1e1 / t177;
  t179 = t176 * t178;
  t180 = t62 * t62;
  t181 = t63 * t63;
  t182 = 0.1e1 / t181;
  t183 = t180 * t182;
  t184 = t179 * t183;
  t186 = t174 * t176;
  t188 = t178 * t62;
  t189 = t96 * params->csk_a;
  t190 = t188 * t189;
  t192 = my_piecewise3(t55, 0, t167);
  t193 = my_piecewise3(t57, t192, 0);
  t196 = t89 * t174;
  t197 = 0.0;
  t199 = t197 * t94 * t97;
  t200 = t196 * t199;
  t201 = t179 * t97;
  t203 = t173 * t186;
  t205 = t178 * t180;
  t206 = t182 * params->csk_a;
  t207 = t205 * t206;
  t210 = my_piecewise5(t52, 0, t55, 0, t173 * t174 * t184 + t89 * t186 * t190 - t89 * t193 * t98 - t203 * t190 + t196 * t201 - t203 * t207 - t200);
  t212 = 0.55e2 / 0.81e2 * t161 + t167 * t65 + 0.2e1 * t87 * t100 + t47 * t210;
  t217 = my_piecewise3(t3, 0, -t8 * t150 * t67 / 0.3e2 + t8 * t73 * t102 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t212);
  tv2rho20 = 0.2e1 * rho[0] * t217 + 0.4e1 * t107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t223 = t32 * t79;
  t224 = t30 * t223;
  t227 = t30 * t223 * t65;
  t230 = t30 * t110 * t100;
  t233 = t91 * t176;
  t234 = t173 * t233;
  t235 = t182 * t118;
  t236 = t205 * t235;
  t238 = t118 * t176;
  t239 = t89 * t238;
  t241 = t188 * t189 * t91;
  t244 = my_piecewise3(t55, 0, 0.4e2 / 0.243e3 * t224);
  t245 = my_piecewise3(t57, t244, 0);
  t248 = t118 * t91;
  t250 = t89 * t248 * t199;
  t251 = t96 * t91;
  t252 = t188 * t251;
  t254 = t173 * t238;
  t256 = t206 * t91;
  t257 = t205 * t256;
  t260 = my_piecewise5(t52, 0, t55, 0, -t89 * t245 * t98 + t234 * t236 + t239 * t241 + t239 * t252 - t254 * t241 - t254 * t257 - t250);
  t262 = -0.5e1 / 0.27e2 * t224 + 0.4e2 / 0.243e3 * t227 - 0.5e1 / 0.81e2 * t230 + t87 * t121 + t47 * t260;
  t267 = my_piecewise3(t3, 0, t8 * t73 * t123 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t262);
  tv2rhosigma0 = 0.2e1 * rho[0] * t267 + 0.2e1 * t127;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t278 = t182 * t136;
  t279 = t205 * t278;
  t281 = t136 * t176;
  t282 = t89 * t281;
  t285 = my_piecewise3(t55, 0, -0.25e2 / 0.162e3 * t111);
  t286 = my_piecewise3(t57, t285, 0);
  t289 = t136 * t91;
  t291 = t89 * t289 * t199;
  t293 = t173 * t281;
  t297 = my_piecewise5(t52, 0, t55, 0, -t89 * t286 * t98 + t234 * t279 + t282 * t241 - t293 * t241 + t282 * t252 - t293 * t257 - t291);
  t299 = -0.25e2 / 0.162e3 * t114 + 0.5e1 / 0.54e2 * t30 * t129 * t100 + t87 * t139 + t47 * t297;
  t304 = my_piecewise3(t3, 0, t8 * t73 * t141 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t299);
  tv2rholapl0 = 0.2e1 * rho[0] * t304 + 0.2e1 * t145;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t308 = t30 * t110 * t121;
  t310 = t118 * t118;
  t313 = t310 * t176;
  t316 = my_piecewise3(t55, 0, 0);
  t317 = my_piecewise3(t57, t316, 0);
  t319 = t89 * t317 * t98;
  t320 = t89 * t310;
  t321 = t320 * t199;
  t323 = t173 * t313;
  t327 = my_piecewise5(t52, 0, t55, 0, t173 * t310 * t184 + t89 * t313 * t190 - t323 * t190 + t320 * t201 - t323 * t207 - t319 - t321);
  t329 = -0.1e2 / 0.81e2 * t308 + t47 * t327;
  t333 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t329);
  tv2sigma20 = 0.2e1 * rho[0] * t333;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t339 = t30 * t110 * t139;
  t343 = t188 * t189 * t118;
  t345 = t136 * t118;
  t346 = t89 * t345;
  t347 = t346 * t199;
  t348 = t96 * t118;
  t349 = t188 * t348;
  t352 = t206 * t118;
  t353 = t205 * t352;
  t356 = my_piecewise5(t52, 0, t55, 0, t254 * t279 + t282 * t343 + t282 * t349 - t293 * t343 - t293 * t353 - t319 - t347);
  t358 = 0.5e1 / 0.54e2 * t30 * t129 * t121 - 0.5e1 / 0.81e2 * t339 + t47 * t356;
  t362 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t358);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t362;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t367 = t136 * t136;
  t370 = t367 * t176;
  t373 = t89 * t367;
  t374 = t373 * t199;
  t376 = t173 * t370;
  t380 = my_piecewise5(t52, 0, t55, 0, t173 * t367 * t184 + t89 * t370 * t190 - t376 * t190 + t373 * t201 - t376 * t207 - t319 - t374);
  t382 = 0.5e1 / 0.27e2 * t30 * t129 * t139 + t47 * t380;
  t386 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t382);
  tv2lapl20 = 0.2e1 * rho[0] * t386;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t391 = t21 / t22 / t34;
  t403 = 0.1e1 / t23 / t157 / rho[0];
  t405 = t30 * t33 * t403;
  t411 = -0.11e4 / 0.729e3 * t30 * t40 * t159 + 0.616e4 / 0.2187e4 * t405;
  t417 = t174 * t91;
  t419 = t176 * t93;
  t421 = 0.1e1 / t177 / t59;
  t422 = t419 * t421;
  t423 = t422 * t183;
  t427 = t422 * t97;
  t432 = t64 / t171 / t60;
  t434 = t180 * t62;
  t436 = 0.1e1 / t181 / t63;
  t437 = t434 * t436;
  t438 = t422 * t437;
  t440 = my_piecewise3(t55, 0, t411);
  t441 = my_piecewise3(t57, t440, 0);
  t444 = t193 * t176;
  t445 = t173 * t444;
  t448 = t417 * t197;
  t449 = t173 * t448;
  t450 = t178 * params->csk_a;
  t452 = t93 * t62 * t96;
  t453 = t450 * t452;
  t454 = t449 * t453;
  t457 = t189 * t193;
  t458 = t188 * t457;
  t464 = t205 * t206 * t93;
  t465 = t449 * t464;
  t467 = t417 * t93;
  t469 = t189 * t197;
  t470 = t188 * t469;
  t471 = t89 * t467 * t470;
  t473 = t417 * t419;
  t474 = t173 * t473;
  t475 = t421 * params->csk_a;
  t476 = t475 * t97;
  t480 = t182 * t197;
  t481 = t205 * t480;
  t482 = t173 * t467 * t481;
  t484 = -0.3e1 * t173 * t417 * t423 + 0.3e1 * t89 * t233 * t458 - 0.2e1 * t89 * t417 * t427 - t432 * t417 * t438 - t89 * t441 * t98 - 0.3e1 * t445 * t241 - 0.3e1 * t445 * t257 + 0.3e1 * t474 * t476 - t200 - 0.3e1 * t454 - 0.3e1 * t465 + 0.3e1 * t471 + 0.3e1 * t482;
  t489 = t96 * t93;
  t490 = t188 * t489;
  t491 = t89 * t448 * t490;
  t493 = t89 * t473;
  t496 = t432 * t473;
  t497 = t421 * t180;
  t498 = t497 * t206;
  t501 = t421 * t62;
  t502 = params->csk_a * params->csk_a;
  t503 = t96 * t502;
  t504 = t501 * t503;
  t509 = t182 * t193;
  t513 = t421 * t434;
  t514 = t436 * params->csk_a;
  t515 = t513 * t514;
  t518 = t182 * t502;
  t519 = t497 * t518;
  t522 = t193 * t91;
  t524 = t89 * t522 * t199;
  t528 = t436 * t502;
  t529 = t513 * t528;
  t532 = 0.3e1 * t234 * t205 * t509 + 0.3e1 * t89 * t444 * t252 + 0.3e1 * t474 * t504 + 0.3e1 * t474 * t519 - 0.3e1 * t493 * t476 - t493 * t504 + 0.3e1 * t496 * t498 - t496 * t504 + 0.3e1 * t496 * t515 - 0.3e1 * t496 * t519 - 0.2e1 * t496 * t529 + 0.3e1 * t491 - 0.3e1 * t524;
  t534 = my_piecewise5(t52, 0, t55, 0, t484 + t532);
  t536 = -0.77e3 / 0.243e3 * t405 + t411 * t65 + 0.3e1 * t167 * t100 + 0.3e1 * t87 * t210 + t47 * t534;
  t541 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t391 * t67 - t8 * t150 * t102 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t73 * t212 + 0.3e1 / 0.2e2 * t8 * t24 * t536);
  tv3rho30 = 0.2e1 * rho[0] * t541 + 0.6e1 * t217;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t551 = t32 * t159;
  t552 = t30 * t551;
  t555 = t30 * t551 * t65;
  t558 = t30 * t223 * t100;
  t561 = t30 * t110 * t210;
  t567 = my_piecewise3(t55, 0, -0.44e3 / 0.729e3 * t552);
  t568 = my_piecewise3(t57, t567, 0);
  t571 = t174 * t93;
  t572 = t173 * t571;
  t573 = t235 * t197;
  t574 = t205 * t573;
  t575 = t572 * t574;
  t577 = t118 * t174;
  t580 = t197 * t178 * t452;
  t581 = t89 * t577 * t580;
  t583 = t118 * t419;
  t584 = t173 * t583;
  t586 = t174 * t62 * t96;
  t587 = t475 * t586;
  t590 = t245 * t176;
  t591 = t173 * t590;
  t594 = t89 * t583;
  t597 = t432 * t583;
  t598 = t421 * t502;
  t599 = t598 * t586;
  t601 = t174 * t419;
  t602 = t432 * t601;
  t603 = t497 * t352;
  t612 = t598 * t174 * t180 * t182;
  t615 = t206 * t193;
  t616 = t205 * t615;
  t618 = t528 * t174;
  t619 = t513 * t618;
  t622 = t436 * t118;
  t623 = t622 * params->csk_a;
  t624 = t513 * t623;
  t627 = t89 * t590;
  t630 = -t89 * t568 * t98 - 0.2e1 * t591 * t241 + 0.2e1 * t627 * t241 - t254 * t458 - t254 * t616 + 0.3e1 * t584 * t587 + 0.3e1 * t584 * t599 - 0.3e1 * t594 * t587 - t594 * t599 - t597 * t599 - 0.3e1 * t597 * t612 - 0.2e1 * t597 * t619 + 0.3e1 * t602 * t603 + 0.3e1 * t602 * t624 + 0.3e1 * t575 + 0.3e1 * t581;
  t636 = t118 * t93;
  t637 = t636 * t178;
  t638 = t89 * t637;
  t640 = params->csk_a * t174 * t197;
  t641 = t97 * t640;
  t642 = t638 * t641;
  t644 = t577 * t197;
  t645 = t173 * t644;
  t646 = t645 * t464;
  t648 = t645 * t453;
  t652 = t173 * t601;
  t653 = t497 * t235;
  t656 = t96 * t174;
  t657 = t501 * t656;
  t661 = t182 * t245;
  t662 = t205 * t661;
  t667 = t245 * t91;
  t669 = t89 * t667 * t199;
  t673 = t89 * t118 * t193 * t199;
  t674 = t96 * t193;
  t675 = t188 * t674;
  t677 = -t602 * t513 * t622 + 0.2e1 * t234 * t662 + t445 * t236 + t239 * t458 + t239 * t675 + 0.2e1 * t627 * t252 - 0.2e1 * t591 * t257 + 0.3e1 * t584 * t612 - 0.2e1 * t594 * t657 - 0.3e1 * t652 * t653 - t250 + 0.3e1 * t642 - 0.3e1 * t646 - 0.3e1 * t648 - 0.2e1 * t669 - t673;
  t679 = my_piecewise5(t52, 0, t55, 0, t630 + t677);
  t681 = 0.55e2 / 0.81e2 * t552 - 0.44e3 / 0.729e3 * t555 + 0.8e2 / 0.243e3 * t558 - 0.5e1 / 0.81e2 * t561 + t167 * t121 + 0.2e1 * t87 * t260 + t47 * t679;
  t686 = my_piecewise3(t3, 0, -t8 * t150 * t123 / 0.3e2 + t8 * t73 * t262 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t681);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t686 + 0.4e1 * t267;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t705 = my_piecewise3(t55, 0, 0.1e3 / 0.243e3 * t224);
  t706 = my_piecewise3(t57, t705, 0);
  t709 = t136 * t419;
  t710 = t173 * t709;
  t713 = t286 * t176;
  t714 = t173 * t713;
  t717 = t89 * t709;
  t720 = t278 * params->csk_a;
  t721 = t497 * t720;
  t727 = t432 * t709;
  t735 = t436 * t136;
  t736 = t735 * params->csk_a;
  t737 = t513 * t736;
  t740 = t89 * t713;
  t746 = -t89 * t706 * t98 - 0.2e1 * t714 * t241 + 0.2e1 * t740 * t241 + t282 * t458 - t293 * t458 - t293 * t616 + 0.3e1 * t710 * t587 - 0.3e1 * t717 * t587 + 0.3e1 * t710 * t599 - t717 * t599 - t727 * t599 + 0.3e1 * t602 * t721 + 0.3e1 * t602 * t737 + 0.3e1 * t710 * t612 - 0.3e1 * t727 * t612 - 0.2e1 * t727 * t619;
  t747 = t136 * t174;
  t748 = t747 * t197;
  t749 = t173 * t748;
  t750 = t749 * t464;
  t752 = t749 * t453;
  t757 = t89 * t747 * t580;
  t759 = t278 * t197;
  t760 = t205 * t759;
  t761 = t572 * t760;
  t764 = t136 * t93 * t178;
  t765 = t89 * t764;
  t766 = t765 * t641;
  t770 = t497 * t278;
  t776 = t182 * t286;
  t777 = t205 * t776;
  t780 = t513 * t735;
  t782 = t286 * t91;
  t784 = t89 * t782 * t199;
  t788 = t89 * t136 * t193 * t199;
  t790 = 0.2e1 * t234 * t777 + 0.2e1 * t740 * t252 - 0.2e1 * t714 * t257 + t445 * t279 + t282 * t675 - t602 * t780 - 0.3e1 * t652 * t770 - 0.2e1 * t717 * t657 - t291 - 0.3e1 * t750 - 0.3e1 * t752 + 0.3e1 * t757 + 0.3e1 * t761 + 0.3e1 * t766 - 0.2e1 * t784 - t788;
  t792 = my_piecewise5(t52, 0, t55, 0, t746 + t790);
  t794 = 0.1e3 / 0.243e3 * t227 - 0.25e2 / 0.81e2 * t230 + 0.5e1 / 0.54e2 * t30 * t129 * t210 + t167 * t139 + 0.2e1 * t87 * t297 + t47 * t792;
  t799 = my_piecewise3(t3, 0, -t8 * t150 * t141 / 0.3e2 + t8 * t73 * t299 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t794);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t799 + 0.4e1 * t304;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t806 = t30 * t223 * t121;
  t809 = t30 * t110 * t260;
  t812 = t310 * t419;
  t813 = t173 * t812;
  t815 = t91 * t62 * t96;
  t816 = t475 * t815;
  t819 = t206 * t245;
  t820 = t205 * t819;
  t823 = t432 * t812;
  t824 = t528 * t91;
  t825 = t513 * t824;
  t829 = t188 * t189 * t245;
  t832 = t518 * t91;
  t833 = t497 * t832;
  t836 = t317 * t176;
  t837 = t173 * t836;
  t838 = t837 * t257;
  t839 = t310 * t197;
  t840 = t89 * t839;
  t842 = t188 * t251 * t93;
  t843 = t840 * t842;
  t849 = t310 * t93;
  t850 = t173 * t849;
  t851 = t182 * t91;
  t852 = t851 * t197;
  t853 = t205 * t852;
  t854 = t850 * t853;
  t856 = t514 * t91;
  t857 = t513 * t856;
  t860 = t89 * t812;
  t864 = t173 * t839 * t178;
  t865 = params->csk_a * t91;
  t866 = t865 * t452;
  t867 = t864 * t866;
  t870 = t89 * t849 * t178;
  t871 = t865 * t197;
  t872 = t97 * t871;
  t873 = t870 * t872;
  t875 = 0.2e1 * t239 * t829 - 0.2e1 * t254 * t820 - 0.2e1 * t254 * t829 + 0.3e1 * t813 * t816 + 0.3e1 * t813 * t833 - 0.3e1 * t860 * t816 - 0.2e1 * t823 * t825 - 0.3e1 * t823 * t833 + 0.3e1 * t823 * t857 - t319 - t321 - t838 + 0.3e1 * t843 + 0.3e1 * t854 - 0.3e1 * t867 + 0.3e1 * t873;
  t876 = t865 * t93;
  t877 = t183 * t876;
  t878 = t864 * t877;
  t880 = t497 * t256;
  t884 = t501 * t503 * t91;
  t889 = t89 * t836;
  t890 = t889 * t241;
  t891 = t837 * t241;
  t892 = t889 * t252;
  t893 = t501 * t251;
  t896 = t497 * t851;
  t901 = t91 * t419;
  t902 = t432 * t901;
  t903 = t436 * t310;
  t904 = t513 * t903;
  t906 = t182 * t317;
  t907 = t205 * t906;
  t908 = t234 * t907;
  t909 = t317 * t91;
  t911 = t89 * t909 * t199;
  t912 = t118 * t197;
  t913 = t89 * t912;
  t914 = t94 * t62;
  t915 = t96 * t245;
  t917 = t913 * t914 * t915;
  t918 = 0.2e1 * t917;
  t919 = t188 * t915;
  t922 = 0.2e1 * t239 * t919 + 0.2e1 * t254 * t662 + 0.3e1 * t813 * t884 - 0.3e1 * t813 * t896 + 0.3e1 * t823 * t880 - t823 * t884 - t860 * t884 - 0.2e1 * t860 * t893 - t902 * t904 - 0.3e1 * t878 + t890 - t891 + t892 + t908 - t911 - t918;
  t924 = my_piecewise5(t52, 0, t55, 0, t875 + t922);
  t926 = 0.8e2 / 0.243e3 * t806 - 0.1e2 / 0.81e2 * t809 + t87 * t327 + t47 * t924;
  t931 = my_piecewise3(t3, 0, t8 * t73 * t329 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t926);
  tv3rhosigma20 = 0.2e1 * rho[0] * t931 + 0.2e1 * t333;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t942 = t30 * t223 * t139;
  t945 = t30 * t110 * t297;
  t948 = t345 * t197;
  t949 = t173 * t948;
  t951 = t450 * t91 * t452;
  t952 = t949 * t951;
  t954 = t97 * params->csk_a;
  t955 = t248 * t197;
  t956 = t954 * t955;
  t957 = t765 * t956;
  t959 = t205 * t182;
  t960 = t959 * t876;
  t961 = t949 * t960;
  t967 = t622 * t136;
  t968 = t513 * t967;
  t972 = t348 * t91;
  t973 = t501 * t972;
  t976 = t278 * t91;
  t977 = t497 * t976;
  t980 = t709 * t421;
  t981 = t89 * t980;
  t982 = params->csk_a * t118;
  t983 = t982 * t91;
  t984 = t97 * t983;
  t987 = t583 * t421;
  t988 = t432 * t987;
  t989 = t136 * params->csk_a;
  t990 = t989 * t91;
  t991 = t183 * t990;
  t994 = t502 * t118;
  t995 = t994 * t91;
  t996 = t97 * t995;
  t998 = t173 * t980;
  t1001 = t432 * t980;
  t1003 = -t1001 * t996 + t282 * t829 - t293 * t820 - t293 * t829 - t714 * t343 + t740 * t343 - t714 * t353 - 0.3e1 * t584 * t977 - 0.2e1 * t717 * t973 - t902 * t968 - 0.3e1 * t981 * t984 - t981 * t996 + 0.3e1 * t988 * t991 + 0.3e1 * t998 * t996 - t319 - t838 - 0.3e1 * t952 + 0.3e1 * t957 - 0.3e1 * t961;
  t1005 = t994 * t183 * t91;
  t1008 = t437 * t995;
  t1011 = t173 * t637;
  t1012 = t289 * t197;
  t1013 = t183 * t1012;
  t1014 = t1011 * t1013;
  t1016 = t437 * t990;
  t1021 = t89 * t948;
  t1022 = t1021 * t842;
  t1028 = t286 * t118;
  t1030 = t89 * t1028 * t199;
  t1031 = t136 * t245;
  t1033 = t89 * t1031 * t199;
  t1036 = -0.3e1 * t1001 * t1005 - 0.2e1 * t1001 * t1008 + 0.3e1 * t998 * t1005 + 0.3e1 * t988 * t1016 + t254 * t777 + t591 * t279 + t282 * t919 + t740 * t349 + 0.3e1 * t998 * t984 + 0.3e1 * t1014 + 0.3e1 * t1022 - t1030 - t1033 - t347 + t890 - t891 + t892 + t908 - t911;
  t1038 = my_piecewise5(t52, 0, t55, 0, t1003 + t1036);
  t1040 = -0.25e2 / 0.162e3 * t308 + 0.5e1 / 0.54e2 * t30 * t129 * t260 + 0.4e2 / 0.243e3 * t942 - 0.5e1 / 0.81e2 * t945 + t87 * t356 + t47 * t1038;
  t1045 = my_piecewise3(t3, 0, t8 * t73 * t358 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1040);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1045 + 0.2e1 * t362;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1056 = t189 * t286;
  t1057 = t188 * t1056;
  t1060 = t367 * t419;
  t1061 = t173 * t1060;
  t1064 = t367 * t197;
  t1065 = t89 * t1064;
  t1066 = t1065 * t842;
  t1068 = t89 * t1060;
  t1073 = t432 * t1060;
  t1076 = t206 * t286;
  t1090 = t367 * t93;
  t1091 = t173 * t1090;
  t1092 = t1091 * t853;
  t1094 = -0.2e1 * t293 * t205 * t1076 + 0.2e1 * t282 * t1057 - 0.2e1 * t293 * t1057 + 0.3e1 * t1061 * t816 + 0.3e1 * t1061 * t833 + 0.3e1 * t1061 * t884 - 0.3e1 * t1068 * t816 - t1068 * t884 - 0.2e1 * t1073 * t825 - 0.3e1 * t1073 * t833 + 0.3e1 * t1073 * t880 - t1073 * t884 + 0.3e1 * t1066 + 0.3e1 * t1092 - t319 - t374;
  t1098 = t173 * t1064 * t178;
  t1099 = t1098 * t866;
  t1102 = t89 * t1090 * t178;
  t1103 = t1102 * t872;
  t1105 = t1098 * t877;
  t1113 = t436 * t367;
  t1114 = t513 * t1113;
  t1116 = t136 * t197;
  t1117 = t89 * t1116;
  t1118 = t96 * t286;
  t1120 = t1117 * t914 * t1118;
  t1121 = 0.2e1 * t1120;
  t1125 = 0.2e1 * t282 * t188 * t1118 - 0.3e1 * t1061 * t896 - 0.2e1 * t1068 * t893 + 0.3e1 * t1073 * t857 - t902 * t1114 + 0.2e1 * t293 * t777 - 0.3e1 * t1099 + 0.3e1 * t1103 - 0.3e1 * t1105 - t1121 - t838 + t890 - t891 + t892 + t908 - t911;
  t1127 = my_piecewise5(t52, 0, t55, 0, t1094 + t1125);
  t1129 = -0.25e2 / 0.81e2 * t339 + 0.5e1 / 0.27e2 * t30 * t129 * t297 + t87 * t380 + t47 * t1127;
  t1134 = my_piecewise3(t3, 0, t8 * t73 * t382 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1129);
  tv3rholapl20 = 0.2e1 * rho[0] * t1134 + 0.2e1 * t386;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1138 = t30 * t110 * t327;
  t1140 = t310 * t118;
  t1149 = t189 * t317;
  t1150 = t188 * t1149;
  t1151 = t239 * t1150;
  t1152 = 0.3e1 * t1151;
  t1153 = t837 * t353;
  t1154 = 0.3e1 * t1153;
  t1155 = t837 * t343;
  t1156 = 0.3e1 * t1155;
  t1157 = t1140 * t197;
  t1158 = t173 * t1157;
  t1159 = t1158 * t453;
  t1160 = 0.3e1 * t1159;
  t1161 = t1140 * t93;
  t1163 = t89 * t1161 * t470;
  t1164 = 0.3e1 * t1163;
  t1165 = t1158 * t464;
  t1166 = 0.3e1 * t1165;
  t1167 = t1140 * t419;
  t1168 = t432 * t1167;
  t1171 = t173 * t1167;
  t1174 = -0.3e1 * t173 * t1140 * t423 - 0.2e1 * t89 * t1140 * t427 - t432 * t1140 * t438 - 0.2e1 * t1168 * t529 + 0.3e1 * t1171 * t519 + t1152 - t1154 - t1156 - t1160 + t1164 - t1166 - t319 - t321;
  t1175 = t317 * t118;
  t1177 = t89 * t1175 * t199;
  t1178 = 0.3e1 * t1177;
  t1181 = t254 * t907;
  t1182 = 0.3e1 * t1181;
  t1186 = t173 * t1161 * t481;
  t1187 = 0.3e1 * t1186;
  t1188 = t889 * t349;
  t1189 = 0.3e1 * t1188;
  t1191 = t89 * t1157 * t490;
  t1192 = 0.3e1 * t1191;
  t1195 = t89 * t1167;
  t1204 = 0.3e1 * t1168 * t498 - t1168 * t504 + 0.3e1 * t1168 * t515 - 0.3e1 * t1168 * t519 + 0.3e1 * t1171 * t476 + 0.3e1 * t1171 * t504 - 0.3e1 * t1195 * t476 - t1195 * t504 - t1178 + t1182 + t1187 + t1189 + t1192;
  t1206 = my_piecewise5(t52, 0, t55, 0, t1174 + t1204);
  t1208 = -0.5e1 / 0.27e2 * t1138 + t47 * t1206;
  t1212 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1208);
  tv3sigma30 = 0.2e1 * rho[0] * t1212;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1218 = t30 * t110 * t356;
  t1221 = t310 * t62 * t96;
  t1222 = t475 * t1221;
  t1229 = t503 * t310;
  t1230 = t501 * t1229;
  t1235 = t850 * t760;
  t1236 = 0.3e1 * t1235;
  t1237 = t136 * t310;
  t1238 = t89 * t1237;
  t1239 = t1238 * t580;
  t1240 = 0.3e1 * t1239;
  t1241 = 0.2e1 * t1151;
  t1242 = 0.2e1 * t1153;
  t1243 = 0.2e1 * t1155;
  t1244 = t528 * t310;
  t1245 = t513 * t1244;
  t1248 = t518 * t310;
  t1249 = t497 * t1248;
  t1252 = t293 * t1150;
  t1255 = 0.3e1 * t710 * t1222 - 0.3e1 * t717 * t1222 + 0.3e1 * t710 * t1230 - t717 * t1230 - t727 * t1230 - 0.2e1 * t727 * t1245 + 0.3e1 * t710 * t1249 - 0.3e1 * t727 * t1249 + 0.3e1 * t823 * t721 + t1236 + t1240 + t1241 - t1242 - t1243 - t1252 - t319;
  t1256 = t206 * t317;
  t1257 = t205 * t1256;
  t1258 = t293 * t1257;
  t1261 = t282 * t1150;
  t1262 = t1237 * t197;
  t1263 = t173 * t1262;
  t1264 = t1263 * t464;
  t1265 = 0.3e1 * t1264;
  t1266 = t1263 * t453;
  t1267 = 0.3e1 * t1266;
  t1268 = params->csk_a * t310;
  t1269 = t1268 * t197;
  t1270 = t97 * t1269;
  t1271 = t765 * t1270;
  t1272 = 0.3e1 * t1271;
  t1273 = 0.2e1 * t1177;
  t1274 = 0.2e1 * t1181;
  t1275 = 0.2e1 * t1188;
  t1276 = t96 * t317;
  t1277 = t188 * t1276;
  t1278 = t282 * t1277;
  t1279 = t837 * t279;
  t1281 = t136 * t317;
  t1283 = t89 * t1281 * t199;
  t1286 = t96 * t310;
  t1287 = t501 * t1286;
  t1290 = -0.2e1 * t717 * t1287 + 0.3e1 * t823 * t737 - 0.3e1 * t813 * t770 - t823 * t780 - t1258 + t1261 - t1265 - t1267 + t1272 - t1273 + t1274 + t1275 + t1278 + t1279 - t1283 - t347;
  t1292 = my_piecewise5(t52, 0, t55, 0, t1255 + t1290);
  t1294 = 0.5e1 / 0.54e2 * t30 * t129 * t327 - 0.1e2 / 0.81e2 * t1218 + t47 * t1292;
  t1298 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1294);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1298;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1304 = t30 * t110 * t380;
  t1306 = t183 * t118;
  t1307 = t598 * t1306;
  t1310 = t1091 * t574;
  t1311 = 0.3e1 * t1310;
  t1314 = t503 * t118;
  t1315 = t501 * t1314;
  t1321 = t118 * t62 * t96;
  t1322 = t475 * t1321;
  t1327 = t528 * t118;
  t1337 = t1065 * t188 * t348 * t93;
  t1338 = 0.3e1 * t1337;
  t1339 = -0.2e1 * t1073 * t513 * t1327 + 0.3e1 * t1061 * t1307 + 0.3e1 * t1061 * t1315 + 0.3e1 * t1061 * t1322 - t1068 * t1315 - 0.3e1 * t1068 * t1322 - 0.3e1 * t1073 * t1307 - t1073 * t1315 + 0.3e1 * t1073 * t603 + 0.3e1 * t1073 * t624 + t1151 - t1153 + t1311 + t1338 - t319 - t374;
  t1340 = 0.2e1 * t1252;
  t1341 = 0.2e1 * t1258;
  t1342 = 0.2e1 * t1261;
  t1343 = t982 * t93;
  t1345 = t1098 * t183 * t1343;
  t1346 = 0.3e1 * t1345;
  t1348 = t1098 * t982 * t452;
  t1349 = 0.3e1 * t1348;
  t1350 = t982 * t197;
  t1351 = t97 * t1350;
  t1352 = t1102 * t1351;
  t1353 = 0.3e1 * t1352;
  t1354 = 0.2e1 * t1278;
  t1355 = 0.2e1 * t1279;
  t1356 = 0.2e1 * t1283;
  t1363 = -0.2e1 * t1068 * t501 * t348 - 0.3e1 * t1061 * t653 - t597 * t1114 - t1155 - t1177 + t1181 + t1188 - t1340 - t1341 + t1342 - t1346 - t1349 + t1353 + t1354 + t1355 - t1356;
  t1365 = my_piecewise5(t52, 0, t55, 0, t1339 + t1363);
  t1367 = 0.5e1 / 0.27e2 * t30 * t129 * t356 - 0.5e1 / 0.81e2 * t1304 + t47 * t1365;
  t1371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1367);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1371;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1376 = t367 * t136;
  t1385 = t1376 * t197;
  t1386 = t173 * t1385;
  t1387 = t1386 * t464;
  t1388 = 0.3e1 * t1387;
  t1389 = t1386 * t453;
  t1390 = 0.3e1 * t1389;
  t1391 = t1376 * t93;
  t1393 = t89 * t1391 * t470;
  t1394 = 0.3e1 * t1393;
  t1395 = 0.3e1 * t1252;
  t1396 = 0.3e1 * t1258;
  t1397 = 0.3e1 * t1261;
  t1398 = 0.3e1 * t1278;
  t1399 = 0.3e1 * t1279;
  t1400 = -0.3e1 * t173 * t1376 * t423 - 0.2e1 * t89 * t1376 * t427 - t432 * t1376 * t438 - t1388 - t1390 + t1394 - t1395 - t1396 + t1397 + t1398 + t1399 - t319 - t374;
  t1401 = 0.3e1 * t1283;
  t1402 = t1376 * t419;
  t1403 = t89 * t1402;
  t1406 = t432 * t1402;
  t1413 = t173 * t1402;
  t1416 = t89 * t1385;
  t1417 = t1416 * t490;
  t1418 = 0.3e1 * t1417;
  t1420 = t173 * t1391 * t481;
  t1421 = 0.3e1 * t1420;
  t1430 = -0.3e1 * t1403 * t476 - t1403 * t504 + 0.3e1 * t1406 * t498 - t1406 * t504 + 0.3e1 * t1406 * t515 - 0.3e1 * t1406 * t519 - 0.2e1 * t1406 * t529 + 0.3e1 * t1413 * t476 + 0.3e1 * t1413 * t504 + 0.3e1 * t1413 * t519 - t1401 + t1418 + t1421;
  t1432 = my_piecewise5(t52, 0, t55, 0, t1400 + t1430);
  t1434 = 0.5e1 / 0.18e2 * t30 * t129 * t380 + t47 * t1432;
  t1438 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1434);
  tv3lapl30 = 0.2e1 * rho[0] * t1438;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1460 = t30 * t33 / t23 / t157 / t34;
  t1466 = 0.154e5 / 0.2187e4 * t30 * t40 * t403 - 0.10472e6 / 0.6561e4 * t1460;
  t1474 = t193 * t193;
  t1475 = t89 * t1474;
  t1483 = my_piecewise3(t55, 0, t1466);
  t1484 = my_piecewise3(t57, t1483, 0);
  t1487 = t171 * t171;
  t1489 = t64 / t1487;
  t1490 = t174 * t174;
  t1492 = t176 * t176;
  t1493 = t177 * t177;
  t1494 = 0.1e1 / t1493;
  t1495 = t1492 * t1494;
  t1496 = t180 * t180;
  t1497 = t181 * t181;
  t1498 = 0.1e1 / t1497;
  t1499 = t1496 * t1498;
  t1500 = t1495 * t1499;
  t1502 = t89 * t1490;
  t1503 = t1495 * t97;
  t1506 = t197 * t197;
  t1507 = t1506 * t178;
  t1508 = t1507 * t97;
  t1512 = t1495 * t437;
  t1515 = t173 * t1490;
  t1516 = t1507 * t183;
  t1519 = t1495 * t183;
  t1526 = t1490 * t197;
  t1527 = t89 * t1526;
  t1528 = t96 * t176;
  t1530 = t501 * t1528 * params->csk_a;
  t1533 = t441 * t176;
  t1534 = t89 * t1533;
  t1537 = t193 * t419;
  t1538 = t173 * t1537;
  t1541 = t173 * t1526;
  t1544 = t89 * t601;
  t1545 = t501 * t457;
  t1549 = t501 * t503 * t193;
  t1553 = t497 * t518 * t176;
  t1556 = -0.18e2 * t1527 * t1530 + 0.18e2 * t1541 * t1530 + 0.4e1 * t1534 * t241 + 0.18e2 * t1538 * t587 + 0.18e2 * t1541 * t1553 - 0.18e2 * t1544 * t1545 - 0.6e1 * t1544 * t1549 - t200 - 0.4e1 * t454 - 0.4e1 * t465 + 0.4e1 * t471;
  t1558 = t1490 * t176;
  t1561 = t501 * t503 * t197;
  t1566 = t432 * t1537;
  t1570 = t176 * t62 * t96;
  t1571 = t598 * t1570;
  t1574 = t432 * t1526;
  t1582 = t497 * t518 * t193;
  t1585 = t436 * t193;
  t1587 = t513 * t1585 * params->csk_a;
  t1592 = t173 * t1533;
  t1597 = t205 * t480 * t193;
  t1600 = t432 * t1558;
  t1601 = t436 * t197;
  t1603 = t513 * t1601 * params->csk_a;
  t1608 = t497 * t615;
  t1614 = t497 * t480 * params->csk_a;
  t1619 = t193 * t93;
  t1622 = t188 * t656 * t197;
  t1626 = t173 * t1619 * t178;
  t1631 = params->csk_a * t193;
  t1633 = t97 * t1631 * t197;
  t1636 = t183 * t640;
  t1639 = 0.18e2 * t89 * t571 * t178 * t1633 + 0.18e2 * t89 * t1619 * t1622 - 0.18e2 * t1574 * t1553 - 0.18e2 * t1566 * t612 - 0.4e1 * t1592 * t241 + 0.18e2 * t572 * t1597 + 0.18e2 * t1600 * t1603 + 0.18e2 * t1600 * t1614 + 0.18e2 * t602 * t1608 - 0.18e2 * t1626 * t1636 - 0.18e2 * t1626 * t641;
  t1645 = t1490 * t1492;
  t1646 = t1489 * t1645;
  t1647 = t502 * params->csk_a;
  t1648 = t1494 * t1647;
  t1649 = t1648 * t437;
  t1652 = t1494 * t1496;
  t1653 = t1498 * t1647;
  t1654 = t1652 * t1653;
  t1657 = t173 * t1645;
  t1658 = t1494 * t180;
  t1659 = t182 * t1647;
  t1660 = t1658 * t1659;
  t1663 = t432 * t1645;
  t1668 = t1498 * t502;
  t1669 = t1652 * t1668;
  t1675 = t1658 * t518;
  t1678 = t1494 * t434;
  t1679 = t1678 * t528;
  t1685 = t1498 * params->csk_a;
  t1686 = t1652 * t1685;
  t1697 = t497 * t509;
  t1700 = t1490 * t1506;
  t1701 = t173 * t1700;
  t1707 = t1494 * params->csk_a;
  t1708 = t1707 * t97;
  t1712 = t497 * t480;
  t1715 = 0.4e1 * t234 * t205 * t182 * t441 - 0.4e1 * t89 * t441 * t91 * t199 - 0.18e2 * t173 * t1558 * t1712 - 0.6e1 * t602 * t513 * t1585 + 0.3e1 * t89 * t1700 * t190 + 0.18e2 * t1646 * t1679 - 0.6e1 * t1646 * t1686 - 0.11e2 * t1657 * t1675 - 0.11e2 * t1657 * t1708 - 0.18e2 * t652 * t1697 - 0.3e1 * t1701 * t207;
  t1720 = t501 * t1528;
  t1725 = t1658 * t206;
  t1728 = t1474 * t176;
  t1729 = t173 * t1728;
  t1732 = t513 * t1601;
  t1742 = t89 * t1645;
  t1743 = t1494 * t62;
  t1744 = t96 * t1647;
  t1745 = t1743 * t1744;
  t1749 = -0.12e2 * t89 * t1537 * t657 + 0.3e1 * t89 * t1728 * t190 - 0.12e2 * t1527 * t1720 + 0.4e1 * t1534 * t252 - 0.6e1 * t1600 * t1732 - 0.7e1 * t1657 * t1745 - 0.18e2 * t1663 * t1725 - 0.3e1 * t1701 * t190 - 0.3e1 * t1729 * t190 - 0.3e1 * t1729 * t207 + t1742 * t1745;
  t1755 = t1494 * t502;
  t1756 = t1755 * t97;
  t1761 = t1678 * t514;
  t1774 = 0.7e1 * t1646 * t1675 - t1646 * t1745 - 0.6e1 * t1646 * t1761 + 0.7e1 * t1657 * t1725 - 0.18e2 * t1657 * t1756 - 0.6e1 * t1663 * t1679 + 0.6e1 * t1663 * t1745 + 0.6e1 * t1663 * t1756 - 0.12e2 * t1663 * t1761 + 0.11e2 * t1742 * t1708 + 0.6e1 * t1742 * t1756;
  t1778 = my_piecewise5(t52, 0, t55, 0, 0.3e1 * t1515 * t1516 + 0.11e2 * t1515 * t1519 + 0.3e1 * t1502 * t1508 + 0.6e1 * t1502 * t1503 - 0.3e1 * t1475 * t199 + 0.3e1 * t1475 * t201 - 0.7e1 * t1657 * t1660 + 0.18e2 * t1663 * t1660 - 0.7e1 * t1646 * t1660 + 0.11e2 * t1646 * t1669 + 0.12e2 * t1663 * t1649 - 0.12e2 * t1646 * t1649 - 0.6e1 * t1646 * t1654 + 0.18e2 * t652 * t1582 + 0.18e2 * t602 * t1587 - 0.12e2 * t1566 * t619 - 0.4e1 * t1592 * t257 + 0.18e2 * t1541 * t1571 - 0.6e1 * t1574 * t1571 + 0.18e2 * t1538 * t599 - 0.6e1 * t1566 * t599 + t1774 + t1749 + t1715 + t1639 + t1556 - 0.12e2 * t1574 * t513 * t528 * t176 + 0.3e1 * t173 * t1474 * t184 - t89 * t1484 * t98 + t1489 * t1490 * t1500 + 0.6e1 * t432 * t1490 * t1512 - 0.6e1 * t89 * t1558 * t1561 + 0.4e1 * t482 + 0.4e1 * t491 - 0.5e1 * t524);
  t1785 = my_piecewise3(t3, 0, -0.14e2 / 0.135e3 * t8 * t21 / t22 / t77 * t67 + 0.8e1 / 0.45e2 * t8 * t391 * t102 - t8 * t150 * t212 / 0.5e1 + 0.2e1 / 0.5e1 * t8 * t73 * t536 + 0.3e1 / 0.2e2 * t8 * t24 * (0.1309e5 / 0.729e3 * t1460 + t1466 * t65 + 0.4e1 * t411 * t100 + 0.6e1 * t167 * t210 + 0.4e1 * t87 * t534 + t47 * t1778));
  tv4rho40 = 0.2e1 * rho[0] * t1785 + 0.8e1 * t541;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1798 = t32 * t403;
  t1799 = t30 * t1798;
  t1819 = my_piecewise3(t55, 0, 0.616e4 / 0.2187e4 * t1799);
  t1820 = my_piecewise3(t57, t1819, 0);
  t1827 = t251 * t197;
  t1828 = t1631 * t62 * t1827;
  t1831 = t183 * params->csk_a;
  t1833 = t1831 * t522 * t197;
  t1838 = t238 * t421;
  t1839 = t432 * t1838;
  t1840 = t502 * t417;
  t1841 = t97 * t197;
  t1842 = t1840 * t1841;
  t1845 = t417 * t176;
  t1847 = t432 * t1845 * t421;
  t1848 = t183 * t1350;
  t1851 = t173 * t987;
  t1853 = t502 * t193 * t91;
  t1854 = t183 * t1853;
  t1857 = t118 * t417;
  t1862 = t118 * t1492;
  t1863 = t432 * t1862;
  t1865 = t417 * t62 * t96;
  t1866 = t1755 * t1865;
  t1869 = t417 * t1492;
  t1870 = t432 * t1869;
  t1871 = t1658 * t352;
  t1874 = 0.18e2 * t173 * t1857 * t197 * t1530 - t89 * t1820 * t98 - 0.9e1 * t1011 * t1828 - 0.9e1 * t1011 * t1833 + 0.9e1 * t638 * t1828 - 0.6e1 * t1839 * t1842 + 0.18e2 * t1847 * t1848 + 0.9e1 * t1851 * t1854 + 0.6e1 * t1863 * t1866 - 0.18e2 * t1870 * t1871 + 0.4e1 * t575 + 0.4e1 * t581 + 0.4e1 * t642;
  t1875 = t436 * t1647;
  t1877 = t1678 * t1875 * t417;
  t1880 = t245 * t419;
  t1881 = t173 * t1880;
  t1884 = t432 * t1880;
  t1887 = t89 * t1862;
  t1890 = t173 * t1862;
  t1893 = t1648 * t1865;
  t1896 = t1489 * t1862;
  t1901 = t245 * t93;
  t1905 = t1707 * t1865;
  t1908 = t568 * t176;
  t1909 = t89 * t1908;
  t1912 = t173 * t1857;
  t1913 = t1507 * t954;
  t1916 = t173 * t1845;
  t1920 = 0.9e1 * t89 * t1901 * t1622 - 0.18e2 * t1916 * t497 * t573 + 0.12e2 * t1863 * t1877 + 0.6e1 * t1863 * t1893 + 0.6e1 * t1887 * t1866 - 0.18e2 * t1890 * t1866 + 0.9e1 * t1881 * t599 - 0.3e1 * t1884 * t599 + t1887 * t1893 - 0.7e1 * t1890 * t1893 - 0.11e2 * t1890 * t1905 - t1896 * t1893 + 0.3e1 * t1909 * t241 - 0.3e1 * t1912 * t1913;
  t1922 = t89 * t1857;
  t1924 = t197 * t421 * t1570;
  t1927 = t1507 * t1831;
  t1931 = t1678 * t528 * t417;
  t1934 = t1678 * t623;
  t1943 = t89 * t1880;
  t1947 = t1658 * t1659 * t417;
  t1954 = t450 * t441 * t62 * t96;
  t1958 = t173 * t1908;
  t1963 = -0.6e1 * t1863 * t1931 + 0.18e2 * t1863 * t1947 - 0.12e2 * t1870 * t1934 - 0.12e2 * t1896 * t1877 + 0.9e1 * t1881 * t587 + 0.11e2 * t1887 * t1905 - 0.7e1 * t1890 * t1947 - 0.3e1 * t1912 * t1927 + 0.3e1 * t1922 * t1913 - 0.12e2 * t1922 * t1924 - 0.3e1 * t1943 * t599 - t254 * t1954 - 0.3e1 * t1958 * t241 - 0.3e1 * t591 * t458;
  t1964 = t497 * t819;
  t1971 = t173 * t1869;
  t1975 = t1658 * t518 * t417;
  t1980 = t1489 * t1869;
  t1982 = t1658 * t235 * t502;
  t1991 = t432 * t1845;
  t1993 = t513 * t622 * t197;
  t1996 = t173 * t901;
  t2002 = t501 * t251 * t193;
  t2007 = t205 * t661 * t197;
  t2010 = 0.9e1 * t602 * t1964 - 0.9e1 * t1884 * t612 - 0.9e1 * t1943 * t587 + 0.7e1 * t1971 * t1871 - 0.11e2 * t1890 * t1975 - 0.3e1 * t1958 * t257 + 0.7e1 * t1980 * t1982 - 0.7e1 * t1896 * t1947 - 0.3e1 * t902 * t513 * t1585 * t118 - 0.6e1 * t1991 * t1993 - 0.9e1 * t1996 * t497 * t235 * t193 - 0.6e1 * t594 * t2002 + t239 * t1954 + 0.9e1 * t572 * t2007;
  t2016 = t205 * t206 * t441;
  t2020 = t1498 * t118;
  t2026 = t1652 * t1653 * t417;
  t2029 = t436 * t245;
  t2031 = t513 * t2029 * params->csk_a;
  t2035 = t1652 * t2020 * params->csk_a;
  t2044 = t1678 * t1327;
  t2047 = t89 * t1838;
  t2050 = t173 * t1838;
  t2053 = 0.11e2 * t1980 * t1652 * t2020 * t502 - 0.6e1 * t2047 * t1842 + 0.18e2 * t2050 * t1842 + 0.9e1 * t1881 * t612 - 0.6e1 * t1884 * t619 - 0.6e1 * t1896 * t2026 - 0.6e1 * t1980 * t1934 - 0.6e1 * t1980 * t2035 + 0.18e2 * t1980 * t2044 - t254 * t2016 + 0.9e1 * t602 * t2031 + 0.3e1 * t627 * t458 - 0.3e1 * t591 * t616;
  t2056 = t97 * params->csk_a * t417 * t197;
  t2059 = t1901 * t178;
  t2060 = t173 * t2059;
  t2063 = t1631 * t815;
  t2066 = t183 * t197;
  t2067 = t1840 * t2066;
  t2071 = t437 * t1840 * t197;
  t2074 = t437 * t1350;
  t2079 = t91 * t93;
  t2081 = t173 * t2079 * t178;
  t2082 = t912 * t193;
  t2088 = t188 * t489 * t193;
  t2092 = t432 * t901 * t421;
  t2093 = t982 * t193;
  t2097 = t437 * t1853;
  t2100 = t502 * t91;
  t2101 = t97 * t193;
  t2102 = t2100 * t2101;
  t2109 = 0.9e1 * t2081 * t183 * t2082 + 0.9e1 * t89 * t955 * t2088 + 0.9e1 * t2092 * t437 * t2093 - 0.9e1 * t2060 * t1636 - 0.18e2 * t1839 * t2067 - 0.12e2 * t1839 * t2071 + 0.18e2 * t1847 * t2074 + 0.9e1 * t1851 * t2063 + 0.9e1 * t1851 * t2102 - 0.9e1 * t988 * t1854 - 0.18e2 * t2047 * t2056 - 0.9e1 * t2060 * t641 - 0.6e1 * t988 * t2097 - 0.3e1 * t988 * t2102;
  t2114 = t89 * t987;
  t2131 = t188 * t96 * t441;
  t2136 = 0.9e1 * t2092 * t183 * t2093 + 0.9e1 * t89 * t2059 * t641 + t1592 * t236 + 0.3e1 * t1909 * t252 + 0.18e2 * t2050 * t2067 - 0.9e1 * t2114 * t2063 - 0.3e1 * t2114 * t2102 + t239 * t2131 + 0.3e1 * t445 * t662 - t250 - 0.4e1 * t646 - 0.4e1 * t648 - 0.3e1 * t669 - 0.2e1 * t673;
  t2137 = t513 * t2029;
  t2150 = t205 * t182 * t568;
  t2159 = t497 * t661;
  t2162 = t1678 * t622;
  t2166 = t1743 * t96 * t417;
  t2170 = t173 * t417 * t1506;
  t2180 = -0.3e1 * t602 * t2137 + t1980 * t1652 * t2020 - 0.3e1 * t89 * t245 * t193 * t199 - t89 * t118 * t441 * t199 + 0.3e1 * t234 * t2150 - 0.3e1 * t89 * t568 * t91 * t199 + 0.3e1 * t627 * t675 - 0.9e1 * t652 * t2159 + 0.6e1 * t1870 * t2162 + 0.6e1 * t1887 * t2166 + 0.3e1 * t2170 * t236 + 0.11e2 * t1971 * t1658 * t235 + 0.3e1 * t1922 * t1508 - 0.6e1 * t1943 * t657;
  t2184 = my_piecewise5(t52, 0, t55, 0, t1874 + t1920 + t1963 + t2010 + t2053 + t2109 + t2136 + t2180);
  t2191 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t391 * t123 - t8 * t150 * t262 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t73 * t681 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.77e3 / 0.243e3 * t1799 + 0.616e4 / 0.2187e4 * t30 * t1798 * t65 - 0.44e3 / 0.243e3 * t30 * t551 * t100 + 0.4e2 / 0.81e2 * t30 * t223 * t210 - 0.5e1 / 0.81e2 * t30 * t110 * t534 + t411 * t121 + 0.3e1 * t167 * t260 + 0.3e1 * t87 * t679 + t47 * t2184));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2191 + 0.6e1 * t686;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2216 = my_piecewise3(t55, 0, -0.11e4 / 0.729e3 * t552);
  t2217 = my_piecewise3(t57, t2216, 0);
  t2220 = t173 * t764;
  t2227 = t286 * t93;
  t2228 = t2227 * t178;
  t2229 = t173 * t2228;
  t2234 = t89 * t2228;
  t2237 = t281 * t421;
  t2238 = t173 * t2237;
  t2243 = t989 * t193;
  t2244 = t183 * t2243;
  t2251 = t89 * t2237;
  t2254 = -t89 * t2217 * t98 - 0.9e1 * t2220 * t1828 + 0.9e1 * t765 * t1828 - 0.9e1 * t2220 * t1833 + 0.18e2 * t2238 * t1842 - 0.6e1 * t2251 * t1842 + 0.9e1 * t998 * t1854 - 0.9e1 * t981 * t2063 + 0.9e1 * t998 * t2063 + 0.18e2 * t2238 * t2067 + 0.9e1 * t2092 * t2244 - 0.9e1 * t2229 * t641 + 0.9e1 * t2234 * t641;
  t2255 = t432 * t2237;
  t2258 = t989 * t197;
  t2259 = t437 * t2258;
  t2264 = t183 * t2258;
  t2275 = t437 * t2243;
  t2289 = 0.9e1 * t89 * t1012 * t2088 - 0.9e1 * t1001 * t1854 - 0.6e1 * t1001 * t2097 - 0.3e1 * t1001 * t2102 - 0.9e1 * t2229 * t1636 - 0.6e1 * t2255 * t1842 + 0.18e2 * t1847 * t2259 + 0.18e2 * t1847 * t2264 + 0.18e2 * t2238 * t2056 - 0.18e2 * t2255 * t2067 - 0.12e2 * t2255 * t2071 + 0.9e1 * t2092 * t2275 - 0.3e1 * t981 * t2102 + 0.9e1 * t998 * t2102;
  t2294 = t183 * t1116 * t193;
  t2297 = t136 * t1492;
  t2298 = t173 * t2297;
  t2302 = t1658 * t278 * t502;
  t2305 = t136 * t417;
  t2306 = t173 * t2305;
  t2311 = t432 * t2297;
  t2314 = t1678 * t736;
  t2317 = t89 * t2305;
  t2320 = t89 * t2297;
  t2329 = t1489 * t2297;
  t2331 = -0.12e2 * t1870 * t2314 - 0.7e1 * t2298 * t1893 + 0.6e1 * t2311 * t1893 - t2329 * t1893 - 0.11e2 * t2298 * t1905 + 0.11e2 * t2320 * t1905 - 0.3e1 * t2306 * t1913 + 0.3e1 * t2317 * t1913 - 0.12e2 * t2317 * t1924 - 0.3e1 * t2306 * t1927 - 0.6e1 * t2311 * t1931 + 0.7e1 * t1980 * t2302 - 0.18e2 * t2251 * t2056 + 0.9e1 * t2081 * t2294;
  t2338 = t286 * t419;
  t2339 = t173 * t2338;
  t2342 = t432 * t2338;
  t2348 = t89 * t2338;
  t2351 = t1658 * t720;
  t2356 = t706 * t176;
  t2357 = t173 * t2356;
  t2363 = t1678 * t735 * t502;
  t2368 = -0.18e2 * t2298 * t1866 + 0.6e1 * t2311 * t1866 + 0.6e1 * t2320 * t1866 + 0.12e2 * t2311 * t1877 + t2320 * t1893 + 0.7e1 * t1971 * t2351 - 0.11e2 * t2298 * t1975 - 0.6e1 * t1980 * t2314 + 0.18e2 * t1980 * t2363 + 0.9e1 * t2339 * t599 - 0.3e1 * t2342 * t599 - 0.9e1 * t2348 * t587 - 0.3e1 * t2348 * t599 - 0.3e1 * t2357 * t257;
  t2381 = t89 * t2356;
  t2391 = t205 * t776 * t197;
  t2395 = t513 * t735 * t197;
  t2399 = t497 * t278 * t193;
  t2405 = -0.3e1 * t902 * t513 * t1585 * t136 - 0.18e2 * t1870 * t2351 - 0.7e1 * t2298 * t1947 - 0.6e1 * t1991 * t2395 - 0.9e1 * t1996 * t2399 - 0.6e1 * t717 * t2002 - t293 * t2016 + 0.9e1 * t2339 * t587 - 0.6e1 * t2342 * t619 - 0.3e1 * t2357 * t241 + 0.3e1 * t2381 * t241 + 0.9e1 * t572 * t2391 - 0.3e1 * t714 * t458;
  t2406 = t1498 * t136;
  t2408 = t1652 * t2406 * t502;
  t2413 = t436 * t286;
  t2415 = t513 * t2413 * params->csk_a;
  t2419 = t1652 * t2406 * params->csk_a;
  t2436 = t497 * t1076;
  t2441 = -0.12e2 * t2329 * t1877 + 0.18e2 * t2311 * t1947 - 0.7e1 * t2329 * t1947 + t282 * t1954 - t293 * t1954 + 0.11e2 * t1980 * t2408 - 0.6e1 * t1980 * t2419 - 0.6e1 * t2329 * t2026 + 0.9e1 * t2339 * t612 - 0.9e1 * t2342 * t612 + 0.9e1 * t602 * t2415 + 0.9e1 * t602 * t2436 + 0.3e1 * t740 * t458 - 0.3e1 * t714 * t616;
  t2446 = t497 * t759;
  t2464 = 0.9e1 * t89 * t2227 * t1622 + 0.3e1 * t2317 * t1508 - 0.18e2 * t1916 * t2446 + 0.6e1 * t2320 * t2166 + 0.3e1 * t2170 * t279 - 0.6e1 * t2348 * t657 - t291 - 0.4e1 * t750 - 0.4e1 * t752 + 0.4e1 * t757 + 0.4e1 * t761 + 0.4e1 * t766 - 0.3e1 * t784 - 0.2e1 * t788;
  t2465 = t1658 * t278;
  t2470 = t513 * t2413;
  t2473 = t1652 * t2406;
  t2484 = t205 * t182 * t706;
  t2493 = t497 * t776;
  t2496 = t1678 * t735;
  t2502 = -t89 * t136 * t441 * t199 - 0.3e1 * t89 * t286 * t193 * t199 - 0.3e1 * t89 * t706 * t91 * t199 + t1592 * t279 + 0.6e1 * t1870 * t2496 + 0.11e2 * t1971 * t2465 + t1980 * t2473 + t282 * t2131 + 0.3e1 * t234 * t2484 + 0.3e1 * t2381 * t252 - 0.3e1 * t602 * t2470 - 0.9e1 * t652 * t2493 + 0.3e1 * t445 * t777 + 0.3e1 * t740 * t675;
  t2506 = my_piecewise5(t52, 0, t55, 0, t2254 + t2289 + t2331 + t2368 + t2405 + t2441 + t2464 + t2502);
  t2513 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t391 * t141 - t8 * t150 * t299 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t73 * t794 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.11e4 / 0.729e3 * t555 + 0.1e3 / 0.81e2 * t558 - 0.25e2 / 0.54e2 * t561 + 0.5e1 / 0.54e2 * t30 * t129 * t534 + t411 * t139 + 0.3e1 * t167 * t297 + 0.3e1 * t87 * t792 + t47 * t2506));
  tv4rho3lapl0 = 0.2e1 * rho[0] * t2513 + 0.6e1 * t799;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2535 = t245 * t245;
  t2536 = t89 * t2535;
  t2544 = t667 * t197;
  t2545 = t954 * t2544;
  t2548 = t912 * t178;
  t2550 = t97 * t245;
  t2557 = t313 * t421;
  t2558 = t432 * t2557;
  t2559 = t502 * t174;
  t2560 = t2559 * t1841;
  t2563 = t317 * t93;
  t2564 = t2563 * t178;
  t2567 = 0.3e1 * t89 * t2564 * t641;
  t2568 = t173 * t2564;
  t2570 = 0.3e1 * t2568 * t641;
  t2576 = t173 * t2557;
  t2580 = t502 * t245 * t91;
  t2581 = t183 * t2580;
  t2584 = t839 * t421;
  t2587 = t97 * t186 * params->csk_a;
  t2590 = -0.12e2 * t173 * t2548 * t876 * t2550 - 0.12e2 * t1011 * t1831 * t2544 + 0.2e1 * t173 * t2535 * t184 - 0.6e1 * t89 * t2557 * t2560 - 0.18e2 * t89 * t2584 * t2587 + 0.18e2 * t2558 * t1636 + 0.12e2 * t1851 * t2581 - 0.2e1 * t2536 * t199 + 0.2e1 * t2536 * t201 + 0.12e2 * t638 * t2545 - 0.6e1 * t2558 * t2560 + 0.18e2 * t2576 * t2560 + t2567 - t2570 - t319 - t321;
  t2593 = t2559 * t197;
  t2598 = params->csk_a * t245 * t91;
  t2599 = t97 * t2598;
  t2602 = t183 * t2593;
  t2606 = 0.3e1 * t2568 * t1636;
  t2610 = t97 * t2580;
  t2618 = t1631 * t93;
  t2619 = t183 * t2618;
  t2625 = t437 * t640;
  t2633 = t1631 * t452;
  t2638 = t176 * t180 * t182;
  t2639 = t2559 * t2638;
  t2648 = -0.12e2 * t988 * t2581 - 0.12e2 * t2558 * t437 * t2593 - 0.12e2 * t2114 * t2599 + 0.18e2 * t2576 * t2602 - t2606 + 0.12e2 * t988 * t183 * t2598 - 0.4e1 * t2114 * t2610 + 0.18e2 * t173 * t2584 * t2587 + 0.3e1 * t870 * t1633 - 0.3e1 * t864 * t2619 + 0.12e2 * t1011 * t183 * t2544 + 0.18e2 * t2558 * t2625 + 0.12e2 * t89 * t2548 * t97 * t2079 * t245 - 0.3e1 * t864 * t2633 - 0.18e2 * t432 * t2584 * t2639 + 0.12e2 * t1851 * t2599 + 0.12e2 * t2092 * t437 * t982 * t245;
  t2650 = t437 * t2580;
  t2657 = t310 * t174;
  t2661 = t310 * t1506;
  t2662 = t173 * t2661;
  t2663 = t206 * t174;
  t2664 = t205 * t2663;
  t2667 = t310 * t1492;
  t2668 = t432 * t2667;
  t2669 = t1678 * t618;
  t2673 = t501 * t656 * t176;
  t2676 = t173 * t2667;
  t2677 = t1755 * t586;
  t2682 = t317 * t419;
  t2683 = t89 * t2682;
  t2685 = 0.3e1 * t2683 * t587;
  t2686 = t173 * t2682;
  t2688 = 0.3e1 * t2686 * t587;
  t2689 = t450 * t586;
  t2692 = t1707 * t586;
  t2695 = t1658 * t2663;
  t2698 = t89 * t2667;
  t2702 = t1678 * t1875 * t174;
  t2705 = 0.3e1 * t89 * t2657 * t1913 + 0.12e2 * t1851 * t2610 - 0.4e1 * t988 * t2610 - 0.8e1 * t988 * t2650 - 0.3e1 * t2662 * t2664 - 0.3e1 * t2662 * t2689 - 0.6e1 * t2668 * t2669 + 0.6e1 * t2668 * t2677 - 0.18e2 * t2668 * t2695 + 0.12e2 * t2668 * t2702 - 0.12e2 * t840 * t2673 - 0.18e2 * t2676 * t2677 - 0.11e2 * t2676 * t2692 + 0.6e1 * t2698 * t2677 - t2685 + t2688;
  t2707 = t1743 * t1744 * t174;
  t2713 = t1489 * t2667;
  t2715 = t2683 * t599;
  t2717 = 0.3e1 * t2686 * t599;
  t2718 = t432 * t2682;
  t2719 = t2718 * t599;
  t2720 = t174 * t1492;
  t2721 = t1489 * t2720;
  t2729 = t173 * t2720;
  t2730 = t1658 * t1248;
  t2734 = t1658 * t1659 * t174;
  t2744 = t1658 * t518 * t174;
  t2747 = t837 * t616;
  t2748 = -0.6e1 * t2721 * t1678 * t903 * params->csk_a + 0.3e1 * t813 * t1549 - t860 * t1549 + 0.6e1 * t2668 * t2707 + 0.18e2 * t2713 * t2669 - 0.7e1 * t2676 * t2707 - 0.7e1 * t2676 * t2734 + 0.11e2 * t2698 * t2692 + t2698 * t2707 - 0.12e2 * t2713 * t2702 - t2713 * t2707 + 0.7e1 * t2713 * t2744 - 0.11e2 * t2729 * t2730 - t2715 + t2717 - t2719 - t2747;
  t2751 = t436 * t317;
  t2753 = t513 * t2751 * params->csk_a;
  t2755 = 0.3e1 * t602 * t2753;
  t2757 = 0.2e1 * t2718 * t619;
  t2760 = t182 * t310;
  t2766 = t501 * t251 * t245;
  t2772 = t205 * t206 * t568;
  t2776 = t513 * t528 * t193;
  t2779 = t1498 * t310;
  t2785 = t1652 * t1653 * t174;
  t2789 = t188 * t189 * t568;
  t2799 = t889 * t458;
  t2800 = 0.11e2 * t2721 * t1652 * t2779 * t502 - 0.18e2 * t203 * t497 * t2760 * t197 + 0.3e1 * t813 * t1545 - t823 * t1549 + 0.3e1 * t813 * t1582 + 0.3e1 * t840 * t2088 + 0.2e1 * t239 * t2789 - 0.2e1 * t254 * t2772 + 0.18e2 * t2668 * t2734 - 0.7e1 * t2713 * t2734 - 0.6e1 * t2713 * t2785 - 0.8e1 * t594 * t2766 - 0.2e1 * t823 * t2776 + t2755 - t2757 + t2799;
  t2802 = 0.3e1 * t2686 * t612;
  t2803 = t837 * t458;
  t2804 = t497 * t1256;
  t2806 = 0.3e1 * t602 * t2804;
  t2808 = 0.3e1 * t2718 * t612;
  t2813 = t1678 * t436 * t174 * params->csk_a;
  t2836 = t432 * t186;
  t2846 = t205 * t906 * t197;
  t2848 = 0.3e1 * t572 * t2846;
  t2849 = t2802 - t2803 + t2806 - t2808 + 0.3e1 * t823 * t1608 - 0.12e2 * t2668 * t2813 + 0.3e1 * t823 * t1587 - 0.6e1 * t2721 * t1652 * t2779 * params->csk_a - 0.3e1 * t860 * t1545 - 0.4e1 * t902 * t513 * t622 * t245 + 0.7e1 * t2676 * t2695 - 0.2e1 * t254 * t2789 - 0.3e1 * t823 * t1582 + 0.3e1 * t850 * t1597 - 0.6e1 * t2836 * t513 * t903 * t197 - 0.12e2 * t584 * t497 * t851 * t245 + t2848;
  t2853 = 0.3e1 * t89 * t2563 * t1622;
  t2854 = 0.2e1 * t838;
  t2860 = 0.2e1 * t890;
  t2861 = 0.2e1 * t891;
  t2862 = 0.2e1 * t892;
  t2863 = 0.2e1 * t908;
  t2864 = 0.3e1 * t911;
  t2866 = t2535 * t176;
  t2867 = t173 * t2866;
  t2874 = t188 * t656;
  t2877 = t1743 * t656;
  t2880 = 0.3e1 * t173 * t2657 * t1516 + 0.3e1 * t89 * t2661 * t2874 - 0.2e1 * t2867 * t190 + 0.6e1 * t2698 * t2877 + t2853 - t2854 + t2860 - t2861 + t2862 + t2863 - t2864 + 0.4e1 * t843 + 0.4e1 * t854 - 0.4e1 * t867 + 0.4e1 * t873 - 0.4e1 * t878 - 0.4e1 * t917;
  t2882 = 0.2e1 * t2683 * t657;
  t2888 = t445 * t907;
  t2889 = t513 * t2751;
  t2890 = t602 * t2889;
  t2893 = t89 * t317 * t193 * t199;
  t2894 = t96 * t568;
  t2898 = t188 * t2894;
  t2901 = t889 * t675;
  t2902 = t497 * t906;
  t2904 = 0.3e1 * t652 * t2902;
  t2905 = t501 * t674;
  t2913 = t432 * t2720;
  t2922 = -t2882 - 0.2e1 * t2867 * t207 + 0.2e1 * t89 * t2866 * t190 + t2888 - t2890 - t2893 - 0.2e1 * t913 * t914 * t2894 + 0.2e1 * t239 * t2898 + t2901 - t2904 - 0.2e1 * t860 * t2905 + 0.11e2 * t2729 * t1658 * t2760 - 0.3e1 * t813 * t1697 + 0.6e1 * t2913 * t1678 * t903 + 0.2e1 * t254 * t2150 - t1566 * t904 + t2721 * t1652 * t2779;
  t2926 = my_piecewise5(t52, 0, t55, 0, t2590 + t2648 + t2705 + t2748 + t2800 + t2849 + t2880 + t2922);
  t2933 = my_piecewise3(t3, 0, -t8 * t150 * t329 / 0.3e2 + t8 * t73 * t926 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.88e3 / 0.729e3 * t30 * t551 * t121 + 0.16e3 / 0.243e3 * t30 * t223 * t260 - 0.1e2 / 0.81e2 * t30 * t110 * t679 + t167 * t327 + 0.2e1 * t87 * t924 + t47 * t2926));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2933 + 0.4e1 * t931;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2960 = t183 * t502;
  t2964 = t1028 * t197;
  t2965 = t173 * t2964;
  t2968 = t1031 * t197;
  t2969 = t173 * t2968;
  t2976 = t432 * t186 * t421;
  t2977 = t437 * t136;
  t2981 = t432 * t948;
  t2983 = t2559 * t176;
  t2995 = t183 * t136;
  t2999 = t598 * t174;
  t3019 = -t319 + 0.18e2 * t2238 * t2960 * t644 - 0.6e1 * t2965 * t960 - 0.6e1 * t2969 * t960 - 0.3e1 * t949 * t959 * t2618 + 0.18e2 * t2976 * t2977 * t1350 - 0.12e2 * t2981 * t513 * t436 * t2983 - 0.6e1 * t2965 * t951 - 0.6e1 * t2969 * t951 - 0.3e1 * t949 * t450 * t193 * t452 + 0.18e2 * t2976 * t2995 * t1350 - 0.18e2 * t2981 * t2999 * t2638 + 0.6e1 * t2234 * t956 + 0.6e1 * t765 * t2545 + 0.18e2 * t949 * t475 * t174 * t1570 - 0.18e2 * t2251 * t954 * t644 + 0.3e1 * t765 * t954 * t2082 - 0.4e1 * t952 + 0.4e1 * t957;
  t3021 = t2338 * t421;
  t3022 = t173 * t3021;
  t3027 = t2720 * t1494;
  t3028 = t432 * t3027;
  t3029 = t345 * params->csk_a;
  t3030 = t437 * t3029;
  t3033 = t1862 * t1494;
  t3034 = t1489 * t3033;
  t3035 = t136 * t502;
  t3036 = t3035 * t174;
  t3040 = t2297 * t1494;
  t3041 = t89 * t3040;
  t3042 = t1647 * t118;
  t3043 = t3042 * t174;
  t3044 = t97 * t3043;
  t3046 = t173 * t3040;
  t3049 = t432 * t3040;
  t3052 = t1489 * t3040;
  t3054 = t437 * t3043;
  t3057 = t2559 * t1321;
  t3070 = t1631 * t1321;
  t3075 = t183 * t3029;
  t3078 = t89 * t3021;
  t3083 = 0.7e1 * t3034 * t183 * t3036 - 0.12e2 * t2251 * t97 * t644 - 0.6e1 * t2976 * t437 * t948 + 0.6e1 * t3022 * t1005 + 0.6e1 * t998 * t2581 - 0.6e1 * t981 * t2599 + 0.6e1 * t998 * t2599 - 0.12e2 * t3028 * t3030 - 0.18e2 * t3028 * t3075 + t3041 * t3044 + 0.6e1 * t3041 * t3057 - 0.7e1 * t3046 * t3044 + 0.6e1 * t3049 * t3044 - t3052 * t3044 - 0.18e2 * t3046 * t3057 + 0.12e2 * t3049 * t3054 + 0.6e1 * t3049 * t3057 + 0.3e1 * t998 * t3070 - 0.6e1 * t3078 * t984 - 0.4e1 * t961;
  t3085 = t994 * t174;
  t3093 = t97 * t982 * t174;
  t3097 = t173 * t345 * t1506;
  t3108 = t1489 * t3027;
  t3115 = t1647 * t174 * t1306;
  t3118 = t432 * t3021;
  t3123 = t994 * t2101;
  t3141 = t286 * params->csk_a;
  t3142 = t3141 * t91;
  t3143 = t183 * t3142;
  t3146 = -0.6e1 * t3049 * t437 * t3085 - 0.18e2 * t2050 * t183 * t748 + 0.11e2 * t3041 * t3093 - 0.3e1 * t3097 * t2664 - 0.3e1 * t3097 * t2689 - 0.11e2 * t3046 * t3093 + 0.3e1 * t89 * t747 * t1506 * t343 - 0.6e1 * t3108 * t1499 * t3029 + 0.6e1 * t998 * t2610 + 0.18e2 * t3049 * t3115 - 0.2e1 * t3118 * t996 - 0.2e1 * t1001 * t2610 - t1001 * t3123 - 0.7e1 * t3052 * t3115 - 0.6e1 * t3118 * t1005 - 0.3e1 * t981 * t3070 + 0.7e1 * t173 * t3027 * t3075 - 0.11e2 * t3046 * t183 * t3085 + 0.6e1 * t432 * t1880 * t421 * t991 + 0.6e1 * t988 * t3143;
  t3169 = t994 * t193;
  t3170 = t183 * t3169;
  t3195 = 0.3e1 * t988 * t2244 - 0.6e1 * t3108 * t3030 + 0.18e2 * t3034 * t437 * t3036 - 0.2e1 * t3078 * t996 - 0.2e1 * t981 * t2610 - t981 * t3123 - 0.7e1 * t3046 * t3115 + 0.6e1 * t3022 * t996 + 0.3e1 * t998 * t3123 + 0.6e1 * t3022 * t984 + 0.3e1 * t988 * t2275 + 0.3e1 * t998 * t3170 + 0.6e1 * t89 * t2964 * t842 + 0.6e1 * t89 * t2968 * t842 + 0.3e1 * t1021 * t2088 - 0.3e1 * t1001 * t3170 - 0.12e2 * t3052 * t3054 - 0.2e1 * t1001 * t437 * t3169 + 0.11e2 * t3108 * t1499 * t3035 * t118 - 0.6e1 * t3052 * t1499 * t3043;
  t3200 = t782 * t197;
  t3201 = t183 * t3200;
  t3208 = t3141 * t118;
  t3209 = t437 * t3208;
  t3214 = t989 * t245;
  t3215 = t437 * t3214;
  t3221 = t1507 * t2995;
  t3246 = 0.6e1 * t2060 * t1013 + 0.6e1 * t1011 * t3201 + 0.3e1 * t1011 * t2294 - 0.6e1 * t1001 * t2581 + 0.6e1 * t2092 * t3209 - 0.4e1 * t3118 * t1008 + 0.6e1 * t2092 * t3215 - 0.4e1 * t1001 * t2650 + t2567 - t2570 - t2606 + 0.3e1 * t173 * t577 * t3221 + 0.6e1 * t2913 * t1678 * t967 + 0.6e1 * t2320 * t1743 * t348 * t174 + 0.3e1 * t346 * t1507 * t586 - 0.4e1 * t717 * t2766 - 0.2e1 * t717 * t501 * t348 * t193 + 0.11e2 * t2729 * t1658 * t278 * t118 - 0.6e1 * t1881 * t977;
  t3247 = t776 * t91;
  t3248 = t497 * t3247;
  t3256 = t513 * t2029 * t136;
  t3279 = -0.6e1 * t584 * t3248 - 0.3e1 * t584 * t2399 - t293 * t2772 - t1566 * t968 - 0.2e1 * t902 * t3256 - 0.2e1 * t902 * t513 * t622 * t286 + t2721 * t1652 * t2020 * t136 + t2381 * t343 + 0.2e1 * t740 * t829 + t282 * t2789 - 0.4e1 * t2348 * t973 - t2357 * t343 - 0.2e1 * t714 * t829 - t293 * t2789 - t2357 * t353 - 0.2e1 * t714 * t820 - t2685 + t2688 - t2715 + t2717;
  t3286 = t2999 * t1570;
  t3291 = t97 * t502;
  t3295 = -t89 * t136 * t568 * t199 - 0.6e1 * t2251 * t3291 * t644 - 0.6e1 * t2981 * t3286 + 0.18e2 * t949 * t3286 + 0.4e1 * t1014 + 0.4e1 * t1022 - t2719 - t2747 + t2755 - t2757 + t2799 + t2802 - t2803 + t2806 - t2808 + t2848 + t2853 - t2854 + t2860 - t2861;
  t3313 = -t89 * t706 * t118 * t199 - 0.2e1 * t89 * t286 * t245 * t199 + t1958 * t279 + t2381 * t349 + t254 * t2484 + t282 * t2898 + 0.2e1 * t591 * t777 + 0.2e1 * t740 * t919 - 0.2e1 * t1030 - 0.2e1 * t1033 + t2862 + t2863 - t2864 - t2882 + t2888 - t2890 - t2893 + t2901 - t2904 - t347;
  t3317 = my_piecewise5(t52, 0, t55, 0, t3019 + t3083 + t3146 + t3195 + t3246 + t3279 + t3295 + t3313);
  t3324 = my_piecewise3(t3, 0, -t8 * t150 * t358 / 0.3e2 + t8 * t73 * t1040 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.1e3 / 0.243e3 * t806 - 0.25e2 / 0.81e2 * t809 + 0.5e1 / 0.54e2 * t30 * t129 * t679 - 0.44e3 / 0.729e3 * t30 * t551 * t139 + 0.8e2 / 0.243e3 * t30 * t223 * t297 - 0.5e1 / 0.81e2 * t30 * t110 * t792 + t167 * t356 + 0.2e1 * t87 * t1038 + t47 * t3317));
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t3324 + 0.4e1 * t1045;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t3342 = t286 * t286;
  t3343 = t89 * t3342;
  t3351 = t370 * t421;
  t3352 = t89 * t3351;
  t3355 = t173 * t3351;
  t3358 = t432 * t3351;
  t3361 = t1064 * t421;
  t3362 = t89 * t3361;
  t3365 = t173 * t3361;
  t3368 = t97 * t3142;
  t3375 = t432 * t3361;
  t3382 = 0.2e1 * t173 * t3342 * t184 + 0.18e2 * t3358 * t1636 - 0.2e1 * t3343 * t199 + 0.2e1 * t3343 * t201 + 0.12e2 * t2220 * t3201 - 0.6e1 * t3352 * t2560 + 0.18e2 * t3355 * t2560 - 0.6e1 * t3358 * t2560 - 0.18e2 * t3362 * t2587 + 0.18e2 * t3365 * t2587 + 0.18e2 * t3355 * t2602 - 0.18e2 * t3375 * t2639 - 0.12e2 * t981 * t3368 + 0.12e2 * t998 * t3368 - t319 - t374;
  t3385 = t2100 * t286;
  t3386 = t97 * t3385;
  t3401 = t502 * t180;
  t3402 = t3401 * t3247;
  t3405 = t1116 * t178;
  t3406 = t89 * t3405;
  t3407 = t2079 * t286;
  t3422 = 0.12e2 * t1001 * t437 * t3142 - 0.8e1 * t1001 * t437 * t3385 - 0.12e2 * t3375 * t437 * t2983 + 0.12e2 * t3406 * t97 * t3407 + 0.12e2 * t1001 * t3143 - 0.4e1 * t1001 * t3386 - 0.12e2 * t1001 * t3402 - 0.3e1 * t1098 * t2619 - 0.3e1 * t1098 * t2633 + 0.3e1 * t1102 * t1633 + 0.18e2 * t3358 * t2625 - 0.4e1 * t981 * t3386 + 0.12e2 * t998 * t3386 + 0.12e2 * t998 * t3402 + t2567 - t2570 - t2606;
  t3424 = t367 * t1492;
  t3425 = t89 * t3424;
  t3427 = t173 * t3424;
  t3430 = t432 * t3424;
  t3433 = t1489 * t3424;
  t3439 = t367 * t1506;
  t3440 = t173 * t3439;
  t3443 = t182 * t174;
  t3450 = t367 * t174;
  t3466 = -0.18e2 * t376 * t497 * t3443 * t197 + 0.3e1 * t89 * t3450 * t1913 - 0.12e2 * t1065 * t2673 - 0.3e1 * t3440 * t2664 + 0.6e1 * t3425 * t2677 - 0.18e2 * t3427 * t2677 + 0.6e1 * t3430 * t2677 - 0.3e1 * t3440 * t2689 + 0.11e2 * t3425 * t2692 + 0.7e1 * t3427 * t2695 - 0.18e2 * t3430 * t2695 + t3425 * t2707 - 0.7e1 * t3427 * t2707 + 0.6e1 * t3430 * t2707 - t3433 * t2707 + 0.7e1 * t3433 * t2744;
  t3478 = t513 * t1113 * t197;
  t3486 = t1678 * t1113 * params->csk_a;
  t3492 = t182 * t367;
  t3509 = -0.11e2 * t3427 * t2692 - 0.6e1 * t3430 * t2669 - 0.7e1 * t3433 * t2734 + 0.3e1 * t1061 * t1545 + 0.3e1 * t1091 * t1597 - 0.6e1 * t2836 * t3478 - 0.12e2 * t710 * t3248 + 0.3e1 * t1073 * t1608 - 0.6e1 * t2721 * t3486 + 0.18e2 * t3433 * t2669 - t1068 * t1549 - 0.11e2 * t2729 * t1658 * t3492 * t502 - 0.7e1 * t3427 * t2734 - 0.12e2 * t3433 * t2702 - 0.2e1 * t293 * t205 * t206 * t706 - 0.2e1 * t1073 * t2776 - 0.6e1 * t3433 * t2785;
  t3513 = t513 * t735 * t286;
  t3525 = t450 * t97 * t706;
  t3534 = t1498 * t367;
  t3536 = t1652 * t3534 * params->csk_a;
  t3554 = 0.11e2 * t3433 * t1652 * t1668 * t174 - 0.8e1 * t717 * t501 * t251 * t286 + 0.3e1 * t1061 * t1549 + 0.3e1 * t1061 * t1582 + 0.3e1 * t1065 * t2088 - 0.3e1 * t1068 * t1545 - t1073 * t1549 - 0.3e1 * t1073 * t1582 + 0.3e1 * t1073 * t1587 + 0.12e2 * t3430 * t2702 - 0.6e1 * t2721 * t3536 + 0.18e2 * t3430 * t2734 - 0.12e2 * t3430 * t2813 + 0.2e1 * t282 * t3525 - 0.2e1 * t293 * t3525 - 0.4e1 * t902 * t3513;
  t3555 = t173 * t3405;
  t3556 = t97 * t286;
  t3563 = -0.12e2 * t3555 * t1831 * t3407 - 0.12e2 * t3555 * t876 * t3556 - t2685 + t2688 - t2715 + t2717 - t2719 - t2747 + t2755 - t2757 + t2799 + t2802 - t2803 + t2806 - t2808 + t2848 + t2853;
  t3575 = t89 * t3439;
  t3584 = t96 * t706;
  t3593 = t1678 * t1113;
  t3596 = -0.2e1 * t1117 * t914 * t3584 + 0.3e1 * t173 * t3450 * t1516 + 0.11e2 * t3427 * t1658 * t3443 + 0.2e1 * t282 * t188 * t3584 + 0.12e2 * t765 * t954 * t3200 - 0.3e1 * t1061 * t1697 + 0.3e1 * t3575 * t2874 + 0.6e1 * t3425 * t2877 + 0.6e1 * t2913 * t3593 + 0.4e1 * t1066 + 0.4e1 * t1092 - 0.4e1 * t1099 + 0.4e1 * t1103 - 0.4e1 * t1105 - t2854 + t2860 - t2861;
  t3602 = t1652 * t3534;
  t3604 = t3342 * t176;
  t3605 = t173 * t3604;
  t3614 = 0.2e1 * t89 * t3604 * t190 - 0.2e1 * t1068 * t2905 - t1566 * t1114 - 0.2e1 * t3605 * t190 - 0.2e1 * t3605 * t207 + 0.2e1 * t293 * t2484 + t2721 * t3602 - 0.4e1 * t1120 + t2862 + t2863 - t2864 - t2882 + t2888 - t2890 - t2893 + t2901 - t2904;
  t3618 = my_piecewise5(t52, 0, t55, 0, t3382 + t3422 + t3466 + t3509 + t3554 + t3563 + t3596 + t3614);
  t3625 = my_piecewise3(t3, 0, -t8 * t150 * t382 / 0.3e2 + t8 * t73 * t1129 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.2e3 / 0.243e3 * t942 - 0.5e2 / 0.81e2 * t945 + 0.5e1 / 0.27e2 * t30 * t129 * t792 + t167 * t380 + 0.2e1 * t87 * t1127 + t47 * t3618));
  tv4rho2lapl20 = 0.2e1 * rho[0] * t3625 + 0.4e1 * t1134;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t3639 = t2100 * t97 * t317;
  t3640 = t1851 * t3639;
  t3642 = params->csk_a * t317;
  t3643 = t3642 * t91;
  t3644 = t97 * t3643;
  t3645 = t2114 * t3644;
  t3647 = t1157 * t421;
  t3650 = t176 * params->csk_a * t91;
  t3651 = t97 * t3650;
  t3657 = t2682 * t421;
  t3658 = t432 * t3657;
  t3659 = t3658 * t1005;
  t3661 = t3658 * t996;
  t3664 = t988 * t183 * t3643;
  t3666 = t1140 * t176;
  t3667 = t3666 * t421;
  t3668 = t432 * t3667;
  t3669 = t183 * t871;
  t3672 = t2114 * t3639;
  t3674 = t1175 * t197;
  t3675 = t89 * t3674;
  t3676 = t3675 * t842;
  t3678 = t3401 * t852;
  t3682 = t988 * t437 * t3643;
  t3684 = 0.18e2 * t173 * t3647 * t3651 - 0.18e2 * t89 * t3647 * t3651 + 0.18e2 * t3668 * t3669 - 0.18e2 * t3668 * t3678 - t319 - t321 + 0.9e1 * t3640 - 0.9e1 * t3645 - 0.9e1 * t3659 - 0.3e1 * t3661 + 0.9e1 * t3664 - 0.3e1 * t3672 + 0.9e1 * t3676 + 0.9e1 * t3682;
  t3685 = t437 * t871;
  t3688 = params->csk_a * t93;
  t3689 = t3688 * t245;
  t3690 = t183 * t3689;
  t3693 = t2100 * t197;
  t3694 = t437 * t3693;
  t3698 = t173 * t3657 * t984;
  t3700 = params->csk_a * t197;
  t3702 = t97 * t3700 * t245;
  t3706 = t97 * t3693;
  t3709 = t173 * t3667;
  t3714 = t3688 * t2550;
  t3717 = t502 * t317;
  t3718 = t3717 * t91;
  t3719 = t183 * t3718;
  t3720 = t1851 * t3719;
  t3722 = t3658 * t1008;
  t3727 = t2081 * t183 * t3674;
  t3729 = t1140 * t1492;
  t3730 = t173 * t3729;
  t3731 = t1707 * t815;
  t3734 = -0.6e1 * t89 * t3667 * t3706 + 0.18e2 * t3668 * t3685 - 0.12e2 * t3668 * t3694 - 0.6e1 * t3668 * t3706 + 0.18e2 * t3709 * t3678 - 0.9e1 * t864 * t3690 + 0.9e1 * t870 * t3702 + 0.18e2 * t3709 * t3706 - 0.9e1 * t864 * t3714 - 0.11e2 * t3730 * t3731 + 0.9e1 * t3698 + 0.9e1 * t3720 - 0.6e1 * t3722 + 0.9e1 * t3727;
  t3736 = t89 * t3729;
  t3738 = t1743 * t1744 * t91;
  t3742 = t432 * t3729;
  t3745 = t1489 * t3729;
  t3748 = t1678 * t1875 * t91;
  t3752 = t1658 * t1659 * t91;
  t3755 = t1658 * t256;
  t3758 = t1658 * t832;
  t3767 = t1755 * t815;
  t3772 = t1140 * t1506;
  t3773 = t173 * t3772;
  t3776 = -0.3e1 * t3773 * t257 - 0.7e1 * t3730 * t3738 - 0.7e1 * t3730 * t3752 - 0.18e2 * t3730 * t3767 + t3736 * t3738 + 0.6e1 * t3742 * t3738 - t3745 * t3738 + 0.12e2 * t3742 * t3748 + 0.18e2 * t3742 * t3752 - 0.18e2 * t3742 * t3755 + 0.6e1 * t3742 * t3767 - 0.12e2 * t3745 * t3748 - 0.7e1 * t3745 * t3752 + 0.7e1 * t3745 * t3758;
  t3777 = t173 * t3666;
  t3781 = t2683 * t973;
  t3787 = t584 * t497 * t906 * t91;
  t3789 = t1678 * t856;
  t3792 = t1678 * t824;
  t3795 = t91 * t1492;
  t3796 = t1489 * t3795;
  t3797 = t1498 * t1140;
  t3803 = t1652 * t1653 * t91;
  t3807 = t497 * t518 * t245;
  t3812 = t436 * t1140;
  t3814 = t1678 * t3812 * t502;
  t3818 = t513 * t528 * t245;
  t3823 = t598 * t2550;
  t3826 = t837 * t829;
  t3828 = 0.11e2 * t3796 * t1652 * t3797 * t502 - 0.18e2 * t3777 * t497 * t852 - 0.11e2 * t3730 * t3758 + 0.11e2 * t3736 * t3731 - 0.12e2 * t3742 * t3789 - 0.6e1 * t3742 * t3792 - 0.6e1 * t3745 * t3803 + 0.18e2 * t3796 * t3814 + 0.9e1 * t813 * t3807 - 0.9e1 * t823 * t3807 - 0.6e1 * t823 * t3818 - 0.3e1 * t823 * t3823 - 0.6e1 * t3781 - 0.9e1 * t3787 - 0.3e1 * t3826;
  t3831 = t837 * t820;
  t3834 = t188 * t489 * t245;
  t3852 = t627 * t1150;
  t3856 = t902 * t513 * t622 * t317;
  t3872 = -0.6e1 * t432 * t233 * t513 * t3812 * t197 - 0.6e1 * t3796 * t1652 * t3797 * params->csk_a - 0.6e1 * t3796 * t1678 * t3812 * params->csk_a - 0.12e2 * t89 * t3666 * t501 * t1827 + 0.9e1 * t823 * t1964 + 0.9e1 * t850 * t2007 + 0.9e1 * t823 * t2031 - 0.3e1 * t3773 * t241 + 0.7e1 * t3730 * t3755 - 0.3e1 * t860 * t3823 + 0.9e1 * t840 * t3834 - 0.3e1 * t3831 + 0.3e1 * t3852 - 0.3e1 * t3856;
  t3873 = t1140 * t91;
  t3879 = t475 * t2550;
  t3886 = t173 * t3674;
  t3887 = t3886 * t960;
  t3889 = t3675 * t951;
  t3891 = t3886 * t951;
  t3893 = 0.3e1 * t89 * t3873 * t1913 + 0.6e1 * t3736 * t3767 + 0.9e1 * t813 * t3823 + 0.9e1 * t813 * t3879 - 0.9e1 * t860 * t3879 + t1152 - t1154 - t1156 - t1160 + t1164 - t1166 - 0.9e1 * t3887 + 0.9e1 * t3889 - 0.9e1 * t3891;
  t3901 = t1743 * t251;
  t3908 = t501 * t915;
  t3911 = 0.3e1 * t173 * t3873 * t1516 + t3796 * t1652 * t3797 + 0.3e1 * t89 * t3772 * t252 - 0.3e1 * t823 * t2137 + 0.6e1 * t3736 * t3901 - 0.6e1 * t860 * t3908 - t838 + t843 + t854 - t867 + t873 - t878 + t890 - t891;
  t3912 = t173 * t3795;
  t3923 = t889 * t919;
  t3927 = t89 * t317 * t245 * t199;
  t3929 = t591 * t907;
  t3931 = 0.6e1 * t1177;
  t3932 = 0.11e2 * t3912 * t1658 * t182 * t1140 + 0.6e1 * t432 * t3795 * t1678 * t3812 - 0.9e1 * t813 * t2159 + t1182 + t1187 + t1189 + t1192 + 0.3e1 * t3923 - 0.3e1 * t3927 + 0.3e1 * t3929 - t3931 + t892 + t908 - t911 - t918;
  t3936 = my_piecewise5(t52, 0, t55, 0, t3684 + t3734 + t3776 + t3828 + t3872 + t3893 + t3911 + t3932);
  t3943 = my_piecewise3(t3, 0, t8 * t73 * t1208 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (0.4e2 / 0.81e2 * t30 * t223 * t327 - 0.5e1 / 0.27e2 * t30 * t110 * t924 + t87 * t1206 + t47 * t3936));
  tv4rhosigma30 = 0.2e1 * rho[0] * t3943 + 0.2e1 * t1212;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t3960 = t1647 * t310;
  t3961 = t3960 * t91;
  t3962 = t183 * t3961;
  t3965 = t998 * t3639;
  t3967 = t1001 * t3639;
  t3968 = t502 * t310;
  t3969 = t3968 * t91;
  t3976 = t3960 * t815;
  t3978 = t998 * t3719;
  t3980 = t981 * t3639;
  t3981 = t3968 * t815;
  t3993 = t3658 * t991;
  t3995 = t2667 * t1494;
  t3996 = t1489 * t3995;
  t3999 = -0.11e2 * t3046 * t183 * t3969 - 0.6e1 * t3049 * t437 * t3969 - 0.6e1 * t3996 * t1016 + t3041 * t3976 + 0.6e1 * t3041 * t3981 - 0.7e1 * t3046 * t3962 - 0.7e1 * t3046 * t3976 - 0.18e2 * t3046 * t3981 + 0.6e1 * t3049 * t3976 + 0.6e1 * t3049 * t3981 - t3052 * t3976 - t319 + 0.3e1 * t3965 - t3967 + 0.3e1 * t3978 - t3980 + 0.3e1 * t3993 - t952 + t957 - t961;
  t4000 = t437 * t3961;
  t4006 = t981 * t3644;
  t4008 = t998 * t3644;
  t4020 = t2568 * t1013;
  t4022 = t3658 * t1016;
  t4032 = t286 * t310;
  t4034 = t173 * t4032 * t197;
  t4037 = t1001 * t3719;
  t4040 = t994 * t183 * t245;
  t4043 = t3795 * t1494;
  t4044 = t1489 * t4043;
  t4045 = t3035 * t310;
  t4050 = t1001 * t437 * t3718;
  t4059 = 0.12e2 * t3049 * t4000 - 0.12e2 * t432 * t3995 * t1016 - 0.3e1 * t4006 + 0.3e1 * t4008 + 0.18e2 * t3049 * t3962 - 0.7e1 * t3052 * t3962 + 0.7e1 * t3996 * t183 * t3035 * t91 - 0.12e2 * t3052 * t4000 + 0.3e1 * t4020 + 0.3e1 * t4022 - 0.6e1 * t2558 * t437 * t1012 - 0.6e1 * t3996 * t1499 * t990 + 0.6e1 * t988 * t3215 - 0.3e1 * t4034 * t453 - 0.3e1 * t4037 - 0.6e1 * t1001 * t4040 + 0.18e2 * t4044 * t437 * t4045 - 0.2e1 * t4050 - 0.4e1 * t1001 * t437 * t994 * t245 + 0.11e2 * t4044 * t1499 * t4045;
  t4068 = t765 * t97 * t909 * t197;
  t4074 = t501 * t1528 * t91;
  t4078 = t173 * t1237 * t1506;
  t4083 = t189 * t310;
  t4084 = t188 * t4083;
  t4088 = t97 * t1268 * t91;
  t4099 = t994 * t2550;
  t4111 = t982 * t2550;
  t4116 = t183 * t989 * t310;
  t4119 = -0.6e1 * t3052 * t1499 * t3961 + 0.6e1 * t998 * t4040 + 0.3e1 * t4068 - 0.18e2 * t2576 * t1013 - 0.12e2 * t89 * t1262 * t4074 - 0.3e1 * t4078 * t257 + 0.3e1 * t89 * t289 * t1506 * t4084 + 0.11e2 * t3041 * t4088 - 0.3e1 * t4078 * t241 - 0.11e2 * t3046 * t4088 + 0.6e1 * t3640 - 0.6e1 * t3645 - 0.3e1 * t4034 * t464 - 0.2e1 * t1001 * t4099 + 0.6e1 * t1011 * t183 * t2968 + 0.6e1 * t1021 * t3834 - 0.2e1 * t981 * t4099 + 0.6e1 * t998 * t4099 + 0.6e1 * t998 * t4111 - 0.18e2 * t432 * t4043 * t4116;
  t4143 = t717 * t501 * t1276 * t91;
  t4153 = t714 * t1150;
  t4156 = 0.6e1 * t2668 * t1678 * t735 * t91 + 0.3e1 * t2339 * t1230 - t2342 * t1230 - t2348 * t1230 - 0.3e1 * t2342 * t1249 + 0.6e1 * t3698 + 0.6e1 * t3720 - 0.4e1 * t3722 + 0.6e1 * t3727 - 0.2e1 * t4143 - t4153;
  t4160 = t714 * t1257;
  t4163 = t740 * t1150;
  t4167 = t513 * t2751 * t136;
  t4168 = t902 * t4167;
  t4179 = t497 * t278 * t317;
  t4180 = t1996 * t4179;
  t4189 = t310 * t91;
  t4213 = -t4160 + 0.3e1 * t823 * t2415 + t4163 + 0.3e1 * t2339 * t1222 - t4168 - 0.2e1 * t597 * t3256 + t3796 * t1652 * t2779 * t136 - 0.2e1 * t2342 * t1245 + 0.3e1 * t2339 * t1249 - 0.3e1 * t4180 + 0.3e1 * t1238 * t1507 * t815 + 0.6e1 * t2320 * t1743 * t1286 * t91 + 0.3e1 * t173 * t4189 * t3221 + 0.11e2 * t2676 * t1658 * t976 + 0.3e1 * t850 * t2391 - 0.6e1 * t584 * t497 * t278 * t245 + 0.3e1 * t89 * t4032 * t580 - 0.4e1 * t717 * t501 * t348 * t245 - 0.3e1 * t2348 * t1222 + 0.3e1 * t823 * t2436;
  t4220 = t1281 * t197;
  t4221 = t173 * t4220;
  t4222 = t4221 * t960;
  t4224 = t437 * t502;
  t4225 = t4189 * t197;
  t4229 = t2960 * t4225;
  t4233 = t598 * t176 * t815;
  t4250 = t89 * t4220;
  t4251 = t4250 * t951;
  t4253 = t4221 * t951;
  t4264 = t233 * t421;
  t4272 = 0.18e2 * t1263 * t475 * t176 * t815 + 0.18e2 * t432 * t4264 * t2995 * t1269 - 0.6e1 * t949 * t450 * t93 * t2550 - 0.6e1 * t432 * t1262 * t4233 - 0.6e1 * t2251 * t3291 * t4225 - 0.18e2 * t2251 * t954 * t4225 + 0.18e2 * t2558 * t2977 * t871 - 0.6e1 * t949 * t959 * t3689 - 0.18e2 * t2255 * t4229 + 0.3e1 * t4251 - 0.3e1 * t4253;
  t4282 = 0.6e1 * t765 * t954 * t912 * t245 + t1014 + t1022 + t1236 + t1240 + t1241 - t1242 - t1243 - t1252 - t1258 + t1261 - t1265 - t1267 + t1272 - 0.6e1 * t3887 + 0.6e1 * t3889 - 0.6e1 * t3891 - t838 + t890 - t891;
  t4288 = t89 * t286 * t317 * t199;
  t4293 = t740 * t1277;
  t4294 = t837 * t777;
  t4298 = t892 + t908 - t911 - t1030 - t1033 - 0.4e1 * t1177 + t1274 + t1275 + t1278 + t1279 - t1356;
  t4303 = my_piecewise5(t52, 0, t55, 0, -t823 * t2470 - 0.3e1 * t813 * t2493 - 0.2e1 * t2348 * t1287 + 0.18e2 * t2238 * t4229 + 0.18e2 * t1263 * t4233 + 0.3e1 * t2234 * t1270 - 0.6e1 * t981 * t4111 - t347 + t3999 + 0.2e1 * t3929 - 0.2e1 * t3927 + 0.2e1 * t3923 - 0.2e1 * t3856 + 0.2e1 * t3852 - 0.2e1 * t3831 - 0.2e1 * t3826 - 0.6e1 * t3787 - 0.4e1 * t3781 + 0.6e1 * t3682 + 0.6e1 * t3676 - 0.2e1 * t3672 - 0.2e1 * t3661 + 0.6e1 * t3664 - 0.6e1 * t3659 + t4298 + t4293 + t4294 - t4288 + t4282 + t4272 - 0.3e1 * t4222 + t4213 + t4156 + t4119 + t4059 - 0.12e2 * t2255 * t4224 * t4225 + 0.7e1 * t173 * t4043 * t4116 + 0.6e1 * t988 * t183 * t3214);
  t4310 = my_piecewise3(t3, 0, t8 * t73 * t1294 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.25e2 / 0.162e3 * t1138 + 0.5e1 / 0.54e2 * t30 * t129 * t924 + 0.8e2 / 0.243e3 * t30 * t223 * t356 - 0.1e2 / 0.81e2 * t30 * t110 * t1038 + t87 * t1292 + t47 * t4303));
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t4310 + 0.2e1 * t1298;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t4327 = t3424 * t1494;
  t4328 = t1489 * t4327;
  t4329 = t3042 * t91;
  t4330 = t437 * t4329;
  t4335 = t432 * t4327;
  t4336 = t183 * t4329;
  t4343 = t183 * t983;
  t4346 = t89 * t4327;
  t4347 = t97 * t4329;
  t4349 = t173 * t4327;
  t4356 = t367 * params->csk_a * t91;
  t4357 = t437 * t4356;
  t4378 = -0.4e1 * t1001 * t437 * t994 * t286 - 0.6e1 * t3034 * t1499 * t4356 - 0.12e2 * t432 * t3033 * t4357 + 0.7e1 * t4328 * t1005 + 0.18e2 * t4328 * t1008 - 0.6e1 * t3034 * t4357 - 0.12e2 * t4328 * t4330 - 0.7e1 * t4328 * t4336 - t4328 * t4347 + 0.12e2 * t4335 * t4330 + 0.18e2 * t4335 * t4336 - 0.18e2 * t4335 * t4343 + 0.6e1 * t4335 * t4347 - 0.7e1 * t4349 * t4336 + t4346 * t4347 + 0.11e2 * t4346 * t984 - 0.7e1 * t4349 * t4347 - 0.11e2 * t4349 * t984 - t319 - t374;
  t4380 = t173 * t3439 * t178;
  t4387 = t367 * t91;
  t4406 = t97 * t3208;
  t4409 = t994 * t3556;
  t4419 = t636 * t286;
  t4430 = t235 * t286;
  t4431 = t3401 * t4430;
  t4437 = -0.3e1 * t4380 * t4343 + 0.6e1 * t4335 * t996 - 0.3e1 * t4380 * t984 + 0.3e1 * t89 * t4387 * t1506 * t343 - 0.11e2 * t4349 * t1005 - 0.12e2 * t3362 * t97 * t238 * t91 + 0.6e1 * t4346 * t996 - 0.18e2 * t4349 * t996 - 0.6e1 * t4335 * t1008 + 0.3e1 * t1102 * t3702 - 0.6e1 * t981 * t4406 + 0.6e1 * t998 * t4409 - 0.2e1 * t1001 * t4409 + 0.6e1 * t1001 * t183 * t3208 - 0.2e1 * t981 * t4409 + 0.6e1 * t3406 * t97 * t4419 - 0.18e2 * t173 * t4264 * t183 * t1064 * t118 + 0.7e1 * t4349 * t4343 - 0.6e1 * t1001 * t4431 + 0.6e1 * t2220 * t183 * t2964;
  t4473 = 0.11e2 * t4044 * t1499 * t367 * t502 * t118 - 0.6e1 * t4328 * t1499 * t4329 + 0.6e1 * t1001 * t3209 + 0.6e1 * t998 * t4431 - 0.6e1 * t1839 * t437 * t4387 * t197 + 0.6e1 * t3965 - 0.2e1 * t3967 - 0.3e1 * t1098 * t3690 - 0.3e1 * t1098 * t3714 + 0.6e1 * t998 * t4406 + 0.6e1 * t3978 - 0.2e1 * t3980 + 0.6e1 * t3993 - 0.6e1 * t4006 + 0.6e1 * t4008 + 0.6e1 * t4020 + 0.6e1 * t4022 - 0.6e1 * t4037 - 0.4e1 * t4050 + 0.6e1 * t4068;
  t4505 = 0.11e2 * t3912 * t1658 * t3492 * t118 - 0.4e1 * t717 * t501 * t348 * t286 + 0.3e1 * t1061 * t3807 + 0.3e1 * t1061 * t3823 + 0.3e1 * t1065 * t3834 - t1068 * t3823 + 0.3e1 * t1073 * t1964 + 0.3e1 * t1073 * t2031 - t1073 * t3823 - 0.2e1 * t3722 + 0.3e1 * t3727;
  t4549 = -0.3e1 * t1073 * t3807 - 0.2e1 * t597 * t3513 + t3796 * t1652 * t2020 * t367 - 0.2e1 * t1073 * t3818 + 0.3e1 * t173 * t4387 * t1507 * t1306 + 0.3e1 * t3575 * t188 * t972 + 0.6e1 * t3425 * t1743 * t972 + 0.6e1 * t1863 * t1678 * t1113 * t91 + 0.3e1 * t1061 * t3879 - 0.3e1 * t1068 * t3879 + 0.3e1 * t1091 * t2007 - 0.6e1 * t710 * t497 * t4430 - 0.4e1 * t4143 - 0.2e1 * t4153 - 0.2e1 * t4160 + 0.2e1 * t4163 - 0.2e1 * t4168 - 0.6e1 * t4180 - 0.2e1 * t3781 - 0.3e1 * t3787;
  t4550 = t1321 * t3650;
  t4558 = t2960 * t955;
  t4561 = t3291 * t955;
  t4589 = 0.18e2 * t3358 * t437 * params->csk_a * t955 + 0.18e2 * t3358 * t1306 * t871 - 0.6e1 * t3555 * t1343 * t3556 - 0.6e1 * t3555 * t1831 * t4419 + 0.6e1 * t765 * t954 * t2964 - 0.12e2 * t3358 * t4224 * t955 - 0.6e1 * t3352 * t4561 + 0.18e2 * t3355 * t4558 + 0.18e2 * t3355 * t4561 - 0.18e2 * t3358 * t4558 - 0.6e1 * t3358 * t4561 - 0.18e2 * t3362 * t4550 + 0.18e2 * t3365 * t4550 - t3826 - t3831 + t3852 - t3856 - 0.6e1 * t4222 + 0.6e1 * t4251 - 0.6e1 * t4253;
  t4594 = -0.3e1 * t3887 + 0.3e1 * t3889 - 0.3e1 * t3891 + t1311 + t1338 + t1151 - t1153 - t1155 - t1340 - t1341 + t1342 + t1066 + t1092 - t838 - t1346 - t1349 + t1353 - t1099 + t1103 - t1105;
  t4605 = -t1884 * t1114 - t1121 + t1181 + t1188 - t1273 - 0.4e1 * t1283 + t1354 + t1355 + t892 + t908 - t911;
  t4610 = my_piecewise5(t52, 0, t55, 0, -0.3e1 * t1061 * t2159 - 0.2e1 * t1068 * t3908 + 0.3e1 * t3640 - 0.3e1 * t3645 - 0.3e1 * t3659 - t3661 + 0.3e1 * t3664 - t3672 + 0.3e1 * t3676 + 0.3e1 * t3682 + 0.3e1 * t3698 + 0.3e1 * t3720 + t3923 - t3927 + t3929 - 0.2e1 * t4288 + 0.2e1 * t4293 + 0.2e1 * t4294 + t4378 + t4437 + t4473 + t4505 + t4549 + t4589 + t4594 + t4605 + t890 - t891);
  t4617 = my_piecewise3(t3, 0, t8 * t73 * t1367 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.25e2 / 0.81e2 * t1218 + 0.5e1 / 0.27e2 * t30 * t129 * t1038 + 0.4e2 / 0.243e3 * t30 * t223 * t380 - 0.5e1 / 0.81e2 * t30 * t110 * t1127 + t87 * t1365 + t47 * t4610));
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t4617 + 0.2e1 * t1371;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t4628 = t1376 * t176;
  t4629 = t4628 * t421;
  t4630 = t89 * t4629;
  t4633 = t173 * t4629;
  t4636 = t432 * t4629;
  t4640 = t173 * t1385 * t421;
  t4662 = 0.9e1 * t1102 * t97 * t3700 * t286 - 0.9e1 * t1098 * t3688 * t3556 + 0.18e2 * t4640 * t3651 + 0.18e2 * t4636 * t3669 + 0.18e2 * t4633 * t3678 - 0.18e2 * t4636 * t3678 + 0.18e2 * t4636 * t3685 - 0.12e2 * t4636 * t3694 - 0.6e1 * t4630 * t3706 + 0.18e2 * t4633 * t3706 - 0.6e1 * t4636 * t3706 - 0.18e2 * t4630 * t872 - t319 - t374;
  t4679 = t1376 * t1492;
  t4680 = t1489 * t4679;
  t4683 = -0.9e1 * t1098 * t183 * t3688 * t286 + 0.7e1 * t4680 * t3758 + 0.9e1 * t3965 - 0.3e1 * t3967 + 0.9e1 * t3978 - 0.3e1 * t3980 + 0.9e1 * t3993 - 0.9e1 * t4006 + 0.9e1 * t4008 + 0.9e1 * t4020 + 0.9e1 * t4022 - 0.9e1 * t4037 - 0.6e1 * t4050 + 0.9e1 * t4068;
  t4685 = t173 * t4679;
  t4688 = t432 * t4679;
  t4694 = t89 * t4679;
  t4712 = t501 * t1056;
  t4715 = -0.9e1 * t1068 * t4712 - t4680 * t3738 - 0.7e1 * t4685 * t3738 + 0.6e1 * t4688 * t3738 + t4694 * t3738 - 0.12e2 * t4680 * t3748 + 0.12e2 * t4688 * t3748 - 0.7e1 * t4680 * t3752 - 0.7e1 * t4685 * t3752 + 0.18e2 * t4688 * t3752 - 0.18e2 * t4688 * t3755 - 0.18e2 * t4685 * t3767 + 0.6e1 * t4694 * t3767 - 0.6e1 * t4680 * t3789;
  t4716 = t182 * t1376;
  t4718 = t1658 * t4716 * params->csk_a;
  t4729 = t1376 * t1506;
  t4730 = t173 * t4729;
  t4737 = t1376 * t91;
  t4749 = t598 * t3556;
  t4756 = -0.6e1 * t1073 * t513 * t528 * t286 + 0.3e1 * t89 * t4737 * t1913 + 0.9e1 * t1061 * t4712 + 0.9e1 * t1061 * t4749 - 0.3e1 * t1073 * t4749 - 0.12e2 * t1416 * t4074 - 0.3e1 * t4730 * t241 - 0.3e1 * t4730 * t257 - 0.11e2 * t4685 * t3731 + 0.11e2 * t4694 * t3731 - 0.11e2 * t4685 * t3758 + 0.6e1 * t4688 * t3767 - 0.12e2 * t4688 * t3789 - 0.6e1 * t4688 * t3792 + 0.7e1 * t3912 * t4718;
  t4768 = t497 * t4716 * t197;
  t4773 = t1498 * t1376;
  t4775 = t1652 * t4773 * t502;
  t4781 = t598 * t183 * t286;
  t4786 = t1678 * t436 * t1376 * t502;
  t4793 = t432 * t4628;
  t4794 = t436 * t91;
  t4804 = 0.9e1 * t1065 * t188 * t489 * t286 - 0.6e1 * t4680 * t1652 * t1685 * t91 - 0.6e1 * t4793 * t513 * t4794 * t197 + 0.9e1 * t1061 * t4781 - 0.3e1 * t1068 * t4749 + 0.9e1 * t1073 * t2415 + 0.9e1 * t1073 * t2436 - 0.9e1 * t1073 * t4781 + 0.9e1 * t1091 * t2391 - 0.18e2 * t234 * t4768 + 0.11e2 * t3796 * t4775 + 0.18e2 * t3796 * t4786 - 0.6e1 * t4680 * t3803 - 0.6e1 * t4143;
  t4813 = -0.3e1 * t4153 - 0.3e1 * t4160 + 0.3e1 * t4163 - 0.3e1 * t4168 - 0.9e1 * t4180 - 0.9e1 * t4222 + 0.9e1 * t4251 - 0.9e1 * t4253 - t1388 - t1390 + t1394 - t1395 - t1396 + t1397;
  t4821 = t89 * t4729;
  t4826 = 0.3e1 * t173 * t4737 * t1516 + 0.3e1 * t4821 * t252 + 0.6e1 * t4694 * t3901 + t1066 + t1092 - t1099 + t1103 - t1105 - 0.3e1 * t4288 + 0.3e1 * t4293 + 0.3e1 * t4294 - t838 + t890 - t891;
  t4833 = t1658 * t4716;
  t4840 = t1652 * t4773;
  t4842 = 0.6e1 * t1283;
  t4843 = -0.6e1 * t1068 * t501 * t1118 + 0.6e1 * t4688 * t1678 * t4794 - 0.9e1 * t1061 * t2493 - 0.3e1 * t1073 * t2470 + t3796 * t4840 + 0.11e2 * t3912 * t4833 - t1121 + t1398 + t1399 + t1418 + t1421 - t4842 + t892 + t908 - t911;
  t4847 = my_piecewise5(t52, 0, t55, 0, t4662 + t4683 + t4715 + t4756 + t4804 + t4813 + t4826 + t4843);
  t4854 = my_piecewise3(t3, 0, t8 * t73 * t1434 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.25e2 / 0.54e2 * t1304 + 0.5e1 / 0.18e2 * t30 * t129 * t1127 + t87 * t1432 + t47 * t4847));
  tv4rholapl30 = 0.2e1 * rho[0] * t4854 + 0.2e1 * t1438;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t4860 = t317 * t317;
  t4861 = t89 * t4860;
  t4863 = 0.3e1 * t4861 * t201;
  t4865 = 0.3e1 * t4861 * t199;
  t4868 = 0.3e1 * t173 * t4860 * t184;
  t4869 = t310 * t310;
  t4870 = t89 * t4869;
  t4875 = t173 * t4869;
  t4886 = t317 * t310;
  t4887 = t4886 * t197;
  t4889 = t89 * t4887 * t453;
  t4891 = t173 * t4887;
  t4892 = t4891 * t453;
  t4894 = t4891 * t464;
  t4896 = t2686 * t1222;
  t4898 = t4869 * t197;
  t4905 = t823 * t2804;
  t4907 = t4869 * t176;
  t4908 = t432 * t4907;
  t4912 = t501 * t503 * t317;
  t4913 = t860 * t4912;
  t4915 = t813 * t4912;
  t4917 = 0.18e2 * t173 * t4898 * t1530 - 0.18e2 * t89 * t4898 * t1530 + 0.18e2 * t4908 * t1614 - t321 + 0.18e2 * t4889 - 0.18e2 * t4892 - 0.18e2 * t4894 + 0.18e2 * t4896 + 0.18e2 * t4905 - 0.6e1 * t4913 + 0.18e2 * t4915;
  t4920 = t89 * t4886 * t580;
  t4922 = t598 * t2066;
  t4927 = t823 * t4912;
  t4929 = t850 * t2846;
  t4932 = t598 * t183 * t317;
  t4933 = t823 * t4932;
  t4935 = t823 * t2753;
  t4938 = t513 * t528 * t317;
  t4939 = t823 * t4938;
  t4941 = t813 * t4932;
  t4943 = t501 * t1149;
  t4944 = t860 * t4943;
  t4947 = t89 * t4907;
  t4950 = t173 * t4907;
  t4956 = t513 * t528 * t197;
  t4967 = -0.6e1 * t4908 * t1561 - 0.6e1 * t4947 * t1561 + 0.18e2 * t4950 * t1561 - 0.12e2 * t4908 * t4956 + 0.18e2 * t4950 * t4922 + 0.4e1 * t1151 - 0.4e1 * t1153 - 0.4e1 * t1155 - 0.4e1 * t1159 + 0.4e1 * t1163 - 0.4e1 * t1165;
  t4972 = t4869 * t1492;
  t4973 = t1489 * t4972;
  t4978 = t823 * t2889;
  t4982 = t501 * t1276;
  t4983 = t860 * t4982;
  t4985 = t173 * t4972;
  t4992 = t4869 * t1506;
  t4997 = t89 * t4972;
  t5002 = t432 * t4972;
  t5005 = t173 * t4992;
  t5019 = -0.11e2 * t4985 * t1675 - 0.6e1 * t5002 * t1679 - 0.18e2 * t4950 * t1712 - 0.18e2 * t4985 * t1756 + 0.6e1 * t4997 * t1756 + 0.6e1 * t5002 * t1756 - 0.3e1 * t5005 * t190 - 0.3e1 * t5005 * t207 - 0.9e1 * t1177 + 0.4e1 * t1181 + 0.4e1 * t1186;
  t5023 = t813 * t2902;
  t5031 = t4860 * t176;
  t5032 = t173 * t5031;
  t5034 = 0.3e1 * t5032 * t190;
  t5036 = 0.3e1 * t5032 * t207;
  t5043 = 0.3e1 * t89 * t5031 * t190;
  t5065 = -0.12e2 * t4973 * t1649 + 0.12e2 * t5002 * t1649 - 0.7e1 * t4973 * t1660 - 0.7e1 * t4985 * t1660 + 0.18e2 * t5002 * t1660 + 0.7e1 * t4973 * t1675 - 0.18e2 * t5002 * t1725 - t4973 * t1745 - 0.7e1 * t4985 * t1745 + t4997 * t1745 + 0.6e1 * t5002 * t1745;
  t5069 = my_piecewise5(t52, 0, t55, 0, 0.6e1 * t432 * t4869 * t1512 + t1489 * t4869 * t1500 + 0.3e1 * t89 * t4992 * t190 - 0.12e2 * t5002 * t1761 + 0.11e2 * t4997 * t1708 - 0.11e2 * t4985 * t1708 - 0.6e1 * t4908 * t1732 - 0.6e1 * t4973 * t1761 + 0.18e2 * t4973 * t1679 - 0.6e1 * t4973 * t1686 + 0.7e1 * t4985 * t1725 + 0.11e2 * t4973 * t1669 - 0.6e1 * t4973 * t1654 - 0.18e2 * t4908 * t4922 + 0.18e2 * t4908 * t1603 + 0.3e1 * t4870 * t1508 + 0.6e1 * t4870 * t1503 + 0.3e1 * t4875 * t1516 + 0.11e2 * t4875 * t1519 - t319 - 0.12e2 * t4947 * t501 * t96 * t197 + t5065 + t5043 - t5034 - t5036 - 0.18e2 * t5023 + t5019 - 0.12e2 * t4983 - 0.6e1 * t4978 + t4967 - 0.18e2 * t4944 - 0.12e2 * t4939 + 0.18e2 * t4941 + 0.18e2 * t4935 + 0.18e2 * t4929 - 0.18e2 * t4933 - 0.6e1 * t4927 + 0.18e2 * t4920 + t4917 + t4868 - t4865 + t4863 + 0.4e1 * t1191 + 0.4e1 * t1188);
  t5075 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (-0.2e2 / 0.81e2 * t30 * t110 * t1206 + t47 * t5069));
  tv4sigma40 = 0.2e1 * rho[0] * t5075;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t5083 = t3658 * t3075;
  t5084 = 0.9e1 * t5083;
  t5085 = t3717 * t1321;
  t5086 = t998 * t5085;
  t5087 = 0.9e1 * t5086;
  t5088 = t1001 * t5085;
  t5089 = 0.3e1 * t5088;
  t5090 = t981 * t5085;
  t5091 = 0.3e1 * t5090;
  t5093 = t97 * t3642 * t118;
  t5094 = t981 * t5093;
  t5095 = 0.9e1 * t5094;
  t5096 = t998 * t5093;
  t5097 = 0.9e1 * t5096;
  t5098 = t136 * t1140;
  t5099 = t5098 * t197;
  t5100 = t173 * t5099;
  t5107 = t502 * t1140 * t197;
  t5111 = -0.6e1 * t432 * t5099 * t1571 - 0.6e1 * t2251 * t97 * t5107 + 0.18e2 * t5100 * t1571 - t319 + t4863 - t4865 + t4868 + t5084 + t5087 - t5089 - t5091 - t5095 + t5097;
  t5117 = t183 * t5107;
  t5124 = t3717 * t1306;
  t5125 = t1001 * t5124;
  t5126 = 0.9e1 * t5125;
  t5127 = t3658 * t3030;
  t5128 = 0.9e1 * t5127;
  t5131 = t1001 * t437 * t994 * t317;
  t5132 = 0.6e1 * t5131;
  t5133 = t998 * t5124;
  t5134 = 0.9e1 * t5133;
  t5136 = t765 * t97 * t3674;
  t5137 = 0.9e1 * t5136;
  t5139 = t2568 * t183 * t948;
  t5140 = 0.9e1 * t5139;
  t5149 = -0.18e2 * t2251 * t97 * params->csk_a * t1140 * t197 - 0.12e2 * t2255 * t437 * t5107 + 0.18e2 * t5100 * t1530 + 0.18e2 * t2238 * t5117 - 0.18e2 * t2255 * t5117 + 0.18e2 * t3668 * t2259 + 0.18e2 * t3668 * t2264 + 0.9e1 * t4889 - t5126 + t5128 - t5132 + t5134 + t5137 + t5140;
  t5156 = t1678 * t1875 * t1140;
  t5160 = t1658 * t1659 * t1140;
  t5165 = t1755 * t1140 * t62 * t96;
  t5173 = t1743 * t1744 * t1140;
  t5182 = -0.7e1 * t2298 * t5160 - 0.18e2 * t2298 * t5165 - 0.7e1 * t2298 * t5173 + 0.12e2 * t2311 * t5156 + 0.6e1 * t2311 * t5165 + 0.6e1 * t2311 * t5173 - 0.12e2 * t3742 * t2314 - 0.6e1 * t3745 * t2314 + 0.6e1 * t2320 * t5165 + t2320 * t5173 - t2329 * t5173 - 0.9e1 * t4892 - 0.9e1 * t4894;
  t5191 = t173 * t5098;
  t5194 = t89 * t5098;
  t5198 = t1743 * t189 * t1140;
  t5217 = -0.11e2 * t2298 * t1658 * t518 * t1140 - 0.3e1 * t5191 * t1913 + 0.3e1 * t5194 * t1913 - 0.12e2 * t5194 * t1924 - 0.3e1 * t5191 * t1927 - 0.11e2 * t2298 * t5198 + 0.7e1 * t3745 * t2302 - 0.6e1 * t2311 * t3814 + 0.18e2 * t2311 * t5160 + 0.11e2 * t2320 * t5198 - 0.12e2 * t2329 * t5156 - 0.7e1 * t2329 * t5160 + 0.7e1 * t3730 * t2351 - 0.18e2 * t3777 * t2446;
  t5222 = t597 * t4167;
  t5223 = 0.3e1 * t5222;
  t5237 = t717 * t501 * t1276 * t118;
  t5238 = 0.6e1 * t5237;
  t5239 = t584 * t4179;
  t5240 = 0.9e1 * t5239;
  t5247 = -0.6e1 * t2329 * t1652 * t1653 * t1140 - 0.6e1 * t432 * t3666 * t2395 - 0.18e2 * t3742 * t2351 + 0.18e2 * t3745 * t2363 + 0.11e2 * t3745 * t2408 - 0.6e1 * t3745 * t2419 + 0.9e1 * t4896 + 0.9e1 * t4905 - 0.3e1 * t4913 + 0.9e1 * t4915 - t5223 - t5238 - t5240;
  t5257 = t188 * t96 * t1343;
  t5258 = t4250 * t5257;
  t5259 = 0.9e1 * t5258;
  t5260 = t4221 * t5257;
  t5261 = 0.9e1 * t5260;
  t5263 = t4221 * t959 * t1343;
  t5264 = 0.9e1 * t5263;
  t5267 = 0.9e1 * t4920 - 0.3e1 * t4927 + 0.9e1 * t4929 - 0.9e1 * t4933 + 0.9e1 * t4935 - 0.6e1 * t4939 + 0.9e1 * t4941 - 0.9e1 * t4944 + t5259 - t5261 - t5264 + 0.4e1 * t1235 + 0.4e1 * t1239 + t1152;
  t5274 = -t1154 - t1156 - t1252 - t1258 + t1261 - 0.4e1 * t1264 - 0.4e1 * t1266 + 0.4e1 * t1271 - 0.3e1 * t4978 - 0.6e1 * t4983 - t347 - t3931 + t1182;
  t5289 = 0.6e1 * t2320 * t1743 * t96 * t1140 + 0.3e1 * t5194 * t1508 + 0.11e2 * t3730 * t2465 + t3745 * t2473 + 0.6e1 * t3742 * t2496 + 0.3e1 * t3773 * t279 + t1189 + t1278 + t1279 - t1401 - 0.9e1 * t5023 - t5034 - t5036 + t5043;
  t5293 = my_piecewise5(t52, 0, t55, 0, t5111 + t5149 + t5182 + t5217 + t5247 + t5267 + t5274 + t5289);
  t5299 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.54e2 * t30 * t129 * t1206 - 0.5e1 / 0.27e2 * t30 * t110 * t1292 + t47 * t5293));
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t5299;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t5310 = t3968 * t197;
  t5311 = t97 * t5310;
  t5324 = t183 * t5310;
  t5330 = t97 * t313 * params->csk_a;
  t5335 = 0.18e2 * t3358 * t183 * t1269 + 0.18e2 * t3358 * t437 * t1269 - 0.12e2 * t3358 * t437 * t5310 - 0.6e1 * t3352 * t5311 + 0.18e2 * t3355 * t5311 + 0.18e2 * t3355 * t5324 - 0.6e1 * t3358 * t5311 - 0.18e2 * t3358 * t5324 - 0.18e2 * t3362 * t5330 + 0.18e2 * t3365 * t5330 - t319 - t374 + t4863 - t4865 + t4868;
  t5342 = t1098 * t183 * t3642 * t93;
  t5345 = t1098 * t3642 * t452;
  t5349 = t1102 * t97 * t3642 * t197;
  t5360 = 0.12e2 * t5083 + 0.12e2 * t5086 - 0.4e1 * t5088 - 0.4e1 * t5090 - 0.3e1 * t5342 - 0.3e1 * t5345 + 0.3e1 * t5349 - 0.12e2 * t5094 + 0.12e2 * t5096 - 0.12e2 * t5125 + 0.12e2 * t5127 - 0.8e1 * t5131 + 0.12e2 * t5133 + 0.12e2 * t5136 + 0.12e2 * t5139 + 0.3e1 * t4889;
  t5366 = t1743 * t4083;
  t5372 = t1678 * t1875 * t310;
  t5375 = t1678 * t1244;
  t5379 = t1658 * t1659 * t310;
  t5388 = t367 * t310;
  t5392 = t206 * t310;
  t5396 = t1743 * t1229;
  t5403 = 0.3e1 * t89 * t5388 * t1913 - 0.3e1 * t3440 * t205 * t5392 - 0.12e2 * t2668 * t3486 - 0.6e1 * t2713 * t3486 + 0.7e1 * t3433 * t2730 + 0.11e2 * t3425 * t5366 + 0.6e1 * t3425 * t5396 - 0.11e2 * t3427 * t5366 - 0.18e2 * t3427 * t5396 + 0.18e2 * t3430 * t5379 + 0.6e1 * t3430 * t5396 - 0.12e2 * t3433 * t5372 + 0.18e2 * t3433 * t5375 - 0.7e1 * t3433 * t5379 - 0.3e1 * t4892 - 0.3e1 * t4894;
  t5417 = t1648 * t1221;
  t5422 = t1068 * t4943;
  t5424 = t1068 * t4912;
  t5425 = t1061 * t4912;
  t5427 = t1073 * t4912;
  t5428 = t1061 * t4943;
  t5430 = t1658 * t5392;
  t5433 = t1073 * t4932;
  t5435 = t1091 * t2846;
  t5437 = t1073 * t2804;
  t5439 = -0.12e2 * t1065 * t501 * t1286 * t176 - 0.6e1 * t432 * t313 * t3478 - 0.11e2 * t3427 * t2730 - 0.7e1 * t3427 * t5417 + 0.7e1 * t3427 * t5430 - 0.6e1 * t3430 * t5375 + 0.6e1 * t3430 * t5417 - 0.3e1 * t3440 * t4084 - 0.3e1 * t5422 - t5424 + 0.3e1 * t5425 - t5427 + 0.3e1 * t5428 - 0.3e1 * t5433 + 0.3e1 * t5435 + 0.3e1 * t5437;
  t5450 = t1073 * t2753;
  t5452 = t1061 * t4932;
  t5456 = t1065 * t188 * t1276 * t93;
  t5464 = t1073 * t4938;
  t5476 = -0.6e1 * t3433 * t1652 * t1653 * t310 + 0.11e2 * t2713 * t1652 * t3534 * t502 - 0.18e2 * t323 * t497 * t3492 * t197 - 0.6e1 * t2713 * t3536 + t3425 * t5417 - 0.7e1 * t3427 * t5379 + 0.12e2 * t3430 * t5372 - 0.18e2 * t3430 * t5430 - t3433 * t5417 - 0.4e1 * t5222 - 0.8e1 * t5237 + 0.3e1 * t5450 + 0.3e1 * t5452 + 0.3e1 * t5456 - 0.2e1 * t5464;
  t5491 = -0.12e2 * t5239 + 0.3e1 * t4896 + 0.3e1 * t4905 - t4913 + 0.3e1 * t4915 + 0.3e1 * t4920 - t4927 + 0.3e1 * t4929 - 0.3e1 * t4933 + 0.3e1 * t4935 - 0.2e1 * t4939 + 0.3e1 * t4941 - 0.3e1 * t4944 + 0.12e2 * t5258 - 0.12e2 * t5260 - 0.12e2 * t5263;
  t5499 = 0.4e1 * t1310 + 0.4e1 * t1337 + t1241 - t1242 - t1243 - t1340 - t1341 + t1342 - 0.4e1 * t1345 - 0.4e1 * t1348 + 0.4e1 * t1352 - t4978 - 0.2e1 * t4983 - t1178 + t1274 + t1275;
  t5501 = t2718 * t1114;
  t5503 = t1068 * t4982;
  t5508 = t1061 * t2902;
  t5521 = 0.6e1 * t3425 * t1743 * t1286 + 0.3e1 * t3575 * t188 * t1286 + 0.3e1 * t173 * t5388 * t1516 + 0.11e2 * t2676 * t1658 * t3492 + 0.6e1 * t2668 * t3593 + t2713 * t3602 + t1354 + t1355 - t4842 - 0.3e1 * t5023 - t5034 - t5036 + t5043 - t5501 - 0.2e1 * t5503 - 0.3e1 * t5508;
  t5525 = my_piecewise5(t52, 0, t55, 0, t5335 + t5360 + t5403 + t5439 + t5476 + t5491 + t5499 + t5521);
  t5531 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.27e2 * t30 * t129 * t1292 - 0.1e2 / 0.81e2 * t30 * t110 * t1365 + t47 * t5525));
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t5531;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t5544 = t994 * t197;
  t5550 = t97 * t5544;
  t5557 = t3401 * t573;
  t5562 = 0.18e2 * t4640 * t982 * t1570 - 0.12e2 * t4636 * t437 * t5544 - 0.18e2 * t4630 * t1351 + 0.18e2 * t4636 * t1848 + 0.18e2 * t4636 * t2074 - 0.6e1 * t4630 * t5550 + 0.18e2 * t4633 * t5550 - 0.6e1 * t4636 * t5550 - 0.18e2 * t4636 * t5557 - t319 - t374 + t4863 - t4865 + t4868;
  t5568 = 0.18e2 * t4633 * t5557 + t5084 + t5087 - t5089 - t5091 - t5095 + t5097 - t5126 + t5128 - t5132 + t5134 - 0.9e1 * t5342 - 0.9e1 * t5345 + 0.9e1 * t5349;
  t5571 = t1678 * t1875 * t118;
  t5574 = t1648 * t1306;
  t5582 = t1743 * t1744 * t118;
  t5591 = t1743 * t1314;
  t5596 = t1707 * t1321;
  t5599 = -0.18e2 * t4688 * t1871 - 0.6e1 * t4680 * t1934 - t4680 * t5582 - 0.7e1 * t4685 * t5574 - 0.7e1 * t4685 * t5582 - 0.18e2 * t4685 * t5591 - 0.11e2 * t4685 * t5596 + 0.12e2 * t4688 * t5571 + 0.18e2 * t4688 * t5574 + 0.6e1 * t4688 * t5582 + t4694 * t5582 + 0.6e1 * t4694 * t5591 + t5137 + t5140;
  t5626 = t1376 * t118;
  t5634 = -0.12e2 * t1416 * t501 * t1528 * t118 - 0.6e1 * t4680 * t1652 * t1653 * t118 + 0.3e1 * t89 * t5626 * t1913 + 0.11e2 * t1896 * t4775 - 0.12e2 * t4688 * t1934 + 0.7e1 * t4680 * t1982 - 0.11e2 * t4685 * t1982 - 0.6e1 * t4793 * t1993 - 0.6e1 * t4680 * t2035 - 0.6e1 * t4688 * t2044 - 0.3e1 * t4730 * t343 - 0.3e1 * t4730 * t353 + 0.6e1 * t4688 * t5591 + 0.11e2 * t4694 * t5596;
  t5656 = 0.7e1 * t1890 * t4718 + 0.18e2 * t1896 * t4786 - 0.18e2 * t254 * t4768 - 0.12e2 * t4680 * t5571 - 0.7e1 * t4680 * t5574 - 0.9e1 * t5422 - 0.3e1 * t5424 + 0.9e1 * t5425 - 0.3e1 * t5427 + 0.9e1 * t5428 - 0.9e1 * t5433 + 0.9e1 * t5435 + 0.9e1 * t5437 + 0.9e1 * t5450;
  t5660 = 0.9e1 * t5452 + 0.9e1 * t5456 - 0.6e1 * t5464 - t5223 - t5238 - t5240 + t5259 - t5261 - t5264 - t1388 - t1390 + t1310 + t1394 + t1337;
  t5662 = t1151 - t1153 - t1155 - t1395 - t1396 + t1397 - t1345 - t1348 + t1352 - t1177 + t1181 + t1188 + t1398 + t1399;
  t5680 = 0.3e1 * t173 * t5626 * t1516 + 0.6e1 * t4694 * t1743 * t348 + 0.11e2 * t1890 * t4833 + t1896 * t4840 + 0.6e1 * t4688 * t2162 + 0.3e1 * t4821 * t349 - 0.8e1 * t1283 + t1418 + t1421 - t5034 - t5036 + t5043 - 0.3e1 * t5501 - 0.6e1 * t5503 - 0.9e1 * t5508;
  t5684 = my_piecewise5(t52, 0, t55, 0, t5562 + t5568 + t5599 + t5634 + t5656 + t5660 + t5662 + t5680);
  t5690 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.18e2 * t30 * t129 * t1365 - 0.5e1 / 0.81e2 * t30 * t110 * t1432 + t47 * t5684));
  tv4sigmalapl30 = 0.2e1 * rho[0] * t5690;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t5695 = t367 * t367;
  t5698 = t173 * t5695;
  t5703 = t89 * t5695;
  t5715 = t5695 * t197;
  t5719 = t5695 * t176;
  t5720 = t89 * t5719;
  t5724 = t432 * t5719;
  t5733 = t173 * t5719;
  t5736 = 0.18e2 * t173 * t5715 * t1530 - 0.18e2 * t5720 * t501 * t469 - 0.6e1 * t5720 * t1561 + 0.18e2 * t5733 * t1561 + 0.18e2 * t5724 * t1603 + 0.18e2 * t5724 * t1614 - 0.18e2 * t5724 * t4922 - t374 - 0.18e2 * t5342 - 0.18e2 * t5345 + 0.18e2 * t5349;
  t5763 = 0.18e2 * t5437 + 0.18e2 * t5450 + 0.18e2 * t5452 + 0.18e2 * t5456 - 0.12e2 * t5464 - 0.4e1 * t1387 - 0.4e1 * t1389 + 0.4e1 * t1393 - 0.4e1 * t1252 - 0.4e1 * t1258 + 0.4e1 * t1261;
  t5777 = t5695 * t1492;
  t5778 = t1489 * t5777;
  t5781 = t173 * t5777;
  t5792 = t432 * t5777;
  t5799 = -0.6e1 * t5778 * t1654 + 0.11e2 * t5778 * t1669 - 0.11e2 * t5781 * t1675 + 0.18e2 * t5778 * t1679 - 0.6e1 * t5778 * t1686 - 0.11e2 * t5781 * t1708 - 0.18e2 * t5733 * t1712 + 0.7e1 * t5781 * t1725 - 0.6e1 * t5724 * t1732 - 0.12e2 * t5792 * t1761 - 0.18e2 * t5508;
  t5801 = t5695 * t1506;
  t5802 = t173 * t5801;
  t5815 = t89 * t5777;
  t5847 = 0.12e2 * t5792 * t1649 - 0.7e1 * t5781 * t1660 + 0.18e2 * t5792 * t1660 - 0.18e2 * t5792 * t1725 - t5778 * t1745 - 0.7e1 * t5781 * t1745 + 0.6e1 * t5792 * t1745 + t5815 * t1745 - 0.18e2 * t5781 * t1756 + 0.6e1 * t5815 * t1756 - 0.6e1 * t5778 * t1761;
  t5851 = my_piecewise5(t52, 0, t55, 0, 0.11e2 * t5815 * t1708 - 0.6e1 * t5792 * t1679 + 0.7e1 * t5778 * t1675 - 0.12e2 * t5778 * t1649 - 0.7e1 * t5778 * t1660 - 0.3e1 * t5802 * t190 + 0.6e1 * t5792 * t1756 - 0.3e1 * t5802 * t207 + 0.18e2 * t5733 * t4922 - 0.6e1 * t5724 * t1561 - 0.12e2 * t5724 * t4956 + 0.11e2 * t5698 * t1519 + 0.3e1 * t5698 * t1516 + 0.3e1 * t5703 * t1508 + 0.6e1 * t5703 * t1503 + t1489 * t5695 * t1500 + 0.6e1 * t432 * t5695 * t1512 - 0.12e2 * t89 * t5715 * t1720 + 0.3e1 * t89 * t5801 * t190 + t5847 - 0.9e1 * t1283 + 0.4e1 * t1279 + 0.4e1 * t1278 - t319 + 0.4e1 * t1420 + t5763 + t5736 + 0.4e1 * t1417 - 0.12e2 * t5503 - 0.6e1 * t5501 - 0.18e2 * t5433 + 0.18e2 * t5435 + 0.18e2 * t5428 - 0.6e1 * t5424 + 0.18e2 * t5425 - 0.6e1 * t5427 - 0.18e2 * t5422 + t5043 - t5034 - t5036 + t4868 - t4865 + t4863 + t5799);
  t5857 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.1e2 / 0.27e2 * t30 * t129 * t1432 + t47 * t5851));
  tv4lapl40 = 0.2e1 * rho[0] * t5857;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  double t122, t123, t124, t126, t129, t130, t134, t135;
  double t138, t141, t143, t149, t151, t152, t153, t155;
  double t156, t158, t159, t160, t162, t164, t169, t170;
  double t172, t175, t176, t180, t183, t185, tvrho0, t189;
  double t192, t193, t198, t200, t203, t204, t210, t212;
  double t218, t220, t221, t222, t224, t225, t227, t228;
  double t229, t231, t233, t238, tvrho1, t241, t244, t247;
  double t248, t251, t253, t257, tvsigma0, tvsigma1, t258, t261;
  double t264, t265, t268, t270, t274, tvsigma2, t280, t281;
  double t284, t286, t290, tvlapl0, t296, t297, t300, t302;
  double t306, tvlapl1, tvtau0, tvtau1;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t122 = t8 * t8;
  t123 = 0.1e1 / t122;
  t124 = t18 * t123;
  t126 = my_piecewise5(t12, 0, t16, 0, t9 - t124);
  t129 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t126);
  t130 = t129 * t31;
  t134 = 0.1e1 / t30;
  t135 = t29 * t134;
  t138 = t7 * t135 * t73 / 0.1e2;
  t141 = 0.1e1 / t41 / t39 / rho[0];
  t143 = t38 * sigma[0] * t141;
  t149 = -0.25e2 / 0.162e3 * t38 * lapl[0] * t43 + 0.4e2 / 0.243e3 * t143;
  t151 = t70 * t67;
  t152 = my_piecewise3(t61, 0, t149);
  t153 = my_piecewise3(t63, t152, 0);
  t155 = fabs(t64) / t64;
  t156 = 0.1e1 / t65;
  t158 = 0.1e1 / t69;
  t159 = t68 * t158;
  t160 = t155 * t156 * t159;
  t162 = my_piecewise5(t58, 0, t61, 0, -t151 * t153 * t160);
  t164 = -0.5e1 / 0.27e2 * t143 + t149 * t71 + t53 * t162;
  t169 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t73 + t138 + 0.3e1 / 0.2e2 * t7 * t32 * t164);
  t170 = t79 * t123;
  t172 = my_piecewise5(t16, 0, t12, 0, -t9 - t170);
  t175 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t172);
  t176 = t175 * t31;
  t180 = t87 * t134;
  t183 = t7 * t180 * t117 / 0.1e2;
  t185 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t117 + t183);
  tvrho0 = t77 + t121 + t8 * (t169 + t185);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t189 = my_piecewise5(t12, 0, t16, 0, -t9 - t124);
  t192 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t189);
  t193 = t192 * t31;
  t198 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t73 + t138);
  t200 = my_piecewise5(t16, 0, t12, 0, t9 - t170);
  t203 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t200);
  t204 = t203 * t31;
  t210 = 0.1e1 / t91 / t89 / rho[1];
  t212 = t38 * sigma[2] * t210;
  t218 = -0.25e2 / 0.162e3 * t38 * lapl[1] * t93 + 0.4e2 / 0.243e3 * t212;
  t220 = t114 * t111;
  t221 = my_piecewise3(t105, 0, t218);
  t222 = my_piecewise3(t107, t221, 0);
  t224 = fabs(t108) / t108;
  t225 = 0.1e1 / t109;
  t227 = 0.1e1 / t113;
  t228 = t112 * t227;
  t229 = t224 * t225 * t228;
  t231 = my_piecewise5(t104, 0, t105, 0, -t220 * t222 * t229);
  t233 = -0.5e1 / 0.27e2 * t212 + t218 * t115 + t103 * t231;
  t238 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t117 + t183 + 0.3e1 / 0.2e2 * t7 * t88 * t233);
  tvrho1 = t77 + t121 + t8 * (t198 + t238);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t241 = t38 * t43;
  t244 = t38 * t43 * t71;
  t247 = my_piecewise3(t61, 0, -0.5e1 / 0.81e2 * t241);
  t248 = my_piecewise3(t63, t247, 0);
  t251 = my_piecewise5(t58, 0, t61, 0, -t151 * t248 * t160);
  t253 = 0.5e1 / 0.72e2 * t241 - 0.5e1 / 0.81e2 * t244 + t53 * t251;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t253);
  tvsigma0 = t8 * t257;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t258 = t38 * t93;
  t261 = t38 * t93 * t115;
  t264 = my_piecewise3(t105, 0, -0.5e1 / 0.81e2 * t258);
  t265 = my_piecewise3(t107, t264, 0);
  t268 = my_piecewise5(t104, 0, t105, 0, -t220 * t265 * t229);
  t270 = 0.5e1 / 0.72e2 * t258 - 0.5e1 / 0.81e2 * t261 + t103 * t268;
  t274 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t270);
  tvsigma2 = t8 * t274;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t280 = my_piecewise3(t61, 0, 0.5e1 / 0.54e2 * t38 * t48);
  t281 = my_piecewise3(t63, t280, 0);
  t284 = my_piecewise5(t58, 0, t61, 0, -t151 * t281 * t160);
  t286 = 0.5e1 / 0.54e2 * t38 * t48 * t71 + t53 * t284;
  t290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t286);
  tvlapl0 = t8 * t290;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t296 = my_piecewise3(t105, 0, 0.5e1 / 0.54e2 * t38 * t98);
  t297 = my_piecewise3(t107, t296, 0);
  t300 = my_piecewise5(t104, 0, t105, 0, -t220 * t297 * t229);
  t302 = 0.5e1 / 0.54e2 * t38 * t98 * t115 + t103 * t300;
  t306 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t302);
  tvlapl1 = t8 * t306;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  double t122, t123, t124, t126, t129, t130, t134, t135;
  double t138, t141, t143, t149, t151, t152, t153, t155;
  double t156, t158, t159, t160, t162, t164, t169, t170;
  double t172, t175, t176, t180, t183, t185, tvrho0, t189;
  double t192, t193, t198, t200, t203, t204, t210, t212;
  double t218, t220, t221, t222, t224, t225, t227, t228;
  double t229, t231, t233, t238, tvrho1, t241, t244, t247;
  double t248, t251, t253, t257, tvsigma0, tvsigma1, t258, t261;
  double t264, t265, t268, t270, t274, tvsigma2, t280, t281;
  double t284, t286, t290, tvlapl0, t296, t297, t300, t302;
  double t306, tvlapl1, tvtau0, tvtau1;

  double t309, t310, t313, t314, t315, t318, t322, t323;
  double t327, t329, t335, t336, t339, t341, t343, t345;
  double t347, t353, t357, t359, t360, t362, t363, t364;
  double t365, t366, t367, t368, t369, t370, t372, t374;
  double t375, t376, t378, t379, t382, t383, t385, t386;
  double t387, t389, t391, t392, t393, t396, t398, t403;
  double t404, t405, t408, t411, t415, t416, t420, t422;
  double t424, t427, t429, tv2rho20, t432, t436, t440, t441;
  double t445, t447, t455, t456, t460, t464, t465, t469;
  double t471, t478, t481, tv2rho21, t486, t491, t495, t496;
  double t502, t503, t508, t512, t513, t522, t524, t526;
  double t532, t536, t538, t539, t541, t542, t543, t544;
  double t545, t546, t547, t548, t549, t551, t553, t554;
  double t555, t557, t558, t561, t562, t564, t565, t566;
  double t568, t570, t571, t572, t575, t577, t582, tv2rho22;
  double t590, t591, t594, t597, t600, t601, t602, t603;
  double t605, t606, t608, t611, t612, t615, t617, t618;
  double t619, t621, t623, t624, t627, t629, t634, tv2rhosigma0;
  double tv2rhosigma1, t641, t643, tv2rhosigma2, t649, tv2rhosigma3, tv2rhosigma4, t654;
  double t657, t660, t663, t664, t665, t666, t668, t669;
  double t671, t674, t675, t678, t680, t681, t682, t684;
  double t686, t687, t690, t692, t697, tv2rhosigma5, t704, t710;
  double t711, t713, t714, t717, t718, t721, t723, t725;
  double t729, t731, t736, tv2rholapl0, t743, t745, tv2rholapl1, t751;
  double tv2rholapl2, t761, t762, t764, t765, t768, t769, t772;
  double t774, t776, t780, t782, t787, tv2rholapl3, tv2rhotau0, tv2rhotau1;
  double tv2rhotau2, tv2rhotau3, t790, t792, t795, t798, t799, t801;
  double t802, t803, t805, t809, t811, t815, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t817, t819, t822, t823, t825;
  double t826, t828, t829, t830, t832, t836, t838, t842;
  double tv2sigma25, t847, t850, t851, t853, t854, t855, t856;
  double t857, t860, t861, t864, t866, t870, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t875, t878, t879, t881, t882;
  double t883, t884, t885, t888, t889, t892, t894, t898;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t902;
  double t905, t906, t908, t909, t911, t915, t917, t921;
  double tv2lapl20, tv2lapl21, t925, t928, t931, t932, t934, t938;
  double t940, t944, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t122 = t8 * t8;
  t123 = 0.1e1 / t122;
  t124 = t18 * t123;
  t126 = my_piecewise5(t12, 0, t16, 0, t9 - t124);
  t129 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t126);
  t130 = t129 * t31;
  t134 = 0.1e1 / t30;
  t135 = t29 * t134;
  t138 = t7 * t135 * t73 / 0.1e2;
  t141 = 0.1e1 / t41 / t39 / rho[0];
  t143 = t38 * sigma[0] * t141;
  t149 = -0.25e2 / 0.162e3 * t38 * lapl[0] * t43 + 0.4e2 / 0.243e3 * t143;
  t151 = t70 * t67;
  t152 = my_piecewise3(t61, 0, t149);
  t153 = my_piecewise3(t63, t152, 0);
  t155 = fabs(t64) / t64;
  t156 = 0.1e1 / t65;
  t158 = 0.1e1 / t69;
  t159 = t68 * t158;
  t160 = t155 * t156 * t159;
  t162 = my_piecewise5(t58, 0, t61, 0, -t151 * t153 * t160);
  t164 = -0.5e1 / 0.27e2 * t143 + t149 * t71 + t53 * t162;
  t169 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t73 + t138 + 0.3e1 / 0.2e2 * t7 * t32 * t164);
  t170 = t79 * t123;
  t172 = my_piecewise5(t16, 0, t12, 0, -t9 - t170);
  t175 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t172);
  t176 = t175 * t31;
  t180 = t87 * t134;
  t183 = t7 * t180 * t117 / 0.1e2;
  t185 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t117 + t183);
  tvrho0 = t77 + t121 + t8 * (t169 + t185);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t189 = my_piecewise5(t12, 0, t16, 0, -t9 - t124);
  t192 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t189);
  t193 = t192 * t31;
  t198 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t73 + t138);
  t200 = my_piecewise5(t16, 0, t12, 0, t9 - t170);
  t203 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t200);
  t204 = t203 * t31;
  t210 = 0.1e1 / t91 / t89 / rho[1];
  t212 = t38 * sigma[2] * t210;
  t218 = -0.25e2 / 0.162e3 * t38 * lapl[1] * t93 + 0.4e2 / 0.243e3 * t212;
  t220 = t114 * t111;
  t221 = my_piecewise3(t105, 0, t218);
  t222 = my_piecewise3(t107, t221, 0);
  t224 = fabs(t108) / t108;
  t225 = 0.1e1 / t109;
  t227 = 0.1e1 / t113;
  t228 = t112 * t227;
  t229 = t224 * t225 * t228;
  t231 = my_piecewise5(t104, 0, t105, 0, -t220 * t222 * t229);
  t233 = -0.5e1 / 0.27e2 * t212 + t218 * t115 + t103 * t231;
  t238 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t117 + t183 + 0.3e1 / 0.2e2 * t7 * t88 * t233);
  tvrho1 = t77 + t121 + t8 * (t198 + t238);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t241 = t38 * t43;
  t244 = t38 * t43 * t71;
  t247 = my_piecewise3(t61, 0, -0.5e1 / 0.81e2 * t241);
  t248 = my_piecewise3(t63, t247, 0);
  t251 = my_piecewise5(t58, 0, t61, 0, -t151 * t248 * t160);
  t253 = 0.5e1 / 0.72e2 * t241 - 0.5e1 / 0.81e2 * t244 + t53 * t251;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t253);
  tvsigma0 = t8 * t257;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t258 = t38 * t93;
  t261 = t38 * t93 * t115;
  t264 = my_piecewise3(t105, 0, -0.5e1 / 0.81e2 * t258);
  t265 = my_piecewise3(t107, t264, 0);
  t268 = my_piecewise5(t104, 0, t105, 0, -t220 * t265 * t229);
  t270 = 0.5e1 / 0.72e2 * t258 - 0.5e1 / 0.81e2 * t261 + t103 * t268;
  t274 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t270);
  tvsigma2 = t8 * t274;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t280 = my_piecewise3(t61, 0, 0.5e1 / 0.54e2 * t38 * t48);
  t281 = my_piecewise3(t63, t280, 0);
  t284 = my_piecewise5(t58, 0, t61, 0, -t151 * t281 * t160);
  t286 = 0.5e1 / 0.54e2 * t38 * t48 * t71 + t53 * t284;
  t290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t286);
  tvlapl0 = t8 * t290;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t296 = my_piecewise3(t105, 0, 0.5e1 / 0.54e2 * t38 * t98);
  t297 = my_piecewise3(t107, t296, 0);
  t300 = my_piecewise5(t104, 0, t105, 0, -t220 * t297 * t229);
  t302 = 0.5e1 / 0.54e2 * t38 * t98 * t115 + t103 * t300;
  t306 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t302);
  tvlapl1 = t8 * t306;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t309 = 0.1e1 / t26;
  t310 = t126 * t126;
  t313 = t122 * t8;
  t314 = 0.1e1 / t313;
  t315 = t18 * t314;
  t318 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t123 + 0.2e1 * t315);
  t322 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t310 + 0.5e1 / 0.3e1 * t27 * t318);
  t323 = t322 * t31;
  t327 = t129 * t134;
  t329 = t7 * t327 * t73;
  t335 = 0.1e1 / t30 / t8;
  t336 = t29 * t335;
  t339 = t7 * t336 * t73 / 0.3e2;
  t341 = t7 * t135 * t164;
  t343 = t39 * t39;
  t345 = 0.1e1 / t41 / t343;
  t347 = t38 * sigma[0] * t345;
  t353 = 0.1e3 / 0.243e3 * t38 * lapl[0] * t141 - 0.44e3 / 0.729e3 * t347;
  t357 = t66 * t66;
  t359 = t70 / t357;
  t360 = t153 * t153;
  t362 = t155 * t155;
  t363 = t65 * t65;
  t364 = 0.1e1 / t363;
  t365 = t362 * t364;
  t366 = t68 * t68;
  t367 = t69 * t69;
  t368 = 0.1e1 / t367;
  t369 = t366 * t368;
  t370 = t365 * t369;
  t372 = t360 * t362;
  t374 = t364 * t68;
  t375 = t158 * params->csk_a;
  t376 = t374 * t375;
  t378 = my_piecewise3(t61, 0, t353);
  t379 = my_piecewise3(t63, t378, 0);
  t382 = t151 * t360;
  t383 = 0.0;
  t385 = t383 * t156 * t159;
  t386 = t382 * t385;
  t387 = t365 * t159;
  t389 = t359 * t372;
  t391 = t364 * t366;
  t392 = t368 * params->csk_a;
  t393 = t391 * t392;
  t396 = my_piecewise5(t58, 0, t61, 0, -t151 * t379 * t160 + t151 * t372 * t376 + t359 * t360 * t370 - t389 * t376 + t382 * t387 - t389 * t393 - t386);
  t398 = 0.55e2 / 0.81e2 * t347 + t353 * t71 + 0.2e1 * t149 * t162 + t53 * t396;
  t403 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t73 + t329 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t164 - t339 + t341 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t398);
  t404 = 0.1e1 / t84;
  t405 = t172 * t172;
  t408 = t79 * t314;
  t411 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t123 + 0.2e1 * t408);
  t415 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t405 + 0.5e1 / 0.3e1 * t85 * t411);
  t416 = t415 * t31;
  t420 = t175 * t134;
  t422 = t7 * t420 * t117;
  t424 = t87 * t335;
  t427 = t7 * t424 * t117 / 0.3e2;
  t429 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t117 + t422 / 0.5e1 - t427);
  tv2rho20 = 0.2e1 * t169 + 0.2e1 * t185 + t8 * (t403 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t432 = t309 * t189;
  t436 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t315);
  t440 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t432 * t126 + 0.5e1 / 0.3e1 * t27 * t436);
  t441 = t440 * t31;
  t445 = t192 * t134;
  t447 = t7 * t445 * t73;
  t455 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t73 + t447 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t164 + t329 / 0.1e2 - t339 + t341 / 0.1e2);
  t456 = t404 * t200;
  t460 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t408);
  t464 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t456 * t172 + 0.5e1 / 0.3e1 * t85 * t460);
  t465 = t464 * t31;
  t469 = t203 * t134;
  t471 = t7 * t469 * t117;
  t478 = t7 * t180 * t233;
  t481 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t117 + t471 / 0.1e2 + t422 / 0.1e2 - t427 + 0.3e1 / 0.2e2 * t7 * t176 * t233 + t478 / 0.1e2);
  tv2rho21 = t169 + t185 + t198 + t238 + t8 * (t455 + t481);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t486 = t189 * t189;
  t491 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t123 + 0.2e1 * t315);
  t495 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t486 + 0.5e1 / 0.3e1 * t27 * t491);
  t496 = t495 * t31;
  t502 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t73 + t447 / 0.5e1 - t339);
  t503 = t200 * t200;
  t508 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t123 + 0.2e1 * t408);
  t512 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t503 + 0.5e1 / 0.3e1 * t85 * t508);
  t513 = t512 * t31;
  t522 = t89 * t89;
  t524 = 0.1e1 / t91 / t522;
  t526 = t38 * sigma[2] * t524;
  t532 = 0.1e3 / 0.243e3 * t38 * lapl[1] * t210 - 0.44e3 / 0.729e3 * t526;
  t536 = t110 * t110;
  t538 = t114 / t536;
  t539 = t222 * t222;
  t541 = t224 * t224;
  t542 = t109 * t109;
  t543 = 0.1e1 / t542;
  t544 = t541 * t543;
  t545 = t112 * t112;
  t546 = t113 * t113;
  t547 = 0.1e1 / t546;
  t548 = t545 * t547;
  t549 = t544 * t548;
  t551 = t539 * t541;
  t553 = t543 * t112;
  t554 = t227 * params->csk_a;
  t555 = t553 * t554;
  t557 = my_piecewise3(t105, 0, t532);
  t558 = my_piecewise3(t107, t557, 0);
  t561 = t220 * t539;
  t562 = 0.0;
  t564 = t562 * t225 * t228;
  t565 = t561 * t564;
  t566 = t544 * t228;
  t568 = t538 * t551;
  t570 = t543 * t545;
  t571 = t547 * params->csk_a;
  t572 = t570 * t571;
  t575 = my_piecewise5(t104, 0, t105, 0, -t220 * t558 * t229 + t220 * t551 * t555 + t538 * t539 * t549 - t568 * t555 + t561 * t566 - t568 * t572 - t565);
  t577 = 0.55e2 / 0.81e2 * t526 + t532 * t115 + 0.2e1 * t218 * t231 + t103 * t575;
  t582 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t117 + t471 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t233 - t427 + t478 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t577);
  tv2rho22 = 0.2e1 * t198 + 0.2e1 * t238 + t8 * (t502 + t582);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t590 = t7 * t135 * t253 / 0.1e2;
  t591 = t38 * t141;
  t594 = t38 * t141 * t71;
  t597 = t38 * t43 * t162;
  t600 = t153 * t362;
  t601 = t359 * t600;
  t602 = t368 * t248;
  t603 = t391 * t602;
  t605 = t248 * t362;
  t606 = t151 * t605;
  t608 = t374 * t375 * t153;
  t611 = my_piecewise3(t61, 0, 0.4e2 / 0.243e3 * t591);
  t612 = my_piecewise3(t63, t611, 0);
  t615 = t248 * t153;
  t617 = t151 * t615 * t385;
  t618 = t158 * t153;
  t619 = t374 * t618;
  t621 = t359 * t605;
  t623 = t392 * t153;
  t624 = t391 * t623;
  t627 = my_piecewise5(t58, 0, t61, 0, -t151 * t612 * t160 + t601 * t603 + t606 * t608 + t606 * t619 - t621 * t608 - t621 * t624 - t617);
  t629 = -0.5e1 / 0.27e2 * t591 + 0.4e2 / 0.243e3 * t594 - 0.5e1 / 0.81e2 * t597 + t149 * t251 + t53 * t627;
  t634 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t253 + t590 + 0.3e1 / 0.2e2 * t7 * t32 * t629);
  tv2rhosigma0 = t8 * t634 + t257;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t641 = t7 * t180 * t270 / 0.1e2;
  t643 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t270 + t641);
  tv2rhosigma2 = t8 * t643 + t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t649 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t253 + t590);
  tv2rhosigma3 = t8 * t649 + t257;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t654 = t38 * t210;
  t657 = t38 * t210 * t115;
  t660 = t38 * t93 * t231;
  t663 = t222 * t541;
  t664 = t538 * t663;
  t665 = t547 * t265;
  t666 = t570 * t665;
  t668 = t265 * t541;
  t669 = t220 * t668;
  t671 = t553 * t554 * t222;
  t674 = my_piecewise3(t105, 0, 0.4e2 / 0.243e3 * t654);
  t675 = my_piecewise3(t107, t674, 0);
  t678 = t265 * t222;
  t680 = t220 * t678 * t564;
  t681 = t227 * t222;
  t682 = t553 * t681;
  t684 = t538 * t668;
  t686 = t571 * t222;
  t687 = t570 * t686;
  t690 = my_piecewise5(t104, 0, t105, 0, -t220 * t675 * t229 + t664 * t666 + t669 * t671 + t669 * t682 - t684 * t671 - t684 * t687 - t680);
  t692 = -0.5e1 / 0.27e2 * t654 + 0.4e2 / 0.243e3 * t657 - 0.5e1 / 0.81e2 * t660 + t218 * t268 + t103 * t690;
  t697 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t270 + t641 + 0.3e1 / 0.2e2 * t7 * t88 * t692);
  tv2rhosigma5 = t8 * t697 + t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t704 = t7 * t135 * t286 / 0.1e2;
  t710 = t368 * t281;
  t711 = t391 * t710;
  t713 = t281 * t362;
  t714 = t151 * t713;
  t717 = my_piecewise3(t61, 0, -0.25e2 / 0.162e3 * t241);
  t718 = my_piecewise3(t63, t717, 0);
  t721 = t281 * t153;
  t723 = t151 * t721 * t385;
  t725 = t359 * t713;
  t729 = my_piecewise5(t58, 0, t61, 0, -t151 * t718 * t160 + t601 * t711 + t714 * t608 - t725 * t608 + t714 * t619 - t725 * t624 - t723);
  t731 = -0.25e2 / 0.162e3 * t244 + 0.5e1 / 0.54e2 * t38 * t48 * t162 + t149 * t284 + t53 * t729;
  t736 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t286 + t704 + 0.3e1 / 0.2e2 * t7 * t32 * t731);
  tv2rholapl0 = t8 * t736 + t290;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t743 = t7 * t180 * t302 / 0.1e2;
  t745 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t302 + t743);
  tv2rholapl1 = t8 * t745 + t306;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t751 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t286 + t704);
  tv2rholapl2 = t8 * t751 + t290;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t761 = t547 * t297;
  t762 = t570 * t761;
  t764 = t297 * t541;
  t765 = t220 * t764;
  t768 = my_piecewise3(t105, 0, -0.25e2 / 0.162e3 * t258);
  t769 = my_piecewise3(t107, t768, 0);
  t772 = t297 * t222;
  t774 = t220 * t772 * t564;
  t776 = t538 * t764;
  t780 = my_piecewise5(t104, 0, t105, 0, -t220 * t769 * t229 + t664 * t762 + t765 * t671 - t776 * t671 + t765 * t682 - t776 * t687 - t774);
  t782 = -0.25e2 / 0.162e3 * t261 + 0.5e1 / 0.54e2 * t38 * t98 * t231 + t218 * t300 + t103 * t780;
  t787 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t302 + t743 + 0.3e1 / 0.2e2 * t7 * t88 * t782);
  tv2rholapl3 = t8 * t787 + t306;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t790 = t38 * t43 * t251;
  t792 = t248 * t248;
  t795 = t792 * t362;
  t798 = my_piecewise3(t61, 0, 0);
  t799 = my_piecewise3(t63, t798, 0);
  t801 = t151 * t799 * t160;
  t802 = t151 * t792;
  t803 = t802 * t385;
  t805 = t359 * t795;
  t809 = my_piecewise5(t58, 0, t61, 0, t151 * t795 * t376 + t359 * t792 * t370 - t805 * t376 + t802 * t387 - t805 * t393 - t801 - t803);
  t811 = -0.1e2 / 0.81e2 * t790 + t53 * t809;
  t815 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t811);
  tv2sigma20 = t8 * t815;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t817 = t38 * t93 * t268;
  t819 = t265 * t265;
  t822 = t819 * t541;
  t823 = t220 * t822;
  t825 = my_piecewise3(t105, 0, 0);
  t826 = my_piecewise3(t107, t825, 0);
  t828 = t220 * t826 * t229;
  t829 = t220 * t819;
  t830 = t829 * t564;
  t832 = t538 * t822;
  t836 = my_piecewise5(t104, 0, t105, 0, t538 * t819 * t549 + t823 * t555 - t832 * t555 + t829 * t566 - t832 * t572 - t828 - t830);
  t838 = -0.1e2 / 0.81e2 * t817 + t103 * t836;
  t842 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t838);
  tv2sigma25 = t8 * t842;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t847 = t38 * t43 * t284;
  t850 = t375 * t248;
  t851 = t374 * t850;
  t853 = t281 * t248;
  t854 = t151 * t853;
  t855 = t854 * t385;
  t856 = t158 * t248;
  t857 = t374 * t856;
  t860 = t392 * t248;
  t861 = t391 * t860;
  t864 = my_piecewise5(t58, 0, t61, 0, t621 * t711 + t714 * t851 + t714 * t857 - t725 * t851 - t725 * t861 - t801 - t855);
  t866 = 0.5e1 / 0.54e2 * t38 * t48 * t251 - 0.5e1 / 0.81e2 * t847 + t53 * t864;
  t870 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t866);
  tv2sigmalapl0 = t8 * t870;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t875 = t38 * t93 * t300;
  t878 = t554 * t265;
  t879 = t553 * t878;
  t881 = t297 * t265;
  t882 = t220 * t881;
  t883 = t882 * t564;
  t884 = t227 * t265;
  t885 = t553 * t884;
  t888 = t571 * t265;
  t889 = t570 * t888;
  t892 = my_piecewise5(t104, 0, t105, 0, t684 * t762 + t765 * t879 + t765 * t885 - t776 * t879 - t776 * t889 - t828 - t883);
  t894 = 0.5e1 / 0.54e2 * t38 * t98 * t268 - 0.5e1 / 0.81e2 * t875 + t103 * t892;
  t898 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t894);
  tv2sigmalapl5 = t8 * t898;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t902 = t281 * t281;
  t905 = t902 * t362;
  t906 = t151 * t905;
  t908 = t151 * t902;
  t909 = t908 * t385;
  t911 = t359 * t905;
  t915 = my_piecewise5(t58, 0, t61, 0, t359 * t902 * t370 + t906 * t376 - t911 * t376 + t908 * t387 - t911 * t393 - t801 - t909);
  t917 = 0.5e1 / 0.27e2 * t38 * t48 * t284 + t53 * t915;
  t921 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t917);
  tv2lapl20 = t8 * t921;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t925 = t297 * t297;
  t928 = t925 * t541;
  t931 = t220 * t925;
  t932 = t931 * t564;
  t934 = t538 * t928;
  t938 = my_piecewise5(t104, 0, t105, 0, t220 * t928 * t555 + t538 * t925 * t549 - t934 * t555 + t931 * t566 - t934 * t572 - t828 - t932);
  t940 = 0.5e1 / 0.27e2 * t38 * t98 * t300 + t103 * t938;
  t944 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t940);
  tv2lapl22 = t8 * t944;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  double t122, t123, t124, t126, t129, t130, t134, t135;
  double t138, t141, t143, t149, t151, t152, t153, t155;
  double t156, t158, t159, t160, t162, t164, t169, t170;
  double t172, t175, t176, t180, t183, t185, tvrho0, t189;
  double t192, t193, t198, t200, t203, t204, t210, t212;
  double t218, t220, t221, t222, t224, t225, t227, t228;
  double t229, t231, t233, t238, tvrho1, t241, t244, t247;
  double t248, t251, t253, t257, tvsigma0, tvsigma1, t258, t261;
  double t264, t265, t268, t270, t274, tvsigma2, t280, t281;
  double t284, t286, t290, tvlapl0, t296, t297, t300, t302;
  double t306, tvlapl1, tvtau0, tvtau1;

  double t309, t310, t313, t314, t315, t318, t322, t323;
  double t327, t329, t335, t336, t339, t341, t343, t345;
  double t347, t353, t357, t359, t360, t362, t363, t364;
  double t365, t366, t367, t368, t369, t370, t372, t374;
  double t375, t376, t378, t379, t382, t383, t385, t386;
  double t387, t389, t391, t392, t393, t396, t398, t403;
  double t404, t405, t408, t411, t415, t416, t420, t422;
  double t424, t427, t429, tv2rho20, t432, t436, t440, t441;
  double t445, t447, t455, t456, t460, t464, t465, t469;
  double t471, t478, t481, tv2rho21, t486, t491, t495, t496;
  double t502, t503, t508, t512, t513, t522, t524, t526;
  double t532, t536, t538, t539, t541, t542, t543, t544;
  double t545, t546, t547, t548, t549, t551, t553, t554;
  double t555, t557, t558, t561, t562, t564, t565, t566;
  double t568, t570, t571, t572, t575, t577, t582, tv2rho22;
  double t590, t591, t594, t597, t600, t601, t602, t603;
  double t605, t606, t608, t611, t612, t615, t617, t618;
  double t619, t621, t623, t624, t627, t629, t634, tv2rhosigma0;
  double tv2rhosigma1, t641, t643, tv2rhosigma2, t649, tv2rhosigma3, tv2rhosigma4, t654;
  double t657, t660, t663, t664, t665, t666, t668, t669;
  double t671, t674, t675, t678, t680, t681, t682, t684;
  double t686, t687, t690, t692, t697, tv2rhosigma5, t704, t710;
  double t711, t713, t714, t717, t718, t721, t723, t725;
  double t729, t731, t736, tv2rholapl0, t743, t745, tv2rholapl1, t751;
  double tv2rholapl2, t761, t762, t764, t765, t768, t769, t772;
  double t774, t776, t780, t782, t787, tv2rholapl3, tv2rhotau0, tv2rhotau1;
  double tv2rhotau2, tv2rhotau3, t790, t792, t795, t798, t799, t801;
  double t802, t803, t805, t809, t811, t815, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t817, t819, t822, t823, t825;
  double t826, t828, t829, t830, t832, t836, t838, t842;
  double tv2sigma25, t847, t850, t851, t853, t854, t855, t856;
  double t857, t860, t861, t864, t866, t870, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t875, t878, t879, t881, t882;
  double t883, t884, t885, t888, t889, t892, t894, t898;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t902;
  double t905, t906, t908, t909, t911, t915, t917, t921;
  double tv2lapl20, tv2lapl21, t925, t928, t931, t932, t934, t938;
  double t940, t944, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  double t948, t949, t952, t955, t956, t957, t960, t964;
  double t965, t969, t971, t976, t978, t981, t987, t988;
  double t991, t993, t996, t1000, t1002, t1008, t1014, t1015;
  double t1016, t1017, t1019, t1020, t1021, t1024, t1028, t1030;
  double t1031, t1032, t1034, t1036, t1037, t1038, t1042, t1043;
  double t1044, t1045, t1048, t1049, t1050, t1052, t1058, t1060;
  double t1061, t1064, t1065, t1067, t1068, t1069, t1072, t1076;
  double t1077, t1080, t1085, t1088, t1090, t1091, t1094, t1095;
  double t1100, t1102, t1103, t1104, t1107, t1108, t1109, t1112;
  double t1113, t1114, t1116, t1117, t1121, t1125, t1128, t1130;
  double t1132, t1137, t1139, t1140, t1143, t1146, t1149, t1153;
  double t1154, t1158, t1160, t1162, t1164, t1166, t1169, t1171;
  double tv3rho30, t1174, t1175, t1176, t1179, t1184, t1185, t1187;
  double t1191, t1192, t1196, t1199, t1203, t1205, t1209, t1218;
  double t1219, t1220, t1223, t1228, t1230, t1234, t1235, t1239;
  double t1242, t1243, t1245, t1254, t1256, t1259, tv3rho31, t1262;
  double t1267, t1271, t1275, t1276, t1280, t1282, t1291, t1292;
  double t1297, t1301, t1305, t1306, t1310, t1312, t1319, t1327;
  double t1329, t1330, tv3rho32, t1335, t1342, t1346, t1347, t1354;
  double t1355, t1362, t1366, t1367, t1384, t1386, t1392, t1398;
  double t1399, t1401, t1402, t1403, t1405, t1409, t1411, t1412;
  double t1413, t1417, t1418, t1419, t1420, t1422, t1423, t1424;
  double t1427, t1428, t1429, t1430, t1432, t1436, t1437, t1440;
  double t1441, t1443, t1444, t1445, t1448, t1452, t1453, t1458;
  double t1460, t1462, t1463, t1464, t1470, t1471, t1474, t1477;
  double t1479, t1480, t1484, t1486, t1487, t1488, t1491, t1492;
  double t1493, t1496, t1497, t1498, t1500, t1501, t1505, t1509;
  double t1512, t1514, t1516, t1521, tv3rho33, t1529, t1536, t1538;
  double t1540, t1543, t1546, t1549, t1554, t1556, t1558, t1560;
  double t1561, t1562, t1565, t1566, t1569, t1570, t1571, t1574;
  double t1575, t1578, t1579, t1580, t1581, t1584, t1585, t1588;
  double t1589, t1595, t1596, t1597, t1598, t1601, t1603, t1604;
  double t1607, t1610, t1613, t1614, t1616, t1623, t1624, t1625;
  double t1626, t1628, t1631, t1632, t1634, t1635, t1643, t1644;
  double t1647, t1648, t1651, t1652, t1653, t1655, t1657, t1658;
  double t1659, t1661, t1662, t1663, t1665, t1667, t1669, t1674;
  double tv3rho2sigma0, tv3rho2sigma1, t1681, t1685, t1687, tv3rho2sigma2, t1693, t1701;
  double tv3rho2sigma3, tv3rho2sigma4, t1707, t1714, t1717, tv3rho2sigma5, t1725, tv3rho2sigma6;
  double tv3rho2sigma7, t1736, t1739, t1742, t1745, t1750, t1751, t1752;
  double t1755, t1756, t1759, t1761, t1763, t1765, t1766, t1767;
  double t1770, t1771, t1774, t1775, t1778, t1779, t1780, t1781;
  double t1787, t1788, t1789, t1790, t1793, t1797, t1798, t1803;
  double t1806, t1810, t1814, t1816, t1819, t1820, t1823, t1824;
  double t1825, t1826, t1831, t1832, t1834, t1835, t1838, t1839;
  double t1843, t1844, t1847, t1848, t1849, t1851, t1852, t1853;
  double t1855, t1856, t1857, t1859, t1861, t1863, t1865, t1870;
  double tv3rho2sigma8, t1877, t1884, t1886, t1896, t1898, t1900, t1902;
  double t1905, t1906, t1909, t1910, t1912, t1913, t1916, t1919;
  double t1920, t1923, t1926, t1931, t1933, t1934, t1938, t1941;
  double t1943, t1945, t1946, t1947, t1958, t1959, t1963, t1964;
  double t1967, t1968, t1969, t1971, t1976, t1977, t1982, t1984;
  double t1986, t1991, tv3rho2lapl0, t1998, t2002, t2004, tv3rho2lapl1, t2010;
  double t2018, tv3rho2lapl2, t2024, t2031, t2034, tv3rho2lapl3, t2042, tv3rho2lapl4;
  double t2061, t2062, t2067, t2068, t2071, t2072, t2074, t2076;
  double t2078, t2080, t2081, t2084, t2085, t2089, t2090, t2093;
  double t2094, t2095, t2096, t2099, t2100, t2101, t2103, t2105;
  double t2110, t2111, t2113, t2114, t2118, t2121, t2122, t2123;
  double t2126, t2128, t2129, t2147, t2149, t2151, t2156, tv3rho2lapl5;
  double tv3rho2tau0, tv3rho2tau1, tv3rho2tau2, tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2163, t2165;
  double t2168, t2171, t2172, t2173, t2174, t2177, t2178, t2179;
  double t2180, t2181, t2184, t2185, t2190, t2191, t2192, t2193;
  double t2195, t2196, t2197, t2198, t2200, t2201, t2202, t2203;
  double t2205, t2206, t2207, t2209, t2210, t2211, t2212, t2213;
  double t2215, t2217, t2218, t2219, t2220, t2222, t2223, t2225;
  double t2227, t2228, t2230, t2231, t2234, t2235, t2236, t2239;
  double t2240, t2245, t2246, t2247, t2249, t2250, t2255, t2256;
  double t2259, t2260, t2263, t2264, t2267, t2268, t2269, t2270;
  double t2272, t2273, t2280, t2281, t2283, t2285, t2290, tv3rhosigma20;
  double tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2297, t2299, tv3rhosigma25, t2305;
  double tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t2311, t2314, t2317;
  double t2318, t2319, t2322, t2323, t2324, t2327, t2328, t2329;
  double t2332, t2333, t2334, t2335, t2337, t2338, t2339, t2340;
  double t2342, t2343, t2344, t2345, t2346, t2348, t2349, t2350;
  double t2353, t2355, t2356, t2357, t2358, t2360, t2362, t2363;
  double t2364, t2365, t2367, t2368, t2369, t2371, t2372, t2375;
  double t2376, t2379, t2380, t2381, t2382, t2384, t2385, t2387;
  double t2388, t2391, t2392, t2397, t2398, t2400, t2401, t2410;
  double t2411, t2414, t2415, t2418, t2419, t2420, t2421, t2423;
  double t2424, t2427, t2429, t2431, t2436, tv3rhosigma211, t2443, t2449;
  double t2452, t2457, t2459, t2460, t2462, t2465, t2466, t2468;
  double t2469, t2471, t2472, t2473, t2474, t2476, t2477, t2478;
  double t2480, t2481, t2482, t2483, t2486, t2489, t2490, t2491;
  double t2492, t2493, t2496, t2497, t2498, t2502, t2503, t2505;
  double t2508, t2511, t2512, t2516, t2517, t2518, t2519, t2521;
  double t2527, t2528, t2532, t2537, t2538, t2541, t2543, t2545;
  double t2550, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2557, t2559;
  double tv3rhosigmalapl5, t2565, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2575;
  double t2578, t2583, t2585, t2586, t2588, t2591, t2592, t2594;
  double t2595, t2597, t2598, t2600, t2602, t2603, t2604, t2606;
  double t2607, t2608, t2609, t2612, t2615, t2616, t2617, t2618;
  double t2619, t2622, t2623, t2624, t2628, t2629, t2631, t2632;
  double t2635, t2638, t2640, t2641, t2643, t2648, t2649, t2652;
  double t2655, t2656, t2663, t2664, t2668, t2670, t2672, t2677;
  double tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6;
  double tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t2684, t2690, t2691;
  double t2692, t2694, t2695, t2701, t2702, t2704, t2705, t2708;
  double t2711, t2713, t2714, t2716, t2718, t2719, t2721, t2724;
  double t2729, t2730, t2731, t2735, t2748, t2754, t2755, t2759;
  double t2761, t2763, t2768, tv3rholapl20, tv3rholapl21, t2775, t2777, tv3rholapl22;
  double t2783, tv3rholapl23, tv3rholapl24, t2793, t2794, t2799, t2800, t2802;
  double t2803, t2804, t2806, t2807, t2811, t2814, t2816, t2817;
  double t2819, t2821, t2822, t2824, t2828, t2830, t2833, t2839;
  double t2840, t2845, t2850, t2851, t2862, t2864, t2866, t2871;
  double tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2874;
  double t2876, t2877, t2878, t2881, t2883, t2884, t2885, t2890;
  double t2891, t2894, t2897, t2898, t2899, t2900, t2901, t2902;
  double t2903, t2905, t2906, t2912, t2924, t2925, t2926, t2927;
  double t2928, t2929, t2930, t2931, t2932, t2934, t2935, t2936;
  double t2937, t2938, t2939, t2940, t2942, t2944, t2948, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t2950, t2952, t2953, t2954, t2957, t2962, t2963, t2966;
  double t2969, t2971, t2972, t2973, t2974, t2975, t2976, t2977;
  double t2979, t2980, t2981, t2982, t2988, t3000, t3001, t3002;
  double t3003, t3004, t3005, t3006, t3007, t3008, t3010, t3011;
  double t3012, t3013, t3014, t3015, t3016, t3018, t3020, t3024;
  double tv3sigma39, t3029, t3033, t3034, t3035, t3036, t3038, t3040;
  double t3041, t3042, t3045, t3046, t3047, t3048, t3049, t3050;
  double t3051, t3052, t3053, t3054, t3055, t3056, t3057, t3058;
  double t3059, t3061, t3062, t3066, t3069, t3070, t3071, t3074;
  double t3082, t3085, t3086, t3087, t3088, t3089, t3092, t3093;
  double t3094, t3095, t3096, t3097, t3098, t3099, t3100, t3102;
  double t3104, t3108, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5;
  double tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t3113, t3115, t3116;
  double t3121, t3122, t3123, t3124, t3128, t3129, t3130, t3131;
  double t3132, t3133, t3134, t3135, t3136, t3137, t3138, t3139;
  double t3140, t3141, t3142, t3143, t3145, t3146, t3151, t3154;
  double t3155, t3160, t3163, t3166, t3167, t3168, t3169, t3170;
  double t3175, t3178, t3179, t3180, t3181, t3182, t3183, t3184;
  double t3185, t3186, t3188, t3190, t3194, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1;
  double tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9;
  double tv3sigma2tau10, tv3sigma2tau11, t3199, t3207, t3208, t3209, t3210, t3211;
  double t3213, t3214, t3216, t3217, t3218, t3220, t3221, t3222;
  double t3226, t3230, t3233, t3237, t3238, t3243, t3244, t3247;
  double t3248, t3253, t3254, t3255, t3256, t3258, t3260, t3264;
  double tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27;
  double t3269, t3277, t3278, t3279, t3280, t3281, t3283, t3284;
  double t3285, t3287, t3288, t3290, t3291, t3292, t3297, t3302;
  double t3303, t3308, t3312, t3313, t3318, t3319, t3322, t3323;
  double t3324, t3325, t3326, t3327, t3329, t3331, t3335, tv3sigmalapl28;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23;
  double tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t3339, t3340, t3341;
  double t3348, t3351, t3352, t3353, t3354, t3355, t3357, t3358;
  double t3359, t3370, t3371, t3372, t3373, t3374, t3375, t3376;
  double t3377, t3378, t3380, t3381, t3382, t3383, t3384, t3393;
  double t3395, t3397, t3401, tv3lapl30, tv3lapl31, tv3lapl32, t3405, t3406;
  double t3407, t3408, t3409, t3410, t3411, t3412, t3413, t3415;
  double t3416, t3417, t3418, t3419, t3420, t3421, t3428, t3431;
  double t3432, t3435, t3445, t3446, t3447, t3448, t3449, t3450;
  double t3459, t3461, t3463, t3467, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t122 = t8 * t8;
  t123 = 0.1e1 / t122;
  t124 = t18 * t123;
  t126 = my_piecewise5(t12, 0, t16, 0, t9 - t124);
  t129 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t126);
  t130 = t129 * t31;
  t134 = 0.1e1 / t30;
  t135 = t29 * t134;
  t138 = t7 * t135 * t73 / 0.1e2;
  t141 = 0.1e1 / t41 / t39 / rho[0];
  t143 = t38 * sigma[0] * t141;
  t149 = -0.25e2 / 0.162e3 * t38 * lapl[0] * t43 + 0.4e2 / 0.243e3 * t143;
  t151 = t70 * t67;
  t152 = my_piecewise3(t61, 0, t149);
  t153 = my_piecewise3(t63, t152, 0);
  t155 = fabs(t64) / t64;
  t156 = 0.1e1 / t65;
  t158 = 0.1e1 / t69;
  t159 = t68 * t158;
  t160 = t155 * t156 * t159;
  t162 = my_piecewise5(t58, 0, t61, 0, -t151 * t153 * t160);
  t164 = -0.5e1 / 0.27e2 * t143 + t149 * t71 + t53 * t162;
  t169 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t73 + t138 + 0.3e1 / 0.2e2 * t7 * t32 * t164);
  t170 = t79 * t123;
  t172 = my_piecewise5(t16, 0, t12, 0, -t9 - t170);
  t175 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t172);
  t176 = t175 * t31;
  t180 = t87 * t134;
  t183 = t7 * t180 * t117 / 0.1e2;
  t185 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t117 + t183);
  tvrho0 = t77 + t121 + t8 * (t169 + t185);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t189 = my_piecewise5(t12, 0, t16, 0, -t9 - t124);
  t192 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t189);
  t193 = t192 * t31;
  t198 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t73 + t138);
  t200 = my_piecewise5(t16, 0, t12, 0, t9 - t170);
  t203 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t200);
  t204 = t203 * t31;
  t210 = 0.1e1 / t91 / t89 / rho[1];
  t212 = t38 * sigma[2] * t210;
  t218 = -0.25e2 / 0.162e3 * t38 * lapl[1] * t93 + 0.4e2 / 0.243e3 * t212;
  t220 = t114 * t111;
  t221 = my_piecewise3(t105, 0, t218);
  t222 = my_piecewise3(t107, t221, 0);
  t224 = fabs(t108) / t108;
  t225 = 0.1e1 / t109;
  t227 = 0.1e1 / t113;
  t228 = t112 * t227;
  t229 = t224 * t225 * t228;
  t231 = my_piecewise5(t104, 0, t105, 0, -t220 * t222 * t229);
  t233 = -0.5e1 / 0.27e2 * t212 + t218 * t115 + t103 * t231;
  t238 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t117 + t183 + 0.3e1 / 0.2e2 * t7 * t88 * t233);
  tvrho1 = t77 + t121 + t8 * (t198 + t238);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t241 = t38 * t43;
  t244 = t38 * t43 * t71;
  t247 = my_piecewise3(t61, 0, -0.5e1 / 0.81e2 * t241);
  t248 = my_piecewise3(t63, t247, 0);
  t251 = my_piecewise5(t58, 0, t61, 0, -t151 * t248 * t160);
  t253 = 0.5e1 / 0.72e2 * t241 - 0.5e1 / 0.81e2 * t244 + t53 * t251;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t253);
  tvsigma0 = t8 * t257;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t258 = t38 * t93;
  t261 = t38 * t93 * t115;
  t264 = my_piecewise3(t105, 0, -0.5e1 / 0.81e2 * t258);
  t265 = my_piecewise3(t107, t264, 0);
  t268 = my_piecewise5(t104, 0, t105, 0, -t220 * t265 * t229);
  t270 = 0.5e1 / 0.72e2 * t258 - 0.5e1 / 0.81e2 * t261 + t103 * t268;
  t274 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t270);
  tvsigma2 = t8 * t274;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t280 = my_piecewise3(t61, 0, 0.5e1 / 0.54e2 * t38 * t48);
  t281 = my_piecewise3(t63, t280, 0);
  t284 = my_piecewise5(t58, 0, t61, 0, -t151 * t281 * t160);
  t286 = 0.5e1 / 0.54e2 * t38 * t48 * t71 + t53 * t284;
  t290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t286);
  tvlapl0 = t8 * t290;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t296 = my_piecewise3(t105, 0, 0.5e1 / 0.54e2 * t38 * t98);
  t297 = my_piecewise3(t107, t296, 0);
  t300 = my_piecewise5(t104, 0, t105, 0, -t220 * t297 * t229);
  t302 = 0.5e1 / 0.54e2 * t38 * t98 * t115 + t103 * t300;
  t306 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t302);
  tvlapl1 = t8 * t306;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t309 = 0.1e1 / t26;
  t310 = t126 * t126;
  t313 = t122 * t8;
  t314 = 0.1e1 / t313;
  t315 = t18 * t314;
  t318 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t123 + 0.2e1 * t315);
  t322 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t310 + 0.5e1 / 0.3e1 * t27 * t318);
  t323 = t322 * t31;
  t327 = t129 * t134;
  t329 = t7 * t327 * t73;
  t335 = 0.1e1 / t30 / t8;
  t336 = t29 * t335;
  t339 = t7 * t336 * t73 / 0.3e2;
  t341 = t7 * t135 * t164;
  t343 = t39 * t39;
  t345 = 0.1e1 / t41 / t343;
  t347 = t38 * sigma[0] * t345;
  t353 = 0.1e3 / 0.243e3 * t38 * lapl[0] * t141 - 0.44e3 / 0.729e3 * t347;
  t357 = t66 * t66;
  t359 = t70 / t357;
  t360 = t153 * t153;
  t362 = t155 * t155;
  t363 = t65 * t65;
  t364 = 0.1e1 / t363;
  t365 = t362 * t364;
  t366 = t68 * t68;
  t367 = t69 * t69;
  t368 = 0.1e1 / t367;
  t369 = t366 * t368;
  t370 = t365 * t369;
  t372 = t360 * t362;
  t374 = t364 * t68;
  t375 = t158 * params->csk_a;
  t376 = t374 * t375;
  t378 = my_piecewise3(t61, 0, t353);
  t379 = my_piecewise3(t63, t378, 0);
  t382 = t151 * t360;
  t383 = 0.0;
  t385 = t383 * t156 * t159;
  t386 = t382 * t385;
  t387 = t365 * t159;
  t389 = t359 * t372;
  t391 = t364 * t366;
  t392 = t368 * params->csk_a;
  t393 = t391 * t392;
  t396 = my_piecewise5(t58, 0, t61, 0, -t151 * t379 * t160 + t151 * t372 * t376 + t359 * t360 * t370 - t389 * t376 + t382 * t387 - t389 * t393 - t386);
  t398 = 0.55e2 / 0.81e2 * t347 + t353 * t71 + 0.2e1 * t149 * t162 + t53 * t396;
  t403 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t73 + t329 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t164 - t339 + t341 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t398);
  t404 = 0.1e1 / t84;
  t405 = t172 * t172;
  t408 = t79 * t314;
  t411 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t123 + 0.2e1 * t408);
  t415 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t405 + 0.5e1 / 0.3e1 * t85 * t411);
  t416 = t415 * t31;
  t420 = t175 * t134;
  t422 = t7 * t420 * t117;
  t424 = t87 * t335;
  t427 = t7 * t424 * t117 / 0.3e2;
  t429 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t117 + t422 / 0.5e1 - t427);
  tv2rho20 = 0.2e1 * t169 + 0.2e1 * t185 + t8 * (t403 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t432 = t309 * t189;
  t436 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t315);
  t440 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t432 * t126 + 0.5e1 / 0.3e1 * t27 * t436);
  t441 = t440 * t31;
  t445 = t192 * t134;
  t447 = t7 * t445 * t73;
  t455 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t73 + t447 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t164 + t329 / 0.1e2 - t339 + t341 / 0.1e2);
  t456 = t404 * t200;
  t460 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t408);
  t464 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t456 * t172 + 0.5e1 / 0.3e1 * t85 * t460);
  t465 = t464 * t31;
  t469 = t203 * t134;
  t471 = t7 * t469 * t117;
  t478 = t7 * t180 * t233;
  t481 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t117 + t471 / 0.1e2 + t422 / 0.1e2 - t427 + 0.3e1 / 0.2e2 * t7 * t176 * t233 + t478 / 0.1e2);
  tv2rho21 = t169 + t185 + t198 + t238 + t8 * (t455 + t481);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t486 = t189 * t189;
  t491 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t123 + 0.2e1 * t315);
  t495 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t486 + 0.5e1 / 0.3e1 * t27 * t491);
  t496 = t495 * t31;
  t502 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t73 + t447 / 0.5e1 - t339);
  t503 = t200 * t200;
  t508 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t123 + 0.2e1 * t408);
  t512 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t503 + 0.5e1 / 0.3e1 * t85 * t508);
  t513 = t512 * t31;
  t522 = t89 * t89;
  t524 = 0.1e1 / t91 / t522;
  t526 = t38 * sigma[2] * t524;
  t532 = 0.1e3 / 0.243e3 * t38 * lapl[1] * t210 - 0.44e3 / 0.729e3 * t526;
  t536 = t110 * t110;
  t538 = t114 / t536;
  t539 = t222 * t222;
  t541 = t224 * t224;
  t542 = t109 * t109;
  t543 = 0.1e1 / t542;
  t544 = t541 * t543;
  t545 = t112 * t112;
  t546 = t113 * t113;
  t547 = 0.1e1 / t546;
  t548 = t545 * t547;
  t549 = t544 * t548;
  t551 = t539 * t541;
  t553 = t543 * t112;
  t554 = t227 * params->csk_a;
  t555 = t553 * t554;
  t557 = my_piecewise3(t105, 0, t532);
  t558 = my_piecewise3(t107, t557, 0);
  t561 = t220 * t539;
  t562 = 0.0;
  t564 = t562 * t225 * t228;
  t565 = t561 * t564;
  t566 = t544 * t228;
  t568 = t538 * t551;
  t570 = t543 * t545;
  t571 = t547 * params->csk_a;
  t572 = t570 * t571;
  t575 = my_piecewise5(t104, 0, t105, 0, -t220 * t558 * t229 + t220 * t551 * t555 + t538 * t539 * t549 - t568 * t555 + t561 * t566 - t568 * t572 - t565);
  t577 = 0.55e2 / 0.81e2 * t526 + t532 * t115 + 0.2e1 * t218 * t231 + t103 * t575;
  t582 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t117 + t471 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t233 - t427 + t478 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t577);
  tv2rho22 = 0.2e1 * t198 + 0.2e1 * t238 + t8 * (t502 + t582);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t590 = t7 * t135 * t253 / 0.1e2;
  t591 = t38 * t141;
  t594 = t38 * t141 * t71;
  t597 = t38 * t43 * t162;
  t600 = t153 * t362;
  t601 = t359 * t600;
  t602 = t368 * t248;
  t603 = t391 * t602;
  t605 = t248 * t362;
  t606 = t151 * t605;
  t608 = t374 * t375 * t153;
  t611 = my_piecewise3(t61, 0, 0.4e2 / 0.243e3 * t591);
  t612 = my_piecewise3(t63, t611, 0);
  t615 = t248 * t153;
  t617 = t151 * t615 * t385;
  t618 = t158 * t153;
  t619 = t374 * t618;
  t621 = t359 * t605;
  t623 = t392 * t153;
  t624 = t391 * t623;
  t627 = my_piecewise5(t58, 0, t61, 0, -t151 * t612 * t160 + t601 * t603 + t606 * t608 + t606 * t619 - t621 * t608 - t621 * t624 - t617);
  t629 = -0.5e1 / 0.27e2 * t591 + 0.4e2 / 0.243e3 * t594 - 0.5e1 / 0.81e2 * t597 + t149 * t251 + t53 * t627;
  t634 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t253 + t590 + 0.3e1 / 0.2e2 * t7 * t32 * t629);
  tv2rhosigma0 = t8 * t634 + t257;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t641 = t7 * t180 * t270 / 0.1e2;
  t643 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t270 + t641);
  tv2rhosigma2 = t8 * t643 + t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t649 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t253 + t590);
  tv2rhosigma3 = t8 * t649 + t257;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t654 = t38 * t210;
  t657 = t38 * t210 * t115;
  t660 = t38 * t93 * t231;
  t663 = t222 * t541;
  t664 = t538 * t663;
  t665 = t547 * t265;
  t666 = t570 * t665;
  t668 = t265 * t541;
  t669 = t220 * t668;
  t671 = t553 * t554 * t222;
  t674 = my_piecewise3(t105, 0, 0.4e2 / 0.243e3 * t654);
  t675 = my_piecewise3(t107, t674, 0);
  t678 = t265 * t222;
  t680 = t220 * t678 * t564;
  t681 = t227 * t222;
  t682 = t553 * t681;
  t684 = t538 * t668;
  t686 = t571 * t222;
  t687 = t570 * t686;
  t690 = my_piecewise5(t104, 0, t105, 0, -t220 * t675 * t229 + t664 * t666 + t669 * t671 + t669 * t682 - t684 * t671 - t684 * t687 - t680);
  t692 = -0.5e1 / 0.27e2 * t654 + 0.4e2 / 0.243e3 * t657 - 0.5e1 / 0.81e2 * t660 + t218 * t268 + t103 * t690;
  t697 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t270 + t641 + 0.3e1 / 0.2e2 * t7 * t88 * t692);
  tv2rhosigma5 = t8 * t697 + t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t704 = t7 * t135 * t286 / 0.1e2;
  t710 = t368 * t281;
  t711 = t391 * t710;
  t713 = t281 * t362;
  t714 = t151 * t713;
  t717 = my_piecewise3(t61, 0, -0.25e2 / 0.162e3 * t241);
  t718 = my_piecewise3(t63, t717, 0);
  t721 = t281 * t153;
  t723 = t151 * t721 * t385;
  t725 = t359 * t713;
  t729 = my_piecewise5(t58, 0, t61, 0, -t151 * t718 * t160 + t601 * t711 + t714 * t608 - t725 * t608 + t714 * t619 - t725 * t624 - t723);
  t731 = -0.25e2 / 0.162e3 * t244 + 0.5e1 / 0.54e2 * t38 * t48 * t162 + t149 * t284 + t53 * t729;
  t736 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t286 + t704 + 0.3e1 / 0.2e2 * t7 * t32 * t731);
  tv2rholapl0 = t8 * t736 + t290;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t743 = t7 * t180 * t302 / 0.1e2;
  t745 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t302 + t743);
  tv2rholapl1 = t8 * t745 + t306;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t751 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t286 + t704);
  tv2rholapl2 = t8 * t751 + t290;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t761 = t547 * t297;
  t762 = t570 * t761;
  t764 = t297 * t541;
  t765 = t220 * t764;
  t768 = my_piecewise3(t105, 0, -0.25e2 / 0.162e3 * t258);
  t769 = my_piecewise3(t107, t768, 0);
  t772 = t297 * t222;
  t774 = t220 * t772 * t564;
  t776 = t538 * t764;
  t780 = my_piecewise5(t104, 0, t105, 0, -t220 * t769 * t229 + t664 * t762 + t765 * t671 - t776 * t671 + t765 * t682 - t776 * t687 - t774);
  t782 = -0.25e2 / 0.162e3 * t261 + 0.5e1 / 0.54e2 * t38 * t98 * t231 + t218 * t300 + t103 * t780;
  t787 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t302 + t743 + 0.3e1 / 0.2e2 * t7 * t88 * t782);
  tv2rholapl3 = t8 * t787 + t306;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t790 = t38 * t43 * t251;
  t792 = t248 * t248;
  t795 = t792 * t362;
  t798 = my_piecewise3(t61, 0, 0);
  t799 = my_piecewise3(t63, t798, 0);
  t801 = t151 * t799 * t160;
  t802 = t151 * t792;
  t803 = t802 * t385;
  t805 = t359 * t795;
  t809 = my_piecewise5(t58, 0, t61, 0, t151 * t795 * t376 + t359 * t792 * t370 - t805 * t376 + t802 * t387 - t805 * t393 - t801 - t803);
  t811 = -0.1e2 / 0.81e2 * t790 + t53 * t809;
  t815 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t811);
  tv2sigma20 = t8 * t815;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t817 = t38 * t93 * t268;
  t819 = t265 * t265;
  t822 = t819 * t541;
  t823 = t220 * t822;
  t825 = my_piecewise3(t105, 0, 0);
  t826 = my_piecewise3(t107, t825, 0);
  t828 = t220 * t826 * t229;
  t829 = t220 * t819;
  t830 = t829 * t564;
  t832 = t538 * t822;
  t836 = my_piecewise5(t104, 0, t105, 0, t538 * t819 * t549 + t823 * t555 - t832 * t555 + t829 * t566 - t832 * t572 - t828 - t830);
  t838 = -0.1e2 / 0.81e2 * t817 + t103 * t836;
  t842 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t838);
  tv2sigma25 = t8 * t842;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t847 = t38 * t43 * t284;
  t850 = t375 * t248;
  t851 = t374 * t850;
  t853 = t281 * t248;
  t854 = t151 * t853;
  t855 = t854 * t385;
  t856 = t158 * t248;
  t857 = t374 * t856;
  t860 = t392 * t248;
  t861 = t391 * t860;
  t864 = my_piecewise5(t58, 0, t61, 0, t621 * t711 + t714 * t851 + t714 * t857 - t725 * t851 - t725 * t861 - t801 - t855);
  t866 = 0.5e1 / 0.54e2 * t38 * t48 * t251 - 0.5e1 / 0.81e2 * t847 + t53 * t864;
  t870 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t866);
  tv2sigmalapl0 = t8 * t870;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t875 = t38 * t93 * t300;
  t878 = t554 * t265;
  t879 = t553 * t878;
  t881 = t297 * t265;
  t882 = t220 * t881;
  t883 = t882 * t564;
  t884 = t227 * t265;
  t885 = t553 * t884;
  t888 = t571 * t265;
  t889 = t570 * t888;
  t892 = my_piecewise5(t104, 0, t105, 0, t684 * t762 + t765 * t879 + t765 * t885 - t776 * t879 - t776 * t889 - t828 - t883);
  t894 = 0.5e1 / 0.54e2 * t38 * t98 * t268 - 0.5e1 / 0.81e2 * t875 + t103 * t892;
  t898 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t894);
  tv2sigmalapl5 = t8 * t898;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t902 = t281 * t281;
  t905 = t902 * t362;
  t906 = t151 * t905;
  t908 = t151 * t902;
  t909 = t908 * t385;
  t911 = t359 * t905;
  t915 = my_piecewise5(t58, 0, t61, 0, t359 * t902 * t370 + t906 * t376 - t911 * t376 + t908 * t387 - t911 * t393 - t801 - t909);
  t917 = 0.5e1 / 0.27e2 * t38 * t48 * t284 + t53 * t915;
  t921 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t917);
  tv2lapl20 = t8 * t921;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t925 = t297 * t297;
  t928 = t925 * t541;
  t931 = t220 * t925;
  t932 = t931 * t564;
  t934 = t538 * t928;
  t938 = my_piecewise5(t104, 0, t105, 0, t220 * t928 * t555 + t538 * t925 * t549 - t934 * t555 + t931 * t566 - t934 * t572 - t828 - t932);
  t940 = 0.5e1 / 0.27e2 * t38 * t98 * t300 + t103 * t938;
  t944 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t940);
  tv2lapl22 = t8 * t944;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t948 = 0.1e1 / t26 / t21;
  t949 = t310 * t126;
  t952 = t309 * t126;
  t955 = t122 * t122;
  t956 = 0.1e1 / t955;
  t957 = t18 * t956;
  t960 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t314 - 0.6e1 * t957);
  t964 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t948 * t949 + 0.1e2 / 0.3e1 * t952 * t318 + 0.5e1 / 0.3e1 * t27 * t960);
  t965 = t964 * t31;
  t969 = t322 * t134;
  t971 = t7 * t969 * t73;
  t976 = t129 * t335;
  t978 = t7 * t976 * t73;
  t981 = t7 * t327 * t164;
  t987 = 0.1e1 / t30 / t122;
  t988 = t29 * t987;
  t991 = 0.2e1 / 0.45e2 * t7 * t988 * t73;
  t993 = t7 * t336 * t164;
  t996 = t7 * t135 * t398;
  t1000 = 0.1e1 / t41 / t343 / rho[0];
  t1002 = t38 * sigma[0] * t1000;
  t1008 = -0.11e4 / 0.729e3 * t38 * lapl[0] * t345 + 0.616e4 / 0.2187e4 * t1002;
  t1014 = t360 * t153;
  t1015 = t362 * t155;
  t1016 = t1014 * t1015;
  t1017 = t151 * t1016;
  t1019 = 0.1e1 / t363 / t65;
  t1020 = t1019 * t68;
  t1021 = t1020 * t375;
  t1024 = t379 * t362;
  t1028 = t1014 * t383;
  t1030 = t158 * t155;
  t1031 = t374 * t1030;
  t1032 = t151 * t1028 * t1031;
  t1034 = t1014 * t155;
  t1036 = t368 * t383;
  t1037 = t391 * t1036;
  t1038 = t359 * t1034 * t1037;
  t1042 = t70 / t357 / t66;
  t1043 = t1042 * t1016;
  t1044 = t1019 * t366;
  t1045 = t1044 * t392;
  t1048 = params->csk_a * params->csk_a;
  t1049 = t158 * t1048;
  t1050 = t1020 * t1049;
  t1052 = t359 * t1016;
  t1058 = t151 * t379 * t153 * t385;
  t1060 = t1019 * t1048;
  t1061 = t1060 * t369;
  t1064 = t366 * t68;
  t1065 = t1019 * t1064;
  t1067 = 0.1e1 / t367 / t69;
  t1068 = t1067 * t1048;
  t1069 = t1065 * t1068;
  t1072 = t368 * t379;
  t1076 = t1067 * params->csk_a;
  t1077 = t1065 * t1076;
  t1080 = 0.3e1 * t151 * t1024 * t619 + 0.3e1 * t601 * t391 * t1072 - 0.3e1 * t1017 * t1021 - t1017 * t1050 + 0.3e1 * t1043 * t1045 - t1043 * t1050 - 0.3e1 * t1043 * t1061 - 0.2e1 * t1043 * t1069 + 0.3e1 * t1043 * t1077 + 0.3e1 * t1052 * t1050 + 0.3e1 * t1032 + 0.3e1 * t1038 - 0.3e1 * t1058;
  t1085 = t359 * t1024;
  t1088 = t359 * t1028;
  t1090 = t391 * t392 * t155;
  t1091 = t1088 * t1090;
  t1094 = t375 * t379;
  t1095 = t374 * t1094;
  t1100 = t364 * params->csk_a;
  t1102 = t155 * t68 * t158;
  t1103 = t1100 * t1102;
  t1104 = t1088 * t1103;
  t1107 = t375 * t383;
  t1108 = t374 * t1107;
  t1109 = t151 * t1034 * t1108;
  t1112 = t1015 * t1019;
  t1113 = t1064 * t1067;
  t1114 = t1112 * t1113;
  t1116 = my_piecewise3(t61, 0, t1008);
  t1117 = my_piecewise3(t63, t1116, 0);
  t1121 = t1112 * t159;
  t1125 = t1112 * t369;
  t1128 = -t1042 * t1014 * t1114 - 0.2e1 * t151 * t1014 * t1121 - 0.3e1 * t359 * t1014 * t1125 + 0.3e1 * t151 * t600 * t1095 - t151 * t1117 * t160 + 0.3e1 * t1052 * t1021 + 0.3e1 * t1052 * t1061 - 0.3e1 * t1085 * t608 - 0.3e1 * t1085 * t624 - 0.3e1 * t1091 - 0.3e1 * t1104 + 0.3e1 * t1109 - t386;
  t1130 = my_piecewise5(t58, 0, t61, 0, t1080 + t1128);
  t1132 = -0.77e3 / 0.243e3 * t1002 + t1008 * t71 + 0.3e1 * t353 * t162 + 0.3e1 * t149 * t396 + t53 * t1130;
  t1137 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t965 * t73 + 0.3e1 / 0.1e2 * t971 + 0.9e1 / 0.2e2 * t7 * t323 * t164 - t978 / 0.1e2 + 0.3e1 / 0.5e1 * t981 + 0.9e1 / 0.2e2 * t7 * t130 * t398 + t991 - t993 / 0.1e2 + 0.3e1 / 0.1e2 * t996 + 0.3e1 / 0.2e2 * t7 * t32 * t1132);
  t1139 = 0.1e1 / t84 / t82;
  t1140 = t405 * t172;
  t1143 = t404 * t172;
  t1146 = t79 * t956;
  t1149 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t314 - 0.6e1 * t1146);
  t1153 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1139 * t1140 + 0.1e2 / 0.3e1 * t1143 * t411 + 0.5e1 / 0.3e1 * t85 * t1149);
  t1154 = t1153 * t31;
  t1158 = t415 * t134;
  t1160 = t7 * t1158 * t117;
  t1162 = t175 * t335;
  t1164 = t7 * t1162 * t117;
  t1166 = t87 * t987;
  t1169 = 0.2e1 / 0.45e2 * t7 * t1166 * t117;
  t1171 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1154 * t117 + 0.3e1 / 0.1e2 * t1160 - t1164 / 0.1e2 + t1169);
  tv3rho30 = 0.3e1 * t403 + 0.3e1 * t429 + t8 * (t1137 + t1171);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1174 = 0.2e1 * t455;
  t1175 = 0.2e1 * t481;
  t1176 = t948 * t189;
  t1179 = t309 * t436;
  t1184 = 0.2e1 * t314;
  t1185 = 0.6e1 * t957;
  t1187 = my_piecewise5(t12, 0, t16, 0, t1184 - t1185);
  t1191 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1176 * t310 + 0.2e2 / 0.9e1 * t1179 * t126 + 0.1e2 / 0.9e1 * t432 * t318 + 0.5e1 / 0.3e1 * t27 * t1187);
  t1192 = t1191 * t31;
  t1196 = t440 * t134;
  t1199 = t7 * t1196 * t73 / 0.5e1;
  t1203 = t192 * t335;
  t1205 = t7 * t1203 * t73;
  t1209 = t7 * t445 * t164 / 0.5e1;
  t1218 = 0.3e1 / 0.2e2 * t7 * t1192 * t73 + t1199 + 0.3e1 / 0.1e2 * t7 * t441 * t164 - t1205 / 0.3e2 + t1209 + 0.3e1 / 0.2e2 * t7 * t193 * t398 + t971 / 0.1e2 - t978 / 0.15e2 + t981 / 0.5e1 + t991 - t993 / 0.15e2 + t996 / 0.1e2;
  t1219 = my_piecewise3(t2, 0, t1218);
  t1220 = t1139 * t200;
  t1223 = t404 * t460;
  t1228 = 0.6e1 * t1146;
  t1230 = my_piecewise5(t16, 0, t12, 0, -t1184 - t1228);
  t1234 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1220 * t405 + 0.2e2 / 0.9e1 * t1223 * t172 + 0.1e2 / 0.9e1 * t456 * t411 + 0.5e1 / 0.3e1 * t85 * t1230);
  t1235 = t1234 * t31;
  t1239 = t464 * t134;
  t1242 = t7 * t1239 * t117 / 0.5e1;
  t1243 = t203 * t335;
  t1245 = t7 * t1243 * t117;
  t1254 = t7 * t420 * t233 / 0.5e1;
  t1256 = t7 * t424 * t233;
  t1259 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1235 * t117 + t1242 - t1245 / 0.3e2 + t1160 / 0.1e2 - t1164 / 0.15e2 + t1169 + 0.3e1 / 0.2e2 * t7 * t416 * t233 + t1254 - t1256 / 0.3e2);
  tv3rho31 = t403 + t429 + t1174 + t1175 + t8 * (t1219 + t1259);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1262 = t948 * t486;
  t1267 = t309 * t491;
  t1271 = my_piecewise5(t12, 0, t16, 0, -t1184 - t1185);
  t1275 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1262 * t126 + 0.2e2 / 0.9e1 * t432 * t436 + 0.1e2 / 0.9e1 * t1267 * t126 + 0.5e1 / 0.3e1 * t27 * t1271);
  t1276 = t1275 * t31;
  t1280 = t495 * t134;
  t1282 = t7 * t1280 * t73;
  t1291 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1276 * t73 + t1282 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t496 * t164 + t1199 - t1205 / 0.15e2 + t1209 - t978 / 0.3e2 + t991 - t993 / 0.3e2);
  t1292 = t1139 * t503;
  t1297 = t404 * t508;
  t1301 = my_piecewise5(t16, 0, t12, 0, t1184 - t1228);
  t1305 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1292 * t172 + 0.2e2 / 0.9e1 * t456 * t460 + 0.1e2 / 0.9e1 * t1297 * t172 + 0.5e1 / 0.3e1 * t85 * t1301);
  t1306 = t1305 * t31;
  t1310 = t512 * t134;
  t1312 = t7 * t1310 * t117;
  t1319 = t7 * t469 * t233;
  t1327 = t7 * t180 * t577;
  t1329 = 0.3e1 / 0.2e2 * t7 * t1306 * t117 + t1312 / 0.1e2 + t1242 - t1245 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t465 * t233 + t1319 / 0.5e1 - t1164 / 0.3e2 + t1169 + t1254 - t1256 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t176 * t577 + t1327 / 0.1e2;
  t1330 = my_piecewise3(t78, 0, t1329);
  tv3rho32 = t1174 + t1175 + t502 + t582 + t8 * (t1291 + t1330);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1335 = t486 * t189;
  t1342 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t314 - 0.6e1 * t957);
  t1346 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t948 * t1335 + 0.1e2 / 0.3e1 * t432 * t491 + 0.5e1 / 0.3e1 * t27 * t1342);
  t1347 = t1346 * t31;
  t1354 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1347 * t73 + 0.3e1 / 0.1e2 * t1282 - t1205 / 0.1e2 + t991);
  t1355 = t503 * t200;
  t1362 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t314 - 0.6e1 * t1146);
  t1366 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1139 * t1355 + 0.1e2 / 0.3e1 * t456 * t508 + 0.5e1 / 0.3e1 * t85 * t1362);
  t1367 = t1366 * t31;
  t1384 = 0.1e1 / t91 / t522 / rho[1];
  t1386 = t38 * sigma[2] * t1384;
  t1392 = -0.11e4 / 0.729e3 * t38 * lapl[1] * t524 + 0.616e4 / 0.2187e4 * t1386;
  t1398 = t539 * t222;
  t1399 = t1398 * t224;
  t1401 = t547 * t562;
  t1402 = t570 * t1401;
  t1403 = t538 * t1399 * t1402;
  t1405 = t558 * t541;
  t1409 = t1398 * t562;
  t1411 = t227 * t224;
  t1412 = t553 * t1411;
  t1413 = t220 * t1409 * t1412;
  t1417 = t114 / t536 / t110;
  t1418 = t541 * t224;
  t1419 = t1398 * t1418;
  t1420 = t1417 * t1419;
  t1422 = 0.1e1 / t542 / t109;
  t1423 = t1422 * t545;
  t1424 = t1423 * t571;
  t1427 = t220 * t1419;
  t1428 = t1422 * t112;
  t1429 = t227 * t1048;
  t1430 = t1428 * t1429;
  t1432 = t538 * t1419;
  t1436 = t1422 * t1048;
  t1437 = t1436 * t548;
  t1440 = t545 * t112;
  t1441 = t1422 * t1440;
  t1443 = 0.1e1 / t546 / t113;
  t1444 = t1443 * t1048;
  t1445 = t1441 * t1444;
  t1448 = t547 * t558;
  t1452 = t1443 * params->csk_a;
  t1453 = t1441 * t1452;
  t1458 = t558 * t222;
  t1460 = t220 * t1458 * t564;
  t1462 = 0.3e1 * t220 * t1405 * t682 + 0.3e1 * t664 * t570 * t1448 + 0.3e1 * t1420 * t1424 - t1420 * t1430 - 0.3e1 * t1420 * t1437 - 0.2e1 * t1420 * t1445 + 0.3e1 * t1420 * t1453 - t1427 * t1430 + 0.3e1 * t1432 * t1430 + 0.3e1 * t1432 * t1437 + 0.3e1 * t1403 + 0.3e1 * t1413 - 0.3e1 * t1460;
  t1463 = t1422 * params->csk_a;
  t1464 = t1463 * t228;
  t1470 = t554 * t558;
  t1471 = t553 * t1470;
  t1474 = t538 * t1405;
  t1477 = t538 * t1409;
  t1479 = t570 * t571 * t224;
  t1480 = t1477 * t1479;
  t1484 = t543 * params->csk_a;
  t1486 = t224 * t112 * t227;
  t1487 = t1484 * t1486;
  t1488 = t1477 * t1487;
  t1491 = t554 * t562;
  t1492 = t553 * t1491;
  t1493 = t220 * t1399 * t1492;
  t1496 = t1418 * t1422;
  t1497 = t1440 * t1443;
  t1498 = t1496 * t1497;
  t1500 = my_piecewise3(t105, 0, t1392);
  t1501 = my_piecewise3(t107, t1500, 0);
  t1505 = t1496 * t548;
  t1509 = t1496 * t228;
  t1512 = -t1417 * t1398 * t1498 - 0.3e1 * t538 * t1398 * t1505 - 0.2e1 * t220 * t1398 * t1509 + 0.3e1 * t220 * t663 * t1471 - t220 * t1501 * t229 - 0.3e1 * t1427 * t1464 + 0.3e1 * t1432 * t1464 - 0.3e1 * t1474 * t671 - 0.3e1 * t1474 * t687 - 0.3e1 * t1480 - 0.3e1 * t1488 + 0.3e1 * t1493 - t565;
  t1514 = my_piecewise5(t104, 0, t105, 0, t1462 + t1512);
  t1516 = -0.77e3 / 0.243e3 * t1386 + t1392 * t115 + 0.3e1 * t532 * t231 + 0.3e1 * t218 * t575 + t103 * t1514;
  t1521 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1367 * t117 + 0.3e1 / 0.1e2 * t1312 + 0.9e1 / 0.2e2 * t7 * t513 * t233 - t1245 / 0.1e2 + 0.3e1 / 0.5e1 * t1319 + 0.9e1 / 0.2e2 * t7 * t204 * t577 + t1169 - t1256 / 0.1e2 + 0.3e1 / 0.1e2 * t1327 + 0.3e1 / 0.2e2 * t7 * t88 * t1516);
  tv3rho33 = 0.3e1 * t502 + 0.3e1 * t582 + t8 * (t1354 + t1521);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1529 = t7 * t327 * t253;
  t1536 = t7 * t336 * t253 / 0.3e2;
  t1538 = t7 * t135 * t629;
  t1540 = t38 * t345;
  t1543 = t38 * t345 * t71;
  t1546 = t38 * t141 * t162;
  t1549 = t38 * t43 * t396;
  t1554 = t612 * t153;
  t1556 = t151 * t1554 * t385;
  t1558 = t248 * t379;
  t1560 = t151 * t1558 * t385;
  t1561 = t158 * t379;
  t1562 = t374 * t1561;
  t1565 = t368 * t612;
  t1566 = t391 * t1565;
  t1569 = t360 * t1015;
  t1570 = t1042 * t1569;
  t1571 = t1067 * t248;
  t1574 = t359 * t1569;
  t1575 = t1044 * t602;
  t1578 = t248 * t1015;
  t1579 = t151 * t1578;
  t1580 = t158 * t360;
  t1581 = t1020 * t1580;
  t1584 = t612 * t362;
  t1585 = t151 * t1584;
  t1588 = t1571 * params->csk_a;
  t1589 = t1065 * t1588;
  t1595 = t359 * t1578;
  t1596 = t368 * t1048;
  t1597 = t1596 * t360;
  t1598 = t1044 * t1597;
  t1601 = t1019 * params->csk_a;
  t1603 = t360 * t68 * t158;
  t1604 = t1601 * t1603;
  t1607 = t359 * t1584;
  t1610 = -t1570 * t1065 * t1571 + t1085 * t603 + t606 * t1095 + t606 * t1562 + 0.2e1 * t601 * t1566 + 0.3e1 * t1570 * t1589 - 0.3e1 * t1574 * t1575 - 0.2e1 * t1579 * t1581 + 0.2e1 * t1585 * t608 + 0.2e1 * t1585 * t619 + 0.3e1 * t1595 * t1598 + 0.3e1 * t1595 * t1604 - 0.2e1 * t1607 * t608 - 0.2e1 * t1556 - t1560 - t617;
  t1613 = t1042 * t1578;
  t1614 = t1060 * t1603;
  t1616 = t1044 * t860;
  t1623 = t359 * t360 * t155;
  t1624 = t602 * t383;
  t1625 = t391 * t1624;
  t1626 = t1623 * t1625;
  t1628 = t248 * t360;
  t1631 = t383 * t364 * t1102;
  t1632 = t151 * t1628 * t1631;
  t1634 = t1068 * t360;
  t1635 = t1065 * t1634;
  t1643 = t392 * t379;
  t1644 = t391 * t1643;
  t1647 = my_piecewise3(t61, 0, -0.44e3 / 0.729e3 * t1540);
  t1648 = my_piecewise3(t63, t1647, 0);
  t1651 = t1628 * t383;
  t1652 = t359 * t1651;
  t1653 = t1652 * t1090;
  t1655 = t1652 * t1103;
  t1657 = t248 * t155;
  t1658 = t1657 * t364;
  t1659 = t151 * t1658;
  t1661 = params->csk_a * t360 * t383;
  t1662 = t159 * t1661;
  t1663 = t1659 * t1662;
  t1665 = -t151 * t1648 * t160 - t621 * t1095 + 0.3e1 * t1570 * t1616 - 0.3e1 * t1579 * t1604 - t1579 * t1614 + 0.3e1 * t1595 * t1614 - 0.3e1 * t1613 * t1598 - 0.2e1 * t1607 * t624 - t1613 * t1614 - 0.2e1 * t1613 * t1635 - t621 * t1644 + 0.3e1 * t1626 + 0.3e1 * t1632 - 0.3e1 * t1653 - 0.3e1 * t1655 + 0.3e1 * t1663;
  t1667 = my_piecewise5(t58, 0, t61, 0, t1610 + t1665);
  t1669 = 0.55e2 / 0.81e2 * t1540 - 0.44e3 / 0.729e3 * t1543 + 0.8e2 / 0.243e3 * t1546 - 0.5e1 / 0.81e2 * t1549 + t353 * t251 + 0.2e1 * t149 * t627 + t53 * t1667;
  t1674 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t253 + t1529 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t629 - t1536 + t1538 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1669);
  tv3rho2sigma0 = t8 * t1674 + 0.2e1 * t634;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1681 = t7 * t420 * t270;
  t1685 = t7 * t424 * t270 / 0.3e2;
  t1687 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t270 + t1681 / 0.5e1 - t1685);
  tv3rho2sigma2 = t8 * t1687 + 0.2e1 * t643;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1693 = t7 * t445 * t253;
  t1701 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t253 + t1693 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t629 + t1529 / 0.1e2 - t1536 + t1538 / 0.1e2);
  tv3rho2sigma3 = t8 * t1701 + t634 + t649;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1707 = t7 * t469 * t270;
  t1714 = t7 * t180 * t692;
  t1717 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t270 + t1707 / 0.1e2 + t1681 / 0.1e2 - t1685 + 0.3e1 / 0.2e2 * t7 * t176 * t692 + t1714 / 0.1e2);
  tv3rho2sigma5 = t8 * t1717 + t643 + t697;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1725 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t253 + t1693 / 0.5e1 - t1536);
  tv3rho2sigma6 = t8 * t1725 + 0.2e1 * t649;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1736 = t38 * t524;
  t1739 = t38 * t524 * t115;
  t1742 = t38 * t210 * t231;
  t1745 = t38 * t93 * t575;
  t1750 = t539 * t1418;
  t1751 = t538 * t1750;
  t1752 = t1423 * t665;
  t1755 = t675 * t541;
  t1756 = t220 * t1755;
  t1759 = t675 * t222;
  t1761 = t220 * t1759 * t564;
  t1763 = t265 * t558;
  t1765 = t220 * t1763 * t564;
  t1766 = t227 * t558;
  t1767 = t553 * t1766;
  t1770 = t547 * t675;
  t1771 = t570 * t1770;
  t1774 = t1417 * t1750;
  t1775 = t1443 * t265;
  t1778 = t265 * t1418;
  t1779 = t220 * t1778;
  t1780 = t227 * t539;
  t1781 = t1428 * t1780;
  t1787 = t538 * t1778;
  t1788 = t547 * t1048;
  t1789 = t1788 * t539;
  t1790 = t1423 * t1789;
  t1793 = t538 * t1755;
  t1797 = t539 * t112 * t227;
  t1798 = t1463 * t1797;
  t1803 = -t1774 * t1441 * t1775 + t669 * t1471 + t1474 * t666 - 0.3e1 * t1751 * t1752 + 0.2e1 * t1756 * t671 + 0.2e1 * t1756 * t682 + t669 * t1767 + 0.2e1 * t664 * t1771 - 0.2e1 * t1779 * t1781 + 0.3e1 * t1787 * t1790 + 0.3e1 * t1787 * t1798 - 0.2e1 * t1793 * t671 - 0.2e1 * t1793 * t687 - 0.2e1 * t1761 - t1765 - t680;
  t1806 = t1423 * t888;
  t1810 = t1428 * t1429 * t539;
  t1814 = t1417 * t1778;
  t1816 = t265 * t539;
  t1819 = t562 * t543 * t1486;
  t1820 = t220 * t1816 * t1819;
  t1823 = t538 * t539 * t224;
  t1824 = t665 * t562;
  t1825 = t570 * t1824;
  t1826 = t1823 * t1825;
  t1831 = t571 * t558;
  t1832 = t570 * t1831;
  t1834 = t1444 * t539;
  t1835 = t1441 * t1834;
  t1838 = t1775 * params->csk_a;
  t1839 = t1441 * t1838;
  t1843 = my_piecewise3(t105, 0, -0.44e3 / 0.729e3 * t1736);
  t1844 = my_piecewise3(t107, t1843, 0);
  t1847 = t265 * t224;
  t1848 = t1847 * t543;
  t1849 = t220 * t1848;
  t1851 = params->csk_a * t539 * t562;
  t1852 = t228 * t1851;
  t1853 = t1849 * t1852;
  t1855 = t1816 * t562;
  t1856 = t538 * t1855;
  t1857 = t1856 * t1479;
  t1859 = t1856 * t1487;
  t1861 = -t220 * t1844 * t229 - t684 * t1471 + 0.3e1 * t1774 * t1806 + 0.3e1 * t1774 * t1839 - 0.3e1 * t1779 * t1798 - t1779 * t1810 + 0.3e1 * t1787 * t1810 - 0.3e1 * t1814 * t1790 - t1814 * t1810 - 0.2e1 * t1814 * t1835 - t684 * t1832 + 0.3e1 * t1820 + 0.3e1 * t1826 + 0.3e1 * t1853 - 0.3e1 * t1857 - 0.3e1 * t1859;
  t1863 = my_piecewise5(t104, 0, t105, 0, t1803 + t1861);
  t1865 = 0.55e2 / 0.81e2 * t1736 - 0.44e3 / 0.729e3 * t1739 + 0.8e2 / 0.243e3 * t1742 - 0.5e1 / 0.81e2 * t1745 + t532 * t268 + 0.2e1 * t218 * t690 + t103 * t1863;
  t1870 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t270 + t1707 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t692 - t1685 + t1714 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t1865);
  tv3rho2sigma8 = t8 * t1870 + 0.2e1 * t697;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1877 = t7 * t327 * t286;
  t1884 = t7 * t336 * t286 / 0.3e2;
  t1886 = t7 * t135 * t731;
  t1896 = t718 * t153;
  t1898 = t151 * t1896 * t385;
  t1900 = t281 * t379;
  t1902 = t151 * t1900 * t385;
  t1905 = t368 * t718;
  t1906 = t391 * t1905;
  t1909 = t1067 * t281;
  t1910 = t1065 * t1909;
  t1912 = t281 * t1015;
  t1913 = t151 * t1912;
  t1916 = t1044 * t710;
  t1919 = t718 * t362;
  t1920 = t151 * t1919;
  t1923 = t359 * t1912;
  t1926 = t359 * t1919;
  t1931 = t1042 * t1912;
  t1933 = t710 * params->csk_a;
  t1934 = t1044 * t1933;
  t1938 = t1085 * t711 + t714 * t1562 - t1570 * t1910 + 0.3e1 * t1570 * t1934 - 0.3e1 * t1574 * t1916 - 0.2e1 * t1913 * t1581 - 0.3e1 * t1913 * t1604 + 0.3e1 * t1923 * t1604 - t1913 * t1614 - t1931 * t1614 + 0.2e1 * t601 * t1906 + 0.2e1 * t1920 * t619 - 0.2e1 * t1926 * t608 - 0.2e1 * t1898 - t1902 - t723;
  t1941 = t281 * t360;
  t1943 = t151 * t1941 * t1631;
  t1945 = t710 * t383;
  t1946 = t391 * t1945;
  t1947 = t1623 * t1946;
  t1958 = my_piecewise3(t61, 0, 0.1e3 / 0.243e3 * t591);
  t1959 = my_piecewise3(t63, t1958, 0);
  t1963 = t359 * t1941 * t383;
  t1964 = t1963 * t1103;
  t1967 = t281 * t155 * t364;
  t1968 = t151 * t1967;
  t1969 = t1968 * t1662;
  t1971 = t1963 * t1090;
  t1976 = t1909 * params->csk_a;
  t1977 = t1065 * t1976;
  t1982 = -t151 * t1959 * t160 + t714 * t1095 - t725 * t1095 + 0.3e1 * t1570 * t1977 + 0.3e1 * t1923 * t1598 - 0.3e1 * t1931 * t1598 + 0.3e1 * t1923 * t1614 - 0.2e1 * t1931 * t1635 - t725 * t1644 + 0.2e1 * t1920 * t608 - 0.2e1 * t1926 * t624 + 0.3e1 * t1943 + 0.3e1 * t1947 - 0.3e1 * t1964 + 0.3e1 * t1969 - 0.3e1 * t1971;
  t1984 = my_piecewise5(t58, 0, t61, 0, t1938 + t1982);
  t1986 = 0.1e3 / 0.243e3 * t594 - 0.25e2 / 0.81e2 * t597 + 0.5e1 / 0.54e2 * t38 * t48 * t396 + t353 * t284 + 0.2e1 * t149 * t729 + t53 * t1984;
  t1991 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t286 + t1877 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t731 - t1884 + t1886 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1986);
  tv3rho2lapl0 = t8 * t1991 + 0.2e1 * t736;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1998 = t7 * t420 * t302;
  t2002 = t7 * t424 * t302 / 0.3e2;
  t2004 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t302 + t1998 / 0.5e1 - t2002);
  tv3rho2lapl1 = t8 * t2004 + 0.2e1 * t745;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2010 = t7 * t445 * t286;
  t2018 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t286 + t2010 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t731 + t1877 / 0.1e2 - t1884 + t1886 / 0.1e2);
  tv3rho2lapl2 = t8 * t2018 + t736 + t751;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2024 = t7 * t469 * t302;
  t2031 = t7 * t180 * t782;
  t2034 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t302 + t2024 / 0.1e2 + t1998 / 0.1e2 - t2002 + 0.3e1 / 0.2e2 * t7 * t176 * t782 + t2031 / 0.1e2);
  tv3rho2lapl3 = t8 * t2034 + t745 + t787;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2042 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t286 + t2010 / 0.5e1 - t1884);
  tv3rho2lapl4 = t8 * t2042 + 0.2e1 * t751;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2061 = t769 * t541;
  t2062 = t220 * t2061;
  t2067 = t547 * t769;
  t2068 = t570 * t2067;
  t2071 = t1443 * t297;
  t2072 = t1441 * t2071;
  t2074 = t769 * t222;
  t2076 = t220 * t2074 * t564;
  t2078 = t297 * t558;
  t2080 = t220 * t2078 * t564;
  t2081 = t1423 * t761;
  t2084 = t297 * t1418;
  t2085 = t220 * t2084;
  t2089 = my_piecewise3(t105, 0, 0.1e3 / 0.243e3 * t654);
  t2090 = my_piecewise3(t107, t2089, 0);
  t2093 = t297 * t539;
  t2094 = t2093 * t562;
  t2095 = t538 * t2094;
  t2096 = t2095 * t1487;
  t2099 = t297 * t224 * t543;
  t2100 = t220 * t2099;
  t2101 = t2100 * t1852;
  t2103 = t2095 * t1479;
  t2105 = t538 * t2061;
  t2110 = -t220 * t2090 * t229 + t1474 * t762 - 0.3e1 * t1751 * t2081 + t765 * t1767 - t1774 * t2072 - 0.2e1 * t2085 * t1781 - 0.3e1 * t2085 * t1798 + 0.2e1 * t2062 * t682 + 0.2e1 * t664 * t2068 - 0.2e1 * t2105 * t671 - 0.2e1 * t2076 - t2080 - 0.3e1 * t2096 + 0.3e1 * t2101 - 0.3e1 * t2103 - t774;
  t2111 = t1417 * t2084;
  t2113 = t761 * params->csk_a;
  t2114 = t1423 * t2113;
  t2118 = t538 * t2084;
  t2121 = t761 * t562;
  t2122 = t570 * t2121;
  t2123 = t1823 * t2122;
  t2126 = t220 * t2093 * t1819;
  t2128 = t2071 * params->csk_a;
  t2129 = t1441 * t2128;
  t2147 = t765 * t1471 - t776 * t1471 + 0.3e1 * t1774 * t2114 + 0.3e1 * t1774 * t2129 - 0.3e1 * t2111 * t1790 + 0.3e1 * t2118 * t1790 + 0.3e1 * t2118 * t1798 - t2085 * t1810 - t2111 * t1810 + 0.3e1 * t2118 * t1810 - t776 * t1832 - 0.2e1 * t2111 * t1835 + 0.2e1 * t2062 * t671 - 0.2e1 * t2105 * t687 + 0.3e1 * t2123 + 0.3e1 * t2126;
  t2149 = my_piecewise5(t104, 0, t105, 0, t2110 + t2147);
  t2151 = 0.1e3 / 0.243e3 * t657 - 0.25e2 / 0.81e2 * t660 + 0.5e1 / 0.54e2 * t38 * t98 * t575 + t532 * t300 + 0.2e1 * t218 * t780 + t103 * t2149;
  t2156 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t302 + t2024 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t782 - t2002 + t2031 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t2151);
  tv3rho2lapl5 = t8 * t2156 + 0.2e1 * t787;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2163 = t7 * t135 * t811 / 0.1e2;
  t2165 = t38 * t141 * t251;
  t2168 = t38 * t43 * t627;
  t2171 = t792 * t1015;
  t2172 = t359 * t2171;
  t2173 = t368 * t153;
  t2174 = t1044 * t2173;
  t2177 = t799 * t362;
  t2178 = t151 * t2177;
  t2179 = t2178 * t619;
  t2180 = t151 * t2171;
  t2181 = t1020 * t618;
  t2184 = t158 * t612;
  t2185 = t374 * t2184;
  t2190 = t153 * t1015;
  t2191 = t1042 * t2190;
  t2192 = t1067 * t792;
  t2193 = t1065 * t2192;
  t2195 = t368 * t799;
  t2196 = t391 * t2195;
  t2197 = t601 * t2196;
  t2198 = t799 * t153;
  t2200 = t151 * t2198 * t385;
  t2201 = t248 * t383;
  t2202 = t151 * t2201;
  t2203 = t156 * t68;
  t2205 = t2202 * t2203 * t2184;
  t2206 = 0.2e1 * t2205;
  t2207 = t792 * t155;
  t2209 = t151 * t2207 * t364;
  t2210 = params->csk_a * t153;
  t2211 = t2210 * t383;
  t2212 = t159 * t2211;
  t2213 = t2209 * t2212;
  t2215 = t792 * t383;
  t2217 = t359 * t2215 * t364;
  t2218 = t2210 * t155;
  t2219 = t369 * t2218;
  t2220 = t2217 * t2219;
  t2222 = t2210 * t1102;
  t2223 = t2217 * t2222;
  t2225 = t151 * t2215;
  t2227 = t374 * t618 * t155;
  t2228 = t2225 * t2227;
  t2230 = t159 * t612;
  t2231 = t1100 * t2230;
  t2234 = 0.2e1 * t621 * t1566 - 0.3e1 * t2172 * t2174 - 0.2e1 * t2180 * t2181 + 0.2e1 * t606 * t2185 - t2191 * t2193 - 0.2e1 * t621 * t2231 + t2179 + t2197 - t2200 - t2206 + 0.3e1 * t2213 - 0.3e1 * t2220 - 0.3e1 * t2223 + 0.3e1 * t2228 - t801 - t803;
  t2235 = t1042 * t2171;
  t2236 = t1044 * t623;
  t2239 = t1049 * t153;
  t2240 = t1020 * t2239;
  t2245 = t2178 * t608;
  t2246 = t359 * t2177;
  t2247 = t2246 * t608;
  t2249 = t153 * t68 * t158;
  t2250 = t1601 * t2249;
  t2255 = t369 * t153;
  t2256 = t1060 * t2255;
  t2259 = t392 * t612;
  t2260 = t391 * t2259;
  t2263 = t1068 * t153;
  t2264 = t1065 * t2263;
  t2267 = t359 * t2207;
  t2268 = t2173 * t383;
  t2269 = t391 * t2268;
  t2270 = t2267 * t2269;
  t2272 = t1076 * t153;
  t2273 = t1065 * t2272;
  t2280 = t2246 * t624;
  t2281 = 0.3e1 * t2172 * t2240 + 0.3e1 * t2172 * t2250 + 0.3e1 * t2172 * t2256 - t2180 * t2240 - 0.3e1 * t2180 * t2250 + 0.2e1 * t606 * t2231 + 0.3e1 * t2235 * t2236 - t2235 * t2240 - 0.3e1 * t2235 * t2256 - 0.2e1 * t2235 * t2264 + 0.3e1 * t2235 * t2273 - 0.2e1 * t621 * t2260 + t2245 - t2247 + 0.3e1 * t2270 - t2280;
  t2283 = my_piecewise5(t58, 0, t61, 0, t2234 + t2281);
  t2285 = 0.8e2 / 0.243e3 * t2165 - 0.1e2 / 0.81e2 * t2168 + t149 * t809 + t53 * t2283;
  t2290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t811 + t2163 + 0.3e1 / 0.2e2 * t7 * t32 * t2285);
  tv3rhosigma20 = t8 * t2290 + t815;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2297 = t7 * t180 * t838 / 0.1e2;
  t2299 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t838 + t2297);
  tv3rhosigma25 = t8 * t2299 + t842;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2305 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t811 + t2163);
  tv3rhosigma26 = t8 * t2305 + t815;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2311 = t38 * t210 * t268;
  t2314 = t38 * t93 * t690;
  t2317 = t819 * t1418;
  t2318 = t220 * t2317;
  t2319 = t1428 * t681;
  t2322 = t538 * t2317;
  t2323 = t547 * t222;
  t2324 = t1423 * t2323;
  t2327 = t826 * t541;
  t2328 = t220 * t2327;
  t2329 = t2328 * t682;
  t2332 = t222 * t1418;
  t2333 = t1417 * t2332;
  t2334 = t1443 * t819;
  t2335 = t1441 * t2334;
  t2337 = t547 * t826;
  t2338 = t570 * t2337;
  t2339 = t664 * t2338;
  t2340 = t826 * t222;
  t2342 = t220 * t2340 * t564;
  t2343 = t265 * t562;
  t2344 = t220 * t2343;
  t2345 = t225 * t112;
  t2346 = t227 * t675;
  t2348 = t2344 * t2345 * t2346;
  t2349 = 0.2e1 * t2348;
  t2350 = t553 * t2346;
  t2353 = t819 * t562;
  t2355 = t538 * t2353 * t543;
  t2356 = params->csk_a * t222;
  t2357 = t2356 * t1486;
  t2358 = t2355 * t2357;
  t2360 = t819 * t224;
  t2362 = t220 * t2360 * t543;
  t2363 = t2356 * t562;
  t2364 = t228 * t2363;
  t2365 = t2362 * t2364;
  t2367 = t2356 * t224;
  t2368 = t548 * t2367;
  t2369 = t2355 * t2368;
  t2371 = t554 * t675;
  t2372 = t553 * t2371;
  t2375 = t1788 * t222;
  t2376 = t1423 * t2375;
  t2379 = 0.2e1 * t684 * t1771 - 0.2e1 * t2318 * t2319 - 0.3e1 * t2322 * t2324 + 0.3e1 * t2322 * t2376 - t2333 * t2335 + 0.2e1 * t669 * t2350 + 0.2e1 * t669 * t2372 + t2329 + t2339 - t2342 - t2349 - 0.3e1 * t2358 + 0.3e1 * t2365 - 0.3e1 * t2369 - t828 - t830;
  t2380 = t538 * t2327;
  t2381 = t2380 * t687;
  t2382 = t220 * t2353;
  t2384 = t553 * t681 * t224;
  t2385 = t2382 * t2384;
  t2387 = t1417 * t2317;
  t2388 = t1423 * t686;
  t2391 = t1429 * t222;
  t2392 = t1428 * t2391;
  t2397 = t2328 * t671;
  t2398 = t2380 * t671;
  t2400 = t222 * t112 * t227;
  t2401 = t1463 * t2400;
  t2410 = t571 * t675;
  t2411 = t570 * t2410;
  t2414 = t1444 * t222;
  t2415 = t1441 * t2414;
  t2418 = t538 * t2360;
  t2419 = t2323 * t562;
  t2420 = t570 * t2419;
  t2421 = t2418 * t2420;
  t2423 = t1452 * t222;
  t2424 = t1441 * t2423;
  t2427 = -t2318 * t2392 - 0.3e1 * t2318 * t2401 + 0.3e1 * t2322 * t2392 + 0.3e1 * t2322 * t2401 - 0.2e1 * t684 * t2372 - 0.3e1 * t2387 * t2376 + 0.3e1 * t2387 * t2388 - t2387 * t2392 - 0.2e1 * t2387 * t2415 + 0.3e1 * t2387 * t2424 - 0.2e1 * t684 * t2411 - t2381 + 0.3e1 * t2385 + t2397 - t2398 + 0.3e1 * t2421;
  t2429 = my_piecewise5(t104, 0, t105, 0, t2379 + t2427);
  t2431 = 0.8e2 / 0.243e3 * t2311 - 0.1e2 / 0.81e2 * t2314 + t218 * t836 + t103 * t2429;
  t2436 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t838 + t2297 + 0.3e1 / 0.2e2 * t7 * t88 * t2431);
  tv3rhosigma211 = t8 * t2436 + t842;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2443 = t7 * t135 * t866 / 0.1e2;
  t2449 = t38 * t141 * t284;
  t2452 = t38 * t43 * t729;
  t2457 = t718 * t248;
  t2459 = t151 * t2457 * t385;
  t2460 = t281 * t612;
  t2462 = t151 * t2460 * t385;
  t2465 = t853 * t383;
  t2466 = t359 * t2465;
  t2468 = t1100 * t153 * t1102;
  t2469 = t2466 * t2468;
  t2471 = t159 * params->csk_a;
  t2472 = t615 * t383;
  t2473 = t2471 * t2472;
  t2474 = t1968 * t2473;
  t2476 = t391 * t368;
  t2477 = t2476 * t2218;
  t2478 = t2466 * t2477;
  t2480 = t1912 * t1019;
  t2481 = t359 * t2480;
  t2482 = t159 * t248;
  t2483 = t2210 * t2482;
  t2486 = t151 * t2480;
  t2489 = t1578 * t1019;
  t2490 = t1042 * t2489;
  t2491 = t281 * params->csk_a;
  t2492 = t2491 * t153;
  t2493 = t369 * t2492;
  t2496 = t1048 * t248;
  t2497 = t2496 * t153;
  t2498 = t159 * t2497;
  t2502 = t1607 * t711 + t621 * t1906 + t1920 * t857 + t714 * t2185 + 0.3e1 * t2481 * t2483 + 0.3e1 * t2481 * t2498 - 0.3e1 * t2486 * t2483 - t2486 * t2498 + 0.3e1 * t2490 * t2493 + t2179 + t2197 - t2200 - t2459 - t2462 - 0.3e1 * t2469 + 0.3e1 * t2474 - 0.3e1 * t2478 - t801 - t855;
  t2503 = t1042 * t2480;
  t2505 = t1113 * t2497;
  t2508 = t369 * t2497;
  t2511 = t151 * t2465;
  t2512 = t2511 * t2227;
  t2516 = t359 * t1658;
  t2517 = t721 * t383;
  t2518 = t369 * t2517;
  t2519 = t2516 * t2518;
  t2521 = t1113 * t2492;
  t2527 = t856 * t153;
  t2528 = t1020 * t2527;
  t2532 = t1044 * t710 * t153;
  t2537 = t1571 * t281;
  t2538 = t1065 * t2537;
  t2541 = -0.3e1 * t1595 * t2532 - 0.2e1 * t1913 * t2528 + t1920 * t851 - t1926 * t851 - t1926 * t861 - t2191 * t2538 + t714 * t2231 - t725 * t2231 - t725 * t2260 + 0.3e1 * t2481 * t2508 + 0.3e1 * t2490 * t2521 - t2503 * t2498 - 0.2e1 * t2503 * t2505 - 0.3e1 * t2503 * t2508 + t2245 - t2247 - t2280 + 0.3e1 * t2512 + 0.3e1 * t2519;
  t2543 = my_piecewise5(t58, 0, t61, 0, t2502 + t2541);
  t2545 = -0.25e2 / 0.162e3 * t790 + 0.5e1 / 0.54e2 * t38 * t48 * t627 + 0.4e2 / 0.243e3 * t2449 - 0.5e1 / 0.81e2 * t2452 + t149 * t864 + t53 * t2543;
  t2550 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t866 + t2443 + 0.3e1 / 0.2e2 * t7 * t32 * t2545);
  tv3rhosigmalapl0 = t8 * t2550 + t870;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2557 = t7 * t180 * t894 / 0.1e2;
  t2559 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t894 + t2557);
  tv3rhosigmalapl5 = t8 * t2559 + t898;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2565 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t866 + t2443);
  tv3rhosigmalapl6 = t8 * t2565 + t870;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2575 = t38 * t210 * t300;
  t2578 = t38 * t93 * t780;
  t2583 = t769 * t265;
  t2585 = t220 * t2583 * t564;
  t2586 = t297 * t675;
  t2588 = t220 * t2586 * t564;
  t2591 = t881 * t562;
  t2592 = t538 * t2591;
  t2594 = t1484 * t222 * t1486;
  t2595 = t2592 * t2594;
  t2597 = t228 * params->csk_a;
  t2598 = t678 * t562;
  t2600 = t2100 * t2597 * t2598;
  t2602 = t570 * t547;
  t2603 = t2602 * t2367;
  t2604 = t2592 * t2603;
  t2606 = t2084 * t1422;
  t2607 = t538 * t2606;
  t2608 = t228 * t265;
  t2609 = t2356 * t2608;
  t2612 = t220 * t2606;
  t2615 = t1778 * t1422;
  t2616 = t1417 * t2615;
  t2617 = t297 * params->csk_a;
  t2618 = t2617 * t222;
  t2619 = t548 * t2618;
  t2622 = t1048 * t265;
  t2623 = t2622 * t222;
  t2624 = t228 * t2623;
  t2628 = t1793 * t762 + t2062 * t885 + t684 * t2068 + t765 * t2350 + 0.3e1 * t2607 * t2609 + 0.3e1 * t2607 * t2624 - 0.3e1 * t2612 * t2609 - t2612 * t2624 + 0.3e1 * t2616 * t2619 + t2329 + t2339 - t2342 - t2585 - t2588 - 0.3e1 * t2595 + 0.3e1 * t2600 - 0.3e1 * t2604 - t828 - t883;
  t2629 = t1417 * t2606;
  t2631 = t548 * t222;
  t2632 = t2622 * t2631;
  t2635 = t1497 * t2623;
  t2638 = t538 * t1848;
  t2640 = t548 * t772 * t562;
  t2641 = t2638 * t2640;
  t2643 = t1497 * t2618;
  t2648 = t220 * t2591;
  t2649 = t2648 * t2384;
  t2652 = t1423 * t761 * t222;
  t2655 = t884 * t222;
  t2656 = t1428 * t2655;
  t2663 = t1775 * t297;
  t2664 = t1441 * t2663;
  t2668 = -0.3e1 * t1787 * t2652 + t2062 * t879 - 0.2e1 * t2085 * t2656 - t2105 * t879 - t2105 * t889 - t2333 * t2664 + t765 * t2372 - t776 * t2372 - t776 * t2411 + 0.3e1 * t2607 * t2632 + 0.3e1 * t2616 * t2643 - t2629 * t2624 - 0.3e1 * t2629 * t2632 - 0.2e1 * t2629 * t2635 - t2381 + t2397 - t2398 + 0.3e1 * t2641 + 0.3e1 * t2649;
  t2670 = my_piecewise5(t104, 0, t105, 0, t2628 + t2668);
  t2672 = -0.25e2 / 0.162e3 * t817 + 0.5e1 / 0.54e2 * t38 * t98 * t690 + 0.4e2 / 0.243e3 * t2575 - 0.5e1 / 0.81e2 * t2578 + t218 * t892 + t103 * t2670;
  t2677 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t894 + t2557 + 0.3e1 / 0.2e2 * t7 * t88 * t2672);
  tv3rhosigmalapl11 = t8 * t2677 + t898;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2684 = t7 * t135 * t917 / 0.1e2;
  t2690 = t281 * t383;
  t2691 = t151 * t2690;
  t2692 = t158 * t718;
  t2694 = t2691 * t2203 * t2692;
  t2695 = 0.2e1 * t2694;
  t2701 = t1067 * t902;
  t2702 = t1065 * t2701;
  t2704 = t902 * t1015;
  t2705 = t151 * t2704;
  t2708 = t359 * t2704;
  t2711 = t902 * t155;
  t2713 = t151 * t2711 * t364;
  t2714 = t2713 * t2212;
  t2716 = t902 * t383;
  t2718 = t359 * t2716 * t364;
  t2719 = t2718 * t2219;
  t2721 = t2718 * t2222;
  t2724 = t374 * t375 * t718;
  t2729 = 0.2e1 * t714 * t374 * t2692 + 0.2e1 * t725 * t1906 - 0.3e1 * t2708 * t2174 - 0.2e1 * t2705 * t2181 - t2191 * t2702 + 0.3e1 * t2708 * t2256 + 0.2e1 * t714 * t2724 + t2179 + t2197 - t2200 - t2695 + 0.3e1 * t2714 - 0.3e1 * t2719 - 0.3e1 * t2721 - t801 - t909;
  t2730 = t151 * t2716;
  t2731 = t2730 * t2227;
  t2735 = t1042 * t2704;
  t2748 = t392 * t718;
  t2754 = t359 * t2711;
  t2755 = t2754 * t2269;
  t2759 = -0.2e1 * t725 * t391 * t2748 + 0.3e1 * t2735 * t2236 - t2705 * t2240 + 0.3e1 * t2708 * t2240 - t2735 * t2240 - 0.3e1 * t2705 * t2250 + 0.3e1 * t2708 * t2250 - 0.3e1 * t2735 * t2256 - 0.2e1 * t2735 * t2264 + 0.3e1 * t2735 * t2273 - 0.2e1 * t725 * t2724 + t2245 - t2247 - t2280 + 0.3e1 * t2731 + 0.3e1 * t2755;
  t2761 = my_piecewise5(t58, 0, t61, 0, t2729 + t2759);
  t2763 = -0.25e2 / 0.81e2 * t847 + 0.5e1 / 0.27e2 * t38 * t48 * t729 + t149 * t915 + t53 * t2761;
  t2768 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t917 + t2684 + 0.3e1 / 0.2e2 * t7 * t32 * t2763);
  tv3rholapl20 = t8 * t2768 + t921;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2775 = t7 * t180 * t940 / 0.1e2;
  t2777 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t940 + t2775);
  tv3rholapl22 = t8 * t2777 + t944;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2783 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t917 + t2684);
  tv3rholapl23 = t8 * t2783 + t921;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2793 = t925 * t1418;
  t2794 = t220 * t2793;
  t2799 = t1443 * t925;
  t2800 = t1441 * t2799;
  t2802 = t297 * t562;
  t2803 = t220 * t2802;
  t2804 = t227 * t769;
  t2806 = t2803 * t2345 * t2804;
  t2807 = 0.2e1 * t2806;
  t2811 = t538 * t2793;
  t2814 = t925 * t224;
  t2816 = t220 * t2814 * t543;
  t2817 = t2816 * t2364;
  t2819 = t925 * t562;
  t2821 = t538 * t2819 * t543;
  t2822 = t2821 * t2368;
  t2824 = t2821 * t2357;
  t2828 = t1417 * t2793;
  t2830 = 0.2e1 * t765 * t553 * t2804 + 0.2e1 * t776 * t2068 - 0.2e1 * t2794 * t2319 - 0.3e1 * t2811 * t2324 - t2333 * t2800 + 0.3e1 * t2811 * t2392 - t2828 * t2392 + t2329 + t2339 - t2342 - t2807 + 0.3e1 * t2817 - 0.3e1 * t2822 - 0.3e1 * t2824 - t828 - t932;
  t2833 = t571 * t769;
  t2839 = t538 * t2814;
  t2840 = t2839 * t2420;
  t2845 = t553 * t554 * t769;
  t2850 = t220 * t2819;
  t2851 = t2850 * t2384;
  t2862 = -0.2e1 * t776 * t570 * t2833 + 0.3e1 * t2811 * t2376 - 0.3e1 * t2828 * t2376 + 0.3e1 * t2828 * t2388 - t2794 * t2392 - 0.3e1 * t2794 * t2401 + 0.3e1 * t2811 * t2401 - 0.2e1 * t2828 * t2415 + 0.3e1 * t2828 * t2424 + 0.2e1 * t765 * t2845 - 0.2e1 * t776 * t2845 - t2381 + t2397 - t2398 + 0.3e1 * t2840 + 0.3e1 * t2851;
  t2864 = my_piecewise5(t104, 0, t105, 0, t2830 + t2862);
  t2866 = -0.25e2 / 0.81e2 * t875 + 0.5e1 / 0.27e2 * t38 * t98 * t780 + t218 * t938 + t103 * t2864;
  t2871 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t940 + t2775 + 0.3e1 / 0.2e2 * t7 * t88 * t2866);
  tv3rholapl25 = t8 * t2871 + t944;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2874 = t38 * t43 * t809;
  t2876 = t792 * t248;
  t2877 = t2876 * t1015;
  t2878 = t151 * t2877;
  t2881 = t799 * t248;
  t2883 = t151 * t2881 * t385;
  t2884 = 0.3e1 * t2883;
  t2885 = t1042 * t2877;
  t2890 = t621 * t2196;
  t2891 = 0.3e1 * t2890;
  t2894 = t359 * t2877;
  t2897 = t2178 * t857;
  t2898 = 0.3e1 * t2897;
  t2899 = t2876 * t383;
  t2900 = t151 * t2899;
  t2901 = t2900 * t1031;
  t2902 = 0.3e1 * t2901;
  t2903 = t2876 * t155;
  t2905 = t359 * t2903 * t1037;
  t2906 = 0.3e1 * t2905;
  t2912 = -0.3e1 * t2878 * t1021 + 0.3e1 * t2885 * t1045 - t2878 * t1050 + 0.3e1 * t2894 * t1050 - 0.3e1 * t2885 * t1061 + 0.3e1 * t2894 * t1061 - 0.2e1 * t2885 * t1069 + 0.3e1 * t2885 * t1077 - t2884 + t2891 + t2898 + t2902 + t2906;
  t2924 = t375 * t799;
  t2925 = t374 * t2924;
  t2926 = t606 * t2925;
  t2927 = 0.3e1 * t2926;
  t2928 = t2246 * t851;
  t2929 = 0.3e1 * t2928;
  t2930 = t359 * t2899;
  t2931 = t2930 * t1103;
  t2932 = 0.3e1 * t2931;
  t2934 = t151 * t2903 * t1108;
  t2935 = 0.3e1 * t2934;
  t2936 = t2246 * t861;
  t2937 = 0.3e1 * t2936;
  t2938 = t2930 * t1090;
  t2939 = 0.3e1 * t2938;
  t2940 = -t1042 * t2876 * t1114 - 0.2e1 * t151 * t2876 * t1121 - 0.3e1 * t359 * t2876 * t1125 + 0.3e1 * t2894 * t1021 - t2885 * t1050 + t2927 - t2929 - t2932 + t2935 - t2937 - t2939 - t801 - t803;
  t2942 = my_piecewise5(t58, 0, t61, 0, t2912 + t2940);
  t2944 = -0.5e1 / 0.27e2 * t2874 + t53 * t2942;
  t2948 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t2944);
  tv3sigma30 = t8 * t2948;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2950 = t38 * t93 * t836;
  t2952 = t819 * t265;
  t2953 = t2952 * t1418;
  t2954 = t220 * t2953;
  t2957 = t1417 * t2953;
  t2962 = t684 * t2338;
  t2963 = 0.3e1 * t2962;
  t2966 = t538 * t2953;
  t2969 = t826 * t265;
  t2971 = t220 * t2969 * t564;
  t2972 = 0.3e1 * t2971;
  t2973 = t2952 * t562;
  t2974 = t220 * t2973;
  t2975 = t2974 * t1412;
  t2976 = 0.3e1 * t2975;
  t2977 = t2952 * t224;
  t2979 = t538 * t2977 * t1402;
  t2980 = 0.3e1 * t2979;
  t2981 = t2328 * t885;
  t2982 = 0.3e1 * t2981;
  t2988 = 0.3e1 * t2957 * t1424 - t2957 * t1430 + 0.3e1 * t2966 * t1430 - 0.3e1 * t2957 * t1437 + 0.3e1 * t2966 * t1437 - 0.2e1 * t2957 * t1445 + 0.3e1 * t2957 * t1453 - 0.3e1 * t2954 * t1464 + t2963 - t2972 + t2976 + t2980 + t2982;
  t3000 = t554 * t826;
  t3001 = t553 * t3000;
  t3002 = t669 * t3001;
  t3003 = 0.3e1 * t3002;
  t3004 = t2380 * t879;
  t3005 = 0.3e1 * t3004;
  t3006 = t538 * t2973;
  t3007 = t3006 * t1487;
  t3008 = 0.3e1 * t3007;
  t3010 = t220 * t2977 * t1492;
  t3011 = 0.3e1 * t3010;
  t3012 = t2380 * t889;
  t3013 = 0.3e1 * t3012;
  t3014 = t3006 * t1479;
  t3015 = 0.3e1 * t3014;
  t3016 = -t1417 * t2952 * t1498 - 0.3e1 * t538 * t2952 * t1505 - 0.2e1 * t220 * t2952 * t1509 - t2954 * t1430 + 0.3e1 * t2966 * t1464 + t3003 - t3005 - t3008 + t3011 - t3013 - t3015 - t828 - t830;
  t3018 = my_piecewise5(t104, 0, t105, 0, t2988 + t3016);
  t3020 = -0.5e1 / 0.27e2 * t2950 + t103 * t3018;
  t3024 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3020);
  tv3sigma39 = t8 * t3024;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3029 = t38 * t43 * t864;
  t3033 = t158 * t799;
  t3034 = t374 * t3033;
  t3035 = t714 * t3034;
  t3036 = t2246 * t711;
  t3038 = t281 * t799;
  t3040 = t151 * t3038 * t385;
  t3041 = t158 * t792;
  t3042 = t1020 * t3041;
  t3045 = 0.2e1 * t2883;
  t3046 = 0.2e1 * t2890;
  t3047 = 0.2e1 * t2897;
  t3048 = t281 * t792;
  t3049 = t3048 * t383;
  t3050 = t359 * t3049;
  t3051 = t3050 * t1103;
  t3052 = 0.3e1 * t3051;
  t3053 = params->csk_a * t792;
  t3054 = t3053 * t383;
  t3055 = t159 * t3054;
  t3056 = t1968 * t3055;
  t3057 = 0.3e1 * t3056;
  t3058 = t3050 * t1090;
  t3059 = 0.3e1 * t3058;
  t3061 = t792 * t68 * t158;
  t3062 = t1060 * t3061;
  t3066 = -t2235 * t1910 - 0.2e1 * t1913 * t3042 - 0.3e1 * t2172 * t1916 + 0.3e1 * t1923 * t3062 - t1931 * t3062 + t3035 + t3036 - t3040 - t3045 + t3046 + t3047 - t3052 + t3057 - t3059 - t801 - t855;
  t3069 = t714 * t2925;
  t3070 = t1596 * t792;
  t3071 = t1044 * t3070;
  t3074 = t1601 * t3061;
  t3082 = t725 * t2925;
  t3085 = t392 * t799;
  t3086 = t391 * t3085;
  t3087 = t725 * t3086;
  t3088 = t1068 * t792;
  t3089 = t1065 * t3088;
  t3092 = t151 * t3048;
  t3093 = t3092 * t1631;
  t3094 = 0.3e1 * t3093;
  t3095 = t2267 * t1946;
  t3096 = 0.3e1 * t3095;
  t3097 = 0.2e1 * t2926;
  t3098 = 0.2e1 * t2928;
  t3099 = 0.2e1 * t2936;
  t3100 = -t1913 * t3062 - 0.3e1 * t1913 * t3074 + 0.3e1 * t1923 * t3071 + 0.3e1 * t1923 * t3074 - 0.3e1 * t1931 * t3071 - 0.2e1 * t1931 * t3089 + 0.3e1 * t2235 * t1934 + 0.3e1 * t2235 * t1977 + t3069 - t3082 - t3087 + t3094 + t3096 + t3097 - t3098 - t3099;
  t3102 = my_piecewise5(t58, 0, t61, 0, t3066 + t3100);
  t3104 = 0.5e1 / 0.54e2 * t38 * t48 * t809 - 0.1e2 / 0.81e2 * t3029 + t53 * t3102;
  t3108 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3104);
  tv3sigma2lapl0 = t8 * t3108;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3113 = t38 * t93 * t892;
  t3115 = t227 * t819;
  t3116 = t1428 * t3115;
  t3121 = t227 * t826;
  t3122 = t553 * t3121;
  t3123 = t765 * t3122;
  t3124 = t2380 * t762;
  t3128 = t220 * t297 * t826 * t564;
  t3129 = 0.2e1 * t2962;
  t3130 = 0.2e1 * t2971;
  t3131 = 0.2e1 * t2981;
  t3132 = t297 * t819;
  t3133 = t3132 * t562;
  t3134 = t538 * t3133;
  t3135 = t3134 * t1487;
  t3136 = 0.3e1 * t3135;
  t3137 = params->csk_a * t819;
  t3138 = t3137 * t562;
  t3139 = t228 * t3138;
  t3140 = t2100 * t3139;
  t3141 = 0.3e1 * t3140;
  t3142 = t3134 * t1479;
  t3143 = 0.3e1 * t3142;
  t3145 = t819 * t112 * t227;
  t3146 = t1463 * t3145;
  t3151 = -t2387 * t2072 - 0.3e1 * t2322 * t2081 - 0.2e1 * t2085 * t3116 - 0.3e1 * t2085 * t3146 + 0.3e1 * t2118 * t3146 + t3123 + t3124 - t3128 + t3129 - t3130 + t3131 - t3136 + t3141 - t3143 - t828 - t883;
  t3154 = t1429 * t819;
  t3155 = t1428 * t3154;
  t3160 = t776 * t3001;
  t3163 = t1436 * t819 * t545 * t547;
  t3166 = t571 * t826;
  t3167 = t570 * t3166;
  t3168 = t776 * t3167;
  t3169 = t1444 * t819;
  t3170 = t1441 * t3169;
  t3175 = t765 * t3001;
  t3178 = t2418 * t2122;
  t3179 = 0.3e1 * t3178;
  t3180 = t220 * t3132;
  t3181 = t3180 * t1819;
  t3182 = 0.3e1 * t3181;
  t3183 = 0.2e1 * t3002;
  t3184 = 0.2e1 * t3004;
  t3185 = 0.2e1 * t3012;
  t3186 = -t2085 * t3155 - t2111 * t3155 - 0.3e1 * t2111 * t3163 - 0.2e1 * t2111 * t3170 + 0.3e1 * t2387 * t2114 + 0.3e1 * t2118 * t3155 + 0.3e1 * t2118 * t3163 + 0.3e1 * t2387 * t2129 - t3160 - t3168 + t3175 + t3179 + t3182 + t3183 - t3184 - t3185;
  t3188 = my_piecewise5(t104, 0, t105, 0, t3151 + t3186);
  t3190 = 0.5e1 / 0.54e2 * t38 * t98 * t836 - 0.1e2 / 0.81e2 * t3113 + t103 * t3188;
  t3194 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3190);
  tv3sigma2lapl11 = t8 * t3194;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3199 = t38 * t43 * t915;
  t3207 = 0.2e1 * t3035;
  t3208 = 0.2e1 * t3036;
  t3209 = 0.2e1 * t3040;
  t3210 = params->csk_a * t248;
  t3211 = t3210 * t155;
  t3213 = t2718 * t369 * t3211;
  t3214 = 0.3e1 * t3213;
  t3216 = t2718 * t3210 * t1102;
  t3217 = 0.3e1 * t3216;
  t3218 = t3210 * t383;
  t3220 = t2713 * t159 * t3218;
  t3221 = 0.3e1 * t3220;
  t3222 = t1060 * t2482;
  t3226 = -0.2e1 * t2705 * t1020 * t856 - 0.3e1 * t2708 * t1575 - t1613 * t2702 + 0.3e1 * t2735 * t1616 - t2735 * t3222 - t2883 + t2890 + t2897 + t3207 + t3208 - t3209 - t3214 - t3217 + t3221 - t801 - t909;
  t3230 = t1601 * t2482;
  t3233 = t1068 * t248;
  t3237 = t1596 * t248;
  t3238 = t1044 * t3237;
  t3243 = t2730 * t374 * t856 * t155;
  t3244 = 0.3e1 * t3243;
  t3247 = t2754 * t1625;
  t3248 = 0.3e1 * t3247;
  t3253 = 0.2e1 * t3069;
  t3254 = 0.2e1 * t3082;
  t3255 = 0.2e1 * t3087;
  t3256 = -0.2e1 * t2735 * t1065 * t3233 + 0.3e1 * t2735 * t1589 - t2705 * t3222 - 0.3e1 * t2705 * t3230 + 0.3e1 * t2708 * t3222 + 0.3e1 * t2708 * t3230 + 0.3e1 * t2708 * t3238 - 0.3e1 * t2735 * t3238 + t2926 - t2928 - t2936 + t3244 + t3248 + t3253 - t3254 - t3255;
  t3258 = my_piecewise5(t58, 0, t61, 0, t3226 + t3256);
  t3260 = 0.5e1 / 0.27e2 * t38 * t48 * t864 - 0.5e1 / 0.81e2 * t3199 + t53 * t3258;
  t3264 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3260);
  tv3sigmalapl20 = t8 * t3264;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3269 = t38 * t93 * t938;
  t3277 = 0.2e1 * t3123;
  t3278 = 0.2e1 * t3124;
  t3279 = 0.2e1 * t3128;
  t3280 = params->csk_a * t265;
  t3281 = t3280 * t562;
  t3283 = t2816 * t228 * t3281;
  t3284 = 0.3e1 * t3283;
  t3285 = t3280 * t224;
  t3287 = t2821 * t548 * t3285;
  t3288 = 0.3e1 * t3287;
  t3290 = t2821 * t3280 * t1486;
  t3291 = 0.3e1 * t3290;
  t3292 = t1463 * t2608;
  t3297 = -0.2e1 * t2794 * t1428 * t884 - 0.3e1 * t2811 * t1752 - t1814 * t2800 + 0.3e1 * t2828 * t1839 + 0.3e1 * t2811 * t3292 + t2962 - t2971 + t2981 + t3277 + t3278 - t3279 + t3284 - t3288 - t3291 - t828 - t932;
  t3302 = t1429 * t265;
  t3303 = t1428 * t3302;
  t3308 = t1444 * t265;
  t3312 = t1788 * t265;
  t3313 = t1423 * t3312;
  t3318 = t2850 * t553 * t884 * t224;
  t3319 = 0.3e1 * t3318;
  t3322 = t2839 * t1825;
  t3323 = 0.3e1 * t3322;
  t3324 = 0.2e1 * t3160;
  t3325 = 0.2e1 * t3168;
  t3326 = 0.2e1 * t3175;
  t3327 = -0.2e1 * t2828 * t1441 * t3308 + 0.3e1 * t2828 * t1806 - 0.3e1 * t2794 * t3292 - t2794 * t3303 + 0.3e1 * t2811 * t3303 + 0.3e1 * t2811 * t3313 - t2828 * t3303 - 0.3e1 * t2828 * t3313 + t3002 - t3004 - t3012 + t3319 + t3323 - t3324 - t3325 + t3326;
  t3329 = my_piecewise5(t104, 0, t105, 0, t3297 + t3327);
  t3331 = 0.5e1 / 0.27e2 * t38 * t98 * t892 - 0.5e1 / 0.81e2 * t3269 + t103 * t3329;
  t3335 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3331);
  tv3sigmalapl28 = t8 * t3335;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3339 = t902 * t281;
  t3340 = t3339 * t1015;
  t3341 = t1042 * t3340;
  t3348 = t359 * t3340;
  t3351 = t3339 * t383;
  t3352 = t151 * t3351;
  t3353 = t3352 * t1031;
  t3354 = 0.3e1 * t3353;
  t3355 = t3339 * t155;
  t3357 = t359 * t3355 * t1037;
  t3358 = 0.3e1 * t3357;
  t3359 = t151 * t3340;
  t3370 = 0.3e1 * t3035;
  t3371 = 0.3e1 * t3348 * t1021 - 0.3e1 * t3359 * t1021 + 0.3e1 * t3341 * t1045 - t3341 * t1050 + 0.3e1 * t3348 * t1050 - t3359 * t1050 - 0.3e1 * t3341 * t1061 + 0.3e1 * t3348 * t1061 - 0.2e1 * t3341 * t1069 + 0.3e1 * t3341 * t1077 + t3354 + t3358 + t3370;
  t3372 = 0.3e1 * t3036;
  t3373 = 0.3e1 * t3040;
  t3374 = t359 * t3351;
  t3375 = t3374 * t1103;
  t3376 = 0.3e1 * t3375;
  t3377 = t3374 * t1090;
  t3378 = 0.3e1 * t3377;
  t3380 = t151 * t3355 * t1108;
  t3381 = 0.3e1 * t3380;
  t3382 = 0.3e1 * t3069;
  t3383 = 0.3e1 * t3082;
  t3384 = 0.3e1 * t3087;
  t3393 = -t1042 * t3339 * t1114 - 0.2e1 * t151 * t3339 * t1121 - 0.3e1 * t359 * t3339 * t1125 + t3372 - t3373 - t3376 - t3378 + t3381 + t3382 - t3383 - t3384 - t801 - t909;
  t3395 = my_piecewise5(t58, 0, t61, 0, t3371 + t3393);
  t3397 = 0.5e1 / 0.18e2 * t38 * t48 * t915 + t53 * t3395;
  t3401 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3397);
  tv3lapl30 = t8 * t3401;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3405 = 0.3e1 * t3123;
  t3406 = 0.3e1 * t3124;
  t3407 = 0.3e1 * t3128;
  t3408 = t925 * t297;
  t3409 = t3408 * t562;
  t3410 = t538 * t3409;
  t3411 = t3410 * t1479;
  t3412 = 0.3e1 * t3411;
  t3413 = t3408 * t224;
  t3415 = t220 * t3413 * t1492;
  t3416 = 0.3e1 * t3415;
  t3417 = t3410 * t1487;
  t3418 = 0.3e1 * t3417;
  t3419 = 0.3e1 * t3160;
  t3420 = 0.3e1 * t3168;
  t3421 = 0.3e1 * t3175;
  t3428 = -0.3e1 * t538 * t3408 * t1505 - 0.2e1 * t220 * t3408 * t1509 + t3405 + t3406 - t3407 - t3412 + t3416 - t3418 - t3419 - t3420 + t3421 - t828 - t932;
  t3431 = t3408 * t1418;
  t3432 = t538 * t3431;
  t3435 = t1417 * t3431;
  t3445 = t538 * t3413 * t1402;
  t3446 = 0.3e1 * t3445;
  t3447 = t220 * t3409;
  t3448 = t3447 * t1412;
  t3449 = 0.3e1 * t3448;
  t3450 = t220 * t3431;
  t3459 = -t1417 * t3408 * t1498 + 0.3e1 * t3435 * t1424 + 0.3e1 * t3432 * t1430 - t3435 * t1430 - t3450 * t1430 + 0.3e1 * t3432 * t1437 - 0.3e1 * t3435 * t1437 - 0.2e1 * t3435 * t1445 + 0.3e1 * t3435 * t1453 + 0.3e1 * t3432 * t1464 - 0.3e1 * t3450 * t1464 + t3446 + t3449;
  t3461 = my_piecewise5(t104, 0, t105, 0, t3428 + t3459);
  t3463 = 0.5e1 / 0.18e2 * t38 * t98 * t938 + t103 * t3461;
  t3467 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3463);
  tv3lapl33 = t8 * t3467;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  double t122, t123, t124, t126, t129, t130, t134, t135;
  double t138, t141, t143, t149, t151, t152, t153, t155;
  double t156, t158, t159, t160, t162, t164, t169, t170;
  double t172, t175, t176, t180, t183, t185, tvrho0, t189;
  double t192, t193, t198, t200, t203, t204, t210, t212;
  double t218, t220, t221, t222, t224, t225, t227, t228;
  double t229, t231, t233, t238, tvrho1, t241, t244, t247;
  double t248, t251, t253, t257, tvsigma0, tvsigma1, t258, t261;
  double t264, t265, t268, t270, t274, tvsigma2, t280, t281;
  double t284, t286, t290, tvlapl0, t296, t297, t300, t302;
  double t306, tvlapl1, tvtau0, tvtau1;

  double t309, t310, t313, t314, t315, t318, t322, t323;
  double t327, t329, t335, t336, t339, t341, t343, t345;
  double t347, t353, t357, t359, t360, t362, t363, t364;
  double t365, t366, t367, t368, t369, t370, t372, t374;
  double t375, t376, t378, t379, t382, t383, t385, t386;
  double t387, t389, t391, t392, t393, t396, t398, t403;
  double t404, t405, t408, t411, t415, t416, t420, t422;
  double t424, t427, t429, tv2rho20, t432, t436, t440, t441;
  double t445, t447, t455, t456, t460, t464, t465, t469;
  double t471, t478, t481, tv2rho21, t486, t491, t495, t496;
  double t502, t503, t508, t512, t513, t522, t524, t526;
  double t532, t536, t538, t539, t541, t542, t543, t544;
  double t545, t546, t547, t548, t549, t551, t553, t554;
  double t555, t557, t558, t561, t562, t564, t565, t566;
  double t568, t570, t571, t572, t575, t577, t582, tv2rho22;
  double t590, t591, t594, t597, t600, t601, t602, t603;
  double t605, t606, t608, t611, t612, t615, t617, t618;
  double t619, t621, t623, t624, t627, t629, t634, tv2rhosigma0;
  double tv2rhosigma1, t641, t643, tv2rhosigma2, t649, tv2rhosigma3, tv2rhosigma4, t654;
  double t657, t660, t663, t664, t665, t666, t668, t669;
  double t671, t674, t675, t678, t680, t681, t682, t684;
  double t686, t687, t690, t692, t697, tv2rhosigma5, t704, t710;
  double t711, t713, t714, t717, t718, t721, t723, t725;
  double t729, t731, t736, tv2rholapl0, t743, t745, tv2rholapl1, t751;
  double tv2rholapl2, t761, t762, t764, t765, t768, t769, t772;
  double t774, t776, t780, t782, t787, tv2rholapl3, tv2rhotau0, tv2rhotau1;
  double tv2rhotau2, tv2rhotau3, t790, t792, t795, t798, t799, t801;
  double t802, t803, t805, t809, t811, t815, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t817, t819, t822, t823, t825;
  double t826, t828, t829, t830, t832, t836, t838, t842;
  double tv2sigma25, t847, t850, t851, t853, t854, t855, t856;
  double t857, t860, t861, t864, t866, t870, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t875, t878, t879, t881, t882;
  double t883, t884, t885, t888, t889, t892, t894, t898;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t902;
  double t905, t906, t908, t909, t911, t915, t917, t921;
  double tv2lapl20, tv2lapl21, t925, t928, t931, t932, t934, t938;
  double t940, t944, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  double t948, t949, t952, t955, t956, t957, t960, t964;
  double t965, t969, t971, t976, t978, t981, t987, t988;
  double t991, t993, t996, t1000, t1002, t1008, t1014, t1015;
  double t1016, t1017, t1019, t1020, t1021, t1024, t1028, t1030;
  double t1031, t1032, t1034, t1036, t1037, t1038, t1042, t1043;
  double t1044, t1045, t1048, t1049, t1050, t1052, t1058, t1060;
  double t1061, t1064, t1065, t1067, t1068, t1069, t1072, t1076;
  double t1077, t1080, t1085, t1088, t1090, t1091, t1094, t1095;
  double t1100, t1102, t1103, t1104, t1107, t1108, t1109, t1112;
  double t1113, t1114, t1116, t1117, t1121, t1125, t1128, t1130;
  double t1132, t1137, t1139, t1140, t1143, t1146, t1149, t1153;
  double t1154, t1158, t1160, t1162, t1164, t1166, t1169, t1171;
  double tv3rho30, t1174, t1175, t1176, t1179, t1184, t1185, t1187;
  double t1191, t1192, t1196, t1199, t1203, t1205, t1209, t1218;
  double t1219, t1220, t1223, t1228, t1230, t1234, t1235, t1239;
  double t1242, t1243, t1245, t1254, t1256, t1259, tv3rho31, t1262;
  double t1267, t1271, t1275, t1276, t1280, t1282, t1291, t1292;
  double t1297, t1301, t1305, t1306, t1310, t1312, t1319, t1327;
  double t1329, t1330, tv3rho32, t1335, t1342, t1346, t1347, t1354;
  double t1355, t1362, t1366, t1367, t1384, t1386, t1392, t1398;
  double t1399, t1401, t1402, t1403, t1405, t1409, t1411, t1412;
  double t1413, t1417, t1418, t1419, t1420, t1422, t1423, t1424;
  double t1427, t1428, t1429, t1430, t1432, t1436, t1437, t1440;
  double t1441, t1443, t1444, t1445, t1448, t1452, t1453, t1458;
  double t1460, t1462, t1463, t1464, t1470, t1471, t1474, t1477;
  double t1479, t1480, t1484, t1486, t1487, t1488, t1491, t1492;
  double t1493, t1496, t1497, t1498, t1500, t1501, t1505, t1509;
  double t1512, t1514, t1516, t1521, tv3rho33, t1529, t1536, t1538;
  double t1540, t1543, t1546, t1549, t1554, t1556, t1558, t1560;
  double t1561, t1562, t1565, t1566, t1569, t1570, t1571, t1574;
  double t1575, t1578, t1579, t1580, t1581, t1584, t1585, t1588;
  double t1589, t1595, t1596, t1597, t1598, t1601, t1603, t1604;
  double t1607, t1610, t1613, t1614, t1616, t1623, t1624, t1625;
  double t1626, t1628, t1631, t1632, t1634, t1635, t1643, t1644;
  double t1647, t1648, t1651, t1652, t1653, t1655, t1657, t1658;
  double t1659, t1661, t1662, t1663, t1665, t1667, t1669, t1674;
  double tv3rho2sigma0, tv3rho2sigma1, t1681, t1685, t1687, tv3rho2sigma2, t1693, t1701;
  double tv3rho2sigma3, tv3rho2sigma4, t1707, t1714, t1717, tv3rho2sigma5, t1725, tv3rho2sigma6;
  double tv3rho2sigma7, t1736, t1739, t1742, t1745, t1750, t1751, t1752;
  double t1755, t1756, t1759, t1761, t1763, t1765, t1766, t1767;
  double t1770, t1771, t1774, t1775, t1778, t1779, t1780, t1781;
  double t1787, t1788, t1789, t1790, t1793, t1797, t1798, t1803;
  double t1806, t1810, t1814, t1816, t1819, t1820, t1823, t1824;
  double t1825, t1826, t1831, t1832, t1834, t1835, t1838, t1839;
  double t1843, t1844, t1847, t1848, t1849, t1851, t1852, t1853;
  double t1855, t1856, t1857, t1859, t1861, t1863, t1865, t1870;
  double tv3rho2sigma8, t1877, t1884, t1886, t1896, t1898, t1900, t1902;
  double t1905, t1906, t1909, t1910, t1912, t1913, t1916, t1919;
  double t1920, t1923, t1926, t1931, t1933, t1934, t1938, t1941;
  double t1943, t1945, t1946, t1947, t1958, t1959, t1963, t1964;
  double t1967, t1968, t1969, t1971, t1976, t1977, t1982, t1984;
  double t1986, t1991, tv3rho2lapl0, t1998, t2002, t2004, tv3rho2lapl1, t2010;
  double t2018, tv3rho2lapl2, t2024, t2031, t2034, tv3rho2lapl3, t2042, tv3rho2lapl4;
  double t2061, t2062, t2067, t2068, t2071, t2072, t2074, t2076;
  double t2078, t2080, t2081, t2084, t2085, t2089, t2090, t2093;
  double t2094, t2095, t2096, t2099, t2100, t2101, t2103, t2105;
  double t2110, t2111, t2113, t2114, t2118, t2121, t2122, t2123;
  double t2126, t2128, t2129, t2147, t2149, t2151, t2156, tv3rho2lapl5;
  double tv3rho2tau0, tv3rho2tau1, tv3rho2tau2, tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2163, t2165;
  double t2168, t2171, t2172, t2173, t2174, t2177, t2178, t2179;
  double t2180, t2181, t2184, t2185, t2190, t2191, t2192, t2193;
  double t2195, t2196, t2197, t2198, t2200, t2201, t2202, t2203;
  double t2205, t2206, t2207, t2209, t2210, t2211, t2212, t2213;
  double t2215, t2217, t2218, t2219, t2220, t2222, t2223, t2225;
  double t2227, t2228, t2230, t2231, t2234, t2235, t2236, t2239;
  double t2240, t2245, t2246, t2247, t2249, t2250, t2255, t2256;
  double t2259, t2260, t2263, t2264, t2267, t2268, t2269, t2270;
  double t2272, t2273, t2280, t2281, t2283, t2285, t2290, tv3rhosigma20;
  double tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2297, t2299, tv3rhosigma25, t2305;
  double tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t2311, t2314, t2317;
  double t2318, t2319, t2322, t2323, t2324, t2327, t2328, t2329;
  double t2332, t2333, t2334, t2335, t2337, t2338, t2339, t2340;
  double t2342, t2343, t2344, t2345, t2346, t2348, t2349, t2350;
  double t2353, t2355, t2356, t2357, t2358, t2360, t2362, t2363;
  double t2364, t2365, t2367, t2368, t2369, t2371, t2372, t2375;
  double t2376, t2379, t2380, t2381, t2382, t2384, t2385, t2387;
  double t2388, t2391, t2392, t2397, t2398, t2400, t2401, t2410;
  double t2411, t2414, t2415, t2418, t2419, t2420, t2421, t2423;
  double t2424, t2427, t2429, t2431, t2436, tv3rhosigma211, t2443, t2449;
  double t2452, t2457, t2459, t2460, t2462, t2465, t2466, t2468;
  double t2469, t2471, t2472, t2473, t2474, t2476, t2477, t2478;
  double t2480, t2481, t2482, t2483, t2486, t2489, t2490, t2491;
  double t2492, t2493, t2496, t2497, t2498, t2502, t2503, t2505;
  double t2508, t2511, t2512, t2516, t2517, t2518, t2519, t2521;
  double t2527, t2528, t2532, t2537, t2538, t2541, t2543, t2545;
  double t2550, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2557, t2559;
  double tv3rhosigmalapl5, t2565, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2575;
  double t2578, t2583, t2585, t2586, t2588, t2591, t2592, t2594;
  double t2595, t2597, t2598, t2600, t2602, t2603, t2604, t2606;
  double t2607, t2608, t2609, t2612, t2615, t2616, t2617, t2618;
  double t2619, t2622, t2623, t2624, t2628, t2629, t2631, t2632;
  double t2635, t2638, t2640, t2641, t2643, t2648, t2649, t2652;
  double t2655, t2656, t2663, t2664, t2668, t2670, t2672, t2677;
  double tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6;
  double tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t2684, t2690, t2691;
  double t2692, t2694, t2695, t2701, t2702, t2704, t2705, t2708;
  double t2711, t2713, t2714, t2716, t2718, t2719, t2721, t2724;
  double t2729, t2730, t2731, t2735, t2748, t2754, t2755, t2759;
  double t2761, t2763, t2768, tv3rholapl20, tv3rholapl21, t2775, t2777, tv3rholapl22;
  double t2783, tv3rholapl23, tv3rholapl24, t2793, t2794, t2799, t2800, t2802;
  double t2803, t2804, t2806, t2807, t2811, t2814, t2816, t2817;
  double t2819, t2821, t2822, t2824, t2828, t2830, t2833, t2839;
  double t2840, t2845, t2850, t2851, t2862, t2864, t2866, t2871;
  double tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2874;
  double t2876, t2877, t2878, t2881, t2883, t2884, t2885, t2890;
  double t2891, t2894, t2897, t2898, t2899, t2900, t2901, t2902;
  double t2903, t2905, t2906, t2912, t2924, t2925, t2926, t2927;
  double t2928, t2929, t2930, t2931, t2932, t2934, t2935, t2936;
  double t2937, t2938, t2939, t2940, t2942, t2944, t2948, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t2950, t2952, t2953, t2954, t2957, t2962, t2963, t2966;
  double t2969, t2971, t2972, t2973, t2974, t2975, t2976, t2977;
  double t2979, t2980, t2981, t2982, t2988, t3000, t3001, t3002;
  double t3003, t3004, t3005, t3006, t3007, t3008, t3010, t3011;
  double t3012, t3013, t3014, t3015, t3016, t3018, t3020, t3024;
  double tv3sigma39, t3029, t3033, t3034, t3035, t3036, t3038, t3040;
  double t3041, t3042, t3045, t3046, t3047, t3048, t3049, t3050;
  double t3051, t3052, t3053, t3054, t3055, t3056, t3057, t3058;
  double t3059, t3061, t3062, t3066, t3069, t3070, t3071, t3074;
  double t3082, t3085, t3086, t3087, t3088, t3089, t3092, t3093;
  double t3094, t3095, t3096, t3097, t3098, t3099, t3100, t3102;
  double t3104, t3108, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5;
  double tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t3113, t3115, t3116;
  double t3121, t3122, t3123, t3124, t3128, t3129, t3130, t3131;
  double t3132, t3133, t3134, t3135, t3136, t3137, t3138, t3139;
  double t3140, t3141, t3142, t3143, t3145, t3146, t3151, t3154;
  double t3155, t3160, t3163, t3166, t3167, t3168, t3169, t3170;
  double t3175, t3178, t3179, t3180, t3181, t3182, t3183, t3184;
  double t3185, t3186, t3188, t3190, t3194, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1;
  double tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9;
  double tv3sigma2tau10, tv3sigma2tau11, t3199, t3207, t3208, t3209, t3210, t3211;
  double t3213, t3214, t3216, t3217, t3218, t3220, t3221, t3222;
  double t3226, t3230, t3233, t3237, t3238, t3243, t3244, t3247;
  double t3248, t3253, t3254, t3255, t3256, t3258, t3260, t3264;
  double tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27;
  double t3269, t3277, t3278, t3279, t3280, t3281, t3283, t3284;
  double t3285, t3287, t3288, t3290, t3291, t3292, t3297, t3302;
  double t3303, t3308, t3312, t3313, t3318, t3319, t3322, t3323;
  double t3324, t3325, t3326, t3327, t3329, t3331, t3335, tv3sigmalapl28;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23;
  double tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t3339, t3340, t3341;
  double t3348, t3351, t3352, t3353, t3354, t3355, t3357, t3358;
  double t3359, t3370, t3371, t3372, t3373, t3374, t3375, t3376;
  double t3377, t3378, t3380, t3381, t3382, t3383, t3384, t3393;
  double t3395, t3397, t3401, tv3lapl30, tv3lapl31, tv3lapl32, t3405, t3406;
  double t3407, t3408, t3409, t3410, t3411, t3412, t3413, t3415;
  double t3416, t3417, t3418, t3419, t3420, t3421, t3428, t3431;
  double t3432, t3435, t3445, t3446, t3447, t3448, t3449, t3450;
  double t3459, t3461, t3463, t3467, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  double t3471, t3474, t3480, t3486, t3500, t3501, t3502, t3511;
  double t3515, t3516, t3519, t3520, t3523, t3524, t3525, t3528;
  double t3530, t3534, t3537, t3540, t3542, t3545, t3547, t3557;
  double t3561, t3562, t3566, t3569, t3571, t3575, t3581, t3587;
  double t3594, t3599, t3602, t3605, t3606, t3614, t3615, t3616;
  double t3617, t3620, t3621, t3624, t3625, t3626, t3627, t3628;
  double t3632, t3635, t3638, t3640, t3642, t3643, t3644, t3645;
  double t3646, t3648, t3649, t3652, t3655, t3658, t3659, t3660;
  double t3661, t3664, t3667, t3668, t3671, t3672, t3673, t3680;
  double t3681, t3685, t3688, t3690, t3693, t3694, t3705, t3710;
  double t3714, t3721, t3724, t3727, t3728, t3731, t3732, t3738;
  double t3745, t3746, t3751, t3754, t3759, t3762, t3763, t3768;
  double t3769, t3770, t3785, t3789, t3795, t3797, t3798, t3804;
  double t3810, t3811, t3814, t3818, t3827, t3833, t3836, t3842;
  double t3846, t3850, t3854, t3857, t3861, t3862, t3863, t3864;
  double t3866, t3867, t3873, t3878, t3881, t3885, t3892, t3896;
  double t3900, t3905, t3907, tv4rho40, t3916, t3917, t3919, t3942;
  double t3943, t3945, t3949, t3958, t3966, t3970, t3971, t3974;
  double t3979, t3980, t3997, t3999, t4003, t4010, t4014, t4015;
  double t4018, t4027, t4030, t4031, t4033, t4035, t4036, tv4rho41;
  double t4045, t4049, t4059, t4072, t4076, t4085, t4101, t4102;
  double t4111, t4124, t4128, t4135, t4139, t4148, t4151, t4162;
  double t4165, t4167, t4168, tv4rho42, t4189, t4193, t4200, t4211;
  double t4212, t4229, t4233, t4240, t4248, t4257, t4267, t4269;
  double t4270, tv4rho43, t4275, t4280, t4287, t4291, t4300, t4308;
  double t4313, t4320, t4324, t4342, t4348, t4362, t4363, t4364;
  double t4373, t4374, t4375, t4377, t4381, t4384, t4388, t4391;
  double t4392, t4395, t4396, t4400, t4403, t4405, t4412, t4416;
  double t4421, t4427, t4430, t4432, t4435, t4436, t4439, t4442;
  double t4447, t4449, t4453, t4464, t4467, t4468, t4473, t4474;
  double t4475, t4476, t4479, t4480, t4481, t4482, t4483, t4486;
  double t4487, t4490, t4494, t4497, t4503, t4505, t4507, t4508;
  double t4509, t4510, t4511, t4513, t4514, t4518, t4519, t4522;
  double t4523, t4526, t4527, t4528, t4529, t4535, t4536, t4538;
  double t4545, t4550, t4554, t4561, t4562, t4565, t4568, t4571;
  double t4572, t4575, t4580, t4581, t4584, t4587, t4590, t4591;
  double t4601, t4602, t4603, t4606, t4612, t4621, t4624, t4633;
  double t4634, t4645, t4649, t4657, t4658, tv4rho44, t4666, t4672;
  double t4675, t4682, t4684, t4687, t4689, t4713, t4714, t4715;
  double t4718, t4722, t4725, t4726, t4727, t4728, t4732, t4733;
  double t4734, t4737, t4738, t4739, t4742, t4743, t4746, t4750;
  double t4751, t4754, t4755, t4758, t4761, t4762, t4764, t4767;
  double t4768, t4772, t4775, t4777, t4778, t4781, t4782, t4790;
  double t4795, t4798, t4800, t4806, t4813, t4817, t4818, t4824;
  double t4827, t4831, t4833, t4836, t4837, t4840, t4841, t4843;
  double t4844, t4847, t4848, t4850, t4853, t4854, t4859, t4862;
  double t4863, t4865, t4868, t4871, t4880, t4883, t4884, t4885;
  double t4890, t4893, t4894, t4898, t4901, t4906, t4915, t4916;
  double t4923, t4924, t4928, t4937, t4943, t4948, t4951, t4955;
  double t4958, t4961, t4965, t4968, t4973, t4980, t4982, t4993;
  double t4999, t5002, t5009, t5014, t5015, t5022, t5026, t5034;
  double t5035, t5046, t5052, t5055, t5073, t5077, t5084, tv4rho3sigma0;
  double tv4rho3sigma1, t5091, t5094, t5098, t5100, tv4rho3sigma2, t5102, t5108;
  double t5113, t5117, t5126, t5127, tv4rho3sigma3, tv4rho3sigma4, t5129, t5135;
  double t5137, t5146, t5148, t5151, tv4rho3sigma5, t5157, t5166, tv4rho3sigma6;
  double tv4rho3sigma7, t5172, t5179, t5187, t5189, t5190, tv4rho3sigma8, t5199;
  double tv4rho3sigma9, tv4rho3sigma10, t5216, t5239, t5240, t5244, t5245, t5246;
  double t5252, t5253, t5255, t5256, t5259, t5260, t5261, t5262;
  double t5266, t5267, t5268, t5271, t5274, t5275, t5277, t5280;
  double t5281, t5285, t5286, t5289, t5290, t5294, t5295, t5297;
  double t5300, t5305, t5308, t5310, t5315, t5316, t5321, t5329;
  double t5334, t5337, t5340, t5354, t5355, t5357, t5360, t5362;
  double t5365, t5366, t5367, t5370, t5374, t5377, t5382, t5383;
  double t5385, t5388, t5390, t5396, t5402, t5405, t5406, t5407;
  double t5410, t5411, t5414, t5418, t5421, t5424, t5427, t5432;
  double t5439, t5441, t5446, t5447, t5451, t5454, t5455, t5458;
  double t5464, t5468, t5473, t5476, t5481, t5484, t5487, t5488;
  double t5491, t5504, t5516, t5519, t5528, t5531, t5540, t5541;
  double t5548, t5552, t5557, t5560, t5566, t5575, t5581, t5584;
  double t5599, t5603, t5610, tv4rho3sigma11, t5617, t5623, t5626, t5633;
  double t5635, t5638, t5658, t5659, t5667, t5668, t5669, t5674;
  double t5677, t5678, t5681, t5688, t5689, t5695, t5696, t5705;
  double t5710, t5713, t5718, t5724, t5733, t5734, t5737, t5740;
  double t5743, t5744, t5747, t5752, t5755, t5758, t5765, t5768;
  double t5769, t5776, t5778, t5781, t5783, t5786, t5791, t5794;
  double t5798, t5802, t5805, t5814, t5817, t5823, t5832, t5839;
  double t5845, t5851, t5870, t5874, t5885, t5886, t5900, t5901;
  double t5904, t5914, t5917, t5920, t5924, t5938, t5942, t5949;
  double tv4rho3lapl0, t5956, t5959, t5963, t5965, tv4rho3lapl1, t5967, t5973;
  double t5978, t5982, t5991, t5992, tv4rho3lapl2, t5994, t6000, t6002;
  double t6011, t6013, t6016, tv4rho3lapl3, t6022, t6031, tv4rho3lapl4, t6037;
  double t6044, t6052, t6054, t6055, tv4rho3lapl5, t6064, tv4rho3lapl6, t6094;
  double t6096, t6097, t6100, t6106, t6107, t6109, t6114, t6115;
  double t6121, t6126, t6129, t6130, t6131, t6132, t6135, t6148;
  double t6149, t6150, t6155, t6166, t6167, t6170, t6177, t6188;
  double t6189, t6192, t6195, t6196, t6201, t6204, t6207, t6210;
  double t6213, t6216, t6219, t6220, t6227, t6230, t6232, t6237;
  double t6238, t6252, t6255, t6281, t6282, t6285, t6288, t6292;
  double t6300, t6305, t6307, t6313, t6317, t6323, t6327, t6328;
  double t6331, t6342, t6343, t6357, t6360, t6361, t6366, t6383;
  double t6391, t6394, t6397, t6401, t6408, tv4rho3lapl7, tv4rho3tau0, tv4rho3tau1;
  double tv4rho3tau2, tv4rho3tau3, tv4rho3tau4, tv4rho3tau5, tv4rho3tau6, tv4rho3tau7, t6415, t6422;
  double t6424, t6438, t6439, t6440, t6442, t6443, t6448, t6451;
  double t6452, t6453, t6454, t6455, t6456, t6459, t6465, t6468;
  double t6471, t6472, t6473, t6478, t6481, t6484, t6485, t6487;
  double t6488, t6490, t6501, t6502, t6507, t6510, t6517, t6518;
  double t6534, t6540, t6541, t6546, t6550, t6551, t6555, t6558;
  double t6561, t6562, t6564, t6565, t6566, t6568, t6571, t6574;
  double t6575, t6578, t6579, t6580, t6583, t6587, t6594, t6597;
  double t6600, t6601, t6602, t6607, t6610, t6613, t6615, t6618;
  double t6620, t6624, t6627, t6628, t6631, t6633, t6634, t6644;
  double t6646, t6651, t6652, t6655, t6657, t6659, t6661, t6663;
  double t6673, t6678, t6702, t6704, t6706, t6709, t6710, t6712;
  double t6719, t6721, t6722, t6724, t6725, t6729, t6734, t6735;
  double t6746, t6749, t6753, t6756, t6757, t6769, t6770, t6772;
  double t6773, t6774, t6778, t6780, t6783, t6786, t6798, t6802;
  double t6803, t6804, t6807, t6808, t6814, t6818, t6819, t6821;
  double t6822, t6825, t6830, t6834, t6841, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22;
  double tv4rho2sigma23, tv4rho2sigma24, t6848, t6852, t6854, tv4rho2sigma25, t6860, t6868;
  double tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t6874, t6881, t6884;
  double tv4rho2sigma211, t6892, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t6915;
  double t6916, t6917, t6919, t6923, t6928, t6929, t6933, t6936;
  double t6939, t6940, t6941, t6942, t6948, t6949, t6954, t6957;
  double t6960, t6964, t6970, t6971, t6972, t6977, t6983, t6986;
  double t6989, t6991, t6993, t6999, t7002, t7003, t7006, t7018;
  double t7026, t7032, t7033, t7035, t7036, t7037, t7038, t7042;
  double t7045, t7047, t7048, t7050, t7051, t7053, t7056, t7059;
  double t7060, t7061, t7068, t7072, t7075, t7077, t7079, t7080;
  double t7082, t7083, t7087, t7095, t7098, t7099, t7100, t7106;
  double t7115, t7118, t7124, t7134, t7139, t7148, t7151, t7152;
  double t7155, t7159, t7166, t7167, t7168, t7178, t7179, t7181;
  double t7183, t7185, t7187, t7202, t7203, t7204, t7207, t7211;
  double t7218, t7221, t7223, t7226, t7227, t7228, t7239, t7241;
  double t7242, t7245, t7249, t7253, t7257, t7258, t7261, t7264;
  double t7265, t7271, t7275, t7276, t7278, t7281, t7285, t7286;
  double t7287, t7290, t7291, t7295, t7300, t7303, t7307, t7314;
  double tv4rho2sigma217, t7321, t7328, t7330, t7359, t7360, t7361, t7364;
  double t7365, t7368, t7371, t7378, t7385, t7386, t7387, t7392;
  double t7398, t7402, t7406, t7409, t7423, t7424, t7425, t7426;
  double t7429, t7430, t7431, t7434, t7435, t7445, t7447, t7451;
  double t7458, t7459, t7460, t7462, t7468, t7470, t7477, t7478;
  double t7481, t7482, t7483, t7484, t7490, t7495, t7498, t7513;
  double t7514, t7517, t7531, t7534, t7539, t7543, t7548, t7552;
  double t7558, t7570, t7577, t7580, t7581, t7582, t7585, t7588;
  double t7599, t7627, t7630, t7647, t7667, t7674, t7685, t7689;
  double t7710, t7714, t7721, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4;
  double t7728, t7732, t7734, tv4rho2sigmalapl5, t7740, t7748, tv4rho2sigmalapl6, tv4rho2sigmalapl7;
  double tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, t7754, t7761, t7764, tv4rho2sigmalapl11, t7772;
  double tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, t7809, t7810, t7813;
  double t7816, t7817, t7820, t7823, t7824, t7827, t7830, t7838;
  double t7839, t7844, t7851, t7852, t7858, t7872, t7873, t7874;
  double t7879, t7880, t7881, t7890, t7893, t7894, t7895, t7896;
  double t7903, t7904, t7907, t7908, t7914, t7915, t7916, t7920;
  double t7925, t7928, t7935, t7936, t7939, t7946, t7947, t7953;
  double t7960, t7973, t7975, t7979, t7982, t7990, t8004, t8008;
  double t8009, t8014, t8025, t8030, t8056, t8057, t8060, t8068;
  double t8075, t8103, t8120, t8123, t8128, t8129, t8136, t8157;
  double t8161, t8168, tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4;
  double tv4rho2sigmatau5, tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, tv4rho2sigmatau12;
  double tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, t8175, t8182, t8184;
  double t8202, t8206, t8209, t8218, t8219, t8227, t8228, t8229;
  double t8235, t8236, t8239, t8240, t8243, t8250, t8251, t8263;
  double t8273, t8275, t8276, t8280, t8283, t8285, t8290, t8295;
  double t8307, t8313, t8320, t8330, t8342, t8346, t8352, t8366;
  double t8370, t8373, t8376, t8397, t8398, t8407, t8410, t8414;
  double t8422, t8423, t8436, t8438, t8442, t8447, t8456, t8462;
  double t8467, t8471, t8476, t8480, t8487, tv4rho2lapl20, tv4rho2lapl21, t8494;
  double t8498, t8500, tv4rho2lapl22, t8506, t8514, tv4rho2lapl23, tv4rho2lapl24, t8520;
  double t8527, t8530, tv4rho2lapl25, t8538, tv4rho2lapl26, tv4rho2lapl27, t8558, t8561;
  double t8562, t8565, t8568, t8578, t8588, t8589, t8595, t8598;
  double t8599, t8600, t8604, t8605, t8617, t8622, t8631, t8633;
  double t8634, t8638, t8644, t8655, t8657, t8660, t8666, t8672;
  double t8679, t8680, t8700, t8707, t8713, t8722, t8727, t8731;
  double t8734, t8735, t8760, t8763, t8764, t8768, t8776, t8780;
  double t8790, t8791, t8802, t8809, t8818, t8821, t8822, t8830;
  double t8834, t8841, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4;
  double tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, tv4rho2tau20;
  double tv4rho2tau21, tv4rho2tau22, tv4rho2tau23, tv4rho2tau24, tv4rho2tau25, tv4rho2tau26, tv4rho2tau27, tv4rho2tau28;
  double t8848, t8856, t8857, t8858, t8859, t8863, t8866, t8867;
  double t8870, t8872, t8873, t8875, t8877, t8878, t8879, t8880;
  double t8881, t8884, t8885, t8886, t8887, t8890, t8892, t8894;
  double t8895, t8899, t8902, t8904, t8907, t8910, t8913, t8914;
  double t8915, t8916, t8918, t8920, t8922, t8927, t8930, t8932;
  double t8936, t8937, t8940, t8942, t8943, t8946, t8947, t8948;
  double t8951, t8953, t8954, t8957, t8960, t8964, t8967, t8970;
  double t8973, t8976, t8983, t8987, t8988, t8989, t8995, t9000;
  double t9006, t9014, t9018, t9021, t9023, t9026, t9030, t9038;
  double t9040, t9047, t9055, t9056, t9061, t9063, t9065, t9072;
  double t9075, t9076, t9082, t9089, t9093, t9095, t9101, t9104;
  double t9106, t9107, t9109, t9111, t9113, t9116, t9118, t9130;
  double t9136, t9138, t9146, t9150, t9157, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32;
  double tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t9164, t9166;
  double tv4rhosigma39, t9172, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315;
  double tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t9184, t9185, t9186, t9187, t9188;
  double t9190, t9191, t9192, t9195, t9196, t9197, t9201, t9204;
  double t9205, t9207, t9208, t9210, t9213, t9215, t9216, t9219;
  double t9220, t9221, t9223, t9225, t9228, t9229, t9230, t9231;
  double t9234, t9237, t9239, t9240, t9241, t9246, t9249, t9252;
  double t9254, t9256, t9261, t9262, t9263, t9264, t9266, t9272;
  double t9273, t9276, t9277, t9279, t9282, t9283, t9286, t9287;
  double t9290, t9296, t9298, t9301, t9304, t9308, t9313, t9314;
  double t9319, t9320, t9321, t9327, t9332, t9336, t9339, t9340;
  double t9342, t9345, t9348, t9349, t9352, t9357, t9363, t9368;
  double t9370, t9373, t9388, t9389, t9392, t9396, t9398, t9405;
  double t9410, t9414, t9421, t9424, t9431, t9436, t9438, t9442;
  double t9448, t9456, t9458, t9460, t9461, t9463, t9465, t9472;
  double t9478, t9482, t9489, tv4rhosigma319, t9496, t9509, t9510, t9512;
  double t9513, t9520, t9521, t9525, t9528, t9529, t9530, t9537;
  double t9542, t9544, t9545, t9550, t9551, t9554, t9555, t9559;
  double t9561, t9570, t9571, t9572, t9575, t9582, t9583, t9587;
  double t9591, t9592, t9594, t9595, t9598, t9604, t9607, t9610;
  double t9619, t9632, t9636, t9639, t9641, t9643, t9650, t9653;
  double t9656, t9661, t9668, t9670, t9673, t9690, t9698, t9706;
  double t9707, t9721, t9727, t9728, t9732, t9738, t9747, t9748;
  double t9754, t9780, t9781, t9784, t9788, t9794, t9796, t9797;
  double t9798, t9808, t9809, t9811, t9822, t9839, t9840, t9841;
  double t9844, t9845, t9846, t9852, t9859, t9864, t9871, tv4rhosigma2lapl0;
  double tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8;
  double tv4rhosigma2lapl9, tv4rhosigma2lapl10, t9878, t9880, tv4rhosigma2lapl11, t9886, tv4rhosigma2lapl12, tv4rhosigma2lapl13;
  double tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21;
  double tv4rhosigma2lapl22, t9904, t9907, t9909, t9910, t9918, t9919, t9924;
  double t9925, t9928, t9933, t9934, t9937, t9938, t9945, t9946;
  double t9949, t9950, t9951, t9953, t9954, t9956, t9960, t9961;
  double t9966, t9976, t9980, t9984, t9990, t9993, t9997, t10004;
  double t10011, t10013, t10016, t10019, t10025, t10027, t10036, t10038;
  double t10040, t10044, t10045, t10055, t10056, t10066, t10067, t10071;
  double t10085, t10093, t10100, t10101, t10103, t10109, t10114, t10127;
  double t10138, t10139, t10153, t10154, t10157, t10158, t10179, t10187;
  double t10192, t10193, t10201, t10219, t10224, t10225, t10227, t10232;
  double t10233, t10234, t10243, t10248, t10255, tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1;
  double tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9;
  double tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17;
  double tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23, t10262, t10275;
  double t10276, t10279, t10284, t10285, t10286, t10289, t10290, t10297;
  double t10298, t10301, t10307, t10310, t10315, t10323, t10338, t10343;
  double t10344, t10348, t10363, t10371, t10381, t10395, t10415, t10438;
  double t10443, t10449, t10470, t10494, t10535, t10551, t10555, t10560;
  double t10567, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26;
  double tv4rhosigmalapl27, t10574, t10576, tv4rhosigmalapl28, t10582, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211;
  double tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, t10599, t10600, t10604;
  double t10607, t10614, t10617, t10622, t10625, t10626, t10629, t10634;
  double t10637, t10638, t10641, t10648, t10649, t10652, t10665, t10678;
  double t10691, t10695, t10698, t10705, t10726, t10741, t10761, t10764;
  double t10778, t10797, t10816, t10862, t10876, t10881, t10886, t10893;
  double tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6;
  double tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14;
  double tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22;
  double tv4rhosigmalapltau23, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26;
  double tv4rhosigmatau27, tv4rhosigmatau28, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214;
  double tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217, t10900, t10906, t10907, t10908, t10911;
  double t10915, t10916, t10921, t10924, t10925, t10953, t10961, t10962;
  double t10965, t10968, t10974, t10980, t10992, t10997, t10999, t11012;
  double t11015, t11020, t11029, t11038, t11040, t11047, t11049, t11057;
  double t11062, t11063, t11066, t11069, t11087, t11091, t11096, t11101;
  double t11107, t11117, t11119, t11123, t11130, tv4rholapl30, tv4rholapl31, tv4rholapl32;
  double t11137, t11139, tv4rholapl33, t11145, tv4rholapl34, tv4rholapl35, tv4rholapl36, t11155;
  double t11156, t11157, t11160, t11163, t11164, t11165, t11168, t11169;
  double t11172, t11183, t11185, t11191, t11196, t11210, t11219, t11220;
  double t11223, t11228, t11231, t11236, t11250, t11252, t11256, t11265;
  double t11267, t11274, t11277, t11279, t11282, t11286, t11289, t11290;
  double t11301, t11307, t11311, t11322, t11328, t11337, t11349, t11356;
  double t11360, t11366, t11377, t11378, t11382, t11389, tv4rholapl37, tv4rholapl2tau0;
  double tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8;
  double tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24;
  double tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, tv4rhotau30;
  double tv4rhotau31, tv4rhotau32, tv4rhotau33, tv4rhotau34, tv4rhotau35, tv4rhotau36, tv4rhotau37, t11399;
  double t11401, t11402, t11405, t11406, t11408, t11410, t11411, t11412;
  double t11415, t11418, t11423, t11424, t11427, t11428, t11430, t11433;
  double t11438, t11443, t11444, t11446, t11450, t11454, t11456, t11458;
  double t11460, t11461, t11463, t11468, t11475, t11476, t11481, t11485;
  double t11496, t11503, t11504, t11505, t11507, t11510, t11512, t11519;
  double t11522, t11538, t11539, t11544, t11549, t11560, t11564, t11567;
  double t11576, t11578, t11581, t11583, t11594, t11598, t11604, tv4sigma40;
  double tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48;
  double tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t11613, t11615, t11616;
  double t11618, t11621, t11622, t11624, t11625, t11626, t11629, t11634;
  double t11638, t11641, t11643, t11649, t11650, t11652, t11655, t11656;
  double t11660, t11661, t11663, t11665, t11668, t11669, t11673, t11675;
  double t11679, t11684, t11687, t11688, t11691, t11695, t11706, t11707;
  double t11708, t11710, t11713, t11720, t11724, t11745, t11746, t11750;
  double t11751, t11758, t11762, t11775, t11778, t11779, t11784, t11791;
  double t11793, t11796, t11798, t11809, t11813, t11819, tv4sigma414, t11827;
  double t11828, t11829, t11830, t11831, t11832, t11837, t11841, t11842;
  double t11843, t11844, t11845, t11846, t11847, t11848, t11849, t11850;
  double t11851, t11852, t11856, t11859, t11860, t11867, t11868, t11869;
  double t11873, t11874, t11875, t11876, t11877, t11878, t11880, t11881;
  double t11882, t11883, t11887, t11898, t11899, t11901, t11902, t11905;
  double t11906, t11909, t11915, t11921, t11923, t11925, t11934, t11941;
  double t11957, t11961, t11964, t11979, t11980, t11985, t11986, t11991;
  double t11992, t11995, t12012, t12029, t12035, t12039, t12045, tv4sigma3lapl0;
  double tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8;
  double tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16;
  double tv4sigma3lapl17, tv4sigma3lapl18, t12052, t12053, t12057, t12060, t12061, t12062;
  double t12063, t12064, t12065, t12066, t12067, t12068, t12069, t12070;
  double t12071, t12073, t12074, t12075, t12077, t12078, t12081, t12082;
  double t12100, t12101, t12102, t12103, t12104, t12105, t12107, t12108;
  double t12109, t12112, t12113, t12114, t12117, t12118, t12126, t12134;
  double t12141, t12142, t12144, t12151, t12155, t12164, t12167, t12181;
  double t12184, t12185, t12186, t12187, t12188, t12190, t12191, t12196;
  double t12197, t12200, t12201, t12206, t12207, t12218, t12235, t12254;
  double t12258, t12262, t12268, tv4sigma3lapl19, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3;
  double tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11;
  double tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19;
  double t12276, t12281, t12284, t12288, t12300, t12302, t12306, t12311;
  double t12325, t12331, t12336, t12343, t12353, t12356, t12358, t12362;
  double t12363, t12366, t12373, t12377, t12381, t12389, t12404, t12407;
  double t12423, t12425, t12426, t12428, t12430, t12432, t12434, t12437;
  double t12440, t12455, t12472, t12474, t12477, t12481, t12486, t12490;
  double t12496, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26;
  double tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214;
  double tv4sigma2lapl215, tv4sigma2lapl216, t12504, t12509, t12512, t12516, t12528, t12530;
  double t12532, t12536, t12553, t12558, t12564, t12568, t12571, t12572;
  double t12575, t12582, t12591, t12593, t12600, t12608, t12612, t12616;
  double t12624, t12632, t12643, t12653, t12654, t12656, t12657, t12659;
  double t12661, t12663, t12666, t12681, t12701, t12703, t12705, t12707;
  double t12712, t12716, t12722, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3;
  double tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11;
  double tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19;
  double tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23;
  double tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211;
  double tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, t12731, t12738;
  double t12739, t12746, t12747, t12760, t12762, t12765, t12771, t12781;
  double t12786, t12800, t12811, t12817, t12847, t12854, t12872, t12873;
  double t12877, t12883, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35;
  double tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, t12892, t12895, t12899;
  double t12914, t12923, t12925, t12931, t12934, t12948, t12951, t12973;
  double t12978, t12986, t13011, t13016, t13034, t13035, t13039, t13045;
  double tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6;
  double tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14;
  double tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24;
  double tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212;
  double tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32;
  double tv4sigmatau33, tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310;
  double tv4sigmatau311, t13057, t13058, t13059, t13066, t13067, t13073, t13089;
  double t13101, t13102, t13105, t13107, t13110, t13124, t13133, t13137;
  double t13173, t13178, t13181, t13200, t13204, t13210, tv4lapl40, tv4lapl41;
  double tv4lapl42, tv4lapl43, t13217, t13218, t13219, t13222, t13226, t13229;
  double t13236, t13245, t13255, t13264, t13265, t13269, t13271, t13278;
  double t13292, t13307, t13311, t13339, t13342, t13345, t13366, t13370;
  double t13376, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5;
  double tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25;
  double tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34;
  double tv4lapltau35, tv4lapltau36, tv4lapltau37, tv4tau40, tv4tau41, tv4tau42, tv4tau43, tv4tau44;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t122 = t8 * t8;
  t123 = 0.1e1 / t122;
  t124 = t18 * t123;
  t126 = my_piecewise5(t12, 0, t16, 0, t9 - t124);
  t129 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t126);
  t130 = t129 * t31;
  t134 = 0.1e1 / t30;
  t135 = t29 * t134;
  t138 = t7 * t135 * t73 / 0.1e2;
  t141 = 0.1e1 / t41 / t39 / rho[0];
  t143 = t38 * sigma[0] * t141;
  t149 = -0.25e2 / 0.162e3 * t38 * lapl[0] * t43 + 0.4e2 / 0.243e3 * t143;
  t151 = t70 * t67;
  t152 = my_piecewise3(t61, 0, t149);
  t153 = my_piecewise3(t63, t152, 0);
  t155 = fabs(t64) / t64;
  t156 = 0.1e1 / t65;
  t158 = 0.1e1 / t69;
  t159 = t68 * t158;
  t160 = t155 * t156 * t159;
  t162 = my_piecewise5(t58, 0, t61, 0, -t151 * t153 * t160);
  t164 = -0.5e1 / 0.27e2 * t143 + t149 * t71 + t53 * t162;
  t169 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t73 + t138 + 0.3e1 / 0.2e2 * t7 * t32 * t164);
  t170 = t79 * t123;
  t172 = my_piecewise5(t16, 0, t12, 0, -t9 - t170);
  t175 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t172);
  t176 = t175 * t31;
  t180 = t87 * t134;
  t183 = t7 * t180 * t117 / 0.1e2;
  t185 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t117 + t183);
  tvrho0 = t77 + t121 + t8 * (t169 + t185);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t189 = my_piecewise5(t12, 0, t16, 0, -t9 - t124);
  t192 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t189);
  t193 = t192 * t31;
  t198 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t73 + t138);
  t200 = my_piecewise5(t16, 0, t12, 0, t9 - t170);
  t203 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t200);
  t204 = t203 * t31;
  t210 = 0.1e1 / t91 / t89 / rho[1];
  t212 = t38 * sigma[2] * t210;
  t218 = -0.25e2 / 0.162e3 * t38 * lapl[1] * t93 + 0.4e2 / 0.243e3 * t212;
  t220 = t114 * t111;
  t221 = my_piecewise3(t105, 0, t218);
  t222 = my_piecewise3(t107, t221, 0);
  t224 = fabs(t108) / t108;
  t225 = 0.1e1 / t109;
  t227 = 0.1e1 / t113;
  t228 = t112 * t227;
  t229 = t224 * t225 * t228;
  t231 = my_piecewise5(t104, 0, t105, 0, -t220 * t222 * t229);
  t233 = -0.5e1 / 0.27e2 * t212 + t218 * t115 + t103 * t231;
  t238 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t117 + t183 + 0.3e1 / 0.2e2 * t7 * t88 * t233);
  tvrho1 = t77 + t121 + t8 * (t198 + t238);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t241 = t38 * t43;
  t244 = t38 * t43 * t71;
  t247 = my_piecewise3(t61, 0, -0.5e1 / 0.81e2 * t241);
  t248 = my_piecewise3(t63, t247, 0);
  t251 = my_piecewise5(t58, 0, t61, 0, -t151 * t248 * t160);
  t253 = 0.5e1 / 0.72e2 * t241 - 0.5e1 / 0.81e2 * t244 + t53 * t251;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t253);
  tvsigma0 = t8 * t257;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t258 = t38 * t93;
  t261 = t38 * t93 * t115;
  t264 = my_piecewise3(t105, 0, -0.5e1 / 0.81e2 * t258);
  t265 = my_piecewise3(t107, t264, 0);
  t268 = my_piecewise5(t104, 0, t105, 0, -t220 * t265 * t229);
  t270 = 0.5e1 / 0.72e2 * t258 - 0.5e1 / 0.81e2 * t261 + t103 * t268;
  t274 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t270);
  tvsigma2 = t8 * t274;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t280 = my_piecewise3(t61, 0, 0.5e1 / 0.54e2 * t38 * t48);
  t281 = my_piecewise3(t63, t280, 0);
  t284 = my_piecewise5(t58, 0, t61, 0, -t151 * t281 * t160);
  t286 = 0.5e1 / 0.54e2 * t38 * t48 * t71 + t53 * t284;
  t290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t286);
  tvlapl0 = t8 * t290;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t296 = my_piecewise3(t105, 0, 0.5e1 / 0.54e2 * t38 * t98);
  t297 = my_piecewise3(t107, t296, 0);
  t300 = my_piecewise5(t104, 0, t105, 0, -t220 * t297 * t229);
  t302 = 0.5e1 / 0.54e2 * t38 * t98 * t115 + t103 * t300;
  t306 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t302);
  tvlapl1 = t8 * t306;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t309 = 0.1e1 / t26;
  t310 = t126 * t126;
  t313 = t122 * t8;
  t314 = 0.1e1 / t313;
  t315 = t18 * t314;
  t318 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t123 + 0.2e1 * t315);
  t322 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t310 + 0.5e1 / 0.3e1 * t27 * t318);
  t323 = t322 * t31;
  t327 = t129 * t134;
  t329 = t7 * t327 * t73;
  t335 = 0.1e1 / t30 / t8;
  t336 = t29 * t335;
  t339 = t7 * t336 * t73 / 0.3e2;
  t341 = t7 * t135 * t164;
  t343 = t39 * t39;
  t345 = 0.1e1 / t41 / t343;
  t347 = t38 * sigma[0] * t345;
  t353 = 0.1e3 / 0.243e3 * t38 * lapl[0] * t141 - 0.44e3 / 0.729e3 * t347;
  t357 = t66 * t66;
  t359 = t70 / t357;
  t360 = t153 * t153;
  t362 = t155 * t155;
  t363 = t65 * t65;
  t364 = 0.1e1 / t363;
  t365 = t362 * t364;
  t366 = t68 * t68;
  t367 = t69 * t69;
  t368 = 0.1e1 / t367;
  t369 = t366 * t368;
  t370 = t365 * t369;
  t372 = t360 * t362;
  t374 = t364 * t68;
  t375 = t158 * params->csk_a;
  t376 = t374 * t375;
  t378 = my_piecewise3(t61, 0, t353);
  t379 = my_piecewise3(t63, t378, 0);
  t382 = t151 * t360;
  t383 = 0.0;
  t385 = t383 * t156 * t159;
  t386 = t382 * t385;
  t387 = t365 * t159;
  t389 = t359 * t372;
  t391 = t364 * t366;
  t392 = t368 * params->csk_a;
  t393 = t391 * t392;
  t396 = my_piecewise5(t58, 0, t61, 0, -t151 * t379 * t160 + t151 * t372 * t376 + t359 * t360 * t370 - t389 * t376 + t382 * t387 - t389 * t393 - t386);
  t398 = 0.55e2 / 0.81e2 * t347 + t353 * t71 + 0.2e1 * t149 * t162 + t53 * t396;
  t403 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t73 + t329 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t164 - t339 + t341 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t398);
  t404 = 0.1e1 / t84;
  t405 = t172 * t172;
  t408 = t79 * t314;
  t411 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t123 + 0.2e1 * t408);
  t415 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t405 + 0.5e1 / 0.3e1 * t85 * t411);
  t416 = t415 * t31;
  t420 = t175 * t134;
  t422 = t7 * t420 * t117;
  t424 = t87 * t335;
  t427 = t7 * t424 * t117 / 0.3e2;
  t429 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t117 + t422 / 0.5e1 - t427);
  tv2rho20 = 0.2e1 * t169 + 0.2e1 * t185 + t8 * (t403 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t432 = t309 * t189;
  t436 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t315);
  t440 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t432 * t126 + 0.5e1 / 0.3e1 * t27 * t436);
  t441 = t440 * t31;
  t445 = t192 * t134;
  t447 = t7 * t445 * t73;
  t455 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t73 + t447 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t164 + t329 / 0.1e2 - t339 + t341 / 0.1e2);
  t456 = t404 * t200;
  t460 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t408);
  t464 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t456 * t172 + 0.5e1 / 0.3e1 * t85 * t460);
  t465 = t464 * t31;
  t469 = t203 * t134;
  t471 = t7 * t469 * t117;
  t478 = t7 * t180 * t233;
  t481 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t117 + t471 / 0.1e2 + t422 / 0.1e2 - t427 + 0.3e1 / 0.2e2 * t7 * t176 * t233 + t478 / 0.1e2);
  tv2rho21 = t169 + t185 + t198 + t238 + t8 * (t455 + t481);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t486 = t189 * t189;
  t491 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t123 + 0.2e1 * t315);
  t495 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t486 + 0.5e1 / 0.3e1 * t27 * t491);
  t496 = t495 * t31;
  t502 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t73 + t447 / 0.5e1 - t339);
  t503 = t200 * t200;
  t508 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t123 + 0.2e1 * t408);
  t512 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t503 + 0.5e1 / 0.3e1 * t85 * t508);
  t513 = t512 * t31;
  t522 = t89 * t89;
  t524 = 0.1e1 / t91 / t522;
  t526 = t38 * sigma[2] * t524;
  t532 = 0.1e3 / 0.243e3 * t38 * lapl[1] * t210 - 0.44e3 / 0.729e3 * t526;
  t536 = t110 * t110;
  t538 = t114 / t536;
  t539 = t222 * t222;
  t541 = t224 * t224;
  t542 = t109 * t109;
  t543 = 0.1e1 / t542;
  t544 = t541 * t543;
  t545 = t112 * t112;
  t546 = t113 * t113;
  t547 = 0.1e1 / t546;
  t548 = t545 * t547;
  t549 = t544 * t548;
  t551 = t539 * t541;
  t553 = t543 * t112;
  t554 = t227 * params->csk_a;
  t555 = t553 * t554;
  t557 = my_piecewise3(t105, 0, t532);
  t558 = my_piecewise3(t107, t557, 0);
  t561 = t220 * t539;
  t562 = 0.0;
  t564 = t562 * t225 * t228;
  t565 = t561 * t564;
  t566 = t544 * t228;
  t568 = t538 * t551;
  t570 = t543 * t545;
  t571 = t547 * params->csk_a;
  t572 = t570 * t571;
  t575 = my_piecewise5(t104, 0, t105, 0, -t220 * t558 * t229 + t220 * t551 * t555 + t538 * t539 * t549 - t568 * t555 + t561 * t566 - t568 * t572 - t565);
  t577 = 0.55e2 / 0.81e2 * t526 + t532 * t115 + 0.2e1 * t218 * t231 + t103 * t575;
  t582 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t117 + t471 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t233 - t427 + t478 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t577);
  tv2rho22 = 0.2e1 * t198 + 0.2e1 * t238 + t8 * (t502 + t582);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t590 = t7 * t135 * t253 / 0.1e2;
  t591 = t38 * t141;
  t594 = t38 * t141 * t71;
  t597 = t38 * t43 * t162;
  t600 = t153 * t362;
  t601 = t359 * t600;
  t602 = t368 * t248;
  t603 = t391 * t602;
  t605 = t248 * t362;
  t606 = t151 * t605;
  t608 = t374 * t375 * t153;
  t611 = my_piecewise3(t61, 0, 0.4e2 / 0.243e3 * t591);
  t612 = my_piecewise3(t63, t611, 0);
  t615 = t248 * t153;
  t617 = t151 * t615 * t385;
  t618 = t158 * t153;
  t619 = t374 * t618;
  t621 = t359 * t605;
  t623 = t392 * t153;
  t624 = t391 * t623;
  t627 = my_piecewise5(t58, 0, t61, 0, -t151 * t612 * t160 + t601 * t603 + t606 * t608 + t606 * t619 - t621 * t608 - t621 * t624 - t617);
  t629 = -0.5e1 / 0.27e2 * t591 + 0.4e2 / 0.243e3 * t594 - 0.5e1 / 0.81e2 * t597 + t149 * t251 + t53 * t627;
  t634 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t253 + t590 + 0.3e1 / 0.2e2 * t7 * t32 * t629);
  tv2rhosigma0 = t8 * t634 + t257;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t641 = t7 * t180 * t270 / 0.1e2;
  t643 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t270 + t641);
  tv2rhosigma2 = t8 * t643 + t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t649 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t253 + t590);
  tv2rhosigma3 = t8 * t649 + t257;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t654 = t38 * t210;
  t657 = t38 * t210 * t115;
  t660 = t38 * t93 * t231;
  t663 = t222 * t541;
  t664 = t538 * t663;
  t665 = t547 * t265;
  t666 = t570 * t665;
  t668 = t265 * t541;
  t669 = t220 * t668;
  t671 = t553 * t554 * t222;
  t674 = my_piecewise3(t105, 0, 0.4e2 / 0.243e3 * t654);
  t675 = my_piecewise3(t107, t674, 0);
  t678 = t265 * t222;
  t680 = t220 * t678 * t564;
  t681 = t227 * t222;
  t682 = t553 * t681;
  t684 = t538 * t668;
  t686 = t571 * t222;
  t687 = t570 * t686;
  t690 = my_piecewise5(t104, 0, t105, 0, -t220 * t675 * t229 + t664 * t666 + t669 * t671 + t669 * t682 - t684 * t671 - t684 * t687 - t680);
  t692 = -0.5e1 / 0.27e2 * t654 + 0.4e2 / 0.243e3 * t657 - 0.5e1 / 0.81e2 * t660 + t218 * t268 + t103 * t690;
  t697 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t270 + t641 + 0.3e1 / 0.2e2 * t7 * t88 * t692);
  tv2rhosigma5 = t8 * t697 + t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t704 = t7 * t135 * t286 / 0.1e2;
  t710 = t368 * t281;
  t711 = t391 * t710;
  t713 = t281 * t362;
  t714 = t151 * t713;
  t717 = my_piecewise3(t61, 0, -0.25e2 / 0.162e3 * t241);
  t718 = my_piecewise3(t63, t717, 0);
  t721 = t281 * t153;
  t723 = t151 * t721 * t385;
  t725 = t359 * t713;
  t729 = my_piecewise5(t58, 0, t61, 0, -t151 * t718 * t160 + t601 * t711 + t714 * t608 - t725 * t608 + t714 * t619 - t725 * t624 - t723);
  t731 = -0.25e2 / 0.162e3 * t244 + 0.5e1 / 0.54e2 * t38 * t48 * t162 + t149 * t284 + t53 * t729;
  t736 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t286 + t704 + 0.3e1 / 0.2e2 * t7 * t32 * t731);
  tv2rholapl0 = t8 * t736 + t290;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t743 = t7 * t180 * t302 / 0.1e2;
  t745 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t302 + t743);
  tv2rholapl1 = t8 * t745 + t306;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t751 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t286 + t704);
  tv2rholapl2 = t8 * t751 + t290;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t761 = t547 * t297;
  t762 = t570 * t761;
  t764 = t297 * t541;
  t765 = t220 * t764;
  t768 = my_piecewise3(t105, 0, -0.25e2 / 0.162e3 * t258);
  t769 = my_piecewise3(t107, t768, 0);
  t772 = t297 * t222;
  t774 = t220 * t772 * t564;
  t776 = t538 * t764;
  t780 = my_piecewise5(t104, 0, t105, 0, -t220 * t769 * t229 + t664 * t762 + t765 * t671 - t776 * t671 + t765 * t682 - t776 * t687 - t774);
  t782 = -0.25e2 / 0.162e3 * t261 + 0.5e1 / 0.54e2 * t38 * t98 * t231 + t218 * t300 + t103 * t780;
  t787 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t302 + t743 + 0.3e1 / 0.2e2 * t7 * t88 * t782);
  tv2rholapl3 = t8 * t787 + t306;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t790 = t38 * t43 * t251;
  t792 = t248 * t248;
  t795 = t792 * t362;
  t798 = my_piecewise3(t61, 0, 0);
  t799 = my_piecewise3(t63, t798, 0);
  t801 = t151 * t799 * t160;
  t802 = t151 * t792;
  t803 = t802 * t385;
  t805 = t359 * t795;
  t809 = my_piecewise5(t58, 0, t61, 0, t151 * t795 * t376 + t359 * t792 * t370 - t805 * t376 + t802 * t387 - t805 * t393 - t801 - t803);
  t811 = -0.1e2 / 0.81e2 * t790 + t53 * t809;
  t815 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t811);
  tv2sigma20 = t8 * t815;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t817 = t38 * t93 * t268;
  t819 = t265 * t265;
  t822 = t819 * t541;
  t823 = t220 * t822;
  t825 = my_piecewise3(t105, 0, 0);
  t826 = my_piecewise3(t107, t825, 0);
  t828 = t220 * t826 * t229;
  t829 = t220 * t819;
  t830 = t829 * t564;
  t832 = t538 * t822;
  t836 = my_piecewise5(t104, 0, t105, 0, t538 * t819 * t549 + t823 * t555 - t832 * t555 + t829 * t566 - t832 * t572 - t828 - t830);
  t838 = -0.1e2 / 0.81e2 * t817 + t103 * t836;
  t842 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t838);
  tv2sigma25 = t8 * t842;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t847 = t38 * t43 * t284;
  t850 = t375 * t248;
  t851 = t374 * t850;
  t853 = t281 * t248;
  t854 = t151 * t853;
  t855 = t854 * t385;
  t856 = t158 * t248;
  t857 = t374 * t856;
  t860 = t392 * t248;
  t861 = t391 * t860;
  t864 = my_piecewise5(t58, 0, t61, 0, t621 * t711 + t714 * t851 + t714 * t857 - t725 * t851 - t725 * t861 - t801 - t855);
  t866 = 0.5e1 / 0.54e2 * t38 * t48 * t251 - 0.5e1 / 0.81e2 * t847 + t53 * t864;
  t870 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t866);
  tv2sigmalapl0 = t8 * t870;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t875 = t38 * t93 * t300;
  t878 = t554 * t265;
  t879 = t553 * t878;
  t881 = t297 * t265;
  t882 = t220 * t881;
  t883 = t882 * t564;
  t884 = t227 * t265;
  t885 = t553 * t884;
  t888 = t571 * t265;
  t889 = t570 * t888;
  t892 = my_piecewise5(t104, 0, t105, 0, t684 * t762 + t765 * t879 + t765 * t885 - t776 * t879 - t776 * t889 - t828 - t883);
  t894 = 0.5e1 / 0.54e2 * t38 * t98 * t268 - 0.5e1 / 0.81e2 * t875 + t103 * t892;
  t898 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t894);
  tv2sigmalapl5 = t8 * t898;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t902 = t281 * t281;
  t905 = t902 * t362;
  t906 = t151 * t905;
  t908 = t151 * t902;
  t909 = t908 * t385;
  t911 = t359 * t905;
  t915 = my_piecewise5(t58, 0, t61, 0, t359 * t902 * t370 + t906 * t376 - t911 * t376 + t908 * t387 - t911 * t393 - t801 - t909);
  t917 = 0.5e1 / 0.27e2 * t38 * t48 * t284 + t53 * t915;
  t921 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t917);
  tv2lapl20 = t8 * t921;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t925 = t297 * t297;
  t928 = t925 * t541;
  t931 = t220 * t925;
  t932 = t931 * t564;
  t934 = t538 * t928;
  t938 = my_piecewise5(t104, 0, t105, 0, t220 * t928 * t555 + t538 * t925 * t549 - t934 * t555 + t931 * t566 - t934 * t572 - t828 - t932);
  t940 = 0.5e1 / 0.27e2 * t38 * t98 * t300 + t103 * t938;
  t944 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t940);
  tv2lapl22 = t8 * t944;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t948 = 0.1e1 / t26 / t21;
  t949 = t310 * t126;
  t952 = t309 * t126;
  t955 = t122 * t122;
  t956 = 0.1e1 / t955;
  t957 = t18 * t956;
  t960 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t314 - 0.6e1 * t957);
  t964 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t948 * t949 + 0.1e2 / 0.3e1 * t952 * t318 + 0.5e1 / 0.3e1 * t27 * t960);
  t965 = t964 * t31;
  t969 = t322 * t134;
  t971 = t7 * t969 * t73;
  t976 = t129 * t335;
  t978 = t7 * t976 * t73;
  t981 = t7 * t327 * t164;
  t987 = 0.1e1 / t30 / t122;
  t988 = t29 * t987;
  t991 = 0.2e1 / 0.45e2 * t7 * t988 * t73;
  t993 = t7 * t336 * t164;
  t996 = t7 * t135 * t398;
  t1000 = 0.1e1 / t41 / t343 / rho[0];
  t1002 = t38 * sigma[0] * t1000;
  t1008 = -0.11e4 / 0.729e3 * t38 * lapl[0] * t345 + 0.616e4 / 0.2187e4 * t1002;
  t1014 = t360 * t153;
  t1015 = t362 * t155;
  t1016 = t1014 * t1015;
  t1017 = t151 * t1016;
  t1019 = 0.1e1 / t363 / t65;
  t1020 = t1019 * t68;
  t1021 = t1020 * t375;
  t1024 = t379 * t362;
  t1028 = t1014 * t383;
  t1030 = t158 * t155;
  t1031 = t374 * t1030;
  t1032 = t151 * t1028 * t1031;
  t1034 = t1014 * t155;
  t1036 = t368 * t383;
  t1037 = t391 * t1036;
  t1038 = t359 * t1034 * t1037;
  t1042 = t70 / t357 / t66;
  t1043 = t1042 * t1016;
  t1044 = t1019 * t366;
  t1045 = t1044 * t392;
  t1048 = params->csk_a * params->csk_a;
  t1049 = t158 * t1048;
  t1050 = t1020 * t1049;
  t1052 = t359 * t1016;
  t1058 = t151 * t379 * t153 * t385;
  t1060 = t1019 * t1048;
  t1061 = t1060 * t369;
  t1064 = t366 * t68;
  t1065 = t1019 * t1064;
  t1067 = 0.1e1 / t367 / t69;
  t1068 = t1067 * t1048;
  t1069 = t1065 * t1068;
  t1072 = t368 * t379;
  t1076 = t1067 * params->csk_a;
  t1077 = t1065 * t1076;
  t1080 = 0.3e1 * t151 * t1024 * t619 + 0.3e1 * t601 * t391 * t1072 - 0.3e1 * t1017 * t1021 - t1017 * t1050 + 0.3e1 * t1043 * t1045 - t1043 * t1050 - 0.3e1 * t1043 * t1061 - 0.2e1 * t1043 * t1069 + 0.3e1 * t1043 * t1077 + 0.3e1 * t1052 * t1050 + 0.3e1 * t1032 + 0.3e1 * t1038 - 0.3e1 * t1058;
  t1085 = t359 * t1024;
  t1088 = t359 * t1028;
  t1090 = t391 * t392 * t155;
  t1091 = t1088 * t1090;
  t1094 = t375 * t379;
  t1095 = t374 * t1094;
  t1100 = t364 * params->csk_a;
  t1102 = t155 * t68 * t158;
  t1103 = t1100 * t1102;
  t1104 = t1088 * t1103;
  t1107 = t375 * t383;
  t1108 = t374 * t1107;
  t1109 = t151 * t1034 * t1108;
  t1112 = t1015 * t1019;
  t1113 = t1064 * t1067;
  t1114 = t1112 * t1113;
  t1116 = my_piecewise3(t61, 0, t1008);
  t1117 = my_piecewise3(t63, t1116, 0);
  t1121 = t1112 * t159;
  t1125 = t1112 * t369;
  t1128 = -t1042 * t1014 * t1114 - 0.2e1 * t151 * t1014 * t1121 - 0.3e1 * t359 * t1014 * t1125 + 0.3e1 * t151 * t600 * t1095 - t151 * t1117 * t160 + 0.3e1 * t1052 * t1021 + 0.3e1 * t1052 * t1061 - 0.3e1 * t1085 * t608 - 0.3e1 * t1085 * t624 - 0.3e1 * t1091 - 0.3e1 * t1104 + 0.3e1 * t1109 - t386;
  t1130 = my_piecewise5(t58, 0, t61, 0, t1080 + t1128);
  t1132 = -0.77e3 / 0.243e3 * t1002 + t1008 * t71 + 0.3e1 * t353 * t162 + 0.3e1 * t149 * t396 + t53 * t1130;
  t1137 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t965 * t73 + 0.3e1 / 0.1e2 * t971 + 0.9e1 / 0.2e2 * t7 * t323 * t164 - t978 / 0.1e2 + 0.3e1 / 0.5e1 * t981 + 0.9e1 / 0.2e2 * t7 * t130 * t398 + t991 - t993 / 0.1e2 + 0.3e1 / 0.1e2 * t996 + 0.3e1 / 0.2e2 * t7 * t32 * t1132);
  t1139 = 0.1e1 / t84 / t82;
  t1140 = t405 * t172;
  t1143 = t404 * t172;
  t1146 = t79 * t956;
  t1149 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t314 - 0.6e1 * t1146);
  t1153 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1139 * t1140 + 0.1e2 / 0.3e1 * t1143 * t411 + 0.5e1 / 0.3e1 * t85 * t1149);
  t1154 = t1153 * t31;
  t1158 = t415 * t134;
  t1160 = t7 * t1158 * t117;
  t1162 = t175 * t335;
  t1164 = t7 * t1162 * t117;
  t1166 = t87 * t987;
  t1169 = 0.2e1 / 0.45e2 * t7 * t1166 * t117;
  t1171 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1154 * t117 + 0.3e1 / 0.1e2 * t1160 - t1164 / 0.1e2 + t1169);
  tv3rho30 = 0.3e1 * t403 + 0.3e1 * t429 + t8 * (t1137 + t1171);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1174 = 0.2e1 * t455;
  t1175 = 0.2e1 * t481;
  t1176 = t948 * t189;
  t1179 = t309 * t436;
  t1184 = 0.2e1 * t314;
  t1185 = 0.6e1 * t957;
  t1187 = my_piecewise5(t12, 0, t16, 0, t1184 - t1185);
  t1191 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1176 * t310 + 0.2e2 / 0.9e1 * t1179 * t126 + 0.1e2 / 0.9e1 * t432 * t318 + 0.5e1 / 0.3e1 * t27 * t1187);
  t1192 = t1191 * t31;
  t1196 = t440 * t134;
  t1199 = t7 * t1196 * t73 / 0.5e1;
  t1203 = t192 * t335;
  t1205 = t7 * t1203 * t73;
  t1209 = t7 * t445 * t164 / 0.5e1;
  t1218 = 0.3e1 / 0.2e2 * t7 * t1192 * t73 + t1199 + 0.3e1 / 0.1e2 * t7 * t441 * t164 - t1205 / 0.3e2 + t1209 + 0.3e1 / 0.2e2 * t7 * t193 * t398 + t971 / 0.1e2 - t978 / 0.15e2 + t981 / 0.5e1 + t991 - t993 / 0.15e2 + t996 / 0.1e2;
  t1219 = my_piecewise3(t2, 0, t1218);
  t1220 = t1139 * t200;
  t1223 = t404 * t460;
  t1228 = 0.6e1 * t1146;
  t1230 = my_piecewise5(t16, 0, t12, 0, -t1184 - t1228);
  t1234 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1220 * t405 + 0.2e2 / 0.9e1 * t1223 * t172 + 0.1e2 / 0.9e1 * t456 * t411 + 0.5e1 / 0.3e1 * t85 * t1230);
  t1235 = t1234 * t31;
  t1239 = t464 * t134;
  t1242 = t7 * t1239 * t117 / 0.5e1;
  t1243 = t203 * t335;
  t1245 = t7 * t1243 * t117;
  t1254 = t7 * t420 * t233 / 0.5e1;
  t1256 = t7 * t424 * t233;
  t1259 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1235 * t117 + t1242 - t1245 / 0.3e2 + t1160 / 0.1e2 - t1164 / 0.15e2 + t1169 + 0.3e1 / 0.2e2 * t7 * t416 * t233 + t1254 - t1256 / 0.3e2);
  tv3rho31 = t403 + t429 + t1174 + t1175 + t8 * (t1219 + t1259);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1262 = t948 * t486;
  t1267 = t309 * t491;
  t1271 = my_piecewise5(t12, 0, t16, 0, -t1184 - t1185);
  t1275 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1262 * t126 + 0.2e2 / 0.9e1 * t432 * t436 + 0.1e2 / 0.9e1 * t1267 * t126 + 0.5e1 / 0.3e1 * t27 * t1271);
  t1276 = t1275 * t31;
  t1280 = t495 * t134;
  t1282 = t7 * t1280 * t73;
  t1291 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1276 * t73 + t1282 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t496 * t164 + t1199 - t1205 / 0.15e2 + t1209 - t978 / 0.3e2 + t991 - t993 / 0.3e2);
  t1292 = t1139 * t503;
  t1297 = t404 * t508;
  t1301 = my_piecewise5(t16, 0, t12, 0, t1184 - t1228);
  t1305 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1292 * t172 + 0.2e2 / 0.9e1 * t456 * t460 + 0.1e2 / 0.9e1 * t1297 * t172 + 0.5e1 / 0.3e1 * t85 * t1301);
  t1306 = t1305 * t31;
  t1310 = t512 * t134;
  t1312 = t7 * t1310 * t117;
  t1319 = t7 * t469 * t233;
  t1327 = t7 * t180 * t577;
  t1329 = 0.3e1 / 0.2e2 * t7 * t1306 * t117 + t1312 / 0.1e2 + t1242 - t1245 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t465 * t233 + t1319 / 0.5e1 - t1164 / 0.3e2 + t1169 + t1254 - t1256 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t176 * t577 + t1327 / 0.1e2;
  t1330 = my_piecewise3(t78, 0, t1329);
  tv3rho32 = t1174 + t1175 + t502 + t582 + t8 * (t1291 + t1330);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1335 = t486 * t189;
  t1342 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t314 - 0.6e1 * t957);
  t1346 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t948 * t1335 + 0.1e2 / 0.3e1 * t432 * t491 + 0.5e1 / 0.3e1 * t27 * t1342);
  t1347 = t1346 * t31;
  t1354 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1347 * t73 + 0.3e1 / 0.1e2 * t1282 - t1205 / 0.1e2 + t991);
  t1355 = t503 * t200;
  t1362 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t314 - 0.6e1 * t1146);
  t1366 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1139 * t1355 + 0.1e2 / 0.3e1 * t456 * t508 + 0.5e1 / 0.3e1 * t85 * t1362);
  t1367 = t1366 * t31;
  t1384 = 0.1e1 / t91 / t522 / rho[1];
  t1386 = t38 * sigma[2] * t1384;
  t1392 = -0.11e4 / 0.729e3 * t38 * lapl[1] * t524 + 0.616e4 / 0.2187e4 * t1386;
  t1398 = t539 * t222;
  t1399 = t1398 * t224;
  t1401 = t547 * t562;
  t1402 = t570 * t1401;
  t1403 = t538 * t1399 * t1402;
  t1405 = t558 * t541;
  t1409 = t1398 * t562;
  t1411 = t227 * t224;
  t1412 = t553 * t1411;
  t1413 = t220 * t1409 * t1412;
  t1417 = t114 / t536 / t110;
  t1418 = t541 * t224;
  t1419 = t1398 * t1418;
  t1420 = t1417 * t1419;
  t1422 = 0.1e1 / t542 / t109;
  t1423 = t1422 * t545;
  t1424 = t1423 * t571;
  t1427 = t220 * t1419;
  t1428 = t1422 * t112;
  t1429 = t227 * t1048;
  t1430 = t1428 * t1429;
  t1432 = t538 * t1419;
  t1436 = t1422 * t1048;
  t1437 = t1436 * t548;
  t1440 = t545 * t112;
  t1441 = t1422 * t1440;
  t1443 = 0.1e1 / t546 / t113;
  t1444 = t1443 * t1048;
  t1445 = t1441 * t1444;
  t1448 = t547 * t558;
  t1452 = t1443 * params->csk_a;
  t1453 = t1441 * t1452;
  t1458 = t558 * t222;
  t1460 = t220 * t1458 * t564;
  t1462 = 0.3e1 * t220 * t1405 * t682 + 0.3e1 * t664 * t570 * t1448 + 0.3e1 * t1420 * t1424 - t1420 * t1430 - 0.3e1 * t1420 * t1437 - 0.2e1 * t1420 * t1445 + 0.3e1 * t1420 * t1453 - t1427 * t1430 + 0.3e1 * t1432 * t1430 + 0.3e1 * t1432 * t1437 + 0.3e1 * t1403 + 0.3e1 * t1413 - 0.3e1 * t1460;
  t1463 = t1422 * params->csk_a;
  t1464 = t1463 * t228;
  t1470 = t554 * t558;
  t1471 = t553 * t1470;
  t1474 = t538 * t1405;
  t1477 = t538 * t1409;
  t1479 = t570 * t571 * t224;
  t1480 = t1477 * t1479;
  t1484 = t543 * params->csk_a;
  t1486 = t224 * t112 * t227;
  t1487 = t1484 * t1486;
  t1488 = t1477 * t1487;
  t1491 = t554 * t562;
  t1492 = t553 * t1491;
  t1493 = t220 * t1399 * t1492;
  t1496 = t1418 * t1422;
  t1497 = t1440 * t1443;
  t1498 = t1496 * t1497;
  t1500 = my_piecewise3(t105, 0, t1392);
  t1501 = my_piecewise3(t107, t1500, 0);
  t1505 = t1496 * t548;
  t1509 = t1496 * t228;
  t1512 = -t1417 * t1398 * t1498 - 0.3e1 * t538 * t1398 * t1505 - 0.2e1 * t220 * t1398 * t1509 + 0.3e1 * t220 * t663 * t1471 - t220 * t1501 * t229 - 0.3e1 * t1427 * t1464 + 0.3e1 * t1432 * t1464 - 0.3e1 * t1474 * t671 - 0.3e1 * t1474 * t687 - 0.3e1 * t1480 - 0.3e1 * t1488 + 0.3e1 * t1493 - t565;
  t1514 = my_piecewise5(t104, 0, t105, 0, t1462 + t1512);
  t1516 = -0.77e3 / 0.243e3 * t1386 + t1392 * t115 + 0.3e1 * t532 * t231 + 0.3e1 * t218 * t575 + t103 * t1514;
  t1521 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1367 * t117 + 0.3e1 / 0.1e2 * t1312 + 0.9e1 / 0.2e2 * t7 * t513 * t233 - t1245 / 0.1e2 + 0.3e1 / 0.5e1 * t1319 + 0.9e1 / 0.2e2 * t7 * t204 * t577 + t1169 - t1256 / 0.1e2 + 0.3e1 / 0.1e2 * t1327 + 0.3e1 / 0.2e2 * t7 * t88 * t1516);
  tv3rho33 = 0.3e1 * t502 + 0.3e1 * t582 + t8 * (t1354 + t1521);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1529 = t7 * t327 * t253;
  t1536 = t7 * t336 * t253 / 0.3e2;
  t1538 = t7 * t135 * t629;
  t1540 = t38 * t345;
  t1543 = t38 * t345 * t71;
  t1546 = t38 * t141 * t162;
  t1549 = t38 * t43 * t396;
  t1554 = t612 * t153;
  t1556 = t151 * t1554 * t385;
  t1558 = t248 * t379;
  t1560 = t151 * t1558 * t385;
  t1561 = t158 * t379;
  t1562 = t374 * t1561;
  t1565 = t368 * t612;
  t1566 = t391 * t1565;
  t1569 = t360 * t1015;
  t1570 = t1042 * t1569;
  t1571 = t1067 * t248;
  t1574 = t359 * t1569;
  t1575 = t1044 * t602;
  t1578 = t248 * t1015;
  t1579 = t151 * t1578;
  t1580 = t158 * t360;
  t1581 = t1020 * t1580;
  t1584 = t612 * t362;
  t1585 = t151 * t1584;
  t1588 = t1571 * params->csk_a;
  t1589 = t1065 * t1588;
  t1595 = t359 * t1578;
  t1596 = t368 * t1048;
  t1597 = t1596 * t360;
  t1598 = t1044 * t1597;
  t1601 = t1019 * params->csk_a;
  t1603 = t360 * t68 * t158;
  t1604 = t1601 * t1603;
  t1607 = t359 * t1584;
  t1610 = -t1570 * t1065 * t1571 + t1085 * t603 + t606 * t1095 + t606 * t1562 + 0.2e1 * t601 * t1566 + 0.3e1 * t1570 * t1589 - 0.3e1 * t1574 * t1575 - 0.2e1 * t1579 * t1581 + 0.2e1 * t1585 * t608 + 0.2e1 * t1585 * t619 + 0.3e1 * t1595 * t1598 + 0.3e1 * t1595 * t1604 - 0.2e1 * t1607 * t608 - 0.2e1 * t1556 - t1560 - t617;
  t1613 = t1042 * t1578;
  t1614 = t1060 * t1603;
  t1616 = t1044 * t860;
  t1623 = t359 * t360 * t155;
  t1624 = t602 * t383;
  t1625 = t391 * t1624;
  t1626 = t1623 * t1625;
  t1628 = t248 * t360;
  t1631 = t383 * t364 * t1102;
  t1632 = t151 * t1628 * t1631;
  t1634 = t1068 * t360;
  t1635 = t1065 * t1634;
  t1643 = t392 * t379;
  t1644 = t391 * t1643;
  t1647 = my_piecewise3(t61, 0, -0.44e3 / 0.729e3 * t1540);
  t1648 = my_piecewise3(t63, t1647, 0);
  t1651 = t1628 * t383;
  t1652 = t359 * t1651;
  t1653 = t1652 * t1090;
  t1655 = t1652 * t1103;
  t1657 = t248 * t155;
  t1658 = t1657 * t364;
  t1659 = t151 * t1658;
  t1661 = params->csk_a * t360 * t383;
  t1662 = t159 * t1661;
  t1663 = t1659 * t1662;
  t1665 = -t151 * t1648 * t160 - t621 * t1095 + 0.3e1 * t1570 * t1616 - 0.3e1 * t1579 * t1604 - t1579 * t1614 + 0.3e1 * t1595 * t1614 - 0.3e1 * t1613 * t1598 - 0.2e1 * t1607 * t624 - t1613 * t1614 - 0.2e1 * t1613 * t1635 - t621 * t1644 + 0.3e1 * t1626 + 0.3e1 * t1632 - 0.3e1 * t1653 - 0.3e1 * t1655 + 0.3e1 * t1663;
  t1667 = my_piecewise5(t58, 0, t61, 0, t1610 + t1665);
  t1669 = 0.55e2 / 0.81e2 * t1540 - 0.44e3 / 0.729e3 * t1543 + 0.8e2 / 0.243e3 * t1546 - 0.5e1 / 0.81e2 * t1549 + t353 * t251 + 0.2e1 * t149 * t627 + t53 * t1667;
  t1674 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t253 + t1529 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t629 - t1536 + t1538 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1669);
  tv3rho2sigma0 = t8 * t1674 + 0.2e1 * t634;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1681 = t7 * t420 * t270;
  t1685 = t7 * t424 * t270 / 0.3e2;
  t1687 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t270 + t1681 / 0.5e1 - t1685);
  tv3rho2sigma2 = t8 * t1687 + 0.2e1 * t643;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1693 = t7 * t445 * t253;
  t1701 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t253 + t1693 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t629 + t1529 / 0.1e2 - t1536 + t1538 / 0.1e2);
  tv3rho2sigma3 = t8 * t1701 + t634 + t649;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1707 = t7 * t469 * t270;
  t1714 = t7 * t180 * t692;
  t1717 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t270 + t1707 / 0.1e2 + t1681 / 0.1e2 - t1685 + 0.3e1 / 0.2e2 * t7 * t176 * t692 + t1714 / 0.1e2);
  tv3rho2sigma5 = t8 * t1717 + t643 + t697;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1725 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t253 + t1693 / 0.5e1 - t1536);
  tv3rho2sigma6 = t8 * t1725 + 0.2e1 * t649;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1736 = t38 * t524;
  t1739 = t38 * t524 * t115;
  t1742 = t38 * t210 * t231;
  t1745 = t38 * t93 * t575;
  t1750 = t539 * t1418;
  t1751 = t538 * t1750;
  t1752 = t1423 * t665;
  t1755 = t675 * t541;
  t1756 = t220 * t1755;
  t1759 = t675 * t222;
  t1761 = t220 * t1759 * t564;
  t1763 = t265 * t558;
  t1765 = t220 * t1763 * t564;
  t1766 = t227 * t558;
  t1767 = t553 * t1766;
  t1770 = t547 * t675;
  t1771 = t570 * t1770;
  t1774 = t1417 * t1750;
  t1775 = t1443 * t265;
  t1778 = t265 * t1418;
  t1779 = t220 * t1778;
  t1780 = t227 * t539;
  t1781 = t1428 * t1780;
  t1787 = t538 * t1778;
  t1788 = t547 * t1048;
  t1789 = t1788 * t539;
  t1790 = t1423 * t1789;
  t1793 = t538 * t1755;
  t1797 = t539 * t112 * t227;
  t1798 = t1463 * t1797;
  t1803 = -t1774 * t1441 * t1775 + t669 * t1471 + t1474 * t666 - 0.3e1 * t1751 * t1752 + 0.2e1 * t1756 * t671 + 0.2e1 * t1756 * t682 + t669 * t1767 + 0.2e1 * t664 * t1771 - 0.2e1 * t1779 * t1781 + 0.3e1 * t1787 * t1790 + 0.3e1 * t1787 * t1798 - 0.2e1 * t1793 * t671 - 0.2e1 * t1793 * t687 - 0.2e1 * t1761 - t1765 - t680;
  t1806 = t1423 * t888;
  t1810 = t1428 * t1429 * t539;
  t1814 = t1417 * t1778;
  t1816 = t265 * t539;
  t1819 = t562 * t543 * t1486;
  t1820 = t220 * t1816 * t1819;
  t1823 = t538 * t539 * t224;
  t1824 = t665 * t562;
  t1825 = t570 * t1824;
  t1826 = t1823 * t1825;
  t1831 = t571 * t558;
  t1832 = t570 * t1831;
  t1834 = t1444 * t539;
  t1835 = t1441 * t1834;
  t1838 = t1775 * params->csk_a;
  t1839 = t1441 * t1838;
  t1843 = my_piecewise3(t105, 0, -0.44e3 / 0.729e3 * t1736);
  t1844 = my_piecewise3(t107, t1843, 0);
  t1847 = t265 * t224;
  t1848 = t1847 * t543;
  t1849 = t220 * t1848;
  t1851 = params->csk_a * t539 * t562;
  t1852 = t228 * t1851;
  t1853 = t1849 * t1852;
  t1855 = t1816 * t562;
  t1856 = t538 * t1855;
  t1857 = t1856 * t1479;
  t1859 = t1856 * t1487;
  t1861 = -t220 * t1844 * t229 - t684 * t1471 + 0.3e1 * t1774 * t1806 + 0.3e1 * t1774 * t1839 - 0.3e1 * t1779 * t1798 - t1779 * t1810 + 0.3e1 * t1787 * t1810 - 0.3e1 * t1814 * t1790 - t1814 * t1810 - 0.2e1 * t1814 * t1835 - t684 * t1832 + 0.3e1 * t1820 + 0.3e1 * t1826 + 0.3e1 * t1853 - 0.3e1 * t1857 - 0.3e1 * t1859;
  t1863 = my_piecewise5(t104, 0, t105, 0, t1803 + t1861);
  t1865 = 0.55e2 / 0.81e2 * t1736 - 0.44e3 / 0.729e3 * t1739 + 0.8e2 / 0.243e3 * t1742 - 0.5e1 / 0.81e2 * t1745 + t532 * t268 + 0.2e1 * t218 * t690 + t103 * t1863;
  t1870 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t270 + t1707 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t692 - t1685 + t1714 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t1865);
  tv3rho2sigma8 = t8 * t1870 + 0.2e1 * t697;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1877 = t7 * t327 * t286;
  t1884 = t7 * t336 * t286 / 0.3e2;
  t1886 = t7 * t135 * t731;
  t1896 = t718 * t153;
  t1898 = t151 * t1896 * t385;
  t1900 = t281 * t379;
  t1902 = t151 * t1900 * t385;
  t1905 = t368 * t718;
  t1906 = t391 * t1905;
  t1909 = t1067 * t281;
  t1910 = t1065 * t1909;
  t1912 = t281 * t1015;
  t1913 = t151 * t1912;
  t1916 = t1044 * t710;
  t1919 = t718 * t362;
  t1920 = t151 * t1919;
  t1923 = t359 * t1912;
  t1926 = t359 * t1919;
  t1931 = t1042 * t1912;
  t1933 = t710 * params->csk_a;
  t1934 = t1044 * t1933;
  t1938 = t1085 * t711 + t714 * t1562 - t1570 * t1910 + 0.3e1 * t1570 * t1934 - 0.3e1 * t1574 * t1916 - 0.2e1 * t1913 * t1581 - 0.3e1 * t1913 * t1604 + 0.3e1 * t1923 * t1604 - t1913 * t1614 - t1931 * t1614 + 0.2e1 * t601 * t1906 + 0.2e1 * t1920 * t619 - 0.2e1 * t1926 * t608 - 0.2e1 * t1898 - t1902 - t723;
  t1941 = t281 * t360;
  t1943 = t151 * t1941 * t1631;
  t1945 = t710 * t383;
  t1946 = t391 * t1945;
  t1947 = t1623 * t1946;
  t1958 = my_piecewise3(t61, 0, 0.1e3 / 0.243e3 * t591);
  t1959 = my_piecewise3(t63, t1958, 0);
  t1963 = t359 * t1941 * t383;
  t1964 = t1963 * t1103;
  t1967 = t281 * t155 * t364;
  t1968 = t151 * t1967;
  t1969 = t1968 * t1662;
  t1971 = t1963 * t1090;
  t1976 = t1909 * params->csk_a;
  t1977 = t1065 * t1976;
  t1982 = -t151 * t1959 * t160 + t714 * t1095 - t725 * t1095 + 0.3e1 * t1570 * t1977 + 0.3e1 * t1923 * t1598 - 0.3e1 * t1931 * t1598 + 0.3e1 * t1923 * t1614 - 0.2e1 * t1931 * t1635 - t725 * t1644 + 0.2e1 * t1920 * t608 - 0.2e1 * t1926 * t624 + 0.3e1 * t1943 + 0.3e1 * t1947 - 0.3e1 * t1964 + 0.3e1 * t1969 - 0.3e1 * t1971;
  t1984 = my_piecewise5(t58, 0, t61, 0, t1938 + t1982);
  t1986 = 0.1e3 / 0.243e3 * t594 - 0.25e2 / 0.81e2 * t597 + 0.5e1 / 0.54e2 * t38 * t48 * t396 + t353 * t284 + 0.2e1 * t149 * t729 + t53 * t1984;
  t1991 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t286 + t1877 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t731 - t1884 + t1886 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1986);
  tv3rho2lapl0 = t8 * t1991 + 0.2e1 * t736;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1998 = t7 * t420 * t302;
  t2002 = t7 * t424 * t302 / 0.3e2;
  t2004 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t302 + t1998 / 0.5e1 - t2002);
  tv3rho2lapl1 = t8 * t2004 + 0.2e1 * t745;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2010 = t7 * t445 * t286;
  t2018 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t286 + t2010 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t731 + t1877 / 0.1e2 - t1884 + t1886 / 0.1e2);
  tv3rho2lapl2 = t8 * t2018 + t736 + t751;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2024 = t7 * t469 * t302;
  t2031 = t7 * t180 * t782;
  t2034 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t302 + t2024 / 0.1e2 + t1998 / 0.1e2 - t2002 + 0.3e1 / 0.2e2 * t7 * t176 * t782 + t2031 / 0.1e2);
  tv3rho2lapl3 = t8 * t2034 + t745 + t787;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2042 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t286 + t2010 / 0.5e1 - t1884);
  tv3rho2lapl4 = t8 * t2042 + 0.2e1 * t751;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2061 = t769 * t541;
  t2062 = t220 * t2061;
  t2067 = t547 * t769;
  t2068 = t570 * t2067;
  t2071 = t1443 * t297;
  t2072 = t1441 * t2071;
  t2074 = t769 * t222;
  t2076 = t220 * t2074 * t564;
  t2078 = t297 * t558;
  t2080 = t220 * t2078 * t564;
  t2081 = t1423 * t761;
  t2084 = t297 * t1418;
  t2085 = t220 * t2084;
  t2089 = my_piecewise3(t105, 0, 0.1e3 / 0.243e3 * t654);
  t2090 = my_piecewise3(t107, t2089, 0);
  t2093 = t297 * t539;
  t2094 = t2093 * t562;
  t2095 = t538 * t2094;
  t2096 = t2095 * t1487;
  t2099 = t297 * t224 * t543;
  t2100 = t220 * t2099;
  t2101 = t2100 * t1852;
  t2103 = t2095 * t1479;
  t2105 = t538 * t2061;
  t2110 = -t220 * t2090 * t229 + t1474 * t762 - 0.3e1 * t1751 * t2081 + t765 * t1767 - t1774 * t2072 - 0.2e1 * t2085 * t1781 - 0.3e1 * t2085 * t1798 + 0.2e1 * t2062 * t682 + 0.2e1 * t664 * t2068 - 0.2e1 * t2105 * t671 - 0.2e1 * t2076 - t2080 - 0.3e1 * t2096 + 0.3e1 * t2101 - 0.3e1 * t2103 - t774;
  t2111 = t1417 * t2084;
  t2113 = t761 * params->csk_a;
  t2114 = t1423 * t2113;
  t2118 = t538 * t2084;
  t2121 = t761 * t562;
  t2122 = t570 * t2121;
  t2123 = t1823 * t2122;
  t2126 = t220 * t2093 * t1819;
  t2128 = t2071 * params->csk_a;
  t2129 = t1441 * t2128;
  t2147 = t765 * t1471 - t776 * t1471 + 0.3e1 * t1774 * t2114 + 0.3e1 * t1774 * t2129 - 0.3e1 * t2111 * t1790 + 0.3e1 * t2118 * t1790 + 0.3e1 * t2118 * t1798 - t2085 * t1810 - t2111 * t1810 + 0.3e1 * t2118 * t1810 - t776 * t1832 - 0.2e1 * t2111 * t1835 + 0.2e1 * t2062 * t671 - 0.2e1 * t2105 * t687 + 0.3e1 * t2123 + 0.3e1 * t2126;
  t2149 = my_piecewise5(t104, 0, t105, 0, t2110 + t2147);
  t2151 = 0.1e3 / 0.243e3 * t657 - 0.25e2 / 0.81e2 * t660 + 0.5e1 / 0.54e2 * t38 * t98 * t575 + t532 * t300 + 0.2e1 * t218 * t780 + t103 * t2149;
  t2156 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t302 + t2024 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t782 - t2002 + t2031 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t2151);
  tv3rho2lapl5 = t8 * t2156 + 0.2e1 * t787;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2163 = t7 * t135 * t811 / 0.1e2;
  t2165 = t38 * t141 * t251;
  t2168 = t38 * t43 * t627;
  t2171 = t792 * t1015;
  t2172 = t359 * t2171;
  t2173 = t368 * t153;
  t2174 = t1044 * t2173;
  t2177 = t799 * t362;
  t2178 = t151 * t2177;
  t2179 = t2178 * t619;
  t2180 = t151 * t2171;
  t2181 = t1020 * t618;
  t2184 = t158 * t612;
  t2185 = t374 * t2184;
  t2190 = t153 * t1015;
  t2191 = t1042 * t2190;
  t2192 = t1067 * t792;
  t2193 = t1065 * t2192;
  t2195 = t368 * t799;
  t2196 = t391 * t2195;
  t2197 = t601 * t2196;
  t2198 = t799 * t153;
  t2200 = t151 * t2198 * t385;
  t2201 = t248 * t383;
  t2202 = t151 * t2201;
  t2203 = t156 * t68;
  t2205 = t2202 * t2203 * t2184;
  t2206 = 0.2e1 * t2205;
  t2207 = t792 * t155;
  t2209 = t151 * t2207 * t364;
  t2210 = params->csk_a * t153;
  t2211 = t2210 * t383;
  t2212 = t159 * t2211;
  t2213 = t2209 * t2212;
  t2215 = t792 * t383;
  t2217 = t359 * t2215 * t364;
  t2218 = t2210 * t155;
  t2219 = t369 * t2218;
  t2220 = t2217 * t2219;
  t2222 = t2210 * t1102;
  t2223 = t2217 * t2222;
  t2225 = t151 * t2215;
  t2227 = t374 * t618 * t155;
  t2228 = t2225 * t2227;
  t2230 = t159 * t612;
  t2231 = t1100 * t2230;
  t2234 = 0.2e1 * t621 * t1566 - 0.3e1 * t2172 * t2174 - 0.2e1 * t2180 * t2181 + 0.2e1 * t606 * t2185 - t2191 * t2193 - 0.2e1 * t621 * t2231 + t2179 + t2197 - t2200 - t2206 + 0.3e1 * t2213 - 0.3e1 * t2220 - 0.3e1 * t2223 + 0.3e1 * t2228 - t801 - t803;
  t2235 = t1042 * t2171;
  t2236 = t1044 * t623;
  t2239 = t1049 * t153;
  t2240 = t1020 * t2239;
  t2245 = t2178 * t608;
  t2246 = t359 * t2177;
  t2247 = t2246 * t608;
  t2249 = t153 * t68 * t158;
  t2250 = t1601 * t2249;
  t2255 = t369 * t153;
  t2256 = t1060 * t2255;
  t2259 = t392 * t612;
  t2260 = t391 * t2259;
  t2263 = t1068 * t153;
  t2264 = t1065 * t2263;
  t2267 = t359 * t2207;
  t2268 = t2173 * t383;
  t2269 = t391 * t2268;
  t2270 = t2267 * t2269;
  t2272 = t1076 * t153;
  t2273 = t1065 * t2272;
  t2280 = t2246 * t624;
  t2281 = 0.3e1 * t2172 * t2240 + 0.3e1 * t2172 * t2250 + 0.3e1 * t2172 * t2256 - t2180 * t2240 - 0.3e1 * t2180 * t2250 + 0.2e1 * t606 * t2231 + 0.3e1 * t2235 * t2236 - t2235 * t2240 - 0.3e1 * t2235 * t2256 - 0.2e1 * t2235 * t2264 + 0.3e1 * t2235 * t2273 - 0.2e1 * t621 * t2260 + t2245 - t2247 + 0.3e1 * t2270 - t2280;
  t2283 = my_piecewise5(t58, 0, t61, 0, t2234 + t2281);
  t2285 = 0.8e2 / 0.243e3 * t2165 - 0.1e2 / 0.81e2 * t2168 + t149 * t809 + t53 * t2283;
  t2290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t811 + t2163 + 0.3e1 / 0.2e2 * t7 * t32 * t2285);
  tv3rhosigma20 = t8 * t2290 + t815;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2297 = t7 * t180 * t838 / 0.1e2;
  t2299 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t838 + t2297);
  tv3rhosigma25 = t8 * t2299 + t842;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2305 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t811 + t2163);
  tv3rhosigma26 = t8 * t2305 + t815;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2311 = t38 * t210 * t268;
  t2314 = t38 * t93 * t690;
  t2317 = t819 * t1418;
  t2318 = t220 * t2317;
  t2319 = t1428 * t681;
  t2322 = t538 * t2317;
  t2323 = t547 * t222;
  t2324 = t1423 * t2323;
  t2327 = t826 * t541;
  t2328 = t220 * t2327;
  t2329 = t2328 * t682;
  t2332 = t222 * t1418;
  t2333 = t1417 * t2332;
  t2334 = t1443 * t819;
  t2335 = t1441 * t2334;
  t2337 = t547 * t826;
  t2338 = t570 * t2337;
  t2339 = t664 * t2338;
  t2340 = t826 * t222;
  t2342 = t220 * t2340 * t564;
  t2343 = t265 * t562;
  t2344 = t220 * t2343;
  t2345 = t225 * t112;
  t2346 = t227 * t675;
  t2348 = t2344 * t2345 * t2346;
  t2349 = 0.2e1 * t2348;
  t2350 = t553 * t2346;
  t2353 = t819 * t562;
  t2355 = t538 * t2353 * t543;
  t2356 = params->csk_a * t222;
  t2357 = t2356 * t1486;
  t2358 = t2355 * t2357;
  t2360 = t819 * t224;
  t2362 = t220 * t2360 * t543;
  t2363 = t2356 * t562;
  t2364 = t228 * t2363;
  t2365 = t2362 * t2364;
  t2367 = t2356 * t224;
  t2368 = t548 * t2367;
  t2369 = t2355 * t2368;
  t2371 = t554 * t675;
  t2372 = t553 * t2371;
  t2375 = t1788 * t222;
  t2376 = t1423 * t2375;
  t2379 = 0.2e1 * t684 * t1771 - 0.2e1 * t2318 * t2319 - 0.3e1 * t2322 * t2324 + 0.3e1 * t2322 * t2376 - t2333 * t2335 + 0.2e1 * t669 * t2350 + 0.2e1 * t669 * t2372 + t2329 + t2339 - t2342 - t2349 - 0.3e1 * t2358 + 0.3e1 * t2365 - 0.3e1 * t2369 - t828 - t830;
  t2380 = t538 * t2327;
  t2381 = t2380 * t687;
  t2382 = t220 * t2353;
  t2384 = t553 * t681 * t224;
  t2385 = t2382 * t2384;
  t2387 = t1417 * t2317;
  t2388 = t1423 * t686;
  t2391 = t1429 * t222;
  t2392 = t1428 * t2391;
  t2397 = t2328 * t671;
  t2398 = t2380 * t671;
  t2400 = t222 * t112 * t227;
  t2401 = t1463 * t2400;
  t2410 = t571 * t675;
  t2411 = t570 * t2410;
  t2414 = t1444 * t222;
  t2415 = t1441 * t2414;
  t2418 = t538 * t2360;
  t2419 = t2323 * t562;
  t2420 = t570 * t2419;
  t2421 = t2418 * t2420;
  t2423 = t1452 * t222;
  t2424 = t1441 * t2423;
  t2427 = -t2318 * t2392 - 0.3e1 * t2318 * t2401 + 0.3e1 * t2322 * t2392 + 0.3e1 * t2322 * t2401 - 0.2e1 * t684 * t2372 - 0.3e1 * t2387 * t2376 + 0.3e1 * t2387 * t2388 - t2387 * t2392 - 0.2e1 * t2387 * t2415 + 0.3e1 * t2387 * t2424 - 0.2e1 * t684 * t2411 - t2381 + 0.3e1 * t2385 + t2397 - t2398 + 0.3e1 * t2421;
  t2429 = my_piecewise5(t104, 0, t105, 0, t2379 + t2427);
  t2431 = 0.8e2 / 0.243e3 * t2311 - 0.1e2 / 0.81e2 * t2314 + t218 * t836 + t103 * t2429;
  t2436 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t838 + t2297 + 0.3e1 / 0.2e2 * t7 * t88 * t2431);
  tv3rhosigma211 = t8 * t2436 + t842;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2443 = t7 * t135 * t866 / 0.1e2;
  t2449 = t38 * t141 * t284;
  t2452 = t38 * t43 * t729;
  t2457 = t718 * t248;
  t2459 = t151 * t2457 * t385;
  t2460 = t281 * t612;
  t2462 = t151 * t2460 * t385;
  t2465 = t853 * t383;
  t2466 = t359 * t2465;
  t2468 = t1100 * t153 * t1102;
  t2469 = t2466 * t2468;
  t2471 = t159 * params->csk_a;
  t2472 = t615 * t383;
  t2473 = t2471 * t2472;
  t2474 = t1968 * t2473;
  t2476 = t391 * t368;
  t2477 = t2476 * t2218;
  t2478 = t2466 * t2477;
  t2480 = t1912 * t1019;
  t2481 = t359 * t2480;
  t2482 = t159 * t248;
  t2483 = t2210 * t2482;
  t2486 = t151 * t2480;
  t2489 = t1578 * t1019;
  t2490 = t1042 * t2489;
  t2491 = t281 * params->csk_a;
  t2492 = t2491 * t153;
  t2493 = t369 * t2492;
  t2496 = t1048 * t248;
  t2497 = t2496 * t153;
  t2498 = t159 * t2497;
  t2502 = t1607 * t711 + t621 * t1906 + t1920 * t857 + t714 * t2185 + 0.3e1 * t2481 * t2483 + 0.3e1 * t2481 * t2498 - 0.3e1 * t2486 * t2483 - t2486 * t2498 + 0.3e1 * t2490 * t2493 + t2179 + t2197 - t2200 - t2459 - t2462 - 0.3e1 * t2469 + 0.3e1 * t2474 - 0.3e1 * t2478 - t801 - t855;
  t2503 = t1042 * t2480;
  t2505 = t1113 * t2497;
  t2508 = t369 * t2497;
  t2511 = t151 * t2465;
  t2512 = t2511 * t2227;
  t2516 = t359 * t1658;
  t2517 = t721 * t383;
  t2518 = t369 * t2517;
  t2519 = t2516 * t2518;
  t2521 = t1113 * t2492;
  t2527 = t856 * t153;
  t2528 = t1020 * t2527;
  t2532 = t1044 * t710 * t153;
  t2537 = t1571 * t281;
  t2538 = t1065 * t2537;
  t2541 = -0.3e1 * t1595 * t2532 - 0.2e1 * t1913 * t2528 + t1920 * t851 - t1926 * t851 - t1926 * t861 - t2191 * t2538 + t714 * t2231 - t725 * t2231 - t725 * t2260 + 0.3e1 * t2481 * t2508 + 0.3e1 * t2490 * t2521 - t2503 * t2498 - 0.2e1 * t2503 * t2505 - 0.3e1 * t2503 * t2508 + t2245 - t2247 - t2280 + 0.3e1 * t2512 + 0.3e1 * t2519;
  t2543 = my_piecewise5(t58, 0, t61, 0, t2502 + t2541);
  t2545 = -0.25e2 / 0.162e3 * t790 + 0.5e1 / 0.54e2 * t38 * t48 * t627 + 0.4e2 / 0.243e3 * t2449 - 0.5e1 / 0.81e2 * t2452 + t149 * t864 + t53 * t2543;
  t2550 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t866 + t2443 + 0.3e1 / 0.2e2 * t7 * t32 * t2545);
  tv3rhosigmalapl0 = t8 * t2550 + t870;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2557 = t7 * t180 * t894 / 0.1e2;
  t2559 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t894 + t2557);
  tv3rhosigmalapl5 = t8 * t2559 + t898;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2565 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t866 + t2443);
  tv3rhosigmalapl6 = t8 * t2565 + t870;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2575 = t38 * t210 * t300;
  t2578 = t38 * t93 * t780;
  t2583 = t769 * t265;
  t2585 = t220 * t2583 * t564;
  t2586 = t297 * t675;
  t2588 = t220 * t2586 * t564;
  t2591 = t881 * t562;
  t2592 = t538 * t2591;
  t2594 = t1484 * t222 * t1486;
  t2595 = t2592 * t2594;
  t2597 = t228 * params->csk_a;
  t2598 = t678 * t562;
  t2600 = t2100 * t2597 * t2598;
  t2602 = t570 * t547;
  t2603 = t2602 * t2367;
  t2604 = t2592 * t2603;
  t2606 = t2084 * t1422;
  t2607 = t538 * t2606;
  t2608 = t228 * t265;
  t2609 = t2356 * t2608;
  t2612 = t220 * t2606;
  t2615 = t1778 * t1422;
  t2616 = t1417 * t2615;
  t2617 = t297 * params->csk_a;
  t2618 = t2617 * t222;
  t2619 = t548 * t2618;
  t2622 = t1048 * t265;
  t2623 = t2622 * t222;
  t2624 = t228 * t2623;
  t2628 = t1793 * t762 + t2062 * t885 + t684 * t2068 + t765 * t2350 + 0.3e1 * t2607 * t2609 + 0.3e1 * t2607 * t2624 - 0.3e1 * t2612 * t2609 - t2612 * t2624 + 0.3e1 * t2616 * t2619 + t2329 + t2339 - t2342 - t2585 - t2588 - 0.3e1 * t2595 + 0.3e1 * t2600 - 0.3e1 * t2604 - t828 - t883;
  t2629 = t1417 * t2606;
  t2631 = t548 * t222;
  t2632 = t2622 * t2631;
  t2635 = t1497 * t2623;
  t2638 = t538 * t1848;
  t2640 = t548 * t772 * t562;
  t2641 = t2638 * t2640;
  t2643 = t1497 * t2618;
  t2648 = t220 * t2591;
  t2649 = t2648 * t2384;
  t2652 = t1423 * t761 * t222;
  t2655 = t884 * t222;
  t2656 = t1428 * t2655;
  t2663 = t1775 * t297;
  t2664 = t1441 * t2663;
  t2668 = -0.3e1 * t1787 * t2652 + t2062 * t879 - 0.2e1 * t2085 * t2656 - t2105 * t879 - t2105 * t889 - t2333 * t2664 + t765 * t2372 - t776 * t2372 - t776 * t2411 + 0.3e1 * t2607 * t2632 + 0.3e1 * t2616 * t2643 - t2629 * t2624 - 0.3e1 * t2629 * t2632 - 0.2e1 * t2629 * t2635 - t2381 + t2397 - t2398 + 0.3e1 * t2641 + 0.3e1 * t2649;
  t2670 = my_piecewise5(t104, 0, t105, 0, t2628 + t2668);
  t2672 = -0.25e2 / 0.162e3 * t817 + 0.5e1 / 0.54e2 * t38 * t98 * t690 + 0.4e2 / 0.243e3 * t2575 - 0.5e1 / 0.81e2 * t2578 + t218 * t892 + t103 * t2670;
  t2677 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t894 + t2557 + 0.3e1 / 0.2e2 * t7 * t88 * t2672);
  tv3rhosigmalapl11 = t8 * t2677 + t898;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2684 = t7 * t135 * t917 / 0.1e2;
  t2690 = t281 * t383;
  t2691 = t151 * t2690;
  t2692 = t158 * t718;
  t2694 = t2691 * t2203 * t2692;
  t2695 = 0.2e1 * t2694;
  t2701 = t1067 * t902;
  t2702 = t1065 * t2701;
  t2704 = t902 * t1015;
  t2705 = t151 * t2704;
  t2708 = t359 * t2704;
  t2711 = t902 * t155;
  t2713 = t151 * t2711 * t364;
  t2714 = t2713 * t2212;
  t2716 = t902 * t383;
  t2718 = t359 * t2716 * t364;
  t2719 = t2718 * t2219;
  t2721 = t2718 * t2222;
  t2724 = t374 * t375 * t718;
  t2729 = 0.2e1 * t714 * t374 * t2692 + 0.2e1 * t725 * t1906 - 0.3e1 * t2708 * t2174 - 0.2e1 * t2705 * t2181 - t2191 * t2702 + 0.3e1 * t2708 * t2256 + 0.2e1 * t714 * t2724 + t2179 + t2197 - t2200 - t2695 + 0.3e1 * t2714 - 0.3e1 * t2719 - 0.3e1 * t2721 - t801 - t909;
  t2730 = t151 * t2716;
  t2731 = t2730 * t2227;
  t2735 = t1042 * t2704;
  t2748 = t392 * t718;
  t2754 = t359 * t2711;
  t2755 = t2754 * t2269;
  t2759 = -0.2e1 * t725 * t391 * t2748 + 0.3e1 * t2735 * t2236 - t2705 * t2240 + 0.3e1 * t2708 * t2240 - t2735 * t2240 - 0.3e1 * t2705 * t2250 + 0.3e1 * t2708 * t2250 - 0.3e1 * t2735 * t2256 - 0.2e1 * t2735 * t2264 + 0.3e1 * t2735 * t2273 - 0.2e1 * t725 * t2724 + t2245 - t2247 - t2280 + 0.3e1 * t2731 + 0.3e1 * t2755;
  t2761 = my_piecewise5(t58, 0, t61, 0, t2729 + t2759);
  t2763 = -0.25e2 / 0.81e2 * t847 + 0.5e1 / 0.27e2 * t38 * t48 * t729 + t149 * t915 + t53 * t2761;
  t2768 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t917 + t2684 + 0.3e1 / 0.2e2 * t7 * t32 * t2763);
  tv3rholapl20 = t8 * t2768 + t921;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2775 = t7 * t180 * t940 / 0.1e2;
  t2777 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t940 + t2775);
  tv3rholapl22 = t8 * t2777 + t944;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2783 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t917 + t2684);
  tv3rholapl23 = t8 * t2783 + t921;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2793 = t925 * t1418;
  t2794 = t220 * t2793;
  t2799 = t1443 * t925;
  t2800 = t1441 * t2799;
  t2802 = t297 * t562;
  t2803 = t220 * t2802;
  t2804 = t227 * t769;
  t2806 = t2803 * t2345 * t2804;
  t2807 = 0.2e1 * t2806;
  t2811 = t538 * t2793;
  t2814 = t925 * t224;
  t2816 = t220 * t2814 * t543;
  t2817 = t2816 * t2364;
  t2819 = t925 * t562;
  t2821 = t538 * t2819 * t543;
  t2822 = t2821 * t2368;
  t2824 = t2821 * t2357;
  t2828 = t1417 * t2793;
  t2830 = 0.2e1 * t765 * t553 * t2804 + 0.2e1 * t776 * t2068 - 0.2e1 * t2794 * t2319 - 0.3e1 * t2811 * t2324 - t2333 * t2800 + 0.3e1 * t2811 * t2392 - t2828 * t2392 + t2329 + t2339 - t2342 - t2807 + 0.3e1 * t2817 - 0.3e1 * t2822 - 0.3e1 * t2824 - t828 - t932;
  t2833 = t571 * t769;
  t2839 = t538 * t2814;
  t2840 = t2839 * t2420;
  t2845 = t553 * t554 * t769;
  t2850 = t220 * t2819;
  t2851 = t2850 * t2384;
  t2862 = -0.2e1 * t776 * t570 * t2833 + 0.3e1 * t2811 * t2376 - 0.3e1 * t2828 * t2376 + 0.3e1 * t2828 * t2388 - t2794 * t2392 - 0.3e1 * t2794 * t2401 + 0.3e1 * t2811 * t2401 - 0.2e1 * t2828 * t2415 + 0.3e1 * t2828 * t2424 + 0.2e1 * t765 * t2845 - 0.2e1 * t776 * t2845 - t2381 + t2397 - t2398 + 0.3e1 * t2840 + 0.3e1 * t2851;
  t2864 = my_piecewise5(t104, 0, t105, 0, t2830 + t2862);
  t2866 = -0.25e2 / 0.81e2 * t875 + 0.5e1 / 0.27e2 * t38 * t98 * t780 + t218 * t938 + t103 * t2864;
  t2871 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t940 + t2775 + 0.3e1 / 0.2e2 * t7 * t88 * t2866);
  tv3rholapl25 = t8 * t2871 + t944;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2874 = t38 * t43 * t809;
  t2876 = t792 * t248;
  t2877 = t2876 * t1015;
  t2878 = t151 * t2877;
  t2881 = t799 * t248;
  t2883 = t151 * t2881 * t385;
  t2884 = 0.3e1 * t2883;
  t2885 = t1042 * t2877;
  t2890 = t621 * t2196;
  t2891 = 0.3e1 * t2890;
  t2894 = t359 * t2877;
  t2897 = t2178 * t857;
  t2898 = 0.3e1 * t2897;
  t2899 = t2876 * t383;
  t2900 = t151 * t2899;
  t2901 = t2900 * t1031;
  t2902 = 0.3e1 * t2901;
  t2903 = t2876 * t155;
  t2905 = t359 * t2903 * t1037;
  t2906 = 0.3e1 * t2905;
  t2912 = -0.3e1 * t2878 * t1021 + 0.3e1 * t2885 * t1045 - t2878 * t1050 + 0.3e1 * t2894 * t1050 - 0.3e1 * t2885 * t1061 + 0.3e1 * t2894 * t1061 - 0.2e1 * t2885 * t1069 + 0.3e1 * t2885 * t1077 - t2884 + t2891 + t2898 + t2902 + t2906;
  t2924 = t375 * t799;
  t2925 = t374 * t2924;
  t2926 = t606 * t2925;
  t2927 = 0.3e1 * t2926;
  t2928 = t2246 * t851;
  t2929 = 0.3e1 * t2928;
  t2930 = t359 * t2899;
  t2931 = t2930 * t1103;
  t2932 = 0.3e1 * t2931;
  t2934 = t151 * t2903 * t1108;
  t2935 = 0.3e1 * t2934;
  t2936 = t2246 * t861;
  t2937 = 0.3e1 * t2936;
  t2938 = t2930 * t1090;
  t2939 = 0.3e1 * t2938;
  t2940 = -t1042 * t2876 * t1114 - 0.2e1 * t151 * t2876 * t1121 - 0.3e1 * t359 * t2876 * t1125 + 0.3e1 * t2894 * t1021 - t2885 * t1050 + t2927 - t2929 - t2932 + t2935 - t2937 - t2939 - t801 - t803;
  t2942 = my_piecewise5(t58, 0, t61, 0, t2912 + t2940);
  t2944 = -0.5e1 / 0.27e2 * t2874 + t53 * t2942;
  t2948 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t2944);
  tv3sigma30 = t8 * t2948;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2950 = t38 * t93 * t836;
  t2952 = t819 * t265;
  t2953 = t2952 * t1418;
  t2954 = t220 * t2953;
  t2957 = t1417 * t2953;
  t2962 = t684 * t2338;
  t2963 = 0.3e1 * t2962;
  t2966 = t538 * t2953;
  t2969 = t826 * t265;
  t2971 = t220 * t2969 * t564;
  t2972 = 0.3e1 * t2971;
  t2973 = t2952 * t562;
  t2974 = t220 * t2973;
  t2975 = t2974 * t1412;
  t2976 = 0.3e1 * t2975;
  t2977 = t2952 * t224;
  t2979 = t538 * t2977 * t1402;
  t2980 = 0.3e1 * t2979;
  t2981 = t2328 * t885;
  t2982 = 0.3e1 * t2981;
  t2988 = 0.3e1 * t2957 * t1424 - t2957 * t1430 + 0.3e1 * t2966 * t1430 - 0.3e1 * t2957 * t1437 + 0.3e1 * t2966 * t1437 - 0.2e1 * t2957 * t1445 + 0.3e1 * t2957 * t1453 - 0.3e1 * t2954 * t1464 + t2963 - t2972 + t2976 + t2980 + t2982;
  t3000 = t554 * t826;
  t3001 = t553 * t3000;
  t3002 = t669 * t3001;
  t3003 = 0.3e1 * t3002;
  t3004 = t2380 * t879;
  t3005 = 0.3e1 * t3004;
  t3006 = t538 * t2973;
  t3007 = t3006 * t1487;
  t3008 = 0.3e1 * t3007;
  t3010 = t220 * t2977 * t1492;
  t3011 = 0.3e1 * t3010;
  t3012 = t2380 * t889;
  t3013 = 0.3e1 * t3012;
  t3014 = t3006 * t1479;
  t3015 = 0.3e1 * t3014;
  t3016 = -t1417 * t2952 * t1498 - 0.3e1 * t538 * t2952 * t1505 - 0.2e1 * t220 * t2952 * t1509 - t2954 * t1430 + 0.3e1 * t2966 * t1464 + t3003 - t3005 - t3008 + t3011 - t3013 - t3015 - t828 - t830;
  t3018 = my_piecewise5(t104, 0, t105, 0, t2988 + t3016);
  t3020 = -0.5e1 / 0.27e2 * t2950 + t103 * t3018;
  t3024 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3020);
  tv3sigma39 = t8 * t3024;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3029 = t38 * t43 * t864;
  t3033 = t158 * t799;
  t3034 = t374 * t3033;
  t3035 = t714 * t3034;
  t3036 = t2246 * t711;
  t3038 = t281 * t799;
  t3040 = t151 * t3038 * t385;
  t3041 = t158 * t792;
  t3042 = t1020 * t3041;
  t3045 = 0.2e1 * t2883;
  t3046 = 0.2e1 * t2890;
  t3047 = 0.2e1 * t2897;
  t3048 = t281 * t792;
  t3049 = t3048 * t383;
  t3050 = t359 * t3049;
  t3051 = t3050 * t1103;
  t3052 = 0.3e1 * t3051;
  t3053 = params->csk_a * t792;
  t3054 = t3053 * t383;
  t3055 = t159 * t3054;
  t3056 = t1968 * t3055;
  t3057 = 0.3e1 * t3056;
  t3058 = t3050 * t1090;
  t3059 = 0.3e1 * t3058;
  t3061 = t792 * t68 * t158;
  t3062 = t1060 * t3061;
  t3066 = -t2235 * t1910 - 0.2e1 * t1913 * t3042 - 0.3e1 * t2172 * t1916 + 0.3e1 * t1923 * t3062 - t1931 * t3062 + t3035 + t3036 - t3040 - t3045 + t3046 + t3047 - t3052 + t3057 - t3059 - t801 - t855;
  t3069 = t714 * t2925;
  t3070 = t1596 * t792;
  t3071 = t1044 * t3070;
  t3074 = t1601 * t3061;
  t3082 = t725 * t2925;
  t3085 = t392 * t799;
  t3086 = t391 * t3085;
  t3087 = t725 * t3086;
  t3088 = t1068 * t792;
  t3089 = t1065 * t3088;
  t3092 = t151 * t3048;
  t3093 = t3092 * t1631;
  t3094 = 0.3e1 * t3093;
  t3095 = t2267 * t1946;
  t3096 = 0.3e1 * t3095;
  t3097 = 0.2e1 * t2926;
  t3098 = 0.2e1 * t2928;
  t3099 = 0.2e1 * t2936;
  t3100 = -t1913 * t3062 - 0.3e1 * t1913 * t3074 + 0.3e1 * t1923 * t3071 + 0.3e1 * t1923 * t3074 - 0.3e1 * t1931 * t3071 - 0.2e1 * t1931 * t3089 + 0.3e1 * t2235 * t1934 + 0.3e1 * t2235 * t1977 + t3069 - t3082 - t3087 + t3094 + t3096 + t3097 - t3098 - t3099;
  t3102 = my_piecewise5(t58, 0, t61, 0, t3066 + t3100);
  t3104 = 0.5e1 / 0.54e2 * t38 * t48 * t809 - 0.1e2 / 0.81e2 * t3029 + t53 * t3102;
  t3108 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3104);
  tv3sigma2lapl0 = t8 * t3108;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3113 = t38 * t93 * t892;
  t3115 = t227 * t819;
  t3116 = t1428 * t3115;
  t3121 = t227 * t826;
  t3122 = t553 * t3121;
  t3123 = t765 * t3122;
  t3124 = t2380 * t762;
  t3128 = t220 * t297 * t826 * t564;
  t3129 = 0.2e1 * t2962;
  t3130 = 0.2e1 * t2971;
  t3131 = 0.2e1 * t2981;
  t3132 = t297 * t819;
  t3133 = t3132 * t562;
  t3134 = t538 * t3133;
  t3135 = t3134 * t1487;
  t3136 = 0.3e1 * t3135;
  t3137 = params->csk_a * t819;
  t3138 = t3137 * t562;
  t3139 = t228 * t3138;
  t3140 = t2100 * t3139;
  t3141 = 0.3e1 * t3140;
  t3142 = t3134 * t1479;
  t3143 = 0.3e1 * t3142;
  t3145 = t819 * t112 * t227;
  t3146 = t1463 * t3145;
  t3151 = -t2387 * t2072 - 0.3e1 * t2322 * t2081 - 0.2e1 * t2085 * t3116 - 0.3e1 * t2085 * t3146 + 0.3e1 * t2118 * t3146 + t3123 + t3124 - t3128 + t3129 - t3130 + t3131 - t3136 + t3141 - t3143 - t828 - t883;
  t3154 = t1429 * t819;
  t3155 = t1428 * t3154;
  t3160 = t776 * t3001;
  t3163 = t1436 * t819 * t545 * t547;
  t3166 = t571 * t826;
  t3167 = t570 * t3166;
  t3168 = t776 * t3167;
  t3169 = t1444 * t819;
  t3170 = t1441 * t3169;
  t3175 = t765 * t3001;
  t3178 = t2418 * t2122;
  t3179 = 0.3e1 * t3178;
  t3180 = t220 * t3132;
  t3181 = t3180 * t1819;
  t3182 = 0.3e1 * t3181;
  t3183 = 0.2e1 * t3002;
  t3184 = 0.2e1 * t3004;
  t3185 = 0.2e1 * t3012;
  t3186 = -t2085 * t3155 - t2111 * t3155 - 0.3e1 * t2111 * t3163 - 0.2e1 * t2111 * t3170 + 0.3e1 * t2387 * t2114 + 0.3e1 * t2118 * t3155 + 0.3e1 * t2118 * t3163 + 0.3e1 * t2387 * t2129 - t3160 - t3168 + t3175 + t3179 + t3182 + t3183 - t3184 - t3185;
  t3188 = my_piecewise5(t104, 0, t105, 0, t3151 + t3186);
  t3190 = 0.5e1 / 0.54e2 * t38 * t98 * t836 - 0.1e2 / 0.81e2 * t3113 + t103 * t3188;
  t3194 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3190);
  tv3sigma2lapl11 = t8 * t3194;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3199 = t38 * t43 * t915;
  t3207 = 0.2e1 * t3035;
  t3208 = 0.2e1 * t3036;
  t3209 = 0.2e1 * t3040;
  t3210 = params->csk_a * t248;
  t3211 = t3210 * t155;
  t3213 = t2718 * t369 * t3211;
  t3214 = 0.3e1 * t3213;
  t3216 = t2718 * t3210 * t1102;
  t3217 = 0.3e1 * t3216;
  t3218 = t3210 * t383;
  t3220 = t2713 * t159 * t3218;
  t3221 = 0.3e1 * t3220;
  t3222 = t1060 * t2482;
  t3226 = -0.2e1 * t2705 * t1020 * t856 - 0.3e1 * t2708 * t1575 - t1613 * t2702 + 0.3e1 * t2735 * t1616 - t2735 * t3222 - t2883 + t2890 + t2897 + t3207 + t3208 - t3209 - t3214 - t3217 + t3221 - t801 - t909;
  t3230 = t1601 * t2482;
  t3233 = t1068 * t248;
  t3237 = t1596 * t248;
  t3238 = t1044 * t3237;
  t3243 = t2730 * t374 * t856 * t155;
  t3244 = 0.3e1 * t3243;
  t3247 = t2754 * t1625;
  t3248 = 0.3e1 * t3247;
  t3253 = 0.2e1 * t3069;
  t3254 = 0.2e1 * t3082;
  t3255 = 0.2e1 * t3087;
  t3256 = -0.2e1 * t2735 * t1065 * t3233 + 0.3e1 * t2735 * t1589 - t2705 * t3222 - 0.3e1 * t2705 * t3230 + 0.3e1 * t2708 * t3222 + 0.3e1 * t2708 * t3230 + 0.3e1 * t2708 * t3238 - 0.3e1 * t2735 * t3238 + t2926 - t2928 - t2936 + t3244 + t3248 + t3253 - t3254 - t3255;
  t3258 = my_piecewise5(t58, 0, t61, 0, t3226 + t3256);
  t3260 = 0.5e1 / 0.27e2 * t38 * t48 * t864 - 0.5e1 / 0.81e2 * t3199 + t53 * t3258;
  t3264 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3260);
  tv3sigmalapl20 = t8 * t3264;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3269 = t38 * t93 * t938;
  t3277 = 0.2e1 * t3123;
  t3278 = 0.2e1 * t3124;
  t3279 = 0.2e1 * t3128;
  t3280 = params->csk_a * t265;
  t3281 = t3280 * t562;
  t3283 = t2816 * t228 * t3281;
  t3284 = 0.3e1 * t3283;
  t3285 = t3280 * t224;
  t3287 = t2821 * t548 * t3285;
  t3288 = 0.3e1 * t3287;
  t3290 = t2821 * t3280 * t1486;
  t3291 = 0.3e1 * t3290;
  t3292 = t1463 * t2608;
  t3297 = -0.2e1 * t2794 * t1428 * t884 - 0.3e1 * t2811 * t1752 - t1814 * t2800 + 0.3e1 * t2828 * t1839 + 0.3e1 * t2811 * t3292 + t2962 - t2971 + t2981 + t3277 + t3278 - t3279 + t3284 - t3288 - t3291 - t828 - t932;
  t3302 = t1429 * t265;
  t3303 = t1428 * t3302;
  t3308 = t1444 * t265;
  t3312 = t1788 * t265;
  t3313 = t1423 * t3312;
  t3318 = t2850 * t553 * t884 * t224;
  t3319 = 0.3e1 * t3318;
  t3322 = t2839 * t1825;
  t3323 = 0.3e1 * t3322;
  t3324 = 0.2e1 * t3160;
  t3325 = 0.2e1 * t3168;
  t3326 = 0.2e1 * t3175;
  t3327 = -0.2e1 * t2828 * t1441 * t3308 + 0.3e1 * t2828 * t1806 - 0.3e1 * t2794 * t3292 - t2794 * t3303 + 0.3e1 * t2811 * t3303 + 0.3e1 * t2811 * t3313 - t2828 * t3303 - 0.3e1 * t2828 * t3313 + t3002 - t3004 - t3012 + t3319 + t3323 - t3324 - t3325 + t3326;
  t3329 = my_piecewise5(t104, 0, t105, 0, t3297 + t3327);
  t3331 = 0.5e1 / 0.27e2 * t38 * t98 * t892 - 0.5e1 / 0.81e2 * t3269 + t103 * t3329;
  t3335 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3331);
  tv3sigmalapl28 = t8 * t3335;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3339 = t902 * t281;
  t3340 = t3339 * t1015;
  t3341 = t1042 * t3340;
  t3348 = t359 * t3340;
  t3351 = t3339 * t383;
  t3352 = t151 * t3351;
  t3353 = t3352 * t1031;
  t3354 = 0.3e1 * t3353;
  t3355 = t3339 * t155;
  t3357 = t359 * t3355 * t1037;
  t3358 = 0.3e1 * t3357;
  t3359 = t151 * t3340;
  t3370 = 0.3e1 * t3035;
  t3371 = 0.3e1 * t3348 * t1021 - 0.3e1 * t3359 * t1021 + 0.3e1 * t3341 * t1045 - t3341 * t1050 + 0.3e1 * t3348 * t1050 - t3359 * t1050 - 0.3e1 * t3341 * t1061 + 0.3e1 * t3348 * t1061 - 0.2e1 * t3341 * t1069 + 0.3e1 * t3341 * t1077 + t3354 + t3358 + t3370;
  t3372 = 0.3e1 * t3036;
  t3373 = 0.3e1 * t3040;
  t3374 = t359 * t3351;
  t3375 = t3374 * t1103;
  t3376 = 0.3e1 * t3375;
  t3377 = t3374 * t1090;
  t3378 = 0.3e1 * t3377;
  t3380 = t151 * t3355 * t1108;
  t3381 = 0.3e1 * t3380;
  t3382 = 0.3e1 * t3069;
  t3383 = 0.3e1 * t3082;
  t3384 = 0.3e1 * t3087;
  t3393 = -t1042 * t3339 * t1114 - 0.2e1 * t151 * t3339 * t1121 - 0.3e1 * t359 * t3339 * t1125 + t3372 - t3373 - t3376 - t3378 + t3381 + t3382 - t3383 - t3384 - t801 - t909;
  t3395 = my_piecewise5(t58, 0, t61, 0, t3371 + t3393);
  t3397 = 0.5e1 / 0.18e2 * t38 * t48 * t915 + t53 * t3395;
  t3401 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3397);
  tv3lapl30 = t8 * t3401;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3405 = 0.3e1 * t3123;
  t3406 = 0.3e1 * t3124;
  t3407 = 0.3e1 * t3128;
  t3408 = t925 * t297;
  t3409 = t3408 * t562;
  t3410 = t538 * t3409;
  t3411 = t3410 * t1479;
  t3412 = 0.3e1 * t3411;
  t3413 = t3408 * t224;
  t3415 = t220 * t3413 * t1492;
  t3416 = 0.3e1 * t3415;
  t3417 = t3410 * t1487;
  t3418 = 0.3e1 * t3417;
  t3419 = 0.3e1 * t3160;
  t3420 = 0.3e1 * t3168;
  t3421 = 0.3e1 * t3175;
  t3428 = -0.3e1 * t538 * t3408 * t1505 - 0.2e1 * t220 * t3408 * t1509 + t3405 + t3406 - t3407 - t3412 + t3416 - t3418 - t3419 - t3420 + t3421 - t828 - t932;
  t3431 = t3408 * t1418;
  t3432 = t538 * t3431;
  t3435 = t1417 * t3431;
  t3445 = t538 * t3413 * t1402;
  t3446 = 0.3e1 * t3445;
  t3447 = t220 * t3409;
  t3448 = t3447 * t1412;
  t3449 = 0.3e1 * t3448;
  t3450 = t220 * t3431;
  t3459 = -t1417 * t3408 * t1498 + 0.3e1 * t3435 * t1424 + 0.3e1 * t3432 * t1430 - t3435 * t1430 - t3450 * t1430 + 0.3e1 * t3432 * t1437 - 0.3e1 * t3435 * t1437 - 0.2e1 * t3435 * t1445 + 0.3e1 * t3435 * t1453 + 0.3e1 * t3432 * t1464 - 0.3e1 * t3450 * t1464 + t3446 + t3449;
  t3461 = my_piecewise5(t104, 0, t105, 0, t3428 + t3459);
  t3463 = 0.5e1 / 0.18e2 * t38 * t98 * t938 + t103 * t3461;
  t3467 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3463);
  tv3lapl33 = t8 * t3467;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t3471 = t7 * t336 * t398;
  t3474 = t7 * t135 * t1132;
  t3480 = t38 * sigma[0] / t41 / t343 / t39;
  t3486 = 0.154e5 / 0.2187e4 * t38 * lapl[0] * t1000 - 0.10472e6 / 0.6561e4 * t3480;
  t3500 = t379 * t360;
  t3501 = t3500 * t383;
  t3502 = t359 * t3501;
  t3511 = t379 * t1015;
  t3515 = t360 * t360;
  t3516 = t3515 * t383;
  t3519 = t362 * t68 * t158;
  t3520 = t1601 * t3519;
  t3523 = t3515 * t362;
  t3524 = t151 * t3523;
  t3525 = t1020 * t1107;
  t3528 = t151 * t1569;
  t3530 = t1020 * t1049 * t379;
  t3534 = t1020 * t1049 * t383;
  t3537 = t1044 * t1643;
  t3540 = t1042 * t3523;
  t3542 = t1065 * t1076 * t383;
  t3545 = t359 * t3523;
  t3547 = t1044 * t1596 * t383;
  t3557 = 0.18e2 * t151 * t3500 * t1631 + 0.18e2 * t359 * t3511 * t1604 + 0.18e2 * t359 * t3516 * t3520 + 0.18e2 * t1570 * t3537 - 0.18e2 * t3524 * t3525 - 0.6e1 * t3524 * t3534 - 0.6e1 * t3528 * t3530 - 0.6e1 * t3540 * t3534 + 0.18e2 * t3545 * t3534 + 0.18e2 * t3540 * t3542 + 0.18e2 * t3545 * t3547;
  t3561 = t1117 * t362;
  t3562 = t359 * t3561;
  t3566 = t1044 * t1036 * params->csk_a;
  t3569 = t1067 * t379;
  t3571 = t1065 * t3569 * params->csk_a;
  t3575 = t1044 * t1596 * t379;
  t3581 = t391 * t1072 * t383;
  t3587 = t1065 * t1068 * t379;
  t3594 = t1065 * t1068 * t383;
  t3599 = t1020 * t1094;
  t3602 = t151 * t3561;
  t3605 = t379 * t379;
  t3606 = t151 * t3605;
  t3614 = t359 * t3515;
  t3615 = t383 * t383;
  t3616 = t3615 * t364;
  t3617 = t3616 * t369;
  t3620 = t151 * t3515;
  t3621 = t3616 * t159;
  t3624 = t362 * t362;
  t3625 = t363 * t363;
  t3626 = 0.1e1 / t3625;
  t3627 = t3624 * t3626;
  t3628 = t3627 * t159;
  t3632 = t3627 * t1113;
  t3635 = 0.6e1 * t1042 * t3515 * t3632 + 0.3e1 * t359 * t3605 * t370 - 0.18e2 * t3528 * t3599 - 0.12e2 * t3540 * t3594 - 0.4e1 * t3562 * t624 + 0.4e1 * t3602 * t608 - 0.3e1 * t3606 * t385 + 0.3e1 * t3606 * t387 + 0.3e1 * t3614 * t3617 + 0.3e1 * t3620 * t3621 + 0.6e1 * t3620 * t3628;
  t3638 = t357 * t357;
  t3640 = t70 / t3638;
  t3642 = t366 * t366;
  t3643 = t367 * t367;
  t3644 = 0.1e1 / t3643;
  t3645 = t3642 * t3644;
  t3646 = t3627 * t3645;
  t3648 = my_piecewise3(t61, 0, t3486);
  t3649 = my_piecewise3(t63, t3648, 0);
  t3652 = t3627 * t369;
  t3655 = t1044 * t1036;
  t3658 = t3515 * t3624;
  t3659 = t1042 * t3658;
  t3660 = t3626 * t366;
  t3661 = t3660 * t392;
  t3664 = t359 * t3658;
  t3667 = t3640 * t3658;
  t3668 = t3660 * t1596;
  t3671 = t1048 * params->csk_a;
  t3672 = t3626 * t3671;
  t3673 = t3672 * t369;
  t3680 = t3626 * t1064;
  t3681 = t3680 * t1068;
  t3685 = t3672 * t1113;
  t3688 = t3626 * t3642;
  t3690 = t3688 * t3644 * t1048;
  t3693 = t3644 * t3671;
  t3694 = t3688 * t3693;
  t3705 = t3688 * t3644 * params->csk_a;
  t3710 = t3605 * t362;
  t3714 = t359 * t3710;
  t3721 = 0.4e1 * t601 * t391 * t368 * t1117 - 0.6e1 * t1570 * t1065 * t3569 + 0.3e1 * t151 * t3710 * t376 + 0.4e1 * t3602 * t619 + 0.18e2 * t3659 * t3673 - 0.12e2 * t3667 * t3685 + 0.11e2 * t3667 * t3690 - 0.6e1 * t3667 * t3694 - 0.6e1 * t3667 * t3705 - 0.3e1 * t3714 * t376 - 0.3e1 * t3714 * t393;
  t3724 = t1065 * t1067 * t383;
  t3727 = t3515 * t3615;
  t3728 = t359 * t3727;
  t3731 = t3626 * params->csk_a;
  t3732 = t3731 * t159;
  t3738 = t151 * t3658;
  t3745 = t158 * t362;
  t3746 = t1020 * t3745;
  t3751 = t1044 * t1072;
  t3754 = t3680 * t1076;
  t3759 = -0.12e2 * t151 * t3511 * t1581 - 0.12e2 * t151 * t3516 * t3746 + 0.3e1 * t151 * t3727 * t376 - 0.18e2 * t1574 * t3751 - 0.6e1 * t3540 * t3724 - 0.6e1 * t3659 * t3681 - 0.12e2 * t3659 * t3754 - 0.11e2 * t3664 * t3668 - 0.11e2 * t3664 * t3732 - 0.3e1 * t3728 * t393 + 0.11e2 * t3738 * t3732;
  t3762 = t3626 * t1048;
  t3763 = t3762 * t159;
  t3768 = t3626 * t68;
  t3769 = t158 * t3671;
  t3770 = t3768 * t3769;
  t3785 = 0.12e2 * t3659 * t3685 + 0.6e1 * t3659 * t3763 + 0.6e1 * t3659 * t3770 - 0.7e1 * t3664 * t3673 - 0.18e2 * t3664 * t3763 - 0.7e1 * t3664 * t3770 - 0.6e1 * t3667 * t3754 - t3667 * t3770 - 0.3e1 * t3728 * t376 + 0.6e1 * t3738 * t3763 + t3738 * t3770;
  t3789 = my_piecewise5(t58, 0, t61, 0, t3640 * t3515 * t3646 - t151 * t3649 * t160 + 0.18e2 * t151 * t3501 * t1103 + 0.4e1 * t1032 + 0.4e1 * t1038 - 0.5e1 * t1058 - 0.4e1 * t1091 - 0.4e1 * t1104 + 0.4e1 * t1109 + t3785 + t3759 + t3721 + t3635 - t386 - 0.4e1 * t151 * t1117 * t153 * t385 + t3557 + 0.18e2 * t3667 * t3681 + 0.11e2 * t3614 * t3652 - 0.18e2 * t3545 * t3655 - 0.18e2 * t3659 * t3661 + 0.7e1 * t3664 * t3661 + 0.7e1 * t3667 * t3668 - 0.7e1 * t3667 * t3673 + 0.18e2 * t1574 * t3530 - 0.4e1 * t3562 * t608 + 0.18e2 * t3540 * t3566 + 0.18e2 * t1570 * t3571 + 0.18e2 * t1574 * t3575 - 0.6e1 * t1570 * t3530 + 0.18e2 * t1623 * t3581 - 0.18e2 * t1570 * t3575 - 0.12e2 * t1570 * t3587 - 0.18e2 * t3540 * t3547 - 0.18e2 * t3502 * t1090 - 0.18e2 * t3502 * t1103);
  t3795 = t21 * t21;
  t3797 = 0.1e1 / t26 / t3795;
  t3798 = t310 * t310;
  t3804 = t318 * t318;
  t3810 = 0.1e1 / t955 / t8;
  t3811 = t18 * t3810;
  t3814 = my_piecewise5(t12, 0, t16, 0, -0.24e2 * t956 + 0.24e2 * t3811);
  t3818 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3797 * t3798 - 0.2e2 / 0.9e1 * t948 * t310 * t318 + 0.1e2 / 0.3e1 * t309 * t3804 + 0.4e2 / 0.9e1 * t952 * t960 + 0.5e1 / 0.3e1 * t27 * t3814);
  t3827 = t7 * t969 * t164;
  t3833 = t7 * t976 * t164;
  t3836 = t7 * t327 * t398;
  t3842 = t7 * t988 * t164;
  t3846 = t7 * t964 * t134 * t73;
  t3850 = t7 * t322 * t335 * t73;
  t3854 = t7 * t129 * t987 * t73;
  t3857 = 0.1e1 / t30 / t313;
  t3861 = 0.14e2 / 0.135e3 * t7 * t29 * t3857 * t73;
  t3862 = -t3471 / 0.5e1 + 0.2e1 / 0.5e1 * t3474 + 0.3e1 / 0.2e2 * t7 * t32 * (0.1309e5 / 0.729e3 * t3480 + t3486 * t71 + 0.4e1 * t1008 * t162 + 0.6e1 * t353 * t396 + 0.4e1 * t149 * t1130 + t53 * t3789) + 0.3e1 / 0.2e2 * t7 * t3818 * t31 * t73 + 0.3e1 / 0.5e1 * t7 * t965 * t164 + 0.6e1 / 0.5e1 * t3827 + 0.9e1 / 0.1e2 * t7 * t323 * t398 - 0.2e1 / 0.5e1 * t3833 + 0.6e1 / 0.5e1 * t3836 + 0.3e1 / 0.5e1 * t7 * t130 * t1132 + 0.8e1 / 0.45e2 * t3842 + 0.2e1 / 0.5e1 * t3846 - t3850 / 0.5e1 + 0.8e1 / 0.45e2 * t3854 - t3861;
  t3863 = my_piecewise3(t2, 0, t3862);
  t3864 = t82 * t82;
  t3866 = 0.1e1 / t84 / t3864;
  t3867 = t405 * t405;
  t3873 = t411 * t411;
  t3878 = t79 * t3810;
  t3881 = my_piecewise5(t16, 0, t12, 0, 0.24e2 * t956 + 0.24e2 * t3878);
  t3885 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3866 * t3867 - 0.2e2 / 0.9e1 * t1139 * t405 * t411 + 0.1e2 / 0.3e1 * t404 * t3873 + 0.4e2 / 0.9e1 * t1143 * t1149 + 0.5e1 / 0.3e1 * t85 * t3881);
  t3892 = t7 * t1153 * t134 * t117;
  t3896 = t7 * t415 * t335 * t117;
  t3900 = t7 * t175 * t987 * t117;
  t3905 = 0.14e2 / 0.135e3 * t7 * t87 * t3857 * t117;
  t3907 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t3885 * t31 * t117 + 0.2e1 / 0.5e1 * t3892 - t3896 / 0.5e1 + 0.8e1 / 0.45e2 * t3900 - t3905);
  tv4rho40 = 0.4e1 * t1137 + 0.4e1 * t1171 + t8 * (t3863 + t3907);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3916 = t7 * t1203 * t164;
  t3917 = t3916 / 0.1e2;
  t3919 = t7 * t445 * t398;
  t3942 = 0.12e2 * t956;
  t3943 = 0.24e2 * t3811;
  t3945 = my_piecewise5(t12, 0, t16, 0, -t3942 + t3943);
  t3949 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3797 * t189 * t949 - 0.1e2 / 0.9e1 * t948 * t436 * t310 - 0.1e2 / 0.9e1 * t1176 * t126 * t318 + 0.1e2 / 0.3e1 * t309 * t1187 * t126 + 0.1e2 / 0.3e1 * t1179 * t318 + 0.1e2 / 0.9e1 * t432 * t960 + 0.5e1 / 0.3e1 * t27 * t3945);
  t3958 = t7 * t1196 * t164;
  t3966 = t7 * t1191 * t134 * t73;
  t3970 = t7 * t440 * t335 * t73;
  t3971 = t3970 / 0.1e2;
  t3974 = t7 * t192 * t987 * t73;
  t3979 = 0.9e1 / 0.2e2 * t7 * t441 * t398 - t3917 + 0.3e1 / 0.1e2 * t3919 + 0.3e1 / 0.2e2 * t7 * t193 * t1132 - t3471 / 0.1e2 + t3474 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t3949 * t31 * t73 + 0.9e1 / 0.2e2 * t7 * t1192 * t164 + 0.3e1 / 0.5e1 * t3958 + 0.3e1 / 0.1e2 * t3827 - t3833 / 0.5e1 + 0.3e1 / 0.1e2 * t3836 + 0.2e1 / 0.15e2 * t3842 + 0.3e1 / 0.1e2 * t3966 - t3971 + 0.2e1 / 0.45e2 * t3974 + t3846 / 0.1e2 - t3850 / 0.1e2 + 0.2e1 / 0.15e2 * t3854 - t3861;
  t3980 = my_piecewise3(t2, 0, t3979);
  t3997 = 0.24e2 * t3878;
  t3999 = my_piecewise5(t16, 0, t12, 0, t3942 + t3997);
  t4003 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3866 * t200 * t1140 - 0.1e2 / 0.9e1 * t1139 * t460 * t405 - 0.1e2 / 0.9e1 * t1220 * t172 * t411 + 0.1e2 / 0.3e1 * t404 * t1230 * t172 + 0.1e2 / 0.3e1 * t1223 * t411 + 0.1e2 / 0.9e1 * t456 * t1149 + 0.5e1 / 0.3e1 * t85 * t3999);
  t4010 = t7 * t1234 * t134 * t117;
  t4014 = t7 * t464 * t335 * t117;
  t4015 = t4014 / 0.1e2;
  t4018 = t7 * t203 * t987 * t117;
  t4027 = t7 * t1158 * t233;
  t4030 = t7 * t1162 * t233;
  t4031 = t4030 / 0.1e2;
  t4033 = t7 * t1166 * t233;
  t4035 = 0.3e1 / 0.2e2 * t7 * t4003 * t31 * t117 + 0.3e1 / 0.1e2 * t4010 - t4015 + 0.2e1 / 0.45e2 * t4018 + t3892 / 0.1e2 - t3896 / 0.1e2 + 0.2e1 / 0.15e2 * t3900 - t3905 + 0.3e1 / 0.2e2 * t7 * t1154 * t233 + 0.3e1 / 0.1e2 * t4027 - t4031 + 0.2e1 / 0.45e2 * t4033;
  t4036 = my_piecewise3(t78, 0, t4035);
  tv4rho41 = t1137 + t1171 + 0.3e1 * t1219 + 0.3e1 * t1259 + t8 * (t3980 + t4036);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t4045 = t7 * t1275 * t134 * t73;
  t4049 = t7 * t495 * t335 * t73;
  t4059 = t436 * t436;
  t4072 = my_piecewise5(t12, 0, t16, 0, t3943);
  t4076 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3797 * t486 * t310 - 0.4e2 / 0.27e2 * t1176 * t126 * t436 - 0.1e2 / 0.27e2 * t1262 * t318 + 0.2e2 / 0.9e1 * t309 * t4059 + 0.2e2 / 0.9e1 * t432 * t1187 - 0.1e2 / 0.27e2 * t948 * t491 * t310 + 0.2e2 / 0.9e1 * t309 * t1271 * t126 + 0.1e2 / 0.9e1 * t1267 * t318 + 0.5e1 / 0.3e1 * t27 * t4072);
  t4085 = t7 * t1280 * t164;
  t4101 = t4045 / 0.5e1 - t4049 / 0.3e2 + 0.3e1 / 0.2e2 * t7 * t4076 * t31 * t73 + 0.3e1 / 0.1e2 * t7 * t1276 * t164 + t4085 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t496 * t398 - 0.2e1 / 0.15e2 * t3916 + t3919 / 0.5e1 - t3471 / 0.3e2 + 0.2e1 / 0.5e1 * t3958 - t3833 / 0.15e2 + 0.4e1 / 0.45e2 * t3842 + t3966 / 0.5e1 - 0.2e1 / 0.15e2 * t3970 + 0.4e1 / 0.45e2 * t3974 - t3850 / 0.3e2 + 0.4e1 / 0.45e2 * t3854 - t3861;
  t4102 = my_piecewise3(t2, 0, t4101);
  t4111 = t460 * t460;
  t4124 = my_piecewise5(t16, 0, t12, 0, t3997);
  t4128 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3866 * t503 * t405 - 0.4e2 / 0.27e2 * t1220 * t172 * t460 - 0.1e2 / 0.27e2 * t1292 * t411 + 0.2e2 / 0.9e1 * t404 * t4111 + 0.2e2 / 0.9e1 * t456 * t1230 - 0.1e2 / 0.27e2 * t1139 * t508 * t405 + 0.2e2 / 0.9e1 * t404 * t1301 * t172 + 0.1e2 / 0.9e1 * t1297 * t411 + 0.5e1 / 0.3e1 * t85 * t4124);
  t4135 = t7 * t1305 * t134 * t117;
  t4139 = t7 * t512 * t335 * t117;
  t4148 = t7 * t1239 * t233;
  t4151 = t7 * t1243 * t233;
  t4162 = t7 * t420 * t577;
  t4165 = t7 * t424 * t577;
  t4167 = 0.3e1 / 0.2e2 * t7 * t4128 * t31 * t117 + t4135 / 0.5e1 - t4139 / 0.3e2 + t4010 / 0.5e1 - 0.2e1 / 0.15e2 * t4014 + 0.4e1 / 0.45e2 * t4018 + 0.3e1 / 0.1e2 * t7 * t1235 * t233 + 0.2e1 / 0.5e1 * t4148 - t4151 / 0.15e2 - t3896 / 0.3e2 + 0.4e1 / 0.45e2 * t3900 - t3905 + t4027 / 0.5e1 - 0.2e1 / 0.15e2 * t4030 + 0.4e1 / 0.45e2 * t4033 + 0.3e1 / 0.2e2 * t7 * t416 * t577 + t4162 / 0.5e1 - t4165 / 0.3e2;
  t4168 = my_piecewise3(t78, 0, t4167);
  tv4rho42 = 0.2e1 * t1219 + 0.2e1 * t1259 + 0.2e1 * t1291 + 0.2e1 * t1330 + t8 * (t4102 + t4168);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4189 = my_piecewise5(t12, 0, t16, 0, t3942 + t3943);
  t4193 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3797 * t1335 * t126 - 0.1e2 / 0.9e1 * t1262 * t436 - 0.1e2 / 0.9e1 * t1176 * t491 * t126 + 0.1e2 / 0.3e1 * t1179 * t491 + 0.1e2 / 0.3e1 * t432 * t1271 + 0.1e2 / 0.9e1 * t309 * t1342 * t126 + 0.5e1 / 0.3e1 * t27 * t4189);
  t4200 = t7 * t1346 * t134 * t73;
  t4211 = 0.3e1 / 0.2e2 * t7 * t4193 * t31 * t73 + t4200 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t1347 * t164 + 0.3e1 / 0.1e2 * t4045 - t4049 / 0.1e2 + 0.3e1 / 0.1e2 * t4085 - t3971 + 0.2e1 / 0.15e2 * t3974 - t3917 + 0.2e1 / 0.45e2 * t3854 - t3861 + 0.2e1 / 0.45e2 * t3842;
  t4212 = my_piecewise3(t2, 0, t4211);
  t4229 = my_piecewise5(t16, 0, t12, 0, -t3942 + t3997);
  t4233 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3866 * t1355 * t172 - 0.1e2 / 0.9e1 * t1292 * t460 - 0.1e2 / 0.9e1 * t1220 * t508 * t172 + 0.1e2 / 0.3e1 * t1223 * t508 + 0.1e2 / 0.3e1 * t456 * t1301 + 0.1e2 / 0.9e1 * t404 * t1362 * t172 + 0.5e1 / 0.3e1 * t85 * t4229);
  t4240 = t7 * t1366 * t134 * t117;
  t4248 = t7 * t1310 * t233;
  t4257 = t7 * t469 * t577;
  t4267 = t7 * t180 * t1516;
  t4269 = 0.3e1 / 0.2e2 * t7 * t4233 * t31 * t117 + t4240 / 0.1e2 + 0.3e1 / 0.1e2 * t4135 - t4139 / 0.1e2 + 0.9e1 / 0.2e2 * t7 * t1306 * t233 + 0.3e1 / 0.1e2 * t4248 - t4015 + 0.2e1 / 0.15e2 * t4018 + 0.3e1 / 0.5e1 * t4148 - t4151 / 0.5e1 + 0.9e1 / 0.2e2 * t7 * t465 * t577 + 0.3e1 / 0.1e2 * t4257 + 0.2e1 / 0.45e2 * t3900 - t3905 - t4031 + 0.2e1 / 0.15e2 * t4033 + 0.3e1 / 0.1e2 * t4162 - t4165 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t176 * t1516 + t4267 / 0.1e2;
  t4270 = my_piecewise3(t78, 0, t4269);
  tv4rho43 = 0.3e1 * t1291 + 0.3e1 * t1330 + t1354 + t1521 + t8 * (t4212 + t4270);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t4275 = t486 * t486;
  t4280 = t491 * t491;
  t4287 = my_piecewise5(t12, 0, t16, 0, 0.24e2 * t956 + 0.24e2 * t3811);
  t4291 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3797 * t4275 - 0.2e2 / 0.9e1 * t1262 * t491 + 0.1e2 / 0.3e1 * t309 * t4280 + 0.4e2 / 0.9e1 * t432 * t1342 + 0.5e1 / 0.3e1 * t27 * t4287);
  t4300 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t4291 * t31 * t73 + 0.2e1 / 0.5e1 * t4200 - t4049 / 0.5e1 + 0.8e1 / 0.45e2 * t3974 - t3861);
  t4308 = t503 * t503;
  t4313 = t508 * t508;
  t4320 = my_piecewise5(t16, 0, t12, 0, -0.24e2 * t956 + 0.24e2 * t3878);
  t4324 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3866 * t4308 - 0.2e2 / 0.9e1 * t1292 * t508 + 0.1e2 / 0.3e1 * t404 * t4313 + 0.4e2 / 0.9e1 * t456 * t1362 + 0.5e1 / 0.3e1 * t85 * t4320);
  t4342 = t38 * sigma[2] / t91 / t522 / t89;
  t4348 = 0.154e5 / 0.2187e4 * t38 * lapl[1] * t1384 - 0.10472e6 / 0.6561e4 * t4342;
  t4362 = t558 * t539;
  t4363 = t4362 * t562;
  t4364 = t538 * t4363;
  t4373 = t539 * t539;
  t4374 = t4373 * t541;
  t4375 = t1417 * t4374;
  t4377 = t1441 * t1444 * t562;
  t4381 = t570 * t1448 * t562;
  t4384 = t558 * t1418;
  t4388 = t4373 * t562;
  t4391 = t541 * t112 * t227;
  t4392 = t1463 * t4391;
  t4395 = t220 * t4374;
  t4396 = t1428 * t1491;
  t4400 = t1441 * t1452 * t562;
  t4403 = t538 * t4374;
  t4405 = t1423 * t1788 * t562;
  t4412 = t1423 * t571 * t562;
  t4416 = t1428 * t1429 * t562;
  t4421 = 0.18e2 * t538 * t4384 * t1798 + 0.18e2 * t220 * t4362 * t1819 + 0.18e2 * t538 * t4388 * t4392 + 0.18e2 * t1823 * t4381 - 0.12e2 * t4375 * t4377 + 0.18e2 * t4375 * t4400 + 0.18e2 * t4375 * t4412 - 0.18e2 * t4395 * t4396 - 0.6e1 * t4395 * t4416 + 0.18e2 * t4403 * t4405 + 0.18e2 * t4403 * t4416;
  t4427 = t1423 * t1831;
  t4430 = t220 * t1750;
  t4432 = t1428 * t1429 * t558;
  t4435 = t1501 * t541;
  t4436 = t220 * t4435;
  t4439 = t538 * t4435;
  t4442 = t1428 * t1470;
  t4447 = t1443 * t558;
  t4449 = t1441 * t4447 * params->csk_a;
  t4453 = t1423 * t1788 * t558;
  t4464 = t1441 * t1444 * t558;
  t4467 = t558 * t558;
  t4468 = t220 * t4467;
  t4473 = t220 * t4373;
  t4474 = t562 * t562;
  t4475 = t4474 * t543;
  t4476 = t4475 * t228;
  t4479 = t541 * t541;
  t4480 = t542 * t542;
  t4481 = 0.1e1 / t4480;
  t4482 = t4479 * t4481;
  t4483 = t4482 * t228;
  t4486 = t538 * t4373;
  t4487 = t4475 * t548;
  t4490 = t4482 * t548;
  t4494 = t4482 * t1497;
  t4497 = 0.6e1 * t1417 * t4373 * t4494 + 0.18e2 * t1751 * t4432 - 0.6e1 * t1774 * t4432 - 0.18e2 * t1774 * t4453 - 0.12e2 * t1774 * t4464 - 0.3e1 * t4468 * t564 + 0.3e1 * t4468 * t566 + 0.3e1 * t4473 * t4476 + 0.6e1 * t4473 * t4483 + 0.3e1 * t4486 * t4487 + 0.11e2 * t4486 * t4490;
  t4503 = t536 * t536;
  t4505 = t114 / t4503;
  t4507 = t545 * t545;
  t4508 = t546 * t546;
  t4509 = 0.1e1 / t4508;
  t4510 = t4507 * t4509;
  t4511 = t4482 * t4510;
  t4513 = my_piecewise3(t105, 0, t4348);
  t4514 = my_piecewise3(t107, t4513, 0);
  t4518 = t227 * t541;
  t4519 = t1428 * t4518;
  t4522 = t4373 * t4474;
  t4523 = t538 * t4522;
  t4526 = t4373 * t4479;
  t4527 = t538 * t4526;
  t4528 = t4481 * t545;
  t4529 = t4528 * t571;
  t4535 = t4505 * t4526;
  t4536 = t4481 * t4507;
  t4538 = t4536 * t4509 * params->csk_a;
  t4545 = t4467 * t541;
  t4550 = t538 * t4545;
  t4554 = t1441 * t1443 * t562;
  t4561 = t4481 * t1440;
  t4562 = t4561 * t1452;
  t4565 = t4561 * t1444;
  t4568 = t4528 * t1788;
  t4571 = t547 * t3671;
  t4572 = t4528 * t4571;
  t4575 = t1417 * t4526;
  t4580 = t4481 * t3671;
  t4581 = t4580 * t1497;
  t4584 = -0.6e1 * t4375 * t4554 + 0.4e1 * t4436 * t682 - 0.11e2 * t4527 * t4568 - 0.7e1 * t4527 * t4572 - 0.6e1 * t4535 * t4562 + 0.18e2 * t4535 * t4565 - 0.7e1 * t4535 * t4572 - 0.12e2 * t4535 * t4581 - 0.3e1 * t4550 * t555 - 0.3e1 * t4550 * t572 + 0.18e2 * t4575 * t4572;
  t4587 = t4536 * t4509 * t1048;
  t4590 = t4509 * t3671;
  t4591 = t4536 * t4590;
  t4601 = t220 * t4526;
  t4602 = t4481 * t112;
  t4603 = t4602 * t554;
  t4606 = t1423 * t1401;
  t4612 = t1423 * t1448;
  t4621 = 0.4e1 * t664 * t570 * t547 * t1501 - 0.12e2 * t220 * t4384 * t1781 + 0.3e1 * t220 * t4522 * t555 - 0.18e2 * t1751 * t4612 - 0.18e2 * t4403 * t4606 - 0.3e1 * t4523 * t555 - 0.11e2 * t4527 * t4603 + 0.11e2 * t4535 * t4587 - 0.6e1 * t4535 * t4591 - 0.12e2 * t4575 * t4562 + 0.11e2 * t4601 * t4603;
  t4624 = t4602 * t1429;
  t4633 = t227 * t3671;
  t4634 = t4602 * t4633;
  t4645 = -0.18e2 * t4527 * t4624 - 0.7e1 * t4527 * t4634 - 0.18e2 * t4575 * t4529 + 0.7e1 * t4535 * t4568 - t4535 * t4634 - 0.6e1 * t4575 * t4565 + 0.12e2 * t4575 * t4581 + 0.6e1 * t4575 * t4624 + 0.6e1 * t4575 * t4634 + 0.6e1 * t4601 * t4624 + t4601 * t4634;
  t4649 = my_piecewise5(t104, 0, t105, 0, 0.3e1 * t538 * t4467 * t549 + t4505 * t4373 * t4511 - t220 * t4514 * t229 - 0.12e2 * t220 * t4388 * t4519 - 0.6e1 * t1774 * t1441 * t4447 + 0.3e1 * t220 * t4545 * t555 + 0.18e2 * t220 * t4363 * t1487 + t4621 + t4645 + 0.4e1 * t1403 + 0.4e1 * t1413 - 0.5e1 * t1460 - 0.4e1 * t1480 - 0.4e1 * t1488 + 0.4e1 * t1493 + t4584 + t4497 + t4421 - t565 - 0.4e1 * t220 * t1501 * t222 * t564 - 0.6e1 * t4535 * t4538 - 0.3e1 * t4523 * t572 + 0.7e1 * t4527 * t4529 - 0.18e2 * t4430 * t4442 - 0.4e1 * t4439 * t671 + 0.18e2 * t1774 * t4449 + 0.18e2 * t1751 * t4453 - 0.6e1 * t4375 * t4416 - 0.18e2 * t4375 * t4405 + 0.18e2 * t1774 * t4427 - 0.6e1 * t4430 * t4432 + 0.4e1 * t4436 * t671 - 0.4e1 * t4439 * t687 - 0.18e2 * t4364 * t1479 - 0.18e2 * t4364 * t1487);
  t4657 = 0.2e1 / 0.5e1 * t4240 + 0.6e1 / 0.5e1 * t4248 + 0.6e1 / 0.5e1 * t4257 + 0.2e1 / 0.5e1 * t4267 - t4139 / 0.5e1 - 0.2e1 / 0.5e1 * t4151 - t4165 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t4324 * t31 * t117 + 0.3e1 / 0.5e1 * t7 * t1367 * t233 + 0.9e1 / 0.1e2 * t7 * t513 * t577 + 0.3e1 / 0.5e1 * t7 * t204 * t1516 + 0.3e1 / 0.2e2 * t7 * t88 * (0.1309e5 / 0.729e3 * t4342 + t4348 * t115 + 0.4e1 * t1392 * t231 + 0.6e1 * t532 * t575 + 0.4e1 * t218 * t1514 + t103 * t4649) + 0.8e1 / 0.45e2 * t4033 + 0.8e1 / 0.45e2 * t4018 - t3905;
  t4658 = my_piecewise3(t78, 0, t4657);
  tv4rho44 = 0.4e1 * t1354 + 0.4e1 * t1521 + t8 * (t4300 + t4658);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t4666 = t7 * t969 * t253;
  t4672 = t7 * t976 * t253;
  t4675 = t7 * t327 * t629;
  t4682 = 0.2e1 / 0.45e2 * t7 * t988 * t253;
  t4684 = t7 * t336 * t629;
  t4687 = t7 * t135 * t1669;
  t4689 = t38 * t1000;
  t4713 = t1100 * t155;
  t4714 = t159 * t379;
  t4715 = t4713 * t4714;
  t4718 = t1558 * t383;
  t4722 = t151 * t4718;
  t4725 = t359 * t2489;
  t4726 = t1048 * t379;
  t4727 = t4726 * t153;
  t4728 = t369 * t4727;
  t4732 = t1042 * t3511 * t1019;
  t4733 = t3210 * t153;
  t4734 = t369 * t4733;
  t4737 = t248 * t1014;
  t4738 = t4737 * t383;
  t4739 = t359 * t4738;
  t4742 = t605 * t1019;
  t4743 = t151 * t4742;
  t4746 = t159 * params->csk_a * t1014 * t383;
  t4750 = t1048 * t1014 * t383;
  t4751 = t159 * t4750;
  t4754 = -0.9e1 * t359 * t2472 * t4715 - 0.9e1 * t359 * t4718 * t2477 + 0.9e1 * t4722 * t2468 + 0.18e2 * t4739 * t3520 + 0.9e1 * t4725 * t4728 + 0.9e1 * t4732 * t4734 - 0.18e2 * t4743 * t4746 - 0.6e1 * t4743 * t4751 - 0.3e1 * t1556 - 0.2e1 * t1560 + 0.4e1 * t1626 + 0.4e1 * t1632 - t617;
  t4755 = t1060 * t3519;
  t4758 = t1042 * t4738;
  t4761 = t151 * t2489;
  t4762 = t379 * params->csk_a;
  t4764 = t159 * t4762 * t153;
  t4767 = t612 * t360;
  t4768 = t4767 * t383;
  t4772 = t1113 * t4727;
  t4775 = t1014 * t362;
  t4777 = t1042 * t4775 * t1019;
  t4778 = t1113 * t3218;
  t4781 = t1048 * t153;
  t4782 = t4781 * t4714;
  t4790 = t369 * t4750;
  t4795 = t359 * t4768;
  t4798 = t153 * t155;
  t4800 = t359 * t4798 * t364;
  t4806 = 0.9e1 * t151 * t4768 * t1103 + 0.18e2 * t359 * t4742 * t4790 + 0.9e1 * t4800 * t369 * t4718 - 0.9e1 * t4795 * t1090 + 0.9e1 * t4722 * t2227 - 0.6e1 * t2490 * t4772 - 0.3e1 * t2490 * t4782 + 0.9e1 * t4725 * t4764 + 0.9e1 * t4725 * t4782 + 0.18e2 * t4739 * t4755 - 0.6e1 * t4758 * t4755 - 0.9e1 * t4761 * t4764 - 0.3e1 * t4761 * t4782 + 0.18e2 * t4777 * t4778;
  t4813 = t369 * t3218;
  t4817 = t362 * t366 * t368;
  t4818 = t1060 * t4817;
  t4824 = t1065 * t1068 * t362;
  t4827 = t359 * t4775;
  t4831 = t151 * t4737;
  t4833 = t383 * t1019 * t3519;
  t4836 = t359 * t4737;
  t4837 = t3616 * t2471;
  t4840 = t248 * t3624;
  t4841 = t359 * t4840;
  t4843 = t1014 * t68 * t158;
  t4844 = t3731 * t4843;
  t4847 = t1042 * t4840;
  t4848 = t1067 * t3671;
  t4850 = t3680 * t4848 * t1014;
  t4853 = t612 * t1015;
  t4854 = t359 * t4853;
  t4859 = t1042 * t4853;
  t4862 = -0.18e2 * t4827 * t1044 * t1624 + 0.9e1 * t4732 * t1113 * t4733 - 0.9e1 * t4795 * t1103 + 0.9e1 * t4854 * t1598 + 0.9e1 * t4854 * t1614 - 0.3e1 * t4859 * t1614 - 0.9e1 * t2490 * t4728 - 0.18e2 * t4758 * t4818 - 0.12e2 * t4758 * t4824 + 0.18e2 * t4777 * t4813 - 0.12e2 * t4831 * t4833 - 0.3e1 * t4836 * t4837 - 0.11e2 * t4841 * t4844 + 0.12e2 * t4847 * t4850;
  t4863 = t151 * t4840;
  t4865 = t3768 * t1049 * t1014;
  t4868 = t3672 * t4843;
  t4871 = t3640 * t4840;
  t4880 = t1044 * t2259;
  t4883 = t1014 * t3624;
  t4884 = t3640 * t4883;
  t4885 = t3680 * t1588;
  t4890 = t151 * t4853;
  t4893 = t1042 * t4883;
  t4894 = t3660 * t860;
  t4898 = t391 * t1565 * t383;
  t4901 = t359 * t2190;
  t4906 = -0.9e1 * t4901 * t1044 * t602 * t379 + 0.9e1 * t1570 * t4880 - 0.9e1 * t4859 * t1598 - 0.9e1 * t4890 * t1604 + 0.9e1 * t1623 * t4898 - 0.18e2 * t4841 * t4865 - 0.7e1 * t4841 * t4868 + 0.6e1 * t4847 * t4865 + 0.6e1 * t4847 * t4868 + 0.6e1 * t4863 * t4865 + t4863 * t4868 - t4871 * t4868 - 0.6e1 * t4884 * t4885 - 0.18e2 * t4893 * t4894;
  t4915 = t1648 * t362;
  t4916 = t151 * t4915;
  t4923 = t369 * params->csk_a;
  t4924 = t3616 * t4923;
  t4928 = t3680 * t1068 * t1014;
  t4937 = t3644 * t248;
  t4943 = t3688 * t3693 * t1014;
  t4948 = 0.11e2 * t4884 * t3688 * t4937 * t1048 - 0.3e1 * t2191 * t1065 * t3569 * t248 + 0.9e1 * t4854 * t1604 - 0.3e1 * t1607 * t1644 - 0.6e1 * t4859 * t1635 + 0.3e1 * t4831 * t4837 - 0.3e1 * t4836 * t4924 + 0.11e2 * t4863 * t4844 - 0.6e1 * t4847 * t4928 - 0.12e2 * t4871 * t4850 - 0.6e1 * t4871 * t4943 - 0.12e2 * t4893 * t4885 + 0.3e1 * t4916 * t608;
  t4951 = t1100 * t1117 * t68 * t158;
  t4955 = t3672 * t1014 * t366 * t368;
  t4958 = t359 * t4915;
  t4961 = t359 * t4883;
  t4965 = t3660 * t1596 * t1014;
  t4968 = t3660 * t3237;
  t4973 = t3680 * t3233;
  t4980 = t1067 * t612;
  t4982 = t1065 * t4980 * params->csk_a;
  t4993 = -0.6e1 * t4884 * t3688 * t4937 * params->csk_a - 0.3e1 * t1607 * t1095 + 0.9e1 * t1570 * t4982 - 0.3e1 * t4890 * t1614 - 0.7e1 * t4841 * t4955 - 0.11e2 * t4841 * t4965 + 0.18e2 * t4847 * t4955 - 0.7e1 * t4871 * t4955 + 0.7e1 * t4884 * t4968 + 0.18e2 * t4884 * t4973 + 0.7e1 * t4961 * t4894 - t621 * t4951 - 0.3e1 * t4958 * t608 - 0.3e1 * t4958 * t624;
  t4999 = t1020 * t1561 * t153;
  t5002 = t1042 * t4775;
  t5009 = t391 * t392 * t1117;
  t5014 = my_piecewise3(t61, 0, 0.616e4 / 0.2187e4 * t4689);
  t5015 = my_piecewise3(t63, t5014, 0);
  t5022 = t3768 * t158 * t1014;
  t5026 = t359 * t1014 * t3615;
  t5034 = -0.6e1 * t5002 * t1065 * t1571 * t383 - t151 * t5015 * t160 + 0.9e1 * t151 * t4767 * t1631 + 0.11e2 * t4961 * t3660 * t602 + 0.3e1 * t1585 * t1095 - 0.6e1 * t1579 * t4999 + 0.3e1 * t4831 * t3621 + 0.6e1 * t4863 * t5022 + t606 * t4951 - t621 * t5009 + 0.3e1 * t5026 * t603 - 0.4e1 * t1653 - 0.4e1 * t1655 + 0.4e1 * t1663;
  t5035 = t1044 * t1565;
  t5046 = t374 * t158 * t1117;
  t5052 = t391 * t368 * t1648;
  t5055 = t1065 * t4980;
  t5073 = -0.9e1 * t1574 * t5035 + 0.6e1 * t4893 * t3680 * t1571 - 0.6e1 * t4890 * t1581 + 0.3e1 * t1585 * t1562 + t606 * t5046 + t3562 * t603 + 0.3e1 * t1085 * t1566 + 0.3e1 * t601 * t5052 - 0.3e1 * t1570 * t5055 + t4884 * t3688 * t4937 - 0.3e1 * t151 * t1648 * t153 * t385 - 0.3e1 * t151 * t612 * t379 * t385 - t151 * t248 * t1117 * t385 + 0.3e1 * t4916 * t619;
  t5077 = my_piecewise5(t58, 0, t61, 0, t4754 + t4806 + t4862 + t4906 + t4948 + t4993 + t5034 + t5073);
  t5084 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t965 * t253 + 0.3e1 / 0.1e2 * t4666 + 0.9e1 / 0.2e2 * t7 * t323 * t629 - t4672 / 0.1e2 + 0.3e1 / 0.5e1 * t4675 + 0.9e1 / 0.2e2 * t7 * t130 * t1669 + t4682 - t4684 / 0.1e2 + 0.3e1 / 0.1e2 * t4687 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.77e3 / 0.243e3 * t4689 + 0.616e4 / 0.2187e4 * t38 * t1000 * t71 - 0.44e3 / 0.243e3 * t38 * t345 * t162 + 0.4e2 / 0.81e2 * t38 * t141 * t396 - 0.5e1 / 0.81e2 * t38 * t43 * t1130 + t1008 * t251 + 0.3e1 * t353 * t627 + 0.3e1 * t149 * t1667 + t53 * t5077));
  tv4rho3sigma0 = t8 * t5084 + 0.3e1 * t1674;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t5091 = t7 * t1158 * t270;
  t5094 = t7 * t1162 * t270;
  t5098 = 0.2e1 / 0.45e2 * t7 * t1166 * t270;
  t5100 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1154 * t270 + 0.3e1 / 0.1e2 * t5091 - t5094 / 0.1e2 + t5098);
  tv4rho3sigma2 = t8 * t5100 + 0.3e1 * t1687;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t5102 = 0.2e1 * t1701;
  t5108 = t7 * t1196 * t253 / 0.5e1;
  t5113 = t7 * t1203 * t253;
  t5117 = t7 * t445 * t629 / 0.5e1;
  t5126 = 0.3e1 / 0.2e2 * t7 * t1192 * t253 + t5108 + 0.3e1 / 0.1e2 * t7 * t441 * t629 - t5113 / 0.3e2 + t5117 + 0.3e1 / 0.2e2 * t7 * t193 * t1669 + t4666 / 0.1e2 - t4672 / 0.15e2 + t4675 / 0.5e1 + t4682 - t4684 / 0.15e2 + t4687 / 0.1e2;
  t5127 = my_piecewise3(t2, 0, t5126);
  tv4rho3sigma3 = t8 * t5127 + t1674 + t5102;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5129 = 0.2e1 * t1717;
  t5135 = t7 * t1239 * t270 / 0.5e1;
  t5137 = t7 * t1243 * t270;
  t5146 = t7 * t420 * t692 / 0.5e1;
  t5148 = t7 * t424 * t692;
  t5151 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1235 * t270 + t5135 - t5137 / 0.3e2 + t5091 / 0.1e2 - t5094 / 0.15e2 + t5098 + 0.3e1 / 0.2e2 * t7 * t416 * t692 + t5146 - t5148 / 0.3e2);
  tv4rho3sigma5 = t8 * t5151 + t1687 + t5129;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5157 = t7 * t1280 * t253;
  t5166 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1276 * t253 + t5157 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t496 * t629 + t5108 - t5113 / 0.15e2 + t5117 - t4672 / 0.3e2 + t4682 - t4684 / 0.3e2);
  tv4rho3sigma6 = t8 * t5166 + t1725 + t5102;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t5172 = t7 * t1310 * t270;
  t5179 = t7 * t469 * t692;
  t5187 = t7 * t180 * t1865;
  t5189 = 0.3e1 / 0.2e2 * t7 * t1306 * t270 + t5172 / 0.1e2 + t5135 - t5137 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t465 * t692 + t5179 / 0.5e1 - t5094 / 0.3e2 + t5098 + t5146 - t5148 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t176 * t1865 + t5187 / 0.1e2;
  t5190 = my_piecewise3(t78, 0, t5189);
  tv4rho3sigma8 = t8 * t5190 + t1870 + t5129;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t5199 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1347 * t253 + 0.3e1 / 0.1e2 * t5157 - t5113 / 0.1e2 + t4682);
  tv4rho3sigma9 = t8 * t5199 + 0.3e1 * t1725;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t5216 = t38 * t1384;
  t5239 = t1763 * t562;
  t5240 = t220 * t5239;
  t5244 = t1484 * t224;
  t5245 = t228 * t558;
  t5246 = t5244 * t5245;
  t5252 = t668 * t1422;
  t5253 = t538 * t5252;
  t5255 = t228 * t562;
  t5256 = params->csk_a * t1398 * t5255;
  t5259 = t538 * t2615;
  t5260 = t1048 * t558;
  t5261 = t5260 * t222;
  t5262 = t548 * t5261;
  t5266 = t1417 * t4384 * t1422;
  t5267 = t3280 * t222;
  t5268 = t548 * t5267;
  t5271 = t220 * t5252;
  t5274 = t265 * t1398;
  t5275 = t5274 * t562;
  t5277 = t1436 * t4391;
  t5280 = -0.9e1 * t538 * t2598 * t5246 - 0.9e1 * t538 * t5239 * t2603 + 0.18e2 * t538 * t5275 * t5277 + 0.9e1 * t5240 * t2594 + 0.18e2 * t5253 * t5256 - 0.18e2 * t5271 * t5256 + 0.9e1 * t5259 * t5262 + 0.9e1 * t5266 * t5268 - 0.3e1 * t1761 - 0.2e1 * t1765 + 0.4e1 * t1820 + 0.4e1 * t1826 - t680;
  t5281 = t1417 * t5275;
  t5285 = t1048 * t1398 * t562;
  t5286 = t228 * t5285;
  t5289 = t675 * t539;
  t5290 = t5289 * t562;
  t5294 = t220 * t2615;
  t5295 = t558 * params->csk_a;
  t5297 = t228 * t5295 * t222;
  t5300 = t548 * t5285;
  t5305 = t538 * t5290;
  t5308 = t1398 * t541;
  t5310 = t1417 * t5308 * t1422;
  t5315 = t541 * t545 * t547;
  t5316 = t1436 * t5315;
  t5321 = t222 * t224;
  t5329 = t1497 * t5261;
  t5334 = 0.9e1 * t538 * t5321 * t543 * t548 * t5239 + 0.9e1 * t220 * t5290 * t1487 + 0.18e2 * t5310 * t548 * t3281 - 0.9e1 * t5305 * t1479 - 0.9e1 * t5305 * t1487 + 0.9e1 * t5240 * t2384 - 0.9e1 * t2616 * t5262 - 0.6e1 * t2616 * t5329 + 0.18e2 * t5253 * t5300 + 0.9e1 * t5259 * t5297 - 0.6e1 * t5271 * t5286 - 0.6e1 * t5281 * t5277 - 0.18e2 * t5281 * t5316 - 0.9e1 * t5294 * t5297;
  t5337 = t1048 * t222 * t5245;
  t5340 = t1497 * t3281;
  t5354 = t265 * t4479;
  t5355 = t220 * t5354;
  t5357 = t4602 * t1429 * t1398;
  t5360 = t220 * t5274;
  t5362 = t562 * t1422 * t4391;
  t5365 = t538 * t5274;
  t5366 = t548 * params->csk_a;
  t5367 = t4475 * t5366;
  t5370 = t4475 * t2597;
  t5374 = t4602 * t554 * t1398;
  t5377 = t538 * t5354;
  t5382 = t1417 * t5354;
  t5383 = t1443 * t3671;
  t5385 = t4561 * t5383 * t1398;
  t5388 = -0.12e2 * t5281 * t1441 * t1444 * t541 + 0.9e1 * t5266 * t1497 * t5267 - 0.3e1 * t2616 * t5337 + 0.9e1 * t5259 * t5337 - 0.3e1 * t5294 * t5337 + 0.18e2 * t5310 * t5340 + 0.6e1 * t5355 * t5357 + 0.11e2 * t5355 * t5374 - 0.12e2 * t5360 * t5362 + 0.3e1 * t5360 * t5370 - 0.3e1 * t5365 * t5367 - 0.3e1 * t5365 * t5370 - 0.11e2 * t5377 * t5374 + 0.12e2 * t5382 * t5385;
  t5390 = t4602 * t4633 * t1398;
  t5396 = t4505 * t5354;
  t5402 = t1423 * t2410;
  t5405 = t1398 * t4479;
  t5406 = t4505 * t5405;
  t5407 = t4561 * t1838;
  t5410 = t675 * t1418;
  t5411 = t538 * t5410;
  t5414 = t1417 * t5410;
  t5418 = t4528 * t1788 * t1398;
  t5421 = t4561 * t3308;
  t5424 = t220 * t5410;
  t5427 = t538 * t2332;
  t5432 = -0.9e1 * t5427 * t1423 * t665 * t558 + 0.9e1 * t1774 * t5402 + 0.9e1 * t5411 * t1810 - 0.3e1 * t5414 * t1810 - 0.3e1 * t5424 * t1810 + t5355 * t5390 - 0.18e2 * t5377 * t5357 + 0.6e1 * t5382 * t5357 - 0.7e1 * t5377 * t5390 - 0.11e2 * t5377 * t5418 + 0.6e1 * t5382 * t5390 - t5396 * t5390 - 0.6e1 * t5406 * t5407 + 0.18e2 * t5406 * t5421;
  t5439 = t1443 * t675;
  t5441 = t1441 * t5439 * params->csk_a;
  t5446 = t1417 * t5405;
  t5447 = t4528 * t888;
  t5451 = t570 * t1770 * t562;
  t5454 = t1844 * t541;
  t5455 = t220 * t5454;
  t5458 = t4528 * t3312;
  t5464 = t4561 * t1444 * t1398;
  t5468 = t1428 * t1766 * t222;
  t5473 = t1484 * t1501 * t112 * t227;
  t5476 = t4528 * t4571 * t1398;
  t5481 = -0.3e1 * t2333 * t1441 * t4447 * t265 + 0.9e1 * t1774 * t5441 - 0.6e1 * t1779 * t5468 + 0.9e1 * t5411 * t1798 + 0.9e1 * t1823 * t5451 - 0.7e1 * t5377 * t5476 - 0.6e1 * t5382 * t5464 + 0.18e2 * t5382 * t5476 + 0.7e1 * t5406 * t5458 - 0.12e2 * t5446 * t5407 - 0.18e2 * t5446 * t5447 + 0.3e1 * t5455 * t671 - t684 * t5473;
  t5484 = t538 * t5454;
  t5487 = t538 * t5308;
  t5488 = t1423 * t1824;
  t5491 = t4509 * t265;
  t5504 = t538 * t5405;
  t5516 = -0.6e1 * t5406 * t4536 * t5491 * params->csk_a + 0.3e1 * t1756 * t1471 - 0.3e1 * t1793 * t1471 + 0.9e1 * t5411 * t1790 - 0.9e1 * t5414 * t1790 - 0.3e1 * t1793 * t1832 - 0.9e1 * t5424 * t1798 - 0.12e2 * t5396 * t5385 - 0.7e1 * t5396 * t5476 + 0.7e1 * t5504 * t5447 + t669 * t5473 - 0.3e1 * t5484 * t671 - 0.3e1 * t5484 * t687 - 0.18e2 * t5487 * t5488;
  t5519 = t570 * t571 * t1501;
  t5528 = t4536 * t4590 * t1398;
  t5531 = t1417 * t5308;
  t5540 = my_piecewise3(t105, 0, 0.616e4 / 0.2187e4 * t5216);
  t5541 = my_piecewise3(t107, t5540, 0);
  t5548 = t4602 * t227 * t1398;
  t5552 = t538 * t1398 * t4474;
  t5557 = t1423 * t1770;
  t5560 = 0.11e2 * t5406 * t4536 * t5491 * t1048 - 0.6e1 * t5531 * t1441 * t1775 * t562 + 0.9e1 * t220 * t5289 * t1819 - t220 * t5541 * t229 - 0.9e1 * t1751 * t5557 - 0.6e1 * t5414 * t1835 + 0.3e1 * t5360 * t4476 + 0.6e1 * t5355 * t5548 - 0.6e1 * t5396 * t5528 - t684 * t5519 + 0.3e1 * t5552 * t666 + 0.4e1 * t1853 - 0.4e1 * t1857 - 0.4e1 * t1859;
  t5566 = t4528 * t665;
  t5575 = t553 * t227 * t1501;
  t5581 = t570 * t547 * t1844;
  t5584 = t1441 * t5439;
  t5599 = 0.6e1 * t5446 * t4561 * t1775 - 0.6e1 * t5424 * t1781 + 0.11e2 * t5504 * t5566 - t220 * t265 * t1501 * t564 + 0.3e1 * t1756 * t1767 + t669 * t5575 + t4439 * t666 + 0.3e1 * t1474 * t1771 + 0.3e1 * t664 * t5581 - 0.3e1 * t1774 * t5584 + t5406 * t4536 * t5491 - 0.3e1 * t220 * t1844 * t222 * t564 - 0.3e1 * t220 * t675 * t558 * t564 + 0.3e1 * t5455 * t682;
  t5603 = my_piecewise5(t104, 0, t105, 0, t5280 + t5334 + t5388 + t5432 + t5481 + t5516 + t5560 + t5599);
  t5610 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1367 * t270 + 0.3e1 / 0.1e2 * t5172 + 0.9e1 / 0.2e2 * t7 * t513 * t692 - t5137 / 0.1e2 + 0.3e1 / 0.5e1 * t5179 + 0.9e1 / 0.2e2 * t7 * t204 * t1865 + t5098 - t5148 / 0.1e2 + 0.3e1 / 0.1e2 * t5187 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.77e3 / 0.243e3 * t5216 + 0.616e4 / 0.2187e4 * t38 * t1384 * t115 - 0.44e3 / 0.243e3 * t38 * t524 * t231 + 0.4e2 / 0.81e2 * t38 * t210 * t575 - 0.5e1 / 0.81e2 * t38 * t93 * t1514 + t1392 * t268 + 0.3e1 * t532 * t690 + 0.3e1 * t218 * t1863 + t103 * t5603));
  tv4rho3sigma11 = t8 * t5610 + 0.3e1 * t1870;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t5617 = t7 * t969 * t286;
  t5623 = t7 * t976 * t286;
  t5626 = t7 * t327 * t731;
  t5633 = 0.2e1 / 0.45e2 * t7 * t988 * t286;
  t5635 = t7 * t336 * t731;
  t5638 = t7 * t135 * t1986;
  t5658 = t1900 * t383;
  t5659 = t151 * t5658;
  t5667 = t281 * t1014;
  t5668 = t5667 * t383;
  t5669 = t1042 * t5668;
  t5674 = t359 * t5668;
  t5677 = t713 * t1019;
  t5678 = t151 * t5677;
  t5681 = -0.9e1 * t359 * t5658 * t2477 - 0.9e1 * t359 * t2517 * t4715 + 0.9e1 * t5659 * t2468 + 0.9e1 * t2481 * t4764 + 0.9e1 * t4732 * t2493 + 0.18e2 * t5674 * t3520 - 0.18e2 * t5678 * t4746 - 0.18e2 * t5669 * t4818 - 0.3e1 * t1898 - 0.2e1 * t1902 + 0.4e1 * t1943 + 0.4e1 * t1947 - t723;
  t5688 = t718 * t360;
  t5689 = t5688 * t383;
  t5695 = t2690 * params->csk_a;
  t5696 = t1113 * t5695;
  t5705 = t359 * t5677;
  t5710 = t359 * t5689;
  t5713 = t369 * t5658;
  t5718 = 0.9e1 * t151 * t5689 * t1103 - 0.9e1 * t5710 * t1090 + 0.9e1 * t5659 * t2227 + 0.9e1 * t2481 * t4782 - 0.9e1 * t2486 * t4764 - 0.3e1 * t2486 * t4782 - 0.3e1 * t2503 * t4782 - 0.6e1 * t5678 * t4751 - 0.6e1 * t5669 * t4755 + 0.18e2 * t5674 * t4755 + 0.18e2 * t4777 * t5696 + 0.18e2 * t5705 * t4790 + 0.9e1 * t4800 * t5713 - 0.12e2 * t5669 * t4824;
  t5724 = t369 * t5695;
  t5733 = t281 * t3624;
  t5734 = t359 * t5733;
  t5737 = t1042 * t5733;
  t5740 = t1044 * t2748;
  t5743 = t1959 * t362;
  t5744 = t151 * t5743;
  t5747 = t3680 * t1976;
  t5752 = t151 * t5667;
  t5755 = t359 * t5667;
  t5758 = -0.9e1 * t5710 * t1103 + 0.9e1 * t1570 * t5740 + 0.9e1 * t2481 * t4728 - 0.9e1 * t2503 * t4728 - 0.6e1 * t2503 * t4772 + 0.9e1 * t4732 * t2521 + 0.18e2 * t4777 * t5724 - 0.12e2 * t5752 * t4833 - 0.18e2 * t5734 * t4865 + 0.6e1 * t5737 * t4865 - 0.12e2 * t4893 * t5747 - 0.3e1 * t5755 * t4924 - 0.6e1 * t5737 * t4928 + 0.3e1 * t5744 * t608;
  t5765 = t151 * t5733;
  t5768 = t718 * t1015;
  t5769 = t151 * t5768;
  t5776 = t1067 * t718;
  t5778 = t1065 * t5776 * params->csk_a;
  t5781 = t3644 * t281;
  t5783 = t3688 * t5781 * params->csk_a;
  t5786 = t359 * t5743;
  t5791 = t359 * t5768;
  t5794 = t3660 * t1933;
  t5798 = t391 * t1905 * t383;
  t5802 = t1044 * t710 * t379;
  t5805 = -0.3e1 * t2191 * t1065 * t3569 * t281 - 0.3e1 * t1926 * t1095 + 0.9e1 * t1570 * t5778 + 0.9e1 * t5791 * t1604 - 0.3e1 * t5769 * t1614 + 0.9e1 * t1623 * t5798 + 0.3e1 * t5752 * t4837 - 0.3e1 * t5755 * t4837 - 0.11e2 * t5734 * t4844 + 0.11e2 * t5765 * t4844 - 0.6e1 * t4884 * t5783 - 0.18e2 * t4893 * t5794 - 0.9e1 * t4901 * t5802 - 0.3e1 * t5786 * t608;
  t5814 = t1065 * t1909 * t383;
  t5817 = t3640 * t5733;
  t5823 = t1042 * t5768;
  t5832 = t1044 * t1945;
  t5839 = 0.9e1 * t151 * t5688 * t1631 - 0.9e1 * t5823 * t1598 - 0.9e1 * t5769 * t1604 - 0.6e1 * t5823 * t1635 - 0.3e1 * t1926 * t1644 - 0.6e1 * t1913 * t4999 - 0.18e2 * t4827 * t5832 - 0.12e2 * t5817 * t4850 - 0.7e1 * t5734 * t4955 + 0.18e2 * t5737 * t4955 - 0.6e1 * t5002 * t5814 - t725 * t5009 - 0.3e1 * t5786 * t624;
  t5845 = t3660 * t710 * t1048;
  t5851 = t3680 * t1909 * t1048;
  t5870 = 0.9e1 * t5791 * t1614 - 0.3e1 * t5823 * t1614 + 0.12e2 * t5737 * t4850 + 0.6e1 * t5765 * t4865 - 0.7e1 * t5734 * t4868 + 0.6e1 * t5737 * t4868 + t5765 * t4868 - t5817 * t4868 - 0.6e1 * t4884 * t5747 + 0.7e1 * t4884 * t5845 + 0.18e2 * t4884 * t5851 - 0.7e1 * t5817 * t4955 + 0.7e1 * t4961 * t5794 - 0.11e2 * t5734 * t4965;
  t5874 = t3688 * t5781 * t1048;
  t5885 = my_piecewise3(t61, 0, -0.11e4 / 0.729e3 * t1540);
  t5886 = my_piecewise3(t63, t5885, 0);
  t5900 = -t151 * t5886 * t160 + 0.3e1 * t1920 * t1095 + 0.9e1 * t5791 * t1598 + 0.3e1 * t5752 * t3621 + 0.11e2 * t4884 * t5874 - 0.6e1 * t5817 * t4943 + t714 * t4951 - t725 * t4951 + 0.6e1 * t5765 * t5022 + 0.3e1 * t5026 * t711 + 0.3e1 * t5744 * t619 - 0.4e1 * t1964 + 0.4e1 * t1969 - 0.4e1 * t1971;
  t5901 = t1044 * t1905;
  t5904 = t3680 * t1909;
  t5914 = t391 * t368 * t1959;
  t5917 = t1065 * t5776;
  t5920 = t3688 * t5781;
  t5924 = t3660 * t710;
  t5938 = -t151 * t281 * t1117 * t385 - 0.3e1 * t151 * t1959 * t153 * t385 - 0.3e1 * t151 * t718 * t379 * t385 + 0.3e1 * t1085 * t1906 + 0.3e1 * t1920 * t1562 - 0.3e1 * t1570 * t5917 - 0.9e1 * t1574 * t5901 - 0.6e1 * t5769 * t1581 + t3562 * t711 + t4884 * t5920 + 0.6e1 * t4893 * t5904 + 0.11e2 * t4961 * t5924 + t714 * t5046 + 0.3e1 * t601 * t5914;
  t5942 = my_piecewise5(t58, 0, t61, 0, t5681 + t5718 + t5758 + t5805 + t5839 + t5870 + t5900 + t5938);
  t5949 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t965 * t286 + 0.3e1 / 0.1e2 * t5617 + 0.9e1 / 0.2e2 * t7 * t323 * t731 - t5623 / 0.1e2 + 0.3e1 / 0.5e1 * t5626 + 0.9e1 / 0.2e2 * t7 * t130 * t1986 + t5633 - t5635 / 0.1e2 + 0.3e1 / 0.1e2 * t5638 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.11e4 / 0.729e3 * t1543 + 0.1e3 / 0.81e2 * t1546 - 0.25e2 / 0.54e2 * t1549 + 0.5e1 / 0.54e2 * t38 * t48 * t1130 + t1008 * t284 + 0.3e1 * t353 * t729 + 0.3e1 * t149 * t1984 + t53 * t5942));
  tv4rho3lapl0 = t8 * t5949 + 0.3e1 * t1991;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t5956 = t7 * t1158 * t302;
  t5959 = t7 * t1162 * t302;
  t5963 = 0.2e1 / 0.45e2 * t7 * t1166 * t302;
  t5965 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1154 * t302 + 0.3e1 / 0.1e2 * t5956 - t5959 / 0.1e2 + t5963);
  tv4rho3lapl1 = t8 * t5965 + 0.3e1 * t2004;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t5967 = 0.2e1 * t2018;
  t5973 = t7 * t1196 * t286 / 0.5e1;
  t5978 = t7 * t1203 * t286;
  t5982 = t7 * t445 * t731 / 0.5e1;
  t5991 = 0.3e1 / 0.2e2 * t7 * t1192 * t286 + t5973 + 0.3e1 / 0.1e2 * t7 * t441 * t731 - t5978 / 0.3e2 + t5982 + 0.3e1 / 0.2e2 * t7 * t193 * t1986 + t5617 / 0.1e2 - t5623 / 0.15e2 + t5626 / 0.5e1 + t5633 - t5635 / 0.15e2 + t5638 / 0.1e2;
  t5992 = my_piecewise3(t2, 0, t5991);
  tv4rho3lapl2 = t8 * t5992 + t1991 + t5967;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t5994 = 0.2e1 * t2034;
  t6000 = t7 * t1239 * t302 / 0.5e1;
  t6002 = t7 * t1243 * t302;
  t6011 = t7 * t420 * t782 / 0.5e1;
  t6013 = t7 * t424 * t782;
  t6016 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1235 * t302 + t6000 - t6002 / 0.3e2 + t5956 / 0.1e2 - t5959 / 0.15e2 + t5963 + 0.3e1 / 0.2e2 * t7 * t416 * t782 + t6011 - t6013 / 0.3e2);
  tv4rho3lapl3 = t8 * t6016 + t2004 + t5994;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t6022 = t7 * t1280 * t286;
  t6031 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1276 * t286 + t6022 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t496 * t731 + t5973 - t5978 / 0.15e2 + t5982 - t5623 / 0.3e2 + t5633 - t5635 / 0.3e2);
  tv4rho3lapl4 = t8 * t6031 + t2042 + t5967;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t6037 = t7 * t1310 * t302;
  t6044 = t7 * t469 * t782;
  t6052 = t7 * t180 * t2151;
  t6054 = 0.3e1 / 0.2e2 * t7 * t1306 * t302 + t6037 / 0.1e2 + t6000 - t6002 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t465 * t782 + t6044 / 0.5e1 - t5959 / 0.3e2 + t5963 + t6011 - t6013 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t176 * t2151 + t6052 / 0.1e2;
  t6055 = my_piecewise3(t78, 0, t6054);
  tv4rho3lapl5 = t8 * t6055 + t2156 + t5994;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t6064 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1347 * t286 + 0.3e1 / 0.1e2 * t6022 - t5978 / 0.1e2 + t5633);
  tv4rho3lapl6 = t8 * t6064 + 0.3e1 * t2042;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t6094 = t538 * t2099;
  t6096 = t681 * t562;
  t6097 = t5295 * t112 * t6096;
  t6100 = t1458 * t562;
  t6106 = t769 * t224;
  t6107 = t6106 * t543;
  t6109 = t548 * t1851;
  t6114 = t764 * t1422;
  t6115 = t1417 * t6114;
  t6121 = t220 * t6107;
  t6126 = t538 * t6114;
  t6129 = -0.12e2 * t6115 * t1497 * t5285 - 0.9e1 * t6094 * t5366 * t6100 - 0.9e1 * t538 * t6107 * t6109 + 0.9e1 * t6121 * t1852 + 0.9e1 * t2100 * t6097 + 0.9e1 * t2607 * t5297 - 0.9e1 * t2612 * t5297 - 0.18e2 * t6115 * t5300 + 0.18e2 * t6126 * t5300 - 0.9e1 * t6094 * t6097 - 0.3e1 * t2076 - 0.2e1 * t2080 - t774;
  t6130 = t297 * t1398;
  t6131 = t6130 * t562;
  t6132 = t538 * t6131;
  t6135 = t220 * t6114;
  t6148 = t1417 * t2332 * t1422;
  t6149 = t2617 * t558;
  t6150 = t1497 * t6149;
  t6155 = t548 * t6149;
  t6166 = t2802 * params->csk_a;
  t6167 = t1497 * t6166;
  t6170 = -0.6e1 * t1417 * t6131 * t5277 + 0.9e1 * t2607 * t5262 + 0.9e1 * t2607 * t5337 - 0.3e1 * t2612 * t5337 - 0.9e1 * t2629 * t5262 - 0.6e1 * t2629 * t5329 - 0.3e1 * t2629 * t5337 + 0.18e2 * t6132 * t4392 - 0.18e2 * t6135 * t5256 + 0.18e2 * t6132 * t5277 - 0.6e1 * t6135 * t5286 + 0.18e2 * t5310 * t6167 + 0.9e1 * t6148 * t6150 + 0.9e1 * t6148 * t6155;
  t6177 = t548 * t6166;
  t6188 = t297 * t4479;
  t6189 = t538 * t6188;
  t6192 = t1417 * t6188;
  t6195 = t769 * t1418;
  t6196 = t220 * t6195;
  t6201 = t4505 * t6188;
  t6204 = t538 * t6195;
  t6207 = t4561 * t2128;
  t6210 = t538 * t6130;
  t6213 = t220 * t6130;
  t6216 = t220 * t6188;
  t6219 = -0.9e1 * t538 * t769 * t539 * t562 * t1487 + 0.18e2 * t5310 * t6177 + 0.9e1 * t2100 * t228 * t6100 + 0.9e1 * t538 * t558 * t224 * t543 * t2640 - 0.11e2 * t6189 * t5374 - 0.6e1 * t6192 * t5464 - 0.9e1 * t6196 * t1798 - 0.11e2 * t6189 * t5418 - 0.7e1 * t6201 * t5476 + 0.9e1 * t6204 * t1798 - 0.12e2 * t5446 * t6207 - 0.3e1 * t6210 * t5367 + 0.3e1 * t6213 * t5370 + 0.11e2 * t6216 * t5374;
  t6220 = t1423 * t2121;
  t6227 = t1417 * t6195;
  t6230 = t4509 * t297;
  t6232 = t4536 * t6230 * t1048;
  t6237 = t2090 * t541;
  t6238 = t220 * t6237;
  t6252 = t4561 * t2071 * t1048;
  t6255 = 0.3e1 * t2062 * t1471 - 0.3e1 * t2105 * t1471 + 0.9e1 * t6204 * t1790 - 0.9e1 * t6227 * t1790 - 0.6e1 * t6227 * t1835 - 0.12e2 * t6213 * t5362 - 0.3e1 * t6210 * t5370 + 0.11e2 * t5406 * t6232 + 0.18e2 * t5406 * t6252 + t765 * t5473 - t776 * t5473 - 0.18e2 * t5487 * t6220 - 0.6e1 * t6201 * t5528 + 0.3e1 * t6238 * t671;
  t6281 = -0.3e1 * t6196 * t1810 + 0.9e1 * t6204 * t1810 - 0.3e1 * t2105 * t1832 - 0.18e2 * t6189 * t5357 + 0.6e1 * t6192 * t5357 + 0.12e2 * t6192 * t5385 - 0.12e2 * t6201 * t5385 - 0.7e1 * t6189 * t5390 - t6201 * t5390 + t6216 * t5390 - 0.7e1 * t6189 * t5476 + 0.18e2 * t6192 * t5476 - t776 * t5519;
  t6282 = t1423 * t2833;
  t6285 = t538 * t6237;
  t6288 = t4528 * t2113;
  t6292 = t4528 * t761 * t1048;
  t6300 = t4536 * t6230 * params->csk_a;
  t6305 = t1443 * t769;
  t6307 = t1441 * t6305 * params->csk_a;
  t6313 = t1423 * t761 * t558;
  t6317 = t1441 * t2071 * t562;
  t6323 = t570 * t2067 * t562;
  t6327 = t1780 * t562;
  t6328 = t553 * t6327;
  t6331 = -0.3e1 * t2333 * t1441 * t4447 * t297 + 0.9e1 * t220 * t6106 * t6328 + 0.9e1 * t1774 * t6282 + 0.9e1 * t1774 * t6307 + 0.9e1 * t1823 * t6323 - 0.6e1 * t2085 * t5468 + 0.7e1 * t5406 * t6292 - 0.6e1 * t5406 * t6300 - 0.9e1 * t5427 * t6313 - 0.18e2 * t5446 * t6288 + 0.7e1 * t5504 * t6288 - 0.6e1 * t5531 * t6317 - 0.3e1 * t6285 * t671 - 0.3e1 * t6285 * t687;
  t6342 = my_piecewise3(t105, 0, -0.11e4 / 0.729e3 * t1736);
  t6343 = my_piecewise3(t107, t6342, 0);
  t6357 = t4528 * t761;
  t6360 = -t220 * t6343 * t229 - 0.3e1 * t6227 * t1810 + 0.3e1 * t6213 * t4476 + 0.6e1 * t6216 * t5357 + 0.6e1 * t6192 * t5390 - 0.6e1 * t5406 * t6207 + 0.11e2 * t5504 * t6357 + 0.6e1 * t6216 * t5548 + 0.3e1 * t5552 * t762 - 0.4e1 * t2096 + 0.4e1 * t2101 - 0.4e1 * t2103 + 0.4e1 * t2123 + 0.4e1 * t2126;
  t6361 = t4561 * t2071;
  t6366 = t4536 * t6230;
  t6383 = t1423 * t2067;
  t6391 = t570 * t547 * t2090;
  t6394 = t1441 * t6305;
  t6397 = -t220 * t297 * t1501 * t564 - 0.3e1 * t220 * t2090 * t222 * t564 - 0.3e1 * t220 * t769 * t558 * t564 + 0.3e1 * t1474 * t2068 - 0.9e1 * t1751 * t6383 + 0.3e1 * t2062 * t1767 - 0.3e1 * t1774 * t6394 - 0.6e1 * t6196 * t1781 + t4439 * t762 + t5406 * t6366 + 0.6e1 * t5446 * t6361 + t765 * t5575 + 0.3e1 * t6238 * t682 + 0.3e1 * t664 * t6391;
  t6401 = my_piecewise5(t104, 0, t105, 0, t6129 + t6170 + t6219 + t6255 + t6281 + t6331 + t6360 + t6397);
  t6408 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1367 * t302 + 0.3e1 / 0.1e2 * t6037 + 0.9e1 / 0.2e2 * t7 * t513 * t782 - t6002 / 0.1e2 + 0.3e1 / 0.5e1 * t6044 + 0.9e1 / 0.2e2 * t7 * t204 * t2151 + t5963 - t6013 / 0.1e2 + 0.3e1 / 0.1e2 * t6052 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.11e4 / 0.729e3 * t1739 + 0.1e3 / 0.81e2 * t1742 - 0.25e2 / 0.54e2 * t1745 + 0.5e1 / 0.54e2 * t38 * t98 * t1514 + t1392 * t300 + 0.3e1 * t532 * t780 + 0.3e1 * t218 * t2149 + t103 * t6401));
  tv4rho3lapl7 = t8 * t6408 + 0.3e1 * t2156;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho3tau1 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  tv4rho3tau2 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  tv4rho3tau3 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  tv4rho3tau4 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  tv4rho3tau5 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  tv4rho3tau6 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  tv4rho3tau7 = 0.e0;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t6415 = t7 * t327 * t811;
  t6422 = t7 * t336 * t811 / 0.3e2;
  t6424 = t7 * t135 * t2285;
  t6438 = 0.2e1 * t2179;
  t6439 = 0.2e1 * t2197;
  t6440 = 0.3e1 * t2200;
  t6442 = t1554 * t383;
  t6443 = t2471 * t6442;
  t6448 = t4923 * t6442;
  t6451 = t795 * t1019;
  t6452 = t1042 * t6451;
  t6453 = t1048 * t366;
  t6454 = t368 * t360;
  t6455 = t6454 * t383;
  t6456 = t6453 * t6455;
  t6459 = t1048 * t360;
  t6465 = t799 * t360 * t383;
  t6468 = 0.3e1 * t151 * t6465 * t1103;
  t6471 = 0.3e1 * t359 * t6465 * t1103;
  t6472 = t159 * t383;
  t6473 = t6459 * t6472;
  t6478 = t159 * params->csk_a * t612 * t153;
  t6481 = t359 * t6451;
  t6484 = -0.12e2 * t6452 * t1113 * t6459 * t383 + 0.12e2 * t1659 * t6443 - 0.12e2 * t2516 * t6443 - 0.12e2 * t2516 * t6448 - 0.12e2 * t4761 * t6478 - 0.18e2 * t6452 * t6456 - 0.6e1 * t6452 * t6473 + 0.18e2 * t6481 * t6456 - 0.4e1 * t2205 + t6438 + t6439 - t6440 + t6468 - t6471 - t801 - t803;
  t6485 = t799 * t155;
  t6487 = t359 * t6485 * t364;
  t6488 = t369 * t1661;
  t6490 = 0.3e1 * t6487 * t6488;
  t6501 = t1048 * t612 * t153;
  t6502 = t159 * t6501;
  t6507 = t2215 * t1019;
  t6510 = t159 * t372 * params->csk_a;
  t6517 = t1042 * t2190 * t1019;
  t6518 = t3210 * t612;
  t6534 = t1113 * t6501;
  t6540 = t2173 * t612;
  t6541 = t6453 * t6540;
  t6546 = 0.12e2 * t151 * t2201 * t364 * t159 * t4798 * t612 + 0.18e2 * t6452 * t1113 * t1661 + 0.12e2 * t6517 * t1113 * t6518 - 0.6e1 * t151 * t6451 * t6473 - 0.18e2 * t151 * t6507 * t6510 + 0.12e2 * t2516 * t369 * t6442 + 0.18e2 * t359 * t6507 * t6510 + 0.12e2 * t6517 * t369 * t6518 - 0.4e1 * t2490 * t6502 - 0.8e1 * t2490 * t6534 - 0.12e2 * t2490 * t6541 + 0.12e2 * t4725 * t6478 + 0.12e2 * t4725 * t6502 - 0.4e1 * t4761 * t6502 + 0.18e2 * t6452 * t6488 + 0.18e2 * t6481 * t6473 - t6490;
  t6550 = t4762 * t155;
  t6551 = t369 * t6550;
  t6555 = t159 * t4762 * t383;
  t6558 = t4762 * t1102;
  t6561 = t799 * t1015;
  t6562 = t359 * t6561;
  t6564 = 0.3e1 * t6562 * t1604;
  t6565 = t792 * t3624;
  t6566 = t151 * t6565;
  t6568 = t3768 * t1580 * params->csk_a;
  t6571 = t359 * t6565;
  t6574 = t1042 * t6565;
  t6575 = t3762 * t1603;
  t6578 = t792 * t3615;
  t6579 = t359 * t6578;
  t6580 = t1100 * t1603;
  t6583 = t3660 * t1597;
  t6587 = t1020 * t1580 * t362;
  t6594 = t3680 * t1634;
  t6597 = t1044 * t6455;
  t6600 = t360 * t3624;
  t6601 = t3640 * t6600;
  t6602 = t3644 * t792;
  t6607 = -0.6e1 * t6601 * t3688 * t6602 * params->csk_a + 0.3e1 * t2209 * t6555 - 0.3e1 * t2217 * t6551 - 0.3e1 * t2217 * t6558 - 0.12e2 * t2225 * t6587 + 0.12e2 * t4725 * t6541 + 0.11e2 * t6566 * t6568 + 0.6e1 * t6566 * t6575 - 0.11e2 * t6571 * t6568 - 0.18e2 * t6571 * t6575 - 0.11e2 * t6571 * t6583 + 0.6e1 * t6574 * t6575 - 0.6e1 * t6574 * t6594 - 0.3e1 * t6579 * t6580 - 0.18e2 * t805 * t6597 + t6564;
  t6610 = t3680 * t3088;
  t6613 = t3640 * t6565;
  t6615 = t3672 * t1113 * t360;
  t6618 = t1042 * t6561;
  t6620 = 0.3e1 * t6618 * t1598;
  t6624 = t3672 * t369 * t360;
  t6627 = t6454 * params->csk_a;
  t6628 = t3660 * t6627;
  t6631 = t151 * t6561;
  t6633 = 0.3e1 * t6631 * t1604;
  t6634 = t6618 * t1614;
  t6644 = 0.3e1 * t6562 * t1598;
  t6646 = t374 * t375 * t1648;
  t6651 = t2246 * t1644;
  t6652 = 0.3e1 * t2172 * t3575 - 0.3e1 * t2235 * t3575 + 0.2e1 * t606 * t6646 - 0.7e1 * t6571 * t6624 + 0.7e1 * t6571 * t6628 + 0.12e2 * t6574 * t6615 + 0.18e2 * t6574 * t6624 - 0.18e2 * t6574 * t6628 + 0.7e1 * t6613 * t6583 + 0.18e2 * t6601 * t6610 - 0.12e2 * t6613 * t6615 - 0.7e1 * t6613 * t6624 - t6620 - t6633 - t6634 + t6644 - t6651;
  t6655 = t1067 * t799;
  t6657 = t1065 * t6655 * params->csk_a;
  t6659 = 0.3e1 * t1570 * t6657;
  t6661 = 0.2e1 * t6618 * t1635;
  t6663 = t391 * t392 * t1648;
  t6673 = t3688 * t3693 * t360;
  t6678 = t1042 * t372;
  t6702 = t391 * t2195 * t383;
  t6704 = 0.3e1 * t1623 * t6702;
  t6706 = t1580 * t383;
  t6709 = 0.3e1 * t151 * t6485 * t374 * t6706;
  t6710 = t6659 - t6661 - 0.2e1 * t621 * t6663 - 0.2e1 * t2235 * t3587 + 0.11e2 * t6601 * t3688 * t6602 * t1048 - 0.6e1 * t6613 * t6673 + 0.3e1 * t2267 * t3581 - 0.6e1 * t6678 * t1065 * t2192 * t383 - 0.12e2 * t1595 * t1044 * t6540 - 0.12e2 * t6574 * t3680 * t1067 * t360 * params->csk_a + 0.3e1 * t2235 * t3571 - 0.2e1 * t621 * t6646 + 0.3e1 * t2235 * t3537 - 0.6e1 * t6601 * t3680 * t2192 * params->csk_a + t6704 + t6709;
  t6712 = t3768 * t3769 * t360;
  t6719 = t1044 * t3085;
  t6721 = 0.3e1 * t1570 * t6719;
  t6722 = t6631 * t1614;
  t6724 = 0.3e1 * t6562 * t1614;
  t6725 = t792 * t360;
  t6729 = t391 * t6627;
  t6734 = t2178 * t1095;
  t6735 = t2246 * t1095;
  t6746 = -0.4e1 * t2191 * t1065 * t1571 * t612 + 0.3e1 * t151 * t6725 * t4837 + 0.3e1 * t2172 * t3530 + 0.3e1 * t2172 * t3599 - t2180 * t3530 - 0.3e1 * t2180 * t3599 - t2235 * t3530 + t6566 * t6712 - 0.7e1 * t6571 * t6712 + 0.6e1 * t6574 * t6712 - 0.3e1 * t6579 * t6729 - t6613 * t6712 + t6721 - t6722 + t6724 + t6734 - t6735;
  t6749 = t374 * t1561 * t155;
  t6753 = t1020 * t618 * t612;
  t6756 = t612 * t612;
  t6757 = t151 * t6756;
  t6769 = 0.2e1 * t2245;
  t6770 = 0.2e1 * t2247;
  t6772 = 0.2e1 * t2280;
  t6773 = t6756 * t362;
  t6774 = t359 * t6773;
  t6778 = 0.2e1 * t6631 * t1581;
  t6780 = t374 * t1580;
  t6783 = t3768 * t1580;
  t6786 = 0.3e1 * t151 * t6578 * t6780 + 0.2e1 * t359 * t6756 * t370 - 0.8e1 * t1579 * t6753 + 0.3e1 * t2225 * t6749 - 0.2e1 * t6774 * t376 - 0.2e1 * t6757 * t385 + 0.2e1 * t6757 * t387 + 0.6e1 * t6566 * t6783 + 0.4e1 * t2213 - 0.4e1 * t2220 - 0.4e1 * t2223 + 0.4e1 * t2228 + 0.4e1 * t2270 + t6769 - t6770 - t6772 - t6778;
  t6798 = t1042 * t3511;
  t6802 = t1085 * t2196;
  t6803 = t1065 * t6655;
  t6804 = t1570 * t6803;
  t6807 = t151 * t799 * t379 * t385;
  t6808 = t158 * t1648;
  t6814 = t1042 * t6600;
  t6818 = t2178 * t1562;
  t6819 = t1044 * t2195;
  t6821 = 0.3e1 * t1574 * t6819;
  t6822 = t1020 * t1561;
  t6825 = t374 * t6808;
  t6830 = 0.11e2 * t6571 * t3660 * t6454 + 0.3e1 * t359 * t6725 * t3617 + 0.2e1 * t151 * t6773 * t376 - 0.2e1 * t6774 * t393 - t6798 * t2193 + t6601 * t3688 * t6602 + t6802 - t6804 - t6807 - 0.2e1 * t2202 * t2203 * t6808 - 0.3e1 * t2172 * t3751 + 0.6e1 * t6814 * t3680 * t2192 + t6818 - t6821 - 0.2e1 * t2180 * t6822 + 0.2e1 * t606 * t6825 + 0.2e1 * t621 * t5052;
  t6834 = my_piecewise5(t58, 0, t61, 0, t6484 + t6546 + t6607 + t6652 + t6710 + t6746 + t6786 + t6830);
  t6841 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t811 + t6415 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t2285 - t6422 + t6424 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.88e3 / 0.729e3 * t38 * t345 * t251 + 0.16e3 / 0.243e3 * t38 * t141 * t627 - 0.1e2 / 0.81e2 * t38 * t43 * t1667 + t353 * t809 + 0.2e1 * t149 * t2283 + t53 * t6834));
  tv4rho2sigma20 = t8 * t6841 + 0.2e1 * t2290;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t6848 = t7 * t420 * t838;
  t6852 = t7 * t424 * t838 / 0.3e2;
  t6854 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t838 + t6848 / 0.5e1 - t6852);
  tv4rho2sigma25 = t8 * t6854 + 0.2e1 * t2299;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t6860 = t7 * t445 * t811;
  t6868 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t811 + t6860 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t2285 + t6415 / 0.1e2 - t6422 + t6424 / 0.1e2);
  tv4rho2sigma26 = t8 * t6868 + t2290 + t2305;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t6874 = t7 * t469 * t838;
  t6881 = t7 * t180 * t2431;
  t6884 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t838 + t6874 / 0.1e2 + t6848 / 0.1e2 - t6852 + 0.3e1 / 0.2e2 * t7 * t176 * t2431 + t6881 / 0.1e2);
  tv4rho2sigma211 = t8 * t6884 + t2299 + t2436;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t6892 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t811 + t6860 / 0.5e1 - t6422);
  tv4rho2sigma212 = t8 * t6892 + 0.2e1 * t2305;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t6915 = 0.2e1 * t2329;
  t6916 = 0.2e1 * t2339;
  t6917 = 0.3e1 * t2342;
  t6919 = t1759 * t562;
  t6923 = t2597 * t6919;
  t6928 = t822 * t1422;
  t6929 = t1417 * t6928;
  t6933 = t826 * t539 * t562;
  t6936 = 0.3e1 * t220 * t6933 * t1487;
  t6939 = 0.3e1 * t538 * t6933 * t1487;
  t6940 = t1048 * t112;
  t6941 = t2346 * t222;
  t6942 = t6940 * t6941;
  t6948 = t1048 * t675 * t222;
  t6949 = t548 * t6948;
  t6954 = t2353 * t1422;
  t6957 = t228 * t551 * params->csk_a;
  t6960 = t3280 * t675;
  t6964 = -0.18e2 * t220 * t6954 * t6957 - 0.12e2 * t2638 * t5366 * t6919 + 0.12e2 * t6148 * t548 * t6960 + 0.12e2 * t1849 * t6923 - 0.4e1 * t2616 * t6942 - 0.12e2 * t2638 * t6923 + 0.12e2 * t5259 * t6942 + 0.12e2 * t5259 * t6949 - 0.4e1 * t5294 * t6942 + 0.18e2 * t6929 * t6109 - 0.4e1 * t2348 + t6915 + t6916 - t6917 + t6936 - t6939;
  t6970 = t538 * t6928;
  t6971 = t1048 * t539;
  t6972 = t6971 * t5255;
  t6977 = t6971 * t562;
  t6983 = t228 * params->csk_a * t675 * t222;
  t6986 = t548 * t6977;
  t6989 = t826 * t224;
  t6991 = t538 * t6989 * t543;
  t6993 = 0.3e1 * t6991 * t6109;
  t6999 = t228 * t5295 * t562;
  t7002 = t5295 * t224;
  t7003 = t548 * t7002;
  t7006 = t5295 * t1486;
  t7018 = -0.12e2 * t2616 * t6949 + 0.18e2 * t538 * t6954 * t6957 - t828 - t830 + 0.18e2 * t6970 * t6972 - 0.6e1 * t6929 * t6972 - 0.12e2 * t6929 * t1497 * t6977 - 0.12e2 * t5294 * t6983 + 0.18e2 * t6970 * t6986 - t6993 + 0.12e2 * t5259 * t6983 - 0.18e2 * t6929 * t6986 + 0.3e1 * t2362 * t6999 - 0.3e1 * t2355 * t7003 - 0.3e1 * t2355 * t7006 + 0.12e2 * t220 * t2343 * t543 * t228 * t5321 * t675 + 0.12e2 * t2638 * t548 * t6919;
  t7026 = t1497 * t6948;
  t7032 = t826 * t1418;
  t7033 = t1417 * t7032;
  t7035 = 0.3e1 * t7033 * t1790;
  t7036 = t819 * t4479;
  t7037 = t4505 * t7036;
  t7038 = t4528 * t1789;
  t7042 = t4580 * t548 * t539;
  t7045 = t220 * t7032;
  t7047 = 0.3e1 * t7045 * t1798;
  t7048 = t538 * t7032;
  t7050 = 0.3e1 * t7048 * t1798;
  t7051 = t220 * t7036;
  t7053 = t4602 * t1780 * params->csk_a;
  t7056 = t538 * t7036;
  t7059 = t547 * t539;
  t7060 = t7059 * params->csk_a;
  t7061 = t4528 * t7060;
  t7068 = t4602 * t4633 * t539;
  t7072 = t1417 * t7036;
  t7075 = -0.12e2 * t823 * t1428 * t6327 + 0.18e2 * t6929 * t1497 * t1851 + 0.12e2 * t6148 * t1497 * t6960 - 0.6e1 * t220 * t6928 * t6972 - 0.8e1 * t2616 * t7026 + 0.7e1 * t7037 * t7038 - 0.7e1 * t7037 * t7042 + 0.11e2 * t7051 * t7053 + t7051 * t7068 - 0.11e2 * t7056 * t7053 + 0.7e1 * t7056 * t7061 - 0.7e1 * t7056 * t7068 + 0.6e1 * t7072 * t7068 - t7035 - t7047 + t7050;
  t7077 = t1423 * t3166;
  t7079 = 0.3e1 * t1774 * t7077;
  t7080 = t7045 * t1810;
  t7082 = 0.3e1 * t7048 * t1810;
  t7083 = t7033 * t1810;
  t7087 = t4561 * t5383 * t539;
  t7095 = 0.3e1 * t7048 * t1790;
  t7098 = t539 * t4479;
  t7099 = t4505 * t7098;
  t7100 = t4509 * t819;
  t7106 = t553 * t554 * t1844;
  t7115 = t4561 * t3169;
  t7118 = -0.6e1 * t7099 * t4536 * t7100 * params->csk_a + 0.3e1 * t2322 * t4453 + 0.3e1 * t2387 * t4449 - 0.3e1 * t2387 * t4453 + 0.2e1 * t669 * t7106 - 0.2e1 * t684 * t7106 - t7037 * t7068 - 0.7e1 * t7056 * t7042 + 0.18e2 * t7072 * t7042 - 0.18e2 * t7072 * t7061 + 0.12e2 * t7072 * t7087 + 0.18e2 * t7099 * t7115 + t7079 - t7080 + t7082 - t7083 + t7095;
  t7124 = t570 * t571 * t1844;
  t7134 = t4536 * t4590 * t539;
  t7139 = t1417 * t551;
  t7148 = t1428 * t6941;
  t7151 = t4481 * t1048;
  t7152 = t7151 * t1797;
  t7155 = t4561 * t1834;
  t7159 = t1423 * t7059 * t562;
  t7166 = t2328 * t1471;
  t7167 = t2380 * t1471;
  t7168 = -0.12e2 * t7037 * t7087 - 0.2e1 * t684 * t7124 - 0.2e1 * t2387 * t4464 + 0.11e2 * t7099 * t4536 * t7100 * t1048 - 0.6e1 * t7037 * t7134 + 0.3e1 * t2418 * t4381 - 0.6e1 * t7139 * t1441 * t2334 * t562 - 0.12e2 * t1787 * t1423 * t2323 * t675 - 0.8e1 * t1779 * t7148 + 0.6e1 * t7072 * t7152 - 0.6e1 * t7072 * t7155 - 0.18e2 * t832 * t7159 - 0.11e2 * t7056 * t7038 - 0.3e1 * t2318 * t4442 + t7166 - t7167;
  t7178 = t2380 * t1832;
  t7179 = t1443 * t826;
  t7181 = t1441 * t7179 * params->csk_a;
  t7183 = 0.3e1 * t1774 * t7181;
  t7185 = 0.2e1 * t7033 * t1835;
  t7187 = t553 * t1766 * t224;
  t7202 = t819 * t4474;
  t7203 = t538 * t7202;
  t7204 = t1484 * t1797;
  t7207 = t819 * t539;
  t7211 = t570 * t7060;
  t7218 = 0.3e1 * t2322 * t4442 + 0.3e1 * t2322 * t4432 - t2387 * t4432 - 0.4e1 * t2333 * t1441 * t1775 * t675 - t7178 + t7183 - t7185 + 0.3e1 * t2382 * t7187 + 0.3e1 * t2387 * t4427 - 0.6e1 * t7099 * t4561 * t2334 * params->csk_a - t2318 * t4432 - 0.12e2 * t7072 * t4561 * t1443 * t539 * params->csk_a - 0.3e1 * t7203 * t7204 + 0.3e1 * t220 * t7207 * t5370 - 0.3e1 * t7203 * t7211 + 0.6e1 * t7051 * t7152 - 0.18e2 * t7056 * t7152;
  t7221 = t570 * t2337 * t562;
  t7223 = 0.3e1 * t1823 * t7221;
  t7226 = 0.3e1 * t220 * t6989 * t6328;
  t7227 = t675 * t675;
  t7228 = t220 * t7227;
  t7239 = 0.2e1 * t2381;
  t7241 = 0.2e1 * t2397;
  t7242 = 0.2e1 * t2398;
  t7245 = t553 * t1780;
  t7249 = 0.2e1 * t7045 * t1781;
  t7253 = t227 * t1844;
  t7257 = 0.3e1 * t220 * t7202 * t7245 - 0.2e1 * t2344 * t2345 * t7253 + 0.3e1 * t538 * t7207 * t4487 + 0.2e1 * t538 * t7227 * t549 - 0.2e1 * t7228 * t564 + 0.2e1 * t7228 * t566 - 0.4e1 * t2358 + 0.4e1 * t2365 - 0.4e1 * t2369 + 0.4e1 * t2385 + 0.4e1 * t2421 + t7223 + t7226 - t7239 + t7241 - t7242 - t7249;
  t7258 = t553 * t7253;
  t7261 = t1428 * t1766;
  t7264 = t538 * t7098;
  t7265 = t547 * t819;
  t7271 = t1417 * t7098;
  t7275 = t2328 * t1767;
  t7276 = t1423 * t2337;
  t7278 = 0.3e1 * t1751 * t7276;
  t7281 = t1417 * t4384;
  t7285 = t1474 * t2338;
  t7286 = t1441 * t7179;
  t7287 = t1774 * t7286;
  t7290 = t220 * t826 * t558 * t564;
  t7291 = t7227 * t541;
  t7295 = t538 * t7291;
  t7300 = t4602 * t1780;
  t7303 = 0.2e1 * t220 * t7291 * t555 + 0.6e1 * t7271 * t4561 * t2334 + 0.11e2 * t7264 * t4528 * t7265 + t7099 * t4536 * t7100 - 0.2e1 * t2318 * t7261 - 0.3e1 * t2322 * t4612 - t7281 * t2335 - 0.2e1 * t7295 * t555 + 0.2e1 * t684 * t5581 - 0.2e1 * t7295 * t572 + 0.2e1 * t669 * t7258 + 0.6e1 * t7051 * t7300 + t7275 - t7278 + t7285 - t7287 - t7290;
  t7307 = my_piecewise5(t104, 0, t105, 0, t6964 + t7018 + t7075 + t7118 + t7168 + t7218 + t7257 + t7303);
  t7314 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t838 + t6874 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t2431 - t6852 + t6881 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.88e3 / 0.729e3 * t38 * t524 * t268 + 0.16e3 / 0.243e3 * t38 * t210 * t690 - 0.1e2 / 0.81e2 * t38 * t93 * t1863 + t532 * t836 + 0.2e1 * t218 * t2429 + t103 * t7307));
  tv4rho2sigma217 = t8 * t7314 + 0.2e1 * t2436;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t7321 = t7 * t327 * t866;
  t7328 = t7 * t336 * t866 / 0.3e2;
  t7330 = t7 * t135 * t2545;
  t7359 = t718 * t155 * t364;
  t7360 = t359 * t7359;
  t7361 = t4923 * t2472;
  t7364 = t1060 * t360;
  t7365 = t7364 * t3519;
  t7368 = t1042 * t2465;
  t7371 = t159 * t1048;
  t7378 = t369 * t1048;
  t7385 = t372 * t1019;
  t7386 = t1042 * t7385;
  t7387 = t1113 * t281;
  t7392 = t6459 * t362;
  t7398 = t369 * t281;
  t7402 = -0.2e1 * t2459 - 0.2e1 * t2462 + t6438 + t6439 - t6440 - t855 - 0.18e2 * t5678 * t2471 * t1651 + 0.18e2 * t2466 * t1601 * t360 * t3519 - 0.6e1 * t7360 * t7361 + 0.18e2 * t2466 * t7365 - 0.6e1 * t7368 * t7365 - 0.6e1 * t5678 * t7371 * t1651 + 0.3e1 * t1968 * t2471 * t4718 + 0.18e2 * t5705 * t7378 * t1651 - 0.3e1 * t2466 * t2476 * t6550 + 0.18e2 * t7386 * t7387 * t3218 - 0.12e2 * t7368 * t1065 * t1067 * t7392 - 0.3e1 * t2466 * t4715 + 0.18e2 * t7386 * t7398 * t3218;
  t7406 = t359 * t1967;
  t7409 = t151 * t7359;
  t7423 = t6600 * t3626;
  t7424 = t3640 * t7423;
  t7425 = t853 * params->csk_a;
  t7426 = t1113 * t7425;
  t7429 = t5733 * t3626;
  t7430 = t359 * t7429;
  t7431 = t6459 * t2482;
  t7434 = t1042 * t7429;
  t7435 = t2496 * t360;
  t7445 = t151 * t7429;
  t7447 = t159 * t3210 * t360;
  t7451 = t359 * t853 * t3615;
  t7458 = t3671 * t248;
  t7459 = t7458 * t360;
  t7460 = t159 * t7459;
  t7462 = -0.18e2 * t7368 * t7364 * t4817 - 0.6e1 * t7406 * t6448 + 0.6e1 * t7409 * t2473 + 0.6e1 * t1968 * t6443 - 0.6e1 * t7360 * t2473 - 0.6e1 * t7406 * t6443 - 0.4e1 * t2469 + 0.4e1 * t2474 - 0.4e1 * t2478 - 0.6e1 * t2503 * t6541 - 0.6e1 * t7424 * t7426 - 0.18e2 * t7430 * t7431 - 0.6e1 * t7434 * t1113 * t7435 - 0.12e2 * t2511 * t6587 + 0.3e1 * t151 * t1941 * t3615 * t851 + 0.11e2 * t7445 * t7447 - 0.3e1 * t7451 * t6729 - 0.3e1 * t7451 * t6580 - 0.11e2 * t7430 * t7447 + t7445 * t7460;
  t7468 = t3640 * t7429;
  t7470 = t1113 * t7459;
  t7477 = t5768 * t1019;
  t7478 = t1042 * t7477;
  t7481 = t4840 * t3626;
  t7482 = t3640 * t7481;
  t7483 = t281 * t1048;
  t7484 = t7483 * t360;
  t7490 = t359 * t7477;
  t7495 = t1042 * t7423;
  t7498 = t151 * t7477;
  t7513 = t2491 * t612;
  t7514 = t1113 * t7513;
  t7517 = 0.7e1 * t7482 * t369 * t7484 + 0.6e1 * t2481 * t6502 + 0.6e1 * t2481 * t6541 - 0.2e1 * t2486 * t6502 - 0.2e1 * t7478 * t2498 + 0.6e1 * t7490 * t2498 - 0.2e1 * t7498 * t2498 - 0.2e1 * t2503 * t6502 - 0.4e1 * t7478 * t2505 - 0.6e1 * t7478 * t2508 + 0.6e1 * t7490 * t2508 + 0.6e1 * t6517 * t7514 - 0.12e2 * t7495 * t7426 - 0.7e1 * t7430 * t7460 + 0.6e1 * t7434 * t7431 + 0.6e1 * t7445 * t7431 + 0.6e1 * t7434 * t7460 + 0.12e2 * t7434 * t7470 - t7468 * t7460 - 0.12e2 * t7468 * t7470;
  t7531 = t369 * t7459;
  t7534 = t4726 * t2482;
  t7539 = t2457 * t383;
  t7543 = t2460 * t383;
  t7548 = t159 * t3210 * t379;
  t7552 = t369 * t7425;
  t7558 = t369 * t7513;
  t7570 = t1896 * t383;
  t7577 = -0.4e1 * t2503 * t6534 - 0.6e1 * t7386 * t1113 * t2465 - 0.6e1 * t7498 * t2483 - 0.6e1 * t2486 * t6478 + 0.6e1 * t7490 * t2483 + 0.6e1 * t2481 * t6478 - 0.7e1 * t7430 * t7531 + 0.3e1 * t2481 * t7534 + 0.18e2 * t7434 * t7531 + 0.6e1 * t151 * t7539 * t2227 + 0.6e1 * t151 * t7543 * t2227 - 0.3e1 * t2486 * t7548 + 0.7e1 * t359 * t7423 * t7552 - 0.11e2 * t7430 * t369 * t7435 + 0.6e1 * t6517 * t7558 + 0.3e1 * t2481 * t7548 - 0.18e2 * t7495 * t7552 + 0.6e1 * t359 * t612 * t155 * t364 * t2518 + 0.6e1 * t2516 * t369 * t7570 - 0.6e1 * t7424 * t3645 * t7425;
  t7580 = t718 * params->csk_a;
  t7581 = t7580 * t248;
  t7582 = t369 * t7581;
  t7585 = t1113 * t7581;
  t7588 = t2491 * t379;
  t7599 = t2496 * t369 * t379;
  t7627 = 0.6e1 * t6517 * t7582 + 0.6e1 * t6517 * t7585 + 0.3e1 * t2490 * t1113 * t7588 + 0.3e1 * t2511 * t6749 - 0.18e2 * t359 * t7385 * t369 * t2465 - 0.3e1 * t2503 * t7599 + 0.3e1 * t2516 * t5713 - t2503 * t7534 - 0.7e1 * t7468 * t7531 - 0.2e1 * t2503 * t1113 * t2496 * t379 + 0.11e2 * t7424 * t3645 * t7483 * t248 - 0.6e1 * t7468 * t3645 * t7459 + 0.3e1 * t2481 * t7599 + 0.3e1 * t2490 * t369 * t7588 + 0.18e2 * t7482 * t1113 * t7484 - t2486 * t7534 - t801 + t6468 - t6471;
  t7630 = t3616 * t7398;
  t7647 = t359 * t6600;
  t7667 = t1065 * t4980 * t281;
  t7674 = -t6490 + t5744 * t851 + 0.3e1 * t359 * t1628 * t7630 + 0.3e1 * t854 * t3616 * t1603 + 0.6e1 * t5765 * t3768 * t856 * t360 + 0.6e1 * t6814 * t3680 * t2537 - 0.2e1 * t1913 * t1020 * t856 * t379 + 0.11e2 * t7647 * t3660 * t710 * t248 - 0.3e1 * t1595 * t5802 + 0.2e1 * t1920 * t2231 + t714 * t6646 - t5786 * t851 - 0.2e1 * t1926 * t2231 - t725 * t6646 - t5786 * t861 - 0.2e1 * t1926 * t2260 - t725 * t6663 - t6798 * t2538 - 0.2e1 * t2191 * t7667 - 0.2e1 * t2191 * t1065 * t1571 * t718;
  t7685 = t1905 * t153;
  t7689 = t6601 * t3688 * t4937 * t281 - 0.6e1 * t1595 * t1044 * t7685 - 0.4e1 * t1913 * t6753 - 0.4e1 * t5769 * t2528 - 0.6e1 * t4854 * t2532 + t6564 - t6620 - t6633 - t6634 + t6644 - t6651 + t6659 - t6661 + t6704 + t6709 + t6721 - t6722 + t6724 + t6734 - t6735;
  t7710 = 0.4e1 * t2512 + 0.4e1 * t2519 + t6769 - t6770 - t6772 - t6778 + t6802 - t6804 - t6807 + t6818 - t6821 - t151 * t281 * t1648 * t385 + t5744 * t857 + 0.2e1 * t1920 * t2185 + t714 * t6825 + t4958 * t711 + 0.2e1 * t1607 * t1906 + t621 * t5914 - t151 * t1959 * t248 * t385 - 0.2e1 * t151 * t718 * t612 * t385;
  t7714 = my_piecewise5(t58, 0, t61, 0, t7402 + t7462 + t7517 + t7577 + t7627 + t7674 + t7689 + t7710);
  t7721 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t866 + t7321 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t2545 - t7328 + t7330 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.1e3 / 0.243e3 * t2165 - 0.25e2 / 0.81e2 * t2168 + 0.5e1 / 0.54e2 * t38 * t48 * t1667 - 0.44e3 / 0.729e3 * t38 * t345 * t284 + 0.8e2 / 0.243e3 * t38 * t141 * t729 - 0.5e1 / 0.81e2 * t38 * t43 * t1984 + t353 * t864 + 0.2e1 * t149 * t2543 + t53 * t7714));
  tv4rho2sigmalapl0 = t8 * t7721 + 0.2e1 * t2550;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t7728 = t7 * t420 * t894;
  t7732 = t7 * t424 * t894 / 0.3e2;
  t7734 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t894 + t7728 / 0.5e1 - t7732);
  tv4rho2sigmalapl5 = t8 * t7734 + 0.2e1 * t2559;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t7740 = t7 * t445 * t866;
  t7748 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t866 + t7740 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t2545 + t7321 / 0.1e2 - t7328 + t7330 / 0.1e2);
  tv4rho2sigmalapl6 = t8 * t7748 + t2550 + t2565;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t7754 = t7 * t469 * t894;
  t7761 = t7 * t180 * t2672;
  t7764 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t894 + t7754 / 0.1e2 + t7728 / 0.1e2 - t7732 + 0.3e1 / 0.2e2 * t7 * t176 * t2672 + t7761 / 0.1e2);
  tv4rho2sigmalapl11 = t8 * t7764 + t2559 + t2677;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t7772 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t866 + t7740 / 0.5e1 - t7328);
  tv4rho2sigmalapl12 = t8 * t7772 + 0.2e1 * t2565;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t7809 = t2583 * t562;
  t7810 = t220 * t7809;
  t7813 = t538 * t7809;
  t7816 = t2586 * t562;
  t7817 = t220 * t7816;
  t7820 = t538 * t7816;
  t7823 = t1436 * t539;
  t7824 = t7823 * t4391;
  t7827 = t1417 * t2591;
  t7830 = t228 * t1048;
  t7838 = t1417 * t551 * t1422;
  t7839 = t1497 * t297;
  t7844 = t6971 * t541;
  t7851 = -0.2e1 * t2585 - 0.2e1 * t2588 + t6915 + t6916 - t6917 - t883 + 0.18e2 * t2592 * t1463 * t539 * t4391 - 0.18e2 * t6135 * t2597 * t1855 + 0.6e1 * t7810 * t2594 - 0.6e1 * t7813 * t2594 + 0.6e1 * t7817 * t2594 - 0.6e1 * t7820 * t2594 + 0.18e2 * t2592 * t7824 - 0.6e1 * t7827 * t7824 - 0.6e1 * t6135 * t7830 * t1855 - 0.3e1 * t2592 * t2602 * t7002 + 0.18e2 * t7838 * t7839 * t3281 - 0.12e2 * t7827 * t1441 * t1443 * t7844 + 0.3e1 * t2100 * t2597 * t5239;
  t7852 = t548 * t1048;
  t7858 = t548 * t297;
  t7872 = t7098 * t4481;
  t7873 = t4505 * t7872;
  t7874 = t297 * t1048;
  t7879 = t6188 * t4481;
  t7880 = t4505 * t7879;
  t7881 = t3671 * t265;
  t7890 = t5260 * t2608;
  t7893 = t1417 * t7879;
  t7894 = t3671 * t539;
  t7895 = t548 * t265;
  t7896 = t7894 * t7895;
  t7903 = t2617 * t265;
  t7904 = t548 * t7903;
  t7907 = t538 * t7879;
  t7908 = t2622 * t539;
  t7914 = t5354 * t4481;
  t7915 = t4505 * t7914;
  t7916 = t7874 * t539;
  t7920 = 0.18e2 * t6126 * t7852 * t1855 - 0.3e1 * t2592 * t5246 + 0.18e2 * t7838 * t7858 * t3281 - 0.18e2 * t7827 * t7823 * t5315 - 0.6e1 * t7813 * t2603 - 0.6e1 * t7820 * t2603 - 0.4e1 * t2595 + 0.4e1 * t2600 - 0.4e1 * t2604 + 0.11e2 * t7873 * t4510 * t7874 * t265 - 0.6e1 * t7880 * t4510 * t7881 * t539 + 0.3e1 * t2638 * t548 * t2078 * t562 + 0.3e1 * t2607 * t7890 + 0.18e2 * t7893 * t7896 - t2629 * t7890 - 0.7e1 * t7880 * t7896 + 0.7e1 * t538 * t7872 * t7904 - 0.11e2 * t7907 * t548 * t7908 + 0.3e1 * t2616 * t6155 + 0.18e2 * t7915 * t1497 * t7916;
  t7925 = t7894 * t2608;
  t7928 = t1497 * t7903;
  t7935 = t6195 * t1422;
  t7936 = t220 * t7935;
  t7939 = t538 * t7935;
  t7946 = t2622 * t558;
  t7947 = t548 * t7946;
  t7953 = t7881 * t1497 * t539;
  t7960 = t1428 * t1780 * t541;
  t7973 = t220 * t7879;
  t7975 = t228 * t3280 * t539;
  t7979 = t538 * t881 * t4474;
  t7982 = -t2612 * t7890 - 0.7e1 * t7907 * t7896 + 0.6e1 * t7893 * t7925 - 0.6e1 * t7873 * t7928 - 0.6e1 * t2612 * t6983 + 0.6e1 * t2607 * t6983 - 0.6e1 * t7936 * t2609 + 0.6e1 * t7939 * t2609 + 0.3e1 * t2648 * t7187 + 0.3e1 * t2616 * t6150 + 0.3e1 * t2607 * t7947 - 0.3e1 * t2629 * t7947 - 0.12e2 * t7880 * t7953 - 0.2e1 * t2629 * t1497 * t7946 - 0.12e2 * t2648 * t7960 - 0.6e1 * t7893 * t1497 * t7908 - 0.18e2 * t5253 * t548 * t2094 + 0.3e1 * t220 * t2093 * t4474 * t879 + 0.11e2 * t7973 * t7975 - 0.3e1 * t7979 * t7211;
  t7990 = t6971 * t2608;
  t8004 = t1417 * t5410 * t1422;
  t8008 = t769 * params->csk_a * t222;
  t8009 = t548 * t8008;
  t8014 = t1417 * t7935;
  t8025 = t1417 * t7872;
  t8030 = 0.7e1 * t7915 * t548 * t7916 + 0.6e1 * t2607 * t6942 + 0.6e1 * t2607 * t6949 + 0.6e1 * t2616 * t8009 + 0.6e1 * t8004 * t2619 - 0.2e1 * t7936 * t2624 + 0.6e1 * t7939 * t2624 - 0.2e1 * t8014 * t2624 - 0.2e1 * t2629 * t6942 + 0.6e1 * t7939 * t2632 - 0.3e1 * t7979 * t7204 - t7880 * t7925 + 0.12e2 * t7893 * t7953 + 0.6e1 * t7893 * t7990 - 0.7e1 * t7907 * t7925 - 0.11e2 * t7907 * t7975 - 0.18e2 * t7907 * t7990 + t7973 * t7925 - 0.12e2 * t8025 * t7928 + 0.6e1 * t7973 * t7990;
  t8056 = t2074 * t562;
  t8057 = t548 * t8056;
  t8060 = t1497 * t8008;
  t8068 = t228 * t3280 * t558;
  t8075 = -0.2e1 * t2612 * t6942 - 0.6e1 * t7838 * t1497 * t2591 - 0.4e1 * t2629 * t7026 - 0.6e1 * t7873 * t4510 * t7903 - 0.6e1 * t8014 * t2632 - 0.6e1 * t2629 * t6949 - 0.4e1 * t8014 * t2635 + 0.6e1 * t538 * t675 * t224 * t543 * t2640 + 0.6e1 * t8004 * t2643 + 0.6e1 * t2638 * t8057 + 0.6e1 * t2616 * t8060 + 0.6e1 * t7810 * t2384 + 0.6e1 * t7817 * t2384 - 0.3e1 * t2612 * t8068 + 0.3e1 * t2607 * t8068 - 0.18e2 * t8025 * t7904 + t6936 - t6939 - t828;
  t8103 = t4475 * t7858;
  t8120 = -t6993 - 0.3e1 * t1787 * t6313 - 0.2e1 * t2085 * t1428 * t884 * t558 - t776 * t7124 - t7281 * t2664 + t7099 * t4536 * t5491 * t297 + t6238 * t879 + 0.2e1 * t2062 * t2372 + t765 * t7106 - 0.2e1 * t2333 * t1441 * t1775 * t769 + 0.3e1 * t882 * t4475 * t1797 + 0.6e1 * t6216 * t4602 * t884 * t539 + 0.3e1 * t538 * t1816 * t8103 + 0.11e2 * t5377 * t4528 * t761 * t539 + 0.6e1 * t7271 * t4561 * t2663 - t6285 * t879 - 0.2e1 * t2105 * t2372 - t776 * t7106 - t6285 * t889 - 0.2e1 * t2105 * t2411;
  t8123 = t1441 * t5439 * t297;
  t8128 = t2067 * t222;
  t8129 = t1423 * t8128;
  t8136 = -0.6e1 * t1787 * t8129 - 0.4e1 * t2085 * t7148 - 0.2e1 * t2333 * t8123 - 0.6e1 * t5411 * t2652 - 0.4e1 * t6196 * t2656 - t7035 - t7047 + t7050 + t7079 - t7080 + t7082 - t7083 + t7095 + t7166 - t7167 - t7178 + t7183 - t7185 + t7223 + t7226;
  t8157 = 0.4e1 * t2641 + 0.4e1 * t2649 - t7239 + t7241 - t7242 - t7249 + t7275 - t7278 + t7285 - t7287 - t7290 + t5484 * t762 + 0.2e1 * t1793 * t2068 + t684 * t6391 - t220 * t2090 * t265 * t564 - 0.2e1 * t220 * t769 * t675 * t564 - t220 * t297 * t1844 * t564 + t6238 * t885 + 0.2e1 * t2062 * t2350 + t765 * t7258;
  t8161 = my_piecewise5(t104, 0, t105, 0, t7851 + t7920 + t7982 + t8030 + t8075 + t8120 + t8136 + t8157);
  t8168 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t894 + t7754 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t2672 - t7732 + t7761 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * (0.1e3 / 0.243e3 * t2311 - 0.25e2 / 0.81e2 * t2314 + 0.5e1 / 0.54e2 * t38 * t98 * t1863 - 0.44e3 / 0.729e3 * t38 * t524 * t300 + 0.8e2 / 0.243e3 * t38 * t210 * t780 - 0.5e1 / 0.81e2 * t38 * t93 * t2149 + t532 * t892 + 0.2e1 * t218 * t2670 + t103 * t8161));
  tv4rho2sigmalapl17 = t8 * t8168 + 0.2e1 * t2677;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t8175 = t7 * t327 * t917;
  t8182 = t7 * t336 * t917 / 0.3e2;
  t8184 = t7 * t135 * t2763;
  t8202 = t7580 * t153;
  t8206 = t6453 * t7685;
  t8209 = t159 * t8202;
  t8218 = t2716 * t1019;
  t8219 = t1042 * t8218;
  t8227 = t2690 * t364;
  t8228 = t151 * t8227;
  t8229 = t1896 * t155;
  t8235 = t905 * t1019;
  t8236 = t359 * t8235;
  t8239 = -0.4e1 * t2694 + t6438 + t6439 - t6440 - 0.3e1 * t2718 * t6558 - 0.8e1 * t2503 * t1113 * t1048 * t718 * t153 + 0.12e2 * t2503 * t1113 * t8202 - 0.12e2 * t2503 * t8206 - 0.12e2 * t2486 * t8209 - 0.3e1 * t2718 * t6551 + 0.18e2 * t7386 * t1113 * t2716 * params->csk_a - 0.12e2 * t8219 * t1113 * t7392 + 0.12e2 * t4800 * t369 * t2690 * t718 + 0.12e2 * t8228 * t159 * t8229 + 0.3e1 * t2713 * t6555 + 0.18e2 * t8236 * t6456;
  t8240 = t1042 * t8235;
  t8243 = t151 * t8235;
  t8250 = t159 * t718;
  t8251 = t4781 * t8250;
  t8263 = t359 * t8218;
  t8273 = 0.12e2 * t2503 * t369 * t8202 - 0.18e2 * t8219 * t369 * t7392 - 0.18e2 * t8243 * t1662 + 0.12e2 * t2481 * t8206 + 0.12e2 * t2481 * t8209 + 0.12e2 * t2481 * t8251 - 0.4e1 * t2486 * t8251 - 0.4e1 * t2503 * t8251 + 0.18e2 * t8236 * t6473 - 0.6e1 * t8240 * t6473 - 0.6e1 * t8243 * t6473 + 0.18e2 * t8240 * t6488 + 0.18e2 * t8263 * t6510 + t6468 - t6471 - t801 - t909;
  t8275 = t902 * t3624;
  t8276 = t3640 * t8275;
  t8280 = t1065 * t1909 * t718;
  t8283 = t3644 * t902;
  t8285 = t3688 * t8283 * params->csk_a;
  t8290 = t368 * t902;
  t8295 = t359 * t8275;
  t8307 = t3660 * t8290 * t1048;
  t8313 = t374 * t375 * t1959;
  t8320 = -0.12e2 * t4901 * t1044 * t710 * t718 + 0.7e1 * t7647 * t3660 * t8290 * params->csk_a - 0.4e1 * t2191 * t8280 - t2705 * t3530 - 0.3e1 * t2705 * t3599 + 0.3e1 * t2708 * t3530 + 0.3e1 * t2708 * t3575 + 0.3e1 * t2730 * t6749 - t2735 * t3530 + 0.3e1 * t2735 * t3537 - 0.11e2 * t8295 * t6583 - 0.6e1 * t6601 * t8285 + 0.7e1 * t6601 * t8307 - 0.6e1 * t8276 * t6673 + 0.2e1 * t714 * t8313 - t6490;
  t8330 = t3680 * t2701 * t1048;
  t8342 = t3688 * t8283 * t1048;
  t8346 = t3680 * t2701 * params->csk_a;
  t8352 = t1065 * t2701 * t383;
  t8366 = t902 * t360;
  t8370 = 0.3e1 * t2754 * t3581 + 0.3e1 * t2735 * t3571 - 0.2e1 * t725 * t8313 - 0.3e1 * t2735 * t3575 + 0.18e2 * t6601 * t8330 - 0.12e2 * t8276 * t6615 - 0.2e1 * t725 * t391 * t392 * t1959 - 0.2e1 * t2735 * t3587 + 0.11e2 * t6601 * t8342 - 0.12e2 * t6814 * t8346 - 0.11e2 * t8295 * t6568 - 0.6e1 * t6678 * t8352 - 0.12e2 * t906 * t1020 * t6706 - 0.8e1 * t1913 * t1020 * t2692 * t153 + 0.3e1 * t2708 * t3599 - 0.7e1 * t8276 * t6624 + 0.3e1 * t151 * t8366 * t4837;
  t8373 = t151 * t8275;
  t8376 = t1042 * t8275;
  t8397 = t902 * t3615;
  t8398 = t359 * t8397;
  t8407 = 0.11e2 * t8373 * t6568 - 0.18e2 * t8295 * t6575 + 0.6e1 * t8373 * t6575 + 0.6e1 * t8376 * t6575 - 0.3e1 * t8398 * t6580 - 0.6e1 * t8376 * t6594 - 0.6e1 * t6601 * t8346 + 0.12e2 * t8376 * t6615 - 0.7e1 * t8295 * t6624 + 0.18e2 * t8376 * t6624 - 0.18e2 * t8376 * t6628 - t8276 * t6712 - 0.7e1 * t8295 * t6712 + t8373 * t6712 + 0.6e1 * t8376 * t6712 - 0.3e1 * t8398 * t6729;
  t8410 = t359 * t8227;
  t8414 = -0.12e2 * t8410 * t2218 * t8250 - 0.18e2 * t911 * t6597 + t6564 - t6620 - t6633 - t6634 + t6644 - t6651 + t6659 - t6661 + t6704 + t6709 + t6721 - t6722 + t6724 + t6734 - t6735;
  t8422 = t718 * t718;
  t8423 = t151 * t8422;
  t8436 = 0.12e2 * t1968 * t2471 * t7570 + 0.2e1 * t359 * t8422 * t370 - 0.12e2 * t8410 * t4923 * t8229 - 0.2e1 * t8423 * t385 + 0.2e1 * t8423 * t387 + 0.4e1 * t2714 - 0.4e1 * t2719 - 0.4e1 * t2721 + 0.4e1 * t2731 + 0.4e1 * t2755 + t6769 - t6770 - t6772 - t6778 + t6802 - t6804 - t6807;
  t8438 = t3688 * t8283;
  t8442 = t3660 * t8290;
  t8447 = t158 * t1959;
  t8456 = t151 * t8397;
  t8462 = t3680 * t2701;
  t8467 = t8422 * t362;
  t8471 = t359 * t8467;
  t8476 = t6818 - t6821 - t6798 * t2702 + t6601 * t8438 - 0.2e1 * t2705 * t6822 + 0.11e2 * t7647 * t8442 - 0.3e1 * t2708 * t3751 - 0.2e1 * t2691 * t2203 * t8447 + 0.2e1 * t714 * t374 * t8447 + 0.2e1 * t725 * t5914 + 0.3e1 * t8456 * t6780 + 0.3e1 * t359 * t8366 * t3617 + 0.6e1 * t6814 * t8462 + 0.6e1 * t8373 * t6783 + 0.2e1 * t151 * t8467 * t376 - 0.2e1 * t8471 * t376 - 0.2e1 * t8471 * t393;
  t8480 = my_piecewise5(t58, 0, t61, 0, t8239 + t8273 + t8320 + t8370 + t8407 + t8414 + t8436 + t8476);
  t8487 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t917 + t8175 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t2763 - t8182 + t8184 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.2e3 / 0.243e3 * t2449 - 0.5e2 / 0.81e2 * t2452 + 0.5e1 / 0.27e2 * t38 * t48 * t1984 + t353 * t915 + 0.2e1 * t149 * t2761 + t53 * t8480));
  tv4rho2lapl20 = t8 * t8487 + 0.2e1 * t2768;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t8494 = t7 * t420 * t940;
  t8498 = t7 * t424 * t940 / 0.3e2;
  t8500 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t940 + t8494 / 0.5e1 - t8498);
  tv4rho2lapl22 = t8 * t8500 + 0.2e1 * t2777;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t8506 = t7 * t445 * t917;
  t8514 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t917 + t8506 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t2763 + t8175 / 0.1e2 - t8182 + t8184 / 0.1e2);
  tv4rho2lapl23 = t8 * t8514 + t2768 + t2783;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t8520 = t7 * t469 * t940;
  t8527 = t7 * t180 * t2866;
  t8530 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t940 + t8520 / 0.1e2 + t8494 / 0.1e2 - t8498 + 0.3e1 / 0.2e2 * t7 * t176 * t2866 + t8527 / 0.1e2);
  tv4rho2lapl25 = t8 * t8530 + t2777 + t2871;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t8538 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t917 + t8506 / 0.5e1 - t8182);
  tv4rho2lapl26 = t8 * t8538 + 0.2e1 * t2783;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t8558 = t228 * t8008;
  t8561 = t928 * t1422;
  t8562 = t1417 * t8561;
  t8565 = t220 * t8561;
  t8568 = t538 * t8561;
  t8578 = t1048 * t769 * t222;
  t8588 = t2819 * t1422;
  t8589 = t1417 * t8588;
  t8595 = 0.18e2 * t7838 * t1497 * t2819 * params->csk_a - 0.8e1 * t2629 * t1497 * t8578 - 0.12e2 * t8589 * t1497 * t7844 - 0.18e2 * t8565 * t1852 + 0.12e2 * t2607 * t8558 - 0.12e2 * t2612 * t8558 - 0.3e1 * t2821 * t7003 - 0.3e1 * t2821 * t7006 + 0.12e2 * t6094 * t8057 + 0.18e2 * t8562 * t6109 - 0.6e1 * t8565 * t6972 + 0.18e2 * t8568 * t6972 - 0.4e1 * t2806 + t6915 + t6916 - t6917;
  t8598 = t2802 * t543;
  t8599 = t220 * t8598;
  t8600 = t2074 * t224;
  t8604 = t1048 * t545;
  t8605 = t8604 * t8128;
  t8617 = t228 * t8578;
  t8622 = t538 * t8588;
  t8631 = 0.12e2 * t8599 * t228 * t8600 - 0.18e2 * t8589 * t548 * t7844 + 0.12e2 * t2607 * t8605 + 0.12e2 * t2607 * t8617 - 0.4e1 * t2612 * t8617 + 0.12e2 * t2629 * t8009 + 0.12e2 * t2629 * t8060 - 0.12e2 * t2629 * t8605 - 0.4e1 * t2629 * t8617 + 0.3e1 * t2816 * t6999 + 0.18e2 * t8622 * t6957 - 0.6e1 * t8562 * t6972 + 0.18e2 * t8568 * t6986 + t6936 - t6939 - t828 - t932;
  t8633 = t925 * t4479;
  t8634 = t538 * t8633;
  t8638 = t1441 * t2071 * t769;
  t8644 = t553 * t554 * t2090;
  t8655 = t4509 * t925;
  t8657 = t4536 * t8655 * t1048;
  t8660 = t4505 * t8633;
  t8666 = t4536 * t8655 * params->csk_a;
  t8672 = t4561 * t2799 * t1048;
  t8679 = -0.2e1 * t776 * t570 * t571 * t2090 - 0.4e1 * t2333 * t8638 - 0.3e1 * t2794 * t4442 + 0.3e1 * t2811 * t4453 + 0.3e1 * t2828 * t4449 - 0.3e1 * t2828 * t4453 - 0.2e1 * t2828 * t4464 + 0.3e1 * t2839 * t4381 - 0.11e2 * t8634 * t7038 - 0.12e2 * t8660 * t7087 + 0.11e2 * t7099 * t8657 - 0.6e1 * t7099 * t8666 + 0.18e2 * t7099 * t8672 - 0.6e1 * t8660 * t7134 + 0.2e1 * t765 * t8644 - t6993;
  t8680 = t547 * t925;
  t8700 = t4561 * t2799 * params->csk_a;
  t8707 = t1417 * t8633;
  t8713 = t1441 * t2799 * t562;
  t8722 = 0.7e1 * t7264 * t4528 * t8680 * params->csk_a + 0.3e1 * t2811 * t4442 + 0.3e1 * t2828 * t4427 - t2794 * t4432 + 0.3e1 * t2811 * t4432 - t2828 * t4432 - 0.7e1 * t8660 * t7042 + 0.7e1 * t8660 * t7038 - 0.11e2 * t8634 * t7053 - 0.12e2 * t7271 * t8700 + 0.3e1 * t2850 * t7187 - 0.2e1 * t776 * t8644 + 0.18e2 * t8707 * t7042 - 0.12e2 * t2118 * t8129 - 0.6e1 * t7139 * t8713 - 0.8e1 * t2085 * t1428 * t2804 * t222 - 0.18e2 * t934 * t7159;
  t8727 = t925 * t539;
  t8731 = t220 * t8633;
  t8734 = t925 * t4474;
  t8735 = t538 * t8734;
  t8760 = 0.3e1 * t220 * t8727 * t5370 - 0.12e2 * t2850 * t7960 - 0.7e1 * t8634 * t7042 + 0.11e2 * t8731 * t7053 - 0.18e2 * t8707 * t7061 - 0.7e1 * t8634 * t7068 - t8660 * t7068 + 0.6e1 * t8707 * t7068 + t8731 * t7068 + 0.12e2 * t8707 * t7087 - 0.6e1 * t7099 * t8700 - 0.18e2 * t8634 * t7152 + 0.6e1 * t8707 * t7152 + 0.6e1 * t8731 * t7152 - 0.3e1 * t8735 * t7204 - 0.3e1 * t8735 * t7211;
  t8763 = t538 * t8598;
  t8764 = t228 * t769;
  t8768 = -0.12e2 * t8763 * t2367 * t8764 - 0.6e1 * t8707 * t7155 - t7035 - t7047 + t7050 + t7079 - t7080 + t7082 - t7083 + t7095 + t7166 - t7167 - t7178 + t7183 - t7185 + t7223 + t7226;
  t8776 = t769 * t769;
  t8780 = t220 * t8776;
  t8790 = 0.12e2 * t2100 * t2597 * t8056 - 0.12e2 * t8763 * t5366 * t8600 + 0.2e1 * t538 * t8776 * t549 - 0.2e1 * t8780 * t564 + 0.2e1 * t8780 * t566 + 0.4e1 * t2817 - 0.4e1 * t2822 - 0.4e1 * t2824 + 0.4e1 * t2840 + 0.4e1 * t2851 - t7239 + t7241 - t7242 - t7249 + t7275 - t7278 + t7285;
  t8791 = t227 * t2090;
  t8802 = t4536 * t8655;
  t8809 = t220 * t8734;
  t8818 = t4561 * t2799;
  t8821 = t8776 * t541;
  t8822 = t538 * t8821;
  t8830 = -t7287 - t7290 + 0.2e1 * t765 * t553 * t8791 - 0.3e1 * t2811 * t4612 - 0.2e1 * t2794 * t7261 + 0.2e1 * t776 * t6391 - t7281 * t2800 + t7099 * t8802 - 0.2e1 * t2803 * t2345 * t8791 + 0.6e1 * t8731 * t7300 + 0.3e1 * t8809 * t7245 + 0.3e1 * t538 * t8727 * t4487 + 0.11e2 * t8634 * t4528 * t7059 + 0.6e1 * t7271 * t8818 - 0.2e1 * t8822 * t555 + 0.2e1 * t220 * t8821 * t555 - 0.2e1 * t8822 * t572;
  t8834 = my_piecewise5(t104, 0, t105, 0, t8595 + t8631 + t8679 + t8722 + t8760 + t8768 + t8790 + t8830);
  t8841 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t940 + t8520 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t2866 - t8498 + t8527 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * (0.2e3 / 0.243e3 * t2575 - 0.5e2 / 0.81e2 * t2578 + 0.5e1 / 0.27e2 * t38 * t98 * t2149 + t532 * t938 + 0.2e1 * t218 * t2864 + t103 * t8834));
  tv4rho2lapl28 = t8 * t8841 + 0.2e1 * t2871;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t8848 = t7 * t135 * t2944 / 0.1e2;
  t8856 = 0.6e1 * t2883;
  t8857 = t6561 * t1019;
  t8858 = t359 * t8857;
  t8859 = t8858 * t2483;
  t8863 = t2210 * t3519;
  t8866 = t1042 * t8857;
  t8867 = t8866 * t2508;
  t8870 = t151 * t8857 * t2483;
  t8872 = t799 * params->csk_a;
  t8873 = t8872 * t153;
  t8875 = t2490 * t1113 * t8873;
  t8877 = 0.18e2 * t359 * t2899 * t1019 * t8863 + t2179 + t2197 - t2200 - t2206 + t2891 + t2898 + t2902 + t2906 - t8856 + 0.9e1 * t8859 - 0.9e1 * t8867 - 0.9e1 * t8870 + 0.9e1 * t8875;
  t8878 = t2876 * t362;
  t8879 = t8878 * t1019;
  t8880 = t1042 * t8879;
  t8881 = t1113 * t2211;
  t8884 = t359 * t8879;
  t8885 = t1048 * t383;
  t8886 = t8885 * t153;
  t8887 = t369 * t8886;
  t8890 = t2881 * t383;
  t8892 = t4800 * t369 * t8890;
  t8894 = t151 * t8890;
  t8895 = t8894 * t2227;
  t8899 = t1113 * t8886;
  t8902 = params->csk_a * t383;
  t8904 = t159 * t8902 * t612;
  t8907 = t151 * t8879;
  t8910 = t369 * t2211;
  t8913 = t1048 * t799;
  t8914 = t8913 * t153;
  t8915 = t159 * t8914;
  t8916 = t4761 * t8915;
  t8918 = t4725 * t8915;
  t8920 = t8866 * t2498;
  t8922 = t159 * t8886;
  t8927 = 0.9e1 * t2209 * t8904 - 0.18e2 * t8907 * t2212 + 0.18e2 * t8880 * t8881 - 0.18e2 * t8880 * t8887 - 0.12e2 * t8880 * t8899 + 0.18e2 * t8880 * t8910 + 0.18e2 * t8884 * t8887 + 0.18e2 * t8884 * t8922 - 0.6e1 * t8907 * t8922 + 0.9e1 * t8892 + 0.9e1 * t8895 - 0.3e1 * t8916 + 0.9e1 * t8918 - 0.3e1 * t8920;
  t8930 = t2490 * t369 * t8873;
  t8932 = t8858 * t2508;
  t8936 = params->csk_a * t155;
  t8937 = t8936 * t2230;
  t8940 = t8866 * t2505;
  t8942 = t8936 * t612;
  t8943 = t369 * t8942;
  t8946 = t2876 * t3624;
  t8947 = t1042 * t8946;
  t8948 = t3672 * t2249;
  t8951 = t3640 * t8946;
  t8953 = t151 * t8946;
  t8954 = t3768 * t2239;
  t8957 = t359 * t8946;
  t8960 = t3672 * t2255;
  t8964 = t3680 * t4848 * t153;
  t8967 = -0.9e1 * t2217 * t8937 - 0.9e1 * t2217 * t8943 - 0.6e1 * t8880 * t8922 + 0.6e1 * t8947 * t8948 + 0.18e2 * t8947 * t8960 + 0.12e2 * t8947 * t8964 - t8951 * t8948 + 0.6e1 * t8953 * t8954 - 0.18e2 * t8957 * t8954 - t801 - t803 + 0.9e1 * t8930 + 0.9e1 * t8932 - 0.6e1 * t8940;
  t8970 = t3680 * t2272;
  t8973 = t3660 * t623;
  t8976 = t368 * t2876;
  t8983 = t2191 * t1065 * t1571 * t799;
  t8987 = t153 * t3624;
  t8988 = t3640 * t8987;
  t8989 = t3644 * t2876;
  t8995 = t1044 * t1596 * t612;
  t9000 = t3680 * t1067 * t2876 * t1048;
  t9006 = t1065 * t1068 * t612;
  t9014 = t3688 * t3693 * t153;
  t9018 = t1020 * t375 * t612;
  t9021 = t359 * t8987;
  t9023 = t3660 * t8976 * params->csk_a;
  t9026 = -0.18e2 * t601 * t1044 * t8976 * t383 + 0.11e2 * t8988 * t3688 * t8989 * t1048 - 0.6e1 * t8988 * t3688 * t8989 * params->csk_a + 0.9e1 * t2172 * t8995 - 0.9e1 * t2180 * t9018 + 0.9e1 * t2235 * t4982 - 0.6e1 * t2235 * t9006 - 0.18e2 * t8947 * t8973 - 0.12e2 * t8951 * t8964 - 0.6e1 * t8951 * t8970 - 0.6e1 * t8951 * t9014 - 0.7e1 * t8957 * t8960 + 0.18e2 * t8988 * t9000 + 0.7e1 * t9021 * t9023 - 0.3e1 * t8983;
  t9030 = t3660 * t1596 * t153;
  t9038 = t2246 * t2231;
  t9040 = t1060 * t2230;
  t9047 = t1585 * t2925;
  t9055 = t1042 * t8878;
  t9056 = t1067 * t153;
  t9061 = t2246 * t2260;
  t9063 = -0.6e1 * t9055 * t1065 * t9056 * t383 + 0.9e1 * t2172 * t9018 + 0.9e1 * t2172 * t9040 - 0.3e1 * t2180 * t9040 + 0.9e1 * t2235 * t4880 - 0.9e1 * t2235 * t8995 - 0.3e1 * t2235 * t9040 + 0.9e1 * t2267 * t4898 + t8953 * t8948 - 0.7e1 * t8957 * t8948 - 0.11e2 * t8957 * t9030 - 0.3e1 * t9038 + 0.3e1 * t9047 - 0.3e1 * t9061;
  t9065 = t374 * t1030 * t612;
  t9072 = t3731 * t2249;
  t9075 = t2876 * t3615;
  t9076 = t359 * t9075;
  t9082 = t1020 * t3745 * t153;
  t9089 = t1595 * t1044 * t2195 * t153;
  t9093 = t6631 * t2528;
  t9095 = t2876 * t153;
  t9101 = t3680 * t2263;
  t9104 = 0.3e1 * t151 * t9095 * t4837 + 0.9e1 * t2225 * t9065 - 0.12e2 * t2900 * t9082 - 0.3e1 * t9076 * t608 - 0.3e1 * t9076 * t624 + 0.6e1 * t8947 * t8954 - 0.12e2 * t8947 * t8970 - 0.6e1 * t8947 * t9101 - 0.7e1 * t8951 * t8960 + 0.7e1 * t8951 * t9030 + 0.11e2 * t8953 * t9072 - 0.11e2 * t8957 * t9072 - 0.9e1 * t9089 - 0.6e1 * t9093;
  t9106 = t359 * t8890;
  t9107 = t9106 * t2468;
  t9109 = t8894 * t2468;
  t9111 = t9106 * t2477;
  t9113 = -0.9e1 * t9107 + 0.9e1 * t9109 - 0.9e1 * t9111 + t2213 - t2220 - t2223 + t2927 - t2929 - t2932 + t2935 - t2937 - t2939 + t2228 + t2245;
  t9116 = t151 * t799 * t612 * t385;
  t9118 = t3768 * t618;
  t9130 = t1607 * t2196;
  t9136 = t2178 * t2185;
  t9138 = t1020 * t2184;
  t9146 = 0.3e1 * t151 * t9075 * t619 + 0.3e1 * t359 * t9095 * t3617 + 0.11e2 * t9021 * t3660 * t8976 + 0.6e1 * t8947 * t3680 * t9056 + t8988 * t3688 * t8989 - 0.9e1 * t2172 * t5035 - 0.6e1 * t2180 * t9138 - 0.3e1 * t2235 * t5055 + 0.6e1 * t8953 * t9118 - t2247 + t2270 - t2280 - 0.3e1 * t9116 + 0.3e1 * t9130 + 0.3e1 * t9136;
  t9150 = my_piecewise5(t58, 0, t61, 0, t8877 + t8927 + t8967 + t9026 + t9063 + t9104 + t9113 + t9146);
  t9157 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t2944 + t8848 + 0.3e1 / 0.2e2 * t7 * t32 * (0.4e2 / 0.81e2 * t38 * t141 * t809 - 0.5e1 / 0.27e2 * t38 * t43 * t2283 + t149 * t2942 + t53 * t9150));
  tv4rhosigma30 = t8 * t9157 + t2948;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t9164 = t7 * t180 * t3020 / 0.1e2;
  t9166 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t3020 + t9164);
  tv4rhosigma39 = t8 * t9166 + t3024;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t9172 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t2944 + t8848);
  tv4rhosigma310 = t8 * t9172 + t2948;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t9184 = 0.6e1 * t2971;
  t9185 = params->csk_a * t826;
  t9186 = t9185 * t222;
  t9187 = t228 * t9186;
  t9188 = t5294 * t9187;
  t9190 = t2952 * t541;
  t9191 = t9190 * t1422;
  t9192 = t220 * t9191;
  t9195 = t7032 * t1422;
  t9196 = t1417 * t9195;
  t9197 = t9196 * t2632;
  t9201 = t2356 * t4391;
  t9204 = t538 * t9195;
  t9205 = t9204 * t2609;
  t9207 = 0.18e2 * t538 * t2973 * t1422 * t9201 - 0.18e2 * t9192 * t2364 + t2329 + t2339 - t2342 - t2349 + t2963 + t2976 + t2980 + t2982 - t9184 - 0.9e1 * t9188 - 0.9e1 * t9197 + 0.9e1 * t9205;
  t9208 = t2340 * t562;
  t9210 = t2638 * t548 * t9208;
  t9213 = t2616 * t1497 * t9186;
  t9215 = t1417 * t9191;
  t9216 = t1497 * t2363;
  t9219 = t2969 * t562;
  t9220 = t220 * t9219;
  t9221 = t9220 * t2384;
  t9223 = params->csk_a * t562;
  t9225 = t228 * t9223 * t675;
  t9228 = t538 * t9191;
  t9229 = t1048 * t562;
  t9230 = t9229 * t222;
  t9231 = t548 * t9230;
  t9234 = t6940 * t6096;
  t9237 = t9196 * t2635;
  t9239 = params->csk_a * t224;
  t9240 = t9239 * t675;
  t9241 = t548 * t9240;
  t9246 = t1497 * t9230;
  t9249 = t9196 * t2624;
  t9252 = t2616 * t548 * t9186;
  t9254 = t9204 * t2632;
  t9256 = -0.9e1 * t2355 * t9241 + 0.9e1 * t2362 * t9225 + 0.18e2 * t9215 * t9216 - 0.18e2 * t9215 * t9231 - 0.6e1 * t9215 * t9234 - 0.12e2 * t9215 * t9246 + 0.18e2 * t9228 * t9231 + 0.9e1 * t9210 + 0.9e1 * t9213 + 0.9e1 * t9221 - 0.6e1 * t9237 - 0.3e1 * t9249 + 0.9e1 * t9252 + 0.9e1 * t9254;
  t9261 = t1048 * t826;
  t9262 = t9261 * t222;
  t9263 = t228 * t9262;
  t9264 = t5294 * t9263;
  t9266 = t5259 * t9263;
  t9272 = t228 * t675;
  t9273 = t9239 * t9272;
  t9276 = t2952 * t4479;
  t9277 = t538 * t9276;
  t9279 = t4481 * params->csk_a * t2400;
  t9282 = t4505 * t9276;
  t9283 = t4561 * t2423;
  t9286 = t1417 * t9276;
  t9287 = t4528 * t686;
  t9290 = t4580 * t2400;
  t9296 = t220 * t9276;
  t9298 = t4602 * t2391;
  t9301 = 0.18e2 * t9215 * t548 * t2363 - 0.9e1 * t2355 * t9273 - 0.6e1 * t9192 * t9234 + 0.18e2 * t9228 * t9234 - 0.11e2 * t9277 * t9279 - 0.7e1 * t9277 * t9290 - 0.6e1 * t9282 * t9283 - t9282 * t9290 - 0.18e2 * t9286 * t9287 + 0.6e1 * t9286 * t9290 + t9296 * t9290 + 0.6e1 * t9296 * t9298 - 0.3e1 * t9264 + 0.9e1 * t9266;
  t9304 = t4580 * t2631;
  t9308 = t4561 * t5383 * t222;
  t9313 = t1417 * t9190;
  t9314 = t1443 * t222;
  t9319 = t222 * t4479;
  t9320 = t4505 * t9319;
  t9321 = t4509 * t2952;
  t9327 = t4536 * t4590 * t222;
  t9332 = t2333 * t1441 * t1775 * t826;
  t9336 = t1428 * t2371;
  t9339 = t538 * t9319;
  t9340 = t547 * t2952;
  t9342 = t4528 * t9340 * params->csk_a;
  t9345 = t4528 * t2375;
  t9348 = t548 * t675;
  t9349 = t1436 * t9348;
  t9352 = 0.11e2 * t9320 * t4536 * t9321 * t1048 - 0.6e1 * t9313 * t1441 * t9314 * t562 - 0.9e1 * t2318 * t9336 + 0.9e1 * t2387 * t5441 - 0.9e1 * t2387 * t9349 - 0.18e2 * t9277 * t9298 - 0.7e1 * t9277 * t9304 - 0.11e2 * t9277 * t9345 - 0.6e1 * t9282 * t9327 + 0.18e2 * t9286 * t9304 + 0.12e2 * t9286 * t9308 + 0.7e1 * t9339 * t9342 - t828 - t830 - 0.3e1 * t9332;
  t9357 = t4561 * t1443 * t2952 * t1048;
  t9363 = t1441 * t1444 * t675;
  t9368 = t1756 * t3001;
  t9370 = t2380 * t2411;
  t9373 = t553 * t1411 * t675;
  t9388 = t2952 * t4474;
  t9389 = t538 * t9388;
  t9392 = t7045 * t2656;
  t9396 = -0.18e2 * t664 * t1423 * t9340 * t562 - 0.6e1 * t9320 * t4536 * t9321 * params->csk_a + 0.9e1 * t2322 * t9349 + 0.9e1 * t2382 * t9373 + 0.9e1 * t2387 * t5402 - 0.6e1 * t2387 * t9363 + 0.9e1 * t2418 * t5451 - 0.3e1 * t9389 * t671 - 0.12e2 * t9282 * t9308 + 0.6e1 * t9286 * t9298 + 0.18e2 * t9320 * t9357 + 0.3e1 * t9368 - 0.3e1 * t9370 - 0.6e1 * t9392;
  t9398 = t1428 * t4518 * t222;
  t9405 = t4561 * t2414;
  t9410 = t1787 * t1423 * t2337 * t222;
  t9414 = t2952 * t222;
  t9421 = t1428 * t1429 * t675;
  t9424 = t2380 * t2372;
  t9431 = t4528 * t9340 * t1048;
  t9436 = 0.3e1 * t220 * t9414 * t5370 - 0.3e1 * t2318 * t9421 + 0.9e1 * t2322 * t9336 + 0.9e1 * t2322 * t9421 - 0.3e1 * t2387 * t9421 - 0.12e2 * t2974 * t9398 - 0.3e1 * t9389 * t687 + 0.11e2 * t9296 * t9279 - 0.7e1 * t9282 * t9304 - 0.12e2 * t9286 * t9283 - 0.6e1 * t9286 * t9405 + 0.7e1 * t9320 * t9431 - 0.9e1 * t9410 - 0.3e1 * t9424;
  t9438 = t1793 * t2338;
  t9442 = t220 * t826 * t675 * t564;
  t9448 = t1428 * t2346;
  t9456 = t2328 * t2350;
  t9458 = t9220 * t2594;
  t9460 = t538 * t9219;
  t9461 = t9460 * t2594;
  t9463 = t9460 * t2603;
  t9465 = 0.11e2 * t9339 * t4528 * t9340 + t9320 * t4536 * t9321 - 0.6e1 * t2318 * t9448 - 0.9e1 * t2322 * t5557 - 0.3e1 * t2387 * t5584 - t2358 + t2365 - t2369 + 0.3e1 * t9438 - 0.3e1 * t9442 + 0.3e1 * t9456 + 0.9e1 * t9458 - 0.9e1 * t9461 - 0.9e1 * t9463;
  t9472 = t4602 * t681;
  t9478 = 0.3e1 * t220 * t9388 * t682 + 0.3e1 * t538 * t9414 * t4487 + 0.6e1 * t9286 * t4561 * t9314 + 0.6e1 * t9296 * t9472 - t2381 + t2385 + t2397 - t2398 + t2421 + t3003 - t3005 - t3008 + t3011 - t3013 - t3015;
  t9482 = my_piecewise5(t104, 0, t105, 0, t9207 + t9256 + t9301 + t9352 + t9396 + t9436 + t9465 + t9478);
  t9489 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t3020 + t9164 + 0.3e1 / 0.2e2 * t7 * t88 * (0.4e2 / 0.81e2 * t38 * t210 * t836 - 0.5e1 / 0.27e2 * t38 * t93 * t2429 + t218 * t3018 + t103 * t9482));
  tv4rhosigma319 = t8 * t9489 + t3024;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t9496 = t7 * t135 * t3104 / 0.1e2;
  t9509 = t159 * t8873;
  t9510 = t2486 * t9509;
  t9512 = t3053 * t153;
  t9513 = t159 * t9512;
  t9520 = t375 * t792;
  t9521 = t374 * t9520;
  t9525 = t359 * t3048 * t3615;
  t9528 = 0.3e1 * t151 * t721 * t3615 * t9521 - 0.3e1 * t9525 * t608 - 0.11e2 * t7430 * t9513 + 0.11e2 * t7445 * t9513 + t2179 + t2197 - t2200 - t2459 - t2462 - t2469 + t2474 - t2478 - 0.4e1 * t2883 + t3035 + t3036 + t3046 + t3047 - t3209 - t855 - 0.3e1 * t9510;
  t9529 = t1048 * t792;
  t9530 = t9529 * t153;
  t9537 = t151 * t3049;
  t9542 = t2481 * t9509;
  t9544 = t6565 * t3626;
  t9545 = t3640 * t9544;
  t9550 = t3671 * t792;
  t9551 = t9550 * t2255;
  t9554 = t600 * t1019;
  t9555 = t359 * t9554;
  t9559 = t718 * t792;
  t9561 = t359 * t9559 * t383;
  t9570 = t2491 * t799;
  t9571 = t1113 * t9570;
  t9572 = t6517 * t9571;
  t9575 = t2503 * t1113 * t8914;
  t9582 = t3640 * t8987 * t3626;
  t9583 = t7483 * t792;
  t9587 = t9550 * t153;
  t9591 = t369 * t9570;
  t9592 = t6517 * t9591;
  t9594 = t8913 * t2255;
  t9595 = t2503 * t9594;
  t9598 = t2496 * t369 * t612;
  t9604 = -0.11e2 * t7430 * t369 * t9530 - 0.6e1 * t7434 * t1113 * t9530 - 0.12e2 * t9537 * t9082 - 0.3e1 * t9525 * t624 + 0.3e1 * t9542 + 0.7e1 * t9545 * t369 * t7483 * t153 - 0.7e1 * t7468 * t9551 - 0.18e2 * t9555 * t369 * t3049 - 0.3e1 * t9561 * t1090 + 0.7e1 * t7430 * t369 * t9512 + 0.6e1 * t2516 * t369 * t7543 + 0.3e1 * t9572 - 0.2e1 * t9575 - 0.4e1 * t2503 * t1113 * t2496 * t612 + 0.11e2 * t9582 * t3645 * t9583 - 0.6e1 * t7468 * t3645 * t9587 + 0.3e1 * t9592 - 0.3e1 * t9595 - 0.6e1 * t2503 * t9598 + 0.18e2 * t9582 * t1113 * t9583;
  t9607 = t9550 * t1113 * t153;
  t9610 = t2496 * t2230;
  t9619 = t159 * t6518;
  t9632 = t1042 * t9554;
  t9636 = t1042 * t9544;
  t9639 = t2198 * t383;
  t9641 = t1968 * t159 * t9639;
  t9643 = t6487 * t2518;
  t9650 = t2486 * t8915;
  t9653 = t9529 * t2249;
  t9656 = -0.6e1 * t9632 * t1113 * t3049 - 0.6e1 * t9545 * t3645 * t2492 - 0.3e1 * t9561 * t1103 + 0.6e1 * t2481 * t9598 + 0.6e1 * t2481 * t9610 + 0.6e1 * t2481 * t9619 - 0.2e1 * t2486 * t9610 - 0.6e1 * t2486 * t9619 + 0.6e1 * t2490 * t7514 + 0.6e1 * t2490 * t7558 - 0.2e1 * t2503 * t9610 + 0.6e1 * t2511 * t9065 - 0.12e2 * t9636 * t2521 + 0.3e1 * t7409 * t3055 - 0.7e1 * t7430 * t9551 - 0.18e2 * t7430 * t9653 - 0.12e2 * t7468 * t9607 + 0.3e1 * t9641 + 0.3e1 * t9643 - t9650;
  t9661 = t159 * t9587;
  t9668 = t2481 * t8915;
  t9670 = t2503 * t8915;
  t9673 = t2481 * t9594;
  t9690 = -0.18e2 * t9636 * t2493 - 0.6e1 * t9545 * t2521 + 0.12e2 * t7434 * t9607 + 0.6e1 * t8859 - 0.6e1 * t8867 - 0.6e1 * t8870 + 0.6e1 * t8875 + 0.6e1 * t8892 + 0.6e1 * t8895 - 0.2e1 * t8916 + 0.6e1 * t8918;
  t9698 = t1920 * t2925;
  t9706 = t1065 * t6655 * t281;
  t9707 = t2191 * t9706;
  t9721 = t1042 * t8987;
  t9727 = t1044 * t710 * t799;
  t9728 = t4901 * t9727;
  t9732 = t1926 * t3086;
  t9738 = -0.2e1 * t8920 + 0.6e1 * t8930 + 0.6e1 * t8932 - 0.4e1 * t8940 + t9698 + 0.3e1 * t5791 * t3071 + 0.3e1 * t5791 * t3074 - 0.3e1 * t5769 * t3074 - t9707 - 0.2e1 * t1613 * t7667 + t8988 * t3688 * t6602 * t281 + 0.3e1 * t2235 * t5778 + 0.3e1 * t2267 * t5798 - 0.6e1 * t1595 * t1044 * t710 * t612 + 0.6e1 * t9721 * t3680 * t2192 * t281 - 0.3e1 * t9728 - 0.3e1 * t5823 * t3071 - t9732 - 0.2e1 * t5823 * t3089 + 0.3e1 * t151 * t9559 * t1631;
  t9747 = t1926 * t2925;
  t9748 = t792 * t153;
  t9754 = t1913 * t1020 * t3033 * t153;
  t9780 = t1920 * t3034;
  t9781 = -0.3e1 * t2172 * t5901 - 0.2e1 * t5769 * t3042 - t5823 * t3062 - t801 - 0.2e1 * t8983 - 0.2e1 * t9038 + 0.2e1 * t9047 - 0.2e1 * t9061 - 0.6e1 * t9089 - 0.4e1 * t9093 + t9780;
  t9784 = t2246 * t1906;
  t9788 = t151 * t718 * t799 * t385;
  t9794 = t7406 * t4923 * t9639;
  t9796 = t1042 * t5677;
  t9797 = t1113 * t1048;
  t9798 = t9748 * t383;
  t9808 = t8872 * t68;
  t9809 = t618 * t383;
  t9811 = t7406 * t9808 * t9809;
  t9822 = t1060 * t362 * t2249;
  t9839 = t3038 * t383;
  t9840 = t151 * t9839;
  t9841 = t9840 * t2468;
  t9844 = t362 * params->csk_a;
  t9845 = t9844 * t153;
  t9846 = t1020 * t158 * t9845;
  t9852 = t9784 - t2235 * t5917 - t9788 + 0.6e1 * t1968 * t2471 * t2201 * t612 - 0.3e1 * t9794 - 0.12e2 * t9796 * t9797 * t9798 - 0.6e1 * t2466 * t2476 * t8942 + 0.18e2 * t9632 * t7387 * t3054 - 0.3e1 * t9811 - 0.18e2 * t9796 * t9529 * t366 * t2268 - 0.6e1 * t2466 * t4713 * t2230 - 0.6e1 * t1042 * t3049 * t9822 - 0.6e1 * t5678 * t7371 * t9798 + 0.18e2 * t6452 * t7398 * t2211 + 0.18e2 * t3050 * t9822 + 0.18e2 * t3050 * t1044 * t368 * t1048 * t362 * t153 + 0.3e1 * t9841 - 0.18e2 * t9537 * t9846 + 0.18e2 * t3050 * t9846 - 0.6e1 * t9107;
  t9859 = t3094 + t3096 + t3097 - t3098 - t3099 + t2245 - t2247 - t2280 - 0.2e1 * t9116 + 0.2e1 * t9130 + 0.2e1 * t9136;
  t9864 = my_piecewise5(t58, 0, t61, 0, -0.6e1 * t9111 + 0.6e1 * t9109 - t3087 - t3082 + t3069 + t3057 - t3059 + t9859 - t3052 + t9852 + t9781 - 0.2e1 * t9754 - t9747 + t9738 + t9690 + 0.3e1 * t9673 + 0.3e1 * t9668 - t9670 + t9656 + t9604 + t9528 - 0.4e1 * t1913 * t1020 * t856 * t612 + 0.11e2 * t9021 * t3660 * t710 * t792 + 0.6e1 * t5765 * t3768 * t3041 * t153 + 0.3e1 * t5791 * t3062 + 0.6e1 * t7434 * t9661 - t7468 * t9661 + 0.18e2 * t7434 * t9551 + 0.6e1 * t7434 * t9653 + 0.6e1 * t7445 * t9653 + t7445 * t9661 - 0.7e1 * t7430 * t9661 + 0.3e1 * t2235 * t5740 - t5769 * t3062 + t2519 + t2512 + 0.3e1 * t359 * t9748 * t7630 + 0.3e1 * t3092 * t3616 * t2249);
  t9871 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t3104 + t9496 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.25e2 / 0.162e3 * t2874 + 0.5e1 / 0.54e2 * t38 * t48 * t2283 + 0.8e2 / 0.243e3 * t38 * t141 * t864 - 0.1e2 / 0.81e2 * t38 * t43 * t2543 + t149 * t3102 + t53 * t9864));
  tv4rhosigma2lapl0 = t8 * t9871 + t3108;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t9878 = t7 * t180 * t3190 / 0.1e2;
  t9880 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t3190 + t9878);
  tv4rhosigma2lapl11 = t8 * t9880 + t3194;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t9886 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t3104 + t9496);
  tv4rhosigma2lapl12 = t8 * t9886 + t3108;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t9904 = t538 * t3132 * t4474;
  t9907 = t2612 * t9187;
  t9909 = t1048 * t819;
  t9910 = t9909 * t222;
  t9918 = -0.11e2 * t7907 * t548 * t9910 - 0.18e2 * t6970 * t2640 - 0.3e1 * t9904 * t671 - 0.3e1 * t9904 * t687 + t2329 + t2339 - t2342 - t2585 - t2588 - t2595 + t2600 - t2604 - 0.4e1 * t2971 + t3123 + t3124 + t3129 + t3131 - t3279 - t883 - 0.3e1 * t9907;
  t9919 = t2607 * t9187;
  t9924 = t7036 * t4481;
  t9925 = t1417 * t9924;
  t9928 = t4505 * t9924;
  t9933 = t3671 * t819;
  t9934 = t9933 * t2631;
  t9937 = t3137 * t222;
  t9938 = t228 * t9937;
  t9945 = t554 * t819;
  t9946 = t553 * t9945;
  t9949 = t2617 * t826;
  t9950 = t548 * t9949;
  t9951 = t6148 * t9950;
  t9953 = t9261 * t2631;
  t9954 = t2629 * t9953;
  t9956 = t2622 * t9348;
  t9960 = t4505 * t9319 * t4481;
  t9961 = t7874 * t819;
  t9966 = t9933 * t1497 * t222;
  t9976 = t9933 * t222;
  t9980 = t2617 * t675;
  t9984 = t228 * t9976;
  t9990 = 0.3e1 * t9919 - 0.6e1 * t7893 * t1497 * t9910 - 0.12e2 * t9925 * t2643 + 0.7e1 * t9928 * t548 * t7874 * t222 - 0.7e1 * t7880 * t9934 + 0.11e2 * t7973 * t9938 - 0.11e2 * t7907 * t9938 + 0.3e1 * t220 * t772 * t4474 * t9946 + 0.3e1 * t9951 - 0.3e1 * t9954 - 0.6e1 * t2629 * t9956 + 0.18e2 * t9960 * t1497 * t9961 - 0.12e2 * t7880 * t9966 - 0.4e1 * t2629 * t1497 * t2622 * t675 + 0.11e2 * t9960 * t4510 * t9961 - 0.6e1 * t7880 * t4510 * t9976 + 0.6e1 * t2616 * t1497 * t9980 + t7973 * t9984 - 0.7e1 * t7907 * t9984 + 0.6e1 * t7893 * t9984;
  t9993 = t2607 * t9953;
  t9997 = t2612 * t9263;
  t10004 = t9909 * t2400;
  t10011 = t2607 * t9263;
  t10013 = t2629 * t9263;
  t10016 = t2622 * t9272;
  t10019 = t228 * t6960;
  t10025 = t769 * t819;
  t10027 = t538 * t10025 * t562;
  t10036 = 0.6e1 * t2616 * t548 * t9980 + 0.6e1 * t7893 * t10004 - 0.18e2 * t7907 * t10004 + 0.6e1 * t7973 * t10004 - 0.2e1 * t2629 * t10016 + 0.6e1 * t2607 * t10019 - 0.6e1 * t2612 * t10019 - 0.3e1 * t10027 * t1487 - 0.18e2 * t9925 * t2619 - 0.6e1 * t9928 * t2643 + 0.6e1 * t2648 * t9373 + 0.3e1 * t6121 * t3139 - t7880 * t9984 + 0.18e2 * t7893 * t9934 + 0.12e2 * t7893 * t9966 - 0.7e1 * t7907 * t9934 + 0.3e1 * t10011 - t10013 + 0.3e1 * t9993 - t9997;
  t10038 = t2100 * t228 * t9208;
  t10040 = t6991 * t2640;
  t10044 = t819 * t222;
  t10045 = t10044 * t562;
  t10055 = t663 * t1422;
  t10056 = t1417 * t10055;
  t10066 = t1497 * t9949;
  t10067 = t6148 * t10066;
  t10071 = t2629 * t1497 * t9262;
  t10085 = 0.6e1 * t2607 * t10016 - 0.2e1 * t2612 * t10016 - 0.2e1 * t10071 - 0.6e1 * t9188 - 0.6e1 * t9197 + 0.6e1 * t9205 + 0.6e1 * t9210 + 0.6e1 * t9213 + 0.6e1 * t9221 - 0.4e1 * t9237 - 0.2e1 * t9249;
  t10093 = t1497 * t1048;
  t10100 = t2597 * t9208;
  t10101 = t2100 * t10100;
  t10103 = t7852 * t10045;
  t10109 = t6094 * t10100;
  t10114 = t6094 * t5366 * t9208;
  t10127 = t1436 * t541 * t2400;
  t10138 = t2105 * t3001;
  t10139 = 0.6e1 * t9252 + 0.6e1 * t9254 - 0.2e1 * t9264 + 0.6e1 * t9266 - 0.12e2 * t6115 * t10093 * t10045 + 0.18e2 * t6929 * t7839 * t2363 + 0.3e1 * t10101 + 0.18e2 * t6126 * t10103 - 0.6e1 * t2592 * t2602 * t9240 - 0.3e1 * t10109 - 0.18e2 * t6115 * t10103 - 0.3e1 * t10114 - 0.6e1 * t2592 * t5244 * t9272 + 0.6e1 * t2100 * t2597 * t2343 * t675 + 0.18e2 * t6929 * t7858 * t2363 + 0.18e2 * t3134 * t10127 - 0.6e1 * t1417 * t3133 * t10127 - 0.6e1 * t6135 * t7830 * t10045 + 0.3e1 * t6204 * t3163 - t10138;
  t10153 = t1423 * t761 * t826;
  t10154 = t5427 * t10153;
  t10157 = t1441 * t7179 * t297;
  t10158 = t2333 * t10157;
  t10179 = t1417 * t9319;
  t10187 = t2105 * t3167;
  t10192 = t2062 * t3001;
  t10193 = 0.6e1 * t10179 * t4561 * t2334 * t297 - 0.6e1 * t1787 * t1423 * t761 * t675 - 0.4e1 * t2085 * t1428 * t884 * t675 + t9320 * t4536 * t7100 * t297 + 0.11e2 * t9339 * t4528 * t761 * t819 + 0.3e1 * t220 * t10025 * t1819 + 0.3e1 * t2387 * t6307 + 0.3e1 * t2418 * t6323 - 0.2e1 * t6227 * t3170 - t10187 + t10192;
  t10201 = t2085 * t1428 * t3121 * t222;
  t10219 = t220 * t769 * t826 * t564;
  t10224 = t2062 * t3122;
  t10225 = t2380 * t2068;
  t10227 = 0.6e1 * t6216 * t4602 * t3115 * t222 + 0.3e1 * t538 * t10044 * t8103 + 0.3e1 * t3180 * t4475 * t2400 - 0.3e1 * t2322 * t6383 - t2387 * t6394 - 0.2e1 * t6196 * t3116 - 0.2e1 * t10201 - t10219 + t10224 + t10225 - t3136 + t3141 - t828 - 0.2e1 * t9332 + 0.2e1 * t9368 - 0.2e1 * t9370 - 0.4e1 * t9392 - 0.6e1 * t9410 - 0.2e1 * t9424 + 0.2e1 * t9438;
  t10232 = t541 * params->csk_a;
  t10233 = t10232 * t222;
  t10234 = t1428 * t227 * t10233;
  t10243 = -t3160 - t3168 + t3175 + t3179 + t3182 + t3183 - t3184 - t3185 - t2381 + t2397 - t2398;
  t10248 = my_piecewise5(t104, 0, t105, 0, t10085 + 0.3e1 * t10067 - t3143 + t9918 + t10243 + t10227 + t10193 - t10158 - 0.3e1 * t10154 + t10139 - 0.6e1 * t9461 - 0.6e1 * t9463 + 0.6e1 * t9458 + 0.2e1 * t9456 - 0.2e1 * t9442 + 0.3e1 * t10040 + t10036 + 0.3e1 * t10038 + t9990 + t2649 + t2641 + 0.18e2 * t3134 * t10234 - 0.3e1 * t6227 * t3163 - t6227 * t3155 + 0.3e1 * t6204 * t3146 - 0.3e1 * t6196 * t3146 + 0.3e1 * t2387 * t6282 - t6196 * t3155 + 0.3e1 * t6204 * t3155 - 0.2e1 * t1814 * t8123 - 0.3e1 * t10027 * t1479 + 0.6e1 * t2607 * t9956 - 0.6e1 * t9960 * t4510 * t3132 * params->csk_a - 0.18e2 * t220 * t3133 * t10234 - 0.12e2 * t6135 * t228 * t10045 + 0.7e1 * t7907 * t548 * t9937 + 0.6e1 * t2638 * t548 * t7816 - 0.6e1 * t10056 * t1497 * t3133);
  t10255 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t3190 + t9878 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.25e2 / 0.162e3 * t2950 + 0.5e1 / 0.54e2 * t38 * t98 * t2429 + 0.8e2 / 0.243e3 * t38 * t210 * t892 - 0.1e2 / 0.81e2 * t38 * t93 * t2670 + t218 * t3188 + t103 * t10248));
  tv4rhosigma2lapl23 = t8 * t10255 + t3194;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t10262 = t7 * t135 * t3260 / 0.1e2;
  t10275 = t8275 * t3626;
  t10276 = t359 * t10275;
  t10279 = t151 * t8218;
  t10284 = t3640 * t10275;
  t10285 = t7458 * t153;
  t10286 = t1113 * t10285;
  t10289 = t1042 * t10275;
  t10290 = t369 * t10285;
  t10297 = t902 * params->csk_a * t153;
  t10298 = t1113 * t10297;
  t10301 = t151 * t10275;
  t10307 = t359 * t8397 * t364;
  t10310 = t902 * t153;
  t10315 = -0.12e2 * t10279 * t159 * t605 * t153 + 0.3e1 * t151 * t10310 * t3615 * t851 - 0.12e2 * t1042 * t7481 * t10298 - 0.11e2 * t10276 * t2483 - 0.11e2 * t10276 * t2508 - 0.12e2 * t10284 * t10286 - 0.7e1 * t10284 * t10290 + 0.18e2 * t10289 * t10290 + 0.11e2 * t10301 * t2483 - 0.3e1 * t10307 * t2483 + t2179 + t2197 - t2200 - t2695 + t2890 + t2897 - 0.4e1 * t3040 - t3045 + t3207 + t3208;
  t10323 = t3671 * t153 * t2482;
  t10338 = t159 * t7581;
  t10343 = t602 * t718;
  t10344 = t6453 * t10343;
  t10348 = t902 * t1048 * t248;
  t10363 = t1657 * t718;
  t10371 = -0.3e1 * t10307 * t4734 + 0.6e1 * t10289 * t2498 - 0.6e1 * t10289 * t2505 - 0.7e1 * t10276 * t10323 - 0.6e1 * t7482 * t10298 + 0.12e2 * t10289 * t10286 - 0.7e1 * t10276 * t10290 - 0.18e2 * t10289 * t4734 + 0.6e1 * t10301 * t2498 + 0.3e1 * t2713 * t8904 - 0.6e1 * t2486 * t10338 + 0.7e1 * t10276 * t4734 - 0.6e1 * t2503 * t10344 + 0.18e2 * t9582 * t1113 * t10348 + 0.6e1 * t7406 * t369 * t7539 + 0.11e2 * t9582 * t3645 * t10348 - 0.6e1 * t10284 * t3645 * t10285 + 0.6e1 * t2481 * t10344 + 0.6e1 * t8228 * t159 * t10363 - 0.18e2 * t9555 * t369 * t2716 * t248;
  t10381 = t2496 * t718;
  t10395 = t159 * t10381;
  t10415 = -0.6e1 * t1042 * t4742 * t1113 * t10310 * t383 - 0.6e1 * t7482 * t3645 * t10297 - 0.4e1 * t2503 * t1113 * t10381 - 0.18e2 * t10276 * t2498 + 0.6e1 * t10289 * t10323 - t10284 * t10323 + t10301 * t10323 + 0.6e1 * t2481 * t10338 - 0.3e1 * t2718 * t8937 - 0.2e1 * t2486 * t10395 + 0.6e1 * t2481 * t10395 - 0.3e1 * t2718 * t8943 - 0.2e1 * t2503 * t10395 + 0.7e1 * t9582 * t369 * t10348 + 0.6e1 * t2503 * t7582 + 0.6e1 * t2503 * t7585 - 0.6e1 * t9510 + 0.6e1 * t9542 + 0.6e1 * t9572 - 0.4e1 * t9575;
  t10438 = -0.6e1 * t8410 * t4923 * t10363 - 0.3e1 * t8870 + 0.3e1 * t8875 + 0.3e1 * t8892 + 0.3e1 * t8895 - t8916 + 0.3e1 * t8918 - t8920 + 0.3e1 * t8930 + 0.3e1 * t8932 - 0.2e1 * t8940;
  t10443 = t2496 * t68 * t9809;
  t10449 = t7378 * t2472;
  t10470 = t2482 * t9845;
  t10494 = -0.6e1 * t8240 * t10443 - 0.12e2 * t8240 * t9797 * t2472 + 0.18e2 * t8236 * t10449 - 0.18e2 * t8240 * t10449 + 0.18e2 * t8240 * t1113 * t248 * t2211 + 0.6e1 * t1968 * t2471 * t7539 - 0.6e1 * t8410 * t3211 * t8250 - 0.6e1 * t8243 * t10443 + 0.18e2 * t8236 * t10443 + 0.18e2 * t8240 * t7361 - 0.18e2 * t10279 * t10470 + 0.18e2 * t8263 * t10470 + 0.3e1 * t2735 * t4982 - 0.3e1 * t2705 * t9018 - t2735 * t9040 + 0.3e1 * t2735 * t4880 + 0.3e1 * t2708 * t8995 + 0.3e1 * t2730 * t9065 - 0.4e1 * t1913 * t1020 * t856 * t718 + 0.11e2 * t9021 * t3660 * t8290 * t248;
  t10535 = -0.3e1 * t2735 * t8995 + 0.3e1 * t2754 * t4898 - 0.6e1 * t1923 * t1044 * t10343 - 0.2e1 * t1613 * t8280 + t8988 * t3688 * t4937 * t902 - 0.2e1 * t2735 * t9006 + 0.3e1 * t359 * t10310 * t3616 * t369 * t248 + 0.3e1 * t8456 * t374 * t2527 + 0.6e1 * t8373 * t3768 * t2527 + 0.6e1 * t4847 * t3680 * t2701 * t153 - t2705 * t9040 + 0.3e1 * t2708 * t9040 + 0.3e1 * t2708 * t9018 + 0.2e1 * t9698 - 0.2e1 * t9707 - 0.6e1 * t9728 - 0.2e1 * t9732 - 0.2e1 * t9747 - 0.4e1 * t9754 - t909;
  t10551 = -t4859 * t2702 - 0.2e1 * t2705 * t9138 - 0.3e1 * t2708 * t5035 - t3214 - t3217 + t3221 - t801 - t8983 - t9038 + t9047 - t9061 - 0.3e1 * t9089 - 0.2e1 * t9093 - 0.3e1 * t9107 + 0.2e1 * t9780 + 0.2e1 * t9784 - 0.2e1 * t9788 - 0.6e1 * t9794 - 0.6e1 * t9811 + 0.6e1 * t9841;
  t10555 = t2926 - t2928 - t2936 + t2731 + t2755 + t2245 - t2247 - t2280 - t9116 + t9130 + t9136;
  t10560 = my_piecewise5(t58, 0, t61, 0, t3253 - t3254 - t3255 + t3248 + t3244 - 0.3e1 * t9111 + 0.3e1 * t9109 + t10555 + t10551 + t10535 + t10494 + t10438 + t10415 + t10371 + t10315 - 0.3e1 * t8867 + 0.3e1 * t8859 + 0.6e1 * t9673 + 0.6e1 * t9668 - 0.2e1 * t9670 - 0.2e1 * t9650 + 0.6e1 * t9641 + 0.6e1 * t9643 - 0.6e1 * t9595 + 0.6e1 * t9592 - t2721 - t2719 + t2714);
  t10567 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t3260 + t10262 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.25e2 / 0.81e2 * t3029 + 0.5e1 / 0.27e2 * t38 * t48 * t2543 + 0.4e2 / 0.243e3 * t38 * t141 * t915 - 0.5e1 / 0.81e2 * t38 * t43 * t2761 + t149 * t3258 + t53 * t10560));
  tv4rhosigmalapl20 = t8 * t10567 + t3264;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t10574 = t7 * t180 * t3331 / 0.1e2;
  t10576 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t3331 + t10574);
  tv4rhosigmalapl28 = t8 * t10576 + t3335;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t10582 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t3260 + t10262);
  tv4rhosigmalapl29 = t8 * t10582 + t3264;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t10599 = t8633 * t4481;
  t10600 = t1417 * t10599;
  t10604 = t538 * t8734 * t543;
  t10607 = t925 * t222;
  t10614 = t538 * t10599;
  t10617 = t220 * t8588;
  t10622 = t4505 * t10599;
  t10625 = t7881 * t222;
  t10626 = t1497 * t10625;
  t10629 = t548 * t10625;
  t10634 = 0.3e1 * t220 * t10607 * t4474 * t879 - 0.12e2 * t10617 * t228 * t668 * t222 + 0.18e2 * t10600 * t10629 + 0.6e1 * t10600 * t2624 - 0.6e1 * t10600 * t2635 - 0.3e1 * t10604 * t2609 - 0.11e2 * t10614 * t2632 - 0.12e2 * t10622 * t10626 - 0.7e1 * t10622 * t10629 + 0.7e1 * t10622 * t2632 + t2329 + t2339 - t2342 - t2807 + t2962 + t2981 - 0.4e1 * t3128 - t3130 + t3277 + t3278;
  t10637 = t925 * params->csk_a * t222;
  t10638 = t1497 * t10637;
  t10641 = t220 * t10599;
  t10648 = t665 * t769;
  t10649 = t8604 * t10648;
  t10652 = t1417 * t5252;
  t10665 = t925 * t1048 * t265;
  t10678 = t228 * t10625;
  t10691 = -0.6e1 * t10652 * t1497 * t10607 * t562 - 0.4e1 * t2629 * t1497 * t2622 * t769 - 0.6e1 * t10622 * t4510 * t10625 - 0.6e1 * t7915 * t4510 * t10637 - 0.12e2 * t1417 * t7914 * t10638 + 0.11e2 * t9960 * t4510 * t10665 + 0.12e2 * t10600 * t10626 + 0.6e1 * t10600 * t10678 - 0.18e2 * t10600 * t5268 - 0.3e1 * t10604 * t5268 - 0.7e1 * t10614 * t10629 - 0.7e1 * t10614 * t10678 - 0.11e2 * t10614 * t2609 - 0.18e2 * t10614 * t2624 - t10622 * t10678 - 0.6e1 * t7915 * t10638 + t10641 * t10678 + 0.11e2 * t10641 * t2609 + 0.6e1 * t10641 * t2624 - 0.6e1 * t2629 * t10649;
  t10695 = t3280 * t8764;
  t10698 = t2622 * t8764;
  t10705 = t3280 * t769;
  t10726 = t1847 * t769;
  t10741 = -0.3e1 * t2821 * t9273 + 0.6e1 * t2607 * t10695 + 0.6e1 * t2607 * t10698 - 0.2e1 * t2629 * t10698 - 0.3e1 * t2821 * t9241 + 0.6e1 * t2629 * t548 * t10705 - 0.2e1 * t2612 * t10698 + 0.6e1 * t2629 * t1497 * t10705 + 0.3e1 * t2816 * t9225 - 0.6e1 * t2612 * t10695 + 0.18e2 * t9960 * t1497 * t10665 + 0.6e1 * t6094 * t548 * t7809 + 0.6e1 * t2607 * t10649 + 0.6e1 * t8599 * t228 * t10726 - 0.18e2 * t538 * t10055 * t548 * t2819 * t265 + 0.7e1 * t10614 * t5268 - 0.6e1 * t9907 + 0.6e1 * t9919 + 0.6e1 * t9951 - 0.6e1 * t9954;
  t10761 = t7852 * t2598;
  t10764 = 0.18e2 * t8568 * t10761 + 0.3e1 * t9205 + 0.3e1 * t9210 + 0.3e1 * t9213 + 0.3e1 * t9221 - 0.2e1 * t9237 - t9249 + 0.3e1 * t9252 + 0.3e1 * t9254 - t9264 + 0.3e1 * t9266;
  t10778 = t2622 * t112 * t6096;
  t10797 = t2608 * t10233;
  t10816 = -0.18e2 * t8562 * t10761 + 0.18e2 * t8562 * t1497 * t265 * t2363 + 0.18e2 * t8562 * t7895 * t2363 - 0.6e1 * t8562 * t10778 - 0.6e1 * t8763 * t3285 * t8764 + 0.6e1 * t2100 * t2597 * t7809 - 0.6e1 * t8763 * t5366 * t10726 - 0.12e2 * t8562 * t10093 * t2598 - 0.6e1 * t8565 * t10778 + 0.18e2 * t8568 * t10778 - 0.18e2 * t10617 * t10797 + 0.18e2 * t8622 * t10797 + 0.6e1 * t10101 - 0.6e1 * t10109 - 0.6e1 * t10114 - 0.4e1 * t2085 * t1428 * t884 * t769 - t2828 * t9421 + 0.3e1 * t2811 * t9336 + 0.3e1 * t2828 * t5441 - 0.3e1 * t2794 * t9336;
  t10862 = 0.3e1 * t2828 * t5402 - t2794 * t9421 + 0.3e1 * t2811 * t9421 + 0.11e2 * t9339 * t4528 * t8680 * t265 - 0.3e1 * t2828 * t9349 + 0.3e1 * t2839 * t5451 - 0.6e1 * t2118 * t1423 * t10648 - 0.2e1 * t1814 * t8638 + t9320 * t4536 * t5491 * t925 - 0.2e1 * t2828 * t9363 + 0.3e1 * t2811 * t9349 + 0.3e1 * t2850 * t9373 + 0.3e1 * t538 * t10607 * t4475 * t7895 + 0.3e1 * t8809 * t553 * t2655 + 0.6e1 * t8731 * t4602 * t2655 + 0.6e1 * t5382 * t4561 * t2799 * t222 - 0.2e1 * t10138 - 0.6e1 * t10154 - 0.2e1 * t10158 - 0.2e1 * t10187;
  t10876 = -0.2e1 * t2794 * t9448 - t5414 * t2800 - 0.3e1 * t2811 * t5557 + 0.2e1 * t10192 - 0.4e1 * t10201 - 0.2e1 * t10219 + 0.2e1 * t10224 + 0.2e1 * t10225 + t3284 - t3288 - t3291 - t828 - t932 - t9332 + t9368 - t9370 - 0.2e1 * t9392 - 0.3e1 * t9410 - t9424 + t9438;
  t10881 = -t3324 - t3325 + t3326 + t3002 - t3004 - t3012 + t2840 + t2851 - t2381 + t2397 - t2398;
  t10886 = my_piecewise5(t104, 0, t105, 0, -0.3e1 * t9188 + 0.6e1 * t10067 + t10881 + t10876 + t10862 + t10816 + t10764 + t10741 + t10691 + t10634 - t2822 - t2824 + t2817 - 0.3e1 * t9461 - 0.3e1 * t9463 + 0.3e1 * t9458 + t9456 - t9442 - 0.3e1 * t9197 + 0.6e1 * t10040 + 0.6e1 * t10038 - 0.2e1 * t10013 + 0.6e1 * t10011 - 0.2e1 * t9997 + 0.6e1 * t9993 + t3323 + t3319 - 0.4e1 * t10071);
  t10893 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t3331 + t10574 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.25e2 / 0.81e2 * t3113 + 0.5e1 / 0.27e2 * t38 * t98 * t2670 + 0.4e2 / 0.243e3 * t38 * t210 * t938 - 0.5e1 / 0.81e2 * t38 * t93 * t2864 + t218 * t3329 + t103 * t10886));
  tv4rhosigmalapl217 = t8 * t10893 + t3335;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t10900 = t7 * t135 * t3397 / 0.1e2;
  t10906 = 0.6e1 * t3040;
  t10907 = t3351 * t1019;
  t10908 = t151 * t10907;
  t10911 = t359 * t10907;
  t10915 = t3339 * t362 * t1019;
  t10916 = t1042 * t10915;
  t10921 = t151 * t10915;
  t10924 = -0.18e2 * t10908 * t8863 + 0.18e2 * t10911 * t8863 - 0.12e2 * t10916 * t8899 + 0.18e2 * t10916 * t8910 - 0.6e1 * t10921 * t8922 - t10906 + t2179 + t2197 - t2200 - t2695 + t3354 + t3358 + t3370 + t3372;
  t10925 = t359 * t10915;
  t10953 = 0.9e1 * t2713 * t159 * t8902 * t718 - 0.9e1 * t2718 * t369 * t8936 * t718 - 0.9e1 * t2718 * t8936 * t8250 + 0.18e2 * t10916 * t8881 - 0.18e2 * t10916 * t8887 - 0.6e1 * t10916 * t8922 + 0.18e2 * t10925 * t8887 + 0.18e2 * t10925 * t8922 - 0.9e1 * t9510 + 0.9e1 * t9542 + 0.9e1 * t9572 - 0.6e1 * t9575 + 0.9e1 * t9592 - 0.9e1 * t9595;
  t10961 = t3339 * t3624;
  t10962 = t151 * t10961;
  t10965 = t359 * t10961;
  t10968 = t3640 * t10961;
  t10974 = t1042 * t10961;
  t10980 = t10962 * t8948 + 0.11e2 * t10962 * t9072 - 0.7e1 * t10965 * t8948 - 0.11e2 * t10965 * t9072 - t10968 * t8948 - 0.6e1 * t10968 * t8970 + 0.6e1 * t10974 * t8948 + 0.18e2 * t10974 * t8960 + 0.9e1 * t9641 + 0.9e1 * t9643 - 0.3e1 * t9650 + 0.9e1 * t9668 - 0.3e1 * t9670 + 0.9e1 * t9673;
  t10992 = t1044 * t1596 * t718;
  t10997 = t1067 * t3339;
  t10999 = t3680 * t10997 * t1048;
  t11012 = t1601 * t8250;
  t11015 = t1060 * t8250;
  t11020 = -0.6e1 * t2735 * t1065 * t1068 * t718 + 0.6e1 * t10962 * t8954 - 0.18e2 * t10965 * t8954 - 0.7e1 * t10965 * t8960 - 0.7e1 * t10968 * t8960 - 0.12e2 * t10968 * t8964 + 0.7e1 * t10968 * t9030 + 0.12e2 * t10974 * t8964 - 0.18e2 * t10974 * t8973 + 0.9e1 * t2708 * t10992 - 0.9e1 * t2735 * t10992 + 0.18e2 * t8988 * t10999 + 0.9e1 * t2708 * t11012 - 0.3e1 * t2735 * t11015 + 0.9e1 * t2735 * t5740;
  t11029 = t1065 * t10997 * t383;
  t11038 = t368 * t3339;
  t11040 = t1044 * t11038 * t383;
  t11047 = t3644 * t3339;
  t11049 = t3688 * t11047 * t1048;
  t11057 = t3688 * t11047 * params->csk_a;
  t11062 = t3339 * t3615;
  t11063 = t359 * t11062;
  t11066 = 0.9e1 * t2730 * t374 * t1030 * t718 - 0.6e1 * t1042 * t600 * t11029 + 0.7e1 * t10965 * t8973 - 0.6e1 * t10968 * t9014 + 0.6e1 * t10974 * t8954 - 0.9e1 * t2705 * t11012 - 0.3e1 * t2705 * t11015 + 0.9e1 * t2708 * t11015 - 0.18e2 * t601 * t11040 + 0.11e2 * t8988 * t11049 - 0.6e1 * t8988 * t11057 - 0.3e1 * t11063 * t608 + 0.9e1 * t2735 * t5778 + 0.9e1 * t2754 * t5798;
  t11069 = t3339 * t153;
  t11087 = 0.3e1 * t151 * t11069 * t4837 - 0.11e2 * t10965 * t9030 - 0.12e2 * t10974 * t8970 - 0.6e1 * t10974 * t9101 - 0.3e1 * t11063 * t624 - 0.12e2 * t3352 * t9082 - t801 - t909 + 0.3e1 * t9698 - 0.3e1 * t9707 - 0.9e1 * t9728 - 0.3e1 * t9732 - 0.3e1 * t9747 - 0.6e1 * t9754;
  t11091 = t3688 * t11047;
  t11096 = t3660 * t11038;
  t11101 = t3680 * t10997;
  t11107 = t151 * t11062;
  t11117 = -0.6e1 * t2705 * t1020 * t2692 + 0.3e1 * t359 * t11069 * t3617 + 0.6e1 * t10962 * t9118 + t8988 * t11091 + 0.11e2 * t9021 * t11096 + 0.6e1 * t9721 * t11101 + 0.3e1 * t11107 * t619 - 0.9e1 * t2708 * t5901 - 0.3e1 * t2735 * t5917 + 0.3e1 * t9780 + 0.3e1 * t9784 - 0.3e1 * t9788 - 0.9e1 * t9794 - 0.9e1 * t9811;
  t11119 = 0.9e1 * t9841 + t2714 - t2719 - t2721 - t3376 - t3378 + t3381 + t3382 - t3383 - t3384 + t2731 + t2755 + t2245 - t2247 - t2280;
  t11123 = my_piecewise5(t58, 0, t61, 0, t10924 + t10953 + t10980 + t11020 + t11066 + t11087 + t11117 + t11119);
  t11130 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t3397 + t10900 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.25e2 / 0.54e2 * t3199 + 0.5e1 / 0.18e2 * t38 * t48 * t2761 + t149 * t3395 + t53 * t11123));
  tv4rholapl30 = t8 * t11130 + t3401;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t11137 = t7 * t180 * t3463 / 0.1e2;
  t11139 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t3463 + t11137);
  tv4rholapl33 = t8 * t11139 + t3467;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t11145 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t3397 + t10900);
  tv4rholapl34 = t8 * t11145 + t3401;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t11155 = 0.6e1 * t3128;
  t11156 = t3409 * t1422;
  t11157 = t538 * t11156;
  t11160 = t220 * t11156;
  t11163 = t3408 * t541;
  t11164 = t11163 * t1422;
  t11165 = t220 * t11164;
  t11168 = t1048 * t541;
  t11169 = t11168 * t2400;
  t11172 = t1417 * t11156;
  t11183 = 0.9e1 * t2816 * t228 * t9223 * t769 - 0.9e1 * t2821 * t548 * t9239 * t769 + 0.18e2 * t11157 * t11169 + 0.18e2 * t11157 * t9201 - 0.18e2 * t11160 * t9201 - 0.6e1 * t11165 * t9234 - 0.6e1 * t11172 * t11169 - t11155 + t2329 + t2339 - t2342 - t2807 + t3405 + t3406;
  t11185 = t548 * t3409 * params->csk_a;
  t11191 = t1417 * t11164;
  t11196 = t538 * t11164;
  t11210 = -0.18e2 * t11172 * t11168 * t2631 - 0.9e1 * t2821 * t9239 * t8764 + 0.18e2 * t10056 * t11185 + 0.18e2 * t11191 * t9216 - 0.12e2 * t11191 * t9246 + 0.18e2 * t11196 * t9231 + 0.9e1 * t10011 - 0.3e1 * t10013 - 0.9e1 * t9907 + 0.9e1 * t9919 + 0.9e1 * t9951 - 0.9e1 * t9954 + 0.9e1 * t9993 - 0.3e1 * t9997;
  t11219 = t3408 * t4479;
  t11220 = t538 * t11219;
  t11223 = t220 * t11219;
  t11228 = t4505 * t11219;
  t11231 = t1417 * t11219;
  t11236 = 0.7e1 * t11220 * t9287 + 0.11e2 * t11223 * t9279 + t11223 * t9290 + 0.6e1 * t11223 * t9298 - 0.6e1 * t11228 * t9283 - t11228 * t9290 + 0.6e1 * t11231 * t9290 + 0.9e1 * t10038 + 0.9e1 * t10040 + 0.9e1 * t10067 - 0.6e1 * t10071 + 0.9e1 * t10101 - 0.9e1 * t10109 - 0.9e1 * t10114;
  t11250 = t1443 * t3408;
  t11252 = t1441 * t11250 * t562;
  t11256 = t4561 * t11250 * t1048;
  t11265 = t4509 * t3408;
  t11267 = t4536 * t11265 * t1048;
  t11274 = t1463 * t8764;
  t11277 = t547 * t3408;
  t11279 = t4528 * t11277 * params->csk_a;
  t11282 = -0.6e1 * t2828 * t1441 * t1444 * t769 - 0.6e1 * t1417 * t663 * t11252 - 0.18e2 * t10179 * t11279 - 0.7e1 * t11220 * t9290 - 0.18e2 * t11220 * t9298 - 0.7e1 * t11220 * t9304 - 0.12e2 * t11228 * t9308 - 0.6e1 * t11228 * t9327 + 0.6e1 * t11231 * t9298 + 0.18e2 * t11231 * t9304 + 0.12e2 * t11231 * t9308 + 0.18e2 * t9320 * t11256 + 0.11e2 * t9320 * t11267 + 0.9e1 * t2811 * t11274 + 0.9e1 * t2828 * t6307;
  t11286 = t1436 * t548 * t769;
  t11289 = t3408 * t4474;
  t11290 = t538 * t11289;
  t11301 = t538 * t11163;
  t11307 = t1436 * t8764;
  t11311 = t4528 * t11277 * t1048;
  t11322 = -0.18e2 * t11301 * t1423 * t2419 - 0.11e2 * t11220 * t9279 - 0.11e2 * t11220 * t9345 - 0.7e1 * t11228 * t9304 - 0.12e2 * t11231 * t9283 - 0.6e1 * t11231 * t9405 - 0.9e1 * t2794 * t11274 - 0.9e1 * t2828 * t11286 - 0.3e1 * t11290 * t671 - 0.3e1 * t2794 * t11307 + 0.9e1 * t2811 * t11307 - 0.3e1 * t2828 * t11307 + 0.7e1 * t9320 * t11311 + 0.9e1 * t2828 * t6282;
  t11328 = t4536 * t11265 * params->csk_a;
  t11337 = t3408 * t222;
  t11349 = 0.9e1 * t2850 * t553 * t1411 * t769 + 0.3e1 * t220 * t11337 * t5370 + 0.9e1 * t2811 * t11286 - 0.3e1 * t11290 * t687 - 0.6e1 * t9320 * t11328 + 0.9e1 * t2839 * t6323 - 0.12e2 * t3447 * t9398 - 0.3e1 * t10138 - 0.9e1 * t10154 - 0.3e1 * t10158 - 0.3e1 * t10187 + 0.3e1 * t10192 - 0.6e1 * t10201 - t828;
  t11356 = t4536 * t11265;
  t11360 = t4561 * t11250;
  t11366 = t220 * t11289;
  t11377 = 0.11e2 * t11220 * t4528 * t2323 + 0.3e1 * t538 * t11337 * t4487 - 0.6e1 * t2794 * t1428 * t2804 + 0.6e1 * t10179 * t11360 + 0.6e1 * t11223 * t9472 + t9320 * t11356 + 0.3e1 * t11366 * t682 - 0.9e1 * t2811 * t6383 - 0.3e1 * t2828 * t6394 - 0.3e1 * t10219 + 0.3e1 * t10224 + 0.3e1 * t10225 + t2817 - t932;
  t11378 = -t2822 - t2824 - t3412 + t3416 - t3418 - t3419 - t3420 + t3421 + t2840 + t2851 - t2381 + t2397 - t2398 + t3446 + t3449;
  t11382 = my_piecewise5(t104, 0, t105, 0, t11183 + t11210 + t11236 + t11282 + t11322 + t11349 + t11377 + t11378);
  t11389 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t3463 + t11137 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.25e2 / 0.54e2 * t3269 + 0.5e1 / 0.18e2 * t38 * t98 * t2864 + t218 * t3461 + t103 * t11382));
  tv4rholapl37 = t8 * t11389 + t3467;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t11399 = t799 * t792;
  t11401 = t359 * t11399 * t383;
  t11402 = t11401 * t1103;
  t11405 = t159 * t8902 * t799;
  t11406 = t2209 * t11405;
  t11408 = t11401 * t1090;
  t11410 = t792 * t792;
  t11411 = t11410 * t362;
  t11412 = t151 * t11411;
  t11415 = t6562 * t3074;
  t11418 = t11410 * t383;
  t11423 = t1060 * t369 * t799;
  t11424 = t2235 * t11423;
  t11427 = t1065 * t1068 * t799;
  t11428 = t2235 * t11427;
  t11430 = t359 * t11411;
  t11433 = t1042 * t11411;
  t11438 = t2235 * t6719;
  t11443 = t1020 * t1049 * t799;
  t11444 = t2180 * t11443;
  t11446 = t2172 * t11443;
  t11450 = 0.18e2 * t359 * t11418 * t3520 - 0.6e1 * t11412 * t3534 + 0.18e2 * t11430 * t3547 + 0.18e2 * t11433 * t3542 + 0.18e2 * t11433 * t3566 - 0.12e2 * t11433 * t3594 - 0.18e2 * t11424 - 0.12e2 * t11428 + 0.18e2 * t11438 - 0.6e1 * t11444 + 0.18e2 * t11446;
  t11454 = t2235 * t11443;
  t11456 = t2235 * t6657;
  t11458 = t2172 * t11423;
  t11460 = t1020 * t2924;
  t11461 = t2180 * t11460;
  t11463 = t2267 * t6702;
  t11468 = t151 * t11399 * t1631;
  t11475 = t11410 * t3624;
  t11476 = t3640 * t11475;
  t11481 = t2235 * t6803;
  t11485 = t359 * t11475;
  t11496 = -0.18e2 * t11430 * t3655 + 0.18e2 * t11476 * t3681 - 0.12e2 * t11476 * t3685 + 0.11e2 * t11476 * t3690 - 0.6e1 * t11476 * t3694 - 0.6e1 * t11476 * t3705 + 0.7e1 * t11485 * t3661 - 0.11e2 * t11485 * t3668 - 0.11e2 * t11485 * t3732 - 0.6e1 * t11481 - t803;
  t11503 = t799 * t799;
  t11504 = t11503 * t362;
  t11505 = t359 * t11504;
  t11507 = 0.3e1 * t11505 * t376;
  t11510 = 0.3e1 * t151 * t11504 * t376;
  t11512 = 0.3e1 * t11505 * t393;
  t11519 = t1042 * t11475;
  t11522 = t151 * t11475;
  t11538 = t11410 * t3615;
  t11539 = t359 * t11538;
  t11544 = t6631 * t3042;
  t11549 = -0.12e2 * t151 * t11418 * t3746 - t11476 * t3770 - 0.18e2 * t11485 * t3763 - 0.7e1 * t11485 * t3770 + 0.18e2 * t11519 * t3673 + 0.12e2 * t11519 * t3685 + 0.6e1 * t11519 * t3763 + 0.6e1 * t11519 * t3770 + 0.6e1 * t11522 * t3763 - 0.3e1 * t11539 * t376 - 0.12e2 * t11544;
  t11560 = t2172 * t6819;
  t11564 = t359 * t11410;
  t11567 = t151 * t11410;
  t11576 = t151 * t11503;
  t11578 = 0.3e1 * t11576 * t387;
  t11581 = 0.3e1 * t359 * t11503 * t370;
  t11583 = 0.3e1 * t11576 * t385;
  t11594 = t3640 * t11410 * t3646 + 0.11e2 * t11564 * t3652 + t11578 + t11581 - t11583 + 0.4e1 * t2926 - 0.4e1 * t2928 - 0.4e1 * t2931 + 0.4e1 * t2934 - 0.4e1 * t2936 - 0.4e1 * t2938;
  t11598 = my_piecewise5(t58, 0, t61, 0, t11594 + 0.4e1 * t2905 + 0.4e1 * t2897 + 0.4e1 * t2901 + 0.4e1 * t2890 - 0.18e2 * t11560 + t11549 - 0.9e1 * t2883 - t11512 + t11510 - t11507 + t11496 + 0.18e2 * t11468 + 0.18e2 * t11463 + 0.18e2 * t11458 - 0.18e2 * t11461 - 0.6e1 * t11454 + 0.18e2 * t11456 + t11450 + 0.18e2 * t11415 - 0.18e2 * t11408 - 0.18e2 * t11402 + 0.18e2 * t11406 - t801 - 0.7e1 * t11476 * t3673 + 0.7e1 * t11476 * t3668 - 0.6e1 * t11433 * t3724 - 0.7e1 * t11485 * t3673 - 0.6e1 * t11476 * t3754 - 0.18e2 * t11519 * t3661 + 0.18e2 * t11430 * t3534 - 0.6e1 * t11433 * t3534 - 0.18e2 * t11433 * t3547 - 0.18e2 * t11412 * t3525 - 0.3e1 * t11539 * t393 + 0.11e2 * t11522 * t3732 - 0.6e1 * t11519 * t3681 - 0.12e2 * t11519 * t3754 + 0.3e1 * t11564 * t3617 + 0.3e1 * t11567 * t3621 + 0.6e1 * t11567 * t3628 + t11522 * t3770 + 0.3e1 * t151 * t11538 * t376 + 0.6e1 * t1042 * t11410 * t3632);
  t11604 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (-0.2e2 / 0.81e2 * t38 * t43 * t2942 + t53 * t11598));
  tv4sigma40 = t8 * t11604;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t11613 = t826 * t819;
  t11615 = t538 * t11613 * t562;
  t11616 = t11615 * t1487;
  t11618 = t11615 * t1479;
  t11621 = t228 * t9223 * t826;
  t11622 = t2362 * t11621;
  t11624 = t819 * t819;
  t11625 = t11624 * t541;
  t11626 = t220 * t11625;
  t11629 = t11624 * t562;
  t11634 = t7048 * t3146;
  t11638 = t538 * t11625;
  t11641 = t2387 * t7077;
  t11643 = t1417 * t11625;
  t11649 = t1436 * t228 * t826;
  t11650 = t2387 * t11649;
  t11652 = t2387 * t7181;
  t11655 = t1423 * t1788 * t826;
  t11656 = t2322 * t11655;
  t11660 = t1428 * t3000;
  t11661 = t2318 * t11660;
  t11663 = -0.6e1 * t11626 * t4416 + 0.18e2 * t11638 * t4405 + 0.18e2 * t11638 * t4416 - 0.12e2 * t11643 * t4377 - 0.18e2 * t11643 * t4405 + 0.18e2 * t11634 + 0.18e2 * t11641 - 0.6e1 * t11650 + 0.18e2 * t11652 + 0.18e2 * t11656 - 0.18e2 * t11661;
  t11665 = t2387 * t11655;
  t11668 = t1441 * t1444 * t826;
  t11669 = t2387 * t11668;
  t11673 = t2318 * t11649;
  t11675 = t2322 * t11649;
  t11679 = t2418 * t7221;
  t11684 = t220 * t11613 * t1819;
  t11687 = t11624 * t4479;
  t11688 = t4505 * t11687;
  t11691 = t2387 * t7286;
  t11695 = t538 * t11687;
  t11706 = t826 * t826;
  t11707 = t11706 * t541;
  t11708 = t538 * t11707;
  t11710 = 0.3e1 * t11708 * t572;
  t11713 = -0.6e1 * t11643 * t4554 - 0.6e1 * t11688 * t4538 + 0.18e2 * t11688 * t4565 - 0.7e1 * t11688 * t4572 - 0.12e2 * t11688 * t4581 - 0.6e1 * t11688 * t4591 + 0.7e1 * t11695 * t4529 - 0.11e2 * t11695 * t4568 - 0.6e1 * t11691 - t11710 - t830;
  t11720 = t1417 * t11687;
  t11724 = t220 * t11687;
  t11745 = t1428 * t3121;
  t11746 = t2318 * t11745;
  t11750 = t11624 * t4474;
  t11751 = t538 * t11750;
  t11758 = t2322 * t7276;
  t11762 = -0.18e2 * t11638 * t4606 - 0.6e1 * t11688 * t4562 + 0.11e2 * t11688 * t4587 - 0.7e1 * t11695 * t4634 - 0.18e2 * t11720 * t4529 - 0.12e2 * t11720 * t4562 + 0.6e1 * t11720 * t4624 - 0.3e1 * t11751 * t555 - 0.3e1 * t11751 * t572 - 0.12e2 * t11746 - 0.18e2 * t11758;
  t11775 = 0.3e1 * t11708 * t555;
  t11778 = 0.3e1 * t220 * t11707 * t555;
  t11779 = t220 * t11624;
  t11784 = t538 * t11624;
  t11791 = t220 * t11706;
  t11793 = 0.3e1 * t11791 * t566;
  t11796 = 0.3e1 * t538 * t11706 * t549;
  t11798 = 0.3e1 * t11791 * t564;
  t11809 = t4505 * t11624 * t4511 + 0.11e2 * t11784 * t4490 + t11793 + t11796 - t11798 + 0.4e1 * t3002 - 0.4e1 * t3004 - 0.4e1 * t3007 + 0.4e1 * t3010 - 0.4e1 * t3012 - 0.4e1 * t3014;
  t11813 = my_piecewise5(t104, 0, t105, 0, t11809 - t11775 + t11778 + t11762 + t11713 + 0.18e2 * t11684 + 0.18e2 * t11679 - 0.6e1 * t11673 + 0.18e2 * t11675 - 0.12e2 * t11669 + t11663 - 0.18e2 * t11665 + 0.18e2 * t11622 - 0.18e2 * t11616 - 0.18e2 * t11618 - 0.9e1 * t2971 + 0.4e1 * t2962 - t828 + 0.4e1 * t2981 + 0.4e1 * t2975 + 0.4e1 * t2979 + 0.3e1 * t11779 * t4476 + 0.6e1 * t11779 * t4483 + 0.3e1 * t11784 * t4487 + 0.11e2 * t11724 * t4603 - 0.6e1 * t11720 * t4565 + t11724 * t4634 + 0.6e1 * t11724 * t4624 - 0.18e2 * t11695 * t4624 + 0.18e2 * t11720 * t4572 + 0.12e2 * t11720 * t4581 - 0.7e1 * t11695 * t4572 - 0.11e2 * t11695 * t4603 + 0.7e1 * t11688 * t4568 + 0.6e1 * t11720 * t4634 - t11688 * t4634 - 0.6e1 * t11643 * t4416 + 0.18e2 * t11643 * t4400 + 0.18e2 * t11643 * t4412 - 0.18e2 * t11626 * t4396 + 0.18e2 * t538 * t11629 * t4392 - 0.12e2 * t220 * t11629 * t4519 + 0.3e1 * t220 * t11750 * t555 + 0.6e1 * t1417 * t11624 * t4494);
  t11819 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (-0.2e2 / 0.81e2 * t38 * t93 * t3018 + t103 * t11813));
  tv4sigma414 = t8 * t11819;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t11827 = t159 * t8872 * t248;
  t11828 = t2486 * t11827;
  t11829 = 0.9e1 * t11828;
  t11830 = t2481 * t11827;
  t11831 = 0.9e1 * t11830;
  t11832 = t1048 * t2876;
  t11837 = t11832 * t383;
  t11841 = t8913 * t2482;
  t11842 = t2481 * t11841;
  t11843 = 0.9e1 * t11842;
  t11844 = t2503 * t11841;
  t11845 = 0.3e1 * t11844;
  t11846 = -0.18e2 * t9796 * t11832 * t369 * t383 - 0.12e2 * t9796 * t1113 * t11837 - t11829 + t11831 + t11843 - t11845 + t2891 + t2898 + t3035 + t3036 - t3373 - t855 - t8856;
  t11847 = t8913 * t248;
  t11848 = t369 * t11847;
  t11849 = t2481 * t11848;
  t11850 = 0.9e1 * t11849;
  t11851 = t281 * t2876;
  t11852 = t11851 * t383;
  t11856 = t359 * t11852;
  t11859 = t2486 * t11841;
  t11860 = 0.3e1 * t11859;
  t11867 = t374 * t1030 * t799;
  t11868 = t2511 * t11867;
  t11869 = 0.9e1 * t11868;
  t11873 = t2516 * t369 * t9839;
  t11874 = 0.9e1 * t11873;
  t11875 = t2503 * t11848;
  t11876 = 0.9e1 * t11875;
  t11877 = t2490 * t9571;
  t11878 = 0.9e1 * t11877;
  t11880 = t2503 * t1113 * t11847;
  t11881 = 0.6e1 * t11880;
  t11882 = t2490 * t9591;
  t11883 = 0.9e1 * t11882;
  t11887 = -0.6e1 * t1042 * t11852 * t4755 - 0.6e1 * t5678 * t159 * t11837 - 0.18e2 * t151 * t11852 * t3520 + 0.18e2 * t11856 * t3520 + 0.18e2 * t11856 * t4818 + 0.18e2 * t8880 * t5696 + t11850 - t11860 + t11869 + t11874 - t11876 + t11878 - t11881 + t11883;
  t11898 = t9840 * t374 * t158 * t3211;
  t11899 = 0.9e1 * t11898;
  t11901 = t7406 * t4923 * t8890;
  t11902 = 0.9e1 * t11901;
  t11905 = t7406 * t9808 * t856 * t383;
  t11906 = 0.9e1 * t11905;
  t11909 = t3762 * t2876 * t68 * t158;
  t11915 = t3768 * t3769 * t2876;
  t11921 = 0.18e2 * t11856 * t4755 + 0.6e1 * t5737 * t11909 + 0.6e1 * t5765 * t11909 - 0.7e1 * t5734 * t11915 + 0.6e1 * t5737 * t11915 + t5765 * t11915 + 0.18e2 * t8880 * t5724 - 0.9e1 * t11402 + 0.9e1 * t11406 - 0.9e1 * t11408 + t11899 - t11902 - t11906;
  t11923 = t158 * t2876;
  t11925 = t3768 * t11923 * params->csk_a;
  t11934 = t359 * t11851;
  t11941 = t151 * t11851;
  t11957 = t3672 * t2876 * t366 * t368;
  t11961 = t3680 * t4848 * t2876;
  t11964 = -0.11e2 * t5734 * t3660 * t1596 * t2876 - 0.6e1 * t5817 * t3688 * t3693 * t2876 - 0.18e2 * t359 * t8878 * t5832 - 0.18e2 * t5734 * t11909 - t5817 * t11915 - 0.11e2 * t5734 * t11925 + 0.11e2 * t5765 * t11925 - 0.3e1 * t11934 * t4837 - 0.3e1 * t11934 * t4924 - 0.12e2 * t11941 * t4833 + 0.18e2 * t5737 * t11957 + 0.12e2 * t5737 * t11961 - 0.6e1 * t5737 * t9000 + 0.11e2 * t8951 * t5874;
  t11979 = t1613 * t9706;
  t11980 = 0.3e1 * t11979;
  t11985 = t1913 * t1020 * t856 * t799;
  t11986 = 0.6e1 * t11985;
  t11991 = t1595 * t9727;
  t11992 = 0.9e1 * t11991;
  t11995 = 0.3e1 * t11941 * t4837 - 0.7e1 * t5734 * t11957 - 0.7e1 * t5817 * t11957 + 0.7e1 * t5734 * t9023 - 0.12e2 * t8947 * t5747 - 0.6e1 * t8951 * t5747 - 0.6e1 * t8951 * t5783 - 0.18e2 * t8947 * t5794 - 0.6e1 * t9055 * t5814 + 0.7e1 * t8951 * t5845 - t11980 - t11986 - t11992;
  t12012 = -0.12e2 * t5817 * t11961 + 0.18e2 * t8951 * t5851 + 0.9e1 * t11415 - 0.9e1 * t11424 - 0.6e1 * t11428 + 0.9e1 * t11438 - 0.3e1 * t11444 + 0.9e1 * t11446 - 0.3e1 * t11454 + 0.9e1 * t11456 + 0.9e1 * t11458 - 0.9e1 * t11461 + 0.9e1 * t11463 + 0.9e1 * t11468;
  t12029 = 0.6e1 * t5765 * t3768 * t11923 + 0.3e1 * t11941 * t3621 + 0.6e1 * t8947 * t5904 + t8951 * t5920 + 0.11e2 * t8957 * t5924 + 0.3e1 * t9076 * t711 - 0.3e1 * t11481 - t11507 + t11510 - t11512 - 0.6e1 * t11544 - 0.9e1 * t11560 - t801;
  t12035 = t11578 + t11581 - t11583 - 0.4e1 * t3051 + 0.4e1 * t3056 - 0.4e1 * t3058 + t3069 - t3082 - t3087 + 0.4e1 * t3093 + 0.4e1 * t3095 + t2927 - t2929 - t2937;
  t12039 = my_piecewise5(t58, 0, t61, 0, t11846 + t11887 + t11921 + t11964 + t11995 + t12012 + t12029 + t12035);
  t12045 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.54e2 * t38 * t48 * t2942 - 0.5e1 / 0.27e2 * t38 * t43 * t3102 + t53 * t12039));
  tv4sigma3lapl0 = t8 * t12045;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t12052 = t297 * t2952;
  t12053 = t12052 * t562;
  t12057 = t538 * t12053;
  t12060 = t9261 * t2608;
  t12061 = t2607 * t12060;
  t12062 = 0.9e1 * t12061;
  t12063 = t2629 * t12060;
  t12064 = 0.3e1 * t12063;
  t12065 = t9261 * t265;
  t12066 = t548 * t12065;
  t12067 = t2607 * t12066;
  t12068 = 0.9e1 * t12067;
  t12069 = t2612 * t12060;
  t12070 = 0.3e1 * t12069;
  t12071 = -0.18e2 * t220 * t12053 * t4392 + 0.18e2 * t12057 * t4392 + t12062 - t12064 + t12068 - t12070 + t2963 + t2982 + t3123 + t3124 - t3407 - t883 - t9184;
  t12073 = t228 * t9185 * t265;
  t12074 = t2612 * t12073;
  t12075 = 0.9e1 * t12074;
  t12077 = t1048 * t2952 * t562;
  t12078 = t548 * t12077;
  t12081 = t2607 * t12073;
  t12082 = 0.9e1 * t12081;
  t12100 = t2616 * t9950;
  t12101 = 0.9e1 * t12100;
  t12102 = t2629 * t12066;
  t12103 = 0.9e1 * t12102;
  t12104 = t2616 * t10066;
  t12105 = 0.9e1 * t12104;
  t12107 = t2629 * t1497 * t12065;
  t12108 = 0.6e1 * t12107;
  t12109 = -0.6e1 * t1417 * t12053 * t5277 - 0.12e2 * t6115 * t1497 * t12077 - 0.6e1 * t6135 * t228 * t12077 + 0.18e2 * t12057 * t5277 - 0.18e2 * t6115 * t12078 + 0.18e2 * t6126 * t12078 + 0.18e2 * t9215 * t6167 + 0.18e2 * t9215 * t6177 - t12075 + t12082 + t12101 - t12103 + t12105 - t12108;
  t12112 = t553 * t1411 * t826;
  t12113 = t2648 * t12112;
  t12114 = 0.9e1 * t12113;
  t12117 = t2638 * t548 * t2802 * t826;
  t12118 = 0.9e1 * t12117;
  t12126 = t7151 * t2952 * t112 * t227;
  t12134 = t4602 * t4633 * t2952;
  t12141 = -0.18e2 * t6189 * t12126 + 0.6e1 * t6192 * t12126 + 0.6e1 * t6216 * t12126 - 0.7e1 * t6189 * t12134 + 0.6e1 * t6192 * t12134 - t6201 * t12134 + t6216 * t12134 - 0.6e1 * t9282 * t6207 - 0.9e1 * t11616 - 0.9e1 * t11618 + 0.9e1 * t11622 + t12114 + t12118;
  t12142 = t227 * t2952;
  t12144 = t4602 * t12142 * params->csk_a;
  t12151 = t4580 * t2952 * t545 * t547;
  t12155 = t4561 * t5383 * t2952;
  t12164 = t220 * t12052;
  t12167 = t538 * t12052;
  t12181 = -0.18e2 * t538 * t9190 * t6220 - 0.11e2 * t6189 * t12144 + 0.11e2 * t6216 * t12144 - 0.7e1 * t6189 * t12151 + 0.18e2 * t6192 * t12151 - 0.7e1 * t6201 * t12151 + 0.12e2 * t6192 * t12155 + 0.3e1 * t12164 * t5370 - 0.3e1 * t12167 * t5367 - 0.3e1 * t12167 * t5370 - 0.11e2 * t6189 * t9431 - 0.6e1 * t6192 * t9357 - 0.12e2 * t9286 * t6207 - 0.18e2 * t9286 * t6288;
  t12184 = t2597 * t9219;
  t12185 = t2100 * t12184;
  t12186 = 0.9e1 * t12185;
  t12187 = t6094 * t12184;
  t12188 = 0.9e1 * t12187;
  t12190 = t6094 * t5366 * t9219;
  t12191 = 0.9e1 * t12190;
  t12196 = t1814 * t10157;
  t12197 = 0.3e1 * t12196;
  t12200 = t2085 * t1428 * t884 * t826;
  t12201 = 0.6e1 * t12200;
  t12206 = t1787 * t10153;
  t12207 = 0.9e1 * t12206;
  t12218 = -0.12e2 * t765 * t1428 * t12142 * t562 - 0.6e1 * t6201 * t4536 * t4590 * t2952 + 0.7e1 * t6189 * t9342 + 0.11e2 * t9282 * t6232 + 0.18e2 * t9282 * t6252 - 0.6e1 * t9282 * t6300 - 0.6e1 * t9313 * t6317 + t12186 - t12188 - t12191 - t12197 - t12201 - t12207;
  t12235 = -0.12e2 * t6201 * t12155 + 0.7e1 * t9282 * t6292 + 0.9e1 * t11634 + 0.9e1 * t11641 - 0.3e1 * t11650 + 0.9e1 * t11652 + 0.9e1 * t11656 - 0.9e1 * t11661 - 0.9e1 * t11665 - 0.6e1 * t11669 - 0.3e1 * t11673 + 0.9e1 * t11675 + 0.9e1 * t11679 + 0.9e1 * t11684;
  t12254 = 0.6e1 * t6216 * t4602 * t12142 + 0.3e1 * t12164 * t4476 + 0.11e2 * t9277 * t6357 + 0.6e1 * t9286 * t6361 + t9282 * t6366 + 0.3e1 * t9389 * t762 - 0.3e1 * t11691 - t11710 - 0.6e1 * t11746 - 0.9e1 * t11758 - 0.4e1 * t3135 + 0.4e1 * t3140 - t828;
  t12258 = -t11775 + t11778 + t11793 + t11796 - t11798 - 0.4e1 * t3142 - t3160 - t3168 + t3175 + 0.4e1 * t3178 + 0.4e1 * t3181 + t3003 - t3005 - t3013;
  t12262 = my_piecewise5(t104, 0, t105, 0, t12071 + t12109 + t12141 + t12181 + t12218 + t12235 + t12254 + t12258);
  t12268 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (0.5e1 / 0.54e2 * t38 * t98 * t3018 - 0.5e1 / 0.27e2 * t38 * t93 * t3188 + t103 * t12262));
  tv4sigma3lapl19 = t8 * t12268;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t12276 = t159 * t795 * params->csk_a;
  t12281 = t9529 * t6472;
  t12284 = t9529 * t383;
  t12288 = t369 * t12284;
  t12300 = -0.12e2 * t8240 * t1113 * t12284 + 0.18e2 * t8240 * t369 * t3054 - 0.18e2 * t10279 * t12276 + 0.18e2 * t8263 * t12276 + 0.18e2 * t8236 * t12281 - 0.6e1 * t8240 * t12281 - 0.6e1 * t8243 * t12281 + 0.18e2 * t8236 * t12288 - 0.18e2 * t8240 * t12288 - t10906 - t2884 + t3046 + t3047 + t3207 + t3208;
  t12302 = t2718 * t8872 * t1102;
  t12306 = t2718 * t369 * t8872 * t155;
  t12311 = t2713 * t11405;
  t12325 = 0.18e2 * t8240 * t1113 * t3054 - 0.12e2 * t11828 + 0.12e2 * t11830 + 0.12e2 * t11842 - 0.4e1 * t11844 + 0.12e2 * t11849 - 0.4e1 * t11859 + 0.12e2 * t11868 + 0.12e2 * t11873 - 0.12e2 * t11875 + 0.12e2 * t11877 - 0.8e1 * t11880 + 0.12e2 * t11882 - 0.3e1 * t12302 - 0.3e1 * t12306 + 0.3e1 * t12311;
  t12331 = t3768 * t1049 * t792;
  t12336 = t3672 * t3061;
  t12343 = t3768 * t9520;
  t12353 = t3680 * t4848 * t792;
  t12356 = t368 * t3671;
  t12358 = t3660 * t12356 * t792;
  t12362 = t368 * t792 * params->csk_a;
  t12363 = t3660 * t12362;
  t12366 = -0.18e2 * t8295 * t12331 + 0.6e1 * t8373 * t12331 - t8276 * t12336 - 0.7e1 * t8295 * t12336 + t8373 * t12336 + 0.6e1 * t8376 * t12336 - 0.11e2 * t8295 * t12343 + 0.11e2 * t8373 * t12343 + 0.12e2 * t8376 * t12353 - 0.7e1 * t8295 * t12358 - 0.18e2 * t8376 * t12363 - 0.12e2 * t6574 * t8346 - 0.6e1 * t6613 * t8346 - 0.3e1 * t11402 + 0.3e1 * t11406 - 0.3e1 * t11408;
  t12373 = t2735 * t11423;
  t12377 = t2754 * t6702;
  t12381 = t2735 * t11427;
  t12389 = t2708 * t11423;
  t12404 = -0.18e2 * t805 * t1044 * t8290 * t383 - 0.6e1 * t8276 * t3688 * t3693 * t792 - 0.3e1 * t8398 * t391 * t12362 + 0.6e1 * t8376 * t12331 - 0.12e2 * t8276 * t12353 - 0.7e1 * t8276 * t12358 + 0.18e2 * t8376 * t12358 + 0.7e1 * t8295 * t12363 - 0.6e1 * t6613 * t8285 + 0.18e2 * t6613 * t8330 + 0.11e2 * t6613 * t8342 - 0.3e1 * t8398 * t9521 - 0.3e1 * t12373 + 0.3e1 * t12377 - 0.2e1 * t12381 + 0.3e1 * t12389;
  t12407 = t902 * t792;
  t12423 = t2735 * t6719;
  t12425 = t2705 * t11443;
  t12426 = t2708 * t11443;
  t12428 = t2708 * t11460;
  t12430 = t2735 * t6657;
  t12432 = t2705 * t11460;
  t12434 = t2735 * t11443;
  t12437 = t2730 * t11867;
  t12440 = -0.12e2 * t2730 * t1020 * t3041 * t362 - 0.6e1 * t1042 * t795 * t8352 + 0.3e1 * t151 * t12407 * t4837 - 0.11e2 * t8295 * t3660 * t3070 - 0.6e1 * t8376 * t6610 + 0.7e1 * t6613 * t8307 + 0.12e2 * t11898 + 0.3e1 * t12423 - t12425 + 0.3e1 * t12426 + 0.3e1 * t12428 + 0.3e1 * t12430 - 0.3e1 * t12432 - t12434 + 0.3e1 * t12437;
  t12455 = -0.12e2 * t11901 - 0.12e2 * t11905 - 0.4e1 * t11979 - 0.8e1 * t11985 - 0.12e2 * t11991 + 0.3e1 * t11415 - 0.3e1 * t11424 - 0.2e1 * t11428 + 0.3e1 * t11438 - t11444 + 0.3e1 * t11446 - t11454 + 0.3e1 * t11456 + 0.3e1 * t11458 - 0.3e1 * t11461 + 0.3e1 * t11463;
  t12472 = t2708 * t6819;
  t12474 = t6618 * t2702;
  t12477 = t2705 * t1020 * t3033;
  t12481 = 0.3e1 * t359 * t12407 * t3617 + 0.3e1 * t8456 * t374 * t3041 + 0.6e1 * t8373 * t3768 * t3041 + 0.11e2 * t6571 * t8442 + 0.6e1 * t6574 * t8462 + t6613 * t8438 + 0.3e1 * t11468 - t11481 - 0.3e1 * t12472 - t12474 - 0.2e1 * t12477 - 0.4e1 * t3213 - 0.4e1 * t3216 + 0.4e1 * t3220 - t801 - t909;
  t12486 = -t11507 + t11510 - t11512 - 0.2e1 * t11544 - 0.3e1 * t11560 + t11578 + t11581 - t11583 + 0.4e1 * t3243 + 0.4e1 * t3247 + t3253 - t3254 - t3255 + t3097 - t3098 - t3099;
  t12490 = my_piecewise5(t58, 0, t61, 0, t12300 + t12325 + t12366 + t12404 + t12440 + t12455 + t12481 + t12486);
  t12496 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.27e2 * t38 * t48 * t3102 - 0.1e2 / 0.81e2 * t38 * t43 * t3258 + t53 * t12490));
  tv4sigma2lapl20 = t8 * t12496;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t12504 = t228 * t822 * params->csk_a;
  t12509 = t9909 * t5255;
  t12512 = t9909 * t562;
  t12516 = t548 * t12512;
  t12528 = -0.12e2 * t8562 * t1497 * t12512 + 0.18e2 * t8562 * t548 * t3138 - 0.18e2 * t10617 * t12504 + 0.18e2 * t8622 * t12504 - 0.6e1 * t8562 * t12509 - 0.6e1 * t8565 * t12509 + 0.18e2 * t8568 * t12509 - 0.18e2 * t8562 * t12516 + 0.18e2 * t8568 * t12516 - t11155 - t2972 + t3129 + t3131 + t3277 + t3278;
  t12530 = t2821 * t9185 * t1486;
  t12532 = t2816 * t11621;
  t12536 = t2821 * t548 * t9185 * t224;
  t12553 = 0.18e2 * t8562 * t1497 * t3138 + 0.12e2 * t12061 - 0.4e1 * t12063 + 0.12e2 * t12067 - 0.4e1 * t12069 - 0.12e2 * t12074 + 0.12e2 * t12081 + 0.12e2 * t12100 - 0.12e2 * t12102 + 0.12e2 * t12104 - 0.8e1 * t12107 + 0.12e2 * t12113 + 0.12e2 * t12117 - 0.3e1 * t12530 + 0.3e1 * t12532 - 0.3e1 * t12536;
  t12558 = t4580 * t3145;
  t12564 = t4561 * t5383 * t819;
  t12568 = t4528 * t4571 * t819;
  t12571 = t7265 * params->csk_a;
  t12572 = t4528 * t12571;
  t12575 = t4602 * t3154;
  t12582 = t4602 * t9945;
  t12591 = -0.7e1 * t8634 * t12558 - t8660 * t12558 + 0.6e1 * t8707 * t12558 + t8731 * t12558 + 0.12e2 * t8707 * t12564 - 0.7e1 * t8634 * t12568 - 0.18e2 * t8707 * t12572 - 0.18e2 * t8634 * t12575 + 0.6e1 * t8731 * t12575 - 0.11e2 * t8634 * t12582 + 0.11e2 * t8731 * t12582 - 0.6e1 * t7037 * t8700 - 0.12e2 * t7072 * t8700 - 0.3e1 * t11616 - 0.3e1 * t11618 + 0.3e1 * t11622;
  t12593 = t4528 * t1788 * t819;
  t12600 = t2850 * t12112;
  t12608 = t2828 * t11655;
  t12612 = t2839 * t7221;
  t12616 = t2828 * t11668;
  t12624 = t2811 * t11655;
  t12632 = -0.18e2 * t832 * t1423 * t8680 * t562 - 0.12e2 * t2850 * t1428 * t3115 * t541 - 0.6e1 * t8660 * t4536 * t4590 * t819 - 0.12e2 * t8660 * t12564 - 0.7e1 * t8660 * t12568 + 0.18e2 * t8707 * t12568 + 0.7e1 * t8634 * t12572 - 0.11e2 * t8634 * t12593 + 0.11e2 * t7037 * t8657 - 0.6e1 * t7037 * t8666 + 0.18e2 * t7037 * t8672 + 0.3e1 * t12600 - 0.3e1 * t12608 + 0.3e1 * t12612 - 0.2e1 * t12616 + 0.3e1 * t12624;
  t12643 = t925 * t819;
  t12653 = t2794 * t11649;
  t12654 = t2811 * t11649;
  t12656 = t2828 * t11649;
  t12657 = t2811 * t11660;
  t12659 = t2828 * t7181;
  t12661 = t2794 * t11660;
  t12663 = t2828 * t7077;
  t12666 = -0.3e1 * t8735 * t570 * t12571 + 0.3e1 * t220 * t12643 * t5370 - 0.6e1 * t1417 * t822 * t8713 + 0.6e1 * t8707 * t12575 + 0.7e1 * t8660 * t12593 - 0.6e1 * t8707 * t7115 - 0.3e1 * t8735 * t9946 + 0.12e2 * t12185 - t12653 + 0.3e1 * t12654 - t12656 + 0.3e1 * t12657 + 0.3e1 * t12659 - 0.3e1 * t12661 + 0.3e1 * t12663;
  t12681 = -0.12e2 * t12187 - 0.12e2 * t12190 - 0.4e1 * t12196 - 0.8e1 * t12200 - 0.12e2 * t12206 + 0.3e1 * t11634 + 0.3e1 * t11641 - t11650 + 0.3e1 * t11652 + 0.3e1 * t11656 - 0.3e1 * t11661 - 0.3e1 * t11665 - 0.2e1 * t11669 - t11673 + 0.3e1 * t11675 + 0.3e1 * t11679;
  t12701 = t2811 * t7276;
  t12703 = t7033 * t2800;
  t12705 = t2794 * t11745;
  t12707 = 0.3e1 * t538 * t12643 * t4487 + 0.6e1 * t8731 * t4602 * t3115 + 0.3e1 * t8809 * t553 * t3115 + 0.11e2 * t7056 * t4528 * t8680 + t7037 * t8802 + 0.6e1 * t7072 * t8818 + 0.3e1 * t11684 - t11691 - 0.3e1 * t12701 - t12703 - 0.2e1 * t12705 + 0.4e1 * t3283 - 0.4e1 * t3287 - 0.4e1 * t3290 - t828 - t932;
  t12712 = -t11710 - 0.2e1 * t11746 - 0.3e1 * t11758 - t11775 + t11778 + t11793 + t11796 - t11798 + 0.4e1 * t3318 + 0.4e1 * t3322 - t3324 - t3325 + t3326 + t3183 - t3184 - t3185;
  t12716 = my_piecewise5(t104, 0, t105, 0, t12528 + t12553 + t12591 + t12632 + t12666 + t12681 + t12707 + t12712);
  t12722 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (0.5e1 / 0.27e2 * t38 * t98 * t3188 - 0.1e2 / 0.81e2 * t38 * t93 * t3329 + t103 * t12716));
  tv4sigma2lapl217 = t8 * t12722;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t12731 = t159 * t9844 * t248;
  t12738 = t8885 * t248;
  t12739 = t159 * t12738;
  t12746 = -0.18e2 * t10908 * t12731 + 0.18e2 * t10911 * t12731 - 0.6e1 * t10916 * t12739 + 0.18e2 * t10916 * t4813 - 0.6e1 * t10921 * t12739 + 0.18e2 * t10925 * t12739 - t2883 + t2890 + t2897 - 0.8e1 * t3040 + t3354 + t3358 + t3370 + t3372;
  t12747 = t6453 * t1624;
  t12760 = -0.12e2 * t10916 * t1113 * t12738 - 0.18e2 * t10916 * t12747 + 0.18e2 * t10916 * t4778 + 0.18e2 * t10925 * t12747 - t11829 + t11831 + t11843 - t11845 + t11850 - t11860 + t11869 - 0.9e1 * t12302 - 0.9e1 * t12306 + 0.9e1 * t12311;
  t12762 = t3672 * t2482;
  t12765 = t3660 * t12356 * t248;
  t12771 = t3768 * t1049 * t248;
  t12781 = t3680 * t4848 * t248;
  t12786 = 0.6e1 * t10962 * t12771 - 0.7e1 * t10965 * t12765 - 0.18e2 * t10965 * t12771 - t10968 * t12762 - 0.6e1 * t10968 * t4885 + 0.7e1 * t10968 * t4968 + 0.18e2 * t10974 * t12765 + 0.12e2 * t10974 * t12781 - 0.18e2 * t10974 * t4894 + t11874 - t11876 + t11878 - t11881 + t11883;
  t12800 = t3768 * t850;
  t12811 = t3339 * t248;
  t12817 = 0.3e1 * t151 * t12811 * t4837 + t10962 * t12762 + 0.11e2 * t10962 * t12800 - 0.7e1 * t10965 * t12762 - 0.11e2 * t10965 * t12800 - 0.7e1 * t10968 * t12765 - 0.12e2 * t10968 * t12781 + 0.6e1 * t10974 * t12762 + 0.6e1 * t10974 * t12771 - 0.6e1 * t10974 * t4973 + 0.18e2 * t4871 * t10999 - 0.6e1 * t4871 * t11057 - 0.3e1 * t11063 * t851 - 0.3e1 * t11063 * t861;
  t12847 = -0.12e2 * t3352 * t1020 * t3745 * t248 - 0.6e1 * t10968 * t3688 * t3693 * t248 - 0.6e1 * t1042 * t605 * t11029 + 0.7e1 * t10965 * t4894 - 0.11e2 * t10965 * t4968 - 0.12e2 * t10974 * t4885 - 0.18e2 * t621 * t11040 + 0.11e2 * t4871 * t11049 - 0.9e1 * t12373 + 0.9e1 * t12377 - 0.6e1 * t12381 + 0.9e1 * t12389 + 0.9e1 * t12423 - 0.3e1 * t12425;
  t12854 = 0.9e1 * t12426 + 0.9e1 * t12428 + 0.9e1 * t12430 - 0.9e1 * t12432 - 0.3e1 * t12434 + 0.9e1 * t12437 + t11899 - t11902 - t11906 - t11980 - t11986 - t11992 - t909 - t801;
  t12872 = 0.6e1 * t10962 * t3768 * t856 + 0.3e1 * t359 * t12811 * t3617 + t4871 * t11091 + 0.11e2 * t4841 * t11096 + 0.6e1 * t4847 * t11101 + 0.3e1 * t11107 * t857 - t11507 + t11510 - 0.9e1 * t12472 - 0.3e1 * t12474 - 0.6e1 * t12477 - t3213 - t3216 + t3220;
  t12873 = -t11512 + t11578 + t11581 - t11583 - t3376 - t3378 + t3381 + t3243 + t3247 + t3382 - t3383 - t3384 + t2926 - t2928 - t2936;
  t12877 = my_piecewise5(t58, 0, t61, 0, t12746 + t12760 + t12786 + t12817 + t12847 + t12854 + t12872 + t12873);
  t12883 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.18e2 * t38 * t48 * t3258 - 0.5e1 / 0.81e2 * t38 * t43 * t3395 + t53 * t12877));
  tv4sigmalapl30 = t8 * t12883;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t12892 = t228 * t10232 * t265;
  t12895 = t9229 * t265;
  t12899 = t11168 * t2608;
  t12914 = -0.6e1 * t11165 * t228 * t12895 - 0.12e2 * t11191 * t1497 * t12895 + 0.18e2 * t11196 * t548 * t12895 + 0.18e2 * t11157 * t12892 + 0.18e2 * t11157 * t12899 - 0.18e2 * t11160 * t12892 - 0.6e1 * t11172 * t12899 + 0.18e2 * t11191 * t5340 + t2962 - t2971 + t2981 - 0.8e1 * t3128 + t3405 + t3406;
  t12923 = -0.18e2 * t11172 * t11168 * t7895 + 0.18e2 * t10652 * t11185 + t12062 - t12064 + t12068 - t12070 - t12075 + t12082 + t12101 - t12103 + t12105 - 0.9e1 * t12530 + 0.9e1 * t12532 - 0.9e1 * t12536;
  t12925 = t4580 * t2608;
  t12931 = t4528 * t4571 * t265;
  t12934 = t4602 * t3302;
  t12948 = t4561 * t5383 * t265;
  t12951 = -0.7e1 * t11220 * t12925 - 0.7e1 * t11220 * t12931 - 0.18e2 * t11220 * t12934 + t11223 * t12925 + 0.6e1 * t11223 * t12934 - t11228 * t12925 - 0.6e1 * t11228 * t5407 + 0.6e1 * t11231 * t12925 + 0.18e2 * t11231 * t12931 + 0.6e1 * t11231 * t12934 + 0.12e2 * t11231 * t12948 - t12108 + t12114 + t12118;
  t12973 = t4602 * t878;
  t12978 = t3408 * t265;
  t12986 = -0.6e1 * t11228 * t4536 * t4590 * t265 - 0.6e1 * t1417 * t668 * t11252 + 0.3e1 * t220 * t12978 * t5370 - 0.11e2 * t11220 * t12973 + 0.7e1 * t11220 * t5447 + 0.11e2 * t11223 * t12973 - 0.7e1 * t11228 * t12931 - 0.12e2 * t11228 * t12948 + 0.18e2 * t5396 * t11256 + 0.11e2 * t5396 * t11267 - 0.18e2 * t5382 * t11279 - 0.3e1 * t11290 * t879 - 0.3e1 * t11290 * t889 - 0.6e1 * t5396 * t11328;
  t13011 = -0.12e2 * t3447 * t1428 * t4518 * t265 - 0.11e2 * t11220 * t5458 - 0.12e2 * t11231 * t5407 - 0.6e1 * t11231 * t5421 - 0.18e2 * t11301 * t5488 + 0.7e1 * t5396 * t11311 + 0.9e1 * t12600 - 0.9e1 * t12608 + 0.9e1 * t12612 - 0.6e1 * t12616 + 0.9e1 * t12624 - 0.3e1 * t12653 + 0.9e1 * t12654 - 0.3e1 * t12656;
  t13016 = 0.9e1 * t12657 + 0.9e1 * t12659 - 0.9e1 * t12661 + 0.9e1 * t12663 + t12186 - t12188 - t12191 - t12197 - t12201 - t12207 - t828 - t932 + t3283 - t3287;
  t13034 = 0.6e1 * t11223 * t4602 * t884 + 0.3e1 * t538 * t12978 * t4487 + 0.11e2 * t11220 * t5566 + t5396 * t11356 + 0.6e1 * t5382 * t11360 + 0.3e1 * t11366 * t885 - t11710 - t11775 + t11778 + t11793 - 0.9e1 * t12701 - 0.3e1 * t12703 - 0.6e1 * t12705 - t3290;
  t13035 = t11796 - t11798 - t3412 + t3416 - t3418 + t3318 + t3322 - t3419 - t3420 + t3421 + t3002 - t3004 - t3012 + t3446 + t3449;
  t13039 = my_piecewise5(t104, 0, t105, 0, t12914 + t12923 + t12951 + t12986 + t13011 + t13016 + t13034 + t13035);
  t13045 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (0.5e1 / 0.18e2 * t38 * t98 * t3329 - 0.5e1 / 0.81e2 * t38 * t93 * t3461 + t103 * t13039));
  tv4sigmalapl311 = t8 * t13045;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t13057 = t902 * t902;
  t13058 = t13057 * t383;
  t13059 = t151 * t13058;
  t13066 = t13057 * t362;
  t13067 = t1042 * t13066;
  t13073 = t359 * t13066;
  t13089 = -0.6e1 * t151 * t13066 * t3534 - 0.6e1 * t13067 * t3534 + 0.18e2 * t13067 * t3542 - 0.18e2 * t13067 * t3547 + 0.18e2 * t13067 * t3566 - 0.12e2 * t13067 * t3594 + 0.18e2 * t13073 * t3534 + 0.18e2 * t13073 * t3547 - 0.18e2 * t12373 + 0.18e2 * t12377 - 0.12e2 * t12381;
  t13101 = t13057 * t3624;
  t13102 = t1042 * t13101;
  t13105 = t3640 * t13101;
  t13107 = t151 * t13101;
  t13110 = t359 * t13101;
  t13124 = 0.18e2 * t13102 * t3673 + 0.12e2 * t13102 * t3685 + 0.6e1 * t13102 * t3770 - 0.6e1 * t13105 * t3754 - t13105 * t3770 + 0.6e1 * t13107 * t3763 + t13107 * t3770 - 0.7e1 * t13110 * t3673 - 0.18e2 * t13110 * t3763 - 0.7e1 * t13110 * t3770 - t801;
  t13133 = t13057 * t3615;
  t13137 = t359 * t13133;
  t13173 = -0.6e1 * t13067 * t3724 - 0.18e2 * t13073 * t3655 + 0.6e1 * t13102 * t3763 + 0.18e2 * t13105 * t3681 - 0.12e2 * t13105 * t3685 + 0.11e2 * t13105 * t3690 - 0.6e1 * t13105 * t3694 - 0.6e1 * t13105 * t3705 + 0.7e1 * t13110 * t3661 - 0.11e2 * t13110 * t3732 - 0.3e1 * t13137 * t376;
  t13178 = t151 * t13057;
  t13181 = t359 * t13057;
  t13200 = 0.6e1 * t1042 * t13057 * t3632 + t3640 * t13057 * t3646 + t11578 + t11581 - t11583 + 0.4e1 * t3069 - 0.4e1 * t3082 - 0.4e1 * t3087 - 0.4e1 * t3375 - 0.4e1 * t3377 + 0.4e1 * t3380;
  t13204 = my_piecewise5(t58, 0, t61, 0, -t11512 + t11510 - t11507 - t909 - 0.9e1 * t3040 + 0.4e1 * t3035 + 0.4e1 * t3036 + 0.18e2 * t359 * t13058 * t3520 + 0.3e1 * t151 * t13133 * t376 + 0.6e1 * t13178 * t3628 + 0.3e1 * t13181 * t3617 + 0.3e1 * t13178 * t3621 + 0.11e2 * t13181 * t3652 - 0.12e2 * t13059 * t3746 + 0.11e2 * t13107 * t3732 - 0.18e2 * t13102 * t3661 + 0.7e1 * t13105 * t3668 - 0.7e1 * t13105 * t3673 - 0.3e1 * t13137 * t393 - 0.6e1 * t13102 * t3681 - 0.12e2 * t13102 * t3754 - 0.11e2 * t13110 * t3668 - 0.18e2 * t13059 * t3520 + 0.18e2 * t12311 - 0.18e2 * t12306 - 0.18e2 * t12302 + t13200 + t13173 - 0.12e2 * t12477 - 0.18e2 * t12472 - 0.6e1 * t12474 + 0.4e1 * t3357 + 0.18e2 * t12437 - 0.18e2 * t12432 - 0.6e1 * t12434 + 0.18e2 * t12428 + 0.18e2 * t12430 + 0.18e2 * t12423 - 0.6e1 * t12425 + 0.18e2 * t12426 + t13124 + t13089 + 0.18e2 * t12389 + 0.4e1 * t3353);
  t13210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.1e2 / 0.27e2 * t38 * t48 * t3395 + t53 * t13204));
  tv4lapl40 = t8 * t13210;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t13217 = t925 * t925;
  t13218 = t13217 * t562;
  t13219 = t220 * t13218;
  t13222 = t13217 * t541;
  t13226 = t538 * t13218;
  t13229 = t1417 * t13218;
  t13236 = t1417 * t13222;
  t13245 = t538 * t13222;
  t13255 = 0.18e2 * t13226 * t4392 - 0.18e2 * t13229 * t5316 - 0.12e2 * t13236 * t4377 + 0.18e2 * t13236 * t4400 + 0.18e2 * t13236 * t4412 + 0.18e2 * t13245 * t4405 + 0.18e2 * t12600 - 0.18e2 * t12608 + 0.18e2 * t12612 - 0.12e2 * t12616 + 0.18e2 * t12624;
  t13264 = t13217 * t4479;
  t13265 = t4505 * t13264;
  t13269 = t220 * t13264;
  t13271 = t538 * t13264;
  t13278 = t1417 * t13264;
  t13292 = -0.6e1 * t13265 * t4562 - t13265 * t4634 + 0.6e1 * t13269 * t4624 + t13269 * t4634 - 0.7e1 * t13271 * t4572 - 0.18e2 * t13271 * t4624 - 0.7e1 * t13271 * t4634 + 0.18e2 * t13278 * t4572 + 0.12e2 * t13278 * t4581 + 0.6e1 * t13278 * t4624 + 0.6e1 * t13278 * t4634;
  t13307 = t13217 * t4474;
  t13311 = t538 * t13307;
  t13339 = -0.12e2 * t13219 * t4519 - 0.6e1 * t13236 * t4554 - 0.18e2 * t13245 * t4606 + 0.7e1 * t13265 * t4568 + 0.11e2 * t13269 * t4603 + 0.7e1 * t13271 * t4529 - 0.11e2 * t13271 * t4568 - 0.12e2 * t13278 * t4562 - 0.6e1 * t13278 * t4565 - 0.18e2 * t12701 - 0.6e1 * t12703;
  t13342 = t538 * t13217;
  t13345 = t220 * t13217;
  t13366 = t11793 + t11796 - t11798 - 0.4e1 * t3411 + 0.4e1 * t3415 - 0.4e1 * t3417 - 0.4e1 * t3160 - 0.4e1 * t3168 + 0.4e1 * t3175 + 0.4e1 * t3445 + 0.4e1 * t3448;
  t13370 = my_piecewise5(t104, 0, t105, 0, -t11775 + t11778 - t11710 - t932 - t828 - 0.9e1 * t3128 + 0.4e1 * t3123 + 0.4e1 * t3124 + 0.11e2 * t13342 * t4490 + 0.3e1 * t13345 * t4476 + 0.6e1 * t13345 * t4483 + 0.3e1 * t13342 * t4487 - 0.6e1 * t13265 * t4538 - 0.3e1 * t13311 * t572 - 0.3e1 * t13311 * t555 - 0.11e2 * t13271 * t4603 - 0.18e2 * t13278 * t4529 + 0.18e2 * t13265 * t4565 - 0.12e2 * t13265 * t4581 + 0.11e2 * t13265 * t4587 - 0.6e1 * t13265 * t4591 - 0.7e1 * t13265 * t4572 - 0.18e2 * t13219 * t4392 + 0.18e2 * t13226 * t5277 - 0.6e1 * t13229 * t5277 - 0.6e1 * t220 * t13222 * t4416 + 0.3e1 * t220 * t13307 * t555 + 0.6e1 * t1417 * t13217 * t4494 + t4505 * t13217 * t4511 - 0.12e2 * t12705 + t13366 + t13339 + 0.18e2 * t12663 + 0.18e2 * t12659 - 0.18e2 * t12661 + 0.18e2 * t12654 - 0.6e1 * t12656 + 0.18e2 * t12657 - 0.6e1 * t12653 + t13292 + t13255 - 0.18e2 * t12536 - 0.18e2 * t12530 + 0.18e2 * t12532);
  t13376 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (0.1e2 / 0.27e2 * t38 * t98 * t3461 + t103 * t13370));
  tv4lapl44 = t8 * t13376;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

