/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.notifications.filter;

import java.util.List;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.notifications.center.NotificationCenterManager;
import org.netbeans.modules.notifications.checklist.CheckList;
import org.openide.awt.NotificationDisplayer.Category;

/**
 *
 * @author sa154850
 */
final class CateogoriesPanel extends JPanel {

    private CheckList lstTypes;
    private List<Category> categories;
    private boolean[] categoryState;
    private CategoryFilter filter;

    public CateogoriesPanel(CategoryFilter filter) {
        this.filter = filter;
        init();
        if ("Metal".equals(UIManager.getLookAndFeel().getID())) //NOI18N
        {
            setOpaque(true);
        } else {
            setOpaque(false);
        }
    }

    public boolean isValueValid() {
        return true;
    }

    private void init() {
        initComponents();

        categories = NotificationCenterManager.getInstance().getCategories();
        categoryState = new boolean[categories.size()];

        String[] names = new String[categories.size()];
        for (int i = 0; i < names.length; i++) {
            names[i] = categories.get(i).getDisplayName();
        }
        String[] descs = new String[categories.size()];
        for (int i = 0; i < descs.length; i++) {
            descs[i] = categories.get(i).getDescription();
        }

        lstTypes = new CheckList(categoryState, names, descs);
        lstTypes.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        lstTypes.getModel().addListDataListener(new ListDataListener() {
            @Override
            public void intervalAdded(ListDataEvent arg0) {
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
            }

            @Override
            public void contentsChanged(ListDataEvent arg0) {
                putClientProperty(FilterEditor.PROP_VALUE_VALID, isValueValid());
            }
        });
        scrollTypes.setViewportView(lstTypes);
        showFilter(filter);
    }

    private void showFilter(CategoryFilter filter) {
        for (int i = 0; i < categoryState.length; i++) {
            Category category = categories.get(i);
            categoryState[i] = null != filter && filter.isEnabled(category.getName());
        }
        lstTypes.setEnabled(null != filter);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollTypes = new javax.swing.JScrollPane();

        setOpaque(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(scrollTypes, javax.swing.GroupLayout.DEFAULT_SIZE, 442, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(scrollTypes, javax.swing.GroupLayout.DEFAULT_SIZE, 181, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane scrollTypes;
    // End of variables declaration//GEN-END:variables

    public CategoryFilter getFilter() {
        if (filter != null) {
            for (int i = 0; i < categoryState.length; i++) {
                Category category = categories.get(i);
                filter.setEnabled(category.getName(), categoryState[i]);
            }
        }
        return filter;
    }
}
