/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicNamingEnumeration;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttributes
implements Attributes {
    static final long serialVersionUID = 4980164073184639448L;
    private boolean ignoreCase;
    private transient Hashtable<String, Attribute> attrMap = new Hashtable();

    public BasicAttributes() {
        this(false);
    }

    public BasicAttributes(boolean flag) {
        this.ignoreCase = flag;
    }

    public BasicAttributes(String attrId, Object attrObj) {
        this(attrId, attrObj, false);
    }

    public BasicAttributes(String attrId, Object attrObj, boolean flag) {
        this.ignoreCase = flag;
        this.attrMap.put(this.convertId(attrId), new BasicAttribute(attrId, attrObj));
    }

    private String convertId(String id) {
        return this.ignoreCase ? id.toLowerCase() : id;
    }

    @Override
    public Attribute get(String id) {
        return this.attrMap.get(this.convertId(id));
    }

    public NamingEnumeration<Attribute> getAll() {
        return new BasicNamingEnumeration<Attribute>(this.attrMap.elements());
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        if (this.ignoreCase) {
            Enumeration<Attribute> e = this.attrMap.elements();
            Vector<String> v = new Vector<String>(this.attrMap.size());
            while (e.hasMoreElements()) {
                v.add(e.nextElement().getID());
            }
            return new BasicNamingEnumeration<String>(v.elements());
        }
        return new BasicNamingEnumeration<String>(this.attrMap.keys());
    }

    @Override
    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    @Override
    public Attribute put(Attribute attribute) {
        String id = this.convertId(attribute.getID());
        return this.attrMap.put(id, attribute);
    }

    @Override
    public Attribute put(String id, Object obj) {
        return this.put(new BasicAttribute(id, obj));
    }

    @Override
    public Attribute remove(String id) {
        return this.attrMap.remove(this.convertId(id));
    }

    @Override
    public int size() {
        return this.attrMap.size();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int size = ois.readInt();
        this.attrMap = new Hashtable();
        int i = 0;
        while (i < size) {
            BasicAttribute attr = (BasicAttribute)ois.readObject();
            this.attrMap.put(this.convertId(attr.getID()), attr);
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.attrMap.size());
        Enumeration<Attribute> enumeration = this.attrMap.elements();
        while (enumeration.hasMoreElements()) {
            oos.writeObject(enumeration.nextElement());
        }
    }

    @Override
    public Object clone() {
        try {
            BasicAttributes c = (BasicAttributes)super.clone();
            c.attrMap = (Hashtable)this.attrMap.clone();
            return c;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)Messages.getString("jndi.15"));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Attributes)) {
            return false;
        }
        Attributes o = (Attributes)obj;
        if (this.isCaseIgnored() != o.isCaseIgnored() || this.size() != o.size()) {
            return false;
        }
        for (Map.Entry<String, Attribute> e : this.attrMap.entrySet()) {
            if (e.getValue().equals(o.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        Enumeration<Attribute> e = this.attrMap.elements();
        int i = this.ignoreCase ? 1 : 0;
        while (e.hasMoreElements()) {
            i += e.nextElement().hashCode();
        }
        return i;
    }

    public String toString() {
        String s = null;
        Iterator<Map.Entry<String, Attribute>> it = this.attrMap.entrySet().iterator();
        Map.Entry<String, Attribute> e = null;
        if (it.hasNext()) {
            e = it.next();
            s = "{\n";
            s = String.valueOf(s) + e.getKey();
            s = String.valueOf(s) + "=" + e.getValue().toString();
            while (it.hasNext()) {
                e = it.next();
                s = String.valueOf(s) + "; ";
                s = String.valueOf(s) + e.getKey();
                s = String.valueOf(s) + "=" + e.getValue().toString();
            }
            s = String.valueOf(s) + "}\n";
        } else {
            s = "This Attributes does not have any attributes.\n";
        }
        return s;
    }
}

