---
stage: Application Security Testing
group: Composition Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Continuous Vulnerability Scanning

DETAILS:
**Tier:** Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

> - Continuous dependency scanning [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/371063) with [feature flags](../../../administration/feature_flags.md) `dependency_scanning_on_advisory_ingestion` and `package_metadata_advisory_scans` enabled by default.
> - [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/425753) in GitLab 16.10. Feature flags `dependency_scanning_on_advisory_ingestion` and `package_metadata_advisory_scans` removed.
> - Continuous container scanning [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/435435) in GitLab 16.8 [with a flag](../../../administration/feature_flags.md) named `container_scanning_continuous_vulnerability_scans`. Disabled by default.
> - Continuous container scanning [enabled on self-managed, and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/issues/437162) in GitLab 16.10.
> - [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/443712) in GitLab 17.0. Feature flag `container_scanning_continuous_vulnerability_scans` removed.
> - CVS triggering on new components, for container scanning and dependency scanning, [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/464575) in GitLab 17.3 [with a flag](../../../administration/feature_flags.md) named `dependency_scanning_using_sbom_reports`. Disabled by default.
> - CVS triggering on new components, for container scanning, [introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165368) in GitLab 17.4 [with a flag](../../../administration/feature_flags.md) named `cvs_for_container_scanning`. Disabled by default.
> - CVS triggering on new components, for dependency scanning only, [enabled on self-managed, and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/issues/395692) in 17.5.

Continuous Vulnerability Scanning looks for security vulnerabilities in your project's dependencies by comparing their component names and versions against information in the latest [security advisories](#security-advisories).

When [security advisories](#security-advisories) are added or updated, Continuous Vulnerability Scanning triggers a scan on all projects where components with [supported package types](#supported-package-types) exist. If an advisory affects a dependency, Continuous Vulnerability Scanning creates a vulnerability in the project.

Vulnerabilities created by Continuous Vulnerability Scanning use `GitLab SBoM Vulnerability Scanner` as the scanner name.

In contrast to CI-based security scans, Continuous Vulnerability Scanning is executed through background jobs (Sidekiq) rather than CI pipelines and no Security report artifacts are generated.

## Prerequisites

- A project with dependencies [supported](#supported-package-types) by Continuous Vulnerability Scanning. See [how to generate a CycloneDX SBOM report](#how-to-generate-a-cyclonedx-sbom-report).
- [Security advisories](#security-advisories) synchronized to the GitLab instance.

NOTE:
If a new component is detected and an advisory for it already exists, a vulnerability is **only** created if either of the following are true:

- The component is generated from [dependency scanning related reports](../dependency_scanning/index.md#cyclonedx-software-bill-of-materials).
- The [feature flag](../../../administration/feature_flags.md) `cvs_for_container_scanning` is enabled, and the component is generated from [container scanning related reports](../container_scanning/index.md#cyclonedx-software-bill-of-materials).

Support for this feature can be tracked in [epic 8026](https://gitlab.com/groups/gitlab-org/-/epics/8026).

## Supported package types

Continuous Vulnerability Scanning supports components with the following [PURL types](https://github.com/package-url/purl-spec/blob/346589846130317464b677bc4eab30bf5040183a/PURL-TYPES.rst):

- `composer`
- `conan`
- `deb`
- `gem`
- `golang`
- `maven`
- `npm`
- `nuget`
- `pypi`
- `rpm`
- `apk`

Go pseudo versions are not supported. A project dependency that references a Go pseudo version is
never considered as affected because this might result in false negatives.

RPM versions containing `^` are not supported. Work to support these versions is tracked in [issue 459969](https://gitlab.com/gitlab-org/gitlab/-/issues/459969).
APK versions containing leading zeros are not supported. Work to support these versions is tracked in [issue 471509](https://gitlab.com/gitlab-org/gitlab/-/issues/471509).

RPM packages in Red Hat distributions are not supported. Work to support this use case is tracked in [epic 12980](https://gitlab.com/groups/gitlab-org/-/epics/12980).

## How to generate a CycloneDX SBOM report

Use a [CycloneDX SBOM report](../../../ci/yaml/artifacts_reports.md#artifactsreportscyclonedx) to register your project components with GitLab.

GitLab offers security analyzers that can generate a report [compatible](../../../development/sec/cyclonedx_property_taxonomy.md) with GitLab:

- [Container Scanning](../container_scanning/index.md#configuration)
- [Container Scanning For Registry](../container_scanning/index.md#container-scanning-for-registry)
- [Dependency Scanning](../dependency_scanning/index.md#configuration)
- [Dependency Scanning CI/CD Component](https://gitlab.com/explore/catalog/components/dependency-scanning) (experimental)

## Checking new vulnerabilities

New vulnerabilities detected by Continuous Vulnerability Scanning are visible on the [Vulnerability Report](../vulnerability_report/index.md).
However, they are not listed on the [Dependency List](../dependency_list/index.md) or in the pipeline where the affected SBOM component was detected.

After a security advisory is published, it might take a few hours before the corresponding vulnerabilities are added to your projects. Only advisories
published within the last 14 days are considered for Continuous Vulnerability Scanning.

## When vulnerabilities are no longer detected

Continuous Vulnerability Scanning automatically creates vulnerabilities when a new advisory is published
but it is not able to tell when a vulnerability is no longer present in the project. To do so, GitLab
still requires to have a [Container Scanning](../container_scanning/index.md) or a
[Dependency Scanning](../dependency_scanning/index.md) scan executed in a pipeline for the default branch,
and a corresponding security report artifact generated with the up to date information. When these reports
are processed, and when they no longer contain some vulnerabilities, these are flagged as such even if
they were created by Continuous Vulnerability Scanning. This behavior has been introduced in 17.1 with
[issue 441490](https://gitlab.com/gitlab-org/gitlab/-/issues/441490) and applies to scanners maintained
by GitLab (`Trivy`, `gemnasium`, `gemnasium-python`, `gemnasium-maven`).

Improvements to this behavior, including requiring only to have a updated SBOM uploaded, are planned in [epic 8026](https://gitlab.com/groups/gitlab-org/-/epics/8026).

## Security advisories

Continuous Vulnerability Scanning uses the Package Metadata Database, a service managed by GitLab which aggregates license and security advisory data, and regularly publishes updates that are used by GitLab.com and self-managed instances.

On GitLab.com, the synchronization is managed by GitLab and is available to all projects.

On GitLab self-managed, you can [choose package registry metadata to synchronize](../../../administration/settings/security_and_compliance.md#choose-package-registry-metadata-to-sync) in the **Admin** area for the GitLab instance.

### Data sources

Current data sources for security advisories include:

- [GitLab Advisory Database](https://advisories.gitlab.com/)
- [Trivy DB](https://github.com/aquasecurity/trivy-db)

### Contributing to the vulnerability database

To find a vulnerability, you can search the [`GitLab Advisory Database`](https://advisories.gitlab.com/).
You can also [submit new vulnerabilities](https://gitlab.com/gitlab-org/security-products/gemnasium-db/blob/master/CONTRIBUTING.md).
