/*-------------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported to C++ by Csaba Balazs, University of Szeged
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the 
Free Software Foundation; either version 2, or (at your option) any 
later version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
for more details.

You should have received a copy of the GNU General Public License along 
with this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than 
Coco/R itself) does not fall under the GNU General Public License.
-------------------------------------------------------------------------*/

#include "Node.h"

namespace Coco {

// constants for node kinds
int Node::t    =  1;  // terminal symbol
int Node::pr   =  2;  // pragma
int Node::nt   =  3;  // nonterminal symbol
int Node::clas =  4;  // character class
int Node::chr  =  5;  // character
int Node::wt   =  6;  // weak terminal symbol
int Node::any  =  7;  // 
int Node::eps  =  8;  // empty
int Node::sync =  9;  // synchronization symbol
int Node::sem  = 10;  // semantic action: (. .)
int Node::alt  = 11;  // alternative: |
int Node::iter = 12;  // iteration: { }
int Node::opt  = 13;  // option: [ ]
int Node::rslv = 14;  // resolver expr

int Node::normalTrans  = 0;		// transition codes
int Node::contextTrans = 1;


Node::Node(int typ, Symbol *sym, int line) {
	this->n     = 0;
	this->next  = NULL;
	this->down  = NULL;
	this->sub   = NULL;
	this->up    = false;
	this->val   = 0;
	this->code  = 0;
	this->set   = NULL;
	this->pos   = NULL;
	this->state = NULL;
	this->state = 0;

	this->typ = typ; this->sym = sym; this->line = line;
}

}; // namespace
