;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; NOTE: This test was ported using port_passes_tests_to_lit.py and could be cleaned up.

;; RUN: foreach %s %t wasm-opt --coalesce-locals-learning -S -o - | filecheck %s

(module
  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (type $FUNCSIG$iii (func (param i32 i32) (result i32)))

  ;; CHECK:      (type $3 (func (param i32 f32)))

  ;; CHECK:      (type $FUNCSIG$iiii (func (param i32 i32 i32) (result i32)))
  (type $FUNCSIG$iiii (func (param i32 i32 i32) (result i32)))
  (type $FUNCSIG$iii (func (param i32 i32) (result i32)))
  (type $2 (func))
  (type $3 (func (param i32 f32)))
  ;; CHECK:      (type $4 (func (param i32)))
  (type $4 (func (param i32)))

  ;; CHECK:      (import "env" "_emscripten_autodebug_i32" (func $_emscripten_autodebug_i32 (param i32 i32) (result i32)))
  (import "env" "_emscripten_autodebug_i32" (func $_emscripten_autodebug_i32 (param i32 i32) (result i32)))

  (memory 10)

  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $nothing-to-do
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $nothing-to-do (type $2)
    (local $x i32)
    (nop)
  )
  ;; CHECK:      (func $merge
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $merge (type $2)
    (local $x i32)
    (local $y i32)
    (nop)
  )
  ;; CHECK:      (func $leave-type
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 f32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $leave-type (type $2)
    (local $x i32)
    (local $y f32)
    (nop)
  )
  ;; CHECK:      (func $leave-interfere
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $leave-interfere (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (local.set $y
      (i32.const 1)
    )
    (drop
      (local.get $x)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $almost-interfere
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $almost-interfere (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (drop
      (local.get $x)
    )
    (local.set $y
      (i32.const 0)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $redundant-copy
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $redundant-copy (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (local.set $y
      (local.get $x)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $ineffective-store
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $ineffective-store (type $2)
    (local $x i32)
    (local.set $x
      (i32.const 0)
    )
    (local.set $x
      (i32.const 0)
    )
    (drop
      (local.get $x)
    )
  )
  ;; CHECK:      (func $block
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:   (local.set $0
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $block (type $2)
    (local $x i32)
    (block $block0
      (local.set $x
        (i32.const 0)
      )
    )
    (drop
      (local.get $x)
    )
  )
  ;; CHECK:      (func $see-both-sides
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:   (local.set $1
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $see-both-sides (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (block $block0
      (local.set $y
        (i32.const 1)
      )
    )
    (drop
      (local.get $x)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $see-br-and-ignore-dead
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (br $block)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const -1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $see-br-and-ignore-dead (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (block $block
      (br $block)
      (local.set $y
        (i32.const 0)
      )
      (drop
        (local.get $y)
      )
      (local.set $x
        (i32.const -1)
      )
    )
    (drop
      (local.get $x)
    )
  )
  ;; CHECK:      (func $see-block-body
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (local.set $1
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (br $block)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $see-block-body (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (block $block
      (local.set $y
        (i32.const 1)
      )
      (drop
        (local.get $y)
      )
      (br $block)
    )
    (drop
      (local.get $x)
    )
  )
  ;; CHECK:      (func $zero-init
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero-init (type $2)
    (local $x i32)
    (local $y i32)
    (drop
      (local.get $x)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $multi
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $multi (type $2)
    (local $x i32)
    (local $y i32)
    (local $z i32)
    (drop
      (local.get $y)
    )
    (drop
      (local.get $z)
    )
  )
  ;; CHECK:      (func $if-else
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-else (type $2)
    (local $x i32)
    (local $y i32)
    (if
      (i32.const 0)
      (then
        (drop
          (local.get $x)
        )
      )
      (else
        (drop
          (local.get $y)
        )
      )
    )
  )
  ;; CHECK:      (func $if-else-parallel
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (block $block1
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (block $block3
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-else-parallel (type $2)
    (local $x i32)
    (local $y i32)
    (if
      (i32.const 0)
      (then
        (block $block1
          (local.set $x
            (i32.const 0)
          )
          (drop
            (local.get $x)
          )
        )
      )
      (else
        (block $block3
          (local.set $y
            (i32.const 1)
          )
          (drop
            (local.get $y)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $if-else-after
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (local.set $0
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (local.set $1
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-else-after (type $2)
    (local $x i32)
    (local $y i32)
    (if
      (i32.const 0)
      (then
        (local.set $x
          (i32.const 0)
        )
      )
      (else
        (local.set $y
          (i32.const 1)
        )
      )
    )
    (drop
      (local.get $x)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $if-else-through
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-else-through (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (local.set $y
      (i32.const 1)
    )
    (if
      (i32.const 0)
      (then
        (drop
          (i32.const 1)
        )
      )
      (else
        (drop
          (i32.const 2)
        )
      )
    )
    (drop
      (local.get $x)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $if-through
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-through (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (local.set $y
      (i32.const 1)
    )
    (if
      (i32.const 0)
      (then
        (drop
          (i32.const 1)
        )
      )
    )
    (drop
      (local.get $x)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $if-through2
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (local.set $1
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-through2 (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 0)
    )
    (if
      (i32.const 0)
      (then
        (local.set $y
          (i32.const 1)
        )
      )
    )
    (drop
      (local.get $x)
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $if-through3
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (block $block1
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-through3 (type $2)
    (local $x i32)
    (local $y i32)
    (local.set $x
      (i32.const 1)
    )
    (if
      (i32.const 0)
      (then
        (block $block1
          (drop
            (local.get $x)
          )
          (drop
            (local.get $y)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $if2
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (local.tee $0
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (block $block1
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if2 (type $2)
    (local $x i32)
    (local $y i32)
    (if
      (local.tee $x
        (i32.const 1)
      )
      (then
        (block $block1
          (drop
            (local.get $x)
          )
          (drop
            (local.get $y)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $if3
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (block $block1
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if3 (type $2)
    (local $x i32)
    (local $y i32)
    (if
      (i32.const 0)
      (then
        (block $block1
          (local.set $x
            (i32.const 0)
          )
          (drop
            (local.get $x)
          )
        )
      )
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $if4
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (block $block1
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if4 (type $2)
    (local $x i32)
    (local $y i32)
    (if
      (i32.const 0)
      (then
        (block $block1
          (local.set $x
            (i32.const 0)
          )
          (drop
            (local.get $x)
          )
          (local.set $y
            (i32.const 1)
          )
        )
      )
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $if5
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (block $block1
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if5 (type $2)
    (local $x i32)
    (local $y i32)
    (if
      (i32.const 0)
      (then
        (block $block1
          (drop
            (local.get $x)
          )
          (local.set $y
            (i32.const 1)
          )
        )
      )
    )
    (drop
      (local.get $y)
    )
  )
  ;; CHECK:      (func $loop
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (loop $in
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $0
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br $in)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop (type $2)
    (local $x i32)
    (local $y i32)
    (block $out
      (loop $in
        (drop
          (local.get $x)
        )
        (local.set $x
          (i32.const 0)
        )
        (drop
          (local.get $y)
        )
        (br $in)
      )
    )
  )
  ;; CHECK:      (func $interfere-in-dead
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (br $block)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $interfere-in-dead (type $2)
    (local $x i32)
    (local $y i32)
    (block $block
      (br $block)
      (drop
        (local.get $x)
      )
      (drop
        (local.get $y)
      )
    )
  )
  ;; CHECK:      (func $interfere-in-dead2
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $interfere-in-dead2 (type $2)
    (local $x i32)
    (local $y i32)
    (block $block
      (unreachable)
      (drop
        (local.get $x)
      )
      (drop
        (local.get $y)
      )
    )
  )
  ;; CHECK:      (func $interfere-in-dead3
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (return)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $interfere-in-dead3 (type $2)
    (local $x i32)
    (local $y i32)
    (block $block
      (return)
      (drop
        (local.get $x)
      )
      (drop
        (local.get $y)
      )
    )
  )
  ;; CHECK:      (func $params (param $0 i32) (param $1 f32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $params (type $3) (param $p i32) (param $q f32)
    (local $x i32)
    (local $y i32)
    (local $z i32)
    (local $w i32)
    (drop
      (local.get $y)
    )
    (drop
      (local.get $z)
    )
    (drop
      (local.get $w)
    )
  )
  ;; CHECK:      (func $interfere-in-dead4
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (br_if $block
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $interfere-in-dead4 (type $2)
    (local $x i32)
    (local $y i32)
    (block $block
      (br_if $block
        (i32.const 0)
      )
      (drop
        (local.get $x)
      )
      (drop
        (local.get $y)
      )
    )
  )
  ;; CHECK:      (func $switch
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (block $switch$def
  ;; CHECK-NEXT:   (block $switch-case$1
  ;; CHECK-NEXT:    (block $switch-case$2
  ;; CHECK-NEXT:     (br_table $switch-case$1 $switch-case$2 $switch-case$1 $switch-case$1 $switch$def
  ;; CHECK-NEXT:      (i32.const 100)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $switch (type $2)
    (local $x i32)
    (local $y i32)
    (local $z i32)
    (local $w i32)
    (block $switch$def
      (block $switch-case$1
        (block $switch-case$2
          (br_table $switch-case$1 $switch-case$2 $switch-case$1 $switch-case$1 $switch$def
            (i32.const 100)
          )
          (drop
            (local.get $x)
          )
        )
        (drop
          (local.get $y)
        )
      )
      (drop
        (local.get $z)
      )
    )
    (drop
      (local.get $w)
    )
  )
  ;; CHECK:      (func $greedy-can-be-happy
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (if
  ;; CHECK-NEXT:       (i32.const 2)
  ;; CHECK-NEXT:       (then
  ;; CHECK-NEXT:        (block $block3
  ;; CHECK-NEXT:         (local.set $0
  ;; CHECK-NEXT:          (i32.const 100)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (local.set $1
  ;; CHECK-NEXT:          (i32.const 101)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (else
  ;; CHECK-NEXT:        (block $block5
  ;; CHECK-NEXT:         (local.set $0
  ;; CHECK-NEXT:          (i32.const 102)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (local.set $1
  ;; CHECK-NEXT:          (i32.const 103)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (if
  ;; CHECK-NEXT:       (i32.const 3)
  ;; CHECK-NEXT:       (then
  ;; CHECK-NEXT:        (block $block8
  ;; CHECK-NEXT:         (local.set $0
  ;; CHECK-NEXT:          (i32.const 104)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (local.set $1
  ;; CHECK-NEXT:          (i32.const 105)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (else
  ;; CHECK-NEXT:        (block $block10
  ;; CHECK-NEXT:         (local.set $0
  ;; CHECK-NEXT:          (i32.const 106)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (local.set $1
  ;; CHECK-NEXT:          (i32.const 107)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (i32.const 4)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (block $block13
  ;; CHECK-NEXT:       (local.set $0
  ;; CHECK-NEXT:        (i32.const 108)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $1
  ;; CHECK-NEXT:        (i32.const 109)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (drop
  ;; CHECK-NEXT:        (local.get $0)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (drop
  ;; CHECK-NEXT:        (local.get $1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (block $block15
  ;; CHECK-NEXT:       (local.set $0
  ;; CHECK-NEXT:        (i32.const 110)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $1
  ;; CHECK-NEXT:        (i32.const 111)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (drop
  ;; CHECK-NEXT:        (local.get $0)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (drop
  ;; CHECK-NEXT:        (local.get $1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $greedy-can-be-happy (type $2)
    (local $x1 i32)
    (local $x2 i32)
    (local $x3 i32)
    (local $y1 i32)
    (local $y2 i32)
    (local $y3 i32)
    (if
      (i32.const 0)
      (then
        (if
          (i32.const 1)
          (then
            (if
              (i32.const 2)
              (then
                (block $block3
                  (local.set $x1
                    (i32.const 100)
                  )
                  (local.set $y2
                    (i32.const 101)
                  )
                  (drop
                    (local.get $x1)
                  )
                  (drop
                    (local.get $y2)
                  )
                )
              )
              (else
                (block $block5
                  (local.set $x1
                    (i32.const 102)
                  )
                  (local.set $y3
                    (i32.const 103)
                  )
                  (drop
                    (local.get $x1)
                  )
                  (drop
                    (local.get $y3)
                  )
                )
              )
            )
          )
          (else
            (if
              (i32.const 3)
              (then
                (block $block8
                  (local.set $x2
                    (i32.const 104)
                  )
                  (local.set $y1
                    (i32.const 105)
                  )
                  (drop
                    (local.get $x2)
                  )
                  (drop
                    (local.get $y1)
                  )
                )
              )
              (else
                (block $block10
                  (local.set $x2
                    (i32.const 106)
                  )
                  (local.set $y3
                    (i32.const 107)
                  )
                  (drop
                    (local.get $x2)
                  )
                  (drop
                    (local.get $y3)
                  )
                )
              )
            )
          )
        )
      )
      (else
        (if
          (i32.const 4)
          (then
            (block $block13
              (local.set $x3
                (i32.const 108)
              )
              (local.set $y1
                (i32.const 109)
              )
              (drop
                (local.get $x3)
              )
              (drop
                (local.get $y1)
              )
            )
          )
          (else
            (block $block15
              (local.set $x3
                (i32.const 110)
              )
              (local.set $y2
                (i32.const 111)
              )
              (drop
                (local.get $x3)
              )
              (drop
                (local.get $y2)
              )
            )
          )
        )
      )
    )
  )
  ;; CHECK:      (func $greedy-can-be-sad
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (if
  ;; CHECK-NEXT:       (i32.const 2)
  ;; CHECK-NEXT:       (then
  ;; CHECK-NEXT:        (block $block3
  ;; CHECK-NEXT:         (local.set $0
  ;; CHECK-NEXT:          (i32.const 100)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (local.set $1
  ;; CHECK-NEXT:          (i32.const 101)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (else
  ;; CHECK-NEXT:        (block $block5
  ;; CHECK-NEXT:         (local.set $0
  ;; CHECK-NEXT:          (i32.const 102)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (local.set $1
  ;; CHECK-NEXT:          (i32.const 103)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (if
  ;; CHECK-NEXT:       (i32.const 3)
  ;; CHECK-NEXT:       (then
  ;; CHECK-NEXT:        (block $block8
  ;; CHECK-NEXT:         (local.set $0
  ;; CHECK-NEXT:          (i32.const 104)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (local.set $1
  ;; CHECK-NEXT:          (i32.const 105)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (else
  ;; CHECK-NEXT:        (block $block10
  ;; CHECK-NEXT:         (local.set $0
  ;; CHECK-NEXT:          (i32.const 106)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (local.set $1
  ;; CHECK-NEXT:          (i32.const 107)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (drop
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (i32.const 4)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (block $block13
  ;; CHECK-NEXT:       (local.set $0
  ;; CHECK-NEXT:        (i32.const 108)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $1
  ;; CHECK-NEXT:        (i32.const 109)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (drop
  ;; CHECK-NEXT:        (local.get $0)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (drop
  ;; CHECK-NEXT:        (local.get $1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (block $block15
  ;; CHECK-NEXT:       (local.set $0
  ;; CHECK-NEXT:        (i32.const 110)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $1
  ;; CHECK-NEXT:        (i32.const 111)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (drop
  ;; CHECK-NEXT:        (local.get $0)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (drop
  ;; CHECK-NEXT:        (local.get $1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $greedy-can-be-sad (type $2)
    (local $x1 i32)
    (local $y1 i32)
    (local $x2 i32)
    (local $y2 i32)
    (local $x3 i32)
    (local $y3 i32)
    (if
      (i32.const 0)
      (then
        (if
          (i32.const 1)
          (then
            (if
              (i32.const 2)
              (then
                (block $block3
                  (local.set $x1
                    (i32.const 100)
                  )
                  (local.set $y2
                    (i32.const 101)
                  )
                  (drop
                    (local.get $x1)
                  )
                  (drop
                    (local.get $y2)
                  )
                )
              )
              (else
                (block $block5
                  (local.set $x1
                    (i32.const 102)
                  )
                  (local.set $y3
                    (i32.const 103)
                  )
                  (drop
                    (local.get $x1)
                  )
                  (drop
                    (local.get $y3)
                  )
                )
              )
            )
          )
          (else
            (if
              (i32.const 3)
              (then
                (block $block8
                  (local.set $x2
                    (i32.const 104)
                  )
                  (local.set $y1
                    (i32.const 105)
                  )
                  (drop
                    (local.get $x2)
                  )
                  (drop
                    (local.get $y1)
                  )
                )
              )
              (else
                (block $block10
                  (local.set $x2
                    (i32.const 106)
                  )
                  (local.set $y3
                    (i32.const 107)
                  )
                  (drop
                    (local.get $x2)
                  )
                  (drop
                    (local.get $y3)
                  )
                )
              )
            )
          )
        )
      )
      (else
        (if
          (i32.const 4)
          (then
            (block $block13
              (local.set $x3
                (i32.const 108)
              )
              (local.set $y1
                (i32.const 109)
              )
              (drop
                (local.get $x3)
              )
              (drop
                (local.get $y1)
              )
            )
          )
          (else
            (block $block15
              (local.set $x3
                (i32.const 110)
              )
              (local.set $y2
                (i32.const 111)
              )
              (drop
                (local.get $x3)
              )
              (drop
                (local.get $y2)
              )
            )
          )
        )
      )
    )
  )
  ;; CHECK:      (func $_memcpy (param $0 i32) (param $1 i32) (param $2 i32) (result i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.ge_s
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:    (i32.const 4096)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.eq
  ;; CHECK-NEXT:    (i32.and
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:     (i32.const 3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.and
  ;; CHECK-NEXT:     (local.get $1)
  ;; CHECK-NEXT:     (i32.const 3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (block $block2
  ;; CHECK-NEXT:     (block $while-out$0
  ;; CHECK-NEXT:      (loop $while-in$1
  ;; CHECK-NEXT:       (if
  ;; CHECK-NEXT:        (i32.eqz
  ;; CHECK-NEXT:         (i32.and
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:          (i32.const 3)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (then
  ;; CHECK-NEXT:         (br $while-out$0)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (block $block4
  ;; CHECK-NEXT:        (if
  ;; CHECK-NEXT:         (i32.eqz
  ;; CHECK-NEXT:          (local.get $2)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (then
  ;; CHECK-NEXT:          (return
  ;; CHECK-NEXT:           (local.get $3)
  ;; CHECK-NEXT:          )
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (i32.store8
  ;; CHECK-NEXT:         (local.get $0)
  ;; CHECK-NEXT:         (i32.load8_s
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (local.set $0
  ;; CHECK-NEXT:         (i32.add
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:          (i32.const 1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (local.set $1
  ;; CHECK-NEXT:         (i32.add
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:          (i32.const 1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (local.set $2
  ;; CHECK-NEXT:         (i32.sub
  ;; CHECK-NEXT:          (local.get $2)
  ;; CHECK-NEXT:          (i32.const 1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (br $while-in$1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (block $while-out$2
  ;; CHECK-NEXT:      (loop $while-in$3
  ;; CHECK-NEXT:       (if
  ;; CHECK-NEXT:        (i32.eqz
  ;; CHECK-NEXT:         (i32.ge_s
  ;; CHECK-NEXT:          (local.get $2)
  ;; CHECK-NEXT:          (i32.const 4)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (then
  ;; CHECK-NEXT:         (br $while-out$2)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (block $block7
  ;; CHECK-NEXT:        (i32.store
  ;; CHECK-NEXT:         (local.get $0)
  ;; CHECK-NEXT:         (i32.load
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (local.set $0
  ;; CHECK-NEXT:         (i32.add
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:          (i32.const 4)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (local.set $1
  ;; CHECK-NEXT:         (i32.add
  ;; CHECK-NEXT:          (local.get $1)
  ;; CHECK-NEXT:          (i32.const 4)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (local.set $2
  ;; CHECK-NEXT:         (i32.sub
  ;; CHECK-NEXT:          (local.get $2)
  ;; CHECK-NEXT:          (i32.const 4)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (br $while-in$3)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block $while-out$4
  ;; CHECK-NEXT:   (loop $while-in$5
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (i32.eqz
  ;; CHECK-NEXT:      (i32.gt_s
  ;; CHECK-NEXT:       (local.get $2)
  ;; CHECK-NEXT:       (i32.const 0)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (br $while-out$4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (block $block9
  ;; CHECK-NEXT:     (i32.store8
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:      (i32.load8_s
  ;; CHECK-NEXT:       (local.get $1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (i32.add
  ;; CHECK-NEXT:       (local.get $0)
  ;; CHECK-NEXT:       (i32.const 1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $1
  ;; CHECK-NEXT:      (i32.add
  ;; CHECK-NEXT:       (local.get $1)
  ;; CHECK-NEXT:       (i32.const 1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $2
  ;; CHECK-NEXT:      (i32.sub
  ;; CHECK-NEXT:       (local.get $2)
  ;; CHECK-NEXT:       (i32.const 1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br $while-in$5)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $3)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $_memcpy (type $FUNCSIG$iiii) (param $i1 i32) (param $i2 i32) (param $i3 i32) (result i32)
    (local $i4 i32)
    (if
      (i32.ge_s
        (local.get $i3)
        (i32.const 4096)
      )
      (then
        (drop
          (local.get $i1)
        )
      )
    )
    (local.set $i4
      (local.get $i1)
    )
    (if
      (i32.eq
        (i32.and
          (local.get $i1)
          (i32.const 3)
        )
        (i32.and
          (local.get $i2)
          (i32.const 3)
        )
      )
      (then
        (block $block2
          (block $while-out$0
            (loop $while-in$1
              (if
                (i32.eqz
                  (i32.and
                    (local.get $i1)
                    (i32.const 3)
                  )
                )
                (then
                  (br $while-out$0)
                )
              )
              (block $block4
                (if
                  (i32.eqz
                    (local.get $i3)
                  )
                  (then
                    (return
                      (local.get $i4)
                    )
                  )
                )
                (i32.store8
                  (local.get $i1)
                  (i32.load8_s
                    (local.get $i2)
                  )
                )
                (local.set $i1
                  (i32.add
                    (local.get $i1)
                    (i32.const 1)
                  )
                )
                (local.set $i2
                  (i32.add
                    (local.get $i2)
                    (i32.const 1)
                  )
                )
                (local.set $i3
                  (i32.sub
                    (local.get $i3)
                    (i32.const 1)
                  )
                )
              )
              (br $while-in$1)
            )
          )
          (block $while-out$2
            (loop $while-in$3
              (if
                (i32.eqz
                  (i32.ge_s
                    (local.get $i3)
                    (i32.const 4)
                  )
                )
                (then
                  (br $while-out$2)
                )
              )
              (block $block7
                (i32.store
                  (local.get $i1)
                  (i32.load
                    (local.get $i2)
                  )
                )
                (local.set $i1
                  (i32.add
                    (local.get $i1)
                    (i32.const 4)
                  )
                )
                (local.set $i2
                  (i32.add
                    (local.get $i2)
                    (i32.const 4)
                  )
                )
                (local.set $i3
                  (i32.sub
                    (local.get $i3)
                    (i32.const 4)
                  )
                )
              )
              (br $while-in$3)
            )
          )
        )
      )
    )
    (block $while-out$4
      (loop $while-in$5
        (if
          (i32.eqz
            (i32.gt_s
              (local.get $i3)
              (i32.const 0)
            )
          )
          (then
            (br $while-out$4)
          )
        )
        (block $block9
          (i32.store8
            (local.get $i1)
            (i32.load8_s
              (local.get $i2)
            )
          )
          (local.set $i1
            (i32.add
              (local.get $i1)
              (i32.const 1)
            )
          )
          (local.set $i2
            (i32.add
              (local.get $i2)
              (i32.const 1)
            )
          )
          (local.set $i3
            (i32.sub
              (local.get $i3)
              (i32.const 1)
            )
          )
        )
        (br $while-in$5)
      )
    )
    (return
      (local.get $i4)
    )
  )
  ;; CHECK:      (func $this-is-effective-i-tell-you (param $0 i32)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.const -1)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (block $block1
  ;; CHECK-NEXT:     (if
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:      (then
  ;; CHECK-NEXT:       (nop)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $this-is-effective-i-tell-you (type $4) (param $x i32)
    (if
      (i32.const -1)
      (then
        (block $block1
          (if
            (i32.const 0)
            (then
              (nop)
            )
          )
          (local.set $x
            (i32.const 1)
          )
        )
      )
      (else
        (nop)
      )
    )
    (drop
      (local.get $x)
    )
  )
)
