/* $Id: selind-kde.h,v 1.3 1999/08/05 17:16:40 stano Exp $ 

   xkbsel main widget

   (C) 1999 Stanislav Meduna <stano@eunet.sk>
*/

#ifndef _SELIND_KDE_H_
#define _SELIND_KDE_H_

#include <kpopmenu.h>
#include <xkbsel.h>

#include <qpushbutton.h>
#include <qtooltip.h>

class KbdSelPopMenu;

// A tooltip
class MainToolTip : public QToolTip
{
public:
	MainToolTip(QWidget *parent) : QToolTip(parent) {}

protected:
	void maybeTip(const QPoint &pos);
};

// We need to get the right button too
class SelBtn : public QPushButton
{
	Q_OBJECT
public:
	SelBtn( QWidget *parent=0, const char *name=0 )
	  : QPushButton(parent, name) {}

signals:
	void optionsRequested();

protected:
	void mousePressEvent( QMouseEvent * );
};


// The option menu is simple
class OptionsPopMenu : public QPopupMenu
{
	Q_OBJECT
public:
	OptionsPopMenu(QWidget *parent=0, const char *name=0);

	int constructMenu();

private slots:
	void selected(int idx);
};

// The main selector / indicator

class SelInd : public QWidget
{
	Q_OBJECT
public:
	SelInd(QWidget *parent=0, const char *name=0);
	~SelInd();

	int constructAll();

protected:
	void resizeEvent(QResizeEvent *);
    
private slots:
	void displayCurSel();
	void popupKbdSel();
	void popupOptions();
	void quitNow();

private:
	KbdSelPopMenu *menu;
	OptionsPopMenu *opt_menu;
	SelBtn   *selBtn;
	QPushButton   *commBtn;
	MainToolTip *toolTip;
};         




#endif	/*_SELIND_KDE_H_ */
