#ifndef _OSDBATTERY_H_
#define _OSDBATTERY_H_


typedef struct  battery_state_struct {
	char charging_state[64];
	int  present_voltage;
	int  remaining_capacity;
} battery_state_struct;

typedef struct battery_info_struct {
	int design_voltage;
	int last_full_capacity;
} battery_info_struct;

typedef struct config_struct {
	int  align;
	int  vertical_offset;
	int  horizontal_offset;
	int  update_time;
	int  battery_num;
	int  bar_length;
	char font[64];
	char colour[64];
	char shadow_colour[64];
	int noloop;
} config_struct;

int get_battery_state(battery_state_struct* battery_state, int bnum);

int get_battery_info(battery_info_struct* battery_info, int bnum); 

config_struct *  parse_config(); 
	
	
 
#endif
