/*
 * This software is Copyright (c) 2017, magnum
 * and it is hereby released to the general public under the following terms:
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted.
 */

#include "formats.h"

struct fmt_tests dmg_tests[] = {
	// testimage.AES-256.64k.header_v2.dmg
	{"$dmg$2*20*fd70ac1e078f01fce55a2e56145a2494446db32a*32*9110b1778f09b1a7000000000000000000000000000000000000000000000000*64*68a32866b0e67515f35dc67c4d6747a8561a9f4f6a6718a894b0a77a47c452471e04ecef9bf56f0d83d1201a509a374e00000000000000000000000000000000*14*8192*70ebe6f1d387e33e3d1093cca2e94c9a32e2c9ba47d461d737d49a7dc1b1f69407b7dbc16f7671689ea4a4641652b3f976b6f1c73c551a0a407d5a335caa169db4a6a25bbd27fbbc38fc71b29ee9b1eae349b0d8a21d57959ecca6bf74bc26ccaee69cfee4999b55374605491af6d0b9066c26995209cd1b71925bcb45a8ef5727a6c20338f08de4357d4cb42cb65ecdc2344a5d7387633c913258ba40699ea5f88804b5e562bf973096337b17b4fc1236d3c8a80b9b48aed63c5a0eae3ae924a883e948f374771bba46923658f225fd2795ce0e795269f589e0ffc81615585e1224cddde654d689a3260e69683c6198bdfcd87507c23cefe36d72f8878cb27bbe5dce868752a7cce067f5a3110f20ebd31ecd53840103e0b2d44385656398edc487bf6d1a5ec3a56af54f9d4254fd20988df41eb85e366f13da1270a3f42c6672ad5faf00fa21e9ba3691bde78ab2c267a142f275467d5b853a107dbf1d75839f0e87b3b4f1d2cec88cc02a26bc4a63aa6836b0c43c5dbb44a832050385a48d46968361ebb053c2416c02458b76c95e50970922556d40b100967340a32824e6b6e44c0c1e0da7ce989d9d5ad91560156"
	 "ed39666cbfbea71f28797a5a7a40e77665612e977ecb8b7fe71d500eafc29d9a0ec1d0ff1723fea7c405bc181ea93c0df42f5bf886eace3cfeee8b0dba52ba8cd2ae009e75d8845264d12dd632ca3236bc1b643437881b270183d2e2bd20808ae73d32bfe88347e33bef4921fcfac9646b74f116be1f04fc353d2222499d5247fa842d0d0f00fc9642ea7524adb65c18fff87b6efd060ec850d7de6f59869387b3d4cc8e38014d52d94ead07d16b8d94327fe5533941497c9be2dd6c04142ba57e29daaeef96d0f2d109522651d797715f4bc5f4cc3fb69fa92623b5ea3e08ff78dc59913993c877f4e2c8964dffd2c8cde6c6b6738da2883505486df5b633aaa8c66acbc2886107f3dd61b1df29f54a13ef27a7d2785c02153375240885e5c54297d88827403320799e05213761549eedc1c159c922087983410d2abadf9ef8ae460d018c278a9ea724f52b866e3d7ff2374496103b5137297100c970d195fca8c1286a8f9d3859ee12c84bdaa4b56ca91e307580b61dbe435ce4021007e4a2a8085976549cf1d195f439bb6e642567f91a0224e98796614d9ea6bfab8f6d13f91b7a80a54e538a1a785cd07b5d7ed2b7e45a0658b5722b5f8844f5139cff3b33ce244946757c020c54c8b5e43324023ed11001201213ffe4829e37135686a8bec1837b35fb234049570868dc5ba9c84cef6890d9ec400a794b1723eb209a60758ba9ae9abd23a7ea9f94fc6b73d29a560e24973c9160f195fbe82376c81dfeec1a7f912a8c22c067a26786a22f0b7db298"
	 "3631400f120010706c78acc36ddcc29c7055fe82105f770e2dadf131ab49af93539fb5186d32dbe4a4df6cb0fdf6840c0609c8769fe242cc60d87e04e6e3be1a7884a05d9fb96c3bc1bbc769d96bbcc0413492eefc5502e9c1ac7c3f237b9851dc453b5bfa899b7b68e5e3b92711e7c92945feb6f6e452d6216e154a952cc28a3740925554d9fd44acedc8a44b0c25bbb6aa637fe9560437c08b17992c74de38fe1fb8fd5f66c2933c2d573ddc914f68f42d6cb350f126a51f607a2dd23b63e6382ec1e6ae434f47cfcd1e7d96c8293ef2994f850a27ef2d8210a0df0c219eadd2376ce36a22db56827d92a90d5e2fa55a4154c39061bd5490ba29f8309cf3e2056f761762dff56803bbe0607faef510d023b249663368977fede0577944f2ff05ead4b432bbb07a7d90148ebd1e30bf1204cd9069725d9fdbb850d3d6fde5044da1b9ffa222d99061c8ae217bc5b249960db545e6fece3ea2faeefa7702f065764b326ae0e62f3b8745cb73f35bea1bb9f6ed4fcda591f4d84da0415a0552306f6691a64a1d0efc8ac93559a79e57e357b63df48506c12dde74f6ea8fc5eeb1846c394fb8fd0fd40df26a42e53692db51bb36403305c1aff797e20adb6f8f1721e316705dcf8fe6e6989a5c3da253fdc6cb5de426f1c018161d72e34e6791d73023c5df69c0f83d3ea1d097f3a7ff37720a66868f40d3b87755bdaf508086c7e478ac1efc0dc421987af6db9b2f096a7270de91f5b3b84ee6d1d268d581718d3c534eeffbe2889388e9930cb051b5752c1a"
	 "b1faf1e367866af7d4b37ba25c15a030d9a5f32bb8912ce853fe7988dc62aa61264e3c5a29d18c5121a605558b15004c817cb0ab1646138cbf6375f1a179852bc22d80b83891edfd38e25efcc0dbb78062f479a9dc792e5822e09ba3e0b8ef71c62ad7747dba8cc97707f31383baa93108d5c7253dce2395fa24d77c42cbf3559b5dc0235c0ce49ef9e3cc816598698c8f8c5b32abfaeb44f3c35a01a4f47421a166d5aa893aaba80e57eb576b838c95ed6f9d5b3d389a8f86b97fe629408ec7c7ba7fd95d7625e950c7324fdd35989570b24f2e1e24d52b65ed6116e728dc3a1004d3d8fbfeeaea1c7dc5d3dc7a029f97f8dc7f740e2386eb27e9793680d959821031fda08c7146f46e8ee47ec28c7d25574eb690de09849725e490c39e524b74aecfc68ff0d760d115b4d0a126609cef83b6c80731dd17f4a307331464953c6b41875b6e5fea328fd59f275e2fabd25717781cf9d5cc52286246ebc92527eeac7acc6e2652c6fcff405e7b4a78b8f9475f46bb82a68a6e44037d61de0df58a8b7a81f407aaa260f3a49c4a2641776404fc15bfb77573dc8728573a1872e7e093663842d9368e74cbe3ae547355fa101daeaa0f97dc0a63927e54ae59fe13aac4f488e938fa67a12876d103b4a56b6eb88ff0104330e5cdc7c6886b46545d523bfbfc88f40f9654fcd0f8c4f443a225b50b44af9674166d3de36b6ac63a150fbcda2e2511ae2a42fbe51c08f7238366aada5c6be8eeb41963c6a5374a94b332012e860d6cfbc1b8a4d5a9825b88a90c9a5f"
	 "5615ca503698ad00df2cd93467b66d9b15876bc49895a081959132bad2e63757aa4e5ff77c6f25dd2581a3e9bb8e213c9313ceca0fcf5f8416882849fbee576d8ffb9dc057eb96bf6b81db60a82b0e6f315a13dd31706c0e36f4f21b9ce977ff6700cd77db603120d59ad8088e121cc3c502e37774b098eee7c8244f9bbe0d4a9d0deba3ec22e5abfea69ab72cdb75a001bb53672fe12b4fdbdf7e82c0bb2608de5d8e1961fb4524dd1acc890361923fb691bc5ea436246428a70b5021f9eee2c637eeab574babde4c0d55f57925e511ff623af5c4224d3ccb9c8572179e2610b4b79817ca18ddcb5302151f9facffca96269ff5fbb11e48209e20145bdd70d72bae54f6fbb89a3396bdaaa3d45413e3c5bc672ab98dfbeb3274156096f641494c1c946baab7c388a16c71ce5009b32f45dbbe37998906570045027950bd758b7ab2f72c243eccf9551d539946a99779848b16cddf9f163fcefe1e1ebee3ba7d5240b92698ad56a036274ca798eae19b0dbcf39a1c0ea1a58b29dc0e3de89def08e6c5800c94db47b7eaef5514c002d687b4d99b00fbd44137f56557830d63156f43bf73db8b330bca0ebb4ea5d50941b758929722aaa5452cd4a4e00640165dfc35fd35daaf929997adeb4c4f7611d66befb80809dc7bc6c763879c3bcd8dd0fe6b621898717fd095fb7eb403b07591b931a8e16ab488b01acd636bf4f1e71d5460532b8a3b00d7353e84c071de5cfa25de685cb85b569e08d2f177727cda11f196b040d25c97ccb83e355db98c2bc14844"
	 "1ca95b5f612020bc53a81184ccd0c5f14bf6d9fd6318ec28bafe8d668cb3c98c56ad416007bef4a3ed9e12eafe8f9e7d87fbb02d1f557b497db1a2c0fe40ec3f23ea88332513c68f724cc8a8af6636c9f332a8e55c2d41fd81a23e92e9ffacd3ef14cda669e7dbe31ca08a5238c7fbfe7020933087bf2ce0a7489fd5a3becce5de09628234f60c833002aa8e9c9ec51f57c8e4ba095c1d054750d46d64041bb1f567a82d63bb5e88fb70bdddad0ed7572229e56b90e74dd88ca829f1ce8424bd24a0bbfe3dc3f77d244ee59f364b36a4b05fb511b5b0d7f876c65ab4233803543b0a68b9d2d6d45d292f91eb4700c2dbf431e40c77a4fcc3ac3fdf3a2bae3df35b6417b8f1eedfe84cc65a07c426780871d16ec5ed3201ea4eaa778b71f04cc1999587bb4645bbc43e365395e9188c85bd024f758304aee979f8e67d07636fea251423e920e2b7258580d1918fce772bf02ee66926fc5f9a3dd6a8c89e6ce7e4fc03d4784296df1a9152a1fc66050983a287e3520bf3e04d900d25316c8bd5ab489bf97a2f31f4061f895111caff9968ecb22d75cb9e5400ca1d0fb044acb4fb9cccaa4766cf6c63ae5a7a3f9af90d1b225067f671d85cdb4e2e21d2850f351d995d54520fdcbb8cb30bfa82190ab2071eb8bf350f984408b206597371736110114d12d79da4027f9a58c8fede63cf16fa552d2a956ae2a49c83b0afca3056f87f1e27bdeb9d14a7e5cf30550017a3233c4f386769021a853b971746aa28aa69ca980bb02979779c5bd29259c84911e2b252"
	 "61b92be669e8a731dd74edce66b6f3ab5944695efd57c0004ff637eabfbc02ae346528fedbf2ae80d420580adc4d571a37fa1397fc2b85ec458d5262c15620c88f2dca0eb1bae4ec39d67fef56ecbdf89703919e5a6767d0f77bf6f0f60ba21003d033c9dc3057df18d855a5801110fa9a29a42ce10a44a39ed883df249ccddef8aaf832387e70048d9ad6014cc17f9a2bf7146696ee4eed388d06a45f7bd7696e57500ecfada9e9eb17926b16bbd90146e406e281141f0a918c320cacc9d1f045ac1bba87ce8d1d45cb6303988d5228da6ad33df6d2a5bd7f265b8f610078e9db5fa3db0e08286e500063f0fd6860a11d9985226ad382a95bc3c3941d43378ea1bf28fc85749f616092d77e7c292e311337168b52eba08ffc0f76582710a1a7d33c55162b3c7fbf227a324e1f4579e035ae0fa17fafb1ea964aa977490b5a3fc16c75e1fc50a6d17e193345b71369df804c61a71bf60be4281c3d1f945c690368c23caab006f9dfc913dbe6119d6fe8349cdd424db7074726e8bdd0ae99e2bfb9b800ddb965c06e0587cd10108c9b431cad4fd10d3654a22ceac73553a6b2b2218ed6526c362df46cfa776e2caea0de61b9d5c0c74e03e299ceb2221ed0f30ffc5876354d5607c3eafc77f78e4fce5e0c7f6ba7d417ac5f0511e2635b41b28dfb4f2fbb73d351a69fff920b76f5687386114b3d5ab9cad056c88840a023b7e2df73f007852763570d38a966c8258365b014a12a3497f506dbe55c073244333547223785438372884ecd8b66aa0a794ab5fb"
	 "94b0a519bb3cbf01b43463c0c7fc6ebc67754ca25686002e13edad54c817b0aef64698637d18a4a8bba382add892f4918b720aa99b09ed2a6e02b7140f89e3e00680f37343d3e47412d04ef78005b8b9a23b92d145a8da9c5efafce374955727367a7f1a179b990868550cf960c6df6baf2cddda5fe3e689de8dfcf1474db419ecf88cbce9de7a58e9d8a15991fdf5361846273d195a2892fbc95ad079ca8153910984c4694edb4c790f430043c4019fbd96fe49d8afa5e7d1f6674e4a125bfbdc916b0d3819566898599443ebf2a87b1fdaf41378227d396d2d320dc5b860705bc87f45eba2b6473234fe054267698dba0913ab1234b46697c54e2b19526d1ad4b7e3eab40a413f86170fe9f2a71eae2fb959a021b0b43516f1c8a3e674f37ee235ade79ca296364b0cad5ebe8449e09b63a34e8711587f7f2fe6e181a787b1d3a8f30012ce9549abb834fb80c673c575a25d3c33bb6d846ac231f411dd6422c59215e0a267424c0c57e6c9bd5486e8b6327e9dd16b7065eb74ef91ec9204360b03d08654a4e418346ec2d4d21edd5608a76903494791546d430eac38178d158d61951de3c61fbe5d56c22cbda4a3d40297f7abd83913e8b483d9a80cf000810d90a921f453bcf9e35732d2579c1aaef4a6980c666e3b273a9f91d9918f850bd6e4475d8aa5cb616cec58d6ab6d70dbe2b0f7ad85618b6e60dd4ff5d0faf19dfdf27a9ee48cd7b2d6613e76f04ab6ef5f0af12966a90875816c27c4297a2bf622ddf66fbe7c211670d0c46c7295b93bd2f1"
	 "22568df3dc46e9294c7258a0b7e81b2d45979680edbb7ab323e4857d84306ccc16ca79c711144eab7b37e3437245d7b78ced1cfebfc45892791b9ac6cc1211f83e328ce3f57af3d89b5be89dd2efeac9d738330bd0d8d4a059bfac06d1ad73bf6d427541e559c3d16eb5adc4380c1b25c1b8a9097ce7eeeed1c5d6884dd1a32ee2bfaab8371593a0eef65f80e705b9b56adfc0db4c272024a71947755032a5ebc1bb346ee8a99b01b408cc0b1658a319ffa5ab2eb87e9aa8b3dd9d9d92ce3bc04e4ebcc011a280143927676360f249ccdaf7949bb23770a06ff5861661d36d761508f7e9ba149310d1347c3165e07997853d415abdacfae9579d1dc0b5990a05ae9e6dce8931ac2db9414546dc64f8161a64cf30b9ce8c50ef2a99775f03dfc2c611e780a5cbcc27cab920a87d940acd8b3fd42897ab6f51b29214275bd564c50eb7aab3ad19a2c903c84d2ed5a23c49c81d87cf3244505424332c917d7b671d4a90765b8953c26bb7ed5dfe3e93632610ab44296afee2b5c631fe643a0a78eb9af94d700250f5a82bc57d24825423f1ecfd8cc2bb0daa229670d0d9a4fb342ee8c9b7b16d86d29abc2a57633303b918ac78ea8d2672dfdd4a06ea0bbd756fbadfb0c09e2426a65e90ca829ea00ad66ca8c9e79b9aa5ddd02d435cb23014b1033da00381ddf2dcf408660d1eebd1f6c7bf5ae9fc3fe47e75ff7ca482716534a9f3365f5cdb48f3d59fb19d11bb8782ef96e394296594812e8a7da23a953f6117ce577e55f3d6cb1d3a4007dc7d252c7123a8"
	 "37be12884e54ad10757af405beffb5cff189133bb7df5fc009544b2d62ec44fdc0c1c8240d4413af5b36e031510b1f1537a690ba7049cce9df4bf4dd63f6987c513992fca78a1cb7e8d670fb43a52ea2ca2f49724e35397041e5c75a365b510f40fa9bd076377274d6a95af801981d71972da0a08b536b024f439c43d13902878798153ed825ddd7dee8937181823076f036caecec170edf1b5fbdd84e530bc50a7acc257bb9679d72de3f115602d18d2d12e6ecf4d3242ccbe9a71a1483e7fe40d2447ba028a76aa92c13516ebde90dc4d204095a554cbfad79d6efe4ec540c7b51593413465b929742b729ca688f67ee9d9fe76431fa81217fb135d0dd6ebc91904efcb0cb6dee22867e5ddd7453f530d04935f41575de9ca457da55b67791d2e8b83890b5be543366b92ba6579a6f19f8e82a0bd87e379967766e5b0a58305b984778c562ea03a8b8392e3160ea4532b6ce5de74bc8fa0e8ebe88fbd62a73d7106a309f5a5f5d7617664b015e166fcd87906caa80ab4eb3e62f73e527b5d951a0ed0340fe17bb7b2692e4a31d14798879788fed12413bac50e490ab93ed66311599a6c1362fc60da5319ad907c7ef7852985ce86246276a138379d2004772d4d9a989b83b3e780bdda9825ad06a4b3dcc9a9d4d8025cbdee7cb2e02ea1f77bc90bf4ae56903859025b7283ba6410aa91933466623b996e9ad07e3095e376b11a27ca451c246d5561501e69c6747013ecda44f8d1fa50a75572453c9ddecc07b1aaeebc04cc7e976915f5e68d1236ae2ff"
	 "dea4b9fc4f8e91b03982801e2ba604b46ad80f966838ae09d2734c6482dd16d7738cadc1276593a336e2ce8cf7ce48d1535c7865f7b90445ff3ab9e56f58e254115bc07710de50d7953238d7ca419013d104d90fe79794995c28f219c963d716bf8942e0cc5cb432aafce4afb42f74596b847fde5d87fba9adce5c17fe590fe58e60379393e521ee194fe063211d72c29d58f7dde89addb6b0e20515ca7aa270df2ef2d77f92219781502c49292c6c4a985242b9447521cdef5a52b53b5eefcc43e8036ebe90b51a3565cbb180ea1b3e3d20f63b8f420c2a7f01c475428d5f63c66f122654af4edcbafebe34970c152767cf623eb4f1ee33931a79622cafc70cdd2bc7ccd55ecc1e0aafde3f66f5414315048d3c5c51638c35fa920cfcf7a18ada48a589c12e4da2c801cb8bf3b182463707a17891cf296ae8aae6a8a88ee3d602cc1bb7647861f65ec1a278433ae08d8c8e63727633425fda0b86d78378ac80b1bc1a48abf270dc2b5ea71691eeeb979950cbe0ddfdc451dcf8e3dc657060f4c3f96512b21bcb228a966381efa94bbf5ff4bbf38a803b6aafc719a545e4d0582a62e81e6468aa04eaf131f8d2f545c060651e115032f5b3579fdfb95a2328f5c9a0308874630e840ae1dcec1b9543c36267a9651c94c91cea42a93a91ba3a054ded4a8343864b449e46abec49474e218c8c541b00eb0f8997e710025631ac28be3f08126446dee0cf61bc69b85e4fc021f203c796cbd2ca16ebc8fa15f55510a08ed334155233c6459d2d428df31a3f376c"
	 "d81a530700b3ef08631dc5b50f787d4efe2bf219bd17f0431803d9d946255716e8543bf77fc44a48abc70a97feae8398c2059938d39fb4ac5f7214d92bb89fb9c45b6d117fd51f6207935beb1a89963fb9d1aa020669bf809c21154c20e720aa1178ed2bc13fd548e0d7d01eb1d028aa48318a02dc7aa412e2ae01ff59a86dae40771ad3f48f0fa54b6e679854be00deb9938e37ab3a4c9a96f3b7849ac75b82619cbc806c42f4bc4feb1141f6a8391bf9335f643ce5cd2791590b28b19d03cca7b5cf702f10ffa0317327e828deb4791f71500f243be77a451e5759c6c711b38f8f62757c54d7fc6dc586a90df7777d8cf1c72f9c0947af005d770f4a74b6c9413738c3b5ab32306ff5b41a6446c2de3f59a27b79d877d3f05fe22d11afd69e49e59f35b3725a0ad126642f388602b7816abe397a9c9233cf7d1e12a00362306d2d9b81fddb279544f35e23a8c198930f75986f26e6f292ae8debe5da0a7a5b8add2be71efc78179eff7fa2a2dad35863b69e85e8172073f434f48fb03f7bd1bc78fc2badbda261a68f7bfa171c898897b3b0d4852920674b8d9ffdb37ce66c1b6aaf9b375253a0d74eba4d359737f7fddb42471969d81605e41f615399c5fd6cce1808e9b511ac54f75f774e84b00970474f5136447af04b4866ab6c54aabf7a247c6caf3ee891fecb14073f3cfdc7368ac00f6b1c9b23e301e49257840f949a57c28a95c5c490bca91bf979d40403f7b9458bd255df757e6eea0bf41d5175548aa46243d98f2f0f6c754d6e7e58fbea97"
	 "7d7e0af8b7d0a6bce07d0c483293868a914a50aaedfb9b239b4c3c472381535b287a4146fd52e7bf882c9c3eff7bb2fae15d5b96bb1222d81d26dba563ac550e716b6c08b062cad6702a33a9db4274fa2e81af815e8325101d5a9ce9b345e29619da9e45dcbcd7b0935d7dde07644edc6b049eee9371511bb2cac50ec1170c7aad835c54fa52c8e0a0e8446356488e09c2f07b17413a7ddb872d05016aba129cc36de609831863747310f0fa443480a47524dfc5e1f34eef3ba2fefa29e596e7fff86a924462781930fab55e71fc2f06271e62878e51e0db08ee5dea31f1d2afe9a4f548ad6a4f4763c9d0eecbcdc32323aba1c9c12554a5cfedb5310b4a03caf426a80d725fabd557493c46f2a174aac851d3d39529d5ad919fdb7fb0dc1e5b0ffdf706a9f5af36fcd2bdde28d68c5af4a1da4e67cd44f97b555b62b39cee1274b7c3dd3971ace3da6101c87f9b8f28c5e13d4066a3e63543825dd8bddc3e90b6dc75bac78931da98929a337817f68deec6065f6f7883d5bb10cab909c9945f71a672eb2cda9fadf4a8d9da906e2a5d1f589193b4e791772663f1bbe751498bda065f90244391169d80490208083de39bec984af73dc99b10d85958f372004a03962c45c531b347851dc5e26bf7bcdd68c9b129524d6734282bdd431f991170d6a5c67138a5405d8005b355ec7ce95496a8e98782f6d978c42c30a17db9c12671d82f2d3e257f66980f20bb6380303f1e89b10035ae7bdb3e55d31f2d1574784aed5c95aa09aaa9614989d957a65d893dbd"
	 "abbfaaf30cae0cad575e39f5311aa00a6979fa52ec12dfb2f731a3ce5f8b6097a612c2ce98f5898eb2d1780d0cf9ad30ce5395ae871ba7ca6a0884a13c09732cefc5aed9d7a28c09041cdd62e75d7396432545f0c16496b7f5f516fb2cc603c0ec10a51ee952b7cd0593ec00dddf67e27dfe3f0cdc5bf737170243a8ed3c1f59733fb47bde4b6578d7ef11f95790d4c678d95ab2cbdb1673d2d516c189af00f996371077276e672f1223926fdcd6627ff86816906edad3aa97e3a9e7346562add05ec1a94c2dbb7f3b28ef537715a1d69761bfb8c2092e608311af2f79a4f8188665a48539944374437bcff6e59bdff4e4b9e4dce11307d892915071157698460b9e9fd68ee0d1acd21434810fc8ae702fb8dc794ad5364c79fdd74c8a70f390556930fc2a23064f36411c626179d1d745d4875f5c2b37292cb8ba37bb78d419f05e9a5d2245a38da20b6b14eba2d5ca3d58d23bb5ade1322cf337eb75a97ce98c167b6305907c3fe18038bee1e2450c3095480f99c9f12d2b543b33866e5546a39d539c6e2d639356bdbcbdb3b4e0935ac76e0fdaf54cfdf241d2c5ce135324885f8cd69e6562f48979352bbab357c6861c66b4ff7d9dd5d32a8ab8b6e759a2f5ddcee847fa439a5f9e3989039aa60751019eca6c7dfcc2464ca4a1ae12f079d200961797cb0e52cb046d1f0cb1d97c4699e07f019b48edd6f4a71b99ba26c2e5e72745cd9bb9a7e89d8eaba646461bb76818fcc447de2820196e32cdcf4a57c527c52f64d316b513f6a611c929890be5b0"
	 "3b3d3352cef23bf86d0e058b1cd9c4a10a9a01060aa9c9cc4bf42c7c6cbb677724db3f0c3736461c1828e67c9916e953057024371bb4ad8995672f760c47574bde9df9e73af90773cd46c9df8cb655f8c37eed8cbda40da06304471e32bc828a7dd9457fbe4d63a15633009c1a9f003f3db7f5b2b5e3b22c60f747d5627bce3eb4398a543cf24b18cf0a56728adcc253d7f5343245c1426b5bcd9daff94394499cb6d7ac2b4e63ec424c66f5dbceaf877fc13f47e744aca7d8b5d89c8d5621f4e13488b141062ee04c2312528a0a987a5d32ebc6ffae45657f4b2d1420890970e363a124b75374594dea0560320b36133e31d6a978f90ef079b81484503c7fc3edbceadfc9fcea06f271a60ea6c5d434b694ace1b506eaf013aca2c6103acfe6c565a5a24cdf638f8ee282ac812e32cc2662a8e2d4a31239952836c4896870d973bb65b280f0370f4c3a54c7f4723b2bef522ca4c233d7646da3fdb9743e273afa1e3bfcb947eea9f323ca908bb4961b214aa906cca1d2d56eff25d60952cc5897ee6390f9af4efd5d48b2aee8734cf6b8042f2de75b107f8d135d9a63148e88e43df815fe7871a354741f8863af4e114ed0369515bca104f8d3b24a2d740b8617de3e96a23*0", "vilefault"},
	{"$dmg$1*20*f615ec6c463799eccc6a2dfbedf12c6bdc422a2a*56*a595f4a81a490e7aa6378034661da57a424f922c971d3db3f856f8d54b0784bcc5d7182905c4237153c5d250b8aee1d26410b1dca7b1cb73*48*74a060efbaf2c79d5523219d8162c425befbb2094fb46e7ffaedc7cd4f192e6f0c47d8aa91e0a3201346725d3ddadfff", "vilefault"},
	{"$dmg$1*20*9c82b419bdac1b3e6b71f8a6b99a7501f34b6950*40*5da479e292e0acf67a9fa3e24d0a767cae2f645ff63836665068637188f4b80295de79aabdbc2536*48*9b136165ee73418631ccf28d5e77073788ae921df596649a7a7789585db0f13f446d5927967e2ede20ce8a4f5389185d", "vilefault"},
	{"$dmg$2*20*839730be2331c69df4f729ffe8a10c26653bea94*32*1f24e25712c2d70d000000000000000000000000000000000000000000000000*48*3231e20aa642889a7e087cb87c84ba1cd52864007cfea677796a6f52e16b2609696dde9230aeb5603aeb1f70f6701be6*14*8192*75884a049d2b7a40c14002ab6e511bf3c73ca79a2bb8285a3d2ac1d5b9b0cbf92d4a483fb762bae8485dc3fc9cd7a54141da2b74a86ea833d253d56f52eecb9dd4d40b9f846690378cb8a5db74fbc6d756ef9fcdbb5d21805ed43a7fb45d6caf6b3d2564f4a7760030aad69ed9e56789e8b2699bebfaac3cd73130fae1d8ef7f003e765e86eb84e990f3c24780022fdff3ba283ece4fa8d31716e5cb1ea22e408431eeb2cda1460217efda86461e940cb10ae602a84ddd22be53064e66c0973a04405ff17afa020b24f1bb4ce42750b28cf4e98c4f542576e712f3c2fe0a0539a411290f65ca763a94d865fc24b1beeefbb6b055db453da38e62bc383e74b188b86c54b62f589334de8ce3ab2e4643f76eb4db95bfc088bea8c4e88cfccd19b89b818fb698982f73df634c8a8148e4c8d3ec2dab02aabcf48ec0a78686fe0b4f5e589a067d6c54f0732e559cf9db5b4ae1f0468f5681226d3b03002cb6ec528b96470f1d1aee5d3b51b4c5f45a2702830ea35056e02279e76fdd30b3ac174cd91b65fd6a26a192f6e632b0fae660d0861059a62bc512f610f4974c22993bbafa364fd2e8eb53d07244d165f990c876320d99070fbfa6fe7e0ca42c0ef2f17205ca"
	 "7196376d4026a8a93fa83a99cd3b6cde354ed3122dfc07ffef91c24f2036b0d83467e120b85a92fa04120cc8f7af3196adb6420f519c610983d163964b0cbd048adfb89266d9ccf9845cd17ed04accff9d106b7bfffefb365e97357fdb9ab2d0956411c0c73bdf235a9ea4b50962c8f258583899ff2c0bad6602e8a3c14f3c870fa14686d15aa17f5cfd1ddeecc7b061cb5c00db7d198d083a690ecee97a1b4b0251349beab744c4bcb53a4c1702d1094f6591ee5ae15a29271ee3d3d22f0f833219c3676236c9e9620a206ab6ab08fe5fc663f4f2ccfdae6e34adc68e59fcba5363f44cbc5d8345f184ccb38d52bc2bbe6ad996c3d4316ce644698bba6044209d108c698c3d18f4b64161651224cb015052d2e9bee0079b779d77b6623e9669c4ff99988bc612c4099f6b8bc9719444cecbc5f87bf9ca6dc30f3b346c3cf20cc342cd4d156ed67c8be0f1801c3e672bfdf2fb9e6c6f1ef3570d059405a8a0c5bcfcd70f7bfc1d2417e3ca205be70a5ffc9b4d1d123ff64cf72b20df25e9861e1da57fd1311451e542c25100c19d1d70bba2c26752e4cf1c59a6373fceceebf2b4c392a45e2cc7151f4cc1c7292720b5f0716cf7ea752a8a44cfcb7f638c5387a410efbfae90598f2d99cc79baa298e30076d5ac8a2094dc14d81953c09fca8b41f88cbca2274158b93fe5a151b93bec1fdabe1a6c67807d5f9d46b2a19ba85f9540cfb54656fe473216ee1922046c5b6cd08b325e0c25a420765a61e5f7a266c9e0ea1148f0e62ec65736d4cacef77940a0eb"
	 "24e93b7b656e3b591f5827e78b577b628da26c1e5bd7544dd439d15ca21a3fbe96d3833ab1bddbb03beb8f0fe39517958b7bf43afdbc68b5061b41145e151d228bb5e5220b31a86878be40060839855db438368e40dd6b8d534c5c39009455c0a783455b41b572f2864eed60e5dad80979b97efd6dd08549c154b76f748101396847efd56a97b82cf62a25e26ecaebfa35d545cdf886ecc22460cc0e2983b9da14ac41dd1e1dead58a2c29a85f6bc900268d755d1158939470c4793359b50da19addd3d8f722c0a889ebd8dc69bd955b524bbe452cc98834613ea48d7a73a9b93820c0ba718cf664d82a1745451a204a2845d4e2a846f0f18923ad0315896b1c1ac1942fbdcba119ceed9e02b0e707b28feaba44bac94888ba1a31670cdce6348d58d2072eb13ee805d569815fb28749c392d11eb06d8b1746ba8eef3313072fdb4685f1401717933fd18edbc99e3d89d08a4c7798bc1d724d6bca02a31642ca0ac6223884580c0be8f6508a6650b783a9ef24de3713f65fadcb2da6d68c4bbbdc216ff91ea7bd24bd7365b91087c14edf70dbd4eceb2676797ead7fbedae77a0add9d22a515e2a79d075958d8fb87aa62700c62df007abaa3a5e002403205fe04edaa4aac3da6d08ad9ba909974e9091148208db90f330b2c2c702521d4b1b32acc4fe6b7ffd9f96fdca05b6c404afcc789fb9ad8c52063fc0f9b9cb4116ee11f07aa17dff57b889a4f4abaedc51a07481c1e954d78ead32c6e808d3eafe7cfa9d2d4ab4886abcd2f64ba2df2d8d507cabfa8"
	 "d01f785409d71896461adaeb4e34d18f9b2fa38779f0932c27ba2f3f75ece12f6eaf7a0d728dc02e97cd44ff175b592b8234c3e3b5491726c58dcf0a1b77698cd38d861fcd549aa793f8d2b58d6afd1d9b7bb96c8936c960eaa7072c00e69f68f948ee24494b8152bd8e5d6923c8eb26023dc660d202e41663888a8e8550092b5e1610452c79069b3cab41a2e7459dc0d361ded09c9f1589999623f6deacf276eb72996a355e4f7dc19a5217e9dcb2d6a3e4679bed9f980a5dc8f24a1c5f4eef00d706566e12ac8deeee964ab9501be5e57e326a6fcb794e4f4fe14922704206a343724913ca2e1d26e3d83cf994cb7aaaf9a916ea6eaa06987a9822c5a8e556b16ad72d5f5640b3490d6b0f290f9f2db7c3ead435e534406dee40366efb98f0b53930a83ff9bad177b84343d204a1083801f1d68b3aff78ec4246f670f924969e4608b419ea9f5aafec40d902492f62844d9a83d65f38af2531b875b964abc781b3537c708fe65f70a11552990447bf6db287412367ca918a39d9e2b2e228451807b01174afc33f5f67d45f9c765015da6abd318c980fc8bcba60ccd5193e7a8caa54193aa83bff7b77725be99780da88b3209a3cec620c17f979fb16e640473b0d98a2f492702ab99f2f0f83bbdcabc2a6dc4986476f420f112ffbc7bddac8cffe59e82ff558151b9160e2f99bf37a05654253321591ef31d01b32b8d69297b3bd57f127e9f574fd472b6d29b6e9a0e1fd43252bc1f1b2c8c959f3f4d80177b4fd6a77dde8fcbaf1eabcd5e7f6d38630f35d"
	 "efc161ba7432cc9af6bc73baabcb343c469ab18e4cf88eee21e49311b4f20077bd6e30705338f047a9c7bbdbe4dfa6d7be3a827c92823a3c8f36909f9e4df4dd91426b75ac6b5d953357929b0bcd91ebd24e651a855755edca82c4664d3c89fca6001ba88688e5ec8d5e5c3fb145b963b29424192530601d74e3b815be85ca44640ca89c57ec4ac7084639b82e23f065ac561779c040cbfe63310ec846db02873203feccc3f88a28fa78d8d567905abc9f8f561b4a29ec5c380849ada42100c15efd3d73fc203e63a315cc27b82f62c4ca0df9ea213dbf7eb39552fcc38edfba0ce7e25dd097bfad5224369f1d2a175ab88ee5a3371daece3342e99c60cde76a1ff5dc7e5ebaa7e0fb59d4d088cfbe7704126b2697d62d7b82289a35ea778ea4ca347410513513084f1fa971686724761f711a916ae1e92402ff3d52f948fdbd9c1d961c6ad6923c8ae9cf3a4eae7a9369daa5cbdadfc786e873b90ed1e8f5933ebd011081ae7ea236c11f0c53e00c1c0f9206f91e6954123b5caa08c7615a787c1661dc17f297c8ed2ff6c90dfdd9a262ab5e9a4489d6ed7ac032f72bcbbc2248e7f1675e2b2da0bf85caf89921fcd8e78403f11a28970f673ec7adbea798b3eff87fec642ef77c15b3f3d19dfeb74d1ef6a38ab938692207133aaeaf722aec4f6082a4cd742bd37fba0f1f83f01cd2fad6a169c4716940f7d74b8f29001f406de5897a5e5d813b995df132cc57a5d9bdecdad9024dff7dee8b89189d35085a70bba2e5e0a8c1c71cc593238f3acbd1337b2c"
	 "c5a8647ce6bbd669eb939279d3b964d661112752bd7fb877c4c6ccb5ef72ff5446410286fc69347841c5595a3408e0c73fed8984d0c0fdd2544a168ccfe41386702f6ab7b3675a78b57f9782f23e0471e6dceb176dc9eb871ddd92dc0b86b2a11293523189c75019200a45213f0cbd86823f65f28cbe6569a58512dd469431322b7ca5b9b8ca57e56a139dc4788ffbac10fb57441f2435584651fa572450a4719c8c9b4a322f3aaedd3693a55820c725b63096d3f211d830d39aa89be83d59b13145dea9231266ef6b1eb1fdef31203922308cff81b166426d662989a350ec712dba14ced58df7dda0d0fad05ad8d9c6b247307d481f79e6a3cffdb2ab9b21a8208d6d7faa72b6f22a505d2b950884474862f6f67effc81c6292f3550c4e8852c39c52d952648b256e961d478c0c6979300c5188c490ce5c1e34ff6dcfca63c0f0571ea616651ef6f9781f2d355dbca208e56948ab9e26c5d2d3f8509952bba3e93241837b11a89caef6c956c9354ac10425a6d8d4e82bd5d7411d18655393d7c542a7c914a5ea6aba717a226e0f51200cc949f38c703f4f6ce452cc1d7d6ee8acf26d34f74981f6850b11610c11d1c5e6689c1b6fcd6b6e997ea145851c6655560c33dcf5ed7315578263c39fe6a838c5de867f1b3cd482c0206f56ebea0617ae25b3ca8d7e13849bb2b58ea4e21409762d549636bb7cf5ec32d3216d827d94cba1f36e7632e3a43b3203fc596cdbf879d1aaee90804fa0cbf46d08ff4c40aff8fb2b46f7ba8ce21d17c2d3d025b67702054e"
	 "9d76716fe7b5c9d2f43036d86e6a17924d2f160f91110ed1f3364a1177aa6193baf59878ec84f450914faad409618bf25cae17ba5545abd33833ebf408990fa4236d322089aa42eebea965e59456250fa14bdb61a32be8d70372891a83e7bf298168c5431e0b326229c36c667217bedbf64e3a07019534a087e84cd1a9cf35a889d9e65a7be63e8d638373774148e127b328734963437e7f00253d2fcce7bc0d798c09326ccd4f379f8a29f2d308ab2fece6fcadd653b1a3ba53a078e51a1a87e8dc03c5c118444d82d9166c0c4c1bfbe8ee09be6f8cd497a20132d4b6e1edd13683b363dc6587de2f11cdd51674ebdaafc41654d639b6cdbcc040f5889efb1f64e1b873442493ebffd8f867f0e1ba2cc629bc5239ded578336a9e88ee8b2d1b71f6d9303cbfb8a35e4015d2f9ec25eb4618c2ac17166e8964b68a66e60cb7b464e36a2251243a218ee542dac96062ec7db751273435dca23bf3e8aaea895ef1d6f6bdc98fcb6a9e0658dbe734450682cd1a3fe16161a9fbd035270fc86684971e20f1f1869546e1b77a481774c9449ac6499f376bc3c0f0efa589abe3bf676fb385ea50618c681eff6e5359678f078292da285c4b5e66d5ddb43499abc3558490aca6481299c351c6b053739d0065c187f59767e7de24f1b7bcd2d80d0ab2e7c789a9f5172a8411a88d2c69d8f9d2744ca7e42ba8478648df29919c23c0f4cf14e2428c792f2d8abae1073b97d86c2d5cf2e5beebc7fdfc449ec3804a81199d6c4f24d9b040bd1feeaf141b7eea626c1fa812"
	 "e499b74e86dded2641ce3e11a04a35c8b8831a4de563c3614b4048eaa656d8dea460d2c46f6d748be434718e9f54934804756fad07d2a8ace694bccbd7bf2e33c09199a22a98726d2e1a690b2a9c33e39c8746d8125d93f675c571247b0a060114eff4c32231898a05e3ced4721edaaee9ebab9b46692c65f086d9fcd34b86a499685010ae0f4423625263d0a2a62672624662a6613bd4235b7402573af1b0571c364f7c14e277b84e4a102b1055a1456b912431f9ce9e875056f8b48345ab09bf06b3de6126fae32e2bd61d2fdea29a2f3cb46d963fa40694c02657352b9b9918bc50fd7e26584e51ab5e4bbcdcbc18b9bc17d3efc5935ae5077a269fb8e912dfc91a2c287686590c3e2671f6d29365c044fac2c077fb5ff280b0a4d69eee3b9538b4c8a029a3360902ee8291ca9f1088074f307392b70a7a43ceaa07c47d175b286c052e2412237da3f6acb1eb6b1ec386dbcdf5b49d2391615788f401ec234b58b112d296b389ede47243c01a1a6d18ca5dd3f2646d483b97e41370faa1c023118a1d2006694debebe35046f6e5852952bb520c9991cf9dfdcf89e51fe29d3cdad6f1091fc7c450782f06b09cb8aed1e1f95221af7ad369e49ed672fbbf2d255549d0fc0398dc6b4d37d038a8dc9e8d9b4d6faacf3c5fd10663107cec0e171ea6e1c26eb8a1534646e0813ab0fb449d15b4865eb2e9914d404d06c1e284f66e39d09e99eaf7c2f36997ac6ecb9197f8ea7fbdf7da38e427dd5179ef265f1471a096fd24d8ea2a2ec3b820c54356cd912f06"
	 "9accfd370ca945e60c72b5d479b15d52a5c3c4423c73f4ec06d9201ddbfdaac2e304b1408674d40c203ed48fbf4b126904900349228b28fe262539c9a12270632f28241198381c6e7174d275227c99178ef4942655ec95acbc19a3b96fd1e07b5e0e91488c979e7e25be5ea733bc3171b2874801157c83a6de754ecd05cd78d6d2846e7ce19f641bdb53075dca078ad0ddfa871c16e47da96d007b5e2b2854d151dccfad21875fcd12df56dee7f4aed6a54fa248ba2721ab2f58c1157c85a3df8486f99295f2c9b8e8cd7a65145b69ca93d0ac4fe328e31c07bc1d0af2db886266def575d74be200ec9a4ccb0213743eace8d7d39f810e3877876082238d72c375a5cbdc4d7de36c2ad90904a173df80195cff86f19a0904d18a1f8a92cc4779e5997dacba58770c5091dab5b832dfaab2d0fd102b99e3b8a799ac6e7357b294a31db5f9bc3d04036a4a6e18dd47dc88b0f07e1c4271e5106f329731ce4dea9f56f6d63beddad788d7eeb955589a13990cbe3454b07f63477642613bd77f3bc5d024dbc5c55a0c7426ac7cfe63dd2da9f0d5a7e816dfe5856b646b648c302c16b50296882c62334c9b8e56ba6dab63a9c787fa153d04e5e64503c6bbb9bfc8957d2fa607ecdd3714123dd52b6f9c1a3a73f649dfe67fd7195857955cb8c5470a9f363116cbb580b793033280dfb63ae47b384e6aed677251b63a7a27447f37e9817f10f27c4a0560ef34c0255617cfb90769aea2e5971077cc89022f8a44493d5157ab2962946c7fe600a24f002cfc6108d345"
	 "469a65f2f29b55e4da3f4c767324f173a11567ccc401628f2934989b29875ededce223de3134b7e99384f94436bed28329daff8da5690984b491d43f14d86d5a5e783545442f913dfa39f25f6360d2143fbe4c7e234a40f65b2c48ff5835c3fab67a92d0adbac9e63993db052a832b1c7b6045a495b82ed0d7f1068ec96fe1519493f7376a9f9f331f6ae89420fd1b523278df3e78c7b957f599767057113d5a1895801f1fff1b7021fde8360c4fc1ec8165132244b680645df7a1c0673728ca6323379739905856537091dba18f762b7be6f5f7e95212c402b005d73dce6a7775e90093f927edcf0d9ca24d04809f953ece372414d5f987ec2ae030dbb547db5ec17bef47dcb097fcd2fdd873eb93a99e2209425d4fbb589530fe41bdb5daf8ad8f83e48557a01d2ff6b658368e39bc8324cc2756160cdf56b8d7fe231aa03e82bf0b3f55eeaba71133a6bbf72342727a52ff7d158992895c61c0bab4cfe42ba5e4d5f239ef5efb6433dff84a02e2a5f12bfc35c1062e4103a3f8fdd1c5be28bc83725023c8a72d2cf5103a7c97a23b2d9903a1870726ad2bbaef7b7a6dac3e36c1b92769cb3f43eea1faf95c53db0cda2a8bea38efc1dd11695bb5de4baf583b175a32d49f98c37510e9e56f3d9e10bb4aff163abc91a36f24fb38d33d87fb4299d5ceb5144c69cb741b03d35436002d7740c38753e284a808a77cc1d4ff9e63b9ece720e778497c25b46ccf757449cb3b3fa8e5bb6d5a9f6eab58c97e9469cc6192b7b31362453faac839327067f41f25ff"
	 "34c2cd40e9fee3a0b8133f266407587ac40db20e7d7d397e90558e54250111f540a44a70d427497b5a06c8ef87f6bba0082e00d42adc7eb38e890dcf5cd426c1bc2b4c781b07670382aa0d13e227e05c1987d3cd0241b5ad78387e19dfe4804189dd8a10cab05c79409b9414a6a384cfaadbefcbe8e3521fcbcaf52d92dcf1611ba3a824b576051aa24f42cadd7b7e9841375646740f2a6271d81d2d5f4819ae6a5d3f1feb6f7923f4252872c3a2709a8b8556b3977af8c4423bdbcf66ade1b3c4303539e06957e8930aea8ff70d6a202407aa44c6c8dab0232a33ff3f3ee9f61ed664bfadde8d294022da21b10e0aee583379d8dcdc078639cf3a1ee18d6ee1740bf1b917ff56070bf807b90d5a19f37a5c31214c6a19532f364d463595262ca057f5865f0d55636ce080acfd4e303f03372af014a3c32d2efec8f7f6cd6c825e5edf309ed16008e50aafa2584804c1897f6433e350cd91e155ac786dd9c3deb22a39d69e85331086842f32ba7cb6b4d4f13e08d90acaff24315020f7efb2b74214b14e840d739378afadcb06d45e7bcc17f2a03ed54d0da71d865508900334386ab96e11b88d2811c84539e4e2a93aa27d66620500789bb4d595a8b2e5972b1805d88af2b722e1e9b8aef10ca3dcf5ddbf3d20a6f101bf8f8a8cad825946dbf0c64193689f461bc0c62d138f902575ed601e26184a10ed9df17ad4be7c9672147c0158f132452ea502948a749b474cd0a63ae5cf942609e4864985b4060239d0cee6c78ce4dfdf5750b51ffbd5ee920967f5"
	 "dcc52df6771e286eb83dac1c576f1a073687411cef3701ce6de66ed17bfe0fa5f03c63f96fb40ad70b478aae1e16efe22cb9e8c2aa57d5498803d35fde7f920b32ec686e6091a9ba6eb91fdd17b3302b760d084bda32244f704e14af619a5c9e72bd14c4e69f51177a26174c16d2e3eac934f184d460df5640fd84c3d3dbbc6785c249a501203374c0d58852d52c4c64a6d70ead2af1bca1d61f6f4cd00c3892565e085d3e603a0586d176f478062b092b205807fe7438a065ae7dbcb14f69c92cae4000dbd6804bf4eabf112813ff0599a29b1fd8bcf9d0ba7d9b14e40e38826b48204d8c0a50fd804167c88056cfe77e7a75ac36b5bd049571639b3f02a7e973abfaff1327080630a4bbaf6a096005ca2ccd54f076f2c3311e6e7b48bafbc9de38d01c8a01ee41d25ff0f775a2db4e34566e377683bad9a133482ab87907769bd783bd170b616d48974ad332e3defe94a2e7d6eccfb4cc43cad93b53c476e7795a087fe58cc074b591315daceee3c02af54d9beac8162b70dd9863bcd7702b7c8c72022856f78b2d249cacaea6c1dbf1317ca9e35664c518bf4155501ae77ecc3f47be6e7151c4d5fe56b893c69f1f939cdfd2b68830d9ea47a89fa7b3d4f620e0909d5a97f2637e2eaf223f25fb5ce7949e3ceb87d93db628872fc469f58a749e8b4841798ef505ef2712a3ba713386dc56b83e504c3d24d2ae8200698f9b3eca8d7971f7b82dbd5df6deb34865e2e6336fcd2fc3ff00bf9c8d04992f012dc9473e347ac05aff1040f010b1683c10dcd0bb"
	 "49b7b5883ceb6c0bee4bd2ea6d275f884a37fc7151245274f208a457f4bcf180d793de68f09c7b03e7e430dd34e553362f91c4e721926eafd54d6c8464082d2d4a4c5b4b44495ddb06290f01913e68c7cd95963242df31741eae89eec41d0af689518ae335aae42c60041154356ce475ba0bc7f6c5ec798cd7c493aeac5e08d7ef554dc23832161a615a6b902e1d4f7bd076f3bf045360cdb73c3b2d7c158b74d2b718b95189225a0824a38836d1d4dbc5a2861e62f8a8c2723cbf1fe8951860f0cf7b4c6bc4c307cca509435e077f3947b8fcbb8ba1252b89d61b69b0328a2b1c31255c2c9df670bc244af42599cb5982878fa363627b321302255f2a20e04b70e8f4f63638af83a98ba40c55ecc46230798224de084d2cc203841d91c4f049c9b0a98535f3f905bb80b24679de883470c8225af80361031354483d879f98b78cdc5aeb07b371fea8355d146f9bbe16c9178f3d83ed63e2812048a386ef85d6c35ad696936a008a524f358ec8a2e40081c3c50b73fcdc6199f59e14b6ee213a8161f675d5938ce72a848ba9e7ed930198d9ae6c43dd86d94d88c5312be17b9dc590072e382607390e247869674ff446e8c37d89b7276aa61b5ebeb0ab18f500389a326341ee13283965dd4cce69b666d2c114372cb0e5b5d9921cfdb5e12aea0d95ec0a73c8d07b3b3e0dd8d159d323feb4bdaf6ea184bc2fbed75e7cc13bde26aa597ea7eaf0e37aa4be069c2c629af7debd8692befbf74d6c9939165e3238d8b2b573001ce957942b199e5c57935ecf5ae0"
	 "c3b161b96f1f637605bc29bf5230fc65524041d9970e9b4bd6e7469e0c0bfb62e672b30a7094b014c27a06e3982d83a951ea4207a4d7b38eb155259b847ecba4675c3f82c48343a07e2d5fe16d3189c8dc0f4bb1fe2ca4abce4638a4462f0dd79d69c240eeac8ee4bea297bc1bd5683ca97a352712bb4461fd507f9125f895fc7ca8fc76c7f78207224d0fd142669137ccbac0f023fe1700eef77abc804e9b9da27ad5c3a767202a0d0a36f8fe86e2a8ac5f30303c39fad8b65a206239b881910f9d904f96edae31e4befce7822a7399ad06355bc3c7198eb1a4b2c7c8b4c92a604dfa4905109c35edb62dd3c817cbf5261f5069bccbcf98da9ee5ea192151237b31131953509157f833bb1b482cd011c361d768347b2d0da11b1dc43b392d609f0c4806d7325e92f9d76ecd278fcfb9d91e9993addffa55d66acf9211b7cdcf28c73bd4e7cf83a869532c90f9880bb963cec69cf40e117b3fdf9c0c5c9d6570a2458aa9d14716ecb8b6642a4cb1fe0fbcf8298ad0db3c676b9836910658f03bd47ded56ed210cb1e2f1088c87f4e225faabf29e2d450468ff6614f282e15b4a6fbcc9463a16f802d3ba071fa5b009403478f1088ca8a8d9eded648be7394aa6bb3590c0725ec87fdcc53c4d2afea49ba11f9f2b3231c912bdd9431ad941a7d89f70d8e1669e90553b047b5f4a033437fe3b84c05105227efb5390e6e99b597fa1c35a1940f513ee8aaef9485d1ffdf7ce94fd34dfccfa8f178dc113c32082e0345f6d39294ef283b6f9a566a87b1122e74411"
	 "8e643cd6a2ecf14e47d68254d26942666fcf957586497c72c9e5814ab3371fe4b0f9a7fa1e5d9629d0dfe9e93fb388865a599076e7ba983365fb3bf574d335787416c099c545feeea69e3069d841b62e4db9833e6865e24cda78e2bc46ee83ad5d79bee507c44007200e64b5d1329930bd658e6f051cdefdf758e5b023650c2abda7a6827ca394c086057c617dfa8c161ea1f953446d8e0d5f6d5c76bedde8d596d1641a973e2b53bddb8f7bfcfbd0fbe4883f4d6d4e6f930e51d47ccc40148e6ed1b409705e9a777f1bf86af2621cb1f04ba160a5faad78a0949032e9dd7e34bbe6b2fa1c478a990d3b7c474a2f81af7f7246bdcc669df005adf397cef71869237c53126d1301ceab14011a529d4897cb00f7d93f35031facdcfda8110b9fb5d55a057ac9087a9cc8f1034e03f79a806db8a8e726e8afbfcb2c7c39d3315ecad3a2e542d94753b88717b7791c66c47a45f499885f6c096cb1093d9dd6082ba8eb2132e4a80e22ee309b7f74af55530e190d73315023fe4b52fca855a06fd111fbe1125910f4ace6dcf228447c007cf82fc50993de0202d28aed32ae795d2d75ba8c975b78c657af*0", "vilefault"},
	{"$dmg$2*20*186673f316ce762e8f2b2595b3e8ea204aef584e*32*df036556654b76eb000000000000000000000000000000000000000000000000*48*71793cfc457320157f12b1351051f60e59fc80a728f82f0156cc8b3f20f75bfb4289c65e6c8c21589f3dc6187540551a*2*5953*3c25089e22f54dfa868b7460f43185a32b6988681952eca4a493ff4699e2340f8cccd06ba2df28334dd01b83f8bafa3754b7afce8f859ffaf64d33950a817d5ffa9671894f71d6ef35aefd00d237f7f8f413b8b8424db42e6fe7bf503d1d4222d77d5c3c2a16f26a1e15d7797cedd59fbeb45f70ff7731cf8be628895f13cc2937f82c92e0d5c6b6ee0214c668ad1ee4f41501dca668af0f83ef252bd6b6444f9028f12ce15134fcd8610426b5a6a75ac25fa938f93280143b5c991a683fb008a08e133a962dd4e3aa9ddb57e72955e3a840c3599b84d874d61cff4236fb487e2a344ee3311d30a531a20ec800ec591607edb97599b297ac67e173a4f7d98ce2d73b66c37659bc75becb65b799f0a1642a4282ad623ee574091821c971363128e307288b4377e1e90e831b800936f2b5eb05fd5d0e505d71e7e34311950812131c5b742ea238bcdfacaf35e23a4b5b9ee2a7c0da6aca0ff02595fd4229baaf700eab8ce7ea772e133bffd5665ea3ccde2edf61d11e64dbd1919454f977a31292416c86e3e11b762a3c6f0c27cf1a07ba3c4197f21c8959e0f04fae6a086be6e77b47495d0cbfcfce05e34ef361d45b1f8c5068f0174cbb2ec9a9f37eb6ae1fb0887"
	 "17630b97bf46c801ca598878e6a8a96b232266479925e8f170bf76afa4acbcc6c7daa51c2b9a1821e5b5df170a8b57aa371019c240626b2f2a9d60587c34383ea7c12b300fb478e2b62ca9bf54b00f04f4970a68d6689c4087713e9b6be1e7c92ef16a7cd527d1ef33140d8d3994c07d8ae237e047bf478f164aee1c6300545bf986e570a403ef626c5fd14044611621bc5d5f37e417175a22288c2fb45b0e11e946f755fccdd774e5ace72bd2ba44be8f673235e9b49c0fd4d6a912493fa797bd97462de0402f77da7eee2ea6c0d02fa880ba57390eb1f73927d4616b95067d18103ad4b10af7a40b35e620211acf4c9f47fd12080b2df1d350d17afb649ea5e8a038157561b107e7d1d00284a59541c0b759bb424d2795ff1d3bfd7749461a9f67502df649d2d69e72036ab4f8869c7bb35fc999a9179612524e2f9bbb00e7dd5ef8fbdbfc486447ad5ea93b7220608aff49eebb98a1de88c68ce2b9846a63ac6b8878fd645bfc0c0fea6bb746b15301f58d2b9d2ace73828a623885fb495761be85780668b436fcaa6367776dee9e3af641ed5755f1cca7a931c97162f6879c7a3bf6eb47f98590d07654be8fd8582c5774f89bebf6fb113d75d28afe74443a64af360f41b9d243d8fb865039d924fff4586e3c76d9d0d43f8487200e802adb9e01460eb6ad5538d8549999c4b38c41dcd878b8dbd049b853aaa4426e74226fa19d3d501e6a93aa99dcea681f0044e15a05c2d08ae49f625ffe88181d2c1fe55e91b6f602409fdf961af1da851fff67f1e9"
	 "c9ac10dd3960f460bb8f937ec415870cb9e99e150f5b2a2308f2136960d199ccf5900f130a3f4610cda347991cf34fe46717071dd5ab2e8dc5bc20757fe6357fa56a18a606b25c51612975f51cad52e5a20a8eb2cefc79732fe19baee7b8c65167e2949a4ddc8d1e262b47c97286c2d0fb7078b3f553453445053d82a865320ead1ff4bf4fea84cfd7ce21e7aee696a15f92da1f3d73c394d47a254247492fec3b6582c94cad0df1b1b097048c9c91bae6aa269f5a074b796bf86770059cc767aa07fcf84010b1686437042d16d693775a03d9832857bdde9f7d98392bbcc579db3bddbc58d8cf08f04064e3eb92d87829e6617efab245cfbb6d564c5fa333ef560d6105c525e39177ff5530dc154b691b1dabf14d0da99229a04ca5c6e7956d474c0ee578b1b287b0a5971506687670ea848820c44875c74e69a79b36eaa3cc2a5a27fd5098f0fd3c190089736a271ecf3f14b3259cab95b941bbebfb5be132d875328a1b0ddeed958e8ea454ef80724f878a2a690bef56fe3ea62f47cfb6db303ae608957dbbd57735195d6b1b2ed73e69d1ac4b4b4fb01c20eddcb29e8b44bbd71fc25515885a56b8b7e55edd4c21d5e8cc43417e94e57cc49f279d0ed740b286d4e27c0b909729c4250ea2d1857f3f7d801a87afcee46f455f8a53e211fa0a311006cdde262ad4bc47941bc52db89c4b454b7075bf29d9cad6c98b7e84318a071789a78d1a83ece7a24cbf17691aec06c5fb7bb8a832c0aa33b27a5b3a68ef36364fd85cbd19e8f75e184c3d1cbccaf7eb"
	 "c71211506021ce0d38bf8c0885a205d7f4a60f7fbc972c7e2365b07d5a52fe8ae02608c7bfb1650ebdb4f2620f2698f5fc90c7b42a34a31732d2cdd12a4bcae3ce399623211946f74c67c5e82c0f53701bb4460504e17c1d6fa14288a63d97a86068be8ec36670adc16670b5cb3c09972b596cd441e4bb9b50471708bab77691417517e91883df9f0b353c2bea3d0acffe5410097edd2b3886592cc70ccaccbbf64d168637a8a3fff0d143e497e5311a9b13b4adcbe8d2625dd1fcb5ffe9c83ddd4a1cb3046616296faed945fe7b29ab6f912be6959f8768ce28958f2441a1e161147145a1621693b9f2d24fb9c7a89535456dab48dbe15c689709e2af6a6805edf923d8504f3d2cb8220ff9966f854c84e9ff04fbf45e42a5c73df4f719b9ed287695a4a03d5c0a3a964a7b6e95bcfc36a292b23774812e8567a02cb8a5baaf89afb900b3fb7be40c9e8432656307fbf2487c0d1f3baeda11e803f9f298e7e0c478f9fac11a43ca32e2cda46ca6491cc7b31aa1725d24805587722248dc326cf81fea4fc1ba9a58bdce9e34740e3732b96889b36e917cf029c7027c5cc985f8b3f0fa4e504325d56c7e653ce903e8410a6b06a2126b3aae2030404441273c1e486bc8285dc078c1874635e75cdb753a0fa821567e8116179b78039f8cc52675d538fe38a71f46792af445b125dcee671bf7789f2e874b25f05a431ce574a2d85762ceade5e5cfebfa5ff62b1ef5ee155fe418b16638c1562b29be425e05ef0237f03bb42181f55d4370272a13d5fbb353358d"
	 "a434519cbd0e4fca54f9cad4a7735238098d3984b0cb9360eccfc63b3b4339e0ad2b2719552085d7445681c919f21a6b482402c271e34d7f9fbe4fbad68eaf825c57d22ec0a2c5ddec8c1273131b867a3760626abe779e37ee632f41f212e9a9aaf26fd5cb28df689d9c4875c49db62213faa1e18c35b5d2df1fec21852e7c35d20d6df85ca2a6b10898b244da31dbb6de3a3a8553601c0dabf1e5f4755fc77c1561223cf0b1ee43441c3aa9d855df0831db6a7f6949ff0ae1cdd465aee616b789c268417de07e9c0f0ddae6b07ce5186b3b83ef96fa1ba9fabda1bd79986efa852a348364e33e89458550049522e64491a9b24514665af058b4be4ba690299d3c2379b25ec97575a9312b38d3106f805e829bd77033f4d5f1b35ffc7289c118749b31f17babb56f48aec597049d635c055d056db0434493a379d15010f3325690444e1021abd622d18ea7e0b5d5b97054708ea9087b4721bf857e3504aafec84516feab2a6f6309a506cd3e931ef3ef47807feba8ff0b6dd56eb83349d99be8633675eed19be804c06d4d81b0a256ec95cfbb2b6565d7906537c5adc404713baa8fc2e0f425c577660df47198e91d2eb3ee7a9a5025641aaa759e7e1f3dfd85c83a17a6a59df4af62bc669f28d12544254f4e0527a6b10958664af9378e41aa9f88ef3041ee6880f23a858254b5d0fa7899655e9d06f12fa863b63c2c950a0c3eae774149502f0fa3c3a44d24add7f9426ceaa21dcdc5408f0b96d63dcfd97dc4a3ce03ccd56c8d48ccb253e82d50123e8a51"
	 "76ae5d1b9cf6b6c11d2decea9f91e9ddfea605eec75391ffc4e01f4988c0ee78ccb3adb8a5e16644eb30e7e76ff251192fb3a8c48a68224a2cfee4aefa616ccbb68abea13d335a4b212b0b9841a42b418cf413fc868a842a26950e11061608a623a5dbd520aaebddfd1a559705e8cadf6abfa272925651f84130223b0056be28b618bfdfb164d2c5db86d82ac0eb2c457198a6cf8b0c2f2560eeac4441df45a9192cdef63a00adee0aafed7e0ab0bbb0c0b9a066f9f45f5e0c6a9376a069a45512081ee3edd2e9679d6c46d71e3740c5ada7457fc5d21610edccc2bef851d18f89e8307105855da15dfa749c44370b8149de48309f99fb5040d05d0739a64cf253855c185550339af73be6d5cc2de3186ff4b004ac816c1f4afcc83ec3ad66740c57b9cf660de7ab97b0771189fae5957751eec58a3aa6d3ec6121bf767d13533ff413c84c1ef47142f51ebf515c3d60a3c5cc3b9eaf9d43d2a84b94ce02db3f254862cf3c6330574fde5f8257c215c416ac3c9833839d5b33436fc12c21046025a4b0be90f18dbf002e001b8541b888835ad138def9910c4546fa0cf496bb4415463cb10004959dc6b0e379c18090bbd1aba6e9588fc21a89778ed1a1c0533049867569691aef6bc310fe4853e9e9bdd94a58943017a197526c70d2d278c66e94aa97abe5af8d9faceb0fd4e102bb69c824a1e4709be2125de420aebb11506bd62ae6b32eb1bb2cbcbc35dda3c992193086b11203775b33dcf4206a976b31222fcfd8b0e6beab7eed02f9f6d0dc2959929e1d"
	 "30c856a672379ea1a20bdea6e023fb7ada31f6f9e02f354f464b2261879372c0c92ea462ad11a83d54bacfce3febcafe14753d697e905a7c77031beb83076444aebdb99cd1aa470d5774ed91cded7eeccf7fb18860fc39577a054b17aacae86d02c2dabbd3ab068c982cb095d135c11daedd863bf9abafe991656d1f7773cbc05aa66c4c800b5763fe845d06c3b19f4f73dedbcd50ea363aa11e8274d541ab754209fe7fc159e7bbe317f8d9ba602bde8fe02171f8daf608bcd4663eb401c7a3f2cc814bd8fc195cc192d4d6fefbb15b9d9738f5e6ade7826d65b9d8477ef500afe2e40077b6ecd7d3ed78233fe980332a313fb2fe854d6becf9ab4c1008cb1b16a513d3fbed8036ddaaf372e8891c59c6e9bcdaf2d88e22d528b975d1a36af2fa792028a3e1161a74545eab1cd6284079c2353ef1c49e3e1242ea52d22d8c7d64f553e4c396e7d62c4a6619ec698b56cf25cecb6673d8a3a703f65e480f1b8b91e4427e9f1e9dfa1939134d03cb3115167567835d449f50cc9bae06adc68e3211d8e0cc1faa34f7bda6e1cfb088fe980397f4643e89052d2bfeb233ad81c3cd466bca1b1007e2e6459e3aa1e51f1a326a2f5d89407c05946b0dc7741f458464b5e4ceea5e367a2e4f0d007e9e31b24f5b7bf69aecdef4ef57de58719cf9fb5e8f5366452013a5bb69c3f1807d83e26bb63493dc141ab1ae8eeea11c495650b346919de060c4af1a80823fb10b4cbc333b9d6d05c6a4c293a7fd524c5259a841500617ee442222ef2cfc71a0e4bffa87903ff5"
	 "31898a44452ca2b132c4a633c91c7a24bbc885a01001988ab845e53a350c3b283dda71360c7a9b47ae40f72737ab6be068ed8ecbde1d0bcaecb729c5bea691ba0de6867e6e6879fdd99efec2b6de4c2691ec9031189491a01329fafb2f0d0cc28e26a22bf55be6ca866dd4a473153901f244c63967e829d9ae2ed83451a365558b697055a3b9a6bcb1bb40ae56f13d4b60defeb1a06cc6831e175ccbdb92a34462e786ea28e2ff25b813b63b30ea3b8d9a0921a5a5bf45576b39fbab6071fb1412670c936b5fc31d668026d297c5b84739021c4e763686e4011a2bb7e109db8e1d6bc853235a44ddd93f1012f7168ba3091a2a92a3e05bbc761fd97ebfa22265e6c1c2bccaa9d327d4ad61de87d3b5f0c5b29e604f79827064e05eede8b574c8982bcc0439db27b15bd7ea9a38923a1982fa7063f9f1572963c75168d53756803f6f60604ab33388ccc1294fb0ea143fa5e128a060da40f4dfa0382906b878a602c568f3c99809cf1d5912f224b2adfdcdda84df149217bf8edae18fb4bd825900ddc57ecca2eb7d209ac44e06e674c2b7c126756bdbad066dcf187344824050b16ff9414fe957c37a048c3a260a8dea72f7a12bf5b35e1c2205866bdf85367d94af939bf52a3027e2c560ca096a449b7297687bee98e4cc56e1449448461d028e435fef26f060097cd96bd605d5a1cf6b1cc95c49037401878b85d437ee43bcfbd7b2b8c145c05a33fe01226a637dd677bfd28c8acebc4a30494917c253957462cdd5a3d200e350f5d92c5c57bbbc7b2392e4"
	 "569610f35e3707aae8a481b8500dc8dcfac689a018671a0f3634d18fc7bf4f7c58933da452308e348a446ade0bdd6f02d29cd8d273544ba46f1767873717fea45f0e0980339fc187acb7045612e95db5dd9c89169daccfef2e3a01c4d19984f8b1cc960d054285119f23e746d743a0db459bdd5803fcdbfe92137e80d47c84c547848ae563695cbf113253b8a96e368bdacf59ff73c023d043348c1dfaf143ed13424662c2da644c25b9d22598813e1973f30ab103c0ada9ed247ca038a056d18f2e7c8443fd2c95366b387e9ab972170cd2b4438455dc73619ab3444da0d64b0b2d3a9d640ea917b1c09d17c37fd587eedab367235e1748dad753e4cbc74dd53017ba65571a5a65269666df0a24bc694a2d24e862830e7808ea8ffc1fd6cf4b29564c8d77d9692d7fd55e496c69f5f17fe145abc0dd1818f2cf6eb979c33eaf41050901dbbe5a49c8bf9983b1284fce92703b45c4131b3204fb9edd58b6cda3918cc490051bf9d6751b7702e577b700230f1820238b959e46f7dc3a3abad842814c69a76be5376c1e7b35e3ad7318b3439008e4c3801bd6754fe67cc7aed658d89550a30cbb1193eb5d2144eb7f84c5c6ee9e13947daa3534ad4902ceb9cedcae471547bf95e2337760322b55af97457d23d174b1c6f3e1d3585feb000953e298e35aeb467e90342bc61bd05af59c72921b2fd4795c19bba268bc6bf4f18349ca91b89cbd6814a62dffd4684ab78e998f7e3833b51ffc495ca3e789e685417a0d972bf4192b0c50016a64ba839da14c3c5bdd"
	 "58a74e96e56c66d73e2869323093892c5272aba5e6edff5a8976c5e04976c8bc1b8cefa630cd924b5bc7d28dbc67b8aac4d7571623c4d412acbfdf61603d2cdf1bed6fdcf8d88519a3ce3c4803317587c4a7dd33147f66aad06554d69138959fc3172298be9f5f83748b83c6618758bb45058fab1bbc1434b993890288a42910b91bd52ac1abe775acb09cf7173ff9fdf0e644ee94b000c8ac5cbce24d424800a9df431e03c650b3f4196115f100b49b7a41f68ce27e5dab5865b40a0977cc1be995d3504dd3bfcdc8db2a57765b1a80f6cdac0db795336bc9ffa4cc163df1d9d6e034d5b246cf59ffb2f81ec02ad4c48eb652be03c97a11427ab519d8fc8d704fea98d597e44cfeb168f3fc1385f1a1dc5926dfda78be4c3a3e1d024e4492e952cc8471ae1f26150cc065bef433c0431128c7df6c57bd79dbd409fb0684137465ec0687ec2ec45c6fb76eb88bb7bfb4df3fe69421dc7e0809e2474f987a59980fdd92b2a66ee31fb9560b4657a112ae523caec636642e44b507ed5a900fd65e29d35c89d252708b7f2c2daa29062b94577b0406ab9cda76c921694998192078e2ba7a90386e1544444c228db678f9c7da51a06b9c0a22ea26ebd3dbd8880a6e981decba2f659ddfcd15af8d06031e2d8ddc587417ab536fd4cef49372e0510c58060f2900e030fc894f1edb6aea502b0e2642a8cb1e0d22cc11a43cfe8eda906711e059d6e4a55959cc337dd54428eec2c123f5cfe185a78f442266f54213537af2f4b42176951bd9b0d1b70c61ef5e728acd"
	 "1a5b0c8f0360fc3d4106d1f1a6a100326500e25cf6ce2c7f230e5e54526c3affad6bba78eb0a275ef942e441919384b0420571655eff68e32cd97a322e22765fe736eaf329f41b2ea005ad56acb4c092b7bcdbf2bf3e54b058827259bac8bd94ea73e1d61cba79deb078857c63e255da3b8ed4bf5d4f603d8e3e19813fbe997afbd272102aef06950ab6daab60139fae51f0fa8b48f3e056a360f074692f982aac57ac3472539e7484862997ed283dda8be4b22b83235299d1b20df4ccbf0fa24faf392a8433535d3f3cc3ad7453b9b150dae24b8c78f149b53f5394af065082540b46f6ec3e70e2428b873fa564b548cc1e39fb406ff897662ac7e901384b3094c328bd484980c120518a8504511644b0616215df50ce1ab6106762d52ef24d40b9851168c69b3068682525f1050fa3ae139c9500f89d1b5a96c35f71e25f8ac229518a79fbdbfafcd67d7356bfc3e9699f0e5a8c9fceb068f810cf2c8e3042b5fef34778a3edcda569dde4fbc240996038e50e233652eb5f303fca7f8f29c633684566f6548bbc311bd24d7e0ba95da8f02917048d9777e5f142f83cce4187ec1af72b6b6c3825e38646f9f29697f6fe3b3cd76*0", "password#"},
	/* test vectors from CMIYC 2012 */
	{"$dmg$2*20*dc39029a22b86bb4f930499578d0dc9eee69398e*32*bb47bff69b10ae67000000000000000000000000000000000000000000000000*48*c4559cada09552ab075e73dbefa4aea1aa21209011946e423ca707753a91c87f6c4cbed3beae20a244d33568f852068a*6*4315*504c0c37c600618fd54da114fc0eb24d6f24585568543126ac56c034cd8d7b3dd991f1418d0c95791e091921c02bf695b7835f7b0da2c1b96524e72b4bd3f671c592aa176b6a58de77a35a26bd1d0c313b2ca23581027fc52c7c63f37439404218d720171d3b178125e6ce0646bd6fa1033f2ab7b6849b3a35a430cbd1401f73b5deb478d6d0f58364579c208c613cb2349fb19adaf98be2d4a74a6030215793fe4f1129189626bb87c23d26dc2af51a98e1fabf2f58e106271c7759d104b9e5171d8f952ceeb14317614b7a14a5313029aa4068b898f7e0f5b68683feff0d375f2ada37f20135df443bae913c7e96a29c6c3388b4b51432add89ee22826ad0b1b0a4ca9233e691f71a5ae2c76b5e5a135dc793e081dc53781faa4f844928db94084b53b39f1820c8342b563e3f46b002bc52ced63e4588388e69c9e85e2002438a1a703de411717d24ea88adef3051b27def61e4b9a31548d3714c3bee39fed866254033a123429043d0c08a052d2999a171b010ffd119f90bf9222462508ac914e0a68daf93f63caaa0c4302c9b1f6447ac3856b09eb45096b3a294731f110b90826b0d611e6e045397b07e5aa64afd271f1c92664e648af648642f786c0c8aae"
	 "6218f4282d8efa713dce232fb24df4073a0e04edc86d940e8ad22db8ca751143743f9f12585bd788551cc7b70821b5c42b133cb7781f60d1b9c345e9adb122ae444be456b8e49f9bab0e2033019b52f2ede4e7f56cc1d1dc3a48bf0666cc7a4dc6b4ffd5077673f2f6761688e4452a4c11b82598cc0ef57213f6c7c12ecc67164ae501b3e87e25a361d0615e48cde249f0193f2aa69a1eccf029340531becdee8eefbddca18905451b48c1085d4cb965786d3892d7144841300b8d2722e92af50fb828cdd8e825dbfb16328f7cf792f311f84078d45306fa570661e1ef2b34d5d36de2fc4b295f5e84fae8d55ca22bc15764932d0c5dd3cfd914b2b8f67477b2b5139c822ee2c511a03f7e9c717a5e8eca6c4b54f9c3b7d85765a78f03b29fb979811ff0c655522b341bb54ae3bc412eb760eb689c6b4c3bfb85a8ce794946214c574105e577acc01d3f8885e72db52075d05a75260a6e4a54872d087040ff38f8942cf150c3615088588cc53fed11040bed573c0e9ab14b987f9223ad089bb73284443f61ffdd61616b8a783e85618217e8bb491a31b7050421f4b0a0bfa5003775933db00e47e4452adc1433da2603f6dc5b9dfe58efe458da25699e512660ac6f1129dd9d7b176a24109c6e6e0c201d784addc9c7f8d4f309ef6fcfb02493abb7c836ba3a371e64fea941031a59adbcd4ef59f0dbf31f361f4282a0e60ced4d9d17675b0422faa1c2f932cb525ee07df7eb2643a67963aa99daf5b119884557ef1585d81eac5c8acf32438636a10d043bf"
	 "47093fb53a5b3ad544a38fbc3588bea3ed616167a79b2133efd8c509f53626b9cd7b71828fbd5d61b1df6ef3713b5347f65e7c0770715ac1fae561cc548864f9cfe281c6e5770f053f68ace64702c81c97976f471ad11c7551789ca21a4d5480c5d3528503f2f7fcb268c34498888d5fd3edf1c71d12581c393db2ff863e22c1f6c037106e5928aac9118702b45bd36782b2295782f93458dc120e79cb3d1632c2c5e527e56060b79a751cb7653b8c0ed2acc32168b56fe5b50ff9e49a71dc9b82f812b53e095660cd7d59c04f31ee47773a04eabccd7a4a6455ebc7d719c9eaedc4e6c935fc99642acd3e60e0f564efae90d7d1308d6ddfe7eb89520c234cafca6bc7e8ac96ed401bf96e3c9de704ad124b0f9381f22d9ce846fad0b14eeb5f93eb0e0fd0657c480fd2a1109d735f3825db598e2aa7e624f282673947c38aee8832ec8d4dc5d6a7306e3477ab4e37588788109a3ed76741f8f2a796d0f5bef8247eb298fb973c4e5d13666d87b0bf5a7a553f208050dd7140f64fcc27793ea82cf58fd86ddf805a700065888bbf6b5037815afe8c03eaea355c90bbbb448de13773e977fa4c6f06e7695e80882cdac40301b537fe254eb1ee437a6ccf3efa68899a7188e6829b58977917a9d6124cd2af7cfa567fb85aac9c6b971423681a0b6658575ea0dd32054800e08be5683faf46165c56647e1c346961608bdd8e6f999eb033caf73f000a71961cf2fa8c319f4084c0ab499caab87d13aca3f057d17748522f08b36c56c1746e49d731f9355100879"
	 "d7d114000293520c9ce71098d26b2114030615aeedabd5a6f7fb9a91f98b7ff00ec72c82136a00e5a19384084e0aebc78bb3cf05c3c1e3872f56e254c68694d930eeb46ca8e99329eb923ee0f1b5af0b7276e8600e25f18642247111eca41da427e5b9034a6a22627734ee024c2e2c4277edcb3a0309c3007c19416fa131086eccc6f73784e1a008dba5166e7c8aa4cf8efc3a4e14f59d665800982e46341b9b098508510c7dadde295a784f7a7085f5ddab5b6881b305f99d87ce3883e557280bf2a1f3adc69b7cc9d4f339623d21d569230e57a2bce611de7495d403adf451725d7ef11df4bde5a31a95bdda0d0c2a7869ddeedf2ca7e1986ef430ed44bff6ae6e44f740b2c65364477ade4dff6f4eacbffc67a2e0494c81e0424bc9220bf20aa795e2b20db6076667088b6863243ccd2bf897d4b6e1e58e2662cac593fb9a86220d65964e7f6e0f1987d07a4a8242c41c001ec38ed2442011d8a56919800b4d590338eb8db02833031ed0422bc08b11dd59b59f1d301e82154803076053464120217ca64bacc02465cdf629732cf709777452e177f4a4d1015fec4c36337ebdb8daf57f19bfeb247a27131ec5280038f3d1a766e071470ffb685cf4d9763b7e1b5776589874f3cbd4761d5fd35638918ad144a4a1bcedab9d652477951a716e4073cb36640fc257031f06e4d6f586a9a0b6172727933179e4cd433ba940571f3eb908535a12e9cc3ec1e8f8aa9975bc17241779d972a8fd8581dd3850905cec48061dd5fff1b295757e38ed8568c3a2967"
	 "ba271e00fb507b10bdd5ac5b90426e48e596ed430b5a3c554ca1cd0d18a90809d8db18853e2580cf2b2ca52ff686b7cf360799bf69c008f87191ee372b44f96696a12632af003eba51adf1e6101628168b92c718c6f7aecb765125880f180047ec3b89fa23bf57e4fabbce38ef0fcba829123f0a3ff527dad6d6b5b0c4b0c4c4cd13787e98c829bec08728acc5e90ddc6bcfe2254eb29ae8450ae87841a39958ab80a38c8a742de64a44e25df0360a9e8672148347d7812bdfcd9037723edbc5fb4a8bba689dfe3baf113778a498e2689e8cf1ad194df422838a618b0cb222aaf020705fcfe1475a8c205690379cbe2d0b5f9a0de41a4d2e6ff85f1f19a97712bdbf49bb90051ab934407bdda9bdbc1a57b0e874f3b2a09df45b7d01bda15330ccc57a752deb2751e495e394471f09f33d98d8face401d418affeeab86be36cd8cfb0f435d9939822041f256ad860733ccf137e582e1cfb5a8b96ffe646d1928657c05c67b8589a90fb32e078697fdf8a3ec58dc6d350a7f50c83d09e5884317829d8e850b7fe17bd2ba4d7fd94b86d060a3a97880fb350b95cde4542cb7d1a2f44f8ea065ae30fd4d4b5fb24f787b8462115b3a918155bae098f0fd7ae2d4646d3731d228909f690cf0116e1ac15899513957834e0a74d8c07f0c696cd3268d631ce1292f66b2633a3287a7e058781aef9d3d566e4e41395fa7e1793aa9f669aff116b99660a5a29fe127a0459eacc3fefa4be95a13499dc844d9faf72dca38d8032932084faca23e4022869f2034ace2de0"
	 "b286e71f2b569951214fd2eaa3d32da48a234265acec4967c74976b5b5d635eb12cff038a4a23d6c8e86a11a408aee5eedfa7209a8ce8d6bc10271e4b5627e16c5f8ce8000882c461de0113efd8ae9cec6ac4819ab2d6f8a9f189fa2929807fb20a895204edad9821d180c54e865548f9b3eafd8073a734e61d574923f0d1f69d266d970102434b0bab705465833ec9926b03798fa8a95ab98d35863b7490db07fa1abd600abcc3718d105f26f96d20e593ce0c82efc68ae65d03e4e2ed3faed27bc5799e359588fa884ac79c1ad4f5f8bcbc9a2a5605f97551710e2e416aacf149941265406490d32cc6bdde994943fac2102e57785dca3c20358cd431cee285768d9eed6ed32a9919e13f1a38304db6a57f637b6a5c8adf4e829baa82ce674ec7444fd9f7f1807b8f65d4b68ef7b6c3fe5bf653e81525f7900916f5d5809a52c070256e6b4cb332fced5e460c9a2f62bd73392bdf4522be7c211577559f59f62869e0a71f832ff493fab76bbe70f3c0b902fdf45cf49793afdb87558f1a6ec289018035d861990eca1dbfc412492cf86503af00c7db7a0a2c6374eed42b440293938a36f61e1c4c187cd50d974f2a0989b05b8ee207398560b516aea520044e37229fe0efa8b7038441fd584d79c010c0f31030d60eaa4dc1fbdb5a254c089198bb5eba6fe20655808c1d22b9604af1247e2b820823b3c622be2b01ca5f16f86af880908ace8765520c813afefef18e2c112a72fcd4760da91f7d1066cb5c8c902745b83be8defa193bc8b6b93a82efdf17"
	 "13a223660c6ff4dbbbaccb1a4e5482cc238388448e8b9c24c9aa3acac9467e1f6d96d6deb1cbc9fbbf77b7e756068e22bc3b9e6c275987c5eb99da6a5e2d90a1e0558c4f9fc392371c07a7844cb947b19dd1a6d9c1ebb6496f36bdce2967bea2971cc1c6330b1c31054c07f8d853858a46ae9370ff1d6ab755beb120a61b4774fba521baec6fe8a079862a0471cdc5080c0f073f7e3d33f0f25978d098f61bcb4905c776ce6c0562dfe08d8b9f17de4bc2048d962ad7f4baf132cd0152a904fea9530e7c1f52a85c0188d6ca38ff9b692b2a68204a6dfbfbec06f2d800b4444503bf2dde736be4108845c5a28909cdb42391b5a0207c157003b8dbd4e43996ab5017c5f21cf0d4d9b3145c0cb70fefa767b4689cb750fa7657c4a788b7759f86496998fd4b99b2ad1b2918bf330c1a81e8986eab031e9f86cd93b7d623c72e1a394f0862a193f21eeb858524477c3192fdf5b61ce9dd5b0bf3b3d7adbfa828f1a9ecd4dabf5e318fc40262f0dd204f28b934d1af7b0d7cbcc20be21f1c7e04fdf76104767892404b14965bf8d53003ca9ff0a8f15f5d9b2e152a662ddd8eaf7902854d8561ff088fe2e880a18a036d06c29997dddbfaba32ae4ed70b47413c2a037122d830d55bfde89ba645562cfa1d29f428da108d93562bd291748a728d1b3090b8a7f56293a3135f05d6876021e92aeede437dc7ab610e1e5af0a00c880887754d76b42b059f32f9159d25ffc56a993661d06a7973d190fd10c4ac998c8627b494444389c529e41982726f47135212b67"
	 "8b69ff36ad29e225856ad2081bd393249f469648e6ea4445e0011adfe320b4eb5cff1d9332c1779edae5d5d66931015e793f730be8482b5f488ca6372edfc71abc4b8aeaecf8051bbcc848d736eb0aa0d7ee4cdb9eaddfdcd4200c3e2f58a97a162565409abc44b8e982fb883b619fa80c7c4f2318954767ea1c63c70124f4342118f2c798adaa7ab5f6ebed1b0a15e12f40978ca8e5f0972a47cf397746f9f482902abdda10ee7f4c610935070f888b5ef8eeb07933e1d6ecaba243fb475b4c788cf8b453638ac43b9f6eb74654835678b47d9437a14300a12553fdb10daff3690e0802dab80fbffc401422a465e10e6414975358249d68e4ad5a1f1c93e295bc10b8c5c11ed98c7ca5773014a2739c0592dfa30d8756be1f66e4fcc01beb2dd58d87800e71d136c12b8f73298cd37b1bb5758376b2111921fa9f7040e69d3620415ace96ebf29fc1a87e392a9e701f4075208a1a8fda7a59b28997c017da70c18d2bbb5c91db86d701cae85a5742842fafec723be9d93b4225619c7188f5bd23c900ef3863068785363ab861b58aab8e91b562b26f72a812e7892ca0bb6ed91086a2935ba82938b367b34f70cbe40c02a8cea92a78588f90cddcabd2738c9a18450f6d3a87c7f827a1773c2c7629452f64e1528258a8ba75bc53245c705246963369f1179a765bed41d*0", "654321"},
	{"$dmg$2*20*0e2a3f19e5f9a89ef8371580fc08738b0dd02ee9*32*57b5e138dcba821a000000000000000000000000000000000000000000000000*48*4a33cb05d5fc441fe39477724556bf2a3445d2826dab91031374075f9b5cda25084769a7af11b2e678d79514be8e5f63*2726*8192*585b8129cddff9f9f5875d62364faf4dccb0625867ebf2cf7ebe08913e340c8bc5b62e4c4152b2274a19c3fb7d0f6ee32e7b6c502073785bbc213c28890b9910c878702b2e16ea0c0b0ed1462b831b1eb02a0a5ef586de3e1bb7b5f70b64e713f2bfe7f401ccf0a4430981b89d23afd47d05d1d28d64917ad2895af8264350f306b7a0b67029f6da75fc60137b99131d3678cb8c596295bef4eee92110d09c52cb30486709fff75b80753378918af4db98e69905245ec52c2c6ce7e71ea62b6e530269af23836fb40cbe12a1498d3d4e66ac26b04c31d4a1cc169909f51c0468edd44d051d79c361f547d7f4891195b96950ebff98f70b36106772abb775308cd6d42fae3a60d748330dadf7ca90bd474d05cdc678a0cf41a5f4461285ce0ef0a6df3a400d0116d1d1f17cd10be2c8f164ffbc3797dc022ffe52b69f0303526d3a17c113a56e67e54b4de121787dc62977af8bcde3f4fb596762ce31460a6f97d3d07874ad42f97ace146ada9b63f579a411fca985d85d64bd3262d1d2ab5721119b0cf8348abacf7aae2f57d3b667a5997d0fa448d3da4c51a6f59c6686a92a35ff4d6d951dc74acab9d956e9a942d9356291f56046c612ff09d1e10d8a0c60"
	 "bb2a4d273b03962f5399ff455ef480018dff09125f6c343f28b13acdbe7f0309e64406d2c453d57d6e78f10caf01d8dd274e0ca6e4a82a208750de92640ef97f67dddf90b0c6de767f185b6bf17a119a735cc97075b93fceeda807d0ec20bb4ed923ed8855202d7d285b767727bb5db55241cd21cd5a7353cc872f0d4a00fa0a50608eeb4cfbda71109a4a2ae97f2c01a40c4968c32ff2c01f05ee768b2ab22f12697805396916d8fbc1b06eeb320d619b0e472b763e7a72acd949e17620f69839543c3852c83e5c3b1cbdcfcfe0e3507a4fecfaf3f27118b6738ae8e33801cb1a2b4168f8f614dea5e673878964d6e27a1d8d8aede3bcf366400cd0155cf502cbc04234a2a418638531ef13c48917328d2bc1736e85be9cd80cf0d99b98d0baf9dd9bb3f840fd15d74788043be9f791540248b5dea621487810371995e5fff578de770699ed8de1f5190cfcd5d47320594299af29efaf204e0a411670c6f4f60652422a7e25ded5fcf26c1d83f805938c1ae578bcab6ea5c679939e5fc6593248d6b8fd55c454d2c69e8c756982c01ff76b4911ab494d90df56d7743f4d8017423a045eb4215963317164bdbb473620e8a17507a9cf26749c6141ab7b94af974db92c875ecfc4ba4421a37da4454867ea3f7d8580185eed9ae3271050d039c25f7b72e18024f91edbf3e1bba71f697c8451302b1ba97c8463b3699754fabf472ac399bd3a783b51cc945051ba1b411ea8093278606efe2b34b3992033fb773fc42cef45fb0482992d5f867416faac3912b82"
	 "eaa852935b54c1c05d2b5be854fa75ee754235ff1e84a53564070de838fbea7704fc249a98c7fd8a4d4ffdc06d5fc0ca39071fc5be83b0e37591e14ee76379f4c5ac64b21f016517ac44a12161543c43d40a8f92237c99de44ec220fdb502d82e96f01f020eef2752279a5aa3d3928a4cb594c5e145d016375e3d7a89d2bf12d4daf3886393c31615fef9e4201cc0208821e932e8b26df396e7c29f2c0b74c9f59ab79fa44b4f9c1156741e3da93df51bb23b756657187f1902f3d5c79aed88190b4a5f814ee1010b2fe82a3edd867457dbbf0598566d80261f83db810d058e785261635cfd1260c6b3b43081deedbf0b2a30d801618090d07340a6ad528b73c7d652efdc48fed161b0a0529d5d1e80fb0a63411d53e75e9ea9873d25a3bcb243faa406293f53a21b37e80023a302682943a30c8f1a5804a3700fb92092677602c39235246f359503cb79d2e084cccd2b40840acc7ac7b18b4e1a665e3833f5b4aefb40f0b36b70dd6b125ac9999d113fed15e5cdcb6ea6043036df3dec7f5638379971758e50f1453af5e48ecddf1d46e575cd2cde1b2091c1797df41f152fa77621f69169d42398312155caa88850800f9a8792c364021463467248e385bf45cd40c7869efcd6e9a24152bcfc8370ae901c7757a19627573a8832e5ea62c344fcd60230a3915561b6fd957750af61ced54ca1ff1a8edfe5ebbad51a79777ebd4e66c63a248687220e66d923c746f56f009f9d3f1f186d987c057af87f7a70a213c9c6eb93867983c3191ee956c8991275c5"
	 "5b07b2ef0eccb8b0287414a154afaca67f218ca43924fffe6e6161690756e3d6a19a29ca972987f603727397e5f4fa19d0c3f1e74f026d35c028bb81450c7b5493a7d837e83504ae7369a49b2354c6c6219c79ad8cf9f5bda3765541d9691b84d19cf1fb9534f859b58257e80a7548c12ca2c0fa34b8b6248b30213be0eb60de5bd04621c163e4ab00d80adec931ee00288fb98e5eaa8f6ec83af863b8a3634f955b54aff779725479d80f2fa51d25e721b159a3dd814db70836a32b3a4e55c4def271a1918805f31fd3af464c01006560b36e1ce0a745d3bb121710083101d1ee469b971400d49483b6c4d858cee24614786f227f320fe6105d61fa8cf21136e9160770167e1b7451a3d9171f56bc436f097d73dd4c21c245efd72b63fe21d1600213ab4f2250e6c5a16cfd3823de93c9c56ced668faddb77d60f4d4d9a9a3b3cb9de0eb5694410fb760b7421cbf6e40ca4e8bfd4577fc3528e0162ea4c9aef069b3e4f199120a10209a6acb1eb6e39fbb23896860eb1366c6eef023c2bd63edcf73aac6094d25cf3c1cb0caf82b1010503fc8e09bc537e8e690f8bbc0ef492f848f77442cbf28bdb42aa8932109ccefbd2ad6563fd3d315cb79a0a5f04772105e8564e01c1e22f1c2ab98813979da0a08ee8812acc1c18097b8f1fd95424ec0d1b63a85e84257d382400c5f44f570382ae8128fc0935a5f7f518ae3808b79ae7aed4990edd9257ccc74dd19adcde363d4c7e5a4594e3d3ce88d308cbb48fe26edad968cd54cb715e460c7b421f6debe9c70"
	 "3bd684a52b6b9571a7cde4568d7656e9bbfc5559d2c60e11054cba9eb54120bdf13c4c5103fc777033014404d6b4a65ea0a716f76a1433ecb904e9ac28b0bb8ab5c5b0216f62c18aa29b685cbe1c9172d51bdef81e7ead1ebb5d6c7cb078fd32cd63c72b163d2848de4c6dd59b35e853d6ec578b681af969941c16692c9010576f6f3777a24e87084c4b78a8502d083c137237a60705080aa90b2441e2f01ef9eef5b0f2b25b2b745136cb143405fe5c7ca013f88392428868bd9f06bbe41872c4cb1f98b16d74d064e66b0c435b52913b8153d47f52fd95ee73ab1f25f1533febb72e9dbf65d11a7568a17d2e8ea2616019297846551c6a3248b0a23e91ac1f38b21878a28f828e8aeb19893478aa2ff2f16833d1b69fbffe68b569afdd1980cdf6d8d4ff52d9e2708568db1a1b50847c8310e4d85dc73b59ee31a63bc894712f2d2214973c2741f4db4f3ca9a337e1f6c4ed3858370626b62e975a85e94b498f8c3c2073e6d6fbedb40e8a356e6d6c77c2b5e13ee52fafab4c8d369ce17a5c40deb98c98b60f433889e092d7da5e7e991b73c15127364d70a879b16ae774d65834fd0029c3a1239143b6398bb19ecda0328f39f39ade7a090b2c5c4e75e4922c50f858195c7fad64e4305d04dea5b85d4dd5a52ac4e60681c2337d3a2eb0b47745563f69352e1c17b08a3625f7ba530dc5a393238b6a2b92bebe6b94966537763ef66179b5c622ac068acfaf796ed4f4214d7fbb36eba5c9216cd5ee1d42132c459042063c71a1323eaacca0a94dc119145"
	 "cef90f744d16226d7168dc9abf46551dbe25ce179e85bd44cf15374ee498f3f3f8fb5800c6cbfc427a834e3f7b3b6b6c7333c5ed46eb2a0c93e4eaaa6f95072221d7cc27d36ad53fd5fee1e65d91e37957a9d34901602d5f49799db3cb4e47e2c5bcfe36008ff0fbf166d9e541504aeed187251b80cc72804687f58b646ca3893e8c9e4340c9580a2008d268e07f7a0705bf062c6b1ebb3a62a4c961ad2f65ec9d44c67ad3a39117d2427d9c3d067df7c089bbc905b319b30d61d099265de1ff42a97540bd08a1ec79a4cef4f692bbe54ca6f95d6ecb82d3ad2316d6cfaf9a66a8b5e5f00847b55509cdd344ccc3fc640da87be6cd4ad8ab3e510b31831d3151b2aea6675c97767076360bcfe1b317c3786dca2e4b3e90818064abb319cca7bae051390063bc6a0a0a133187a60a6eb82162a5061fba5fe17f157e9e589ad83d2f1760f4055879445b0934c954622476c29c9c577c053c723786c8d25829db7a896c66eec594a6b798ed278a824550795b0904e154fc06ce8783a773a8919b624dab70f92000b832475b77db27d0b5bbc5578765adaeac6f61166094fe11603f37a41fa047156f2e57d80a47d110901d96e33b5247a587552e37b7a0712cec420a5680ee8e5550ce5d0996b235b8898d67126415184bc9a0ec172d9f78f595182400c010d905fa73b5a6fef2f722b7f9dc51b9d21d85ec554c9f32612fcdd89577c47b3cb5203132e76ed5a39af7e9cfa2c92369464e14f8333fc29fe7a662b9373011f0d4627c9ba7b0ab0c050d0e67c625c"
	 "dc83a0e244dcfc7f5b58ceb0d1ca2f16349ad8b16a48dbbd63da41eb5d0732a13ce5a7ee7c9088739eec6d63e0a410fb53f83cc75915c0b6353a75fd2d219986ee35bd3991161fd054f0d39c2c9da696ec2968e801cfe726cd512ddcb6cc28af65b1f8e542d1ad6a6d76dd1582dda6af4f6c9363ad7117e0ea0102cffc1ba0d94dd8abdb5ac37ef9b444387bfac2b811479086e550ce3452f77461febec72ce35d06ec70b94779b794dab1a3fba727f364bd0a65e7255da20d77ac6b85ffee926a1c3c635366a4d5c8233b798e565752103c66d5e7f18f315f7fe2641dec5944e51e373f19fbe1b34dd00f4604a4f741a5d4a8c720bf4e51511fb3316951ea63c3129c4f6242a9014a78a050e633ea5bf85960fe340c54043d9bffb969f8abe458a8c9dd02e9416e0f3504a5bdbf6cd0b4013b4b548bbe59a23149a24296e0c326d69affa61a878baff7525bea12a4bacaee6c216de31e22e218a3bffc996eb7a3b8570caa06193b56452ab7f3430c758c3b447db98c7a1faeafffa497d938d9b952e3ab3f6774333a02742375e7e1dc39cee15313d69e8cad1a251274ecf48f273cb79c58aac657adc8d77f7cd1755ad9a2fd43b69cad9d2f8bd77695dac3c43d2469e4ab34e26c7debaf33eb2ca6cb7fd0a963a37b7dfd5304b9d5f0bc1ae0940bb40375001e9920d4956f4011f4f1263c3b7cb38afa1d8f7c8c188bd226ac3e23867f3989d76a402a9476756e03c6c3bc4e3ce78095125ee11e7b47347bab7a638b0088a3b18f23abae9ab2f94650a30e2"
	 "9abdbba8ae9d9d03cf5b12ab23f5a6464547bb7078b91f533ea06541941483359a8562e709608e0c5d1da2c7206c5af49be0df87a3244903293bbcc121fd2e20ff909a90ed836f1822ee2b40530084f02bd9c42b350a4703851d197d9c465485112f1bbb21aff46daef510159a1f354e5fb7b11508a3ffe12577b40d3bc16631f8a79191745fe828303cbe5b6d9578cd80f736971e1f108f02039e0bbcc12b42e8860cea15cc18505c3e4242ef481930f3e2c4b64ccedb5b4d9837461efc7c48f8b1a6dae1041e696b99fd8c9108ac1fa9d975b4d5a740c4e5bab92004b7c91cb64e80a67aff2596c919b73d88943538e0996a775b88857187e9f97828f8661f89252cd0c5577b27151b5b0021f17937a9abbfd8ac3946fec79a4063af00802d54eb08461f951cdbcec92f593eeba457f381a7a98f313ba28d21d2574fc751449e1c3b497e09b90f8e1840e7a56159915d98b36647dcc15e1b335102074741f1dba46f0df9e7114ca29d02a7e4581fc45c48e6b31cb291760a05774fdfdc0448abe313ca496bd2d1f011f4706072d69eb0207b0289f5dbe4d1f73355b206ab3d5c777d1d9dd65281a0dcdf598569109e8fc3b56af94e4340929457d2c45d9a9bbc37741dc031136a11955a465e0baea8c11c06ae9321dedadc498570efc3191e67354f0cae6a763e84aaf74597dc1d329c81231546df2fd965d2ce0fa2026e0ca896d48bf8cff97e9e1fc5e035a13a1dce07810a9e87c21988d7e9bf19dd68379f346d232f83d776c36791ed1ede88f8bdc1b"
	 "62e3e7857fddb802ef7771be6a2428b7bb7e419cd95042d7de60359365efec7397b4d7fd32a4d7e8b924930606e7adc49333809812635939f79a20eae6066fc494ad27aa5be989663ed12f9f1c82d092b7a4af546f6dd33ab862fe21cc45c2c7c58842360070e206ac341c26ef2f92cc7629d873a219ea1177ac6354e7192f4c3f3aedb580c322e1644c92b9882a96addd01a35371c07b6cd3d7e4e38d089559ee41bdaeaf81650dc263a69fffa6d2713d3a8ffcadde7601cd2a87c23187463d3f3305a36ea01743d2cd846cc5ac96c89241c86b3c38ab97f1ab7b9685e68260fc116b7d02db8cff929b871dc02379d203aea4160c6302a7bad3379ce2b77effb3f9eb37d7826181ac8f606e67026fac0f43e39c72a04a6278f89d16a6c14c6d6e3dab80e9089a83c7a370726fffd0a2e6a9a6a950fad60982eb28b638ebf2315932911b91e465f076e97aacad4c6e19ec46a8ba9e7a19fca03b7796cd6d8efe6d2fbbb96b3fd3f85d4622fef029819efb34abc28143faf10ba4879fa69d493908649f03853ea84bf7d5bb21c6c541edf0c0aa96347b4102cde3c27a58ba0788ac02cdba243a3f52e0ce4d682d41d432e632635cdce5be1542b6b6a8708e144a6acf80ab3ff5842ca2db90e9d75401cfc99746a0919ed81983d2171b4093b1b07e5e5c45992f657c892e91c16cc6017a66af6466ade21f4b378a6fea6a8e4bf000ee986bbc0a170467548e7f6e797381ee89fc431f7aa562110555dfa5c275523c202744541d51701d70a8f3006ddbdfa5f72"
	 "9563bc0234d0b2759efb747633221706cfe73d47743ce6e6077943ef6d0801729e1301ff9bbf37f50667909f1cdc70f95040c841106ce566de5dded0fa485ea539978a88ca8618e566e9da4f2e215d544ee62accbe75dc17ea26962d78bcad516e6bff3152642e346444db494a909478bf6d80aec53f3ffb3311c6283711eb96fdbdd8e6d94c71cbfb9d7ddc7f092df5092199dfd822b98e21239bb8dd17f0c101909bd38d309bb5456232f5a1b731990a4cce847394fc40b859a8d89c7c02c388e7d6ad42bcf4818de33d696ed6d6ace4c23d51fc9d7d82d0602dbea094aa2db51d9aa8ef5c1f4803e40f6f5fae44da3c3c6ce9b1003d95300871353762062d1ad49a31cae73d569bf07d147a0c8d212e60b1be486df08bc353a2e3ca7337b83e3db43be03147114c229fd32fc2eea5f64d5d5d9848709ad7335dab3909c1232d93e76eac218e7e0497ad5b7b1ca8d9ad5447879b20dd370398eb8ce4bc6805064ccdaa6d8ed1e98e259b7654a75848705dbf2c3804b455a9e3dd2890f8d74f0e968dd050ee81af2f98fdfbe831c16dae6589b9b2a16965713b8fa52e5d2d4df504411ad9c14929e560a5f7e74e98d72f71223a5eee41a40d85c177183c510881950bebd3f0ac907fbc5a4efe70a60da6bdfb6870d7fcefe04fdfffd1492c5033ec79b8de002c41895ea6e84393db391b9692983c84148928ba0fae6b2ee3aed2289a9e053d47340b5faa4870fa632c1b81c516a58a049728f941f57bc34ad53c236d33dc2ab6a196e896968d0a2bf651889"
	 "825b8f358ef4874b0e75e39331e513c506b29a61495e78722bb25475ec2ddcda0816ff634062a54721c9fb425ff286336e7036928cfac29216dd0eacd3e5328b6979f831dccf403e87ccfc4346f5743d972d5047f6055bd86c98b8fb720a3cc3f459750ddb870a845c1ff4bc3499b1c92b6e591eca7e94f1f8d2fa3c57fc97b573a738f7f55e3b6cc975a813ffb7f897930b8de8382c5883ebffba463ce72b0c50c721db403cef01d5be035730ac3c6f6a3f78681218656f397966753c04507e08a09f7176c3e37de40b9c7faaef1b675fd083c9cced4261dbd4a289f6aa0ba04964e1a6d328ef05786933d67d6da009aaac7d4a8ca31df5a15e3874eb9b288edf7d794e1abdf9e411c5bb87f7fb27f76bd62968bba4d53844e76487818ddd38620854debdced8930ead6b46f3bce6009683d3ffedfff0be83cd8727bbcbf428c761b79a3c06a7c2de7b99394030b51eeb954cfa3fa307a37881a8dcbcedf9549e2600b72f3665946d14071d9d22894020346466bfd2062e092f21e38e920609df77e3b8ec024334c9708a415d3408e22645f06cd6d805e8da2f4005000aed542aa995816bbbf32597d9025daea32fd07733e080188d6c5c7af4ce8b7bb25d7c""50e9f3cec80e86a8f9f6d4e78a40ee20fc3c83bbbd07020f0092cdac8ffc2d52c24166d78da8ec32ebc49f815264c5ab29ab84f3b44ba75c06b80aba2966a617830efb08fd3fdda831fedeb67b7d593c661538d422e1a9fe378acf51b0f2a07f34d84624e0b90af172e5976a237a7dea10f"
	 "a7cbfd3203d1b4985a1af6c2d2300136226b2edf519fdd2b7b5e3fb5b0c70f2e3160305fe9dd0c09b98d522666e5100532f516bfe24d12d46b5decb4d4cbdd5fe9cd647006c1c7eba14a56262fa7a3b7b6d7b22032c1d444fe023d66b7f51004c6176f4c198a2998beab66ca70e1343187ae697e9fbfa6ca6443d617552e6b7bb73c59613ce0a7cab58545bb40636f54ccdf89c507098680f4486f821b2fb2c7baa182686b0b6f893fc9575df701196b14255b547b925387cacd5f4a762b1d4b7f713e7aebe4f75ed648b8666e60a4f8d92f752451d704e19aa102bb3dda418c80f3b4f395965ec36fd9474088ac213b38220df73c8159401ff87751bbe392e0aab031de59691a0a77ba2ab7cfbf4daf09fa4d7d61dc5b456dfdbf7a60eab671ed1f1a67fd58bceb34e981a2dc3c3bb8a7a14fc8443b47a123662d96b4df2c584856ba257f39749d51caa70b147d50c68d4aafe51ee195f1ccb99b7015de726b5f0e85bf37617138d2b24d1cbe985d8d1cbb40a52e4c57e20c799e2f5ffc0557be9d3e2bc5b99dde628c4dffd5c8704c78689e967bc870c0fec80c3c69a2453b052a46e142309fb21bcbdad7c6c5a67df409bfb9899ec58ff0973e1813f47ec6428e35a932c117b5dc70a8f5b1a9fa402d59fa45714b4bd79bc214d488939f997add26d13c147aa4d4239d8aa0e3c70994eb4a8debb7cf292b3ff59bc36f97a9acad107fcc556c24a309c4a15dab16a47a71f31324dcc8183fdaabe1fbd1cb3808c1c35c311ea51188759d4e1533d39a9547f"
	 "04054e2ef994c97e213669f08db02702dd8b54154e7376f256dedc67fcd3dc48f5e0be91f1f88766415d203bb4bb11c4a0f6d0888e0c98d3b8519aab741b20ced0e02a5638e40ad2ffc301318a77e57787995acea46eb8ff7edb535036c3b3781d63a02bce56499cd03ae75ba6610ef27124da36dce85ad406c82e72a0319dcd6e05dbc66523be5015036de859af45be32c664c18ad712bf09d361769be3e568d5f51c943ec2c9f74077cb9f5757de92c643a2963d69c2cc3f010908e661f3a6ce202d50d72a436319bb2337ab1babd4f2cf1bffc3de25a09dfc5cffb31c7080c5473b4ff673fdae11e64cd492a784a106beb65bfc01f9b7b97384d877d9f4440b7434240e98656703edd66279f1bd5b7cfacc8a6b511f1db9060e813f2e37a8be5de25087b0520e7729a873e125d7cba84b93cdd333e8756630d9dc9e1815832c8dba1a3c51776948b184a916ae44694664192af75a616387f47319bcd5da1d94fce857c8e76c3438ae5c7c810310058558e01b01cfb5676f1a5a5d027bcd1ec62428a82b78fdc9dfe69ae9c0301f6f2dbf1475e1cd1804d05cb04583ae62efe63a6f1d20d5c5675f4822ddb8f6f6af3d639f56839b1993dc40223341c04d829849dea53aba7d0d2a2db0a89881a2ecee4f66698aef5ebdbb3c6d65ff03cc1a00b714112f0b111e7a97ded2abde97767e0ea6e19a04f96d708d419f457022ac21715ca86305b8d5e4f45d6382c7ce8d87a8f0f2f1a18134deb9a33b334bc04697479c4f438f5e58a62a1b22b49580fd46eb4"
	 "946d07c505e9c778dc56524880e8fb565487da236bb1340d92dbe21516f40a05dc3cec3fa4a56bc93ce57e7be50ef2fb38c94790acb9702dbf2ed30d6b5cc1e0173ed4c19e2822e79e711a523ecdeb6742d90353c904876e66b30fba8975d35418f0ef3fc8e5621d8d243973addf756d1e4621618fcae42af188a22f47f0f8bd0e821c16c8ca2a15e35d855ccc5c9660ebd2fe8966e6b86326905267b80358328483d0045fc63af4edda4020ecba5853f005b9058dbb81092cc12ebb3205ade902cef207f783a3921225f3a8a108eccf02cc303b11a2a7db60c897f31480db900fb1a6e1ccd1ba0aa61214037e50d8eb1ac777fc4a467ff9b9ffcaf34fe721300067d33a25f9acd43888ba09cbd26e8b269fe84065b5c44fdf734545fe21689b838eec4a00860f654df33f87d0f115a6fc1ba4f0de641f06eb8a19d2e75aad7dddc6f00c8d598015541fc8bd22540b9bd3babbbf3e41212d35cfef1236edfa5746b733de738c60901b87bfc3a4c7d49eb16e7fbb7ab93083cab5c225f79ef03db6d490169b5ecd2791fef9045e017f9dac41dbaf841f050729c6adf789b8008a82e61c80cc4d06207dbfd6b2a9cdfb67ac26280fa9ecc298dac1878fac6188066b9d8637f772136edaa7f64fa491b0bb4775656f5f1a3135686205b8217a590c088cf448892e134a29ef4cc61bd76886663afb18ad504b204ea52ef61782ce9ba44fbf2e18e1d59302a1b69717375be70a295517b069d26e161c91ec3a1a782e38efa6ac867dbe488cfddcf8c200135b059a0"
	 "da4b4dbadda9b742b906266a879da79da144eba455fa7cc5062d326996acdddec0eba8666b0e1e6c7116a1e5f04f1e94e5d85b77b2d35deb45402a589d46734810ba3a74414eb53181f75c2f0bad61d9f4aaeb94f30a1051f5ba2b2b30f1445bfe889da81e550449d863cd5af77d49d344b63666df8206bc04686ebdaee954da5f14692bc2bf1b4b01cd6b2bfad93dcc7e5c08a5059d047f6ffe96a17c828244b234a2abf28674b15d14b735956c0a9bd438183666d6926912358edea95ac5b1b6a53784f47819a3cfd4ddb9af8e74f30e06c30e218edda9eb8207dc7cd931d6e926af59f8238225dd037b47c7a4c8af558d981a7c9a7dbae3fb66345874b27cb229f1c82b841cac0cad018e8f75d0731d5a8ea0c4d530f575de7d39d77fffde64c9d1fd87b9af3759d8a275d5a1d95f1d2d0bee007544f5c39ecf4013c80cd89821f79af3979f23dfff87d093b85b892b93bec546c5eccabf41d04c65bb571543f2312ed5e3596ec5d6bf8e57e9854164d34b48ca0ca4044a526e038332348eb801a6ff342bf25750abbcfc27e7cb5e7b026db3743b210b91d1fb688c8f16d4e40203d39272f22b5bd0f796f0fa09c90*1*b48bda800b2b3665adca330cfc990283a604b08074521335437c0ed7f2a997069c88d620b638ee988edb3f6f32be1ccd01ffb14b66b2c213d31aad92b25f66f226f2793b5e554475ce8c1a7f9541ce66c594379303ce730fd77a6591c97f5bdc400ba7e8cbd496c188c2112208778ff9699674b117631d8f385ebe45ed91dd60a"
	 "4a657ca39c11c135e426c03ce2219392f55c635c1736f31b1a7a892273b6d9e2867864606aa0244b82c8be1748123f0b8478baa9402521583f24ac86c11801fe340e64628e8840aee6a093b1bf25aa05c74d1c1dd8ec48321b34a53bf78347a59fa9ee394a60b845cfd4c2f5bc53541065f1c5a0d3953d9808b26ee51d17dc026ea97a2ffae213bb9818f3c4009480ac0d1774e6237546204339db20ab366a805ba8c34304070959a16639006ced72bc3ba6430ef7e5a10e9a969ee233efc23b2d99bd8d49c3615f0da372cb98e077829f07e112a5bf4357a3cdee0268bbee69d31fea1ac66564d4b1c7c303f9b41e2b23b3c7825d1ef93ae1ca1aed1607177bf92cdce38fc68325a652efd3791e922a196eba24e9816c52afeb1d84577b8a22125c1d90beb57cacff4b2a637061d69bf7f1f006d102ca2acb8471909689d36196ec300691ddb9369868f3fd577e463d8b74c7a8e95fe2fd2954136f9650f7301d4a91d9c41f647675d37c1663d4b5c50cfb175facf30598a9be1ecc2f33fd4ec7e1ecc7dffbb1180a5b224b4eb6d0e0af4ecad6cbcb2a26cb3365a723caa2eacf9404083a427d5e7e62e967875e53a8eaf4f5873627717ce802b6b66d627f3390b50c0c950dac739ab46fad66920de3fb8edb0ad0a3c93e7b3beeb90a26a1553aecf4d1f3b17b7f852cf5441bd626012ca14d8e4aa2c43ef6a272f9f6990672b2ead99d839617069117aa10f840c379fc62de5ebf5c82ed59a5a1f76b0fec724ea809411709d88fd2f986c35edf9a562e3fd"
	 "bb13577e2ac78bb854768ab38850daf931c1b8cc3e6f3c244fb339d288348f88f792954e90b68d664b7f941b634aec4b2d54995ba08b999d32d007e85e7e0df4dc6022b0d6d7a23ac5bcbfb2dd6cdc300fd0e4c9b4403a53a67a1c8979774833ba4b8f338b1932424b8654e02ff039967bb43c3f0661bf22f638a4caef57d50acce63e472f1316fdb93e75218d630d958c1aef855a9a7bc54122a26ff94d78e74d48aff82a485f584b8acbea147666712d35a7167dc5f92ef4059e42c28ba66fbdccaafe71efc630b8ce7fd840bd2802c2d69a4b09a11cf17c9321d9ccfb1623bfaa89786df732b405e2cf118611e9ff153dd2db2df1953fdd888f023e74e23f3a5595b81456b6ffb33e91d65f08fc8eab545412b18be47d14ab77827073286a735187bed1b12fbed879969f7d06c53041a6bd79bf6c5260342480cdb50cb617c2b4111da501ea98f368320094c5353a36df520824ec52dd15e818bec43d80b537c0d809845645429ea4f7635528cb7b8149924053a76d3c05b0c31e5970eaa014708c64c902be5272513111a73e682ed9f473c87b964a4957934424bf957d1e86c6c90a967a8643eec2b65f08d4c91252cb9663a4e5aa4ad9180166ac633c0e5f5170656373489126e6be09e9e8bd6f226f0833bd392884dfce749d68ad51b1f0e0ef5fc5a8876e54558e191abcfc4632409547a8a5c46c2b546db07ba324b4d327ebe86f87dac27b64d6e0c8250019c1114a4f8fa39523dc3f5d597aa33af245ecca15ea8cbef7604eca5ed804ac4f57c12"
	 "6e335763925b88128b7289566270a5d7d1602481647f74d71bc1eafd0913851bcf07047dfef51b41fc02215d136885e647001f9f47546e9ea6ba0beab1d8a276cf9b85d780c05d4031f55d35d54c56f7fceeae9d62c58e7e928e591c2d6b1d14391f829f3e30bda6132bc513227cfad357be2c6f045bad7be72d01ceccd059327a72ce044edd534a5ddf71831bf07ebe84806feb621a5b8d71f4a608878e5e5daf3f8b4b3eda75f74f03d1ae5aebd029f037f66253f542aa06cd6c29ac5ed27ecdc7641fb6d54c98e71491772944303d3b6be683ac44b7bda5d49209133ff564cee31912b8e024cf628e0719522b11eff2e32874818f9a0ebde427657558a72943d6eb25c4b9d523336f37453af157035a3bc5ffd13847a928450d4e01f2ce7ca51d456939363c3e5a69b0d25311682c7b266cf86d12b63dcd322be77594c7f929a77467566a8d86a7d2b583b95f76626244738251fa762e0b2825c7668d6dde8ac5579c1a06318e5c5a6b2b1bc93bce6cd4853c50b6662482549290b15500722e3d6772c7541e3c864291dcbed84496dcc9ff4dddc974aa8b17b7ccea56c856f24ee2277a391c3c0c2c5584111ed24fe64e478e3c4d22380b8183222570fa3c70d29230aa21fd21808baacfd41e2430fed7c3316235e6b4c2c3331ee36d9e5c94ddbd73b351897cab7ede8a7c417c753d8023cf46694acbc9aa6ca556da7de108005330704cf54b1ec7bf7df02e36cd736237316b3523bca0a53a2472e68d30d95b1eb49282b27530bc69cd154b7a4dce75d"
	 "a3efc65c12ce45de7a63632d340fc61a1789129df1554813a15c9a6ad101c07363ba8d967b70ae1767f8927440678bab989dbe994922779c3c277055a35bf12d6909caba8a4b6bec7f49dd32426d858e53164c8db77bd1b9321b31e6c1ad1e92596bec4ad39d5b6944c7585a5ad0c6f83f64727a7f6397f784d865ba3b9c85343f3a2828a0e71d75f19036ea0f17e265750d6a01513be2bee0bd0a837996971b87305dafda12679bc118a1df188888396e10074254e4aeecb6801e00e8f3ade2889b65aba9e29d2d146001740116c893df1899175dbbf88ec175216df3d93a88fb6957adf64a3849e26194edb91188c0373fdf9be85a520c173817ccac3e4e9c88ce0bd9448be3f6cf3eb92b9337ecf2e63db5887e1113ee31529c373e83ec02012ddaa8812fa5c6b8be8febe29d0c286fe03832aee79018fdbaedd8bec03345c05faa1231ad148bf4531679738a537ec490bdcf78a0d9dd13e6988e360273c388b91006a66176c93caf3594cb098d5f4287a37d79b636eb566eaeb73ef76a4a480fad73caad3378d17a9395bf71c6c43f643b04b4f1773939329470e51053467b67ed8ac0807b8806d26d16f6f4fc15b3f3cc197d24ea26418cf970a5e7009bd871aff96be823fd80efe1adcaa882c168692b53bdb47effc666a1768d04d0d8bf199d36604e82b72fcce53e86d063c347aeecc79a846f8e12cdec679b857f85a75fe59a1338a411950459443b3fec6511dcc78d5bb6dc60accd6013400c0ef71f19d7713b37777a75e96d0d341d416c9cd94"
	 "7e3c442f6ddb31daec66bd96ca31b01d2dfb99d312a651ba5ec1765354de39d7aa4bb096ce7edbd93829d8ee2b7e3ff364f5d87f653a541f033db6c3266a03046f8612ad8d56a1c78912c9774c86a8d7e2eaa7f3bb1033470789ac2c32bd3c2ba1269bb01b176b167688f8fbe1f6094c3e2736bdc1cb1733364011681be98047cdad7d998241e121e6508cfd665c42b30f22bc442f940b5c7d93659f59abcb17aab1f28a02d0b59239f148211c525dd209cb932c54f24fa8a9541f0eab28b4c8df80845058e71e5447959bfc7f7d28e15542523410bc162f566875ed6d9d4fba519000b8c5d90f894f2bc74dc8307e26d4e0a9b418487d7470fbd64e97e660a3038a10a26a80e7cca09a3280ce3c87d07befd6f65127096d6075a18f30906828cee1f8b968dd3247210041078cf6d28f05977e5c172a9ecd83167873881e0ffcc56615ad0d64b0189ed8d559e43cccb1e2f8805df7156cb11f5df9dfbc067fce9fb3ee3230e28edfcf98741b9883f9f0f42913cc2be1036a0590107c69a9fadd4c9fc39df872f0db664ea7172fd72e0ad756be95417487d0c2bb38061c52124dcb2545f15a5bfd39d950b5878a067945733d8b1dc37cb85dd9393c98b0751c83d8e848fd1bd3ad243f6a8af7a8cb8cda7e1dc05324fa3932423fea0428131646534e74398f1604146da26a615045ee49ae2df3c8fcd16da64672845a946de4c26c1417c534a2b62a408a8c30c2e4f73ee44571259b628249c9e3f65e7b8d22002a170e7e53dc7c4cdc0073491db2cd6de20cd"
	 "df07501ff08378ac1cfe3ef479491f3fc475f8aa1fb188706c264e276da3e0399e2bc17cffd6ad0ff94d2d3b9a3b46e8c1472c41fc1c002daa76634f94b3bdf8560cb3241352c6f1be21fee70cd54a1d96e31d71ef99589b93e7ca8d026abcb4a4fbfc8c0f57d59a6d9e760f02fd0a569702da7f59da495c2dd7f92d60fb3220cd7932a032d40ed29deaa5fe971128c6503eb9d1029a23ed6dc4fd5e8c5cf0347841424d60a5a07a9781d08c85222cf7241d199609762488332a6eafbc08cec42c876da9bd3fa287bca12f71b6e33c4453afb970b425a45b9baa9aa69ebb3907e06e6610f100b00c86752b2c106c2e0b71963f1933d315ceef89132c7744149db0c28f62b3d7b43d570d1f5c40bf4b7470b3b8de30b0d756b8326542743f2fa5cf3eff226b6a658ecbe44dc9a0e59f073f999d8c3340ba30ecff6f2fa4f3815f0d4c665b5109ce8984971e5cbec806888c2acdf73d2a330de9e5133787aa4950d08759f4cfcb55ec8efb43d421cf3a9f601a096677eb95f61e352a9adae7c0b971fb455f170c7ed95329b699d6e93f024786507e2e0acbeffb452c26d8c041cb88316d09a08af54ec48451f9bb685a23910e97ac82bb41f19f6b42fa10cfb75f9fa8edd61653c14a27b51544e3fb28009aab76d060135df2d097fd4c2f2e63dba1192c648215fdd1dace4824d71e038e23184ede7f61baefd747aed93b9807d0b3b7b4f7cb9eb171d1ba241b19cf1c74781eaaaca99a458253777522dedcf3d1db6bd4eec4459e59ad635904201b5d91c77bb"
	 "b6e91f00f5a6f29794b35afde3dcd850f08ac5da097549ded05159567e9f7a023e08e49253766c0e151852714987201e90df675368ee638a947b7e6dc20bedf60656971170afe2d453662685dc1ceef8436ca8071680d0346239b41a6825839e9d5af12f9574d51b4672c5fa7f84bac497c8ba5fad2c10fbffe5ee713090b903d7723cd28c1b189a47c6a9fe9a88d0881dd60d1970c6e8a6d812bbd089c10841e5ced1417bef41f400118fa990d157bca93267d407989de017bd48f0231d43b9487526072e2755461274b3f5bf27847dda36c652a2b1fdd3815fd4ab93863426b31ecd1e6a9094dd2ed0190f8138e650dd2174fcc6b6ab1b8b91cc8020f2dcbb14855e7dd0bc1b5a01f55f81c0476daf1684cc4e72a68327120730ae92c45ab4e447c4ee900d61f79681667eec61343e4eebdd65c5b38a1ba5e3478f4d2f59d184ec39aca445a0f6edaa6840f04bfc19acf23db4507609cbdb44514b36aa5ef4ffe46577b711d1028970916eae919f1b4913d5894a24117cd7cc1aa8965840865554ce663af470455c0f756c795fb29eec04b727b12f7f3796f572ca2ec1e8771a88f68999e16b2acb235a7d9146f85f2be5a034babc3bdde750eb7895396d4777c144aee517a07310dcc8c9ce0ead93abb7f1eb4e34ed5036361d682c97eac1ad7c8158035e40a713f0f2e6f6e677d4b11ecc97e101a5b48420435dd218846ae622b416faeba7e0003bbbece71c2aa046715173b408c8ab2888b0b5dc4c34683f83ba9a83795f86122e6d80597d3a952a44f"
	 "5a1edb6f294a0ceebefc3cb54db814cf91fe450ed4c71d0b4091a1fc7474", "goodjob"},
	{"$dmg$2*20*2ade7391bd439ecf905265f0277e9bd55e5c1a3b*32*52ca8f338cc9fbe2000000000000000000000000000000000000000000000000*64*1181ee325254ae8bdeaca3dcf7949adcd850f6a41f90427e947d79d0e3fa1d44db4408c23cd2a197610e650cb2dbf782cd3d1d6ab0686eeb929ddc2bbf3121ec*24418*4608*f125cfafc707bd1564dbf9e6e12e7c06886c4c63ec99b8cca6c1e1a4767c458b0b574499db3c3f45720722cacddde613d04c81b81416b2918e22975011183cea6e1b172f68349230a742b4acb986d7e71c7097c27326bcdbf3ebf511e20c73146fd3b27d21497c826a4d066681ee420bf8c1f5a7dec266688e73dead6d25f1e6dc3d6b9f557de6cd5f73e74593058b7269b77bde719f9e2f46c7372505c2a2aa1b12331d99165e05cee3d961dfae561892c75ad76489ed432a6ed7b78444ed3bb3b6ce19aa6b956ab2ed4af047f21ccc418cac29269b9d1e98f4b670381bf31b2fdffdfb958ad265b7f016c09cfccd58c508c1e283f17d3f5e2b0bf0e4d625f9190ec66101932ee8c55ecad4848be10f8afbeb36d22a02a8b272dd45a38bde621c8d6e1520913de5aaa3a1f17104479a4c085664539fdbc3708611b32241886d4923b1444196264535f54df2503314dcc28e972c2c8333b4d22e5e8c719d5546f67e2152febb9dadb9a825675177ded037999ec1247e45a71a26accad0b780e72d51f20592195deb6d97bce322e202e4ba001e14ca4e8702222259740db687f53425b44b09b9a360a8045b0cc1306e1"
	 "a18ad7ad753da6d696003f38a7f9dbac87ead2c7aa82a995dc05d21fc7a2f69e6114ee0a82fce8c0add73077a199193514f130173175e39a8193fda104f39db09d9d7fc70a15eedc044cedd32e474d47dc79fc43d02352126d3d6f72712707a793212f1786898cf78d9714f48e3c54a59f7d928062f1355cdc80757ec61a1b5b5bb91245569296762aa558e19f5632c5fb04e02b25a4fddb81af95f46d041206c86d75f6044e6043baed351ef4d8f8a0d97e008523b51dd363afe702bc4f9c925fd7550d14e4bd3c6111d101d6e4c5067a11d834c0e6cb44bfb7d656e05eb7e8ab2146c386ef9ff2a3b2c3f2a8b4308e8663acf15f292e77adc2b5f558d599af3488756c9a9b6200d82084620f016508d0773117cff469c09e91e875e7743a3e94efa49410ed8f3dfe2158c6ada5927eb31c2149dfed26cb34d565172aca5ee5549e1955378f21b109caebd643d51d8fbbf3a818ffca853611e9c0bb4407d48479a77b5966ebdf3f2848b0cde021d88dfcd4adbfb5c1415ac2313e630ec82408ee3897e4b3ff940e8831a4e2554e8e61b466f43d8941c7b6b2215c2f6b51aaf593041f37ada9770da5e02d1b01293ab4d0ff29de659d04ee933ac31c877c756ad746e96e3c2bc65f6fa8b1c61cd9c2b400a68ef3a86e9868f0b2f7507775fa16aeb677b91aa3416f9bdaea9b9e134ae3224fd076c3a327f5545db301e6ea8e39a4099f552004c55229b9fe2c4e014f51ba7f1f8a4ebbb6a1cf5df15b30ae0c80b8c36bc3732d8ce521b61c260c86c696f1850"
	 "7399c5d2e25ea7088700d6ee76aae7980fde0c97c7c40a6077d4f9c76b872b0028bb90c4ed7f30410b8757dbf53e1a08cd53d6f140e44cffbfdd8dda41849613346865c09bafc5f3ad034d609198e2d438bddc0cdaebf77102c03e859d751b5583c9b7359c78935fa15e9a2ce615b4f923d9f07786d7a4096130412307a8b9294e3a1cbbea5c5266ecee581d54e60a352181c7489985691f280babcbe5915fcbd94043cb2c5cc7b182ba9b2f7c8cd45ac733a7d2a25f6d4bc0f1602694444f8d6c9894b75700232c621d54190f64d97e99791a92dce8ffb9d0418c656fe29c84cbb469f24146371ce8147c205c418bb7e67340b08b8cf64f416319572fb404f667e9fa4c0f122ce66592c6953cad3ce88ddac1ace8779dce3936669d1e147114c32476d48bbf492f42359e8c322854508f549b63329ec7dc9528e41b1c4c8dcd37f6fb0490768f96450bde5ddad2cfd1f64196201474dd8c190d5ea30aff763e33f608f100a87cc316add7d5f75b6dc91d99d38b49e7b75a4eecb65beb3c4248f0287a770f48738953bcf825811a98bda76d84882a1d178aa99a23936e37797b9afddb7405ceecba3d9a67442eee7b7793307ba8c6b6276c58662dad92ebabd7d828ef456c495227636ba35b350d6a6e641c634e39a196fe67c860f444b4777167e5a0ab6861639da14871e3701835f5810bb8fa8fe1985b9de6063ea87268e9085693f326be3a7c8a072fa610e04b33b9c6e02e0a605dc2129efdfcc282f17bf26c1efb421158b83ef0782bdc961fdefbfb5"
	 "be57ee37c2385e08b30b034b03c2bb121a157362d7519efc39974b2d77f274e5266ae2039c6ca6bcd4b6dd6c649881744fe5b457846663009b811f71d4b596a843d807fcde46e062934ad448a62bd5d8c4e14fbff01fded539629151bb58d1195214d45e78e9227a74633f1d8eb052057d51cce0fe786668b3b25b38910c6bdd44615b178848bd7cb09ef24a44af20802c07c63cd3e3acfd7bbd602a7c4dc32aaefda886d582e1b556ebd3d20c6b4901faae92156b0a15d67b327087b4d2a3ae943fa3758b3676d5eac69e79b3391eef4e4872bdce4cfeefd1f3e34b4fd6235763cedfaaff69d375036bfd7df2c286022f38d63a6c9d9aacff6d8a97d58b26a50c4f5d306fabd001b6dcfad05ae03290768e7bfb14c057d6753088faa4f19b77bd4ce81ae3cfd03b897bbd291c0ad73d0617ae50072889a6d2300f2245194a2c559c29cd5fb90edef893ff203adc647ee86a1a56c2c48e1e871c3e8b4492e0743127d7408167c88e8d1cee6e268eabdeb0de9a6be25d0983ed3adb9204720266b77a630522fbf70fdaf1280906de0b30b81866a25639c68063a4a608650fc9fbd702cb2e3638b5ad61f4b3c71be3787f28c95cdfe57c26edc98411d0cd6a802cc8fd565a1c4397c4218e0a26c7a537074bc1b89bd802c091e154de879529545499190bdba94b77c257625fad282963553ed49f8ea1c111784e337e82a905d976d8988cc42931339696cec27f5922272506aab9943d8170ed0e1d3f000c1d3091a323dd722d55d23b7df5e4a266ac553ef2b26"
	 "f5f8b5e1a76a2f0e8984b0341e51da2e4463973d86f4725563f5f4c4e6180e8221b1782f7d4537b3d9ca0f39ba7835b9688b57995e5d6c42dc9848c274fc2c736f39d6ded0e5ab66fb53695308823aaf05ac05ee0b52d301294b8b00e1c4864e5ce2894d8206c5c47ed776f9cd8c5420501f921528f1f938601acd45c7330232f0017812016c384b3eb778867f0a4b107ba2ac9d03e6473e4e2a3e4fbc7509312db9b786329eee4e021fb2d6bc8f287e2515b5ae339e1f4cd45e388eec77bf81f4e4614f73e305817a68a44d236cc4dfc4f787d7bb37bb8f34f05fdd25608ca864d9e9f8c827db01d2e89f7a7837497bc43adf5d68594fac53ce4ef20b6887bca28e5f1168463915678608af9adfa0870cbea6bbc0366b1a311acea3ea58cc11fd67884c91f38332077b8ffa9fc63ba8ba087d5dda8a92d6637ab74a87fe1de8f4eb822c60f18aaaf61047238561a151d34d8004da377a51d6c6b9167f78d8e8f8aae4e51dcbbfa4ca4568571ae839257b133c4a95b116582ec948ed1876977b7874b811696bbe646356c6207530c7bacdcbd5d107a1cbd65d0f3d2e841f1a2e9ce014b8aa4b2364f5950e09c06a71fdc277fbd51341c771e3fb6419c7fe37d093a3910771623d08874a5bef501ee588bbdb1ddc2430ac5f88436d57f47710fad95cb946d2c785b5ff196f4070b384e87f8eb34e686acce3bae4a1158ddaaff09a5f71f3e5b2ee05193613adcb5ac3214f32e8f5ce0349ffc81fedfa1670efe0f1463461766666c5e22b331e3a3b55c1cecae"
	 "76a6bdbdba506732f3aa193a9539c616820a7e7d52edd472ce490e947781283992272701ec4bcd161761148ad6f606718df3521460a51905b62fa60210f4f779a2d91310311cbdd5a93c323ac895b29b8a4e0e36b5307c3303530b610328d1d4463b51a3550c45c97533142f6d24567c47325327186633130f1d3ecdce653aa68b7b29d8c75be579eea53bca62444e13d27bcefa45c920d3e61e50f4449c0b461dc4b5c41c7d0b99665fbeb9f1130927e14b569ca2b802039a5d16ad0d9155a9c7d9c1cf5758952bbea746fb2f7810d2da654cca3d62212d96482ac3d8ca44732cc76e85c0a42aa361ddceefbb7ee2e205c93d78c8b0eea3a6b3f2e1f85143955d453383977d7332a4d4cef05c9328e8b2092b283b3a1a413c41c19b8b4ce0d039f97c6701849e15ef8ba2b8e32dd51d38b72043f26006b61084f1a4ccec07632ed9b7522ea612e4af7cc8609ff5465eb902b4e44534579986179bfde5bdb1bc3c1105814a2b700bc8323e4948bd55b2414bdbb79c246e25823674108aac77c22e4e12e812bd57567c36b19bbf0b172f1893fb384086e9d8660db52ae99470c7977d519ead4a5bf63de3a2f89ed268258cfe1940c95e225c1834614f438753d8129ccbedae5b55f53a09ffeaab57208b1ce8c0da4a18e0e9e42a4e075bd3d7309c082668e114766716d096c121bbafa066b942bf29499eb1eae63678459f6edc87e5325dc16c87f00e5019cc07f0c0e3f9f23218d2d344daffa81c08e1b2de4f7acfd57265e0aeef446da6ac44b596c4491a6"
	 "99e6bfc8d46152cbd045c1661ce8626846b5327d3f057fca314f584840c4bf3d3d1e897c1247b641422970bff70322e23a45f752f8742104a807eaa3e29385d9ed0c29039cd879a28aa6f6690621bcc36e658610f69df5abbb14d9ee6f205346bcfb979d7057b83f598d67770c380a4fcc57448280dc3de59d8961d497cc6ef54dacdf50c8bfa52f99651766a67e1acf03551815daeb2d681e53da0e8c6ef05d70ee2e57a9759e629e3b757bf95155eb1d274ecffcccf17576f8df11d6b673d878e7c99d7a25708c53a5074f258e2e6b263a296c846da6738576ad4d90bb79704d92976e36d23947111e30f26b187cc15d2aa69db61bec9a5e076fb509f519b90a9db056be5b4de0f2d6dad1b42c5ca2f2b6bd97c750ec9c69d2aee242b165bfdc6eaceae2918fb4524d9f93b619d560f769366995ade92f3a99adc62968d0e8e4f544bb0a562abe188c5ece18994fa515f97248a4e684857dd46360ad06eea6f25ad74b440f011cab7db9fa4ee8e385462a1a1cac027fb689150d1399d206a4c30e71dc758865330275fef5ee9157200c55d6b66fecffd0e9fe0600ec56b0d6c1f52d40ae80d781104bfe100594c72920765a4a7dadc257e4d1cfb12e65981a832c762c6e92b395d342221b03d7947d1c78dff7c957474b482d7cc917d55925552af2f78d7017b1c7473b2ceb20339e58ad48419228ee61a5f80f84cd42608de6fd2e71834fb097824bcbd41122a67804a4faa9dfba4a6d7f659af8a24ff243be6267ea089865f6474932c5deabd0037523c"
	 "26b9e59614dc09caf438b72628f1aad09bf8065d30517dc76b756083671357b1ef1c3b815d4d68710ffa0ac9d838990f8222cdf166e9edf0e48d895daec2a79aee8cf69b44499a239c1104e5cf010bc1d0be66b2d118f7cefe51bd11e5e568b6c5d49c2d569379be666ce8a9508f8ef7bf2069eedeed224814daea76030f96db258fff607ee2fb69345d602e7e67f062b191e2c3c248a6964bf426ad0b1031523faa03cfc97574b0601eb67de60583c9ed57ef613407b2e2f787572c2f9e8f22a4b8cd99a133292644f0c87cf87b56fb0d10933bc1deb1e0e4ac0d92b6fc7f1ad46e9733b6ba5b7d7c5521b13a9b01cd9a23cdf10477a5e88ef1c6abc3700370af1b8d102c074514747c1726f263beada7d32942342fa258fe6775f11966d0815095c4cd36f1780b0c7adb925e7fc9977a93c6e7934263d7f3ee942a3e3d1580e5d5cc20866ed1d592895d888013ae9b599b47f6e4a3c324faf04f5fc7288c89714d21fb4b82ae2727256cfb228a81cfe3644f970ab12c4414273ee00d523f7b5a02b5fbfa85e7def581631e899e5a0808c32b0cf9cf219a5c1f0abaceb730f1981544efb2d7963fafa8214459a9a4e678bdd0af52696688305663df8c1dc664a191fea2bddfebe5ac93ce861131f2b0eed17db43ff23d0e645965a4f577fc8f47a0388e91235f10d400920448c79f51dfc8fb240b846b3733c06a60bf57a3b41fa36101a7a90e06eb908853f2c664e83f9c7b957a8d157b34aec7b208be77cca5761580eac7d1de58f18cd90db831650e2b0"
	 "734e6d80b2a1bae773310b9977a264e787bc73b99a403a6e7778bc7808d468a756ada8b55b57fc6752c2e60fd129ea752d38bee95f8ce6214021541fd392dc5238fcd90b3302f7409ade2f313d84b4d1638902153de822fba1c1df72af04323ff105063fcd6c5d5a05b6dce15870cbef70c352a54ec336a0129f5d562fe21f0993bceb2d4935851ffb67a83872282d60e56191ac6a6ad1fd14aff73dc64bdb330a3bf19024d37f922fc56ae27ae74dcb40571f299bece7ce1b4ab4856dc545de23be4a257ae4b86713bf17233b18506841d5a6a88640a7eef8c69bf8e586c23432bdf3d1e3b7eed01bdb0c91795a27*1*4795c9725fae0bc94516f0e31856e1a55c901576da2ca259c0db1b5195ff3904723e811159b4eaf3ed824d5e37e91a593f2301bc7d57f1334dd2e09260b26e439a0b323a25ff8b7ce71e30ca4aa7a382dcb809aa6c7abef009f8225f775aa19ec9fa937827aef6ea273101daf1c0ab6e4b5dce0cf9e52a1addb119fff035d6ddc1bb3bce1a7e10cd5964c1e8555071ef7970362612cf100276fb8cae6e9c889b5fd3063972a76f998050a75ed1b8f2828178009d2b635df04f1051de409de9bb48c11fbb00f389ec62730cd9e91d9c20c533d04a24a38915397a39c15f3f87d2b030bc179fd4d0b507281f5703a1993010b11cb0917104a9a3d83f13f088679877148faded5c7eff3915a29ee938dbaff1764e99f25deb3c80415eb47805c05b54b015f5c7527396fb9cc32ecb780401e3cedbfd463b90c181b9953239716a5d3e73"
	 "84810d8ef7913f0a6e298f9eebebac97e289a2f296d0b526ee1579e7e2e7a779fe04d21d3a050fb168e1cc886cc6d308123037f69fe053ef562d21f2cc7040f085bf1f1c7959ecc2d48e492d1b6efa6cb427dd18fb834db962569821d862823c9adacb7ff86fb702171b84925501b578fc7540fedecedc848e839426c800e96dc288c6dd801c1237281e4d3412075ed30216d126c9ec7817de91d27c498e77aed53ba560db696b15245bd22c6af52fe90b7b88d6dbd69ce0dd194f571de9ffac1676a1f3dae7490006f6ace9585fc6a7535a80f23464c1fc151a376dfcb65532aabb7729865324cce373a3d8099c28eafc2bf38a10319d527690598204f7bedc606dedc4ef52fd007ae5f29ed209669d2f729afc4da63452f29f2fbeb83c7bf8b7614bd6da86a342365d10f1bc9f4e366661d19f67dcdb0f0d6ae04fcd467a403c9966a0dc2b31e9b235fd2f4a30293bd8d3f899632be0318f566d3fecdd30b2fc645fec3f8960f973e7a7729f14290c26d4f27ca3b822f879ea0672c300db832152410d12636e506d88c8220faab748550ff53719bdd46eb603dccac2add6a1f97d40e09e25da3da741b1701cf17f7c863bbbac89d40c09b39109156bb206b978650dd02d9181371cae6fe50686c2031f0dfd7311012270fbb294b2ca63c180b028dbe0964351823f64fd061c2ca536160b66efa33901bb2a481e7f5e2153a52d83adbb185d765a9c37d86d559257c315048695b5d0c46e8831632f1621162dd092fd770d6c0a6273f83691cb77ee16b58ff"
	 "44851e282513fb66dac3aa6f76629e5201237cf6cb28378495072ce551423cbdf431ad586fc4f19273005a032424f14c578be896e77f2fe8a9703ce1891293e5ad7c2ce9672392c2835a01068940cf876c435d3b1b4bd34237881a10ea4544de6ff18efc060587d276a22a46e8706cf87dbe0975bd1a7b97a6f54819e2d46585d25243aba096f3958a502b1e1d555c242c2d09d09d7d639c50ea6924b7ea38a08129bd853b9c9794966dba251830a1715d1e4ca58c0bee0d41335114f7a0469fe0772713470d74a8a9b884efc09b592b1a3bebc5abdec37aed33df93775129c162802cd219c8183574b1ca806e14996bf869cee1deb5dc4cb8b3dc67e63bc7070ed7ef9647ef6eafce3d7b704132bf18d7e80c4047244797d1204a011df628fa065faef50defccfd68c99588d55a19477dfa12622ca156dbe91601254ec7922ef04da4f7373a47d002d2f2351f00d4f4d50b2b0e2c345fb3da20616a8e901d5267e239d8b6c9d1e618a678f8170ff8d88d50c3426a74e2c7817e92603c55a7d8b736f997cd8ec7b1de060c062dc3f388ebdeeec2c6812fffc8484779a612aadc164d3350dc74c61e8b7a1417c14975211f5a4ce0c91b7f53da0674f0bb6a13170340dd7253de34f9ebfcd6e098069bc25c12397ef2dfab35a04c8418acd4a58c3a7b456662f2a90e0d59952e3938c283c61ae7f382c92a9c0baac5fdf6702d1ed0661671aaaf23579753fe563eefc4d83b381bbc468e4cb13de78e0fb7bb32cb1790d406fc1e3ea17e99f2c47d49b741a2ec7"
	 "84973e397d2b00a21a2045599e93349f9fe1d4cdec84553b0c6acea2742249ff02eb6e70fc092d1b9820738a36ba9e5705a7abfcaa347901f422ca007d1c0b2f10dfa2823778046a5387bc1f70287a0b5490b5c659ea9c4f6f8570dd84be750a32d77407ad41db0025e74c1488f616a98ddc42b7b5ed98477ce052950cbcd9007258afad731ca53e70b5d4ff9b368f0968786ce199966866cfb391371dfb6f9a493fc156c28030a22b1dce10cee2f2d310beef444e67d377c51d594c185de7b3d573a6a03c0cc6d6d1c2ad879bb141966ca751f2ed88d21b1d5120e0fba586be29faffeacf391e70bb743f91a36fdf564feb196c954ce3ca0ef914872164a103e74385489d6a2bd1771ab6987e8b93dc73b3834d20c5866d1e249158138a0ae7dfcab174434535a2b80c3e9e0e6e0141887633ff996717b9b07aea75a89f9ba0e90ac4aec0f87fdcdb4b024c8193b8bd452e4f1870adc13925f0764a66b50c280f25f26ed5527ad0265345ea0265e90213ab228e92ca610abca56d5a7625a8cd29a4f4d3948d1f4f78f5ac7ab50f68da624691d3f246c8cdf6f55461f8052ce886cd3a0ff2a4739dc08337bb0ac80afdb8bee887dc421548231bad378a7ed4bbbe1361373026b008bca48de8a1cdc5984f4867f49203e0c02dc4920d5b25a8180274f39a98fe3741c6d8c6d2bde487ede94bf7d8f56014fa5503f84c5a03c4a99fd04f4894c43d3c2b59ad4165150fb29c24d2715fcd2b671d289480a7f25cf74c4664cb85915932f95d466b991b51cb5a984"
	 "fb110a61cff8b511f623608b3be1d8c2ba685f1c48f23f53c5433d3371947dd690fd9a63c2c6a92e95f9f043a49b3bb5726d35cbf969e8dc2cb74e99821583ed5ce1799dd42fec077898c19f5484ad21322b7ca51424c7e68fd26e8350c2c2a5e089038f7f1827711d2e2d9f4cf91090d6c9616c5ace3149c4aab339d22cff432ceee7b371fc2f57ceb1e84785e49fbd67b12d574a6f7446988dc0a2d6bd0f0e825fb5d44a435403d1366f955bda7947fa40b01cdb4423a983cb09299ab66983c9a516927cc68c4873938329f9321c23d380b196b3f5b222e43f3ca0b514605095cf3644d44dad4cf13157e12e8ead95d5e4d13c0ed9c157f5df9bdf092baa470390d835848141bbdcb1aa60ca15777ed4af001e7c19b0c8907f9192694d15e47eb85fbe576958542a238e0fa54a2490e3375c41e42ada040b58705b8be2c4d3201d195807d1fbae2821a9325a32f60e3d558206bce96350b6d7d17d20345f91d5db987099840be5512cf5f35566460ec4ee1287ba3ed74c669fc1ffb2ddffc81fa7a3e7e234bf622bf453d72ee0d60358fd8f243f64aeeeff59e368c76593f2141d494034f24e92ebca5c2def22cb523de185af088671666ef531bcd1e244697527c52e9438326c0fca0370c4a69e6ce56adc61d51d3b7cc916ce43360df65f4d0504db68e019cdbb5b8da17bcfd3b91484db00623ed1c4dfc32bbe5fe9e45821af322c9e0f36273041395b6721933e4d0503809529348c20bbef1702c1737359b218f816cfb3bfc48556eae8d2ae0e96052"
	 "1261fe5720eff029a9c1a0341951247f2a35266e7dedf0d669be2a5de6b3eeccb4069317ce6b40bfda453818adf9c66bbbdd0e93f76d352cdc080ef11ffc39d7b4437f78d6501b89b47575b3040c4b7e430f9772a3b1f92de2ac2c918e28e165cf7d5133e4797e6dcca5fbe56579ca79ce47cd355bf6c389c51d02203d7c1784f175eff854fbec80fb85db5ffb899921da97ac07e911321d679e23bd11c083c1136b59ba1c2e8a5126ba32979116fa7e724f79c34e3b31130c2a04857d5a9d8f0ec5c7b75d529381163635b295eb31b429f062bfe714bb5b671f6834e76769a5d0cbd101b6f9d27354a711f85e7066e817fcbeeef9e6ed6e8c23c243335e54cd43a27c74f9256825b21ceaf2d23bdc8f79e18d8dc32011413c54eb9e78a9bfd7b97fe1d3bf73c880ed58c387a3bcd8db31d7d03f9c298b24d9d0bea71a644c8b27402c94fc3d52e68971a4d7657dc5b6b06cffdf8590e909c4215d6e9644954577179e089e3a966b2295e7da1a877eb5b51d0deae6113da8217e735b835e6ef8c0fe0711c8cbe96f4d02f16d689ee6309d3a78dd4d81dfa83d2ba62777217862b598f70b8809e35a7745523eaa182c347225b8bb05f91fd099ed303ab5ee798534f331a12abeed4fea91b75342fec2a82030667037e03a910e97e8afb8845a81dcf401c1cb7e6aa8646dba60682bbf779d2386292f5c3e97f958a48d2ec20a6da1ea5b42f8c726705a20ed2029e6ac05c1a6b9bfa746df0a259c7dd74170ae37a1965560ef20779f09a37acc10eceaf6cd055"
	 "31f19386a0cc043cc7051dbe1adb24f2911242d3a08861eae5f97be39df33f608d857063a9e5f997703ab11fe29e3a5c9ebefa4f3529fb49c1056e6eca75d3cc11b2bd8fa66908c662819bfae2ae02ca5f38a1586abda26dffcd474544180c33678dbb483dc5253b59120e83d3326195541566334f44588a644addb472b0f6ab746995be1d4caae8aae55258371fae4609a12f550145ff28a1a2b34d66af8a06e9927d6059765f22b309664c809f557e71627e0777cc9343d9c5a882aac3979929d0ed48d2591d8656159fb9adc2daa501d104f9b7361ee2b9451565ce235a04f7ceb9d4ecf081f019912147bf6f0eb19b4dcf2af20121c2be6b475395fcaaeac4d71c664e29b7918da2dc306aa6cc6b680b7bb3dc5aafae0a68dfdbd1b1860a4797996bf6af4077e1f7c6104775e5b36960641982f401d12ef8da50385fbb2e8137d2a1513e154f227bc7f8349206fa02de6557623b455136bf1f09a0acf83836af40b2578db3ccb75b8b22741e30d4e69b5afe0572656ce0fef67dd7b151c3b23207e86d3ba05fb1a63d1034b992da26f8072624cad1690d2d87a18ea9d80e6432c5b69ebbe08848b1f96bd60fa29b357f8a27aa393ea9cbe34d020e7c1067dccf0382d417d9b0fe4367737e1b51ad56cdb7604b82f31a7433f6aa92e7478e92a17ab435f03ff7f2ac7e35c41db1a4e1e4ad74a9cc00600f5abe0fcaba89cb0a1dc50b3c6a75926b9032a0f42c700f088b74b6ba4b0c97931d0db524a145c5535a086a52d3741e7af701d68009aa5df513c"
	 "fdc4f8d423cb3d954da66f650435016bc4ad0f2f0c4a00e8bd2bde44e98f4424c8247cdb3c8f11d18fea5fdcacdf05f62815e478ec4e95d1bed4d2e8fe99c23ad46fedf531713b88d81b02c47f348c8c2d2dfba17c2fab7f98518f6c3331b6d3d3c7684d43a9e6d99b0a6b19630eb5fb92c33412a386e8cd5dc85421ae1e06eadcb421c747c3e491d9ee978c14697e623fad52a92e6d686e652efaebd79f562ab6ccffcf035b47949931d6f7892627e6522aa349517061b621ec1e13efaaf79cd97ec00e64b8da52769a2513446dcce8c47a513f9414e7ab1b1b886c95cd718c472eea30f413b4c0b1591f26c8cb42c9eb27f87a9f5a97e5970df8f4466a53bd410bf2ad4f92d92682d302482fd1bee67e963f5f373813feccb9f4ff468e46972a708bf6925501defde950acc917f27da3a0257af8e2701918390e3d701f83f32f91f7be893b6ffaa7e2d78247e4ef7849f5d75102e37f4c5686ac8b73dfb1bd6207dc70054b6b54090bbb2db8446626ae54e9d08fa0b888fcf7bb6b72423c834fd5f74984a38d9da7b1820d2d6616*181818","1234567890abcdefghij1234567890abcdefghij1234567890abcdefghij1234567890abcdefghij"},
#if DEBUG
	{"$dmg$2*20*a631b96b5fcb8047cb84e3b5dab3f0a0f305eed6*32*52a7e3147d29e3a2000000000000000000000000000000000000000000000000*64*bd454b86fccfb4971cd5ae9ca8a828ba2a03f17bfdc9b4155b3089298ce82a778ed21ad311596a99a682d867adf9e5ca06074a59ad8044b505e269e13092facd*1*8192*0eb194415c5cb6a0a82867714f20147a208e651ee5514d3f4416b9fb421b3bef969df766105e472bb41b43844abbc4bfabf773108b9748808181256eda4d9f7f6397cc0ed5ced194ec0d96cf30a9277cc81e1a2385e87d0b2138625b38209e6d8ec04f36f4c2be64d966f1c39cb7979b78a6678a651415b8199d09ce720291c0420f3822372de7005f99e185c4712f3d4f0f3c1366988857ccc457664cc2f43d8562e7c8712f1eba325740bea5f0ec1be2b4596c623bfe14ca38024e7e0be394b101d373219287c8028af0ce6ffcf9e50d0d400502c821a4a7aa943d74df01e50ca660e867937842c8e643fd847e3b22a1b3779ea6edbda497cc81a311bf0375ea44dbd88f3e2b0c70205588713eb1818af205ea313a8c760af4712101ba6433cbc4f7ac290db1a7fa7ec6813e678515e652a5eb8ca7a275a7fdec478ffbb9235d73738681d1891a25df504ea484e514a6c57410484ccf90086f4ffdc61d6bee3be4aa819e9affd6be8a8ccef8289ef7191e9b159d22b5dc5fad09d12bb715466d1fb311201928034778507275717c52794b1c145181890060102dd72977b1b19a53ad98b07feb27d95cfb9911cf0a653eb6f2eae9a3cad2f2a9b26e05a3f73e357a4bd4808b8a0690ed343f1355eef156b8b241e14acd6d6b00e6f7d780c1580f2df02db34a8b368557767d06386bebf792d25ba862d2489de3e6443540929f2637ee396cb7bbdd0cd57a5597b3bf2ebc963daddce7836cd21c6a812d728faa44c127886ba79ca6998b6b669eb2ea4a11f75cda2972d8b8e9a5ea5106eaccb9a75e47a4c869513f4ef3c81769cd286fdd37155d1ff9d3deed7ae1960e95b2af6456aa87355823bc698ec0600155f361ba9bb904b7230e43d74d83da414a2e52a291a9bca5058a0fb65dd831ed4374f998b82849039bbafcd73895ec63809caf503649c56494bb9b01185c6d4bc88cde35aaab25df3e6e7327f8f77a3365b173e9a4c96f0df2dee033cc3d5b0adea30dd90f59b75a08a9ca31f73ecef48bba0c2870addcab061974d88d3ed46f4b2c22588e55f1b0413b2cf5605e0e37c2246e1394d0c2e7e3a8b412d531c012f26274cafae07ca18f65fe10dd61e54c31edfcfa61f3ae1ee3b4b4de318b5dc43849c732ebeaf86a63eddb5ec5a81aa08f95c2d97dcb46c9a25d5b4a1c37ece800164737f91aaab4ed5fd5f63de974dd51775840db0be361772199118e53b001608ae389573cf8678a41e5cd7c781e6326bbdde034982e728d1c2c3d3c3ec1a3726d24c81817fffc69353bee17e443ce55fba840f8c114e300e73742d96346093994bafa4293ea1911755dce34fffea6b4b5248be56687d5a9b84adecbd46302fea488a48e22536f999156309d11ec008dc8886ad0f3661b7e7d9ef59e89bc9787c789176d42c01a8a780d6fdf8dc151bfa4ec6b56d530a769a3365e47c333fa4930dbcb0ea2e3187c41c31587ba623a24608da90aeab55be6a014af29bfdc552c4a514b648e964e4eb5e6cd4c171edafa4c478768ffffdadab15ac55563f53c88d0bcfb5d28aa6a32af946fcc842fc4f275eb41edc36781bffb1295f49436ed96b594ebceaf41cf1149082565896fc66385dd725e518061acb904ff2064f3a2055611c45cf102335f0756272835f7e250b351e9020e22d90740658769e6c69b2ff2cd9cde4c6c8f8c6902b5d66d85a8706fecccb4ddc62801b994eaa7de38717b5fad8abd90d59b0dcf554b4ed705b680fb777eb02b67d1e0a0d52b04b896f8b71d4d2b22bc7ea99835b9dfe62597fe86ae89b72c58da87f26edec3180d0103ad5ba2586b3b7517739a1b3de0852a75473f35683e4d978245823a614e1c56ae901f6f89ac0bd44558cd3cca777a1948ef0425965dc0b6105fbf71b2354bd8f5101f150f76e6738b86842f253a29ba652e0a37269d67a877910ec7d435d18044566cceaa796c878566ff0c348a988e691fefddbe109c07f9e3b0b8b80c32165fe10f1c1ff91cd93f1ef7de5fd31df8762be797cb26851e4704f002be4ef23f79f0a081226fce49163e42f58abfc114a50f5973ca516093b8660466d750cc525a088bed3fa2f98955ceb6ecfcd94e079559a8a3af3d51816494d33cbdf8d7b91036ad0fd03a28ab98ccd60de76ffe20de4d6363f61777252e46a53af5d6d639cb2b2d78ab89b0b9ed3dcd54874b06d1c4704eedbb43069e7084b7cc5eed226cd8646af87563df3e0077738f9232d6483692aebba65a8f600ea7467718661c550efc21ce159f40d54b64f10ad6ab5ec0bd6453e7a422764494525d6bc95ff67fd0964a1b15f171127343a2a61b0fc63e93012f616b4382b29f70c954eddce6221e7fd3ef25d9271bad10ff14655ce9b62db39d4c2c5259df50c0ebef895095746bdaac2aaf294dad27985d6f220f6edf14b3e85fffa90e7463b546d32268a01afc212c87836f43caa73c5203b9a607a97a09270b1a1b2a4333f0d4c754a3260e5116cbdc9760dea1b1519a4785e398b5888b21b64ef2677bfdb6d96250439c7302136ff7c17d4e2d976d221caec7ca811f7cb73751e8437aa6fdcf68b6374d928100469a69eadc42bc1e2f1f93c8e12f875dbb1063b0e959e4ece77bbff44b49206e39a5866965b221d8fc78d1cff7e787579894c8c843b0ef9df919679f0ee364cf956cf875739931ad9f95a9eb67a39c789372d9074305e9c51298122b8a1cce7939cb3b89417160e2df62da72d0f9a2cbe372e9368f4204d1fea0296abbc05fdc97a212a97c84a60471b57e77ddd551c389fc3b78ee0bb4a2f4ee2267a043b2accb6117f589a247e45cce0e50f5281a19157139133c644499df06a9ffa2d9ef0068e109fa54d0c525f06ce9ab0c27cd8a0c777ef8a81fa7aab4de7992e35628d267232c621c287258513ad9faac8911d3c4c28d493faf1f96a500c92418195de6b5c767de6ff126e7164bc7f9adffe4fe2c4a1acae5406d6f719c34160f4f5139b54585defdc5bbabbdcff728490ec409f3d48bee0e646a31a90f0e38a7bfa4adfaf364bd1b948011a7a851b78c6ef353befc6b419ca10421b3f8d1bb0816e970087ed732370fec195bfd4c9c3d8fa779630c9a4f823390090313a69af6554c19bae30940428241147a068ddcde22efd04d80265f94735d5ca2559f59da33b485b8850ab50a1578ba4b912cefc655c6963c366fd6d7e6c1ce4bf1371dae0aa6535d81a03f0cbbfc27dae247b1eafd2eee627590500fa9cb794eda2b13206781de86ca89913b9f94677d539209f549fa75f03f1638c3935d48f09707dd164879bf343de79d772d959f65ba92c498d73bb9b3eb1680f7c2054b2b01b5553355f5ad807f1dd1d4b9dec069ee5362ba5a3331034e1cbec2f0090a53c6e342213e52bb66a2380c1a7f95ba469850f5962b9bd0b01d5182c099a05258373604739dcdfff3e46b0e74e7ba019dc307fd5e95aa6d9a9b77a804c3a911d4258c3e4b3eaefbd611b7028b7ca658cb2dd4204b33754e9cfc394e4bb32dd6a29cc2c93c70def987a0e8455c28ab1aad61b19c3eb151b8a7f3c1ca21f13743e4b8682066c274825a43d3e7df2495cb7557cb5a01c8d6ab9f554f9670c60f2da4279bee4bf7c965aedfec1b051069666681f07d6cb41dee47aece39f750eb15708cc59a687dce83f0cd8b60b7ea237096fc6b7c4a45f8ff1e0e220fe410414972a884c27035e53d75b55ef539873868797e6401c734096353ff7813b91c54bc051c36f123ba7111848fe8ed827e404066de065aa851e5afbf744c973434c929ac65e0365bcc150ef31207a75a496b51bf418eae69fd5263f233afcac59bd5b024bd4f3ce91cf78b7ee5da2948b5690410e85ea1d76c4ff55c8d2213ad4f3f9f08fffd6ed1ab9cc4eb99e28eb499deb7f5652d3335d0bfb0c580409e8b619458cfcfe028bc584deb95c0f8acd32d0130d35781c2b16c92b2cf1f02d97bac4aa5a93105452eef52946728e6a00d8c5cb19aaf6e86501fa6c83e692199e836e7f77afe1baeaa4bc5e2a7f39d33e8fdbbff2b438958de3c8321c59ee6920ca1bfa599d5bdacd4a87b41a66f269b46f455eae99b98d3b9ccda1956a4c9e6a94ab1f008562d5e348017a3ec3a5e4e47ad8a27ece0aa4d07ae969d185d135ab7ddf403ae2a34ce2a2a0af2ab1e70aa450cda6cc91617357321aac686e31db8a82b4b7f6ded3e41a5ed92ddb2c16bca680367dcd0131b888f300e585c86dad7270739b2b565de167890fab272c128f22ba90493db164f3e514413d06879f000834f153502026cb6c2802fca4614761ea363b80802a7daf1cff4b761bbafc3b3501853e5bc71789c10e7bcf2bdc3d5f9afa3582a482cd7ef96545bd266e28bdb74ec380bdcf9273433a02cdab3b84711b2e9e6de7450dd03178d85f96301a5a879de31c2b3afbf464b0d98511c426618f67f3f1f35024d3474fed2c3bdeaeea5cc325233e99e97d102968d0ce74c073fe280f848275bfaac2bd4c74a7aeff9d7969a2aabda99773869972f426f8f0e4c6770a598ab8762ca00b6b7bd9fb6ec0b61aed807cd934f5f9daa3ac457f04dc819802e0aea20e36d3bf8dce1bc7282d7691a6879e69f3c0e8229c1f6f07019da3520f3fa57104806fd7757ff3eacbcfdb57643170300df009ddf0875f47da7a32d5e5d1a5097e318759fab34ffb54b5796c32fb44e67517c6206d7fc8f8f4a2d0651431e2489ba435d7444d05312b0ef84cc349056e1d4f9ac096b7e164001749accad9849d800a44b7e30d4abd6116edf7395f96904944c4df949c8ddd7ea9c30c3359e80139fed92d0766bbe720302a348c98aa1a15ee28e3934ad0b6c70668d18126b9b0e390bb011c35090c5bcc4cab9d050cadf39e5de606184f1ce51bbaf6dd91ec76e7e4c5188966a01f24f91ac14acd88f1bd7339e3948874856dcbade686ae6c6a952565dd627631e0966a547aa0ee3dc2d88ad0d89b049e8c14782ed139510abafafa9cdd5e44b60e78b8e45c5daaaa92f1189f92ee489676ccf31e0669db58612282575ed6d670df4e79a2b5f9c28466eda9d1fb0da124b125324a4b356f4871131d33d3695e8e5d8d57ae88f8753bc4504395a10775d02068da7d1c95716920ceffa35d4546e045aac7858f9f2690bb6d7d1170db2c4536573ebe1d628ec68a33bd10a53593269c885444fc8a01f96263400128e66a8fbccd7d57882da607eec53f76da448ba5ce43ce8694087aad3294e381a9866ce1419484625175f1bbcc38be679d1e51b276025f835f1bcddc02beb1d08e79d27c6fabfb09c9a13bfb6b51f215a387853fd65d4c4db2291310d868762944d3b93fff741998b7308706de150b73e3a6c53b0697e414a0e5f1390d53f485c32733ab4216fc5035ef6ff5803366c0de98f6cfeb207b7a1392a2abb1520c9eb509a5bfe5949ef88ff9cbc5a730af9fcd496f01b48533af60601869d1f47496378ee3bce360d82acb70ba6789d89708acea75e5b19609e97b8e9133270ad4a729dd31d6487e64c771b565983223b438d8839b38d6caa27f7991689cfddb6201d3280b8ee3f12aaf1392d66a7b5b5c317a23904b5aa50dbe3a2cde9418ec853c145aa9739b813cf245e4ab0a4a07784d12d7bcb2f914ee71c80c45286373d5d79f4c215d1db275d37a8be8490737ab6e597df97dedf53c04387f5b53dce70c9b22191d0c6f5478ea9e1305660a1e363b22ff83d57ba00af4654e12d0839418e968464d876f9d6944b49c171d0b045be0971b5681d322dd8790e3fe04b2d0a6dd9aa976ff0b6fd7934a78742dda5df9da4e19c95b60082ad9f60db959ca1989a50951ab6c7ad00dbfc6130ca270b2284aa58ee9ab4e6db03049dfcafea27ab59f72c5db1589a8a032cfff44ba7546c506ac5f679f4123a8099824d724253d214087cb23347c2422a2b5f94c21bffdd5087875ab9bead8d3eefbf465df7e94f58d0e362c4774412754b030b4e4135b89f5f3d94e46822f834e31d29bbffa41868b08d7a3a368fdb73c5b26e2f73948dc3c1b006a74c047579ca1fa7b74eea439c8da90f5d4ed424911b513c8e8bdfdffa0adbbb2b44a3dcca3b50e2e12744b943051cc931252e70885693be70a02ce6f57b8fecb36f42b1f6661a0120498205833d87828e5d24768ccd17a3549a3ddb8a76e0121a1707170d897cedc7364ba5cb92a781c50221ae7ad5aa982b6a85547782fb440422f72e31e6d8f38c721e13ccc1da73ed96dd05f701c34132e04c6477a12bdb0048429cc2053aaff5ae498a89dd268b7d7b08142772471d41f15f8cef60c02d89014565b3e033e28cde445c436ebce3ff35c4774edbefa02aa5bb6666b3f32b94b600ca11c8db9b07e6caa23baf3e7ec40c76d0ce0bd7f60ad2c66c8cef7409b04edcbeb9acf18e7e10a7db47c648ee44ee1e7746ad923b855770d674ed1defcc43f3baaa3096d6e8f9700398549f7e996f72ead1d293a778427af0ba2057737691f5778f1377b3a81fa9f5b9376c5ff38e270b4ffa04b07f2b92b33b9a29ce71b8eadca0e321a1885f163f1ed7b63634ea5b9df05dd26fe8430898b111e88eab3487da01d591873be35ade54eb5bf088b77e8c33ac51c11262f3039c34fc4651635ea5b57f64b2af54aa1d0ea347b68d365f70b48c4fc7d0303bceafd3bccde9895e32b199921fc2673c4cce6d97cc1521f38f845138cf779d7d868e7539b2ad4a6a045f89059f17ed3b5d3c1829fa40001d9f17524e9e40f8e6f858e72df1a22deae05402175b15bcf08875bc66828fbd758d027633e9868b488414272ba4a847372976756b8673a7909f0011836955e387e9f08e055672b5a914af44e6c8afb567ace0ceb03b57372836f4479aa914b89fd7523701d15c9a9711a9a997e6c65663e36011e134b13cd266a1dbf3d0a5c27ffa08960bab2bfb4a8fcc115cb5e77906e18c1c2c05b9137581c53fa8640a1cef303937190047eb2ab5ba54fd6fc104d09d4a3b4fa6c1f0914988e3637a36d115d9725bec40aa8c52ca4c352d673b8f8701861d5dff7cecc8dab5e7b2e4c103baeb35eaef838d3bf97e2a13274376bcdf3ddfc5e4993a84ce49af65644438b26b80f207bf6205946c73d1b89f3df3189fd90733e0e75a3ad2f85ec31fa825b23a6dcf2f317cc2c14074716fb361ee0a536dabcd36023d171fd72ee1303faf144888432c436be335651ff6654472a9449199c2d0e0d6f7c50a0b083be6689abe149efa9986bbc3f377cdb63fc3e05636f809c3c72dd597971cf3c0410615cb01a41ac899989ce215aab96c8ed3bdf1cb42ba7cb2b5c0375f505b9a83bdc80c5d4411d8d737eca6625e6a334e78b7d4cb2937dbb9a5bbd6e0203252eedbe7a8a2bf3e20b54c42d61394fc1ab5337ed20969c7264daf7fc643d7e1616b30e4b70751a382444d076127717797b0c5745b811271f582df4ca11e91ba44cb52d6af7e92db0d028e577c4b8d86afd03661ccb6f27786cab1cc08a3abf9d5c9281540bf23ab52e1e44e44b08a6901e563764de6702537d2bd1bbdfa1d9a783ab370ff2bc8eacc9c435d800d7a4e53d422d3125b74584d7c1785b51eacb9f458023d23a971941600a9ca18de6eeb99f52062ffdca1fa850b8118cab3949707e545df8bcd3f1a64ea242d11bbd6ac65e9078891a43cdbb565907a0fa17a24302b278cd4a735afbdbbb256f1f8a32af4a7bc50398d80d512ec3acb8f55e92d14f01d542798db6b4f5de54d207d253bf1ffe2587d2a91acc83c9b65a0aed947148c3b6f36a2be0488e06823e88b17f264146b613b19e42135c99eca45295722a366804b57a5ef7864225418edeb27766b0ad4f96ede5e33a5bb49101dffd7543b8f1a61317616749e07cfd2aa3c4e9bb9d8c8d1a9958b6891b059287137b0381b719916c14768520e8b08aada1133d6a2ef481b97e3692dfa85ffe008622dd4eac58b942dd123174f9b872cef33bccfd99148bfea3e81ed68db19c45f62312d83b33f957a65bacd835766ed6ff238b801f40b0d38aaa52ff50d17a59846fd00bea075dc466f7997be4b613a4797b7ba2d55c497eb0f91a024fecca08cea4f287c2c8e14202d23a68d7d8e0ff56d08d59a131059880b331f39741aa9ddd1a7becbe314920dd370b3a5707f723e50722ab5b10ef58171d501f4032de0950660e04ff4f9ec4147edf249d9d26acbb1b30b03152317b48c5f6091aeab6918443fff8b57c50b0c5c32cf3669fbac11774b8ae4c3b8e0d9ae92fe66eed788b455c5f0426b19830adb5f5ef91a6674ad6f5c1c2a1b9f3f2f0de079bdf0cba52b0d54b710e437c1d3d53b4b9c79c61efb091646ffd132349887081967482b89aed32dbebd13b337c8dc0c8e74b925cc8449451e0f5d3d067b9750e40744203409c53db81ac9ba683ef0ee54131f45802783b2e54eefce453572f9530f0cee6a2e7efd3887a7a293fefbf7d40ebead39273ad4f19caf4ad227ac78ba5919494f2ed9abaf1eb4b947353a055dba8ce48c3f307419b515370b827e9eb8dd87d14bbba4ae264ba8725ea53ef786204e7dbf5f1adc080acb901b7223d026923f2ce2907fd2f5b0f8de553c3390c5db0258043def1c3f77566b2b99c44dbdc6c0576ed2a4c37599894b2deec40630b41127d40a773a8aa61a2f1067b14f88d1418f23d020311aa61d1792193b4ef9489ded443342bb7b396fc23dba3e64944a80e442de84a185b5a2c4061377485537c1ec2d32a86ed241b497de2f3a55e7bbc3e7093b79a06ed10307e12d8f93024850f1fd5641da7f02492f30c497d4eeba2fe463ff55dd315a0a7bcb22436a8cd25d784613ccb35e6687c96db3d0b93bf4a7a8816ef0b240f90b99c62dd21a11794330eb6a4a17e57ebd0b2820f59d098e63a655f013a5dfabb9eb2075211de8b6cf5d0b6a5420b277829695d5d5a79d7a11be26e1fcde2eab9defe7a6f0ac2bb14199f735aa61d7292b0de4e42b6bf17c5940424b79632325cdadaa1ca8722592eefb4cddcc93584cc7370eedbcc4e9d8b6acdcbd9ef1450242f222ab0d0310b674bd946cb5f2d2eeef7ac89d16412a0330aa079191329d4d62472491090c9416d7939cbd2514547698482e15abd3c2dc60fe69ed1a63700fccb08952861d2f881d5073a447c1b431bc984b385ea2199f6944e4f852a545c30d9f97b0686ab456b25bc0fd783d65131c78cc4b1cada8c0acba7457940409b99c69a5a542df3898d0d142b71a2198f2254ceb2bb8940e3c44cecd57823edd508e89b2c0f885d1059ff3d16fff4712f37013caacedbaadc160094d359d5c9de4f815b74b903d1deeb1b1f8ccff3faf32bd924b77dbdadbc6fa0fa90fe8a54749f371f95552382fac7248ced80634ae09a6efda178d49f19a189cf2931667240e583cad2c583f053fbf936d3328646e6de5c7b7f021c6248f3a5deb0a05e935274c7aeb286f367c97665e5e56fce48e2d68ea26f9cf86b28d9362a75ee99ca24a91b181112c78acaea300bc3611cdf418436f447b01e1102b5103d61e14d47da425854b244a494ec6cd3020e720fa65c35a59a4a0732009f7e500d553e0607e1495c7bc3184fd1bd8a219b39656cc52bb6cca8c7030eb279c232ea2bfdcae56bdc0f44ac2a69ab6d91cf475c8986e651635a507880e6730cb8697489a5d8bec420229a0da40b7b2097a4285f28c55d89a149a65eb90f3f149adef3a97e59cea7da4312237be4e315e66d9d7713230994bf2e1e1525cead992ce4258fa0f99786b37bc0dbce5157fafcc565d2a95d40f370fd1a971ca45c42607c210358e70d4b7da992c98e6fd80afc94be96600be97e8f0896e83c509119c4f366cc6f529da7ecc1695f8f5adf8ba4fd9efe119f2e5051086ff9fb61a869c647e225f08969b7851798f58058c4224b03de83e608d3efb52da2aa21fbe7040c6319a774c42beeca0368c1bf3f3deaa8a321421fe458e77b700f492458c64e108b30ef98fcb096e98385b23e95eba1d0f8e5eb33d6cb6239536d28f3ac991e0f59a4e72384ce3575eb49197c71bc368abb259aca55186d3169f6b5401d3beae1515018106b9caf1b97fc03b05f666918fd9f148b6afd9ed7b61abef2603b6b8a1c905b5b9ff8f7495dee66f15fb69639f8ab934037fc01a002695f987d86925070f0ba1dcc59420bffc36ab871d40b70555f9eecbfc956da992f11640a5b156b0a6e9714274110e40b40edd3c853e26f35539abc0324c35f69d76afc0eb52d42b825745ea902fe84e5df6d25895941e52f5680d60b65f2a56d191f177c7acd8be07bf07ddceae5a0704ee3077375bfd43b9545505210bdbb3aa0e982db4e7736e76caaf64b4a6cb4e1b77e4be1838cb95094fe4f24db7a804844ab6681311366296f5def2257205dd1f715cd1f6904b099962d10d3d26b6e90f5b6af43fc1b117f0a19625e667ae12710690cb8b7cb62ebb5fb541ba69883cb9d6e8349ee608103feaff24a7adf75b522c4753c40c0bec2d9d1c36ff668be6f17311df1c3da0fc047c67bd5a05afb68cd15d60ed96ae03a4945a722c8c893c435ed3a221206f2eedc1c7624ae0611b07cff9450043213264bef727e3e1bfe9917db9fae21f7d6a8f604bd6ea4a05d2e0fb129e2abab951e0ae9a7a4ea7f4157e35eaa5b8571a79216d6eb90b036ae34def1a0fbf327d835703a053ad3b57a37701cab3c5d282903544c0e18270db2fcae73a51686ca1f0a839debc8729c229fbf48bca35a3fa5d2e2ae09f6b4d403306ee7ce2e31da0499b862ff93d359ec97637a614160d32195087a3ab852844ce123838fa68ed3a1765d4cb07f77a2ae86afe9fe6155f7e88fffc53f40e3ca83dc7c1d1aaa527508155805d478f41bbdfd618498dc92c8c0cc329717d8065a8fa8e5303acc505f4b95361217748c55eb3d4e74089d2566fa152c5032d0bbe2c80add4be2c30a49d5564dbf89bff86aba910e4165e22df0cca9dc7c28bd7f8e0ac5eb315002f6da3d660eefc53b92e32075db7e847f44a281892706dde3ab42d406e59caa848890c5c8bc07f7e7735ac1b907c9fc0264e59077ccab96057802501a4c6540a85d12f4a28aaef5c260088beca0b359743e920ae108c6e586141081e61d1122b59e897ae2ffe3770d731637e1b995b69d1ef8db21d9c0c1407201c9a8fdc4da192ad907ceb0de4f6240e0258af921e749fbf5b55c22679df7f1f677ed815ef32f53d9a5b8888a4f5befc4311513958c826d8cc00e7bafbece759f727063d155afb88df0e857a68fa9be1a7cdeea6d60c807da80aeb76880ff056da69cd82e79cc1530e959564f22639f26481817b61b3a29bf526809a4a87b24c9af5a7f7db9d248a52cf6f39c5552547ef3c8c6dd6431edd12f6b80b7c62e71d86f64dbad4892324cc89b9cb990fd75bebfa744ad3b2cbbb2ec15aed0dae0e66fd46d6522f27f7efeddbfb46d6aa42b07310e087dc7a730eb42b7c560ae16208e96bb4dcbd82ae16aa7bbc599525dd8eab0c1c14de1cb219f26d06f2f20e52c7333ea6fd369292f8542be34d97605bb32c12a3148e89f0*1*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*166666","1234567890098765432112345678900987654321123456789009876543211234567890098765432112345678900987654321"},
	{"$dmg$2*20*58f110c5659f71a773cfee15fce57bd39a9c3071*32*67a0f064560064ad000000000000000000000000000000000000000000000000*64*a888055ffd98f46c27ed27ef34abde2d46808cf5a0da4a1ace11c116ae28febaebb282fc4d5aeb0338eb5a16e7bb81975767a83a4c20ac341f1af24b6e012e32*24418*4608*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*1*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*192307","123456789009876543211234567890098765432112345678900987654321123456789009876543211234567890098765432112345678900987654321"},
	{"$dmg$2*20*7bb7182f7225b9b973f10c376a9c05b520a4976b*32*34c0eccd65128113000000000000000000000000000000000000000000000000*48*242e419e830ec6768eddef7ce37afeae00d48b67a24f8c9e9d78f71657df53366c30c049dbea7ff37234a1f11d4c8f5f*24418*4608*ad5d35364660108ef6d835572abc64738d87cd7ecc3c332ff9360a7dae254ebab203e538c4a31a147fbaf9c78033cc7465f270d901ca454f2b3e23e68b230b9451059c167110aceedc4aa3ed19226bf5be4039c04d8a657f614728d6b9922fbf1f38164059d3faa7c32ceb85e955bc873561c3ed37d3bd62b4ab90e32a9444cff91ecab550f26ca1346d7f24002a20265d7170203aee2b5df9fd84d586507c241f9e1279f9c3192e24ce970a45f29fe8c274f0559fe47096a78cddee03c305ae228cfc990a1a508b9bebf409b764e198d23c215a9087cd394d27d56405d3975ba0e1c997cf85043aafc1cb8345fe721bcb043100707e8ba8f55a3563c18e59fe5d5ab8d87d739cc2b34f03e78a132842fdce1fd75c7ea3ee42e9f6575169a2b0be1dc8ff7eed74f0a3e5086aef0198c7516e9a41485fab8e581b25e8eb8db744515c3f33f83c01e57491380767c8ad1e779eec76a5db5a0cd0c067b36b5a506a995b97ac35de9004f80ca0a4f3e2ca84198cbdd2adf5ad4ccc60f6db0dc8508611085632d702cadcde380e0e975e665fd72113287329f3a8da25ac05b77aeb70c1f63e71b0dbc5d708f7c3df5dffcfdf998ecbf4d97c3ca84e0f35564a8d3ab5df77f93511537acb0015dd56b2c58ab13ed269af973a9217c94f4fa19efb6a21ea60673fd5bd227bfe738ee65bfc0659d76b7ee16ce2f1c8fae4ac27b09f877dcaeba1a4189ea66614598d129ab8cfc0b8302dcabfbf23ff8c7ce46bcc330015e690516aa91166df32753e179fc0546487d0fd9aa833043680963c0612d68f018c9c76b8c50d2ca076a84cb20c90768f3b305d292db2b67b3f9eab4c2eccf7e320efeed8f83db910a26961158798f5f4d7e3b0c0290248c22b2dc9c68f34791bd127b25de2b2f97d7aa473a3bd2f12264b3c7c534a81f1480f9347c82d88697da4d5a1859e18916935c9aef80615253f86b58cf583c5826d9a18166c9fbb8bc291a196d66fb4052a3f27990353bfc81bf42fc5043c588b336ac2974d5a83168c54a361d280efd18dc28c89a3803c4b1ca0e0fbfab4c3d4d96c320fa7121eb5b01ac853027e48b7a6b06a805a064a4b621f9986a9da14c527b60496b4bae436d9e702530c6fa2b499e6d80df2132497b975738bad803d781ca1fa6b4eb9982359d6ce3699c57393e1a1775ffe595654e9b0ec550035e3172d744d1f4dc80b3e15ed564f04a4c1939fe08d73761af39606b97cd63852eb74464416f9b2843fce540c0eef0e1155289f09ae5dd07a334aedd83ded01d73fc1381bda61e39e628878834ca40308c3bdc967503a99f90d4c7af38a9a99708bcdd0652314f9b5802687986d7d057bd79159a410adbee2444d1e7997a23f91cf736ecfe38c3e4ee06fc4bbcb94f717a6c901330218d205624ae4f1cd51b5543a6f658e827e3361b1f9d68877c25eb91e7b488497994329584bf81d3fbb33e4bc695b4b2c81092ccc18df7a3e285237219a9a3deb677a8c62f657399b16dfb33d7dc95c0f267c6e63f1b2de5c4012fa9102bccc0058cc961e8269bda03fb2656475b0d22e77d4b46517144a050d25411a999c5ca4e5450807ee9ee15259945f2c9f768c739ba3c6ffda5f6e77c68f3e392fe4924cc1316cefd5ae04d8149f43f90a8ee5a7017e6e56c0eb0049a8b41dc25dd9a00b9cddf650b1711961b4fa503b6f2a184f220c2839538e6ae8854a67d1815cf5234bbbdb107182373a102d42001d6d26b0350d275bf21ac3edef198148588ef5629fe5cfc4134ff609118c773d8e6ee887562bc7162213542bb033f4418f38cfb219101b29f0068987964c789223fec2a6ba1eee8eda6f17b7f8fab9c5a7d437583ef1b615aa4ffbd11002d47ba35b9c5331f6fca93fe69883fe00f61eaaad9882080d2f19eeb3c246b763c85dc1b331e63b9b9b287251702d9490cabe224c8ad976ef6daf001208b118ceea578006c0666f6b0dcb174854ede40d217e0815c65d640cda2d70e98eef833ed02580c13d8c530146ebdb24778385c5361eb5a5828b2b6ca100e188445c4c31ac2157e35ab425e7506c6e132702fc374d663f9f0b0514b03d89c0f963f60391e7818d72ba49ed7d5a2afeb2acea33963ab3546cb7158f83c5191cd9a36ae71af1d209e05520264205e14895a8ea0d56a6b878537c9113024b035c3e6a6a45668e18bc6e86ce70424747f8cf90d5e574289ef5a80ee1b38a3bbe04f367cae39d6fdf9eaa0f9617c6060a06f5e134e7444c06b63f789cc0018c85e9890c36c1c20134c4b84ce3f7d07690a827f50e003649c387c38f44db76627bdf6617c800efc187754cc7dc9928018730cc6e51511dec6ba1d95d72274fbeab9625ae7ee16cb3634d6cc4494fe12a07d1c1caec3e9d841688b9eb1a162c6e4e85b6ae1e13529d2ac158e51e4f1cedf646ad52a500f5dcae8eac4a485d90014aba2347f90fe8a930e562ae744aa02edd5e9c356e83ea1622d8c67713ac88fee3b8c843a3a5c3f32fadf95fcc6139ebe798c3381e750d36e43c0e323093ea1e38ceca376909f87d1304942c1b63d19adc25b47a9f6ee0f68286b1441cd3cf378a5342a13bf358afc38690fbb6a2294157c0ea6be220749ea3120439a0d4ecf2d02fda03e666a7afddd9793c0f08b225f6afe587286379eee70e06aadaaae11602f74dbe4da07b84f848818a3ad08e1a83289556578efb812ca26984b1bc18a93de9abf5b570adf759e93a6df5d50764a01cd363231ea64d9d8e1ed1aa9a2b1a2fa9aa432c876e2e99592bf7cf75d5f707ead9162c1660e1ea27bd12abc6f9a4b7254128184fca3ea9d8ec459b67a04f09ef42dfb6dc0638084edfa32bc6fc577381c633ca467653ac3710abaa541d58abc427e74b1df781d19e7e3bf66feb6907cdf6cffb3bb3be54a742355de9f9cad8eed74a8bf655e5a7c90a53cba06cd8c32463de192ca133609bb1b98d67ea6193011a714fd3d352843d087936a073528788705bc0b9a828b9899e1a5f37a23e53382033ba875ba91e26eed003cfb313c0b444af1ea29f51ef489e3d44e80077db54ae7bcf3f237e94ea95463e22e8ae3dc29d713beda19cd0ac6c09b6fd1fd317cd4f8341acaf81f5ee36eafc194465c4bd94d6da076413974063247abc697e9ece89d965603e7c119805221a188e7713577a238d52d8588582759dcd40c35cfe972563950ec1a532febdca0138c7482489a9baa5c2fe9852e242ee53e91329e8ad568aa98c28305d1b7d8b9d9c9a5a220e815502894d7e598f30f5ec34a521cbf7ca083e3c0be9ab1447ddca78f78cf4969667fe80a75f3e6ac0ccc798c6f166a09be59e98bc0e519b4ab1942a6b50e1f9ee7a069e2555256e3211ba126757ad37172ee3961b1b2da82f146c1636083136d71686bcb62a083bfdca9353520da85ae104fc77e529f57a27ec752010a35a95785edaf778b06f5caddc663ba3bdba583c14366ba27385b410e8215e413cf6a387eedf02b71de1d494dc0f58fbb6cbfa159e4cf8cfafd70f0e4ab6e4b40864de678cd3c0d73009880ed9e24964f057c688297133706926265452fbbb0b6f2b8938f91f8340a8d07ef27c09b1e7097c7cac91e50714a4637561eabc1479b3cce59fb5aab44abfff4e44f8bf9c8e2f07c6c8846f1364c37144ddd6a1a96492d5060c2b3dc4887642e076cf9b88a8cbedf18b3f832e8f7ab9bd21410ca551047cdaac6908b7019289f898aaec69799a190cbef54ce12f6d3357f2c456d766166c62ae4b93321414499eca5b782d862b63cb91b7f8f998e7a51e0ce9737abd64bb1e9f885f288a4ad6c97e0fce353a43e4f00c56c75ce22865e88a4dc9b1a03eda8ae0e84dc8f6afbff15ea4143c106b3eb60f435b527beaa292a579c4d6c43b50e1d1eb67a39a53898961c650fffc728846491e1029a62bdf47967df94780198f4edc78aa49b7d5465b590d9f0549441055d41a2584cdc16a3e9fb4c679106f8784fd4709cd8fdef0e20f8cb90729adae24ae0e0547cbe63fa3c87194e569bd052110473162e04ad1aece60504069a92492f55d4b05273795b23103c3d04f894dc8fdba5153df0eaf31e7a8acb75cbd6b190630a292c60606696dc89e4f2244194b622cef5e87303b88894bfecc2d7f3cb5315ab7de6e3e214e6a3f3098786bb6a08dc2d54e601a42db3083f14da376191f634b0d21045df19fb0e4de72c839947fd0409a0d04cd605093c2766f6b4a6eea4a89cc443aff7e8cd620efa71fe9ab41b9cc31d659f99d5fcda1c367ee237499ee728638d701fcd7577aa8f8fe56d5cf5f2b7a692b81fe65a9d52122aa2cacc086380789976579e14ae70e2202a7daae256902c88beff747afd1ba6f3744419e0e586731b91e93147977987e9b3f58e2178085b33aca0e616719d8b2f5dbc416d2da62a9bf18a145350dde8ae161ff9baa5449db95cccaf4b18d12dabbb063e4c8fce04b59a36c0aca81f3c0656d0a50bf31670d6ae242bc71e03289c79e0d5053a5a316442729f92848d04f3bfc8ea7b8b10561e5b36e0c37c8f9932edf52c06feb131fba0b8f894a3e432c6807865f2030c7ce5ed9d408ed9a092de287d41ae0e1daa61679f46762ef708422800ea77d427069858721ad20cd83f05c2ea319d31123e5a1318d53f63c48aceaa44bbd49c8841eef0eb23f3dae1551a1bfaba2b5ccdea8da3ed18dc063f61e5a50379ea69f6a850f3d62c1b5778c305e630d66c6f81a19a462d7422a4ea808948a7f05eb25f4a5be1e40e7aa9d860c0ae161d9ba76f7769e972a06216d16f6a162469ab464a9268c8bf2a164b3673cacfc72a65813baa825ea26a2de08cc70e147928efbbdc4b21e47fc65770f3fbedf0becf3e95a9b550acefd40fd4fdfb39fc44705ec7f0011db96134431cd6500ee06ac2822f81a4262d91bbd95684a55eeca150e31c9c8faf49f1b7960a762d8b124edb4198c488925156c43b32bf64c894e809c7490af1989f25d65ad3af1ed4fc487d2ff015e459c53ddd42b8e35cf3e5c261e0cf8c99f8b65d58e84b6591016b921eadef59f3f7ffa9d10047a95dfe77061661963a2cda9ca01d32a8c69e2ceac8f12de49e36cce26e4ca3c8bc9930e9024b9d6cfe507e8ac8c65b00f94ba84863c8137c4e86e62c96ffa073944e5a655e143d1545c6b708032719000819e6a97d83136d150a6a193815c0a3cd63af7926e92150c45a44e5d0652d3641a160605ef9190dfb3e92484870c0f5725a93e5e5f2eb2291d2178efc8b141c87cc500d7dc8c30bc10cbabb6151f456ca7638f874e62d3ded7c2e45ac0094fed06a10850800f89a63885abff0ba6571c779ab86418ee199384c4fbb0a77897952a2e58cd64a83dba1d2312ea20d7353fc473a2a4dee4ecaf1d75c0f566b11c9da72ecf249adc4868925ffd355adbda4d4ac8299d6528641c8f4d518d6d5b3bcc3412117498a0f7e615f19c2508b87d8c4ded544d22a206d30aa8d2fe10c462c110a78d223e8f9d2ab230823ed61f1ccc8e41cb40058ad79e60a98a21584caa3c530654dc2af0537b15bbbc600b42f7b88de8cad8a6eb67c8736891af8f17a109ab97881b86484152c1bcdc0de5664aff151c2a9cc699af35ee7adf59c61a3551caa0a00ecfd047d4e63632fb5c7c7f18309f2dafc8d5a782bf46844cb8f8b079c7b44912d36f1bfffaa330e34eb0e64689f18b0c09496e9932e7213a54d0c7f1843d5f63617034e26eca16263cb8c61b90adb919f6f0a4189935b227e4e07bec4c2c0a0b97d7ab310b05c59088b4154151594d748748ea77170a0af2c99c1f21fa277abb7610c9a6dfa578c877c94cac5d38b3c2e657de868b167bd45035577a3ed5db0ba9d94b8dcf98e729f8ffe65e20e916104d305dbd0de77c36e5e4b60912387df316d85857aa646e2062825d5af65eb90675aeb871696ccc937335d8760ad567f426ab364e5f06eda85d0f1f88103d7c0c3751f3e62a796c5cb9881730f8c77d64d8be44c7352dc6b51ae42013852cd4aea0b9ffc62fa79aa7efe6067e47541e6c43c6a9e9e0811b5b40a88a91233853a8c7f1733029bf54c7d4b005966ac17b220e0fae4e12d3ce2c323df7eb4752134b2811ebe7bc3afcba542d41e8d64740552229dbaf2691ca86e4b8b0c83adac73907a13acea5ecf1f74e35d5f6129b026ee4f426722b8c960c686d041fec159dc920dae12f41932063a4cc9919e2cfdf63e87c6891b2d11f8263b61cef49b16a895c9f5558c5ea66d08c1cf9b44a2a6a37ca64d194a8ccecbc2b84a048341f4631a3ff9e1181741cf97aa0a94cd5eb1ba9b9b4c816a4561c6b4807d9af22ad739dee1d32f8505f37d07f7f8bee2f6f41a61083508e7161bc588c4288c855cf21bec5d59bd0c61afe57cb6ef87dc11b4034cecbab574be683f83f3c9466e0ba270038c062e0d630aced7f6a2992f64c514990847ccfb3c7706835019551300d63ec2edb3eb6d83908d5adfd75d17409b0d78c4849*1*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*138888","12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345"},
	// APFS formatted DMG with AES-128, created on macOS 10.13.5
	{"$dmg$2*20*d7af39b1565a4de54c614867ffd6d1c8c54339b3*32*24b860af719a4997000000000000000000000000000000000000000000000000*48*571781caae23af5e88bd1255d17f2affd7e448c8ec3ddb79ffd6bf8b959d20224a302d30acdf619bcee61c064ac72657*24418*4608*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*1*67a8597f90a698175c6bddc0437dfcfa151c0c58716d0c934f258a02e6009881184cee1e207c3c245f257abb65211094175c34ea65e0716702c4316d97bfd6e296720eda523face3693f02a17abf28a6b8dfd934f75032aa41366e3b2511e0f75fc602cc26bd44396b028470d9c48658130e66130526eccc02e2f240e4b8307bd3040558e439d3790ffdbc657ba9af9141f60d6d717bde4a49da618e7ccdae4d69e6d19110c4f749467c13c6aa132a732674ecb1f4de52d3a09aa081e1a680c67a23df5e536a125e11d46b8553dbddb30e90a8b8855ba81968f8f950a60287a566fd3cb7a8562a04a8326039fb06325e0658a81d0803f276df433f5982afbc49bb82c4a75302a221e53c060f4ab8156563f6e7e1cb7bb0533691a3eff951b66bea1be649f7e5f5d19dfe9eba60d9f10391c99c4a1c2079d64fb5757ce559203dbb10579c4852bbdebbde9a3bbeab2b512a87a57eb6b8a2733057b7648c574b3ba876fa0c39b7eebda52fc272bca121d10424df06e36ff67cd117a084363c643f2762613016f349cb2d59f4c9f3174119b6ad461dd34ae07f1ea554f868cbe837e1701e62bf6e2e847c1f0cbd317c17a3d9b917a768b216a96fc4f22cfe48529e2e7d5c852b272b816b3b98f0e0501681b9085fb6e3183abf1819a70cc8b5bc2bfbabe1e550e7307123d72e98bf9a2c2cf69eeaa37266574086a77b784e22cc5c9203ff2fdcba33560703bf94e696841412c381f53f48cd7f4372297f721c339a0ad34c67b36918dd7163d2a64f715c2c18e10d57f067e1a1280819a738421d7d3d8109fecb3babe92b403bbbc1955a324bd013c1bfb060103398d9842a5bd80b9d97ecac34f19c2e5ce73158f9bbe7c1e8d2087f920ba0f0858f52f06b693f1f145c1e1c912f446e6a86d6b105c1ecefd75f74bbf80887c38a719c299fb2b7e7a6040663806b7f36ff890426580ee50341fb423bbcaf51d549f77b54a95f2bd3969daa328547ba5438036de769545f9986f4ee5e3f5880dad6b73bbea53b7d0c79f0e929cdc14b1a2de49a867a420592db10ad682d39551b9116db2d65d7f0c56d34d1bff1c748ed5172b35695259a191a2c8eac0766a026cab495810178185d8b7d04a455222a1839264033a72a19159492c75f1a35a07324e7ef61780d9a7a12958e0f2da4ff61012e78d4bf561ba27e5bb0d8dcc0487b0ec5ca65ec2f2c3bdfe97fb34bdd920efdd45ad9afe914e6632f149347092358d9d8760bf8282ffa4b95edd6d7c3d1c0c97c08040c89157205dd0651e01bc9726fef49aef65cbbca12d079256b39479bdf3851806e2442bf7281d6e37370ae63159dd04743d1c1af7c63a62f8babd57d99a64a434fc56be43a928ce27c3db0dbdf0adcbf9ff5050fa606660dbb662382bb70f96643029f8814012112bd2ba558912a8602903d89ef80a6d0cdaca23b20da231deb1a226596c71547a2733dd6c55969a924984c9fb7198075c3b0865a874b8f6366cc0c7fc285523fdb79fcdf5d0dfc61369a316eea75f4458730a4fc00da48d1a998e74513d9609c4ec62ff4586909fe2c051f2aad341f2350302751d77adff4e20077fb669c03d08526c6e9252d4ff152470c270b73c9b4d5d4d20740aedbb1a8241c839be06a09adf4cb1b4ff62c2c435a38105815899a2bf20a186330e3e436e1805c61929f42c449a18a55b06c858cfd5785ed41dd32c9b3fa86b4b7be15744c24c5bef1e44d387cf0dd434b9f76d568cd25aa2c999df5a950455e6e47b78132c541accbca834403518c26c32f9d5d687b66e1d96350a2328c37d4e16e5d684148d5fec018199fc1835ecdf60decf1261a35496a1d8a2015b2fdef1c491a97fb27b20de1aef93af9937f25929e91137223201954f5169e45580f80fe182d680f6ed3cd7efd6684e4b18f3c4be16848efe09f6df94180d9e517ecaf558e3e6484df372f338850f63abfcb96d0982d740e627fc0bd57445dcab1647f461b8955a50f860444a135b4fd942e8543bd4a011fd28a1d1d2a16dbb4adafb3a4c9aa639ec9d344b85b72a12fef2cf0e2a94de27642da42269110848369468615f19c3765fd79f38eff7eea4c0c78ee3f142f3f4eb2e9518bc680e3a30270dc043cd10aa784e0c4533e98133a917a7f62240b10f3569efb93a40d54c62ef518c126096352cf4efb766b5da10d26a32272d271b4e3ace9f2581b454309c09d4892f12a0b782f8d7ea0f429ef17d9a44f4cfe22b2e50b50f0070373f6734f68268a91e88e1890898cf93e6a13ecfb7be00a6fe9d28b94a3ac057ee05a0f617d9da705216f9ff99eff3d964621a2d9a836b64663ba23e1e8e46c9d60e012f1e7df61273dc8260d563543b3e82c08053c6bb2c267566f3c60ce20b2675925df4b77b4bfaca02c75833856fd9696b8d899afd7c235b57df60c05e55e9a9f170e44d49b01c75e381670f52b1a1d3d845132adc3fe4f3b723681f041d1198063a01749e638eba5d883cc194a947541867d657b93954349f7b9458a918bfbee0fb210a890831cfce5f12d85da515dd183c299ec6648bd66d30930358b6c78467a44c2bc2752b11abe2e8f2b038aeb205d5aa1d17d76cc0c484f371325ad300d382856c52bf2adfb509ff5e5fe39f9d3cc3ab99c6d400363f995d89f0d8c6bfe17829d22a667b57e19510a83799719b44945402a237c799897f4ce9a48e9b142f444425699dd234e86ab862e905db2bcde022b9ac2df077b0ee54da80eafb537a951282c0e24511672bb7dda9afac0513ccd547aff3549161f2f61b3d2dffd9f8fe726b4d0c2f456d4fe5ef5412e2a44e50c3f92284fab232606fd9ff52ae9da831aef03f9a0a85459c249439c063731fb20a42081bb868186afd118b8b4df95edafd5242b00d74c1e9715d8a1edc981de84fdf5b9ca98650bb146132dfb6ae2031d8096ad178d83248bf8ffb9273b9a3544067669b47a50dd37d3868ffeffc594bade6ee7d705edd8c0e1de097de2fe29b660e101736b78a635add58a849206bb1459aa756e8d22986159e278e30b1da1f98e2de541a7abf6bdffb3eebd217d0979235599ec8ba4510791e36bd165b27416f35b8073637a70173e9c2a4d67c996fa10e5ccb44cf1094e0a1a961253e5dd78edcbd296fdee1630a572159955c399dd0d2b8d1076a8f0432366fbaac52e3310e7efcbff465c013292af588e5a71ebf4274f62727a257b838c8a2ab72519f263de6dcb14f0e2400629bbb982043bded1aca7478116480b7ba01db2af94634fa64be2f25f89796753f460bfbfce37c792d31805bd1f6c105ed464e1c33203dc06c5804b5d936caf216efd1290aa0b2f24fe49118b54225e0b8fc37bddd40056e384f42e0385781343c209acb572078f2e3be59ae81a941ed4d4615d041128a61481dba18cfe330ac707274b0d6d55d1ccf2c980ab7625f1c839322dca2287fa6bffc6b5f55a8628a51db8a0013785efe5ff81d02f4c948242d4bcb69cbb834d268742996676a72ec1f44acbac8da64f2924357622014cff2606341987bad682ad44181b26266db29236742bdc32c987a5374755c820dd2700a7ba15b3271add95decc7e3ca779cbcb977e4a5312665911ad7e03d6dbe4d551f02340807f074b8d4535fef274d199868f78465d119bb5acf8d432b12e757c211504e9e9eaa4777285162a83c3c9038d29380f07fa4442fa16d769a725b46de3e1bcb50b0e74caf10eb3f6616804f60579fa9ace63c292ff276497413fd722bd721683a1cfd33a1b0a699dac1eaaa76d3f4e095ced3459b184c75201958c775096387e20fdd5653172fd84d6a5bb9894f88bbabf436f64daade4fb1081b7f6939e7875d05618f5a4b8e43d2f948cdf443276541383e5592ae01d43c6befa459ab0b3c352306964bc06e9211e1e10479c40483b06a174ec565af21462c02e4644b7259f6bb02f1493fa614187ae8def6cfa83b222766d146b64fd0d63fe0524251ca23fe73f723e55ddc1b3b4e9a6add624854aa76fba1e31b547f068b30156e0ba06fd7d37ca85829e88b822bbea61f19e2b53a0e471783e6ba61483dd2048540b2d3ceaf6e56d62f3b868a6bd198e0aba36eae2b24b26d0708e801b9ff4767d4481b33a1de1394705e12520bfaf140dc7f1217ca418b1793bc7f8f0c28283e0313f70b1d73c02bc0eb153a014bb1a30e8e0559359c0091061bebd29d518d1ec63b349054ee2ebbeaf99c5e1a747e97eaf56d744df3d56961f8159a2f65e2becf6bf769493be1793003982023827943119d104c3a0087cd2b185568a48e0695f487855406d1b5987e6f02ac7d70ab513d2a4aa518e347c9795e17ca591319d9b63f4f86f1df9fe1c053823cd718635ffe11a871bf4c5c4835222041d1e3bfd59350a50eb308c9de53313c9831780ba0506570d3ae8c00c46515a79edafb0f39b875a5a5965e17e4ba5dd0f900ea1f91db7d0c071cb3d6a25facf50019bd0a28b9a8645d465586a52bc553796926051265f1c773f9184c8d166fa298c1bfa8ffd23b4fb9e10c11e3428b6fea32bbf05f73fe4ec05f836f744c8e99ca5a8ac110e9e6bdafb9af8d43f9e4819061b37a90b69e15c5c8afc9c7968ecc52dd2b0b2c44dbbfd16eebd902b8bc65a4487de6e610fff7aac68ce6f410e5f5367b9d7e4ae274df4c037293bc59cfe9186953e53c13c97ef63a64a87d7f5ae5f22be3a0ed55ca4073955ec2a8f6a6dcb0e27cc4a29f26065ba034cf8f694ecfec0a20a6dc8af6ef64d512a8f6ab3d2ecec089ded4172367ab25be50ef4ed617d267905ae141b342fd1ed4de3328b958461f08bc5df15a78d08c1cfc63c98924bdcd98908863bfdbdba7c485dccc2f22a3eec6b285b6c3dce2d298057cd5f0658e17bdc5b6eacfccae8ebe8bf9c92ba7994dea9327c54b466e716afd616f8fedbd9a73d1420fe7b7b390d4d6f7cfee77ea8c5b85031a87edcf89c7671702b2528279dd838e873c9b0429ef72dc48bdbeb13736615e47c1e4ae72221f3271187cb133eaf1e1a4cd5fd1605324bd2d8c12c477262716d7f077b0f6b8f943df86b4bcf70b825b753ddb3b5d1e9b51d85aeb28814811a30d27f3dc9030a175369db5440e2942b37d70f62d7a3132f2bbcdd2a15a384621cc0b1d62464c791b7824b596a996b2e6457df0e617ab565e8d22df237c9f5400784c6b43d7ba4135c54a006c4aa28fb117941aa1a866e571b2f8e9a1522b18b1984101c2776bec6fc018ab7aa788df3000847d6017cd864a91a7503dbb6b729ff2ad34116c5b5a9bd5550ac7b0b68e33596f20dcbfe13caec769ebc4cf027ff83f2da91a6c6160d7e532b3abbcbf283891682613e617661aac465e84b83323fdfa03b69e12ffbdba289640759cfe858f3755086eebaf05bfb43c6a3ced692a53d2457d340efe9dab5d8783af9847e739f9c62daaa60743c17ac7b63771621a3fd0be86d836a3e12fb4c26c228c952cf5dcff5c69d6b116b8445c5841de1362764344f62ed208ebd3abf272144f87d07c63589aa3900840033d6e53e5cfa75f038f37ab16f5787782b0641197bf9d361b9a36a2aa832c55a7393ce309a36d6dc0f66068ab3f532c7868d7f3721b6398bc3f809d98d777dc02d5d7ab3c1207cbb062fbcb3841eec7452551b267cba6c4fb1b44216125e79e6711feeb47ac9d857cca59bfd965a8e334f797b199d1edcf7e39b674bf517b79ffd5ad4ac89a357c9e92fc91ac2bcc8723042c5f225225424f46eeaccbf1acb8544611f4c4a6837a969478a*263157::::APFS-openwall.dmg", "openwall"},
	// APFS formatted DMG with AES-256, created on macOS 10.13.5
	{"$dmg$2*20*884f164bcb22763d51b514f4fb47beee67f7848d*32*107465ab13cabc37000000000000000000000000000000000000000000000000*64*4eb95e77bdd06a63e5ace4c6912e602969cf6d084f064bb803d20530585752aa941cb26f5b4e01471eb8b4cacb6dc11f89e9f03af66da6ca2aaf3febf7623335*24418*4608*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*1*ff46404b8d8adb952b057e73efc3ce89547faa9b4ad669878416d024c3d2c03dda7734e8c93f9efcd51d5bb86ae049a7dadc0b709b32314d96411b77051df8a20846eb454c824d2bc0d732990103a6867f5c2bf27ae29defcb702736ae9b77694c507fe5d71c5a41570549a4f48eb0d40787b79308e8e90c3950bc72f9da3818b0a401fb9fbb9c0a7f92ee13b3d230805a4ef53d5d2a59492e816a4703228e93814eeae8500555ee0e2e53bf3cdedd26efedbbb59fa4dd918fc807fe53cea138f6f59112f1a438ccb4b4a5bb215ecc2f9d5183f6f3a22b931c561693cad979e286c4bd038e56310a42a30a9d5299702730e01c6a46893ae3da0fcab246f5eb5001c7ca0ce69ef6f10da8d7549dd18940375b23d9dbd05acd6e7defb59a8d3b97c71c290964f8eec6b95dd505118a5a4a3190a15e339151397327aa2b0c7f607af891bdb26f270010577ecba7d2891e787896a8207000d4a78b3034517a4ce557744a0c7c0564228c0f1614815a73708ed52ebe3a32e51c6121253662da39cf3161127b9186f12d83602a4391d1c6b4d81f90777062b833e65718225f5991497d4d076f7c32e9b265dce4d951842ed790500d6a4cc2273146a366f6a23dafe3e3ae94614baafa907f8feb62af231df63d43d99fdbc88291f2953937bad5dfad9117868785b990e56be438429a67cf7ec197a9c73b53377de94657aaaac50a2a0d9cc4531d1277adaa26d4370a15b4d1b662e6551aff5a785260ac725617c301d9b92855f0226a184d677900298834b614fff1a64b75877d1990832f72933fe230820b235c00ea30faace0b218e05f8f3195d4524f4a22277070583da025abdf15c94a8f3d70f1a79a5c45667b65b7dbe7e04009efd75c4ac08b1db51369bd09921e637fed094ce8179080da084d83f0a1be4c3604e649897c36e65888d5658e69a4b4294b92db302f7b5a3d77cc1b9d8a5dba04974e6b83c5ca00531a979f1f6a9badcdc40d0a77a879007978c7ab1edad64091dd51b8c47fa94b8a3c44be1a7a28429e59591858f17ab0321ff8e3c22b8f01d9fa047f77ea4feb4cbccc4accace83e6d0bf6e8f0021524302563c7874c69e1fdcc1bad65c3696335d50784fd8c7e238f67615300ba55d9068ffcd217926c87a4562448eb37a10ccbc9c767b93e41429556b72090d8d81342b5d005c05004b41cbef0aac03c22a342c188308ca6238bcd86f68d711ff974b398e1b1431abbf123ed8654164ef5c907238cf29508b56687443862d90539f3b324c2096c58259b90ba094073f38660f3897a85b209999762228657a6f0b10fcad8acaf8cb34c2dabd347056485ead80aa15d828864fb02b54c1d24629376b5aec596029f7fe05d502800d9a8438ac7f16ed3592491518b8a23e21df010c9b8dacff2f6eaab26731fd96c005692db386dd3cca4aaf64d33d0473d74d1700bc5812d73bc72ffce3c06783cf15caf74f23bf8351a43af8e3626f17a4578aa30e48d84a2d8a5b21a1481801e9cb17666885163056ea06e1bf92db82bb64676c750bf2ee9fefd3e2b2a17471532ba7dda08782bee069a29088d36a5335a74575a68cff82e1103fba73b7da9623fffee0efaf0cd5bb9fc9530638d8bf55b716acbd1c5cc24c1dd901c9f0081c0cdc33c758d3a1ded531fdde3912b7676f9f93bfa07fb79d9f9e24358c6be8341501dc4b0323727ff4cba294f376d894f4b658337aab618a57efe05f1bc6bc6893d112c627face6de0f0b6c3b0fe1c179c1e7cc42f4d4c6afc0298f6c168f1685ab57b92ef72fea37b99d32f1358a1ebfdd8fd580f7f2cc45e26c458f33b8bf9c27e57eeaf050dab3cab814d70e5e848e1c7c4acfa69e34297953e22ab7edb44638e7630890d1d02f2b76b9ec13a0ec2da7c4c7253933d48ddc040a25a06e928e52c15ed732bdd473a95123a7e58f166513f1d5b0d558601abfc1ed9e3f72f397301a8226db21e3d5756e48981dce277ff21fc28c914049d741fb447542b2e9eec4597bf267407627b9194788d7c0bfdbfd566330761c0960d08dc4d6d3a16253b02b9fb85a15b83cbe577dc89f2f00839aac8b83b367948012efb19b9775613e5f34ea1b9388c9dd1b77d80a7fc644b008811b1eed9f138a4c1b3227e56d4bca20631c9fa7f677e9faa7aabbc96fdbef9360b5bfd7e38c9569f8269eb9c0be23b35234d829c26b2c3fcf9f9bd0a808bd4916ceac00077ca7ee24e4739140756188861dc9f83052b93cbe2dc58b1e92a944f8d299ac64ce6374b0c283903fb28d9155ed959f2425dd613fcf44617c45f087438ba059767d33c2d6db82a84c0ee6962ec6c01373d842dd322fd2530ee9b4c14543a88c4cb5fbc7d7c0eaddb47114f51218fc2a4447d353e454b39a7b42af61ce8d3b6db6b013c05bf107e2dfe95704f2c5fd654164d0652ede9283855753ccace3d2db04119868aad96f622554c978a952004c37e6666e6e5cfb89e5f02daaa1981dbc1ffc10af5818f50970a61d9b97dcf561eb7fa6b47029cd70fd85599239518440bf80d68f353af644a993a6c9a22b4a90283ecccd06fcd9cb40287fb82afabee43c002779ac786aa9a7b6c8947d62d503fa5422c8946920c042b6fbb9144af7d30250dd1970144bea0c64e416978365d2f8ca4b9171b07543349a748aada515d06bc34d0630e7d5ec0729bedf2c6547227fa1f4b94bfaba66a0cd26ec3e60573cab342ec0299c3ad27142d28022ed2d282d66d2306f62a576577cebd0d3dfbc41b2865dc4d182e0b97b6b16043cb0bc085c964d784e0789a1168b8e8dd52586b19643c0c58dedbd88a01210da15c78ba7da5f657451fb92840941cb4ef780d4e3a49b7318dd25b4c8bc768e002ec0d7dc44cf405d40830d0b5cd93cee340e1d7dc308e43b4afc5505f835f9c36cc35f0e3cc4e9df00a1268e6251d53ce4aeeb35f6f31f2b9b0d19b6a19dd608c233d9668be7a140c13c79ccd1f6874e6832c0c9040dbde18ef756760c447911ba285b56798ba973a5f94d2a689c507ed1b00cb9703975ab32d55d5cc310672465cff62f2fae251e50d18b0da12baf67dfbb8f720175fdd280ec4322fdb188e37d6c22e24e728e3ed9ca5f62ac31c428cd420ce82c80dc4152a934825b880721360119d3844ff94ff0e4c9030d14fc35d0b48503a04f5e56e5368936b9c63d5232fe650ff0379dfb585da6bff839644820d0182d75efc4ad907fb72bd125443c9ed38bcecc717ffedeb9d337b8aa8b5c3a8578df0591665f57760207c641e2b474419ef7514409436e5a729a9a6498734b4cce1096fd884f40f411fef7d4dc779e3737891e4137f807c6c856768a930dc54e8a8ad2c1d4a571f2fb2b0e7347c7612b86a4ace781ca1b17338e5802aba0e651e90d79f40ab7b3ed04a7a08c5e09eb415c6ddb4e0b13c2279d07a42153d9735a70c18f1f3f69abc7ee97cae0d4f2c37017e97808d2e6260000a4fa7584c5216ce1f6c656e99b784dee14d3cf6c66b61b108efb54d7db32e8b66ac857909200432d43ed2e8bbf547901f9c6fa33c2f46229b17b8cd3d0cfac19cfdc941c08dd62992d3babb61119052b103b1e3c54e581247d7c9653642a0e6ce023a93facf145f7a44982e1d5451ac893b409b845d04a644de98552a64d79d9042c5380c41ecefad0219f991979fba7121dd9456ce2e0a7c970850516c409bbe639029b42a89777879d2d09f8bb0a5b55eb4f2580868b7861e275b47bd80c0c5aef905e806788eba8f521978306da1ab83fbc9c72fde5d581b8af0b584590803d7a95577a41f55e55872bed2cfe82da34e2c36d0d4b14bcf443194719e36bb9c8909c68f5853e0c6abd206b529399060ffbd07dc2162ffa0136e21715c892173f64be634a5df45788f58b8c9e287c0269d358afdf5c4d107dc8e14de60f80c485eb84b2c35cc89f7ba757342558bc0c13ed6692f8fc49ca740b8da9ddc07b6263227a645e7da30bb150c4933b3fb7e4c7a61293d5c6fc6c276ea7f1e6a3b8bdd729fc97cb0bed2212887354f852a97bc46b994712ecbf272db72d50f92ee5ae14091895114012a43bd19adf6b1fb3e2e2ce672aafc88ebb322d106f8c103760cbe61f224a3b5854136acd7d51c79105bfe36ba90a740cbf55a5de65280a3410f9e7b78f694ac2a2e7e3d4a92fc1f6267f3c8936d2b7786e3db702a3479a2a95ee3467bf228b23154cb440380ed2dcb742de965cdb530ee5a122c7db7b314f61b1edb04a59608e9b6ddac6abeb5d549090395f3b666243847f96bc9e659b9faf198cfcc75fb5c52562b9d22ccbc924cfa529d30fb3971baab049a425b13cd4af70b72b8239787c4e07baee1b70d9f05dfd898a3834308e1e3d4573291285929227994bf0f58295b454a6cf5ae05c171e189a560e7d41f600aaf7ce737a5b01860a5c8f18e8f1948b32f09592cd2f4ddd9a4f017c268f74e2d3d798fe582e63879893a87a2b6f290f84a19ac2bb54e9f1840016965e3b16d9825e8c7c96ba0d258047f852ae351889ed567bde31d1785692a0c281628af951791c9a1738d1a6423f292b3863670c0d36d91978d7bed55031986a00fe73b27db750cfa58bace761f49a252e73d89ef5ed1c3dbbda2980f1c06e62c5ccaf606d938f6b5a61dad0460432c99b637b2b6fb2ba00b9cb05ca6dbd0b42104eba3122381108759d09690a214f95e00ee94fc6b827909e144a5c828d68e96fd768d629af2eaad24b7c589a98faa5bfe349c4ec0df7ce82dbdc32a3d0b552b176772b4548ba07f1aa18346c57d09106db541e175e5d2213610750da0ebc4d9c0a0e75fb6bb765d89f83e5831766f915d9bf5fea496b9db572cdedb57592d78f7d24563c5f87badbd47f616cf93912f7f7eaeb03bbd5b661a96d8d1d146e3fc43abcba7fa0daa90c57ae3bf0741bd3036739b7bdcbf73b708a8571b04c2614b67a3dbac28a52d06030c534c47b6f4862c560c2199d478297ff3b036829565434b3698ed43acffe2a41097e873d25d5ea98b2a35a274ee31ba6c2b9f3605cb89f71ccadf683c25811105e69984e476fbd2a7dac4a4d086f98582afc8ae51b274980bc973112dbf997c7e7330f23e924458c651427704f4c9067e1ac57ff9f7cb4cb04ebd3b614f99b75f58557774f5d653aac70a6c310590894e626675a0d3f28f34af4cfaabebeba70ff0a26ba2102aaf04e607e6d1146e9419b5bf849376ce9b5f5bfb178f7cf6d7f4db126e3f2c050b0ced1273b99476ec53ac841d5c16ba2d61dae3555492eb32a46c5a2d4530464a37bf314561ff00ab83c5678df5098d571184bb47f60386e52101288e645f94040352150570d57fe154c356f0446d3bf06e08cc422b3151e4960a7f3a40018f5b5be49270b6bac1fde52f0c229b17b66f326b94438f24607f739d8a13c5dc8ec92ec54f0eb8fe1a34f9d4b362dde924c587b444fb659ea4fa546dfaa6112d703a06aa4d3b745790d5ca2a8db7906f4036241803a404edc62453cd188b5c53ea021d647267ca82f2cd3cd6abe4444e96d1848e11df2ea63551514cfb04092cf42a20b6d8b7c0d10c7555967bcdcf4e44ba5a30ab3f540442813600a063210f4b7bd3763bb14197bfa4975248e4d0c7a98e044255b3ddf6363d03e9d883c1d652870a299af107091644b90f7b0991d88494343eb7bb0f9b934d03b9d7f55879d64bd825fb87cd82c80f6ac024cdd9e85937186da9539f22ee2522842cbccb80dfaa6001362eef2ad9b077f7d2cc5b1fb3b59e9213f2e7ae8d0b170d7*294117::::APFS-openwall123.dmg", "openwall123"},
#endif
	{NULL}
};
