/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.NumberUtils;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.CompressionMethod;

public class TooSoonMethod
extends CompressionMethod {
    private final int _secondsLimit;

    public TooSoonMethod(int n) {
        this._secondsLimit = n;
    }

    public TooSoonMethod(String string) {
        this._secondsLimit = TooSoonMethod.recogniseString(string) ? NumberUtils.getIntOrZero(string.substring(4)) : 0;
    }

    @Override
    public CompressionMethodType getType() {
        return CompressionMethodType.TIME_DIFFERENCE;
    }

    @Override
    public String getParam() {
        return "" + Math.abs(this._secondsLimit);
    }

    @Override
    public int compress(Track track, TrackDetails trackDetails, MarkingData markingData) {
        int n = track.getNumPoints();
        DataPoint dataPoint = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint2;
            if (!markingData.isPointMarkedForDeletion(n3) && !(dataPoint2 = track.getPoint(n3)).isWaypoint() && dataPoint2.hasTimestamp()) {
                long l;
                if (!(dataPoint2.hasMedia() || trackDetails.isSegmentStart(n3) || trackDetails.isSegmentEnd(n3) || dataPoint == null || (l = dataPoint2.getTimestamp().getSecondsSince(dataPoint.getTimestamp())) < 0L || l >= (long)this._secondsLimit)) {
                    markingData.markPointForDeletion(n3);
                    ++n2;
                }
                if (!markingData.isPointMarkedForDeletion(n3)) {
                    dataPoint = dataPoint2;
                }
            }
            ++n3;
        }
        return n2;
    }

    @Override
    public String getSettingsString() {
        return String.valueOf(this.getType().getKey()) + this._secondsLimit;
    }

    static boolean recogniseString(String string) {
        return TooSoonMethod.recogniseString(string, CompressionMethodType.TIME_DIFFERENCE);
    }
}

