/*
    This file is part of Element
    Copyright (c) 2019 Kushview, LLC.  All rights reserved.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

#pragma once

// !!!! DO NOT INCLUDE THIS IN OTHER HEADERS !!!! //

#include "ElementApp.h"

#include "controllers/AppController.h"
#include "controllers/DevicesController.h"
#include "controllers/EngineController.h"
#include "controllers/GuiController.h"
#include "controllers/GraphController.h"
#include "controllers/MappingController.h"
#include "controllers/SessionController.h"
#include "controllers/PresetsController.h"
#include "controllers/ScriptingController.h"
#include "controllers/WorkspacesController.h"

#include "engine/nodes/NodeTypes.h"

#include "session/Node.h"
#include "session/Session.h"

#include "Commands.h"
#include "Messages.h"
#include "Globals.h"
#include "Settings.h"
#include "Utils.h"
#include "Version.h"
