/*
 * NMEAConverter.java
 *
 * Created on 28. Juni 2008, 14:08
 */
package de.k621.avr.gps.converter;

import gps.BT747Constants;
import gps.connection.GPSrxtx;
import gps.log.LogFileInfo;

import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;

import javax.swing.JFileChooser;
import javax.swing.UIManager;

import bt747.j2se_view.GPSKMZFile;
import bt747.j2se_view.J2SEController;
import bt747.model.AppSettings;
import bt747.model.Model;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747FileName;
import bt747.sys.interfaces.BT747Path;

/**
 * <h1>NMEA Toolbox</h1>
 * 
 * <p>
 * Die NMEA Toolbox ermglicht es, Datenstze im NMEA Format mit wenigen Klicks
 * in ein handlicheres Format umzuwandeln. Dabei werden automatisch ungltige
 * Koordinaten ausgefiltert.
 * </p>
 * 
 * <h2>Lizenz</h2>
 * 
 * <p>
 * Dieses Werk ist unter einem Creative Commons Namensnennung-Keine kommerzielle
 * Nutzung-Weitergabe unter gleichen Bedingungen 3.0 Deutschland Lizenzvertrag
 * lizenziert. Um die Lizenz anzusehen, gehen Sie bitte zu
 * http://creativecommons.org/licenses/by-nc-sa/3.0/de/ oder schicken Sie einen
 * Brief an Creative Commons, 171 Second Street, Suite 300, San Francisco,
 * California 94105, USA.
 * </p>
 * 
 * <a href="http://creativecommons.org/licenses/by-nc-sa/3.0/de/">Creative
 * Commons by-nc-sa</a>, Namensnennung-Keine kommerzielle Nutzung-Weitergabe
 * unter gleichen Bedingungen
 * 
 * <h2>Changelog:</h2>
 * 
 * <h3>Version 1.3 (18.04.2010)</h3>
 * 
 * <ul>
 * <li>Verwendung von "Preferences" zum Sichern des zuletzt verwendeten Ordners
 * (Implementiert von <a href="http://www.esuark.de">Jens Krause</a>, vielen
 * Dank!)</li>
 * </ul>
 * 
 * <h3>Version 1.2 (21.03.2009)</h3>
 * 
 * <ul>
 * <li>Javadoc angelegt</li>
 * <li>Kompletten Code umstrukturiert</li>
 * <ul>
 * <li>Konvertierer in eigene Klassen gepackt</li>
 * <li>Konvertierer laufen nun als Threads</li>
 * <li>Insgesamt Code etwas aufgerumt</li>
 * </ul>
 * <li>Interface 'erfrischt'</li>
 * <ul>
 * <li>Konvertier-Buttons durch Grafiken ersetzt (Text wird als Tooltip
 * angezeigt)</li>
 * <li>Statusanzeige eingebaut</li>
 * </ul>
 * <li>Weitere kleine bersetzungen auf Deutsch</li> <li>Im description-Tag der
 * KML-Datei wird nun das Erstellungsdatum angezeigt</li> <li>Einige Filter
 * entfernt (werden nun autom. ausgefhrt)</li> <li>Google Maps Frage erscheint
 * nur noch, wenn man eine KML Datei erstellen mchte und der Pfad mehr als 350
 * Punkte besitzt</li> <li>Google Maps - Reduzieralgorithmus optimiert</li> <li>
 * GPX Format implementiert</li> </ul>
 * 
 * <h3>Version 1.1 (03.01.2009)</h3>
 * 
 * <ul>
 * <li>Meldungen in Dialogfenstern auf Deutsch bersetzt</li>
 * <li>Fehler bei Google-Maps-Filter behoben</li>
 * </ul>
 * 
 * <h3>Version 1.0d (25.09.2008)</h3>
 * 
 * <ul>
 * <li>NMEA Toolbox auf Deutsch bersetzt</li>
 * </ul>
 * 
 * <h3>Version 1.00 (12.07.2008)</h3>
 * 
 * <ul>
 * <li>Erstes ffentliches Release</li>
 * </ul>
 * 
 * @author Martin Matysiak
 */
@SuppressWarnings("serial")
public class NMEAConverter extends javax.swing.JFrame implements
		KProgressViewer {

	/**
	 * Set up system specific classes.
	 */
	static {
		// Set up the low level functions interface.
		JavaLibBridge
				.setJavaLibImplementation(net.sf.bt747.j2se.system.J2SEJavaTranslations
						.getInstance());
		// Set the serial port class instance to use (also system specific).
		// if (!GPSrxtx.hasDefaultPortInstance()) {
		// GPSrxtx.setDefaultGpsPortInstance(new gps.connection.GPSRxTxPort());
		// }
		GPSrxtx.setDefaultGpsPortInstance(null);
	}

	private static final String NOFILE = "NO\\FILE";
	private static final int GPX = 1;
	private static final int KML = 2;
	private static final int ELEV = 3;
	private static final int SPD = 4;

	private static final Preferences PREFS = Preferences
			.userNodeForPackage(NMEAConverter.class);;

	/** Erstellt die Oberflche */
	public NMEAConverter() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}

		initComponents();

		this.setBounds(50, 50, this.getWidth(), this.getHeight());
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
	// desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		txtInput = new javax.swing.JTextField();
		lblTitle = new javax.swing.JLabel();
		lblInput = new javax.swing.JLabel();
		btnBrowseInput = new javax.swing.JButton();
		btnKML = new javax.swing.JButton();
		btnElevationTable = new javax.swing.JButton();
		btnSpeed = new javax.swing.JButton();
		chkSat = new javax.swing.JCheckBox();
		lblSats = new javax.swing.JLabel();
		comSats = new javax.swing.JComboBox();
		chkHdop = new javax.swing.JCheckBox();
		comHdop = new javax.swing.JComboBox();
		lblInfo2 = new javax.swing.JLabel();
		jSeparator1 = new javax.swing.JSeparator();
		jSeparator2 = new javax.swing.JSeparator();
		lblHomepage = new javax.swing.JLabel();
		lblAuthor = new javax.swing.JLabel();
		barProgress = new javax.swing.JProgressBar();
		btnGPX = new javax.swing.JButton();
		jSeparator3 = new javax.swing.JSeparator();
		jSeparator4 = new javax.swing.JSeparator();
		lblProgress = new javax.swing.JLabel();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setTitle("NMEA Toolbox");
		setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
		setResizable(false);

		txtInput.setEditable(false);
		txtInput.setText("Bitte whlen Sie eine Datei aus...");

		lblTitle.setFont(new java.awt.Font("Verdana", 0, 36)); // NOI18N
		lblTitle.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		lblTitle.setText("NMEA Toolbox V1.3");

		lblInput.setLabelFor(txtInput);
		lblInput.setText("Bitte Eingangs-Datei auswhlen :");

		btnBrowseInput.setText("Durchsuchen...");
		btnBrowseInput.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnBrowseInputActionPerformed(evt);
			}
		});

		btnKML.setIcon(new javax.swing.ImageIcon(getClass().getResource(
				"/de/k621/avr/gps/converter/icons/kml.png"))); // NOI18N
		btnKML.setToolTipText("KML Datei erstellen (fr Google Earth/Maps)");
		btnKML.setPreferredSize(new java.awt.Dimension(90, 90));
		btnKML.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnKMLActionPerformed(evt);
			}
		});

		btnElevationTable.setIcon(new javax.swing.ImageIcon(getClass()
				.getResource("/de/k621/avr/gps/converter/icons/elev.png"))); // NOI18N
		btnElevationTable.setToolTipText("Hhendiagramm erstellen");
		btnElevationTable
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						btnElevationTableActionPerformed(evt);
					}
				});

		btnSpeed.setIcon(new javax.swing.ImageIcon(getClass().getResource(
				"/de/k621/avr/gps/converter/icons/spd.png"))); // NOI18N
		btnSpeed.setToolTipText("Geschwindigkeitsdiagramm erstellen");
		btnSpeed.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnSpeedActionPerformed(evt);
			}
		});

		chkSat.setText("Nur Punkte mit mindestens");

		lblSats.setLabelFor(chkSat);
		lblSats.setText("Satteliten nehmen");

		comSats
				.setModel(new javax.swing.DefaultComboBoxModel(new String[] {
						"1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
						"11", "12" }));

		chkHdop.setText("Nur Punkte mit geringerem HDOP als");

		comHdop.setModel(new javax.swing.DefaultComboBoxModel(new String[] {
				"1.0 (Bestes)", "3.5", "6", "8.5", "11 (Schlechtestes)" }));
		comHdop.setSelectedItem(comHdop.getModel().getElementAt(3));

		lblInfo2.setText("Filter :");

		lblHomepage.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
		lblHomepage.setText("k621.de");

		lblAuthor.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
		lblAuthor.setText("Martin Matysiak");

		btnGPX.setIcon(new javax.swing.ImageIcon(getClass().getResource(
				"/de/k621/avr/gps/converter/icons/gpx.png"))); // NOI18N
		btnGPX.setToolTipText("GPX Datei erstellen");
		btnGPX.setMaximumSize(new java.awt.Dimension(100, 89));
		btnGPX.setMinimumSize(new java.awt.Dimension(100, 89));
		btnGPX.setName("btnGPX"); // NOI18N
		btnGPX.setPreferredSize(new java.awt.Dimension(90, 90));
		btnGPX.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnGPXActionPerformed(evt);
			}
		});

		lblProgress.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		lblProgress.setText("Programm initalisiert");

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(
				getContentPane());
		getContentPane().setLayout(layout);
		layout
				.setHorizontalGroup(layout
						.createParallelGroup(
								javax.swing.GroupLayout.Alignment.LEADING)
						.addGroup(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.addGroup(
												layout
														.createParallelGroup(
																javax.swing.GroupLayout.Alignment.LEADING)
														.addGroup(
																layout
																		.createSequentialGroup()
																		.addGroup(
																				layout
																						.createParallelGroup(
																								javax.swing.GroupLayout.Alignment.LEADING)
																						.addGroup(
																								layout
																										.createSequentialGroup()
																										.addComponent(
																												chkSat)
																										.addPreferredGap(
																												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																										.addComponent(
																												comSats,
																												javax.swing.GroupLayout.PREFERRED_SIZE,
																												javax.swing.GroupLayout.DEFAULT_SIZE,
																												javax.swing.GroupLayout.PREFERRED_SIZE)
																										.addPreferredGap(
																												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																										.addComponent(
																												lblSats))
																						.addGroup(
																								layout
																										.createSequentialGroup()
																										.addComponent(
																												chkHdop)
																										.addPreferredGap(
																												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																										.addComponent(
																												comHdop,
																												javax.swing.GroupLayout.PREFERRED_SIZE,
																												90,
																												javax.swing.GroupLayout.PREFERRED_SIZE))
																						.addComponent(
																								lblInfo2)
																						.addComponent(
																								lblTitle,
																								javax.swing.GroupLayout.DEFAULT_SIZE,
																								434,
																								Short.MAX_VALUE)
																						.addGroup(
																								javax.swing.GroupLayout.Alignment.TRAILING,
																								layout
																										.createSequentialGroup()
																										.addComponent(
																												lblAuthor)
																										.addPreferredGap(
																												javax.swing.LayoutStyle.ComponentPlacement.RELATED,
																												270,
																												Short.MAX_VALUE)
																										.addComponent(
																												lblHomepage))
																						.addComponent(
																								jSeparator1,
																								javax.swing.GroupLayout.Alignment.TRAILING,
																								javax.swing.GroupLayout.DEFAULT_SIZE,
																								434,
																								Short.MAX_VALUE)
																						.addGroup(
																								layout
																										.createSequentialGroup()
																										.addGroup(
																												layout
																														.createParallelGroup(
																																javax.swing.GroupLayout.Alignment.LEADING)
																														.addComponent(
																																lblInput)
																														.addComponent(
																																txtInput,
																																javax.swing.GroupLayout.DEFAULT_SIZE,
																																321,
																																Short.MAX_VALUE))
																										.addPreferredGap(
																												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																										.addComponent(
																												btnBrowseInput))
																						.addComponent(
																								jSeparator2,
																								javax.swing.GroupLayout.DEFAULT_SIZE,
																								434,
																								Short.MAX_VALUE))
																		.addContainerGap())
														.addGroup(
																layout
																		.createSequentialGroup()
																		.addGroup(
																				layout
																						.createParallelGroup(
																								javax.swing.GroupLayout.Alignment.LEADING)
																						.addGroup(
																								layout
																										.createSequentialGroup()
																										.addGap(
																												10,
																												10,
																												10)
																										.addComponent(
																												btnGPX,
																												javax.swing.GroupLayout.PREFERRED_SIZE,
																												javax.swing.GroupLayout.DEFAULT_SIZE,
																												javax.swing.GroupLayout.PREFERRED_SIZE)
																										.addGap(
																												18,
																												18,
																												18)
																										.addComponent(
																												btnKML,
																												javax.swing.GroupLayout.PREFERRED_SIZE,
																												javax.swing.GroupLayout.DEFAULT_SIZE,
																												javax.swing.GroupLayout.PREFERRED_SIZE)
																										.addGap(
																												18,
																												18,
																												18)
																										.addComponent(
																												btnElevationTable,
																												javax.swing.GroupLayout.PREFERRED_SIZE,
																												90,
																												Short.MAX_VALUE)
																										.addGap(
																												18,
																												18,
																												18)
																										.addComponent(
																												btnSpeed,
																												javax.swing.GroupLayout.PREFERRED_SIZE,
																												90,
																												Short.MAX_VALUE)
																										.addGap(
																												10,
																												10,
																												10))
																						.addComponent(
																								jSeparator4,
																								javax.swing.GroupLayout.Alignment.TRAILING,
																								javax.swing.GroupLayout.DEFAULT_SIZE,
																								434,
																								Short.MAX_VALUE))
																		.addContainerGap())
														.addGroup(
																javax.swing.GroupLayout.Alignment.TRAILING,
																layout
																		.createSequentialGroup()
																		.addComponent(
																				jSeparator3,
																				javax.swing.GroupLayout.DEFAULT_SIZE,
																				434,
																				Short.MAX_VALUE)
																		.addGap(
																				10,
																				10,
																				10))
														.addGroup(
																layout
																		.createSequentialGroup()
																		.addGroup(
																				layout
																						.createParallelGroup(
																								javax.swing.GroupLayout.Alignment.TRAILING)
																						.addComponent(
																								barProgress,
																								javax.swing.GroupLayout.Alignment.LEADING,
																								javax.swing.GroupLayout.DEFAULT_SIZE,
																								434,
																								Short.MAX_VALUE)
																						.addComponent(
																								lblProgress,
																								javax.swing.GroupLayout.Alignment.LEADING,
																								javax.swing.GroupLayout.DEFAULT_SIZE,
																								434,
																								Short.MAX_VALUE))
																		.addContainerGap()))));
		layout
				.setVerticalGroup(layout
						.createParallelGroup(
								javax.swing.GroupLayout.Alignment.LEADING)
						.addGroup(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.addComponent(lblTitle)
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addGroup(
												layout
														.createParallelGroup(
																javax.swing.GroupLayout.Alignment.BASELINE)
														.addComponent(
																lblHomepage)
														.addComponent(lblAuthor))
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(
												jSeparator2,
												javax.swing.GroupLayout.PREFERRED_SIZE,
												10,
												javax.swing.GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(lblInput)
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addGroup(
												layout
														.createParallelGroup(
																javax.swing.GroupLayout.Alignment.BASELINE)
														.addComponent(
																btnBrowseInput)
														.addComponent(
																txtInput,
																javax.swing.GroupLayout.PREFERRED_SIZE,
																javax.swing.GroupLayout.DEFAULT_SIZE,
																javax.swing.GroupLayout.PREFERRED_SIZE))
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(
												jSeparator1,
												javax.swing.GroupLayout.PREFERRED_SIZE,
												10,
												javax.swing.GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(lblInfo2)
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addGroup(
												layout
														.createParallelGroup(
																javax.swing.GroupLayout.Alignment.BASELINE)
														.addComponent(chkSat)
														.addComponent(
																comSats,
																javax.swing.GroupLayout.PREFERRED_SIZE,
																javax.swing.GroupLayout.DEFAULT_SIZE,
																javax.swing.GroupLayout.PREFERRED_SIZE)
														.addComponent(lblSats))
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addGroup(
												layout
														.createParallelGroup(
																javax.swing.GroupLayout.Alignment.BASELINE)
														.addComponent(
																comHdop,
																javax.swing.GroupLayout.PREFERRED_SIZE,
																javax.swing.GroupLayout.DEFAULT_SIZE,
																javax.swing.GroupLayout.PREFERRED_SIZE)
														.addComponent(chkHdop))
										.addGap(18, 18, 18)
										.addComponent(
												jSeparator4,
												javax.swing.GroupLayout.PREFERRED_SIZE,
												10,
												javax.swing.GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addGroup(
												layout
														.createParallelGroup(
																javax.swing.GroupLayout.Alignment.TRAILING)
														.addComponent(
																btnGPX,
																javax.swing.GroupLayout.PREFERRED_SIZE,
																javax.swing.GroupLayout.DEFAULT_SIZE,
																javax.swing.GroupLayout.PREFERRED_SIZE)
														.addComponent(
																btnKML,
																javax.swing.GroupLayout.PREFERRED_SIZE,
																javax.swing.GroupLayout.DEFAULT_SIZE,
																javax.swing.GroupLayout.PREFERRED_SIZE)
														.addComponent(
																btnElevationTable)
														.addComponent(btnSpeed))
										.addGap(18, 18, 18)
										.addComponent(
												jSeparator3,
												javax.swing.GroupLayout.PREFERRED_SIZE,
												12,
												javax.swing.GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED,
												javax.swing.GroupLayout.DEFAULT_SIZE,
												Short.MAX_VALUE)
										.addComponent(lblProgress)
										.addPreferredGap(
												javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(
												barProgress,
												javax.swing.GroupLayout.PREFERRED_SIZE,
												36,
												javax.swing.GroupLayout.PREFERRED_SIZE)
										.addContainerGap()));

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void btnKMLActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_btnKMLActionPerformed
		convert(KML, "kml");
	}// GEN-LAST:event_btnKMLActionPerformed

	private void btnBrowseInputActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_btnBrowseInputActionPerformed
		JFileChooser fileChooser = new JFileChooser(PREFS
				.get("input.dir", null));

		if (fileChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
			txtInput.setText(fileChooser.getSelectedFile().getAbsolutePath());
			PREFS.put("input.dir", fileChooser.getSelectedFile().getParent());
		}

	}// GEN-LAST:event_btnBrowseInputActionPerformed

	private void btnElevationTableActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_btnElevationTableActionPerformed
		convert(ELEV, "csv");
	}// GEN-LAST:event_btnElevationTableActionPerformed

	private void btnSpeedActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_btnSpeedActionPerformed
		convert(SPD, "csv");
	}// GEN-LAST:event_btnSpeedActionPerformed

	private void btnGPXActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_btnGPXActionPerformed
		convert(GPX, "gpx");
	}// GEN-LAST:event_btnGPXActionPerformed

	/**
	 * Die Startmethode der Anwendung
	 * 
	 * @param args
	 *            Kommandozeilenparameter (werden nicht beachtet)
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {

			public void run() {
				new NMEAConverter().setVisible(true);
			}
		});
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JProgressBar barProgress;
	private javax.swing.JButton btnBrowseInput;
	private javax.swing.JButton btnElevationTable;
	private javax.swing.JButton btnGPX;
	private javax.swing.JButton btnKML;
	private javax.swing.JButton btnSpeed;
	private javax.swing.JCheckBox chkHdop;
	private javax.swing.JCheckBox chkSat;
	private javax.swing.JComboBox comHdop;
	private javax.swing.JComboBox comSats;
	private javax.swing.JSeparator jSeparator1;
	private javax.swing.JSeparator jSeparator2;
	private javax.swing.JSeparator jSeparator3;
	private javax.swing.JSeparator jSeparator4;
	private javax.swing.JLabel lblAuthor;
	private javax.swing.JLabel lblHomepage;
	private javax.swing.JLabel lblInfo2;
	private javax.swing.JLabel lblInput;
	private javax.swing.JLabel lblProgress;
	private javax.swing.JLabel lblSats;
	private javax.swing.JLabel lblTitle;
	private javax.swing.JTextField txtInput;

	// End of variables declaration//GEN-END:variables

	Model m = new Model();
	J2SEController c = new J2SEController(m);
	
	public final int convertLog(final int logType) {
		int error = 0;
		System.out.println("Input file: " + m.getStringOpt(Model.LOGFILEPATH));
		if (Model.logFiles.size() != 0) {
			for (int i = 0; i < Model.logFiles.size(); i++) {
				LogFileInfo lfi = (LogFileInfo) Model.logFiles.elementAt(i);
				System.out.println("Input file: " + lfi.getBT747Path().getPath());
			}
		}

		System.out.println("Output directory: "
				+ m.getStringOpt(Model.OUTPUTDIRPATH));
		System.out.println("Output basename: "
				+ m.getStringOpt(Model.REPORTFILEBASE));

		if (Model.logFiles.size() != 0) {
			c.setStringOpt(Model.LOGFILEPATH, "");
		}

		if (logType == Model.KMZ_LOGTYPE) {
			error = c.doConvertLog(logType, new GPSKMZFile(), ".kmz");
		} else {
			error = c.doConvertLog(logType);
		}

		return error;
	}
	
	private void reportError(final int error, final String errorInfo) {


		System.err.println("\n####    PROBLEM  !!! ####");
		String msg = "";
		switch (error) {
		case BT747Constants.ERROR_COULD_NOT_OPEN:
			msg = "ERROR - Could not open ";
			break;
		case BT747Constants.ERROR_NO_FILES_WERE_CREATED:
			msg = "WARNING - No files were created - Check the input type.";
			break;
		case BT747Constants.ERROR_READING_FILE:
			msg = "ERROR - Problem reading" + errorInfo;
			break;
		default:
			break;
		}
		
		javax.swing.JOptionPane.showMessageDialog(null, msg, "Fehler",
				javax.swing.JOptionPane.ERROR_MESSAGE);	}



	private void convert(int pFormat, String pFiletype) {

		try {
			// Eingabe- und Ausgabedatei ffnen
			if (!(new File(txtInput.getText()).exists())) {
				throw new IOException(
						"Bitte whlen Sie eine existierende Eingabedatei aus!");
			}

			JFileChooser fileChooser = new JFileChooser(PREFS.get("output.dir",
					PREFS.get("input.dir", null)));
			String outFile = NOFILE;

			fileChooser.setAcceptAllFileFilterUsed(false);
			fileChooser.setFileFilter(new FileTypeFilter(pFiletype));

			if (fileChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
				outFile = (fileChooser.getSelectedFile().getAbsolutePath());
				PREFS.put("output.dir", fileChooser.getSelectedFile()
						.getParent());
			} else {
				throw new IOException("Es wurde keine Ausgabedatei ausgewhlt");
			}

			if (!outFile.endsWith("." + pFiletype)) {
				outFile += "." + pFiletype;
			}

			if (new File(outFile).exists()) {
				throw new IOException(
						"Bitte whlen Sie eine nicht existente Datei zur Ausgabe aus!");
			}

			// BufferedReader input = new BufferedReader(new FileReader(new
			// File(txtInput.getText())));
			// BufferedWriter output = new BufferedWriter(new FileWriter(new
			// File(outFile)));

			int minSat = chkSat.isEnabled() ? comSats.getSelectedIndex() + 1
					: 0;
			float maxHDOP = chkHdop.isEnabled() ? 1 + comHdop
					.getSelectedIndex() * 2.5F : Float.POSITIVE_INFINITY;

			{
				m.init();
				c
						.setIntOpt(
								AppSettings.TRKPT_VALID,
								(0xFFFFFFFF ^ (BT747Constants.VALID_NO_FIX_MASK | BT747Constants.VALID_ESTIMATED_MASK)));
				c
						.setIntOpt(
								AppSettings.WAYPT_VALID,
								(0xFFFFFFFF ^ (BT747Constants.VALID_NO_FIX_MASK | BT747Constants.VALID_ESTIMATED_MASK)));
				c.setIntOpt(AppSettings.WAYPT_RCR, 0);
				c.setIntOpt(AppSettings.TRKPT_RCR, 0xFFFFFFFF);
				
		        c.setBooleanOpt(Model.ADVFILTACTIVE, true);
		        c.setFloatOpt(Model.MAX_HDOP,maxHDOP);
		        c.setIntOpt(Model.MIN_NSAT,minSat);

				c.setStringOpt(Model.LOGFILEPATH, txtInput.getText());
				int logType = -1; // None
				switch (pFormat) {
				case GPX:
					logType = Model.GPX_LOGTYPE;
					break;
				case KML:
					logType = Model.KML_LOGTYPE;
					break;
				case ELEV:
					logType = Model.CSV_LOGTYPE;
					break;
				case SPD:
					logType = Model.CSV_LOGTYPE;
					break;
				}
				// The output filename does not depend on the time.
				
				final String oFileName = outFile;
				c.setFileNameBuilder(new BT747FileName() {
					public BT747Path getOutputFileName(
							final BT747Path baseName, final int utcTimeSeconds,
							final String proposedExtension,
							final String proposedTimeSpec) {
						
						return new BT747Path(oFileName);
//						BT747Time t = JavaLibBridge.getTimeInstance();
//						t.setUTCTime(utcTimeSeconds);
//						String base = Conv.expandDate(baseName.getPath(), t);
//						boolean addTimeSpec;
//						addTimeSpec = (baseName.getPath().indexOf('%') < 0);
//						switch (m.getIntOpt(AppSettings.OUTPUTFILESPLITTYPE)) {
//						case 0:
//							addTimeSpec &= false;
//						default:
//							addTimeSpec &= true;
//						}
//
//						if (!addTimeSpec) {
//							return new BT747Path(base + "_trk"
//									+ proposedExtension);
//						} else {
//							return new BT747Path(base + proposedTimeSpec
//									+ "_trk" + proposedExtension);
//						}
					}
				});

				final int error = convertLog(logType);
				if (error != 0) {
					reportError(c.getLastError(), c.getLastErrorInfo());
				}

			}

			// switch (pFormat) {
			// case GPX:
			// new KGPXConverter(input, output, this, minSat, maxHDOP);
			// break;
			// case KML:
			// new KKMLConverter(input, output, this, minSat, maxHDOP);
			// break;
			// case ELEV:
			// new KElevationConverter(input, output, this, minSat, maxHDOP);
			// break;
			// case SPD:
			// new KSpeedConverter(input, output, this);
			// break;
			// }

		} catch (IOException ioex) {
			javax.swing.JOptionPane.showMessageDialog(null, ioex
					.getLocalizedMessage(), "Fehler",
					javax.swing.JOptionPane.ERROR_MESSAGE);
		}
	}

	public void updateText(String pText) {
		lblProgress.setText(pText);
	}

	public void updateBar(int pValue) {
		if (pValue == -1) {
			barProgress.setValue(barProgress.getMaximum());
		} else {
			barProgress.setValue(pValue);
		}
	}

	public void incrementBar() {
		barProgress.setValue(barProgress.getValue() + 1);
	}

	public void setBarMax(int pValue) {
		barProgress.setMaximum(pValue);
	}
}


/**
 * Dient als Filter fr Dateitypen
 * 
 * @author Martin Matysiak
 */
class FileTypeFilter extends javax.swing.filechooser.FileFilter {

	private String type = "";

	public FileTypeFilter(String type) {
		this.type = type;
	}

	public boolean accept(File pathname) {
		if (pathname.isDirectory()) {
			return true;
		}

		if (pathname.getName().toLowerCase().endsWith(type.toLowerCase())) {
			return true;
		} else {
			return false;
		}
	}

	public String getDescription() {
		return (type.toUpperCase() + " Dateien (*." + type + ")");
	}
}
