#!/bin/bash

MAJOR_VERSION=`bash ./bashrun --major-version`
MINOR_VERSION=`bash ./bashrun --minor-version`
BUGFIX_VERSION=`bash ./bashrun --bugfix-version`
VERSION="$MAJOR_VERSION.$MINOR_VERSION.$BUGFIX_VERSION"

PREFIX=/usr/local
if [[ "$1" =~ ^--prefix=.+ ]]; then
    PREFIX=$(echo $1 | cut -d = -f 2)
    PREFIX=${PREFIX:-/usr/local}
fi

if [ ! -f $PREFIX/bin/bashrun ]; then

    echo "Bashrun does not seem to be installed in $PREFIX. If you have
previously installed bashrun under a prefix other than $PREFIX,
please use the --prefix option to specify it.
"
    exit 1
fi

rm -v $PREFIX/bin/bashrun
rmdir -v $PREFIX/bin

rm -v $PREFIX/share/bashrun/bashrc
rmdir -v $PREFIX/share/bashrun

rm -v $PREFIX/share/man/man1/bashrun.1
rmdir -v $PREFIX/share/man/man1

echo
echo "bashrun $VERSION has been uninstalled from $PREFIX"
